/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-02-18 22:11:37 UTC)
 * on 2016-03-02 at 19:27:50 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.clouduseraccounts.model;

/**
 * A list of all Linux accounts for this project. This API is only used by Compute Engine virtual
 * machines to get information about user accounts for a project or instance. Linux resources are
 * read-only views into users and groups managed by the Compute Engine Accounts API.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud User Accounts API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LinuxAccountViews extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] A list of all groups within a project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LinuxGroupView> groupViews;

  /**
   * [Output Only] Type of the resource. Always clouduseraccounts#linuxAccountViews for Linux
   * resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] A list of all users within a project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LinuxUserView> userViews;

  /**
   * [Output Only] A list of all groups within a project.
   * @return value or {@code null} for none
   */
  public java.util.List<LinuxGroupView> getGroupViews() {
    return groupViews;
  }

  /**
   * [Output Only] A list of all groups within a project.
   * @param groupViews groupViews or {@code null} for none
   */
  public LinuxAccountViews setGroupViews(java.util.List<LinuxGroupView> groupViews) {
    this.groupViews = groupViews;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always clouduseraccounts#linuxAccountViews for Linux
   * resources.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always clouduseraccounts#linuxAccountViews for Linux
   * resources.
   * @param kind kind or {@code null} for none
   */
  public LinuxAccountViews setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] A list of all users within a project.
   * @return value or {@code null} for none
   */
  public java.util.List<LinuxUserView> getUserViews() {
    return userViews;
  }

  /**
   * [Output Only] A list of all users within a project.
   * @param userViews userViews or {@code null} for none
   */
  public LinuxAccountViews setUserViews(java.util.List<LinuxUserView> userViews) {
    this.userViews = userViews;
    return this;
  }

  @Override
  public LinuxAccountViews set(String fieldName, Object value) {
    return (LinuxAccountViews) super.set(fieldName, value);
  }

  @Override
  public LinuxAccountViews clone() {
    return (LinuxAccountViews) super.clone();
  }

}
