/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-03-25 20:06:55 UTC)
 * on 2016-04-06 at 17:34:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudbuild.v1.model;

/**
 * BuildStep describes a step to perform in the build pipeline.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Container Builder API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BuildStep extends com.google.api.client.json.GenericJson {

  /**
   * Command-line arguments to use when running this step's container.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> args;

  /**
   * Working directory (relative to project source root) to use when running this operation's
   * container.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dir;

  /**
   * Additional environment variables to set for this step's container.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> env;

  /**
   * Name of the container image to use for creating this stage in the pipeline, as presented to
   * `docker pull`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Command-line arguments to use when running this step's container.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getArgs() {
    return args;
  }

  /**
   * Command-line arguments to use when running this step's container.
   * @param args args or {@code null} for none
   */
  public BuildStep setArgs(java.util.List<java.lang.String> args) {
    this.args = args;
    return this;
  }

  /**
   * Working directory (relative to project source root) to use when running this operation's
   * container.
   * @return value or {@code null} for none
   */
  public java.lang.String getDir() {
    return dir;
  }

  /**
   * Working directory (relative to project source root) to use when running this operation's
   * container.
   * @param dir dir or {@code null} for none
   */
  public BuildStep setDir(java.lang.String dir) {
    this.dir = dir;
    return this;
  }

  /**
   * Additional environment variables to set for this step's container.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getEnv() {
    return env;
  }

  /**
   * Additional environment variables to set for this step's container.
   * @param env env or {@code null} for none
   */
  public BuildStep setEnv(java.util.List<java.lang.String> env) {
    this.env = env;
    return this;
  }

  /**
   * Name of the container image to use for creating this stage in the pipeline, as presented to
   * `docker pull`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the container image to use for creating this stage in the pipeline, as presented to
   * `docker pull`.
   * @param name name or {@code null} for none
   */
  public BuildStep setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public BuildStep set(String fieldName, Object value) {
    return (BuildStep) super.set(fieldName, value);
  }

  @Override
  public BuildStep clone() {
    return (BuildStep) super.clone();
  }

}
