/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-03-25 20:06:55 UTC)
 * on 2016-04-06 at 17:34:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudbuild.v1.model;

/**
 * A build resource in the Container Builder API.
 *
 * At a high level, a Build describes where to find source code, how to build it (for example, the
 * builder image to run on the source), and what tag to apply to the built image when it is pushed
 * to Google Container Registry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Container Builder API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Build extends com.google.api.client.json.GenericJson {

  /**
   * Time at which the build was created. @OutputOnly
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Time at whihc execution of the build was finished. @OutputOnly
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String finishTime;

  /**
   * Unique identifier of the build. @OutputOnly
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * List of images expected to be built and pushed to Google Container Registry. If an image is
   * listed here and the image is not produced by one of the build steps, the build will fail. Any
   * images present when the build steps are complete will be pushed to Container Registry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> images;

  /**
   * Google Cloud Storage bucket where logs should be written (see [Bucket Name
   * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Logs file
   * names will be of the format `${logs_bucket}/log-${build_id}.txt`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String logsBucket;

  /**
   * ID of the project. @OutputOnly.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Results of the build. @OutputOnly
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Results results;

  /**
   * Describes where to find the source files to build.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Source source;

  /**
   * Time at which execution of the build was started. @OutputOnly
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * Status of the build. @OutputOnly
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Describes the operations to be performed on the workspace.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BuildStep> steps;

  /**
   * Amount of time that this build should be allowed to run, to second granularity. If this amount
   * of time elapses, work on the build will cease and the build status will be TIMEOUT.
   *
   * Default time is ten minutes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String timeout;

  /**
   * Time at which the build was created. @OutputOnly
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Time at which the build was created. @OutputOnly
   * @param createTime createTime or {@code null} for none
   */
  public Build setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Time at whihc execution of the build was finished. @OutputOnly
   * @return value or {@code null} for none
   */
  public String getFinishTime() {
    return finishTime;
  }

  /**
   * Time at whihc execution of the build was finished. @OutputOnly
   * @param finishTime finishTime or {@code null} for none
   */
  public Build setFinishTime(String finishTime) {
    this.finishTime = finishTime;
    return this;
  }

  /**
   * Unique identifier of the build. @OutputOnly
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Unique identifier of the build. @OutputOnly
   * @param id id or {@code null} for none
   */
  public Build setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * List of images expected to be built and pushed to Google Container Registry. If an image is
   * listed here and the image is not produced by one of the build steps, the build will fail. Any
   * images present when the build steps are complete will be pushed to Container Registry.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getImages() {
    return images;
  }

  /**
   * List of images expected to be built and pushed to Google Container Registry. If an image is
   * listed here and the image is not produced by one of the build steps, the build will fail. Any
   * images present when the build steps are complete will be pushed to Container Registry.
   * @param images images or {@code null} for none
   */
  public Build setImages(java.util.List<java.lang.String> images) {
    this.images = images;
    return this;
  }

  /**
   * Google Cloud Storage bucket where logs should be written (see [Bucket Name
   * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Logs file
   * names will be of the format `${logs_bucket}/log-${build_id}.txt`.
   * @return value or {@code null} for none
   */
  public java.lang.String getLogsBucket() {
    return logsBucket;
  }

  /**
   * Google Cloud Storage bucket where logs should be written (see [Bucket Name
   * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Logs file
   * names will be of the format `${logs_bucket}/log-${build_id}.txt`.
   * @param logsBucket logsBucket or {@code null} for none
   */
  public Build setLogsBucket(java.lang.String logsBucket) {
    this.logsBucket = logsBucket;
    return this;
  }

  /**
   * ID of the project. @OutputOnly.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * ID of the project. @OutputOnly.
   * @param projectId projectId or {@code null} for none
   */
  public Build setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Results of the build. @OutputOnly
   * @return value or {@code null} for none
   */
  public Results getResults() {
    return results;
  }

  /**
   * Results of the build. @OutputOnly
   * @param results results or {@code null} for none
   */
  public Build setResults(Results results) {
    this.results = results;
    return this;
  }

  /**
   * Describes where to find the source files to build.
   * @return value or {@code null} for none
   */
  public Source getSource() {
    return source;
  }

  /**
   * Describes where to find the source files to build.
   * @param source source or {@code null} for none
   */
  public Build setSource(Source source) {
    this.source = source;
    return this;
  }

  /**
   * Time at which execution of the build was started. @OutputOnly
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * Time at which execution of the build was started. @OutputOnly
   * @param startTime startTime or {@code null} for none
   */
  public Build setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Status of the build. @OutputOnly
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the build. @OutputOnly
   * @param status status or {@code null} for none
   */
  public Build setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Describes the operations to be performed on the workspace.
   * @return value or {@code null} for none
   */
  public java.util.List<BuildStep> getSteps() {
    return steps;
  }

  /**
   * Describes the operations to be performed on the workspace.
   * @param steps steps or {@code null} for none
   */
  public Build setSteps(java.util.List<BuildStep> steps) {
    this.steps = steps;
    return this;
  }

  /**
   * Amount of time that this build should be allowed to run, to second granularity. If this amount
   * of time elapses, work on the build will cease and the build status will be TIMEOUT.
   *
   * Default time is ten minutes.
   * @return value or {@code null} for none
   */
  public String getTimeout() {
    return timeout;
  }

  /**
   * Amount of time that this build should be allowed to run, to second granularity. If this amount
   * of time elapses, work on the build will cease and the build status will be TIMEOUT.
   *
   * Default time is ten minutes.
   * @param timeout timeout or {@code null} for none
   */
  public Build setTimeout(String timeout) {
    this.timeout = timeout;
    return this;
  }

  @Override
  public Build set(String fieldName, Object value) {
    return (Build) super.set(fieldName, value);
  }

  @Override
  public Build clone() {
    return (Build) super.clone();
  }

}
