/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-03-25 20:06:55 UTC)
 * on 2016-04-06 at 17:34:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudbuild.v1;

/**
 * Service definition for CloudBuild (v1).
 *
 * <p>
 * Builds container images in the cloud.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/container-builder/docs/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link CloudBuildRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class CloudBuild extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.20.0 of the Google Cloud Container Builder API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://cloudbuild.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public CloudBuild(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  CloudBuild(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Operations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code CloudBuild cloudbuild = new CloudBuild(...);}
   *   {@code CloudBuild.Operations.List request = cloudbuild.operations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Operations operations() {
    return new Operations();
  }

  /**
   * The "operations" collection of methods.
   */
  public class Operations {

    /**
     * Gets the latest state of a long-running operation.  Clients can use this method to poll the
     * operation result at intervals as recommended by the API service.
     *
     * Create a request for the method "operations.get".
     *
     * This request holds the parameters needed by the cloudbuild server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Operation> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations/.*$");

      /**
       * Gets the latest state of a long-running operation.  Clients can use this method to poll the
       * operation result at intervals as recommended by the API service.
       *
       * Create a request for the method "operations.get".
       *
       * This request holds the parameters needed by the the cloudbuild server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(CloudBuild.this, "GET", REST_PATH, null, com.google.api.services.cloudbuild.v1.model.Operation.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.*$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setBearerToken(java.lang.String bearerToken) {
        return (Get) super.setBearerToken(bearerToken);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPp(java.lang.Boolean pp) {
        return (Get) super.setPp(pp);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource. */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.*$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists operations that match the specified filter in the request. If the server doesn't support
     * this method, it returns `UNIMPLEMENTED`.
     *
     * NOTE: the `name` binding below allows API services to override the binding to use different
     * resource name schemes, such as `users/operations`.
     *
     * Create a request for the method "operations.list".
     *
     * This request holds the parameters needed by the cloudbuild server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation collection.
     * @return the request
     */
    public List list(java.lang.String name) throws java.io.IOException {
      List result = new List(name);
      initialize(result);
      return result;
    }

    public class List extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.ListOperationsResponse> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations$");

      /**
       * Lists operations that match the specified filter in the request. If the server doesn't support
       * this method, it returns `UNIMPLEMENTED`.
       *
       * NOTE: the `name` binding below allows API services to override the binding to use different
       * resource name schemes, such as `users/operations`.
       *
       * Create a request for the method "operations.list".
       *
       * This request holds the parameters needed by the the cloudbuild server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation collection.
       * @since 1.13
       */
      protected List(java.lang.String name) {
        super(CloudBuild.this, "GET", REST_PATH, null, com.google.api.services.cloudbuild.v1.model.ListOperationsResponse.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setBearerToken(java.lang.String bearerToken) {
        return (List) super.setBearerToken(bearerToken);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPp(java.lang.Boolean pp) {
        return (List) super.setPp(pp);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation collection. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation collection.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation collection. */
      public List setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations$");
        }
        this.name = name;
        return this;
      }

      /** The standard list page size. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The standard list page size.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The standard list page size. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** The standard list filter. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** The standard list filter.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** The standard list filter. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /** The standard list page token. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The standard list page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The standard list page token. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code CloudBuild cloudbuild = new CloudBuild(...);}
   *   {@code CloudBuild.Projects.List request = cloudbuild.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Builds collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code CloudBuild cloudbuild = new CloudBuild(...);}
     *   {@code CloudBuild.Builds.List request = cloudbuild.builds().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Builds builds() {
      return new Builds();
    }

    /**
     * The "builds" collection of methods.
     */
    public class Builds {

      /**
       * Cancels a requested build in progress.
       *
       * Create a request for the method "builds.cancel".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project.
       * @param id ID of the build.
       * @param content the {@link com.google.api.services.cloudbuild.v1.model.CancelBuildRequest}
       * @return the request
       */
      public Cancel cancel(java.lang.String projectId, java.lang.String id, com.google.api.services.cloudbuild.v1.model.CancelBuildRequest content) throws java.io.IOException {
        Cancel result = new Cancel(projectId, id, content);
        initialize(result);
        return result;
      }

      public class Cancel extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Build> {

        private static final String REST_PATH = "v1/projects/{projectId}/builds/{id}:cancel";

        /**
         * Cancels a requested build in progress.
         *
         * Create a request for the method "builds.cancel".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
         * <p> {@link
         * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project.
         * @param id ID of the build.
         * @param content the {@link com.google.api.services.cloudbuild.v1.model.CancelBuildRequest}
         * @since 1.13
         */
        protected Cancel(java.lang.String projectId, java.lang.String id, com.google.api.services.cloudbuild.v1.model.CancelBuildRequest content) {
          super(CloudBuild.this, "POST", REST_PATH, content, com.google.api.services.cloudbuild.v1.model.Build.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Cancel set$Xgafv(java.lang.String $Xgafv) {
          return (Cancel) super.set$Xgafv($Xgafv);
        }

        @Override
        public Cancel setAccessToken(java.lang.String accessToken) {
          return (Cancel) super.setAccessToken(accessToken);
        }

        @Override
        public Cancel setAlt(java.lang.String alt) {
          return (Cancel) super.setAlt(alt);
        }

        @Override
        public Cancel setBearerToken(java.lang.String bearerToken) {
          return (Cancel) super.setBearerToken(bearerToken);
        }

        @Override
        public Cancel setCallback(java.lang.String callback) {
          return (Cancel) super.setCallback(callback);
        }

        @Override
        public Cancel setFields(java.lang.String fields) {
          return (Cancel) super.setFields(fields);
        }

        @Override
        public Cancel setKey(java.lang.String key) {
          return (Cancel) super.setKey(key);
        }

        @Override
        public Cancel setOauthToken(java.lang.String oauthToken) {
          return (Cancel) super.setOauthToken(oauthToken);
        }

        @Override
        public Cancel setPp(java.lang.Boolean pp) {
          return (Cancel) super.setPp(pp);
        }

        @Override
        public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Cancel) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Cancel setQuotaUser(java.lang.String quotaUser) {
          return (Cancel) super.setQuotaUser(quotaUser);
        }

        @Override
        public Cancel setUploadType(java.lang.String uploadType) {
          return (Cancel) super.setUploadType(uploadType);
        }

        @Override
        public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
          return (Cancel) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project. */
        public Cancel setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** ID of the build. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** ID of the build.
         */
        public java.lang.String getId() {
          return id;
        }

        /** ID of the build. */
        public Cancel setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Cancel set(String parameterName, Object value) {
          return (Cancel) super.set(parameterName, value);
        }
      }
      /**
       * Starts a build with the specified configuration.
       *
       * The long-running Operation returned by this method will include the ID of the build, which can be
       * passed to GetBuild to determine its status (e.g., success or failure).
       *
       * Create a request for the method "builds.create".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project.
       * @param content the {@link com.google.api.services.cloudbuild.v1.model.Build}
       * @return the request
       */
      public Create create(java.lang.String projectId, com.google.api.services.cloudbuild.v1.model.Build content) throws java.io.IOException {
        Create result = new Create(projectId, content);
        initialize(result);
        return result;
      }

      public class Create extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Operation> {

        private static final String REST_PATH = "v1/projects/{projectId}/builds";

        /**
         * Starts a build with the specified configuration.
         *
         * The long-running Operation returned by this method will include the ID of the build, which can
         * be passed to GetBuild to determine its status (e.g., success or failure).
         *
         * Create a request for the method "builds.create".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project.
         * @param content the {@link com.google.api.services.cloudbuild.v1.model.Build}
         * @since 1.13
         */
        protected Create(java.lang.String projectId, com.google.api.services.cloudbuild.v1.model.Build content) {
          super(CloudBuild.this, "POST", REST_PATH, content, com.google.api.services.cloudbuild.v1.model.Operation.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setBearerToken(java.lang.String bearerToken) {
          return (Create) super.setBearerToken(bearerToken);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPp(java.lang.Boolean pp) {
          return (Create) super.setPp(pp);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project. */
        public Create setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Returns information about a previously requested build.
       *
       * The Build that is returned includes its status (e.g., success or failure, or in-progress), and
       * timing information.
       *
       * Create a request for the method "builds.get".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project.
       * @param id ID of the build.
       * @return the request
       */
      public Get get(java.lang.String projectId, java.lang.String id) throws java.io.IOException {
        Get result = new Get(projectId, id);
        initialize(result);
        return result;
      }

      public class Get extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.Build> {

        private static final String REST_PATH = "v1/projects/{projectId}/builds/{id}";

        /**
         * Returns information about a previously requested build.
         *
         * The Build that is returned includes its status (e.g., success or failure, or in-progress), and
         * timing information.
         *
         * Create a request for the method "builds.get".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project.
         * @param id ID of the build.
         * @since 1.13
         */
        protected Get(java.lang.String projectId, java.lang.String id) {
          super(CloudBuild.this, "GET", REST_PATH, null, com.google.api.services.cloudbuild.v1.model.Build.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setBearerToken(java.lang.String bearerToken) {
          return (Get) super.setBearerToken(bearerToken);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPp(java.lang.Boolean pp) {
          return (Get) super.setPp(pp);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project. */
        public Get setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** ID of the build. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** ID of the build.
         */
        public java.lang.String getId() {
          return id;
        }

        /** ID of the build. */
        public Get setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists previously requested builds.
       *
       * Previously requested builds may still be in-progress, or may have finished successfully or
       * unsuccessfully.
       *
       * Create a request for the method "builds.list".
       *
       * This request holds the parameters needed by the cloudbuild server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param projectId ID of the project.
       * @return the request
       */
      public List list(java.lang.String projectId) throws java.io.IOException {
        List result = new List(projectId);
        initialize(result);
        return result;
      }

      public class List extends CloudBuildRequest<com.google.api.services.cloudbuild.v1.model.ListBuildsResponse> {

        private static final String REST_PATH = "v1/projects/{projectId}/builds";

        /**
         * Lists previously requested builds.
         *
         * Previously requested builds may still be in-progress, or may have finished successfully or
         * unsuccessfully.
         *
         * Create a request for the method "builds.list".
         *
         * This request holds the parameters needed by the the cloudbuild server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param projectId ID of the project.
         * @since 1.13
         */
        protected List(java.lang.String projectId) {
          super(CloudBuild.this, "GET", REST_PATH, null, com.google.api.services.cloudbuild.v1.model.ListBuildsResponse.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setBearerToken(java.lang.String bearerToken) {
          return (List) super.setBearerToken(bearerToken);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPp(java.lang.Boolean pp) {
          return (List) super.setPp(pp);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** ID of the project. */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** ID of the project.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /** ID of the project. */
        public List setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** Number of results to return in the list. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Number of results to return in the list.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** Number of results to return in the list. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /** Token to provide to skip to a particular spot in the list. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Token to provide to skip to a particular spot in the list.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** Token to provide to skip to a particular spot in the list. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link CloudBuild}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link CloudBuild}. */
    @Override
    public CloudBuild build() {
      return new CloudBuild(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link CloudBuildRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setCloudBuildRequestInitializer(
        CloudBuildRequestInitializer cloudbuildRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(cloudbuildRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
