/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-06-30 18:20:40 UTC)
 * on 2015-07-14 at 18:53:42 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.appengine;

/**
 * Service definition for Appengine (v1beta4).
 *
 * <p>
 * The App Engine Admin API enables developers to provision and manage their App Engine applications.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/appengine/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link AppengineRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Appengine extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.19.0 of the Google App Engine Admin API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://appengine.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "v1beta4/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Appengine(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Appengine(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Apps collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Appengine appengine = new Appengine(...);}
   *   {@code Appengine.Apps.List request = appengine.apps().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Apps apps() {
    return new Apps();
  }

  /**
   * The "apps" collection of methods.
   */
  public class Apps {

    /**
     * Creates an application.
     *
     * Create a request for the method "apps.create".
     *
     * This request holds the parameters needed by the appengine server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.appengine.model.Application}
     * @return the request
     */
    public Create create(com.google.api.services.appengine.model.Application content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends AppengineRequest<com.google.api.services.appengine.model.Operation> {

      private static final String REST_PATH = "apps";

      /**
       * Creates an application.
       *
       * Create a request for the method "apps.create".
       *
       * This request holds the parameters needed by the the appengine server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       * <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.appengine.model.Application}
       * @since 1.13
       */
      protected Create(com.google.api.services.appengine.model.Application content) {
        super(Appengine.this, "POST", REST_PATH, content, com.google.api.services.appengine.model.Operation.class);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUserIp(java.lang.String userIp) {
        return (Create) super.setUserIp(userIp);
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Gets information about an application.
     *
     * Create a request for the method "apps.get".
     *
     * This request holds the parameters needed by the appengine server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends AppengineRequest<com.google.api.services.appengine.model.Application> {

      private static final String REST_PATH = "{+name}";

      /**
       * Gets information about an application.
       *
       * Create a request for the method "apps.get".
       *
       * This request holds the parameters needed by the the appengine server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(Appengine.this, "GET", REST_PATH, null, com.google.api.services.appengine.model.Application.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String name;

      /**

       */
      public java.lang.String getName() {
        return name;
      }

      public Get setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean ensureResourcesExist;

      /**

       */
      public java.lang.Boolean getEnsureResourcesExist() {
        return ensureResourcesExist;
      }

      public Get setEnsureResourcesExist(java.lang.Boolean ensureResourcesExist) {
        this.ensureResourcesExist = ensureResourcesExist;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the IAM policy for the specified user. See google/iam/v1/iam_policy.proto for details.
     *
     * Create a request for the method "apps.getIamPolicy".
     *
     * This request holds the parameters needed by the appengine server.  After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(resource);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends AppengineRequest<com.google.api.services.appengine.model.Policy> {

      private static final String REST_PATH = "{+resource}:getIamPolicy";

      /**
       * Gets the IAM policy for the specified user. See google/iam/v1/iam_policy.proto for details.
       *
       * Create a request for the method "apps.getIamPolicy".
       *
       * This request holds the parameters needed by the the appengine server.  After setting any
       * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String resource) {
        super(Appengine.this, "POST", REST_PATH, null, com.google.api.services.appengine.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUserIp(java.lang.String userIp) {
        return (GetIamPolicy) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String resource;

      /**

       */
      public java.lang.String getResource() {
        return resource;
      }

      public GetIamPolicy setResource(java.lang.String resource) {
        this.resource = resource;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Updates application parameters.
     *
     * Create a request for the method "apps.patch".
     *
     * This request holds the parameters needed by the appengine server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param name
     * @param content the {@link com.google.api.services.appengine.model.Application}
     * @return the request
     */
    public Patch patch(java.lang.String name, com.google.api.services.appengine.model.Application content) throws java.io.IOException {
      Patch result = new Patch(name, content);
      initialize(result);
      return result;
    }

    public class Patch extends AppengineRequest<com.google.api.services.appengine.model.Operation> {

      private static final String REST_PATH = "{+name}";

      /**
       * Updates application parameters.
       *
       * Create a request for the method "apps.patch".
       *
       * This request holds the parameters needed by the the appengine server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name
       * @param content the {@link com.google.api.services.appengine.model.Application}
       * @since 1.13
       */
      protected Patch(java.lang.String name, com.google.api.services.appengine.model.Application content) {
        super(Appengine.this, "PATCH", REST_PATH, content, com.google.api.services.appengine.model.Operation.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String name;

      /**

       */
      public java.lang.String getName() {
        return name;
      }

      public Patch setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String mask;

      /**

       */
      public java.lang.String getMask() {
        return mask;
      }

      public Patch setMask(java.lang.String mask) {
        this.mask = mask;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Sets the IAM policy for the specified user. See google/iam/v1/iam_policy.proto for details
     *
     * Create a request for the method "apps.setIamPolicy".
     *
     * This request holds the parameters needed by the appengine server.  After setting any optional
     * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource
     * @param content the {@link com.google.api.services.appengine.model.SetIamPolicyRequest}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.appengine.model.SetIamPolicyRequest content) throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy extends AppengineRequest<com.google.api.services.appengine.model.Policy> {

      private static final String REST_PATH = "{+resource}:setIamPolicy";

      /**
       * Sets the IAM policy for the specified user. See google/iam/v1/iam_policy.proto for details
       *
       * Create a request for the method "apps.setIamPolicy".
       *
       * This request holds the parameters needed by the the appengine server.  After setting any
       * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource
       * @param content the {@link com.google.api.services.appengine.model.SetIamPolicyRequest}
       * @since 1.13
       */
      protected SetIamPolicy(java.lang.String resource, com.google.api.services.appengine.model.SetIamPolicyRequest content) {
        super(Appengine.this, "POST", REST_PATH, content, com.google.api.services.appengine.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
      }

      @Override
      public SetIamPolicy setAlt(java.lang.String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setFields(java.lang.String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(java.lang.String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUserIp(java.lang.String userIp) {
        return (SetIamPolicy) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String resource;

      /**

       */
      public java.lang.String getResource() {
        return resource;
      }

      public SetIamPolicy setResource(java.lang.String resource) {
        this.resource = resource;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the EmailSenders collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Appengine appengine = new Appengine(...);}
     *   {@code Appengine.EmailSenders.List request = appengine.emailSenders().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public EmailSenders emailSenders() {
      return new EmailSenders();
    }

    /**
     * The "emailSenders" collection of methods.
     */
    public class EmailSenders {

      /**
       * Inserts an email address into the specified application's email senders list.
       *
       * Create a request for the method "emailSenders.create".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name
       * @param content the {@link com.google.api.services.appengine.model.EmailSender}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.appengine.model.EmailSender content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends AppengineRequest<com.google.api.services.appengine.model.EmailSender> {

        private static final String REST_PATH = "{+name}/emailSenders";

        /**
         * Inserts an email address into the specified application's email senders list.
         *
         * Create a request for the method "emailSenders.create".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name
         * @param content the {@link com.google.api.services.appengine.model.EmailSender}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.appengine.model.EmailSender content) {
          super(Appengine.this, "POST", REST_PATH, content, com.google.api.services.appengine.model.EmailSender.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUserIp(java.lang.String userIp) {
          return (Create) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String name;

        /**

         */
        public java.lang.String getName() {
          return name;
        }

        public Create setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes an email address from the specified application's email senders list.
       *
       * Create a request for the method "emailSenders.delete".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends AppengineRequest<com.google.api.services.appengine.model.Empty> {

        private static final String REST_PATH = "{+name}";

        /**
         * Deletes an email address from the specified application's email senders list.
         *
         * Create a request for the method "emailSenders.delete".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Appengine.this, "DELETE", REST_PATH, null, com.google.api.services.appengine.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String name;

        /**

         */
        public java.lang.String getName() {
          return name;
        }

        public Delete setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets list of the specified application's email sender addresses.
       *
       * Create a request for the method "emailSenders.list".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends AppengineRequest<com.google.api.services.appengine.model.ListEmailSendersResponse> {

        private static final String REST_PATH = "{+name}/emailSenders";

        /**
         * Gets list of the specified application's email sender addresses.
         *
         * Create a request for the method "emailSenders.list".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Appengine.this, "GET", REST_PATH, null, com.google.api.services.appengine.model.ListEmailSendersResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String name;

        /**

         */
        public java.lang.String getName() {
          return name;
        }

        public List setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /**

         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /**

         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Modules collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Appengine appengine = new Appengine(...);}
     *   {@code Appengine.Modules.List request = appengine.modules().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Modules modules() {
      return new Modules();
    }

    /**
     * The "modules" collection of methods.
     */
    public class Modules {

      /**
       * Deletes a module and all enclosed versions.
       *
       * Create a request for the method "modules.delete".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends AppengineRequest<com.google.api.services.appengine.model.Operation> {

        private static final String REST_PATH = "{+name}";

        /**
         * Deletes a module and all enclosed versions.
         *
         * Create a request for the method "modules.delete".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Appengine.this, "DELETE", REST_PATH, null, com.google.api.services.appengine.model.Operation.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String name;

        /**

         */
        public java.lang.String getName() {
          return name;
        }

        public Delete setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the current configuration of the module.
       *
       * Create a request for the method "modules.get".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends AppengineRequest<com.google.api.services.appengine.model.Module> {

        private static final String REST_PATH = "{+name}";

        /**
         * Gets the current configuration of the module.
         *
         * Create a request for the method "modules.get".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Appengine.this, "GET", REST_PATH, null, com.google.api.services.appengine.model.Module.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String name;

        /**

         */
        public java.lang.String getName() {
          return name;
        }

        public Get setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Gets the IAM policy of the specified module. See google/iam/v1/iam_policy.proto for details.
       *
       * Create a request for the method "modules.getIamPolicy".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource
       * @param content the {@link com.google.api.services.appengine.model.GetIamPolicyRequest}
       * @return the request
       */
      public GetIamPolicy getIamPolicy(java.lang.String resource, com.google.api.services.appengine.model.GetIamPolicyRequest content) throws java.io.IOException {
        GetIamPolicy result = new GetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class GetIamPolicy extends AppengineRequest<com.google.api.services.appengine.model.Policy> {

        private static final String REST_PATH = "{+resource}:getIamPolicy";

        /**
         * Gets the IAM policy of the specified module. See google/iam/v1/iam_policy.proto for details.
         *
         * Create a request for the method "modules.getIamPolicy".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
         * operation. <p> {@link
         * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource
         * @param content the {@link com.google.api.services.appengine.model.GetIamPolicyRequest}
         * @since 1.13
         */
        protected GetIamPolicy(java.lang.String resource, com.google.api.services.appengine.model.GetIamPolicyRequest content) {
          super(Appengine.this, "POST", REST_PATH, content, com.google.api.services.appengine.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        }

        @Override
        public GetIamPolicy setAlt(java.lang.String alt) {
          return (GetIamPolicy) super.setAlt(alt);
        }

        @Override
        public GetIamPolicy setFields(java.lang.String fields) {
          return (GetIamPolicy) super.setFields(fields);
        }

        @Override
        public GetIamPolicy setKey(java.lang.String key) {
          return (GetIamPolicy) super.setKey(key);
        }

        @Override
        public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (GetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (GetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetIamPolicy setUserIp(java.lang.String userIp) {
          return (GetIamPolicy) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String resource;

        /**

         */
        public java.lang.String getResource() {
          return resource;
        }

        public GetIamPolicy setResource(java.lang.String resource) {
          this.resource = resource;
          return this;
        }

        @Override
        public GetIamPolicy set(String parameterName, Object value) {
          return (GetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Lists all the modules in the application.
       *
       * Create a request for the method "modules.list".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends AppengineRequest<com.google.api.services.appengine.model.ListModulesResponse> {

        private static final String REST_PATH = "{+name}/modules";

        /**
         * Lists all the modules in the application.
         *
         * Create a request for the method "modules.list".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Appengine.this, "GET", REST_PATH, null, com.google.api.services.appengine.model.ListModulesResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String name;

        /**

         */
        public java.lang.String getName() {
          return name;
        }

        public List setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /**

         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /**

         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates the configuration of the specified module.
       *
       * Create a request for the method "modules.patch".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name
       * @param content the {@link com.google.api.services.appengine.model.Module}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.appengine.model.Module content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends AppengineRequest<com.google.api.services.appengine.model.Operation> {

        private static final String REST_PATH = "{+name}";

        /**
         * Updates the configuration of the specified module.
         *
         * Create a request for the method "modules.patch".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name
         * @param content the {@link com.google.api.services.appengine.model.Module}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.appengine.model.Module content) {
          super(Appengine.this, "PATCH", REST_PATH, content, com.google.api.services.appengine.model.Operation.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(java.lang.String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String name;

        /**

         */
        public java.lang.String getName() {
          return name;
        }

        public Patch setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @com.google.api.client.util.Key
        private java.lang.Boolean migrateTraffic;

        /**

         */
        public java.lang.Boolean getMigrateTraffic() {
          return migrateTraffic;
        }

        public Patch setMigrateTraffic(java.lang.Boolean migrateTraffic) {
          this.migrateTraffic = migrateTraffic;
          return this;
        }

        @com.google.api.client.util.Key
        private java.lang.String mask;

        /**

         */
        public java.lang.String getMask() {
          return mask;
        }

        public Patch setMask(java.lang.String mask) {
          this.mask = mask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Sets the IAM policy of the specified module for the specified user. See
       * google/iam/v1/iam_policy.proto for details
       *
       * Create a request for the method "modules.setIamPolicy".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource
       * @param content the {@link com.google.api.services.appengine.model.SetIamPolicyRequest}
       * @return the request
       */
      public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.appengine.model.SetIamPolicyRequest content) throws java.io.IOException {
        SetIamPolicy result = new SetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class SetIamPolicy extends AppengineRequest<com.google.api.services.appengine.model.Policy> {

        private static final String REST_PATH = "{+resource}:setIamPolicy";

        /**
         * Sets the IAM policy of the specified module for the specified user. See
         * google/iam/v1/iam_policy.proto for details
         *
         * Create a request for the method "modules.setIamPolicy".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
         * operation. <p> {@link
         * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource
         * @param content the {@link com.google.api.services.appengine.model.SetIamPolicyRequest}
         * @since 1.13
         */
        protected SetIamPolicy(java.lang.String resource, com.google.api.services.appengine.model.SetIamPolicyRequest content) {
          super(Appengine.this, "POST", REST_PATH, content, com.google.api.services.appengine.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        }

        @Override
        public SetIamPolicy setAlt(java.lang.String alt) {
          return (SetIamPolicy) super.setAlt(alt);
        }

        @Override
        public SetIamPolicy setFields(java.lang.String fields) {
          return (SetIamPolicy) super.setFields(fields);
        }

        @Override
        public SetIamPolicy setKey(java.lang.String key) {
          return (SetIamPolicy) super.setKey(key);
        }

        @Override
        public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (SetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (SetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public SetIamPolicy setUserIp(java.lang.String userIp) {
          return (SetIamPolicy) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String resource;

        /**

         */
        public java.lang.String getResource() {
          return resource;
        }

        public SetIamPolicy setResource(java.lang.String resource) {
          this.resource = resource;
          return this;
        }

        @Override
        public SetIamPolicy set(String parameterName, Object value) {
          return (SetIamPolicy) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Versions collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Appengine appengine = new Appengine(...);}
       *   {@code Appengine.Versions.List request = appengine.versions().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Versions versions() {
        return new Versions();
      }

      /**
       * The "versions" collection of methods.
       */
      public class Versions {

        /**
         * Deploys new code and resource files to a version.
         *
         * Create a request for the method "versions.create".
         *
         * This request holds the parameters needed by the appengine server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param name
         * @param content the {@link com.google.api.services.appengine.model.Version}
         * @return the request
         */
        public Create create(java.lang.String name, com.google.api.services.appengine.model.Version content) throws java.io.IOException {
          Create result = new Create(name, content);
          initialize(result);
          return result;
        }

        public class Create extends AppengineRequest<com.google.api.services.appengine.model.Operation> {

          private static final String REST_PATH = "{+name}/versions";

          /**
           * Deploys new code and resource files to a version.
           *
           * Create a request for the method "versions.create".
           *
           * This request holds the parameters needed by the the appengine server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name
           * @param content the {@link com.google.api.services.appengine.model.Version}
           * @since 1.13
           */
          protected Create(java.lang.String name, com.google.api.services.appengine.model.Version content) {
            super(Appengine.this, "POST", REST_PATH, content, com.google.api.services.appengine.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUserIp(java.lang.String userIp) {
            return (Create) super.setUserIp(userIp);
          }

          @com.google.api.client.util.Key
          private java.lang.String name;

          /**

           */
          public java.lang.String getName() {
            return name;
          }

          public Create setName(java.lang.String name) {
            this.name = name;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes an existing version.
         *
         * Create a request for the method "versions.delete".
         *
         * This request holds the parameters needed by the appengine server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends AppengineRequest<com.google.api.services.appengine.model.Operation> {

          private static final String REST_PATH = "{+name}";

          /**
           * Deletes an existing version.
           *
           * Create a request for the method "versions.delete".
           *
           * This request holds the parameters needed by the the appengine server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Appengine.this, "DELETE", REST_PATH, null, com.google.api.services.appengine.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUserIp(java.lang.String userIp) {
            return (Delete) super.setUserIp(userIp);
          }

          @com.google.api.client.util.Key
          private java.lang.String name;

          /**

           */
          public java.lang.String getName() {
            return name;
          }

          public Delete setName(java.lang.String name) {
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets application deployment information.
         *
         * Create a request for the method "versions.get".
         *
         * This request holds the parameters needed by the appengine server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends AppengineRequest<com.google.api.services.appengine.model.Version> {

          private static final String REST_PATH = "{+name}";

          /**
           * Gets application deployment information.
           *
           * Create a request for the method "versions.get".
           *
           * This request holds the parameters needed by the the appengine server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Appengine.this, "GET", REST_PATH, null, com.google.api.services.appengine.model.Version.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUserIp(java.lang.String userIp) {
            return (Get) super.setUserIp(userIp);
          }

          @com.google.api.client.util.Key
          private java.lang.String name;

          /**

           */
          public java.lang.String getName() {
            return name;
          }

          public Get setName(java.lang.String name) {
            this.name = name;
            return this;
          }

          @com.google.api.client.util.Key
          private java.lang.String view;

          /**

           */
          public java.lang.String getView() {
            return view;
          }

          public Get setView(java.lang.String view) {
            this.view = view;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists the versions of a module.
         *
         * Create a request for the method "versions.list".
         *
         * This request holds the parameters needed by the appengine server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param name
         * @return the request
         */
        public List list(java.lang.String name) throws java.io.IOException {
          List result = new List(name);
          initialize(result);
          return result;
        }

        public class List extends AppengineRequest<com.google.api.services.appengine.model.ListVersionsResponse> {

          private static final String REST_PATH = "{+name}/versions";

          /**
           * Lists the versions of a module.
           *
           * Create a request for the method "versions.list".
           *
           * This request holds the parameters needed by the the appengine server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name
           * @since 1.13
           */
          protected List(java.lang.String name) {
            super(Appengine.this, "GET", REST_PATH, null, com.google.api.services.appengine.model.ListVersionsResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUserIp(java.lang.String userIp) {
            return (List) super.setUserIp(userIp);
          }

          @com.google.api.client.util.Key
          private java.lang.String name;

          /**

           */
          public java.lang.String getName() {
            return name;
          }

          public List setName(java.lang.String name) {
            this.name = name;
            return this;
          }

          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /**

           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /**

           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @com.google.api.client.util.Key
          private java.lang.String view;

          /**

           */
          public java.lang.String getView() {
            return view;
          }

          public List setView(java.lang.String view) {
            this.view = view;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
    /**
     * An accessor for creating requests from the Operations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Appengine appengine = new Appengine(...);}
     *   {@code Appengine.Operations.List request = appengine.operations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Operations operations() {
      return new Operations();
    }

    /**
     * The "operations" collection of methods.
     */
    public class Operations {

      /**
       * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
       * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
       * it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use
       * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or other methods to check
       * if the cancellation succeeded or the operation completed despite cancellation.
       *
       * Create a request for the method "operations.cancel".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
       *
       * @param name
       * @param content the {@link com.google.api.services.appengine.model.CancelOperationRequest}
       * @return the request
       */
      public Cancel cancel(java.lang.String name, com.google.api.services.appengine.model.CancelOperationRequest content) throws java.io.IOException {
        Cancel result = new Cancel(name, content);
        initialize(result);
        return result;
      }

      public class Cancel extends AppengineRequest<com.google.api.services.appengine.model.Empty> {

        private static final String REST_PATH = "{+name}:cancel";

        /**
         * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
         * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
         * it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use
         * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or other methods to check
         * if the cancellation succeeded or the operation completed despite cancellation.
         *
         * Create a request for the method "operations.cancel".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
         * <p> {@link
         * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name
         * @param content the {@link com.google.api.services.appengine.model.CancelOperationRequest}
         * @since 1.13
         */
        protected Cancel(java.lang.String name, com.google.api.services.appengine.model.CancelOperationRequest content) {
          super(Appengine.this, "POST", REST_PATH, content, com.google.api.services.appengine.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        }

        @Override
        public Cancel setAlt(java.lang.String alt) {
          return (Cancel) super.setAlt(alt);
        }

        @Override
        public Cancel setFields(java.lang.String fields) {
          return (Cancel) super.setFields(fields);
        }

        @Override
        public Cancel setKey(java.lang.String key) {
          return (Cancel) super.setKey(key);
        }

        @Override
        public Cancel setOauthToken(java.lang.String oauthToken) {
          return (Cancel) super.setOauthToken(oauthToken);
        }

        @Override
        public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Cancel) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Cancel setQuotaUser(java.lang.String quotaUser) {
          return (Cancel) super.setQuotaUser(quotaUser);
        }

        @Override
        public Cancel setUserIp(java.lang.String userIp) {
          return (Cancel) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String name;

        /**

         */
        public java.lang.String getName() {
          return name;
        }

        public Cancel setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @Override
        public Cancel set(String parameterName, Object value) {
          return (Cancel) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a long-running operation. It indicates the client is no longer interested in the
       * operation result. It does not cancel the operation. If the server doesn't support this method, it
       * returns `google.rpc.Code.UNIMPLEMENTED`.
       *
       * Create a request for the method "operations.delete".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends AppengineRequest<com.google.api.services.appengine.model.Empty> {

        private static final String REST_PATH = "{+name}";

        /**
         * Deletes a long-running operation. It indicates the client is no longer interested in the
         * operation result. It does not cancel the operation. If the server doesn't support this method,
         * it returns `google.rpc.Code.UNIMPLEMENTED`.
         *
         * Create a request for the method "operations.delete".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Appengine.this, "DELETE", REST_PATH, null, com.google.api.services.appengine.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String name;

        /**

         */
        public java.lang.String getName() {
          return name;
        }

        public Delete setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the latest state of a long-running operation. Clients can use this method to poll the
       * operation result at intervals as recommended by the API service.
       *
       * Create a request for the method "operations.get".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends AppengineRequest<com.google.api.services.appengine.model.Operation> {

        private static final String REST_PATH = "{+name}";

        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the
         * operation result at intervals as recommended by the API service.
         *
         * Create a request for the method "operations.get".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Appengine.this, "GET", REST_PATH, null, com.google.api.services.appengine.model.Operation.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String name;

        /**

         */
        public java.lang.String getName() {
          return name;
        }

        public Get setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists operations that match the specified filter in the request. If the server doesn't support
       * this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding below allows API services to
       * override the binding to use different resource name schemes, such as `users/operations`.
       *
       * Create a request for the method "operations.list".
       *
       * This request holds the parameters needed by the appengine server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends AppengineRequest<com.google.api.services.appengine.model.ListOperationsResponse> {

        private static final String REST_PATH = "{+name}/operations";

        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support
         * this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding below allows API services to
         * override the binding to use different resource name schemes, such as `users/operations`.
         *
         * Create a request for the method "operations.list".
         *
         * This request holds the parameters needed by the the appengine server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Appengine.this, "GET", REST_PATH, null, com.google.api.services.appengine.model.ListOperationsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        @com.google.api.client.util.Key
        private java.lang.String name;

        /**

         */
        public java.lang.String getName() {
          return name;
        }

        public List setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @com.google.api.client.util.Key
        private java.lang.String filter;

        /**

         */
        public java.lang.String getFilter() {
          return filter;
        }

        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /**

         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /**

         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link Appengine}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Appengine}. */
    @Override
    public Appengine build() {
      return new Appengine(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link AppengineRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setAppengineRequestInitializer(
        AppengineRequestInitializer appengineRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(appengineRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
