/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.api;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EndpointName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENDPOINT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/endpoints/{endpoint}");
    private static final PathTemplate PROJECT_LOCATION_PUBLISHER_MODEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/publishers/{publisher}/models/{model}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String endpoint;
    private final String publisher;
    private final String model;

    @Deprecated
    protected EndpointName() {
        this.project = null;
        this.location = null;
        this.endpoint = null;
        this.publisher = null;
        this.model = null;
    }

    private EndpointName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.endpoint = (String)Preconditions.checkNotNull((Object)builder.getEndpoint());
        this.publisher = null;
        this.model = null;
        this.pathTemplate = PROJECT_LOCATION_ENDPOINT;
    }

    private EndpointName(ProjectLocationPublisherModelBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.publisher = (String)Preconditions.checkNotNull((Object)builder.getPublisher());
        this.model = (String)Preconditions.checkNotNull((Object)builder.getModel());
        this.endpoint = null;
        this.pathTemplate = PROJECT_LOCATION_PUBLISHER_MODEL;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getModel() {
        return this.model;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationEndpointBuilder() {
        return new Builder();
    }

    public static ProjectLocationPublisherModelBuilder newProjectLocationPublisherModelBuilder() {
        return new ProjectLocationPublisherModelBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EndpointName of(String project, String location, String endpoint) {
        return EndpointName.newBuilder().setProject(project).setLocation(location).setEndpoint(endpoint).build();
    }

    public static EndpointName ofProjectLocationEndpointName(String project, String location, String endpoint) {
        return EndpointName.newBuilder().setProject(project).setLocation(location).setEndpoint(endpoint).build();
    }

    public static EndpointName ofProjectLocationPublisherModelName(String project, String location, String publisher, String model) {
        return EndpointName.newProjectLocationPublisherModelBuilder().setProject(project).setLocation(location).setPublisher(publisher).setModel(model).build();
    }

    public static String format(String project, String location, String endpoint) {
        return EndpointName.newBuilder().setProject(project).setLocation(location).setEndpoint(endpoint).build().toString();
    }

    public static String formatProjectLocationEndpointName(String project, String location, String endpoint) {
        return EndpointName.newBuilder().setProject(project).setLocation(location).setEndpoint(endpoint).build().toString();
    }

    public static String formatProjectLocationPublisherModelName(String project, String location, String publisher, String model) {
        return EndpointName.newProjectLocationPublisherModelBuilder().setProject(project).setLocation(location).setPublisher(publisher).setModel(model).build().toString();
    }

    public static EndpointName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_ENDPOINT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_ENDPOINT.match(formattedString);
            return EndpointName.ofProjectLocationEndpointName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("endpoint"));
        }
        if (PROJECT_LOCATION_PUBLISHER_MODEL.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_PUBLISHER_MODEL.match(formattedString);
            return EndpointName.ofProjectLocationPublisherModelName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("publisher"), (String)matchMap.get("model"));
        }
        throw new ValidationException("EndpointName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<EndpointName> parseList(List<String> formattedStrings) {
        ArrayList<EndpointName> list = new ArrayList<EndpointName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EndpointName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EndpointName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EndpointName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENDPOINT.matches(formattedString) || PROJECT_LOCATION_PUBLISHER_MODEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EndpointName endpointName = this;
            synchronized (endpointName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.endpoint != null) {
                        fieldMapBuilder.put((Object)"endpoint", (Object)this.endpoint);
                    }
                    if (this.publisher != null) {
                        fieldMapBuilder.put((Object)"publisher", (Object)this.publisher);
                    }
                    if (this.model != null) {
                        fieldMapBuilder.put((Object)"model", (Object)this.model);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EndpointName that = (EndpointName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.publisher, that.publisher) && Objects.equals(this.model, that.model);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.endpoint);
        h *= 1000003;
        h ^= Objects.hashCode(this.publisher);
        h *= 1000003;
        return h ^= Objects.hashCode(this.model);
    }

    public static class ProjectLocationPublisherModelBuilder {
        private String project;
        private String location;
        private String publisher;
        private String model;

        protected ProjectLocationPublisherModelBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPublisher() {
            return this.publisher;
        }

        public String getModel() {
            return this.model;
        }

        public ProjectLocationPublisherModelBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationPublisherModelBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationPublisherModelBuilder setPublisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public ProjectLocationPublisherModelBuilder setModel(String model) {
            this.model = model;
            return this;
        }

        public EndpointName build() {
            return new EndpointName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String endpoint;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        private Builder(EndpointName endpointName) {
            Preconditions.checkArgument((boolean)Objects.equals(endpointName.pathTemplate, PROJECT_LOCATION_ENDPOINT), (Object)"toBuilder is only supported when EndpointName has the pattern of projects/{project}/locations/{location}/endpoints/{endpoint}");
            this.project = endpointName.project;
            this.location = endpointName.location;
            this.endpoint = endpointName.endpoint;
        }

        public EndpointName build() {
            return new EndpointName(this);
        }
    }
}

