/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * Represents the metadata of a long-running operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.OperationMetadata}
 */
public final class OperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.OperationMetadata)
    OperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OperationMetadata.newBuilder() to construct.
  private OperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OperationMetadata() {
    resource_ = "";
    method_ = "";
    kmsKeyName_ = "";
    kmsKeyVersionName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_OperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_OperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.OperationMetadata.class,
            com.google.cloud.speech.v2.OperationMetadata.Builder.class);
  }

  private int bitField0_;
  private int requestCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object request_;

  public enum RequestCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BATCH_RECOGNIZE_REQUEST(8),
    CREATE_RECOGNIZER_REQUEST(9),
    UPDATE_RECOGNIZER_REQUEST(10),
    DELETE_RECOGNIZER_REQUEST(11),
    UNDELETE_RECOGNIZER_REQUEST(12),
    CREATE_CUSTOM_CLASS_REQUEST(13),
    UPDATE_CUSTOM_CLASS_REQUEST(14),
    DELETE_CUSTOM_CLASS_REQUEST(15),
    UNDELETE_CUSTOM_CLASS_REQUEST(16),
    CREATE_PHRASE_SET_REQUEST(17),
    UPDATE_PHRASE_SET_REQUEST(18),
    DELETE_PHRASE_SET_REQUEST(19),
    UNDELETE_PHRASE_SET_REQUEST(20),
    @java.lang.Deprecated
    UPDATE_CONFIG_REQUEST(21),
    REQUEST_NOT_SET(0);
    private final int value;

    private RequestCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RequestCase valueOf(int value) {
      return forNumber(value);
    }

    public static RequestCase forNumber(int value) {
      switch (value) {
        case 8:
          return BATCH_RECOGNIZE_REQUEST;
        case 9:
          return CREATE_RECOGNIZER_REQUEST;
        case 10:
          return UPDATE_RECOGNIZER_REQUEST;
        case 11:
          return DELETE_RECOGNIZER_REQUEST;
        case 12:
          return UNDELETE_RECOGNIZER_REQUEST;
        case 13:
          return CREATE_CUSTOM_CLASS_REQUEST;
        case 14:
          return UPDATE_CUSTOM_CLASS_REQUEST;
        case 15:
          return DELETE_CUSTOM_CLASS_REQUEST;
        case 16:
          return UNDELETE_CUSTOM_CLASS_REQUEST;
        case 17:
          return CREATE_PHRASE_SET_REQUEST;
        case 18:
          return UPDATE_PHRASE_SET_REQUEST;
        case 19:
          return DELETE_PHRASE_SET_REQUEST;
        case 20:
          return UNDELETE_PHRASE_SET_REQUEST;
        case 21:
          return UPDATE_CONFIG_REQUEST;
        case 0:
          return REQUEST_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RequestCase getRequestCase() {
    return RequestCase.forNumber(requestCase_);
  }

  private int metadataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metadata_;

  public enum MetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BATCH_RECOGNIZE_METADATA(23),
    METADATA_NOT_SET(0);
    private final int value;

    private MetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetadataCase forNumber(int value) {
      switch (value) {
        case 23:
          return BATCH_RECOGNIZE_METADATA;
        case 0:
          return METADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetadataCase getMetadataCase() {
    return MetadataCase.forNumber(metadataCase_);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * The time the operation was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time the operation was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the operation was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int RESOURCE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resource_ = "";
  /**
   *
   *
   * <pre>
   * The resource path for the target of the operation.
   * </pre>
   *
   * <code>string resource = 3;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public java.lang.String getResource() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource path for the target of the operation.
   * </pre>
   *
   * <code>string resource = 3;</code>
   *
   * @return The bytes for resource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceBytes() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METHOD_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object method_ = "";
  /**
   *
   *
   * <pre>
   * The method that triggered the operation.
   * </pre>
   *
   * <code>string method = 4;</code>
   *
   * @return The method.
   */
  @java.lang.Override
  public java.lang.String getMethod() {
    java.lang.Object ref = method_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      method_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The method that triggered the operation.
   * </pre>
   *
   * <code>string method = 4;</code>
   *
   * @return The bytes for method.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMethodBytes() {
    java.lang.Object ref = method_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      method_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";
  /**
   *
   *
   * <pre>
   * The [KMS key
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
   * the content of the Operation is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   * </pre>
   *
   * <code>string kms_key_name = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [KMS key
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
   * the content of the Operation is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   * </pre>
   *
   * <code>string kms_key_name = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_VERSION_NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyVersionName_ = "";
  /**
   *
   *
   * <pre>
   * The [KMS key version
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
   * with which content of the Operation is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
   * </pre>
   *
   * <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The kmsKeyVersionName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyVersionName() {
    java.lang.Object ref = kmsKeyVersionName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyVersionName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [KMS key version
   * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
   * with which content of the Operation is encrypted. The expected format is
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
   * </pre>
   *
   * <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for kmsKeyVersionName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyVersionNameBytes() {
    java.lang.Object ref = kmsKeyVersionName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyVersionName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BATCH_RECOGNIZE_REQUEST_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * The BatchRecognizeRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
   *
   * @return Whether the batchRecognizeRequest field is set.
   */
  @java.lang.Override
  public boolean hasBatchRecognizeRequest() {
    return requestCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * The BatchRecognizeRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
   *
   * @return The batchRecognizeRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeRequest getBatchRecognizeRequest() {
    if (requestCase_ == 8) {
      return (com.google.cloud.speech.v2.BatchRecognizeRequest) request_;
    }
    return com.google.cloud.speech.v2.BatchRecognizeRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The BatchRecognizeRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeRequestOrBuilder
      getBatchRecognizeRequestOrBuilder() {
    if (requestCase_ == 8) {
      return (com.google.cloud.speech.v2.BatchRecognizeRequest) request_;
    }
    return com.google.cloud.speech.v2.BatchRecognizeRequest.getDefaultInstance();
  }

  public static final int CREATE_RECOGNIZER_REQUEST_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * The CreateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
   *
   * @return Whether the createRecognizerRequest field is set.
   */
  @java.lang.Override
  public boolean hasCreateRecognizerRequest() {
    return requestCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * The CreateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
   *
   * @return The createRecognizerRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.CreateRecognizerRequest getCreateRecognizerRequest() {
    if (requestCase_ == 9) {
      return (com.google.cloud.speech.v2.CreateRecognizerRequest) request_;
    }
    return com.google.cloud.speech.v2.CreateRecognizerRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The CreateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.CreateRecognizerRequestOrBuilder
      getCreateRecognizerRequestOrBuilder() {
    if (requestCase_ == 9) {
      return (com.google.cloud.speech.v2.CreateRecognizerRequest) request_;
    }
    return com.google.cloud.speech.v2.CreateRecognizerRequest.getDefaultInstance();
  }

  public static final int UPDATE_RECOGNIZER_REQUEST_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * The UpdateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
   *
   * @return Whether the updateRecognizerRequest field is set.
   */
  @java.lang.Override
  public boolean hasUpdateRecognizerRequest() {
    return requestCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * The UpdateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
   *
   * @return The updateRecognizerRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UpdateRecognizerRequest getUpdateRecognizerRequest() {
    if (requestCase_ == 10) {
      return (com.google.cloud.speech.v2.UpdateRecognizerRequest) request_;
    }
    return com.google.cloud.speech.v2.UpdateRecognizerRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The UpdateRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UpdateRecognizerRequestOrBuilder
      getUpdateRecognizerRequestOrBuilder() {
    if (requestCase_ == 10) {
      return (com.google.cloud.speech.v2.UpdateRecognizerRequest) request_;
    }
    return com.google.cloud.speech.v2.UpdateRecognizerRequest.getDefaultInstance();
  }

  public static final int DELETE_RECOGNIZER_REQUEST_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * The DeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
   *
   * @return Whether the deleteRecognizerRequest field is set.
   */
  @java.lang.Override
  public boolean hasDeleteRecognizerRequest() {
    return requestCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * The DeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
   *
   * @return The deleteRecognizerRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.DeleteRecognizerRequest getDeleteRecognizerRequest() {
    if (requestCase_ == 11) {
      return (com.google.cloud.speech.v2.DeleteRecognizerRequest) request_;
    }
    return com.google.cloud.speech.v2.DeleteRecognizerRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The DeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.DeleteRecognizerRequestOrBuilder
      getDeleteRecognizerRequestOrBuilder() {
    if (requestCase_ == 11) {
      return (com.google.cloud.speech.v2.DeleteRecognizerRequest) request_;
    }
    return com.google.cloud.speech.v2.DeleteRecognizerRequest.getDefaultInstance();
  }

  public static final int UNDELETE_RECOGNIZER_REQUEST_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * The UndeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
   * </code>
   *
   * @return Whether the undeleteRecognizerRequest field is set.
   */
  @java.lang.Override
  public boolean hasUndeleteRecognizerRequest() {
    return requestCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * The UndeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
   * </code>
   *
   * @return The undeleteRecognizerRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UndeleteRecognizerRequest getUndeleteRecognizerRequest() {
    if (requestCase_ == 12) {
      return (com.google.cloud.speech.v2.UndeleteRecognizerRequest) request_;
    }
    return com.google.cloud.speech.v2.UndeleteRecognizerRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The UndeleteRecognizerRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UndeleteRecognizerRequestOrBuilder
      getUndeleteRecognizerRequestOrBuilder() {
    if (requestCase_ == 12) {
      return (com.google.cloud.speech.v2.UndeleteRecognizerRequest) request_;
    }
    return com.google.cloud.speech.v2.UndeleteRecognizerRequest.getDefaultInstance();
  }

  public static final int CREATE_CUSTOM_CLASS_REQUEST_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * The CreateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;</code>
   *
   * @return Whether the createCustomClassRequest field is set.
   */
  @java.lang.Override
  public boolean hasCreateCustomClassRequest() {
    return requestCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * The CreateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;</code>
   *
   * @return The createCustomClassRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.CreateCustomClassRequest getCreateCustomClassRequest() {
    if (requestCase_ == 13) {
      return (com.google.cloud.speech.v2.CreateCustomClassRequest) request_;
    }
    return com.google.cloud.speech.v2.CreateCustomClassRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The CreateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.CreateCustomClassRequestOrBuilder
      getCreateCustomClassRequestOrBuilder() {
    if (requestCase_ == 13) {
      return (com.google.cloud.speech.v2.CreateCustomClassRequest) request_;
    }
    return com.google.cloud.speech.v2.CreateCustomClassRequest.getDefaultInstance();
  }

  public static final int UPDATE_CUSTOM_CLASS_REQUEST_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * The UpdateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;</code>
   *
   * @return Whether the updateCustomClassRequest field is set.
   */
  @java.lang.Override
  public boolean hasUpdateCustomClassRequest() {
    return requestCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * The UpdateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;</code>
   *
   * @return The updateCustomClassRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UpdateCustomClassRequest getUpdateCustomClassRequest() {
    if (requestCase_ == 14) {
      return (com.google.cloud.speech.v2.UpdateCustomClassRequest) request_;
    }
    return com.google.cloud.speech.v2.UpdateCustomClassRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The UpdateCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UpdateCustomClassRequestOrBuilder
      getUpdateCustomClassRequestOrBuilder() {
    if (requestCase_ == 14) {
      return (com.google.cloud.speech.v2.UpdateCustomClassRequest) request_;
    }
    return com.google.cloud.speech.v2.UpdateCustomClassRequest.getDefaultInstance();
  }

  public static final int DELETE_CUSTOM_CLASS_REQUEST_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * The DeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;</code>
   *
   * @return Whether the deleteCustomClassRequest field is set.
   */
  @java.lang.Override
  public boolean hasDeleteCustomClassRequest() {
    return requestCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * The DeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;</code>
   *
   * @return The deleteCustomClassRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.DeleteCustomClassRequest getDeleteCustomClassRequest() {
    if (requestCase_ == 15) {
      return (com.google.cloud.speech.v2.DeleteCustomClassRequest) request_;
    }
    return com.google.cloud.speech.v2.DeleteCustomClassRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The DeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.DeleteCustomClassRequestOrBuilder
      getDeleteCustomClassRequestOrBuilder() {
    if (requestCase_ == 15) {
      return (com.google.cloud.speech.v2.DeleteCustomClassRequest) request_;
    }
    return com.google.cloud.speech.v2.DeleteCustomClassRequest.getDefaultInstance();
  }

  public static final int UNDELETE_CUSTOM_CLASS_REQUEST_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * The UndeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
   * </code>
   *
   * @return Whether the undeleteCustomClassRequest field is set.
   */
  @java.lang.Override
  public boolean hasUndeleteCustomClassRequest() {
    return requestCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * The UndeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
   * </code>
   *
   * @return The undeleteCustomClassRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UndeleteCustomClassRequest getUndeleteCustomClassRequest() {
    if (requestCase_ == 16) {
      return (com.google.cloud.speech.v2.UndeleteCustomClassRequest) request_;
    }
    return com.google.cloud.speech.v2.UndeleteCustomClassRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The UndeleteCustomClassRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UndeleteCustomClassRequestOrBuilder
      getUndeleteCustomClassRequestOrBuilder() {
    if (requestCase_ == 16) {
      return (com.google.cloud.speech.v2.UndeleteCustomClassRequest) request_;
    }
    return com.google.cloud.speech.v2.UndeleteCustomClassRequest.getDefaultInstance();
  }

  public static final int CREATE_PHRASE_SET_REQUEST_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * The CreatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
   *
   * @return Whether the createPhraseSetRequest field is set.
   */
  @java.lang.Override
  public boolean hasCreatePhraseSetRequest() {
    return requestCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * The CreatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
   *
   * @return The createPhraseSetRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.CreatePhraseSetRequest getCreatePhraseSetRequest() {
    if (requestCase_ == 17) {
      return (com.google.cloud.speech.v2.CreatePhraseSetRequest) request_;
    }
    return com.google.cloud.speech.v2.CreatePhraseSetRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The CreatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.CreatePhraseSetRequestOrBuilder
      getCreatePhraseSetRequestOrBuilder() {
    if (requestCase_ == 17) {
      return (com.google.cloud.speech.v2.CreatePhraseSetRequest) request_;
    }
    return com.google.cloud.speech.v2.CreatePhraseSetRequest.getDefaultInstance();
  }

  public static final int UPDATE_PHRASE_SET_REQUEST_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * The UpdatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
   *
   * @return Whether the updatePhraseSetRequest field is set.
   */
  @java.lang.Override
  public boolean hasUpdatePhraseSetRequest() {
    return requestCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * The UpdatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
   *
   * @return The updatePhraseSetRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UpdatePhraseSetRequest getUpdatePhraseSetRequest() {
    if (requestCase_ == 18) {
      return (com.google.cloud.speech.v2.UpdatePhraseSetRequest) request_;
    }
    return com.google.cloud.speech.v2.UpdatePhraseSetRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The UpdatePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UpdatePhraseSetRequestOrBuilder
      getUpdatePhraseSetRequestOrBuilder() {
    if (requestCase_ == 18) {
      return (com.google.cloud.speech.v2.UpdatePhraseSetRequest) request_;
    }
    return com.google.cloud.speech.v2.UpdatePhraseSetRequest.getDefaultInstance();
  }

  public static final int DELETE_PHRASE_SET_REQUEST_FIELD_NUMBER = 19;
  /**
   *
   *
   * <pre>
   * The DeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
   *
   * @return Whether the deletePhraseSetRequest field is set.
   */
  @java.lang.Override
  public boolean hasDeletePhraseSetRequest() {
    return requestCase_ == 19;
  }
  /**
   *
   *
   * <pre>
   * The DeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
   *
   * @return The deletePhraseSetRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.DeletePhraseSetRequest getDeletePhraseSetRequest() {
    if (requestCase_ == 19) {
      return (com.google.cloud.speech.v2.DeletePhraseSetRequest) request_;
    }
    return com.google.cloud.speech.v2.DeletePhraseSetRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The DeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.DeletePhraseSetRequestOrBuilder
      getDeletePhraseSetRequestOrBuilder() {
    if (requestCase_ == 19) {
      return (com.google.cloud.speech.v2.DeletePhraseSetRequest) request_;
    }
    return com.google.cloud.speech.v2.DeletePhraseSetRequest.getDefaultInstance();
  }

  public static final int UNDELETE_PHRASE_SET_REQUEST_FIELD_NUMBER = 20;
  /**
   *
   *
   * <pre>
   * The UndeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;</code>
   *
   * @return Whether the undeletePhraseSetRequest field is set.
   */
  @java.lang.Override
  public boolean hasUndeletePhraseSetRequest() {
    return requestCase_ == 20;
  }
  /**
   *
   *
   * <pre>
   * The UndeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;</code>
   *
   * @return The undeletePhraseSetRequest.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UndeletePhraseSetRequest getUndeletePhraseSetRequest() {
    if (requestCase_ == 20) {
      return (com.google.cloud.speech.v2.UndeletePhraseSetRequest) request_;
    }
    return com.google.cloud.speech.v2.UndeletePhraseSetRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The UndeletePhraseSetRequest that spawned the Operation.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.UndeletePhraseSetRequestOrBuilder
      getUndeletePhraseSetRequestOrBuilder() {
    if (requestCase_ == 20) {
      return (com.google.cloud.speech.v2.UndeletePhraseSetRequest) request_;
    }
    return com.google.cloud.speech.v2.UndeletePhraseSetRequest.getDefaultInstance();
  }

  public static final int UPDATE_CONFIG_REQUEST_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * The UpdateConfigRequest that spawned the Operation.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.speech.v2.OperationMetadata.update_config_request is deprecated. See
   *     google/cloud/speech/v2/cloud_speech.proto;l=420
   * @return Whether the updateConfigRequest field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasUpdateConfigRequest() {
    return requestCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * The UpdateConfigRequest that spawned the Operation.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.speech.v2.OperationMetadata.update_config_request is deprecated. See
   *     google/cloud/speech/v2/cloud_speech.proto;l=420
   * @return The updateConfigRequest.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.speech.v2.UpdateConfigRequest getUpdateConfigRequest() {
    if (requestCase_ == 21) {
      return (com.google.cloud.speech.v2.UpdateConfigRequest) request_;
    }
    return com.google.cloud.speech.v2.UpdateConfigRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The UpdateConfigRequest that spawned the Operation.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.speech.v2.UpdateConfigRequestOrBuilder getUpdateConfigRequestOrBuilder() {
    if (requestCase_ == 21) {
      return (com.google.cloud.speech.v2.UpdateConfigRequest) request_;
    }
    return com.google.cloud.speech.v2.UpdateConfigRequest.getDefaultInstance();
  }

  public static final int PROGRESS_PERCENT_FIELD_NUMBER = 22;
  private int progressPercent_ = 0;
  /**
   *
   *
   * <pre>
   * The percent progress of the Operation. Values can range from 0-100. If the
   * value is 100, then the operation is finished.
   * </pre>
   *
   * <code>int32 progress_percent = 22;</code>
   *
   * @return The progressPercent.
   */
  @java.lang.Override
  public int getProgressPercent() {
    return progressPercent_;
  }

  public static final int BATCH_RECOGNIZE_METADATA_FIELD_NUMBER = 23;
  /**
   *
   *
   * <pre>
   * Metadata specific to the BatchRecognize method.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
   *
   * @return Whether the batchRecognizeMetadata field is set.
   */
  @java.lang.Override
  public boolean hasBatchRecognizeMetadata() {
    return metadataCase_ == 23;
  }
  /**
   *
   *
   * <pre>
   * Metadata specific to the BatchRecognize method.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
   *
   * @return The batchRecognizeMetadata.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeMetadata getBatchRecognizeMetadata() {
    if (metadataCase_ == 23) {
      return (com.google.cloud.speech.v2.BatchRecognizeMetadata) metadata_;
    }
    return com.google.cloud.speech.v2.BatchRecognizeMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata specific to the BatchRecognize method.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeMetadataOrBuilder
      getBatchRecognizeMetadataOrBuilder() {
    if (metadataCase_ == 23) {
      return (com.google.cloud.speech.v2.BatchRecognizeMetadata) metadata_;
    }
    return com.google.cloud.speech.v2.BatchRecognizeMetadata.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(method_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, method_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersionName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, kmsKeyVersionName_);
    }
    if (requestCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.speech.v2.BatchRecognizeRequest) request_);
    }
    if (requestCase_ == 9) {
      output.writeMessage(9, (com.google.cloud.speech.v2.CreateRecognizerRequest) request_);
    }
    if (requestCase_ == 10) {
      output.writeMessage(10, (com.google.cloud.speech.v2.UpdateRecognizerRequest) request_);
    }
    if (requestCase_ == 11) {
      output.writeMessage(11, (com.google.cloud.speech.v2.DeleteRecognizerRequest) request_);
    }
    if (requestCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.speech.v2.UndeleteRecognizerRequest) request_);
    }
    if (requestCase_ == 13) {
      output.writeMessage(13, (com.google.cloud.speech.v2.CreateCustomClassRequest) request_);
    }
    if (requestCase_ == 14) {
      output.writeMessage(14, (com.google.cloud.speech.v2.UpdateCustomClassRequest) request_);
    }
    if (requestCase_ == 15) {
      output.writeMessage(15, (com.google.cloud.speech.v2.DeleteCustomClassRequest) request_);
    }
    if (requestCase_ == 16) {
      output.writeMessage(16, (com.google.cloud.speech.v2.UndeleteCustomClassRequest) request_);
    }
    if (requestCase_ == 17) {
      output.writeMessage(17, (com.google.cloud.speech.v2.CreatePhraseSetRequest) request_);
    }
    if (requestCase_ == 18) {
      output.writeMessage(18, (com.google.cloud.speech.v2.UpdatePhraseSetRequest) request_);
    }
    if (requestCase_ == 19) {
      output.writeMessage(19, (com.google.cloud.speech.v2.DeletePhraseSetRequest) request_);
    }
    if (requestCase_ == 20) {
      output.writeMessage(20, (com.google.cloud.speech.v2.UndeletePhraseSetRequest) request_);
    }
    if (requestCase_ == 21) {
      output.writeMessage(21, (com.google.cloud.speech.v2.UpdateConfigRequest) request_);
    }
    if (progressPercent_ != 0) {
      output.writeInt32(22, progressPercent_);
    }
    if (metadataCase_ == 23) {
      output.writeMessage(23, (com.google.cloud.speech.v2.BatchRecognizeMetadata) metadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, resource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(method_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, method_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersionName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, kmsKeyVersionName_);
    }
    if (requestCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.speech.v2.BatchRecognizeRequest) request_);
    }
    if (requestCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.speech.v2.CreateRecognizerRequest) request_);
    }
    if (requestCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.speech.v2.UpdateRecognizerRequest) request_);
    }
    if (requestCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.speech.v2.DeleteRecognizerRequest) request_);
    }
    if (requestCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.speech.v2.UndeleteRecognizerRequest) request_);
    }
    if (requestCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.speech.v2.CreateCustomClassRequest) request_);
    }
    if (requestCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.speech.v2.UpdateCustomClassRequest) request_);
    }
    if (requestCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.speech.v2.DeleteCustomClassRequest) request_);
    }
    if (requestCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, (com.google.cloud.speech.v2.UndeleteCustomClassRequest) request_);
    }
    if (requestCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.cloud.speech.v2.CreatePhraseSetRequest) request_);
    }
    if (requestCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, (com.google.cloud.speech.v2.UpdatePhraseSetRequest) request_);
    }
    if (requestCase_ == 19) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, (com.google.cloud.speech.v2.DeletePhraseSetRequest) request_);
    }
    if (requestCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, (com.google.cloud.speech.v2.UndeletePhraseSetRequest) request_);
    }
    if (requestCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.cloud.speech.v2.UpdateConfigRequest) request_);
    }
    if (progressPercent_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(22, progressPercent_);
    }
    if (metadataCase_ == 23) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23, (com.google.cloud.speech.v2.BatchRecognizeMetadata) metadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.OperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.OperationMetadata other =
        (com.google.cloud.speech.v2.OperationMetadata) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getResource().equals(other.getResource())) return false;
    if (!getMethod().equals(other.getMethod())) return false;
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (!getKmsKeyVersionName().equals(other.getKmsKeyVersionName())) return false;
    if (getProgressPercent() != other.getProgressPercent()) return false;
    if (!getRequestCase().equals(other.getRequestCase())) return false;
    switch (requestCase_) {
      case 8:
        if (!getBatchRecognizeRequest().equals(other.getBatchRecognizeRequest())) return false;
        break;
      case 9:
        if (!getCreateRecognizerRequest().equals(other.getCreateRecognizerRequest())) return false;
        break;
      case 10:
        if (!getUpdateRecognizerRequest().equals(other.getUpdateRecognizerRequest())) return false;
        break;
      case 11:
        if (!getDeleteRecognizerRequest().equals(other.getDeleteRecognizerRequest())) return false;
        break;
      case 12:
        if (!getUndeleteRecognizerRequest().equals(other.getUndeleteRecognizerRequest()))
          return false;
        break;
      case 13:
        if (!getCreateCustomClassRequest().equals(other.getCreateCustomClassRequest()))
          return false;
        break;
      case 14:
        if (!getUpdateCustomClassRequest().equals(other.getUpdateCustomClassRequest()))
          return false;
        break;
      case 15:
        if (!getDeleteCustomClassRequest().equals(other.getDeleteCustomClassRequest()))
          return false;
        break;
      case 16:
        if (!getUndeleteCustomClassRequest().equals(other.getUndeleteCustomClassRequest()))
          return false;
        break;
      case 17:
        if (!getCreatePhraseSetRequest().equals(other.getCreatePhraseSetRequest())) return false;
        break;
      case 18:
        if (!getUpdatePhraseSetRequest().equals(other.getUpdatePhraseSetRequest())) return false;
        break;
      case 19:
        if (!getDeletePhraseSetRequest().equals(other.getDeletePhraseSetRequest())) return false;
        break;
      case 20:
        if (!getUndeletePhraseSetRequest().equals(other.getUndeletePhraseSetRequest()))
          return false;
        break;
      case 21:
        if (!getUpdateConfigRequest().equals(other.getUpdateConfigRequest())) return false;
        break;
      case 0:
      default:
    }
    if (!getMetadataCase().equals(other.getMetadataCase())) return false;
    switch (metadataCase_) {
      case 23:
        if (!getBatchRecognizeMetadata().equals(other.getBatchRecognizeMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getResource().hashCode();
    hash = (37 * hash) + METHOD_FIELD_NUMBER;
    hash = (53 * hash) + getMethod().hashCode();
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    hash = (37 * hash) + KMS_KEY_VERSION_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyVersionName().hashCode();
    hash = (37 * hash) + PROGRESS_PERCENT_FIELD_NUMBER;
    hash = (53 * hash) + getProgressPercent();
    switch (requestCase_) {
      case 8:
        hash = (37 * hash) + BATCH_RECOGNIZE_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getBatchRecognizeRequest().hashCode();
        break;
      case 9:
        hash = (37 * hash) + CREATE_RECOGNIZER_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getCreateRecognizerRequest().hashCode();
        break;
      case 10:
        hash = (37 * hash) + UPDATE_RECOGNIZER_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateRecognizerRequest().hashCode();
        break;
      case 11:
        hash = (37 * hash) + DELETE_RECOGNIZER_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteRecognizerRequest().hashCode();
        break;
      case 12:
        hash = (37 * hash) + UNDELETE_RECOGNIZER_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getUndeleteRecognizerRequest().hashCode();
        break;
      case 13:
        hash = (37 * hash) + CREATE_CUSTOM_CLASS_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getCreateCustomClassRequest().hashCode();
        break;
      case 14:
        hash = (37 * hash) + UPDATE_CUSTOM_CLASS_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateCustomClassRequest().hashCode();
        break;
      case 15:
        hash = (37 * hash) + DELETE_CUSTOM_CLASS_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteCustomClassRequest().hashCode();
        break;
      case 16:
        hash = (37 * hash) + UNDELETE_CUSTOM_CLASS_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getUndeleteCustomClassRequest().hashCode();
        break;
      case 17:
        hash = (37 * hash) + CREATE_PHRASE_SET_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getCreatePhraseSetRequest().hashCode();
        break;
      case 18:
        hash = (37 * hash) + UPDATE_PHRASE_SET_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getUpdatePhraseSetRequest().hashCode();
        break;
      case 19:
        hash = (37 * hash) + DELETE_PHRASE_SET_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getDeletePhraseSetRequest().hashCode();
        break;
      case 20:
        hash = (37 * hash) + UNDELETE_PHRASE_SET_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getUndeletePhraseSetRequest().hashCode();
        break;
      case 21:
        hash = (37 * hash) + UPDATE_CONFIG_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateConfigRequest().hashCode();
        break;
      case 0:
      default:
    }
    switch (metadataCase_) {
      case 23:
        hash = (37 * hash) + BATCH_RECOGNIZE_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getBatchRecognizeMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.OperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v2.OperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the metadata of a long-running operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.OperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.OperationMetadata)
      com.google.cloud.speech.v2.OperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_OperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_OperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.OperationMetadata.class,
              com.google.cloud.speech.v2.OperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.OperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      resource_ = "";
      method_ = "";
      kmsKeyName_ = "";
      kmsKeyVersionName_ = "";
      if (batchRecognizeRequestBuilder_ != null) {
        batchRecognizeRequestBuilder_.clear();
      }
      if (createRecognizerRequestBuilder_ != null) {
        createRecognizerRequestBuilder_.clear();
      }
      if (updateRecognizerRequestBuilder_ != null) {
        updateRecognizerRequestBuilder_.clear();
      }
      if (deleteRecognizerRequestBuilder_ != null) {
        deleteRecognizerRequestBuilder_.clear();
      }
      if (undeleteRecognizerRequestBuilder_ != null) {
        undeleteRecognizerRequestBuilder_.clear();
      }
      if (createCustomClassRequestBuilder_ != null) {
        createCustomClassRequestBuilder_.clear();
      }
      if (updateCustomClassRequestBuilder_ != null) {
        updateCustomClassRequestBuilder_.clear();
      }
      if (deleteCustomClassRequestBuilder_ != null) {
        deleteCustomClassRequestBuilder_.clear();
      }
      if (undeleteCustomClassRequestBuilder_ != null) {
        undeleteCustomClassRequestBuilder_.clear();
      }
      if (createPhraseSetRequestBuilder_ != null) {
        createPhraseSetRequestBuilder_.clear();
      }
      if (updatePhraseSetRequestBuilder_ != null) {
        updatePhraseSetRequestBuilder_.clear();
      }
      if (deletePhraseSetRequestBuilder_ != null) {
        deletePhraseSetRequestBuilder_.clear();
      }
      if (undeletePhraseSetRequestBuilder_ != null) {
        undeletePhraseSetRequestBuilder_.clear();
      }
      if (updateConfigRequestBuilder_ != null) {
        updateConfigRequestBuilder_.clear();
      }
      progressPercent_ = 0;
      if (batchRecognizeMetadataBuilder_ != null) {
        batchRecognizeMetadataBuilder_.clear();
      }
      requestCase_ = 0;
      request_ = null;
      metadataCase_ = 0;
      metadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_OperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.OperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.OperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.OperationMetadata build() {
      com.google.cloud.speech.v2.OperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.OperationMetadata buildPartial() {
      com.google.cloud.speech.v2.OperationMetadata result =
          new com.google.cloud.speech.v2.OperationMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.speech.v2.OperationMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resource_ = resource_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.method_ = method_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.kmsKeyVersionName_ = kmsKeyVersionName_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.progressPercent_ = progressPercent_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.speech.v2.OperationMetadata result) {
      result.requestCase_ = requestCase_;
      result.request_ = this.request_;
      if (requestCase_ == 8 && batchRecognizeRequestBuilder_ != null) {
        result.request_ = batchRecognizeRequestBuilder_.build();
      }
      if (requestCase_ == 9 && createRecognizerRequestBuilder_ != null) {
        result.request_ = createRecognizerRequestBuilder_.build();
      }
      if (requestCase_ == 10 && updateRecognizerRequestBuilder_ != null) {
        result.request_ = updateRecognizerRequestBuilder_.build();
      }
      if (requestCase_ == 11 && deleteRecognizerRequestBuilder_ != null) {
        result.request_ = deleteRecognizerRequestBuilder_.build();
      }
      if (requestCase_ == 12 && undeleteRecognizerRequestBuilder_ != null) {
        result.request_ = undeleteRecognizerRequestBuilder_.build();
      }
      if (requestCase_ == 13 && createCustomClassRequestBuilder_ != null) {
        result.request_ = createCustomClassRequestBuilder_.build();
      }
      if (requestCase_ == 14 && updateCustomClassRequestBuilder_ != null) {
        result.request_ = updateCustomClassRequestBuilder_.build();
      }
      if (requestCase_ == 15 && deleteCustomClassRequestBuilder_ != null) {
        result.request_ = deleteCustomClassRequestBuilder_.build();
      }
      if (requestCase_ == 16 && undeleteCustomClassRequestBuilder_ != null) {
        result.request_ = undeleteCustomClassRequestBuilder_.build();
      }
      if (requestCase_ == 17 && createPhraseSetRequestBuilder_ != null) {
        result.request_ = createPhraseSetRequestBuilder_.build();
      }
      if (requestCase_ == 18 && updatePhraseSetRequestBuilder_ != null) {
        result.request_ = updatePhraseSetRequestBuilder_.build();
      }
      if (requestCase_ == 19 && deletePhraseSetRequestBuilder_ != null) {
        result.request_ = deletePhraseSetRequestBuilder_.build();
      }
      if (requestCase_ == 20 && undeletePhraseSetRequestBuilder_ != null) {
        result.request_ = undeletePhraseSetRequestBuilder_.build();
      }
      if (requestCase_ == 21 && updateConfigRequestBuilder_ != null) {
        result.request_ = updateConfigRequestBuilder_.build();
      }
      result.metadataCase_ = metadataCase_;
      result.metadata_ = this.metadata_;
      if (metadataCase_ == 23 && batchRecognizeMetadataBuilder_ != null) {
        result.metadata_ = batchRecognizeMetadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.OperationMetadata) {
        return mergeFrom((com.google.cloud.speech.v2.OperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.OperationMetadata other) {
      if (other == com.google.cloud.speech.v2.OperationMetadata.getDefaultInstance()) return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getResource().isEmpty()) {
        resource_ = other.resource_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getMethod().isEmpty()) {
        method_ = other.method_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getKmsKeyVersionName().isEmpty()) {
        kmsKeyVersionName_ = other.kmsKeyVersionName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getProgressPercent() != 0) {
        setProgressPercent(other.getProgressPercent());
      }
      switch (other.getRequestCase()) {
        case BATCH_RECOGNIZE_REQUEST:
          {
            mergeBatchRecognizeRequest(other.getBatchRecognizeRequest());
            break;
          }
        case CREATE_RECOGNIZER_REQUEST:
          {
            mergeCreateRecognizerRequest(other.getCreateRecognizerRequest());
            break;
          }
        case UPDATE_RECOGNIZER_REQUEST:
          {
            mergeUpdateRecognizerRequest(other.getUpdateRecognizerRequest());
            break;
          }
        case DELETE_RECOGNIZER_REQUEST:
          {
            mergeDeleteRecognizerRequest(other.getDeleteRecognizerRequest());
            break;
          }
        case UNDELETE_RECOGNIZER_REQUEST:
          {
            mergeUndeleteRecognizerRequest(other.getUndeleteRecognizerRequest());
            break;
          }
        case CREATE_CUSTOM_CLASS_REQUEST:
          {
            mergeCreateCustomClassRequest(other.getCreateCustomClassRequest());
            break;
          }
        case UPDATE_CUSTOM_CLASS_REQUEST:
          {
            mergeUpdateCustomClassRequest(other.getUpdateCustomClassRequest());
            break;
          }
        case DELETE_CUSTOM_CLASS_REQUEST:
          {
            mergeDeleteCustomClassRequest(other.getDeleteCustomClassRequest());
            break;
          }
        case UNDELETE_CUSTOM_CLASS_REQUEST:
          {
            mergeUndeleteCustomClassRequest(other.getUndeleteCustomClassRequest());
            break;
          }
        case CREATE_PHRASE_SET_REQUEST:
          {
            mergeCreatePhraseSetRequest(other.getCreatePhraseSetRequest());
            break;
          }
        case UPDATE_PHRASE_SET_REQUEST:
          {
            mergeUpdatePhraseSetRequest(other.getUpdatePhraseSetRequest());
            break;
          }
        case DELETE_PHRASE_SET_REQUEST:
          {
            mergeDeletePhraseSetRequest(other.getDeletePhraseSetRequest());
            break;
          }
        case UNDELETE_PHRASE_SET_REQUEST:
          {
            mergeUndeletePhraseSetRequest(other.getUndeletePhraseSetRequest());
            break;
          }
        case UPDATE_CONFIG_REQUEST:
          {
            mergeUpdateConfigRequest(other.getUpdateConfigRequest());
            break;
          }
        case REQUEST_NOT_SET:
          {
            break;
          }
      }
      switch (other.getMetadataCase()) {
        case BATCH_RECOGNIZE_METADATA:
          {
            mergeBatchRecognizeMetadata(other.getBatchRecognizeMetadata());
            break;
          }
        case METADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                resource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                method_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                kmsKeyVersionName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getBatchRecognizeRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getCreateRecognizerRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getUpdateRecognizerRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getDeleteRecognizerRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getUndeleteRecognizerRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getCreateCustomClassRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getUpdateCustomClassRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getDeleteCustomClassRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(
                    getUndeleteCustomClassRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 16;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(
                    getCreatePhraseSetRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getUpdatePhraseSetRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 18;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getDeletePhraseSetRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 19;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getUndeletePhraseSetRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 20;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(
                    getUpdateConfigRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 21;
                break;
              } // case 170
            case 176:
              {
                progressPercent_ = input.readInt32();
                bitField0_ |= 0x00100000;
                break;
              } // case 176
            case 186:
              {
                input.readMessage(
                    getBatchRecognizeMetadataFieldBuilder().getBuilder(), extensionRegistry);
                metadataCase_ = 23;
                break;
              } // case 186
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int requestCase_ = 0;
    private java.lang.Object request_;

    public RequestCase getRequestCase() {
      return RequestCase.forNumber(requestCase_);
    }

    public Builder clearRequest() {
      requestCase_ = 0;
      request_ = null;
      onChanged();
      return this;
    }

    private int metadataCase_ = 0;
    private java.lang.Object metadata_;

    public MetadataCase getMetadataCase() {
      return MetadataCase.forNumber(metadataCase_);
    }

    public Builder clearMetadata() {
      metadataCase_ = 0;
      metadata_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the operation was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the operation was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the operation was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation was last updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object resource_ = "";
    /**
     *
     *
     * <pre>
     * The resource path for the target of the operation.
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @return The resource.
     */
    public java.lang.String getResource() {
      java.lang.Object ref = resource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource path for the target of the operation.
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @return The bytes for resource.
     */
    public com.google.protobuf.ByteString getResourceBytes() {
      java.lang.Object ref = resource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource path for the target of the operation.
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @param value The resource to set.
     * @return This builder for chaining.
     */
    public Builder setResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resource_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource path for the target of the operation.
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResource() {
      resource_ = getDefaultInstance().getResource();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource path for the target of the operation.
     * </pre>
     *
     * <code>string resource = 3;</code>
     *
     * @param value The bytes for resource to set.
     * @return This builder for chaining.
     */
    public Builder setResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resource_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object method_ = "";
    /**
     *
     *
     * <pre>
     * The method that triggered the operation.
     * </pre>
     *
     * <code>string method = 4;</code>
     *
     * @return The method.
     */
    public java.lang.String getMethod() {
      java.lang.Object ref = method_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        method_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The method that triggered the operation.
     * </pre>
     *
     * <code>string method = 4;</code>
     *
     * @return The bytes for method.
     */
    public com.google.protobuf.ByteString getMethodBytes() {
      java.lang.Object ref = method_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        method_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The method that triggered the operation.
     * </pre>
     *
     * <code>string method = 4;</code>
     *
     * @param value The method to set.
     * @return This builder for chaining.
     */
    public Builder setMethod(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      method_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The method that triggered the operation.
     * </pre>
     *
     * <code>string method = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMethod() {
      method_ = getDefaultInstance().getMethod();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The method that triggered the operation.
     * </pre>
     *
     * <code>string method = 4;</code>
     *
     * @param value The bytes for method to set.
     * @return This builder for chaining.
     */
    public Builder setMethodBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      method_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [KMS key
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
     * the content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyVersionName_ = "";
    /**
     *
     *
     * <pre>
     * The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     * </pre>
     *
     * <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The kmsKeyVersionName.
     */
    public java.lang.String getKmsKeyVersionName() {
      java.lang.Object ref = kmsKeyVersionName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyVersionName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     * </pre>
     *
     * <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for kmsKeyVersionName.
     */
    public com.google.protobuf.ByteString getKmsKeyVersionNameBytes() {
      java.lang.Object ref = kmsKeyVersionName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyVersionName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     * </pre>
     *
     * <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The kmsKeyVersionName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersionName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyVersionName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     * </pre>
     *
     * <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyVersionName() {
      kmsKeyVersionName_ = getDefaultInstance().getKmsKeyVersionName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [KMS key version
     * name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
     * with which content of the Operation is encrypted. The expected format is
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
     * </pre>
     *
     * <code>string kms_key_version_name = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for kmsKeyVersionName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersionNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyVersionName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.BatchRecognizeRequest,
            com.google.cloud.speech.v2.BatchRecognizeRequest.Builder,
            com.google.cloud.speech.v2.BatchRecognizeRequestOrBuilder>
        batchRecognizeRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The BatchRecognizeRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
     *
     * @return Whether the batchRecognizeRequest field is set.
     */
    @java.lang.Override
    public boolean hasBatchRecognizeRequest() {
      return requestCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * The BatchRecognizeRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
     *
     * @return The batchRecognizeRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeRequest getBatchRecognizeRequest() {
      if (batchRecognizeRequestBuilder_ == null) {
        if (requestCase_ == 8) {
          return (com.google.cloud.speech.v2.BatchRecognizeRequest) request_;
        }
        return com.google.cloud.speech.v2.BatchRecognizeRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 8) {
          return batchRecognizeRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.BatchRecognizeRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The BatchRecognizeRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
     */
    public Builder setBatchRecognizeRequest(
        com.google.cloud.speech.v2.BatchRecognizeRequest value) {
      if (batchRecognizeRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        batchRecognizeRequestBuilder_.setMessage(value);
      }
      requestCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BatchRecognizeRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
     */
    public Builder setBatchRecognizeRequest(
        com.google.cloud.speech.v2.BatchRecognizeRequest.Builder builderForValue) {
      if (batchRecognizeRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        batchRecognizeRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BatchRecognizeRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
     */
    public Builder mergeBatchRecognizeRequest(
        com.google.cloud.speech.v2.BatchRecognizeRequest value) {
      if (batchRecognizeRequestBuilder_ == null) {
        if (requestCase_ == 8
            && request_ != com.google.cloud.speech.v2.BatchRecognizeRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.BatchRecognizeRequest.newBuilder(
                      (com.google.cloud.speech.v2.BatchRecognizeRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 8) {
          batchRecognizeRequestBuilder_.mergeFrom(value);
        } else {
          batchRecognizeRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BatchRecognizeRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
     */
    public Builder clearBatchRecognizeRequest() {
      if (batchRecognizeRequestBuilder_ == null) {
        if (requestCase_ == 8) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 8) {
          requestCase_ = 0;
          request_ = null;
        }
        batchRecognizeRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The BatchRecognizeRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
     */
    public com.google.cloud.speech.v2.BatchRecognizeRequest.Builder
        getBatchRecognizeRequestBuilder() {
      return getBatchRecognizeRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The BatchRecognizeRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeRequestOrBuilder
        getBatchRecognizeRequestOrBuilder() {
      if ((requestCase_ == 8) && (batchRecognizeRequestBuilder_ != null)) {
        return batchRecognizeRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 8) {
          return (com.google.cloud.speech.v2.BatchRecognizeRequest) request_;
        }
        return com.google.cloud.speech.v2.BatchRecognizeRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The BatchRecognizeRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeRequest batch_recognize_request = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.BatchRecognizeRequest,
            com.google.cloud.speech.v2.BatchRecognizeRequest.Builder,
            com.google.cloud.speech.v2.BatchRecognizeRequestOrBuilder>
        getBatchRecognizeRequestFieldBuilder() {
      if (batchRecognizeRequestBuilder_ == null) {
        if (!(requestCase_ == 8)) {
          request_ = com.google.cloud.speech.v2.BatchRecognizeRequest.getDefaultInstance();
        }
        batchRecognizeRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.BatchRecognizeRequest,
                com.google.cloud.speech.v2.BatchRecognizeRequest.Builder,
                com.google.cloud.speech.v2.BatchRecognizeRequestOrBuilder>(
                (com.google.cloud.speech.v2.BatchRecognizeRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 8;
      onChanged();
      return batchRecognizeRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.CreateRecognizerRequest,
            com.google.cloud.speech.v2.CreateRecognizerRequest.Builder,
            com.google.cloud.speech.v2.CreateRecognizerRequestOrBuilder>
        createRecognizerRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The CreateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
     *
     * @return Whether the createRecognizerRequest field is set.
     */
    @java.lang.Override
    public boolean hasCreateRecognizerRequest() {
      return requestCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * The CreateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
     *
     * @return The createRecognizerRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.CreateRecognizerRequest getCreateRecognizerRequest() {
      if (createRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 9) {
          return (com.google.cloud.speech.v2.CreateRecognizerRequest) request_;
        }
        return com.google.cloud.speech.v2.CreateRecognizerRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 9) {
          return createRecognizerRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.CreateRecognizerRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The CreateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
     */
    public Builder setCreateRecognizerRequest(
        com.google.cloud.speech.v2.CreateRecognizerRequest value) {
      if (createRecognizerRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        createRecognizerRequestBuilder_.setMessage(value);
      }
      requestCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
     */
    public Builder setCreateRecognizerRequest(
        com.google.cloud.speech.v2.CreateRecognizerRequest.Builder builderForValue) {
      if (createRecognizerRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        createRecognizerRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
     */
    public Builder mergeCreateRecognizerRequest(
        com.google.cloud.speech.v2.CreateRecognizerRequest value) {
      if (createRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 9
            && request_
                != com.google.cloud.speech.v2.CreateRecognizerRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.CreateRecognizerRequest.newBuilder(
                      (com.google.cloud.speech.v2.CreateRecognizerRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 9) {
          createRecognizerRequestBuilder_.mergeFrom(value);
        } else {
          createRecognizerRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
     */
    public Builder clearCreateRecognizerRequest() {
      if (createRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 9) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 9) {
          requestCase_ = 0;
          request_ = null;
        }
        createRecognizerRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
     */
    public com.google.cloud.speech.v2.CreateRecognizerRequest.Builder
        getCreateRecognizerRequestBuilder() {
      return getCreateRecognizerRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The CreateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.CreateRecognizerRequestOrBuilder
        getCreateRecognizerRequestOrBuilder() {
      if ((requestCase_ == 9) && (createRecognizerRequestBuilder_ != null)) {
        return createRecognizerRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 9) {
          return (com.google.cloud.speech.v2.CreateRecognizerRequest) request_;
        }
        return com.google.cloud.speech.v2.CreateRecognizerRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The CreateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateRecognizerRequest create_recognizer_request = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.CreateRecognizerRequest,
            com.google.cloud.speech.v2.CreateRecognizerRequest.Builder,
            com.google.cloud.speech.v2.CreateRecognizerRequestOrBuilder>
        getCreateRecognizerRequestFieldBuilder() {
      if (createRecognizerRequestBuilder_ == null) {
        if (!(requestCase_ == 9)) {
          request_ = com.google.cloud.speech.v2.CreateRecognizerRequest.getDefaultInstance();
        }
        createRecognizerRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.CreateRecognizerRequest,
                com.google.cloud.speech.v2.CreateRecognizerRequest.Builder,
                com.google.cloud.speech.v2.CreateRecognizerRequestOrBuilder>(
                (com.google.cloud.speech.v2.CreateRecognizerRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 9;
      onChanged();
      return createRecognizerRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UpdateRecognizerRequest,
            com.google.cloud.speech.v2.UpdateRecognizerRequest.Builder,
            com.google.cloud.speech.v2.UpdateRecognizerRequestOrBuilder>
        updateRecognizerRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The UpdateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
     *
     * @return Whether the updateRecognizerRequest field is set.
     */
    @java.lang.Override
    public boolean hasUpdateRecognizerRequest() {
      return requestCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * The UpdateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
     *
     * @return The updateRecognizerRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UpdateRecognizerRequest getUpdateRecognizerRequest() {
      if (updateRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 10) {
          return (com.google.cloud.speech.v2.UpdateRecognizerRequest) request_;
        }
        return com.google.cloud.speech.v2.UpdateRecognizerRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 10) {
          return updateRecognizerRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.UpdateRecognizerRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UpdateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
     */
    public Builder setUpdateRecognizerRequest(
        com.google.cloud.speech.v2.UpdateRecognizerRequest value) {
      if (updateRecognizerRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        updateRecognizerRequestBuilder_.setMessage(value);
      }
      requestCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
     */
    public Builder setUpdateRecognizerRequest(
        com.google.cloud.speech.v2.UpdateRecognizerRequest.Builder builderForValue) {
      if (updateRecognizerRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        updateRecognizerRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
     */
    public Builder mergeUpdateRecognizerRequest(
        com.google.cloud.speech.v2.UpdateRecognizerRequest value) {
      if (updateRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 10
            && request_
                != com.google.cloud.speech.v2.UpdateRecognizerRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.UpdateRecognizerRequest.newBuilder(
                      (com.google.cloud.speech.v2.UpdateRecognizerRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 10) {
          updateRecognizerRequestBuilder_.mergeFrom(value);
        } else {
          updateRecognizerRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
     */
    public Builder clearUpdateRecognizerRequest() {
      if (updateRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 10) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 10) {
          requestCase_ = 0;
          request_ = null;
        }
        updateRecognizerRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
     */
    public com.google.cloud.speech.v2.UpdateRecognizerRequest.Builder
        getUpdateRecognizerRequestBuilder() {
      return getUpdateRecognizerRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The UpdateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UpdateRecognizerRequestOrBuilder
        getUpdateRecognizerRequestOrBuilder() {
      if ((requestCase_ == 10) && (updateRecognizerRequestBuilder_ != null)) {
        return updateRecognizerRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 10) {
          return (com.google.cloud.speech.v2.UpdateRecognizerRequest) request_;
        }
        return com.google.cloud.speech.v2.UpdateRecognizerRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UpdateRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateRecognizerRequest update_recognizer_request = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UpdateRecognizerRequest,
            com.google.cloud.speech.v2.UpdateRecognizerRequest.Builder,
            com.google.cloud.speech.v2.UpdateRecognizerRequestOrBuilder>
        getUpdateRecognizerRequestFieldBuilder() {
      if (updateRecognizerRequestBuilder_ == null) {
        if (!(requestCase_ == 10)) {
          request_ = com.google.cloud.speech.v2.UpdateRecognizerRequest.getDefaultInstance();
        }
        updateRecognizerRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.UpdateRecognizerRequest,
                com.google.cloud.speech.v2.UpdateRecognizerRequest.Builder,
                com.google.cloud.speech.v2.UpdateRecognizerRequestOrBuilder>(
                (com.google.cloud.speech.v2.UpdateRecognizerRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 10;
      onChanged();
      return updateRecognizerRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.DeleteRecognizerRequest,
            com.google.cloud.speech.v2.DeleteRecognizerRequest.Builder,
            com.google.cloud.speech.v2.DeleteRecognizerRequestOrBuilder>
        deleteRecognizerRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The DeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
     *
     * @return Whether the deleteRecognizerRequest field is set.
     */
    @java.lang.Override
    public boolean hasDeleteRecognizerRequest() {
      return requestCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * The DeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
     *
     * @return The deleteRecognizerRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.DeleteRecognizerRequest getDeleteRecognizerRequest() {
      if (deleteRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 11) {
          return (com.google.cloud.speech.v2.DeleteRecognizerRequest) request_;
        }
        return com.google.cloud.speech.v2.DeleteRecognizerRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 11) {
          return deleteRecognizerRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.DeleteRecognizerRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
     */
    public Builder setDeleteRecognizerRequest(
        com.google.cloud.speech.v2.DeleteRecognizerRequest value) {
      if (deleteRecognizerRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        deleteRecognizerRequestBuilder_.setMessage(value);
      }
      requestCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
     */
    public Builder setDeleteRecognizerRequest(
        com.google.cloud.speech.v2.DeleteRecognizerRequest.Builder builderForValue) {
      if (deleteRecognizerRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        deleteRecognizerRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
     */
    public Builder mergeDeleteRecognizerRequest(
        com.google.cloud.speech.v2.DeleteRecognizerRequest value) {
      if (deleteRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 11
            && request_
                != com.google.cloud.speech.v2.DeleteRecognizerRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.DeleteRecognizerRequest.newBuilder(
                      (com.google.cloud.speech.v2.DeleteRecognizerRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 11) {
          deleteRecognizerRequestBuilder_.mergeFrom(value);
        } else {
          deleteRecognizerRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
     */
    public Builder clearDeleteRecognizerRequest() {
      if (deleteRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 11) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 11) {
          requestCase_ = 0;
          request_ = null;
        }
        deleteRecognizerRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
     */
    public com.google.cloud.speech.v2.DeleteRecognizerRequest.Builder
        getDeleteRecognizerRequestBuilder() {
      return getDeleteRecognizerRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The DeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.DeleteRecognizerRequestOrBuilder
        getDeleteRecognizerRequestOrBuilder() {
      if ((requestCase_ == 11) && (deleteRecognizerRequestBuilder_ != null)) {
        return deleteRecognizerRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 11) {
          return (com.google.cloud.speech.v2.DeleteRecognizerRequest) request_;
        }
        return com.google.cloud.speech.v2.DeleteRecognizerRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteRecognizerRequest delete_recognizer_request = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.DeleteRecognizerRequest,
            com.google.cloud.speech.v2.DeleteRecognizerRequest.Builder,
            com.google.cloud.speech.v2.DeleteRecognizerRequestOrBuilder>
        getDeleteRecognizerRequestFieldBuilder() {
      if (deleteRecognizerRequestBuilder_ == null) {
        if (!(requestCase_ == 11)) {
          request_ = com.google.cloud.speech.v2.DeleteRecognizerRequest.getDefaultInstance();
        }
        deleteRecognizerRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.DeleteRecognizerRequest,
                com.google.cloud.speech.v2.DeleteRecognizerRequest.Builder,
                com.google.cloud.speech.v2.DeleteRecognizerRequestOrBuilder>(
                (com.google.cloud.speech.v2.DeleteRecognizerRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 11;
      onChanged();
      return deleteRecognizerRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UndeleteRecognizerRequest,
            com.google.cloud.speech.v2.UndeleteRecognizerRequest.Builder,
            com.google.cloud.speech.v2.UndeleteRecognizerRequestOrBuilder>
        undeleteRecognizerRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The UndeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
     * </code>
     *
     * @return Whether the undeleteRecognizerRequest field is set.
     */
    @java.lang.Override
    public boolean hasUndeleteRecognizerRequest() {
      return requestCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * The UndeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
     * </code>
     *
     * @return The undeleteRecognizerRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UndeleteRecognizerRequest getUndeleteRecognizerRequest() {
      if (undeleteRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 12) {
          return (com.google.cloud.speech.v2.UndeleteRecognizerRequest) request_;
        }
        return com.google.cloud.speech.v2.UndeleteRecognizerRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 12) {
          return undeleteRecognizerRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.UndeleteRecognizerRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UndeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
     * </code>
     */
    public Builder setUndeleteRecognizerRequest(
        com.google.cloud.speech.v2.UndeleteRecognizerRequest value) {
      if (undeleteRecognizerRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        undeleteRecognizerRequestBuilder_.setMessage(value);
      }
      requestCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
     * </code>
     */
    public Builder setUndeleteRecognizerRequest(
        com.google.cloud.speech.v2.UndeleteRecognizerRequest.Builder builderForValue) {
      if (undeleteRecognizerRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        undeleteRecognizerRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
     * </code>
     */
    public Builder mergeUndeleteRecognizerRequest(
        com.google.cloud.speech.v2.UndeleteRecognizerRequest value) {
      if (undeleteRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 12
            && request_
                != com.google.cloud.speech.v2.UndeleteRecognizerRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.UndeleteRecognizerRequest.newBuilder(
                      (com.google.cloud.speech.v2.UndeleteRecognizerRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 12) {
          undeleteRecognizerRequestBuilder_.mergeFrom(value);
        } else {
          undeleteRecognizerRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
     * </code>
     */
    public Builder clearUndeleteRecognizerRequest() {
      if (undeleteRecognizerRequestBuilder_ == null) {
        if (requestCase_ == 12) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 12) {
          requestCase_ = 0;
          request_ = null;
        }
        undeleteRecognizerRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
     * </code>
     */
    public com.google.cloud.speech.v2.UndeleteRecognizerRequest.Builder
        getUndeleteRecognizerRequestBuilder() {
      return getUndeleteRecognizerRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The UndeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UndeleteRecognizerRequestOrBuilder
        getUndeleteRecognizerRequestOrBuilder() {
      if ((requestCase_ == 12) && (undeleteRecognizerRequestBuilder_ != null)) {
        return undeleteRecognizerRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 12) {
          return (com.google.cloud.speech.v2.UndeleteRecognizerRequest) request_;
        }
        return com.google.cloud.speech.v2.UndeleteRecognizerRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UndeleteRecognizerRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteRecognizerRequest undelete_recognizer_request = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UndeleteRecognizerRequest,
            com.google.cloud.speech.v2.UndeleteRecognizerRequest.Builder,
            com.google.cloud.speech.v2.UndeleteRecognizerRequestOrBuilder>
        getUndeleteRecognizerRequestFieldBuilder() {
      if (undeleteRecognizerRequestBuilder_ == null) {
        if (!(requestCase_ == 12)) {
          request_ = com.google.cloud.speech.v2.UndeleteRecognizerRequest.getDefaultInstance();
        }
        undeleteRecognizerRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.UndeleteRecognizerRequest,
                com.google.cloud.speech.v2.UndeleteRecognizerRequest.Builder,
                com.google.cloud.speech.v2.UndeleteRecognizerRequestOrBuilder>(
                (com.google.cloud.speech.v2.UndeleteRecognizerRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 12;
      onChanged();
      return undeleteRecognizerRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.CreateCustomClassRequest,
            com.google.cloud.speech.v2.CreateCustomClassRequest.Builder,
            com.google.cloud.speech.v2.CreateCustomClassRequestOrBuilder>
        createCustomClassRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The CreateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;
     * </code>
     *
     * @return Whether the createCustomClassRequest field is set.
     */
    @java.lang.Override
    public boolean hasCreateCustomClassRequest() {
      return requestCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * The CreateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;
     * </code>
     *
     * @return The createCustomClassRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.CreateCustomClassRequest getCreateCustomClassRequest() {
      if (createCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 13) {
          return (com.google.cloud.speech.v2.CreateCustomClassRequest) request_;
        }
        return com.google.cloud.speech.v2.CreateCustomClassRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 13) {
          return createCustomClassRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.CreateCustomClassRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The CreateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;
     * </code>
     */
    public Builder setCreateCustomClassRequest(
        com.google.cloud.speech.v2.CreateCustomClassRequest value) {
      if (createCustomClassRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        createCustomClassRequestBuilder_.setMessage(value);
      }
      requestCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;
     * </code>
     */
    public Builder setCreateCustomClassRequest(
        com.google.cloud.speech.v2.CreateCustomClassRequest.Builder builderForValue) {
      if (createCustomClassRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        createCustomClassRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;
     * </code>
     */
    public Builder mergeCreateCustomClassRequest(
        com.google.cloud.speech.v2.CreateCustomClassRequest value) {
      if (createCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 13
            && request_
                != com.google.cloud.speech.v2.CreateCustomClassRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.CreateCustomClassRequest.newBuilder(
                      (com.google.cloud.speech.v2.CreateCustomClassRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 13) {
          createCustomClassRequestBuilder_.mergeFrom(value);
        } else {
          createCustomClassRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;
     * </code>
     */
    public Builder clearCreateCustomClassRequest() {
      if (createCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 13) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 13) {
          requestCase_ = 0;
          request_ = null;
        }
        createCustomClassRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;
     * </code>
     */
    public com.google.cloud.speech.v2.CreateCustomClassRequest.Builder
        getCreateCustomClassRequestBuilder() {
      return getCreateCustomClassRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The CreateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.CreateCustomClassRequestOrBuilder
        getCreateCustomClassRequestOrBuilder() {
      if ((requestCase_ == 13) && (createCustomClassRequestBuilder_ != null)) {
        return createCustomClassRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 13) {
          return (com.google.cloud.speech.v2.CreateCustomClassRequest) request_;
        }
        return com.google.cloud.speech.v2.CreateCustomClassRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The CreateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreateCustomClassRequest create_custom_class_request = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.CreateCustomClassRequest,
            com.google.cloud.speech.v2.CreateCustomClassRequest.Builder,
            com.google.cloud.speech.v2.CreateCustomClassRequestOrBuilder>
        getCreateCustomClassRequestFieldBuilder() {
      if (createCustomClassRequestBuilder_ == null) {
        if (!(requestCase_ == 13)) {
          request_ = com.google.cloud.speech.v2.CreateCustomClassRequest.getDefaultInstance();
        }
        createCustomClassRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.CreateCustomClassRequest,
                com.google.cloud.speech.v2.CreateCustomClassRequest.Builder,
                com.google.cloud.speech.v2.CreateCustomClassRequestOrBuilder>(
                (com.google.cloud.speech.v2.CreateCustomClassRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 13;
      onChanged();
      return createCustomClassRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UpdateCustomClassRequest,
            com.google.cloud.speech.v2.UpdateCustomClassRequest.Builder,
            com.google.cloud.speech.v2.UpdateCustomClassRequestOrBuilder>
        updateCustomClassRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The UpdateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;
     * </code>
     *
     * @return Whether the updateCustomClassRequest field is set.
     */
    @java.lang.Override
    public boolean hasUpdateCustomClassRequest() {
      return requestCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * The UpdateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;
     * </code>
     *
     * @return The updateCustomClassRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UpdateCustomClassRequest getUpdateCustomClassRequest() {
      if (updateCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 14) {
          return (com.google.cloud.speech.v2.UpdateCustomClassRequest) request_;
        }
        return com.google.cloud.speech.v2.UpdateCustomClassRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 14) {
          return updateCustomClassRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.UpdateCustomClassRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UpdateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;
     * </code>
     */
    public Builder setUpdateCustomClassRequest(
        com.google.cloud.speech.v2.UpdateCustomClassRequest value) {
      if (updateCustomClassRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        updateCustomClassRequestBuilder_.setMessage(value);
      }
      requestCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;
     * </code>
     */
    public Builder setUpdateCustomClassRequest(
        com.google.cloud.speech.v2.UpdateCustomClassRequest.Builder builderForValue) {
      if (updateCustomClassRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        updateCustomClassRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;
     * </code>
     */
    public Builder mergeUpdateCustomClassRequest(
        com.google.cloud.speech.v2.UpdateCustomClassRequest value) {
      if (updateCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 14
            && request_
                != com.google.cloud.speech.v2.UpdateCustomClassRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.UpdateCustomClassRequest.newBuilder(
                      (com.google.cloud.speech.v2.UpdateCustomClassRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 14) {
          updateCustomClassRequestBuilder_.mergeFrom(value);
        } else {
          updateCustomClassRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;
     * </code>
     */
    public Builder clearUpdateCustomClassRequest() {
      if (updateCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 14) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 14) {
          requestCase_ = 0;
          request_ = null;
        }
        updateCustomClassRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;
     * </code>
     */
    public com.google.cloud.speech.v2.UpdateCustomClassRequest.Builder
        getUpdateCustomClassRequestBuilder() {
      return getUpdateCustomClassRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The UpdateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UpdateCustomClassRequestOrBuilder
        getUpdateCustomClassRequestOrBuilder() {
      if ((requestCase_ == 14) && (updateCustomClassRequestBuilder_ != null)) {
        return updateCustomClassRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 14) {
          return (com.google.cloud.speech.v2.UpdateCustomClassRequest) request_;
        }
        return com.google.cloud.speech.v2.UpdateCustomClassRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UpdateCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdateCustomClassRequest update_custom_class_request = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UpdateCustomClassRequest,
            com.google.cloud.speech.v2.UpdateCustomClassRequest.Builder,
            com.google.cloud.speech.v2.UpdateCustomClassRequestOrBuilder>
        getUpdateCustomClassRequestFieldBuilder() {
      if (updateCustomClassRequestBuilder_ == null) {
        if (!(requestCase_ == 14)) {
          request_ = com.google.cloud.speech.v2.UpdateCustomClassRequest.getDefaultInstance();
        }
        updateCustomClassRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.UpdateCustomClassRequest,
                com.google.cloud.speech.v2.UpdateCustomClassRequest.Builder,
                com.google.cloud.speech.v2.UpdateCustomClassRequestOrBuilder>(
                (com.google.cloud.speech.v2.UpdateCustomClassRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 14;
      onChanged();
      return updateCustomClassRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.DeleteCustomClassRequest,
            com.google.cloud.speech.v2.DeleteCustomClassRequest.Builder,
            com.google.cloud.speech.v2.DeleteCustomClassRequestOrBuilder>
        deleteCustomClassRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The DeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;
     * </code>
     *
     * @return Whether the deleteCustomClassRequest field is set.
     */
    @java.lang.Override
    public boolean hasDeleteCustomClassRequest() {
      return requestCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * The DeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;
     * </code>
     *
     * @return The deleteCustomClassRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.DeleteCustomClassRequest getDeleteCustomClassRequest() {
      if (deleteCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 15) {
          return (com.google.cloud.speech.v2.DeleteCustomClassRequest) request_;
        }
        return com.google.cloud.speech.v2.DeleteCustomClassRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 15) {
          return deleteCustomClassRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.DeleteCustomClassRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;
     * </code>
     */
    public Builder setDeleteCustomClassRequest(
        com.google.cloud.speech.v2.DeleteCustomClassRequest value) {
      if (deleteCustomClassRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        deleteCustomClassRequestBuilder_.setMessage(value);
      }
      requestCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;
     * </code>
     */
    public Builder setDeleteCustomClassRequest(
        com.google.cloud.speech.v2.DeleteCustomClassRequest.Builder builderForValue) {
      if (deleteCustomClassRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        deleteCustomClassRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;
     * </code>
     */
    public Builder mergeDeleteCustomClassRequest(
        com.google.cloud.speech.v2.DeleteCustomClassRequest value) {
      if (deleteCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 15
            && request_
                != com.google.cloud.speech.v2.DeleteCustomClassRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.DeleteCustomClassRequest.newBuilder(
                      (com.google.cloud.speech.v2.DeleteCustomClassRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 15) {
          deleteCustomClassRequestBuilder_.mergeFrom(value);
        } else {
          deleteCustomClassRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;
     * </code>
     */
    public Builder clearDeleteCustomClassRequest() {
      if (deleteCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 15) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 15) {
          requestCase_ = 0;
          request_ = null;
        }
        deleteCustomClassRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;
     * </code>
     */
    public com.google.cloud.speech.v2.DeleteCustomClassRequest.Builder
        getDeleteCustomClassRequestBuilder() {
      return getDeleteCustomClassRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The DeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.DeleteCustomClassRequestOrBuilder
        getDeleteCustomClassRequestOrBuilder() {
      if ((requestCase_ == 15) && (deleteCustomClassRequestBuilder_ != null)) {
        return deleteCustomClassRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 15) {
          return (com.google.cloud.speech.v2.DeleteCustomClassRequest) request_;
        }
        return com.google.cloud.speech.v2.DeleteCustomClassRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeleteCustomClassRequest delete_custom_class_request = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.DeleteCustomClassRequest,
            com.google.cloud.speech.v2.DeleteCustomClassRequest.Builder,
            com.google.cloud.speech.v2.DeleteCustomClassRequestOrBuilder>
        getDeleteCustomClassRequestFieldBuilder() {
      if (deleteCustomClassRequestBuilder_ == null) {
        if (!(requestCase_ == 15)) {
          request_ = com.google.cloud.speech.v2.DeleteCustomClassRequest.getDefaultInstance();
        }
        deleteCustomClassRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.DeleteCustomClassRequest,
                com.google.cloud.speech.v2.DeleteCustomClassRequest.Builder,
                com.google.cloud.speech.v2.DeleteCustomClassRequestOrBuilder>(
                (com.google.cloud.speech.v2.DeleteCustomClassRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 15;
      onChanged();
      return deleteCustomClassRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UndeleteCustomClassRequest,
            com.google.cloud.speech.v2.UndeleteCustomClassRequest.Builder,
            com.google.cloud.speech.v2.UndeleteCustomClassRequestOrBuilder>
        undeleteCustomClassRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The UndeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
     * </code>
     *
     * @return Whether the undeleteCustomClassRequest field is set.
     */
    @java.lang.Override
    public boolean hasUndeleteCustomClassRequest() {
      return requestCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * The UndeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
     * </code>
     *
     * @return The undeleteCustomClassRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UndeleteCustomClassRequest getUndeleteCustomClassRequest() {
      if (undeleteCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 16) {
          return (com.google.cloud.speech.v2.UndeleteCustomClassRequest) request_;
        }
        return com.google.cloud.speech.v2.UndeleteCustomClassRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 16) {
          return undeleteCustomClassRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.UndeleteCustomClassRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UndeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
     * </code>
     */
    public Builder setUndeleteCustomClassRequest(
        com.google.cloud.speech.v2.UndeleteCustomClassRequest value) {
      if (undeleteCustomClassRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        undeleteCustomClassRequestBuilder_.setMessage(value);
      }
      requestCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
     * </code>
     */
    public Builder setUndeleteCustomClassRequest(
        com.google.cloud.speech.v2.UndeleteCustomClassRequest.Builder builderForValue) {
      if (undeleteCustomClassRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        undeleteCustomClassRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
     * </code>
     */
    public Builder mergeUndeleteCustomClassRequest(
        com.google.cloud.speech.v2.UndeleteCustomClassRequest value) {
      if (undeleteCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 16
            && request_
                != com.google.cloud.speech.v2.UndeleteCustomClassRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.UndeleteCustomClassRequest.newBuilder(
                      (com.google.cloud.speech.v2.UndeleteCustomClassRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 16) {
          undeleteCustomClassRequestBuilder_.mergeFrom(value);
        } else {
          undeleteCustomClassRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
     * </code>
     */
    public Builder clearUndeleteCustomClassRequest() {
      if (undeleteCustomClassRequestBuilder_ == null) {
        if (requestCase_ == 16) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 16) {
          requestCase_ = 0;
          request_ = null;
        }
        undeleteCustomClassRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
     * </code>
     */
    public com.google.cloud.speech.v2.UndeleteCustomClassRequest.Builder
        getUndeleteCustomClassRequestBuilder() {
      return getUndeleteCustomClassRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The UndeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UndeleteCustomClassRequestOrBuilder
        getUndeleteCustomClassRequestOrBuilder() {
      if ((requestCase_ == 16) && (undeleteCustomClassRequestBuilder_ != null)) {
        return undeleteCustomClassRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 16) {
          return (com.google.cloud.speech.v2.UndeleteCustomClassRequest) request_;
        }
        return com.google.cloud.speech.v2.UndeleteCustomClassRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UndeleteCustomClassRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeleteCustomClassRequest undelete_custom_class_request = 16;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UndeleteCustomClassRequest,
            com.google.cloud.speech.v2.UndeleteCustomClassRequest.Builder,
            com.google.cloud.speech.v2.UndeleteCustomClassRequestOrBuilder>
        getUndeleteCustomClassRequestFieldBuilder() {
      if (undeleteCustomClassRequestBuilder_ == null) {
        if (!(requestCase_ == 16)) {
          request_ = com.google.cloud.speech.v2.UndeleteCustomClassRequest.getDefaultInstance();
        }
        undeleteCustomClassRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.UndeleteCustomClassRequest,
                com.google.cloud.speech.v2.UndeleteCustomClassRequest.Builder,
                com.google.cloud.speech.v2.UndeleteCustomClassRequestOrBuilder>(
                (com.google.cloud.speech.v2.UndeleteCustomClassRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 16;
      onChanged();
      return undeleteCustomClassRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.CreatePhraseSetRequest,
            com.google.cloud.speech.v2.CreatePhraseSetRequest.Builder,
            com.google.cloud.speech.v2.CreatePhraseSetRequestOrBuilder>
        createPhraseSetRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The CreatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
     *
     * @return Whether the createPhraseSetRequest field is set.
     */
    @java.lang.Override
    public boolean hasCreatePhraseSetRequest() {
      return requestCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * The CreatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
     *
     * @return The createPhraseSetRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.CreatePhraseSetRequest getCreatePhraseSetRequest() {
      if (createPhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 17) {
          return (com.google.cloud.speech.v2.CreatePhraseSetRequest) request_;
        }
        return com.google.cloud.speech.v2.CreatePhraseSetRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 17) {
          return createPhraseSetRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.CreatePhraseSetRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The CreatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
     */
    public Builder setCreatePhraseSetRequest(
        com.google.cloud.speech.v2.CreatePhraseSetRequest value) {
      if (createPhraseSetRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        createPhraseSetRequestBuilder_.setMessage(value);
      }
      requestCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
     */
    public Builder setCreatePhraseSetRequest(
        com.google.cloud.speech.v2.CreatePhraseSetRequest.Builder builderForValue) {
      if (createPhraseSetRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        createPhraseSetRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
     */
    public Builder mergeCreatePhraseSetRequest(
        com.google.cloud.speech.v2.CreatePhraseSetRequest value) {
      if (createPhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 17
            && request_ != com.google.cloud.speech.v2.CreatePhraseSetRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.CreatePhraseSetRequest.newBuilder(
                      (com.google.cloud.speech.v2.CreatePhraseSetRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 17) {
          createPhraseSetRequestBuilder_.mergeFrom(value);
        } else {
          createPhraseSetRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
     */
    public Builder clearCreatePhraseSetRequest() {
      if (createPhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 17) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 17) {
          requestCase_ = 0;
          request_ = null;
        }
        createPhraseSetRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CreatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
     */
    public com.google.cloud.speech.v2.CreatePhraseSetRequest.Builder
        getCreatePhraseSetRequestBuilder() {
      return getCreatePhraseSetRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The CreatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.CreatePhraseSetRequestOrBuilder
        getCreatePhraseSetRequestOrBuilder() {
      if ((requestCase_ == 17) && (createPhraseSetRequestBuilder_ != null)) {
        return createPhraseSetRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 17) {
          return (com.google.cloud.speech.v2.CreatePhraseSetRequest) request_;
        }
        return com.google.cloud.speech.v2.CreatePhraseSetRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The CreatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.CreatePhraseSetRequest create_phrase_set_request = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.CreatePhraseSetRequest,
            com.google.cloud.speech.v2.CreatePhraseSetRequest.Builder,
            com.google.cloud.speech.v2.CreatePhraseSetRequestOrBuilder>
        getCreatePhraseSetRequestFieldBuilder() {
      if (createPhraseSetRequestBuilder_ == null) {
        if (!(requestCase_ == 17)) {
          request_ = com.google.cloud.speech.v2.CreatePhraseSetRequest.getDefaultInstance();
        }
        createPhraseSetRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.CreatePhraseSetRequest,
                com.google.cloud.speech.v2.CreatePhraseSetRequest.Builder,
                com.google.cloud.speech.v2.CreatePhraseSetRequestOrBuilder>(
                (com.google.cloud.speech.v2.CreatePhraseSetRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 17;
      onChanged();
      return createPhraseSetRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UpdatePhraseSetRequest,
            com.google.cloud.speech.v2.UpdatePhraseSetRequest.Builder,
            com.google.cloud.speech.v2.UpdatePhraseSetRequestOrBuilder>
        updatePhraseSetRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The UpdatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
     *
     * @return Whether the updatePhraseSetRequest field is set.
     */
    @java.lang.Override
    public boolean hasUpdatePhraseSetRequest() {
      return requestCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * The UpdatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
     *
     * @return The updatePhraseSetRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UpdatePhraseSetRequest getUpdatePhraseSetRequest() {
      if (updatePhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 18) {
          return (com.google.cloud.speech.v2.UpdatePhraseSetRequest) request_;
        }
        return com.google.cloud.speech.v2.UpdatePhraseSetRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 18) {
          return updatePhraseSetRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.UpdatePhraseSetRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UpdatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
     */
    public Builder setUpdatePhraseSetRequest(
        com.google.cloud.speech.v2.UpdatePhraseSetRequest value) {
      if (updatePhraseSetRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        updatePhraseSetRequestBuilder_.setMessage(value);
      }
      requestCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
     */
    public Builder setUpdatePhraseSetRequest(
        com.google.cloud.speech.v2.UpdatePhraseSetRequest.Builder builderForValue) {
      if (updatePhraseSetRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        updatePhraseSetRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
     */
    public Builder mergeUpdatePhraseSetRequest(
        com.google.cloud.speech.v2.UpdatePhraseSetRequest value) {
      if (updatePhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 18
            && request_ != com.google.cloud.speech.v2.UpdatePhraseSetRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.UpdatePhraseSetRequest.newBuilder(
                      (com.google.cloud.speech.v2.UpdatePhraseSetRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 18) {
          updatePhraseSetRequestBuilder_.mergeFrom(value);
        } else {
          updatePhraseSetRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
     */
    public Builder clearUpdatePhraseSetRequest() {
      if (updatePhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 18) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 18) {
          requestCase_ = 0;
          request_ = null;
        }
        updatePhraseSetRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
     */
    public com.google.cloud.speech.v2.UpdatePhraseSetRequest.Builder
        getUpdatePhraseSetRequestBuilder() {
      return getUpdatePhraseSetRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The UpdatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UpdatePhraseSetRequestOrBuilder
        getUpdatePhraseSetRequestOrBuilder() {
      if ((requestCase_ == 18) && (updatePhraseSetRequestBuilder_ != null)) {
        return updatePhraseSetRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 18) {
          return (com.google.cloud.speech.v2.UpdatePhraseSetRequest) request_;
        }
        return com.google.cloud.speech.v2.UpdatePhraseSetRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UpdatePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UpdatePhraseSetRequest update_phrase_set_request = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UpdatePhraseSetRequest,
            com.google.cloud.speech.v2.UpdatePhraseSetRequest.Builder,
            com.google.cloud.speech.v2.UpdatePhraseSetRequestOrBuilder>
        getUpdatePhraseSetRequestFieldBuilder() {
      if (updatePhraseSetRequestBuilder_ == null) {
        if (!(requestCase_ == 18)) {
          request_ = com.google.cloud.speech.v2.UpdatePhraseSetRequest.getDefaultInstance();
        }
        updatePhraseSetRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.UpdatePhraseSetRequest,
                com.google.cloud.speech.v2.UpdatePhraseSetRequest.Builder,
                com.google.cloud.speech.v2.UpdatePhraseSetRequestOrBuilder>(
                (com.google.cloud.speech.v2.UpdatePhraseSetRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 18;
      onChanged();
      return updatePhraseSetRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.DeletePhraseSetRequest,
            com.google.cloud.speech.v2.DeletePhraseSetRequest.Builder,
            com.google.cloud.speech.v2.DeletePhraseSetRequestOrBuilder>
        deletePhraseSetRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The DeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
     *
     * @return Whether the deletePhraseSetRequest field is set.
     */
    @java.lang.Override
    public boolean hasDeletePhraseSetRequest() {
      return requestCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * The DeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
     *
     * @return The deletePhraseSetRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.DeletePhraseSetRequest getDeletePhraseSetRequest() {
      if (deletePhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 19) {
          return (com.google.cloud.speech.v2.DeletePhraseSetRequest) request_;
        }
        return com.google.cloud.speech.v2.DeletePhraseSetRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 19) {
          return deletePhraseSetRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.DeletePhraseSetRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
     */
    public Builder setDeletePhraseSetRequest(
        com.google.cloud.speech.v2.DeletePhraseSetRequest value) {
      if (deletePhraseSetRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        deletePhraseSetRequestBuilder_.setMessage(value);
      }
      requestCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
     */
    public Builder setDeletePhraseSetRequest(
        com.google.cloud.speech.v2.DeletePhraseSetRequest.Builder builderForValue) {
      if (deletePhraseSetRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        deletePhraseSetRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
     */
    public Builder mergeDeletePhraseSetRequest(
        com.google.cloud.speech.v2.DeletePhraseSetRequest value) {
      if (deletePhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 19
            && request_ != com.google.cloud.speech.v2.DeletePhraseSetRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.DeletePhraseSetRequest.newBuilder(
                      (com.google.cloud.speech.v2.DeletePhraseSetRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 19) {
          deletePhraseSetRequestBuilder_.mergeFrom(value);
        } else {
          deletePhraseSetRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
     */
    public Builder clearDeletePhraseSetRequest() {
      if (deletePhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 19) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 19) {
          requestCase_ = 0;
          request_ = null;
        }
        deletePhraseSetRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
     */
    public com.google.cloud.speech.v2.DeletePhraseSetRequest.Builder
        getDeletePhraseSetRequestBuilder() {
      return getDeletePhraseSetRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The DeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.DeletePhraseSetRequestOrBuilder
        getDeletePhraseSetRequestOrBuilder() {
      if ((requestCase_ == 19) && (deletePhraseSetRequestBuilder_ != null)) {
        return deletePhraseSetRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 19) {
          return (com.google.cloud.speech.v2.DeletePhraseSetRequest) request_;
        }
        return com.google.cloud.speech.v2.DeletePhraseSetRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.DeletePhraseSetRequest delete_phrase_set_request = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.DeletePhraseSetRequest,
            com.google.cloud.speech.v2.DeletePhraseSetRequest.Builder,
            com.google.cloud.speech.v2.DeletePhraseSetRequestOrBuilder>
        getDeletePhraseSetRequestFieldBuilder() {
      if (deletePhraseSetRequestBuilder_ == null) {
        if (!(requestCase_ == 19)) {
          request_ = com.google.cloud.speech.v2.DeletePhraseSetRequest.getDefaultInstance();
        }
        deletePhraseSetRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.DeletePhraseSetRequest,
                com.google.cloud.speech.v2.DeletePhraseSetRequest.Builder,
                com.google.cloud.speech.v2.DeletePhraseSetRequestOrBuilder>(
                (com.google.cloud.speech.v2.DeletePhraseSetRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 19;
      onChanged();
      return deletePhraseSetRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UndeletePhraseSetRequest,
            com.google.cloud.speech.v2.UndeletePhraseSetRequest.Builder,
            com.google.cloud.speech.v2.UndeletePhraseSetRequestOrBuilder>
        undeletePhraseSetRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The UndeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;
     * </code>
     *
     * @return Whether the undeletePhraseSetRequest field is set.
     */
    @java.lang.Override
    public boolean hasUndeletePhraseSetRequest() {
      return requestCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * The UndeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;
     * </code>
     *
     * @return The undeletePhraseSetRequest.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UndeletePhraseSetRequest getUndeletePhraseSetRequest() {
      if (undeletePhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 20) {
          return (com.google.cloud.speech.v2.UndeletePhraseSetRequest) request_;
        }
        return com.google.cloud.speech.v2.UndeletePhraseSetRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 20) {
          return undeletePhraseSetRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.UndeletePhraseSetRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UndeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;
     * </code>
     */
    public Builder setUndeletePhraseSetRequest(
        com.google.cloud.speech.v2.UndeletePhraseSetRequest value) {
      if (undeletePhraseSetRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        undeletePhraseSetRequestBuilder_.setMessage(value);
      }
      requestCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;
     * </code>
     */
    public Builder setUndeletePhraseSetRequest(
        com.google.cloud.speech.v2.UndeletePhraseSetRequest.Builder builderForValue) {
      if (undeletePhraseSetRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        undeletePhraseSetRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;
     * </code>
     */
    public Builder mergeUndeletePhraseSetRequest(
        com.google.cloud.speech.v2.UndeletePhraseSetRequest value) {
      if (undeletePhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 20
            && request_
                != com.google.cloud.speech.v2.UndeletePhraseSetRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.UndeletePhraseSetRequest.newBuilder(
                      (com.google.cloud.speech.v2.UndeletePhraseSetRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 20) {
          undeletePhraseSetRequestBuilder_.mergeFrom(value);
        } else {
          undeletePhraseSetRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;
     * </code>
     */
    public Builder clearUndeletePhraseSetRequest() {
      if (undeletePhraseSetRequestBuilder_ == null) {
        if (requestCase_ == 20) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 20) {
          requestCase_ = 0;
          request_ = null;
        }
        undeletePhraseSetRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UndeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;
     * </code>
     */
    public com.google.cloud.speech.v2.UndeletePhraseSetRequest.Builder
        getUndeletePhraseSetRequestBuilder() {
      return getUndeletePhraseSetRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The UndeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.UndeletePhraseSetRequestOrBuilder
        getUndeletePhraseSetRequestOrBuilder() {
      if ((requestCase_ == 20) && (undeletePhraseSetRequestBuilder_ != null)) {
        return undeletePhraseSetRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 20) {
          return (com.google.cloud.speech.v2.UndeletePhraseSetRequest) request_;
        }
        return com.google.cloud.speech.v2.UndeletePhraseSetRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UndeletePhraseSetRequest that spawned the Operation.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.UndeletePhraseSetRequest undelete_phrase_set_request = 20;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UndeletePhraseSetRequest,
            com.google.cloud.speech.v2.UndeletePhraseSetRequest.Builder,
            com.google.cloud.speech.v2.UndeletePhraseSetRequestOrBuilder>
        getUndeletePhraseSetRequestFieldBuilder() {
      if (undeletePhraseSetRequestBuilder_ == null) {
        if (!(requestCase_ == 20)) {
          request_ = com.google.cloud.speech.v2.UndeletePhraseSetRequest.getDefaultInstance();
        }
        undeletePhraseSetRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.UndeletePhraseSetRequest,
                com.google.cloud.speech.v2.UndeletePhraseSetRequest.Builder,
                com.google.cloud.speech.v2.UndeletePhraseSetRequestOrBuilder>(
                (com.google.cloud.speech.v2.UndeletePhraseSetRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 20;
      onChanged();
      return undeletePhraseSetRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UpdateConfigRequest,
            com.google.cloud.speech.v2.UpdateConfigRequest.Builder,
            com.google.cloud.speech.v2.UpdateConfigRequestOrBuilder>
        updateConfigRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The UpdateConfigRequest that spawned the Operation.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.speech.v2.OperationMetadata.update_config_request is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=420
     * @return Whether the updateConfigRequest field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasUpdateConfigRequest() {
      return requestCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * The UpdateConfigRequest that spawned the Operation.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.speech.v2.OperationMetadata.update_config_request is deprecated. See
     *     google/cloud/speech/v2/cloud_speech.proto;l=420
     * @return The updateConfigRequest.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.speech.v2.UpdateConfigRequest getUpdateConfigRequest() {
      if (updateConfigRequestBuilder_ == null) {
        if (requestCase_ == 21) {
          return (com.google.cloud.speech.v2.UpdateConfigRequest) request_;
        }
        return com.google.cloud.speech.v2.UpdateConfigRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 21) {
          return updateConfigRequestBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.UpdateConfigRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UpdateConfigRequest that spawned the Operation.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setUpdateConfigRequest(com.google.cloud.speech.v2.UpdateConfigRequest value) {
      if (updateConfigRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        updateConfigRequestBuilder_.setMessage(value);
      }
      requestCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateConfigRequest that spawned the Operation.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setUpdateConfigRequest(
        com.google.cloud.speech.v2.UpdateConfigRequest.Builder builderForValue) {
      if (updateConfigRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        updateConfigRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateConfigRequest that spawned the Operation.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeUpdateConfigRequest(com.google.cloud.speech.v2.UpdateConfigRequest value) {
      if (updateConfigRequestBuilder_ == null) {
        if (requestCase_ == 21
            && request_ != com.google.cloud.speech.v2.UpdateConfigRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.speech.v2.UpdateConfigRequest.newBuilder(
                      (com.google.cloud.speech.v2.UpdateConfigRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 21) {
          updateConfigRequestBuilder_.mergeFrom(value);
        } else {
          updateConfigRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateConfigRequest that spawned the Operation.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearUpdateConfigRequest() {
      if (updateConfigRequestBuilder_ == null) {
        if (requestCase_ == 21) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 21) {
          requestCase_ = 0;
          request_ = null;
        }
        updateConfigRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UpdateConfigRequest that spawned the Operation.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.speech.v2.UpdateConfigRequest.Builder getUpdateConfigRequestBuilder() {
      return getUpdateConfigRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The UpdateConfigRequest that spawned the Operation.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.speech.v2.UpdateConfigRequestOrBuilder
        getUpdateConfigRequestOrBuilder() {
      if ((requestCase_ == 21) && (updateConfigRequestBuilder_ != null)) {
        return updateConfigRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 21) {
          return (com.google.cloud.speech.v2.UpdateConfigRequest) request_;
        }
        return com.google.cloud.speech.v2.UpdateConfigRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The UpdateConfigRequest that spawned the Operation.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v2.UpdateConfigRequest update_config_request = 21 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.UpdateConfigRequest,
            com.google.cloud.speech.v2.UpdateConfigRequest.Builder,
            com.google.cloud.speech.v2.UpdateConfigRequestOrBuilder>
        getUpdateConfigRequestFieldBuilder() {
      if (updateConfigRequestBuilder_ == null) {
        if (!(requestCase_ == 21)) {
          request_ = com.google.cloud.speech.v2.UpdateConfigRequest.getDefaultInstance();
        }
        updateConfigRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.UpdateConfigRequest,
                com.google.cloud.speech.v2.UpdateConfigRequest.Builder,
                com.google.cloud.speech.v2.UpdateConfigRequestOrBuilder>(
                (com.google.cloud.speech.v2.UpdateConfigRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 21;
      onChanged();
      return updateConfigRequestBuilder_;
    }

    private int progressPercent_;
    /**
     *
     *
     * <pre>
     * The percent progress of the Operation. Values can range from 0-100. If the
     * value is 100, then the operation is finished.
     * </pre>
     *
     * <code>int32 progress_percent = 22;</code>
     *
     * @return The progressPercent.
     */
    @java.lang.Override
    public int getProgressPercent() {
      return progressPercent_;
    }
    /**
     *
     *
     * <pre>
     * The percent progress of the Operation. Values can range from 0-100. If the
     * value is 100, then the operation is finished.
     * </pre>
     *
     * <code>int32 progress_percent = 22;</code>
     *
     * @param value The progressPercent to set.
     * @return This builder for chaining.
     */
    public Builder setProgressPercent(int value) {

      progressPercent_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The percent progress of the Operation. Values can range from 0-100. If the
     * value is 100, then the operation is finished.
     * </pre>
     *
     * <code>int32 progress_percent = 22;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProgressPercent() {
      bitField0_ = (bitField0_ & ~0x00100000);
      progressPercent_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.BatchRecognizeMetadata,
            com.google.cloud.speech.v2.BatchRecognizeMetadata.Builder,
            com.google.cloud.speech.v2.BatchRecognizeMetadataOrBuilder>
        batchRecognizeMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata specific to the BatchRecognize method.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
     *
     * @return Whether the batchRecognizeMetadata field is set.
     */
    @java.lang.Override
    public boolean hasBatchRecognizeMetadata() {
      return metadataCase_ == 23;
    }
    /**
     *
     *
     * <pre>
     * Metadata specific to the BatchRecognize method.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
     *
     * @return The batchRecognizeMetadata.
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeMetadata getBatchRecognizeMetadata() {
      if (batchRecognizeMetadataBuilder_ == null) {
        if (metadataCase_ == 23) {
          return (com.google.cloud.speech.v2.BatchRecognizeMetadata) metadata_;
        }
        return com.google.cloud.speech.v2.BatchRecognizeMetadata.getDefaultInstance();
      } else {
        if (metadataCase_ == 23) {
          return batchRecognizeMetadataBuilder_.getMessage();
        }
        return com.google.cloud.speech.v2.BatchRecognizeMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata specific to the BatchRecognize method.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
     */
    public Builder setBatchRecognizeMetadata(
        com.google.cloud.speech.v2.BatchRecognizeMetadata value) {
      if (batchRecognizeMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        batchRecognizeMetadataBuilder_.setMessage(value);
      }
      metadataCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata specific to the BatchRecognize method.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
     */
    public Builder setBatchRecognizeMetadata(
        com.google.cloud.speech.v2.BatchRecognizeMetadata.Builder builderForValue) {
      if (batchRecognizeMetadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        batchRecognizeMetadataBuilder_.setMessage(builderForValue.build());
      }
      metadataCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata specific to the BatchRecognize method.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
     */
    public Builder mergeBatchRecognizeMetadata(
        com.google.cloud.speech.v2.BatchRecognizeMetadata value) {
      if (batchRecognizeMetadataBuilder_ == null) {
        if (metadataCase_ == 23
            && metadata_
                != com.google.cloud.speech.v2.BatchRecognizeMetadata.getDefaultInstance()) {
          metadata_ =
              com.google.cloud.speech.v2.BatchRecognizeMetadata.newBuilder(
                      (com.google.cloud.speech.v2.BatchRecognizeMetadata) metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        if (metadataCase_ == 23) {
          batchRecognizeMetadataBuilder_.mergeFrom(value);
        } else {
          batchRecognizeMetadataBuilder_.setMessage(value);
        }
      }
      metadataCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata specific to the BatchRecognize method.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
     */
    public Builder clearBatchRecognizeMetadata() {
      if (batchRecognizeMetadataBuilder_ == null) {
        if (metadataCase_ == 23) {
          metadataCase_ = 0;
          metadata_ = null;
          onChanged();
        }
      } else {
        if (metadataCase_ == 23) {
          metadataCase_ = 0;
          metadata_ = null;
        }
        batchRecognizeMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata specific to the BatchRecognize method.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
     */
    public com.google.cloud.speech.v2.BatchRecognizeMetadata.Builder
        getBatchRecognizeMetadataBuilder() {
      return getBatchRecognizeMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata specific to the BatchRecognize method.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
     */
    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeMetadataOrBuilder
        getBatchRecognizeMetadataOrBuilder() {
      if ((metadataCase_ == 23) && (batchRecognizeMetadataBuilder_ != null)) {
        return batchRecognizeMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (metadataCase_ == 23) {
          return (com.google.cloud.speech.v2.BatchRecognizeMetadata) metadata_;
        }
        return com.google.cloud.speech.v2.BatchRecognizeMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata specific to the BatchRecognize method.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.BatchRecognizeMetadata batch_recognize_metadata = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.BatchRecognizeMetadata,
            com.google.cloud.speech.v2.BatchRecognizeMetadata.Builder,
            com.google.cloud.speech.v2.BatchRecognizeMetadataOrBuilder>
        getBatchRecognizeMetadataFieldBuilder() {
      if (batchRecognizeMetadataBuilder_ == null) {
        if (!(metadataCase_ == 23)) {
          metadata_ = com.google.cloud.speech.v2.BatchRecognizeMetadata.getDefaultInstance();
        }
        batchRecognizeMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.BatchRecognizeMetadata,
                com.google.cloud.speech.v2.BatchRecognizeMetadata.Builder,
                com.google.cloud.speech.v2.BatchRecognizeMetadataOrBuilder>(
                (com.google.cloud.speech.v2.BatchRecognizeMetadata) metadata_,
                getParentForChildren(),
                isClean());
        metadata_ = null;
      }
      metadataCase_ = 23;
      onChanged();
      return batchRecognizeMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.OperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.OperationMetadata)
  private static final com.google.cloud.speech.v2.OperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.OperationMetadata();
  }

  public static com.google.cloud.speech.v2.OperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<OperationMetadata>() {
        @java.lang.Override
        public OperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.OperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
