/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

public interface VehicleOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.Vehicle)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The travel mode which affects the roads usable by the vehicle and its
   * speed. See also `travel_duration_multiple`.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
   *
   * @return The enum numeric value on the wire for travelMode.
   */
  int getTravelModeValue();
  /**
   *
   *
   * <pre>
   * The travel mode which affects the roads usable by the vehicle and its
   * speed. See also `travel_duration_multiple`.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
   *
   * @return The travelMode.
   */
  com.google.cloud.optimization.v1.Vehicle.TravelMode getTravelMode();

  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle starts before picking up any
   * shipments. If not specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng start_location = 3;</code>
   *
   * @return Whether the startLocation field is set.
   */
  boolean hasStartLocation();
  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle starts before picking up any
   * shipments. If not specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng start_location = 3;</code>
   *
   * @return The startLocation.
   */
  com.google.type.LatLng getStartLocation();
  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle starts before picking up any
   * shipments. If not specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng start_location = 3;</code>
   */
  com.google.type.LatLngOrBuilder getStartLocationOrBuilder();

  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle starts before
   * picking up any shipments. If neither `start_waypoint` nor `start_location`
   * is specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
   *
   * @return Whether the startWaypoint field is set.
   */
  boolean hasStartWaypoint();
  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle starts before
   * picking up any shipments. If neither `start_waypoint` nor `start_location`
   * is specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
   *
   * @return The startWaypoint.
   */
  com.google.cloud.optimization.v1.Waypoint getStartWaypoint();
  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle starts before
   * picking up any shipments. If neither `start_waypoint` nor `start_location`
   * is specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
   */
  com.google.cloud.optimization.v1.WaypointOrBuilder getStartWaypointOrBuilder();

  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle ends after it has completed its last
   * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
   * immediately when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng end_location = 5;</code>
   *
   * @return Whether the endLocation field is set.
   */
  boolean hasEndLocation();
  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle ends after it has completed its last
   * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
   * immediately when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng end_location = 5;</code>
   *
   * @return The endLocation.
   */
  com.google.type.LatLng getEndLocation();
  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle ends after it has completed its last
   * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
   * immediately when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng end_location = 5;</code>
   */
  com.google.type.LatLngOrBuilder getEndLocationOrBuilder();

  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle ends after
   * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
   * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
   * when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
   *
   * @return Whether the endWaypoint field is set.
   */
  boolean hasEndWaypoint();
  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle ends after
   * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
   * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
   * when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
   *
   * @return The endWaypoint.
   */
  com.google.cloud.optimization.v1.Waypoint getEndWaypoint();
  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle ends after
   * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
   * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
   * when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
   */
  com.google.cloud.optimization.v1.WaypointOrBuilder getEndWaypointOrBuilder();

  /**
   *
   *
   * <pre>
   * Specifies tags attached to the start of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string start_tags = 7;</code>
   *
   * @return A list containing the startTags.
   */
  java.util.List<java.lang.String> getStartTagsList();
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the start of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string start_tags = 7;</code>
   *
   * @return The count of startTags.
   */
  int getStartTagsCount();
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the start of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string start_tags = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The startTags at the given index.
   */
  java.lang.String getStartTags(int index);
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the start of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string start_tags = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the startTags at the given index.
   */
  com.google.protobuf.ByteString getStartTagsBytes(int index);

  /**
   *
   *
   * <pre>
   * Specifies tags attached to the end of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string end_tags = 8;</code>
   *
   * @return A list containing the endTags.
   */
  java.util.List<java.lang.String> getEndTagsList();
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the end of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string end_tags = 8;</code>
   *
   * @return The count of endTags.
   */
  int getEndTagsCount();
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the end of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string end_tags = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The endTags at the given index.
   */
  java.lang.String getEndTags(int index);
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the end of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string end_tags = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the endTags at the given index.
   */
  com.google.protobuf.ByteString getEndTagsBytes(int index);

  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may depart its start location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
   */
  java.util.List<com.google.cloud.optimization.v1.TimeWindow> getStartTimeWindowsList();
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may depart its start location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
   */
  com.google.cloud.optimization.v1.TimeWindow getStartTimeWindows(int index);
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may depart its start location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
   */
  int getStartTimeWindowsCount();
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may depart its start location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
   */
  java.util.List<? extends com.google.cloud.optimization.v1.TimeWindowOrBuilder>
      getStartTimeWindowsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may depart its start location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
   */
  com.google.cloud.optimization.v1.TimeWindowOrBuilder getStartTimeWindowsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may arrive at its end location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
   */
  java.util.List<com.google.cloud.optimization.v1.TimeWindow> getEndTimeWindowsList();
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may arrive at its end location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
   */
  com.google.cloud.optimization.v1.TimeWindow getEndTimeWindows(int index);
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may arrive at its end location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
   */
  int getEndTimeWindowsCount();
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may arrive at its end location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
   */
  java.util.List<? extends com.google.cloud.optimization.v1.TimeWindowOrBuilder>
      getEndTimeWindowsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may arrive at its end location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
   */
  com.google.cloud.optimization.v1.TimeWindowOrBuilder getEndTimeWindowsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Specifies a multiplicative factor that can be used to increase or decrease
   * travel times of this vehicle. For example, setting this to 2.0 means
   * that this vehicle is slower and has travel times that are twice what they
   * are for standard vehicles. This multiple does not affect visit durations.
   * It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
   * specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
   * is standard, and this multiple is considered 1.0.
   * WARNING: Travel times will be rounded to the nearest second after this
   * multiple is applied but before performing any numerical operations, thus,
   * a small multiple may result in a loss of precision.
   * See also `extra_visit_duration_for_visit_type` below.
   * </pre>
   *
   * <code>optional double travel_duration_multiple = 11;</code>
   *
   * @return Whether the travelDurationMultiple field is set.
   */
  boolean hasTravelDurationMultiple();
  /**
   *
   *
   * <pre>
   * Specifies a multiplicative factor that can be used to increase or decrease
   * travel times of this vehicle. For example, setting this to 2.0 means
   * that this vehicle is slower and has travel times that are twice what they
   * are for standard vehicles. This multiple does not affect visit durations.
   * It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
   * specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
   * is standard, and this multiple is considered 1.0.
   * WARNING: Travel times will be rounded to the nearest second after this
   * multiple is applied but before performing any numerical operations, thus,
   * a small multiple may result in a loss of precision.
   * See also `extra_visit_duration_for_visit_type` below.
   * </pre>
   *
   * <code>optional double travel_duration_multiple = 11;</code>
   *
   * @return The travelDurationMultiple.
   */
  double getTravelDurationMultiple();

  /**
   *
   *
   * <pre>
   * Unloading policy enforced on the vehicle.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
   *
   * @return The enum numeric value on the wire for unloadingPolicy.
   */
  int getUnloadingPolicyValue();
  /**
   *
   *
   * <pre>
   * Unloading policy enforced on the vehicle.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
   *
   * @return The unloadingPolicy.
   */
  com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy getUnloadingPolicy();

  /**
   *
   *
   * <pre>
   * Capacities of the vehicle (weight, volume, # of pallets for example).
   * The keys in the map are the identifiers of the type of load, consistent
   * with the keys of the
   * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
   * field. If a given key is absent from this map, the corresponding capacity
   * is considered to be limitless.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
   * </code>
   */
  int getLoadLimitsCount();
  /**
   *
   *
   * <pre>
   * Capacities of the vehicle (weight, volume, # of pallets for example).
   * The keys in the map are the identifiers of the type of load, consistent
   * with the keys of the
   * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
   * field. If a given key is absent from this map, the corresponding capacity
   * is considered to be limitless.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
   * </code>
   */
  boolean containsLoadLimits(java.lang.String key);
  /** Use {@link #getLoadLimitsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
      getLoadLimits();
  /**
   *
   *
   * <pre>
   * Capacities of the vehicle (weight, volume, # of pallets for example).
   * The keys in the map are the identifiers of the type of load, consistent
   * with the keys of the
   * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
   * field. If a given key is absent from this map, the corresponding capacity
   * is considered to be limitless.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
   * </code>
   */
  java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
      getLoadLimitsMap();
  /**
   *
   *
   * <pre>
   * Capacities of the vehicle (weight, volume, # of pallets for example).
   * The keys in the map are the identifiers of the type of load, consistent
   * with the keys of the
   * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
   * field. If a given key is absent from this map, the corresponding capacity
   * is considered to be limitless.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
   * </code>
   */

  /* nullable */
  com.google.cloud.optimization.v1.Vehicle.LoadLimit getLoadLimitsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.optimization.v1.Vehicle.LoadLimit defaultValue);
  /**
   *
   *
   * <pre>
   * Capacities of the vehicle (weight, volume, # of pallets for example).
   * The keys in the map are the identifiers of the type of load, consistent
   * with the keys of the
   * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
   * field. If a given key is absent from this map, the corresponding capacity
   * is considered to be limitless.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
   * </code>
   */
  com.google.cloud.optimization.v1.Vehicle.LoadLimit getLoadLimitsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Vehicle costs: all costs add up and must be in the same unit as
   * [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
   * Cost per hour of the vehicle route. This cost is applied to the total time
   * taken by the route, and includes travel time, waiting time, and visit time.
   * Using `cost_per_hour` instead of just `cost_per_traveled_hour` may result
   * in additional latency.
   * </pre>
   *
   * <code>double cost_per_hour = 16;</code>
   *
   * @return The costPerHour.
   */
  double getCostPerHour();

  /**
   *
   *
   * <pre>
   * Cost per traveled hour of the vehicle route. This cost is applied only to
   * travel time taken by the route (i.e., that reported in
   * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]), and excludes waiting time and visit time.
   * </pre>
   *
   * <code>double cost_per_traveled_hour = 17;</code>
   *
   * @return The costPerTraveledHour.
   */
  double getCostPerTraveledHour();

  /**
   *
   *
   * <pre>
   * Cost per kilometer of the vehicle route. This cost is applied to the
   * distance reported in the [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] and does not apply
   * to any distance implicitly traveled from the `arrival_location` to the
   * `departure_location` of a single `VisitRequest`.
   * </pre>
   *
   * <code>double cost_per_kilometer = 18;</code>
   *
   * @return The costPerKilometer.
   */
  double getCostPerKilometer();

  /**
   *
   *
   * <pre>
   * Fixed cost applied if this vehicle is used to handle a shipment.
   * </pre>
   *
   * <code>double fixed_cost = 19;</code>
   *
   * @return The fixedCost.
   */
  double getFixedCost();

  /**
   *
   *
   * <pre>
   * This field only applies to vehicles when their route does not serve any
   * shipments. It indicates if the vehicle should be considered as used or not
   * in this case.
   * If true, the vehicle goes from its start to its end location even if it
   * doesn't serve any shipments, and time and distance costs resulting from its
   * start --&gt; end travel are taken into account.
   * Otherwise, it doesn't travel from its start to its end location, and no
   * `break_rule` or delay (from `TransitionAttributes`) are scheduled for this
   * vehicle. In this case, the vehicle's `ShipmentRoute` doesn't contain any
   * information except for the vehicle index and label.
   * </pre>
   *
   * <code>bool used_if_route_is_empty = 20;</code>
   *
   * @return The usedIfRouteIsEmpty.
   */
  boolean getUsedIfRouteIsEmpty();

  /**
   *
   *
   * <pre>
   * Limit applied to the total duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route duration of a vehicle is the
   * difference between its `vehicle_end_time` and `vehicle_start_time`.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
   *
   * @return Whether the routeDurationLimit field is set.
   */
  boolean hasRouteDurationLimit();
  /**
   *
   *
   * <pre>
   * Limit applied to the total duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route duration of a vehicle is the
   * difference between its `vehicle_end_time` and `vehicle_start_time`.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
   *
   * @return The routeDurationLimit.
   */
  com.google.cloud.optimization.v1.Vehicle.DurationLimit getRouteDurationLimit();
  /**
   *
   *
   * <pre>
   * Limit applied to the total duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route duration of a vehicle is the
   * difference between its `vehicle_end_time` and `vehicle_start_time`.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
   */
  com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder getRouteDurationLimitOrBuilder();

  /**
   *
   *
   * <pre>
   * Limit applied to the travel duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route travel duration is the sum of all its
   * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
   *
   * @return Whether the travelDurationLimit field is set.
   */
  boolean hasTravelDurationLimit();
  /**
   *
   *
   * <pre>
   * Limit applied to the travel duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route travel duration is the sum of all its
   * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
   *
   * @return The travelDurationLimit.
   */
  com.google.cloud.optimization.v1.Vehicle.DurationLimit getTravelDurationLimit();
  /**
   *
   *
   * <pre>
   * Limit applied to the travel duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route travel duration is the sum of all its
   * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
   */
  com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder getTravelDurationLimitOrBuilder();

  /**
   *
   *
   * <pre>
   * Limit applied to the total distance of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route distance is the sum of all its
   * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
   *
   * @return Whether the routeDistanceLimit field is set.
   */
  boolean hasRouteDistanceLimit();
  /**
   *
   *
   * <pre>
   * Limit applied to the total distance of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route distance is the sum of all its
   * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
   *
   * @return The routeDistanceLimit.
   */
  com.google.cloud.optimization.v1.DistanceLimit getRouteDistanceLimit();
  /**
   *
   *
   * <pre>
   * Limit applied to the total distance of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route distance is the sum of all its
   * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
   */
  com.google.cloud.optimization.v1.DistanceLimitOrBuilder getRouteDistanceLimitOrBuilder();

  /**
   *
   *
   * <pre>
   * Specifies a map from visit_types strings to durations. The duration is time
   * in addition to
   * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
   * to be taken at visits with the specified `visit_types`. This extra visit
   * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
   * `visit_types`) cannot be empty strings.
   * If a visit request has multiple types, a duration will be added for each
   * type in the map.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
   * </code>
   */
  int getExtraVisitDurationForVisitTypeCount();
  /**
   *
   *
   * <pre>
   * Specifies a map from visit_types strings to durations. The duration is time
   * in addition to
   * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
   * to be taken at visits with the specified `visit_types`. This extra visit
   * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
   * `visit_types`) cannot be empty strings.
   * If a visit request has multiple types, a duration will be added for each
   * type in the map.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
   * </code>
   */
  boolean containsExtraVisitDurationForVisitType(java.lang.String key);
  /** Use {@link #getExtraVisitDurationForVisitTypeMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.protobuf.Duration> getExtraVisitDurationForVisitType();
  /**
   *
   *
   * <pre>
   * Specifies a map from visit_types strings to durations. The duration is time
   * in addition to
   * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
   * to be taken at visits with the specified `visit_types`. This extra visit
   * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
   * `visit_types`) cannot be empty strings.
   * If a visit request has multiple types, a duration will be added for each
   * type in the map.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
   * </code>
   */
  java.util.Map<java.lang.String, com.google.protobuf.Duration>
      getExtraVisitDurationForVisitTypeMap();
  /**
   *
   *
   * <pre>
   * Specifies a map from visit_types strings to durations. The duration is time
   * in addition to
   * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
   * to be taken at visits with the specified `visit_types`. This extra visit
   * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
   * `visit_types`) cannot be empty strings.
   * If a visit request has multiple types, a duration will be added for each
   * type in the map.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
   * </code>
   */

  /* nullable */
  com.google.protobuf.Duration getExtraVisitDurationForVisitTypeOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Duration defaultValue);
  /**
   *
   *
   * <pre>
   * Specifies a map from visit_types strings to durations. The duration is time
   * in addition to
   * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
   * to be taken at visits with the specified `visit_types`. This extra visit
   * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
   * `visit_types`) cannot be empty strings.
   * If a visit request has multiple types, a duration will be added for each
   * type in the map.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
   * </code>
   */
  com.google.protobuf.Duration getExtraVisitDurationForVisitTypeOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Describes the break schedule to be enforced on this vehicle.
   * If empty, no breaks will be scheduled for this vehicle.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
   *
   * @return Whether the breakRule field is set.
   */
  boolean hasBreakRule();
  /**
   *
   *
   * <pre>
   * Describes the break schedule to be enforced on this vehicle.
   * If empty, no breaks will be scheduled for this vehicle.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
   *
   * @return The breakRule.
   */
  com.google.cloud.optimization.v1.BreakRule getBreakRule();
  /**
   *
   *
   * <pre>
   * Describes the break schedule to be enforced on this vehicle.
   * If empty, no breaks will be scheduled for this vehicle.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
   */
  com.google.cloud.optimization.v1.BreakRuleOrBuilder getBreakRuleOrBuilder();

  /**
   *
   *
   * <pre>
   * Specifies a label for this vehicle. This label is reported in the response
   * as the `vehicle_label` of the corresponding [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
   * </pre>
   *
   * <code>string label = 27;</code>
   *
   * @return The label.
   */
  java.lang.String getLabel();
  /**
   *
   *
   * <pre>
   * Specifies a label for this vehicle. This label is reported in the response
   * as the `vehicle_label` of the corresponding [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
   * </pre>
   *
   * <code>string label = 27;</code>
   *
   * @return The bytes for label.
   */
  com.google.protobuf.ByteString getLabelBytes();

  /**
   *
   *
   * <pre>
   * If true, `used_if_route_is_empty` must be false, and this vehicle will
   * remain unused.
   * If a shipment is performed by an ignored vehicle in
   * `injected_first_solution_routes`, it is skipped in the first solution but
   * is free to be performed in the response.
   * If a shipment is performed by an ignored vehicle in
   * `injected_solution_constraint` and any related pickup/delivery is
   * constrained to remain on the vehicle (i.e., not relaxed to level
   * `RELAX_ALL_AFTER_THRESHOLD`), it is skipped in the response.
   * If a shipment has a non-empty `allowed_vehicle_indices` field and all of
   * the allowed vehicles are ignored, it is skipped in the response.
   * </pre>
   *
   * <code>bool ignore = 28;</code>
   *
   * @return The ignore.
   */
  boolean getIgnore();

  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Indices in the `break_rule` field in the source
   * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
   * As of 2018/03, at most one rule index per vehicle can be specified.
   * </pre>
   *
   * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
   *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
   * @return A list containing the breakRuleIndices.
   */
  @java.lang.Deprecated
  java.util.List<java.lang.Integer> getBreakRuleIndicesList();
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Indices in the `break_rule` field in the source
   * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
   * As of 2018/03, at most one rule index per vehicle can be specified.
   * </pre>
   *
   * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
   *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
   * @return The count of breakRuleIndices.
   */
  @java.lang.Deprecated
  int getBreakRuleIndicesCount();
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Indices in the `break_rule` field in the source
   * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
   * As of 2018/03, at most one rule index per vehicle can be specified.
   * </pre>
   *
   * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
   *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
   * @param index The index of the element to return.
   * @return The breakRuleIndices at the given index.
   */
  @java.lang.Deprecated
  int getBreakRuleIndices(int index);

  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.load_limits][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getCapacitiesList();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.load_limits][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.cloud.optimization.v1.CapacityQuantity getCapacities(int index);
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.load_limits][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  int getCapacitiesCount();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.load_limits][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
      getCapacitiesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.load_limits][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getCapacitiesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval>
      getStartLoadIntervalsList();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.cloud.optimization.v1.CapacityQuantityInterval getStartLoadIntervals(int index);
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  int getStartLoadIntervalsCount();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>
      getStartLoadIntervalsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder getStartLoadIntervalsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval>
      getEndLoadIntervalsList();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.cloud.optimization.v1.CapacityQuantityInterval getEndLoadIntervals(int index);
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  int getEndLoadIntervalsCount();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>
      getEndLoadIntervalsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder getEndLoadIntervalsOrBuilder(
      int index);
}
