/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Models a vehicle in a shipment problem. Solving a shipment problem will
 * build a route starting from `start_location` and ending at `end_location`
 * for this vehicle. A route is a sequence of visits (see `ShipmentRoute`).
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.Vehicle}
 */
public final class Vehicle extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.Vehicle)
    VehicleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Vehicle.newBuilder() to construct.
  private Vehicle(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Vehicle() {
    travelMode_ = 0;
    startTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    endTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    startTimeWindows_ = java.util.Collections.emptyList();
    endTimeWindows_ = java.util.Collections.emptyList();
    unloadingPolicy_ = 0;
    label_ = "";
    breakRuleIndices_ = emptyIntList();
    capacities_ = java.util.Collections.emptyList();
    startLoadIntervals_ = java.util.Collections.emptyList();
    endLoadIntervals_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Vehicle();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_Vehicle_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 30:
        return internalGetLoadLimits();
      case 24:
        return internalGetExtraVisitDurationForVisitType();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_Vehicle_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.Vehicle.class,
            com.google.cloud.optimization.v1.Vehicle.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Travel modes which can be used by vehicles.
   * These should be a subset of the Google Maps Platform Routes Preferred API
   * travel modes, see:
   * https://developers.google.com/maps/documentation/routes_preferred/reference/rest/Shared.Types/RouteTravelMode.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.optimization.v1.Vehicle.TravelMode}
   */
  public enum TravelMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified travel mode, equivalent to `DRIVING`.
     * </pre>
     *
     * <code>TRAVEL_MODE_UNSPECIFIED = 0;</code>
     */
    TRAVEL_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Travel mode corresponding to driving directions (car, ...).
     * </pre>
     *
     * <code>DRIVING = 1;</code>
     */
    DRIVING(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified travel mode, equivalent to `DRIVING`.
     * </pre>
     *
     * <code>TRAVEL_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int TRAVEL_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Travel mode corresponding to driving directions (car, ...).
     * </pre>
     *
     * <code>DRIVING = 1;</code>
     */
    public static final int DRIVING_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TravelMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TravelMode forNumber(int value) {
      switch (value) {
        case 0:
          return TRAVEL_MODE_UNSPECIFIED;
        case 1:
          return DRIVING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TravelMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TravelMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TravelMode>() {
          public TravelMode findValueByNumber(int number) {
            return TravelMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.optimization.v1.Vehicle.getDescriptor().getEnumTypes().get(0);
    }

    private static final TravelMode[] VALUES = values();

    public static TravelMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TravelMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.optimization.v1.Vehicle.TravelMode)
  }

  /**
   *
   *
   * <pre>
   * Policy on how a vehicle can be unloaded. Applies only to shipments having
   * both a pickup and a delivery.
   * Other shipments are free to occur anywhere on the route independent of
   * `unloading_policy`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.optimization.v1.Vehicle.UnloadingPolicy}
   */
  public enum UnloadingPolicy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified unloading policy; deliveries must just occur after their
     * corresponding pickups.
     * </pre>
     *
     * <code>UNLOADING_POLICY_UNSPECIFIED = 0;</code>
     */
    UNLOADING_POLICY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Deliveries must occur in reverse order of pickups
     * </pre>
     *
     * <code>LAST_IN_FIRST_OUT = 1;</code>
     */
    LAST_IN_FIRST_OUT(1),
    /**
     *
     *
     * <pre>
     * Deliveries must occur in the same order as pickups
     * </pre>
     *
     * <code>FIRST_IN_FIRST_OUT = 2;</code>
     */
    FIRST_IN_FIRST_OUT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified unloading policy; deliveries must just occur after their
     * corresponding pickups.
     * </pre>
     *
     * <code>UNLOADING_POLICY_UNSPECIFIED = 0;</code>
     */
    public static final int UNLOADING_POLICY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Deliveries must occur in reverse order of pickups
     * </pre>
     *
     * <code>LAST_IN_FIRST_OUT = 1;</code>
     */
    public static final int LAST_IN_FIRST_OUT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Deliveries must occur in the same order as pickups
     * </pre>
     *
     * <code>FIRST_IN_FIRST_OUT = 2;</code>
     */
    public static final int FIRST_IN_FIRST_OUT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static UnloadingPolicy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static UnloadingPolicy forNumber(int value) {
      switch (value) {
        case 0:
          return UNLOADING_POLICY_UNSPECIFIED;
        case 1:
          return LAST_IN_FIRST_OUT;
        case 2:
          return FIRST_IN_FIRST_OUT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<UnloadingPolicy> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<UnloadingPolicy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<UnloadingPolicy>() {
              public UnloadingPolicy findValueByNumber(int number) {
                return UnloadingPolicy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.optimization.v1.Vehicle.getDescriptor().getEnumTypes().get(1);
    }

    private static final UnloadingPolicy[] VALUES = values();

    public static UnloadingPolicy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private UnloadingPolicy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.optimization.v1.Vehicle.UnloadingPolicy)
  }

  public interface LoadLimitOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.Vehicle.LoadLimit)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The maximum acceptable amount of load.
     * </pre>
     *
     * <code>optional int64 max_load = 1;</code>
     *
     * @return Whether the maxLoad field is set.
     */
    boolean hasMaxLoad();
    /**
     *
     *
     * <pre>
     * The maximum acceptable amount of load.
     * </pre>
     *
     * <code>optional int64 max_load = 1;</code>
     *
     * @return The maxLoad.
     */
    long getMaxLoad();

    /**
     *
     *
     * <pre>
     * A soft limit of the load. See [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max].
     * </pre>
     *
     * <code>int64 soft_max_load = 2;</code>
     *
     * @return The softMaxLoad.
     */
    long getSoftMaxLoad();

    /**
     *
     *
     * <pre>
     * If the load ever exceeds [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load] along this vehicle's route,
     * the following cost penalty applies (only once per vehicle):
     * (load - [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load]) * [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max]. All costs
     * add up and must be in the same unit as [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
     * </pre>
     *
     * <code>double cost_per_unit_above_soft_max = 3;</code>
     *
     * @return The costPerUnitAboveSoftMax.
     */
    double getCostPerUnitAboveSoftMax();

    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the start of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
     * </code>
     *
     * @return Whether the startLoadInterval field is set.
     */
    boolean hasStartLoadInterval();
    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the start of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
     * </code>
     *
     * @return The startLoadInterval.
     */
    com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval getStartLoadInterval();
    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the start of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
     * </code>
     */
    com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder
        getStartLoadIntervalOrBuilder();

    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the end of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;</code>
     *
     * @return Whether the endLoadInterval field is set.
     */
    boolean hasEndLoadInterval();
    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the end of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;</code>
     *
     * @return The endLoadInterval.
     */
    com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval getEndLoadInterval();
    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the end of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;</code>
     */
    com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder
        getEndLoadIntervalOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Defines a load limit applying to a vehicle, e.g. "this truck may only
   * carry up to 3500 kg". See [load_limits][google.cloud.optimization.v1.Vehicle.load_limits].
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.Vehicle.LoadLimit}
   */
  public static final class LoadLimit extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.Vehicle.LoadLimit)
      LoadLimitOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LoadLimit.newBuilder() to construct.
    private LoadLimit(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LoadLimit() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LoadLimit();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Vehicle_LoadLimit_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Vehicle_LoadLimit_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.class,
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.Builder.class);
    }

    public interface IntervalOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.Vehicle.LoadLimit.Interval)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * A minimum acceptable load. Must be ≥ 0.
       * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
       * </pre>
       *
       * <code>int64 min = 1;</code>
       *
       * @return The min.
       */
      long getMin();

      /**
       *
       *
       * <pre>
       * A maximum acceptable load. Must be ≥ 0. If unspecified, the maximum
       * load is unrestricted by this message.
       * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
       * </pre>
       *
       * <code>optional int64 max = 2;</code>
       *
       * @return Whether the max field is set.
       */
      boolean hasMax();
      /**
       *
       *
       * <pre>
       * A maximum acceptable load. Must be ≥ 0. If unspecified, the maximum
       * load is unrestricted by this message.
       * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
       * </pre>
       *
       * <code>optional int64 max = 2;</code>
       *
       * @return The max.
       */
      long getMax();
    }
    /**
     *
     *
     * <pre>
     * Interval of acceptable load amounts.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.Vehicle.LoadLimit.Interval}
     */
    public static final class Interval extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.Vehicle.LoadLimit.Interval)
        IntervalOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Interval.newBuilder() to construct.
      private Interval(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Interval() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Interval();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Vehicle_LoadLimit_Interval_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Vehicle_LoadLimit_Interval_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.class,
                com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder.class);
      }

      private int bitField0_;
      public static final int MIN_FIELD_NUMBER = 1;
      private long min_;
      /**
       *
       *
       * <pre>
       * A minimum acceptable load. Must be ≥ 0.
       * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
       * </pre>
       *
       * <code>int64 min = 1;</code>
       *
       * @return The min.
       */
      @java.lang.Override
      public long getMin() {
        return min_;
      }

      public static final int MAX_FIELD_NUMBER = 2;
      private long max_;
      /**
       *
       *
       * <pre>
       * A maximum acceptable load. Must be ≥ 0. If unspecified, the maximum
       * load is unrestricted by this message.
       * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
       * </pre>
       *
       * <code>optional int64 max = 2;</code>
       *
       * @return Whether the max field is set.
       */
      @java.lang.Override
      public boolean hasMax() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A maximum acceptable load. Must be ≥ 0. If unspecified, the maximum
       * load is unrestricted by this message.
       * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
       * </pre>
       *
       * <code>optional int64 max = 2;</code>
       *
       * @return The max.
       */
      @java.lang.Override
      public long getMax() {
        return max_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (min_ != 0L) {
          output.writeInt64(1, min_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeInt64(2, max_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (min_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, min_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, max_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval)) {
          return super.equals(obj);
        }
        com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval other =
            (com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval) obj;

        if (getMin() != other.getMin()) return false;
        if (hasMax() != other.hasMax()) return false;
        if (hasMax()) {
          if (getMax() != other.getMax()) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MIN_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMin());
        if (hasMax()) {
          hash = (37 * hash) + MAX_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMax());
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Interval of acceptable load amounts.
       * </pre>
       *
       * Protobuf type {@code google.cloud.optimization.v1.Vehicle.LoadLimit.Interval}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.Vehicle.LoadLimit.Interval)
          com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_Vehicle_LoadLimit_Interval_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_Vehicle_LoadLimit_Interval_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.class,
                  com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder.class);
        }

        // Construct using com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          min_ = 0L;

          max_ = 0L;
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_Vehicle_LoadLimit_Interval_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval
            getDefaultInstanceForType() {
          return com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval build() {
          com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval buildPartial() {
          com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval result =
              new com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          result.min_ = min_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.max_ = max_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval) {
            return mergeFrom((com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval other) {
          if (other
              == com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.getDefaultInstance())
            return this;
          if (other.getMin() != 0L) {
            setMin(other.getMin());
          }
          if (other.hasMax()) {
            setMax(other.getMax());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    min_ = input.readInt64();

                    break;
                  } // case 8
                case 16:
                  {
                    max_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long min_;
        /**
         *
         *
         * <pre>
         * A minimum acceptable load. Must be ≥ 0.
         * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
         * </pre>
         *
         * <code>int64 min = 1;</code>
         *
         * @return The min.
         */
        @java.lang.Override
        public long getMin() {
          return min_;
        }
        /**
         *
         *
         * <pre>
         * A minimum acceptable load. Must be ≥ 0.
         * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
         * </pre>
         *
         * <code>int64 min = 1;</code>
         *
         * @param value The min to set.
         * @return This builder for chaining.
         */
        public Builder setMin(long value) {

          min_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A minimum acceptable load. Must be ≥ 0.
         * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
         * </pre>
         *
         * <code>int64 min = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMin() {

          min_ = 0L;
          onChanged();
          return this;
        }

        private long max_;
        /**
         *
         *
         * <pre>
         * A maximum acceptable load. Must be ≥ 0. If unspecified, the maximum
         * load is unrestricted by this message.
         * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
         * </pre>
         *
         * <code>optional int64 max = 2;</code>
         *
         * @return Whether the max field is set.
         */
        @java.lang.Override
        public boolean hasMax() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * A maximum acceptable load. Must be ≥ 0. If unspecified, the maximum
         * load is unrestricted by this message.
         * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
         * </pre>
         *
         * <code>optional int64 max = 2;</code>
         *
         * @return The max.
         */
        @java.lang.Override
        public long getMax() {
          return max_;
        }
        /**
         *
         *
         * <pre>
         * A maximum acceptable load. Must be ≥ 0. If unspecified, the maximum
         * load is unrestricted by this message.
         * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
         * </pre>
         *
         * <code>optional int64 max = 2;</code>
         *
         * @param value The max to set.
         * @return This builder for chaining.
         */
        public Builder setMax(long value) {
          bitField0_ |= 0x00000001;
          max_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A maximum acceptable load. Must be ≥ 0. If unspecified, the maximum
         * load is unrestricted by this message.
         * If they're both specified, [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must be ≤ [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
         * </pre>
         *
         * <code>optional int64 max = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMax() {
          bitField0_ = (bitField0_ & ~0x00000001);
          max_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.Vehicle.LoadLimit.Interval)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.Vehicle.LoadLimit.Interval)
      private static final com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval();
      }

      public static com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Interval> PARSER =
          new com.google.protobuf.AbstractParser<Interval>() {
            @java.lang.Override
            public Interval parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Interval> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Interval> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int MAX_LOAD_FIELD_NUMBER = 1;
    private long maxLoad_;
    /**
     *
     *
     * <pre>
     * The maximum acceptable amount of load.
     * </pre>
     *
     * <code>optional int64 max_load = 1;</code>
     *
     * @return Whether the maxLoad field is set.
     */
    @java.lang.Override
    public boolean hasMaxLoad() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maximum acceptable amount of load.
     * </pre>
     *
     * <code>optional int64 max_load = 1;</code>
     *
     * @return The maxLoad.
     */
    @java.lang.Override
    public long getMaxLoad() {
      return maxLoad_;
    }

    public static final int SOFT_MAX_LOAD_FIELD_NUMBER = 2;
    private long softMaxLoad_;
    /**
     *
     *
     * <pre>
     * A soft limit of the load. See [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max].
     * </pre>
     *
     * <code>int64 soft_max_load = 2;</code>
     *
     * @return The softMaxLoad.
     */
    @java.lang.Override
    public long getSoftMaxLoad() {
      return softMaxLoad_;
    }

    public static final int COST_PER_UNIT_ABOVE_SOFT_MAX_FIELD_NUMBER = 3;
    private double costPerUnitAboveSoftMax_;
    /**
     *
     *
     * <pre>
     * If the load ever exceeds [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load] along this vehicle's route,
     * the following cost penalty applies (only once per vehicle):
     * (load - [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load]) * [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max]. All costs
     * add up and must be in the same unit as [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
     * </pre>
     *
     * <code>double cost_per_unit_above_soft_max = 3;</code>
     *
     * @return The costPerUnitAboveSoftMax.
     */
    @java.lang.Override
    public double getCostPerUnitAboveSoftMax() {
      return costPerUnitAboveSoftMax_;
    }

    public static final int START_LOAD_INTERVAL_FIELD_NUMBER = 4;
    private com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval startLoadInterval_;
    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the start of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
     * </code>
     *
     * @return Whether the startLoadInterval field is set.
     */
    @java.lang.Override
    public boolean hasStartLoadInterval() {
      return startLoadInterval_ != null;
    }
    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the start of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
     * </code>
     *
     * @return The startLoadInterval.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval getStartLoadInterval() {
      return startLoadInterval_ == null
          ? com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.getDefaultInstance()
          : startLoadInterval_;
    }
    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the start of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder
        getStartLoadIntervalOrBuilder() {
      return getStartLoadInterval();
    }

    public static final int END_LOAD_INTERVAL_FIELD_NUMBER = 5;
    private com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval endLoadInterval_;
    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the end of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;</code>
     *
     * @return Whether the endLoadInterval field is set.
     */
    @java.lang.Override
    public boolean hasEndLoadInterval() {
      return endLoadInterval_ != null;
    }
    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the end of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;</code>
     *
     * @return The endLoadInterval.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval getEndLoadInterval() {
      return endLoadInterval_ == null
          ? com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.getDefaultInstance()
          : endLoadInterval_;
    }
    /**
     *
     *
     * <pre>
     * The acceptable load interval of the vehicle at the end of the route.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder
        getEndLoadIntervalOrBuilder() {
      return getEndLoadInterval();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt64(1, maxLoad_);
      }
      if (softMaxLoad_ != 0L) {
        output.writeInt64(2, softMaxLoad_);
      }
      if (java.lang.Double.doubleToRawLongBits(costPerUnitAboveSoftMax_) != 0) {
        output.writeDouble(3, costPerUnitAboveSoftMax_);
      }
      if (startLoadInterval_ != null) {
        output.writeMessage(4, getStartLoadInterval());
      }
      if (endLoadInterval_ != null) {
        output.writeMessage(5, getEndLoadInterval());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, maxLoad_);
      }
      if (softMaxLoad_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, softMaxLoad_);
      }
      if (java.lang.Double.doubleToRawLongBits(costPerUnitAboveSoftMax_) != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(3, costPerUnitAboveSoftMax_);
      }
      if (startLoadInterval_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartLoadInterval());
      }
      if (endLoadInterval_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndLoadInterval());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.Vehicle.LoadLimit)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.Vehicle.LoadLimit other =
          (com.google.cloud.optimization.v1.Vehicle.LoadLimit) obj;

      if (hasMaxLoad() != other.hasMaxLoad()) return false;
      if (hasMaxLoad()) {
        if (getMaxLoad() != other.getMaxLoad()) return false;
      }
      if (getSoftMaxLoad() != other.getSoftMaxLoad()) return false;
      if (java.lang.Double.doubleToLongBits(getCostPerUnitAboveSoftMax())
          != java.lang.Double.doubleToLongBits(other.getCostPerUnitAboveSoftMax())) return false;
      if (hasStartLoadInterval() != other.hasStartLoadInterval()) return false;
      if (hasStartLoadInterval()) {
        if (!getStartLoadInterval().equals(other.getStartLoadInterval())) return false;
      }
      if (hasEndLoadInterval() != other.hasEndLoadInterval()) return false;
      if (hasEndLoadInterval()) {
        if (!getEndLoadInterval().equals(other.getEndLoadInterval())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMaxLoad()) {
        hash = (37 * hash) + MAX_LOAD_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxLoad());
      }
      hash = (37 * hash) + SOFT_MAX_LOAD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSoftMaxLoad());
      hash = (37 * hash) + COST_PER_UNIT_ABOVE_SOFT_MAX_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getCostPerUnitAboveSoftMax()));
      if (hasStartLoadInterval()) {
        hash = (37 * hash) + START_LOAD_INTERVAL_FIELD_NUMBER;
        hash = (53 * hash) + getStartLoadInterval().hashCode();
      }
      if (hasEndLoadInterval()) {
        hash = (37 * hash) + END_LOAD_INTERVAL_FIELD_NUMBER;
        hash = (53 * hash) + getEndLoadInterval().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.optimization.v1.Vehicle.LoadLimit prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines a load limit applying to a vehicle, e.g. "this truck may only
     * carry up to 3500 kg". See [load_limits][google.cloud.optimization.v1.Vehicle.load_limits].
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.Vehicle.LoadLimit}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.Vehicle.LoadLimit)
        com.google.cloud.optimization.v1.Vehicle.LoadLimitOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Vehicle_LoadLimit_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Vehicle_LoadLimit_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.Vehicle.LoadLimit.class,
                com.google.cloud.optimization.v1.Vehicle.LoadLimit.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.Vehicle.LoadLimit.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        maxLoad_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        softMaxLoad_ = 0L;

        costPerUnitAboveSoftMax_ = 0D;

        if (startLoadIntervalBuilder_ == null) {
          startLoadInterval_ = null;
        } else {
          startLoadInterval_ = null;
          startLoadIntervalBuilder_ = null;
        }
        if (endLoadIntervalBuilder_ == null) {
          endLoadInterval_ = null;
        } else {
          endLoadInterval_ = null;
          endLoadIntervalBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Vehicle_LoadLimit_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Vehicle.LoadLimit getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.Vehicle.LoadLimit.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Vehicle.LoadLimit build() {
        com.google.cloud.optimization.v1.Vehicle.LoadLimit result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Vehicle.LoadLimit buildPartial() {
        com.google.cloud.optimization.v1.Vehicle.LoadLimit result =
            new com.google.cloud.optimization.v1.Vehicle.LoadLimit(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.maxLoad_ = maxLoad_;
          to_bitField0_ |= 0x00000001;
        }
        result.softMaxLoad_ = softMaxLoad_;
        result.costPerUnitAboveSoftMax_ = costPerUnitAboveSoftMax_;
        if (startLoadIntervalBuilder_ == null) {
          result.startLoadInterval_ = startLoadInterval_;
        } else {
          result.startLoadInterval_ = startLoadIntervalBuilder_.build();
        }
        if (endLoadIntervalBuilder_ == null) {
          result.endLoadInterval_ = endLoadInterval_;
        } else {
          result.endLoadInterval_ = endLoadIntervalBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.Vehicle.LoadLimit) {
          return mergeFrom((com.google.cloud.optimization.v1.Vehicle.LoadLimit) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.Vehicle.LoadLimit other) {
        if (other == com.google.cloud.optimization.v1.Vehicle.LoadLimit.getDefaultInstance())
          return this;
        if (other.hasMaxLoad()) {
          setMaxLoad(other.getMaxLoad());
        }
        if (other.getSoftMaxLoad() != 0L) {
          setSoftMaxLoad(other.getSoftMaxLoad());
        }
        if (other.getCostPerUnitAboveSoftMax() != 0D) {
          setCostPerUnitAboveSoftMax(other.getCostPerUnitAboveSoftMax());
        }
        if (other.hasStartLoadInterval()) {
          mergeStartLoadInterval(other.getStartLoadInterval());
        }
        if (other.hasEndLoadInterval()) {
          mergeEndLoadInterval(other.getEndLoadInterval());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  maxLoad_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  softMaxLoad_ = input.readInt64();

                  break;
                } // case 16
              case 25:
                {
                  costPerUnitAboveSoftMax_ = input.readDouble();

                  break;
                } // case 25
              case 34:
                {
                  input.readMessage(
                      getStartLoadIntervalFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getEndLoadIntervalFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long maxLoad_;
      /**
       *
       *
       * <pre>
       * The maximum acceptable amount of load.
       * </pre>
       *
       * <code>optional int64 max_load = 1;</code>
       *
       * @return Whether the maxLoad field is set.
       */
      @java.lang.Override
      public boolean hasMaxLoad() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The maximum acceptable amount of load.
       * </pre>
       *
       * <code>optional int64 max_load = 1;</code>
       *
       * @return The maxLoad.
       */
      @java.lang.Override
      public long getMaxLoad() {
        return maxLoad_;
      }
      /**
       *
       *
       * <pre>
       * The maximum acceptable amount of load.
       * </pre>
       *
       * <code>optional int64 max_load = 1;</code>
       *
       * @param value The maxLoad to set.
       * @return This builder for chaining.
       */
      public Builder setMaxLoad(long value) {
        bitField0_ |= 0x00000001;
        maxLoad_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum acceptable amount of load.
       * </pre>
       *
       * <code>optional int64 max_load = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxLoad() {
        bitField0_ = (bitField0_ & ~0x00000001);
        maxLoad_ = 0L;
        onChanged();
        return this;
      }

      private long softMaxLoad_;
      /**
       *
       *
       * <pre>
       * A soft limit of the load. See [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max].
       * </pre>
       *
       * <code>int64 soft_max_load = 2;</code>
       *
       * @return The softMaxLoad.
       */
      @java.lang.Override
      public long getSoftMaxLoad() {
        return softMaxLoad_;
      }
      /**
       *
       *
       * <pre>
       * A soft limit of the load. See [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max].
       * </pre>
       *
       * <code>int64 soft_max_load = 2;</code>
       *
       * @param value The softMaxLoad to set.
       * @return This builder for chaining.
       */
      public Builder setSoftMaxLoad(long value) {

        softMaxLoad_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A soft limit of the load. See [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max].
       * </pre>
       *
       * <code>int64 soft_max_load = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSoftMaxLoad() {

        softMaxLoad_ = 0L;
        onChanged();
        return this;
      }

      private double costPerUnitAboveSoftMax_;
      /**
       *
       *
       * <pre>
       * If the load ever exceeds [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load] along this vehicle's route,
       * the following cost penalty applies (only once per vehicle):
       * (load - [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load]) * [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max]. All costs
       * add up and must be in the same unit as [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
       * </pre>
       *
       * <code>double cost_per_unit_above_soft_max = 3;</code>
       *
       * @return The costPerUnitAboveSoftMax.
       */
      @java.lang.Override
      public double getCostPerUnitAboveSoftMax() {
        return costPerUnitAboveSoftMax_;
      }
      /**
       *
       *
       * <pre>
       * If the load ever exceeds [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load] along this vehicle's route,
       * the following cost penalty applies (only once per vehicle):
       * (load - [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load]) * [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max]. All costs
       * add up and must be in the same unit as [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
       * </pre>
       *
       * <code>double cost_per_unit_above_soft_max = 3;</code>
       *
       * @param value The costPerUnitAboveSoftMax to set.
       * @return This builder for chaining.
       */
      public Builder setCostPerUnitAboveSoftMax(double value) {

        costPerUnitAboveSoftMax_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the load ever exceeds [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load] along this vehicle's route,
       * the following cost penalty applies (only once per vehicle):
       * (load - [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load]) * [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max]. All costs
       * add up and must be in the same unit as [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
       * </pre>
       *
       * <code>double cost_per_unit_above_soft_max = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCostPerUnitAboveSoftMax() {

        costPerUnitAboveSoftMax_ = 0D;
        onChanged();
        return this;
      }

      private com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval startLoadInterval_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval,
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder,
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder>
          startLoadIntervalBuilder_;
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the start of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
       * </code>
       *
       * @return Whether the startLoadInterval field is set.
       */
      public boolean hasStartLoadInterval() {
        return startLoadIntervalBuilder_ != null || startLoadInterval_ != null;
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the start of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
       * </code>
       *
       * @return The startLoadInterval.
       */
      public com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval getStartLoadInterval() {
        if (startLoadIntervalBuilder_ == null) {
          return startLoadInterval_ == null
              ? com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.getDefaultInstance()
              : startLoadInterval_;
        } else {
          return startLoadIntervalBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the start of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
       * </code>
       */
      public Builder setStartLoadInterval(
          com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval value) {
        if (startLoadIntervalBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startLoadInterval_ = value;
          onChanged();
        } else {
          startLoadIntervalBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the start of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
       * </code>
       */
      public Builder setStartLoadInterval(
          com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder builderForValue) {
        if (startLoadIntervalBuilder_ == null) {
          startLoadInterval_ = builderForValue.build();
          onChanged();
        } else {
          startLoadIntervalBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the start of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
       * </code>
       */
      public Builder mergeStartLoadInterval(
          com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval value) {
        if (startLoadIntervalBuilder_ == null) {
          if (startLoadInterval_ != null) {
            startLoadInterval_ =
                com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.newBuilder(
                        startLoadInterval_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            startLoadInterval_ = value;
          }
          onChanged();
        } else {
          startLoadIntervalBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the start of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
       * </code>
       */
      public Builder clearStartLoadInterval() {
        if (startLoadIntervalBuilder_ == null) {
          startLoadInterval_ = null;
          onChanged();
        } else {
          startLoadInterval_ = null;
          startLoadIntervalBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the start of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
       * </code>
       */
      public com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder
          getStartLoadIntervalBuilder() {

        onChanged();
        return getStartLoadIntervalFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the start of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
       * </code>
       */
      public com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder
          getStartLoadIntervalOrBuilder() {
        if (startLoadIntervalBuilder_ != null) {
          return startLoadIntervalBuilder_.getMessageOrBuilder();
        } else {
          return startLoadInterval_ == null
              ? com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.getDefaultInstance()
              : startLoadInterval_;
        }
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the start of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval start_load_interval = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval,
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder,
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder>
          getStartLoadIntervalFieldBuilder() {
        if (startLoadIntervalBuilder_ == null) {
          startLoadIntervalBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval,
                  com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder,
                  com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder>(
                  getStartLoadInterval(), getParentForChildren(), isClean());
          startLoadInterval_ = null;
        }
        return startLoadIntervalBuilder_;
      }

      private com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval endLoadInterval_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval,
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder,
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder>
          endLoadIntervalBuilder_;
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the end of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;
       * </code>
       *
       * @return Whether the endLoadInterval field is set.
       */
      public boolean hasEndLoadInterval() {
        return endLoadIntervalBuilder_ != null || endLoadInterval_ != null;
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the end of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;
       * </code>
       *
       * @return The endLoadInterval.
       */
      public com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval getEndLoadInterval() {
        if (endLoadIntervalBuilder_ == null) {
          return endLoadInterval_ == null
              ? com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.getDefaultInstance()
              : endLoadInterval_;
        } else {
          return endLoadIntervalBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the end of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;
       * </code>
       */
      public Builder setEndLoadInterval(
          com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval value) {
        if (endLoadIntervalBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endLoadInterval_ = value;
          onChanged();
        } else {
          endLoadIntervalBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the end of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;
       * </code>
       */
      public Builder setEndLoadInterval(
          com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder builderForValue) {
        if (endLoadIntervalBuilder_ == null) {
          endLoadInterval_ = builderForValue.build();
          onChanged();
        } else {
          endLoadIntervalBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the end of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;
       * </code>
       */
      public Builder mergeEndLoadInterval(
          com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval value) {
        if (endLoadIntervalBuilder_ == null) {
          if (endLoadInterval_ != null) {
            endLoadInterval_ =
                com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.newBuilder(
                        endLoadInterval_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            endLoadInterval_ = value;
          }
          onChanged();
        } else {
          endLoadIntervalBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the end of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;
       * </code>
       */
      public Builder clearEndLoadInterval() {
        if (endLoadIntervalBuilder_ == null) {
          endLoadInterval_ = null;
          onChanged();
        } else {
          endLoadInterval_ = null;
          endLoadIntervalBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the end of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;
       * </code>
       */
      public com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder
          getEndLoadIntervalBuilder() {

        onChanged();
        return getEndLoadIntervalFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the end of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;
       * </code>
       */
      public com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder
          getEndLoadIntervalOrBuilder() {
        if (endLoadIntervalBuilder_ != null) {
          return endLoadIntervalBuilder_.getMessageOrBuilder();
        } else {
          return endLoadInterval_ == null
              ? com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.getDefaultInstance()
              : endLoadInterval_;
        }
      }
      /**
       *
       *
       * <pre>
       * The acceptable load interval of the vehicle at the end of the route.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval end_load_interval = 5;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval,
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder,
              com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder>
          getEndLoadIntervalFieldBuilder() {
        if (endLoadIntervalBuilder_ == null) {
          endLoadIntervalBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval,
                  com.google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.Builder,
                  com.google.cloud.optimization.v1.Vehicle.LoadLimit.IntervalOrBuilder>(
                  getEndLoadInterval(), getParentForChildren(), isClean());
          endLoadInterval_ = null;
        }
        return endLoadIntervalBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.Vehicle.LoadLimit)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.Vehicle.LoadLimit)
    private static final com.google.cloud.optimization.v1.Vehicle.LoadLimit DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.Vehicle.LoadLimit();
    }

    public static com.google.cloud.optimization.v1.Vehicle.LoadLimit getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LoadLimit> PARSER =
        new com.google.protobuf.AbstractParser<LoadLimit>() {
          @java.lang.Override
          public LoadLimit parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LoadLimit> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LoadLimit> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle.LoadLimit getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DurationLimitOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.Vehicle.DurationLimit)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A hard limit constraining the duration to be at most max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 1;</code>
     *
     * @return Whether the maxDuration field is set.
     */
    boolean hasMaxDuration();
    /**
     *
     *
     * <pre>
     * A hard limit constraining the duration to be at most max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 1;</code>
     *
     * @return The maxDuration.
     */
    com.google.protobuf.Duration getMaxDuration();
    /**
     *
     *
     * <pre>
     * A hard limit constraining the duration to be at most max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 1;</code>
     */
    com.google.protobuf.DurationOrBuilder getMaxDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost. This cost adds up to other costs defined in
     * the model, with the same unit.
     * If defined, `soft_max_duration` must be nonnegative. If max_duration is
     * also defined, `soft_max_duration` must be less than max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
     *
     * @return Whether the softMaxDuration field is set.
     */
    boolean hasSoftMaxDuration();
    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost. This cost adds up to other costs defined in
     * the model, with the same unit.
     * If defined, `soft_max_duration` must be nonnegative. If max_duration is
     * also defined, `soft_max_duration` must be less than max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
     *
     * @return The softMaxDuration.
     */
    com.google.protobuf.Duration getSoftMaxDuration();
    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost. This cost adds up to other costs defined in
     * the model, with the same unit.
     * If defined, `soft_max_duration` must be nonnegative. If max_duration is
     * also defined, `soft_max_duration` must be less than max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
     */
    com.google.protobuf.DurationOrBuilder getSoftMaxDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Cost per hour incurred if the `soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_hour_after_soft_max * (duration - soft_max_duration)
     * ```
     * The cost must be nonnegative.
     * </pre>
     *
     * <code>optional double cost_per_hour_after_soft_max = 3;</code>
     *
     * @return Whether the costPerHourAfterSoftMax field is set.
     */
    boolean hasCostPerHourAfterSoftMax();
    /**
     *
     *
     * <pre>
     * Cost per hour incurred if the `soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_hour_after_soft_max * (duration - soft_max_duration)
     * ```
     * The cost must be nonnegative.
     * </pre>
     *
     * <code>optional double cost_per_hour_after_soft_max = 3;</code>
     *
     * @return The costPerHourAfterSoftMax.
     */
    double getCostPerHourAfterSoftMax();

    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost, quadratic in the duration. This cost adds
     * up to other costs defined in the model, with the same unit.
     * If defined, `quadratic_soft_max_duration` must be nonnegative. If
     * `max_duration` is also defined, `quadratic_soft_max_duration` must be
     * less than `max_duration`, and the difference must be no larger than one
     * day:
     *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
     * </pre>
     *
     * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
     *
     * @return Whether the quadraticSoftMaxDuration field is set.
     */
    boolean hasQuadraticSoftMaxDuration();
    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost, quadratic in the duration. This cost adds
     * up to other costs defined in the model, with the same unit.
     * If defined, `quadratic_soft_max_duration` must be nonnegative. If
     * `max_duration` is also defined, `quadratic_soft_max_duration` must be
     * less than `max_duration`, and the difference must be no larger than one
     * day:
     *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
     * </pre>
     *
     * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
     *
     * @return The quadraticSoftMaxDuration.
     */
    com.google.protobuf.Duration getQuadraticSoftMaxDuration();
    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost, quadratic in the duration. This cost adds
     * up to other costs defined in the model, with the same unit.
     * If defined, `quadratic_soft_max_duration` must be nonnegative. If
     * `max_duration` is also defined, `quadratic_soft_max_duration` must be
     * less than `max_duration`, and the difference must be no larger than one
     * day:
     *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
     * </pre>
     *
     * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
     */
    com.google.protobuf.DurationOrBuilder getQuadraticSoftMaxDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Cost per square hour incurred if the
     * `quadratic_soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_square_hour_after_quadratic_soft_max *
     *   (duration - quadratic_soft_max_duration)^2
     * ```
     * The cost must be nonnegative.
     * </pre>
     *
     * <code>optional double cost_per_square_hour_after_quadratic_soft_max = 5;</code>
     *
     * @return Whether the costPerSquareHourAfterQuadraticSoftMax field is set.
     */
    boolean hasCostPerSquareHourAfterQuadraticSoftMax();
    /**
     *
     *
     * <pre>
     * Cost per square hour incurred if the
     * `quadratic_soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_square_hour_after_quadratic_soft_max *
     *   (duration - quadratic_soft_max_duration)^2
     * ```
     * The cost must be nonnegative.
     * </pre>
     *
     * <code>optional double cost_per_square_hour_after_quadratic_soft_max = 5;</code>
     *
     * @return The costPerSquareHourAfterQuadraticSoftMax.
     */
    double getCostPerSquareHourAfterQuadraticSoftMax();
  }
  /**
   *
   *
   * <pre>
   * A limit defining a maximum duration of the route of a vehicle. It can be
   * either hard or soft.
   * When a soft limit field is defined, both the soft max threshold and its
   * associated cost must be defined together.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.Vehicle.DurationLimit}
   */
  public static final class DurationLimit extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.Vehicle.DurationLimit)
      DurationLimitOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DurationLimit.newBuilder() to construct.
    private DurationLimit(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DurationLimit() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DurationLimit();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Vehicle_DurationLimit_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Vehicle_DurationLimit_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.Vehicle.DurationLimit.class,
              com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder.class);
    }

    private int bitField0_;
    public static final int MAX_DURATION_FIELD_NUMBER = 1;
    private com.google.protobuf.Duration maxDuration_;
    /**
     *
     *
     * <pre>
     * A hard limit constraining the duration to be at most max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 1;</code>
     *
     * @return Whether the maxDuration field is set.
     */
    @java.lang.Override
    public boolean hasMaxDuration() {
      return maxDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * A hard limit constraining the duration to be at most max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 1;</code>
     *
     * @return The maxDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMaxDuration() {
      return maxDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : maxDuration_;
    }
    /**
     *
     *
     * <pre>
     * A hard limit constraining the duration to be at most max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMaxDurationOrBuilder() {
      return getMaxDuration();
    }

    public static final int SOFT_MAX_DURATION_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration softMaxDuration_;
    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost. This cost adds up to other costs defined in
     * the model, with the same unit.
     * If defined, `soft_max_duration` must be nonnegative. If max_duration is
     * also defined, `soft_max_duration` must be less than max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
     *
     * @return Whether the softMaxDuration field is set.
     */
    @java.lang.Override
    public boolean hasSoftMaxDuration() {
      return softMaxDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost. This cost adds up to other costs defined in
     * the model, with the same unit.
     * If defined, `soft_max_duration` must be nonnegative. If max_duration is
     * also defined, `soft_max_duration` must be less than max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
     *
     * @return The softMaxDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getSoftMaxDuration() {
      return softMaxDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : softMaxDuration_;
    }
    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost. This cost adds up to other costs defined in
     * the model, with the same unit.
     * If defined, `soft_max_duration` must be nonnegative. If max_duration is
     * also defined, `soft_max_duration` must be less than max_duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getSoftMaxDurationOrBuilder() {
      return getSoftMaxDuration();
    }

    public static final int COST_PER_HOUR_AFTER_SOFT_MAX_FIELD_NUMBER = 3;
    private double costPerHourAfterSoftMax_;
    /**
     *
     *
     * <pre>
     * Cost per hour incurred if the `soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_hour_after_soft_max * (duration - soft_max_duration)
     * ```
     * The cost must be nonnegative.
     * </pre>
     *
     * <code>optional double cost_per_hour_after_soft_max = 3;</code>
     *
     * @return Whether the costPerHourAfterSoftMax field is set.
     */
    @java.lang.Override
    public boolean hasCostPerHourAfterSoftMax() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cost per hour incurred if the `soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_hour_after_soft_max * (duration - soft_max_duration)
     * ```
     * The cost must be nonnegative.
     * </pre>
     *
     * <code>optional double cost_per_hour_after_soft_max = 3;</code>
     *
     * @return The costPerHourAfterSoftMax.
     */
    @java.lang.Override
    public double getCostPerHourAfterSoftMax() {
      return costPerHourAfterSoftMax_;
    }

    public static final int QUADRATIC_SOFT_MAX_DURATION_FIELD_NUMBER = 4;
    private com.google.protobuf.Duration quadraticSoftMaxDuration_;
    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost, quadratic in the duration. This cost adds
     * up to other costs defined in the model, with the same unit.
     * If defined, `quadratic_soft_max_duration` must be nonnegative. If
     * `max_duration` is also defined, `quadratic_soft_max_duration` must be
     * less than `max_duration`, and the difference must be no larger than one
     * day:
     *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
     * </pre>
     *
     * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
     *
     * @return Whether the quadraticSoftMaxDuration field is set.
     */
    @java.lang.Override
    public boolean hasQuadraticSoftMaxDuration() {
      return quadraticSoftMaxDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost, quadratic in the duration. This cost adds
     * up to other costs defined in the model, with the same unit.
     * If defined, `quadratic_soft_max_duration` must be nonnegative. If
     * `max_duration` is also defined, `quadratic_soft_max_duration` must be
     * less than `max_duration`, and the difference must be no larger than one
     * day:
     *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
     * </pre>
     *
     * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
     *
     * @return The quadraticSoftMaxDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getQuadraticSoftMaxDuration() {
      return quadraticSoftMaxDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : quadraticSoftMaxDuration_;
    }
    /**
     *
     *
     * <pre>
     * A soft limit not enforcing a maximum duration limit, but when violated
     * makes the route incur a cost, quadratic in the duration. This cost adds
     * up to other costs defined in the model, with the same unit.
     * If defined, `quadratic_soft_max_duration` must be nonnegative. If
     * `max_duration` is also defined, `quadratic_soft_max_duration` must be
     * less than `max_duration`, and the difference must be no larger than one
     * day:
     *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
     * </pre>
     *
     * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getQuadraticSoftMaxDurationOrBuilder() {
      return getQuadraticSoftMaxDuration();
    }

    public static final int COST_PER_SQUARE_HOUR_AFTER_QUADRATIC_SOFT_MAX_FIELD_NUMBER = 5;
    private double costPerSquareHourAfterQuadraticSoftMax_;
    /**
     *
     *
     * <pre>
     * Cost per square hour incurred if the
     * `quadratic_soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_square_hour_after_quadratic_soft_max *
     *   (duration - quadratic_soft_max_duration)^2
     * ```
     * The cost must be nonnegative.
     * </pre>
     *
     * <code>optional double cost_per_square_hour_after_quadratic_soft_max = 5;</code>
     *
     * @return Whether the costPerSquareHourAfterQuadraticSoftMax field is set.
     */
    @java.lang.Override
    public boolean hasCostPerSquareHourAfterQuadraticSoftMax() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cost per square hour incurred if the
     * `quadratic_soft_max_duration` threshold is violated.
     * The additional cost is 0 if the duration is under the threshold,
     * otherwise the cost depends on the duration as follows:
     * ```
     *   cost_per_square_hour_after_quadratic_soft_max *
     *   (duration - quadratic_soft_max_duration)^2
     * ```
     * The cost must be nonnegative.
     * </pre>
     *
     * <code>optional double cost_per_square_hour_after_quadratic_soft_max = 5;</code>
     *
     * @return The costPerSquareHourAfterQuadraticSoftMax.
     */
    @java.lang.Override
    public double getCostPerSquareHourAfterQuadraticSoftMax() {
      return costPerSquareHourAfterQuadraticSoftMax_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (maxDuration_ != null) {
        output.writeMessage(1, getMaxDuration());
      }
      if (softMaxDuration_ != null) {
        output.writeMessage(2, getSoftMaxDuration());
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeDouble(3, costPerHourAfterSoftMax_);
      }
      if (quadraticSoftMaxDuration_ != null) {
        output.writeMessage(4, getQuadraticSoftMaxDuration());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeDouble(5, costPerSquareHourAfterQuadraticSoftMax_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (maxDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMaxDuration());
      }
      if (softMaxDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSoftMaxDuration());
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(3, costPerHourAfterSoftMax_);
      }
      if (quadraticSoftMaxDuration_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getQuadraticSoftMaxDuration());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                5, costPerSquareHourAfterQuadraticSoftMax_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.Vehicle.DurationLimit)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.Vehicle.DurationLimit other =
          (com.google.cloud.optimization.v1.Vehicle.DurationLimit) obj;

      if (hasMaxDuration() != other.hasMaxDuration()) return false;
      if (hasMaxDuration()) {
        if (!getMaxDuration().equals(other.getMaxDuration())) return false;
      }
      if (hasSoftMaxDuration() != other.hasSoftMaxDuration()) return false;
      if (hasSoftMaxDuration()) {
        if (!getSoftMaxDuration().equals(other.getSoftMaxDuration())) return false;
      }
      if (hasCostPerHourAfterSoftMax() != other.hasCostPerHourAfterSoftMax()) return false;
      if (hasCostPerHourAfterSoftMax()) {
        if (java.lang.Double.doubleToLongBits(getCostPerHourAfterSoftMax())
            != java.lang.Double.doubleToLongBits(other.getCostPerHourAfterSoftMax())) return false;
      }
      if (hasQuadraticSoftMaxDuration() != other.hasQuadraticSoftMaxDuration()) return false;
      if (hasQuadraticSoftMaxDuration()) {
        if (!getQuadraticSoftMaxDuration().equals(other.getQuadraticSoftMaxDuration()))
          return false;
      }
      if (hasCostPerSquareHourAfterQuadraticSoftMax()
          != other.hasCostPerSquareHourAfterQuadraticSoftMax()) return false;
      if (hasCostPerSquareHourAfterQuadraticSoftMax()) {
        if (java.lang.Double.doubleToLongBits(getCostPerSquareHourAfterQuadraticSoftMax())
            != java.lang.Double.doubleToLongBits(other.getCostPerSquareHourAfterQuadraticSoftMax()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMaxDuration()) {
        hash = (37 * hash) + MAX_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getMaxDuration().hashCode();
      }
      if (hasSoftMaxDuration()) {
        hash = (37 * hash) + SOFT_MAX_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getSoftMaxDuration().hashCode();
      }
      if (hasCostPerHourAfterSoftMax()) {
        hash = (37 * hash) + COST_PER_HOUR_AFTER_SOFT_MAX_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getCostPerHourAfterSoftMax()));
      }
      if (hasQuadraticSoftMaxDuration()) {
        hash = (37 * hash) + QUADRATIC_SOFT_MAX_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getQuadraticSoftMaxDuration().hashCode();
      }
      if (hasCostPerSquareHourAfterQuadraticSoftMax()) {
        hash = (37 * hash) + COST_PER_SQUARE_HOUR_AFTER_QUADRATIC_SOFT_MAX_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getCostPerSquareHourAfterQuadraticSoftMax()));
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.Vehicle.DurationLimit prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A limit defining a maximum duration of the route of a vehicle. It can be
     * either hard or soft.
     * When a soft limit field is defined, both the soft max threshold and its
     * associated cost must be defined together.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.Vehicle.DurationLimit}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.Vehicle.DurationLimit)
        com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Vehicle_DurationLimit_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Vehicle_DurationLimit_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.Vehicle.DurationLimit.class,
                com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.Vehicle.DurationLimit.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (maxDurationBuilder_ == null) {
          maxDuration_ = null;
        } else {
          maxDuration_ = null;
          maxDurationBuilder_ = null;
        }
        if (softMaxDurationBuilder_ == null) {
          softMaxDuration_ = null;
        } else {
          softMaxDuration_ = null;
          softMaxDurationBuilder_ = null;
        }
        costPerHourAfterSoftMax_ = 0D;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (quadraticSoftMaxDurationBuilder_ == null) {
          quadraticSoftMaxDuration_ = null;
        } else {
          quadraticSoftMaxDuration_ = null;
          quadraticSoftMaxDurationBuilder_ = null;
        }
        costPerSquareHourAfterQuadraticSoftMax_ = 0D;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Vehicle_DurationLimit_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Vehicle.DurationLimit getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.Vehicle.DurationLimit.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Vehicle.DurationLimit build() {
        com.google.cloud.optimization.v1.Vehicle.DurationLimit result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Vehicle.DurationLimit buildPartial() {
        com.google.cloud.optimization.v1.Vehicle.DurationLimit result =
            new com.google.cloud.optimization.v1.Vehicle.DurationLimit(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (maxDurationBuilder_ == null) {
          result.maxDuration_ = maxDuration_;
        } else {
          result.maxDuration_ = maxDurationBuilder_.build();
        }
        if (softMaxDurationBuilder_ == null) {
          result.softMaxDuration_ = softMaxDuration_;
        } else {
          result.softMaxDuration_ = softMaxDurationBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.costPerHourAfterSoftMax_ = costPerHourAfterSoftMax_;
          to_bitField0_ |= 0x00000001;
        }
        if (quadraticSoftMaxDurationBuilder_ == null) {
          result.quadraticSoftMaxDuration_ = quadraticSoftMaxDuration_;
        } else {
          result.quadraticSoftMaxDuration_ = quadraticSoftMaxDurationBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.costPerSquareHourAfterQuadraticSoftMax_ = costPerSquareHourAfterQuadraticSoftMax_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.Vehicle.DurationLimit) {
          return mergeFrom((com.google.cloud.optimization.v1.Vehicle.DurationLimit) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.Vehicle.DurationLimit other) {
        if (other == com.google.cloud.optimization.v1.Vehicle.DurationLimit.getDefaultInstance())
          return this;
        if (other.hasMaxDuration()) {
          mergeMaxDuration(other.getMaxDuration());
        }
        if (other.hasSoftMaxDuration()) {
          mergeSoftMaxDuration(other.getSoftMaxDuration());
        }
        if (other.hasCostPerHourAfterSoftMax()) {
          setCostPerHourAfterSoftMax(other.getCostPerHourAfterSoftMax());
        }
        if (other.hasQuadraticSoftMaxDuration()) {
          mergeQuadraticSoftMaxDuration(other.getQuadraticSoftMaxDuration());
        }
        if (other.hasCostPerSquareHourAfterQuadraticSoftMax()) {
          setCostPerSquareHourAfterQuadraticSoftMax(
              other.getCostPerSquareHourAfterQuadraticSoftMax());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getMaxDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getSoftMaxDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              case 25:
                {
                  costPerHourAfterSoftMax_ = input.readDouble();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 25
              case 34:
                {
                  input.readMessage(
                      getQuadraticSoftMaxDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 34
              case 41:
                {
                  costPerSquareHourAfterQuadraticSoftMax_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 41
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Duration maxDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          maxDurationBuilder_;
      /**
       *
       *
       * <pre>
       * A hard limit constraining the duration to be at most max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration = 1;</code>
       *
       * @return Whether the maxDuration field is set.
       */
      public boolean hasMaxDuration() {
        return maxDurationBuilder_ != null || maxDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * A hard limit constraining the duration to be at most max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration = 1;</code>
       *
       * @return The maxDuration.
       */
      public com.google.protobuf.Duration getMaxDuration() {
        if (maxDurationBuilder_ == null) {
          return maxDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : maxDuration_;
        } else {
          return maxDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A hard limit constraining the duration to be at most max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration = 1;</code>
       */
      public Builder setMaxDuration(com.google.protobuf.Duration value) {
        if (maxDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxDuration_ = value;
          onChanged();
        } else {
          maxDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A hard limit constraining the duration to be at most max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration = 1;</code>
       */
      public Builder setMaxDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (maxDurationBuilder_ == null) {
          maxDuration_ = builderForValue.build();
          onChanged();
        } else {
          maxDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A hard limit constraining the duration to be at most max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration = 1;</code>
       */
      public Builder mergeMaxDuration(com.google.protobuf.Duration value) {
        if (maxDurationBuilder_ == null) {
          if (maxDuration_ != null) {
            maxDuration_ =
                com.google.protobuf.Duration.newBuilder(maxDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            maxDuration_ = value;
          }
          onChanged();
        } else {
          maxDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A hard limit constraining the duration to be at most max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration = 1;</code>
       */
      public Builder clearMaxDuration() {
        if (maxDurationBuilder_ == null) {
          maxDuration_ = null;
          onChanged();
        } else {
          maxDuration_ = null;
          maxDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A hard limit constraining the duration to be at most max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration = 1;</code>
       */
      public com.google.protobuf.Duration.Builder getMaxDurationBuilder() {

        onChanged();
        return getMaxDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A hard limit constraining the duration to be at most max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration = 1;</code>
       */
      public com.google.protobuf.DurationOrBuilder getMaxDurationOrBuilder() {
        if (maxDurationBuilder_ != null) {
          return maxDurationBuilder_.getMessageOrBuilder();
        } else {
          return maxDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : maxDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * A hard limit constraining the duration to be at most max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMaxDurationFieldBuilder() {
        if (maxDurationBuilder_ == null) {
          maxDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMaxDuration(), getParentForChildren(), isClean());
          maxDuration_ = null;
        }
        return maxDurationBuilder_;
      }

      private com.google.protobuf.Duration softMaxDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          softMaxDurationBuilder_;
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost. This cost adds up to other costs defined in
       * the model, with the same unit.
       * If defined, `soft_max_duration` must be nonnegative. If max_duration is
       * also defined, `soft_max_duration` must be less than max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
       *
       * @return Whether the softMaxDuration field is set.
       */
      public boolean hasSoftMaxDuration() {
        return softMaxDurationBuilder_ != null || softMaxDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost. This cost adds up to other costs defined in
       * the model, with the same unit.
       * If defined, `soft_max_duration` must be nonnegative. If max_duration is
       * also defined, `soft_max_duration` must be less than max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
       *
       * @return The softMaxDuration.
       */
      public com.google.protobuf.Duration getSoftMaxDuration() {
        if (softMaxDurationBuilder_ == null) {
          return softMaxDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : softMaxDuration_;
        } else {
          return softMaxDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost. This cost adds up to other costs defined in
       * the model, with the same unit.
       * If defined, `soft_max_duration` must be nonnegative. If max_duration is
       * also defined, `soft_max_duration` must be less than max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
       */
      public Builder setSoftMaxDuration(com.google.protobuf.Duration value) {
        if (softMaxDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          softMaxDuration_ = value;
          onChanged();
        } else {
          softMaxDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost. This cost adds up to other costs defined in
       * the model, with the same unit.
       * If defined, `soft_max_duration` must be nonnegative. If max_duration is
       * also defined, `soft_max_duration` must be less than max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
       */
      public Builder setSoftMaxDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (softMaxDurationBuilder_ == null) {
          softMaxDuration_ = builderForValue.build();
          onChanged();
        } else {
          softMaxDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost. This cost adds up to other costs defined in
       * the model, with the same unit.
       * If defined, `soft_max_duration` must be nonnegative. If max_duration is
       * also defined, `soft_max_duration` must be less than max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
       */
      public Builder mergeSoftMaxDuration(com.google.protobuf.Duration value) {
        if (softMaxDurationBuilder_ == null) {
          if (softMaxDuration_ != null) {
            softMaxDuration_ =
                com.google.protobuf.Duration.newBuilder(softMaxDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            softMaxDuration_ = value;
          }
          onChanged();
        } else {
          softMaxDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost. This cost adds up to other costs defined in
       * the model, with the same unit.
       * If defined, `soft_max_duration` must be nonnegative. If max_duration is
       * also defined, `soft_max_duration` must be less than max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
       */
      public Builder clearSoftMaxDuration() {
        if (softMaxDurationBuilder_ == null) {
          softMaxDuration_ = null;
          onChanged();
        } else {
          softMaxDuration_ = null;
          softMaxDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost. This cost adds up to other costs defined in
       * the model, with the same unit.
       * If defined, `soft_max_duration` must be nonnegative. If max_duration is
       * also defined, `soft_max_duration` must be less than max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
       */
      public com.google.protobuf.Duration.Builder getSoftMaxDurationBuilder() {

        onChanged();
        return getSoftMaxDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost. This cost adds up to other costs defined in
       * the model, with the same unit.
       * If defined, `soft_max_duration` must be nonnegative. If max_duration is
       * also defined, `soft_max_duration` must be less than max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
       */
      public com.google.protobuf.DurationOrBuilder getSoftMaxDurationOrBuilder() {
        if (softMaxDurationBuilder_ != null) {
          return softMaxDurationBuilder_.getMessageOrBuilder();
        } else {
          return softMaxDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : softMaxDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost. This cost adds up to other costs defined in
       * the model, with the same unit.
       * If defined, `soft_max_duration` must be nonnegative. If max_duration is
       * also defined, `soft_max_duration` must be less than max_duration.
       * </pre>
       *
       * <code>.google.protobuf.Duration soft_max_duration = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getSoftMaxDurationFieldBuilder() {
        if (softMaxDurationBuilder_ == null) {
          softMaxDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getSoftMaxDuration(), getParentForChildren(), isClean());
          softMaxDuration_ = null;
        }
        return softMaxDurationBuilder_;
      }

      private double costPerHourAfterSoftMax_;
      /**
       *
       *
       * <pre>
       * Cost per hour incurred if the `soft_max_duration` threshold is violated.
       * The additional cost is 0 if the duration is under the threshold,
       * otherwise the cost depends on the duration as follows:
       * ```
       *   cost_per_hour_after_soft_max * (duration - soft_max_duration)
       * ```
       * The cost must be nonnegative.
       * </pre>
       *
       * <code>optional double cost_per_hour_after_soft_max = 3;</code>
       *
       * @return Whether the costPerHourAfterSoftMax field is set.
       */
      @java.lang.Override
      public boolean hasCostPerHourAfterSoftMax() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Cost per hour incurred if the `soft_max_duration` threshold is violated.
       * The additional cost is 0 if the duration is under the threshold,
       * otherwise the cost depends on the duration as follows:
       * ```
       *   cost_per_hour_after_soft_max * (duration - soft_max_duration)
       * ```
       * The cost must be nonnegative.
       * </pre>
       *
       * <code>optional double cost_per_hour_after_soft_max = 3;</code>
       *
       * @return The costPerHourAfterSoftMax.
       */
      @java.lang.Override
      public double getCostPerHourAfterSoftMax() {
        return costPerHourAfterSoftMax_;
      }
      /**
       *
       *
       * <pre>
       * Cost per hour incurred if the `soft_max_duration` threshold is violated.
       * The additional cost is 0 if the duration is under the threshold,
       * otherwise the cost depends on the duration as follows:
       * ```
       *   cost_per_hour_after_soft_max * (duration - soft_max_duration)
       * ```
       * The cost must be nonnegative.
       * </pre>
       *
       * <code>optional double cost_per_hour_after_soft_max = 3;</code>
       *
       * @param value The costPerHourAfterSoftMax to set.
       * @return This builder for chaining.
       */
      public Builder setCostPerHourAfterSoftMax(double value) {
        bitField0_ |= 0x00000001;
        costPerHourAfterSoftMax_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cost per hour incurred if the `soft_max_duration` threshold is violated.
       * The additional cost is 0 if the duration is under the threshold,
       * otherwise the cost depends on the duration as follows:
       * ```
       *   cost_per_hour_after_soft_max * (duration - soft_max_duration)
       * ```
       * The cost must be nonnegative.
       * </pre>
       *
       * <code>optional double cost_per_hour_after_soft_max = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCostPerHourAfterSoftMax() {
        bitField0_ = (bitField0_ & ~0x00000001);
        costPerHourAfterSoftMax_ = 0D;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration quadraticSoftMaxDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          quadraticSoftMaxDurationBuilder_;
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost, quadratic in the duration. This cost adds
       * up to other costs defined in the model, with the same unit.
       * If defined, `quadratic_soft_max_duration` must be nonnegative. If
       * `max_duration` is also defined, `quadratic_soft_max_duration` must be
       * less than `max_duration`, and the difference must be no larger than one
       * day:
       *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
       * </pre>
       *
       * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
       *
       * @return Whether the quadraticSoftMaxDuration field is set.
       */
      public boolean hasQuadraticSoftMaxDuration() {
        return quadraticSoftMaxDurationBuilder_ != null || quadraticSoftMaxDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost, quadratic in the duration. This cost adds
       * up to other costs defined in the model, with the same unit.
       * If defined, `quadratic_soft_max_duration` must be nonnegative. If
       * `max_duration` is also defined, `quadratic_soft_max_duration` must be
       * less than `max_duration`, and the difference must be no larger than one
       * day:
       *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
       * </pre>
       *
       * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
       *
       * @return The quadraticSoftMaxDuration.
       */
      public com.google.protobuf.Duration getQuadraticSoftMaxDuration() {
        if (quadraticSoftMaxDurationBuilder_ == null) {
          return quadraticSoftMaxDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : quadraticSoftMaxDuration_;
        } else {
          return quadraticSoftMaxDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost, quadratic in the duration. This cost adds
       * up to other costs defined in the model, with the same unit.
       * If defined, `quadratic_soft_max_duration` must be nonnegative. If
       * `max_duration` is also defined, `quadratic_soft_max_duration` must be
       * less than `max_duration`, and the difference must be no larger than one
       * day:
       *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
       * </pre>
       *
       * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
       */
      public Builder setQuadraticSoftMaxDuration(com.google.protobuf.Duration value) {
        if (quadraticSoftMaxDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          quadraticSoftMaxDuration_ = value;
          onChanged();
        } else {
          quadraticSoftMaxDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost, quadratic in the duration. This cost adds
       * up to other costs defined in the model, with the same unit.
       * If defined, `quadratic_soft_max_duration` must be nonnegative. If
       * `max_duration` is also defined, `quadratic_soft_max_duration` must be
       * less than `max_duration`, and the difference must be no larger than one
       * day:
       *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
       * </pre>
       *
       * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
       */
      public Builder setQuadraticSoftMaxDuration(
          com.google.protobuf.Duration.Builder builderForValue) {
        if (quadraticSoftMaxDurationBuilder_ == null) {
          quadraticSoftMaxDuration_ = builderForValue.build();
          onChanged();
        } else {
          quadraticSoftMaxDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost, quadratic in the duration. This cost adds
       * up to other costs defined in the model, with the same unit.
       * If defined, `quadratic_soft_max_duration` must be nonnegative. If
       * `max_duration` is also defined, `quadratic_soft_max_duration` must be
       * less than `max_duration`, and the difference must be no larger than one
       * day:
       *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
       * </pre>
       *
       * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
       */
      public Builder mergeQuadraticSoftMaxDuration(com.google.protobuf.Duration value) {
        if (quadraticSoftMaxDurationBuilder_ == null) {
          if (quadraticSoftMaxDuration_ != null) {
            quadraticSoftMaxDuration_ =
                com.google.protobuf.Duration.newBuilder(quadraticSoftMaxDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            quadraticSoftMaxDuration_ = value;
          }
          onChanged();
        } else {
          quadraticSoftMaxDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost, quadratic in the duration. This cost adds
       * up to other costs defined in the model, with the same unit.
       * If defined, `quadratic_soft_max_duration` must be nonnegative. If
       * `max_duration` is also defined, `quadratic_soft_max_duration` must be
       * less than `max_duration`, and the difference must be no larger than one
       * day:
       *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
       * </pre>
       *
       * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
       */
      public Builder clearQuadraticSoftMaxDuration() {
        if (quadraticSoftMaxDurationBuilder_ == null) {
          quadraticSoftMaxDuration_ = null;
          onChanged();
        } else {
          quadraticSoftMaxDuration_ = null;
          quadraticSoftMaxDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost, quadratic in the duration. This cost adds
       * up to other costs defined in the model, with the same unit.
       * If defined, `quadratic_soft_max_duration` must be nonnegative. If
       * `max_duration` is also defined, `quadratic_soft_max_duration` must be
       * less than `max_duration`, and the difference must be no larger than one
       * day:
       *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
       * </pre>
       *
       * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
       */
      public com.google.protobuf.Duration.Builder getQuadraticSoftMaxDurationBuilder() {

        onChanged();
        return getQuadraticSoftMaxDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost, quadratic in the duration. This cost adds
       * up to other costs defined in the model, with the same unit.
       * If defined, `quadratic_soft_max_duration` must be nonnegative. If
       * `max_duration` is also defined, `quadratic_soft_max_duration` must be
       * less than `max_duration`, and the difference must be no larger than one
       * day:
       *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
       * </pre>
       *
       * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
       */
      public com.google.protobuf.DurationOrBuilder getQuadraticSoftMaxDurationOrBuilder() {
        if (quadraticSoftMaxDurationBuilder_ != null) {
          return quadraticSoftMaxDurationBuilder_.getMessageOrBuilder();
        } else {
          return quadraticSoftMaxDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : quadraticSoftMaxDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * A soft limit not enforcing a maximum duration limit, but when violated
       * makes the route incur a cost, quadratic in the duration. This cost adds
       * up to other costs defined in the model, with the same unit.
       * If defined, `quadratic_soft_max_duration` must be nonnegative. If
       * `max_duration` is also defined, `quadratic_soft_max_duration` must be
       * less than `max_duration`, and the difference must be no larger than one
       * day:
       *    `max_duration - quadratic_soft_max_duration &lt;= 86400 seconds`
       * </pre>
       *
       * <code>.google.protobuf.Duration quadratic_soft_max_duration = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getQuadraticSoftMaxDurationFieldBuilder() {
        if (quadraticSoftMaxDurationBuilder_ == null) {
          quadraticSoftMaxDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getQuadraticSoftMaxDuration(), getParentForChildren(), isClean());
          quadraticSoftMaxDuration_ = null;
        }
        return quadraticSoftMaxDurationBuilder_;
      }

      private double costPerSquareHourAfterQuadraticSoftMax_;
      /**
       *
       *
       * <pre>
       * Cost per square hour incurred if the
       * `quadratic_soft_max_duration` threshold is violated.
       * The additional cost is 0 if the duration is under the threshold,
       * otherwise the cost depends on the duration as follows:
       * ```
       *   cost_per_square_hour_after_quadratic_soft_max *
       *   (duration - quadratic_soft_max_duration)^2
       * ```
       * The cost must be nonnegative.
       * </pre>
       *
       * <code>optional double cost_per_square_hour_after_quadratic_soft_max = 5;</code>
       *
       * @return Whether the costPerSquareHourAfterQuadraticSoftMax field is set.
       */
      @java.lang.Override
      public boolean hasCostPerSquareHourAfterQuadraticSoftMax() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Cost per square hour incurred if the
       * `quadratic_soft_max_duration` threshold is violated.
       * The additional cost is 0 if the duration is under the threshold,
       * otherwise the cost depends on the duration as follows:
       * ```
       *   cost_per_square_hour_after_quadratic_soft_max *
       *   (duration - quadratic_soft_max_duration)^2
       * ```
       * The cost must be nonnegative.
       * </pre>
       *
       * <code>optional double cost_per_square_hour_after_quadratic_soft_max = 5;</code>
       *
       * @return The costPerSquareHourAfterQuadraticSoftMax.
       */
      @java.lang.Override
      public double getCostPerSquareHourAfterQuadraticSoftMax() {
        return costPerSquareHourAfterQuadraticSoftMax_;
      }
      /**
       *
       *
       * <pre>
       * Cost per square hour incurred if the
       * `quadratic_soft_max_duration` threshold is violated.
       * The additional cost is 0 if the duration is under the threshold,
       * otherwise the cost depends on the duration as follows:
       * ```
       *   cost_per_square_hour_after_quadratic_soft_max *
       *   (duration - quadratic_soft_max_duration)^2
       * ```
       * The cost must be nonnegative.
       * </pre>
       *
       * <code>optional double cost_per_square_hour_after_quadratic_soft_max = 5;</code>
       *
       * @param value The costPerSquareHourAfterQuadraticSoftMax to set.
       * @return This builder for chaining.
       */
      public Builder setCostPerSquareHourAfterQuadraticSoftMax(double value) {
        bitField0_ |= 0x00000002;
        costPerSquareHourAfterQuadraticSoftMax_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cost per square hour incurred if the
       * `quadratic_soft_max_duration` threshold is violated.
       * The additional cost is 0 if the duration is under the threshold,
       * otherwise the cost depends on the duration as follows:
       * ```
       *   cost_per_square_hour_after_quadratic_soft_max *
       *   (duration - quadratic_soft_max_duration)^2
       * ```
       * The cost must be nonnegative.
       * </pre>
       *
       * <code>optional double cost_per_square_hour_after_quadratic_soft_max = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCostPerSquareHourAfterQuadraticSoftMax() {
        bitField0_ = (bitField0_ & ~0x00000002);
        costPerSquareHourAfterQuadraticSoftMax_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.Vehicle.DurationLimit)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.Vehicle.DurationLimit)
    private static final com.google.cloud.optimization.v1.Vehicle.DurationLimit DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.Vehicle.DurationLimit();
    }

    public static com.google.cloud.optimization.v1.Vehicle.DurationLimit getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DurationLimit> PARSER =
        new com.google.protobuf.AbstractParser<DurationLimit>() {
          @java.lang.Override
          public DurationLimit parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DurationLimit> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DurationLimit> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle.DurationLimit getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TRAVEL_MODE_FIELD_NUMBER = 1;
  private int travelMode_;
  /**
   *
   *
   * <pre>
   * The travel mode which affects the roads usable by the vehicle and its
   * speed. See also `travel_duration_multiple`.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
   *
   * @return The enum numeric value on the wire for travelMode.
   */
  @java.lang.Override
  public int getTravelModeValue() {
    return travelMode_;
  }
  /**
   *
   *
   * <pre>
   * The travel mode which affects the roads usable by the vehicle and its
   * speed. See also `travel_duration_multiple`.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
   *
   * @return The travelMode.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Vehicle.TravelMode getTravelMode() {
    @SuppressWarnings("deprecation")
    com.google.cloud.optimization.v1.Vehicle.TravelMode result =
        com.google.cloud.optimization.v1.Vehicle.TravelMode.valueOf(travelMode_);
    return result == null
        ? com.google.cloud.optimization.v1.Vehicle.TravelMode.UNRECOGNIZED
        : result;
  }

  public static final int START_LOCATION_FIELD_NUMBER = 3;
  private com.google.type.LatLng startLocation_;
  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle starts before picking up any
   * shipments. If not specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng start_location = 3;</code>
   *
   * @return Whether the startLocation field is set.
   */
  @java.lang.Override
  public boolean hasStartLocation() {
    return startLocation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle starts before picking up any
   * shipments. If not specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng start_location = 3;</code>
   *
   * @return The startLocation.
   */
  @java.lang.Override
  public com.google.type.LatLng getStartLocation() {
    return startLocation_ == null ? com.google.type.LatLng.getDefaultInstance() : startLocation_;
  }
  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle starts before picking up any
   * shipments. If not specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng start_location = 3;</code>
   */
  @java.lang.Override
  public com.google.type.LatLngOrBuilder getStartLocationOrBuilder() {
    return getStartLocation();
  }

  public static final int START_WAYPOINT_FIELD_NUMBER = 4;
  private com.google.cloud.optimization.v1.Waypoint startWaypoint_;
  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle starts before
   * picking up any shipments. If neither `start_waypoint` nor `start_location`
   * is specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
   *
   * @return Whether the startWaypoint field is set.
   */
  @java.lang.Override
  public boolean hasStartWaypoint() {
    return startWaypoint_ != null;
  }
  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle starts before
   * picking up any shipments. If neither `start_waypoint` nor `start_location`
   * is specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
   *
   * @return The startWaypoint.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Waypoint getStartWaypoint() {
    return startWaypoint_ == null
        ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
        : startWaypoint_;
  }
  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle starts before
   * picking up any shipments. If neither `start_waypoint` nor `start_location`
   * is specified, the vehicle starts at its first pickup.
   * If the shipment model has duration and distance matrices, `start_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.WaypointOrBuilder getStartWaypointOrBuilder() {
    return getStartWaypoint();
  }

  public static final int END_LOCATION_FIELD_NUMBER = 5;
  private com.google.type.LatLng endLocation_;
  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle ends after it has completed its last
   * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
   * immediately when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng end_location = 5;</code>
   *
   * @return Whether the endLocation field is set.
   */
  @java.lang.Override
  public boolean hasEndLocation() {
    return endLocation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle ends after it has completed its last
   * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
   * immediately when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng end_location = 5;</code>
   *
   * @return The endLocation.
   */
  @java.lang.Override
  public com.google.type.LatLng getEndLocation() {
    return endLocation_ == null ? com.google.type.LatLng.getDefaultInstance() : endLocation_;
  }
  /**
   *
   *
   * <pre>
   * Geographic location where the vehicle ends after it has completed its last
   * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
   * immediately when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_location`
   * must not be specified.
   * </pre>
   *
   * <code>.google.type.LatLng end_location = 5;</code>
   */
  @java.lang.Override
  public com.google.type.LatLngOrBuilder getEndLocationOrBuilder() {
    return getEndLocation();
  }

  public static final int END_WAYPOINT_FIELD_NUMBER = 6;
  private com.google.cloud.optimization.v1.Waypoint endWaypoint_;
  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle ends after
   * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
   * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
   * when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
   *
   * @return Whether the endWaypoint field is set.
   */
  @java.lang.Override
  public boolean hasEndWaypoint() {
    return endWaypoint_ != null;
  }
  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle ends after
   * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
   * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
   * when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
   *
   * @return The endWaypoint.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Waypoint getEndWaypoint() {
    return endWaypoint_ == null
        ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
        : endWaypoint_;
  }
  /**
   *
   *
   * <pre>
   * Waypoint representing a geographic location where the vehicle ends after
   * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
   * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
   * when it completes its last `VisitRequest`.
   * If the shipment model has duration and distance matrices, `end_waypoint`
   * must not be specified.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.WaypointOrBuilder getEndWaypointOrBuilder() {
    return getEndWaypoint();
  }

  public static final int START_TAGS_FIELD_NUMBER = 7;
  private com.google.protobuf.LazyStringList startTags_;
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the start of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string start_tags = 7;</code>
   *
   * @return A list containing the startTags.
   */
  public com.google.protobuf.ProtocolStringList getStartTagsList() {
    return startTags_;
  }
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the start of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string start_tags = 7;</code>
   *
   * @return The count of startTags.
   */
  public int getStartTagsCount() {
    return startTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the start of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string start_tags = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The startTags at the given index.
   */
  public java.lang.String getStartTags(int index) {
    return startTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the start of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string start_tags = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the startTags at the given index.
   */
  public com.google.protobuf.ByteString getStartTagsBytes(int index) {
    return startTags_.getByteString(index);
  }

  public static final int END_TAGS_FIELD_NUMBER = 8;
  private com.google.protobuf.LazyStringList endTags_;
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the end of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string end_tags = 8;</code>
   *
   * @return A list containing the endTags.
   */
  public com.google.protobuf.ProtocolStringList getEndTagsList() {
    return endTags_;
  }
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the end of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string end_tags = 8;</code>
   *
   * @return The count of endTags.
   */
  public int getEndTagsCount() {
    return endTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the end of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string end_tags = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The endTags at the given index.
   */
  public java.lang.String getEndTags(int index) {
    return endTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies tags attached to the end of the vehicle's route.
   * Empty or duplicate strings are not allowed.
   * </pre>
   *
   * <code>repeated string end_tags = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the endTags at the given index.
   */
  public com.google.protobuf.ByteString getEndTagsBytes(int index) {
    return endTags_.getByteString(index);
  }

  public static final int START_TIME_WINDOWS_FIELD_NUMBER = 9;
  private java.util.List<com.google.cloud.optimization.v1.TimeWindow> startTimeWindows_;
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may depart its start location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.TimeWindow> getStartTimeWindowsList() {
    return startTimeWindows_;
  }
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may depart its start location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.TimeWindowOrBuilder>
      getStartTimeWindowsOrBuilderList() {
    return startTimeWindows_;
  }
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may depart its start location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
   */
  @java.lang.Override
  public int getStartTimeWindowsCount() {
    return startTimeWindows_.size();
  }
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may depart its start location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.TimeWindow getStartTimeWindows(int index) {
    return startTimeWindows_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may depart its start location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.TimeWindowOrBuilder getStartTimeWindowsOrBuilder(
      int index) {
    return startTimeWindows_.get(index);
  }

  public static final int END_TIME_WINDOWS_FIELD_NUMBER = 10;
  private java.util.List<com.google.cloud.optimization.v1.TimeWindow> endTimeWindows_;
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may arrive at its end location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.TimeWindow> getEndTimeWindowsList() {
    return endTimeWindows_;
  }
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may arrive at its end location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.TimeWindowOrBuilder>
      getEndTimeWindowsOrBuilderList() {
    return endTimeWindows_;
  }
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may arrive at its end location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
   */
  @java.lang.Override
  public int getEndTimeWindowsCount() {
    return endTimeWindows_.size();
  }
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may arrive at its end location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.TimeWindow getEndTimeWindows(int index) {
    return endTimeWindows_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Time windows during which the vehicle may arrive at its end location.
   * They must be within the global time limits (see
   * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
   * fields). If unspecified, there is no limitation besides those global time
   * limits.
   * Time windows belonging to the same repeated field must be disjoint, i.e. no
   * time window can overlap with or be adjacent to another, and they must be in
   * chronological order.
   * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
   * there is a single time window.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.TimeWindowOrBuilder getEndTimeWindowsOrBuilder(
      int index) {
    return endTimeWindows_.get(index);
  }

  public static final int TRAVEL_DURATION_MULTIPLE_FIELD_NUMBER = 11;
  private double travelDurationMultiple_;
  /**
   *
   *
   * <pre>
   * Specifies a multiplicative factor that can be used to increase or decrease
   * travel times of this vehicle. For example, setting this to 2.0 means
   * that this vehicle is slower and has travel times that are twice what they
   * are for standard vehicles. This multiple does not affect visit durations.
   * It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
   * specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
   * is standard, and this multiple is considered 1.0.
   * WARNING: Travel times will be rounded to the nearest second after this
   * multiple is applied but before performing any numerical operations, thus,
   * a small multiple may result in a loss of precision.
   * See also `extra_visit_duration_for_visit_type` below.
   * </pre>
   *
   * <code>optional double travel_duration_multiple = 11;</code>
   *
   * @return Whether the travelDurationMultiple field is set.
   */
  @java.lang.Override
  public boolean hasTravelDurationMultiple() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies a multiplicative factor that can be used to increase or decrease
   * travel times of this vehicle. For example, setting this to 2.0 means
   * that this vehicle is slower and has travel times that are twice what they
   * are for standard vehicles. This multiple does not affect visit durations.
   * It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
   * specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
   * is standard, and this multiple is considered 1.0.
   * WARNING: Travel times will be rounded to the nearest second after this
   * multiple is applied but before performing any numerical operations, thus,
   * a small multiple may result in a loss of precision.
   * See also `extra_visit_duration_for_visit_type` below.
   * </pre>
   *
   * <code>optional double travel_duration_multiple = 11;</code>
   *
   * @return The travelDurationMultiple.
   */
  @java.lang.Override
  public double getTravelDurationMultiple() {
    return travelDurationMultiple_;
  }

  public static final int UNLOADING_POLICY_FIELD_NUMBER = 12;
  private int unloadingPolicy_;
  /**
   *
   *
   * <pre>
   * Unloading policy enforced on the vehicle.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
   *
   * @return The enum numeric value on the wire for unloadingPolicy.
   */
  @java.lang.Override
  public int getUnloadingPolicyValue() {
    return unloadingPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Unloading policy enforced on the vehicle.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
   *
   * @return The unloadingPolicy.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy getUnloadingPolicy() {
    @SuppressWarnings("deprecation")
    com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy result =
        com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy.valueOf(unloadingPolicy_);
    return result == null
        ? com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy.UNRECOGNIZED
        : result;
  }

  public static final int LOAD_LIMITS_FIELD_NUMBER = 30;

  private static final class LoadLimitsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
                    newDefaultInstance(
                        com.google.cloud.optimization.v1.FleetRoutingProto
                            .internal_static_google_cloud_optimization_v1_Vehicle_LoadLimitsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.optimization.v1.Vehicle.LoadLimit.getDefaultInstance());
  }

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
      loadLimits_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
      internalGetLoadLimits() {
    if (loadLimits_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LoadLimitsDefaultEntryHolder.defaultEntry);
    }
    return loadLimits_;
  }

  public int getLoadLimitsCount() {
    return internalGetLoadLimits().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Capacities of the vehicle (weight, volume, # of pallets for example).
   * The keys in the map are the identifiers of the type of load, consistent
   * with the keys of the
   * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
   * field. If a given key is absent from this map, the corresponding capacity
   * is considered to be limitless.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
   * </code>
   */
  @java.lang.Override
  public boolean containsLoadLimits(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLoadLimits().getMap().containsKey(key);
  }
  /** Use {@link #getLoadLimitsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
      getLoadLimits() {
    return getLoadLimitsMap();
  }
  /**
   *
   *
   * <pre>
   * Capacities of the vehicle (weight, volume, # of pallets for example).
   * The keys in the map are the identifiers of the type of load, consistent
   * with the keys of the
   * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
   * field. If a given key is absent from this map, the corresponding capacity
   * is considered to be limitless.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
      getLoadLimitsMap() {
    return internalGetLoadLimits().getMap();
  }
  /**
   *
   *
   * <pre>
   * Capacities of the vehicle (weight, volume, # of pallets for example).
   * The keys in the map are the identifiers of the type of load, consistent
   * with the keys of the
   * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
   * field. If a given key is absent from this map, the corresponding capacity
   * is considered to be limitless.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Vehicle.LoadLimit getLoadLimitsOrDefault(
      java.lang.String key, com.google.cloud.optimization.v1.Vehicle.LoadLimit defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit> map =
        internalGetLoadLimits().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Capacities of the vehicle (weight, volume, # of pallets for example).
   * The keys in the map are the identifiers of the type of load, consistent
   * with the keys of the
   * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
   * field. If a given key is absent from this map, the corresponding capacity
   * is considered to be limitless.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Vehicle.LoadLimit getLoadLimitsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit> map =
        internalGetLoadLimits().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int COST_PER_HOUR_FIELD_NUMBER = 16;
  private double costPerHour_;
  /**
   *
   *
   * <pre>
   * Vehicle costs: all costs add up and must be in the same unit as
   * [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
   * Cost per hour of the vehicle route. This cost is applied to the total time
   * taken by the route, and includes travel time, waiting time, and visit time.
   * Using `cost_per_hour` instead of just `cost_per_traveled_hour` may result
   * in additional latency.
   * </pre>
   *
   * <code>double cost_per_hour = 16;</code>
   *
   * @return The costPerHour.
   */
  @java.lang.Override
  public double getCostPerHour() {
    return costPerHour_;
  }

  public static final int COST_PER_TRAVELED_HOUR_FIELD_NUMBER = 17;
  private double costPerTraveledHour_;
  /**
   *
   *
   * <pre>
   * Cost per traveled hour of the vehicle route. This cost is applied only to
   * travel time taken by the route (i.e., that reported in
   * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]), and excludes waiting time and visit time.
   * </pre>
   *
   * <code>double cost_per_traveled_hour = 17;</code>
   *
   * @return The costPerTraveledHour.
   */
  @java.lang.Override
  public double getCostPerTraveledHour() {
    return costPerTraveledHour_;
  }

  public static final int COST_PER_KILOMETER_FIELD_NUMBER = 18;
  private double costPerKilometer_;
  /**
   *
   *
   * <pre>
   * Cost per kilometer of the vehicle route. This cost is applied to the
   * distance reported in the [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] and does not apply
   * to any distance implicitly traveled from the `arrival_location` to the
   * `departure_location` of a single `VisitRequest`.
   * </pre>
   *
   * <code>double cost_per_kilometer = 18;</code>
   *
   * @return The costPerKilometer.
   */
  @java.lang.Override
  public double getCostPerKilometer() {
    return costPerKilometer_;
  }

  public static final int FIXED_COST_FIELD_NUMBER = 19;
  private double fixedCost_;
  /**
   *
   *
   * <pre>
   * Fixed cost applied if this vehicle is used to handle a shipment.
   * </pre>
   *
   * <code>double fixed_cost = 19;</code>
   *
   * @return The fixedCost.
   */
  @java.lang.Override
  public double getFixedCost() {
    return fixedCost_;
  }

  public static final int USED_IF_ROUTE_IS_EMPTY_FIELD_NUMBER = 20;
  private boolean usedIfRouteIsEmpty_;
  /**
   *
   *
   * <pre>
   * This field only applies to vehicles when their route does not serve any
   * shipments. It indicates if the vehicle should be considered as used or not
   * in this case.
   * If true, the vehicle goes from its start to its end location even if it
   * doesn't serve any shipments, and time and distance costs resulting from its
   * start --&gt; end travel are taken into account.
   * Otherwise, it doesn't travel from its start to its end location, and no
   * `break_rule` or delay (from `TransitionAttributes`) are scheduled for this
   * vehicle. In this case, the vehicle's `ShipmentRoute` doesn't contain any
   * information except for the vehicle index and label.
   * </pre>
   *
   * <code>bool used_if_route_is_empty = 20;</code>
   *
   * @return The usedIfRouteIsEmpty.
   */
  @java.lang.Override
  public boolean getUsedIfRouteIsEmpty() {
    return usedIfRouteIsEmpty_;
  }

  public static final int ROUTE_DURATION_LIMIT_FIELD_NUMBER = 21;
  private com.google.cloud.optimization.v1.Vehicle.DurationLimit routeDurationLimit_;
  /**
   *
   *
   * <pre>
   * Limit applied to the total duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route duration of a vehicle is the
   * difference between its `vehicle_end_time` and `vehicle_start_time`.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
   *
   * @return Whether the routeDurationLimit field is set.
   */
  @java.lang.Override
  public boolean hasRouteDurationLimit() {
    return routeDurationLimit_ != null;
  }
  /**
   *
   *
   * <pre>
   * Limit applied to the total duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route duration of a vehicle is the
   * difference between its `vehicle_end_time` and `vehicle_start_time`.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
   *
   * @return The routeDurationLimit.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Vehicle.DurationLimit getRouteDurationLimit() {
    return routeDurationLimit_ == null
        ? com.google.cloud.optimization.v1.Vehicle.DurationLimit.getDefaultInstance()
        : routeDurationLimit_;
  }
  /**
   *
   *
   * <pre>
   * Limit applied to the total duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route duration of a vehicle is the
   * difference between its `vehicle_end_time` and `vehicle_start_time`.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder
      getRouteDurationLimitOrBuilder() {
    return getRouteDurationLimit();
  }

  public static final int TRAVEL_DURATION_LIMIT_FIELD_NUMBER = 22;
  private com.google.cloud.optimization.v1.Vehicle.DurationLimit travelDurationLimit_;
  /**
   *
   *
   * <pre>
   * Limit applied to the travel duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route travel duration is the sum of all its
   * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
   *
   * @return Whether the travelDurationLimit field is set.
   */
  @java.lang.Override
  public boolean hasTravelDurationLimit() {
    return travelDurationLimit_ != null;
  }
  /**
   *
   *
   * <pre>
   * Limit applied to the travel duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route travel duration is the sum of all its
   * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
   *
   * @return The travelDurationLimit.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Vehicle.DurationLimit getTravelDurationLimit() {
    return travelDurationLimit_ == null
        ? com.google.cloud.optimization.v1.Vehicle.DurationLimit.getDefaultInstance()
        : travelDurationLimit_;
  }
  /**
   *
   *
   * <pre>
   * Limit applied to the travel duration of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route travel duration is the sum of all its
   * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder
      getTravelDurationLimitOrBuilder() {
    return getTravelDurationLimit();
  }

  public static final int ROUTE_DISTANCE_LIMIT_FIELD_NUMBER = 23;
  private com.google.cloud.optimization.v1.DistanceLimit routeDistanceLimit_;
  /**
   *
   *
   * <pre>
   * Limit applied to the total distance of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route distance is the sum of all its
   * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
   *
   * @return Whether the routeDistanceLimit field is set.
   */
  @java.lang.Override
  public boolean hasRouteDistanceLimit() {
    return routeDistanceLimit_ != null;
  }
  /**
   *
   *
   * <pre>
   * Limit applied to the total distance of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route distance is the sum of all its
   * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
   *
   * @return The routeDistanceLimit.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.DistanceLimit getRouteDistanceLimit() {
    return routeDistanceLimit_ == null
        ? com.google.cloud.optimization.v1.DistanceLimit.getDefaultInstance()
        : routeDistanceLimit_;
  }
  /**
   *
   *
   * <pre>
   * Limit applied to the total distance of the vehicle's route. In a given
   * `OptimizeToursResponse`, the route distance is the sum of all its
   * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.DistanceLimitOrBuilder getRouteDistanceLimitOrBuilder() {
    return getRouteDistanceLimit();
  }

  public static final int EXTRA_VISIT_DURATION_FOR_VISIT_TYPE_FIELD_NUMBER = 24;

  private static final class ExtraVisitDurationForVisitTypeDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Duration>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Duration>newDefaultInstance(
                    com.google.cloud.optimization.v1.FleetRoutingProto
                        .internal_static_google_cloud_optimization_v1_Vehicle_ExtraVisitDurationForVisitTypeEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Duration.getDefaultInstance());
  }

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Duration>
      extraVisitDurationForVisitType_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Duration>
      internalGetExtraVisitDurationForVisitType() {
    if (extraVisitDurationForVisitType_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry);
    }
    return extraVisitDurationForVisitType_;
  }

  public int getExtraVisitDurationForVisitTypeCount() {
    return internalGetExtraVisitDurationForVisitType().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Specifies a map from visit_types strings to durations. The duration is time
   * in addition to
   * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
   * to be taken at visits with the specified `visit_types`. This extra visit
   * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
   * `visit_types`) cannot be empty strings.
   * If a visit request has multiple types, a duration will be added for each
   * type in the map.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
   * </code>
   */
  @java.lang.Override
  public boolean containsExtraVisitDurationForVisitType(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetExtraVisitDurationForVisitType().getMap().containsKey(key);
  }
  /** Use {@link #getExtraVisitDurationForVisitTypeMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Duration>
      getExtraVisitDurationForVisitType() {
    return getExtraVisitDurationForVisitTypeMap();
  }
  /**
   *
   *
   * <pre>
   * Specifies a map from visit_types strings to durations. The duration is time
   * in addition to
   * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
   * to be taken at visits with the specified `visit_types`. This extra visit
   * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
   * `visit_types`) cannot be empty strings.
   * If a visit request has multiple types, a duration will be added for each
   * type in the map.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Duration>
      getExtraVisitDurationForVisitTypeMap() {
    return internalGetExtraVisitDurationForVisitType().getMap();
  }
  /**
   *
   *
   * <pre>
   * Specifies a map from visit_types strings to durations. The duration is time
   * in addition to
   * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
   * to be taken at visits with the specified `visit_types`. This extra visit
   * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
   * `visit_types`) cannot be empty strings.
   * If a visit request has multiple types, a duration will be added for each
   * type in the map.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Duration getExtraVisitDurationForVisitTypeOrDefault(
      java.lang.String key, com.google.protobuf.Duration defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Duration> map =
        internalGetExtraVisitDurationForVisitType().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Specifies a map from visit_types strings to durations. The duration is time
   * in addition to
   * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
   * to be taken at visits with the specified `visit_types`. This extra visit
   * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
   * `visit_types`) cannot be empty strings.
   * If a visit request has multiple types, a duration will be added for each
   * type in the map.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Duration getExtraVisitDurationForVisitTypeOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Duration> map =
        internalGetExtraVisitDurationForVisitType().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int BREAK_RULE_FIELD_NUMBER = 25;
  private com.google.cloud.optimization.v1.BreakRule breakRule_;
  /**
   *
   *
   * <pre>
   * Describes the break schedule to be enforced on this vehicle.
   * If empty, no breaks will be scheduled for this vehicle.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
   *
   * @return Whether the breakRule field is set.
   */
  @java.lang.Override
  public boolean hasBreakRule() {
    return breakRule_ != null;
  }
  /**
   *
   *
   * <pre>
   * Describes the break schedule to be enforced on this vehicle.
   * If empty, no breaks will be scheduled for this vehicle.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
   *
   * @return The breakRule.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.BreakRule getBreakRule() {
    return breakRule_ == null
        ? com.google.cloud.optimization.v1.BreakRule.getDefaultInstance()
        : breakRule_;
  }
  /**
   *
   *
   * <pre>
   * Describes the break schedule to be enforced on this vehicle.
   * If empty, no breaks will be scheduled for this vehicle.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.BreakRuleOrBuilder getBreakRuleOrBuilder() {
    return getBreakRule();
  }

  public static final int LABEL_FIELD_NUMBER = 27;
  private volatile java.lang.Object label_;
  /**
   *
   *
   * <pre>
   * Specifies a label for this vehicle. This label is reported in the response
   * as the `vehicle_label` of the corresponding [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
   * </pre>
   *
   * <code>string label = 27;</code>
   *
   * @return The label.
   */
  @java.lang.Override
  public java.lang.String getLabel() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      label_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies a label for this vehicle. This label is reported in the response
   * as the `vehicle_label` of the corresponding [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
   * </pre>
   *
   * <code>string label = 27;</code>
   *
   * @return The bytes for label.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelBytes() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      label_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IGNORE_FIELD_NUMBER = 28;
  private boolean ignore_;
  /**
   *
   *
   * <pre>
   * If true, `used_if_route_is_empty` must be false, and this vehicle will
   * remain unused.
   * If a shipment is performed by an ignored vehicle in
   * `injected_first_solution_routes`, it is skipped in the first solution but
   * is free to be performed in the response.
   * If a shipment is performed by an ignored vehicle in
   * `injected_solution_constraint` and any related pickup/delivery is
   * constrained to remain on the vehicle (i.e., not relaxed to level
   * `RELAX_ALL_AFTER_THRESHOLD`), it is skipped in the response.
   * If a shipment has a non-empty `allowed_vehicle_indices` field and all of
   * the allowed vehicles are ignored, it is skipped in the response.
   * </pre>
   *
   * <code>bool ignore = 28;</code>
   *
   * @return The ignore.
   */
  @java.lang.Override
  public boolean getIgnore() {
    return ignore_;
  }

  public static final int BREAK_RULE_INDICES_FIELD_NUMBER = 29;
  private com.google.protobuf.Internal.IntList breakRuleIndices_;
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Indices in the `break_rule` field in the source
   * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
   * As of 2018/03, at most one rule index per vehicle can be specified.
   * </pre>
   *
   * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
   *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
   * @return A list containing the breakRuleIndices.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<java.lang.Integer> getBreakRuleIndicesList() {
    return breakRuleIndices_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Indices in the `break_rule` field in the source
   * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
   * As of 2018/03, at most one rule index per vehicle can be specified.
   * </pre>
   *
   * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
   *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
   * @return The count of breakRuleIndices.
   */
  @java.lang.Deprecated
  public int getBreakRuleIndicesCount() {
    return breakRuleIndices_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Indices in the `break_rule` field in the source
   * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
   * As of 2018/03, at most one rule index per vehicle can be specified.
   * </pre>
   *
   * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
   *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
   * @param index The index of the element to return.
   * @return The breakRuleIndices at the given index.
   */
  @java.lang.Deprecated
  public int getBreakRuleIndices(int index) {
    return breakRuleIndices_.getInt(index);
  }

  private int breakRuleIndicesMemoizedSerializedSize = -1;

  public static final int CAPACITIES_FIELD_NUMBER = 13;
  private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> capacities_;
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.load_limits][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getCapacitiesList() {
    return capacities_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.load_limits][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
      getCapacitiesOrBuilderList() {
    return capacities_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.load_limits][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getCapacitiesCount() {
    return capacities_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.load_limits][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.CapacityQuantity getCapacities(int index) {
    return capacities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.load_limits][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getCapacitiesOrBuilder(
      int index) {
    return capacities_.get(index);
  }

  public static final int START_LOAD_INTERVALS_FIELD_NUMBER = 14;
  private java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval>
      startLoadIntervals_;
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval>
      getStartLoadIntervalsList() {
    return startLoadIntervals_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<
          ? extends com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>
      getStartLoadIntervalsOrBuilderList() {
    return startLoadIntervals_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getStartLoadIntervalsCount() {
    return startLoadIntervals_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.CapacityQuantityInterval getStartLoadIntervals(
      int index) {
    return startLoadIntervals_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder
      getStartLoadIntervalsOrBuilder(int index) {
    return startLoadIntervals_.get(index);
  }

  public static final int END_LOAD_INTERVALS_FIELD_NUMBER = 15;
  private java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval>
      endLoadIntervals_;
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval>
      getEndLoadIntervalsList() {
    return endLoadIntervals_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<
          ? extends com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>
      getEndLoadIntervalsOrBuilderList() {
    return endLoadIntervals_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getEndLoadIntervalsCount() {
    return endLoadIntervals_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.CapacityQuantityInterval getEndLoadIntervals(int index) {
    return endLoadIntervals_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder
      getEndLoadIntervalsOrBuilder(int index) {
    return endLoadIntervals_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (travelMode_
        != com.google.cloud.optimization.v1.Vehicle.TravelMode.TRAVEL_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, travelMode_);
    }
    if (startLocation_ != null) {
      output.writeMessage(3, getStartLocation());
    }
    if (startWaypoint_ != null) {
      output.writeMessage(4, getStartWaypoint());
    }
    if (endLocation_ != null) {
      output.writeMessage(5, getEndLocation());
    }
    if (endWaypoint_ != null) {
      output.writeMessage(6, getEndWaypoint());
    }
    for (int i = 0; i < startTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, startTags_.getRaw(i));
    }
    for (int i = 0; i < endTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, endTags_.getRaw(i));
    }
    for (int i = 0; i < startTimeWindows_.size(); i++) {
      output.writeMessage(9, startTimeWindows_.get(i));
    }
    for (int i = 0; i < endTimeWindows_.size(); i++) {
      output.writeMessage(10, endTimeWindows_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeDouble(11, travelDurationMultiple_);
    }
    if (unloadingPolicy_
        != com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy.UNLOADING_POLICY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(12, unloadingPolicy_);
    }
    for (int i = 0; i < capacities_.size(); i++) {
      output.writeMessage(13, capacities_.get(i));
    }
    for (int i = 0; i < startLoadIntervals_.size(); i++) {
      output.writeMessage(14, startLoadIntervals_.get(i));
    }
    for (int i = 0; i < endLoadIntervals_.size(); i++) {
      output.writeMessage(15, endLoadIntervals_.get(i));
    }
    if (java.lang.Double.doubleToRawLongBits(costPerHour_) != 0) {
      output.writeDouble(16, costPerHour_);
    }
    if (java.lang.Double.doubleToRawLongBits(costPerTraveledHour_) != 0) {
      output.writeDouble(17, costPerTraveledHour_);
    }
    if (java.lang.Double.doubleToRawLongBits(costPerKilometer_) != 0) {
      output.writeDouble(18, costPerKilometer_);
    }
    if (java.lang.Double.doubleToRawLongBits(fixedCost_) != 0) {
      output.writeDouble(19, fixedCost_);
    }
    if (usedIfRouteIsEmpty_ != false) {
      output.writeBool(20, usedIfRouteIsEmpty_);
    }
    if (routeDurationLimit_ != null) {
      output.writeMessage(21, getRouteDurationLimit());
    }
    if (travelDurationLimit_ != null) {
      output.writeMessage(22, getTravelDurationLimit());
    }
    if (routeDistanceLimit_ != null) {
      output.writeMessage(23, getRouteDistanceLimit());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetExtraVisitDurationForVisitType(),
        ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry,
        24);
    if (breakRule_ != null) {
      output.writeMessage(25, getBreakRule());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, label_);
    }
    if (ignore_ != false) {
      output.writeBool(28, ignore_);
    }
    if (getBreakRuleIndicesList().size() > 0) {
      output.writeUInt32NoTag(234);
      output.writeUInt32NoTag(breakRuleIndicesMemoizedSerializedSize);
    }
    for (int i = 0; i < breakRuleIndices_.size(); i++) {
      output.writeInt32NoTag(breakRuleIndices_.getInt(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLoadLimits(), LoadLimitsDefaultEntryHolder.defaultEntry, 30);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (travelMode_
        != com.google.cloud.optimization.v1.Vehicle.TravelMode.TRAVEL_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, travelMode_);
    }
    if (startLocation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStartLocation());
    }
    if (startWaypoint_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartWaypoint());
    }
    if (endLocation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndLocation());
    }
    if (endWaypoint_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEndWaypoint());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < startTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(startTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getStartTagsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < endTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(endTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getEndTagsList().size();
    }
    for (int i = 0; i < startTimeWindows_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, startTimeWindows_.get(i));
    }
    for (int i = 0; i < endTimeWindows_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, endTimeWindows_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(11, travelDurationMultiple_);
    }
    if (unloadingPolicy_
        != com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy.UNLOADING_POLICY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, unloadingPolicy_);
    }
    for (int i = 0; i < capacities_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, capacities_.get(i));
    }
    for (int i = 0; i < startLoadIntervals_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, startLoadIntervals_.get(i));
    }
    for (int i = 0; i < endLoadIntervals_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(15, endLoadIntervals_.get(i));
    }
    if (java.lang.Double.doubleToRawLongBits(costPerHour_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(16, costPerHour_);
    }
    if (java.lang.Double.doubleToRawLongBits(costPerTraveledHour_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(17, costPerTraveledHour_);
    }
    if (java.lang.Double.doubleToRawLongBits(costPerKilometer_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(18, costPerKilometer_);
    }
    if (java.lang.Double.doubleToRawLongBits(fixedCost_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(19, fixedCost_);
    }
    if (usedIfRouteIsEmpty_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(20, usedIfRouteIsEmpty_);
    }
    if (routeDurationLimit_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getRouteDurationLimit());
    }
    if (travelDurationLimit_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(22, getTravelDurationLimit());
    }
    if (routeDistanceLimit_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getRouteDistanceLimit());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Duration> entry :
        internalGetExtraVisitDurationForVisitType().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Duration>
          extraVisitDurationForVisitType__ =
              ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24, extraVisitDurationForVisitType__);
    }
    if (breakRule_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, getBreakRule());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(27, label_);
    }
    if (ignore_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(28, ignore_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < breakRuleIndices_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                breakRuleIndices_.getInt(i));
      }
      size += dataSize;
      if (!getBreakRuleIndicesList().isEmpty()) {
        size += 2;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      breakRuleIndicesMemoizedSerializedSize = dataSize;
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
        entry : internalGetLoadLimits().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
          loadLimits__ =
              LoadLimitsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(30, loadLimits__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.Vehicle)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.Vehicle other = (com.google.cloud.optimization.v1.Vehicle) obj;

    if (travelMode_ != other.travelMode_) return false;
    if (hasStartLocation() != other.hasStartLocation()) return false;
    if (hasStartLocation()) {
      if (!getStartLocation().equals(other.getStartLocation())) return false;
    }
    if (hasStartWaypoint() != other.hasStartWaypoint()) return false;
    if (hasStartWaypoint()) {
      if (!getStartWaypoint().equals(other.getStartWaypoint())) return false;
    }
    if (hasEndLocation() != other.hasEndLocation()) return false;
    if (hasEndLocation()) {
      if (!getEndLocation().equals(other.getEndLocation())) return false;
    }
    if (hasEndWaypoint() != other.hasEndWaypoint()) return false;
    if (hasEndWaypoint()) {
      if (!getEndWaypoint().equals(other.getEndWaypoint())) return false;
    }
    if (!getStartTagsList().equals(other.getStartTagsList())) return false;
    if (!getEndTagsList().equals(other.getEndTagsList())) return false;
    if (!getStartTimeWindowsList().equals(other.getStartTimeWindowsList())) return false;
    if (!getEndTimeWindowsList().equals(other.getEndTimeWindowsList())) return false;
    if (hasTravelDurationMultiple() != other.hasTravelDurationMultiple()) return false;
    if (hasTravelDurationMultiple()) {
      if (java.lang.Double.doubleToLongBits(getTravelDurationMultiple())
          != java.lang.Double.doubleToLongBits(other.getTravelDurationMultiple())) return false;
    }
    if (unloadingPolicy_ != other.unloadingPolicy_) return false;
    if (!internalGetLoadLimits().equals(other.internalGetLoadLimits())) return false;
    if (java.lang.Double.doubleToLongBits(getCostPerHour())
        != java.lang.Double.doubleToLongBits(other.getCostPerHour())) return false;
    if (java.lang.Double.doubleToLongBits(getCostPerTraveledHour())
        != java.lang.Double.doubleToLongBits(other.getCostPerTraveledHour())) return false;
    if (java.lang.Double.doubleToLongBits(getCostPerKilometer())
        != java.lang.Double.doubleToLongBits(other.getCostPerKilometer())) return false;
    if (java.lang.Double.doubleToLongBits(getFixedCost())
        != java.lang.Double.doubleToLongBits(other.getFixedCost())) return false;
    if (getUsedIfRouteIsEmpty() != other.getUsedIfRouteIsEmpty()) return false;
    if (hasRouteDurationLimit() != other.hasRouteDurationLimit()) return false;
    if (hasRouteDurationLimit()) {
      if (!getRouteDurationLimit().equals(other.getRouteDurationLimit())) return false;
    }
    if (hasTravelDurationLimit() != other.hasTravelDurationLimit()) return false;
    if (hasTravelDurationLimit()) {
      if (!getTravelDurationLimit().equals(other.getTravelDurationLimit())) return false;
    }
    if (hasRouteDistanceLimit() != other.hasRouteDistanceLimit()) return false;
    if (hasRouteDistanceLimit()) {
      if (!getRouteDistanceLimit().equals(other.getRouteDistanceLimit())) return false;
    }
    if (!internalGetExtraVisitDurationForVisitType()
        .equals(other.internalGetExtraVisitDurationForVisitType())) return false;
    if (hasBreakRule() != other.hasBreakRule()) return false;
    if (hasBreakRule()) {
      if (!getBreakRule().equals(other.getBreakRule())) return false;
    }
    if (!getLabel().equals(other.getLabel())) return false;
    if (getIgnore() != other.getIgnore()) return false;
    if (!getBreakRuleIndicesList().equals(other.getBreakRuleIndicesList())) return false;
    if (!getCapacitiesList().equals(other.getCapacitiesList())) return false;
    if (!getStartLoadIntervalsList().equals(other.getStartLoadIntervalsList())) return false;
    if (!getEndLoadIntervalsList().equals(other.getEndLoadIntervalsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TRAVEL_MODE_FIELD_NUMBER;
    hash = (53 * hash) + travelMode_;
    if (hasStartLocation()) {
      hash = (37 * hash) + START_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getStartLocation().hashCode();
    }
    if (hasStartWaypoint()) {
      hash = (37 * hash) + START_WAYPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getStartWaypoint().hashCode();
    }
    if (hasEndLocation()) {
      hash = (37 * hash) + END_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getEndLocation().hashCode();
    }
    if (hasEndWaypoint()) {
      hash = (37 * hash) + END_WAYPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getEndWaypoint().hashCode();
    }
    if (getStartTagsCount() > 0) {
      hash = (37 * hash) + START_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getStartTagsList().hashCode();
    }
    if (getEndTagsCount() > 0) {
      hash = (37 * hash) + END_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getEndTagsList().hashCode();
    }
    if (getStartTimeWindowsCount() > 0) {
      hash = (37 * hash) + START_TIME_WINDOWS_FIELD_NUMBER;
      hash = (53 * hash) + getStartTimeWindowsList().hashCode();
    }
    if (getEndTimeWindowsCount() > 0) {
      hash = (37 * hash) + END_TIME_WINDOWS_FIELD_NUMBER;
      hash = (53 * hash) + getEndTimeWindowsList().hashCode();
    }
    if (hasTravelDurationMultiple()) {
      hash = (37 * hash) + TRAVEL_DURATION_MULTIPLE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getTravelDurationMultiple()));
    }
    hash = (37 * hash) + UNLOADING_POLICY_FIELD_NUMBER;
    hash = (53 * hash) + unloadingPolicy_;
    if (!internalGetLoadLimits().getMap().isEmpty()) {
      hash = (37 * hash) + LOAD_LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLoadLimits().hashCode();
    }
    hash = (37 * hash) + COST_PER_HOUR_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getCostPerHour()));
    hash = (37 * hash) + COST_PER_TRAVELED_HOUR_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getCostPerTraveledHour()));
    hash = (37 * hash) + COST_PER_KILOMETER_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getCostPerKilometer()));
    hash = (37 * hash) + FIXED_COST_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getFixedCost()));
    hash = (37 * hash) + USED_IF_ROUTE_IS_EMPTY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUsedIfRouteIsEmpty());
    if (hasRouteDurationLimit()) {
      hash = (37 * hash) + ROUTE_DURATION_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getRouteDurationLimit().hashCode();
    }
    if (hasTravelDurationLimit()) {
      hash = (37 * hash) + TRAVEL_DURATION_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getTravelDurationLimit().hashCode();
    }
    if (hasRouteDistanceLimit()) {
      hash = (37 * hash) + ROUTE_DISTANCE_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getRouteDistanceLimit().hashCode();
    }
    if (!internalGetExtraVisitDurationForVisitType().getMap().isEmpty()) {
      hash = (37 * hash) + EXTRA_VISIT_DURATION_FOR_VISIT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + internalGetExtraVisitDurationForVisitType().hashCode();
    }
    if (hasBreakRule()) {
      hash = (37 * hash) + BREAK_RULE_FIELD_NUMBER;
      hash = (53 * hash) + getBreakRule().hashCode();
    }
    hash = (37 * hash) + LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getLabel().hashCode();
    hash = (37 * hash) + IGNORE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnore());
    if (getBreakRuleIndicesCount() > 0) {
      hash = (37 * hash) + BREAK_RULE_INDICES_FIELD_NUMBER;
      hash = (53 * hash) + getBreakRuleIndicesList().hashCode();
    }
    if (getCapacitiesCount() > 0) {
      hash = (37 * hash) + CAPACITIES_FIELD_NUMBER;
      hash = (53 * hash) + getCapacitiesList().hashCode();
    }
    if (getStartLoadIntervalsCount() > 0) {
      hash = (37 * hash) + START_LOAD_INTERVALS_FIELD_NUMBER;
      hash = (53 * hash) + getStartLoadIntervalsList().hashCode();
    }
    if (getEndLoadIntervalsCount() > 0) {
      hash = (37 * hash) + END_LOAD_INTERVALS_FIELD_NUMBER;
      hash = (53 * hash) + getEndLoadIntervalsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.Vehicle parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.Vehicle parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.Vehicle parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.Vehicle parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.Vehicle parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.Vehicle parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.Vehicle parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.Vehicle parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.Vehicle parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.Vehicle parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.Vehicle parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.Vehicle parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.optimization.v1.Vehicle prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Models a vehicle in a shipment problem. Solving a shipment problem will
   * build a route starting from `start_location` and ending at `end_location`
   * for this vehicle. A route is a sequence of visits (see `ShipmentRoute`).
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.Vehicle}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.Vehicle)
      com.google.cloud.optimization.v1.VehicleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Vehicle_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 30:
          return internalGetLoadLimits();
        case 24:
          return internalGetExtraVisitDurationForVisitType();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 30:
          return internalGetMutableLoadLimits();
        case 24:
          return internalGetMutableExtraVisitDurationForVisitType();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Vehicle_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.Vehicle.class,
              com.google.cloud.optimization.v1.Vehicle.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.Vehicle.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      travelMode_ = 0;

      if (startLocationBuilder_ == null) {
        startLocation_ = null;
      } else {
        startLocation_ = null;
        startLocationBuilder_ = null;
      }
      if (startWaypointBuilder_ == null) {
        startWaypoint_ = null;
      } else {
        startWaypoint_ = null;
        startWaypointBuilder_ = null;
      }
      if (endLocationBuilder_ == null) {
        endLocation_ = null;
      } else {
        endLocation_ = null;
        endLocationBuilder_ = null;
      }
      if (endWaypointBuilder_ == null) {
        endWaypoint_ = null;
      } else {
        endWaypoint_ = null;
        endWaypointBuilder_ = null;
      }
      startTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      endTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      if (startTimeWindowsBuilder_ == null) {
        startTimeWindows_ = java.util.Collections.emptyList();
      } else {
        startTimeWindows_ = null;
        startTimeWindowsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (endTimeWindowsBuilder_ == null) {
        endTimeWindows_ = java.util.Collections.emptyList();
      } else {
        endTimeWindows_ = null;
        endTimeWindowsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      travelDurationMultiple_ = 0D;
      bitField0_ = (bitField0_ & ~0x00000010);
      unloadingPolicy_ = 0;

      internalGetMutableLoadLimits().clear();
      costPerHour_ = 0D;

      costPerTraveledHour_ = 0D;

      costPerKilometer_ = 0D;

      fixedCost_ = 0D;

      usedIfRouteIsEmpty_ = false;

      if (routeDurationLimitBuilder_ == null) {
        routeDurationLimit_ = null;
      } else {
        routeDurationLimit_ = null;
        routeDurationLimitBuilder_ = null;
      }
      if (travelDurationLimitBuilder_ == null) {
        travelDurationLimit_ = null;
      } else {
        travelDurationLimit_ = null;
        travelDurationLimitBuilder_ = null;
      }
      if (routeDistanceLimitBuilder_ == null) {
        routeDistanceLimit_ = null;
      } else {
        routeDistanceLimit_ = null;
        routeDistanceLimitBuilder_ = null;
      }
      internalGetMutableExtraVisitDurationForVisitType().clear();
      if (breakRuleBuilder_ == null) {
        breakRule_ = null;
      } else {
        breakRule_ = null;
        breakRuleBuilder_ = null;
      }
      label_ = "";

      ignore_ = false;

      breakRuleIndices_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000080);
      if (capacitiesBuilder_ == null) {
        capacities_ = java.util.Collections.emptyList();
      } else {
        capacities_ = null;
        capacitiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      if (startLoadIntervalsBuilder_ == null) {
        startLoadIntervals_ = java.util.Collections.emptyList();
      } else {
        startLoadIntervals_ = null;
        startLoadIntervalsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      if (endLoadIntervalsBuilder_ == null) {
        endLoadIntervals_ = java.util.Collections.emptyList();
      } else {
        endLoadIntervals_ = null;
        endLoadIntervalsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Vehicle_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.Vehicle.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle build() {
      com.google.cloud.optimization.v1.Vehicle result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle buildPartial() {
      com.google.cloud.optimization.v1.Vehicle result =
          new com.google.cloud.optimization.v1.Vehicle(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.travelMode_ = travelMode_;
      if (startLocationBuilder_ == null) {
        result.startLocation_ = startLocation_;
      } else {
        result.startLocation_ = startLocationBuilder_.build();
      }
      if (startWaypointBuilder_ == null) {
        result.startWaypoint_ = startWaypoint_;
      } else {
        result.startWaypoint_ = startWaypointBuilder_.build();
      }
      if (endLocationBuilder_ == null) {
        result.endLocation_ = endLocation_;
      } else {
        result.endLocation_ = endLocationBuilder_.build();
      }
      if (endWaypointBuilder_ == null) {
        result.endWaypoint_ = endWaypoint_;
      } else {
        result.endWaypoint_ = endWaypointBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        startTags_ = startTags_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.startTags_ = startTags_;
      if (((bitField0_ & 0x00000002) != 0)) {
        endTags_ = endTags_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.endTags_ = endTags_;
      if (startTimeWindowsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          startTimeWindows_ = java.util.Collections.unmodifiableList(startTimeWindows_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.startTimeWindows_ = startTimeWindows_;
      } else {
        result.startTimeWindows_ = startTimeWindowsBuilder_.build();
      }
      if (endTimeWindowsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          endTimeWindows_ = java.util.Collections.unmodifiableList(endTimeWindows_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.endTimeWindows_ = endTimeWindows_;
      } else {
        result.endTimeWindows_ = endTimeWindowsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.travelDurationMultiple_ = travelDurationMultiple_;
        to_bitField0_ |= 0x00000001;
      }
      result.unloadingPolicy_ = unloadingPolicy_;
      result.loadLimits_ = internalGetLoadLimits();
      result.loadLimits_.makeImmutable();
      result.costPerHour_ = costPerHour_;
      result.costPerTraveledHour_ = costPerTraveledHour_;
      result.costPerKilometer_ = costPerKilometer_;
      result.fixedCost_ = fixedCost_;
      result.usedIfRouteIsEmpty_ = usedIfRouteIsEmpty_;
      if (routeDurationLimitBuilder_ == null) {
        result.routeDurationLimit_ = routeDurationLimit_;
      } else {
        result.routeDurationLimit_ = routeDurationLimitBuilder_.build();
      }
      if (travelDurationLimitBuilder_ == null) {
        result.travelDurationLimit_ = travelDurationLimit_;
      } else {
        result.travelDurationLimit_ = travelDurationLimitBuilder_.build();
      }
      if (routeDistanceLimitBuilder_ == null) {
        result.routeDistanceLimit_ = routeDistanceLimit_;
      } else {
        result.routeDistanceLimit_ = routeDistanceLimitBuilder_.build();
      }
      result.extraVisitDurationForVisitType_ = internalGetExtraVisitDurationForVisitType();
      result.extraVisitDurationForVisitType_.makeImmutable();
      if (breakRuleBuilder_ == null) {
        result.breakRule_ = breakRule_;
      } else {
        result.breakRule_ = breakRuleBuilder_.build();
      }
      result.label_ = label_;
      result.ignore_ = ignore_;
      if (((bitField0_ & 0x00000080) != 0)) {
        breakRuleIndices_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000080);
      }
      result.breakRuleIndices_ = breakRuleIndices_;
      if (capacitiesBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          capacities_ = java.util.Collections.unmodifiableList(capacities_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.capacities_ = capacities_;
      } else {
        result.capacities_ = capacitiesBuilder_.build();
      }
      if (startLoadIntervalsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          startLoadIntervals_ = java.util.Collections.unmodifiableList(startLoadIntervals_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.startLoadIntervals_ = startLoadIntervals_;
      } else {
        result.startLoadIntervals_ = startLoadIntervalsBuilder_.build();
      }
      if (endLoadIntervalsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          endLoadIntervals_ = java.util.Collections.unmodifiableList(endLoadIntervals_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.endLoadIntervals_ = endLoadIntervals_;
      } else {
        result.endLoadIntervals_ = endLoadIntervalsBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.Vehicle) {
        return mergeFrom((com.google.cloud.optimization.v1.Vehicle) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.Vehicle other) {
      if (other == com.google.cloud.optimization.v1.Vehicle.getDefaultInstance()) return this;
      if (other.travelMode_ != 0) {
        setTravelModeValue(other.getTravelModeValue());
      }
      if (other.hasStartLocation()) {
        mergeStartLocation(other.getStartLocation());
      }
      if (other.hasStartWaypoint()) {
        mergeStartWaypoint(other.getStartWaypoint());
      }
      if (other.hasEndLocation()) {
        mergeEndLocation(other.getEndLocation());
      }
      if (other.hasEndWaypoint()) {
        mergeEndWaypoint(other.getEndWaypoint());
      }
      if (!other.startTags_.isEmpty()) {
        if (startTags_.isEmpty()) {
          startTags_ = other.startTags_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureStartTagsIsMutable();
          startTags_.addAll(other.startTags_);
        }
        onChanged();
      }
      if (!other.endTags_.isEmpty()) {
        if (endTags_.isEmpty()) {
          endTags_ = other.endTags_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureEndTagsIsMutable();
          endTags_.addAll(other.endTags_);
        }
        onChanged();
      }
      if (startTimeWindowsBuilder_ == null) {
        if (!other.startTimeWindows_.isEmpty()) {
          if (startTimeWindows_.isEmpty()) {
            startTimeWindows_ = other.startTimeWindows_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureStartTimeWindowsIsMutable();
            startTimeWindows_.addAll(other.startTimeWindows_);
          }
          onChanged();
        }
      } else {
        if (!other.startTimeWindows_.isEmpty()) {
          if (startTimeWindowsBuilder_.isEmpty()) {
            startTimeWindowsBuilder_.dispose();
            startTimeWindowsBuilder_ = null;
            startTimeWindows_ = other.startTimeWindows_;
            bitField0_ = (bitField0_ & ~0x00000004);
            startTimeWindowsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStartTimeWindowsFieldBuilder()
                    : null;
          } else {
            startTimeWindowsBuilder_.addAllMessages(other.startTimeWindows_);
          }
        }
      }
      if (endTimeWindowsBuilder_ == null) {
        if (!other.endTimeWindows_.isEmpty()) {
          if (endTimeWindows_.isEmpty()) {
            endTimeWindows_ = other.endTimeWindows_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureEndTimeWindowsIsMutable();
            endTimeWindows_.addAll(other.endTimeWindows_);
          }
          onChanged();
        }
      } else {
        if (!other.endTimeWindows_.isEmpty()) {
          if (endTimeWindowsBuilder_.isEmpty()) {
            endTimeWindowsBuilder_.dispose();
            endTimeWindowsBuilder_ = null;
            endTimeWindows_ = other.endTimeWindows_;
            bitField0_ = (bitField0_ & ~0x00000008);
            endTimeWindowsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEndTimeWindowsFieldBuilder()
                    : null;
          } else {
            endTimeWindowsBuilder_.addAllMessages(other.endTimeWindows_);
          }
        }
      }
      if (other.hasTravelDurationMultiple()) {
        setTravelDurationMultiple(other.getTravelDurationMultiple());
      }
      if (other.unloadingPolicy_ != 0) {
        setUnloadingPolicyValue(other.getUnloadingPolicyValue());
      }
      internalGetMutableLoadLimits().mergeFrom(other.internalGetLoadLimits());
      if (other.getCostPerHour() != 0D) {
        setCostPerHour(other.getCostPerHour());
      }
      if (other.getCostPerTraveledHour() != 0D) {
        setCostPerTraveledHour(other.getCostPerTraveledHour());
      }
      if (other.getCostPerKilometer() != 0D) {
        setCostPerKilometer(other.getCostPerKilometer());
      }
      if (other.getFixedCost() != 0D) {
        setFixedCost(other.getFixedCost());
      }
      if (other.getUsedIfRouteIsEmpty() != false) {
        setUsedIfRouteIsEmpty(other.getUsedIfRouteIsEmpty());
      }
      if (other.hasRouteDurationLimit()) {
        mergeRouteDurationLimit(other.getRouteDurationLimit());
      }
      if (other.hasTravelDurationLimit()) {
        mergeTravelDurationLimit(other.getTravelDurationLimit());
      }
      if (other.hasRouteDistanceLimit()) {
        mergeRouteDistanceLimit(other.getRouteDistanceLimit());
      }
      internalGetMutableExtraVisitDurationForVisitType()
          .mergeFrom(other.internalGetExtraVisitDurationForVisitType());
      if (other.hasBreakRule()) {
        mergeBreakRule(other.getBreakRule());
      }
      if (!other.getLabel().isEmpty()) {
        label_ = other.label_;
        onChanged();
      }
      if (other.getIgnore() != false) {
        setIgnore(other.getIgnore());
      }
      if (!other.breakRuleIndices_.isEmpty()) {
        if (breakRuleIndices_.isEmpty()) {
          breakRuleIndices_ = other.breakRuleIndices_;
          bitField0_ = (bitField0_ & ~0x00000080);
        } else {
          ensureBreakRuleIndicesIsMutable();
          breakRuleIndices_.addAll(other.breakRuleIndices_);
        }
        onChanged();
      }
      if (capacitiesBuilder_ == null) {
        if (!other.capacities_.isEmpty()) {
          if (capacities_.isEmpty()) {
            capacities_ = other.capacities_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureCapacitiesIsMutable();
            capacities_.addAll(other.capacities_);
          }
          onChanged();
        }
      } else {
        if (!other.capacities_.isEmpty()) {
          if (capacitiesBuilder_.isEmpty()) {
            capacitiesBuilder_.dispose();
            capacitiesBuilder_ = null;
            capacities_ = other.capacities_;
            bitField0_ = (bitField0_ & ~0x00000100);
            capacitiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCapacitiesFieldBuilder()
                    : null;
          } else {
            capacitiesBuilder_.addAllMessages(other.capacities_);
          }
        }
      }
      if (startLoadIntervalsBuilder_ == null) {
        if (!other.startLoadIntervals_.isEmpty()) {
          if (startLoadIntervals_.isEmpty()) {
            startLoadIntervals_ = other.startLoadIntervals_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureStartLoadIntervalsIsMutable();
            startLoadIntervals_.addAll(other.startLoadIntervals_);
          }
          onChanged();
        }
      } else {
        if (!other.startLoadIntervals_.isEmpty()) {
          if (startLoadIntervalsBuilder_.isEmpty()) {
            startLoadIntervalsBuilder_.dispose();
            startLoadIntervalsBuilder_ = null;
            startLoadIntervals_ = other.startLoadIntervals_;
            bitField0_ = (bitField0_ & ~0x00000200);
            startLoadIntervalsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStartLoadIntervalsFieldBuilder()
                    : null;
          } else {
            startLoadIntervalsBuilder_.addAllMessages(other.startLoadIntervals_);
          }
        }
      }
      if (endLoadIntervalsBuilder_ == null) {
        if (!other.endLoadIntervals_.isEmpty()) {
          if (endLoadIntervals_.isEmpty()) {
            endLoadIntervals_ = other.endLoadIntervals_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureEndLoadIntervalsIsMutable();
            endLoadIntervals_.addAll(other.endLoadIntervals_);
          }
          onChanged();
        }
      } else {
        if (!other.endLoadIntervals_.isEmpty()) {
          if (endLoadIntervalsBuilder_.isEmpty()) {
            endLoadIntervalsBuilder_.dispose();
            endLoadIntervalsBuilder_ = null;
            endLoadIntervals_ = other.endLoadIntervals_;
            bitField0_ = (bitField0_ & ~0x00000400);
            endLoadIntervalsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEndLoadIntervalsFieldBuilder()
                    : null;
          } else {
            endLoadIntervalsBuilder_.addAllMessages(other.endLoadIntervals_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                travelMode_ = input.readEnum();

                break;
              } // case 8
            case 26:
              {
                input.readMessage(getStartLocationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStartWaypointFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getEndLocationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getEndWaypointFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureStartTagsIsMutable();
                startTags_.add(s);
                break;
              } // case 58
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureEndTagsIsMutable();
                endTags_.add(s);
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.optimization.v1.TimeWindow m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.TimeWindow.parser(), extensionRegistry);
                if (startTimeWindowsBuilder_ == null) {
                  ensureStartTimeWindowsIsMutable();
                  startTimeWindows_.add(m);
                } else {
                  startTimeWindowsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.optimization.v1.TimeWindow m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.TimeWindow.parser(), extensionRegistry);
                if (endTimeWindowsBuilder_ == null) {
                  ensureEndTimeWindowsIsMutable();
                  endTimeWindows_.add(m);
                } else {
                  endTimeWindowsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 89:
              {
                travelDurationMultiple_ = input.readDouble();
                bitField0_ |= 0x00000010;
                break;
              } // case 89
            case 96:
              {
                unloadingPolicy_ = input.readEnum();

                break;
              } // case 96
            case 106:
              {
                com.google.cloud.optimization.v1.CapacityQuantity m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.CapacityQuantity.parser(),
                        extensionRegistry);
                if (capacitiesBuilder_ == null) {
                  ensureCapacitiesIsMutable();
                  capacities_.add(m);
                } else {
                  capacitiesBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                com.google.cloud.optimization.v1.CapacityQuantityInterval m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.CapacityQuantityInterval.parser(),
                        extensionRegistry);
                if (startLoadIntervalsBuilder_ == null) {
                  ensureStartLoadIntervalsIsMutable();
                  startLoadIntervals_.add(m);
                } else {
                  startLoadIntervalsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 122:
              {
                com.google.cloud.optimization.v1.CapacityQuantityInterval m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.CapacityQuantityInterval.parser(),
                        extensionRegistry);
                if (endLoadIntervalsBuilder_ == null) {
                  ensureEndLoadIntervalsIsMutable();
                  endLoadIntervals_.add(m);
                } else {
                  endLoadIntervalsBuilder_.addMessage(m);
                }
                break;
              } // case 122
            case 129:
              {
                costPerHour_ = input.readDouble();

                break;
              } // case 129
            case 137:
              {
                costPerTraveledHour_ = input.readDouble();

                break;
              } // case 137
            case 145:
              {
                costPerKilometer_ = input.readDouble();

                break;
              } // case 145
            case 153:
              {
                fixedCost_ = input.readDouble();

                break;
              } // case 153
            case 160:
              {
                usedIfRouteIsEmpty_ = input.readBool();

                break;
              } // case 160
            case 170:
              {
                input.readMessage(
                    getRouteDurationLimitFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 170
            case 178:
              {
                input.readMessage(
                    getTravelDurationLimitFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 178
            case 186:
              {
                input.readMessage(
                    getRouteDistanceLimitFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 186
            case 194:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Duration>
                    extraVisitDurationForVisitType__ =
                        input.readMessage(
                            ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableExtraVisitDurationForVisitType()
                    .getMutableMap()
                    .put(
                        extraVisitDurationForVisitType__.getKey(),
                        extraVisitDurationForVisitType__.getValue());
                break;
              } // case 194
            case 202:
              {
                input.readMessage(getBreakRuleFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 202
            case 218:
              {
                label_ = input.readStringRequireUtf8();

                break;
              } // case 218
            case 224:
              {
                ignore_ = input.readBool();

                break;
              } // case 224
            case 232:
              {
                int v = input.readInt32();
                ensureBreakRuleIndicesIsMutable();
                breakRuleIndices_.addInt(v);
                break;
              } // case 232
            case 234:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureBreakRuleIndicesIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  breakRuleIndices_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 234
            case 242:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
                    loadLimits__ =
                        input.readMessage(
                            LoadLimitsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableLoadLimits()
                    .getMutableMap()
                    .put(loadLimits__.getKey(), loadLimits__.getValue());
                break;
              } // case 242
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int travelMode_ = 0;
    /**
     *
     *
     * <pre>
     * The travel mode which affects the roads usable by the vehicle and its
     * speed. See also `travel_duration_multiple`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
     *
     * @return The enum numeric value on the wire for travelMode.
     */
    @java.lang.Override
    public int getTravelModeValue() {
      return travelMode_;
    }
    /**
     *
     *
     * <pre>
     * The travel mode which affects the roads usable by the vehicle and its
     * speed. See also `travel_duration_multiple`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
     *
     * @param value The enum numeric value on the wire for travelMode to set.
     * @return This builder for chaining.
     */
    public Builder setTravelModeValue(int value) {

      travelMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The travel mode which affects the roads usable by the vehicle and its
     * speed. See also `travel_duration_multiple`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
     *
     * @return The travelMode.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle.TravelMode getTravelMode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.optimization.v1.Vehicle.TravelMode result =
          com.google.cloud.optimization.v1.Vehicle.TravelMode.valueOf(travelMode_);
      return result == null
          ? com.google.cloud.optimization.v1.Vehicle.TravelMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The travel mode which affects the roads usable by the vehicle and its
     * speed. See also `travel_duration_multiple`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
     *
     * @param value The travelMode to set.
     * @return This builder for chaining.
     */
    public Builder setTravelMode(com.google.cloud.optimization.v1.Vehicle.TravelMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      travelMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The travel mode which affects the roads usable by the vehicle and its
     * speed. See also `travel_duration_multiple`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.TravelMode travel_mode = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTravelMode() {

      travelMode_ = 0;
      onChanged();
      return this;
    }

    private com.google.type.LatLng startLocation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        startLocationBuilder_;
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng start_location = 3;</code>
     *
     * @return Whether the startLocation field is set.
     */
    public boolean hasStartLocation() {
      return startLocationBuilder_ != null || startLocation_ != null;
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng start_location = 3;</code>
     *
     * @return The startLocation.
     */
    public com.google.type.LatLng getStartLocation() {
      if (startLocationBuilder_ == null) {
        return startLocation_ == null
            ? com.google.type.LatLng.getDefaultInstance()
            : startLocation_;
      } else {
        return startLocationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng start_location = 3;</code>
     */
    public Builder setStartLocation(com.google.type.LatLng value) {
      if (startLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startLocation_ = value;
        onChanged();
      } else {
        startLocationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng start_location = 3;</code>
     */
    public Builder setStartLocation(com.google.type.LatLng.Builder builderForValue) {
      if (startLocationBuilder_ == null) {
        startLocation_ = builderForValue.build();
        onChanged();
      } else {
        startLocationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng start_location = 3;</code>
     */
    public Builder mergeStartLocation(com.google.type.LatLng value) {
      if (startLocationBuilder_ == null) {
        if (startLocation_ != null) {
          startLocation_ =
              com.google.type.LatLng.newBuilder(startLocation_).mergeFrom(value).buildPartial();
        } else {
          startLocation_ = value;
        }
        onChanged();
      } else {
        startLocationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng start_location = 3;</code>
     */
    public Builder clearStartLocation() {
      if (startLocationBuilder_ == null) {
        startLocation_ = null;
        onChanged();
      } else {
        startLocation_ = null;
        startLocationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng start_location = 3;</code>
     */
    public com.google.type.LatLng.Builder getStartLocationBuilder() {

      onChanged();
      return getStartLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng start_location = 3;</code>
     */
    public com.google.type.LatLngOrBuilder getStartLocationOrBuilder() {
      if (startLocationBuilder_ != null) {
        return startLocationBuilder_.getMessageOrBuilder();
      } else {
        return startLocation_ == null
            ? com.google.type.LatLng.getDefaultInstance()
            : startLocation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle starts before picking up any
     * shipments. If not specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng start_location = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        getStartLocationFieldBuilder() {
      if (startLocationBuilder_ == null) {
        startLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.LatLng,
                com.google.type.LatLng.Builder,
                com.google.type.LatLngOrBuilder>(
                getStartLocation(), getParentForChildren(), isClean());
        startLocation_ = null;
      }
      return startLocationBuilder_;
    }

    private com.google.cloud.optimization.v1.Waypoint startWaypoint_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.Waypoint,
            com.google.cloud.optimization.v1.Waypoint.Builder,
            com.google.cloud.optimization.v1.WaypointOrBuilder>
        startWaypointBuilder_;
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
     *
     * @return Whether the startWaypoint field is set.
     */
    public boolean hasStartWaypoint() {
      return startWaypointBuilder_ != null || startWaypoint_ != null;
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
     *
     * @return The startWaypoint.
     */
    public com.google.cloud.optimization.v1.Waypoint getStartWaypoint() {
      if (startWaypointBuilder_ == null) {
        return startWaypoint_ == null
            ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
            : startWaypoint_;
      } else {
        return startWaypointBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
     */
    public Builder setStartWaypoint(com.google.cloud.optimization.v1.Waypoint value) {
      if (startWaypointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startWaypoint_ = value;
        onChanged();
      } else {
        startWaypointBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
     */
    public Builder setStartWaypoint(
        com.google.cloud.optimization.v1.Waypoint.Builder builderForValue) {
      if (startWaypointBuilder_ == null) {
        startWaypoint_ = builderForValue.build();
        onChanged();
      } else {
        startWaypointBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
     */
    public Builder mergeStartWaypoint(com.google.cloud.optimization.v1.Waypoint value) {
      if (startWaypointBuilder_ == null) {
        if (startWaypoint_ != null) {
          startWaypoint_ =
              com.google.cloud.optimization.v1.Waypoint.newBuilder(startWaypoint_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          startWaypoint_ = value;
        }
        onChanged();
      } else {
        startWaypointBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
     */
    public Builder clearStartWaypoint() {
      if (startWaypointBuilder_ == null) {
        startWaypoint_ = null;
        onChanged();
      } else {
        startWaypoint_ = null;
        startWaypointBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
     */
    public com.google.cloud.optimization.v1.Waypoint.Builder getStartWaypointBuilder() {

      onChanged();
      return getStartWaypointFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
     */
    public com.google.cloud.optimization.v1.WaypointOrBuilder getStartWaypointOrBuilder() {
      if (startWaypointBuilder_ != null) {
        return startWaypointBuilder_.getMessageOrBuilder();
      } else {
        return startWaypoint_ == null
            ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
            : startWaypoint_;
      }
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle starts before
     * picking up any shipments. If neither `start_waypoint` nor `start_location`
     * is specified, the vehicle starts at its first pickup.
     * If the shipment model has duration and distance matrices, `start_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint start_waypoint = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.Waypoint,
            com.google.cloud.optimization.v1.Waypoint.Builder,
            com.google.cloud.optimization.v1.WaypointOrBuilder>
        getStartWaypointFieldBuilder() {
      if (startWaypointBuilder_ == null) {
        startWaypointBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.Waypoint,
                com.google.cloud.optimization.v1.Waypoint.Builder,
                com.google.cloud.optimization.v1.WaypointOrBuilder>(
                getStartWaypoint(), getParentForChildren(), isClean());
        startWaypoint_ = null;
      }
      return startWaypointBuilder_;
    }

    private com.google.type.LatLng endLocation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        endLocationBuilder_;
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng end_location = 5;</code>
     *
     * @return Whether the endLocation field is set.
     */
    public boolean hasEndLocation() {
      return endLocationBuilder_ != null || endLocation_ != null;
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng end_location = 5;</code>
     *
     * @return The endLocation.
     */
    public com.google.type.LatLng getEndLocation() {
      if (endLocationBuilder_ == null) {
        return endLocation_ == null ? com.google.type.LatLng.getDefaultInstance() : endLocation_;
      } else {
        return endLocationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng end_location = 5;</code>
     */
    public Builder setEndLocation(com.google.type.LatLng value) {
      if (endLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endLocation_ = value;
        onChanged();
      } else {
        endLocationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng end_location = 5;</code>
     */
    public Builder setEndLocation(com.google.type.LatLng.Builder builderForValue) {
      if (endLocationBuilder_ == null) {
        endLocation_ = builderForValue.build();
        onChanged();
      } else {
        endLocationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng end_location = 5;</code>
     */
    public Builder mergeEndLocation(com.google.type.LatLng value) {
      if (endLocationBuilder_ == null) {
        if (endLocation_ != null) {
          endLocation_ =
              com.google.type.LatLng.newBuilder(endLocation_).mergeFrom(value).buildPartial();
        } else {
          endLocation_ = value;
        }
        onChanged();
      } else {
        endLocationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng end_location = 5;</code>
     */
    public Builder clearEndLocation() {
      if (endLocationBuilder_ == null) {
        endLocation_ = null;
        onChanged();
      } else {
        endLocation_ = null;
        endLocationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng end_location = 5;</code>
     */
    public com.google.type.LatLng.Builder getEndLocationBuilder() {

      onChanged();
      return getEndLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng end_location = 5;</code>
     */
    public com.google.type.LatLngOrBuilder getEndLocationOrBuilder() {
      if (endLocationBuilder_ != null) {
        return endLocationBuilder_.getMessageOrBuilder();
      } else {
        return endLocation_ == null ? com.google.type.LatLng.getDefaultInstance() : endLocation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Geographic location where the vehicle ends after it has completed its last
     * `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
     * immediately when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_location`
     * must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng end_location = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        getEndLocationFieldBuilder() {
      if (endLocationBuilder_ == null) {
        endLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.LatLng,
                com.google.type.LatLng.Builder,
                com.google.type.LatLngOrBuilder>(
                getEndLocation(), getParentForChildren(), isClean());
        endLocation_ = null;
      }
      return endLocationBuilder_;
    }

    private com.google.cloud.optimization.v1.Waypoint endWaypoint_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.Waypoint,
            com.google.cloud.optimization.v1.Waypoint.Builder,
            com.google.cloud.optimization.v1.WaypointOrBuilder>
        endWaypointBuilder_;
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
     *
     * @return Whether the endWaypoint field is set.
     */
    public boolean hasEndWaypoint() {
      return endWaypointBuilder_ != null || endWaypoint_ != null;
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
     *
     * @return The endWaypoint.
     */
    public com.google.cloud.optimization.v1.Waypoint getEndWaypoint() {
      if (endWaypointBuilder_ == null) {
        return endWaypoint_ == null
            ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
            : endWaypoint_;
      } else {
        return endWaypointBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
     */
    public Builder setEndWaypoint(com.google.cloud.optimization.v1.Waypoint value) {
      if (endWaypointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endWaypoint_ = value;
        onChanged();
      } else {
        endWaypointBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
     */
    public Builder setEndWaypoint(
        com.google.cloud.optimization.v1.Waypoint.Builder builderForValue) {
      if (endWaypointBuilder_ == null) {
        endWaypoint_ = builderForValue.build();
        onChanged();
      } else {
        endWaypointBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
     */
    public Builder mergeEndWaypoint(com.google.cloud.optimization.v1.Waypoint value) {
      if (endWaypointBuilder_ == null) {
        if (endWaypoint_ != null) {
          endWaypoint_ =
              com.google.cloud.optimization.v1.Waypoint.newBuilder(endWaypoint_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          endWaypoint_ = value;
        }
        onChanged();
      } else {
        endWaypointBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
     */
    public Builder clearEndWaypoint() {
      if (endWaypointBuilder_ == null) {
        endWaypoint_ = null;
        onChanged();
      } else {
        endWaypoint_ = null;
        endWaypointBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
     */
    public com.google.cloud.optimization.v1.Waypoint.Builder getEndWaypointBuilder() {

      onChanged();
      return getEndWaypointFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
     */
    public com.google.cloud.optimization.v1.WaypointOrBuilder getEndWaypointOrBuilder() {
      if (endWaypointBuilder_ != null) {
        return endWaypointBuilder_.getMessageOrBuilder();
      } else {
        return endWaypoint_ == null
            ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
            : endWaypoint_;
      }
    }
    /**
     *
     *
     * <pre>
     * Waypoint representing a geographic location where the vehicle ends after
     * it has completed its last `VisitRequest`. If neither `end_waypoint` nor
     * `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
     * when it completes its last `VisitRequest`.
     * If the shipment model has duration and distance matrices, `end_waypoint`
     * must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint end_waypoint = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.Waypoint,
            com.google.cloud.optimization.v1.Waypoint.Builder,
            com.google.cloud.optimization.v1.WaypointOrBuilder>
        getEndWaypointFieldBuilder() {
      if (endWaypointBuilder_ == null) {
        endWaypointBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.Waypoint,
                com.google.cloud.optimization.v1.Waypoint.Builder,
                com.google.cloud.optimization.v1.WaypointOrBuilder>(
                getEndWaypoint(), getParentForChildren(), isClean());
        endWaypoint_ = null;
      }
      return endWaypointBuilder_;
    }

    private com.google.protobuf.LazyStringList startTags_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureStartTagsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        startTags_ = new com.google.protobuf.LazyStringArrayList(startTags_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string start_tags = 7;</code>
     *
     * @return A list containing the startTags.
     */
    public com.google.protobuf.ProtocolStringList getStartTagsList() {
      return startTags_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string start_tags = 7;</code>
     *
     * @return The count of startTags.
     */
    public int getStartTagsCount() {
      return startTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string start_tags = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The startTags at the given index.
     */
    public java.lang.String getStartTags(int index) {
      return startTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string start_tags = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the startTags at the given index.
     */
    public com.google.protobuf.ByteString getStartTagsBytes(int index) {
      return startTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string start_tags = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The startTags to set.
     * @return This builder for chaining.
     */
    public Builder setStartTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStartTagsIsMutable();
      startTags_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string start_tags = 7;</code>
     *
     * @param value The startTags to add.
     * @return This builder for chaining.
     */
    public Builder addStartTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStartTagsIsMutable();
      startTags_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string start_tags = 7;</code>
     *
     * @param values The startTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllStartTags(java.lang.Iterable<java.lang.String> values) {
      ensureStartTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, startTags_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string start_tags = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartTags() {
      startTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the start of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string start_tags = 7;</code>
     *
     * @param value The bytes of the startTags to add.
     * @return This builder for chaining.
     */
    public Builder addStartTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStartTagsIsMutable();
      startTags_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList endTags_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureEndTagsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        endTags_ = new com.google.protobuf.LazyStringArrayList(endTags_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string end_tags = 8;</code>
     *
     * @return A list containing the endTags.
     */
    public com.google.protobuf.ProtocolStringList getEndTagsList() {
      return endTags_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string end_tags = 8;</code>
     *
     * @return The count of endTags.
     */
    public int getEndTagsCount() {
      return endTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string end_tags = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The endTags at the given index.
     */
    public java.lang.String getEndTags(int index) {
      return endTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string end_tags = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the endTags at the given index.
     */
    public com.google.protobuf.ByteString getEndTagsBytes(int index) {
      return endTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string end_tags = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The endTags to set.
     * @return This builder for chaining.
     */
    public Builder setEndTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEndTagsIsMutable();
      endTags_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string end_tags = 8;</code>
     *
     * @param value The endTags to add.
     * @return This builder for chaining.
     */
    public Builder addEndTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEndTagsIsMutable();
      endTags_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string end_tags = 8;</code>
     *
     * @param values The endTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllEndTags(java.lang.Iterable<java.lang.String> values) {
      ensureEndTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, endTags_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string end_tags = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndTags() {
      endTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the end of the vehicle's route.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string end_tags = 8;</code>
     *
     * @param value The bytes of the endTags to add.
     * @return This builder for chaining.
     */
    public Builder addEndTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEndTagsIsMutable();
      endTags_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.optimization.v1.TimeWindow> startTimeWindows_ =
        java.util.Collections.emptyList();

    private void ensureStartTimeWindowsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        startTimeWindows_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.TimeWindow>(startTimeWindows_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.TimeWindow,
            com.google.cloud.optimization.v1.TimeWindow.Builder,
            com.google.cloud.optimization.v1.TimeWindowOrBuilder>
        startTimeWindowsBuilder_;

    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.TimeWindow> getStartTimeWindowsList() {
      if (startTimeWindowsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(startTimeWindows_);
      } else {
        return startTimeWindowsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public int getStartTimeWindowsCount() {
      if (startTimeWindowsBuilder_ == null) {
        return startTimeWindows_.size();
      } else {
        return startTimeWindowsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public com.google.cloud.optimization.v1.TimeWindow getStartTimeWindows(int index) {
      if (startTimeWindowsBuilder_ == null) {
        return startTimeWindows_.get(index);
      } else {
        return startTimeWindowsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public Builder setStartTimeWindows(
        int index, com.google.cloud.optimization.v1.TimeWindow value) {
      if (startTimeWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStartTimeWindowsIsMutable();
        startTimeWindows_.set(index, value);
        onChanged();
      } else {
        startTimeWindowsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public Builder setStartTimeWindows(
        int index, com.google.cloud.optimization.v1.TimeWindow.Builder builderForValue) {
      if (startTimeWindowsBuilder_ == null) {
        ensureStartTimeWindowsIsMutable();
        startTimeWindows_.set(index, builderForValue.build());
        onChanged();
      } else {
        startTimeWindowsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public Builder addStartTimeWindows(com.google.cloud.optimization.v1.TimeWindow value) {
      if (startTimeWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStartTimeWindowsIsMutable();
        startTimeWindows_.add(value);
        onChanged();
      } else {
        startTimeWindowsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public Builder addStartTimeWindows(
        int index, com.google.cloud.optimization.v1.TimeWindow value) {
      if (startTimeWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStartTimeWindowsIsMutable();
        startTimeWindows_.add(index, value);
        onChanged();
      } else {
        startTimeWindowsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public Builder addStartTimeWindows(
        com.google.cloud.optimization.v1.TimeWindow.Builder builderForValue) {
      if (startTimeWindowsBuilder_ == null) {
        ensureStartTimeWindowsIsMutable();
        startTimeWindows_.add(builderForValue.build());
        onChanged();
      } else {
        startTimeWindowsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public Builder addStartTimeWindows(
        int index, com.google.cloud.optimization.v1.TimeWindow.Builder builderForValue) {
      if (startTimeWindowsBuilder_ == null) {
        ensureStartTimeWindowsIsMutable();
        startTimeWindows_.add(index, builderForValue.build());
        onChanged();
      } else {
        startTimeWindowsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public Builder addAllStartTimeWindows(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.TimeWindow> values) {
      if (startTimeWindowsBuilder_ == null) {
        ensureStartTimeWindowsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, startTimeWindows_);
        onChanged();
      } else {
        startTimeWindowsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public Builder clearStartTimeWindows() {
      if (startTimeWindowsBuilder_ == null) {
        startTimeWindows_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        startTimeWindowsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public Builder removeStartTimeWindows(int index) {
      if (startTimeWindowsBuilder_ == null) {
        ensureStartTimeWindowsIsMutable();
        startTimeWindows_.remove(index);
        onChanged();
      } else {
        startTimeWindowsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public com.google.cloud.optimization.v1.TimeWindow.Builder getStartTimeWindowsBuilder(
        int index) {
      return getStartTimeWindowsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public com.google.cloud.optimization.v1.TimeWindowOrBuilder getStartTimeWindowsOrBuilder(
        int index) {
      if (startTimeWindowsBuilder_ == null) {
        return startTimeWindows_.get(index);
      } else {
        return startTimeWindowsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.TimeWindowOrBuilder>
        getStartTimeWindowsOrBuilderList() {
      if (startTimeWindowsBuilder_ != null) {
        return startTimeWindowsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(startTimeWindows_);
      }
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public com.google.cloud.optimization.v1.TimeWindow.Builder addStartTimeWindowsBuilder() {
      return getStartTimeWindowsFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.TimeWindow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public com.google.cloud.optimization.v1.TimeWindow.Builder addStartTimeWindowsBuilder(
        int index) {
      return getStartTimeWindowsFieldBuilder()
          .addBuilder(index, com.google.cloud.optimization.v1.TimeWindow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may depart its start location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow start_time_windows = 9;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.TimeWindow.Builder>
        getStartTimeWindowsBuilderList() {
      return getStartTimeWindowsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.TimeWindow,
            com.google.cloud.optimization.v1.TimeWindow.Builder,
            com.google.cloud.optimization.v1.TimeWindowOrBuilder>
        getStartTimeWindowsFieldBuilder() {
      if (startTimeWindowsBuilder_ == null) {
        startTimeWindowsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.TimeWindow,
                com.google.cloud.optimization.v1.TimeWindow.Builder,
                com.google.cloud.optimization.v1.TimeWindowOrBuilder>(
                startTimeWindows_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        startTimeWindows_ = null;
      }
      return startTimeWindowsBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.TimeWindow> endTimeWindows_ =
        java.util.Collections.emptyList();

    private void ensureEndTimeWindowsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        endTimeWindows_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.TimeWindow>(endTimeWindows_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.TimeWindow,
            com.google.cloud.optimization.v1.TimeWindow.Builder,
            com.google.cloud.optimization.v1.TimeWindowOrBuilder>
        endTimeWindowsBuilder_;

    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.TimeWindow> getEndTimeWindowsList() {
      if (endTimeWindowsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(endTimeWindows_);
      } else {
        return endTimeWindowsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public int getEndTimeWindowsCount() {
      if (endTimeWindowsBuilder_ == null) {
        return endTimeWindows_.size();
      } else {
        return endTimeWindowsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public com.google.cloud.optimization.v1.TimeWindow getEndTimeWindows(int index) {
      if (endTimeWindowsBuilder_ == null) {
        return endTimeWindows_.get(index);
      } else {
        return endTimeWindowsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public Builder setEndTimeWindows(int index, com.google.cloud.optimization.v1.TimeWindow value) {
      if (endTimeWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndTimeWindowsIsMutable();
        endTimeWindows_.set(index, value);
        onChanged();
      } else {
        endTimeWindowsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public Builder setEndTimeWindows(
        int index, com.google.cloud.optimization.v1.TimeWindow.Builder builderForValue) {
      if (endTimeWindowsBuilder_ == null) {
        ensureEndTimeWindowsIsMutable();
        endTimeWindows_.set(index, builderForValue.build());
        onChanged();
      } else {
        endTimeWindowsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public Builder addEndTimeWindows(com.google.cloud.optimization.v1.TimeWindow value) {
      if (endTimeWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndTimeWindowsIsMutable();
        endTimeWindows_.add(value);
        onChanged();
      } else {
        endTimeWindowsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public Builder addEndTimeWindows(int index, com.google.cloud.optimization.v1.TimeWindow value) {
      if (endTimeWindowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndTimeWindowsIsMutable();
        endTimeWindows_.add(index, value);
        onChanged();
      } else {
        endTimeWindowsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public Builder addEndTimeWindows(
        com.google.cloud.optimization.v1.TimeWindow.Builder builderForValue) {
      if (endTimeWindowsBuilder_ == null) {
        ensureEndTimeWindowsIsMutable();
        endTimeWindows_.add(builderForValue.build());
        onChanged();
      } else {
        endTimeWindowsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public Builder addEndTimeWindows(
        int index, com.google.cloud.optimization.v1.TimeWindow.Builder builderForValue) {
      if (endTimeWindowsBuilder_ == null) {
        ensureEndTimeWindowsIsMutable();
        endTimeWindows_.add(index, builderForValue.build());
        onChanged();
      } else {
        endTimeWindowsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public Builder addAllEndTimeWindows(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.TimeWindow> values) {
      if (endTimeWindowsBuilder_ == null) {
        ensureEndTimeWindowsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, endTimeWindows_);
        onChanged();
      } else {
        endTimeWindowsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public Builder clearEndTimeWindows() {
      if (endTimeWindowsBuilder_ == null) {
        endTimeWindows_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        endTimeWindowsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public Builder removeEndTimeWindows(int index) {
      if (endTimeWindowsBuilder_ == null) {
        ensureEndTimeWindowsIsMutable();
        endTimeWindows_.remove(index);
        onChanged();
      } else {
        endTimeWindowsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public com.google.cloud.optimization.v1.TimeWindow.Builder getEndTimeWindowsBuilder(int index) {
      return getEndTimeWindowsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public com.google.cloud.optimization.v1.TimeWindowOrBuilder getEndTimeWindowsOrBuilder(
        int index) {
      if (endTimeWindowsBuilder_ == null) {
        return endTimeWindows_.get(index);
      } else {
        return endTimeWindowsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.TimeWindowOrBuilder>
        getEndTimeWindowsOrBuilderList() {
      if (endTimeWindowsBuilder_ != null) {
        return endTimeWindowsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(endTimeWindows_);
      }
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public com.google.cloud.optimization.v1.TimeWindow.Builder addEndTimeWindowsBuilder() {
      return getEndTimeWindowsFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.TimeWindow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public com.google.cloud.optimization.v1.TimeWindow.Builder addEndTimeWindowsBuilder(int index) {
      return getEndTimeWindowsFieldBuilder()
          .addBuilder(index, com.google.cloud.optimization.v1.TimeWindow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Time windows during which the vehicle may arrive at its end location.
     * They must be within the global time limits (see
     * [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
     * fields). If unspecified, there is no limitation besides those global time
     * limits.
     * Time windows belonging to the same repeated field must be disjoint, i.e. no
     * time window can overlap with or be adjacent to another, and they must be in
     * chronological order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
     * there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow end_time_windows = 10;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.TimeWindow.Builder>
        getEndTimeWindowsBuilderList() {
      return getEndTimeWindowsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.TimeWindow,
            com.google.cloud.optimization.v1.TimeWindow.Builder,
            com.google.cloud.optimization.v1.TimeWindowOrBuilder>
        getEndTimeWindowsFieldBuilder() {
      if (endTimeWindowsBuilder_ == null) {
        endTimeWindowsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.TimeWindow,
                com.google.cloud.optimization.v1.TimeWindow.Builder,
                com.google.cloud.optimization.v1.TimeWindowOrBuilder>(
                endTimeWindows_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        endTimeWindows_ = null;
      }
      return endTimeWindowsBuilder_;
    }

    private double travelDurationMultiple_;
    /**
     *
     *
     * <pre>
     * Specifies a multiplicative factor that can be used to increase or decrease
     * travel times of this vehicle. For example, setting this to 2.0 means
     * that this vehicle is slower and has travel times that are twice what they
     * are for standard vehicles. This multiple does not affect visit durations.
     * It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
     * specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
     * is standard, and this multiple is considered 1.0.
     * WARNING: Travel times will be rounded to the nearest second after this
     * multiple is applied but before performing any numerical operations, thus,
     * a small multiple may result in a loss of precision.
     * See also `extra_visit_duration_for_visit_type` below.
     * </pre>
     *
     * <code>optional double travel_duration_multiple = 11;</code>
     *
     * @return Whether the travelDurationMultiple field is set.
     */
    @java.lang.Override
    public boolean hasTravelDurationMultiple() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies a multiplicative factor that can be used to increase or decrease
     * travel times of this vehicle. For example, setting this to 2.0 means
     * that this vehicle is slower and has travel times that are twice what they
     * are for standard vehicles. This multiple does not affect visit durations.
     * It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
     * specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
     * is standard, and this multiple is considered 1.0.
     * WARNING: Travel times will be rounded to the nearest second after this
     * multiple is applied but before performing any numerical operations, thus,
     * a small multiple may result in a loss of precision.
     * See also `extra_visit_duration_for_visit_type` below.
     * </pre>
     *
     * <code>optional double travel_duration_multiple = 11;</code>
     *
     * @return The travelDurationMultiple.
     */
    @java.lang.Override
    public double getTravelDurationMultiple() {
      return travelDurationMultiple_;
    }
    /**
     *
     *
     * <pre>
     * Specifies a multiplicative factor that can be used to increase or decrease
     * travel times of this vehicle. For example, setting this to 2.0 means
     * that this vehicle is slower and has travel times that are twice what they
     * are for standard vehicles. This multiple does not affect visit durations.
     * It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
     * specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
     * is standard, and this multiple is considered 1.0.
     * WARNING: Travel times will be rounded to the nearest second after this
     * multiple is applied but before performing any numerical operations, thus,
     * a small multiple may result in a loss of precision.
     * See also `extra_visit_duration_for_visit_type` below.
     * </pre>
     *
     * <code>optional double travel_duration_multiple = 11;</code>
     *
     * @param value The travelDurationMultiple to set.
     * @return This builder for chaining.
     */
    public Builder setTravelDurationMultiple(double value) {
      bitField0_ |= 0x00000010;
      travelDurationMultiple_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a multiplicative factor that can be used to increase or decrease
     * travel times of this vehicle. For example, setting this to 2.0 means
     * that this vehicle is slower and has travel times that are twice what they
     * are for standard vehicles. This multiple does not affect visit durations.
     * It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
     * specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
     * is standard, and this multiple is considered 1.0.
     * WARNING: Travel times will be rounded to the nearest second after this
     * multiple is applied but before performing any numerical operations, thus,
     * a small multiple may result in a loss of precision.
     * See also `extra_visit_duration_for_visit_type` below.
     * </pre>
     *
     * <code>optional double travel_duration_multiple = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTravelDurationMultiple() {
      bitField0_ = (bitField0_ & ~0x00000010);
      travelDurationMultiple_ = 0D;
      onChanged();
      return this;
    }

    private int unloadingPolicy_ = 0;
    /**
     *
     *
     * <pre>
     * Unloading policy enforced on the vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
     *
     * @return The enum numeric value on the wire for unloadingPolicy.
     */
    @java.lang.Override
    public int getUnloadingPolicyValue() {
      return unloadingPolicy_;
    }
    /**
     *
     *
     * <pre>
     * Unloading policy enforced on the vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
     *
     * @param value The enum numeric value on the wire for unloadingPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setUnloadingPolicyValue(int value) {

      unloadingPolicy_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unloading policy enforced on the vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
     *
     * @return The unloadingPolicy.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy getUnloadingPolicy() {
      @SuppressWarnings("deprecation")
      com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy result =
          com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy.valueOf(unloadingPolicy_);
      return result == null
          ? com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Unloading policy enforced on the vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
     *
     * @param value The unloadingPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setUnloadingPolicy(
        com.google.cloud.optimization.v1.Vehicle.UnloadingPolicy value) {
      if (value == null) {
        throw new NullPointerException();
      }

      unloadingPolicy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unloading policy enforced on the vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.UnloadingPolicy unloading_policy = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnloadingPolicy() {

      unloadingPolicy_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
        loadLimits_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
        internalGetLoadLimits() {
      if (loadLimits_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            LoadLimitsDefaultEntryHolder.defaultEntry);
      }
      return loadLimits_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
        internalGetMutableLoadLimits() {
      onChanged();
      ;
      if (loadLimits_ == null) {
        loadLimits_ =
            com.google.protobuf.MapField.newMapField(LoadLimitsDefaultEntryHolder.defaultEntry);
      }
      if (!loadLimits_.isMutable()) {
        loadLimits_ = loadLimits_.copy();
      }
      return loadLimits_;
    }

    public int getLoadLimitsCount() {
      return internalGetLoadLimits().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Capacities of the vehicle (weight, volume, # of pallets for example).
     * The keys in the map are the identifiers of the type of load, consistent
     * with the keys of the
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
     * field. If a given key is absent from this map, the corresponding capacity
     * is considered to be limitless.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
     * </code>
     */
    @java.lang.Override
    public boolean containsLoadLimits(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLoadLimits().getMap().containsKey(key);
    }
    /** Use {@link #getLoadLimitsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
        getLoadLimits() {
      return getLoadLimitsMap();
    }
    /**
     *
     *
     * <pre>
     * Capacities of the vehicle (weight, volume, # of pallets for example).
     * The keys in the map are the identifiers of the type of load, consistent
     * with the keys of the
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
     * field. If a given key is absent from this map, the corresponding capacity
     * is considered to be limitless.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
        getLoadLimitsMap() {
      return internalGetLoadLimits().getMap();
    }
    /**
     *
     *
     * <pre>
     * Capacities of the vehicle (weight, volume, # of pallets for example).
     * The keys in the map are the identifiers of the type of load, consistent
     * with the keys of the
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
     * field. If a given key is absent from this map, the corresponding capacity
     * is considered to be limitless.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle.LoadLimit getLoadLimitsOrDefault(
        java.lang.String key, com.google.cloud.optimization.v1.Vehicle.LoadLimit defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit> map =
          internalGetLoadLimits().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Capacities of the vehicle (weight, volume, # of pallets for example).
     * The keys in the map are the identifiers of the type of load, consistent
     * with the keys of the
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
     * field. If a given key is absent from this map, the corresponding capacity
     * is considered to be limitless.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Vehicle.LoadLimit getLoadLimitsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit> map =
          internalGetLoadLimits().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLoadLimits() {
      internalGetMutableLoadLimits().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Capacities of the vehicle (weight, volume, # of pallets for example).
     * The keys in the map are the identifiers of the type of load, consistent
     * with the keys of the
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
     * field. If a given key is absent from this map, the corresponding capacity
     * is considered to be limitless.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
     * </code>
     */
    public Builder removeLoadLimits(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLoadLimits().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
        getMutableLoadLimits() {
      return internalGetMutableLoadLimits().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Capacities of the vehicle (weight, volume, # of pallets for example).
     * The keys in the map are the identifiers of the type of load, consistent
     * with the keys of the
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
     * field. If a given key is absent from this map, the corresponding capacity
     * is considered to be limitless.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
     * </code>
     */
    public Builder putLoadLimits(
        java.lang.String key, com.google.cloud.optimization.v1.Vehicle.LoadLimit value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLoadLimits().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Capacities of the vehicle (weight, volume, # of pallets for example).
     * The keys in the map are the identifiers of the type of load, consistent
     * with the keys of the
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
     * field. If a given key is absent from this map, the corresponding capacity
     * is considered to be limitless.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Vehicle.LoadLimit&gt; load_limits = 30;
     * </code>
     */
    public Builder putAllLoadLimits(
        java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Vehicle.LoadLimit>
            values) {
      internalGetMutableLoadLimits().getMutableMap().putAll(values);
      return this;
    }

    private double costPerHour_;
    /**
     *
     *
     * <pre>
     * Vehicle costs: all costs add up and must be in the same unit as
     * [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
     * Cost per hour of the vehicle route. This cost is applied to the total time
     * taken by the route, and includes travel time, waiting time, and visit time.
     * Using `cost_per_hour` instead of just `cost_per_traveled_hour` may result
     * in additional latency.
     * </pre>
     *
     * <code>double cost_per_hour = 16;</code>
     *
     * @return The costPerHour.
     */
    @java.lang.Override
    public double getCostPerHour() {
      return costPerHour_;
    }
    /**
     *
     *
     * <pre>
     * Vehicle costs: all costs add up and must be in the same unit as
     * [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
     * Cost per hour of the vehicle route. This cost is applied to the total time
     * taken by the route, and includes travel time, waiting time, and visit time.
     * Using `cost_per_hour` instead of just `cost_per_traveled_hour` may result
     * in additional latency.
     * </pre>
     *
     * <code>double cost_per_hour = 16;</code>
     *
     * @param value The costPerHour to set.
     * @return This builder for chaining.
     */
    public Builder setCostPerHour(double value) {

      costPerHour_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vehicle costs: all costs add up and must be in the same unit as
     * [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
     * Cost per hour of the vehicle route. This cost is applied to the total time
     * taken by the route, and includes travel time, waiting time, and visit time.
     * Using `cost_per_hour` instead of just `cost_per_traveled_hour` may result
     * in additional latency.
     * </pre>
     *
     * <code>double cost_per_hour = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCostPerHour() {

      costPerHour_ = 0D;
      onChanged();
      return this;
    }

    private double costPerTraveledHour_;
    /**
     *
     *
     * <pre>
     * Cost per traveled hour of the vehicle route. This cost is applied only to
     * travel time taken by the route (i.e., that reported in
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]), and excludes waiting time and visit time.
     * </pre>
     *
     * <code>double cost_per_traveled_hour = 17;</code>
     *
     * @return The costPerTraveledHour.
     */
    @java.lang.Override
    public double getCostPerTraveledHour() {
      return costPerTraveledHour_;
    }
    /**
     *
     *
     * <pre>
     * Cost per traveled hour of the vehicle route. This cost is applied only to
     * travel time taken by the route (i.e., that reported in
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]), and excludes waiting time and visit time.
     * </pre>
     *
     * <code>double cost_per_traveled_hour = 17;</code>
     *
     * @param value The costPerTraveledHour to set.
     * @return This builder for chaining.
     */
    public Builder setCostPerTraveledHour(double value) {

      costPerTraveledHour_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cost per traveled hour of the vehicle route. This cost is applied only to
     * travel time taken by the route (i.e., that reported in
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]), and excludes waiting time and visit time.
     * </pre>
     *
     * <code>double cost_per_traveled_hour = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCostPerTraveledHour() {

      costPerTraveledHour_ = 0D;
      onChanged();
      return this;
    }

    private double costPerKilometer_;
    /**
     *
     *
     * <pre>
     * Cost per kilometer of the vehicle route. This cost is applied to the
     * distance reported in the [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] and does not apply
     * to any distance implicitly traveled from the `arrival_location` to the
     * `departure_location` of a single `VisitRequest`.
     * </pre>
     *
     * <code>double cost_per_kilometer = 18;</code>
     *
     * @return The costPerKilometer.
     */
    @java.lang.Override
    public double getCostPerKilometer() {
      return costPerKilometer_;
    }
    /**
     *
     *
     * <pre>
     * Cost per kilometer of the vehicle route. This cost is applied to the
     * distance reported in the [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] and does not apply
     * to any distance implicitly traveled from the `arrival_location` to the
     * `departure_location` of a single `VisitRequest`.
     * </pre>
     *
     * <code>double cost_per_kilometer = 18;</code>
     *
     * @param value The costPerKilometer to set.
     * @return This builder for chaining.
     */
    public Builder setCostPerKilometer(double value) {

      costPerKilometer_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cost per kilometer of the vehicle route. This cost is applied to the
     * distance reported in the [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] and does not apply
     * to any distance implicitly traveled from the `arrival_location` to the
     * `departure_location` of a single `VisitRequest`.
     * </pre>
     *
     * <code>double cost_per_kilometer = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCostPerKilometer() {

      costPerKilometer_ = 0D;
      onChanged();
      return this;
    }

    private double fixedCost_;
    /**
     *
     *
     * <pre>
     * Fixed cost applied if this vehicle is used to handle a shipment.
     * </pre>
     *
     * <code>double fixed_cost = 19;</code>
     *
     * @return The fixedCost.
     */
    @java.lang.Override
    public double getFixedCost() {
      return fixedCost_;
    }
    /**
     *
     *
     * <pre>
     * Fixed cost applied if this vehicle is used to handle a shipment.
     * </pre>
     *
     * <code>double fixed_cost = 19;</code>
     *
     * @param value The fixedCost to set.
     * @return This builder for chaining.
     */
    public Builder setFixedCost(double value) {

      fixedCost_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fixed cost applied if this vehicle is used to handle a shipment.
     * </pre>
     *
     * <code>double fixed_cost = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFixedCost() {

      fixedCost_ = 0D;
      onChanged();
      return this;
    }

    private boolean usedIfRouteIsEmpty_;
    /**
     *
     *
     * <pre>
     * This field only applies to vehicles when their route does not serve any
     * shipments. It indicates if the vehicle should be considered as used or not
     * in this case.
     * If true, the vehicle goes from its start to its end location even if it
     * doesn't serve any shipments, and time and distance costs resulting from its
     * start --&gt; end travel are taken into account.
     * Otherwise, it doesn't travel from its start to its end location, and no
     * `break_rule` or delay (from `TransitionAttributes`) are scheduled for this
     * vehicle. In this case, the vehicle's `ShipmentRoute` doesn't contain any
     * information except for the vehicle index and label.
     * </pre>
     *
     * <code>bool used_if_route_is_empty = 20;</code>
     *
     * @return The usedIfRouteIsEmpty.
     */
    @java.lang.Override
    public boolean getUsedIfRouteIsEmpty() {
      return usedIfRouteIsEmpty_;
    }
    /**
     *
     *
     * <pre>
     * This field only applies to vehicles when their route does not serve any
     * shipments. It indicates if the vehicle should be considered as used or not
     * in this case.
     * If true, the vehicle goes from its start to its end location even if it
     * doesn't serve any shipments, and time and distance costs resulting from its
     * start --&gt; end travel are taken into account.
     * Otherwise, it doesn't travel from its start to its end location, and no
     * `break_rule` or delay (from `TransitionAttributes`) are scheduled for this
     * vehicle. In this case, the vehicle's `ShipmentRoute` doesn't contain any
     * information except for the vehicle index and label.
     * </pre>
     *
     * <code>bool used_if_route_is_empty = 20;</code>
     *
     * @param value The usedIfRouteIsEmpty to set.
     * @return This builder for chaining.
     */
    public Builder setUsedIfRouteIsEmpty(boolean value) {

      usedIfRouteIsEmpty_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field only applies to vehicles when their route does not serve any
     * shipments. It indicates if the vehicle should be considered as used or not
     * in this case.
     * If true, the vehicle goes from its start to its end location even if it
     * doesn't serve any shipments, and time and distance costs resulting from its
     * start --&gt; end travel are taken into account.
     * Otherwise, it doesn't travel from its start to its end location, and no
     * `break_rule` or delay (from `TransitionAttributes`) are scheduled for this
     * vehicle. In this case, the vehicle's `ShipmentRoute` doesn't contain any
     * information except for the vehicle index and label.
     * </pre>
     *
     * <code>bool used_if_route_is_empty = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUsedIfRouteIsEmpty() {

      usedIfRouteIsEmpty_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.optimization.v1.Vehicle.DurationLimit routeDurationLimit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.Vehicle.DurationLimit,
            com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder,
            com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder>
        routeDurationLimitBuilder_;
    /**
     *
     *
     * <pre>
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     *
     * @return Whether the routeDurationLimit field is set.
     */
    public boolean hasRouteDurationLimit() {
      return routeDurationLimitBuilder_ != null || routeDurationLimit_ != null;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     *
     * @return The routeDurationLimit.
     */
    public com.google.cloud.optimization.v1.Vehicle.DurationLimit getRouteDurationLimit() {
      if (routeDurationLimitBuilder_ == null) {
        return routeDurationLimit_ == null
            ? com.google.cloud.optimization.v1.Vehicle.DurationLimit.getDefaultInstance()
            : routeDurationLimit_;
      } else {
        return routeDurationLimitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     */
    public Builder setRouteDurationLimit(
        com.google.cloud.optimization.v1.Vehicle.DurationLimit value) {
      if (routeDurationLimitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        routeDurationLimit_ = value;
        onChanged();
      } else {
        routeDurationLimitBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     */
    public Builder setRouteDurationLimit(
        com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder builderForValue) {
      if (routeDurationLimitBuilder_ == null) {
        routeDurationLimit_ = builderForValue.build();
        onChanged();
      } else {
        routeDurationLimitBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     */
    public Builder mergeRouteDurationLimit(
        com.google.cloud.optimization.v1.Vehicle.DurationLimit value) {
      if (routeDurationLimitBuilder_ == null) {
        if (routeDurationLimit_ != null) {
          routeDurationLimit_ =
              com.google.cloud.optimization.v1.Vehicle.DurationLimit.newBuilder(routeDurationLimit_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          routeDurationLimit_ = value;
        }
        onChanged();
      } else {
        routeDurationLimitBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     */
    public Builder clearRouteDurationLimit() {
      if (routeDurationLimitBuilder_ == null) {
        routeDurationLimit_ = null;
        onChanged();
      } else {
        routeDurationLimit_ = null;
        routeDurationLimitBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     */
    public com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder
        getRouteDurationLimitBuilder() {

      onChanged();
      return getRouteDurationLimitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     */
    public com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder
        getRouteDurationLimitOrBuilder() {
      if (routeDurationLimitBuilder_ != null) {
        return routeDurationLimitBuilder_.getMessageOrBuilder();
      } else {
        return routeDurationLimit_ == null
            ? com.google.cloud.optimization.v1.Vehicle.DurationLimit.getDefaultInstance()
            : routeDurationLimit_;
      }
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route duration of a vehicle is the
     * difference between its `vehicle_end_time` and `vehicle_start_time`.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit route_duration_limit = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.Vehicle.DurationLimit,
            com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder,
            com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder>
        getRouteDurationLimitFieldBuilder() {
      if (routeDurationLimitBuilder_ == null) {
        routeDurationLimitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.Vehicle.DurationLimit,
                com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder,
                com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder>(
                getRouteDurationLimit(), getParentForChildren(), isClean());
        routeDurationLimit_ = null;
      }
      return routeDurationLimitBuilder_;
    }

    private com.google.cloud.optimization.v1.Vehicle.DurationLimit travelDurationLimit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.Vehicle.DurationLimit,
            com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder,
            com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder>
        travelDurationLimitBuilder_;
    /**
     *
     *
     * <pre>
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     *
     * @return Whether the travelDurationLimit field is set.
     */
    public boolean hasTravelDurationLimit() {
      return travelDurationLimitBuilder_ != null || travelDurationLimit_ != null;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     *
     * @return The travelDurationLimit.
     */
    public com.google.cloud.optimization.v1.Vehicle.DurationLimit getTravelDurationLimit() {
      if (travelDurationLimitBuilder_ == null) {
        return travelDurationLimit_ == null
            ? com.google.cloud.optimization.v1.Vehicle.DurationLimit.getDefaultInstance()
            : travelDurationLimit_;
      } else {
        return travelDurationLimitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     */
    public Builder setTravelDurationLimit(
        com.google.cloud.optimization.v1.Vehicle.DurationLimit value) {
      if (travelDurationLimitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        travelDurationLimit_ = value;
        onChanged();
      } else {
        travelDurationLimitBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     */
    public Builder setTravelDurationLimit(
        com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder builderForValue) {
      if (travelDurationLimitBuilder_ == null) {
        travelDurationLimit_ = builderForValue.build();
        onChanged();
      } else {
        travelDurationLimitBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     */
    public Builder mergeTravelDurationLimit(
        com.google.cloud.optimization.v1.Vehicle.DurationLimit value) {
      if (travelDurationLimitBuilder_ == null) {
        if (travelDurationLimit_ != null) {
          travelDurationLimit_ =
              com.google.cloud.optimization.v1.Vehicle.DurationLimit.newBuilder(
                      travelDurationLimit_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          travelDurationLimit_ = value;
        }
        onChanged();
      } else {
        travelDurationLimitBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     */
    public Builder clearTravelDurationLimit() {
      if (travelDurationLimitBuilder_ == null) {
        travelDurationLimit_ = null;
        onChanged();
      } else {
        travelDurationLimit_ = null;
        travelDurationLimitBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     */
    public com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder
        getTravelDurationLimitBuilder() {

      onChanged();
      return getTravelDurationLimitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     */
    public com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder
        getTravelDurationLimitOrBuilder() {
      if (travelDurationLimitBuilder_ != null) {
        return travelDurationLimitBuilder_.getMessageOrBuilder();
      } else {
        return travelDurationLimit_ == null
            ? com.google.cloud.optimization.v1.Vehicle.DurationLimit.getDefaultInstance()
            : travelDurationLimit_;
      }
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the travel duration of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route travel duration is the sum of all its
     * [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Vehicle.DurationLimit travel_duration_limit = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.Vehicle.DurationLimit,
            com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder,
            com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder>
        getTravelDurationLimitFieldBuilder() {
      if (travelDurationLimitBuilder_ == null) {
        travelDurationLimitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.Vehicle.DurationLimit,
                com.google.cloud.optimization.v1.Vehicle.DurationLimit.Builder,
                com.google.cloud.optimization.v1.Vehicle.DurationLimitOrBuilder>(
                getTravelDurationLimit(), getParentForChildren(), isClean());
        travelDurationLimit_ = null;
      }
      return travelDurationLimitBuilder_;
    }

    private com.google.cloud.optimization.v1.DistanceLimit routeDistanceLimit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.DistanceLimit,
            com.google.cloud.optimization.v1.DistanceLimit.Builder,
            com.google.cloud.optimization.v1.DistanceLimitOrBuilder>
        routeDistanceLimitBuilder_;
    /**
     *
     *
     * <pre>
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
     *
     * @return Whether the routeDistanceLimit field is set.
     */
    public boolean hasRouteDistanceLimit() {
      return routeDistanceLimitBuilder_ != null || routeDistanceLimit_ != null;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
     *
     * @return The routeDistanceLimit.
     */
    public com.google.cloud.optimization.v1.DistanceLimit getRouteDistanceLimit() {
      if (routeDistanceLimitBuilder_ == null) {
        return routeDistanceLimit_ == null
            ? com.google.cloud.optimization.v1.DistanceLimit.getDefaultInstance()
            : routeDistanceLimit_;
      } else {
        return routeDistanceLimitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
     */
    public Builder setRouteDistanceLimit(com.google.cloud.optimization.v1.DistanceLimit value) {
      if (routeDistanceLimitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        routeDistanceLimit_ = value;
        onChanged();
      } else {
        routeDistanceLimitBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
     */
    public Builder setRouteDistanceLimit(
        com.google.cloud.optimization.v1.DistanceLimit.Builder builderForValue) {
      if (routeDistanceLimitBuilder_ == null) {
        routeDistanceLimit_ = builderForValue.build();
        onChanged();
      } else {
        routeDistanceLimitBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
     */
    public Builder mergeRouteDistanceLimit(com.google.cloud.optimization.v1.DistanceLimit value) {
      if (routeDistanceLimitBuilder_ == null) {
        if (routeDistanceLimit_ != null) {
          routeDistanceLimit_ =
              com.google.cloud.optimization.v1.DistanceLimit.newBuilder(routeDistanceLimit_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          routeDistanceLimit_ = value;
        }
        onChanged();
      } else {
        routeDistanceLimitBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
     */
    public Builder clearRouteDistanceLimit() {
      if (routeDistanceLimitBuilder_ == null) {
        routeDistanceLimit_ = null;
        onChanged();
      } else {
        routeDistanceLimit_ = null;
        routeDistanceLimitBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
     */
    public com.google.cloud.optimization.v1.DistanceLimit.Builder getRouteDistanceLimitBuilder() {

      onChanged();
      return getRouteDistanceLimitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
     */
    public com.google.cloud.optimization.v1.DistanceLimitOrBuilder
        getRouteDistanceLimitOrBuilder() {
      if (routeDistanceLimitBuilder_ != null) {
        return routeDistanceLimitBuilder_.getMessageOrBuilder();
      } else {
        return routeDistanceLimit_ == null
            ? com.google.cloud.optimization.v1.DistanceLimit.getDefaultInstance()
            : routeDistanceLimit_;
      }
    }
    /**
     *
     *
     * <pre>
     * Limit applied to the total distance of the vehicle's route. In a given
     * `OptimizeToursResponse`, the route distance is the sum of all its
     * [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit route_distance_limit = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.DistanceLimit,
            com.google.cloud.optimization.v1.DistanceLimit.Builder,
            com.google.cloud.optimization.v1.DistanceLimitOrBuilder>
        getRouteDistanceLimitFieldBuilder() {
      if (routeDistanceLimitBuilder_ == null) {
        routeDistanceLimitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.DistanceLimit,
                com.google.cloud.optimization.v1.DistanceLimit.Builder,
                com.google.cloud.optimization.v1.DistanceLimitOrBuilder>(
                getRouteDistanceLimit(), getParentForChildren(), isClean());
        routeDistanceLimit_ = null;
      }
      return routeDistanceLimitBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Duration>
        extraVisitDurationForVisitType_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Duration>
        internalGetExtraVisitDurationForVisitType() {
      if (extraVisitDurationForVisitType_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry);
      }
      return extraVisitDurationForVisitType_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Duration>
        internalGetMutableExtraVisitDurationForVisitType() {
      onChanged();
      ;
      if (extraVisitDurationForVisitType_ == null) {
        extraVisitDurationForVisitType_ =
            com.google.protobuf.MapField.newMapField(
                ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry);
      }
      if (!extraVisitDurationForVisitType_.isMutable()) {
        extraVisitDurationForVisitType_ = extraVisitDurationForVisitType_.copy();
      }
      return extraVisitDurationForVisitType_;
    }

    public int getExtraVisitDurationForVisitTypeCount() {
      return internalGetExtraVisitDurationForVisitType().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Specifies a map from visit_types strings to durations. The duration is time
     * in addition to
     * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
     * to be taken at visits with the specified `visit_types`. This extra visit
     * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
     * `visit_types`) cannot be empty strings.
     * If a visit request has multiple types, a duration will be added for each
     * type in the map.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
     * </code>
     */
    @java.lang.Override
    public boolean containsExtraVisitDurationForVisitType(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetExtraVisitDurationForVisitType().getMap().containsKey(key);
    }
    /** Use {@link #getExtraVisitDurationForVisitTypeMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Duration>
        getExtraVisitDurationForVisitType() {
      return getExtraVisitDurationForVisitTypeMap();
    }
    /**
     *
     *
     * <pre>
     * Specifies a map from visit_types strings to durations. The duration is time
     * in addition to
     * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
     * to be taken at visits with the specified `visit_types`. This extra visit
     * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
     * `visit_types`) cannot be empty strings.
     * If a visit request has multiple types, a duration will be added for each
     * type in the map.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Duration>
        getExtraVisitDurationForVisitTypeMap() {
      return internalGetExtraVisitDurationForVisitType().getMap();
    }
    /**
     *
     *
     * <pre>
     * Specifies a map from visit_types strings to durations. The duration is time
     * in addition to
     * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
     * to be taken at visits with the specified `visit_types`. This extra visit
     * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
     * `visit_types`) cannot be empty strings.
     * If a visit request has multiple types, a duration will be added for each
     * type in the map.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.Duration getExtraVisitDurationForVisitTypeOrDefault(
        java.lang.String key, com.google.protobuf.Duration defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Duration> map =
          internalGetExtraVisitDurationForVisitType().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Specifies a map from visit_types strings to durations. The duration is time
     * in addition to
     * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
     * to be taken at visits with the specified `visit_types`. This extra visit
     * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
     * `visit_types`) cannot be empty strings.
     * If a visit request has multiple types, a duration will be added for each
     * type in the map.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.Duration getExtraVisitDurationForVisitTypeOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Duration> map =
          internalGetExtraVisitDurationForVisitType().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearExtraVisitDurationForVisitType() {
      internalGetMutableExtraVisitDurationForVisitType().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a map from visit_types strings to durations. The duration is time
     * in addition to
     * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
     * to be taken at visits with the specified `visit_types`. This extra visit
     * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
     * `visit_types`) cannot be empty strings.
     * If a visit request has multiple types, a duration will be added for each
     * type in the map.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
     * </code>
     */
    public Builder removeExtraVisitDurationForVisitType(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableExtraVisitDurationForVisitType().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Duration>
        getMutableExtraVisitDurationForVisitType() {
      return internalGetMutableExtraVisitDurationForVisitType().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Specifies a map from visit_types strings to durations. The duration is time
     * in addition to
     * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
     * to be taken at visits with the specified `visit_types`. This extra visit
     * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
     * `visit_types`) cannot be empty strings.
     * If a visit request has multiple types, a duration will be added for each
     * type in the map.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
     * </code>
     */
    public Builder putExtraVisitDurationForVisitType(
        java.lang.String key, com.google.protobuf.Duration value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableExtraVisitDurationForVisitType().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a map from visit_types strings to durations. The duration is time
     * in addition to
     * [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
     * to be taken at visits with the specified `visit_types`. This extra visit
     * duration adds cost if `cost_per_hour` is specified. Keys (i.e.
     * `visit_types`) cannot be empty strings.
     * If a visit request has multiple types, a duration will be added for each
     * type in the map.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Duration&gt; extra_visit_duration_for_visit_type = 24;
     * </code>
     */
    public Builder putAllExtraVisitDurationForVisitType(
        java.util.Map<java.lang.String, com.google.protobuf.Duration> values) {
      internalGetMutableExtraVisitDurationForVisitType().getMutableMap().putAll(values);
      return this;
    }

    private com.google.cloud.optimization.v1.BreakRule breakRule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.BreakRule,
            com.google.cloud.optimization.v1.BreakRule.Builder,
            com.google.cloud.optimization.v1.BreakRuleOrBuilder>
        breakRuleBuilder_;
    /**
     *
     *
     * <pre>
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
     *
     * @return Whether the breakRule field is set.
     */
    public boolean hasBreakRule() {
      return breakRuleBuilder_ != null || breakRule_ != null;
    }
    /**
     *
     *
     * <pre>
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
     *
     * @return The breakRule.
     */
    public com.google.cloud.optimization.v1.BreakRule getBreakRule() {
      if (breakRuleBuilder_ == null) {
        return breakRule_ == null
            ? com.google.cloud.optimization.v1.BreakRule.getDefaultInstance()
            : breakRule_;
      } else {
        return breakRuleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
     */
    public Builder setBreakRule(com.google.cloud.optimization.v1.BreakRule value) {
      if (breakRuleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        breakRule_ = value;
        onChanged();
      } else {
        breakRuleBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
     */
    public Builder setBreakRule(
        com.google.cloud.optimization.v1.BreakRule.Builder builderForValue) {
      if (breakRuleBuilder_ == null) {
        breakRule_ = builderForValue.build();
        onChanged();
      } else {
        breakRuleBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
     */
    public Builder mergeBreakRule(com.google.cloud.optimization.v1.BreakRule value) {
      if (breakRuleBuilder_ == null) {
        if (breakRule_ != null) {
          breakRule_ =
              com.google.cloud.optimization.v1.BreakRule.newBuilder(breakRule_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          breakRule_ = value;
        }
        onChanged();
      } else {
        breakRuleBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
     */
    public Builder clearBreakRule() {
      if (breakRuleBuilder_ == null) {
        breakRule_ = null;
        onChanged();
      } else {
        breakRule_ = null;
        breakRuleBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
     */
    public com.google.cloud.optimization.v1.BreakRule.Builder getBreakRuleBuilder() {

      onChanged();
      return getBreakRuleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
     */
    public com.google.cloud.optimization.v1.BreakRuleOrBuilder getBreakRuleOrBuilder() {
      if (breakRuleBuilder_ != null) {
        return breakRuleBuilder_.getMessageOrBuilder();
      } else {
        return breakRule_ == null
            ? com.google.cloud.optimization.v1.BreakRule.getDefaultInstance()
            : breakRule_;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the break schedule to be enforced on this vehicle.
     * If empty, no breaks will be scheduled for this vehicle.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.BreakRule break_rule = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.BreakRule,
            com.google.cloud.optimization.v1.BreakRule.Builder,
            com.google.cloud.optimization.v1.BreakRuleOrBuilder>
        getBreakRuleFieldBuilder() {
      if (breakRuleBuilder_ == null) {
        breakRuleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.BreakRule,
                com.google.cloud.optimization.v1.BreakRule.Builder,
                com.google.cloud.optimization.v1.BreakRuleOrBuilder>(
                getBreakRule(), getParentForChildren(), isClean());
        breakRule_ = null;
      }
      return breakRuleBuilder_;
    }

    private java.lang.Object label_ = "";
    /**
     *
     *
     * <pre>
     * Specifies a label for this vehicle. This label is reported in the response
     * as the `vehicle_label` of the corresponding [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
     * </pre>
     *
     * <code>string label = 27;</code>
     *
     * @return The label.
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a label for this vehicle. This label is reported in the response
     * as the `vehicle_label` of the corresponding [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
     * </pre>
     *
     * <code>string label = 27;</code>
     *
     * @return The bytes for label.
     */
    public com.google.protobuf.ByteString getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a label for this vehicle. This label is reported in the response
     * as the `vehicle_label` of the corresponding [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
     * </pre>
     *
     * <code>string label = 27;</code>
     *
     * @param value The label to set.
     * @return This builder for chaining.
     */
    public Builder setLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      label_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a label for this vehicle. This label is reported in the response
     * as the `vehicle_label` of the corresponding [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
     * </pre>
     *
     * <code>string label = 27;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabel() {

      label_ = getDefaultInstance().getLabel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a label for this vehicle. This label is reported in the response
     * as the `vehicle_label` of the corresponding [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
     * </pre>
     *
     * <code>string label = 27;</code>
     *
     * @param value The bytes for label to set.
     * @return This builder for chaining.
     */
    public Builder setLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      label_ = value;
      onChanged();
      return this;
    }

    private boolean ignore_;
    /**
     *
     *
     * <pre>
     * If true, `used_if_route_is_empty` must be false, and this vehicle will
     * remain unused.
     * If a shipment is performed by an ignored vehicle in
     * `injected_first_solution_routes`, it is skipped in the first solution but
     * is free to be performed in the response.
     * If a shipment is performed by an ignored vehicle in
     * `injected_solution_constraint` and any related pickup/delivery is
     * constrained to remain on the vehicle (i.e., not relaxed to level
     * `RELAX_ALL_AFTER_THRESHOLD`), it is skipped in the response.
     * If a shipment has a non-empty `allowed_vehicle_indices` field and all of
     * the allowed vehicles are ignored, it is skipped in the response.
     * </pre>
     *
     * <code>bool ignore = 28;</code>
     *
     * @return The ignore.
     */
    @java.lang.Override
    public boolean getIgnore() {
      return ignore_;
    }
    /**
     *
     *
     * <pre>
     * If true, `used_if_route_is_empty` must be false, and this vehicle will
     * remain unused.
     * If a shipment is performed by an ignored vehicle in
     * `injected_first_solution_routes`, it is skipped in the first solution but
     * is free to be performed in the response.
     * If a shipment is performed by an ignored vehicle in
     * `injected_solution_constraint` and any related pickup/delivery is
     * constrained to remain on the vehicle (i.e., not relaxed to level
     * `RELAX_ALL_AFTER_THRESHOLD`), it is skipped in the response.
     * If a shipment has a non-empty `allowed_vehicle_indices` field and all of
     * the allowed vehicles are ignored, it is skipped in the response.
     * </pre>
     *
     * <code>bool ignore = 28;</code>
     *
     * @param value The ignore to set.
     * @return This builder for chaining.
     */
    public Builder setIgnore(boolean value) {

      ignore_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, `used_if_route_is_empty` must be false, and this vehicle will
     * remain unused.
     * If a shipment is performed by an ignored vehicle in
     * `injected_first_solution_routes`, it is skipped in the first solution but
     * is free to be performed in the response.
     * If a shipment is performed by an ignored vehicle in
     * `injected_solution_constraint` and any related pickup/delivery is
     * constrained to remain on the vehicle (i.e., not relaxed to level
     * `RELAX_ALL_AFTER_THRESHOLD`), it is skipped in the response.
     * If a shipment has a non-empty `allowed_vehicle_indices` field and all of
     * the allowed vehicles are ignored, it is skipped in the response.
     * </pre>
     *
     * <code>bool ignore = 28;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnore() {

      ignore_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList breakRuleIndices_ = emptyIntList();

    private void ensureBreakRuleIndicesIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        breakRuleIndices_ = mutableCopy(breakRuleIndices_);
        bitField0_ |= 0x00000080;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Indices in the `break_rule` field in the source
     * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
     * As of 2018/03, at most one rule index per vehicle can be specified.
     * </pre>
     *
     * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
     * @return A list containing the breakRuleIndices.
     */
    @java.lang.Deprecated
    public java.util.List<java.lang.Integer> getBreakRuleIndicesList() {
      return ((bitField0_ & 0x00000080) != 0)
          ? java.util.Collections.unmodifiableList(breakRuleIndices_)
          : breakRuleIndices_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Indices in the `break_rule` field in the source
     * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
     * As of 2018/03, at most one rule index per vehicle can be specified.
     * </pre>
     *
     * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
     * @return The count of breakRuleIndices.
     */
    @java.lang.Deprecated
    public int getBreakRuleIndicesCount() {
      return breakRuleIndices_.size();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Indices in the `break_rule` field in the source
     * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
     * As of 2018/03, at most one rule index per vehicle can be specified.
     * </pre>
     *
     * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
     * @param index The index of the element to return.
     * @return The breakRuleIndices at the given index.
     */
    @java.lang.Deprecated
    public int getBreakRuleIndices(int index) {
      return breakRuleIndices_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Indices in the `break_rule` field in the source
     * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
     * As of 2018/03, at most one rule index per vehicle can be specified.
     * </pre>
     *
     * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
     * @param index The index to set the value at.
     * @param value The breakRuleIndices to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setBreakRuleIndices(int index, int value) {
      ensureBreakRuleIndicesIsMutable();
      breakRuleIndices_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Indices in the `break_rule` field in the source
     * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
     * As of 2018/03, at most one rule index per vehicle can be specified.
     * </pre>
     *
     * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
     * @param value The breakRuleIndices to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addBreakRuleIndices(int value) {
      ensureBreakRuleIndicesIsMutable();
      breakRuleIndices_.addInt(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Indices in the `break_rule` field in the source
     * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
     * As of 2018/03, at most one rule index per vehicle can be specified.
     * </pre>
     *
     * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
     * @param values The breakRuleIndices to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllBreakRuleIndices(java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureBreakRuleIndicesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, breakRuleIndices_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Indices in the `break_rule` field in the source
     * [ShipmentModel][]. They correspond to break rules enforced on the vehicle.
     * As of 2018/03, at most one rule index per vehicle can be specified.
     * </pre>
     *
     * <code>repeated int32 break_rule_indices = 29 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.Vehicle.break_rule_indices is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=1379
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearBreakRuleIndices() {
      breakRuleIndices_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> capacities_ =
        java.util.Collections.emptyList();

    private void ensureCapacitiesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        capacities_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.CapacityQuantity>(capacities_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.CapacityQuantity,
            com.google.cloud.optimization.v1.CapacityQuantity.Builder,
            com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        capacitiesBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getCapacitiesList() {
      if (capacitiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(capacities_);
      } else {
        return capacitiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getCapacitiesCount() {
      if (capacitiesBuilder_ == null) {
        return capacities_.size();
      } else {
        return capacitiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity getCapacities(int index) {
      if (capacitiesBuilder_ == null) {
        return capacities_.get(index);
      } else {
        return capacitiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setCapacities(
        int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
      if (capacitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCapacitiesIsMutable();
        capacities_.set(index, value);
        onChanged();
      } else {
        capacitiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setCapacities(
        int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
      if (capacitiesBuilder_ == null) {
        ensureCapacitiesIsMutable();
        capacities_.set(index, builderForValue.build());
        onChanged();
      } else {
        capacitiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addCapacities(com.google.cloud.optimization.v1.CapacityQuantity value) {
      if (capacitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCapacitiesIsMutable();
        capacities_.add(value);
        onChanged();
      } else {
        capacitiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addCapacities(
        int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
      if (capacitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCapacitiesIsMutable();
        capacities_.add(index, value);
        onChanged();
      } else {
        capacitiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addCapacities(
        com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
      if (capacitiesBuilder_ == null) {
        ensureCapacitiesIsMutable();
        capacities_.add(builderForValue.build());
        onChanged();
      } else {
        capacitiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addCapacities(
        int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
      if (capacitiesBuilder_ == null) {
        ensureCapacitiesIsMutable();
        capacities_.add(index, builderForValue.build());
        onChanged();
      } else {
        capacitiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllCapacities(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.CapacityQuantity> values) {
      if (capacitiesBuilder_ == null) {
        ensureCapacitiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, capacities_);
        onChanged();
      } else {
        capacitiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearCapacities() {
      if (capacitiesBuilder_ == null) {
        capacities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        capacitiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeCapacities(int index) {
      if (capacitiesBuilder_ == null) {
        ensureCapacitiesIsMutable();
        capacities_.remove(index);
        onChanged();
      } else {
        capacitiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity.Builder getCapacitiesBuilder(
        int index) {
      return getCapacitiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getCapacitiesOrBuilder(
        int index) {
      if (capacitiesBuilder_ == null) {
        return capacities_.get(index);
      } else {
        return capacitiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getCapacitiesOrBuilderList() {
      if (capacitiesBuilder_ != null) {
        return capacitiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(capacities_);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity.Builder addCapacitiesBuilder() {
      return getCapacitiesFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity.Builder addCapacitiesBuilder(
        int index) {
      return getCapacitiesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.load_limits][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity capacities = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity.Builder>
        getCapacitiesBuilderList() {
      return getCapacitiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.CapacityQuantity,
            com.google.cloud.optimization.v1.CapacityQuantity.Builder,
            com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getCapacitiesFieldBuilder() {
      if (capacitiesBuilder_ == null) {
        capacitiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.CapacityQuantity,
                com.google.cloud.optimization.v1.CapacityQuantity.Builder,
                com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>(
                capacities_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        capacities_ = null;
      }
      return capacitiesBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval>
        startLoadIntervals_ = java.util.Collections.emptyList();

    private void ensureStartLoadIntervalsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        startLoadIntervals_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.CapacityQuantityInterval>(
                startLoadIntervals_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.CapacityQuantityInterval,
            com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder,
            com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>
        startLoadIntervalsBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval>
        getStartLoadIntervalsList() {
      if (startLoadIntervalsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(startLoadIntervals_);
      } else {
        return startLoadIntervalsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getStartLoadIntervalsCount() {
      if (startLoadIntervalsBuilder_ == null) {
        return startLoadIntervals_.size();
      } else {
        return startLoadIntervalsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityInterval getStartLoadIntervals(
        int index) {
      if (startLoadIntervalsBuilder_ == null) {
        return startLoadIntervals_.get(index);
      } else {
        return startLoadIntervalsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setStartLoadIntervals(
        int index, com.google.cloud.optimization.v1.CapacityQuantityInterval value) {
      if (startLoadIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStartLoadIntervalsIsMutable();
        startLoadIntervals_.set(index, value);
        onChanged();
      } else {
        startLoadIntervalsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setStartLoadIntervals(
        int index,
        com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder builderForValue) {
      if (startLoadIntervalsBuilder_ == null) {
        ensureStartLoadIntervalsIsMutable();
        startLoadIntervals_.set(index, builderForValue.build());
        onChanged();
      } else {
        startLoadIntervalsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addStartLoadIntervals(
        com.google.cloud.optimization.v1.CapacityQuantityInterval value) {
      if (startLoadIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStartLoadIntervalsIsMutable();
        startLoadIntervals_.add(value);
        onChanged();
      } else {
        startLoadIntervalsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addStartLoadIntervals(
        int index, com.google.cloud.optimization.v1.CapacityQuantityInterval value) {
      if (startLoadIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStartLoadIntervalsIsMutable();
        startLoadIntervals_.add(index, value);
        onChanged();
      } else {
        startLoadIntervalsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addStartLoadIntervals(
        com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder builderForValue) {
      if (startLoadIntervalsBuilder_ == null) {
        ensureStartLoadIntervalsIsMutable();
        startLoadIntervals_.add(builderForValue.build());
        onChanged();
      } else {
        startLoadIntervalsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addStartLoadIntervals(
        int index,
        com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder builderForValue) {
      if (startLoadIntervalsBuilder_ == null) {
        ensureStartLoadIntervalsIsMutable();
        startLoadIntervals_.add(index, builderForValue.build());
        onChanged();
      } else {
        startLoadIntervalsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllStartLoadIntervals(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.CapacityQuantityInterval>
            values) {
      if (startLoadIntervalsBuilder_ == null) {
        ensureStartLoadIntervalsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, startLoadIntervals_);
        onChanged();
      } else {
        startLoadIntervalsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearStartLoadIntervals() {
      if (startLoadIntervalsBuilder_ == null) {
        startLoadIntervals_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        startLoadIntervalsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeStartLoadIntervals(int index) {
      if (startLoadIntervalsBuilder_ == null) {
        ensureStartLoadIntervalsIsMutable();
        startLoadIntervals_.remove(index);
        onChanged();
      } else {
        startLoadIntervalsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder
        getStartLoadIntervalsBuilder(int index) {
      return getStartLoadIntervalsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder
        getStartLoadIntervalsOrBuilder(int index) {
      if (startLoadIntervalsBuilder_ == null) {
        return startLoadIntervals_.get(index);
      } else {
        return startLoadIntervalsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>
        getStartLoadIntervalsOrBuilderList() {
      if (startLoadIntervalsBuilder_ != null) {
        return startLoadIntervalsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(startLoadIntervals_);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder
        addStartLoadIntervalsBuilder() {
      return getStartLoadIntervalsFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.CapacityQuantityInterval.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder
        addStartLoadIntervalsBuilder(int index) {
      return getStartLoadIntervalsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.CapacityQuantityInterval.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.start_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval start_load_intervals = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder>
        getStartLoadIntervalsBuilderList() {
      return getStartLoadIntervalsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.CapacityQuantityInterval,
            com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder,
            com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>
        getStartLoadIntervalsFieldBuilder() {
      if (startLoadIntervalsBuilder_ == null) {
        startLoadIntervalsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.CapacityQuantityInterval,
                com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder,
                com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>(
                startLoadIntervals_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        startLoadIntervals_ = null;
      }
      return startLoadIntervalsBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval>
        endLoadIntervals_ = java.util.Collections.emptyList();

    private void ensureEndLoadIntervalsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        endLoadIntervals_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.CapacityQuantityInterval>(
                endLoadIntervals_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.CapacityQuantityInterval,
            com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder,
            com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>
        endLoadIntervalsBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval>
        getEndLoadIntervalsList() {
      if (endLoadIntervalsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(endLoadIntervals_);
      } else {
        return endLoadIntervalsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getEndLoadIntervalsCount() {
      if (endLoadIntervalsBuilder_ == null) {
        return endLoadIntervals_.size();
      } else {
        return endLoadIntervalsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityInterval getEndLoadIntervals(
        int index) {
      if (endLoadIntervalsBuilder_ == null) {
        return endLoadIntervals_.get(index);
      } else {
        return endLoadIntervalsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setEndLoadIntervals(
        int index, com.google.cloud.optimization.v1.CapacityQuantityInterval value) {
      if (endLoadIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndLoadIntervalsIsMutable();
        endLoadIntervals_.set(index, value);
        onChanged();
      } else {
        endLoadIntervalsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setEndLoadIntervals(
        int index,
        com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder builderForValue) {
      if (endLoadIntervalsBuilder_ == null) {
        ensureEndLoadIntervalsIsMutable();
        endLoadIntervals_.set(index, builderForValue.build());
        onChanged();
      } else {
        endLoadIntervalsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addEndLoadIntervals(
        com.google.cloud.optimization.v1.CapacityQuantityInterval value) {
      if (endLoadIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndLoadIntervalsIsMutable();
        endLoadIntervals_.add(value);
        onChanged();
      } else {
        endLoadIntervalsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addEndLoadIntervals(
        int index, com.google.cloud.optimization.v1.CapacityQuantityInterval value) {
      if (endLoadIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndLoadIntervalsIsMutable();
        endLoadIntervals_.add(index, value);
        onChanged();
      } else {
        endLoadIntervalsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addEndLoadIntervals(
        com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder builderForValue) {
      if (endLoadIntervalsBuilder_ == null) {
        ensureEndLoadIntervalsIsMutable();
        endLoadIntervals_.add(builderForValue.build());
        onChanged();
      } else {
        endLoadIntervalsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addEndLoadIntervals(
        int index,
        com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder builderForValue) {
      if (endLoadIntervalsBuilder_ == null) {
        ensureEndLoadIntervalsIsMutable();
        endLoadIntervals_.add(index, builderForValue.build());
        onChanged();
      } else {
        endLoadIntervalsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllEndLoadIntervals(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.CapacityQuantityInterval>
            values) {
      if (endLoadIntervalsBuilder_ == null) {
        ensureEndLoadIntervalsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, endLoadIntervals_);
        onChanged();
      } else {
        endLoadIntervalsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearEndLoadIntervals() {
      if (endLoadIntervalsBuilder_ == null) {
        endLoadIntervals_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        endLoadIntervalsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeEndLoadIntervals(int index) {
      if (endLoadIntervalsBuilder_ == null) {
        ensureEndLoadIntervalsIsMutable();
        endLoadIntervals_.remove(index);
        onChanged();
      } else {
        endLoadIntervalsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder
        getEndLoadIntervalsBuilder(int index) {
      return getEndLoadIntervalsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder
        getEndLoadIntervalsOrBuilder(int index) {
      if (endLoadIntervalsBuilder_ == null) {
        return endLoadIntervals_.get(index);
      } else {
        return endLoadIntervalsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>
        getEndLoadIntervalsOrBuilderList() {
      if (endLoadIntervalsBuilder_ != null) {
        return endLoadIntervalsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(endLoadIntervals_);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder
        addEndLoadIntervalsBuilder() {
      return getEndLoadIntervalsFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.CapacityQuantityInterval.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder
        addEndLoadIntervalsBuilder(int index) {
      return getEndLoadIntervalsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.CapacityQuantityInterval.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Vehicle.LoadLimit.end_load_interval][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantityInterval end_load_intervals = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder>
        getEndLoadIntervalsBuilderList() {
      return getEndLoadIntervalsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.CapacityQuantityInterval,
            com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder,
            com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>
        getEndLoadIntervalsFieldBuilder() {
      if (endLoadIntervalsBuilder_ == null) {
        endLoadIntervalsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.CapacityQuantityInterval,
                com.google.cloud.optimization.v1.CapacityQuantityInterval.Builder,
                com.google.cloud.optimization.v1.CapacityQuantityIntervalOrBuilder>(
                endLoadIntervals_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        endLoadIntervals_ = null;
      }
      return endLoadIntervalsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.Vehicle)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.Vehicle)
  private static final com.google.cloud.optimization.v1.Vehicle DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.Vehicle();
  }

  public static com.google.cloud.optimization.v1.Vehicle getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Vehicle> PARSER =
      new com.google.protobuf.AbstractParser<Vehicle>() {
        @java.lang.Override
        public Vehicle parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Vehicle> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Vehicle> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.Vehicle getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
