/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Specifies attributes of transitions between two consecutive visits on a
 * route. Several `TransitionAttributes` may apply to the same transition: in
 * that case, all extra costs add up and the strictest constraint or limit
 * applies (following natural "AND" semantics).
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.TransitionAttributes}
 */
public final class TransitionAttributes extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.TransitionAttributes)
    TransitionAttributesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransitionAttributes.newBuilder() to construct.
  private TransitionAttributes(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransitionAttributes() {
    srcTag_ = "";
    excludedSrcTag_ = "";
    dstTag_ = "";
    excludedDstTag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransitionAttributes();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_TransitionAttributes_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_TransitionAttributes_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.TransitionAttributes.class,
            com.google.cloud.optimization.v1.TransitionAttributes.Builder.class);
  }

  public static final int SRC_TAG_FIELD_NUMBER = 1;
  private volatile java.lang.Object srcTag_;
  /**
   *
   *
   * <pre>
   * Tags defining the set of (src-&gt;dst) transitions these attributes apply to.
   * A source visit or vehicle start matches iff its
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags]
   * either contains `src_tag` or does not contain `excluded_src_tag` (depending
   * on which of these two fields is non-empty).
   * </pre>
   *
   * <code>string src_tag = 1;</code>
   *
   * @return The srcTag.
   */
  @java.lang.Override
  public java.lang.String getSrcTag() {
    java.lang.Object ref = srcTag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      srcTag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Tags defining the set of (src-&gt;dst) transitions these attributes apply to.
   * A source visit or vehicle start matches iff its
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags]
   * either contains `src_tag` or does not contain `excluded_src_tag` (depending
   * on which of these two fields is non-empty).
   * </pre>
   *
   * <code>string src_tag = 1;</code>
   *
   * @return The bytes for srcTag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSrcTagBytes() {
    java.lang.Object ref = srcTag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      srcTag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXCLUDED_SRC_TAG_FIELD_NUMBER = 2;
  private volatile java.lang.Object excludedSrcTag_;
  /**
   *
   *
   * <pre>
   * See `src_tag`. Exactly one of `src_tag` and `excluded_src_tag` must be
   * non-empty.
   * </pre>
   *
   * <code>string excluded_src_tag = 2;</code>
   *
   * @return The excludedSrcTag.
   */
  @java.lang.Override
  public java.lang.String getExcludedSrcTag() {
    java.lang.Object ref = excludedSrcTag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      excludedSrcTag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * See `src_tag`. Exactly one of `src_tag` and `excluded_src_tag` must be
   * non-empty.
   * </pre>
   *
   * <code>string excluded_src_tag = 2;</code>
   *
   * @return The bytes for excludedSrcTag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExcludedSrcTagBytes() {
    java.lang.Object ref = excludedSrcTag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      excludedSrcTag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DST_TAG_FIELD_NUMBER = 3;
  private volatile java.lang.Object dstTag_;
  /**
   *
   *
   * <pre>
   * A destination visit or vehicle end matches iff its
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.end_tags][google.cloud.optimization.v1.Vehicle.end_tags] either contains `dst_tag` or does not contain
   * `excluded_dst_tag` (depending on which of these two fields is non-empty).
   * </pre>
   *
   * <code>string dst_tag = 3;</code>
   *
   * @return The dstTag.
   */
  @java.lang.Override
  public java.lang.String getDstTag() {
    java.lang.Object ref = dstTag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dstTag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A destination visit or vehicle end matches iff its
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.end_tags][google.cloud.optimization.v1.Vehicle.end_tags] either contains `dst_tag` or does not contain
   * `excluded_dst_tag` (depending on which of these two fields is non-empty).
   * </pre>
   *
   * <code>string dst_tag = 3;</code>
   *
   * @return The bytes for dstTag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDstTagBytes() {
    java.lang.Object ref = dstTag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dstTag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXCLUDED_DST_TAG_FIELD_NUMBER = 4;
  private volatile java.lang.Object excludedDstTag_;
  /**
   *
   *
   * <pre>
   * See `dst_tag`. Exactly one of `dst_tag` and `excluded_dst_tag` must be
   * non-empty.
   * </pre>
   *
   * <code>string excluded_dst_tag = 4;</code>
   *
   * @return The excludedDstTag.
   */
  @java.lang.Override
  public java.lang.String getExcludedDstTag() {
    java.lang.Object ref = excludedDstTag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      excludedDstTag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * See `dst_tag`. Exactly one of `dst_tag` and `excluded_dst_tag` must be
   * non-empty.
   * </pre>
   *
   * <code>string excluded_dst_tag = 4;</code>
   *
   * @return The bytes for excludedDstTag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExcludedDstTagBytes() {
    java.lang.Object ref = excludedDstTag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      excludedDstTag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COST_FIELD_NUMBER = 5;
  private double cost_;
  /**
   *
   *
   * <pre>
   * Specifies a cost for performing this transition. This is in the same unit
   * as all other costs in the model and must not be negative. It is applied on
   * top of all other existing costs.
   * </pre>
   *
   * <code>double cost = 5;</code>
   *
   * @return The cost.
   */
  @java.lang.Override
  public double getCost() {
    return cost_;
  }

  public static final int COST_PER_KILOMETER_FIELD_NUMBER = 6;
  private double costPerKilometer_;
  /**
   *
   *
   * <pre>
   * Specifies a cost per kilometer applied to the distance traveled while
   * performing this transition. It adds up to any
   * [Vehicle.cost_per_kilometer][google.cloud.optimization.v1.Vehicle.cost_per_kilometer] specified on vehicles.
   * </pre>
   *
   * <code>double cost_per_kilometer = 6;</code>
   *
   * @return The costPerKilometer.
   */
  @java.lang.Override
  public double getCostPerKilometer() {
    return costPerKilometer_;
  }

  public static final int DISTANCE_LIMIT_FIELD_NUMBER = 7;
  private com.google.cloud.optimization.v1.DistanceLimit distanceLimit_;
  /**
   *
   *
   * <pre>
   * Specifies a limit on the distance traveled while performing this
   * transition.
   * As of 2021/06, only soft limits are supported.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
   *
   * @return Whether the distanceLimit field is set.
   */
  @java.lang.Override
  public boolean hasDistanceLimit() {
    return distanceLimit_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies a limit on the distance traveled while performing this
   * transition.
   * As of 2021/06, only soft limits are supported.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
   *
   * @return The distanceLimit.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.DistanceLimit getDistanceLimit() {
    return distanceLimit_ == null
        ? com.google.cloud.optimization.v1.DistanceLimit.getDefaultInstance()
        : distanceLimit_;
  }
  /**
   *
   *
   * <pre>
   * Specifies a limit on the distance traveled while performing this
   * transition.
   * As of 2021/06, only soft limits are supported.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.DistanceLimitOrBuilder getDistanceLimitOrBuilder() {
    return getDistanceLimit();
  }

  public static final int DELAY_FIELD_NUMBER = 8;
  private com.google.protobuf.Duration delay_;
  /**
   *
   *
   * <pre>
   * Specifies a delay incurred when performing this transition.
   * This delay always occurs *after* finishing the source visit and *before*
   * starting the destination visit.
   * </pre>
   *
   * <code>.google.protobuf.Duration delay = 8;</code>
   *
   * @return Whether the delay field is set.
   */
  @java.lang.Override
  public boolean hasDelay() {
    return delay_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies a delay incurred when performing this transition.
   * This delay always occurs *after* finishing the source visit and *before*
   * starting the destination visit.
   * </pre>
   *
   * <code>.google.protobuf.Duration delay = 8;</code>
   *
   * @return The delay.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDelay() {
    return delay_ == null ? com.google.protobuf.Duration.getDefaultInstance() : delay_;
  }
  /**
   *
   *
   * <pre>
   * Specifies a delay incurred when performing this transition.
   * This delay always occurs *after* finishing the source visit and *before*
   * starting the destination visit.
   * </pre>
   *
   * <code>.google.protobuf.Duration delay = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDelayOrBuilder() {
    return getDelay();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(srcTag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, srcTag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(excludedSrcTag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, excludedSrcTag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dstTag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, dstTag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(excludedDstTag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, excludedDstTag_);
    }
    if (java.lang.Double.doubleToRawLongBits(cost_) != 0) {
      output.writeDouble(5, cost_);
    }
    if (java.lang.Double.doubleToRawLongBits(costPerKilometer_) != 0) {
      output.writeDouble(6, costPerKilometer_);
    }
    if (distanceLimit_ != null) {
      output.writeMessage(7, getDistanceLimit());
    }
    if (delay_ != null) {
      output.writeMessage(8, getDelay());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(srcTag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, srcTag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(excludedSrcTag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, excludedSrcTag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dstTag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, dstTag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(excludedDstTag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, excludedDstTag_);
    }
    if (java.lang.Double.doubleToRawLongBits(cost_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(5, cost_);
    }
    if (java.lang.Double.doubleToRawLongBits(costPerKilometer_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(6, costPerKilometer_);
    }
    if (distanceLimit_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDistanceLimit());
    }
    if (delay_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDelay());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.TransitionAttributes)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.TransitionAttributes other =
        (com.google.cloud.optimization.v1.TransitionAttributes) obj;

    if (!getSrcTag().equals(other.getSrcTag())) return false;
    if (!getExcludedSrcTag().equals(other.getExcludedSrcTag())) return false;
    if (!getDstTag().equals(other.getDstTag())) return false;
    if (!getExcludedDstTag().equals(other.getExcludedDstTag())) return false;
    if (java.lang.Double.doubleToLongBits(getCost())
        != java.lang.Double.doubleToLongBits(other.getCost())) return false;
    if (java.lang.Double.doubleToLongBits(getCostPerKilometer())
        != java.lang.Double.doubleToLongBits(other.getCostPerKilometer())) return false;
    if (hasDistanceLimit() != other.hasDistanceLimit()) return false;
    if (hasDistanceLimit()) {
      if (!getDistanceLimit().equals(other.getDistanceLimit())) return false;
    }
    if (hasDelay() != other.hasDelay()) return false;
    if (hasDelay()) {
      if (!getDelay().equals(other.getDelay())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SRC_TAG_FIELD_NUMBER;
    hash = (53 * hash) + getSrcTag().hashCode();
    hash = (37 * hash) + EXCLUDED_SRC_TAG_FIELD_NUMBER;
    hash = (53 * hash) + getExcludedSrcTag().hashCode();
    hash = (37 * hash) + DST_TAG_FIELD_NUMBER;
    hash = (53 * hash) + getDstTag().hashCode();
    hash = (37 * hash) + EXCLUDED_DST_TAG_FIELD_NUMBER;
    hash = (53 * hash) + getExcludedDstTag().hashCode();
    hash = (37 * hash) + COST_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getCost()));
    hash = (37 * hash) + COST_PER_KILOMETER_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getCostPerKilometer()));
    if (hasDistanceLimit()) {
      hash = (37 * hash) + DISTANCE_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getDistanceLimit().hashCode();
    }
    if (hasDelay()) {
      hash = (37 * hash) + DELAY_FIELD_NUMBER;
      hash = (53 * hash) + getDelay().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.optimization.v1.TransitionAttributes prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies attributes of transitions between two consecutive visits on a
   * route. Several `TransitionAttributes` may apply to the same transition: in
   * that case, all extra costs add up and the strictest constraint or limit
   * applies (following natural "AND" semantics).
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.TransitionAttributes}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.TransitionAttributes)
      com.google.cloud.optimization.v1.TransitionAttributesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_TransitionAttributes_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_TransitionAttributes_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.TransitionAttributes.class,
              com.google.cloud.optimization.v1.TransitionAttributes.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.TransitionAttributes.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      srcTag_ = "";

      excludedSrcTag_ = "";

      dstTag_ = "";

      excludedDstTag_ = "";

      cost_ = 0D;

      costPerKilometer_ = 0D;

      if (distanceLimitBuilder_ == null) {
        distanceLimit_ = null;
      } else {
        distanceLimit_ = null;
        distanceLimitBuilder_ = null;
      }
      if (delayBuilder_ == null) {
        delay_ = null;
      } else {
        delay_ = null;
        delayBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_TransitionAttributes_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.TransitionAttributes getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.TransitionAttributes.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.TransitionAttributes build() {
      com.google.cloud.optimization.v1.TransitionAttributes result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.TransitionAttributes buildPartial() {
      com.google.cloud.optimization.v1.TransitionAttributes result =
          new com.google.cloud.optimization.v1.TransitionAttributes(this);
      result.srcTag_ = srcTag_;
      result.excludedSrcTag_ = excludedSrcTag_;
      result.dstTag_ = dstTag_;
      result.excludedDstTag_ = excludedDstTag_;
      result.cost_ = cost_;
      result.costPerKilometer_ = costPerKilometer_;
      if (distanceLimitBuilder_ == null) {
        result.distanceLimit_ = distanceLimit_;
      } else {
        result.distanceLimit_ = distanceLimitBuilder_.build();
      }
      if (delayBuilder_ == null) {
        result.delay_ = delay_;
      } else {
        result.delay_ = delayBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.TransitionAttributes) {
        return mergeFrom((com.google.cloud.optimization.v1.TransitionAttributes) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.TransitionAttributes other) {
      if (other == com.google.cloud.optimization.v1.TransitionAttributes.getDefaultInstance())
        return this;
      if (!other.getSrcTag().isEmpty()) {
        srcTag_ = other.srcTag_;
        onChanged();
      }
      if (!other.getExcludedSrcTag().isEmpty()) {
        excludedSrcTag_ = other.excludedSrcTag_;
        onChanged();
      }
      if (!other.getDstTag().isEmpty()) {
        dstTag_ = other.dstTag_;
        onChanged();
      }
      if (!other.getExcludedDstTag().isEmpty()) {
        excludedDstTag_ = other.excludedDstTag_;
        onChanged();
      }
      if (other.getCost() != 0D) {
        setCost(other.getCost());
      }
      if (other.getCostPerKilometer() != 0D) {
        setCostPerKilometer(other.getCostPerKilometer());
      }
      if (other.hasDistanceLimit()) {
        mergeDistanceLimit(other.getDistanceLimit());
      }
      if (other.hasDelay()) {
        mergeDelay(other.getDelay());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                srcTag_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                excludedSrcTag_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                dstTag_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                excludedDstTag_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 41:
              {
                cost_ = input.readDouble();

                break;
              } // case 41
            case 49:
              {
                costPerKilometer_ = input.readDouble();

                break;
              } // case 49
            case 58:
              {
                input.readMessage(getDistanceLimitFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                input.readMessage(getDelayFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object srcTag_ = "";
    /**
     *
     *
     * <pre>
     * Tags defining the set of (src-&gt;dst) transitions these attributes apply to.
     * A source visit or vehicle start matches iff its
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags]
     * either contains `src_tag` or does not contain `excluded_src_tag` (depending
     * on which of these two fields is non-empty).
     * </pre>
     *
     * <code>string src_tag = 1;</code>
     *
     * @return The srcTag.
     */
    public java.lang.String getSrcTag() {
      java.lang.Object ref = srcTag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        srcTag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Tags defining the set of (src-&gt;dst) transitions these attributes apply to.
     * A source visit or vehicle start matches iff its
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags]
     * either contains `src_tag` or does not contain `excluded_src_tag` (depending
     * on which of these two fields is non-empty).
     * </pre>
     *
     * <code>string src_tag = 1;</code>
     *
     * @return The bytes for srcTag.
     */
    public com.google.protobuf.ByteString getSrcTagBytes() {
      java.lang.Object ref = srcTag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        srcTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Tags defining the set of (src-&gt;dst) transitions these attributes apply to.
     * A source visit or vehicle start matches iff its
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags]
     * either contains `src_tag` or does not contain `excluded_src_tag` (depending
     * on which of these two fields is non-empty).
     * </pre>
     *
     * <code>string src_tag = 1;</code>
     *
     * @param value The srcTag to set.
     * @return This builder for chaining.
     */
    public Builder setSrcTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      srcTag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags defining the set of (src-&gt;dst) transitions these attributes apply to.
     * A source visit or vehicle start matches iff its
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags]
     * either contains `src_tag` or does not contain `excluded_src_tag` (depending
     * on which of these two fields is non-empty).
     * </pre>
     *
     * <code>string src_tag = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSrcTag() {

      srcTag_ = getDefaultInstance().getSrcTag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags defining the set of (src-&gt;dst) transitions these attributes apply to.
     * A source visit or vehicle start matches iff its
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags]
     * either contains `src_tag` or does not contain `excluded_src_tag` (depending
     * on which of these two fields is non-empty).
     * </pre>
     *
     * <code>string src_tag = 1;</code>
     *
     * @param value The bytes for srcTag to set.
     * @return This builder for chaining.
     */
    public Builder setSrcTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      srcTag_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object excludedSrcTag_ = "";
    /**
     *
     *
     * <pre>
     * See `src_tag`. Exactly one of `src_tag` and `excluded_src_tag` must be
     * non-empty.
     * </pre>
     *
     * <code>string excluded_src_tag = 2;</code>
     *
     * @return The excludedSrcTag.
     */
    public java.lang.String getExcludedSrcTag() {
      java.lang.Object ref = excludedSrcTag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        excludedSrcTag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * See `src_tag`. Exactly one of `src_tag` and `excluded_src_tag` must be
     * non-empty.
     * </pre>
     *
     * <code>string excluded_src_tag = 2;</code>
     *
     * @return The bytes for excludedSrcTag.
     */
    public com.google.protobuf.ByteString getExcludedSrcTagBytes() {
      java.lang.Object ref = excludedSrcTag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        excludedSrcTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * See `src_tag`. Exactly one of `src_tag` and `excluded_src_tag` must be
     * non-empty.
     * </pre>
     *
     * <code>string excluded_src_tag = 2;</code>
     *
     * @param value The excludedSrcTag to set.
     * @return This builder for chaining.
     */
    public Builder setExcludedSrcTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      excludedSrcTag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * See `src_tag`. Exactly one of `src_tag` and `excluded_src_tag` must be
     * non-empty.
     * </pre>
     *
     * <code>string excluded_src_tag = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExcludedSrcTag() {

      excludedSrcTag_ = getDefaultInstance().getExcludedSrcTag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * See `src_tag`. Exactly one of `src_tag` and `excluded_src_tag` must be
     * non-empty.
     * </pre>
     *
     * <code>string excluded_src_tag = 2;</code>
     *
     * @param value The bytes for excludedSrcTag to set.
     * @return This builder for chaining.
     */
    public Builder setExcludedSrcTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      excludedSrcTag_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object dstTag_ = "";
    /**
     *
     *
     * <pre>
     * A destination visit or vehicle end matches iff its
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.end_tags][google.cloud.optimization.v1.Vehicle.end_tags] either contains `dst_tag` or does not contain
     * `excluded_dst_tag` (depending on which of these two fields is non-empty).
     * </pre>
     *
     * <code>string dst_tag = 3;</code>
     *
     * @return The dstTag.
     */
    public java.lang.String getDstTag() {
      java.lang.Object ref = dstTag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dstTag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A destination visit or vehicle end matches iff its
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.end_tags][google.cloud.optimization.v1.Vehicle.end_tags] either contains `dst_tag` or does not contain
     * `excluded_dst_tag` (depending on which of these two fields is non-empty).
     * </pre>
     *
     * <code>string dst_tag = 3;</code>
     *
     * @return The bytes for dstTag.
     */
    public com.google.protobuf.ByteString getDstTagBytes() {
      java.lang.Object ref = dstTag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dstTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A destination visit or vehicle end matches iff its
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.end_tags][google.cloud.optimization.v1.Vehicle.end_tags] either contains `dst_tag` or does not contain
     * `excluded_dst_tag` (depending on which of these two fields is non-empty).
     * </pre>
     *
     * <code>string dst_tag = 3;</code>
     *
     * @param value The dstTag to set.
     * @return This builder for chaining.
     */
    public Builder setDstTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      dstTag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A destination visit or vehicle end matches iff its
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.end_tags][google.cloud.optimization.v1.Vehicle.end_tags] either contains `dst_tag` or does not contain
     * `excluded_dst_tag` (depending on which of these two fields is non-empty).
     * </pre>
     *
     * <code>string dst_tag = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDstTag() {

      dstTag_ = getDefaultInstance().getDstTag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A destination visit or vehicle end matches iff its
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.end_tags][google.cloud.optimization.v1.Vehicle.end_tags] either contains `dst_tag` or does not contain
     * `excluded_dst_tag` (depending on which of these two fields is non-empty).
     * </pre>
     *
     * <code>string dst_tag = 3;</code>
     *
     * @param value The bytes for dstTag to set.
     * @return This builder for chaining.
     */
    public Builder setDstTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      dstTag_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object excludedDstTag_ = "";
    /**
     *
     *
     * <pre>
     * See `dst_tag`. Exactly one of `dst_tag` and `excluded_dst_tag` must be
     * non-empty.
     * </pre>
     *
     * <code>string excluded_dst_tag = 4;</code>
     *
     * @return The excludedDstTag.
     */
    public java.lang.String getExcludedDstTag() {
      java.lang.Object ref = excludedDstTag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        excludedDstTag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * See `dst_tag`. Exactly one of `dst_tag` and `excluded_dst_tag` must be
     * non-empty.
     * </pre>
     *
     * <code>string excluded_dst_tag = 4;</code>
     *
     * @return The bytes for excludedDstTag.
     */
    public com.google.protobuf.ByteString getExcludedDstTagBytes() {
      java.lang.Object ref = excludedDstTag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        excludedDstTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * See `dst_tag`. Exactly one of `dst_tag` and `excluded_dst_tag` must be
     * non-empty.
     * </pre>
     *
     * <code>string excluded_dst_tag = 4;</code>
     *
     * @param value The excludedDstTag to set.
     * @return This builder for chaining.
     */
    public Builder setExcludedDstTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      excludedDstTag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * See `dst_tag`. Exactly one of `dst_tag` and `excluded_dst_tag` must be
     * non-empty.
     * </pre>
     *
     * <code>string excluded_dst_tag = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExcludedDstTag() {

      excludedDstTag_ = getDefaultInstance().getExcludedDstTag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * See `dst_tag`. Exactly one of `dst_tag` and `excluded_dst_tag` must be
     * non-empty.
     * </pre>
     *
     * <code>string excluded_dst_tag = 4;</code>
     *
     * @param value The bytes for excludedDstTag to set.
     * @return This builder for chaining.
     */
    public Builder setExcludedDstTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      excludedDstTag_ = value;
      onChanged();
      return this;
    }

    private double cost_;
    /**
     *
     *
     * <pre>
     * Specifies a cost for performing this transition. This is in the same unit
     * as all other costs in the model and must not be negative. It is applied on
     * top of all other existing costs.
     * </pre>
     *
     * <code>double cost = 5;</code>
     *
     * @return The cost.
     */
    @java.lang.Override
    public double getCost() {
      return cost_;
    }
    /**
     *
     *
     * <pre>
     * Specifies a cost for performing this transition. This is in the same unit
     * as all other costs in the model and must not be negative. It is applied on
     * top of all other existing costs.
     * </pre>
     *
     * <code>double cost = 5;</code>
     *
     * @param value The cost to set.
     * @return This builder for chaining.
     */
    public Builder setCost(double value) {

      cost_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a cost for performing this transition. This is in the same unit
     * as all other costs in the model and must not be negative. It is applied on
     * top of all other existing costs.
     * </pre>
     *
     * <code>double cost = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCost() {

      cost_ = 0D;
      onChanged();
      return this;
    }

    private double costPerKilometer_;
    /**
     *
     *
     * <pre>
     * Specifies a cost per kilometer applied to the distance traveled while
     * performing this transition. It adds up to any
     * [Vehicle.cost_per_kilometer][google.cloud.optimization.v1.Vehicle.cost_per_kilometer] specified on vehicles.
     * </pre>
     *
     * <code>double cost_per_kilometer = 6;</code>
     *
     * @return The costPerKilometer.
     */
    @java.lang.Override
    public double getCostPerKilometer() {
      return costPerKilometer_;
    }
    /**
     *
     *
     * <pre>
     * Specifies a cost per kilometer applied to the distance traveled while
     * performing this transition. It adds up to any
     * [Vehicle.cost_per_kilometer][google.cloud.optimization.v1.Vehicle.cost_per_kilometer] specified on vehicles.
     * </pre>
     *
     * <code>double cost_per_kilometer = 6;</code>
     *
     * @param value The costPerKilometer to set.
     * @return This builder for chaining.
     */
    public Builder setCostPerKilometer(double value) {

      costPerKilometer_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a cost per kilometer applied to the distance traveled while
     * performing this transition. It adds up to any
     * [Vehicle.cost_per_kilometer][google.cloud.optimization.v1.Vehicle.cost_per_kilometer] specified on vehicles.
     * </pre>
     *
     * <code>double cost_per_kilometer = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCostPerKilometer() {

      costPerKilometer_ = 0D;
      onChanged();
      return this;
    }

    private com.google.cloud.optimization.v1.DistanceLimit distanceLimit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.DistanceLimit,
            com.google.cloud.optimization.v1.DistanceLimit.Builder,
            com.google.cloud.optimization.v1.DistanceLimitOrBuilder>
        distanceLimitBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies a limit on the distance traveled while performing this
     * transition.
     * As of 2021/06, only soft limits are supported.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
     *
     * @return Whether the distanceLimit field is set.
     */
    public boolean hasDistanceLimit() {
      return distanceLimitBuilder_ != null || distanceLimit_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specifies a limit on the distance traveled while performing this
     * transition.
     * As of 2021/06, only soft limits are supported.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
     *
     * @return The distanceLimit.
     */
    public com.google.cloud.optimization.v1.DistanceLimit getDistanceLimit() {
      if (distanceLimitBuilder_ == null) {
        return distanceLimit_ == null
            ? com.google.cloud.optimization.v1.DistanceLimit.getDefaultInstance()
            : distanceLimit_;
      } else {
        return distanceLimitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a limit on the distance traveled while performing this
     * transition.
     * As of 2021/06, only soft limits are supported.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
     */
    public Builder setDistanceLimit(com.google.cloud.optimization.v1.DistanceLimit value) {
      if (distanceLimitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        distanceLimit_ = value;
        onChanged();
      } else {
        distanceLimitBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a limit on the distance traveled while performing this
     * transition.
     * As of 2021/06, only soft limits are supported.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
     */
    public Builder setDistanceLimit(
        com.google.cloud.optimization.v1.DistanceLimit.Builder builderForValue) {
      if (distanceLimitBuilder_ == null) {
        distanceLimit_ = builderForValue.build();
        onChanged();
      } else {
        distanceLimitBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a limit on the distance traveled while performing this
     * transition.
     * As of 2021/06, only soft limits are supported.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
     */
    public Builder mergeDistanceLimit(com.google.cloud.optimization.v1.DistanceLimit value) {
      if (distanceLimitBuilder_ == null) {
        if (distanceLimit_ != null) {
          distanceLimit_ =
              com.google.cloud.optimization.v1.DistanceLimit.newBuilder(distanceLimit_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          distanceLimit_ = value;
        }
        onChanged();
      } else {
        distanceLimitBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a limit on the distance traveled while performing this
     * transition.
     * As of 2021/06, only soft limits are supported.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
     */
    public Builder clearDistanceLimit() {
      if (distanceLimitBuilder_ == null) {
        distanceLimit_ = null;
        onChanged();
      } else {
        distanceLimit_ = null;
        distanceLimitBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a limit on the distance traveled while performing this
     * transition.
     * As of 2021/06, only soft limits are supported.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
     */
    public com.google.cloud.optimization.v1.DistanceLimit.Builder getDistanceLimitBuilder() {

      onChanged();
      return getDistanceLimitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies a limit on the distance traveled while performing this
     * transition.
     * As of 2021/06, only soft limits are supported.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
     */
    public com.google.cloud.optimization.v1.DistanceLimitOrBuilder getDistanceLimitOrBuilder() {
      if (distanceLimitBuilder_ != null) {
        return distanceLimitBuilder_.getMessageOrBuilder();
      } else {
        return distanceLimit_ == null
            ? com.google.cloud.optimization.v1.DistanceLimit.getDefaultInstance()
            : distanceLimit_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a limit on the distance traveled while performing this
     * transition.
     * As of 2021/06, only soft limits are supported.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.DistanceLimit distance_limit = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.DistanceLimit,
            com.google.cloud.optimization.v1.DistanceLimit.Builder,
            com.google.cloud.optimization.v1.DistanceLimitOrBuilder>
        getDistanceLimitFieldBuilder() {
      if (distanceLimitBuilder_ == null) {
        distanceLimitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.DistanceLimit,
                com.google.cloud.optimization.v1.DistanceLimit.Builder,
                com.google.cloud.optimization.v1.DistanceLimitOrBuilder>(
                getDistanceLimit(), getParentForChildren(), isClean());
        distanceLimit_ = null;
      }
      return distanceLimitBuilder_;
    }

    private com.google.protobuf.Duration delay_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        delayBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies a delay incurred when performing this transition.
     * This delay always occurs *after* finishing the source visit and *before*
     * starting the destination visit.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay = 8;</code>
     *
     * @return Whether the delay field is set.
     */
    public boolean hasDelay() {
      return delayBuilder_ != null || delay_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specifies a delay incurred when performing this transition.
     * This delay always occurs *after* finishing the source visit and *before*
     * starting the destination visit.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay = 8;</code>
     *
     * @return The delay.
     */
    public com.google.protobuf.Duration getDelay() {
      if (delayBuilder_ == null) {
        return delay_ == null ? com.google.protobuf.Duration.getDefaultInstance() : delay_;
      } else {
        return delayBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a delay incurred when performing this transition.
     * This delay always occurs *after* finishing the source visit and *before*
     * starting the destination visit.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay = 8;</code>
     */
    public Builder setDelay(com.google.protobuf.Duration value) {
      if (delayBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        delay_ = value;
        onChanged();
      } else {
        delayBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a delay incurred when performing this transition.
     * This delay always occurs *after* finishing the source visit and *before*
     * starting the destination visit.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay = 8;</code>
     */
    public Builder setDelay(com.google.protobuf.Duration.Builder builderForValue) {
      if (delayBuilder_ == null) {
        delay_ = builderForValue.build();
        onChanged();
      } else {
        delayBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a delay incurred when performing this transition.
     * This delay always occurs *after* finishing the source visit and *before*
     * starting the destination visit.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay = 8;</code>
     */
    public Builder mergeDelay(com.google.protobuf.Duration value) {
      if (delayBuilder_ == null) {
        if (delay_ != null) {
          delay_ = com.google.protobuf.Duration.newBuilder(delay_).mergeFrom(value).buildPartial();
        } else {
          delay_ = value;
        }
        onChanged();
      } else {
        delayBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a delay incurred when performing this transition.
     * This delay always occurs *after* finishing the source visit and *before*
     * starting the destination visit.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay = 8;</code>
     */
    public Builder clearDelay() {
      if (delayBuilder_ == null) {
        delay_ = null;
        onChanged();
      } else {
        delay_ = null;
        delayBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a delay incurred when performing this transition.
     * This delay always occurs *after* finishing the source visit and *before*
     * starting the destination visit.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay = 8;</code>
     */
    public com.google.protobuf.Duration.Builder getDelayBuilder() {

      onChanged();
      return getDelayFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies a delay incurred when performing this transition.
     * This delay always occurs *after* finishing the source visit and *before*
     * starting the destination visit.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay = 8;</code>
     */
    public com.google.protobuf.DurationOrBuilder getDelayOrBuilder() {
      if (delayBuilder_ != null) {
        return delayBuilder_.getMessageOrBuilder();
      } else {
        return delay_ == null ? com.google.protobuf.Duration.getDefaultInstance() : delay_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a delay incurred when performing this transition.
     * This delay always occurs *after* finishing the source visit and *before*
     * starting the destination visit.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDelayFieldBuilder() {
      if (delayBuilder_ == null) {
        delayBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDelay(), getParentForChildren(), isClean());
        delay_ = null;
      }
      return delayBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.TransitionAttributes)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.TransitionAttributes)
  private static final com.google.cloud.optimization.v1.TransitionAttributes DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.TransitionAttributes();
  }

  public static com.google.cloud.optimization.v1.TransitionAttributes getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransitionAttributes> PARSER =
      new com.google.protobuf.AbstractParser<TransitionAttributes>() {
        @java.lang.Override
        public TransitionAttributes parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransitionAttributes> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransitionAttributes> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.TransitionAttributes getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
