/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Time windows constrain the time of an event, such as the arrival time at a
 * visit, or the start and end time of a vehicle.
 * Hard time window bounds, `start_time` and `end_time`, enforce the earliest
 * and latest time of the event, such that `start_time &lt;= event_time &lt;=
 * end_time`. The soft time window lower bound, `soft_start_time`, expresses a
 * preference for the event to happen at or after `soft_start_time` by incurring
 * a cost proportional to how long before soft_start_time the event occurs. The
 * soft time window upper bound, `soft_end_time`, expresses a preference for the
 * event to happen at or before `soft_end_time` by incurring a cost proportional
 * to how long after `soft_end_time` the event occurs. `start_time`, `end_time`,
 * `soft_start_time` and `soft_end_time` should be within the global time limits
 * (see [ShipmentModel.global_start_time][google.cloud.optimization.v1.ShipmentModel.global_start_time] and
 * [ShipmentModel.global_end_time][google.cloud.optimization.v1.ShipmentModel.global_end_time]) and should respect:
 * ```
 *   0 &lt;= `start_time` &lt;= `soft_start_time` &lt;= `end_time` and
 *   0 &lt;= `start_time` &lt;= `soft_end_time` &lt;= `end_time`.
 * ```
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.TimeWindow}
 */
public final class TimeWindow extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.TimeWindow)
    TimeWindowOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimeWindow.newBuilder() to construct.
  private TimeWindow(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimeWindow() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimeWindow();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_TimeWindow_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_TimeWindow_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.TimeWindow.class,
            com.google.cloud.optimization.v1.TimeWindow.Builder.class);
  }

  private int bitField0_;
  public static final int START_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The hard time window start time. If unspecified it will be set to
   * `ShipmentModel.global_start_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The hard time window start time. If unspecified it will be set to
   * `ShipmentModel.global_start_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The hard time window start time. If unspecified it will be set to
   * `ShipmentModel.global_start_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The hard time window end time. If unspecified it will be set to
   * `ShipmentModel.global_end_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The hard time window end time. If unspecified it will be set to
   * `ShipmentModel.global_end_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The hard time window end time. If unspecified it will be set to
   * `ShipmentModel.global_end_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int SOFT_START_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp softStartTime_;
  /**
   *
   *
   * <pre>
   * The soft start time of the time window.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
   *
   * @return Whether the softStartTime field is set.
   */
  @java.lang.Override
  public boolean hasSoftStartTime() {
    return softStartTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The soft start time of the time window.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
   *
   * @return The softStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSoftStartTime() {
    return softStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : softStartTime_;
  }
  /**
   *
   *
   * <pre>
   * The soft start time of the time window.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSoftStartTimeOrBuilder() {
    return getSoftStartTime();
  }

  public static final int SOFT_END_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp softEndTime_;
  /**
   *
   *
   * <pre>
   * The soft end time of the time window.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
   *
   * @return Whether the softEndTime field is set.
   */
  @java.lang.Override
  public boolean hasSoftEndTime() {
    return softEndTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The soft end time of the time window.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
   *
   * @return The softEndTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSoftEndTime() {
    return softEndTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : softEndTime_;
  }
  /**
   *
   *
   * <pre>
   * The soft end time of the time window.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSoftEndTimeOrBuilder() {
    return getSoftEndTime();
  }

  public static final int COST_PER_HOUR_BEFORE_SOFT_START_TIME_FIELD_NUMBER = 5;
  private double costPerHourBeforeSoftStartTime_;
  /**
   *
   *
   * <pre>
   * A cost per hour added to other costs in the model if the event occurs
   * before soft_start_time, computed as:
   * ```
   *    max(0, soft_start_time - t.seconds)
   *                           * cost_per_hour_before_soft_start_time / 3600,
   * t being the time of the event.
   * ```
   * This cost must be positive, and the field can only be set if
   * soft_start_time has been set.
   * </pre>
   *
   * <code>optional double cost_per_hour_before_soft_start_time = 5;</code>
   *
   * @return Whether the costPerHourBeforeSoftStartTime field is set.
   */
  @java.lang.Override
  public boolean hasCostPerHourBeforeSoftStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * A cost per hour added to other costs in the model if the event occurs
   * before soft_start_time, computed as:
   * ```
   *    max(0, soft_start_time - t.seconds)
   *                           * cost_per_hour_before_soft_start_time / 3600,
   * t being the time of the event.
   * ```
   * This cost must be positive, and the field can only be set if
   * soft_start_time has been set.
   * </pre>
   *
   * <code>optional double cost_per_hour_before_soft_start_time = 5;</code>
   *
   * @return The costPerHourBeforeSoftStartTime.
   */
  @java.lang.Override
  public double getCostPerHourBeforeSoftStartTime() {
    return costPerHourBeforeSoftStartTime_;
  }

  public static final int COST_PER_HOUR_AFTER_SOFT_END_TIME_FIELD_NUMBER = 6;
  private double costPerHourAfterSoftEndTime_;
  /**
   *
   *
   * <pre>
   * A cost per hour added to other costs in the model if the event occurs after
   * `soft_end_time`, computed as:
   * ```
   *    max(0, t.seconds - soft_end_time.seconds)
   *                     * cost_per_hour_after_soft_end_time / 3600,
   * t being the time of the event.
   * ```
   * This cost must be positive, and the field can only be set if
   * `soft_end_time` has been set.
   * </pre>
   *
   * <code>optional double cost_per_hour_after_soft_end_time = 6;</code>
   *
   * @return Whether the costPerHourAfterSoftEndTime field is set.
   */
  @java.lang.Override
  public boolean hasCostPerHourAfterSoftEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * A cost per hour added to other costs in the model if the event occurs after
   * `soft_end_time`, computed as:
   * ```
   *    max(0, t.seconds - soft_end_time.seconds)
   *                     * cost_per_hour_after_soft_end_time / 3600,
   * t being the time of the event.
   * ```
   * This cost must be positive, and the field can only be set if
   * `soft_end_time` has been set.
   * </pre>
   *
   * <code>optional double cost_per_hour_after_soft_end_time = 6;</code>
   *
   * @return The costPerHourAfterSoftEndTime.
   */
  @java.lang.Override
  public double getCostPerHourAfterSoftEndTime() {
    return costPerHourAfterSoftEndTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (startTime_ != null) {
      output.writeMessage(1, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(2, getEndTime());
    }
    if (softStartTime_ != null) {
      output.writeMessage(3, getSoftStartTime());
    }
    if (softEndTime_ != null) {
      output.writeMessage(4, getSoftEndTime());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeDouble(5, costPerHourBeforeSoftStartTime_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeDouble(6, costPerHourAfterSoftEndTime_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (softStartTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSoftStartTime());
    }
    if (softEndTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSoftEndTime());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              5, costPerHourBeforeSoftStartTime_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(6, costPerHourAfterSoftEndTime_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.TimeWindow)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.TimeWindow other =
        (com.google.cloud.optimization.v1.TimeWindow) obj;

    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasSoftStartTime() != other.hasSoftStartTime()) return false;
    if (hasSoftStartTime()) {
      if (!getSoftStartTime().equals(other.getSoftStartTime())) return false;
    }
    if (hasSoftEndTime() != other.hasSoftEndTime()) return false;
    if (hasSoftEndTime()) {
      if (!getSoftEndTime().equals(other.getSoftEndTime())) return false;
    }
    if (hasCostPerHourBeforeSoftStartTime() != other.hasCostPerHourBeforeSoftStartTime())
      return false;
    if (hasCostPerHourBeforeSoftStartTime()) {
      if (java.lang.Double.doubleToLongBits(getCostPerHourBeforeSoftStartTime())
          != java.lang.Double.doubleToLongBits(other.getCostPerHourBeforeSoftStartTime()))
        return false;
    }
    if (hasCostPerHourAfterSoftEndTime() != other.hasCostPerHourAfterSoftEndTime()) return false;
    if (hasCostPerHourAfterSoftEndTime()) {
      if (java.lang.Double.doubleToLongBits(getCostPerHourAfterSoftEndTime())
          != java.lang.Double.doubleToLongBits(other.getCostPerHourAfterSoftEndTime()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasSoftStartTime()) {
      hash = (37 * hash) + SOFT_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSoftStartTime().hashCode();
    }
    if (hasSoftEndTime()) {
      hash = (37 * hash) + SOFT_END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSoftEndTime().hashCode();
    }
    if (hasCostPerHourBeforeSoftStartTime()) {
      hash = (37 * hash) + COST_PER_HOUR_BEFORE_SOFT_START_TIME_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getCostPerHourBeforeSoftStartTime()));
    }
    if (hasCostPerHourAfterSoftEndTime()) {
      hash = (37 * hash) + COST_PER_HOUR_AFTER_SOFT_END_TIME_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getCostPerHourAfterSoftEndTime()));
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.TimeWindow parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.optimization.v1.TimeWindow prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Time windows constrain the time of an event, such as the arrival time at a
   * visit, or the start and end time of a vehicle.
   * Hard time window bounds, `start_time` and `end_time`, enforce the earliest
   * and latest time of the event, such that `start_time &lt;= event_time &lt;=
   * end_time`. The soft time window lower bound, `soft_start_time`, expresses a
   * preference for the event to happen at or after `soft_start_time` by incurring
   * a cost proportional to how long before soft_start_time the event occurs. The
   * soft time window upper bound, `soft_end_time`, expresses a preference for the
   * event to happen at or before `soft_end_time` by incurring a cost proportional
   * to how long after `soft_end_time` the event occurs. `start_time`, `end_time`,
   * `soft_start_time` and `soft_end_time` should be within the global time limits
   * (see [ShipmentModel.global_start_time][google.cloud.optimization.v1.ShipmentModel.global_start_time] and
   * [ShipmentModel.global_end_time][google.cloud.optimization.v1.ShipmentModel.global_end_time]) and should respect:
   * ```
   *   0 &lt;= `start_time` &lt;= `soft_start_time` &lt;= `end_time` and
   *   0 &lt;= `start_time` &lt;= `soft_end_time` &lt;= `end_time`.
   * ```
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.TimeWindow}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.TimeWindow)
      com.google.cloud.optimization.v1.TimeWindowOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_TimeWindow_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_TimeWindow_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.TimeWindow.class,
              com.google.cloud.optimization.v1.TimeWindow.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.TimeWindow.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      if (softStartTimeBuilder_ == null) {
        softStartTime_ = null;
      } else {
        softStartTime_ = null;
        softStartTimeBuilder_ = null;
      }
      if (softEndTimeBuilder_ == null) {
        softEndTime_ = null;
      } else {
        softEndTime_ = null;
        softEndTimeBuilder_ = null;
      }
      costPerHourBeforeSoftStartTime_ = 0D;
      bitField0_ = (bitField0_ & ~0x00000001);
      costPerHourAfterSoftEndTime_ = 0D;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_TimeWindow_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.TimeWindow getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.TimeWindow.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.TimeWindow build() {
      com.google.cloud.optimization.v1.TimeWindow result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.TimeWindow buildPartial() {
      com.google.cloud.optimization.v1.TimeWindow result =
          new com.google.cloud.optimization.v1.TimeWindow(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      if (softStartTimeBuilder_ == null) {
        result.softStartTime_ = softStartTime_;
      } else {
        result.softStartTime_ = softStartTimeBuilder_.build();
      }
      if (softEndTimeBuilder_ == null) {
        result.softEndTime_ = softEndTime_;
      } else {
        result.softEndTime_ = softEndTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.costPerHourBeforeSoftStartTime_ = costPerHourBeforeSoftStartTime_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.costPerHourAfterSoftEndTime_ = costPerHourAfterSoftEndTime_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.TimeWindow) {
        return mergeFrom((com.google.cloud.optimization.v1.TimeWindow) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.TimeWindow other) {
      if (other == com.google.cloud.optimization.v1.TimeWindow.getDefaultInstance()) return this;
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasSoftStartTime()) {
        mergeSoftStartTime(other.getSoftStartTime());
      }
      if (other.hasSoftEndTime()) {
        mergeSoftEndTime(other.getSoftEndTime());
      }
      if (other.hasCostPerHourBeforeSoftStartTime()) {
        setCostPerHourBeforeSoftStartTime(other.getCostPerHourBeforeSoftStartTime());
      }
      if (other.hasCostPerHourAfterSoftEndTime()) {
        setCostPerHourAfterSoftEndTime(other.getCostPerHourAfterSoftEndTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getSoftStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getSoftEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 41:
              {
                costPerHourBeforeSoftStartTime_ = input.readDouble();
                bitField0_ |= 0x00000001;
                break;
              } // case 41
            case 49:
              {
                costPerHourAfterSoftEndTime_ = input.readDouble();
                bitField0_ |= 0x00000002;
                break;
              } // case 49
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The hard time window start time. If unspecified it will be set to
     * `ShipmentModel.global_start_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The hard time window start time. If unspecified it will be set to
     * `ShipmentModel.global_start_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The hard time window start time. If unspecified it will be set to
     * `ShipmentModel.global_start_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The hard time window start time. If unspecified it will be set to
     * `ShipmentModel.global_start_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The hard time window start time. If unspecified it will be set to
     * `ShipmentModel.global_start_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The hard time window start time. If unspecified it will be set to
     * `ShipmentModel.global_start_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The hard time window start time. If unspecified it will be set to
     * `ShipmentModel.global_start_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The hard time window start time. If unspecified it will be set to
     * `ShipmentModel.global_start_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The hard time window start time. If unspecified it will be set to
     * `ShipmentModel.global_start_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The hard time window end time. If unspecified it will be set to
     * `ShipmentModel.global_end_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The hard time window end time. If unspecified it will be set to
     * `ShipmentModel.global_end_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The hard time window end time. If unspecified it will be set to
     * `ShipmentModel.global_end_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The hard time window end time. If unspecified it will be set to
     * `ShipmentModel.global_end_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The hard time window end time. If unspecified it will be set to
     * `ShipmentModel.global_end_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The hard time window end time. If unspecified it will be set to
     * `ShipmentModel.global_end_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The hard time window end time. If unspecified it will be set to
     * `ShipmentModel.global_end_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The hard time window end time. If unspecified it will be set to
     * `ShipmentModel.global_end_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The hard time window end time. If unspecified it will be set to
     * `ShipmentModel.global_end_time`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Timestamp softStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        softStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The soft start time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
     *
     * @return Whether the softStartTime field is set.
     */
    public boolean hasSoftStartTime() {
      return softStartTimeBuilder_ != null || softStartTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The soft start time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
     *
     * @return The softStartTime.
     */
    public com.google.protobuf.Timestamp getSoftStartTime() {
      if (softStartTimeBuilder_ == null) {
        return softStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : softStartTime_;
      } else {
        return softStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The soft start time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
     */
    public Builder setSoftStartTime(com.google.protobuf.Timestamp value) {
      if (softStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        softStartTime_ = value;
        onChanged();
      } else {
        softStartTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The soft start time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
     */
    public Builder setSoftStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (softStartTimeBuilder_ == null) {
        softStartTime_ = builderForValue.build();
        onChanged();
      } else {
        softStartTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The soft start time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
     */
    public Builder mergeSoftStartTime(com.google.protobuf.Timestamp value) {
      if (softStartTimeBuilder_ == null) {
        if (softStartTime_ != null) {
          softStartTime_ =
              com.google.protobuf.Timestamp.newBuilder(softStartTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          softStartTime_ = value;
        }
        onChanged();
      } else {
        softStartTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The soft start time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
     */
    public Builder clearSoftStartTime() {
      if (softStartTimeBuilder_ == null) {
        softStartTime_ = null;
        onChanged();
      } else {
        softStartTime_ = null;
        softStartTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The soft start time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getSoftStartTimeBuilder() {

      onChanged();
      return getSoftStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The soft start time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getSoftStartTimeOrBuilder() {
      if (softStartTimeBuilder_ != null) {
        return softStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return softStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : softStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The soft start time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_start_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSoftStartTimeFieldBuilder() {
      if (softStartTimeBuilder_ == null) {
        softStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSoftStartTime(), getParentForChildren(), isClean());
        softStartTime_ = null;
      }
      return softStartTimeBuilder_;
    }

    private com.google.protobuf.Timestamp softEndTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        softEndTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The soft end time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
     *
     * @return Whether the softEndTime field is set.
     */
    public boolean hasSoftEndTime() {
      return softEndTimeBuilder_ != null || softEndTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The soft end time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
     *
     * @return The softEndTime.
     */
    public com.google.protobuf.Timestamp getSoftEndTime() {
      if (softEndTimeBuilder_ == null) {
        return softEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : softEndTime_;
      } else {
        return softEndTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The soft end time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
     */
    public Builder setSoftEndTime(com.google.protobuf.Timestamp value) {
      if (softEndTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        softEndTime_ = value;
        onChanged();
      } else {
        softEndTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The soft end time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
     */
    public Builder setSoftEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (softEndTimeBuilder_ == null) {
        softEndTime_ = builderForValue.build();
        onChanged();
      } else {
        softEndTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The soft end time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
     */
    public Builder mergeSoftEndTime(com.google.protobuf.Timestamp value) {
      if (softEndTimeBuilder_ == null) {
        if (softEndTime_ != null) {
          softEndTime_ =
              com.google.protobuf.Timestamp.newBuilder(softEndTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          softEndTime_ = value;
        }
        onChanged();
      } else {
        softEndTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The soft end time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
     */
    public Builder clearSoftEndTime() {
      if (softEndTimeBuilder_ == null) {
        softEndTime_ = null;
        onChanged();
      } else {
        softEndTime_ = null;
        softEndTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The soft end time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getSoftEndTimeBuilder() {

      onChanged();
      return getSoftEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The soft end time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getSoftEndTimeOrBuilder() {
      if (softEndTimeBuilder_ != null) {
        return softEndTimeBuilder_.getMessageOrBuilder();
      } else {
        return softEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : softEndTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The soft end time of the time window.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp soft_end_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSoftEndTimeFieldBuilder() {
      if (softEndTimeBuilder_ == null) {
        softEndTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSoftEndTime(), getParentForChildren(), isClean());
        softEndTime_ = null;
      }
      return softEndTimeBuilder_;
    }

    private double costPerHourBeforeSoftStartTime_;
    /**
     *
     *
     * <pre>
     * A cost per hour added to other costs in the model if the event occurs
     * before soft_start_time, computed as:
     * ```
     *    max(0, soft_start_time - t.seconds)
     *                           * cost_per_hour_before_soft_start_time / 3600,
     * t being the time of the event.
     * ```
     * This cost must be positive, and the field can only be set if
     * soft_start_time has been set.
     * </pre>
     *
     * <code>optional double cost_per_hour_before_soft_start_time = 5;</code>
     *
     * @return Whether the costPerHourBeforeSoftStartTime field is set.
     */
    @java.lang.Override
    public boolean hasCostPerHourBeforeSoftStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * A cost per hour added to other costs in the model if the event occurs
     * before soft_start_time, computed as:
     * ```
     *    max(0, soft_start_time - t.seconds)
     *                           * cost_per_hour_before_soft_start_time / 3600,
     * t being the time of the event.
     * ```
     * This cost must be positive, and the field can only be set if
     * soft_start_time has been set.
     * </pre>
     *
     * <code>optional double cost_per_hour_before_soft_start_time = 5;</code>
     *
     * @return The costPerHourBeforeSoftStartTime.
     */
    @java.lang.Override
    public double getCostPerHourBeforeSoftStartTime() {
      return costPerHourBeforeSoftStartTime_;
    }
    /**
     *
     *
     * <pre>
     * A cost per hour added to other costs in the model if the event occurs
     * before soft_start_time, computed as:
     * ```
     *    max(0, soft_start_time - t.seconds)
     *                           * cost_per_hour_before_soft_start_time / 3600,
     * t being the time of the event.
     * ```
     * This cost must be positive, and the field can only be set if
     * soft_start_time has been set.
     * </pre>
     *
     * <code>optional double cost_per_hour_before_soft_start_time = 5;</code>
     *
     * @param value The costPerHourBeforeSoftStartTime to set.
     * @return This builder for chaining.
     */
    public Builder setCostPerHourBeforeSoftStartTime(double value) {
      bitField0_ |= 0x00000001;
      costPerHourBeforeSoftStartTime_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cost per hour added to other costs in the model if the event occurs
     * before soft_start_time, computed as:
     * ```
     *    max(0, soft_start_time - t.seconds)
     *                           * cost_per_hour_before_soft_start_time / 3600,
     * t being the time of the event.
     * ```
     * This cost must be positive, and the field can only be set if
     * soft_start_time has been set.
     * </pre>
     *
     * <code>optional double cost_per_hour_before_soft_start_time = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCostPerHourBeforeSoftStartTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      costPerHourBeforeSoftStartTime_ = 0D;
      onChanged();
      return this;
    }

    private double costPerHourAfterSoftEndTime_;
    /**
     *
     *
     * <pre>
     * A cost per hour added to other costs in the model if the event occurs after
     * `soft_end_time`, computed as:
     * ```
     *    max(0, t.seconds - soft_end_time.seconds)
     *                     * cost_per_hour_after_soft_end_time / 3600,
     * t being the time of the event.
     * ```
     * This cost must be positive, and the field can only be set if
     * `soft_end_time` has been set.
     * </pre>
     *
     * <code>optional double cost_per_hour_after_soft_end_time = 6;</code>
     *
     * @return Whether the costPerHourAfterSoftEndTime field is set.
     */
    @java.lang.Override
    public boolean hasCostPerHourAfterSoftEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * A cost per hour added to other costs in the model if the event occurs after
     * `soft_end_time`, computed as:
     * ```
     *    max(0, t.seconds - soft_end_time.seconds)
     *                     * cost_per_hour_after_soft_end_time / 3600,
     * t being the time of the event.
     * ```
     * This cost must be positive, and the field can only be set if
     * `soft_end_time` has been set.
     * </pre>
     *
     * <code>optional double cost_per_hour_after_soft_end_time = 6;</code>
     *
     * @return The costPerHourAfterSoftEndTime.
     */
    @java.lang.Override
    public double getCostPerHourAfterSoftEndTime() {
      return costPerHourAfterSoftEndTime_;
    }
    /**
     *
     *
     * <pre>
     * A cost per hour added to other costs in the model if the event occurs after
     * `soft_end_time`, computed as:
     * ```
     *    max(0, t.seconds - soft_end_time.seconds)
     *                     * cost_per_hour_after_soft_end_time / 3600,
     * t being the time of the event.
     * ```
     * This cost must be positive, and the field can only be set if
     * `soft_end_time` has been set.
     * </pre>
     *
     * <code>optional double cost_per_hour_after_soft_end_time = 6;</code>
     *
     * @param value The costPerHourAfterSoftEndTime to set.
     * @return This builder for chaining.
     */
    public Builder setCostPerHourAfterSoftEndTime(double value) {
      bitField0_ |= 0x00000002;
      costPerHourAfterSoftEndTime_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cost per hour added to other costs in the model if the event occurs after
     * `soft_end_time`, computed as:
     * ```
     *    max(0, t.seconds - soft_end_time.seconds)
     *                     * cost_per_hour_after_soft_end_time / 3600,
     * t being the time of the event.
     * ```
     * This cost must be positive, and the field can only be set if
     * `soft_end_time` has been set.
     * </pre>
     *
     * <code>optional double cost_per_hour_after_soft_end_time = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCostPerHourAfterSoftEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      costPerHourAfterSoftEndTime_ = 0D;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.TimeWindow)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.TimeWindow)
  private static final com.google.cloud.optimization.v1.TimeWindow DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.TimeWindow();
  }

  public static com.google.cloud.optimization.v1.TimeWindow getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimeWindow> PARSER =
      new com.google.protobuf.AbstractParser<TimeWindow>() {
        @java.lang.Override
        public TimeWindow parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TimeWindow> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimeWindow> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.TimeWindow getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
