/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Specifies details of unperformed shipments in a solution. For trivial cases
 * and/or if we are able to identify the cause for skipping, we report the
 * reason here.
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.SkippedShipment}
 */
public final class SkippedShipment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.SkippedShipment)
    SkippedShipmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SkippedShipment.newBuilder() to construct.
  private SkippedShipment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SkippedShipment() {
    label_ = "";
    reasons_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SkippedShipment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_SkippedShipment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_SkippedShipment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.SkippedShipment.class,
            com.google.cloud.optimization.v1.SkippedShipment.Builder.class);
  }

  public interface ReasonOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.SkippedShipment.Reason)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Refer to the comments of Code.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.SkippedShipment.Reason.Code code = 1;</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    int getCodeValue();
    /**
     *
     *
     * <pre>
     * Refer to the comments of Code.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.SkippedShipment.Reason.Code code = 1;</code>
     *
     * @return The code.
     */
    com.google.cloud.optimization.v1.SkippedShipment.Reason.Code getCode();

    /**
     *
     *
     * <pre>
     * If the reason is related to a shipment-vehicle incompatibility, this
     * field provides the index of one relevant vehicle.
     * </pre>
     *
     * <code>optional int32 example_vehicle_index = 2;</code>
     *
     * @return Whether the exampleVehicleIndex field is set.
     */
    boolean hasExampleVehicleIndex();
    /**
     *
     *
     * <pre>
     * If the reason is related to a shipment-vehicle incompatibility, this
     * field provides the index of one relevant vehicle.
     * </pre>
     *
     * <code>optional int32 example_vehicle_index = 2;</code>
     *
     * @return The exampleVehicleIndex.
     */
    int getExampleVehicleIndex();

    /**
     *
     *
     * <pre>
     * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
     * capacity type that is exceeded.
     * </pre>
     *
     * <code>string example_exceeded_capacity_type = 3;</code>
     *
     * @return The exampleExceededCapacityType.
     */
    java.lang.String getExampleExceededCapacityType();
    /**
     *
     *
     * <pre>
     * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
     * capacity type that is exceeded.
     * </pre>
     *
     * <code>string example_exceeded_capacity_type = 3;</code>
     *
     * @return The bytes for exampleExceededCapacityType.
     */
    com.google.protobuf.ByteString getExampleExceededCapacityTypeBytes();
  }
  /**
   *
   *
   * <pre>
   * If we can explain why the shipment was skipped, reasons will be listed
   * here. If the reason is not the same for all vehicles, `reason` will have
   * more than 1 element. A skipped shipment cannot have duplicate reasons,
   * i.e. where all fields are the same except for `example_vehicle_index`.
   * Example:
   * ```
   * reasons {
   *   code: DEMAND_EXCEEDS_VEHICLE_CAPACITY
   *   example_vehicle_index: 1
   *   example_exceeded_capacity_type: "Apples"
   * }
   * reasons {
   *   code: DEMAND_EXCEEDS_VEHICLE_CAPACITY
   *   example_vehicle_index: 3
   *   example_exceeded_capacity_type: "Pears"
   * }
   * reasons {
   *   code: CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT
   *   example_vehicle_index: 1
   * }
   * ```
   * The skipped shipment is incompatible with all vehicles. The reasons may
   * be different for all vehicles but at least one vehicle's "Apples"
   * capacity would be exceeded (including vehicle 1), at least one vehicle's
   * "Pears" capacity would be exceeded (including vehicle 3) and at least one
   * vehicle's distance limit would be exceeded (including vehicle 1).
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.SkippedShipment.Reason}
   */
  public static final class Reason extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.SkippedShipment.Reason)
      ReasonOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Reason.newBuilder() to construct.
    private Reason(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Reason() {
      code_ = 0;
      exampleExceededCapacityType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Reason();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_SkippedShipment_Reason_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_SkippedShipment_Reason_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.SkippedShipment.Reason.class,
              com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Code identifying the reason type. The order here is meaningless. In
     * particular, it gives no indication of whether a given reason will
     * appear before another in the solution, if both apply.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.optimization.v1.SkippedShipment.Reason.Code}
     */
    public enum Code implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * This should never be used. If we are unable to understand why a
       * shipment was skipped, we simply return an empty set of reasons.
       * </pre>
       *
       * <code>CODE_UNSPECIFIED = 0;</code>
       */
      CODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * There is no vehicle in the model making all shipments infeasible.
       * </pre>
       *
       * <code>NO_VEHICLE = 1;</code>
       */
      NO_VEHICLE(1),
      /**
       *
       *
       * <pre>
       * The demand of the shipment exceeds a vehicle's capacity for some
       * capacity types, one of which is `example_exceeded_capacity_type`.
       * </pre>
       *
       * <code>DEMAND_EXCEEDS_VEHICLE_CAPACITY = 2;</code>
       */
      DEMAND_EXCEEDS_VEHICLE_CAPACITY(2),
      /**
       *
       *
       * <pre>
       * The minimum distance necessary to perform this shipment, i.e. from
       * the vehicle's `start_location` to the shipment's pickup and/or delivery
       * locations and to the vehicle's end location exceeds the vehicle's
       * `route_distance_limit`.
       * Note that for this computation we use the geodesic distances.
       * </pre>
       *
       * <code>CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT = 3;</code>
       */
      CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT(3),
      /**
       *
       *
       * <pre>
       * The minimum time necessary to perform this shipment, including travel
       * time, wait time and service time exceeds the vehicle's
       * `route_duration_limit`.
       * Note: travel time is computed in the best-case scenario, namely as
       * geodesic distance x 36 m/s (roughly 130 km/hour).
       * </pre>
       *
       * <code>CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT = 4;</code>
       */
      CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT(4),
      /**
       *
       *
       * <pre>
       * Same as above but we only compare minimum travel time and the
       * vehicle's `travel_duration_limit`.
       * </pre>
       *
       * <code>CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TRAVEL_DURATION_LIMIT = 5;</code>
       */
      CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TRAVEL_DURATION_LIMIT(5),
      /**
       *
       *
       * <pre>
       * The vehicle cannot perform this shipment in the best-case scenario
       * (see `CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT` for time
       * computation) if it starts at its earliest start time: the total time
       * would make the vehicle end after its latest end time.
       * </pre>
       *
       * <code>CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TIME_WINDOWS = 6;</code>
       */
      CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TIME_WINDOWS(6),
      /**
       *
       *
       * <pre>
       * The `allowed_vehicle_indices` field of the shipment is not empty and
       * this vehicle does not belong to it.
       * </pre>
       *
       * <code>VEHICLE_NOT_ALLOWED = 7;</code>
       */
      VEHICLE_NOT_ALLOWED(7),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * This should never be used. If we are unable to understand why a
       * shipment was skipped, we simply return an empty set of reasons.
       * </pre>
       *
       * <code>CODE_UNSPECIFIED = 0;</code>
       */
      public static final int CODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * There is no vehicle in the model making all shipments infeasible.
       * </pre>
       *
       * <code>NO_VEHICLE = 1;</code>
       */
      public static final int NO_VEHICLE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The demand of the shipment exceeds a vehicle's capacity for some
       * capacity types, one of which is `example_exceeded_capacity_type`.
       * </pre>
       *
       * <code>DEMAND_EXCEEDS_VEHICLE_CAPACITY = 2;</code>
       */
      public static final int DEMAND_EXCEEDS_VEHICLE_CAPACITY_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The minimum distance necessary to perform this shipment, i.e. from
       * the vehicle's `start_location` to the shipment's pickup and/or delivery
       * locations and to the vehicle's end location exceeds the vehicle's
       * `route_distance_limit`.
       * Note that for this computation we use the geodesic distances.
       * </pre>
       *
       * <code>CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT = 3;</code>
       */
      public static final int CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The minimum time necessary to perform this shipment, including travel
       * time, wait time and service time exceeds the vehicle's
       * `route_duration_limit`.
       * Note: travel time is computed in the best-case scenario, namely as
       * geodesic distance x 36 m/s (roughly 130 km/hour).
       * </pre>
       *
       * <code>CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT = 4;</code>
       */
      public static final int CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT_VALUE = 4;
      /**
       *
       *
       * <pre>
       * Same as above but we only compare minimum travel time and the
       * vehicle's `travel_duration_limit`.
       * </pre>
       *
       * <code>CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TRAVEL_DURATION_LIMIT = 5;</code>
       */
      public static final int CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TRAVEL_DURATION_LIMIT_VALUE = 5;
      /**
       *
       *
       * <pre>
       * The vehicle cannot perform this shipment in the best-case scenario
       * (see `CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT` for time
       * computation) if it starts at its earliest start time: the total time
       * would make the vehicle end after its latest end time.
       * </pre>
       *
       * <code>CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TIME_WINDOWS = 6;</code>
       */
      public static final int CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TIME_WINDOWS_VALUE = 6;
      /**
       *
       *
       * <pre>
       * The `allowed_vehicle_indices` field of the shipment is not empty and
       * this vehicle does not belong to it.
       * </pre>
       *
       * <code>VEHICLE_NOT_ALLOWED = 7;</code>
       */
      public static final int VEHICLE_NOT_ALLOWED_VALUE = 7;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Code valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Code forNumber(int value) {
        switch (value) {
          case 0:
            return CODE_UNSPECIFIED;
          case 1:
            return NO_VEHICLE;
          case 2:
            return DEMAND_EXCEEDS_VEHICLE_CAPACITY;
          case 3:
            return CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT;
          case 4:
            return CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT;
          case 5:
            return CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TRAVEL_DURATION_LIMIT;
          case 6:
            return CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TIME_WINDOWS;
          case 7:
            return VEHICLE_NOT_ALLOWED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Code> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Code> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Code>() {
            public Code findValueByNumber(int number) {
              return Code.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.optimization.v1.SkippedShipment.Reason.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Code[] VALUES = values();

      public static Code valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Code(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.optimization.v1.SkippedShipment.Reason.Code)
    }

    private int bitField0_;
    public static final int CODE_FIELD_NUMBER = 1;
    private int code_;
    /**
     *
     *
     * <pre>
     * Refer to the comments of Code.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.SkippedShipment.Reason.Code code = 1;</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    @java.lang.Override
    public int getCodeValue() {
      return code_;
    }
    /**
     *
     *
     * <pre>
     * Refer to the comments of Code.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.SkippedShipment.Reason.Code code = 1;</code>
     *
     * @return The code.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.SkippedShipment.Reason.Code getCode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.optimization.v1.SkippedShipment.Reason.Code result =
          com.google.cloud.optimization.v1.SkippedShipment.Reason.Code.valueOf(code_);
      return result == null
          ? com.google.cloud.optimization.v1.SkippedShipment.Reason.Code.UNRECOGNIZED
          : result;
    }

    public static final int EXAMPLE_VEHICLE_INDEX_FIELD_NUMBER = 2;
    private int exampleVehicleIndex_;
    /**
     *
     *
     * <pre>
     * If the reason is related to a shipment-vehicle incompatibility, this
     * field provides the index of one relevant vehicle.
     * </pre>
     *
     * <code>optional int32 example_vehicle_index = 2;</code>
     *
     * @return Whether the exampleVehicleIndex field is set.
     */
    @java.lang.Override
    public boolean hasExampleVehicleIndex() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * If the reason is related to a shipment-vehicle incompatibility, this
     * field provides the index of one relevant vehicle.
     * </pre>
     *
     * <code>optional int32 example_vehicle_index = 2;</code>
     *
     * @return The exampleVehicleIndex.
     */
    @java.lang.Override
    public int getExampleVehicleIndex() {
      return exampleVehicleIndex_;
    }

    public static final int EXAMPLE_EXCEEDED_CAPACITY_TYPE_FIELD_NUMBER = 3;
    private volatile java.lang.Object exampleExceededCapacityType_;
    /**
     *
     *
     * <pre>
     * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
     * capacity type that is exceeded.
     * </pre>
     *
     * <code>string example_exceeded_capacity_type = 3;</code>
     *
     * @return The exampleExceededCapacityType.
     */
    @java.lang.Override
    public java.lang.String getExampleExceededCapacityType() {
      java.lang.Object ref = exampleExceededCapacityType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        exampleExceededCapacityType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
     * capacity type that is exceeded.
     * </pre>
     *
     * <code>string example_exceeded_capacity_type = 3;</code>
     *
     * @return The bytes for exampleExceededCapacityType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getExampleExceededCapacityTypeBytes() {
      java.lang.Object ref = exampleExceededCapacityType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        exampleExceededCapacityType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (code_
          != com.google.cloud.optimization.v1.SkippedShipment.Reason.Code.CODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, code_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt32(2, exampleVehicleIndex_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exampleExceededCapacityType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, exampleExceededCapacityType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (code_
          != com.google.cloud.optimization.v1.SkippedShipment.Reason.Code.CODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, code_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, exampleVehicleIndex_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exampleExceededCapacityType_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(
                3, exampleExceededCapacityType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.SkippedShipment.Reason)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.SkippedShipment.Reason other =
          (com.google.cloud.optimization.v1.SkippedShipment.Reason) obj;

      if (code_ != other.code_) return false;
      if (hasExampleVehicleIndex() != other.hasExampleVehicleIndex()) return false;
      if (hasExampleVehicleIndex()) {
        if (getExampleVehicleIndex() != other.getExampleVehicleIndex()) return false;
      }
      if (!getExampleExceededCapacityType().equals(other.getExampleExceededCapacityType()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CODE_FIELD_NUMBER;
      hash = (53 * hash) + code_;
      if (hasExampleVehicleIndex()) {
        hash = (37 * hash) + EXAMPLE_VEHICLE_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + getExampleVehicleIndex();
      }
      hash = (37 * hash) + EXAMPLE_EXCEEDED_CAPACITY_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getExampleExceededCapacityType().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.SkippedShipment.Reason prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * If we can explain why the shipment was skipped, reasons will be listed
     * here. If the reason is not the same for all vehicles, `reason` will have
     * more than 1 element. A skipped shipment cannot have duplicate reasons,
     * i.e. where all fields are the same except for `example_vehicle_index`.
     * Example:
     * ```
     * reasons {
     *   code: DEMAND_EXCEEDS_VEHICLE_CAPACITY
     *   example_vehicle_index: 1
     *   example_exceeded_capacity_type: "Apples"
     * }
     * reasons {
     *   code: DEMAND_EXCEEDS_VEHICLE_CAPACITY
     *   example_vehicle_index: 3
     *   example_exceeded_capacity_type: "Pears"
     * }
     * reasons {
     *   code: CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT
     *   example_vehicle_index: 1
     * }
     * ```
     * The skipped shipment is incompatible with all vehicles. The reasons may
     * be different for all vehicles but at least one vehicle's "Apples"
     * capacity would be exceeded (including vehicle 1), at least one vehicle's
     * "Pears" capacity would be exceeded (including vehicle 3) and at least one
     * vehicle's distance limit would be exceeded (including vehicle 1).
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.SkippedShipment.Reason}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.SkippedShipment.Reason)
        com.google.cloud.optimization.v1.SkippedShipment.ReasonOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_SkippedShipment_Reason_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_SkippedShipment_Reason_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.SkippedShipment.Reason.class,
                com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.SkippedShipment.Reason.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        code_ = 0;

        exampleVehicleIndex_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        exampleExceededCapacityType_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_SkippedShipment_Reason_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.SkippedShipment.Reason getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.SkippedShipment.Reason.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.SkippedShipment.Reason build() {
        com.google.cloud.optimization.v1.SkippedShipment.Reason result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.SkippedShipment.Reason buildPartial() {
        com.google.cloud.optimization.v1.SkippedShipment.Reason result =
            new com.google.cloud.optimization.v1.SkippedShipment.Reason(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.code_ = code_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.exampleVehicleIndex_ = exampleVehicleIndex_;
          to_bitField0_ |= 0x00000001;
        }
        result.exampleExceededCapacityType_ = exampleExceededCapacityType_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.SkippedShipment.Reason) {
          return mergeFrom((com.google.cloud.optimization.v1.SkippedShipment.Reason) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.SkippedShipment.Reason other) {
        if (other == com.google.cloud.optimization.v1.SkippedShipment.Reason.getDefaultInstance())
          return this;
        if (other.code_ != 0) {
          setCodeValue(other.getCodeValue());
        }
        if (other.hasExampleVehicleIndex()) {
          setExampleVehicleIndex(other.getExampleVehicleIndex());
        }
        if (!other.getExampleExceededCapacityType().isEmpty()) {
          exampleExceededCapacityType_ = other.exampleExceededCapacityType_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  code_ = input.readEnum();

                  break;
                } // case 8
              case 16:
                {
                  exampleVehicleIndex_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 16
              case 26:
                {
                  exampleExceededCapacityType_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int code_ = 0;
      /**
       *
       *
       * <pre>
       * Refer to the comments of Code.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.SkippedShipment.Reason.Code code = 1;</code>
       *
       * @return The enum numeric value on the wire for code.
       */
      @java.lang.Override
      public int getCodeValue() {
        return code_;
      }
      /**
       *
       *
       * <pre>
       * Refer to the comments of Code.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.SkippedShipment.Reason.Code code = 1;</code>
       *
       * @param value The enum numeric value on the wire for code to set.
       * @return This builder for chaining.
       */
      public Builder setCodeValue(int value) {

        code_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Refer to the comments of Code.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.SkippedShipment.Reason.Code code = 1;</code>
       *
       * @return The code.
       */
      @java.lang.Override
      public com.google.cloud.optimization.v1.SkippedShipment.Reason.Code getCode() {
        @SuppressWarnings("deprecation")
        com.google.cloud.optimization.v1.SkippedShipment.Reason.Code result =
            com.google.cloud.optimization.v1.SkippedShipment.Reason.Code.valueOf(code_);
        return result == null
            ? com.google.cloud.optimization.v1.SkippedShipment.Reason.Code.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Refer to the comments of Code.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.SkippedShipment.Reason.Code code = 1;</code>
       *
       * @param value The code to set.
       * @return This builder for chaining.
       */
      public Builder setCode(com.google.cloud.optimization.v1.SkippedShipment.Reason.Code value) {
        if (value == null) {
          throw new NullPointerException();
        }

        code_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Refer to the comments of Code.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.SkippedShipment.Reason.Code code = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCode() {

        code_ = 0;
        onChanged();
        return this;
      }

      private int exampleVehicleIndex_;
      /**
       *
       *
       * <pre>
       * If the reason is related to a shipment-vehicle incompatibility, this
       * field provides the index of one relevant vehicle.
       * </pre>
       *
       * <code>optional int32 example_vehicle_index = 2;</code>
       *
       * @return Whether the exampleVehicleIndex field is set.
       */
      @java.lang.Override
      public boolean hasExampleVehicleIndex() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * If the reason is related to a shipment-vehicle incompatibility, this
       * field provides the index of one relevant vehicle.
       * </pre>
       *
       * <code>optional int32 example_vehicle_index = 2;</code>
       *
       * @return The exampleVehicleIndex.
       */
      @java.lang.Override
      public int getExampleVehicleIndex() {
        return exampleVehicleIndex_;
      }
      /**
       *
       *
       * <pre>
       * If the reason is related to a shipment-vehicle incompatibility, this
       * field provides the index of one relevant vehicle.
       * </pre>
       *
       * <code>optional int32 example_vehicle_index = 2;</code>
       *
       * @param value The exampleVehicleIndex to set.
       * @return This builder for chaining.
       */
      public Builder setExampleVehicleIndex(int value) {
        bitField0_ |= 0x00000001;
        exampleVehicleIndex_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the reason is related to a shipment-vehicle incompatibility, this
       * field provides the index of one relevant vehicle.
       * </pre>
       *
       * <code>optional int32 example_vehicle_index = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExampleVehicleIndex() {
        bitField0_ = (bitField0_ & ~0x00000001);
        exampleVehicleIndex_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object exampleExceededCapacityType_ = "";
      /**
       *
       *
       * <pre>
       * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
       * capacity type that is exceeded.
       * </pre>
       *
       * <code>string example_exceeded_capacity_type = 3;</code>
       *
       * @return The exampleExceededCapacityType.
       */
      public java.lang.String getExampleExceededCapacityType() {
        java.lang.Object ref = exampleExceededCapacityType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          exampleExceededCapacityType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
       * capacity type that is exceeded.
       * </pre>
       *
       * <code>string example_exceeded_capacity_type = 3;</code>
       *
       * @return The bytes for exampleExceededCapacityType.
       */
      public com.google.protobuf.ByteString getExampleExceededCapacityTypeBytes() {
        java.lang.Object ref = exampleExceededCapacityType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          exampleExceededCapacityType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
       * capacity type that is exceeded.
       * </pre>
       *
       * <code>string example_exceeded_capacity_type = 3;</code>
       *
       * @param value The exampleExceededCapacityType to set.
       * @return This builder for chaining.
       */
      public Builder setExampleExceededCapacityType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        exampleExceededCapacityType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
       * capacity type that is exceeded.
       * </pre>
       *
       * <code>string example_exceeded_capacity_type = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExampleExceededCapacityType() {

        exampleExceededCapacityType_ = getDefaultInstance().getExampleExceededCapacityType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
       * capacity type that is exceeded.
       * </pre>
       *
       * <code>string example_exceeded_capacity_type = 3;</code>
       *
       * @param value The bytes for exampleExceededCapacityType to set.
       * @return This builder for chaining.
       */
      public Builder setExampleExceededCapacityTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        exampleExceededCapacityType_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.SkippedShipment.Reason)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.SkippedShipment.Reason)
    private static final com.google.cloud.optimization.v1.SkippedShipment.Reason DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.SkippedShipment.Reason();
    }

    public static com.google.cloud.optimization.v1.SkippedShipment.Reason getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Reason> PARSER =
        new com.google.protobuf.AbstractParser<Reason>() {
          @java.lang.Override
          public Reason parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Reason> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Reason> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.SkippedShipment.Reason getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int INDEX_FIELD_NUMBER = 1;
  private int index_;
  /**
   *
   *
   * <pre>
   * The index corresponds to the index of the shipment in the source
   * `ShipmentModel`.
   * </pre>
   *
   * <code>int32 index = 1;</code>
   *
   * @return The index.
   */
  @java.lang.Override
  public int getIndex() {
    return index_;
  }

  public static final int LABEL_FIELD_NUMBER = 2;
  private volatile java.lang.Object label_;
  /**
   *
   *
   * <pre>
   * Copy of the corresponding [Shipment.label][google.cloud.optimization.v1.Shipment.label], if specified in the
   * `Shipment`.
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The label.
   */
  @java.lang.Override
  public java.lang.String getLabel() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      label_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Copy of the corresponding [Shipment.label][google.cloud.optimization.v1.Shipment.label], if specified in the
   * `Shipment`.
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The bytes for label.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelBytes() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      label_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REASONS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.optimization.v1.SkippedShipment.Reason> reasons_;
  /**
   *
   *
   * <pre>
   * A list of reasons that explain why the shipment was skipped. See comment
   * above `Reason`.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.SkippedShipment.Reason> getReasonsList() {
    return reasons_;
  }
  /**
   *
   *
   * <pre>
   * A list of reasons that explain why the shipment was skipped. See comment
   * above `Reason`.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.SkippedShipment.ReasonOrBuilder>
      getReasonsOrBuilderList() {
    return reasons_;
  }
  /**
   *
   *
   * <pre>
   * A list of reasons that explain why the shipment was skipped. See comment
   * above `Reason`.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
   */
  @java.lang.Override
  public int getReasonsCount() {
    return reasons_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of reasons that explain why the shipment was skipped. See comment
   * above `Reason`.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.SkippedShipment.Reason getReasons(int index) {
    return reasons_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of reasons that explain why the shipment was skipped. See comment
   * above `Reason`.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.SkippedShipment.ReasonOrBuilder getReasonsOrBuilder(
      int index) {
    return reasons_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (index_ != 0) {
      output.writeInt32(1, index_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, label_);
    }
    for (int i = 0; i < reasons_.size(); i++) {
      output.writeMessage(3, reasons_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (index_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, index_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, label_);
    }
    for (int i = 0; i < reasons_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, reasons_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.SkippedShipment)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.SkippedShipment other =
        (com.google.cloud.optimization.v1.SkippedShipment) obj;

    if (getIndex() != other.getIndex()) return false;
    if (!getLabel().equals(other.getLabel())) return false;
    if (!getReasonsList().equals(other.getReasonsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INDEX_FIELD_NUMBER;
    hash = (53 * hash) + getIndex();
    hash = (37 * hash) + LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getLabel().hashCode();
    if (getReasonsCount() > 0) {
      hash = (37 * hash) + REASONS_FIELD_NUMBER;
      hash = (53 * hash) + getReasonsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.SkippedShipment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.optimization.v1.SkippedShipment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies details of unperformed shipments in a solution. For trivial cases
   * and/or if we are able to identify the cause for skipping, we report the
   * reason here.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.SkippedShipment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.SkippedShipment)
      com.google.cloud.optimization.v1.SkippedShipmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_SkippedShipment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_SkippedShipment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.SkippedShipment.class,
              com.google.cloud.optimization.v1.SkippedShipment.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.SkippedShipment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      index_ = 0;

      label_ = "";

      if (reasonsBuilder_ == null) {
        reasons_ = java.util.Collections.emptyList();
      } else {
        reasons_ = null;
        reasonsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_SkippedShipment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.SkippedShipment getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.SkippedShipment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.SkippedShipment build() {
      com.google.cloud.optimization.v1.SkippedShipment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.SkippedShipment buildPartial() {
      com.google.cloud.optimization.v1.SkippedShipment result =
          new com.google.cloud.optimization.v1.SkippedShipment(this);
      int from_bitField0_ = bitField0_;
      result.index_ = index_;
      result.label_ = label_;
      if (reasonsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          reasons_ = java.util.Collections.unmodifiableList(reasons_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.reasons_ = reasons_;
      } else {
        result.reasons_ = reasonsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.SkippedShipment) {
        return mergeFrom((com.google.cloud.optimization.v1.SkippedShipment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.SkippedShipment other) {
      if (other == com.google.cloud.optimization.v1.SkippedShipment.getDefaultInstance())
        return this;
      if (other.getIndex() != 0) {
        setIndex(other.getIndex());
      }
      if (!other.getLabel().isEmpty()) {
        label_ = other.label_;
        onChanged();
      }
      if (reasonsBuilder_ == null) {
        if (!other.reasons_.isEmpty()) {
          if (reasons_.isEmpty()) {
            reasons_ = other.reasons_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureReasonsIsMutable();
            reasons_.addAll(other.reasons_);
          }
          onChanged();
        }
      } else {
        if (!other.reasons_.isEmpty()) {
          if (reasonsBuilder_.isEmpty()) {
            reasonsBuilder_.dispose();
            reasonsBuilder_ = null;
            reasons_ = other.reasons_;
            bitField0_ = (bitField0_ & ~0x00000001);
            reasonsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getReasonsFieldBuilder()
                    : null;
          } else {
            reasonsBuilder_.addAllMessages(other.reasons_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                index_ = input.readInt32();

                break;
              } // case 8
            case 18:
              {
                label_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                com.google.cloud.optimization.v1.SkippedShipment.Reason m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.SkippedShipment.Reason.parser(),
                        extensionRegistry);
                if (reasonsBuilder_ == null) {
                  ensureReasonsIsMutable();
                  reasons_.add(m);
                } else {
                  reasonsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int index_;
    /**
     *
     *
     * <pre>
     * The index corresponds to the index of the shipment in the source
     * `ShipmentModel`.
     * </pre>
     *
     * <code>int32 index = 1;</code>
     *
     * @return The index.
     */
    @java.lang.Override
    public int getIndex() {
      return index_;
    }
    /**
     *
     *
     * <pre>
     * The index corresponds to the index of the shipment in the source
     * `ShipmentModel`.
     * </pre>
     *
     * <code>int32 index = 1;</code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(int value) {

      index_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The index corresponds to the index of the shipment in the source
     * `ShipmentModel`.
     * </pre>
     *
     * <code>int32 index = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {

      index_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object label_ = "";
    /**
     *
     *
     * <pre>
     * Copy of the corresponding [Shipment.label][google.cloud.optimization.v1.Shipment.label], if specified in the
     * `Shipment`.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return The label.
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Copy of the corresponding [Shipment.label][google.cloud.optimization.v1.Shipment.label], if specified in the
     * `Shipment`.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return The bytes for label.
     */
    public com.google.protobuf.ByteString getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Copy of the corresponding [Shipment.label][google.cloud.optimization.v1.Shipment.label], if specified in the
     * `Shipment`.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @param value The label to set.
     * @return This builder for chaining.
     */
    public Builder setLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      label_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Copy of the corresponding [Shipment.label][google.cloud.optimization.v1.Shipment.label], if specified in the
     * `Shipment`.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabel() {

      label_ = getDefaultInstance().getLabel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Copy of the corresponding [Shipment.label][google.cloud.optimization.v1.Shipment.label], if specified in the
     * `Shipment`.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @param value The bytes for label to set.
     * @return This builder for chaining.
     */
    public Builder setLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      label_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.optimization.v1.SkippedShipment.Reason> reasons_ =
        java.util.Collections.emptyList();

    private void ensureReasonsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        reasons_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.SkippedShipment.Reason>(
                reasons_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.SkippedShipment.Reason,
            com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder,
            com.google.cloud.optimization.v1.SkippedShipment.ReasonOrBuilder>
        reasonsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.SkippedShipment.Reason>
        getReasonsList() {
      if (reasonsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(reasons_);
      } else {
        return reasonsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public int getReasonsCount() {
      if (reasonsBuilder_ == null) {
        return reasons_.size();
      } else {
        return reasonsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment.Reason getReasons(int index) {
      if (reasonsBuilder_ == null) {
        return reasons_.get(index);
      } else {
        return reasonsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public Builder setReasons(
        int index, com.google.cloud.optimization.v1.SkippedShipment.Reason value) {
      if (reasonsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReasonsIsMutable();
        reasons_.set(index, value);
        onChanged();
      } else {
        reasonsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public Builder setReasons(
        int index,
        com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder builderForValue) {
      if (reasonsBuilder_ == null) {
        ensureReasonsIsMutable();
        reasons_.set(index, builderForValue.build());
        onChanged();
      } else {
        reasonsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public Builder addReasons(com.google.cloud.optimization.v1.SkippedShipment.Reason value) {
      if (reasonsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReasonsIsMutable();
        reasons_.add(value);
        onChanged();
      } else {
        reasonsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public Builder addReasons(
        int index, com.google.cloud.optimization.v1.SkippedShipment.Reason value) {
      if (reasonsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReasonsIsMutable();
        reasons_.add(index, value);
        onChanged();
      } else {
        reasonsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public Builder addReasons(
        com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder builderForValue) {
      if (reasonsBuilder_ == null) {
        ensureReasonsIsMutable();
        reasons_.add(builderForValue.build());
        onChanged();
      } else {
        reasonsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public Builder addReasons(
        int index,
        com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder builderForValue) {
      if (reasonsBuilder_ == null) {
        ensureReasonsIsMutable();
        reasons_.add(index, builderForValue.build());
        onChanged();
      } else {
        reasonsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public Builder addAllReasons(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.SkippedShipment.Reason>
            values) {
      if (reasonsBuilder_ == null) {
        ensureReasonsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, reasons_);
        onChanged();
      } else {
        reasonsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public Builder clearReasons() {
      if (reasonsBuilder_ == null) {
        reasons_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        reasonsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public Builder removeReasons(int index) {
      if (reasonsBuilder_ == null) {
        ensureReasonsIsMutable();
        reasons_.remove(index);
        onChanged();
      } else {
        reasonsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder getReasonsBuilder(
        int index) {
      return getReasonsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment.ReasonOrBuilder getReasonsOrBuilder(
        int index) {
      if (reasonsBuilder_ == null) {
        return reasons_.get(index);
      } else {
        return reasonsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.SkippedShipment.ReasonOrBuilder>
        getReasonsOrBuilderList() {
      if (reasonsBuilder_ != null) {
        return reasonsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(reasons_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder addReasonsBuilder() {
      return getReasonsFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.SkippedShipment.Reason.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder addReasonsBuilder(
        int index) {
      return getReasonsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.SkippedShipment.Reason.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of reasons that explain why the shipment was skipped. See comment
     * above `Reason`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment.Reason reasons = 3;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder>
        getReasonsBuilderList() {
      return getReasonsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.SkippedShipment.Reason,
            com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder,
            com.google.cloud.optimization.v1.SkippedShipment.ReasonOrBuilder>
        getReasonsFieldBuilder() {
      if (reasonsBuilder_ == null) {
        reasonsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.SkippedShipment.Reason,
                com.google.cloud.optimization.v1.SkippedShipment.Reason.Builder,
                com.google.cloud.optimization.v1.SkippedShipment.ReasonOrBuilder>(
                reasons_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        reasons_ = null;
      }
      return reasonsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.SkippedShipment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.SkippedShipment)
  private static final com.google.cloud.optimization.v1.SkippedShipment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.SkippedShipment();
  }

  public static com.google.cloud.optimization.v1.SkippedShipment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SkippedShipment> PARSER =
      new com.google.protobuf.AbstractParser<SkippedShipment>() {
        @java.lang.Override
        public SkippedShipment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SkippedShipment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SkippedShipment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.SkippedShipment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
