/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Specifies requirements between shipments based on their shipment_type.
 * The specifics of the requirement are defined by the requirement mode.
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.ShipmentTypeRequirement}
 */
public final class ShipmentTypeRequirement extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentTypeRequirement)
    ShipmentTypeRequirementOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ShipmentTypeRequirement.newBuilder() to construct.
  private ShipmentTypeRequirement(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ShipmentTypeRequirement() {
    requiredShipmentTypeAlternatives_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    dependentShipmentTypes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    requirementMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ShipmentTypeRequirement();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_ShipmentTypeRequirement_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_ShipmentTypeRequirement_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.ShipmentTypeRequirement.class,
            com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Modes defining the appearance of dependent shipments on a route.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode}
   */
  public enum RequirementMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified requirement mode. This value should never be used.
     * </pre>
     *
     * <code>REQUIREMENT_MODE_UNSPECIFIED = 0;</code>
     */
    REQUIREMENT_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * In this mode, all "dependent" shipments must share the same vehicle as at
     * least one of their "required" shipments.
     * </pre>
     *
     * <code>PERFORMED_BY_SAME_VEHICLE = 1;</code>
     */
    PERFORMED_BY_SAME_VEHICLE(1),
    /**
     *
     *
     * <pre>
     * With the `IN_SAME_VEHICLE_AT_PICKUP_TIME` mode, all "dependent"
     * shipments need to have at least one "required" shipment on their vehicle
     * at the time of their pickup.
     * A "dependent" shipment pickup must therefore have either:
     * * A delivery-only "required" shipment delivered on the route after, or
     * * A "required" shipment picked up on the route before it, and if the
     *   "required" shipment has a delivery, this delivery must be performed
     *   after the "dependent" shipment's pickup.
     * </pre>
     *
     * <code>IN_SAME_VEHICLE_AT_PICKUP_TIME = 2;</code>
     */
    IN_SAME_VEHICLE_AT_PICKUP_TIME(2),
    /**
     *
     *
     * <pre>
     * Same as before, except the "dependent" shipments need to have a
     * "required" shipment on their vehicle at the time of their *delivery*.
     * </pre>
     *
     * <code>IN_SAME_VEHICLE_AT_DELIVERY_TIME = 3;</code>
     */
    IN_SAME_VEHICLE_AT_DELIVERY_TIME(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified requirement mode. This value should never be used.
     * </pre>
     *
     * <code>REQUIREMENT_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int REQUIREMENT_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * In this mode, all "dependent" shipments must share the same vehicle as at
     * least one of their "required" shipments.
     * </pre>
     *
     * <code>PERFORMED_BY_SAME_VEHICLE = 1;</code>
     */
    public static final int PERFORMED_BY_SAME_VEHICLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * With the `IN_SAME_VEHICLE_AT_PICKUP_TIME` mode, all "dependent"
     * shipments need to have at least one "required" shipment on their vehicle
     * at the time of their pickup.
     * A "dependent" shipment pickup must therefore have either:
     * * A delivery-only "required" shipment delivered on the route after, or
     * * A "required" shipment picked up on the route before it, and if the
     *   "required" shipment has a delivery, this delivery must be performed
     *   after the "dependent" shipment's pickup.
     * </pre>
     *
     * <code>IN_SAME_VEHICLE_AT_PICKUP_TIME = 2;</code>
     */
    public static final int IN_SAME_VEHICLE_AT_PICKUP_TIME_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Same as before, except the "dependent" shipments need to have a
     * "required" shipment on their vehicle at the time of their *delivery*.
     * </pre>
     *
     * <code>IN_SAME_VEHICLE_AT_DELIVERY_TIME = 3;</code>
     */
    public static final int IN_SAME_VEHICLE_AT_DELIVERY_TIME_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RequirementMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RequirementMode forNumber(int value) {
      switch (value) {
        case 0:
          return REQUIREMENT_MODE_UNSPECIFIED;
        case 1:
          return PERFORMED_BY_SAME_VEHICLE;
        case 2:
          return IN_SAME_VEHICLE_AT_PICKUP_TIME;
        case 3:
          return IN_SAME_VEHICLE_AT_DELIVERY_TIME;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RequirementMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RequirementMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RequirementMode>() {
              public RequirementMode findValueByNumber(int number) {
                return RequirementMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.optimization.v1.ShipmentTypeRequirement.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RequirementMode[] VALUES = values();

    public static RequirementMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RequirementMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode)
  }

  public static final int REQUIRED_SHIPMENT_TYPE_ALTERNATIVES_FIELD_NUMBER = 1;
  private com.google.protobuf.LazyStringList requiredShipmentTypeAlternatives_;
  /**
   *
   *
   * <pre>
   * List of alternative shipment types required by the
   * `dependent_shipment_types`.
   * </pre>
   *
   * <code>repeated string required_shipment_type_alternatives = 1;</code>
   *
   * @return A list containing the requiredShipmentTypeAlternatives.
   */
  public com.google.protobuf.ProtocolStringList getRequiredShipmentTypeAlternativesList() {
    return requiredShipmentTypeAlternatives_;
  }
  /**
   *
   *
   * <pre>
   * List of alternative shipment types required by the
   * `dependent_shipment_types`.
   * </pre>
   *
   * <code>repeated string required_shipment_type_alternatives = 1;</code>
   *
   * @return The count of requiredShipmentTypeAlternatives.
   */
  public int getRequiredShipmentTypeAlternativesCount() {
    return requiredShipmentTypeAlternatives_.size();
  }
  /**
   *
   *
   * <pre>
   * List of alternative shipment types required by the
   * `dependent_shipment_types`.
   * </pre>
   *
   * <code>repeated string required_shipment_type_alternatives = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The requiredShipmentTypeAlternatives at the given index.
   */
  public java.lang.String getRequiredShipmentTypeAlternatives(int index) {
    return requiredShipmentTypeAlternatives_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of alternative shipment types required by the
   * `dependent_shipment_types`.
   * </pre>
   *
   * <code>repeated string required_shipment_type_alternatives = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the requiredShipmentTypeAlternatives at the given index.
   */
  public com.google.protobuf.ByteString getRequiredShipmentTypeAlternativesBytes(int index) {
    return requiredShipmentTypeAlternatives_.getByteString(index);
  }

  public static final int DEPENDENT_SHIPMENT_TYPES_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList dependentShipmentTypes_;
  /**
   *
   *
   * <pre>
   * All shipments with a type in the `dependent_shipment_types` field require
   * at least one shipment of type `required_shipment_type_alternatives` to be
   * visited on the same route.
   * NOTE: Chains of requirements such that a `shipment_type` depends on itself
   * are not allowed.
   * </pre>
   *
   * <code>repeated string dependent_shipment_types = 2;</code>
   *
   * @return A list containing the dependentShipmentTypes.
   */
  public com.google.protobuf.ProtocolStringList getDependentShipmentTypesList() {
    return dependentShipmentTypes_;
  }
  /**
   *
   *
   * <pre>
   * All shipments with a type in the `dependent_shipment_types` field require
   * at least one shipment of type `required_shipment_type_alternatives` to be
   * visited on the same route.
   * NOTE: Chains of requirements such that a `shipment_type` depends on itself
   * are not allowed.
   * </pre>
   *
   * <code>repeated string dependent_shipment_types = 2;</code>
   *
   * @return The count of dependentShipmentTypes.
   */
  public int getDependentShipmentTypesCount() {
    return dependentShipmentTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * All shipments with a type in the `dependent_shipment_types` field require
   * at least one shipment of type `required_shipment_type_alternatives` to be
   * visited on the same route.
   * NOTE: Chains of requirements such that a `shipment_type` depends on itself
   * are not allowed.
   * </pre>
   *
   * <code>repeated string dependent_shipment_types = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The dependentShipmentTypes at the given index.
   */
  public java.lang.String getDependentShipmentTypes(int index) {
    return dependentShipmentTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All shipments with a type in the `dependent_shipment_types` field require
   * at least one shipment of type `required_shipment_type_alternatives` to be
   * visited on the same route.
   * NOTE: Chains of requirements such that a `shipment_type` depends on itself
   * are not allowed.
   * </pre>
   *
   * <code>repeated string dependent_shipment_types = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the dependentShipmentTypes at the given index.
   */
  public com.google.protobuf.ByteString getDependentShipmentTypesBytes(int index) {
    return dependentShipmentTypes_.getByteString(index);
  }

  public static final int REQUIREMENT_MODE_FIELD_NUMBER = 3;
  private int requirementMode_;
  /**
   *
   *
   * <pre>
   * Mode applied to the requirement.
   * </pre>
   *
   * <code>
   * .google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode requirement_mode = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for requirementMode.
   */
  @java.lang.Override
  public int getRequirementModeValue() {
    return requirementMode_;
  }
  /**
   *
   *
   * <pre>
   * Mode applied to the requirement.
   * </pre>
   *
   * <code>
   * .google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode requirement_mode = 3;
   * </code>
   *
   * @return The requirementMode.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode
      getRequirementMode() {
    @SuppressWarnings("deprecation")
    com.google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode result =
        com.google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode.valueOf(
            requirementMode_);
    return result == null
        ? com.google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < requiredShipmentTypeAlternatives_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 1, requiredShipmentTypeAlternatives_.getRaw(i));
    }
    for (int i = 0; i < dependentShipmentTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 2, dependentShipmentTypes_.getRaw(i));
    }
    if (requirementMode_
        != com.google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode
            .REQUIREMENT_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, requirementMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < requiredShipmentTypeAlternatives_.size(); i++) {
        dataSize += computeStringSizeNoTag(requiredShipmentTypeAlternatives_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRequiredShipmentTypeAlternativesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < dependentShipmentTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(dependentShipmentTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDependentShipmentTypesList().size();
    }
    if (requirementMode_
        != com.google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode
            .REQUIREMENT_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, requirementMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentTypeRequirement)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.ShipmentTypeRequirement other =
        (com.google.cloud.optimization.v1.ShipmentTypeRequirement) obj;

    if (!getRequiredShipmentTypeAlternativesList()
        .equals(other.getRequiredShipmentTypeAlternativesList())) return false;
    if (!getDependentShipmentTypesList().equals(other.getDependentShipmentTypesList()))
      return false;
    if (requirementMode_ != other.requirementMode_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRequiredShipmentTypeAlternativesCount() > 0) {
      hash = (37 * hash) + REQUIRED_SHIPMENT_TYPE_ALTERNATIVES_FIELD_NUMBER;
      hash = (53 * hash) + getRequiredShipmentTypeAlternativesList().hashCode();
    }
    if (getDependentShipmentTypesCount() > 0) {
      hash = (37 * hash) + DEPENDENT_SHIPMENT_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getDependentShipmentTypesList().hashCode();
    }
    hash = (37 * hash) + REQUIREMENT_MODE_FIELD_NUMBER;
    hash = (53 * hash) + requirementMode_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.optimization.v1.ShipmentTypeRequirement prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies requirements between shipments based on their shipment_type.
   * The specifics of the requirement are defined by the requirement mode.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentTypeRequirement}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentTypeRequirement)
      com.google.cloud.optimization.v1.ShipmentTypeRequirementOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentTypeRequirement_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentTypeRequirement_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentTypeRequirement.class,
              com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.ShipmentTypeRequirement.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      requiredShipmentTypeAlternatives_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      dependentShipmentTypes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      requirementMode_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentTypeRequirement_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentTypeRequirement getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.ShipmentTypeRequirement.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentTypeRequirement build() {
      com.google.cloud.optimization.v1.ShipmentTypeRequirement result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentTypeRequirement buildPartial() {
      com.google.cloud.optimization.v1.ShipmentTypeRequirement result =
          new com.google.cloud.optimization.v1.ShipmentTypeRequirement(this);
      int from_bitField0_ = bitField0_;
      if (((bitField0_ & 0x00000001) != 0)) {
        requiredShipmentTypeAlternatives_ = requiredShipmentTypeAlternatives_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.requiredShipmentTypeAlternatives_ = requiredShipmentTypeAlternatives_;
      if (((bitField0_ & 0x00000002) != 0)) {
        dependentShipmentTypes_ = dependentShipmentTypes_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.dependentShipmentTypes_ = dependentShipmentTypes_;
      result.requirementMode_ = requirementMode_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.ShipmentTypeRequirement) {
        return mergeFrom((com.google.cloud.optimization.v1.ShipmentTypeRequirement) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.ShipmentTypeRequirement other) {
      if (other == com.google.cloud.optimization.v1.ShipmentTypeRequirement.getDefaultInstance())
        return this;
      if (!other.requiredShipmentTypeAlternatives_.isEmpty()) {
        if (requiredShipmentTypeAlternatives_.isEmpty()) {
          requiredShipmentTypeAlternatives_ = other.requiredShipmentTypeAlternatives_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureRequiredShipmentTypeAlternativesIsMutable();
          requiredShipmentTypeAlternatives_.addAll(other.requiredShipmentTypeAlternatives_);
        }
        onChanged();
      }
      if (!other.dependentShipmentTypes_.isEmpty()) {
        if (dependentShipmentTypes_.isEmpty()) {
          dependentShipmentTypes_ = other.dependentShipmentTypes_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureDependentShipmentTypesIsMutable();
          dependentShipmentTypes_.addAll(other.dependentShipmentTypes_);
        }
        onChanged();
      }
      if (other.requirementMode_ != 0) {
        setRequirementModeValue(other.getRequirementModeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRequiredShipmentTypeAlternativesIsMutable();
                requiredShipmentTypeAlternatives_.add(s);
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDependentShipmentTypesIsMutable();
                dependentShipmentTypes_.add(s);
                break;
              } // case 18
            case 24:
              {
                requirementMode_ = input.readEnum();

                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringList requiredShipmentTypeAlternatives_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureRequiredShipmentTypeAlternativesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        requiredShipmentTypeAlternatives_ =
            new com.google.protobuf.LazyStringArrayList(requiredShipmentTypeAlternatives_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * List of alternative shipment types required by the
     * `dependent_shipment_types`.
     * </pre>
     *
     * <code>repeated string required_shipment_type_alternatives = 1;</code>
     *
     * @return A list containing the requiredShipmentTypeAlternatives.
     */
    public com.google.protobuf.ProtocolStringList getRequiredShipmentTypeAlternativesList() {
      return requiredShipmentTypeAlternatives_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * List of alternative shipment types required by the
     * `dependent_shipment_types`.
     * </pre>
     *
     * <code>repeated string required_shipment_type_alternatives = 1;</code>
     *
     * @return The count of requiredShipmentTypeAlternatives.
     */
    public int getRequiredShipmentTypeAlternativesCount() {
      return requiredShipmentTypeAlternatives_.size();
    }
    /**
     *
     *
     * <pre>
     * List of alternative shipment types required by the
     * `dependent_shipment_types`.
     * </pre>
     *
     * <code>repeated string required_shipment_type_alternatives = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The requiredShipmentTypeAlternatives at the given index.
     */
    public java.lang.String getRequiredShipmentTypeAlternatives(int index) {
      return requiredShipmentTypeAlternatives_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of alternative shipment types required by the
     * `dependent_shipment_types`.
     * </pre>
     *
     * <code>repeated string required_shipment_type_alternatives = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the requiredShipmentTypeAlternatives at the given index.
     */
    public com.google.protobuf.ByteString getRequiredShipmentTypeAlternativesBytes(int index) {
      return requiredShipmentTypeAlternatives_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of alternative shipment types required by the
     * `dependent_shipment_types`.
     * </pre>
     *
     * <code>repeated string required_shipment_type_alternatives = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The requiredShipmentTypeAlternatives to set.
     * @return This builder for chaining.
     */
    public Builder setRequiredShipmentTypeAlternatives(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequiredShipmentTypeAlternativesIsMutable();
      requiredShipmentTypeAlternatives_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of alternative shipment types required by the
     * `dependent_shipment_types`.
     * </pre>
     *
     * <code>repeated string required_shipment_type_alternatives = 1;</code>
     *
     * @param value The requiredShipmentTypeAlternatives to add.
     * @return This builder for chaining.
     */
    public Builder addRequiredShipmentTypeAlternatives(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequiredShipmentTypeAlternativesIsMutable();
      requiredShipmentTypeAlternatives_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of alternative shipment types required by the
     * `dependent_shipment_types`.
     * </pre>
     *
     * <code>repeated string required_shipment_type_alternatives = 1;</code>
     *
     * @param values The requiredShipmentTypeAlternatives to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequiredShipmentTypeAlternatives(
        java.lang.Iterable<java.lang.String> values) {
      ensureRequiredShipmentTypeAlternativesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, requiredShipmentTypeAlternatives_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of alternative shipment types required by the
     * `dependent_shipment_types`.
     * </pre>
     *
     * <code>repeated string required_shipment_type_alternatives = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequiredShipmentTypeAlternatives() {
      requiredShipmentTypeAlternatives_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of alternative shipment types required by the
     * `dependent_shipment_types`.
     * </pre>
     *
     * <code>repeated string required_shipment_type_alternatives = 1;</code>
     *
     * @param value The bytes of the requiredShipmentTypeAlternatives to add.
     * @return This builder for chaining.
     */
    public Builder addRequiredShipmentTypeAlternativesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRequiredShipmentTypeAlternativesIsMutable();
      requiredShipmentTypeAlternatives_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList dependentShipmentTypes_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureDependentShipmentTypesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        dependentShipmentTypes_ =
            new com.google.protobuf.LazyStringArrayList(dependentShipmentTypes_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * All shipments with a type in the `dependent_shipment_types` field require
     * at least one shipment of type `required_shipment_type_alternatives` to be
     * visited on the same route.
     * NOTE: Chains of requirements such that a `shipment_type` depends on itself
     * are not allowed.
     * </pre>
     *
     * <code>repeated string dependent_shipment_types = 2;</code>
     *
     * @return A list containing the dependentShipmentTypes.
     */
    public com.google.protobuf.ProtocolStringList getDependentShipmentTypesList() {
      return dependentShipmentTypes_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * All shipments with a type in the `dependent_shipment_types` field require
     * at least one shipment of type `required_shipment_type_alternatives` to be
     * visited on the same route.
     * NOTE: Chains of requirements such that a `shipment_type` depends on itself
     * are not allowed.
     * </pre>
     *
     * <code>repeated string dependent_shipment_types = 2;</code>
     *
     * @return The count of dependentShipmentTypes.
     */
    public int getDependentShipmentTypesCount() {
      return dependentShipmentTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * All shipments with a type in the `dependent_shipment_types` field require
     * at least one shipment of type `required_shipment_type_alternatives` to be
     * visited on the same route.
     * NOTE: Chains of requirements such that a `shipment_type` depends on itself
     * are not allowed.
     * </pre>
     *
     * <code>repeated string dependent_shipment_types = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The dependentShipmentTypes at the given index.
     */
    public java.lang.String getDependentShipmentTypes(int index) {
      return dependentShipmentTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * All shipments with a type in the `dependent_shipment_types` field require
     * at least one shipment of type `required_shipment_type_alternatives` to be
     * visited on the same route.
     * NOTE: Chains of requirements such that a `shipment_type` depends on itself
     * are not allowed.
     * </pre>
     *
     * <code>repeated string dependent_shipment_types = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dependentShipmentTypes at the given index.
     */
    public com.google.protobuf.ByteString getDependentShipmentTypesBytes(int index) {
      return dependentShipmentTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * All shipments with a type in the `dependent_shipment_types` field require
     * at least one shipment of type `required_shipment_type_alternatives` to be
     * visited on the same route.
     * NOTE: Chains of requirements such that a `shipment_type` depends on itself
     * are not allowed.
     * </pre>
     *
     * <code>repeated string dependent_shipment_types = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The dependentShipmentTypes to set.
     * @return This builder for chaining.
     */
    public Builder setDependentShipmentTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDependentShipmentTypesIsMutable();
      dependentShipmentTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All shipments with a type in the `dependent_shipment_types` field require
     * at least one shipment of type `required_shipment_type_alternatives` to be
     * visited on the same route.
     * NOTE: Chains of requirements such that a `shipment_type` depends on itself
     * are not allowed.
     * </pre>
     *
     * <code>repeated string dependent_shipment_types = 2;</code>
     *
     * @param value The dependentShipmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addDependentShipmentTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDependentShipmentTypesIsMutable();
      dependentShipmentTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All shipments with a type in the `dependent_shipment_types` field require
     * at least one shipment of type `required_shipment_type_alternatives` to be
     * visited on the same route.
     * NOTE: Chains of requirements such that a `shipment_type` depends on itself
     * are not allowed.
     * </pre>
     *
     * <code>repeated string dependent_shipment_types = 2;</code>
     *
     * @param values The dependentShipmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllDependentShipmentTypes(java.lang.Iterable<java.lang.String> values) {
      ensureDependentShipmentTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dependentShipmentTypes_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All shipments with a type in the `dependent_shipment_types` field require
     * at least one shipment of type `required_shipment_type_alternatives` to be
     * visited on the same route.
     * NOTE: Chains of requirements such that a `shipment_type` depends on itself
     * are not allowed.
     * </pre>
     *
     * <code>repeated string dependent_shipment_types = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDependentShipmentTypes() {
      dependentShipmentTypes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All shipments with a type in the `dependent_shipment_types` field require
     * at least one shipment of type `required_shipment_type_alternatives` to be
     * visited on the same route.
     * NOTE: Chains of requirements such that a `shipment_type` depends on itself
     * are not allowed.
     * </pre>
     *
     * <code>repeated string dependent_shipment_types = 2;</code>
     *
     * @param value The bytes of the dependentShipmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addDependentShipmentTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDependentShipmentTypesIsMutable();
      dependentShipmentTypes_.add(value);
      onChanged();
      return this;
    }

    private int requirementMode_ = 0;
    /**
     *
     *
     * <pre>
     * Mode applied to the requirement.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode requirement_mode = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for requirementMode.
     */
    @java.lang.Override
    public int getRequirementModeValue() {
      return requirementMode_;
    }
    /**
     *
     *
     * <pre>
     * Mode applied to the requirement.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode requirement_mode = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for requirementMode to set.
     * @return This builder for chaining.
     */
    public Builder setRequirementModeValue(int value) {

      requirementMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mode applied to the requirement.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode requirement_mode = 3;
     * </code>
     *
     * @return The requirementMode.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode
        getRequirementMode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode result =
          com.google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode.valueOf(
              requirementMode_);
      return result == null
          ? com.google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Mode applied to the requirement.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode requirement_mode = 3;
     * </code>
     *
     * @param value The requirementMode to set.
     * @return This builder for chaining.
     */
    public Builder setRequirementMode(
        com.google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      requirementMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mode applied to the requirement.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode requirement_mode = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequirementMode() {

      requirementMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentTypeRequirement)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentTypeRequirement)
  private static final com.google.cloud.optimization.v1.ShipmentTypeRequirement DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentTypeRequirement();
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeRequirement getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ShipmentTypeRequirement> PARSER =
      new com.google.protobuf.AbstractParser<ShipmentTypeRequirement>() {
        @java.lang.Override
        public ShipmentTypeRequirement parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ShipmentTypeRequirement> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ShipmentTypeRequirement> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentTypeRequirement getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
