/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Specifies incompatibilties between shipments depending on their
 * shipment_type. The appearance of incompatible shipments on the same route is
 * restricted based on the incompatibility mode.
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.ShipmentTypeIncompatibility}
 */
public final class ShipmentTypeIncompatibility extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentTypeIncompatibility)
    ShipmentTypeIncompatibilityOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ShipmentTypeIncompatibility.newBuilder() to construct.
  private ShipmentTypeIncompatibility(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ShipmentTypeIncompatibility() {
    types_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    incompatibilityMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ShipmentTypeIncompatibility();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_ShipmentTypeIncompatibility_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_ShipmentTypeIncompatibility_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.class,
            com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Modes defining how the appearance of incompatible shipments are restricted
   * on the same route.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode}
   */
  public enum IncompatibilityMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified incompatibility mode. This value should never be used.
     * </pre>
     *
     * <code>INCOMPATIBILITY_MODE_UNSPECIFIED = 0;</code>
     */
    INCOMPATIBILITY_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * In this mode, two shipments with incompatible types can never share the
     * same vehicle.
     * </pre>
     *
     * <code>NOT_PERFORMED_BY_SAME_VEHICLE = 1;</code>
     */
    NOT_PERFORMED_BY_SAME_VEHICLE(1),
    /**
     *
     *
     * <pre>
     * For two shipments with incompatible types with the
     * `NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY` incompatibility mode:
     * * If both are pickups only (no deliveries) or deliveries only (no
     *   pickups), they cannot share the same vehicle at all.
     * * If one of the shipments has a delivery and the other a pickup, the two
     *   shipments can share the same vehicle iff the former shipment is
     *   delivered before the latter is picked up.
     * </pre>
     *
     * <code>NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY = 2;</code>
     */
    NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified incompatibility mode. This value should never be used.
     * </pre>
     *
     * <code>INCOMPATIBILITY_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int INCOMPATIBILITY_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * In this mode, two shipments with incompatible types can never share the
     * same vehicle.
     * </pre>
     *
     * <code>NOT_PERFORMED_BY_SAME_VEHICLE = 1;</code>
     */
    public static final int NOT_PERFORMED_BY_SAME_VEHICLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * For two shipments with incompatible types with the
     * `NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY` incompatibility mode:
     * * If both are pickups only (no deliveries) or deliveries only (no
     *   pickups), they cannot share the same vehicle at all.
     * * If one of the shipments has a delivery and the other a pickup, the two
     *   shipments can share the same vehicle iff the former shipment is
     *   delivered before the latter is picked up.
     * </pre>
     *
     * <code>NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY = 2;</code>
     */
    public static final int NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IncompatibilityMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IncompatibilityMode forNumber(int value) {
      switch (value) {
        case 0:
          return INCOMPATIBILITY_MODE_UNSPECIFIED;
        case 1:
          return NOT_PERFORMED_BY_SAME_VEHICLE;
        case 2:
          return NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IncompatibilityMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IncompatibilityMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<IncompatibilityMode>() {
              public IncompatibilityMode findValueByNumber(int number) {
                return IncompatibilityMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final IncompatibilityMode[] VALUES = values();

    public static IncompatibilityMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IncompatibilityMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode)
  }

  public static final int TYPES_FIELD_NUMBER = 1;
  private com.google.protobuf.LazyStringList types_;
  /**
   *
   *
   * <pre>
   * List of incompatible types. Two shipments having different `shipment_types`
   * among those listed are "incompatible".
   * </pre>
   *
   * <code>repeated string types = 1;</code>
   *
   * @return A list containing the types.
   */
  public com.google.protobuf.ProtocolStringList getTypesList() {
    return types_;
  }
  /**
   *
   *
   * <pre>
   * List of incompatible types. Two shipments having different `shipment_types`
   * among those listed are "incompatible".
   * </pre>
   *
   * <code>repeated string types = 1;</code>
   *
   * @return The count of types.
   */
  public int getTypesCount() {
    return types_.size();
  }
  /**
   *
   *
   * <pre>
   * List of incompatible types. Two shipments having different `shipment_types`
   * among those listed are "incompatible".
   * </pre>
   *
   * <code>repeated string types = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The types at the given index.
   */
  public java.lang.String getTypes(int index) {
    return types_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of incompatible types. Two shipments having different `shipment_types`
   * among those listed are "incompatible".
   * </pre>
   *
   * <code>repeated string types = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the types at the given index.
   */
  public com.google.protobuf.ByteString getTypesBytes(int index) {
    return types_.getByteString(index);
  }

  public static final int INCOMPATIBILITY_MODE_FIELD_NUMBER = 2;
  private int incompatibilityMode_;
  /**
   *
   *
   * <pre>
   * Mode applied to the incompatibility.
   * </pre>
   *
   * <code>
   * .google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode incompatibility_mode = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for incompatibilityMode.
   */
  @java.lang.Override
  public int getIncompatibilityModeValue() {
    return incompatibilityMode_;
  }
  /**
   *
   *
   * <pre>
   * Mode applied to the incompatibility.
   * </pre>
   *
   * <code>
   * .google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode incompatibility_mode = 2;
   * </code>
   *
   * @return The incompatibilityMode.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode
      getIncompatibilityMode() {
    @SuppressWarnings("deprecation")
    com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode result =
        com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode.valueOf(
            incompatibilityMode_);
    return result == null
        ? com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode
            .UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < types_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, types_.getRaw(i));
    }
    if (incompatibilityMode_
        != com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode
            .INCOMPATIBILITY_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, incompatibilityMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < types_.size(); i++) {
        dataSize += computeStringSizeNoTag(types_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTypesList().size();
    }
    if (incompatibilityMode_
        != com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode
            .INCOMPATIBILITY_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, incompatibilityMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentTypeIncompatibility)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.ShipmentTypeIncompatibility other =
        (com.google.cloud.optimization.v1.ShipmentTypeIncompatibility) obj;

    if (!getTypesList().equals(other.getTypesList())) return false;
    if (incompatibilityMode_ != other.incompatibilityMode_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTypesCount() > 0) {
      hash = (37 * hash) + TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getTypesList().hashCode();
    }
    hash = (37 * hash) + INCOMPATIBILITY_MODE_FIELD_NUMBER;
    hash = (53 * hash) + incompatibilityMode_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.optimization.v1.ShipmentTypeIncompatibility prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies incompatibilties between shipments depending on their
   * shipment_type. The appearance of incompatible shipments on the same route is
   * restricted based on the incompatibility mode.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentTypeIncompatibility}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentTypeIncompatibility)
      com.google.cloud.optimization.v1.ShipmentTypeIncompatibilityOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentTypeIncompatibility_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentTypeIncompatibility_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.class,
              com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      types_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      incompatibilityMode_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentTypeIncompatibility_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentTypeIncompatibility
        getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentTypeIncompatibility build() {
      com.google.cloud.optimization.v1.ShipmentTypeIncompatibility result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentTypeIncompatibility buildPartial() {
      com.google.cloud.optimization.v1.ShipmentTypeIncompatibility result =
          new com.google.cloud.optimization.v1.ShipmentTypeIncompatibility(this);
      int from_bitField0_ = bitField0_;
      if (((bitField0_ & 0x00000001) != 0)) {
        types_ = types_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.types_ = types_;
      result.incompatibilityMode_ = incompatibilityMode_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.ShipmentTypeIncompatibility) {
        return mergeFrom((com.google.cloud.optimization.v1.ShipmentTypeIncompatibility) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.ShipmentTypeIncompatibility other) {
      if (other
          == com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.getDefaultInstance())
        return this;
      if (!other.types_.isEmpty()) {
        if (types_.isEmpty()) {
          types_ = other.types_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureTypesIsMutable();
          types_.addAll(other.types_);
        }
        onChanged();
      }
      if (other.incompatibilityMode_ != 0) {
        setIncompatibilityModeValue(other.getIncompatibilityModeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTypesIsMutable();
                types_.add(s);
                break;
              } // case 10
            case 16:
              {
                incompatibilityMode_ = input.readEnum();

                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringList types_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureTypesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        types_ = new com.google.protobuf.LazyStringArrayList(types_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * List of incompatible types. Two shipments having different `shipment_types`
     * among those listed are "incompatible".
     * </pre>
     *
     * <code>repeated string types = 1;</code>
     *
     * @return A list containing the types.
     */
    public com.google.protobuf.ProtocolStringList getTypesList() {
      return types_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * List of incompatible types. Two shipments having different `shipment_types`
     * among those listed are "incompatible".
     * </pre>
     *
     * <code>repeated string types = 1;</code>
     *
     * @return The count of types.
     */
    public int getTypesCount() {
      return types_.size();
    }
    /**
     *
     *
     * <pre>
     * List of incompatible types. Two shipments having different `shipment_types`
     * among those listed are "incompatible".
     * </pre>
     *
     * <code>repeated string types = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The types at the given index.
     */
    public java.lang.String getTypes(int index) {
      return types_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of incompatible types. Two shipments having different `shipment_types`
     * among those listed are "incompatible".
     * </pre>
     *
     * <code>repeated string types = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the types at the given index.
     */
    public com.google.protobuf.ByteString getTypesBytes(int index) {
      return types_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of incompatible types. Two shipments having different `shipment_types`
     * among those listed are "incompatible".
     * </pre>
     *
     * <code>repeated string types = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The types to set.
     * @return This builder for chaining.
     */
    public Builder setTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTypesIsMutable();
      types_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of incompatible types. Two shipments having different `shipment_types`
     * among those listed are "incompatible".
     * </pre>
     *
     * <code>repeated string types = 1;</code>
     *
     * @param value The types to add.
     * @return This builder for chaining.
     */
    public Builder addTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTypesIsMutable();
      types_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of incompatible types. Two shipments having different `shipment_types`
     * among those listed are "incompatible".
     * </pre>
     *
     * <code>repeated string types = 1;</code>
     *
     * @param values The types to add.
     * @return This builder for chaining.
     */
    public Builder addAllTypes(java.lang.Iterable<java.lang.String> values) {
      ensureTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, types_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of incompatible types. Two shipments having different `shipment_types`
     * among those listed are "incompatible".
     * </pre>
     *
     * <code>repeated string types = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTypes() {
      types_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of incompatible types. Two shipments having different `shipment_types`
     * among those listed are "incompatible".
     * </pre>
     *
     * <code>repeated string types = 1;</code>
     *
     * @param value The bytes of the types to add.
     * @return This builder for chaining.
     */
    public Builder addTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTypesIsMutable();
      types_.add(value);
      onChanged();
      return this;
    }

    private int incompatibilityMode_ = 0;
    /**
     *
     *
     * <pre>
     * Mode applied to the incompatibility.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode incompatibility_mode = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for incompatibilityMode.
     */
    @java.lang.Override
    public int getIncompatibilityModeValue() {
      return incompatibilityMode_;
    }
    /**
     *
     *
     * <pre>
     * Mode applied to the incompatibility.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode incompatibility_mode = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for incompatibilityMode to set.
     * @return This builder for chaining.
     */
    public Builder setIncompatibilityModeValue(int value) {

      incompatibilityMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mode applied to the incompatibility.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode incompatibility_mode = 2;
     * </code>
     *
     * @return The incompatibilityMode.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode
        getIncompatibilityMode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode result =
          com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode.valueOf(
              incompatibilityMode_);
      return result == null
          ? com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Mode applied to the incompatibility.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode incompatibility_mode = 2;
     * </code>
     *
     * @param value The incompatibilityMode to set.
     * @return This builder for chaining.
     */
    public Builder setIncompatibilityMode(
        com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      incompatibilityMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mode applied to the incompatibility.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode incompatibility_mode = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncompatibilityMode() {

      incompatibilityMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentTypeIncompatibility)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentTypeIncompatibility)
  private static final com.google.cloud.optimization.v1.ShipmentTypeIncompatibility
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentTypeIncompatibility();
  }

  public static com.google.cloud.optimization.v1.ShipmentTypeIncompatibility getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ShipmentTypeIncompatibility> PARSER =
      new com.google.protobuf.AbstractParser<ShipmentTypeIncompatibility>() {
        @java.lang.Override
        public ShipmentTypeIncompatibility parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ShipmentTypeIncompatibility> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ShipmentTypeIncompatibility> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentTypeIncompatibility getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
