/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * A vehicle's route can be decomposed, along the time axis, like this (we
 * assume there are n visits):
 * ```
 *   |            |            |          |       |  T[2], |        |      |
 *   | Transition |  Visit #0  |          |       |  V[2], |        |      |
 *   |     #0     |    aka     |   T[1]   |  V[1] |  ...   | V[n-1] | T[n] |
 *   |  aka T[0]  |    V[0]    |          |       | V[n-2],|        |      |
 *   |            |            |          |       | T[n-1] |        |      |
 *   ^            ^            ^          ^       ^        ^        ^      ^
 * vehicle    V[0].start   V[0].end     V[1].   V[1].    V[n].    V[n]. vehicle
 *  start     (arrival)   (departure)   start   end      start    end     end
 * ```
 * Note that we make a difference between:
 * * "punctual events", such as the vehicle start and end and each visit's start
 *   and end (aka arrival and departure). They happen at a given second.
 * * "time intervals", such as the visits themselves, and the transition between
 *   visits. Though time intervals can sometimes have zero duration, i.e. start
 *   and end at the same second, they often have a positive duration.
 * Invariants:
 * * If there are n visits, there are n+1 transitions.
 * * A visit is always surrounded by a transition before it (same index) and a
 *   transition after it (index + 1).
 * * The vehicle start is always followed by transition #0.
 * * The vehicle end is always preceded by transition #n.
 * Zooming in, here is what happens during a `Transition` and a `Visit`:
 * ```
 * ---+-------------------------------------+-----------------------------+--&gt;
 *    |           TRANSITION[i]             |           VISIT[i]          |
 *    |                                     |                             |
 *    |  * TRAVEL: the vehicle moves from   |      PERFORM the visit:     |
 *    |    VISIT[i-1].departure_location to |                             |
 *    |    VISIT[i].arrival_location, which |  * Spend some time:         |
 *    |    takes a given travel duration    |    the "visit duration".    |
 *    |    and distance                     |                             |
 *    |                                     |  * Load or unload           |
 *    |  * BREAKS: the driver may have      |    some quantities from the |
 *    |    breaks (e.g. lunch break).       |    vehicle: the "demand".   |
 *    |                                     |                             |
 *    |  * WAIT: the driver/vehicle does    |                             |
 *    |    nothing. This can happen for     |                             |
 *    |    many reasons, for example when   |                             |
 *    |    the vehicle reaches the next     |                             |
 *    |    event's destination before the   |                             |
 *    |    start of its time window         |                             |
 *    |                                     |                             |
 *    |  * DELAY: *right before* the next   |                             |
 *    |    arrival. E.g. the vehicle and/or |                             |
 *    |    driver spends time unloading.    |                             |
 *    |                                     |                             |
 * ---+-------------------------------------+-----------------------------+--&gt;
 *    ^                                     ^                             ^
 * V[i-1].end                           V[i].start                    V[i].end
 * ```
 * Lastly, here is how the TRAVEL, BREAKS, DELAY and WAIT can be arranged
 * during a transition.
 * * They don't overlap.
 * * The DELAY is unique and *must* be a contiguous period of time right
 *   before the next visit (or vehicle end). Thus, it suffice to know the
 *   delay duration to know its start and end time.
 * * The BREAKS are contiguous, non-overlapping periods of time. The
 *   response specifies the start time and duration of each break.
 * * TRAVEL and WAIT are "preemptable": they can be interrupted several times
 *   during this transition. Clients can assume that travel happens "as soon as
 *   possible" and that "wait" fills the remaining time.
 * A (complex) example:
 * ```
 *                                TRANSITION[i]
 * --++-----+-----------------------------------------------------------++--&gt;
 *   ||     |       |           |       |           |         |         ||
 *   ||  T  |   B   |     T     |       |     B     |         |    D    ||
 *   ||  r  |   r   |     r     |   W   |     r     |    W    |    e    ||
 *   ||  a  |   e   |     a     |   a   |     e     |    a    |    l    ||
 *   ||  v  |   a   |     v     |   i   |     a     |    i    |    a    ||
 *   ||  e  |   k   |     e     |   t   |     k     |    t    |    y    ||
 *   ||  l  |       |     l     |       |           |         |         ||
 *   ||     |       |           |       |           |         |         ||
 * --++-----------------------------------------------------------------++--&gt;
 * ```
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute}
 */
public final class ShipmentRoute extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentRoute)
    ShipmentRouteOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ShipmentRoute.newBuilder() to construct.
  private ShipmentRoute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ShipmentRoute() {
    vehicleLabel_ = "";
    visits_ = java.util.Collections.emptyList();
    transitions_ = java.util.Collections.emptyList();
    breaks_ = java.util.Collections.emptyList();
    endLoads_ = java.util.Collections.emptyList();
    travelSteps_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ShipmentRoute();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_ShipmentRoute_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 17:
        return internalGetRouteCosts();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_ShipmentRoute_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.ShipmentRoute.class,
            com.google.cloud.optimization.v1.ShipmentRoute.Builder.class);
  }

  @java.lang.Deprecated
  public interface DelayOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentRoute.Delay)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Start of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    boolean hasStartTime();
    /**
     *
     *
     * <pre>
     * Start of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    com.google.protobuf.Timestamp getStartTime();
    /**
     *
     *
     * <pre>
     * Start of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Duration of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     *
     * @return Whether the duration field is set.
     */
    boolean hasDuration();
    /**
     *
     *
     * <pre>
     * Duration of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     *
     * @return The duration.
     */
    com.google.protobuf.Duration getDuration();
    /**
     *
     *
     * <pre>
     * Duration of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     */
    com.google.protobuf.DurationOrBuilder getDurationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
   * Time interval spent on the route resulting from a
   * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.Delay}
   */
  @java.lang.Deprecated
  public static final class Delay extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentRoute.Delay)
      DelayOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Delay.newBuilder() to construct.
    private Delay(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Delay() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Delay();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_Delay_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_Delay_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentRoute.Delay.class,
              com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder.class);
    }

    public static final int START_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp startTime_;
    /**
     *
     *
     * <pre>
     * Start of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Start of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }
    /**
     *
     *
     * <pre>
     * Start of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      return getStartTime();
    }

    public static final int DURATION_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration duration_;
    /**
     *
     *
     * <pre>
     * Duration of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     *
     * @return Whether the duration field is set.
     */
    @java.lang.Override
    public boolean hasDuration() {
      return duration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Duration of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     *
     * @return The duration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getDuration() {
      return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
    }
    /**
     *
     *
     * <pre>
     * Duration of the delay.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      return getDuration();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (startTime_ != null) {
        output.writeMessage(1, getStartTime());
      }
      if (duration_ != null) {
        output.writeMessage(2, getDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (startTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
      }
      if (duration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentRoute.Delay)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.ShipmentRoute.Delay other =
          (com.google.cloud.optimization.v1.ShipmentRoute.Delay) obj;

      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime().equals(other.getStartTime())) return false;
      }
      if (hasDuration() != other.hasDuration()) return false;
      if (hasDuration()) {
        if (!getDuration().equals(other.getDuration())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      if (hasDuration()) {
        hash = (37 * hash) + DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.ShipmentRoute.Delay prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * Time interval spent on the route resulting from a
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.Delay}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentRoute.Delay)
        com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Delay_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Delay_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentRoute.Delay.class,
                com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.ShipmentRoute.Delay.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (startTimeBuilder_ == null) {
          startTime_ = null;
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }
        if (durationBuilder_ == null) {
          duration_ = null;
        } else {
          duration_ = null;
          durationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Delay_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Delay getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.ShipmentRoute.Delay.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Delay build() {
        com.google.cloud.optimization.v1.ShipmentRoute.Delay result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Delay buildPartial() {
        com.google.cloud.optimization.v1.ShipmentRoute.Delay result =
            new com.google.cloud.optimization.v1.ShipmentRoute.Delay(this);
        if (startTimeBuilder_ == null) {
          result.startTime_ = startTime_;
        } else {
          result.startTime_ = startTimeBuilder_.build();
        }
        if (durationBuilder_ == null) {
          result.duration_ = duration_;
        } else {
          result.duration_ = durationBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.ShipmentRoute.Delay) {
          return mergeFrom((com.google.cloud.optimization.v1.ShipmentRoute.Delay) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.ShipmentRoute.Delay other) {
        if (other == com.google.cloud.optimization.v1.ShipmentRoute.Delay.getDefaultInstance())
          return this;
        if (other.hasStartTime()) {
          mergeStartTime(other.getStartTime());
        }
        if (other.hasDuration()) {
          mergeDuration(other.getDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.protobuf.Timestamp startTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Start of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return Whether the startTime field is set.
       */
      public boolean hasStartTime() {
        return startTimeBuilder_ != null || startTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Start of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return The startTime.
       */
      public com.google.protobuf.Timestamp getStartTime() {
        if (startTimeBuilder_ == null) {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        } else {
          return startTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Start of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTime_ = value;
          onChanged();
        } else {
          startTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimeBuilder_ == null) {
          startTime_ = builderForValue.build();
          onChanged();
        } else {
          startTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (startTime_ != null) {
            startTime_ =
                com.google.protobuf.Timestamp.newBuilder(startTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            startTime_ = value;
          }
          onChanged();
        } else {
          startTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder clearStartTime() {
        if (startTimeBuilder_ == null) {
          startTime_ = null;
          onChanged();
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

        onChanged();
        return getStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Start of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        if (startTimeBuilder_ != null) {
          return startTimeBuilder_.getMessageOrBuilder();
        } else {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Start of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimeFieldBuilder() {
        if (startTimeBuilder_ == null) {
          startTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTime(), getParentForChildren(), isClean());
          startTime_ = null;
        }
        return startTimeBuilder_;
      }

      private com.google.protobuf.Duration duration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          durationBuilder_;
      /**
       *
       *
       * <pre>
       * Duration of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return Whether the duration field is set.
       */
      public boolean hasDuration() {
        return durationBuilder_ != null || duration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Duration of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return The duration.
       */
      public com.google.protobuf.Duration getDuration() {
        if (durationBuilder_ == null) {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        } else {
          return durationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          duration_ = value;
          onChanged();
        } else {
          durationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (durationBuilder_ == null) {
          duration_ = builderForValue.build();
          onChanged();
        } else {
          durationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public Builder mergeDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (duration_ != null) {
            duration_ =
                com.google.protobuf.Duration.newBuilder(duration_).mergeFrom(value).buildPartial();
          } else {
            duration_ = value;
          }
          onChanged();
        } else {
          durationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public Builder clearDuration() {
        if (durationBuilder_ == null) {
          duration_ = null;
          onChanged();
        } else {
          duration_ = null;
          durationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public com.google.protobuf.Duration.Builder getDurationBuilder() {

        onChanged();
        return getDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        if (durationBuilder_ != null) {
          return durationBuilder_.getMessageOrBuilder();
        } else {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of the delay.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getDurationFieldBuilder() {
        if (durationBuilder_ == null) {
          durationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getDuration(), getParentForChildren(), isClean());
          duration_ = null;
        }
        return durationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentRoute.Delay)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentRoute.Delay)
    private static final com.google.cloud.optimization.v1.ShipmentRoute.Delay DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentRoute.Delay();
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Delay getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Delay> PARSER =
        new com.google.protobuf.AbstractParser<Delay>() {
          @java.lang.Override
          public Delay parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Delay> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Delay> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.Delay getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VisitOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentRoute.Visit)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Index of the `shipments` field in the source [ShipmentModel][google.cloud.optimization.v1.ShipmentModel].
     * </pre>
     *
     * <code>int32 shipment_index = 1;</code>
     *
     * @return The shipmentIndex.
     */
    int getShipmentIndex();

    /**
     *
     *
     * <pre>
     * If true the visit corresponds to a pickup of a `Shipment`. Otherwise, it
     * corresponds to a delivery.
     * </pre>
     *
     * <code>bool is_pickup = 2;</code>
     *
     * @return The isPickup.
     */
    boolean getIsPickup();

    /**
     *
     *
     * <pre>
     * Index of `VisitRequest` in either the pickup or delivery field of the
     * `Shipment` (see `is_pickup`).
     * </pre>
     *
     * <code>int32 visit_request_index = 3;</code>
     *
     * @return The visitRequestIndex.
     */
    int getVisitRequestIndex();

    /**
     *
     *
     * <pre>
     * Time at which the visit starts. Note that the vehicle may arrive earlier
     * than this at the visit location. Times are consistent with the
     * `ShipmentModel`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return Whether the startTime field is set.
     */
    boolean hasStartTime();
    /**
     *
     *
     * <pre>
     * Time at which the visit starts. Note that the vehicle may arrive earlier
     * than this at the visit location. Times are consistent with the
     * `ShipmentModel`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return The startTime.
     */
    com.google.protobuf.Timestamp getStartTime();
    /**
     *
     *
     * <pre>
     * Time at which the visit starts. Note that the vehicle may arrive earlier
     * than this at the visit location. Times are consistent with the
     * `ShipmentModel`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Total visit load demand as the sum of the shipment and the visit request
     * `load_demands`. The values are negative if the visit is a delivery.
     * Demands are reported for the same types as the
     * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
     * (see this field).
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
     * </code>
     */
    int getLoadDemandsCount();
    /**
     *
     *
     * <pre>
     * Total visit load demand as the sum of the shipment and the visit request
     * `load_demands`. The values are negative if the visit is a delivery.
     * Demands are reported for the same types as the
     * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
     * (see this field).
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
     * </code>
     */
    boolean containsLoadDemands(java.lang.String key);
    /** Use {@link #getLoadDemandsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        getLoadDemands();
    /**
     *
     *
     * <pre>
     * Total visit load demand as the sum of the shipment and the visit request
     * `load_demands`. The values are negative if the visit is a delivery.
     * Demands are reported for the same types as the
     * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
     * (see this field).
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
     * </code>
     */
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        getLoadDemandsMap();
    /**
     *
     *
     * <pre>
     * Total visit load demand as the sum of the shipment and the visit request
     * `load_demands`. The values are negative if the visit is a delivery.
     * Demands are reported for the same types as the
     * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
     * (see this field).
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
     * </code>
     */

    /* nullable */
    com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.optimization.v1.Shipment.Load defaultValue);
    /**
     *
     *
     * <pre>
     * Total visit load demand as the sum of the shipment and the visit request
     * `load_demands`. The values are negative if the visit is a delivery.
     * Demands are reported for the same types as the
     * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
     * (see this field).
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
     * </code>
     */
    com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Extra detour time due to the shipments visited on the route before the
     * visit and to the potential waiting time induced by time windows.
     * If the visit is a delivery, the detour is computed from the corresponding
     * pickup visit and is equal to:
     * ```
     * start_time(delivery) - start_time(pickup)
     * - (duration(pickup) + travel duration from the pickup location
     * to the delivery location).
     * ```
     * Otherwise, it is computed from the vehicle `start_location` and is equal
     * to:
     * ```
     * start_time - vehicle_start_time - travel duration from
     * the vehicle's `start_location` to the visit.
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Duration detour = 6;</code>
     *
     * @return Whether the detour field is set.
     */
    boolean hasDetour();
    /**
     *
     *
     * <pre>
     * Extra detour time due to the shipments visited on the route before the
     * visit and to the potential waiting time induced by time windows.
     * If the visit is a delivery, the detour is computed from the corresponding
     * pickup visit and is equal to:
     * ```
     * start_time(delivery) - start_time(pickup)
     * - (duration(pickup) + travel duration from the pickup location
     * to the delivery location).
     * ```
     * Otherwise, it is computed from the vehicle `start_location` and is equal
     * to:
     * ```
     * start_time - vehicle_start_time - travel duration from
     * the vehicle's `start_location` to the visit.
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Duration detour = 6;</code>
     *
     * @return The detour.
     */
    com.google.protobuf.Duration getDetour();
    /**
     *
     *
     * <pre>
     * Extra detour time due to the shipments visited on the route before the
     * visit and to the potential waiting time induced by time windows.
     * If the visit is a delivery, the detour is computed from the corresponding
     * pickup visit and is equal to:
     * ```
     * start_time(delivery) - start_time(pickup)
     * - (duration(pickup) + travel duration from the pickup location
     * to the delivery location).
     * ```
     * Otherwise, it is computed from the vehicle `start_location` and is equal
     * to:
     * ```
     * start_time - vehicle_start_time - travel duration from
     * the vehicle's `start_location` to the visit.
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Duration detour = 6;</code>
     */
    com.google.protobuf.DurationOrBuilder getDetourOrBuilder();

    /**
     *
     *
     * <pre>
     * Copy of the corresponding `Shipment.label`, if specified in the
     * `Shipment`.
     * </pre>
     *
     * <code>string shipment_label = 7;</code>
     *
     * @return The shipmentLabel.
     */
    java.lang.String getShipmentLabel();
    /**
     *
     *
     * <pre>
     * Copy of the corresponding `Shipment.label`, if specified in the
     * `Shipment`.
     * </pre>
     *
     * <code>string shipment_label = 7;</code>
     *
     * @return The bytes for shipmentLabel.
     */
    com.google.protobuf.ByteString getShipmentLabelBytes();

    /**
     *
     *
     * <pre>
     * Copy of the corresponding
     * [VisitRequest.label][google.cloud.optimization.v1.Shipment.VisitRequest.label],
     * if specified in the `VisitRequest`.
     * </pre>
     *
     * <code>string visit_label = 8;</code>
     *
     * @return The visitLabel.
     */
    java.lang.String getVisitLabel();
    /**
     *
     *
     * <pre>
     * Copy of the corresponding
     * [VisitRequest.label][google.cloud.optimization.v1.Shipment.VisitRequest.label],
     * if specified in the `VisitRequest`.
     * </pre>
     *
     * <code>string visit_label = 8;</code>
     *
     * @return The bytes for visitLabel.
     */
    com.google.protobuf.ByteString getVisitLabelBytes();

    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at the visit location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
     * `end_load_intervals` or `demands`.
     * Exception: we omit loads for quantity types unconstrained by intervals
     * and that don't have any non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getArrivalLoadsList();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at the visit location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
     * `end_load_intervals` or `demands`.
     * Exception: we omit loads for quantity types unconstrained by intervals
     * and that don't have any non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.optimization.v1.CapacityQuantity getArrivalLoads(int index);
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at the visit location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
     * `end_load_intervals` or `demands`.
     * Exception: we omit loads for quantity types unconstrained by intervals
     * and that don't have any non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    int getArrivalLoadsCount();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at the visit location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
     * `end_load_intervals` or `demands`.
     * Exception: we omit loads for quantity types unconstrained by intervals
     * and that don't have any non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getArrivalLoadsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at the visit location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
     * `end_load_intervals` or `demands`.
     * Exception: we omit loads for quantity types unconstrained by intervals
     * and that don't have any non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getArrivalLoadsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.optimization.v1.ShipmentRoute.Visit.delay_before_start is
     *     deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=1824
     * @return Whether the delayBeforeStart field is set.
     */
    @java.lang.Deprecated
    boolean hasDelayBeforeStart();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.optimization.v1.ShipmentRoute.Visit.delay_before_start is
     *     deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=1824
     * @return The delayBeforeStart.
     */
    @java.lang.Deprecated
    com.google.cloud.optimization.v1.ShipmentRoute.Delay getDelayBeforeStart();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder getDelayBeforeStartOrBuilder();

    /**
     *
     *
     * <pre>
     * Deprecated: Use [Visit.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getDemandsList();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Visit.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.optimization.v1.CapacityQuantity getDemands(int index);
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Visit.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    int getDemandsCount();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Visit.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getDemandsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Visit.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getDemandsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A visit performed during a route. This visit corresponds to a pickup or a
   * delivery of a `Shipment`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.Visit}
   */
  public static final class Visit extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentRoute.Visit)
      VisitOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Visit.newBuilder() to construct.
    private Visit(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Visit() {
      shipmentLabel_ = "";
      visitLabel_ = "";
      arrivalLoads_ = java.util.Collections.emptyList();
      demands_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Visit();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_Visit_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 11:
          return internalGetLoadDemands();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_Visit_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentRoute.Visit.class,
              com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder.class);
    }

    public static final int SHIPMENT_INDEX_FIELD_NUMBER = 1;
    private int shipmentIndex_;
    /**
     *
     *
     * <pre>
     * Index of the `shipments` field in the source [ShipmentModel][google.cloud.optimization.v1.ShipmentModel].
     * </pre>
     *
     * <code>int32 shipment_index = 1;</code>
     *
     * @return The shipmentIndex.
     */
    @java.lang.Override
    public int getShipmentIndex() {
      return shipmentIndex_;
    }

    public static final int IS_PICKUP_FIELD_NUMBER = 2;
    private boolean isPickup_;
    /**
     *
     *
     * <pre>
     * If true the visit corresponds to a pickup of a `Shipment`. Otherwise, it
     * corresponds to a delivery.
     * </pre>
     *
     * <code>bool is_pickup = 2;</code>
     *
     * @return The isPickup.
     */
    @java.lang.Override
    public boolean getIsPickup() {
      return isPickup_;
    }

    public static final int VISIT_REQUEST_INDEX_FIELD_NUMBER = 3;
    private int visitRequestIndex_;
    /**
     *
     *
     * <pre>
     * Index of `VisitRequest` in either the pickup or delivery field of the
     * `Shipment` (see `is_pickup`).
     * </pre>
     *
     * <code>int32 visit_request_index = 3;</code>
     *
     * @return The visitRequestIndex.
     */
    @java.lang.Override
    public int getVisitRequestIndex() {
      return visitRequestIndex_;
    }

    public static final int START_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp startTime_;
    /**
     *
     *
     * <pre>
     * Time at which the visit starts. Note that the vehicle may arrive earlier
     * than this at the visit location. Times are consistent with the
     * `ShipmentModel`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time at which the visit starts. Note that the vehicle may arrive earlier
     * than this at the visit location. Times are consistent with the
     * `ShipmentModel`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }
    /**
     *
     *
     * <pre>
     * Time at which the visit starts. Note that the vehicle may arrive earlier
     * than this at the visit location. Times are consistent with the
     * `ShipmentModel`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      return getStartTime();
    }

    public static final int LOAD_DEMANDS_FIELD_NUMBER = 11;

    private static final class LoadDemandsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
                      newDefaultInstance(
                          com.google.cloud.optimization.v1.FleetRoutingProto
                              .internal_static_google_cloud_optimization_v1_ShipmentRoute_Visit_LoadDemandsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.optimization.v1.Shipment.Load.getDefaultInstance());
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        loadDemands_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        internalGetLoadDemands() {
      if (loadDemands_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            LoadDemandsDefaultEntryHolder.defaultEntry);
      }
      return loadDemands_;
    }

    public int getLoadDemandsCount() {
      return internalGetLoadDemands().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Total visit load demand as the sum of the shipment and the visit request
     * `load_demands`. The values are negative if the visit is a delivery.
     * Demands are reported for the same types as the
     * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
     * (see this field).
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
     * </code>
     */
    @java.lang.Override
    public boolean containsLoadDemands(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLoadDemands().getMap().containsKey(key);
    }
    /** Use {@link #getLoadDemandsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        getLoadDemands() {
      return getLoadDemandsMap();
    }
    /**
     *
     *
     * <pre>
     * Total visit load demand as the sum of the shipment and the visit request
     * `load_demands`. The values are negative if the visit is a delivery.
     * Demands are reported for the same types as the
     * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
     * (see this field).
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        getLoadDemandsMap() {
      return internalGetLoadDemands().getMap();
    }
    /**
     *
     *
     * <pre>
     * Total visit load demand as the sum of the shipment and the visit request
     * `load_demands`. The values are negative if the visit is a delivery.
     * Demands are reported for the same types as the
     * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
     * (see this field).
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrDefault(
        java.lang.String key, com.google.cloud.optimization.v1.Shipment.Load defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
          internalGetLoadDemands().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Total visit load demand as the sum of the shipment and the visit request
     * `load_demands`. The values are negative if the visit is a delivery.
     * Demands are reported for the same types as the
     * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
     * (see this field).
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
          internalGetLoadDemands().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int DETOUR_FIELD_NUMBER = 6;
    private com.google.protobuf.Duration detour_;
    /**
     *
     *
     * <pre>
     * Extra detour time due to the shipments visited on the route before the
     * visit and to the potential waiting time induced by time windows.
     * If the visit is a delivery, the detour is computed from the corresponding
     * pickup visit and is equal to:
     * ```
     * start_time(delivery) - start_time(pickup)
     * - (duration(pickup) + travel duration from the pickup location
     * to the delivery location).
     * ```
     * Otherwise, it is computed from the vehicle `start_location` and is equal
     * to:
     * ```
     * start_time - vehicle_start_time - travel duration from
     * the vehicle's `start_location` to the visit.
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Duration detour = 6;</code>
     *
     * @return Whether the detour field is set.
     */
    @java.lang.Override
    public boolean hasDetour() {
      return detour_ != null;
    }
    /**
     *
     *
     * <pre>
     * Extra detour time due to the shipments visited on the route before the
     * visit and to the potential waiting time induced by time windows.
     * If the visit is a delivery, the detour is computed from the corresponding
     * pickup visit and is equal to:
     * ```
     * start_time(delivery) - start_time(pickup)
     * - (duration(pickup) + travel duration from the pickup location
     * to the delivery location).
     * ```
     * Otherwise, it is computed from the vehicle `start_location` and is equal
     * to:
     * ```
     * start_time - vehicle_start_time - travel duration from
     * the vehicle's `start_location` to the visit.
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Duration detour = 6;</code>
     *
     * @return The detour.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getDetour() {
      return detour_ == null ? com.google.protobuf.Duration.getDefaultInstance() : detour_;
    }
    /**
     *
     *
     * <pre>
     * Extra detour time due to the shipments visited on the route before the
     * visit and to the potential waiting time induced by time windows.
     * If the visit is a delivery, the detour is computed from the corresponding
     * pickup visit and is equal to:
     * ```
     * start_time(delivery) - start_time(pickup)
     * - (duration(pickup) + travel duration from the pickup location
     * to the delivery location).
     * ```
     * Otherwise, it is computed from the vehicle `start_location` and is equal
     * to:
     * ```
     * start_time - vehicle_start_time - travel duration from
     * the vehicle's `start_location` to the visit.
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Duration detour = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getDetourOrBuilder() {
      return getDetour();
    }

    public static final int SHIPMENT_LABEL_FIELD_NUMBER = 7;
    private volatile java.lang.Object shipmentLabel_;
    /**
     *
     *
     * <pre>
     * Copy of the corresponding `Shipment.label`, if specified in the
     * `Shipment`.
     * </pre>
     *
     * <code>string shipment_label = 7;</code>
     *
     * @return The shipmentLabel.
     */
    @java.lang.Override
    public java.lang.String getShipmentLabel() {
      java.lang.Object ref = shipmentLabel_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        shipmentLabel_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Copy of the corresponding `Shipment.label`, if specified in the
     * `Shipment`.
     * </pre>
     *
     * <code>string shipment_label = 7;</code>
     *
     * @return The bytes for shipmentLabel.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getShipmentLabelBytes() {
      java.lang.Object ref = shipmentLabel_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        shipmentLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VISIT_LABEL_FIELD_NUMBER = 8;
    private volatile java.lang.Object visitLabel_;
    /**
     *
     *
     * <pre>
     * Copy of the corresponding
     * [VisitRequest.label][google.cloud.optimization.v1.Shipment.VisitRequest.label],
     * if specified in the `VisitRequest`.
     * </pre>
     *
     * <code>string visit_label = 8;</code>
     *
     * @return The visitLabel.
     */
    @java.lang.Override
    public java.lang.String getVisitLabel() {
      java.lang.Object ref = visitLabel_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        visitLabel_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Copy of the corresponding
     * [VisitRequest.label][google.cloud.optimization.v1.Shipment.VisitRequest.label],
     * if specified in the `VisitRequest`.
     * </pre>
     *
     * <code>string visit_label = 8;</code>
     *
     * @return The bytes for visitLabel.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVisitLabelBytes() {
      java.lang.Object ref = visitLabel_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        visitLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ARRIVAL_LOADS_FIELD_NUMBER = 9;
    private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> arrivalLoads_;
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at the visit location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
     * `end_load_intervals` or `demands`.
     * Exception: we omit loads for quantity types unconstrained by intervals
     * and that don't have any non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getArrivalLoadsList() {
      return arrivalLoads_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at the visit location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
     * `end_load_intervals` or `demands`.
     * Exception: we omit loads for quantity types unconstrained by intervals
     * and that don't have any non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getArrivalLoadsOrBuilderList() {
      return arrivalLoads_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at the visit location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
     * `end_load_intervals` or `demands`.
     * Exception: we omit loads for quantity types unconstrained by intervals
     * and that don't have any non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getArrivalLoadsCount() {
      return arrivalLoads_.size();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at the visit location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
     * `end_load_intervals` or `demands`.
     * Exception: we omit loads for quantity types unconstrained by intervals
     * and that don't have any non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity getArrivalLoads(int index) {
      return arrivalLoads_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at the visit location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
     * `end_load_intervals` or `demands`.
     * Exception: we omit loads for quantity types unconstrained by intervals
     * and that don't have any non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getArrivalLoadsOrBuilder(
        int index) {
      return arrivalLoads_.get(index);
    }

    public static final int DELAY_BEFORE_START_FIELD_NUMBER = 10;
    private com.google.cloud.optimization.v1.ShipmentRoute.Delay delayBeforeStart_;
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.optimization.v1.ShipmentRoute.Visit.delay_before_start is
     *     deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=1824
     * @return Whether the delayBeforeStart field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasDelayBeforeStart() {
      return delayBeforeStart_ != null;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.optimization.v1.ShipmentRoute.Visit.delay_before_start is
     *     deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=1824
     * @return The delayBeforeStart.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentRoute.Delay getDelayBeforeStart() {
      return delayBeforeStart_ == null
          ? com.google.cloud.optimization.v1.ShipmentRoute.Delay.getDefaultInstance()
          : delayBeforeStart_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder
        getDelayBeforeStartOrBuilder() {
      return getDelayBeforeStart();
    }

    public static final int DEMANDS_FIELD_NUMBER = 5;
    private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> demands_;
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Visit.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getDemandsList() {
      return demands_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Visit.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getDemandsOrBuilderList() {
      return demands_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Visit.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getDemandsCount() {
      return demands_.size();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Visit.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity getDemands(int index) {
      return demands_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Visit.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getDemandsOrBuilder(
        int index) {
      return demands_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (shipmentIndex_ != 0) {
        output.writeInt32(1, shipmentIndex_);
      }
      if (isPickup_ != false) {
        output.writeBool(2, isPickup_);
      }
      if (visitRequestIndex_ != 0) {
        output.writeInt32(3, visitRequestIndex_);
      }
      if (startTime_ != null) {
        output.writeMessage(4, getStartTime());
      }
      for (int i = 0; i < demands_.size(); i++) {
        output.writeMessage(5, demands_.get(i));
      }
      if (detour_ != null) {
        output.writeMessage(6, getDetour());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(shipmentLabel_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, shipmentLabel_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(visitLabel_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, visitLabel_);
      }
      for (int i = 0; i < arrivalLoads_.size(); i++) {
        output.writeMessage(9, arrivalLoads_.get(i));
      }
      if (delayBeforeStart_ != null) {
        output.writeMessage(10, getDelayBeforeStart());
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetLoadDemands(), LoadDemandsDefaultEntryHolder.defaultEntry, 11);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (shipmentIndex_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, shipmentIndex_);
      }
      if (isPickup_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, isPickup_);
      }
      if (visitRequestIndex_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, visitRequestIndex_);
      }
      if (startTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartTime());
      }
      for (int i = 0; i < demands_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, demands_.get(i));
      }
      if (detour_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDetour());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(shipmentLabel_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, shipmentLabel_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(visitLabel_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, visitLabel_);
      }
      for (int i = 0; i < arrivalLoads_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, arrivalLoads_.get(i));
      }
      if (delayBeforeStart_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDelayBeforeStart());
      }
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          entry : internalGetLoadDemands().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
            loadDemands__ =
                LoadDemandsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, loadDemands__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentRoute.Visit)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.ShipmentRoute.Visit other =
          (com.google.cloud.optimization.v1.ShipmentRoute.Visit) obj;

      if (getShipmentIndex() != other.getShipmentIndex()) return false;
      if (getIsPickup() != other.getIsPickup()) return false;
      if (getVisitRequestIndex() != other.getVisitRequestIndex()) return false;
      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime().equals(other.getStartTime())) return false;
      }
      if (!internalGetLoadDemands().equals(other.internalGetLoadDemands())) return false;
      if (hasDetour() != other.hasDetour()) return false;
      if (hasDetour()) {
        if (!getDetour().equals(other.getDetour())) return false;
      }
      if (!getShipmentLabel().equals(other.getShipmentLabel())) return false;
      if (!getVisitLabel().equals(other.getVisitLabel())) return false;
      if (!getArrivalLoadsList().equals(other.getArrivalLoadsList())) return false;
      if (hasDelayBeforeStart() != other.hasDelayBeforeStart()) return false;
      if (hasDelayBeforeStart()) {
        if (!getDelayBeforeStart().equals(other.getDelayBeforeStart())) return false;
      }
      if (!getDemandsList().equals(other.getDemandsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SHIPMENT_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getShipmentIndex();
      hash = (37 * hash) + IS_PICKUP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsPickup());
      hash = (37 * hash) + VISIT_REQUEST_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getVisitRequestIndex();
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      if (!internalGetLoadDemands().getMap().isEmpty()) {
        hash = (37 * hash) + LOAD_DEMANDS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetLoadDemands().hashCode();
      }
      if (hasDetour()) {
        hash = (37 * hash) + DETOUR_FIELD_NUMBER;
        hash = (53 * hash) + getDetour().hashCode();
      }
      hash = (37 * hash) + SHIPMENT_LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getShipmentLabel().hashCode();
      hash = (37 * hash) + VISIT_LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getVisitLabel().hashCode();
      if (getArrivalLoadsCount() > 0) {
        hash = (37 * hash) + ARRIVAL_LOADS_FIELD_NUMBER;
        hash = (53 * hash) + getArrivalLoadsList().hashCode();
      }
      if (hasDelayBeforeStart()) {
        hash = (37 * hash) + DELAY_BEFORE_START_FIELD_NUMBER;
        hash = (53 * hash) + getDelayBeforeStart().hashCode();
      }
      if (getDemandsCount() > 0) {
        hash = (37 * hash) + DEMANDS_FIELD_NUMBER;
        hash = (53 * hash) + getDemandsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.ShipmentRoute.Visit prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A visit performed during a route. This visit corresponds to a pickup or a
     * delivery of a `Shipment`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.Visit}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentRoute.Visit)
        com.google.cloud.optimization.v1.ShipmentRoute.VisitOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Visit_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 11:
            return internalGetLoadDemands();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 11:
            return internalGetMutableLoadDemands();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Visit_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentRoute.Visit.class,
                com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.ShipmentRoute.Visit.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        shipmentIndex_ = 0;

        isPickup_ = false;

        visitRequestIndex_ = 0;

        if (startTimeBuilder_ == null) {
          startTime_ = null;
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }
        internalGetMutableLoadDemands().clear();
        if (detourBuilder_ == null) {
          detour_ = null;
        } else {
          detour_ = null;
          detourBuilder_ = null;
        }
        shipmentLabel_ = "";

        visitLabel_ = "";

        if (arrivalLoadsBuilder_ == null) {
          arrivalLoads_ = java.util.Collections.emptyList();
        } else {
          arrivalLoads_ = null;
          arrivalLoadsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (delayBeforeStartBuilder_ == null) {
          delayBeforeStart_ = null;
        } else {
          delayBeforeStart_ = null;
          delayBeforeStartBuilder_ = null;
        }
        if (demandsBuilder_ == null) {
          demands_ = java.util.Collections.emptyList();
        } else {
          demands_ = null;
          demandsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Visit_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Visit getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.ShipmentRoute.Visit.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Visit build() {
        com.google.cloud.optimization.v1.ShipmentRoute.Visit result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Visit buildPartial() {
        com.google.cloud.optimization.v1.ShipmentRoute.Visit result =
            new com.google.cloud.optimization.v1.ShipmentRoute.Visit(this);
        int from_bitField0_ = bitField0_;
        result.shipmentIndex_ = shipmentIndex_;
        result.isPickup_ = isPickup_;
        result.visitRequestIndex_ = visitRequestIndex_;
        if (startTimeBuilder_ == null) {
          result.startTime_ = startTime_;
        } else {
          result.startTime_ = startTimeBuilder_.build();
        }
        result.loadDemands_ = internalGetLoadDemands();
        result.loadDemands_.makeImmutable();
        if (detourBuilder_ == null) {
          result.detour_ = detour_;
        } else {
          result.detour_ = detourBuilder_.build();
        }
        result.shipmentLabel_ = shipmentLabel_;
        result.visitLabel_ = visitLabel_;
        if (arrivalLoadsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            arrivalLoads_ = java.util.Collections.unmodifiableList(arrivalLoads_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.arrivalLoads_ = arrivalLoads_;
        } else {
          result.arrivalLoads_ = arrivalLoadsBuilder_.build();
        }
        if (delayBeforeStartBuilder_ == null) {
          result.delayBeforeStart_ = delayBeforeStart_;
        } else {
          result.delayBeforeStart_ = delayBeforeStartBuilder_.build();
        }
        if (demandsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            demands_ = java.util.Collections.unmodifiableList(demands_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.demands_ = demands_;
        } else {
          result.demands_ = demandsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.ShipmentRoute.Visit) {
          return mergeFrom((com.google.cloud.optimization.v1.ShipmentRoute.Visit) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.ShipmentRoute.Visit other) {
        if (other == com.google.cloud.optimization.v1.ShipmentRoute.Visit.getDefaultInstance())
          return this;
        if (other.getShipmentIndex() != 0) {
          setShipmentIndex(other.getShipmentIndex());
        }
        if (other.getIsPickup() != false) {
          setIsPickup(other.getIsPickup());
        }
        if (other.getVisitRequestIndex() != 0) {
          setVisitRequestIndex(other.getVisitRequestIndex());
        }
        if (other.hasStartTime()) {
          mergeStartTime(other.getStartTime());
        }
        internalGetMutableLoadDemands().mergeFrom(other.internalGetLoadDemands());
        if (other.hasDetour()) {
          mergeDetour(other.getDetour());
        }
        if (!other.getShipmentLabel().isEmpty()) {
          shipmentLabel_ = other.shipmentLabel_;
          onChanged();
        }
        if (!other.getVisitLabel().isEmpty()) {
          visitLabel_ = other.visitLabel_;
          onChanged();
        }
        if (arrivalLoadsBuilder_ == null) {
          if (!other.arrivalLoads_.isEmpty()) {
            if (arrivalLoads_.isEmpty()) {
              arrivalLoads_ = other.arrivalLoads_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureArrivalLoadsIsMutable();
              arrivalLoads_.addAll(other.arrivalLoads_);
            }
            onChanged();
          }
        } else {
          if (!other.arrivalLoads_.isEmpty()) {
            if (arrivalLoadsBuilder_.isEmpty()) {
              arrivalLoadsBuilder_.dispose();
              arrivalLoadsBuilder_ = null;
              arrivalLoads_ = other.arrivalLoads_;
              bitField0_ = (bitField0_ & ~0x00000002);
              arrivalLoadsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getArrivalLoadsFieldBuilder()
                      : null;
            } else {
              arrivalLoadsBuilder_.addAllMessages(other.arrivalLoads_);
            }
          }
        }
        if (other.hasDelayBeforeStart()) {
          mergeDelayBeforeStart(other.getDelayBeforeStart());
        }
        if (demandsBuilder_ == null) {
          if (!other.demands_.isEmpty()) {
            if (demands_.isEmpty()) {
              demands_ = other.demands_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureDemandsIsMutable();
              demands_.addAll(other.demands_);
            }
            onChanged();
          }
        } else {
          if (!other.demands_.isEmpty()) {
            if (demandsBuilder_.isEmpty()) {
              demandsBuilder_.dispose();
              demandsBuilder_ = null;
              demands_ = other.demands_;
              bitField0_ = (bitField0_ & ~0x00000004);
              demandsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDemandsFieldBuilder()
                      : null;
            } else {
              demandsBuilder_.addAllMessages(other.demands_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  shipmentIndex_ = input.readInt32();

                  break;
                } // case 8
              case 16:
                {
                  isPickup_ = input.readBool();

                  break;
                } // case 16
              case 24:
                {
                  visitRequestIndex_ = input.readInt32();

                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 34
              case 42:
                {
                  com.google.cloud.optimization.v1.CapacityQuantity m =
                      input.readMessage(
                          com.google.cloud.optimization.v1.CapacityQuantity.parser(),
                          extensionRegistry);
                  if (demandsBuilder_ == null) {
                    ensureDemandsIsMutable();
                    demands_.add(m);
                  } else {
                    demandsBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getDetourFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 50
              case 58:
                {
                  shipmentLabel_ = input.readStringRequireUtf8();

                  break;
                } // case 58
              case 66:
                {
                  visitLabel_ = input.readStringRequireUtf8();

                  break;
                } // case 66
              case 74:
                {
                  com.google.cloud.optimization.v1.CapacityQuantity m =
                      input.readMessage(
                          com.google.cloud.optimization.v1.CapacityQuantity.parser(),
                          extensionRegistry);
                  if (arrivalLoadsBuilder_ == null) {
                    ensureArrivalLoadsIsMutable();
                    arrivalLoads_.add(m);
                  } else {
                    arrivalLoadsBuilder_.addMessage(m);
                  }
                  break;
                } // case 74
              case 82:
                {
                  input.readMessage(
                      getDelayBeforeStartFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 82
              case 90:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
                      loadDemands__ =
                          input.readMessage(
                              LoadDemandsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableLoadDemands()
                      .getMutableMap()
                      .put(loadDemands__.getKey(), loadDemands__.getValue());
                  break;
                } // case 90
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int shipmentIndex_;
      /**
       *
       *
       * <pre>
       * Index of the `shipments` field in the source [ShipmentModel][google.cloud.optimization.v1.ShipmentModel].
       * </pre>
       *
       * <code>int32 shipment_index = 1;</code>
       *
       * @return The shipmentIndex.
       */
      @java.lang.Override
      public int getShipmentIndex() {
        return shipmentIndex_;
      }
      /**
       *
       *
       * <pre>
       * Index of the `shipments` field in the source [ShipmentModel][google.cloud.optimization.v1.ShipmentModel].
       * </pre>
       *
       * <code>int32 shipment_index = 1;</code>
       *
       * @param value The shipmentIndex to set.
       * @return This builder for chaining.
       */
      public Builder setShipmentIndex(int value) {

        shipmentIndex_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Index of the `shipments` field in the source [ShipmentModel][google.cloud.optimization.v1.ShipmentModel].
       * </pre>
       *
       * <code>int32 shipment_index = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearShipmentIndex() {

        shipmentIndex_ = 0;
        onChanged();
        return this;
      }

      private boolean isPickup_;
      /**
       *
       *
       * <pre>
       * If true the visit corresponds to a pickup of a `Shipment`. Otherwise, it
       * corresponds to a delivery.
       * </pre>
       *
       * <code>bool is_pickup = 2;</code>
       *
       * @return The isPickup.
       */
      @java.lang.Override
      public boolean getIsPickup() {
        return isPickup_;
      }
      /**
       *
       *
       * <pre>
       * If true the visit corresponds to a pickup of a `Shipment`. Otherwise, it
       * corresponds to a delivery.
       * </pre>
       *
       * <code>bool is_pickup = 2;</code>
       *
       * @param value The isPickup to set.
       * @return This builder for chaining.
       */
      public Builder setIsPickup(boolean value) {

        isPickup_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true the visit corresponds to a pickup of a `Shipment`. Otherwise, it
       * corresponds to a delivery.
       * </pre>
       *
       * <code>bool is_pickup = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsPickup() {

        isPickup_ = false;
        onChanged();
        return this;
      }

      private int visitRequestIndex_;
      /**
       *
       *
       * <pre>
       * Index of `VisitRequest` in either the pickup or delivery field of the
       * `Shipment` (see `is_pickup`).
       * </pre>
       *
       * <code>int32 visit_request_index = 3;</code>
       *
       * @return The visitRequestIndex.
       */
      @java.lang.Override
      public int getVisitRequestIndex() {
        return visitRequestIndex_;
      }
      /**
       *
       *
       * <pre>
       * Index of `VisitRequest` in either the pickup or delivery field of the
       * `Shipment` (see `is_pickup`).
       * </pre>
       *
       * <code>int32 visit_request_index = 3;</code>
       *
       * @param value The visitRequestIndex to set.
       * @return This builder for chaining.
       */
      public Builder setVisitRequestIndex(int value) {

        visitRequestIndex_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Index of `VisitRequest` in either the pickup or delivery field of the
       * `Shipment` (see `is_pickup`).
       * </pre>
       *
       * <code>int32 visit_request_index = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVisitRequestIndex() {

        visitRequestIndex_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp startTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Time at which the visit starts. Note that the vehicle may arrive earlier
       * than this at the visit location. Times are consistent with the
       * `ShipmentModel`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 4;</code>
       *
       * @return Whether the startTime field is set.
       */
      public boolean hasStartTime() {
        return startTimeBuilder_ != null || startTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Time at which the visit starts. Note that the vehicle may arrive earlier
       * than this at the visit location. Times are consistent with the
       * `ShipmentModel`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 4;</code>
       *
       * @return The startTime.
       */
      public com.google.protobuf.Timestamp getStartTime() {
        if (startTimeBuilder_ == null) {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        } else {
          return startTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Time at which the visit starts. Note that the vehicle may arrive earlier
       * than this at the visit location. Times are consistent with the
       * `ShipmentModel`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 4;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTime_ = value;
          onChanged();
        } else {
          startTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Time at which the visit starts. Note that the vehicle may arrive earlier
       * than this at the visit location. Times are consistent with the
       * `ShipmentModel`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 4;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimeBuilder_ == null) {
          startTime_ = builderForValue.build();
          onChanged();
        } else {
          startTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Time at which the visit starts. Note that the vehicle may arrive earlier
       * than this at the visit location. Times are consistent with the
       * `ShipmentModel`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 4;</code>
       */
      public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (startTime_ != null) {
            startTime_ =
                com.google.protobuf.Timestamp.newBuilder(startTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            startTime_ = value;
          }
          onChanged();
        } else {
          startTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Time at which the visit starts. Note that the vehicle may arrive earlier
       * than this at the visit location. Times are consistent with the
       * `ShipmentModel`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 4;</code>
       */
      public Builder clearStartTime() {
        if (startTimeBuilder_ == null) {
          startTime_ = null;
          onChanged();
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Time at which the visit starts. Note that the vehicle may arrive earlier
       * than this at the visit location. Times are consistent with the
       * `ShipmentModel`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

        onChanged();
        return getStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Time at which the visit starts. Note that the vehicle may arrive earlier
       * than this at the visit location. Times are consistent with the
       * `ShipmentModel`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 4;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        if (startTimeBuilder_ != null) {
          return startTimeBuilder_.getMessageOrBuilder();
        } else {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Time at which the visit starts. Note that the vehicle may arrive earlier
       * than this at the visit location. Times are consistent with the
       * `ShipmentModel`.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimeFieldBuilder() {
        if (startTimeBuilder_ == null) {
          startTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTime(), getParentForChildren(), isClean());
          startTime_ = null;
        }
        return startTimeBuilder_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          loadDemands_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          internalGetLoadDemands() {
        if (loadDemands_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              LoadDemandsDefaultEntryHolder.defaultEntry);
        }
        return loadDemands_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          internalGetMutableLoadDemands() {
        onChanged();
        ;
        if (loadDemands_ == null) {
          loadDemands_ =
              com.google.protobuf.MapField.newMapField(LoadDemandsDefaultEntryHolder.defaultEntry);
        }
        if (!loadDemands_.isMutable()) {
          loadDemands_ = loadDemands_.copy();
        }
        return loadDemands_;
      }

      public int getLoadDemandsCount() {
        return internalGetLoadDemands().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Total visit load demand as the sum of the shipment and the visit request
       * `load_demands`. The values are negative if the visit is a delivery.
       * Demands are reported for the same types as the
       * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
       * (see this field).
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
       * </code>
       */
      @java.lang.Override
      public boolean containsLoadDemands(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetLoadDemands().getMap().containsKey(key);
      }
      /** Use {@link #getLoadDemandsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          getLoadDemands() {
        return getLoadDemandsMap();
      }
      /**
       *
       *
       * <pre>
       * Total visit load demand as the sum of the shipment and the visit request
       * `load_demands`. The values are negative if the visit is a delivery.
       * Demands are reported for the same types as the
       * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
       * (see this field).
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          getLoadDemandsMap() {
        return internalGetLoadDemands().getMap();
      }
      /**
       *
       *
       * <pre>
       * Total visit load demand as the sum of the shipment and the visit request
       * `load_demands`. The values are negative if the visit is a delivery.
       * Demands are reported for the same types as the
       * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
       * (see this field).
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrDefault(
          java.lang.String key, com.google.cloud.optimization.v1.Shipment.Load defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
            internalGetLoadDemands().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Total visit load demand as the sum of the shipment and the visit request
       * `load_demands`. The values are negative if the visit is a delivery.
       * Demands are reported for the same types as the
       * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
       * (see this field).
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
            internalGetLoadDemands().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearLoadDemands() {
        internalGetMutableLoadDemands().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total visit load demand as the sum of the shipment and the visit request
       * `load_demands`. The values are negative if the visit is a delivery.
       * Demands are reported for the same types as the
       * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
       * (see this field).
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
       * </code>
       */
      public Builder removeLoadDemands(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableLoadDemands().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          getMutableLoadDemands() {
        return internalGetMutableLoadDemands().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Total visit load demand as the sum of the shipment and the visit request
       * `load_demands`. The values are negative if the visit is a delivery.
       * Demands are reported for the same types as the
       * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
       * (see this field).
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
       * </code>
       */
      public Builder putLoadDemands(
          java.lang.String key, com.google.cloud.optimization.v1.Shipment.Load value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableLoadDemands().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total visit load demand as the sum of the shipment and the visit request
       * `load_demands`. The values are negative if the visit is a delivery.
       * Demands are reported for the same types as the
       * [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
       * (see this field).
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 11;
       * </code>
       */
      public Builder putAllLoadDemands(
          java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> values) {
        internalGetMutableLoadDemands().getMutableMap().putAll(values);
        return this;
      }

      private com.google.protobuf.Duration detour_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          detourBuilder_;
      /**
       *
       *
       * <pre>
       * Extra detour time due to the shipments visited on the route before the
       * visit and to the potential waiting time induced by time windows.
       * If the visit is a delivery, the detour is computed from the corresponding
       * pickup visit and is equal to:
       * ```
       * start_time(delivery) - start_time(pickup)
       * - (duration(pickup) + travel duration from the pickup location
       * to the delivery location).
       * ```
       * Otherwise, it is computed from the vehicle `start_location` and is equal
       * to:
       * ```
       * start_time - vehicle_start_time - travel duration from
       * the vehicle's `start_location` to the visit.
       * ```
       * </pre>
       *
       * <code>.google.protobuf.Duration detour = 6;</code>
       *
       * @return Whether the detour field is set.
       */
      public boolean hasDetour() {
        return detourBuilder_ != null || detour_ != null;
      }
      /**
       *
       *
       * <pre>
       * Extra detour time due to the shipments visited on the route before the
       * visit and to the potential waiting time induced by time windows.
       * If the visit is a delivery, the detour is computed from the corresponding
       * pickup visit and is equal to:
       * ```
       * start_time(delivery) - start_time(pickup)
       * - (duration(pickup) + travel duration from the pickup location
       * to the delivery location).
       * ```
       * Otherwise, it is computed from the vehicle `start_location` and is equal
       * to:
       * ```
       * start_time - vehicle_start_time - travel duration from
       * the vehicle's `start_location` to the visit.
       * ```
       * </pre>
       *
       * <code>.google.protobuf.Duration detour = 6;</code>
       *
       * @return The detour.
       */
      public com.google.protobuf.Duration getDetour() {
        if (detourBuilder_ == null) {
          return detour_ == null ? com.google.protobuf.Duration.getDefaultInstance() : detour_;
        } else {
          return detourBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Extra detour time due to the shipments visited on the route before the
       * visit and to the potential waiting time induced by time windows.
       * If the visit is a delivery, the detour is computed from the corresponding
       * pickup visit and is equal to:
       * ```
       * start_time(delivery) - start_time(pickup)
       * - (duration(pickup) + travel duration from the pickup location
       * to the delivery location).
       * ```
       * Otherwise, it is computed from the vehicle `start_location` and is equal
       * to:
       * ```
       * start_time - vehicle_start_time - travel duration from
       * the vehicle's `start_location` to the visit.
       * ```
       * </pre>
       *
       * <code>.google.protobuf.Duration detour = 6;</code>
       */
      public Builder setDetour(com.google.protobuf.Duration value) {
        if (detourBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          detour_ = value;
          onChanged();
        } else {
          detourBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Extra detour time due to the shipments visited on the route before the
       * visit and to the potential waiting time induced by time windows.
       * If the visit is a delivery, the detour is computed from the corresponding
       * pickup visit and is equal to:
       * ```
       * start_time(delivery) - start_time(pickup)
       * - (duration(pickup) + travel duration from the pickup location
       * to the delivery location).
       * ```
       * Otherwise, it is computed from the vehicle `start_location` and is equal
       * to:
       * ```
       * start_time - vehicle_start_time - travel duration from
       * the vehicle's `start_location` to the visit.
       * ```
       * </pre>
       *
       * <code>.google.protobuf.Duration detour = 6;</code>
       */
      public Builder setDetour(com.google.protobuf.Duration.Builder builderForValue) {
        if (detourBuilder_ == null) {
          detour_ = builderForValue.build();
          onChanged();
        } else {
          detourBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Extra detour time due to the shipments visited on the route before the
       * visit and to the potential waiting time induced by time windows.
       * If the visit is a delivery, the detour is computed from the corresponding
       * pickup visit and is equal to:
       * ```
       * start_time(delivery) - start_time(pickup)
       * - (duration(pickup) + travel duration from the pickup location
       * to the delivery location).
       * ```
       * Otherwise, it is computed from the vehicle `start_location` and is equal
       * to:
       * ```
       * start_time - vehicle_start_time - travel duration from
       * the vehicle's `start_location` to the visit.
       * ```
       * </pre>
       *
       * <code>.google.protobuf.Duration detour = 6;</code>
       */
      public Builder mergeDetour(com.google.protobuf.Duration value) {
        if (detourBuilder_ == null) {
          if (detour_ != null) {
            detour_ =
                com.google.protobuf.Duration.newBuilder(detour_).mergeFrom(value).buildPartial();
          } else {
            detour_ = value;
          }
          onChanged();
        } else {
          detourBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Extra detour time due to the shipments visited on the route before the
       * visit and to the potential waiting time induced by time windows.
       * If the visit is a delivery, the detour is computed from the corresponding
       * pickup visit and is equal to:
       * ```
       * start_time(delivery) - start_time(pickup)
       * - (duration(pickup) + travel duration from the pickup location
       * to the delivery location).
       * ```
       * Otherwise, it is computed from the vehicle `start_location` and is equal
       * to:
       * ```
       * start_time - vehicle_start_time - travel duration from
       * the vehicle's `start_location` to the visit.
       * ```
       * </pre>
       *
       * <code>.google.protobuf.Duration detour = 6;</code>
       */
      public Builder clearDetour() {
        if (detourBuilder_ == null) {
          detour_ = null;
          onChanged();
        } else {
          detour_ = null;
          detourBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Extra detour time due to the shipments visited on the route before the
       * visit and to the potential waiting time induced by time windows.
       * If the visit is a delivery, the detour is computed from the corresponding
       * pickup visit and is equal to:
       * ```
       * start_time(delivery) - start_time(pickup)
       * - (duration(pickup) + travel duration from the pickup location
       * to the delivery location).
       * ```
       * Otherwise, it is computed from the vehicle `start_location` and is equal
       * to:
       * ```
       * start_time - vehicle_start_time - travel duration from
       * the vehicle's `start_location` to the visit.
       * ```
       * </pre>
       *
       * <code>.google.protobuf.Duration detour = 6;</code>
       */
      public com.google.protobuf.Duration.Builder getDetourBuilder() {

        onChanged();
        return getDetourFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Extra detour time due to the shipments visited on the route before the
       * visit and to the potential waiting time induced by time windows.
       * If the visit is a delivery, the detour is computed from the corresponding
       * pickup visit and is equal to:
       * ```
       * start_time(delivery) - start_time(pickup)
       * - (duration(pickup) + travel duration from the pickup location
       * to the delivery location).
       * ```
       * Otherwise, it is computed from the vehicle `start_location` and is equal
       * to:
       * ```
       * start_time - vehicle_start_time - travel duration from
       * the vehicle's `start_location` to the visit.
       * ```
       * </pre>
       *
       * <code>.google.protobuf.Duration detour = 6;</code>
       */
      public com.google.protobuf.DurationOrBuilder getDetourOrBuilder() {
        if (detourBuilder_ != null) {
          return detourBuilder_.getMessageOrBuilder();
        } else {
          return detour_ == null ? com.google.protobuf.Duration.getDefaultInstance() : detour_;
        }
      }
      /**
       *
       *
       * <pre>
       * Extra detour time due to the shipments visited on the route before the
       * visit and to the potential waiting time induced by time windows.
       * If the visit is a delivery, the detour is computed from the corresponding
       * pickup visit and is equal to:
       * ```
       * start_time(delivery) - start_time(pickup)
       * - (duration(pickup) + travel duration from the pickup location
       * to the delivery location).
       * ```
       * Otherwise, it is computed from the vehicle `start_location` and is equal
       * to:
       * ```
       * start_time - vehicle_start_time - travel duration from
       * the vehicle's `start_location` to the visit.
       * ```
       * </pre>
       *
       * <code>.google.protobuf.Duration detour = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getDetourFieldBuilder() {
        if (detourBuilder_ == null) {
          detourBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getDetour(), getParentForChildren(), isClean());
          detour_ = null;
        }
        return detourBuilder_;
      }

      private java.lang.Object shipmentLabel_ = "";
      /**
       *
       *
       * <pre>
       * Copy of the corresponding `Shipment.label`, if specified in the
       * `Shipment`.
       * </pre>
       *
       * <code>string shipment_label = 7;</code>
       *
       * @return The shipmentLabel.
       */
      public java.lang.String getShipmentLabel() {
        java.lang.Object ref = shipmentLabel_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          shipmentLabel_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Copy of the corresponding `Shipment.label`, if specified in the
       * `Shipment`.
       * </pre>
       *
       * <code>string shipment_label = 7;</code>
       *
       * @return The bytes for shipmentLabel.
       */
      public com.google.protobuf.ByteString getShipmentLabelBytes() {
        java.lang.Object ref = shipmentLabel_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          shipmentLabel_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Copy of the corresponding `Shipment.label`, if specified in the
       * `Shipment`.
       * </pre>
       *
       * <code>string shipment_label = 7;</code>
       *
       * @param value The shipmentLabel to set.
       * @return This builder for chaining.
       */
      public Builder setShipmentLabel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        shipmentLabel_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Copy of the corresponding `Shipment.label`, if specified in the
       * `Shipment`.
       * </pre>
       *
       * <code>string shipment_label = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearShipmentLabel() {

        shipmentLabel_ = getDefaultInstance().getShipmentLabel();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Copy of the corresponding `Shipment.label`, if specified in the
       * `Shipment`.
       * </pre>
       *
       * <code>string shipment_label = 7;</code>
       *
       * @param value The bytes for shipmentLabel to set.
       * @return This builder for chaining.
       */
      public Builder setShipmentLabelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        shipmentLabel_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object visitLabel_ = "";
      /**
       *
       *
       * <pre>
       * Copy of the corresponding
       * [VisitRequest.label][google.cloud.optimization.v1.Shipment.VisitRequest.label],
       * if specified in the `VisitRequest`.
       * </pre>
       *
       * <code>string visit_label = 8;</code>
       *
       * @return The visitLabel.
       */
      public java.lang.String getVisitLabel() {
        java.lang.Object ref = visitLabel_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          visitLabel_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Copy of the corresponding
       * [VisitRequest.label][google.cloud.optimization.v1.Shipment.VisitRequest.label],
       * if specified in the `VisitRequest`.
       * </pre>
       *
       * <code>string visit_label = 8;</code>
       *
       * @return The bytes for visitLabel.
       */
      public com.google.protobuf.ByteString getVisitLabelBytes() {
        java.lang.Object ref = visitLabel_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          visitLabel_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Copy of the corresponding
       * [VisitRequest.label][google.cloud.optimization.v1.Shipment.VisitRequest.label],
       * if specified in the `VisitRequest`.
       * </pre>
       *
       * <code>string visit_label = 8;</code>
       *
       * @param value The visitLabel to set.
       * @return This builder for chaining.
       */
      public Builder setVisitLabel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        visitLabel_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Copy of the corresponding
       * [VisitRequest.label][google.cloud.optimization.v1.Shipment.VisitRequest.label],
       * if specified in the `VisitRequest`.
       * </pre>
       *
       * <code>string visit_label = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVisitLabel() {

        visitLabel_ = getDefaultInstance().getVisitLabel();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Copy of the corresponding
       * [VisitRequest.label][google.cloud.optimization.v1.Shipment.VisitRequest.label],
       * if specified in the `VisitRequest`.
       * </pre>
       *
       * <code>string visit_label = 8;</code>
       *
       * @param value The bytes for visitLabel to set.
       * @return This builder for chaining.
       */
      public Builder setVisitLabelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        visitLabel_ = value;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> arrivalLoads_ =
          java.util.Collections.emptyList();

      private void ensureArrivalLoadsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          arrivalLoads_ =
              new java.util.ArrayList<com.google.cloud.optimization.v1.CapacityQuantity>(
                  arrivalLoads_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.CapacityQuantity,
              com.google.cloud.optimization.v1.CapacityQuantity.Builder,
              com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          arrivalLoadsBuilder_;

      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity>
          getArrivalLoadsList() {
        if (arrivalLoadsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(arrivalLoads_);
        } else {
          return arrivalLoadsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public int getArrivalLoadsCount() {
        if (arrivalLoadsBuilder_ == null) {
          return arrivalLoads_.size();
        } else {
          return arrivalLoadsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity getArrivalLoads(int index) {
        if (arrivalLoadsBuilder_ == null) {
          return arrivalLoads_.get(index);
        } else {
          return arrivalLoadsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setArrivalLoads(
          int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (arrivalLoadsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArrivalLoadsIsMutable();
          arrivalLoads_.set(index, value);
          onChanged();
        } else {
          arrivalLoadsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setArrivalLoads(
          int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (arrivalLoadsBuilder_ == null) {
          ensureArrivalLoadsIsMutable();
          arrivalLoads_.set(index, builderForValue.build());
          onChanged();
        } else {
          arrivalLoadsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addArrivalLoads(com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (arrivalLoadsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArrivalLoadsIsMutable();
          arrivalLoads_.add(value);
          onChanged();
        } else {
          arrivalLoadsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addArrivalLoads(
          int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (arrivalLoadsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArrivalLoadsIsMutable();
          arrivalLoads_.add(index, value);
          onChanged();
        } else {
          arrivalLoadsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addArrivalLoads(
          com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (arrivalLoadsBuilder_ == null) {
          ensureArrivalLoadsIsMutable();
          arrivalLoads_.add(builderForValue.build());
          onChanged();
        } else {
          arrivalLoadsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addArrivalLoads(
          int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (arrivalLoadsBuilder_ == null) {
          ensureArrivalLoadsIsMutable();
          arrivalLoads_.add(index, builderForValue.build());
          onChanged();
        } else {
          arrivalLoadsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAllArrivalLoads(
          java.lang.Iterable<? extends com.google.cloud.optimization.v1.CapacityQuantity> values) {
        if (arrivalLoadsBuilder_ == null) {
          ensureArrivalLoadsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, arrivalLoads_);
          onChanged();
        } else {
          arrivalLoadsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder clearArrivalLoads() {
        if (arrivalLoadsBuilder_ == null) {
          arrivalLoads_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          arrivalLoadsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder removeArrivalLoads(int index) {
        if (arrivalLoadsBuilder_ == null) {
          ensureArrivalLoadsIsMutable();
          arrivalLoads_.remove(index);
          onChanged();
        } else {
          arrivalLoadsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder getArrivalLoadsBuilder(
          int index) {
        return getArrivalLoadsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getArrivalLoadsOrBuilder(
          int index) {
        if (arrivalLoadsBuilder_ == null) {
          return arrivalLoads_.get(index);
        } else {
          return arrivalLoadsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          getArrivalLoadsOrBuilderList() {
        if (arrivalLoadsBuilder_ != null) {
          return arrivalLoadsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(arrivalLoads_);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder addArrivalLoadsBuilder() {
        return getArrivalLoadsFieldBuilder()
            .addBuilder(com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder addArrivalLoadsBuilder(
          int index) {
        return getArrivalLoadsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
       * Vehicle loads upon arrival at the visit location, for each
       * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities], `start_load_intervals`,
       * `end_load_intervals` or `demands`.
       * Exception: we omit loads for quantity types unconstrained by intervals
       * and that don't have any non-zero demand on the route.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity arrival_loads = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity.Builder>
          getArrivalLoadsBuilderList() {
        return getArrivalLoadsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.CapacityQuantity,
              com.google.cloud.optimization.v1.CapacityQuantity.Builder,
              com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          getArrivalLoadsFieldBuilder() {
        if (arrivalLoadsBuilder_ == null) {
          arrivalLoadsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.optimization.v1.CapacityQuantity,
                  com.google.cloud.optimization.v1.CapacityQuantity.Builder,
                  com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>(
                  arrivalLoads_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          arrivalLoads_ = null;
        }
        return arrivalLoadsBuilder_;
      }

      private com.google.cloud.optimization.v1.ShipmentRoute.Delay delayBeforeStart_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentRoute.Delay,
              com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder,
              com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder>
          delayBeforeStartBuilder_;
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.optimization.v1.ShipmentRoute.Visit.delay_before_start is
       *     deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=1824
       * @return Whether the delayBeforeStart field is set.
       */
      @java.lang.Deprecated
      public boolean hasDelayBeforeStart() {
        return delayBeforeStartBuilder_ != null || delayBeforeStart_ != null;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.optimization.v1.ShipmentRoute.Visit.delay_before_start is
       *     deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=1824
       * @return The delayBeforeStart.
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.ShipmentRoute.Delay getDelayBeforeStart() {
        if (delayBeforeStartBuilder_ == null) {
          return delayBeforeStart_ == null
              ? com.google.cloud.optimization.v1.ShipmentRoute.Delay.getDefaultInstance()
              : delayBeforeStart_;
        } else {
          return delayBeforeStartBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setDelayBeforeStart(
          com.google.cloud.optimization.v1.ShipmentRoute.Delay value) {
        if (delayBeforeStartBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          delayBeforeStart_ = value;
          onChanged();
        } else {
          delayBeforeStartBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setDelayBeforeStart(
          com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder builderForValue) {
        if (delayBeforeStartBuilder_ == null) {
          delayBeforeStart_ = builderForValue.build();
          onChanged();
        } else {
          delayBeforeStartBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder mergeDelayBeforeStart(
          com.google.cloud.optimization.v1.ShipmentRoute.Delay value) {
        if (delayBeforeStartBuilder_ == null) {
          if (delayBeforeStart_ != null) {
            delayBeforeStart_ =
                com.google.cloud.optimization.v1.ShipmentRoute.Delay.newBuilder(delayBeforeStart_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            delayBeforeStart_ = value;
          }
          onChanged();
        } else {
          delayBeforeStartBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder clearDelayBeforeStart() {
        if (delayBeforeStartBuilder_ == null) {
          delayBeforeStart_ = null;
          onChanged();
        } else {
          delayBeforeStart_ = null;
          delayBeforeStartBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder
          getDelayBeforeStartBuilder() {

        onChanged();
        return getDelayBeforeStartFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder
          getDelayBeforeStartOrBuilder() {
        if (delayBeforeStartBuilder_ != null) {
          return delayBeforeStartBuilder_.getMessageOrBuilder();
        } else {
          return delayBeforeStart_ == null
              ? com.google.cloud.optimization.v1.ShipmentRoute.Delay.getDefaultInstance()
              : delayBeforeStart_;
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_start = 10 [deprecated = true];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentRoute.Delay,
              com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder,
              com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder>
          getDelayBeforeStartFieldBuilder() {
        if (delayBeforeStartBuilder_ == null) {
          delayBeforeStartBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.optimization.v1.ShipmentRoute.Delay,
                  com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder,
                  com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder>(
                  getDelayBeforeStart(), getParentForChildren(), isClean());
          delayBeforeStart_ = null;
        }
        return delayBeforeStartBuilder_;
      }

      private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> demands_ =
          java.util.Collections.emptyList();

      private void ensureDemandsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          demands_ =
              new java.util.ArrayList<com.google.cloud.optimization.v1.CapacityQuantity>(demands_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.CapacityQuantity,
              com.google.cloud.optimization.v1.CapacityQuantity.Builder,
              com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          demandsBuilder_;

      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getDemandsList() {
        if (demandsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(demands_);
        } else {
          return demandsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public int getDemandsCount() {
        if (demandsBuilder_ == null) {
          return demands_.size();
        } else {
          return demandsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity getDemands(int index) {
        if (demandsBuilder_ == null) {
          return demands_.get(index);
        } else {
          return demandsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setDemands(
          int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (demandsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDemandsIsMutable();
          demands_.set(index, value);
          onChanged();
        } else {
          demandsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setDemands(
          int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (demandsBuilder_ == null) {
          ensureDemandsIsMutable();
          demands_.set(index, builderForValue.build());
          onChanged();
        } else {
          demandsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addDemands(com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (demandsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDemandsIsMutable();
          demands_.add(value);
          onChanged();
        } else {
          demandsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addDemands(
          int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (demandsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDemandsIsMutable();
          demands_.add(index, value);
          onChanged();
        } else {
          demandsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addDemands(
          com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (demandsBuilder_ == null) {
          ensureDemandsIsMutable();
          demands_.add(builderForValue.build());
          onChanged();
        } else {
          demandsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addDemands(
          int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (demandsBuilder_ == null) {
          ensureDemandsIsMutable();
          demands_.add(index, builderForValue.build());
          onChanged();
        } else {
          demandsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAllDemands(
          java.lang.Iterable<? extends com.google.cloud.optimization.v1.CapacityQuantity> values) {
        if (demandsBuilder_ == null) {
          ensureDemandsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, demands_);
          onChanged();
        } else {
          demandsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder clearDemands() {
        if (demandsBuilder_ == null) {
          demands_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          demandsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder removeDemands(int index) {
        if (demandsBuilder_ == null) {
          ensureDemandsIsMutable();
          demands_.remove(index);
          onChanged();
        } else {
          demandsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder getDemandsBuilder(
          int index) {
        return getDemandsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getDemandsOrBuilder(
          int index) {
        if (demandsBuilder_ == null) {
          return demands_.get(index);
        } else {
          return demandsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          getDemandsOrBuilderList() {
        if (demandsBuilder_ != null) {
          return demandsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(demands_);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder addDemandsBuilder() {
        return getDemandsFieldBuilder()
            .addBuilder(com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder addDemandsBuilder(
          int index) {
        return getDemandsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Visit.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity.Builder>
          getDemandsBuilderList() {
        return getDemandsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.CapacityQuantity,
              com.google.cloud.optimization.v1.CapacityQuantity.Builder,
              com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          getDemandsFieldBuilder() {
        if (demandsBuilder_ == null) {
          demandsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.optimization.v1.CapacityQuantity,
                  com.google.cloud.optimization.v1.CapacityQuantity.Builder,
                  com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>(
                  demands_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
          demands_ = null;
        }
        return demandsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentRoute.Visit)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentRoute.Visit)
    private static final com.google.cloud.optimization.v1.ShipmentRoute.Visit DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentRoute.Visit();
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Visit getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Visit> PARSER =
        new com.google.protobuf.AbstractParser<Visit>() {
          @java.lang.Override
          public Visit parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Visit> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Visit> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.Visit getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TransitionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentRoute.Transition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Travel duration during this transition.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 1;</code>
     *
     * @return Whether the travelDuration field is set.
     */
    boolean hasTravelDuration();
    /**
     *
     *
     * <pre>
     * Travel duration during this transition.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 1;</code>
     *
     * @return The travelDuration.
     */
    com.google.protobuf.Duration getTravelDuration();
    /**
     *
     *
     * <pre>
     * Travel duration during this transition.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 1;</code>
     */
    com.google.protobuf.DurationOrBuilder getTravelDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Distance traveled during the transition.
     * </pre>
     *
     * <code>double travel_distance_meters = 2;</code>
     *
     * @return The travelDistanceMeters.
     */
    double getTravelDistanceMeters();

    /**
     *
     *
     * <pre>
     * When traffic is requested via
     * [OptimizeToursRequest.consider_road_traffic]
     * [google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
     * and the traffic info couldn't be retrieved for a `Transition`, this
     * boolean is set to true. This may be temporary (rare hiccup in the
     * realtime traffic servers) or permanent (no data for this location).
     * </pre>
     *
     * <code>bool traffic_info_unavailable = 3;</code>
     *
     * @return The trafficInfoUnavailable.
     */
    boolean getTrafficInfoUnavailable();

    /**
     *
     *
     * <pre>
     * Sum of the delay durations applied to this transition. If any, the delay
     * starts exactly `delay_duration` seconds before the next event (visit or
     * vehicle end). See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     *
     * @return Whether the delayDuration field is set.
     */
    boolean hasDelayDuration();
    /**
     *
     *
     * <pre>
     * Sum of the delay durations applied to this transition. If any, the delay
     * starts exactly `delay_duration` seconds before the next event (visit or
     * vehicle end). See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     *
     * @return The delayDuration.
     */
    com.google.protobuf.Duration getDelayDuration();
    /**
     *
     *
     * <pre>
     * Sum of the delay durations applied to this transition. If any, the delay
     * starts exactly `delay_duration` seconds before the next event (visit or
     * vehicle end). See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     */
    com.google.protobuf.DurationOrBuilder getDelayDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Sum of the duration of the breaks occurring during this transition, if
     * any. Details about each break's start time and duration are stored in
     * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     *
     * @return Whether the breakDuration field is set.
     */
    boolean hasBreakDuration();
    /**
     *
     *
     * <pre>
     * Sum of the duration of the breaks occurring during this transition, if
     * any. Details about each break's start time and duration are stored in
     * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     *
     * @return The breakDuration.
     */
    com.google.protobuf.Duration getBreakDuration();
    /**
     *
     *
     * <pre>
     * Sum of the duration of the breaks occurring during this transition, if
     * any. Details about each break's start time and duration are stored in
     * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     */
    com.google.protobuf.DurationOrBuilder getBreakDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Time spent waiting during this transition. Wait duration corresponds to
     * idle time and does not include break time. Also note that this wait time
     * may be split into several non-contiguous intervals.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 6;</code>
     *
     * @return Whether the waitDuration field is set.
     */
    boolean hasWaitDuration();
    /**
     *
     *
     * <pre>
     * Time spent waiting during this transition. Wait duration corresponds to
     * idle time and does not include break time. Also note that this wait time
     * may be split into several non-contiguous intervals.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 6;</code>
     *
     * @return The waitDuration.
     */
    com.google.protobuf.Duration getWaitDuration();
    /**
     *
     *
     * <pre>
     * Time spent waiting during this transition. Wait duration corresponds to
     * idle time and does not include break time. Also note that this wait time
     * may be split into several non-contiguous intervals.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 6;</code>
     */
    com.google.protobuf.DurationOrBuilder getWaitDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Total duration of the transition, provided for convenience. It is equal
     * to:
     * * next visit `start_time` (or `vehicle_end_time` if this is the last
     * transition) - this transition's `start_time`;
     * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
     * additionally holds: `total_duration = travel_duration + delay_duration
     * + break_duration + wait_duration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     *
     * @return Whether the totalDuration field is set.
     */
    boolean hasTotalDuration();
    /**
     *
     *
     * <pre>
     * Total duration of the transition, provided for convenience. It is equal
     * to:
     * * next visit `start_time` (or `vehicle_end_time` if this is the last
     * transition) - this transition's `start_time`;
     * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
     * additionally holds: `total_duration = travel_duration + delay_duration
     * + break_duration + wait_duration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     *
     * @return The totalDuration.
     */
    com.google.protobuf.Duration getTotalDuration();
    /**
     *
     *
     * <pre>
     * Total duration of the transition, provided for convenience. It is equal
     * to:
     * * next visit `start_time` (or `vehicle_end_time` if this is the last
     * transition) - this transition's `start_time`;
     * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
     * additionally holds: `total_duration = travel_duration + delay_duration
     * + break_duration + wait_duration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     */
    com.google.protobuf.DurationOrBuilder getTotalDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Start time of this transition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     *
     * @return Whether the startTime field is set.
     */
    boolean hasStartTime();
    /**
     *
     *
     * <pre>
     * Start time of this transition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     *
     * @return The startTime.
     */
    com.google.protobuf.Timestamp getStartTime();
    /**
     *
     *
     * <pre>
     * Start time of this transition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * transition.
     * This field is only populated if [populate_transition_polylines]
     * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;</code>
     *
     * @return Whether the routePolyline field is set.
     */
    boolean hasRoutePolyline();
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * transition.
     * This field is only populated if [populate_transition_polylines]
     * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;</code>
     *
     * @return The routePolyline.
     */
    com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline getRoutePolyline();
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * transition.
     * This field is only populated if [populate_transition_polylines]
     * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;</code>
     */
    com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder
        getRoutePolylineOrBuilder();

    /**
     *
     *
     * <pre>
     * Vehicle loads during this transition, for each type that either appears
     * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
     * The loads during the first transition are the starting loads of the
     * vehicle route. Then, after each visit, the visit's `load_demands` are
     * either added or subtracted to get the next transition's loads, depending
     * on whether the visit was a pickup or a delivery.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
     * </code>
     */
    int getVehicleLoadsCount();
    /**
     *
     *
     * <pre>
     * Vehicle loads during this transition, for each type that either appears
     * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
     * The loads during the first transition are the starting loads of the
     * vehicle route. Then, after each visit, the visit's `load_demands` are
     * either added or subtracted to get the next transition's loads, depending
     * on whether the visit was a pickup or a delivery.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
     * </code>
     */
    boolean containsVehicleLoads(java.lang.String key);
    /** Use {@link #getVehicleLoadsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        getVehicleLoads();
    /**
     *
     *
     * <pre>
     * Vehicle loads during this transition, for each type that either appears
     * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
     * The loads during the first transition are the starting loads of the
     * vehicle route. Then, after each visit, the visit's `load_demands` are
     * either added or subtracted to get the next transition's loads, depending
     * on whether the visit was a pickup or a delivery.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
     * </code>
     */
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        getVehicleLoadsMap();
    /**
     *
     *
     * <pre>
     * Vehicle loads during this transition, for each type that either appears
     * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
     * The loads during the first transition are the starting loads of the
     * vehicle route. Then, after each visit, the visit's `load_demands` are
     * either added or subtracted to get the next transition's loads, depending
     * on whether the visit was a pickup or a delivery.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
     * </code>
     */

    /* nullable */
    com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getVehicleLoadsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad defaultValue);
    /**
     *
     *
     * <pre>
     * Vehicle loads during this transition, for each type that either appears
     * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
     * The loads during the first transition are the starting loads of the
     * vehicle route. Then, after each visit, the visit's `load_demands` are
     * either added or subtracted to get the next transition's loads, depending
     * on whether the visit was a pickup or a delivery.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
     * </code>
     */
    com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getVehicleLoadsOrThrow(
        java.lang.String key);

    /**
     *
     *
     * <pre>
     * Deprecated: Use [Transition.vehicle_loads][] instead.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getLoadsList();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Transition.vehicle_loads][] instead.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.optimization.v1.CapacityQuantity getLoads(int index);
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Transition.vehicle_loads][] instead.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    int getLoadsCount();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Transition.vehicle_loads][] instead.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getLoadsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Transition.vehicle_loads][] instead.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getLoadsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Transition between two events on the route. See the description of
   * [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
   * If the vehicle does not have a `start_location` and/or `end_location`, the
   * corresponding travel metrics are 0.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.Transition}
   */
  public static final class Transition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentRoute.Transition)
      TransitionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Transition.newBuilder() to construct.
    private Transition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Transition() {
      loads_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Transition();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_Transition_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 11:
          return internalGetVehicleLoads();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_Transition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentRoute.Transition.class,
              com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder.class);
    }

    public static final int TRAVEL_DURATION_FIELD_NUMBER = 1;
    private com.google.protobuf.Duration travelDuration_;
    /**
     *
     *
     * <pre>
     * Travel duration during this transition.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 1;</code>
     *
     * @return Whether the travelDuration field is set.
     */
    @java.lang.Override
    public boolean hasTravelDuration() {
      return travelDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Travel duration during this transition.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 1;</code>
     *
     * @return The travelDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTravelDuration() {
      return travelDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : travelDuration_;
    }
    /**
     *
     *
     * <pre>
     * Travel duration during this transition.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTravelDurationOrBuilder() {
      return getTravelDuration();
    }

    public static final int TRAVEL_DISTANCE_METERS_FIELD_NUMBER = 2;
    private double travelDistanceMeters_;
    /**
     *
     *
     * <pre>
     * Distance traveled during the transition.
     * </pre>
     *
     * <code>double travel_distance_meters = 2;</code>
     *
     * @return The travelDistanceMeters.
     */
    @java.lang.Override
    public double getTravelDistanceMeters() {
      return travelDistanceMeters_;
    }

    public static final int TRAFFIC_INFO_UNAVAILABLE_FIELD_NUMBER = 3;
    private boolean trafficInfoUnavailable_;
    /**
     *
     *
     * <pre>
     * When traffic is requested via
     * [OptimizeToursRequest.consider_road_traffic]
     * [google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
     * and the traffic info couldn't be retrieved for a `Transition`, this
     * boolean is set to true. This may be temporary (rare hiccup in the
     * realtime traffic servers) or permanent (no data for this location).
     * </pre>
     *
     * <code>bool traffic_info_unavailable = 3;</code>
     *
     * @return The trafficInfoUnavailable.
     */
    @java.lang.Override
    public boolean getTrafficInfoUnavailable() {
      return trafficInfoUnavailable_;
    }

    public static final int DELAY_DURATION_FIELD_NUMBER = 4;
    private com.google.protobuf.Duration delayDuration_;
    /**
     *
     *
     * <pre>
     * Sum of the delay durations applied to this transition. If any, the delay
     * starts exactly `delay_duration` seconds before the next event (visit or
     * vehicle end). See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     *
     * @return Whether the delayDuration field is set.
     */
    @java.lang.Override
    public boolean hasDelayDuration() {
      return delayDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Sum of the delay durations applied to this transition. If any, the delay
     * starts exactly `delay_duration` seconds before the next event (visit or
     * vehicle end). See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     *
     * @return The delayDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getDelayDuration() {
      return delayDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : delayDuration_;
    }
    /**
     *
     *
     * <pre>
     * Sum of the delay durations applied to this transition. If any, the delay
     * starts exactly `delay_duration` seconds before the next event (visit or
     * vehicle end). See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getDelayDurationOrBuilder() {
      return getDelayDuration();
    }

    public static final int BREAK_DURATION_FIELD_NUMBER = 5;
    private com.google.protobuf.Duration breakDuration_;
    /**
     *
     *
     * <pre>
     * Sum of the duration of the breaks occurring during this transition, if
     * any. Details about each break's start time and duration are stored in
     * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     *
     * @return Whether the breakDuration field is set.
     */
    @java.lang.Override
    public boolean hasBreakDuration() {
      return breakDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Sum of the duration of the breaks occurring during this transition, if
     * any. Details about each break's start time and duration are stored in
     * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     *
     * @return The breakDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getBreakDuration() {
      return breakDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : breakDuration_;
    }
    /**
     *
     *
     * <pre>
     * Sum of the duration of the breaks occurring during this transition, if
     * any. Details about each break's start time and duration are stored in
     * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getBreakDurationOrBuilder() {
      return getBreakDuration();
    }

    public static final int WAIT_DURATION_FIELD_NUMBER = 6;
    private com.google.protobuf.Duration waitDuration_;
    /**
     *
     *
     * <pre>
     * Time spent waiting during this transition. Wait duration corresponds to
     * idle time and does not include break time. Also note that this wait time
     * may be split into several non-contiguous intervals.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 6;</code>
     *
     * @return Whether the waitDuration field is set.
     */
    @java.lang.Override
    public boolean hasWaitDuration() {
      return waitDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time spent waiting during this transition. Wait duration corresponds to
     * idle time and does not include break time. Also note that this wait time
     * may be split into several non-contiguous intervals.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 6;</code>
     *
     * @return The waitDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getWaitDuration() {
      return waitDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : waitDuration_;
    }
    /**
     *
     *
     * <pre>
     * Time spent waiting during this transition. Wait duration corresponds to
     * idle time and does not include break time. Also note that this wait time
     * may be split into several non-contiguous intervals.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getWaitDurationOrBuilder() {
      return getWaitDuration();
    }

    public static final int TOTAL_DURATION_FIELD_NUMBER = 7;
    private com.google.protobuf.Duration totalDuration_;
    /**
     *
     *
     * <pre>
     * Total duration of the transition, provided for convenience. It is equal
     * to:
     * * next visit `start_time` (or `vehicle_end_time` if this is the last
     * transition) - this transition's `start_time`;
     * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
     * additionally holds: `total_duration = travel_duration + delay_duration
     * + break_duration + wait_duration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     *
     * @return Whether the totalDuration field is set.
     */
    @java.lang.Override
    public boolean hasTotalDuration() {
      return totalDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Total duration of the transition, provided for convenience. It is equal
     * to:
     * * next visit `start_time` (or `vehicle_end_time` if this is the last
     * transition) - this transition's `start_time`;
     * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
     * additionally holds: `total_duration = travel_duration + delay_duration
     * + break_duration + wait_duration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     *
     * @return The totalDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTotalDuration() {
      return totalDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : totalDuration_;
    }
    /**
     *
     *
     * <pre>
     * Total duration of the transition, provided for convenience. It is equal
     * to:
     * * next visit `start_time` (or `vehicle_end_time` if this is the last
     * transition) - this transition's `start_time`;
     * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
     * additionally holds: `total_duration = travel_duration + delay_duration
     * + break_duration + wait_duration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTotalDurationOrBuilder() {
      return getTotalDuration();
    }

    public static final int START_TIME_FIELD_NUMBER = 8;
    private com.google.protobuf.Timestamp startTime_;
    /**
     *
     *
     * <pre>
     * Start time of this transition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Start time of this transition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }
    /**
     *
     *
     * <pre>
     * Start time of this transition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      return getStartTime();
    }

    public static final int ROUTE_POLYLINE_FIELD_NUMBER = 9;
    private com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline routePolyline_;
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * transition.
     * This field is only populated if [populate_transition_polylines]
     * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;</code>
     *
     * @return Whether the routePolyline field is set.
     */
    @java.lang.Override
    public boolean hasRoutePolyline() {
      return routePolyline_ != null;
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * transition.
     * This field is only populated if [populate_transition_polylines]
     * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;</code>
     *
     * @return The routePolyline.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline getRoutePolyline() {
      return routePolyline_ == null
          ? com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.getDefaultInstance()
          : routePolyline_;
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * transition.
     * This field is only populated if [populate_transition_polylines]
     * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder
        getRoutePolylineOrBuilder() {
      return getRoutePolyline();
    }

    public static final int VEHICLE_LOADS_FIELD_NUMBER = 11;

    private static final class VehicleLoadsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
                      newDefaultInstance(
                          com.google.cloud.optimization.v1.FleetRoutingProto
                              .internal_static_google_cloud_optimization_v1_ShipmentRoute_Transition_VehicleLoadsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad
                              .getDefaultInstance());
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        vehicleLoads_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        internalGetVehicleLoads() {
      if (vehicleLoads_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            VehicleLoadsDefaultEntryHolder.defaultEntry);
      }
      return vehicleLoads_;
    }

    public int getVehicleLoadsCount() {
      return internalGetVehicleLoads().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Vehicle loads during this transition, for each type that either appears
     * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
     * The loads during the first transition are the starting loads of the
     * vehicle route. Then, after each visit, the visit's `load_demands` are
     * either added or subtracted to get the next transition's loads, depending
     * on whether the visit was a pickup or a delivery.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
     * </code>
     */
    @java.lang.Override
    public boolean containsVehicleLoads(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetVehicleLoads().getMap().containsKey(key);
    }
    /** Use {@link #getVehicleLoadsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        getVehicleLoads() {
      return getVehicleLoadsMap();
    }
    /**
     *
     *
     * <pre>
     * Vehicle loads during this transition, for each type that either appears
     * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
     * The loads during the first transition are the starting loads of the
     * vehicle route. Then, after each visit, the visit's `load_demands` are
     * either added or subtracted to get the next transition's loads, depending
     * on whether the visit was a pickup or a delivery.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        getVehicleLoadsMap() {
      return internalGetVehicleLoads().getMap();
    }
    /**
     *
     *
     * <pre>
     * Vehicle loads during this transition, for each type that either appears
     * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
     * The loads during the first transition are the starting loads of the
     * vehicle route. Then, after each visit, the visit's `load_demands` are
     * either added or subtracted to get the next transition's loads, depending
     * on whether the visit was a pickup or a delivery.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getVehicleLoadsOrDefault(
        java.lang.String key,
        com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          map = internalGetVehicleLoads().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Vehicle loads during this transition, for each type that either appears
     * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
     * The loads during the first transition are the starting loads of the
     * vehicle route. Then, after each visit, the visit's `load_demands` are
     * either added or subtracted to get the next transition's loads, depending
     * on whether the visit was a pickup or a delivery.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getVehicleLoadsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          map = internalGetVehicleLoads().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int LOADS_FIELD_NUMBER = 10;
    private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> loads_;
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Transition.vehicle_loads][] instead.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getLoadsList() {
      return loads_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Transition.vehicle_loads][] instead.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getLoadsOrBuilderList() {
      return loads_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Transition.vehicle_loads][] instead.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getLoadsCount() {
      return loads_.size();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Transition.vehicle_loads][] instead.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity getLoads(int index) {
      return loads_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Transition.vehicle_loads][] instead.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getLoadsOrBuilder(int index) {
      return loads_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (travelDuration_ != null) {
        output.writeMessage(1, getTravelDuration());
      }
      if (java.lang.Double.doubleToRawLongBits(travelDistanceMeters_) != 0) {
        output.writeDouble(2, travelDistanceMeters_);
      }
      if (trafficInfoUnavailable_ != false) {
        output.writeBool(3, trafficInfoUnavailable_);
      }
      if (delayDuration_ != null) {
        output.writeMessage(4, getDelayDuration());
      }
      if (breakDuration_ != null) {
        output.writeMessage(5, getBreakDuration());
      }
      if (waitDuration_ != null) {
        output.writeMessage(6, getWaitDuration());
      }
      if (totalDuration_ != null) {
        output.writeMessage(7, getTotalDuration());
      }
      if (startTime_ != null) {
        output.writeMessage(8, getStartTime());
      }
      if (routePolyline_ != null) {
        output.writeMessage(9, getRoutePolyline());
      }
      for (int i = 0; i < loads_.size(); i++) {
        output.writeMessage(10, loads_.get(i));
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetVehicleLoads(), VehicleLoadsDefaultEntryHolder.defaultEntry, 11);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (travelDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTravelDuration());
      }
      if (java.lang.Double.doubleToRawLongBits(travelDistanceMeters_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, travelDistanceMeters_);
      }
      if (trafficInfoUnavailable_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, trafficInfoUnavailable_);
      }
      if (delayDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDelayDuration());
      }
      if (breakDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getBreakDuration());
      }
      if (waitDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getWaitDuration());
      }
      if (totalDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTotalDuration());
      }
      if (startTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getStartTime());
      }
      if (routePolyline_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getRoutePolyline());
      }
      for (int i = 0; i < loads_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, loads_.get(i));
      }
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          entry : internalGetVehicleLoads().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
            vehicleLoads__ =
                VehicleLoadsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, vehicleLoads__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentRoute.Transition)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.ShipmentRoute.Transition other =
          (com.google.cloud.optimization.v1.ShipmentRoute.Transition) obj;

      if (hasTravelDuration() != other.hasTravelDuration()) return false;
      if (hasTravelDuration()) {
        if (!getTravelDuration().equals(other.getTravelDuration())) return false;
      }
      if (java.lang.Double.doubleToLongBits(getTravelDistanceMeters())
          != java.lang.Double.doubleToLongBits(other.getTravelDistanceMeters())) return false;
      if (getTrafficInfoUnavailable() != other.getTrafficInfoUnavailable()) return false;
      if (hasDelayDuration() != other.hasDelayDuration()) return false;
      if (hasDelayDuration()) {
        if (!getDelayDuration().equals(other.getDelayDuration())) return false;
      }
      if (hasBreakDuration() != other.hasBreakDuration()) return false;
      if (hasBreakDuration()) {
        if (!getBreakDuration().equals(other.getBreakDuration())) return false;
      }
      if (hasWaitDuration() != other.hasWaitDuration()) return false;
      if (hasWaitDuration()) {
        if (!getWaitDuration().equals(other.getWaitDuration())) return false;
      }
      if (hasTotalDuration() != other.hasTotalDuration()) return false;
      if (hasTotalDuration()) {
        if (!getTotalDuration().equals(other.getTotalDuration())) return false;
      }
      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime().equals(other.getStartTime())) return false;
      }
      if (hasRoutePolyline() != other.hasRoutePolyline()) return false;
      if (hasRoutePolyline()) {
        if (!getRoutePolyline().equals(other.getRoutePolyline())) return false;
      }
      if (!internalGetVehicleLoads().equals(other.internalGetVehicleLoads())) return false;
      if (!getLoadsList().equals(other.getLoadsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTravelDuration()) {
        hash = (37 * hash) + TRAVEL_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getTravelDuration().hashCode();
      }
      hash = (37 * hash) + TRAVEL_DISTANCE_METERS_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getTravelDistanceMeters()));
      hash = (37 * hash) + TRAFFIC_INFO_UNAVAILABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTrafficInfoUnavailable());
      if (hasDelayDuration()) {
        hash = (37 * hash) + DELAY_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getDelayDuration().hashCode();
      }
      if (hasBreakDuration()) {
        hash = (37 * hash) + BREAK_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getBreakDuration().hashCode();
      }
      if (hasWaitDuration()) {
        hash = (37 * hash) + WAIT_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getWaitDuration().hashCode();
      }
      if (hasTotalDuration()) {
        hash = (37 * hash) + TOTAL_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getTotalDuration().hashCode();
      }
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      if (hasRoutePolyline()) {
        hash = (37 * hash) + ROUTE_POLYLINE_FIELD_NUMBER;
        hash = (53 * hash) + getRoutePolyline().hashCode();
      }
      if (!internalGetVehicleLoads().getMap().isEmpty()) {
        hash = (37 * hash) + VEHICLE_LOADS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetVehicleLoads().hashCode();
      }
      if (getLoadsCount() > 0) {
        hash = (37 * hash) + LOADS_FIELD_NUMBER;
        hash = (53 * hash) + getLoadsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.ShipmentRoute.Transition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Transition between two events on the route. See the description of
     * [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
     * If the vehicle does not have a `start_location` and/or `end_location`, the
     * corresponding travel metrics are 0.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.Transition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentRoute.Transition)
        com.google.cloud.optimization.v1.ShipmentRoute.TransitionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Transition_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 11:
            return internalGetVehicleLoads();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 11:
            return internalGetMutableVehicleLoads();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Transition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentRoute.Transition.class,
                com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.ShipmentRoute.Transition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (travelDurationBuilder_ == null) {
          travelDuration_ = null;
        } else {
          travelDuration_ = null;
          travelDurationBuilder_ = null;
        }
        travelDistanceMeters_ = 0D;

        trafficInfoUnavailable_ = false;

        if (delayDurationBuilder_ == null) {
          delayDuration_ = null;
        } else {
          delayDuration_ = null;
          delayDurationBuilder_ = null;
        }
        if (breakDurationBuilder_ == null) {
          breakDuration_ = null;
        } else {
          breakDuration_ = null;
          breakDurationBuilder_ = null;
        }
        if (waitDurationBuilder_ == null) {
          waitDuration_ = null;
        } else {
          waitDuration_ = null;
          waitDurationBuilder_ = null;
        }
        if (totalDurationBuilder_ == null) {
          totalDuration_ = null;
        } else {
          totalDuration_ = null;
          totalDurationBuilder_ = null;
        }
        if (startTimeBuilder_ == null) {
          startTime_ = null;
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }
        if (routePolylineBuilder_ == null) {
          routePolyline_ = null;
        } else {
          routePolyline_ = null;
          routePolylineBuilder_ = null;
        }
        internalGetMutableVehicleLoads().clear();
        if (loadsBuilder_ == null) {
          loads_ = java.util.Collections.emptyList();
        } else {
          loads_ = null;
          loadsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Transition_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Transition getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.ShipmentRoute.Transition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Transition build() {
        com.google.cloud.optimization.v1.ShipmentRoute.Transition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Transition buildPartial() {
        com.google.cloud.optimization.v1.ShipmentRoute.Transition result =
            new com.google.cloud.optimization.v1.ShipmentRoute.Transition(this);
        int from_bitField0_ = bitField0_;
        if (travelDurationBuilder_ == null) {
          result.travelDuration_ = travelDuration_;
        } else {
          result.travelDuration_ = travelDurationBuilder_.build();
        }
        result.travelDistanceMeters_ = travelDistanceMeters_;
        result.trafficInfoUnavailable_ = trafficInfoUnavailable_;
        if (delayDurationBuilder_ == null) {
          result.delayDuration_ = delayDuration_;
        } else {
          result.delayDuration_ = delayDurationBuilder_.build();
        }
        if (breakDurationBuilder_ == null) {
          result.breakDuration_ = breakDuration_;
        } else {
          result.breakDuration_ = breakDurationBuilder_.build();
        }
        if (waitDurationBuilder_ == null) {
          result.waitDuration_ = waitDuration_;
        } else {
          result.waitDuration_ = waitDurationBuilder_.build();
        }
        if (totalDurationBuilder_ == null) {
          result.totalDuration_ = totalDuration_;
        } else {
          result.totalDuration_ = totalDurationBuilder_.build();
        }
        if (startTimeBuilder_ == null) {
          result.startTime_ = startTime_;
        } else {
          result.startTime_ = startTimeBuilder_.build();
        }
        if (routePolylineBuilder_ == null) {
          result.routePolyline_ = routePolyline_;
        } else {
          result.routePolyline_ = routePolylineBuilder_.build();
        }
        result.vehicleLoads_ = internalGetVehicleLoads();
        result.vehicleLoads_.makeImmutable();
        if (loadsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            loads_ = java.util.Collections.unmodifiableList(loads_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.loads_ = loads_;
        } else {
          result.loads_ = loadsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.ShipmentRoute.Transition) {
          return mergeFrom((com.google.cloud.optimization.v1.ShipmentRoute.Transition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.ShipmentRoute.Transition other) {
        if (other == com.google.cloud.optimization.v1.ShipmentRoute.Transition.getDefaultInstance())
          return this;
        if (other.hasTravelDuration()) {
          mergeTravelDuration(other.getTravelDuration());
        }
        if (other.getTravelDistanceMeters() != 0D) {
          setTravelDistanceMeters(other.getTravelDistanceMeters());
        }
        if (other.getTrafficInfoUnavailable() != false) {
          setTrafficInfoUnavailable(other.getTrafficInfoUnavailable());
        }
        if (other.hasDelayDuration()) {
          mergeDelayDuration(other.getDelayDuration());
        }
        if (other.hasBreakDuration()) {
          mergeBreakDuration(other.getBreakDuration());
        }
        if (other.hasWaitDuration()) {
          mergeWaitDuration(other.getWaitDuration());
        }
        if (other.hasTotalDuration()) {
          mergeTotalDuration(other.getTotalDuration());
        }
        if (other.hasStartTime()) {
          mergeStartTime(other.getStartTime());
        }
        if (other.hasRoutePolyline()) {
          mergeRoutePolyline(other.getRoutePolyline());
        }
        internalGetMutableVehicleLoads().mergeFrom(other.internalGetVehicleLoads());
        if (loadsBuilder_ == null) {
          if (!other.loads_.isEmpty()) {
            if (loads_.isEmpty()) {
              loads_ = other.loads_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureLoadsIsMutable();
              loads_.addAll(other.loads_);
            }
            onChanged();
          }
        } else {
          if (!other.loads_.isEmpty()) {
            if (loadsBuilder_.isEmpty()) {
              loadsBuilder_.dispose();
              loadsBuilder_ = null;
              loads_ = other.loads_;
              bitField0_ = (bitField0_ & ~0x00000002);
              loadsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getLoadsFieldBuilder()
                      : null;
            } else {
              loadsBuilder_.addAllMessages(other.loads_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getTravelDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 17:
                {
                  travelDistanceMeters_ = input.readDouble();

                  break;
                } // case 17
              case 24:
                {
                  trafficInfoUnavailable_ = input.readBool();

                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(getDelayDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getBreakDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getWaitDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getTotalDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(getRoutePolylineFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 74
              case 82:
                {
                  com.google.cloud.optimization.v1.CapacityQuantity m =
                      input.readMessage(
                          com.google.cloud.optimization.v1.CapacityQuantity.parser(),
                          extensionRegistry);
                  if (loadsBuilder_ == null) {
                    ensureLoadsIsMutable();
                    loads_.add(m);
                  } else {
                    loadsBuilder_.addMessage(m);
                  }
                  break;
                } // case 82
              case 90:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
                      vehicleLoads__ =
                          input.readMessage(
                              VehicleLoadsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableVehicleLoads()
                      .getMutableMap()
                      .put(vehicleLoads__.getKey(), vehicleLoads__.getValue());
                  break;
                } // case 90
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Duration travelDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          travelDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Travel duration during this transition.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 1;</code>
       *
       * @return Whether the travelDuration field is set.
       */
      public boolean hasTravelDuration() {
        return travelDurationBuilder_ != null || travelDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Travel duration during this transition.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 1;</code>
       *
       * @return The travelDuration.
       */
      public com.google.protobuf.Duration getTravelDuration() {
        if (travelDurationBuilder_ == null) {
          return travelDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : travelDuration_;
        } else {
          return travelDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Travel duration during this transition.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 1;</code>
       */
      public Builder setTravelDuration(com.google.protobuf.Duration value) {
        if (travelDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          travelDuration_ = value;
          onChanged();
        } else {
          travelDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel duration during this transition.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 1;</code>
       */
      public Builder setTravelDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (travelDurationBuilder_ == null) {
          travelDuration_ = builderForValue.build();
          onChanged();
        } else {
          travelDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel duration during this transition.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 1;</code>
       */
      public Builder mergeTravelDuration(com.google.protobuf.Duration value) {
        if (travelDurationBuilder_ == null) {
          if (travelDuration_ != null) {
            travelDuration_ =
                com.google.protobuf.Duration.newBuilder(travelDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            travelDuration_ = value;
          }
          onChanged();
        } else {
          travelDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel duration during this transition.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 1;</code>
       */
      public Builder clearTravelDuration() {
        if (travelDurationBuilder_ == null) {
          travelDuration_ = null;
          onChanged();
        } else {
          travelDuration_ = null;
          travelDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel duration during this transition.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 1;</code>
       */
      public com.google.protobuf.Duration.Builder getTravelDurationBuilder() {

        onChanged();
        return getTravelDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Travel duration during this transition.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 1;</code>
       */
      public com.google.protobuf.DurationOrBuilder getTravelDurationOrBuilder() {
        if (travelDurationBuilder_ != null) {
          return travelDurationBuilder_.getMessageOrBuilder();
        } else {
          return travelDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : travelDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Travel duration during this transition.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getTravelDurationFieldBuilder() {
        if (travelDurationBuilder_ == null) {
          travelDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getTravelDuration(), getParentForChildren(), isClean());
          travelDuration_ = null;
        }
        return travelDurationBuilder_;
      }

      private double travelDistanceMeters_;
      /**
       *
       *
       * <pre>
       * Distance traveled during the transition.
       * </pre>
       *
       * <code>double travel_distance_meters = 2;</code>
       *
       * @return The travelDistanceMeters.
       */
      @java.lang.Override
      public double getTravelDistanceMeters() {
        return travelDistanceMeters_;
      }
      /**
       *
       *
       * <pre>
       * Distance traveled during the transition.
       * </pre>
       *
       * <code>double travel_distance_meters = 2;</code>
       *
       * @param value The travelDistanceMeters to set.
       * @return This builder for chaining.
       */
      public Builder setTravelDistanceMeters(double value) {

        travelDistanceMeters_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Distance traveled during the transition.
       * </pre>
       *
       * <code>double travel_distance_meters = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTravelDistanceMeters() {

        travelDistanceMeters_ = 0D;
        onChanged();
        return this;
      }

      private boolean trafficInfoUnavailable_;
      /**
       *
       *
       * <pre>
       * When traffic is requested via
       * [OptimizeToursRequest.consider_road_traffic]
       * [google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
       * and the traffic info couldn't be retrieved for a `Transition`, this
       * boolean is set to true. This may be temporary (rare hiccup in the
       * realtime traffic servers) or permanent (no data for this location).
       * </pre>
       *
       * <code>bool traffic_info_unavailable = 3;</code>
       *
       * @return The trafficInfoUnavailable.
       */
      @java.lang.Override
      public boolean getTrafficInfoUnavailable() {
        return trafficInfoUnavailable_;
      }
      /**
       *
       *
       * <pre>
       * When traffic is requested via
       * [OptimizeToursRequest.consider_road_traffic]
       * [google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
       * and the traffic info couldn't be retrieved for a `Transition`, this
       * boolean is set to true. This may be temporary (rare hiccup in the
       * realtime traffic servers) or permanent (no data for this location).
       * </pre>
       *
       * <code>bool traffic_info_unavailable = 3;</code>
       *
       * @param value The trafficInfoUnavailable to set.
       * @return This builder for chaining.
       */
      public Builder setTrafficInfoUnavailable(boolean value) {

        trafficInfoUnavailable_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When traffic is requested via
       * [OptimizeToursRequest.consider_road_traffic]
       * [google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
       * and the traffic info couldn't be retrieved for a `Transition`, this
       * boolean is set to true. This may be temporary (rare hiccup in the
       * realtime traffic servers) or permanent (no data for this location).
       * </pre>
       *
       * <code>bool traffic_info_unavailable = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrafficInfoUnavailable() {

        trafficInfoUnavailable_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration delayDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          delayDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Sum of the delay durations applied to this transition. If any, the delay
       * starts exactly `delay_duration` seconds before the next event (visit or
       * vehicle end). See
       * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
       * </pre>
       *
       * <code>.google.protobuf.Duration delay_duration = 4;</code>
       *
       * @return Whether the delayDuration field is set.
       */
      public boolean hasDelayDuration() {
        return delayDurationBuilder_ != null || delayDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Sum of the delay durations applied to this transition. If any, the delay
       * starts exactly `delay_duration` seconds before the next event (visit or
       * vehicle end). See
       * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
       * </pre>
       *
       * <code>.google.protobuf.Duration delay_duration = 4;</code>
       *
       * @return The delayDuration.
       */
      public com.google.protobuf.Duration getDelayDuration() {
        if (delayDurationBuilder_ == null) {
          return delayDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : delayDuration_;
        } else {
          return delayDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Sum of the delay durations applied to this transition. If any, the delay
       * starts exactly `delay_duration` seconds before the next event (visit or
       * vehicle end). See
       * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
       * </pre>
       *
       * <code>.google.protobuf.Duration delay_duration = 4;</code>
       */
      public Builder setDelayDuration(com.google.protobuf.Duration value) {
        if (delayDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          delayDuration_ = value;
          onChanged();
        } else {
          delayDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum of the delay durations applied to this transition. If any, the delay
       * starts exactly `delay_duration` seconds before the next event (visit or
       * vehicle end). See
       * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
       * </pre>
       *
       * <code>.google.protobuf.Duration delay_duration = 4;</code>
       */
      public Builder setDelayDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (delayDurationBuilder_ == null) {
          delayDuration_ = builderForValue.build();
          onChanged();
        } else {
          delayDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum of the delay durations applied to this transition. If any, the delay
       * starts exactly `delay_duration` seconds before the next event (visit or
       * vehicle end). See
       * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
       * </pre>
       *
       * <code>.google.protobuf.Duration delay_duration = 4;</code>
       */
      public Builder mergeDelayDuration(com.google.protobuf.Duration value) {
        if (delayDurationBuilder_ == null) {
          if (delayDuration_ != null) {
            delayDuration_ =
                com.google.protobuf.Duration.newBuilder(delayDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            delayDuration_ = value;
          }
          onChanged();
        } else {
          delayDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum of the delay durations applied to this transition. If any, the delay
       * starts exactly `delay_duration` seconds before the next event (visit or
       * vehicle end). See
       * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
       * </pre>
       *
       * <code>.google.protobuf.Duration delay_duration = 4;</code>
       */
      public Builder clearDelayDuration() {
        if (delayDurationBuilder_ == null) {
          delayDuration_ = null;
          onChanged();
        } else {
          delayDuration_ = null;
          delayDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum of the delay durations applied to this transition. If any, the delay
       * starts exactly `delay_duration` seconds before the next event (visit or
       * vehicle end). See
       * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
       * </pre>
       *
       * <code>.google.protobuf.Duration delay_duration = 4;</code>
       */
      public com.google.protobuf.Duration.Builder getDelayDurationBuilder() {

        onChanged();
        return getDelayDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Sum of the delay durations applied to this transition. If any, the delay
       * starts exactly `delay_duration` seconds before the next event (visit or
       * vehicle end). See
       * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
       * </pre>
       *
       * <code>.google.protobuf.Duration delay_duration = 4;</code>
       */
      public com.google.protobuf.DurationOrBuilder getDelayDurationOrBuilder() {
        if (delayDurationBuilder_ != null) {
          return delayDurationBuilder_.getMessageOrBuilder();
        } else {
          return delayDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : delayDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Sum of the delay durations applied to this transition. If any, the delay
       * starts exactly `delay_duration` seconds before the next event (visit or
       * vehicle end). See
       * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
       * </pre>
       *
       * <code>.google.protobuf.Duration delay_duration = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getDelayDurationFieldBuilder() {
        if (delayDurationBuilder_ == null) {
          delayDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getDelayDuration(), getParentForChildren(), isClean());
          delayDuration_ = null;
        }
        return delayDurationBuilder_;
      }

      private com.google.protobuf.Duration breakDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          breakDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Sum of the duration of the breaks occurring during this transition, if
       * any. Details about each break's start time and duration are stored in
       * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
       * </pre>
       *
       * <code>.google.protobuf.Duration break_duration = 5;</code>
       *
       * @return Whether the breakDuration field is set.
       */
      public boolean hasBreakDuration() {
        return breakDurationBuilder_ != null || breakDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Sum of the duration of the breaks occurring during this transition, if
       * any. Details about each break's start time and duration are stored in
       * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
       * </pre>
       *
       * <code>.google.protobuf.Duration break_duration = 5;</code>
       *
       * @return The breakDuration.
       */
      public com.google.protobuf.Duration getBreakDuration() {
        if (breakDurationBuilder_ == null) {
          return breakDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : breakDuration_;
        } else {
          return breakDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Sum of the duration of the breaks occurring during this transition, if
       * any. Details about each break's start time and duration are stored in
       * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
       * </pre>
       *
       * <code>.google.protobuf.Duration break_duration = 5;</code>
       */
      public Builder setBreakDuration(com.google.protobuf.Duration value) {
        if (breakDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          breakDuration_ = value;
          onChanged();
        } else {
          breakDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum of the duration of the breaks occurring during this transition, if
       * any. Details about each break's start time and duration are stored in
       * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
       * </pre>
       *
       * <code>.google.protobuf.Duration break_duration = 5;</code>
       */
      public Builder setBreakDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (breakDurationBuilder_ == null) {
          breakDuration_ = builderForValue.build();
          onChanged();
        } else {
          breakDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum of the duration of the breaks occurring during this transition, if
       * any. Details about each break's start time and duration are stored in
       * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
       * </pre>
       *
       * <code>.google.protobuf.Duration break_duration = 5;</code>
       */
      public Builder mergeBreakDuration(com.google.protobuf.Duration value) {
        if (breakDurationBuilder_ == null) {
          if (breakDuration_ != null) {
            breakDuration_ =
                com.google.protobuf.Duration.newBuilder(breakDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            breakDuration_ = value;
          }
          onChanged();
        } else {
          breakDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum of the duration of the breaks occurring during this transition, if
       * any. Details about each break's start time and duration are stored in
       * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
       * </pre>
       *
       * <code>.google.protobuf.Duration break_duration = 5;</code>
       */
      public Builder clearBreakDuration() {
        if (breakDurationBuilder_ == null) {
          breakDuration_ = null;
          onChanged();
        } else {
          breakDuration_ = null;
          breakDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum of the duration of the breaks occurring during this transition, if
       * any. Details about each break's start time and duration are stored in
       * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
       * </pre>
       *
       * <code>.google.protobuf.Duration break_duration = 5;</code>
       */
      public com.google.protobuf.Duration.Builder getBreakDurationBuilder() {

        onChanged();
        return getBreakDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Sum of the duration of the breaks occurring during this transition, if
       * any. Details about each break's start time and duration are stored in
       * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
       * </pre>
       *
       * <code>.google.protobuf.Duration break_duration = 5;</code>
       */
      public com.google.protobuf.DurationOrBuilder getBreakDurationOrBuilder() {
        if (breakDurationBuilder_ != null) {
          return breakDurationBuilder_.getMessageOrBuilder();
        } else {
          return breakDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : breakDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Sum of the duration of the breaks occurring during this transition, if
       * any. Details about each break's start time and duration are stored in
       * [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
       * </pre>
       *
       * <code>.google.protobuf.Duration break_duration = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getBreakDurationFieldBuilder() {
        if (breakDurationBuilder_ == null) {
          breakDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getBreakDuration(), getParentForChildren(), isClean());
          breakDuration_ = null;
        }
        return breakDurationBuilder_;
      }

      private com.google.protobuf.Duration waitDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          waitDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Time spent waiting during this transition. Wait duration corresponds to
       * idle time and does not include break time. Also note that this wait time
       * may be split into several non-contiguous intervals.
       * </pre>
       *
       * <code>.google.protobuf.Duration wait_duration = 6;</code>
       *
       * @return Whether the waitDuration field is set.
       */
      public boolean hasWaitDuration() {
        return waitDurationBuilder_ != null || waitDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Time spent waiting during this transition. Wait duration corresponds to
       * idle time and does not include break time. Also note that this wait time
       * may be split into several non-contiguous intervals.
       * </pre>
       *
       * <code>.google.protobuf.Duration wait_duration = 6;</code>
       *
       * @return The waitDuration.
       */
      public com.google.protobuf.Duration getWaitDuration() {
        if (waitDurationBuilder_ == null) {
          return waitDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : waitDuration_;
        } else {
          return waitDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Time spent waiting during this transition. Wait duration corresponds to
       * idle time and does not include break time. Also note that this wait time
       * may be split into several non-contiguous intervals.
       * </pre>
       *
       * <code>.google.protobuf.Duration wait_duration = 6;</code>
       */
      public Builder setWaitDuration(com.google.protobuf.Duration value) {
        if (waitDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          waitDuration_ = value;
          onChanged();
        } else {
          waitDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Time spent waiting during this transition. Wait duration corresponds to
       * idle time and does not include break time. Also note that this wait time
       * may be split into several non-contiguous intervals.
       * </pre>
       *
       * <code>.google.protobuf.Duration wait_duration = 6;</code>
       */
      public Builder setWaitDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (waitDurationBuilder_ == null) {
          waitDuration_ = builderForValue.build();
          onChanged();
        } else {
          waitDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Time spent waiting during this transition. Wait duration corresponds to
       * idle time and does not include break time. Also note that this wait time
       * may be split into several non-contiguous intervals.
       * </pre>
       *
       * <code>.google.protobuf.Duration wait_duration = 6;</code>
       */
      public Builder mergeWaitDuration(com.google.protobuf.Duration value) {
        if (waitDurationBuilder_ == null) {
          if (waitDuration_ != null) {
            waitDuration_ =
                com.google.protobuf.Duration.newBuilder(waitDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            waitDuration_ = value;
          }
          onChanged();
        } else {
          waitDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Time spent waiting during this transition. Wait duration corresponds to
       * idle time and does not include break time. Also note that this wait time
       * may be split into several non-contiguous intervals.
       * </pre>
       *
       * <code>.google.protobuf.Duration wait_duration = 6;</code>
       */
      public Builder clearWaitDuration() {
        if (waitDurationBuilder_ == null) {
          waitDuration_ = null;
          onChanged();
        } else {
          waitDuration_ = null;
          waitDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Time spent waiting during this transition. Wait duration corresponds to
       * idle time and does not include break time. Also note that this wait time
       * may be split into several non-contiguous intervals.
       * </pre>
       *
       * <code>.google.protobuf.Duration wait_duration = 6;</code>
       */
      public com.google.protobuf.Duration.Builder getWaitDurationBuilder() {

        onChanged();
        return getWaitDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Time spent waiting during this transition. Wait duration corresponds to
       * idle time and does not include break time. Also note that this wait time
       * may be split into several non-contiguous intervals.
       * </pre>
       *
       * <code>.google.protobuf.Duration wait_duration = 6;</code>
       */
      public com.google.protobuf.DurationOrBuilder getWaitDurationOrBuilder() {
        if (waitDurationBuilder_ != null) {
          return waitDurationBuilder_.getMessageOrBuilder();
        } else {
          return waitDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : waitDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Time spent waiting during this transition. Wait duration corresponds to
       * idle time and does not include break time. Also note that this wait time
       * may be split into several non-contiguous intervals.
       * </pre>
       *
       * <code>.google.protobuf.Duration wait_duration = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getWaitDurationFieldBuilder() {
        if (waitDurationBuilder_ == null) {
          waitDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getWaitDuration(), getParentForChildren(), isClean());
          waitDuration_ = null;
        }
        return waitDurationBuilder_;
      }

      private com.google.protobuf.Duration totalDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          totalDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Total duration of the transition, provided for convenience. It is equal
       * to:
       * * next visit `start_time` (or `vehicle_end_time` if this is the last
       * transition) - this transition's `start_time`;
       * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
       * additionally holds: `total_duration = travel_duration + delay_duration
       * + break_duration + wait_duration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration total_duration = 7;</code>
       *
       * @return Whether the totalDuration field is set.
       */
      public boolean hasTotalDuration() {
        return totalDurationBuilder_ != null || totalDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Total duration of the transition, provided for convenience. It is equal
       * to:
       * * next visit `start_time` (or `vehicle_end_time` if this is the last
       * transition) - this transition's `start_time`;
       * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
       * additionally holds: `total_duration = travel_duration + delay_duration
       * + break_duration + wait_duration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration total_duration = 7;</code>
       *
       * @return The totalDuration.
       */
      public com.google.protobuf.Duration getTotalDuration() {
        if (totalDurationBuilder_ == null) {
          return totalDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : totalDuration_;
        } else {
          return totalDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Total duration of the transition, provided for convenience. It is equal
       * to:
       * * next visit `start_time` (or `vehicle_end_time` if this is the last
       * transition) - this transition's `start_time`;
       * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
       * additionally holds: `total_duration = travel_duration + delay_duration
       * + break_duration + wait_duration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration total_duration = 7;</code>
       */
      public Builder setTotalDuration(com.google.protobuf.Duration value) {
        if (totalDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          totalDuration_ = value;
          onChanged();
        } else {
          totalDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Total duration of the transition, provided for convenience. It is equal
       * to:
       * * next visit `start_time` (or `vehicle_end_time` if this is the last
       * transition) - this transition's `start_time`;
       * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
       * additionally holds: `total_duration = travel_duration + delay_duration
       * + break_duration + wait_duration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration total_duration = 7;</code>
       */
      public Builder setTotalDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (totalDurationBuilder_ == null) {
          totalDuration_ = builderForValue.build();
          onChanged();
        } else {
          totalDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Total duration of the transition, provided for convenience. It is equal
       * to:
       * * next visit `start_time` (or `vehicle_end_time` if this is the last
       * transition) - this transition's `start_time`;
       * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
       * additionally holds: `total_duration = travel_duration + delay_duration
       * + break_duration + wait_duration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration total_duration = 7;</code>
       */
      public Builder mergeTotalDuration(com.google.protobuf.Duration value) {
        if (totalDurationBuilder_ == null) {
          if (totalDuration_ != null) {
            totalDuration_ =
                com.google.protobuf.Duration.newBuilder(totalDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            totalDuration_ = value;
          }
          onChanged();
        } else {
          totalDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Total duration of the transition, provided for convenience. It is equal
       * to:
       * * next visit `start_time` (or `vehicle_end_time` if this is the last
       * transition) - this transition's `start_time`;
       * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
       * additionally holds: `total_duration = travel_duration + delay_duration
       * + break_duration + wait_duration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration total_duration = 7;</code>
       */
      public Builder clearTotalDuration() {
        if (totalDurationBuilder_ == null) {
          totalDuration_ = null;
          onChanged();
        } else {
          totalDuration_ = null;
          totalDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Total duration of the transition, provided for convenience. It is equal
       * to:
       * * next visit `start_time` (or `vehicle_end_time` if this is the last
       * transition) - this transition's `start_time`;
       * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
       * additionally holds: `total_duration = travel_duration + delay_duration
       * + break_duration + wait_duration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration total_duration = 7;</code>
       */
      public com.google.protobuf.Duration.Builder getTotalDurationBuilder() {

        onChanged();
        return getTotalDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Total duration of the transition, provided for convenience. It is equal
       * to:
       * * next visit `start_time` (or `vehicle_end_time` if this is the last
       * transition) - this transition's `start_time`;
       * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
       * additionally holds: `total_duration = travel_duration + delay_duration
       * + break_duration + wait_duration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration total_duration = 7;</code>
       */
      public com.google.protobuf.DurationOrBuilder getTotalDurationOrBuilder() {
        if (totalDurationBuilder_ != null) {
          return totalDurationBuilder_.getMessageOrBuilder();
        } else {
          return totalDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : totalDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Total duration of the transition, provided for convenience. It is equal
       * to:
       * * next visit `start_time` (or `vehicle_end_time` if this is the last
       * transition) - this transition's `start_time`;
       * * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
       * additionally holds: `total_duration = travel_duration + delay_duration
       * + break_duration + wait_duration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration total_duration = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getTotalDurationFieldBuilder() {
        if (totalDurationBuilder_ == null) {
          totalDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getTotalDuration(), getParentForChildren(), isClean());
          totalDuration_ = null;
        }
        return totalDurationBuilder_;
      }

      private com.google.protobuf.Timestamp startTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Start time of this transition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 8;</code>
       *
       * @return Whether the startTime field is set.
       */
      public boolean hasStartTime() {
        return startTimeBuilder_ != null || startTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Start time of this transition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 8;</code>
       *
       * @return The startTime.
       */
      public com.google.protobuf.Timestamp getStartTime() {
        if (startTimeBuilder_ == null) {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        } else {
          return startTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Start time of this transition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 8;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTime_ = value;
          onChanged();
        } else {
          startTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of this transition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 8;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimeBuilder_ == null) {
          startTime_ = builderForValue.build();
          onChanged();
        } else {
          startTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of this transition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 8;</code>
       */
      public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (startTime_ != null) {
            startTime_ =
                com.google.protobuf.Timestamp.newBuilder(startTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            startTime_ = value;
          }
          onChanged();
        } else {
          startTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of this transition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 8;</code>
       */
      public Builder clearStartTime() {
        if (startTimeBuilder_ == null) {
          startTime_ = null;
          onChanged();
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of this transition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 8;</code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

        onChanged();
        return getStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Start time of this transition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 8;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        if (startTimeBuilder_ != null) {
          return startTimeBuilder_.getMessageOrBuilder();
        } else {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Start time of this transition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimeFieldBuilder() {
        if (startTimeBuilder_ == null) {
          startTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTime(), getParentForChildren(), isClean());
          startTime_ = null;
        }
        return startTimeBuilder_;
      }

      private com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline routePolyline_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline,
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder,
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder>
          routePolylineBuilder_;
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * transition.
       * This field is only populated if [populate_transition_polylines]
       * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;
       * </code>
       *
       * @return Whether the routePolyline field is set.
       */
      public boolean hasRoutePolyline() {
        return routePolylineBuilder_ != null || routePolyline_ != null;
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * transition.
       * This field is only populated if [populate_transition_polylines]
       * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;
       * </code>
       *
       * @return The routePolyline.
       */
      public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline getRoutePolyline() {
        if (routePolylineBuilder_ == null) {
          return routePolyline_ == null
              ? com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.getDefaultInstance()
              : routePolyline_;
        } else {
          return routePolylineBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * transition.
       * This field is only populated if [populate_transition_polylines]
       * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;
       * </code>
       */
      public Builder setRoutePolyline(
          com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline value) {
        if (routePolylineBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          routePolyline_ = value;
          onChanged();
        } else {
          routePolylineBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * transition.
       * This field is only populated if [populate_transition_polylines]
       * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;
       * </code>
       */
      public Builder setRoutePolyline(
          com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder builderForValue) {
        if (routePolylineBuilder_ == null) {
          routePolyline_ = builderForValue.build();
          onChanged();
        } else {
          routePolylineBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * transition.
       * This field is only populated if [populate_transition_polylines]
       * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;
       * </code>
       */
      public Builder mergeRoutePolyline(
          com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline value) {
        if (routePolylineBuilder_ == null) {
          if (routePolyline_ != null) {
            routePolyline_ =
                com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.newBuilder(
                        routePolyline_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            routePolyline_ = value;
          }
          onChanged();
        } else {
          routePolylineBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * transition.
       * This field is only populated if [populate_transition_polylines]
       * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;
       * </code>
       */
      public Builder clearRoutePolyline() {
        if (routePolylineBuilder_ == null) {
          routePolyline_ = null;
          onChanged();
        } else {
          routePolyline_ = null;
          routePolylineBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * transition.
       * This field is only populated if [populate_transition_polylines]
       * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder
          getRoutePolylineBuilder() {

        onChanged();
        return getRoutePolylineFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * transition.
       * This field is only populated if [populate_transition_polylines]
       * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder
          getRoutePolylineOrBuilder() {
        if (routePolylineBuilder_ != null) {
          return routePolylineBuilder_.getMessageOrBuilder();
        } else {
          return routePolyline_ == null
              ? com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.getDefaultInstance()
              : routePolyline_;
        }
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * transition.
       * This field is only populated if [populate_transition_polylines]
       * [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 9;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline,
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder,
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder>
          getRoutePolylineFieldBuilder() {
        if (routePolylineBuilder_ == null) {
          routePolylineBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline,
                  com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder,
                  com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder>(
                  getRoutePolyline(), getParentForChildren(), isClean());
          routePolyline_ = null;
        }
        return routePolylineBuilder_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          vehicleLoads_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          internalGetVehicleLoads() {
        if (vehicleLoads_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              VehicleLoadsDefaultEntryHolder.defaultEntry);
        }
        return vehicleLoads_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          internalGetMutableVehicleLoads() {
        onChanged();
        ;
        if (vehicleLoads_ == null) {
          vehicleLoads_ =
              com.google.protobuf.MapField.newMapField(VehicleLoadsDefaultEntryHolder.defaultEntry);
        }
        if (!vehicleLoads_.isMutable()) {
          vehicleLoads_ = vehicleLoads_.copy();
        }
        return vehicleLoads_;
      }

      public int getVehicleLoadsCount() {
        return internalGetVehicleLoads().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Vehicle loads during this transition, for each type that either appears
       * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
       * The loads during the first transition are the starting loads of the
       * vehicle route. Then, after each visit, the visit's `load_demands` are
       * either added or subtracted to get the next transition's loads, depending
       * on whether the visit was a pickup or a delivery.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
       * </code>
       */
      @java.lang.Override
      public boolean containsVehicleLoads(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetVehicleLoads().getMap().containsKey(key);
      }
      /** Use {@link #getVehicleLoadsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          getVehicleLoads() {
        return getVehicleLoadsMap();
      }
      /**
       *
       *
       * <pre>
       * Vehicle loads during this transition, for each type that either appears
       * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
       * The loads during the first transition are the starting loads of the
       * vehicle route. Then, after each visit, the visit's `load_demands` are
       * either added or subtracted to get the next transition's loads, depending
       * on whether the visit was a pickup or a delivery.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          getVehicleLoadsMap() {
        return internalGetVehicleLoads().getMap();
      }
      /**
       *
       *
       * <pre>
       * Vehicle loads during this transition, for each type that either appears
       * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
       * The loads during the first transition are the starting loads of the
       * vehicle route. Then, after each visit, the visit's `load_demands` are
       * either added or subtracted to get the next transition's loads, depending
       * on whether the visit was a pickup or a delivery.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getVehicleLoadsOrDefault(
          java.lang.String key,
          com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
            map = internalGetVehicleLoads().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Vehicle loads during this transition, for each type that either appears
       * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
       * The loads during the first transition are the starting loads of the
       * vehicle route. Then, after each visit, the visit's `load_demands` are
       * either added or subtracted to get the next transition's loads, depending
       * on whether the visit was a pickup or a delivery.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getVehicleLoadsOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
            map = internalGetVehicleLoads().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearVehicleLoads() {
        internalGetMutableVehicleLoads().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Vehicle loads during this transition, for each type that either appears
       * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
       * The loads during the first transition are the starting loads of the
       * vehicle route. Then, after each visit, the visit's `load_demands` are
       * either added or subtracted to get the next transition's loads, depending
       * on whether the visit was a pickup or a delivery.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
       * </code>
       */
      public Builder removeVehicleLoads(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableVehicleLoads().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          getMutableVehicleLoads() {
        return internalGetMutableVehicleLoads().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Vehicle loads during this transition, for each type that either appears
       * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
       * The loads during the first transition are the starting loads of the
       * vehicle route. Then, after each visit, the visit's `load_demands` are
       * either added or subtracted to get the next transition's loads, depending
       * on whether the visit was a pickup or a delivery.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
       * </code>
       */
      public Builder putVehicleLoads(
          java.lang.String key, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableVehicleLoads().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Vehicle loads during this transition, for each type that either appears
       * in this vehicle's [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits], or that have non-zero
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] on some shipment performed on this route.
       * The loads during the first transition are the starting loads of the
       * vehicle route. Then, after each visit, the visit's `load_demands` are
       * either added or subtracted to get the next transition's loads, depending
       * on whether the visit was a pickup or a delivery.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; vehicle_loads = 11;
       * </code>
       */
      public Builder putAllVehicleLoads(
          java.util.Map<
                  java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
              values) {
        internalGetMutableVehicleLoads().getMutableMap().putAll(values);
        return this;
      }

      private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> loads_ =
          java.util.Collections.emptyList();

      private void ensureLoadsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          loads_ =
              new java.util.ArrayList<com.google.cloud.optimization.v1.CapacityQuantity>(loads_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.CapacityQuantity,
              com.google.cloud.optimization.v1.CapacityQuantity.Builder,
              com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          loadsBuilder_;

      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getLoadsList() {
        if (loadsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(loads_);
        } else {
          return loadsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public int getLoadsCount() {
        if (loadsBuilder_ == null) {
          return loads_.size();
        } else {
          return loadsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity getLoads(int index) {
        if (loadsBuilder_ == null) {
          return loads_.get(index);
        } else {
          return loadsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setLoads(int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (loadsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLoadsIsMutable();
          loads_.set(index, value);
          onChanged();
        } else {
          loadsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setLoads(
          int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (loadsBuilder_ == null) {
          ensureLoadsIsMutable();
          loads_.set(index, builderForValue.build());
          onChanged();
        } else {
          loadsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addLoads(com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (loadsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLoadsIsMutable();
          loads_.add(value);
          onChanged();
        } else {
          loadsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addLoads(int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (loadsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLoadsIsMutable();
          loads_.add(index, value);
          onChanged();
        } else {
          loadsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addLoads(
          com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (loadsBuilder_ == null) {
          ensureLoadsIsMutable();
          loads_.add(builderForValue.build());
          onChanged();
        } else {
          loadsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addLoads(
          int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (loadsBuilder_ == null) {
          ensureLoadsIsMutable();
          loads_.add(index, builderForValue.build());
          onChanged();
        } else {
          loadsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAllLoads(
          java.lang.Iterable<? extends com.google.cloud.optimization.v1.CapacityQuantity> values) {
        if (loadsBuilder_ == null) {
          ensureLoadsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, loads_);
          onChanged();
        } else {
          loadsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder clearLoads() {
        if (loadsBuilder_ == null) {
          loads_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          loadsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder removeLoads(int index) {
        if (loadsBuilder_ == null) {
          ensureLoadsIsMutable();
          loads_.remove(index);
          onChanged();
        } else {
          loadsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder getLoadsBuilder(int index) {
        return getLoadsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getLoadsOrBuilder(
          int index) {
        if (loadsBuilder_ == null) {
          return loads_.get(index);
        } else {
          return loadsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          getLoadsOrBuilderList() {
        if (loadsBuilder_ != null) {
          return loadsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(loads_);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder addLoadsBuilder() {
        return getLoadsFieldBuilder()
            .addBuilder(com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder addLoadsBuilder(int index) {
        return getLoadsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [Transition.vehicle_loads][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity loads = 10 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity.Builder>
          getLoadsBuilderList() {
        return getLoadsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.CapacityQuantity,
              com.google.cloud.optimization.v1.CapacityQuantity.Builder,
              com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          getLoadsFieldBuilder() {
        if (loadsBuilder_ == null) {
          loadsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.optimization.v1.CapacityQuantity,
                  com.google.cloud.optimization.v1.CapacityQuantity.Builder,
                  com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>(
                  loads_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          loads_ = null;
        }
        return loadsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentRoute.Transition)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentRoute.Transition)
    private static final com.google.cloud.optimization.v1.ShipmentRoute.Transition DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentRoute.Transition();
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Transition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Transition> PARSER =
        new com.google.protobuf.AbstractParser<Transition>() {
          @java.lang.Override
          public Transition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Transition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Transition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.Transition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VehicleLoadOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentRoute.VehicleLoad)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The amount of load on the vehicle, for the given type. The unit of load
     * is usually indicated by the type. See [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads].
     * </pre>
     *
     * <code>int64 amount = 1;</code>
     *
     * @return The amount.
     */
    long getAmount();
  }
  /**
   *
   *
   * <pre>
   * Reports the actual load of the vehicle at some point along the route,
   * for a given type (see [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]).
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.VehicleLoad}
   */
  public static final class VehicleLoad extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentRoute.VehicleLoad)
      VehicleLoadOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VehicleLoad.newBuilder() to construct.
    private VehicleLoad(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VehicleLoad() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VehicleLoad();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_VehicleLoad_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_VehicleLoad_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad.class,
              com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad.Builder.class);
    }

    public static final int AMOUNT_FIELD_NUMBER = 1;
    private long amount_;
    /**
     *
     *
     * <pre>
     * The amount of load on the vehicle, for the given type. The unit of load
     * is usually indicated by the type. See [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads].
     * </pre>
     *
     * <code>int64 amount = 1;</code>
     *
     * @return The amount.
     */
    @java.lang.Override
    public long getAmount() {
      return amount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (amount_ != 0L) {
        output.writeInt64(1, amount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (amount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, amount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad other =
          (com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad) obj;

      if (getAmount() != other.getAmount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AMOUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAmount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Reports the actual load of the vehicle at some point along the route,
     * for a given type (see [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]).
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.VehicleLoad}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentRoute.VehicleLoad)
        com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoadOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_VehicleLoad_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_VehicleLoad_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad.class,
                com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        amount_ = 0L;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_VehicleLoad_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad
          getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad build() {
        com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad buildPartial() {
        com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad result =
            new com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad(this);
        result.amount_ = amount_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad) {
          return mergeFrom((com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad other) {
        if (other
            == com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad.getDefaultInstance())
          return this;
        if (other.getAmount() != 0L) {
          setAmount(other.getAmount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  amount_ = input.readInt64();

                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private long amount_;
      /**
       *
       *
       * <pre>
       * The amount of load on the vehicle, for the given type. The unit of load
       * is usually indicated by the type. See [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads].
       * </pre>
       *
       * <code>int64 amount = 1;</code>
       *
       * @return The amount.
       */
      @java.lang.Override
      public long getAmount() {
        return amount_;
      }
      /**
       *
       *
       * <pre>
       * The amount of load on the vehicle, for the given type. The unit of load
       * is usually indicated by the type. See [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads].
       * </pre>
       *
       * <code>int64 amount = 1;</code>
       *
       * @param value The amount to set.
       * @return This builder for chaining.
       */
      public Builder setAmount(long value) {

        amount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The amount of load on the vehicle, for the given type. The unit of load
       * is usually indicated by the type. See [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads].
       * </pre>
       *
       * <code>int64 amount = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAmount() {

        amount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentRoute.VehicleLoad)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentRoute.VehicleLoad)
    private static final com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad();
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VehicleLoad> PARSER =
        new com.google.protobuf.AbstractParser<VehicleLoad>() {
          @java.lang.Override
          public VehicleLoad parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VehicleLoad> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VehicleLoad> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EncodedPolylineOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * String representing encoded points of the polyline.
     * </pre>
     *
     * <code>string points = 1;</code>
     *
     * @return The points.
     */
    java.lang.String getPoints();
    /**
     *
     *
     * <pre>
     * String representing encoded points of the polyline.
     * </pre>
     *
     * <code>string points = 1;</code>
     *
     * @return The bytes for points.
     */
    com.google.protobuf.ByteString getPointsBytes();
  }
  /**
   *
   *
   * <pre>
   * The encoded representation of a polyline. More information on polyline
   * encoding can be found here:
   * https://developers.google.com/maps/documentation/utilities/polylinealgorithm
   * https://developers.google.com/maps/documentation/javascript/reference/geometry#encoding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline}
   */
  public static final class EncodedPolyline extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline)
      EncodedPolylineOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EncodedPolyline.newBuilder() to construct.
    private EncodedPolyline(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EncodedPolyline() {
      points_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EncodedPolyline();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_EncodedPolyline_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_EncodedPolyline_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.class,
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder.class);
    }

    public static final int POINTS_FIELD_NUMBER = 1;
    private volatile java.lang.Object points_;
    /**
     *
     *
     * <pre>
     * String representing encoded points of the polyline.
     * </pre>
     *
     * <code>string points = 1;</code>
     *
     * @return The points.
     */
    @java.lang.Override
    public java.lang.String getPoints() {
      java.lang.Object ref = points_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        points_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * String representing encoded points of the polyline.
     * </pre>
     *
     * <code>string points = 1;</code>
     *
     * @return The bytes for points.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPointsBytes() {
      java.lang.Object ref = points_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        points_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(points_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, points_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(points_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, points_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline other =
          (com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline) obj;

      if (!getPoints().equals(other.getPoints())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + POINTS_FIELD_NUMBER;
      hash = (53 * hash) + getPoints().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The encoded representation of a polyline. More information on polyline
     * encoding can be found here:
     * https://developers.google.com/maps/documentation/utilities/polylinealgorithm
     * https://developers.google.com/maps/documentation/javascript/reference/geometry#encoding.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline)
        com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_EncodedPolyline_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_EncodedPolyline_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.class,
                com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        points_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_EncodedPolyline_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline
          getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline build() {
        com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline buildPartial() {
        com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline result =
            new com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline(this);
        result.points_ = points_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline) {
          return mergeFrom((com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline other) {
        if (other
            == com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.getDefaultInstance())
          return this;
        if (!other.getPoints().isEmpty()) {
          points_ = other.points_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  points_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object points_ = "";
      /**
       *
       *
       * <pre>
       * String representing encoded points of the polyline.
       * </pre>
       *
       * <code>string points = 1;</code>
       *
       * @return The points.
       */
      public java.lang.String getPoints() {
        java.lang.Object ref = points_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          points_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * String representing encoded points of the polyline.
       * </pre>
       *
       * <code>string points = 1;</code>
       *
       * @return The bytes for points.
       */
      public com.google.protobuf.ByteString getPointsBytes() {
        java.lang.Object ref = points_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          points_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * String representing encoded points of the polyline.
       * </pre>
       *
       * <code>string points = 1;</code>
       *
       * @param value The points to set.
       * @return This builder for chaining.
       */
      public Builder setPoints(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        points_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * String representing encoded points of the polyline.
       * </pre>
       *
       * <code>string points = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPoints() {

        points_ = getDefaultInstance().getPoints();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * String representing encoded points of the polyline.
       * </pre>
       *
       * <code>string points = 1;</code>
       *
       * @param value The bytes for points to set.
       * @return This builder for chaining.
       */
      public Builder setPointsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        points_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline)
    private static final com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline();
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EncodedPolyline> PARSER =
        new com.google.protobuf.AbstractParser<EncodedPolyline>() {
          @java.lang.Override
          public EncodedPolyline parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EncodedPolyline> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EncodedPolyline> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BreakOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentRoute.Break)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Start time of a break.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    boolean hasStartTime();
    /**
     *
     *
     * <pre>
     * Start time of a break.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    com.google.protobuf.Timestamp getStartTime();
    /**
     *
     *
     * <pre>
     * Start time of a break.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Duration of a break.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     *
     * @return Whether the duration field is set.
     */
    boolean hasDuration();
    /**
     *
     *
     * <pre>
     * Duration of a break.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     *
     * @return The duration.
     */
    com.google.protobuf.Duration getDuration();
    /**
     *
     *
     * <pre>
     * Duration of a break.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     */
    com.google.protobuf.DurationOrBuilder getDurationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Data representing the execution of a break.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.Break}
   */
  public static final class Break extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentRoute.Break)
      BreakOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Break.newBuilder() to construct.
    private Break(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Break() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Break();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_Break_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_Break_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentRoute.Break.class,
              com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder.class);
    }

    public static final int START_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp startTime_;
    /**
     *
     *
     * <pre>
     * Start time of a break.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Start time of a break.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }
    /**
     *
     *
     * <pre>
     * Start time of a break.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      return getStartTime();
    }

    public static final int DURATION_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration duration_;
    /**
     *
     *
     * <pre>
     * Duration of a break.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     *
     * @return Whether the duration field is set.
     */
    @java.lang.Override
    public boolean hasDuration() {
      return duration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Duration of a break.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     *
     * @return The duration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getDuration() {
      return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
    }
    /**
     *
     *
     * <pre>
     * Duration of a break.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      return getDuration();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (startTime_ != null) {
        output.writeMessage(1, getStartTime());
      }
      if (duration_ != null) {
        output.writeMessage(2, getDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (startTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
      }
      if (duration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentRoute.Break)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.ShipmentRoute.Break other =
          (com.google.cloud.optimization.v1.ShipmentRoute.Break) obj;

      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime().equals(other.getStartTime())) return false;
      }
      if (hasDuration() != other.hasDuration()) return false;
      if (hasDuration()) {
        if (!getDuration().equals(other.getDuration())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      if (hasDuration()) {
        hash = (37 * hash) + DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.ShipmentRoute.Break prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Data representing the execution of a break.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.Break}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentRoute.Break)
        com.google.cloud.optimization.v1.ShipmentRoute.BreakOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Break_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Break_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentRoute.Break.class,
                com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.ShipmentRoute.Break.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (startTimeBuilder_ == null) {
          startTime_ = null;
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }
        if (durationBuilder_ == null) {
          duration_ = null;
        } else {
          duration_ = null;
          durationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_Break_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Break getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.ShipmentRoute.Break.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Break build() {
        com.google.cloud.optimization.v1.ShipmentRoute.Break result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.Break buildPartial() {
        com.google.cloud.optimization.v1.ShipmentRoute.Break result =
            new com.google.cloud.optimization.v1.ShipmentRoute.Break(this);
        if (startTimeBuilder_ == null) {
          result.startTime_ = startTime_;
        } else {
          result.startTime_ = startTimeBuilder_.build();
        }
        if (durationBuilder_ == null) {
          result.duration_ = duration_;
        } else {
          result.duration_ = durationBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.ShipmentRoute.Break) {
          return mergeFrom((com.google.cloud.optimization.v1.ShipmentRoute.Break) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.ShipmentRoute.Break other) {
        if (other == com.google.cloud.optimization.v1.ShipmentRoute.Break.getDefaultInstance())
          return this;
        if (other.hasStartTime()) {
          mergeStartTime(other.getStartTime());
        }
        if (other.hasDuration()) {
          mergeDuration(other.getDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.protobuf.Timestamp startTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Start time of a break.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return Whether the startTime field is set.
       */
      public boolean hasStartTime() {
        return startTimeBuilder_ != null || startTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Start time of a break.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return The startTime.
       */
      public com.google.protobuf.Timestamp getStartTime() {
        if (startTimeBuilder_ == null) {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        } else {
          return startTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Start time of a break.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTime_ = value;
          onChanged();
        } else {
          startTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of a break.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimeBuilder_ == null) {
          startTime_ = builderForValue.build();
          onChanged();
        } else {
          startTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of a break.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (startTime_ != null) {
            startTime_ =
                com.google.protobuf.Timestamp.newBuilder(startTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            startTime_ = value;
          }
          onChanged();
        } else {
          startTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of a break.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder clearStartTime() {
        if (startTimeBuilder_ == null) {
          startTime_ = null;
          onChanged();
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Start time of a break.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

        onChanged();
        return getStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Start time of a break.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        if (startTimeBuilder_ != null) {
          return startTimeBuilder_.getMessageOrBuilder();
        } else {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Start time of a break.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimeFieldBuilder() {
        if (startTimeBuilder_ == null) {
          startTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTime(), getParentForChildren(), isClean());
          startTime_ = null;
        }
        return startTimeBuilder_;
      }

      private com.google.protobuf.Duration duration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          durationBuilder_;
      /**
       *
       *
       * <pre>
       * Duration of a break.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return Whether the duration field is set.
       */
      public boolean hasDuration() {
        return durationBuilder_ != null || duration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Duration of a break.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       *
       * @return The duration.
       */
      public com.google.protobuf.Duration getDuration() {
        if (durationBuilder_ == null) {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        } else {
          return durationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of a break.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          duration_ = value;
          onChanged();
        } else {
          durationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of a break.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (durationBuilder_ == null) {
          duration_ = builderForValue.build();
          onChanged();
        } else {
          durationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of a break.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public Builder mergeDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (duration_ != null) {
            duration_ =
                com.google.protobuf.Duration.newBuilder(duration_).mergeFrom(value).buildPartial();
          } else {
            duration_ = value;
          }
          onChanged();
        } else {
          durationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of a break.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public Builder clearDuration() {
        if (durationBuilder_ == null) {
          duration_ = null;
          onChanged();
        } else {
          duration_ = null;
          durationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of a break.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public com.google.protobuf.Duration.Builder getDurationBuilder() {

        onChanged();
        return getDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration of a break.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        if (durationBuilder_ != null) {
          return durationBuilder_.getMessageOrBuilder();
        } else {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of a break.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getDurationFieldBuilder() {
        if (durationBuilder_ == null) {
          durationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getDuration(), getParentForChildren(), isClean());
          duration_ = null;
        }
        return durationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentRoute.Break)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentRoute.Break)
    private static final com.google.cloud.optimization.v1.ShipmentRoute.Break DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentRoute.Break();
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.Break getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Break> PARSER =
        new com.google.protobuf.AbstractParser<Break>() {
          @java.lang.Override
          public Break parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Break> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Break> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.Break getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  @java.lang.Deprecated
  public interface TravelStepOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentRoute.TravelStep)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Duration of the travel step.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 1;</code>
     *
     * @return Whether the duration field is set.
     */
    boolean hasDuration();
    /**
     *
     *
     * <pre>
     * Duration of the travel step.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 1;</code>
     *
     * @return The duration.
     */
    com.google.protobuf.Duration getDuration();
    /**
     *
     *
     * <pre>
     * Duration of the travel step.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 1;</code>
     */
    com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Distance traveled during the step.
     * </pre>
     *
     * <code>double distance_meters = 2;</code>
     *
     * @return The distanceMeters.
     */
    double getDistanceMeters();

    /**
     *
     *
     * <pre>
     * When traffic is requested via
     * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
     * and the traffic info couldn't be retrieved for a TravelStep, this boolean
     * is set to true. This may be temporary (rare hiccup in the realtime
     * traffic servers) or permanent (no data for this location).
     * </pre>
     *
     * <code>bool traffic_info_unavailable = 3;</code>
     *
     * @return The trafficInfoUnavailable.
     */
    boolean getTrafficInfoUnavailable();

    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * step.
     * This field is only populated if
     * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;</code>
     *
     * @return Whether the routePolyline field is set.
     */
    boolean hasRoutePolyline();
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * step.
     * This field is only populated if
     * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;</code>
     *
     * @return The routePolyline.
     */
    com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline getRoutePolyline();
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * step.
     * This field is only populated if
     * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;</code>
     */
    com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder
        getRoutePolylineOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.transitions][] instead.
   * Travel between each visit, along the route: from the
   * vehicle's `start_location` to the first visit's `arrival_location`, then
   * from the first visit's `departure_location` to the second visit's
   * `arrival_location`, and so on until the vehicle's `end_location`. This
   * accounts only for the actual travel between visits, not counting the
   * waiting time, the time spent performing a visit, nor the distance covered
   * during a visit.
   * Invariant: `travel_steps_size() == visits_size() + 1`.
   * If the vehicle does not have a start_ and/or end_location, the
   * corresponding travel metrics are 0 and/or empty.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.TravelStep}
   */
  @java.lang.Deprecated
  public static final class TravelStep extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentRoute.TravelStep)
      TravelStepOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TravelStep.newBuilder() to construct.
    private TravelStep(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TravelStep() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TravelStep();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_TravelStep_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_TravelStep_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.class,
              com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder.class);
    }

    public static final int DURATION_FIELD_NUMBER = 1;
    private com.google.protobuf.Duration duration_;
    /**
     *
     *
     * <pre>
     * Duration of the travel step.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 1;</code>
     *
     * @return Whether the duration field is set.
     */
    @java.lang.Override
    public boolean hasDuration() {
      return duration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Duration of the travel step.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 1;</code>
     *
     * @return The duration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getDuration() {
      return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
    }
    /**
     *
     *
     * <pre>
     * Duration of the travel step.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      return getDuration();
    }

    public static final int DISTANCE_METERS_FIELD_NUMBER = 2;
    private double distanceMeters_;
    /**
     *
     *
     * <pre>
     * Distance traveled during the step.
     * </pre>
     *
     * <code>double distance_meters = 2;</code>
     *
     * @return The distanceMeters.
     */
    @java.lang.Override
    public double getDistanceMeters() {
      return distanceMeters_;
    }

    public static final int TRAFFIC_INFO_UNAVAILABLE_FIELD_NUMBER = 3;
    private boolean trafficInfoUnavailable_;
    /**
     *
     *
     * <pre>
     * When traffic is requested via
     * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
     * and the traffic info couldn't be retrieved for a TravelStep, this boolean
     * is set to true. This may be temporary (rare hiccup in the realtime
     * traffic servers) or permanent (no data for this location).
     * </pre>
     *
     * <code>bool traffic_info_unavailable = 3;</code>
     *
     * @return The trafficInfoUnavailable.
     */
    @java.lang.Override
    public boolean getTrafficInfoUnavailable() {
      return trafficInfoUnavailable_;
    }

    public static final int ROUTE_POLYLINE_FIELD_NUMBER = 4;
    private com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline routePolyline_;
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * step.
     * This field is only populated if
     * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;</code>
     *
     * @return Whether the routePolyline field is set.
     */
    @java.lang.Override
    public boolean hasRoutePolyline() {
      return routePolyline_ != null;
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * step.
     * This field is only populated if
     * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;</code>
     *
     * @return The routePolyline.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline getRoutePolyline() {
      return routePolyline_ == null
          ? com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.getDefaultInstance()
          : routePolyline_;
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route followed during the
     * step.
     * This field is only populated if
     * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder
        getRoutePolylineOrBuilder() {
      return getRoutePolyline();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (duration_ != null) {
        output.writeMessage(1, getDuration());
      }
      if (java.lang.Double.doubleToRawLongBits(distanceMeters_) != 0) {
        output.writeDouble(2, distanceMeters_);
      }
      if (trafficInfoUnavailable_ != false) {
        output.writeBool(3, trafficInfoUnavailable_);
      }
      if (routePolyline_ != null) {
        output.writeMessage(4, getRoutePolyline());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (duration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDuration());
      }
      if (java.lang.Double.doubleToRawLongBits(distanceMeters_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, distanceMeters_);
      }
      if (trafficInfoUnavailable_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, trafficInfoUnavailable_);
      }
      if (routePolyline_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRoutePolyline());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentRoute.TravelStep)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.ShipmentRoute.TravelStep other =
          (com.google.cloud.optimization.v1.ShipmentRoute.TravelStep) obj;

      if (hasDuration() != other.hasDuration()) return false;
      if (hasDuration()) {
        if (!getDuration().equals(other.getDuration())) return false;
      }
      if (java.lang.Double.doubleToLongBits(getDistanceMeters())
          != java.lang.Double.doubleToLongBits(other.getDistanceMeters())) return false;
      if (getTrafficInfoUnavailable() != other.getTrafficInfoUnavailable()) return false;
      if (hasRoutePolyline() != other.hasRoutePolyline()) return false;
      if (hasRoutePolyline()) {
        if (!getRoutePolyline().equals(other.getRoutePolyline())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDuration()) {
        hash = (37 * hash) + DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getDuration().hashCode();
      }
      hash = (37 * hash) + DISTANCE_METERS_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getDistanceMeters()));
      hash = (37 * hash) + TRAFFIC_INFO_UNAVAILABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTrafficInfoUnavailable());
      if (hasRoutePolyline()) {
        hash = (37 * hash) + ROUTE_POLYLINE_FIELD_NUMBER;
        hash = (53 * hash) + getRoutePolyline().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.ShipmentRoute.TravelStep prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.transitions][] instead.
     * Travel between each visit, along the route: from the
     * vehicle's `start_location` to the first visit's `arrival_location`, then
     * from the first visit's `departure_location` to the second visit's
     * `arrival_location`, and so on until the vehicle's `end_location`. This
     * accounts only for the actual travel between visits, not counting the
     * waiting time, the time spent performing a visit, nor the distance covered
     * during a visit.
     * Invariant: `travel_steps_size() == visits_size() + 1`.
     * If the vehicle does not have a start_ and/or end_location, the
     * corresponding travel metrics are 0 and/or empty.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute.TravelStep}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentRoute.TravelStep)
        com.google.cloud.optimization.v1.ShipmentRoute.TravelStepOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_TravelStep_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_TravelStep_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.class,
                com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (durationBuilder_ == null) {
          duration_ = null;
        } else {
          duration_ = null;
          durationBuilder_ = null;
        }
        distanceMeters_ = 0D;

        trafficInfoUnavailable_ = false;

        if (routePolylineBuilder_ == null) {
          routePolyline_ = null;
        } else {
          routePolyline_ = null;
          routePolylineBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentRoute_TravelStep_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.TravelStep getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.TravelStep build() {
        com.google.cloud.optimization.v1.ShipmentRoute.TravelStep result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentRoute.TravelStep buildPartial() {
        com.google.cloud.optimization.v1.ShipmentRoute.TravelStep result =
            new com.google.cloud.optimization.v1.ShipmentRoute.TravelStep(this);
        if (durationBuilder_ == null) {
          result.duration_ = duration_;
        } else {
          result.duration_ = durationBuilder_.build();
        }
        result.distanceMeters_ = distanceMeters_;
        result.trafficInfoUnavailable_ = trafficInfoUnavailable_;
        if (routePolylineBuilder_ == null) {
          result.routePolyline_ = routePolyline_;
        } else {
          result.routePolyline_ = routePolylineBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.ShipmentRoute.TravelStep) {
          return mergeFrom((com.google.cloud.optimization.v1.ShipmentRoute.TravelStep) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.ShipmentRoute.TravelStep other) {
        if (other == com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.getDefaultInstance())
          return this;
        if (other.hasDuration()) {
          mergeDuration(other.getDuration());
        }
        if (other.getDistanceMeters() != 0D) {
          setDistanceMeters(other.getDistanceMeters());
        }
        if (other.getTrafficInfoUnavailable() != false) {
          setTrafficInfoUnavailable(other.getTrafficInfoUnavailable());
        }
        if (other.hasRoutePolyline()) {
          mergeRoutePolyline(other.getRoutePolyline());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 17:
                {
                  distanceMeters_ = input.readDouble();

                  break;
                } // case 17
              case 24:
                {
                  trafficInfoUnavailable_ = input.readBool();

                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(getRoutePolylineFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.protobuf.Duration duration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          durationBuilder_;
      /**
       *
       *
       * <pre>
       * Duration of the travel step.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 1;</code>
       *
       * @return Whether the duration field is set.
       */
      public boolean hasDuration() {
        return durationBuilder_ != null || duration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Duration of the travel step.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 1;</code>
       *
       * @return The duration.
       */
      public com.google.protobuf.Duration getDuration() {
        if (durationBuilder_ == null) {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        } else {
          return durationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of the travel step.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 1;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          duration_ = value;
          onChanged();
        } else {
          durationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the travel step.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 1;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (durationBuilder_ == null) {
          duration_ = builderForValue.build();
          onChanged();
        } else {
          durationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the travel step.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 1;</code>
       */
      public Builder mergeDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (duration_ != null) {
            duration_ =
                com.google.protobuf.Duration.newBuilder(duration_).mergeFrom(value).buildPartial();
          } else {
            duration_ = value;
          }
          onChanged();
        } else {
          durationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the travel step.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 1;</code>
       */
      public Builder clearDuration() {
        if (durationBuilder_ == null) {
          duration_ = null;
          onChanged();
        } else {
          duration_ = null;
          durationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the travel step.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 1;</code>
       */
      public com.google.protobuf.Duration.Builder getDurationBuilder() {

        onChanged();
        return getDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration of the travel step.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 1;</code>
       */
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        if (durationBuilder_ != null) {
          return durationBuilder_.getMessageOrBuilder();
        } else {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of the travel step.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getDurationFieldBuilder() {
        if (durationBuilder_ == null) {
          durationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getDuration(), getParentForChildren(), isClean());
          duration_ = null;
        }
        return durationBuilder_;
      }

      private double distanceMeters_;
      /**
       *
       *
       * <pre>
       * Distance traveled during the step.
       * </pre>
       *
       * <code>double distance_meters = 2;</code>
       *
       * @return The distanceMeters.
       */
      @java.lang.Override
      public double getDistanceMeters() {
        return distanceMeters_;
      }
      /**
       *
       *
       * <pre>
       * Distance traveled during the step.
       * </pre>
       *
       * <code>double distance_meters = 2;</code>
       *
       * @param value The distanceMeters to set.
       * @return This builder for chaining.
       */
      public Builder setDistanceMeters(double value) {

        distanceMeters_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Distance traveled during the step.
       * </pre>
       *
       * <code>double distance_meters = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDistanceMeters() {

        distanceMeters_ = 0D;
        onChanged();
        return this;
      }

      private boolean trafficInfoUnavailable_;
      /**
       *
       *
       * <pre>
       * When traffic is requested via
       * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
       * and the traffic info couldn't be retrieved for a TravelStep, this boolean
       * is set to true. This may be temporary (rare hiccup in the realtime
       * traffic servers) or permanent (no data for this location).
       * </pre>
       *
       * <code>bool traffic_info_unavailable = 3;</code>
       *
       * @return The trafficInfoUnavailable.
       */
      @java.lang.Override
      public boolean getTrafficInfoUnavailable() {
        return trafficInfoUnavailable_;
      }
      /**
       *
       *
       * <pre>
       * When traffic is requested via
       * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
       * and the traffic info couldn't be retrieved for a TravelStep, this boolean
       * is set to true. This may be temporary (rare hiccup in the realtime
       * traffic servers) or permanent (no data for this location).
       * </pre>
       *
       * <code>bool traffic_info_unavailable = 3;</code>
       *
       * @param value The trafficInfoUnavailable to set.
       * @return This builder for chaining.
       */
      public Builder setTrafficInfoUnavailable(boolean value) {

        trafficInfoUnavailable_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When traffic is requested via
       * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
       * and the traffic info couldn't be retrieved for a TravelStep, this boolean
       * is set to true. This may be temporary (rare hiccup in the realtime
       * traffic servers) or permanent (no data for this location).
       * </pre>
       *
       * <code>bool traffic_info_unavailable = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrafficInfoUnavailable() {

        trafficInfoUnavailable_ = false;
        onChanged();
        return this;
      }

      private com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline routePolyline_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline,
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder,
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder>
          routePolylineBuilder_;
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * step.
       * This field is only populated if
       * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;
       * </code>
       *
       * @return Whether the routePolyline field is set.
       */
      public boolean hasRoutePolyline() {
        return routePolylineBuilder_ != null || routePolyline_ != null;
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * step.
       * This field is only populated if
       * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;
       * </code>
       *
       * @return The routePolyline.
       */
      public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline getRoutePolyline() {
        if (routePolylineBuilder_ == null) {
          return routePolyline_ == null
              ? com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.getDefaultInstance()
              : routePolyline_;
        } else {
          return routePolylineBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * step.
       * This field is only populated if
       * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;
       * </code>
       */
      public Builder setRoutePolyline(
          com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline value) {
        if (routePolylineBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          routePolyline_ = value;
          onChanged();
        } else {
          routePolylineBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * step.
       * This field is only populated if
       * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;
       * </code>
       */
      public Builder setRoutePolyline(
          com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder builderForValue) {
        if (routePolylineBuilder_ == null) {
          routePolyline_ = builderForValue.build();
          onChanged();
        } else {
          routePolylineBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * step.
       * This field is only populated if
       * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;
       * </code>
       */
      public Builder mergeRoutePolyline(
          com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline value) {
        if (routePolylineBuilder_ == null) {
          if (routePolyline_ != null) {
            routePolyline_ =
                com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.newBuilder(
                        routePolyline_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            routePolyline_ = value;
          }
          onChanged();
        } else {
          routePolylineBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * step.
       * This field is only populated if
       * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;
       * </code>
       */
      public Builder clearRoutePolyline() {
        if (routePolylineBuilder_ == null) {
          routePolyline_ = null;
          onChanged();
        } else {
          routePolyline_ = null;
          routePolylineBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * step.
       * This field is only populated if
       * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder
          getRoutePolylineBuilder() {

        onChanged();
        return getRoutePolylineFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * step.
       * This field is only populated if
       * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder
          getRoutePolylineOrBuilder() {
        if (routePolylineBuilder_ != null) {
          return routePolylineBuilder_.getMessageOrBuilder();
        } else {
          return routePolyline_ == null
              ? com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.getDefaultInstance()
              : routePolyline_;
        }
      }
      /**
       *
       *
       * <pre>
       * The encoded polyline representation of the route followed during the
       * step.
       * This field is only populated if
       * [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
       * is set to true.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline,
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder,
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder>
          getRoutePolylineFieldBuilder() {
        if (routePolylineBuilder_ == null) {
          routePolylineBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline,
                  com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder,
                  com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder>(
                  getRoutePolyline(), getParentForChildren(), isClean());
          routePolyline_ = null;
        }
        return routePolylineBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentRoute.TravelStep)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentRoute.TravelStep)
    private static final com.google.cloud.optimization.v1.ShipmentRoute.TravelStep DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentRoute.TravelStep();
    }

    public static com.google.cloud.optimization.v1.ShipmentRoute.TravelStep getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TravelStep> PARSER =
        new com.google.protobuf.AbstractParser<TravelStep>() {
          @java.lang.Override
          public TravelStep parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TravelStep> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TravelStep> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.TravelStep getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int VEHICLE_INDEX_FIELD_NUMBER = 1;
  private int vehicleIndex_;
  /**
   *
   *
   * <pre>
   * Vehicle performing the route, identified by its index in the source
   * `ShipmentModel`.
   * </pre>
   *
   * <code>int32 vehicle_index = 1;</code>
   *
   * @return The vehicleIndex.
   */
  @java.lang.Override
  public int getVehicleIndex() {
    return vehicleIndex_;
  }

  public static final int VEHICLE_LABEL_FIELD_NUMBER = 2;
  private volatile java.lang.Object vehicleLabel_;
  /**
   *
   *
   * <pre>
   * Label of the vehicle performing this route, equal to
   * `ShipmentModel.vehicles(vehicle_index).label`, if specified.
   * </pre>
   *
   * <code>string vehicle_label = 2;</code>
   *
   * @return The vehicleLabel.
   */
  @java.lang.Override
  public java.lang.String getVehicleLabel() {
    java.lang.Object ref = vehicleLabel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vehicleLabel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Label of the vehicle performing this route, equal to
   * `ShipmentModel.vehicles(vehicle_index).label`, if specified.
   * </pre>
   *
   * <code>string vehicle_label = 2;</code>
   *
   * @return The bytes for vehicleLabel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVehicleLabelBytes() {
    java.lang.Object ref = vehicleLabel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vehicleLabel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VEHICLE_START_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp vehicleStartTime_;
  /**
   *
   *
   * <pre>
   * Time at which the vehicle starts its route.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
   *
   * @return Whether the vehicleStartTime field is set.
   */
  @java.lang.Override
  public boolean hasVehicleStartTime() {
    return vehicleStartTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time at which the vehicle starts its route.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
   *
   * @return The vehicleStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getVehicleStartTime() {
    return vehicleStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : vehicleStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Time at which the vehicle starts its route.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getVehicleStartTimeOrBuilder() {
    return getVehicleStartTime();
  }

  public static final int VEHICLE_END_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp vehicleEndTime_;
  /**
   *
   *
   * <pre>
   * Time at which the vehicle finishes its route.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
   *
   * @return Whether the vehicleEndTime field is set.
   */
  @java.lang.Override
  public boolean hasVehicleEndTime() {
    return vehicleEndTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time at which the vehicle finishes its route.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
   *
   * @return The vehicleEndTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getVehicleEndTime() {
    return vehicleEndTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : vehicleEndTime_;
  }
  /**
   *
   *
   * <pre>
   * Time at which the vehicle finishes its route.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getVehicleEndTimeOrBuilder() {
    return getVehicleEndTime();
  }

  public static final int VISITS_FIELD_NUMBER = 7;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Visit> visits_;
  /**
   *
   *
   * <pre>
   * Ordered sequence of visits representing a route.
   * visits[i] is the i-th visit in the route.
   * If this field is empty, the vehicle is considered as unused.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Visit> getVisitsList() {
    return visits_;
  }
  /**
   *
   *
   * <pre>
   * Ordered sequence of visits representing a route.
   * visits[i] is the i-th visit in the route.
   * If this field is empty, the vehicle is considered as unused.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRoute.VisitOrBuilder>
      getVisitsOrBuilderList() {
    return visits_;
  }
  /**
   *
   *
   * <pre>
   * Ordered sequence of visits representing a route.
   * visits[i] is the i-th visit in the route.
   * If this field is empty, the vehicle is considered as unused.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
   */
  @java.lang.Override
  public int getVisitsCount() {
    return visits_.size();
  }
  /**
   *
   *
   * <pre>
   * Ordered sequence of visits representing a route.
   * visits[i] is the i-th visit in the route.
   * If this field is empty, the vehicle is considered as unused.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute.Visit getVisits(int index) {
    return visits_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Ordered sequence of visits representing a route.
   * visits[i] is the i-th visit in the route.
   * If this field is empty, the vehicle is considered as unused.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute.VisitOrBuilder getVisitsOrBuilder(
      int index) {
    return visits_.get(index);
  }

  public static final int TRANSITIONS_FIELD_NUMBER = 8;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Transition> transitions_;
  /**
   *
   *
   * <pre>
   * Ordered list of transitions for the route.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Transition>
      getTransitionsList() {
    return transitions_;
  }
  /**
   *
   *
   * <pre>
   * Ordered list of transitions for the route.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.optimization.v1.ShipmentRoute.TransitionOrBuilder>
      getTransitionsOrBuilderList() {
    return transitions_;
  }
  /**
   *
   *
   * <pre>
   * Ordered list of transitions for the route.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
   */
  @java.lang.Override
  public int getTransitionsCount() {
    return transitions_.size();
  }
  /**
   *
   *
   * <pre>
   * Ordered list of transitions for the route.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute.Transition getTransitions(int index) {
    return transitions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Ordered list of transitions for the route.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute.TransitionOrBuilder getTransitionsOrBuilder(
      int index) {
    return transitions_.get(index);
  }

  public static final int HAS_TRAFFIC_INFEASIBILITIES_FIELD_NUMBER = 9;
  private boolean hasTrafficInfeasibilities_;
  /**
   *
   *
   * <pre>
   * When
   * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
   * is set to true, this field indicates that inconsistencies in route timings
   * are predicted using traffic-based travel duration estimates. There may be
   * insufficient time to complete traffic-adjusted travel, delays, and breaks
   * between visits, before the first visit, or after the last visit, while
   * still satisfying the visit and vehicle time windows. For example,
   *   ```start_time(previous_visit) + duration(previous_visit) +
   *   travel_duration(previous_visit, next_visit) &gt; start_time(next_visit)```
   * Arrival at next_visit will likely happen later than its current
   * time window due the increased estimate of travel time
   * `travel_duration(previous_visit, next_visit)` due to traffic. Also, a break
   * may be forced to overlap with a visit due to an increase in travel time
   * estimates and visit or break time window restrictions.
   * </pre>
   *
   * <code>bool has_traffic_infeasibilities = 9;</code>
   *
   * @return The hasTrafficInfeasibilities.
   */
  @java.lang.Override
  public boolean getHasTrafficInfeasibilities() {
    return hasTrafficInfeasibilities_;
  }

  public static final int ROUTE_POLYLINE_FIELD_NUMBER = 10;
  private com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline routePolyline_;
  /**
   *
   *
   * <pre>
   * The encoded polyline representation of the route.
   * This field is only populated if
   * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
   * is set to true.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
   *
   * @return Whether the routePolyline field is set.
   */
  @java.lang.Override
  public boolean hasRoutePolyline() {
    return routePolyline_ != null;
  }
  /**
   *
   *
   * <pre>
   * The encoded polyline representation of the route.
   * This field is only populated if
   * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
   * is set to true.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
   *
   * @return The routePolyline.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline getRoutePolyline() {
    return routePolyline_ == null
        ? com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.getDefaultInstance()
        : routePolyline_;
  }
  /**
   *
   *
   * <pre>
   * The encoded polyline representation of the route.
   * This field is only populated if
   * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
   * is set to true.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder
      getRoutePolylineOrBuilder() {
    return getRoutePolyline();
  }

  public static final int BREAKS_FIELD_NUMBER = 11;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Break> breaks_;
  /**
   *
   *
   * <pre>
   * Breaks scheduled for the vehicle performing this route.
   * The `breaks` sequence represents time intervals, each starting at the
   * corresponding `start_time` and lasting `duration` seconds.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Break> getBreaksList() {
    return breaks_;
  }
  /**
   *
   *
   * <pre>
   * Breaks scheduled for the vehicle performing this route.
   * The `breaks` sequence represents time intervals, each starting at the
   * corresponding `start_time` and lasting `duration` seconds.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRoute.BreakOrBuilder>
      getBreaksOrBuilderList() {
    return breaks_;
  }
  /**
   *
   *
   * <pre>
   * Breaks scheduled for the vehicle performing this route.
   * The `breaks` sequence represents time intervals, each starting at the
   * corresponding `start_time` and lasting `duration` seconds.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
   */
  @java.lang.Override
  public int getBreaksCount() {
    return breaks_.size();
  }
  /**
   *
   *
   * <pre>
   * Breaks scheduled for the vehicle performing this route.
   * The `breaks` sequence represents time intervals, each starting at the
   * corresponding `start_time` and lasting `duration` seconds.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute.Break getBreaks(int index) {
    return breaks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Breaks scheduled for the vehicle performing this route.
   * The `breaks` sequence represents time intervals, each starting at the
   * corresponding `start_time` and lasting `duration` seconds.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute.BreakOrBuilder getBreaksOrBuilder(
      int index) {
    return breaks_.get(index);
  }

  public static final int METRICS_FIELD_NUMBER = 12;
  private com.google.cloud.optimization.v1.AggregatedMetrics metrics_;
  /**
   *
   *
   * <pre>
   * Duration, distance and load metrics for this route. The fields of
   * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
   * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
   *
   * @return Whether the metrics field is set.
   */
  @java.lang.Override
  public boolean hasMetrics() {
    return metrics_ != null;
  }
  /**
   *
   *
   * <pre>
   * Duration, distance and load metrics for this route. The fields of
   * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
   * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
   *
   * @return The metrics.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.AggregatedMetrics getMetrics() {
    return metrics_ == null
        ? com.google.cloud.optimization.v1.AggregatedMetrics.getDefaultInstance()
        : metrics_;
  }
  /**
   *
   *
   * <pre>
   * Duration, distance and load metrics for this route. The fields of
   * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
   * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder getMetricsOrBuilder() {
    return getMetrics();
  }

  public static final int ROUTE_COSTS_FIELD_NUMBER = 17;

  private static final class RouteCostsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Double>newDefaultInstance(
            com.google.cloud.optimization.v1.FleetRoutingProto
                .internal_static_google_cloud_optimization_v1_ShipmentRoute_RouteCostsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.DOUBLE,
            0D);
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.Double> routeCosts_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Double> internalGetRouteCosts() {
    if (routeCosts_ == null) {
      return com.google.protobuf.MapField.emptyMapField(RouteCostsDefaultEntryHolder.defaultEntry);
    }
    return routeCosts_;
  }

  public int getRouteCostsCount() {
    return internalGetRouteCosts().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Cost of the route, broken down by cost-related request fields.
   * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
   * "model.shipments.pickups.cost", and the values are the total cost
   * generated by the corresponding cost field, aggregated over the whole route.
   * In other words, costs["model.shipments.pickups.cost"] is the sum of all
   * pickup costs over the route. All costs defined in the model are reported in
   * detail here with the exception of costs related to TransitionAttributes
   * that are only reported in an aggregated way as of 2022/01.
   * </pre>
   *
   * <code>map&lt;string, double&gt; route_costs = 17;</code>
   */
  @java.lang.Override
  public boolean containsRouteCosts(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetRouteCosts().getMap().containsKey(key);
  }
  /** Use {@link #getRouteCostsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Double> getRouteCosts() {
    return getRouteCostsMap();
  }
  /**
   *
   *
   * <pre>
   * Cost of the route, broken down by cost-related request fields.
   * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
   * "model.shipments.pickups.cost", and the values are the total cost
   * generated by the corresponding cost field, aggregated over the whole route.
   * In other words, costs["model.shipments.pickups.cost"] is the sum of all
   * pickup costs over the route. All costs defined in the model are reported in
   * detail here with the exception of costs related to TransitionAttributes
   * that are only reported in an aggregated way as of 2022/01.
   * </pre>
   *
   * <code>map&lt;string, double&gt; route_costs = 17;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Double> getRouteCostsMap() {
    return internalGetRouteCosts().getMap();
  }
  /**
   *
   *
   * <pre>
   * Cost of the route, broken down by cost-related request fields.
   * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
   * "model.shipments.pickups.cost", and the values are the total cost
   * generated by the corresponding cost field, aggregated over the whole route.
   * In other words, costs["model.shipments.pickups.cost"] is the sum of all
   * pickup costs over the route. All costs defined in the model are reported in
   * detail here with the exception of costs related to TransitionAttributes
   * that are only reported in an aggregated way as of 2022/01.
   * </pre>
   *
   * <code>map&lt;string, double&gt; route_costs = 17;</code>
   */
  @java.lang.Override
  public double getRouteCostsOrDefault(java.lang.String key, double defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Double> map = internalGetRouteCosts().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Cost of the route, broken down by cost-related request fields.
   * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
   * "model.shipments.pickups.cost", and the values are the total cost
   * generated by the corresponding cost field, aggregated over the whole route.
   * In other words, costs["model.shipments.pickups.cost"] is the sum of all
   * pickup costs over the route. All costs defined in the model are reported in
   * detail here with the exception of costs related to TransitionAttributes
   * that are only reported in an aggregated way as of 2022/01.
   * </pre>
   *
   * <code>map&lt;string, double&gt; route_costs = 17;</code>
   */
  @java.lang.Override
  public double getRouteCostsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Double> map = internalGetRouteCosts().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ROUTE_TOTAL_COST_FIELD_NUMBER = 18;
  private double routeTotalCost_;
  /**
   *
   *
   * <pre>
   * Total cost of the route. The sum of all costs in the cost map.
   * </pre>
   *
   * <code>double route_total_cost = 18;</code>
   *
   * @return The routeTotalCost.
   */
  @java.lang.Override
  public double getRouteTotalCost() {
    return routeTotalCost_;
  }

  public static final int END_LOADS_FIELD_NUMBER = 13;
  private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> endLoads_;
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
   * Vehicle loads upon arrival at its end location, for each
   * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
   * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
   * loads for quantity types unconstrained by intervals and that don't have any
   * non-zero demand on the route.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getEndLoadsList() {
    return endLoads_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
   * Vehicle loads upon arrival at its end location, for each
   * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
   * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
   * loads for quantity types unconstrained by intervals and that don't have any
   * non-zero demand on the route.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
      getEndLoadsOrBuilderList() {
    return endLoads_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
   * Vehicle loads upon arrival at its end location, for each
   * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
   * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
   * loads for quantity types unconstrained by intervals and that don't have any
   * non-zero demand on the route.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getEndLoadsCount() {
    return endLoads_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
   * Vehicle loads upon arrival at its end location, for each
   * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
   * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
   * loads for quantity types unconstrained by intervals and that don't have any
   * non-zero demand on the route.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.CapacityQuantity getEndLoads(int index) {
    return endLoads_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
   * Vehicle loads upon arrival at its end location, for each
   * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
   * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
   * loads for quantity types unconstrained by intervals and that don't have any
   * non-zero demand on the route.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getEndLoadsOrBuilder(
      int index) {
    return endLoads_.get(index);
  }

  public static final int TRAVEL_STEPS_FIELD_NUMBER = 14;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.TravelStep> travelSteps_;
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition][] instead.
   * Ordered list of travel steps for the route.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.TravelStep>
      getTravelStepsList() {
    return travelSteps_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition][] instead.
   * Ordered list of travel steps for the route.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<
          ? extends com.google.cloud.optimization.v1.ShipmentRoute.TravelStepOrBuilder>
      getTravelStepsOrBuilderList() {
    return travelSteps_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition][] instead.
   * Ordered list of travel steps for the route.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getTravelStepsCount() {
    return travelSteps_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition][] instead.
   * Ordered list of travel steps for the route.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.ShipmentRoute.TravelStep getTravelSteps(int index) {
    return travelSteps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition][] instead.
   * Ordered list of travel steps for the route.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.ShipmentRoute.TravelStepOrBuilder getTravelStepsOrBuilder(
      int index) {
    return travelSteps_.get(index);
  }

  public static final int VEHICLE_DETOUR_FIELD_NUMBER = 15;
  private com.google.protobuf.Duration vehicleDetour_;
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * This field will only be populated at the
   * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
   * Extra detour time due to the shipments visited on the route.
   * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
   * from the vehicle's start_location to its `end_location`.
   * </pre>
   *
   * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.ShipmentRoute.vehicle_detour is deprecated. See
   *     google/cloud/optimization/v1/fleet_routing.proto;l=2052
   * @return Whether the vehicleDetour field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasVehicleDetour() {
    return vehicleDetour_ != null;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * This field will only be populated at the
   * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
   * Extra detour time due to the shipments visited on the route.
   * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
   * from the vehicle's start_location to its `end_location`.
   * </pre>
   *
   * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.ShipmentRoute.vehicle_detour is deprecated. See
   *     google/cloud/optimization/v1/fleet_routing.proto;l=2052
   * @return The vehicleDetour.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.Duration getVehicleDetour() {
    return vehicleDetour_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : vehicleDetour_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * This field will only be populated at the
   * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
   * Extra detour time due to the shipments visited on the route.
   * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
   * from the vehicle's start_location to its `end_location`.
   * </pre>
   *
   * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.DurationOrBuilder getVehicleDetourOrBuilder() {
    return getVehicleDetour();
  }

  public static final int DELAY_BEFORE_VEHICLE_END_FIELD_NUMBER = 16;
  private com.google.cloud.optimization.v1.ShipmentRoute.Delay delayBeforeVehicleEnd_;
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
   * Delay occurring before the vehicle end. See
   * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
   * </pre>
   *
   * <code>
   * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.optimization.v1.ShipmentRoute.delay_before_vehicle_end is deprecated.
   *     See google/cloud/optimization/v1/fleet_routing.proto;l=2057
   * @return Whether the delayBeforeVehicleEnd field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasDelayBeforeVehicleEnd() {
    return delayBeforeVehicleEnd_ != null;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
   * Delay occurring before the vehicle end. See
   * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
   * </pre>
   *
   * <code>
   * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.optimization.v1.ShipmentRoute.delay_before_vehicle_end is deprecated.
   *     See google/cloud/optimization/v1/fleet_routing.proto;l=2057
   * @return The delayBeforeVehicleEnd.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.ShipmentRoute.Delay getDelayBeforeVehicleEnd() {
    return delayBeforeVehicleEnd_ == null
        ? com.google.cloud.optimization.v1.ShipmentRoute.Delay.getDefaultInstance()
        : delayBeforeVehicleEnd_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
   * Delay occurring before the vehicle end. See
   * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
   * </pre>
   *
   * <code>
   * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder
      getDelayBeforeVehicleEndOrBuilder() {
    return getDelayBeforeVehicleEnd();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (vehicleIndex_ != 0) {
      output.writeInt32(1, vehicleIndex_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vehicleLabel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, vehicleLabel_);
    }
    if (vehicleStartTime_ != null) {
      output.writeMessage(5, getVehicleStartTime());
    }
    if (vehicleEndTime_ != null) {
      output.writeMessage(6, getVehicleEndTime());
    }
    for (int i = 0; i < visits_.size(); i++) {
      output.writeMessage(7, visits_.get(i));
    }
    for (int i = 0; i < transitions_.size(); i++) {
      output.writeMessage(8, transitions_.get(i));
    }
    if (hasTrafficInfeasibilities_ != false) {
      output.writeBool(9, hasTrafficInfeasibilities_);
    }
    if (routePolyline_ != null) {
      output.writeMessage(10, getRoutePolyline());
    }
    for (int i = 0; i < breaks_.size(); i++) {
      output.writeMessage(11, breaks_.get(i));
    }
    if (metrics_ != null) {
      output.writeMessage(12, getMetrics());
    }
    for (int i = 0; i < endLoads_.size(); i++) {
      output.writeMessage(13, endLoads_.get(i));
    }
    for (int i = 0; i < travelSteps_.size(); i++) {
      output.writeMessage(14, travelSteps_.get(i));
    }
    if (vehicleDetour_ != null) {
      output.writeMessage(15, getVehicleDetour());
    }
    if (delayBeforeVehicleEnd_ != null) {
      output.writeMessage(16, getDelayBeforeVehicleEnd());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetRouteCosts(), RouteCostsDefaultEntryHolder.defaultEntry, 17);
    if (java.lang.Double.doubleToRawLongBits(routeTotalCost_) != 0) {
      output.writeDouble(18, routeTotalCost_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (vehicleIndex_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, vehicleIndex_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vehicleLabel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, vehicleLabel_);
    }
    if (vehicleStartTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getVehicleStartTime());
    }
    if (vehicleEndTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getVehicleEndTime());
    }
    for (int i = 0; i < visits_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, visits_.get(i));
    }
    for (int i = 0; i < transitions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, transitions_.get(i));
    }
    if (hasTrafficInfeasibilities_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, hasTrafficInfeasibilities_);
    }
    if (routePolyline_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getRoutePolyline());
    }
    for (int i = 0; i < breaks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, breaks_.get(i));
    }
    if (metrics_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getMetrics());
    }
    for (int i = 0; i < endLoads_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, endLoads_.get(i));
    }
    for (int i = 0; i < travelSteps_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, travelSteps_.get(i));
    }
    if (vehicleDetour_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getVehicleDetour());
    }
    if (delayBeforeVehicleEnd_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(16, getDelayBeforeVehicleEnd());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Double> entry :
        internalGetRouteCosts().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> routeCosts__ =
          RouteCostsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, routeCosts__);
    }
    if (java.lang.Double.doubleToRawLongBits(routeTotalCost_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(18, routeTotalCost_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentRoute)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.ShipmentRoute other =
        (com.google.cloud.optimization.v1.ShipmentRoute) obj;

    if (getVehicleIndex() != other.getVehicleIndex()) return false;
    if (!getVehicleLabel().equals(other.getVehicleLabel())) return false;
    if (hasVehicleStartTime() != other.hasVehicleStartTime()) return false;
    if (hasVehicleStartTime()) {
      if (!getVehicleStartTime().equals(other.getVehicleStartTime())) return false;
    }
    if (hasVehicleEndTime() != other.hasVehicleEndTime()) return false;
    if (hasVehicleEndTime()) {
      if (!getVehicleEndTime().equals(other.getVehicleEndTime())) return false;
    }
    if (!getVisitsList().equals(other.getVisitsList())) return false;
    if (!getTransitionsList().equals(other.getTransitionsList())) return false;
    if (getHasTrafficInfeasibilities() != other.getHasTrafficInfeasibilities()) return false;
    if (hasRoutePolyline() != other.hasRoutePolyline()) return false;
    if (hasRoutePolyline()) {
      if (!getRoutePolyline().equals(other.getRoutePolyline())) return false;
    }
    if (!getBreaksList().equals(other.getBreaksList())) return false;
    if (hasMetrics() != other.hasMetrics()) return false;
    if (hasMetrics()) {
      if (!getMetrics().equals(other.getMetrics())) return false;
    }
    if (!internalGetRouteCosts().equals(other.internalGetRouteCosts())) return false;
    if (java.lang.Double.doubleToLongBits(getRouteTotalCost())
        != java.lang.Double.doubleToLongBits(other.getRouteTotalCost())) return false;
    if (!getEndLoadsList().equals(other.getEndLoadsList())) return false;
    if (!getTravelStepsList().equals(other.getTravelStepsList())) return false;
    if (hasVehicleDetour() != other.hasVehicleDetour()) return false;
    if (hasVehicleDetour()) {
      if (!getVehicleDetour().equals(other.getVehicleDetour())) return false;
    }
    if (hasDelayBeforeVehicleEnd() != other.hasDelayBeforeVehicleEnd()) return false;
    if (hasDelayBeforeVehicleEnd()) {
      if (!getDelayBeforeVehicleEnd().equals(other.getDelayBeforeVehicleEnd())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VEHICLE_INDEX_FIELD_NUMBER;
    hash = (53 * hash) + getVehicleIndex();
    hash = (37 * hash) + VEHICLE_LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getVehicleLabel().hashCode();
    if (hasVehicleStartTime()) {
      hash = (37 * hash) + VEHICLE_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getVehicleStartTime().hashCode();
    }
    if (hasVehicleEndTime()) {
      hash = (37 * hash) + VEHICLE_END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getVehicleEndTime().hashCode();
    }
    if (getVisitsCount() > 0) {
      hash = (37 * hash) + VISITS_FIELD_NUMBER;
      hash = (53 * hash) + getVisitsList().hashCode();
    }
    if (getTransitionsCount() > 0) {
      hash = (37 * hash) + TRANSITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTransitionsList().hashCode();
    }
    hash = (37 * hash) + HAS_TRAFFIC_INFEASIBILITIES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasTrafficInfeasibilities());
    if (hasRoutePolyline()) {
      hash = (37 * hash) + ROUTE_POLYLINE_FIELD_NUMBER;
      hash = (53 * hash) + getRoutePolyline().hashCode();
    }
    if (getBreaksCount() > 0) {
      hash = (37 * hash) + BREAKS_FIELD_NUMBER;
      hash = (53 * hash) + getBreaksList().hashCode();
    }
    if (hasMetrics()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrics().hashCode();
    }
    if (!internalGetRouteCosts().getMap().isEmpty()) {
      hash = (37 * hash) + ROUTE_COSTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetRouteCosts().hashCode();
    }
    hash = (37 * hash) + ROUTE_TOTAL_COST_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getRouteTotalCost()));
    if (getEndLoadsCount() > 0) {
      hash = (37 * hash) + END_LOADS_FIELD_NUMBER;
      hash = (53 * hash) + getEndLoadsList().hashCode();
    }
    if (getTravelStepsCount() > 0) {
      hash = (37 * hash) + TRAVEL_STEPS_FIELD_NUMBER;
      hash = (53 * hash) + getTravelStepsList().hashCode();
    }
    if (hasVehicleDetour()) {
      hash = (37 * hash) + VEHICLE_DETOUR_FIELD_NUMBER;
      hash = (53 * hash) + getVehicleDetour().hashCode();
    }
    if (hasDelayBeforeVehicleEnd()) {
      hash = (37 * hash) + DELAY_BEFORE_VEHICLE_END_FIELD_NUMBER;
      hash = (53 * hash) + getDelayBeforeVehicleEnd().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.optimization.v1.ShipmentRoute prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A vehicle's route can be decomposed, along the time axis, like this (we
   * assume there are n visits):
   * ```
   *   |            |            |          |       |  T[2], |        |      |
   *   | Transition |  Visit #0  |          |       |  V[2], |        |      |
   *   |     #0     |    aka     |   T[1]   |  V[1] |  ...   | V[n-1] | T[n] |
   *   |  aka T[0]  |    V[0]    |          |       | V[n-2],|        |      |
   *   |            |            |          |       | T[n-1] |        |      |
   *   ^            ^            ^          ^       ^        ^        ^      ^
   * vehicle    V[0].start   V[0].end     V[1].   V[1].    V[n].    V[n]. vehicle
   *  start     (arrival)   (departure)   start   end      start    end     end
   * ```
   * Note that we make a difference between:
   * * "punctual events", such as the vehicle start and end and each visit's start
   *   and end (aka arrival and departure). They happen at a given second.
   * * "time intervals", such as the visits themselves, and the transition between
   *   visits. Though time intervals can sometimes have zero duration, i.e. start
   *   and end at the same second, they often have a positive duration.
   * Invariants:
   * * If there are n visits, there are n+1 transitions.
   * * A visit is always surrounded by a transition before it (same index) and a
   *   transition after it (index + 1).
   * * The vehicle start is always followed by transition #0.
   * * The vehicle end is always preceded by transition #n.
   * Zooming in, here is what happens during a `Transition` and a `Visit`:
   * ```
   * ---+-------------------------------------+-----------------------------+--&gt;
   *    |           TRANSITION[i]             |           VISIT[i]          |
   *    |                                     |                             |
   *    |  * TRAVEL: the vehicle moves from   |      PERFORM the visit:     |
   *    |    VISIT[i-1].departure_location to |                             |
   *    |    VISIT[i].arrival_location, which |  * Spend some time:         |
   *    |    takes a given travel duration    |    the "visit duration".    |
   *    |    and distance                     |                             |
   *    |                                     |  * Load or unload           |
   *    |  * BREAKS: the driver may have      |    some quantities from the |
   *    |    breaks (e.g. lunch break).       |    vehicle: the "demand".   |
   *    |                                     |                             |
   *    |  * WAIT: the driver/vehicle does    |                             |
   *    |    nothing. This can happen for     |                             |
   *    |    many reasons, for example when   |                             |
   *    |    the vehicle reaches the next     |                             |
   *    |    event's destination before the   |                             |
   *    |    start of its time window         |                             |
   *    |                                     |                             |
   *    |  * DELAY: *right before* the next   |                             |
   *    |    arrival. E.g. the vehicle and/or |                             |
   *    |    driver spends time unloading.    |                             |
   *    |                                     |                             |
   * ---+-------------------------------------+-----------------------------+--&gt;
   *    ^                                     ^                             ^
   * V[i-1].end                           V[i].start                    V[i].end
   * ```
   * Lastly, here is how the TRAVEL, BREAKS, DELAY and WAIT can be arranged
   * during a transition.
   * * They don't overlap.
   * * The DELAY is unique and *must* be a contiguous period of time right
   *   before the next visit (or vehicle end). Thus, it suffice to know the
   *   delay duration to know its start and end time.
   * * The BREAKS are contiguous, non-overlapping periods of time. The
   *   response specifies the start time and duration of each break.
   * * TRAVEL and WAIT are "preemptable": they can be interrupted several times
   *   during this transition. Clients can assume that travel happens "as soon as
   *   possible" and that "wait" fills the remaining time.
   * A (complex) example:
   * ```
   *                                TRANSITION[i]
   * --++-----+-----------------------------------------------------------++--&gt;
   *   ||     |       |           |       |           |         |         ||
   *   ||  T  |   B   |     T     |       |     B     |         |    D    ||
   *   ||  r  |   r   |     r     |   W   |     r     |    W    |    e    ||
   *   ||  a  |   e   |     a     |   a   |     e     |    a    |    l    ||
   *   ||  v  |   a   |     v     |   i   |     a     |    i    |    a    ||
   *   ||  e  |   k   |     e     |   t   |     k     |    t    |    y    ||
   *   ||  l  |       |     l     |       |           |         |         ||
   *   ||     |       |           |       |           |         |         ||
   * --++-----------------------------------------------------------------++--&gt;
   * ```
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentRoute}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentRoute)
      com.google.cloud.optimization.v1.ShipmentRouteOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 17:
          return internalGetRouteCosts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 17:
          return internalGetMutableRouteCosts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentRoute.class,
              com.google.cloud.optimization.v1.ShipmentRoute.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.ShipmentRoute.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      vehicleIndex_ = 0;

      vehicleLabel_ = "";

      if (vehicleStartTimeBuilder_ == null) {
        vehicleStartTime_ = null;
      } else {
        vehicleStartTime_ = null;
        vehicleStartTimeBuilder_ = null;
      }
      if (vehicleEndTimeBuilder_ == null) {
        vehicleEndTime_ = null;
      } else {
        vehicleEndTime_ = null;
        vehicleEndTimeBuilder_ = null;
      }
      if (visitsBuilder_ == null) {
        visits_ = java.util.Collections.emptyList();
      } else {
        visits_ = null;
        visitsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (transitionsBuilder_ == null) {
        transitions_ = java.util.Collections.emptyList();
      } else {
        transitions_ = null;
        transitionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      hasTrafficInfeasibilities_ = false;

      if (routePolylineBuilder_ == null) {
        routePolyline_ = null;
      } else {
        routePolyline_ = null;
        routePolylineBuilder_ = null;
      }
      if (breaksBuilder_ == null) {
        breaks_ = java.util.Collections.emptyList();
      } else {
        breaks_ = null;
        breaksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (metricsBuilder_ == null) {
        metrics_ = null;
      } else {
        metrics_ = null;
        metricsBuilder_ = null;
      }
      internalGetMutableRouteCosts().clear();
      routeTotalCost_ = 0D;

      if (endLoadsBuilder_ == null) {
        endLoads_ = java.util.Collections.emptyList();
      } else {
        endLoads_ = null;
        endLoadsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (travelStepsBuilder_ == null) {
        travelSteps_ = java.util.Collections.emptyList();
      } else {
        travelSteps_ = null;
        travelStepsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (vehicleDetourBuilder_ == null) {
        vehicleDetour_ = null;
      } else {
        vehicleDetour_ = null;
        vehicleDetourBuilder_ = null;
      }
      if (delayBeforeVehicleEndBuilder_ == null) {
        delayBeforeVehicleEnd_ = null;
      } else {
        delayBeforeVehicleEnd_ = null;
        delayBeforeVehicleEndBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentRoute_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.ShipmentRoute.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute build() {
      com.google.cloud.optimization.v1.ShipmentRoute result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute buildPartial() {
      com.google.cloud.optimization.v1.ShipmentRoute result =
          new com.google.cloud.optimization.v1.ShipmentRoute(this);
      int from_bitField0_ = bitField0_;
      result.vehicleIndex_ = vehicleIndex_;
      result.vehicleLabel_ = vehicleLabel_;
      if (vehicleStartTimeBuilder_ == null) {
        result.vehicleStartTime_ = vehicleStartTime_;
      } else {
        result.vehicleStartTime_ = vehicleStartTimeBuilder_.build();
      }
      if (vehicleEndTimeBuilder_ == null) {
        result.vehicleEndTime_ = vehicleEndTime_;
      } else {
        result.vehicleEndTime_ = vehicleEndTimeBuilder_.build();
      }
      if (visitsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          visits_ = java.util.Collections.unmodifiableList(visits_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.visits_ = visits_;
      } else {
        result.visits_ = visitsBuilder_.build();
      }
      if (transitionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          transitions_ = java.util.Collections.unmodifiableList(transitions_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.transitions_ = transitions_;
      } else {
        result.transitions_ = transitionsBuilder_.build();
      }
      result.hasTrafficInfeasibilities_ = hasTrafficInfeasibilities_;
      if (routePolylineBuilder_ == null) {
        result.routePolyline_ = routePolyline_;
      } else {
        result.routePolyline_ = routePolylineBuilder_.build();
      }
      if (breaksBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          breaks_ = java.util.Collections.unmodifiableList(breaks_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.breaks_ = breaks_;
      } else {
        result.breaks_ = breaksBuilder_.build();
      }
      if (metricsBuilder_ == null) {
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      result.routeCosts_ = internalGetRouteCosts();
      result.routeCosts_.makeImmutable();
      result.routeTotalCost_ = routeTotalCost_;
      if (endLoadsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          endLoads_ = java.util.Collections.unmodifiableList(endLoads_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.endLoads_ = endLoads_;
      } else {
        result.endLoads_ = endLoadsBuilder_.build();
      }
      if (travelStepsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          travelSteps_ = java.util.Collections.unmodifiableList(travelSteps_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.travelSteps_ = travelSteps_;
      } else {
        result.travelSteps_ = travelStepsBuilder_.build();
      }
      if (vehicleDetourBuilder_ == null) {
        result.vehicleDetour_ = vehicleDetour_;
      } else {
        result.vehicleDetour_ = vehicleDetourBuilder_.build();
      }
      if (delayBeforeVehicleEndBuilder_ == null) {
        result.delayBeforeVehicleEnd_ = delayBeforeVehicleEnd_;
      } else {
        result.delayBeforeVehicleEnd_ = delayBeforeVehicleEndBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.ShipmentRoute) {
        return mergeFrom((com.google.cloud.optimization.v1.ShipmentRoute) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.ShipmentRoute other) {
      if (other == com.google.cloud.optimization.v1.ShipmentRoute.getDefaultInstance()) return this;
      if (other.getVehicleIndex() != 0) {
        setVehicleIndex(other.getVehicleIndex());
      }
      if (!other.getVehicleLabel().isEmpty()) {
        vehicleLabel_ = other.vehicleLabel_;
        onChanged();
      }
      if (other.hasVehicleStartTime()) {
        mergeVehicleStartTime(other.getVehicleStartTime());
      }
      if (other.hasVehicleEndTime()) {
        mergeVehicleEndTime(other.getVehicleEndTime());
      }
      if (visitsBuilder_ == null) {
        if (!other.visits_.isEmpty()) {
          if (visits_.isEmpty()) {
            visits_ = other.visits_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureVisitsIsMutable();
            visits_.addAll(other.visits_);
          }
          onChanged();
        }
      } else {
        if (!other.visits_.isEmpty()) {
          if (visitsBuilder_.isEmpty()) {
            visitsBuilder_.dispose();
            visitsBuilder_ = null;
            visits_ = other.visits_;
            bitField0_ = (bitField0_ & ~0x00000001);
            visitsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVisitsFieldBuilder()
                    : null;
          } else {
            visitsBuilder_.addAllMessages(other.visits_);
          }
        }
      }
      if (transitionsBuilder_ == null) {
        if (!other.transitions_.isEmpty()) {
          if (transitions_.isEmpty()) {
            transitions_ = other.transitions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTransitionsIsMutable();
            transitions_.addAll(other.transitions_);
          }
          onChanged();
        }
      } else {
        if (!other.transitions_.isEmpty()) {
          if (transitionsBuilder_.isEmpty()) {
            transitionsBuilder_.dispose();
            transitionsBuilder_ = null;
            transitions_ = other.transitions_;
            bitField0_ = (bitField0_ & ~0x00000002);
            transitionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTransitionsFieldBuilder()
                    : null;
          } else {
            transitionsBuilder_.addAllMessages(other.transitions_);
          }
        }
      }
      if (other.getHasTrafficInfeasibilities() != false) {
        setHasTrafficInfeasibilities(other.getHasTrafficInfeasibilities());
      }
      if (other.hasRoutePolyline()) {
        mergeRoutePolyline(other.getRoutePolyline());
      }
      if (breaksBuilder_ == null) {
        if (!other.breaks_.isEmpty()) {
          if (breaks_.isEmpty()) {
            breaks_ = other.breaks_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureBreaksIsMutable();
            breaks_.addAll(other.breaks_);
          }
          onChanged();
        }
      } else {
        if (!other.breaks_.isEmpty()) {
          if (breaksBuilder_.isEmpty()) {
            breaksBuilder_.dispose();
            breaksBuilder_ = null;
            breaks_ = other.breaks_;
            bitField0_ = (bitField0_ & ~0x00000004);
            breaksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBreaksFieldBuilder()
                    : null;
          } else {
            breaksBuilder_.addAllMessages(other.breaks_);
          }
        }
      }
      if (other.hasMetrics()) {
        mergeMetrics(other.getMetrics());
      }
      internalGetMutableRouteCosts().mergeFrom(other.internalGetRouteCosts());
      if (other.getRouteTotalCost() != 0D) {
        setRouteTotalCost(other.getRouteTotalCost());
      }
      if (endLoadsBuilder_ == null) {
        if (!other.endLoads_.isEmpty()) {
          if (endLoads_.isEmpty()) {
            endLoads_ = other.endLoads_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureEndLoadsIsMutable();
            endLoads_.addAll(other.endLoads_);
          }
          onChanged();
        }
      } else {
        if (!other.endLoads_.isEmpty()) {
          if (endLoadsBuilder_.isEmpty()) {
            endLoadsBuilder_.dispose();
            endLoadsBuilder_ = null;
            endLoads_ = other.endLoads_;
            bitField0_ = (bitField0_ & ~0x00000010);
            endLoadsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEndLoadsFieldBuilder()
                    : null;
          } else {
            endLoadsBuilder_.addAllMessages(other.endLoads_);
          }
        }
      }
      if (travelStepsBuilder_ == null) {
        if (!other.travelSteps_.isEmpty()) {
          if (travelSteps_.isEmpty()) {
            travelSteps_ = other.travelSteps_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureTravelStepsIsMutable();
            travelSteps_.addAll(other.travelSteps_);
          }
          onChanged();
        }
      } else {
        if (!other.travelSteps_.isEmpty()) {
          if (travelStepsBuilder_.isEmpty()) {
            travelStepsBuilder_.dispose();
            travelStepsBuilder_ = null;
            travelSteps_ = other.travelSteps_;
            bitField0_ = (bitField0_ & ~0x00000020);
            travelStepsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTravelStepsFieldBuilder()
                    : null;
          } else {
            travelStepsBuilder_.addAllMessages(other.travelSteps_);
          }
        }
      }
      if (other.hasVehicleDetour()) {
        mergeVehicleDetour(other.getVehicleDetour());
      }
      if (other.hasDelayBeforeVehicleEnd()) {
        mergeDelayBeforeVehicleEnd(other.getDelayBeforeVehicleEnd());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                vehicleIndex_ = input.readInt32();

                break;
              } // case 8
            case 18:
              {
                vehicleLabel_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 42:
              {
                input.readMessage(
                    getVehicleStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getVehicleEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                com.google.cloud.optimization.v1.ShipmentRoute.Visit m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentRoute.Visit.parser(),
                        extensionRegistry);
                if (visitsBuilder_ == null) {
                  ensureVisitsIsMutable();
                  visits_.add(m);
                } else {
                  visitsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.optimization.v1.ShipmentRoute.Transition m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentRoute.Transition.parser(),
                        extensionRegistry);
                if (transitionsBuilder_ == null) {
                  ensureTransitionsIsMutable();
                  transitions_.add(m);
                } else {
                  transitionsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 72:
              {
                hasTrafficInfeasibilities_ = input.readBool();

                break;
              } // case 72
            case 82:
              {
                input.readMessage(getRoutePolylineFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 82
            case 90:
              {
                com.google.cloud.optimization.v1.ShipmentRoute.Break m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentRoute.Break.parser(),
                        extensionRegistry);
                if (breaksBuilder_ == null) {
                  ensureBreaksIsMutable();
                  breaks_.add(m);
                } else {
                  breaksBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getMetricsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 98
            case 106:
              {
                com.google.cloud.optimization.v1.CapacityQuantity m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.CapacityQuantity.parser(),
                        extensionRegistry);
                if (endLoadsBuilder_ == null) {
                  ensureEndLoadsIsMutable();
                  endLoads_.add(m);
                } else {
                  endLoadsBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                com.google.cloud.optimization.v1.ShipmentRoute.TravelStep m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.parser(),
                        extensionRegistry);
                if (travelStepsBuilder_ == null) {
                  ensureTravelStepsIsMutable();
                  travelSteps_.add(m);
                } else {
                  travelStepsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getVehicleDetourFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 122
            case 130:
              {
                input.readMessage(
                    getDelayBeforeVehicleEndFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 130
            case 138:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> routeCosts__ =
                    input.readMessage(
                        RouteCostsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableRouteCosts()
                    .getMutableMap()
                    .put(routeCosts__.getKey(), routeCosts__.getValue());
                break;
              } // case 138
            case 145:
              {
                routeTotalCost_ = input.readDouble();

                break;
              } // case 145
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int vehicleIndex_;
    /**
     *
     *
     * <pre>
     * Vehicle performing the route, identified by its index in the source
     * `ShipmentModel`.
     * </pre>
     *
     * <code>int32 vehicle_index = 1;</code>
     *
     * @return The vehicleIndex.
     */
    @java.lang.Override
    public int getVehicleIndex() {
      return vehicleIndex_;
    }
    /**
     *
     *
     * <pre>
     * Vehicle performing the route, identified by its index in the source
     * `ShipmentModel`.
     * </pre>
     *
     * <code>int32 vehicle_index = 1;</code>
     *
     * @param value The vehicleIndex to set.
     * @return This builder for chaining.
     */
    public Builder setVehicleIndex(int value) {

      vehicleIndex_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vehicle performing the route, identified by its index in the source
     * `ShipmentModel`.
     * </pre>
     *
     * <code>int32 vehicle_index = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVehicleIndex() {

      vehicleIndex_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object vehicleLabel_ = "";
    /**
     *
     *
     * <pre>
     * Label of the vehicle performing this route, equal to
     * `ShipmentModel.vehicles(vehicle_index).label`, if specified.
     * </pre>
     *
     * <code>string vehicle_label = 2;</code>
     *
     * @return The vehicleLabel.
     */
    public java.lang.String getVehicleLabel() {
      java.lang.Object ref = vehicleLabel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vehicleLabel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Label of the vehicle performing this route, equal to
     * `ShipmentModel.vehicles(vehicle_index).label`, if specified.
     * </pre>
     *
     * <code>string vehicle_label = 2;</code>
     *
     * @return The bytes for vehicleLabel.
     */
    public com.google.protobuf.ByteString getVehicleLabelBytes() {
      java.lang.Object ref = vehicleLabel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vehicleLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Label of the vehicle performing this route, equal to
     * `ShipmentModel.vehicles(vehicle_index).label`, if specified.
     * </pre>
     *
     * <code>string vehicle_label = 2;</code>
     *
     * @param value The vehicleLabel to set.
     * @return This builder for chaining.
     */
    public Builder setVehicleLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      vehicleLabel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label of the vehicle performing this route, equal to
     * `ShipmentModel.vehicles(vehicle_index).label`, if specified.
     * </pre>
     *
     * <code>string vehicle_label = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVehicleLabel() {

      vehicleLabel_ = getDefaultInstance().getVehicleLabel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label of the vehicle performing this route, equal to
     * `ShipmentModel.vehicles(vehicle_index).label`, if specified.
     * </pre>
     *
     * <code>string vehicle_label = 2;</code>
     *
     * @param value The bytes for vehicleLabel to set.
     * @return This builder for chaining.
     */
    public Builder setVehicleLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      vehicleLabel_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp vehicleStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        vehicleStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time at which the vehicle starts its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     *
     * @return Whether the vehicleStartTime field is set.
     */
    public boolean hasVehicleStartTime() {
      return vehicleStartTimeBuilder_ != null || vehicleStartTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle starts its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     *
     * @return The vehicleStartTime.
     */
    public com.google.protobuf.Timestamp getVehicleStartTime() {
      if (vehicleStartTimeBuilder_ == null) {
        return vehicleStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : vehicleStartTime_;
      } else {
        return vehicleStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle starts its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     */
    public Builder setVehicleStartTime(com.google.protobuf.Timestamp value) {
      if (vehicleStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vehicleStartTime_ = value;
        onChanged();
      } else {
        vehicleStartTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle starts its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     */
    public Builder setVehicleStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (vehicleStartTimeBuilder_ == null) {
        vehicleStartTime_ = builderForValue.build();
        onChanged();
      } else {
        vehicleStartTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle starts its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     */
    public Builder mergeVehicleStartTime(com.google.protobuf.Timestamp value) {
      if (vehicleStartTimeBuilder_ == null) {
        if (vehicleStartTime_ != null) {
          vehicleStartTime_ =
              com.google.protobuf.Timestamp.newBuilder(vehicleStartTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vehicleStartTime_ = value;
        }
        onChanged();
      } else {
        vehicleStartTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle starts its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     */
    public Builder clearVehicleStartTime() {
      if (vehicleStartTimeBuilder_ == null) {
        vehicleStartTime_ = null;
        onChanged();
      } else {
        vehicleStartTime_ = null;
        vehicleStartTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle starts its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getVehicleStartTimeBuilder() {

      onChanged();
      return getVehicleStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle starts its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getVehicleStartTimeOrBuilder() {
      if (vehicleStartTimeBuilder_ != null) {
        return vehicleStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return vehicleStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : vehicleStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle starts its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_start_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getVehicleStartTimeFieldBuilder() {
      if (vehicleStartTimeBuilder_ == null) {
        vehicleStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getVehicleStartTime(), getParentForChildren(), isClean());
        vehicleStartTime_ = null;
      }
      return vehicleStartTimeBuilder_;
    }

    private com.google.protobuf.Timestamp vehicleEndTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        vehicleEndTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time at which the vehicle finishes its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     *
     * @return Whether the vehicleEndTime field is set.
     */
    public boolean hasVehicleEndTime() {
      return vehicleEndTimeBuilder_ != null || vehicleEndTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle finishes its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     *
     * @return The vehicleEndTime.
     */
    public com.google.protobuf.Timestamp getVehicleEndTime() {
      if (vehicleEndTimeBuilder_ == null) {
        return vehicleEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : vehicleEndTime_;
      } else {
        return vehicleEndTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle finishes its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     */
    public Builder setVehicleEndTime(com.google.protobuf.Timestamp value) {
      if (vehicleEndTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vehicleEndTime_ = value;
        onChanged();
      } else {
        vehicleEndTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle finishes its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     */
    public Builder setVehicleEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (vehicleEndTimeBuilder_ == null) {
        vehicleEndTime_ = builderForValue.build();
        onChanged();
      } else {
        vehicleEndTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle finishes its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     */
    public Builder mergeVehicleEndTime(com.google.protobuf.Timestamp value) {
      if (vehicleEndTimeBuilder_ == null) {
        if (vehicleEndTime_ != null) {
          vehicleEndTime_ =
              com.google.protobuf.Timestamp.newBuilder(vehicleEndTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vehicleEndTime_ = value;
        }
        onChanged();
      } else {
        vehicleEndTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle finishes its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     */
    public Builder clearVehicleEndTime() {
      if (vehicleEndTimeBuilder_ == null) {
        vehicleEndTime_ = null;
        onChanged();
      } else {
        vehicleEndTime_ = null;
        vehicleEndTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle finishes its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getVehicleEndTimeBuilder() {

      onChanged();
      return getVehicleEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle finishes its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getVehicleEndTimeOrBuilder() {
      if (vehicleEndTimeBuilder_ != null) {
        return vehicleEndTimeBuilder_.getMessageOrBuilder();
      } else {
        return vehicleEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : vehicleEndTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time at which the vehicle finishes its route.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp vehicle_end_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getVehicleEndTimeFieldBuilder() {
      if (vehicleEndTimeBuilder_ == null) {
        vehicleEndTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getVehicleEndTime(), getParentForChildren(), isClean());
        vehicleEndTime_ = null;
      }
      return vehicleEndTimeBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Visit> visits_ =
        java.util.Collections.emptyList();

    private void ensureVisitsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        visits_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentRoute.Visit>(visits_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.Visit,
            com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.VisitOrBuilder>
        visitsBuilder_;

    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Visit> getVisitsList() {
      if (visitsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(visits_);
      } else {
        return visitsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public int getVisitsCount() {
      if (visitsBuilder_ == null) {
        return visits_.size();
      } else {
        return visitsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Visit getVisits(int index) {
      if (visitsBuilder_ == null) {
        return visits_.get(index);
      } else {
        return visitsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public Builder setVisits(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Visit value) {
      if (visitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVisitsIsMutable();
        visits_.set(index, value);
        onChanged();
      } else {
        visitsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public Builder setVisits(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder builderForValue) {
      if (visitsBuilder_ == null) {
        ensureVisitsIsMutable();
        visits_.set(index, builderForValue.build());
        onChanged();
      } else {
        visitsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public Builder addVisits(com.google.cloud.optimization.v1.ShipmentRoute.Visit value) {
      if (visitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVisitsIsMutable();
        visits_.add(value);
        onChanged();
      } else {
        visitsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public Builder addVisits(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Visit value) {
      if (visitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVisitsIsMutable();
        visits_.add(index, value);
        onChanged();
      } else {
        visitsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public Builder addVisits(
        com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder builderForValue) {
      if (visitsBuilder_ == null) {
        ensureVisitsIsMutable();
        visits_.add(builderForValue.build());
        onChanged();
      } else {
        visitsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public Builder addVisits(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder builderForValue) {
      if (visitsBuilder_ == null) {
        ensureVisitsIsMutable();
        visits_.add(index, builderForValue.build());
        onChanged();
      } else {
        visitsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public Builder addAllVisits(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentRoute.Visit> values) {
      if (visitsBuilder_ == null) {
        ensureVisitsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, visits_);
        onChanged();
      } else {
        visitsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public Builder clearVisits() {
      if (visitsBuilder_ == null) {
        visits_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        visitsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public Builder removeVisits(int index) {
      if (visitsBuilder_ == null) {
        ensureVisitsIsMutable();
        visits_.remove(index);
        onChanged();
      } else {
        visitsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder getVisitsBuilder(
        int index) {
      return getVisitsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.VisitOrBuilder getVisitsOrBuilder(
        int index) {
      if (visitsBuilder_ == null) {
        return visits_.get(index);
      } else {
        return visitsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRoute.VisitOrBuilder>
        getVisitsOrBuilderList() {
      if (visitsBuilder_ != null) {
        return visitsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(visits_);
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder addVisitsBuilder() {
      return getVisitsFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.ShipmentRoute.Visit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder addVisitsBuilder(
        int index) {
      return getVisitsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.ShipmentRoute.Visit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Ordered sequence of visits representing a route.
     * visits[i] is the i-th visit in the route.
     * If this field is empty, the vehicle is considered as unused.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Visit visits = 7;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder>
        getVisitsBuilderList() {
      return getVisitsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.Visit,
            com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.VisitOrBuilder>
        getVisitsFieldBuilder() {
      if (visitsBuilder_ == null) {
        visitsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentRoute.Visit,
                com.google.cloud.optimization.v1.ShipmentRoute.Visit.Builder,
                com.google.cloud.optimization.v1.ShipmentRoute.VisitOrBuilder>(
                visits_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        visits_ = null;
      }
      return visitsBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Transition> transitions_ =
        java.util.Collections.emptyList();

    private void ensureTransitionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        transitions_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentRoute.Transition>(
                transitions_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.Transition,
            com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.TransitionOrBuilder>
        transitionsBuilder_;

    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Transition>
        getTransitionsList() {
      if (transitionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(transitions_);
      } else {
        return transitionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public int getTransitionsCount() {
      if (transitionsBuilder_ == null) {
        return transitions_.size();
      } else {
        return transitionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Transition getTransitions(int index) {
      if (transitionsBuilder_ == null) {
        return transitions_.get(index);
      } else {
        return transitionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public Builder setTransitions(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Transition value) {
      if (transitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionsIsMutable();
        transitions_.set(index, value);
        onChanged();
      } else {
        transitionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public Builder setTransitions(
        int index,
        com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder builderForValue) {
      if (transitionsBuilder_ == null) {
        ensureTransitionsIsMutable();
        transitions_.set(index, builderForValue.build());
        onChanged();
      } else {
        transitionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public Builder addTransitions(com.google.cloud.optimization.v1.ShipmentRoute.Transition value) {
      if (transitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionsIsMutable();
        transitions_.add(value);
        onChanged();
      } else {
        transitionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public Builder addTransitions(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Transition value) {
      if (transitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionsIsMutable();
        transitions_.add(index, value);
        onChanged();
      } else {
        transitionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public Builder addTransitions(
        com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder builderForValue) {
      if (transitionsBuilder_ == null) {
        ensureTransitionsIsMutable();
        transitions_.add(builderForValue.build());
        onChanged();
      } else {
        transitionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public Builder addTransitions(
        int index,
        com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder builderForValue) {
      if (transitionsBuilder_ == null) {
        ensureTransitionsIsMutable();
        transitions_.add(index, builderForValue.build());
        onChanged();
      } else {
        transitionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public Builder addAllTransitions(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentRoute.Transition>
            values) {
      if (transitionsBuilder_ == null) {
        ensureTransitionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transitions_);
        onChanged();
      } else {
        transitionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public Builder clearTransitions() {
      if (transitionsBuilder_ == null) {
        transitions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        transitionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public Builder removeTransitions(int index) {
      if (transitionsBuilder_ == null) {
        ensureTransitionsIsMutable();
        transitions_.remove(index);
        onChanged();
      } else {
        transitionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder getTransitionsBuilder(
        int index) {
      return getTransitionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.TransitionOrBuilder
        getTransitionsOrBuilder(int index) {
      if (transitionsBuilder_ == null) {
        return transitions_.get(index);
      } else {
        return transitionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.ShipmentRoute.TransitionOrBuilder>
        getTransitionsOrBuilderList() {
      if (transitionsBuilder_ != null) {
        return transitionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(transitions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder
        addTransitionsBuilder() {
      return getTransitionsFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.ShipmentRoute.Transition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder addTransitionsBuilder(
        int index) {
      return getTransitionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.ShipmentRoute.Transition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Ordered list of transitions for the route.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Transition transitions = 8;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder>
        getTransitionsBuilderList() {
      return getTransitionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.Transition,
            com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.TransitionOrBuilder>
        getTransitionsFieldBuilder() {
      if (transitionsBuilder_ == null) {
        transitionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentRoute.Transition,
                com.google.cloud.optimization.v1.ShipmentRoute.Transition.Builder,
                com.google.cloud.optimization.v1.ShipmentRoute.TransitionOrBuilder>(
                transitions_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        transitions_ = null;
      }
      return transitionsBuilder_;
    }

    private boolean hasTrafficInfeasibilities_;
    /**
     *
     *
     * <pre>
     * When
     * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
     * is set to true, this field indicates that inconsistencies in route timings
     * are predicted using traffic-based travel duration estimates. There may be
     * insufficient time to complete traffic-adjusted travel, delays, and breaks
     * between visits, before the first visit, or after the last visit, while
     * still satisfying the visit and vehicle time windows. For example,
     *   ```start_time(previous_visit) + duration(previous_visit) +
     *   travel_duration(previous_visit, next_visit) &gt; start_time(next_visit)```
     * Arrival at next_visit will likely happen later than its current
     * time window due the increased estimate of travel time
     * `travel_duration(previous_visit, next_visit)` due to traffic. Also, a break
     * may be forced to overlap with a visit due to an increase in travel time
     * estimates and visit or break time window restrictions.
     * </pre>
     *
     * <code>bool has_traffic_infeasibilities = 9;</code>
     *
     * @return The hasTrafficInfeasibilities.
     */
    @java.lang.Override
    public boolean getHasTrafficInfeasibilities() {
      return hasTrafficInfeasibilities_;
    }
    /**
     *
     *
     * <pre>
     * When
     * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
     * is set to true, this field indicates that inconsistencies in route timings
     * are predicted using traffic-based travel duration estimates. There may be
     * insufficient time to complete traffic-adjusted travel, delays, and breaks
     * between visits, before the first visit, or after the last visit, while
     * still satisfying the visit and vehicle time windows. For example,
     *   ```start_time(previous_visit) + duration(previous_visit) +
     *   travel_duration(previous_visit, next_visit) &gt; start_time(next_visit)```
     * Arrival at next_visit will likely happen later than its current
     * time window due the increased estimate of travel time
     * `travel_duration(previous_visit, next_visit)` due to traffic. Also, a break
     * may be forced to overlap with a visit due to an increase in travel time
     * estimates and visit or break time window restrictions.
     * </pre>
     *
     * <code>bool has_traffic_infeasibilities = 9;</code>
     *
     * @param value The hasTrafficInfeasibilities to set.
     * @return This builder for chaining.
     */
    public Builder setHasTrafficInfeasibilities(boolean value) {

      hasTrafficInfeasibilities_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When
     * [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
     * is set to true, this field indicates that inconsistencies in route timings
     * are predicted using traffic-based travel duration estimates. There may be
     * insufficient time to complete traffic-adjusted travel, delays, and breaks
     * between visits, before the first visit, or after the last visit, while
     * still satisfying the visit and vehicle time windows. For example,
     *   ```start_time(previous_visit) + duration(previous_visit) +
     *   travel_duration(previous_visit, next_visit) &gt; start_time(next_visit)```
     * Arrival at next_visit will likely happen later than its current
     * time window due the increased estimate of travel time
     * `travel_duration(previous_visit, next_visit)` due to traffic. Also, a break
     * may be forced to overlap with a visit due to an increase in travel time
     * estimates and visit or break time window restrictions.
     * </pre>
     *
     * <code>bool has_traffic_infeasibilities = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHasTrafficInfeasibilities() {

      hasTrafficInfeasibilities_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline routePolyline_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline,
            com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder>
        routePolylineBuilder_;
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     *
     * @return Whether the routePolyline field is set.
     */
    public boolean hasRoutePolyline() {
      return routePolylineBuilder_ != null || routePolyline_ != null;
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     *
     * @return The routePolyline.
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline getRoutePolyline() {
      if (routePolylineBuilder_ == null) {
        return routePolyline_ == null
            ? com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.getDefaultInstance()
            : routePolyline_;
      } else {
        return routePolylineBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     */
    public Builder setRoutePolyline(
        com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline value) {
      if (routePolylineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        routePolyline_ = value;
        onChanged();
      } else {
        routePolylineBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     */
    public Builder setRoutePolyline(
        com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder builderForValue) {
      if (routePolylineBuilder_ == null) {
        routePolyline_ = builderForValue.build();
        onChanged();
      } else {
        routePolylineBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     */
    public Builder mergeRoutePolyline(
        com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline value) {
      if (routePolylineBuilder_ == null) {
        if (routePolyline_ != null) {
          routePolyline_ =
              com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.newBuilder(
                      routePolyline_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          routePolyline_ = value;
        }
        onChanged();
      } else {
        routePolylineBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     */
    public Builder clearRoutePolyline() {
      if (routePolylineBuilder_ == null) {
        routePolyline_ = null;
        onChanged();
      } else {
        routePolyline_ = null;
        routePolylineBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder
        getRoutePolylineBuilder() {

      onChanged();
      return getRoutePolylineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder
        getRoutePolylineOrBuilder() {
      if (routePolylineBuilder_ != null) {
        return routePolylineBuilder_.getMessageOrBuilder();
      } else {
        return routePolyline_ == null
            ? com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.getDefaultInstance()
            : routePolyline_;
      }
    }
    /**
     *
     *
     * <pre>
     * The encoded polyline representation of the route.
     * This field is only populated if
     * [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
     * is set to true.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline route_polyline = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline,
            com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder>
        getRoutePolylineFieldBuilder() {
      if (routePolylineBuilder_ == null) {
        routePolylineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline,
                com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline.Builder,
                com.google.cloud.optimization.v1.ShipmentRoute.EncodedPolylineOrBuilder>(
                getRoutePolyline(), getParentForChildren(), isClean());
        routePolyline_ = null;
      }
      return routePolylineBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Break> breaks_ =
        java.util.Collections.emptyList();

    private void ensureBreaksIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        breaks_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentRoute.Break>(breaks_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.Break,
            com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.BreakOrBuilder>
        breaksBuilder_;

    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Break> getBreaksList() {
      if (breaksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(breaks_);
      } else {
        return breaksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public int getBreaksCount() {
      if (breaksBuilder_ == null) {
        return breaks_.size();
      } else {
        return breaksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Break getBreaks(int index) {
      if (breaksBuilder_ == null) {
        return breaks_.get(index);
      } else {
        return breaksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public Builder setBreaks(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Break value) {
      if (breaksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBreaksIsMutable();
        breaks_.set(index, value);
        onChanged();
      } else {
        breaksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public Builder setBreaks(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder builderForValue) {
      if (breaksBuilder_ == null) {
        ensureBreaksIsMutable();
        breaks_.set(index, builderForValue.build());
        onChanged();
      } else {
        breaksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public Builder addBreaks(com.google.cloud.optimization.v1.ShipmentRoute.Break value) {
      if (breaksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBreaksIsMutable();
        breaks_.add(value);
        onChanged();
      } else {
        breaksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public Builder addBreaks(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Break value) {
      if (breaksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBreaksIsMutable();
        breaks_.add(index, value);
        onChanged();
      } else {
        breaksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public Builder addBreaks(
        com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder builderForValue) {
      if (breaksBuilder_ == null) {
        ensureBreaksIsMutable();
        breaks_.add(builderForValue.build());
        onChanged();
      } else {
        breaksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public Builder addBreaks(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder builderForValue) {
      if (breaksBuilder_ == null) {
        ensureBreaksIsMutable();
        breaks_.add(index, builderForValue.build());
        onChanged();
      } else {
        breaksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public Builder addAllBreaks(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentRoute.Break> values) {
      if (breaksBuilder_ == null) {
        ensureBreaksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, breaks_);
        onChanged();
      } else {
        breaksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public Builder clearBreaks() {
      if (breaksBuilder_ == null) {
        breaks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        breaksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public Builder removeBreaks(int index) {
      if (breaksBuilder_ == null) {
        ensureBreaksIsMutable();
        breaks_.remove(index);
        onChanged();
      } else {
        breaksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder getBreaksBuilder(
        int index) {
      return getBreaksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.BreakOrBuilder getBreaksOrBuilder(
        int index) {
      if (breaksBuilder_ == null) {
        return breaks_.get(index);
      } else {
        return breaksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRoute.BreakOrBuilder>
        getBreaksOrBuilderList() {
      if (breaksBuilder_ != null) {
        return breaksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(breaks_);
      }
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder addBreaksBuilder() {
      return getBreaksFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.ShipmentRoute.Break.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder addBreaksBuilder(
        int index) {
      return getBreaksFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.ShipmentRoute.Break.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Breaks scheduled for the vehicle performing this route.
     * The `breaks` sequence represents time intervals, each starting at the
     * corresponding `start_time` and lasting `duration` seconds.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute.Break breaks = 11;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder>
        getBreaksBuilderList() {
      return getBreaksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.Break,
            com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.BreakOrBuilder>
        getBreaksFieldBuilder() {
      if (breaksBuilder_ == null) {
        breaksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentRoute.Break,
                com.google.cloud.optimization.v1.ShipmentRoute.Break.Builder,
                com.google.cloud.optimization.v1.ShipmentRoute.BreakOrBuilder>(
                breaks_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        breaks_ = null;
      }
      return breaksBuilder_;
    }

    private com.google.cloud.optimization.v1.AggregatedMetrics metrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.AggregatedMetrics,
            com.google.cloud.optimization.v1.AggregatedMetrics.Builder,
            com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder>
        metricsBuilder_;
    /**
     *
     *
     * <pre>
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     *
     * @return Whether the metrics field is set.
     */
    public boolean hasMetrics() {
      return metricsBuilder_ != null || metrics_ != null;
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     *
     * @return The metrics.
     */
    public com.google.cloud.optimization.v1.AggregatedMetrics getMetrics() {
      if (metricsBuilder_ == null) {
        return metrics_ == null
            ? com.google.cloud.optimization.v1.AggregatedMetrics.getDefaultInstance()
            : metrics_;
      } else {
        return metricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     */
    public Builder setMetrics(com.google.cloud.optimization.v1.AggregatedMetrics value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        metricsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     */
    public Builder setMetrics(
        com.google.cloud.optimization.v1.AggregatedMetrics.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        metricsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     */
    public Builder mergeMetrics(com.google.cloud.optimization.v1.AggregatedMetrics value) {
      if (metricsBuilder_ == null) {
        if (metrics_ != null) {
          metrics_ =
              com.google.cloud.optimization.v1.AggregatedMetrics.newBuilder(metrics_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        metricsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = null;
        onChanged();
      } else {
        metrics_ = null;
        metricsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     */
    public com.google.cloud.optimization.v1.AggregatedMetrics.Builder getMetricsBuilder() {

      onChanged();
      return getMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     */
    public com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder getMetricsOrBuilder() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilder();
      } else {
        return metrics_ == null
            ? com.google.cloud.optimization.v1.AggregatedMetrics.getDefaultInstance()
            : metrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and load metrics for this route. The fields of
     * [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are summed over all [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions] or
     * [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits], depending on the context.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics metrics = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.AggregatedMetrics,
            com.google.cloud.optimization.v1.AggregatedMetrics.Builder,
            com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.AggregatedMetrics,
                com.google.cloud.optimization.v1.AggregatedMetrics.Builder,
                com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder>(
                getMetrics(), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double> routeCosts_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double>
        internalGetRouteCosts() {
      if (routeCosts_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            RouteCostsDefaultEntryHolder.defaultEntry);
      }
      return routeCosts_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double>
        internalGetMutableRouteCosts() {
      onChanged();
      ;
      if (routeCosts_ == null) {
        routeCosts_ =
            com.google.protobuf.MapField.newMapField(RouteCostsDefaultEntryHolder.defaultEntry);
      }
      if (!routeCosts_.isMutable()) {
        routeCosts_ = routeCosts_.copy();
      }
      return routeCosts_;
    }

    public int getRouteCostsCount() {
      return internalGetRouteCosts().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Cost of the route, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
     * "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole route.
     * In other words, costs["model.shipments.pickups.cost"] is the sum of all
     * pickup costs over the route. All costs defined in the model are reported in
     * detail here with the exception of costs related to TransitionAttributes
     * that are only reported in an aggregated way as of 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; route_costs = 17;</code>
     */
    @java.lang.Override
    public boolean containsRouteCosts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetRouteCosts().getMap().containsKey(key);
    }
    /** Use {@link #getRouteCostsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Double> getRouteCosts() {
      return getRouteCostsMap();
    }
    /**
     *
     *
     * <pre>
     * Cost of the route, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
     * "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole route.
     * In other words, costs["model.shipments.pickups.cost"] is the sum of all
     * pickup costs over the route. All costs defined in the model are reported in
     * detail here with the exception of costs related to TransitionAttributes
     * that are only reported in an aggregated way as of 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; route_costs = 17;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Double> getRouteCostsMap() {
      return internalGetRouteCosts().getMap();
    }
    /**
     *
     *
     * <pre>
     * Cost of the route, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
     * "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole route.
     * In other words, costs["model.shipments.pickups.cost"] is the sum of all
     * pickup costs over the route. All costs defined in the model are reported in
     * detail here with the exception of costs related to TransitionAttributes
     * that are only reported in an aggregated way as of 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; route_costs = 17;</code>
     */
    @java.lang.Override
    public double getRouteCostsOrDefault(java.lang.String key, double defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetRouteCosts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Cost of the route, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
     * "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole route.
     * In other words, costs["model.shipments.pickups.cost"] is the sum of all
     * pickup costs over the route. All costs defined in the model are reported in
     * detail here with the exception of costs related to TransitionAttributes
     * that are only reported in an aggregated way as of 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; route_costs = 17;</code>
     */
    @java.lang.Override
    public double getRouteCostsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetRouteCosts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearRouteCosts() {
      internalGetMutableRouteCosts().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cost of the route, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
     * "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole route.
     * In other words, costs["model.shipments.pickups.cost"] is the sum of all
     * pickup costs over the route. All costs defined in the model are reported in
     * detail here with the exception of costs related to TransitionAttributes
     * that are only reported in an aggregated way as of 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; route_costs = 17;</code>
     */
    public Builder removeRouteCosts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableRouteCosts().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Double> getMutableRouteCosts() {
      return internalGetMutableRouteCosts().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Cost of the route, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
     * "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole route.
     * In other words, costs["model.shipments.pickups.cost"] is the sum of all
     * pickup costs over the route. All costs defined in the model are reported in
     * detail here with the exception of costs related to TransitionAttributes
     * that are only reported in an aggregated way as of 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; route_costs = 17;</code>
     */
    public Builder putRouteCosts(java.lang.String key, double value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableRouteCosts().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cost of the route, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
     * "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole route.
     * In other words, costs["model.shipments.pickups.cost"] is the sum of all
     * pickup costs over the route. All costs defined in the model are reported in
     * detail here with the exception of costs related to TransitionAttributes
     * that are only reported in an aggregated way as of 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; route_costs = 17;</code>
     */
    public Builder putAllRouteCosts(java.util.Map<java.lang.String, java.lang.Double> values) {
      internalGetMutableRouteCosts().getMutableMap().putAll(values);
      return this;
    }

    private double routeTotalCost_;
    /**
     *
     *
     * <pre>
     * Total cost of the route. The sum of all costs in the cost map.
     * </pre>
     *
     * <code>double route_total_cost = 18;</code>
     *
     * @return The routeTotalCost.
     */
    @java.lang.Override
    public double getRouteTotalCost() {
      return routeTotalCost_;
    }
    /**
     *
     *
     * <pre>
     * Total cost of the route. The sum of all costs in the cost map.
     * </pre>
     *
     * <code>double route_total_cost = 18;</code>
     *
     * @param value The routeTotalCost to set.
     * @return This builder for chaining.
     */
    public Builder setRouteTotalCost(double value) {

      routeTotalCost_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total cost of the route. The sum of all costs in the cost map.
     * </pre>
     *
     * <code>double route_total_cost = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouteTotalCost() {

      routeTotalCost_ = 0D;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> endLoads_ =
        java.util.Collections.emptyList();

    private void ensureEndLoadsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        endLoads_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.CapacityQuantity>(endLoads_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.CapacityQuantity,
            com.google.cloud.optimization.v1.CapacityQuantity.Builder,
            com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        endLoadsBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getEndLoadsList() {
      if (endLoadsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(endLoads_);
      } else {
        return endLoadsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getEndLoadsCount() {
      if (endLoadsBuilder_ == null) {
        return endLoads_.size();
      } else {
        return endLoadsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity getEndLoads(int index) {
      if (endLoadsBuilder_ == null) {
        return endLoads_.get(index);
      } else {
        return endLoadsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setEndLoads(int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
      if (endLoadsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndLoadsIsMutable();
        endLoads_.set(index, value);
        onChanged();
      } else {
        endLoadsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setEndLoads(
        int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
      if (endLoadsBuilder_ == null) {
        ensureEndLoadsIsMutable();
        endLoads_.set(index, builderForValue.build());
        onChanged();
      } else {
        endLoadsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addEndLoads(com.google.cloud.optimization.v1.CapacityQuantity value) {
      if (endLoadsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndLoadsIsMutable();
        endLoads_.add(value);
        onChanged();
      } else {
        endLoadsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addEndLoads(int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
      if (endLoadsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndLoadsIsMutable();
        endLoads_.add(index, value);
        onChanged();
      } else {
        endLoadsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addEndLoads(
        com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
      if (endLoadsBuilder_ == null) {
        ensureEndLoadsIsMutable();
        endLoads_.add(builderForValue.build());
        onChanged();
      } else {
        endLoadsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addEndLoads(
        int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
      if (endLoadsBuilder_ == null) {
        ensureEndLoadsIsMutable();
        endLoads_.add(index, builderForValue.build());
        onChanged();
      } else {
        endLoadsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllEndLoads(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.CapacityQuantity> values) {
      if (endLoadsBuilder_ == null) {
        ensureEndLoadsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, endLoads_);
        onChanged();
      } else {
        endLoadsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearEndLoads() {
      if (endLoadsBuilder_ == null) {
        endLoads_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        endLoadsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeEndLoads(int index) {
      if (endLoadsBuilder_ == null) {
        ensureEndLoadsIsMutable();
        endLoads_.remove(index);
        onChanged();
      } else {
        endLoadsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity.Builder getEndLoadsBuilder(int index) {
      return getEndLoadsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getEndLoadsOrBuilder(
        int index) {
      if (endLoadsBuilder_ == null) {
        return endLoads_.get(index);
      } else {
        return endLoadsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getEndLoadsOrBuilderList() {
      if (endLoadsBuilder_ != null) {
        return endLoadsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(endLoads_);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity.Builder addEndLoadsBuilder() {
      return getEndLoadsFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity.Builder addEndLoadsBuilder(int index) {
      return getEndLoadsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.loads][] instead.
     * Vehicle loads upon arrival at its end location, for each
     * type specified in [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
     * `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
     * loads for quantity types unconstrained by intervals and that don't have any
     * non-zero demand on the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity end_loads = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity.Builder>
        getEndLoadsBuilderList() {
      return getEndLoadsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.CapacityQuantity,
            com.google.cloud.optimization.v1.CapacityQuantity.Builder,
            com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getEndLoadsFieldBuilder() {
      if (endLoadsBuilder_ == null) {
        endLoadsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.CapacityQuantity,
                com.google.cloud.optimization.v1.CapacityQuantity.Builder,
                com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>(
                endLoads_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        endLoads_ = null;
      }
      return endLoadsBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.TravelStep> travelSteps_ =
        java.util.Collections.emptyList();

    private void ensureTravelStepsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        travelSteps_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentRoute.TravelStep>(
                travelSteps_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.TravelStep,
            com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.TravelStepOrBuilder>
        travelStepsBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.TravelStep>
        getTravelStepsList() {
      if (travelStepsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(travelSteps_);
      } else {
        return travelStepsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getTravelStepsCount() {
      if (travelStepsBuilder_ == null) {
        return travelSteps_.size();
      } else {
        return travelStepsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentRoute.TravelStep getTravelSteps(int index) {
      if (travelStepsBuilder_ == null) {
        return travelSteps_.get(index);
      } else {
        return travelStepsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setTravelSteps(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.TravelStep value) {
      if (travelStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTravelStepsIsMutable();
        travelSteps_.set(index, value);
        onChanged();
      } else {
        travelStepsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setTravelSteps(
        int index,
        com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder builderForValue) {
      if (travelStepsBuilder_ == null) {
        ensureTravelStepsIsMutable();
        travelSteps_.set(index, builderForValue.build());
        onChanged();
      } else {
        travelStepsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addTravelSteps(com.google.cloud.optimization.v1.ShipmentRoute.TravelStep value) {
      if (travelStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTravelStepsIsMutable();
        travelSteps_.add(value);
        onChanged();
      } else {
        travelStepsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addTravelSteps(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.TravelStep value) {
      if (travelStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTravelStepsIsMutable();
        travelSteps_.add(index, value);
        onChanged();
      } else {
        travelStepsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addTravelSteps(
        com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder builderForValue) {
      if (travelStepsBuilder_ == null) {
        ensureTravelStepsIsMutable();
        travelSteps_.add(builderForValue.build());
        onChanged();
      } else {
        travelStepsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addTravelSteps(
        int index,
        com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder builderForValue) {
      if (travelStepsBuilder_ == null) {
        ensureTravelStepsIsMutable();
        travelSteps_.add(index, builderForValue.build());
        onChanged();
      } else {
        travelStepsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllTravelSteps(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentRoute.TravelStep>
            values) {
      if (travelStepsBuilder_ == null) {
        ensureTravelStepsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, travelSteps_);
        onChanged();
      } else {
        travelStepsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearTravelSteps() {
      if (travelStepsBuilder_ == null) {
        travelSteps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        travelStepsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeTravelSteps(int index) {
      if (travelStepsBuilder_ == null) {
        ensureTravelStepsIsMutable();
        travelSteps_.remove(index);
        onChanged();
      } else {
        travelStepsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder getTravelStepsBuilder(
        int index) {
      return getTravelStepsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentRoute.TravelStepOrBuilder
        getTravelStepsOrBuilder(int index) {
      if (travelStepsBuilder_ == null) {
        return travelSteps_.get(index);
      } else {
        return travelStepsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.ShipmentRoute.TravelStepOrBuilder>
        getTravelStepsOrBuilderList() {
      if (travelStepsBuilder_ != null) {
        return travelStepsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(travelSteps_);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder
        addTravelStepsBuilder() {
      return getTravelStepsFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder addTravelStepsBuilder(
        int index) {
      return getTravelStepsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition][] instead.
     * Ordered list of travel steps for the route.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute.TravelStep travel_steps = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder>
        getTravelStepsBuilderList() {
      return getTravelStepsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.TravelStep,
            com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.TravelStepOrBuilder>
        getTravelStepsFieldBuilder() {
      if (travelStepsBuilder_ == null) {
        travelStepsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentRoute.TravelStep,
                com.google.cloud.optimization.v1.ShipmentRoute.TravelStep.Builder,
                com.google.cloud.optimization.v1.ShipmentRoute.TravelStepOrBuilder>(
                travelSteps_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        travelSteps_ = null;
      }
      return travelStepsBuilder_;
    }

    private com.google.protobuf.Duration vehicleDetour_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        vehicleDetourBuilder_;
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
     * Extra detour time due to the shipments visited on the route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     * </pre>
     *
     * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.ShipmentRoute.vehicle_detour is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=2052
     * @return Whether the vehicleDetour field is set.
     */
    @java.lang.Deprecated
    public boolean hasVehicleDetour() {
      return vehicleDetourBuilder_ != null || vehicleDetour_ != null;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
     * Extra detour time due to the shipments visited on the route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     * </pre>
     *
     * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.ShipmentRoute.vehicle_detour is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=2052
     * @return The vehicleDetour.
     */
    @java.lang.Deprecated
    public com.google.protobuf.Duration getVehicleDetour() {
      if (vehicleDetourBuilder_ == null) {
        return vehicleDetour_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : vehicleDetour_;
      } else {
        return vehicleDetourBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
     * Extra detour time due to the shipments visited on the route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     * </pre>
     *
     * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setVehicleDetour(com.google.protobuf.Duration value) {
      if (vehicleDetourBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vehicleDetour_ = value;
        onChanged();
      } else {
        vehicleDetourBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
     * Extra detour time due to the shipments visited on the route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     * </pre>
     *
     * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setVehicleDetour(com.google.protobuf.Duration.Builder builderForValue) {
      if (vehicleDetourBuilder_ == null) {
        vehicleDetour_ = builderForValue.build();
        onChanged();
      } else {
        vehicleDetourBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
     * Extra detour time due to the shipments visited on the route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     * </pre>
     *
     * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeVehicleDetour(com.google.protobuf.Duration value) {
      if (vehicleDetourBuilder_ == null) {
        if (vehicleDetour_ != null) {
          vehicleDetour_ =
              com.google.protobuf.Duration.newBuilder(vehicleDetour_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vehicleDetour_ = value;
        }
        onChanged();
      } else {
        vehicleDetourBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
     * Extra detour time due to the shipments visited on the route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     * </pre>
     *
     * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearVehicleDetour() {
      if (vehicleDetourBuilder_ == null) {
        vehicleDetour_ = null;
        onChanged();
      } else {
        vehicleDetour_ = null;
        vehicleDetourBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
     * Extra detour time due to the shipments visited on the route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     * </pre>
     *
     * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.Duration.Builder getVehicleDetourBuilder() {

      onChanged();
      return getVehicleDetourFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
     * Extra detour time due to the shipments visited on the route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     * </pre>
     *
     * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.DurationOrBuilder getVehicleDetourOrBuilder() {
      if (vehicleDetourBuilder_ != null) {
        return vehicleDetourBuilder_.getMessageOrBuilder();
      } else {
        return vehicleDetour_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : vehicleDetour_;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * This field will only be populated at the
     * [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] level.
     * Extra detour time due to the shipments visited on the route.
     * It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
     * from the vehicle's start_location to its `end_location`.
     * </pre>
     *
     * <code>.google.protobuf.Duration vehicle_detour = 15 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getVehicleDetourFieldBuilder() {
      if (vehicleDetourBuilder_ == null) {
        vehicleDetourBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getVehicleDetour(), getParentForChildren(), isClean());
        vehicleDetour_ = null;
      }
      return vehicleDetourBuilder_;
    }

    private com.google.cloud.optimization.v1.ShipmentRoute.Delay delayBeforeVehicleEnd_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.Delay,
            com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder>
        delayBeforeVehicleEndBuilder_;
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.optimization.v1.ShipmentRoute.delay_before_vehicle_end is
     *     deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=2057
     * @return Whether the delayBeforeVehicleEnd field is set.
     */
    @java.lang.Deprecated
    public boolean hasDelayBeforeVehicleEnd() {
      return delayBeforeVehicleEndBuilder_ != null || delayBeforeVehicleEnd_ != null;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.optimization.v1.ShipmentRoute.delay_before_vehicle_end is
     *     deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=2057
     * @return The delayBeforeVehicleEnd.
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentRoute.Delay getDelayBeforeVehicleEnd() {
      if (delayBeforeVehicleEndBuilder_ == null) {
        return delayBeforeVehicleEnd_ == null
            ? com.google.cloud.optimization.v1.ShipmentRoute.Delay.getDefaultInstance()
            : delayBeforeVehicleEnd_;
      } else {
        return delayBeforeVehicleEndBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDelayBeforeVehicleEnd(
        com.google.cloud.optimization.v1.ShipmentRoute.Delay value) {
      if (delayBeforeVehicleEndBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        delayBeforeVehicleEnd_ = value;
        onChanged();
      } else {
        delayBeforeVehicleEndBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDelayBeforeVehicleEnd(
        com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder builderForValue) {
      if (delayBeforeVehicleEndBuilder_ == null) {
        delayBeforeVehicleEnd_ = builderForValue.build();
        onChanged();
      } else {
        delayBeforeVehicleEndBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeDelayBeforeVehicleEnd(
        com.google.cloud.optimization.v1.ShipmentRoute.Delay value) {
      if (delayBeforeVehicleEndBuilder_ == null) {
        if (delayBeforeVehicleEnd_ != null) {
          delayBeforeVehicleEnd_ =
              com.google.cloud.optimization.v1.ShipmentRoute.Delay.newBuilder(
                      delayBeforeVehicleEnd_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          delayBeforeVehicleEnd_ = value;
        }
        onChanged();
      } else {
        delayBeforeVehicleEndBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearDelayBeforeVehicleEnd() {
      if (delayBeforeVehicleEndBuilder_ == null) {
        delayBeforeVehicleEnd_ = null;
        onChanged();
      } else {
        delayBeforeVehicleEnd_ = null;
        delayBeforeVehicleEndBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder
        getDelayBeforeVehicleEndBuilder() {

      onChanged();
      return getDelayBeforeVehicleEndFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder
        getDelayBeforeVehicleEndOrBuilder() {
      if (delayBeforeVehicleEndBuilder_ != null) {
        return delayBeforeVehicleEndBuilder_.getMessageOrBuilder();
      } else {
        return delayBeforeVehicleEnd_ == null
            ? com.google.cloud.optimization.v1.ShipmentRoute.Delay.getDefaultInstance()
            : delayBeforeVehicleEnd_;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.Transition.delay_duration][] instead.
     * Delay occurring before the vehicle end. See
     * [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.ShipmentRoute.Delay delay_before_vehicle_end = 16 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute.Delay,
            com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder,
            com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder>
        getDelayBeforeVehicleEndFieldBuilder() {
      if (delayBeforeVehicleEndBuilder_ == null) {
        delayBeforeVehicleEndBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentRoute.Delay,
                com.google.cloud.optimization.v1.ShipmentRoute.Delay.Builder,
                com.google.cloud.optimization.v1.ShipmentRoute.DelayOrBuilder>(
                getDelayBeforeVehicleEnd(), getParentForChildren(), isClean());
        delayBeforeVehicleEnd_ = null;
      }
      return delayBeforeVehicleEndBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentRoute)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentRoute)
  private static final com.google.cloud.optimization.v1.ShipmentRoute DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentRoute();
  }

  public static com.google.cloud.optimization.v1.ShipmentRoute getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ShipmentRoute> PARSER =
      new com.google.protobuf.AbstractParser<ShipmentRoute>() {
        @java.lang.Override
        public ShipmentRoute parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ShipmentRoute> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ShipmentRoute> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
