/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

public interface ShipmentModelOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentModel)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Set of shipments which must be performed in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
   */
  java.util.List<com.google.cloud.optimization.v1.Shipment> getShipmentsList();
  /**
   *
   *
   * <pre>
   * Set of shipments which must be performed in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
   */
  com.google.cloud.optimization.v1.Shipment getShipments(int index);
  /**
   *
   *
   * <pre>
   * Set of shipments which must be performed in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
   */
  int getShipmentsCount();
  /**
   *
   *
   * <pre>
   * Set of shipments which must be performed in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
   */
  java.util.List<? extends com.google.cloud.optimization.v1.ShipmentOrBuilder>
      getShipmentsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Set of shipments which must be performed in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
   */
  com.google.cloud.optimization.v1.ShipmentOrBuilder getShipmentsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Set of vehicles which can be used to perform visits.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
   */
  java.util.List<com.google.cloud.optimization.v1.Vehicle> getVehiclesList();
  /**
   *
   *
   * <pre>
   * Set of vehicles which can be used to perform visits.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
   */
  com.google.cloud.optimization.v1.Vehicle getVehicles(int index);
  /**
   *
   *
   * <pre>
   * Set of vehicles which can be used to perform visits.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
   */
  int getVehiclesCount();
  /**
   *
   *
   * <pre>
   * Set of vehicles which can be used to perform visits.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
   */
  java.util.List<? extends com.google.cloud.optimization.v1.VehicleOrBuilder>
      getVehiclesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Set of vehicles which can be used to perform visits.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
   */
  com.google.cloud.optimization.v1.VehicleOrBuilder getVehiclesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Constrains the maximum number of active vehicles. A vehicle is active if
   * its route performs at least one shipment. This can be used to limit the
   * number of routes in the case where there are fewer drivers than
   * vehicles and that the fleet of vehicles is heterogeneous. The optimization
   * will then select the best subset of vehicles to use.
   * Must be strictly positive.
   * </pre>
   *
   * <code>optional int32 max_active_vehicles = 4;</code>
   *
   * @return Whether the maxActiveVehicles field is set.
   */
  boolean hasMaxActiveVehicles();
  /**
   *
   *
   * <pre>
   * Constrains the maximum number of active vehicles. A vehicle is active if
   * its route performs at least one shipment. This can be used to limit the
   * number of routes in the case where there are fewer drivers than
   * vehicles and that the fleet of vehicles is heterogeneous. The optimization
   * will then select the best subset of vehicles to use.
   * Must be strictly positive.
   * </pre>
   *
   * <code>optional int32 max_active_vehicles = 4;</code>
   *
   * @return The maxActiveVehicles.
   */
  int getMaxActiveVehicles();

  /**
   *
   *
   * <pre>
   * Global start and end time of the model: no times outside of this range
   * can be considered valid.
   * The model's time span must be less than a year, i.e. the `global_end_time`
   * and the `global_start_time` must be within 31536000 seconds of each other.
   * When using `cost_per_*hour` fields, you might want to set this window to a
   * smaller interval to increase performance (eg. if you model a single day,
   * you should set the global time limits to that day).
   * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
   * as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
   *
   * @return Whether the globalStartTime field is set.
   */
  boolean hasGlobalStartTime();
  /**
   *
   *
   * <pre>
   * Global start and end time of the model: no times outside of this range
   * can be considered valid.
   * The model's time span must be less than a year, i.e. the `global_end_time`
   * and the `global_start_time` must be within 31536000 seconds of each other.
   * When using `cost_per_*hour` fields, you might want to set this window to a
   * smaller interval to increase performance (eg. if you model a single day,
   * you should set the global time limits to that day).
   * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
   * as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
   *
   * @return The globalStartTime.
   */
  com.google.protobuf.Timestamp getGlobalStartTime();
  /**
   *
   *
   * <pre>
   * Global start and end time of the model: no times outside of this range
   * can be considered valid.
   * The model's time span must be less than a year, i.e. the `global_end_time`
   * and the `global_start_time` must be within 31536000 seconds of each other.
   * When using `cost_per_*hour` fields, you might want to set this window to a
   * smaller interval to increase performance (eg. if you model a single day,
   * you should set the global time limits to that day).
   * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
   * as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
   */
  com.google.protobuf.TimestampOrBuilder getGlobalStartTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
   * is used as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
   *
   * @return Whether the globalEndTime field is set.
   */
  boolean hasGlobalEndTime();
  /**
   *
   *
   * <pre>
   * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
   * is used as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
   *
   * @return The globalEndTime.
   */
  com.google.protobuf.Timestamp getGlobalEndTime();
  /**
   *
   *
   * <pre>
   * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
   * is used as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
   */
  com.google.protobuf.TimestampOrBuilder getGlobalEndTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The "global duration" of the overall plan is the difference between the
   * earliest effective start time and the latest effective end time of
   * all vehicles. Users can assign a cost per hour to that quantity to try
   * and optimize for earliest job completion, for example. This cost must be in
   * the same unit as [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
   * </pre>
   *
   * <code>double global_duration_cost_per_hour = 7;</code>
   *
   * @return The globalDurationCostPerHour.
   */
  double getGlobalDurationCostPerHour();

  /**
   *
   *
   * <pre>
   * Specifies duration and distance matrices used in the model. If this field
   * is empty, Google Maps or geodesic distances will be used instead, depending
   * on the value of the `use_geodesic_distances` field. If it is not empty,
   * `use_geodesic_distances` cannot be true and neither
   * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
   * can be empty.
   * Usage examples:
   * * There are two locations: locA and locB.
   * * 1 vehicle starting its route at locA and ending it at locA.
   * * 1 pickup visit request at locB.
   * ```
   * model {
   *   vehicles { start_tags: "locA"  end_tags: "locA" }
   *   shipments { pickups { tags: "locB" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locA"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrices {
   *     rows {  # from: locA
   *       durations { seconds: 0 }   meters: 0    # to: locA
   *       durations { seconds: 100 } meters: 1000 # to: locB
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 102 } meters: 990 # to: locA
   *       durations { seconds: 0 }   meters: 0   # to: locB
   *     }
   *   }
   * }
   * ```
   * * There are three locations: locA, locB and locC.
   * * 1 vehicle starting its route at locA and ending it at locB, using
   *   matrix "fast".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "slow".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "fast".
   * * 1 pickup visit request at locC.
   * ```
   * model {
   *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
   *   shipments { pickups { tags: "locC" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_src_tags: "locC"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locC"
   *   duration_distance_matrices {
   *     vehicle_start_tag: "fast"
   *     rows {  # from: locA
   *       durations { seconds: 1000 } meters: 2000 # to: locB
   *       durations { seconds: 600 }  meters: 1000 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }   meters: 0    # to: locB
   *       durations { seconds: 700 } meters: 1200 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 702 } meters: 1190 # to: locB
   *       durations { seconds: 0 }   meters: 0    # to: locC
   *     }
   *   }
   *   duration_distance_matrices {
   *     vehicle_start_tag: "slow"
   *     rows {  # from: locA
   *       durations { seconds: 1800 } meters: 2001 # to: locB
   *       durations { seconds: 900 }  meters: 1002 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }    meters: 0    # to: locB
   *       durations { seconds: 1000 } meters: 1202 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 1001 } meters: 1195 # to: locB
   *       durations { seconds: 0 }    meters: 0    # to: locC
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
   * </code>
   */
  java.util.List<com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix>
      getDurationDistanceMatricesList();
  /**
   *
   *
   * <pre>
   * Specifies duration and distance matrices used in the model. If this field
   * is empty, Google Maps or geodesic distances will be used instead, depending
   * on the value of the `use_geodesic_distances` field. If it is not empty,
   * `use_geodesic_distances` cannot be true and neither
   * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
   * can be empty.
   * Usage examples:
   * * There are two locations: locA and locB.
   * * 1 vehicle starting its route at locA and ending it at locA.
   * * 1 pickup visit request at locB.
   * ```
   * model {
   *   vehicles { start_tags: "locA"  end_tags: "locA" }
   *   shipments { pickups { tags: "locB" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locA"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrices {
   *     rows {  # from: locA
   *       durations { seconds: 0 }   meters: 0    # to: locA
   *       durations { seconds: 100 } meters: 1000 # to: locB
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 102 } meters: 990 # to: locA
   *       durations { seconds: 0 }   meters: 0   # to: locB
   *     }
   *   }
   * }
   * ```
   * * There are three locations: locA, locB and locC.
   * * 1 vehicle starting its route at locA and ending it at locB, using
   *   matrix "fast".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "slow".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "fast".
   * * 1 pickup visit request at locC.
   * ```
   * model {
   *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
   *   shipments { pickups { tags: "locC" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_src_tags: "locC"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locC"
   *   duration_distance_matrices {
   *     vehicle_start_tag: "fast"
   *     rows {  # from: locA
   *       durations { seconds: 1000 } meters: 2000 # to: locB
   *       durations { seconds: 600 }  meters: 1000 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }   meters: 0    # to: locB
   *       durations { seconds: 700 } meters: 1200 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 702 } meters: 1190 # to: locB
   *       durations { seconds: 0 }   meters: 0    # to: locC
   *     }
   *   }
   *   duration_distance_matrices {
   *     vehicle_start_tag: "slow"
   *     rows {  # from: locA
   *       durations { seconds: 1800 } meters: 2001 # to: locB
   *       durations { seconds: 900 }  meters: 1002 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }    meters: 0    # to: locB
   *       durations { seconds: 1000 } meters: 1202 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 1001 } meters: 1195 # to: locB
   *       durations { seconds: 0 }    meters: 0    # to: locC
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
   * </code>
   */
  com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix getDurationDistanceMatrices(
      int index);
  /**
   *
   *
   * <pre>
   * Specifies duration and distance matrices used in the model. If this field
   * is empty, Google Maps or geodesic distances will be used instead, depending
   * on the value of the `use_geodesic_distances` field. If it is not empty,
   * `use_geodesic_distances` cannot be true and neither
   * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
   * can be empty.
   * Usage examples:
   * * There are two locations: locA and locB.
   * * 1 vehicle starting its route at locA and ending it at locA.
   * * 1 pickup visit request at locB.
   * ```
   * model {
   *   vehicles { start_tags: "locA"  end_tags: "locA" }
   *   shipments { pickups { tags: "locB" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locA"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrices {
   *     rows {  # from: locA
   *       durations { seconds: 0 }   meters: 0    # to: locA
   *       durations { seconds: 100 } meters: 1000 # to: locB
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 102 } meters: 990 # to: locA
   *       durations { seconds: 0 }   meters: 0   # to: locB
   *     }
   *   }
   * }
   * ```
   * * There are three locations: locA, locB and locC.
   * * 1 vehicle starting its route at locA and ending it at locB, using
   *   matrix "fast".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "slow".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "fast".
   * * 1 pickup visit request at locC.
   * ```
   * model {
   *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
   *   shipments { pickups { tags: "locC" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_src_tags: "locC"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locC"
   *   duration_distance_matrices {
   *     vehicle_start_tag: "fast"
   *     rows {  # from: locA
   *       durations { seconds: 1000 } meters: 2000 # to: locB
   *       durations { seconds: 600 }  meters: 1000 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }   meters: 0    # to: locB
   *       durations { seconds: 700 } meters: 1200 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 702 } meters: 1190 # to: locB
   *       durations { seconds: 0 }   meters: 0    # to: locC
   *     }
   *   }
   *   duration_distance_matrices {
   *     vehicle_start_tag: "slow"
   *     rows {  # from: locA
   *       durations { seconds: 1800 } meters: 2001 # to: locB
   *       durations { seconds: 900 }  meters: 1002 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }    meters: 0    # to: locB
   *       durations { seconds: 1000 } meters: 1202 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 1001 } meters: 1195 # to: locB
   *       durations { seconds: 0 }    meters: 0    # to: locC
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
   * </code>
   */
  int getDurationDistanceMatricesCount();
  /**
   *
   *
   * <pre>
   * Specifies duration and distance matrices used in the model. If this field
   * is empty, Google Maps or geodesic distances will be used instead, depending
   * on the value of the `use_geodesic_distances` field. If it is not empty,
   * `use_geodesic_distances` cannot be true and neither
   * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
   * can be empty.
   * Usage examples:
   * * There are two locations: locA and locB.
   * * 1 vehicle starting its route at locA and ending it at locA.
   * * 1 pickup visit request at locB.
   * ```
   * model {
   *   vehicles { start_tags: "locA"  end_tags: "locA" }
   *   shipments { pickups { tags: "locB" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locA"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrices {
   *     rows {  # from: locA
   *       durations { seconds: 0 }   meters: 0    # to: locA
   *       durations { seconds: 100 } meters: 1000 # to: locB
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 102 } meters: 990 # to: locA
   *       durations { seconds: 0 }   meters: 0   # to: locB
   *     }
   *   }
   * }
   * ```
   * * There are three locations: locA, locB and locC.
   * * 1 vehicle starting its route at locA and ending it at locB, using
   *   matrix "fast".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "slow".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "fast".
   * * 1 pickup visit request at locC.
   * ```
   * model {
   *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
   *   shipments { pickups { tags: "locC" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_src_tags: "locC"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locC"
   *   duration_distance_matrices {
   *     vehicle_start_tag: "fast"
   *     rows {  # from: locA
   *       durations { seconds: 1000 } meters: 2000 # to: locB
   *       durations { seconds: 600 }  meters: 1000 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }   meters: 0    # to: locB
   *       durations { seconds: 700 } meters: 1200 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 702 } meters: 1190 # to: locB
   *       durations { seconds: 0 }   meters: 0    # to: locC
   *     }
   *   }
   *   duration_distance_matrices {
   *     vehicle_start_tag: "slow"
   *     rows {  # from: locA
   *       durations { seconds: 1800 } meters: 2001 # to: locB
   *       durations { seconds: 900 }  meters: 1002 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }    meters: 0    # to: locB
   *       durations { seconds: 1000 } meters: 1202 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 1001 } meters: 1195 # to: locB
   *       durations { seconds: 0 }    meters: 0    # to: locC
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
   * </code>
   */
  java.util.List<
          ? extends com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrixOrBuilder>
      getDurationDistanceMatricesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Specifies duration and distance matrices used in the model. If this field
   * is empty, Google Maps or geodesic distances will be used instead, depending
   * on the value of the `use_geodesic_distances` field. If it is not empty,
   * `use_geodesic_distances` cannot be true and neither
   * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
   * can be empty.
   * Usage examples:
   * * There are two locations: locA and locB.
   * * 1 vehicle starting its route at locA and ending it at locA.
   * * 1 pickup visit request at locB.
   * ```
   * model {
   *   vehicles { start_tags: "locA"  end_tags: "locA" }
   *   shipments { pickups { tags: "locB" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locA"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrices {
   *     rows {  # from: locA
   *       durations { seconds: 0 }   meters: 0    # to: locA
   *       durations { seconds: 100 } meters: 1000 # to: locB
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 102 } meters: 990 # to: locA
   *       durations { seconds: 0 }   meters: 0   # to: locB
   *     }
   *   }
   * }
   * ```
   * * There are three locations: locA, locB and locC.
   * * 1 vehicle starting its route at locA and ending it at locB, using
   *   matrix "fast".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "slow".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "fast".
   * * 1 pickup visit request at locC.
   * ```
   * model {
   *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
   *   shipments { pickups { tags: "locC" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_src_tags: "locC"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locC"
   *   duration_distance_matrices {
   *     vehicle_start_tag: "fast"
   *     rows {  # from: locA
   *       durations { seconds: 1000 } meters: 2000 # to: locB
   *       durations { seconds: 600 }  meters: 1000 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }   meters: 0    # to: locB
   *       durations { seconds: 700 } meters: 1200 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 702 } meters: 1190 # to: locB
   *       durations { seconds: 0 }   meters: 0    # to: locC
   *     }
   *   }
   *   duration_distance_matrices {
   *     vehicle_start_tag: "slow"
   *     rows {  # from: locA
   *       durations { seconds: 1800 } meters: 2001 # to: locB
   *       durations { seconds: 900 }  meters: 1002 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }    meters: 0    # to: locB
   *       durations { seconds: 1000 } meters: 1202 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 1001 } meters: 1195 # to: locB
   *       durations { seconds: 0 }    meters: 0    # to: locC
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
   * </code>
   */
  com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrixOrBuilder
      getDurationDistanceMatricesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Tags defining the sources of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j)` defines durations and distances
   * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
   * in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
   *
   * @return A list containing the durationDistanceMatrixSrcTags.
   */
  java.util.List<java.lang.String> getDurationDistanceMatrixSrcTagsList();
  /**
   *
   *
   * <pre>
   * Tags defining the sources of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j)` defines durations and distances
   * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
   * in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
   *
   * @return The count of durationDistanceMatrixSrcTags.
   */
  int getDurationDistanceMatrixSrcTagsCount();
  /**
   *
   *
   * <pre>
   * Tags defining the sources of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j)` defines durations and distances
   * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
   * in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The durationDistanceMatrixSrcTags at the given index.
   */
  java.lang.String getDurationDistanceMatrixSrcTags(int index);
  /**
   *
   *
   * <pre>
   * Tags defining the sources of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j)` defines durations and distances
   * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
   * in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the durationDistanceMatrixSrcTags at the given index.
   */
  com.google.protobuf.ByteString getDurationDistanceMatrixSrcTagsBytes(int index);

  /**
   *
   *
   * <pre>
   * Tags defining the destinations of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
   * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
   * (resp. the distance) of the travel from visits with tag
   * `duration_distance_matrix_src_tags(j)` to visits with tag
   * `duration_distance_matrix_dst_tags(k)` in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
   *
   * @return A list containing the durationDistanceMatrixDstTags.
   */
  java.util.List<java.lang.String> getDurationDistanceMatrixDstTagsList();
  /**
   *
   *
   * <pre>
   * Tags defining the destinations of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
   * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
   * (resp. the distance) of the travel from visits with tag
   * `duration_distance_matrix_src_tags(j)` to visits with tag
   * `duration_distance_matrix_dst_tags(k)` in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
   *
   * @return The count of durationDistanceMatrixDstTags.
   */
  int getDurationDistanceMatrixDstTagsCount();
  /**
   *
   *
   * <pre>
   * Tags defining the destinations of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
   * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
   * (resp. the distance) of the travel from visits with tag
   * `duration_distance_matrix_src_tags(j)` to visits with tag
   * `duration_distance_matrix_dst_tags(k)` in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The durationDistanceMatrixDstTags at the given index.
   */
  java.lang.String getDurationDistanceMatrixDstTags(int index);
  /**
   *
   *
   * <pre>
   * Tags defining the destinations of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
   * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
   * (resp. the distance) of the travel from visits with tag
   * `duration_distance_matrix_src_tags(j)` to visits with tag
   * `duration_distance_matrix_dst_tags(k)` in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the durationDistanceMatrixDstTags at the given index.
   */
  com.google.protobuf.ByteString getDurationDistanceMatrixDstTagsBytes(int index);

  /**
   *
   *
   * <pre>
   * Transition attributes added to the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
   * </code>
   */
  java.util.List<com.google.cloud.optimization.v1.TransitionAttributes>
      getTransitionAttributesList();
  /**
   *
   *
   * <pre>
   * Transition attributes added to the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
   * </code>
   */
  com.google.cloud.optimization.v1.TransitionAttributes getTransitionAttributes(int index);
  /**
   *
   *
   * <pre>
   * Transition attributes added to the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
   * </code>
   */
  int getTransitionAttributesCount();
  /**
   *
   *
   * <pre>
   * Transition attributes added to the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
   * </code>
   */
  java.util.List<? extends com.google.cloud.optimization.v1.TransitionAttributesOrBuilder>
      getTransitionAttributesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Transition attributes added to the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
   * </code>
   */
  com.google.cloud.optimization.v1.TransitionAttributesOrBuilder getTransitionAttributesOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
   * </code>
   */
  java.util.List<com.google.cloud.optimization.v1.ShipmentTypeIncompatibility>
      getShipmentTypeIncompatibilitiesList();
  /**
   *
   *
   * <pre>
   * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
   * </code>
   */
  com.google.cloud.optimization.v1.ShipmentTypeIncompatibility getShipmentTypeIncompatibilities(
      int index);
  /**
   *
   *
   * <pre>
   * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
   * </code>
   */
  int getShipmentTypeIncompatibilitiesCount();
  /**
   *
   *
   * <pre>
   * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
   * </code>
   */
  java.util.List<? extends com.google.cloud.optimization.v1.ShipmentTypeIncompatibilityOrBuilder>
      getShipmentTypeIncompatibilitiesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
   * </code>
   */
  com.google.cloud.optimization.v1.ShipmentTypeIncompatibilityOrBuilder
      getShipmentTypeIncompatibilitiesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
   * </code>
   */
  java.util.List<com.google.cloud.optimization.v1.ShipmentTypeRequirement>
      getShipmentTypeRequirementsList();
  /**
   *
   *
   * <pre>
   * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
   * </code>
   */
  com.google.cloud.optimization.v1.ShipmentTypeRequirement getShipmentTypeRequirements(int index);
  /**
   *
   *
   * <pre>
   * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
   * </code>
   */
  int getShipmentTypeRequirementsCount();
  /**
   *
   *
   * <pre>
   * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
   * </code>
   */
  java.util.List<? extends com.google.cloud.optimization.v1.ShipmentTypeRequirementOrBuilder>
      getShipmentTypeRequirementsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
   * </code>
   */
  com.google.cloud.optimization.v1.ShipmentTypeRequirementOrBuilder
      getShipmentTypeRequirementsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Set of precedence rules which must be enforced in the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
   * </code>
   */
  java.util.List<com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule>
      getPrecedenceRulesList();
  /**
   *
   *
   * <pre>
   * Set of precedence rules which must be enforced in the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
   * </code>
   */
  com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule getPrecedenceRules(int index);
  /**
   *
   *
   * <pre>
   * Set of precedence rules which must be enforced in the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
   * </code>
   */
  int getPrecedenceRulesCount();
  /**
   *
   *
   * <pre>
   * Set of precedence rules which must be enforced in the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
   * </code>
   */
  java.util.List<? extends com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRuleOrBuilder>
      getPrecedenceRulesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Set of precedence rules which must be enforced in the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
   * </code>
   */
  com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRuleOrBuilder
      getPrecedenceRulesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Set of break rules used in the model.
   * Each vehicle specifies the `BreakRule` that applies to it via the
   * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule> getBreakRulesList();
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Set of break rules used in the model.
   * Each vehicle specifies the `BreakRule` that applies to it via the
   * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.cloud.optimization.v1.ShipmentModel.BreakRule getBreakRules(int index);
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Set of break rules used in the model.
   * Each vehicle specifies the `BreakRule` that applies to it via the
   * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  int getBreakRulesCount();
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Set of break rules used in the model.
   * Each vehicle specifies the `BreakRule` that applies to it via the
   * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  java.util.List<? extends com.google.cloud.optimization.v1.ShipmentModel.BreakRuleOrBuilder>
      getBreakRulesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Set of break rules used in the model.
   * Each vehicle specifies the `BreakRule` that applies to it via the
   * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.cloud.optimization.v1.ShipmentModel.BreakRuleOrBuilder getBreakRulesOrBuilder(
      int index);
}
