/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * A shipment model contains a set of shipments which must be performed by a
 * set of vehicles, while minimizing the overall cost, which is the sum of:
 * * the cost of routing the vehicles (sum of cost per total time, cost per
 *   travel time, and fixed cost over all vehicles).
 * * the unperformed shipment penalties.
 * * the cost of the global duration of the shipments
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel}
 */
public final class ShipmentModel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentModel)
    ShipmentModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ShipmentModel.newBuilder() to construct.
  private ShipmentModel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ShipmentModel() {
    shipments_ = java.util.Collections.emptyList();
    vehicles_ = java.util.Collections.emptyList();
    durationDistanceMatrices_ = java.util.Collections.emptyList();
    durationDistanceMatrixSrcTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    durationDistanceMatrixDstTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    transitionAttributes_ = java.util.Collections.emptyList();
    shipmentTypeIncompatibilities_ = java.util.Collections.emptyList();
    shipmentTypeRequirements_ = java.util.Collections.emptyList();
    precedenceRules_ = java.util.Collections.emptyList();
    breakRules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ShipmentModel();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_ShipmentModel_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_ShipmentModel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.ShipmentModel.class,
            com.google.cloud.optimization.v1.ShipmentModel.Builder.class);
  }

  public interface DurationDistanceMatrixOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specifies the rows of the duration and distance matrix. It must have as
     * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
     * </code>
     */
    java.util.List<com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row>
        getRowsList();
    /**
     *
     *
     * <pre>
     * Specifies the rows of the duration and distance matrix. It must have as
     * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
     * </code>
     */
    com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row getRows(int index);
    /**
     *
     *
     * <pre>
     * Specifies the rows of the duration and distance matrix. It must have as
     * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
     * </code>
     */
    int getRowsCount();
    /**
     *
     *
     * <pre>
     * Specifies the rows of the duration and distance matrix. It must have as
     * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.RowOrBuilder>
        getRowsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Specifies the rows of the duration and distance matrix. It must have as
     * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
     * </code>
     */
    com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.RowOrBuilder
        getRowsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Tag defining to which vehicles this duration and distance matrix applies.
     * If empty, this applies to all vehicles, and there can only be a single
     * matrix.
     * Each vehicle start must match exactly one matrix, i.e. exactly one of
     * their `start_tags` field must match the `vehicle_start_tag` of a matrix
     * (and of that matrix only).
     * All matrices must have a different `vehicle_start_tag`.
     * </pre>
     *
     * <code>string vehicle_start_tag = 2;</code>
     *
     * @return The vehicleStartTag.
     */
    java.lang.String getVehicleStartTag();
    /**
     *
     *
     * <pre>
     * Tag defining to which vehicles this duration and distance matrix applies.
     * If empty, this applies to all vehicles, and there can only be a single
     * matrix.
     * Each vehicle start must match exactly one matrix, i.e. exactly one of
     * their `start_tags` field must match the `vehicle_start_tag` of a matrix
     * (and of that matrix only).
     * All matrices must have a different `vehicle_start_tag`.
     * </pre>
     *
     * <code>string vehicle_start_tag = 2;</code>
     *
     * @return The bytes for vehicleStartTag.
     */
    com.google.protobuf.ByteString getVehicleStartTagBytes();
  }
  /**
   *
   *
   * <pre>
   * Specifies a duration and distance matrix from visit and vehicle start
   * locations to visit and vehicle end locations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix}
   */
  public static final class DurationDistanceMatrix extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix)
      DurationDistanceMatrixOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DurationDistanceMatrix.newBuilder() to construct.
    private DurationDistanceMatrix(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DurationDistanceMatrix() {
      rows_ = java.util.Collections.emptyList();
      vehicleStartTag_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DurationDistanceMatrix();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentModel_DurationDistanceMatrix_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentModel_DurationDistanceMatrix_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.class,
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder.class);
    }

    public interface RowOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Duration values for a given row. It must have as many elements as
       * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
       * </pre>
       *
       * <code>repeated .google.protobuf.Duration durations = 1;</code>
       */
      java.util.List<com.google.protobuf.Duration> getDurationsList();
      /**
       *
       *
       * <pre>
       * Duration values for a given row. It must have as many elements as
       * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
       * </pre>
       *
       * <code>repeated .google.protobuf.Duration durations = 1;</code>
       */
      com.google.protobuf.Duration getDurations(int index);
      /**
       *
       *
       * <pre>
       * Duration values for a given row. It must have as many elements as
       * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
       * </pre>
       *
       * <code>repeated .google.protobuf.Duration durations = 1;</code>
       */
      int getDurationsCount();
      /**
       *
       *
       * <pre>
       * Duration values for a given row. It must have as many elements as
       * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
       * </pre>
       *
       * <code>repeated .google.protobuf.Duration durations = 1;</code>
       */
      java.util.List<? extends com.google.protobuf.DurationOrBuilder> getDurationsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Duration values for a given row. It must have as many elements as
       * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
       * </pre>
       *
       * <code>repeated .google.protobuf.Duration durations = 1;</code>
       */
      com.google.protobuf.DurationOrBuilder getDurationsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Distance values for a given row. If no costs or constraints refer to
       * distances in the model, this can be left empty; otherwise it must have
       * as many elements as `durations`.
       * </pre>
       *
       * <code>repeated double meters = 2;</code>
       *
       * @return A list containing the meters.
       */
      java.util.List<java.lang.Double> getMetersList();
      /**
       *
       *
       * <pre>
       * Distance values for a given row. If no costs or constraints refer to
       * distances in the model, this can be left empty; otherwise it must have
       * as many elements as `durations`.
       * </pre>
       *
       * <code>repeated double meters = 2;</code>
       *
       * @return The count of meters.
       */
      int getMetersCount();
      /**
       *
       *
       * <pre>
       * Distance values for a given row. If no costs or constraints refer to
       * distances in the model, this can be left empty; otherwise it must have
       * as many elements as `durations`.
       * </pre>
       *
       * <code>repeated double meters = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The meters at the given index.
       */
      double getMeters(int index);
    }
    /**
     *
     *
     * <pre>
     * Specifies a row of the duration and distance matrix.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row}
     */
    public static final class Row extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row)
        RowOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Row.newBuilder() to construct.
      private Row(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Row() {
        durations_ = java.util.Collections.emptyList();
        meters_ = emptyDoubleList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Row();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_DurationDistanceMatrix_Row_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_DurationDistanceMatrix_Row_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.class,
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder
                    .class);
      }

      public static final int DURATIONS_FIELD_NUMBER = 1;
      private java.util.List<com.google.protobuf.Duration> durations_;
      /**
       *
       *
       * <pre>
       * Duration values for a given row. It must have as many elements as
       * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
       * </pre>
       *
       * <code>repeated .google.protobuf.Duration durations = 1;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.protobuf.Duration> getDurationsList() {
        return durations_;
      }
      /**
       *
       *
       * <pre>
       * Duration values for a given row. It must have as many elements as
       * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
       * </pre>
       *
       * <code>repeated .google.protobuf.Duration durations = 1;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
          getDurationsOrBuilderList() {
        return durations_;
      }
      /**
       *
       *
       * <pre>
       * Duration values for a given row. It must have as many elements as
       * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
       * </pre>
       *
       * <code>repeated .google.protobuf.Duration durations = 1;</code>
       */
      @java.lang.Override
      public int getDurationsCount() {
        return durations_.size();
      }
      /**
       *
       *
       * <pre>
       * Duration values for a given row. It must have as many elements as
       * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
       * </pre>
       *
       * <code>repeated .google.protobuf.Duration durations = 1;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Duration getDurations(int index) {
        return durations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Duration values for a given row. It must have as many elements as
       * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
       * </pre>
       *
       * <code>repeated .google.protobuf.Duration durations = 1;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getDurationsOrBuilder(int index) {
        return durations_.get(index);
      }

      public static final int METERS_FIELD_NUMBER = 2;
      private com.google.protobuf.Internal.DoubleList meters_;
      /**
       *
       *
       * <pre>
       * Distance values for a given row. If no costs or constraints refer to
       * distances in the model, this can be left empty; otherwise it must have
       * as many elements as `durations`.
       * </pre>
       *
       * <code>repeated double meters = 2;</code>
       *
       * @return A list containing the meters.
       */
      @java.lang.Override
      public java.util.List<java.lang.Double> getMetersList() {
        return meters_;
      }
      /**
       *
       *
       * <pre>
       * Distance values for a given row. If no costs or constraints refer to
       * distances in the model, this can be left empty; otherwise it must have
       * as many elements as `durations`.
       * </pre>
       *
       * <code>repeated double meters = 2;</code>
       *
       * @return The count of meters.
       */
      public int getMetersCount() {
        return meters_.size();
      }
      /**
       *
       *
       * <pre>
       * Distance values for a given row. If no costs or constraints refer to
       * distances in the model, this can be left empty; otherwise it must have
       * as many elements as `durations`.
       * </pre>
       *
       * <code>repeated double meters = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The meters at the given index.
       */
      public double getMeters(int index) {
        return meters_.getDouble(index);
      }

      private int metersMemoizedSerializedSize = -1;

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        for (int i = 0; i < durations_.size(); i++) {
          output.writeMessage(1, durations_.get(i));
        }
        if (getMetersList().size() > 0) {
          output.writeUInt32NoTag(18);
          output.writeUInt32NoTag(metersMemoizedSerializedSize);
        }
        for (int i = 0; i < meters_.size(); i++) {
          output.writeDoubleNoTag(meters_.getDouble(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < durations_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, durations_.get(i));
        }
        {
          int dataSize = 0;
          dataSize = 8 * getMetersList().size();
          size += dataSize;
          if (!getMetersList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
          }
          metersMemoizedSerializedSize = dataSize;
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row)) {
          return super.equals(obj);
        }
        com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row other =
            (com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row) obj;

        if (!getDurationsList().equals(other.getDurationsList())) return false;
        if (!getMetersList().equals(other.getMetersList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getDurationsCount() > 0) {
          hash = (37 * hash) + DURATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getDurationsList().hashCode();
        }
        if (getMetersCount() > 0) {
          hash = (37 * hash) + METERS_FIELD_NUMBER;
          hash = (53 * hash) + getMetersList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specifies a row of the duration and distance matrix.
       * </pre>
       *
       * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row)
          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.RowOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_ShipmentModel_DurationDistanceMatrix_Row_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_ShipmentModel_DurationDistanceMatrix_Row_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.class,
                  com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (durationsBuilder_ == null) {
            durations_ = java.util.Collections.emptyList();
          } else {
            durations_ = null;
            durationsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          meters_ = emptyDoubleList();
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_ShipmentModel_DurationDistanceMatrix_Row_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
            getDefaultInstanceForType() {
          return com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row build() {
          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
            buildPartial() {
          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row result =
              new com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row(this);
          int from_bitField0_ = bitField0_;
          if (durationsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              durations_ = java.util.Collections.unmodifiableList(durations_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.durations_ = durations_;
          } else {
            result.durations_ = durationsBuilder_.build();
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            meters_.makeImmutable();
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.meters_ = meters_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row) {
            return mergeFrom(
                (com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row other) {
          if (other
              == com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
                  .getDefaultInstance()) return this;
          if (durationsBuilder_ == null) {
            if (!other.durations_.isEmpty()) {
              if (durations_.isEmpty()) {
                durations_ = other.durations_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureDurationsIsMutable();
                durations_.addAll(other.durations_);
              }
              onChanged();
            }
          } else {
            if (!other.durations_.isEmpty()) {
              if (durationsBuilder_.isEmpty()) {
                durationsBuilder_.dispose();
                durationsBuilder_ = null;
                durations_ = other.durations_;
                bitField0_ = (bitField0_ & ~0x00000001);
                durationsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDurationsFieldBuilder()
                        : null;
              } else {
                durationsBuilder_.addAllMessages(other.durations_);
              }
            }
          }
          if (!other.meters_.isEmpty()) {
            if (meters_.isEmpty()) {
              meters_ = other.meters_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureMetersIsMutable();
              meters_.addAll(other.meters_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.protobuf.Duration m =
                        input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
                    if (durationsBuilder_ == null) {
                      ensureDurationsIsMutable();
                      durations_.add(m);
                    } else {
                      durationsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                case 17:
                  {
                    double v = input.readDouble();
                    ensureMetersIsMutable();
                    meters_.addDouble(v);
                    break;
                  } // case 17
                case 18:
                  {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    ensureMetersIsMutable();
                    while (input.getBytesUntilLimit() > 0) {
                      meters_.addDouble(input.readDouble());
                    }
                    input.popLimit(limit);
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<com.google.protobuf.Duration> durations_ =
            java.util.Collections.emptyList();

        private void ensureDurationsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            durations_ = new java.util.ArrayList<com.google.protobuf.Duration>(durations_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            durationsBuilder_;

        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public java.util.List<com.google.protobuf.Duration> getDurationsList() {
          if (durationsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(durations_);
          } else {
            return durationsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public int getDurationsCount() {
          if (durationsBuilder_ == null) {
            return durations_.size();
          } else {
            return durationsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public com.google.protobuf.Duration getDurations(int index) {
          if (durationsBuilder_ == null) {
            return durations_.get(index);
          } else {
            return durationsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public Builder setDurations(int index, com.google.protobuf.Duration value) {
          if (durationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDurationsIsMutable();
            durations_.set(index, value);
            onChanged();
          } else {
            durationsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public Builder setDurations(
            int index, com.google.protobuf.Duration.Builder builderForValue) {
          if (durationsBuilder_ == null) {
            ensureDurationsIsMutable();
            durations_.set(index, builderForValue.build());
            onChanged();
          } else {
            durationsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public Builder addDurations(com.google.protobuf.Duration value) {
          if (durationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDurationsIsMutable();
            durations_.add(value);
            onChanged();
          } else {
            durationsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public Builder addDurations(int index, com.google.protobuf.Duration value) {
          if (durationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDurationsIsMutable();
            durations_.add(index, value);
            onChanged();
          } else {
            durationsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public Builder addDurations(com.google.protobuf.Duration.Builder builderForValue) {
          if (durationsBuilder_ == null) {
            ensureDurationsIsMutable();
            durations_.add(builderForValue.build());
            onChanged();
          } else {
            durationsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public Builder addDurations(
            int index, com.google.protobuf.Duration.Builder builderForValue) {
          if (durationsBuilder_ == null) {
            ensureDurationsIsMutable();
            durations_.add(index, builderForValue.build());
            onChanged();
          } else {
            durationsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public Builder addAllDurations(
            java.lang.Iterable<? extends com.google.protobuf.Duration> values) {
          if (durationsBuilder_ == null) {
            ensureDurationsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, durations_);
            onChanged();
          } else {
            durationsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public Builder clearDurations() {
          if (durationsBuilder_ == null) {
            durations_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            durationsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public Builder removeDurations(int index) {
          if (durationsBuilder_ == null) {
            ensureDurationsIsMutable();
            durations_.remove(index);
            onChanged();
          } else {
            durationsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public com.google.protobuf.Duration.Builder getDurationsBuilder(int index) {
          return getDurationsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public com.google.protobuf.DurationOrBuilder getDurationsOrBuilder(int index) {
          if (durationsBuilder_ == null) {
            return durations_.get(index);
          } else {
            return durationsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
            getDurationsOrBuilderList() {
          if (durationsBuilder_ != null) {
            return durationsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(durations_);
          }
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public com.google.protobuf.Duration.Builder addDurationsBuilder() {
          return getDurationsFieldBuilder()
              .addBuilder(com.google.protobuf.Duration.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public com.google.protobuf.Duration.Builder addDurationsBuilder(int index) {
          return getDurationsFieldBuilder()
              .addBuilder(index, com.google.protobuf.Duration.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Duration values for a given row. It must have as many elements as
         * [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
         * </pre>
         *
         * <code>repeated .google.protobuf.Duration durations = 1;</code>
         */
        public java.util.List<com.google.protobuf.Duration.Builder> getDurationsBuilderList() {
          return getDurationsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getDurationsFieldBuilder() {
          if (durationsBuilder_ == null) {
            durationsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    durations_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            durations_ = null;
          }
          return durationsBuilder_;
        }

        private com.google.protobuf.Internal.DoubleList meters_ = emptyDoubleList();

        private void ensureMetersIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            meters_ = mutableCopy(meters_);
            bitField0_ |= 0x00000002;
          }
        }
        /**
         *
         *
         * <pre>
         * Distance values for a given row. If no costs or constraints refer to
         * distances in the model, this can be left empty; otherwise it must have
         * as many elements as `durations`.
         * </pre>
         *
         * <code>repeated double meters = 2;</code>
         *
         * @return A list containing the meters.
         */
        public java.util.List<java.lang.Double> getMetersList() {
          return ((bitField0_ & 0x00000002) != 0)
              ? java.util.Collections.unmodifiableList(meters_)
              : meters_;
        }
        /**
         *
         *
         * <pre>
         * Distance values for a given row. If no costs or constraints refer to
         * distances in the model, this can be left empty; otherwise it must have
         * as many elements as `durations`.
         * </pre>
         *
         * <code>repeated double meters = 2;</code>
         *
         * @return The count of meters.
         */
        public int getMetersCount() {
          return meters_.size();
        }
        /**
         *
         *
         * <pre>
         * Distance values for a given row. If no costs or constraints refer to
         * distances in the model, this can be left empty; otherwise it must have
         * as many elements as `durations`.
         * </pre>
         *
         * <code>repeated double meters = 2;</code>
         *
         * @param index The index of the element to return.
         * @return The meters at the given index.
         */
        public double getMeters(int index) {
          return meters_.getDouble(index);
        }
        /**
         *
         *
         * <pre>
         * Distance values for a given row. If no costs or constraints refer to
         * distances in the model, this can be left empty; otherwise it must have
         * as many elements as `durations`.
         * </pre>
         *
         * <code>repeated double meters = 2;</code>
         *
         * @param index The index to set the value at.
         * @param value The meters to set.
         * @return This builder for chaining.
         */
        public Builder setMeters(int index, double value) {
          ensureMetersIsMutable();
          meters_.setDouble(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Distance values for a given row. If no costs or constraints refer to
         * distances in the model, this can be left empty; otherwise it must have
         * as many elements as `durations`.
         * </pre>
         *
         * <code>repeated double meters = 2;</code>
         *
         * @param value The meters to add.
         * @return This builder for chaining.
         */
        public Builder addMeters(double value) {
          ensureMetersIsMutable();
          meters_.addDouble(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Distance values for a given row. If no costs or constraints refer to
         * distances in the model, this can be left empty; otherwise it must have
         * as many elements as `durations`.
         * </pre>
         *
         * <code>repeated double meters = 2;</code>
         *
         * @param values The meters to add.
         * @return This builder for chaining.
         */
        public Builder addAllMeters(java.lang.Iterable<? extends java.lang.Double> values) {
          ensureMetersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, meters_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Distance values for a given row. If no costs or constraints refer to
         * distances in the model, this can be left empty; otherwise it must have
         * as many elements as `durations`.
         * </pre>
         *
         * <code>repeated double meters = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMeters() {
          meters_ = emptyDoubleList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row)
      private static final com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row();
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Row> PARSER =
          new com.google.protobuf.AbstractParser<Row>() {
            @java.lang.Override
            public Row parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Row> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Row> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int ROWS_FIELD_NUMBER = 1;
    private java.util.List<
            com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row>
        rows_;
    /**
     *
     *
     * <pre>
     * Specifies the rows of the duration and distance matrix. It must have as
     * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row>
        getRowsList() {
      return rows_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the rows of the duration and distance matrix. It must have as
     * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.RowOrBuilder>
        getRowsOrBuilderList() {
      return rows_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the rows of the duration and distance matrix. It must have as
     * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
     * </code>
     */
    @java.lang.Override
    public int getRowsCount() {
      return rows_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies the rows of the duration and distance matrix. It must have as
     * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row getRows(
        int index) {
      return rows_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies the rows of the duration and distance matrix. It must have as
     * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.RowOrBuilder
        getRowsOrBuilder(int index) {
      return rows_.get(index);
    }

    public static final int VEHICLE_START_TAG_FIELD_NUMBER = 2;
    private volatile java.lang.Object vehicleStartTag_;
    /**
     *
     *
     * <pre>
     * Tag defining to which vehicles this duration and distance matrix applies.
     * If empty, this applies to all vehicles, and there can only be a single
     * matrix.
     * Each vehicle start must match exactly one matrix, i.e. exactly one of
     * their `start_tags` field must match the `vehicle_start_tag` of a matrix
     * (and of that matrix only).
     * All matrices must have a different `vehicle_start_tag`.
     * </pre>
     *
     * <code>string vehicle_start_tag = 2;</code>
     *
     * @return The vehicleStartTag.
     */
    @java.lang.Override
    public java.lang.String getVehicleStartTag() {
      java.lang.Object ref = vehicleStartTag_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vehicleStartTag_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Tag defining to which vehicles this duration and distance matrix applies.
     * If empty, this applies to all vehicles, and there can only be a single
     * matrix.
     * Each vehicle start must match exactly one matrix, i.e. exactly one of
     * their `start_tags` field must match the `vehicle_start_tag` of a matrix
     * (and of that matrix only).
     * All matrices must have a different `vehicle_start_tag`.
     * </pre>
     *
     * <code>string vehicle_start_tag = 2;</code>
     *
     * @return The bytes for vehicleStartTag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVehicleStartTagBytes() {
      java.lang.Object ref = vehicleStartTag_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vehicleStartTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < rows_.size(); i++) {
        output.writeMessage(1, rows_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vehicleStartTag_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, vehicleStartTag_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < rows_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, rows_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vehicleStartTag_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, vehicleStartTag_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix other =
          (com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix) obj;

      if (!getRowsList().equals(other.getRowsList())) return false;
      if (!getVehicleStartTag().equals(other.getVehicleStartTag())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getRowsCount() > 0) {
        hash = (37 * hash) + ROWS_FIELD_NUMBER;
        hash = (53 * hash) + getRowsList().hashCode();
      }
      hash = (37 * hash) + VEHICLE_START_TAG_FIELD_NUMBER;
      hash = (53 * hash) + getVehicleStartTag().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies a duration and distance matrix from visit and vehicle start
     * locations to visit and vehicle end locations.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix)
        com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrixOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_DurationDistanceMatrix_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_DurationDistanceMatrix_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.class,
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (rowsBuilder_ == null) {
          rows_ = java.util.Collections.emptyList();
        } else {
          rows_ = null;
          rowsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        vehicleStartTag_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_DurationDistanceMatrix_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
          getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix build() {
        com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix buildPartial() {
        com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix result =
            new com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix(this);
        int from_bitField0_ = bitField0_;
        if (rowsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            rows_ = java.util.Collections.unmodifiableList(rows_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.rows_ = rows_;
        } else {
          result.rows_ = rowsBuilder_.build();
        }
        result.vehicleStartTag_ = vehicleStartTag_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix) {
          return mergeFrom(
              (com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix other) {
        if (other
            == com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
                .getDefaultInstance()) return this;
        if (rowsBuilder_ == null) {
          if (!other.rows_.isEmpty()) {
            if (rows_.isEmpty()) {
              rows_ = other.rows_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureRowsIsMutable();
              rows_.addAll(other.rows_);
            }
            onChanged();
          }
        } else {
          if (!other.rows_.isEmpty()) {
            if (rowsBuilder_.isEmpty()) {
              rowsBuilder_.dispose();
              rowsBuilder_ = null;
              rows_ = other.rows_;
              bitField0_ = (bitField0_ & ~0x00000001);
              rowsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getRowsFieldBuilder()
                      : null;
            } else {
              rowsBuilder_.addAllMessages(other.rows_);
            }
          }
        }
        if (!other.getVehicleStartTag().isEmpty()) {
          vehicleStartTag_ = other.vehicleStartTag_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row m =
                      input.readMessage(
                          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
                              .parser(),
                          extensionRegistry);
                  if (rowsBuilder_ == null) {
                    ensureRowsIsMutable();
                    rows_.add(m);
                  } else {
                    rowsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  vehicleStartTag_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row>
          rows_ = java.util.Collections.emptyList();

      private void ensureRowsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          rows_ =
              new java.util.ArrayList<
                  com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row>(rows_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row,
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder,
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.RowOrBuilder>
          rowsBuilder_;

      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row>
          getRowsList() {
        if (rowsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(rows_);
        } else {
          return rowsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public int getRowsCount() {
        if (rowsBuilder_ == null) {
          return rows_.size();
        } else {
          return rowsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row getRows(
          int index) {
        if (rowsBuilder_ == null) {
          return rows_.get(index);
        } else {
          return rowsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public Builder setRows(
          int index,
          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row value) {
        if (rowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowsIsMutable();
          rows_.set(index, value);
          onChanged();
        } else {
          rowsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public Builder setRows(
          int index,
          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder
              builderForValue) {
        if (rowsBuilder_ == null) {
          ensureRowsIsMutable();
          rows_.set(index, builderForValue.build());
          onChanged();
        } else {
          rowsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public Builder addRows(
          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row value) {
        if (rowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowsIsMutable();
          rows_.add(value);
          onChanged();
        } else {
          rowsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public Builder addRows(
          int index,
          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row value) {
        if (rowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowsIsMutable();
          rows_.add(index, value);
          onChanged();
        } else {
          rowsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public Builder addRows(
          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder
              builderForValue) {
        if (rowsBuilder_ == null) {
          ensureRowsIsMutable();
          rows_.add(builderForValue.build());
          onChanged();
        } else {
          rowsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public Builder addRows(
          int index,
          com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder
              builderForValue) {
        if (rowsBuilder_ == null) {
          ensureRowsIsMutable();
          rows_.add(index, builderForValue.build());
          onChanged();
        } else {
          rowsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public Builder addAllRows(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row>
              values) {
        if (rowsBuilder_ == null) {
          ensureRowsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rows_);
          onChanged();
        } else {
          rowsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public Builder clearRows() {
        if (rowsBuilder_ == null) {
          rows_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          rowsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public Builder removeRows(int index) {
        if (rowsBuilder_ == null) {
          ensureRowsIsMutable();
          rows_.remove(index);
          onChanged();
        } else {
          rowsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder
          getRowsBuilder(int index) {
        return getRowsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.RowOrBuilder
          getRowsOrBuilder(int index) {
        if (rowsBuilder_ == null) {
          return rows_.get(index);
        } else {
          return rowsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
                      .RowOrBuilder>
          getRowsOrBuilderList() {
        if (rowsBuilder_ != null) {
          return rowsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(rows_);
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder
          addRowsBuilder() {
        return getRowsFieldBuilder()
            .addBuilder(
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder
          addRowsBuilder(int index) {
        return getRowsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Specifies the rows of the duration and distance matrix. It must have as
       * many elements as [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row rows = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder>
          getRowsBuilderList() {
        return getRowsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row,
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder,
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.RowOrBuilder>
          getRowsFieldBuilder() {
        if (rowsBuilder_ == null) {
          rowsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row,
                  com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.Builder,
                  com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
                      .RowOrBuilder>(
                  rows_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          rows_ = null;
        }
        return rowsBuilder_;
      }

      private java.lang.Object vehicleStartTag_ = "";
      /**
       *
       *
       * <pre>
       * Tag defining to which vehicles this duration and distance matrix applies.
       * If empty, this applies to all vehicles, and there can only be a single
       * matrix.
       * Each vehicle start must match exactly one matrix, i.e. exactly one of
       * their `start_tags` field must match the `vehicle_start_tag` of a matrix
       * (and of that matrix only).
       * All matrices must have a different `vehicle_start_tag`.
       * </pre>
       *
       * <code>string vehicle_start_tag = 2;</code>
       *
       * @return The vehicleStartTag.
       */
      public java.lang.String getVehicleStartTag() {
        java.lang.Object ref = vehicleStartTag_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          vehicleStartTag_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Tag defining to which vehicles this duration and distance matrix applies.
       * If empty, this applies to all vehicles, and there can only be a single
       * matrix.
       * Each vehicle start must match exactly one matrix, i.e. exactly one of
       * their `start_tags` field must match the `vehicle_start_tag` of a matrix
       * (and of that matrix only).
       * All matrices must have a different `vehicle_start_tag`.
       * </pre>
       *
       * <code>string vehicle_start_tag = 2;</code>
       *
       * @return The bytes for vehicleStartTag.
       */
      public com.google.protobuf.ByteString getVehicleStartTagBytes() {
        java.lang.Object ref = vehicleStartTag_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          vehicleStartTag_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Tag defining to which vehicles this duration and distance matrix applies.
       * If empty, this applies to all vehicles, and there can only be a single
       * matrix.
       * Each vehicle start must match exactly one matrix, i.e. exactly one of
       * their `start_tags` field must match the `vehicle_start_tag` of a matrix
       * (and of that matrix only).
       * All matrices must have a different `vehicle_start_tag`.
       * </pre>
       *
       * <code>string vehicle_start_tag = 2;</code>
       *
       * @param value The vehicleStartTag to set.
       * @return This builder for chaining.
       */
      public Builder setVehicleStartTag(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        vehicleStartTag_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Tag defining to which vehicles this duration and distance matrix applies.
       * If empty, this applies to all vehicles, and there can only be a single
       * matrix.
       * Each vehicle start must match exactly one matrix, i.e. exactly one of
       * their `start_tags` field must match the `vehicle_start_tag` of a matrix
       * (and of that matrix only).
       * All matrices must have a different `vehicle_start_tag`.
       * </pre>
       *
       * <code>string vehicle_start_tag = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVehicleStartTag() {

        vehicleStartTag_ = getDefaultInstance().getVehicleStartTag();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Tag defining to which vehicles this duration and distance matrix applies.
       * If empty, this applies to all vehicles, and there can only be a single
       * matrix.
       * Each vehicle start must match exactly one matrix, i.e. exactly one of
       * their `start_tags` field must match the `vehicle_start_tag` of a matrix
       * (and of that matrix only).
       * All matrices must have a different `vehicle_start_tag`.
       * </pre>
       *
       * <code>string vehicle_start_tag = 2;</code>
       *
       * @param value The bytes for vehicleStartTag to set.
       * @return This builder for chaining.
       */
      public Builder setVehicleStartTagBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        vehicleStartTag_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix)
    private static final com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix();
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DurationDistanceMatrix> PARSER =
        new com.google.protobuf.AbstractParser<DurationDistanceMatrix>() {
          @java.lang.Override
          public DurationDistanceMatrix parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DurationDistanceMatrix> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DurationDistanceMatrix> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PrecedenceRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentModel.PrecedenceRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Shipment index of the "first" event. This field must be specified.
     * </pre>
     *
     * <code>optional int32 first_index = 1;</code>
     *
     * @return Whether the firstIndex field is set.
     */
    boolean hasFirstIndex();
    /**
     *
     *
     * <pre>
     * Shipment index of the "first" event. This field must be specified.
     * </pre>
     *
     * <code>optional int32 first_index = 1;</code>
     *
     * @return The firstIndex.
     */
    int getFirstIndex();

    /**
     *
     *
     * <pre>
     * Indicates if the "first" event is a delivery.
     * </pre>
     *
     * <code>bool first_is_delivery = 3;</code>
     *
     * @return The firstIsDelivery.
     */
    boolean getFirstIsDelivery();

    /**
     *
     *
     * <pre>
     * Shipment index of the "second" event. This field must be specified.
     * </pre>
     *
     * <code>optional int32 second_index = 2;</code>
     *
     * @return Whether the secondIndex field is set.
     */
    boolean hasSecondIndex();
    /**
     *
     *
     * <pre>
     * Shipment index of the "second" event. This field must be specified.
     * </pre>
     *
     * <code>optional int32 second_index = 2;</code>
     *
     * @return The secondIndex.
     */
    int getSecondIndex();

    /**
     *
     *
     * <pre>
     * Indicates if the "second" event is a delivery.
     * </pre>
     *
     * <code>bool second_is_delivery = 4;</code>
     *
     * @return The secondIsDelivery.
     */
    boolean getSecondIsDelivery();

    /**
     *
     *
     * <pre>
     * The offset between the "first" and "second" event. It can be negative.
     * </pre>
     *
     * <code>.google.protobuf.Duration offset_duration = 5;</code>
     *
     * @return Whether the offsetDuration field is set.
     */
    boolean hasOffsetDuration();
    /**
     *
     *
     * <pre>
     * The offset between the "first" and "second" event. It can be negative.
     * </pre>
     *
     * <code>.google.protobuf.Duration offset_duration = 5;</code>
     *
     * @return The offsetDuration.
     */
    com.google.protobuf.Duration getOffsetDuration();
    /**
     *
     *
     * <pre>
     * The offset between the "first" and "second" event. It can be negative.
     * </pre>
     *
     * <code>.google.protobuf.Duration offset_duration = 5;</code>
     */
    com.google.protobuf.DurationOrBuilder getOffsetDurationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A precedence rule between two events (each event is the pickup or the
   * delivery of a shipment): the "second" event has to start at least
   * `offset_duration` after "first" has started.
   * Several precedences can refer to the same (or related) events, e.g.,
   * "pickup of B happens after delivery of A" and "pickup of C happens after
   * pickup of B".
   * Furthermore, precedences only apply when both shipments are performed and
   * are otherwise ignored.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel.PrecedenceRule}
   */
  public static final class PrecedenceRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentModel.PrecedenceRule)
      PrecedenceRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PrecedenceRule.newBuilder() to construct.
    private PrecedenceRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PrecedenceRule() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PrecedenceRule();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentModel_PrecedenceRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentModel_PrecedenceRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.class,
              com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder.class);
    }

    private int bitField0_;
    public static final int FIRST_INDEX_FIELD_NUMBER = 1;
    private int firstIndex_;
    /**
     *
     *
     * <pre>
     * Shipment index of the "first" event. This field must be specified.
     * </pre>
     *
     * <code>optional int32 first_index = 1;</code>
     *
     * @return Whether the firstIndex field is set.
     */
    @java.lang.Override
    public boolean hasFirstIndex() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Shipment index of the "first" event. This field must be specified.
     * </pre>
     *
     * <code>optional int32 first_index = 1;</code>
     *
     * @return The firstIndex.
     */
    @java.lang.Override
    public int getFirstIndex() {
      return firstIndex_;
    }

    public static final int FIRST_IS_DELIVERY_FIELD_NUMBER = 3;
    private boolean firstIsDelivery_;
    /**
     *
     *
     * <pre>
     * Indicates if the "first" event is a delivery.
     * </pre>
     *
     * <code>bool first_is_delivery = 3;</code>
     *
     * @return The firstIsDelivery.
     */
    @java.lang.Override
    public boolean getFirstIsDelivery() {
      return firstIsDelivery_;
    }

    public static final int SECOND_INDEX_FIELD_NUMBER = 2;
    private int secondIndex_;
    /**
     *
     *
     * <pre>
     * Shipment index of the "second" event. This field must be specified.
     * </pre>
     *
     * <code>optional int32 second_index = 2;</code>
     *
     * @return Whether the secondIndex field is set.
     */
    @java.lang.Override
    public boolean hasSecondIndex() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Shipment index of the "second" event. This field must be specified.
     * </pre>
     *
     * <code>optional int32 second_index = 2;</code>
     *
     * @return The secondIndex.
     */
    @java.lang.Override
    public int getSecondIndex() {
      return secondIndex_;
    }

    public static final int SECOND_IS_DELIVERY_FIELD_NUMBER = 4;
    private boolean secondIsDelivery_;
    /**
     *
     *
     * <pre>
     * Indicates if the "second" event is a delivery.
     * </pre>
     *
     * <code>bool second_is_delivery = 4;</code>
     *
     * @return The secondIsDelivery.
     */
    @java.lang.Override
    public boolean getSecondIsDelivery() {
      return secondIsDelivery_;
    }

    public static final int OFFSET_DURATION_FIELD_NUMBER = 5;
    private com.google.protobuf.Duration offsetDuration_;
    /**
     *
     *
     * <pre>
     * The offset between the "first" and "second" event. It can be negative.
     * </pre>
     *
     * <code>.google.protobuf.Duration offset_duration = 5;</code>
     *
     * @return Whether the offsetDuration field is set.
     */
    @java.lang.Override
    public boolean hasOffsetDuration() {
      return offsetDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * The offset between the "first" and "second" event. It can be negative.
     * </pre>
     *
     * <code>.google.protobuf.Duration offset_duration = 5;</code>
     *
     * @return The offsetDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getOffsetDuration() {
      return offsetDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : offsetDuration_;
    }
    /**
     *
     *
     * <pre>
     * The offset between the "first" and "second" event. It can be negative.
     * </pre>
     *
     * <code>.google.protobuf.Duration offset_duration = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getOffsetDurationOrBuilder() {
      return getOffsetDuration();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt32(1, firstIndex_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt32(2, secondIndex_);
      }
      if (firstIsDelivery_ != false) {
        output.writeBool(3, firstIsDelivery_);
      }
      if (secondIsDelivery_ != false) {
        output.writeBool(4, secondIsDelivery_);
      }
      if (offsetDuration_ != null) {
        output.writeMessage(5, getOffsetDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, firstIndex_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, secondIndex_);
      }
      if (firstIsDelivery_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, firstIsDelivery_);
      }
      if (secondIsDelivery_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, secondIsDelivery_);
      }
      if (offsetDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getOffsetDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule other =
          (com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule) obj;

      if (hasFirstIndex() != other.hasFirstIndex()) return false;
      if (hasFirstIndex()) {
        if (getFirstIndex() != other.getFirstIndex()) return false;
      }
      if (getFirstIsDelivery() != other.getFirstIsDelivery()) return false;
      if (hasSecondIndex() != other.hasSecondIndex()) return false;
      if (hasSecondIndex()) {
        if (getSecondIndex() != other.getSecondIndex()) return false;
      }
      if (getSecondIsDelivery() != other.getSecondIsDelivery()) return false;
      if (hasOffsetDuration() != other.hasOffsetDuration()) return false;
      if (hasOffsetDuration()) {
        if (!getOffsetDuration().equals(other.getOffsetDuration())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasFirstIndex()) {
        hash = (37 * hash) + FIRST_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + getFirstIndex();
      }
      hash = (37 * hash) + FIRST_IS_DELIVERY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFirstIsDelivery());
      if (hasSecondIndex()) {
        hash = (37 * hash) + SECOND_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + getSecondIndex();
      }
      hash = (37 * hash) + SECOND_IS_DELIVERY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSecondIsDelivery());
      if (hasOffsetDuration()) {
        hash = (37 * hash) + OFFSET_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getOffsetDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A precedence rule between two events (each event is the pickup or the
     * delivery of a shipment): the "second" event has to start at least
     * `offset_duration` after "first" has started.
     * Several precedences can refer to the same (or related) events, e.g.,
     * "pickup of B happens after delivery of A" and "pickup of C happens after
     * pickup of B".
     * Furthermore, precedences only apply when both shipments are performed and
     * are otherwise ignored.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel.PrecedenceRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentModel.PrecedenceRule)
        com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_PrecedenceRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_PrecedenceRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.class,
                com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        firstIndex_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        firstIsDelivery_ = false;

        secondIndex_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        secondIsDelivery_ = false;

        if (offsetDurationBuilder_ == null) {
          offsetDuration_ = null;
        } else {
          offsetDuration_ = null;
          offsetDurationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_PrecedenceRule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule
          getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule build() {
        com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule buildPartial() {
        com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule result =
            new com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.firstIndex_ = firstIndex_;
          to_bitField0_ |= 0x00000001;
        }
        result.firstIsDelivery_ = firstIsDelivery_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.secondIndex_ = secondIndex_;
          to_bitField0_ |= 0x00000002;
        }
        result.secondIsDelivery_ = secondIsDelivery_;
        if (offsetDurationBuilder_ == null) {
          result.offsetDuration_ = offsetDuration_;
        } else {
          result.offsetDuration_ = offsetDurationBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule) {
          return mergeFrom((com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule other) {
        if (other
            == com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.getDefaultInstance())
          return this;
        if (other.hasFirstIndex()) {
          setFirstIndex(other.getFirstIndex());
        }
        if (other.getFirstIsDelivery() != false) {
          setFirstIsDelivery(other.getFirstIsDelivery());
        }
        if (other.hasSecondIndex()) {
          setSecondIndex(other.getSecondIndex());
        }
        if (other.getSecondIsDelivery() != false) {
          setSecondIsDelivery(other.getSecondIsDelivery());
        }
        if (other.hasOffsetDuration()) {
          mergeOffsetDuration(other.getOffsetDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  firstIndex_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  secondIndex_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  firstIsDelivery_ = input.readBool();

                  break;
                } // case 24
              case 32:
                {
                  secondIsDelivery_ = input.readBool();

                  break;
                } // case 32
              case 42:
                {
                  input.readMessage(
                      getOffsetDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int firstIndex_;
      /**
       *
       *
       * <pre>
       * Shipment index of the "first" event. This field must be specified.
       * </pre>
       *
       * <code>optional int32 first_index = 1;</code>
       *
       * @return Whether the firstIndex field is set.
       */
      @java.lang.Override
      public boolean hasFirstIndex() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Shipment index of the "first" event. This field must be specified.
       * </pre>
       *
       * <code>optional int32 first_index = 1;</code>
       *
       * @return The firstIndex.
       */
      @java.lang.Override
      public int getFirstIndex() {
        return firstIndex_;
      }
      /**
       *
       *
       * <pre>
       * Shipment index of the "first" event. This field must be specified.
       * </pre>
       *
       * <code>optional int32 first_index = 1;</code>
       *
       * @param value The firstIndex to set.
       * @return This builder for chaining.
       */
      public Builder setFirstIndex(int value) {
        bitField0_ |= 0x00000001;
        firstIndex_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Shipment index of the "first" event. This field must be specified.
       * </pre>
       *
       * <code>optional int32 first_index = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFirstIndex() {
        bitField0_ = (bitField0_ & ~0x00000001);
        firstIndex_ = 0;
        onChanged();
        return this;
      }

      private boolean firstIsDelivery_;
      /**
       *
       *
       * <pre>
       * Indicates if the "first" event is a delivery.
       * </pre>
       *
       * <code>bool first_is_delivery = 3;</code>
       *
       * @return The firstIsDelivery.
       */
      @java.lang.Override
      public boolean getFirstIsDelivery() {
        return firstIsDelivery_;
      }
      /**
       *
       *
       * <pre>
       * Indicates if the "first" event is a delivery.
       * </pre>
       *
       * <code>bool first_is_delivery = 3;</code>
       *
       * @param value The firstIsDelivery to set.
       * @return This builder for chaining.
       */
      public Builder setFirstIsDelivery(boolean value) {

        firstIsDelivery_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates if the "first" event is a delivery.
       * </pre>
       *
       * <code>bool first_is_delivery = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFirstIsDelivery() {

        firstIsDelivery_ = false;
        onChanged();
        return this;
      }

      private int secondIndex_;
      /**
       *
       *
       * <pre>
       * Shipment index of the "second" event. This field must be specified.
       * </pre>
       *
       * <code>optional int32 second_index = 2;</code>
       *
       * @return Whether the secondIndex field is set.
       */
      @java.lang.Override
      public boolean hasSecondIndex() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Shipment index of the "second" event. This field must be specified.
       * </pre>
       *
       * <code>optional int32 second_index = 2;</code>
       *
       * @return The secondIndex.
       */
      @java.lang.Override
      public int getSecondIndex() {
        return secondIndex_;
      }
      /**
       *
       *
       * <pre>
       * Shipment index of the "second" event. This field must be specified.
       * </pre>
       *
       * <code>optional int32 second_index = 2;</code>
       *
       * @param value The secondIndex to set.
       * @return This builder for chaining.
       */
      public Builder setSecondIndex(int value) {
        bitField0_ |= 0x00000002;
        secondIndex_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Shipment index of the "second" event. This field must be specified.
       * </pre>
       *
       * <code>optional int32 second_index = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSecondIndex() {
        bitField0_ = (bitField0_ & ~0x00000002);
        secondIndex_ = 0;
        onChanged();
        return this;
      }

      private boolean secondIsDelivery_;
      /**
       *
       *
       * <pre>
       * Indicates if the "second" event is a delivery.
       * </pre>
       *
       * <code>bool second_is_delivery = 4;</code>
       *
       * @return The secondIsDelivery.
       */
      @java.lang.Override
      public boolean getSecondIsDelivery() {
        return secondIsDelivery_;
      }
      /**
       *
       *
       * <pre>
       * Indicates if the "second" event is a delivery.
       * </pre>
       *
       * <code>bool second_is_delivery = 4;</code>
       *
       * @param value The secondIsDelivery to set.
       * @return This builder for chaining.
       */
      public Builder setSecondIsDelivery(boolean value) {

        secondIsDelivery_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates if the "second" event is a delivery.
       * </pre>
       *
       * <code>bool second_is_delivery = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSecondIsDelivery() {

        secondIsDelivery_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration offsetDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          offsetDurationBuilder_;
      /**
       *
       *
       * <pre>
       * The offset between the "first" and "second" event. It can be negative.
       * </pre>
       *
       * <code>.google.protobuf.Duration offset_duration = 5;</code>
       *
       * @return Whether the offsetDuration field is set.
       */
      public boolean hasOffsetDuration() {
        return offsetDurationBuilder_ != null || offsetDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * The offset between the "first" and "second" event. It can be negative.
       * </pre>
       *
       * <code>.google.protobuf.Duration offset_duration = 5;</code>
       *
       * @return The offsetDuration.
       */
      public com.google.protobuf.Duration getOffsetDuration() {
        if (offsetDurationBuilder_ == null) {
          return offsetDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : offsetDuration_;
        } else {
          return offsetDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The offset between the "first" and "second" event. It can be negative.
       * </pre>
       *
       * <code>.google.protobuf.Duration offset_duration = 5;</code>
       */
      public Builder setOffsetDuration(com.google.protobuf.Duration value) {
        if (offsetDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          offsetDuration_ = value;
          onChanged();
        } else {
          offsetDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The offset between the "first" and "second" event. It can be negative.
       * </pre>
       *
       * <code>.google.protobuf.Duration offset_duration = 5;</code>
       */
      public Builder setOffsetDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (offsetDurationBuilder_ == null) {
          offsetDuration_ = builderForValue.build();
          onChanged();
        } else {
          offsetDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The offset between the "first" and "second" event. It can be negative.
       * </pre>
       *
       * <code>.google.protobuf.Duration offset_duration = 5;</code>
       */
      public Builder mergeOffsetDuration(com.google.protobuf.Duration value) {
        if (offsetDurationBuilder_ == null) {
          if (offsetDuration_ != null) {
            offsetDuration_ =
                com.google.protobuf.Duration.newBuilder(offsetDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            offsetDuration_ = value;
          }
          onChanged();
        } else {
          offsetDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The offset between the "first" and "second" event. It can be negative.
       * </pre>
       *
       * <code>.google.protobuf.Duration offset_duration = 5;</code>
       */
      public Builder clearOffsetDuration() {
        if (offsetDurationBuilder_ == null) {
          offsetDuration_ = null;
          onChanged();
        } else {
          offsetDuration_ = null;
          offsetDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The offset between the "first" and "second" event. It can be negative.
       * </pre>
       *
       * <code>.google.protobuf.Duration offset_duration = 5;</code>
       */
      public com.google.protobuf.Duration.Builder getOffsetDurationBuilder() {

        onChanged();
        return getOffsetDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The offset between the "first" and "second" event. It can be negative.
       * </pre>
       *
       * <code>.google.protobuf.Duration offset_duration = 5;</code>
       */
      public com.google.protobuf.DurationOrBuilder getOffsetDurationOrBuilder() {
        if (offsetDurationBuilder_ != null) {
          return offsetDurationBuilder_.getMessageOrBuilder();
        } else {
          return offsetDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : offsetDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * The offset between the "first" and "second" event. It can be negative.
       * </pre>
       *
       * <code>.google.protobuf.Duration offset_duration = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getOffsetDurationFieldBuilder() {
        if (offsetDurationBuilder_ == null) {
          offsetDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getOffsetDuration(), getParentForChildren(), isClean());
          offsetDuration_ = null;
        }
        return offsetDurationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentModel.PrecedenceRule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentModel.PrecedenceRule)
    private static final com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule();
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PrecedenceRule> PARSER =
        new com.google.protobuf.AbstractParser<PrecedenceRule>() {
          @java.lang.Override
          public PrecedenceRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PrecedenceRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PrecedenceRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  @java.lang.Deprecated
  public interface BreakRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentModel.BreakRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest>
        getBreakRequestsList();
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest getBreakRequests(
        int index);
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    int getBreakRequestsCount();
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequestOrBuilder>
        getBreakRequestsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequestOrBuilder
        getBreakRequestsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint>
        getFrequencyConstraintsList();
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
        getFrequencyConstraints(int index);
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    int getFrequencyConstraintsCount();
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule
                    .FrequencyConstraintOrBuilder>
        getFrequencyConstraintsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraintOrBuilder
        getFrequencyConstraintsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use top level [BreakRule][] instead.
   * Rules to generate time breaks for a vehicle (e.g. lunch
   * breaks). A break is a contiguous period of time during which the vehicle
   * remains idle at its current position and cannot perform any visit. A break
   * may occur:
   * * during the travel between two visits (which includes the time right
   *   before or right after a visit, but not in the middle of a visit), in
   *   which case it extends the corresponding transit time between the visits,
   * * or before the vehicle start (the vehicle may not start in the middle of
   *   a break), in which case it does not affect the vehicle start time.
   * * or after the vehicle end (ditto, with the vehicle end time).
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel.BreakRule}
   */
  @java.lang.Deprecated
  public static final class BreakRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentModel.BreakRule)
      BreakRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BreakRule.newBuilder() to construct.
    private BreakRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BreakRule() {
      breakRequests_ = java.util.Collections.emptyList();
      frequencyConstraints_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BreakRule();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.class,
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder.class);
    }

    public interface BreakRequestOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the earliestStartTime field is set.
       */
      boolean hasEarliestStartTime();
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The earliestStartTime.
       */
      com.google.protobuf.Timestamp getEarliestStartTime();
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.protobuf.TimestampOrBuilder getEarliestStartTimeOrBuilder();

      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the latestStartTime field is set.
       */
      boolean hasLatestStartTime();
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The latestStartTime.
       */
      com.google.protobuf.Timestamp getLatestStartTime();
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.protobuf.TimestampOrBuilder getLatestStartTimeOrBuilder();

      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the minDuration field is set.
       */
      boolean hasMinDuration();
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The minDuration.
       */
      com.google.protobuf.Duration getMinDuration();
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.protobuf.DurationOrBuilder getMinDurationOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * The sequence of breaks (i.e. their number and order) that apply to each
     * vehicle must be known beforehand. The repeated `BreakRequest`s define
     * that sequence, in the order in which they must occur. Their time windows
     * (`earliest_start_time` / `latest_start_time`) may overlap, but they must
     * be compatible with the order (this is checked).
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest}
     */
    public static final class BreakRequest extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest)
        BreakRequestOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use BreakRequest.newBuilder() to construct.
      private BreakRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private BreakRequest() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new BreakRequest();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_BreakRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_BreakRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.class,
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder
                    .class);
      }

      public static final int EARLIEST_START_TIME_FIELD_NUMBER = 1;
      private com.google.protobuf.Timestamp earliestStartTime_;
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the earliestStartTime field is set.
       */
      @java.lang.Override
      public boolean hasEarliestStartTime() {
        return earliestStartTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The earliestStartTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getEarliestStartTime() {
        return earliestStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : earliestStartTime_;
      }
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getEarliestStartTimeOrBuilder() {
        return getEarliestStartTime();
      }

      public static final int LATEST_START_TIME_FIELD_NUMBER = 2;
      private com.google.protobuf.Timestamp latestStartTime_;
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the latestStartTime field is set.
       */
      @java.lang.Override
      public boolean hasLatestStartTime() {
        return latestStartTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The latestStartTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getLatestStartTime() {
        return latestStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : latestStartTime_;
      }
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getLatestStartTimeOrBuilder() {
        return getLatestStartTime();
      }

      public static final int MIN_DURATION_FIELD_NUMBER = 3;
      private com.google.protobuf.Duration minDuration_;
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the minDuration field is set.
       */
      @java.lang.Override
      public boolean hasMinDuration() {
        return minDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The minDuration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getMinDuration() {
        return minDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minDuration_;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getMinDurationOrBuilder() {
        return getMinDuration();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (earliestStartTime_ != null) {
          output.writeMessage(1, getEarliestStartTime());
        }
        if (latestStartTime_ != null) {
          output.writeMessage(2, getLatestStartTime());
        }
        if (minDuration_ != null) {
          output.writeMessage(3, getMinDuration());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (earliestStartTime_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEarliestStartTime());
        }
        if (latestStartTime_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLatestStartTime());
        }
        if (minDuration_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMinDuration());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest)) {
          return super.equals(obj);
        }
        com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest other =
            (com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest) obj;

        if (hasEarliestStartTime() != other.hasEarliestStartTime()) return false;
        if (hasEarliestStartTime()) {
          if (!getEarliestStartTime().equals(other.getEarliestStartTime())) return false;
        }
        if (hasLatestStartTime() != other.hasLatestStartTime()) return false;
        if (hasLatestStartTime()) {
          if (!getLatestStartTime().equals(other.getLatestStartTime())) return false;
        }
        if (hasMinDuration() != other.hasMinDuration()) return false;
        if (hasMinDuration()) {
          if (!getMinDuration().equals(other.getMinDuration())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasEarliestStartTime()) {
          hash = (37 * hash) + EARLIEST_START_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getEarliestStartTime().hashCode();
        }
        if (hasLatestStartTime()) {
          hash = (37 * hash) + LATEST_START_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getLatestStartTime().hashCode();
        }
        if (hasMinDuration()) {
          hash = (37 * hash) + MIN_DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getMinDuration().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The sequence of breaks (i.e. their number and order) that apply to each
       * vehicle must be known beforehand. The repeated `BreakRequest`s define
       * that sequence, in the order in which they must occur. Their time windows
       * (`earliest_start_time` / `latest_start_time`) may overlap, but they must
       * be compatible with the order (this is checked).
       * </pre>
       *
       * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest)
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequestOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_BreakRequest_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_BreakRequest_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.class,
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (earliestStartTimeBuilder_ == null) {
            earliestStartTime_ = null;
          } else {
            earliestStartTime_ = null;
            earliestStartTimeBuilder_ = null;
          }
          if (latestStartTimeBuilder_ == null) {
            latestStartTime_ = null;
          } else {
            latestStartTime_ = null;
            latestStartTimeBuilder_ = null;
          }
          if (minDurationBuilder_ == null) {
            minDuration_ = null;
          } else {
            minDuration_ = null;
            minDurationBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_BreakRequest_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
            getDefaultInstanceForType() {
          return com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest build() {
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
            buildPartial() {
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest result =
              new com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest(this);
          if (earliestStartTimeBuilder_ == null) {
            result.earliestStartTime_ = earliestStartTime_;
          } else {
            result.earliestStartTime_ = earliestStartTimeBuilder_.build();
          }
          if (latestStartTimeBuilder_ == null) {
            result.latestStartTime_ = latestStartTime_;
          } else {
            result.latestStartTime_ = latestStartTimeBuilder_.build();
          }
          if (minDurationBuilder_ == null) {
            result.minDuration_ = minDuration_;
          } else {
            result.minDuration_ = minDurationBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest) {
            return mergeFrom(
                (com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest other) {
          if (other
              == com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
                  .getDefaultInstance()) return this;
          if (other.hasEarliestStartTime()) {
            mergeEarliestStartTime(other.getEarliestStartTime());
          }
          if (other.hasLatestStartTime()) {
            mergeLatestStartTime(other.getLatestStartTime());
          }
          if (other.hasMinDuration()) {
            mergeMinDuration(other.getMinDuration());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getEarliestStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getLatestStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getMinDurationFieldBuilder().getBuilder(), extensionRegistry);

                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private com.google.protobuf.Timestamp earliestStartTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            earliestStartTimeBuilder_;
        /**
         *
         *
         * <pre>
         * Required. Lower bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the earliestStartTime field is set.
         */
        public boolean hasEarliestStartTime() {
          return earliestStartTimeBuilder_ != null || earliestStartTime_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. Lower bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The earliestStartTime.
         */
        public com.google.protobuf.Timestamp getEarliestStartTime() {
          if (earliestStartTimeBuilder_ == null) {
            return earliestStartTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : earliestStartTime_;
          } else {
            return earliestStartTimeBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Lower bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setEarliestStartTime(com.google.protobuf.Timestamp value) {
          if (earliestStartTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            earliestStartTime_ = value;
            onChanged();
          } else {
            earliestStartTimeBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Lower bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setEarliestStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (earliestStartTimeBuilder_ == null) {
            earliestStartTime_ = builderForValue.build();
            onChanged();
          } else {
            earliestStartTimeBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Lower bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeEarliestStartTime(com.google.protobuf.Timestamp value) {
          if (earliestStartTimeBuilder_ == null) {
            if (earliestStartTime_ != null) {
              earliestStartTime_ =
                  com.google.protobuf.Timestamp.newBuilder(earliestStartTime_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              earliestStartTime_ = value;
            }
            onChanged();
          } else {
            earliestStartTimeBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Lower bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearEarliestStartTime() {
          if (earliestStartTimeBuilder_ == null) {
            earliestStartTime_ = null;
            onChanged();
          } else {
            earliestStartTime_ = null;
            earliestStartTimeBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Lower bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.protobuf.Timestamp.Builder getEarliestStartTimeBuilder() {

          onChanged();
          return getEarliestStartTimeFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. Lower bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.protobuf.TimestampOrBuilder getEarliestStartTimeOrBuilder() {
          if (earliestStartTimeBuilder_ != null) {
            return earliestStartTimeBuilder_.getMessageOrBuilder();
          } else {
            return earliestStartTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : earliestStartTime_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Lower bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getEarliestStartTimeFieldBuilder() {
          if (earliestStartTimeBuilder_ == null) {
            earliestStartTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getEarliestStartTime(), getParentForChildren(), isClean());
            earliestStartTime_ = null;
          }
          return earliestStartTimeBuilder_;
        }

        private com.google.protobuf.Timestamp latestStartTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            latestStartTimeBuilder_;
        /**
         *
         *
         * <pre>
         * Required. Upper bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the latestStartTime field is set.
         */
        public boolean hasLatestStartTime() {
          return latestStartTimeBuilder_ != null || latestStartTime_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. Upper bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The latestStartTime.
         */
        public com.google.protobuf.Timestamp getLatestStartTime() {
          if (latestStartTimeBuilder_ == null) {
            return latestStartTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : latestStartTime_;
          } else {
            return latestStartTimeBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Upper bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setLatestStartTime(com.google.protobuf.Timestamp value) {
          if (latestStartTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            latestStartTime_ = value;
            onChanged();
          } else {
            latestStartTimeBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Upper bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setLatestStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (latestStartTimeBuilder_ == null) {
            latestStartTime_ = builderForValue.build();
            onChanged();
          } else {
            latestStartTimeBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Upper bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeLatestStartTime(com.google.protobuf.Timestamp value) {
          if (latestStartTimeBuilder_ == null) {
            if (latestStartTime_ != null) {
              latestStartTime_ =
                  com.google.protobuf.Timestamp.newBuilder(latestStartTime_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              latestStartTime_ = value;
            }
            onChanged();
          } else {
            latestStartTimeBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Upper bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearLatestStartTime() {
          if (latestStartTimeBuilder_ == null) {
            latestStartTime_ = null;
            onChanged();
          } else {
            latestStartTime_ = null;
            latestStartTimeBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Upper bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.protobuf.Timestamp.Builder getLatestStartTimeBuilder() {

          onChanged();
          return getLatestStartTimeFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. Upper bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.protobuf.TimestampOrBuilder getLatestStartTimeOrBuilder() {
          if (latestStartTimeBuilder_ != null) {
            return latestStartTimeBuilder_.getMessageOrBuilder();
          } else {
            return latestStartTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : latestStartTime_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Upper bound (inclusive) on the start of the break.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getLatestStartTimeFieldBuilder() {
          if (latestStartTimeBuilder_ == null) {
            latestStartTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getLatestStartTime(), getParentForChildren(), isClean());
            latestStartTime_ = null;
          }
          return latestStartTimeBuilder_;
        }

        private com.google.protobuf.Duration minDuration_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            minDurationBuilder_;
        /**
         *
         *
         * <pre>
         * Required. Minimum duration of the break. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the minDuration field is set.
         */
        public boolean hasMinDuration() {
          return minDurationBuilder_ != null || minDuration_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum duration of the break. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The minDuration.
         */
        public com.google.protobuf.Duration getMinDuration() {
          if (minDurationBuilder_ == null) {
            return minDuration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : minDuration_;
          } else {
            return minDurationBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum duration of the break. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setMinDuration(com.google.protobuf.Duration value) {
          if (minDurationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            minDuration_ = value;
            onChanged();
          } else {
            minDurationBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum duration of the break. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setMinDuration(com.google.protobuf.Duration.Builder builderForValue) {
          if (minDurationBuilder_ == null) {
            minDuration_ = builderForValue.build();
            onChanged();
          } else {
            minDurationBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum duration of the break. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeMinDuration(com.google.protobuf.Duration value) {
          if (minDurationBuilder_ == null) {
            if (minDuration_ != null) {
              minDuration_ =
                  com.google.protobuf.Duration.newBuilder(minDuration_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              minDuration_ = value;
            }
            onChanged();
          } else {
            minDurationBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum duration of the break. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearMinDuration() {
          if (minDurationBuilder_ == null) {
            minDuration_ = null;
            onChanged();
          } else {
            minDuration_ = null;
            minDurationBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum duration of the break. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.protobuf.Duration.Builder getMinDurationBuilder() {

          onChanged();
          return getMinDurationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum duration of the break. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.protobuf.DurationOrBuilder getMinDurationOrBuilder() {
          if (minDurationBuilder_ != null) {
            return minDurationBuilder_.getMessageOrBuilder();
          } else {
            return minDuration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : minDuration_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum duration of the break. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getMinDurationFieldBuilder() {
          if (minDurationBuilder_ == null) {
            minDurationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getMinDuration(), getParentForChildren(), isClean());
            minDuration_ = null;
          }
          return minDurationBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest)
      private static final com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest();
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<BreakRequest> PARSER =
          new com.google.protobuf.AbstractParser<BreakRequest>() {
            @java.lang.Override
            public BreakRequest parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<BreakRequest> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<BreakRequest> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface FrequencyConstraintOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the minBreakDuration field is set.
       */
      boolean hasMinBreakDuration();
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The minBreakDuration.
       */
      com.google.protobuf.Duration getMinBreakDuration();
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.protobuf.DurationOrBuilder getMinBreakDurationOrBuilder();

      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the maxInterBreakDuration field is set.
       */
      boolean hasMaxInterBreakDuration();
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The maxInterBreakDuration.
       */
      com.google.protobuf.Duration getMaxInterBreakDuration();
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.protobuf.DurationOrBuilder getMaxInterBreakDurationOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * One may further constrain the frequency and duration of the breaks
     * specified above, by enforcing a minimum break frequency, such as
     * "There must be a break of at least 1 hour every 12 hours". Assuming that
     * this can be interpreted as "Within any sliding time window of 12h, there
     * must be at least one break of at least one hour", that example would
     * translate to the following `FrequencyConstraint`:
     * ```
     * {
     *    min_break_duration { seconds: 3600 }         # 1 hour.
     *    max_inter_break_duration { seconds: 39600 }  # 11 hours (12 - 1 = 11).
     * }
     * ```
     * The timing and duration of the breaks in the solution will respect all
     * such constraints, in addition to the time windows and minimum durations
     * already specified in the `BreakRequest`.
     * A `FrequencyConstraint` may in practice apply to non-consecutive breaks.
     * For example, the following schedule honors the "1h every 12h" example:
     * ```
     *   04:00 vehicle start
     *    .. performing travel and visits ..
     *   09:00 1 hour break
     *   10:00 end of the break
     *    .. performing travel and visits ..
     *   12:00 20-min lunch break
     *   12:20 end of the break
     *    .. performing travel and visits ..
     *   21:00 1 hour break
     *   22:00 end of the break
     *    .. performing travel and visits ..
     *   23:59 vehicle end
     * ```
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint}
     */
    public static final class FrequencyConstraint extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint)
        FrequencyConstraintOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FrequencyConstraint.newBuilder() to construct.
      private FrequencyConstraint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FrequencyConstraint() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FrequencyConstraint();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_FrequencyConstraint_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_FrequencyConstraint_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.class,
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.Builder
                    .class);
      }

      public static final int MIN_BREAK_DURATION_FIELD_NUMBER = 1;
      private com.google.protobuf.Duration minBreakDuration_;
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the minBreakDuration field is set.
       */
      @java.lang.Override
      public boolean hasMinBreakDuration() {
        return minBreakDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The minBreakDuration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getMinBreakDuration() {
        return minBreakDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minBreakDuration_;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getMinBreakDurationOrBuilder() {
        return getMinBreakDuration();
      }

      public static final int MAX_INTER_BREAK_DURATION_FIELD_NUMBER = 2;
      private com.google.protobuf.Duration maxInterBreakDuration_;
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the maxInterBreakDuration field is set.
       */
      @java.lang.Override
      public boolean hasMaxInterBreakDuration() {
        return maxInterBreakDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The maxInterBreakDuration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getMaxInterBreakDuration() {
        return maxInterBreakDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxInterBreakDuration_;
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getMaxInterBreakDurationOrBuilder() {
        return getMaxInterBreakDuration();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (minBreakDuration_ != null) {
          output.writeMessage(1, getMinBreakDuration());
        }
        if (maxInterBreakDuration_ != null) {
          output.writeMessage(2, getMaxInterBreakDuration());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (minBreakDuration_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMinBreakDuration());
        }
        if (maxInterBreakDuration_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, getMaxInterBreakDuration());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint)) {
          return super.equals(obj);
        }
        com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint other =
            (com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint) obj;

        if (hasMinBreakDuration() != other.hasMinBreakDuration()) return false;
        if (hasMinBreakDuration()) {
          if (!getMinBreakDuration().equals(other.getMinBreakDuration())) return false;
        }
        if (hasMaxInterBreakDuration() != other.hasMaxInterBreakDuration()) return false;
        if (hasMaxInterBreakDuration()) {
          if (!getMaxInterBreakDuration().equals(other.getMaxInterBreakDuration())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasMinBreakDuration()) {
          hash = (37 * hash) + MIN_BREAK_DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getMinBreakDuration().hashCode();
        }
        if (hasMaxInterBreakDuration()) {
          hash = (37 * hash) + MAX_INTER_BREAK_DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getMaxInterBreakDuration().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * One may further constrain the frequency and duration of the breaks
       * specified above, by enforcing a minimum break frequency, such as
       * "There must be a break of at least 1 hour every 12 hours". Assuming that
       * this can be interpreted as "Within any sliding time window of 12h, there
       * must be at least one break of at least one hour", that example would
       * translate to the following `FrequencyConstraint`:
       * ```
       * {
       *    min_break_duration { seconds: 3600 }         # 1 hour.
       *    max_inter_break_duration { seconds: 39600 }  # 11 hours (12 - 1 = 11).
       * }
       * ```
       * The timing and duration of the breaks in the solution will respect all
       * such constraints, in addition to the time windows and minimum durations
       * already specified in the `BreakRequest`.
       * A `FrequencyConstraint` may in practice apply to non-consecutive breaks.
       * For example, the following schedule honors the "1h every 12h" example:
       * ```
       *   04:00 vehicle start
       *    .. performing travel and visits ..
       *   09:00 1 hour break
       *   10:00 end of the break
       *    .. performing travel and visits ..
       *   12:00 20-min lunch break
       *   12:20 end of the break
       *    .. performing travel and visits ..
       *   21:00 1 hour break
       *   22:00 end of the break
       *    .. performing travel and visits ..
       *   23:59 vehicle end
       * ```
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint)
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraintOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_FrequencyConstraint_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_FrequencyConstraint_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
                      .class,
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (minBreakDurationBuilder_ == null) {
            minBreakDuration_ = null;
          } else {
            minBreakDuration_ = null;
            minBreakDurationBuilder_ = null;
          }
          if (maxInterBreakDurationBuilder_ == null) {
            maxInterBreakDuration_ = null;
          } else {
            maxInterBreakDuration_ = null;
            maxInterBreakDurationBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_FrequencyConstraint_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
            getDefaultInstanceForType() {
          return com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
            build() {
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
            buildPartial() {
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint result =
              new com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint(
                  this);
          if (minBreakDurationBuilder_ == null) {
            result.minBreakDuration_ = minBreakDuration_;
          } else {
            result.minBreakDuration_ = minBreakDurationBuilder_.build();
          }
          if (maxInterBreakDurationBuilder_ == null) {
            result.maxInterBreakDuration_ = maxInterBreakDuration_;
          } else {
            result.maxInterBreakDuration_ = maxInterBreakDurationBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint) {
            return mergeFrom(
                (com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint other) {
          if (other
              == com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
                  .getDefaultInstance()) return this;
          if (other.hasMinBreakDuration()) {
            mergeMinBreakDuration(other.getMinBreakDuration());
          }
          if (other.hasMaxInterBreakDuration()) {
            mergeMaxInterBreakDuration(other.getMaxInterBreakDuration());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getMinBreakDurationFieldBuilder().getBuilder(), extensionRegistry);

                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getMaxInterBreakDurationFieldBuilder().getBuilder(), extensionRegistry);

                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private com.google.protobuf.Duration minBreakDuration_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            minBreakDurationBuilder_;
        /**
         *
         *
         * <pre>
         * Required. Minimum break duration for this constraint. Nonnegative.
         * See description of `FrequencyConstraint`.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the minBreakDuration field is set.
         */
        public boolean hasMinBreakDuration() {
          return minBreakDurationBuilder_ != null || minBreakDuration_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum break duration for this constraint. Nonnegative.
         * See description of `FrequencyConstraint`.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The minBreakDuration.
         */
        public com.google.protobuf.Duration getMinBreakDuration() {
          if (minBreakDurationBuilder_ == null) {
            return minBreakDuration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : minBreakDuration_;
          } else {
            return minBreakDurationBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum break duration for this constraint. Nonnegative.
         * See description of `FrequencyConstraint`.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setMinBreakDuration(com.google.protobuf.Duration value) {
          if (minBreakDurationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            minBreakDuration_ = value;
            onChanged();
          } else {
            minBreakDurationBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum break duration for this constraint. Nonnegative.
         * See description of `FrequencyConstraint`.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setMinBreakDuration(com.google.protobuf.Duration.Builder builderForValue) {
          if (minBreakDurationBuilder_ == null) {
            minBreakDuration_ = builderForValue.build();
            onChanged();
          } else {
            minBreakDurationBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum break duration for this constraint. Nonnegative.
         * See description of `FrequencyConstraint`.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeMinBreakDuration(com.google.protobuf.Duration value) {
          if (minBreakDurationBuilder_ == null) {
            if (minBreakDuration_ != null) {
              minBreakDuration_ =
                  com.google.protobuf.Duration.newBuilder(minBreakDuration_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              minBreakDuration_ = value;
            }
            onChanged();
          } else {
            minBreakDurationBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum break duration for this constraint. Nonnegative.
         * See description of `FrequencyConstraint`.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearMinBreakDuration() {
          if (minBreakDurationBuilder_ == null) {
            minBreakDuration_ = null;
            onChanged();
          } else {
            minBreakDuration_ = null;
            minBreakDurationBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum break duration for this constraint. Nonnegative.
         * See description of `FrequencyConstraint`.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.protobuf.Duration.Builder getMinBreakDurationBuilder() {

          onChanged();
          return getMinBreakDurationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum break duration for this constraint. Nonnegative.
         * See description of `FrequencyConstraint`.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.protobuf.DurationOrBuilder getMinBreakDurationOrBuilder() {
          if (minBreakDurationBuilder_ != null) {
            return minBreakDurationBuilder_.getMessageOrBuilder();
          } else {
            return minBreakDuration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : minBreakDuration_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Minimum break duration for this constraint. Nonnegative.
         * See description of `FrequencyConstraint`.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getMinBreakDurationFieldBuilder() {
          if (minBreakDurationBuilder_ == null) {
            minBreakDurationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getMinBreakDuration(), getParentForChildren(), isClean());
            minBreakDuration_ = null;
          }
          return minBreakDurationBuilder_;
        }

        private com.google.protobuf.Duration maxInterBreakDuration_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            maxInterBreakDurationBuilder_;
        /**
         *
         *
         * <pre>
         * Required. Maximum allowed span of any interval of time in the route that does not
         * include at least partially a break of `duration &gt;=
         * min_break_duration`. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the maxInterBreakDuration field is set.
         */
        public boolean hasMaxInterBreakDuration() {
          return maxInterBreakDurationBuilder_ != null || maxInterBreakDuration_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. Maximum allowed span of any interval of time in the route that does not
         * include at least partially a break of `duration &gt;=
         * min_break_duration`. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The maxInterBreakDuration.
         */
        public com.google.protobuf.Duration getMaxInterBreakDuration() {
          if (maxInterBreakDurationBuilder_ == null) {
            return maxInterBreakDuration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : maxInterBreakDuration_;
          } else {
            return maxInterBreakDurationBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Maximum allowed span of any interval of time in the route that does not
         * include at least partially a break of `duration &gt;=
         * min_break_duration`. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setMaxInterBreakDuration(com.google.protobuf.Duration value) {
          if (maxInterBreakDurationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            maxInterBreakDuration_ = value;
            onChanged();
          } else {
            maxInterBreakDurationBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Maximum allowed span of any interval of time in the route that does not
         * include at least partially a break of `duration &gt;=
         * min_break_duration`. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setMaxInterBreakDuration(
            com.google.protobuf.Duration.Builder builderForValue) {
          if (maxInterBreakDurationBuilder_ == null) {
            maxInterBreakDuration_ = builderForValue.build();
            onChanged();
          } else {
            maxInterBreakDurationBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Maximum allowed span of any interval of time in the route that does not
         * include at least partially a break of `duration &gt;=
         * min_break_duration`. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeMaxInterBreakDuration(com.google.protobuf.Duration value) {
          if (maxInterBreakDurationBuilder_ == null) {
            if (maxInterBreakDuration_ != null) {
              maxInterBreakDuration_ =
                  com.google.protobuf.Duration.newBuilder(maxInterBreakDuration_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              maxInterBreakDuration_ = value;
            }
            onChanged();
          } else {
            maxInterBreakDurationBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Maximum allowed span of any interval of time in the route that does not
         * include at least partially a break of `duration &gt;=
         * min_break_duration`. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearMaxInterBreakDuration() {
          if (maxInterBreakDurationBuilder_ == null) {
            maxInterBreakDuration_ = null;
            onChanged();
          } else {
            maxInterBreakDuration_ = null;
            maxInterBreakDurationBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Maximum allowed span of any interval of time in the route that does not
         * include at least partially a break of `duration &gt;=
         * min_break_duration`. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.protobuf.Duration.Builder getMaxInterBreakDurationBuilder() {

          onChanged();
          return getMaxInterBreakDurationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. Maximum allowed span of any interval of time in the route that does not
         * include at least partially a break of `duration &gt;=
         * min_break_duration`. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.protobuf.DurationOrBuilder getMaxInterBreakDurationOrBuilder() {
          if (maxInterBreakDurationBuilder_ != null) {
            return maxInterBreakDurationBuilder_.getMessageOrBuilder();
          } else {
            return maxInterBreakDuration_ == null
                ? com.google.protobuf.Duration.getDefaultInstance()
                : maxInterBreakDuration_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Maximum allowed span of any interval of time in the route that does not
         * include at least partially a break of `duration &gt;=
         * min_break_duration`. Must be positive.
         * </pre>
         *
         * <code>
         * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getMaxInterBreakDurationFieldBuilder() {
          if (maxInterBreakDurationBuilder_ == null) {
            maxInterBreakDurationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getMaxInterBreakDuration(), getParentForChildren(), isClean());
            maxInterBreakDuration_ = null;
          }
          return maxInterBreakDurationBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint)
      private static final com.google.cloud.optimization.v1.ShipmentModel.BreakRule
              .FrequencyConstraint
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint();
      }

      public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FrequencyConstraint> PARSER =
          new com.google.protobuf.AbstractParser<FrequencyConstraint>() {
            @java.lang.Override
            public FrequencyConstraint parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FrequencyConstraint> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FrequencyConstraint> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int BREAK_REQUESTS_FIELD_NUMBER = 1;
    private java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest>
        breakRequests_;
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest>
        getBreakRequestsList() {
      return breakRequests_;
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequestOrBuilder>
        getBreakRequestsOrBuilderList() {
      return breakRequests_;
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    @java.lang.Override
    public int getBreakRequestsCount() {
      return breakRequests_.size();
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest getBreakRequests(
        int index) {
      return breakRequests_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequestOrBuilder
        getBreakRequestsOrBuilder(int index) {
      return breakRequests_.get(index);
    }

    public static final int FREQUENCY_CONSTRAINTS_FIELD_NUMBER = 2;
    private java.util.List<
            com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint>
        frequencyConstraints_;
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint>
        getFrequencyConstraintsList() {
      return frequencyConstraints_;
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule
                    .FrequencyConstraintOrBuilder>
        getFrequencyConstraintsOrBuilderList() {
      return frequencyConstraints_;
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    @java.lang.Override
    public int getFrequencyConstraintsCount() {
      return frequencyConstraints_.size();
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
        getFrequencyConstraints(int index) {
      return frequencyConstraints_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraintOrBuilder
        getFrequencyConstraintsOrBuilder(int index) {
      return frequencyConstraints_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < breakRequests_.size(); i++) {
        output.writeMessage(1, breakRequests_.get(i));
      }
      for (int i = 0; i < frequencyConstraints_.size(); i++) {
        output.writeMessage(2, frequencyConstraints_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < breakRequests_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, breakRequests_.get(i));
      }
      for (int i = 0; i < frequencyConstraints_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, frequencyConstraints_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentModel.BreakRule)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.ShipmentModel.BreakRule other =
          (com.google.cloud.optimization.v1.ShipmentModel.BreakRule) obj;

      if (!getBreakRequestsList().equals(other.getBreakRequestsList())) return false;
      if (!getFrequencyConstraintsList().equals(other.getFrequencyConstraintsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getBreakRequestsCount() > 0) {
        hash = (37 * hash) + BREAK_REQUESTS_FIELD_NUMBER;
        hash = (53 * hash) + getBreakRequestsList().hashCode();
      }
      if (getFrequencyConstraintsCount() > 0) {
        hash = (37 * hash) + FREQUENCY_CONSTRAINTS_FIELD_NUMBER;
        hash = (53 * hash) + getFrequencyConstraintsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.ShipmentModel.BreakRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use top level [BreakRule][] instead.
     * Rules to generate time breaks for a vehicle (e.g. lunch
     * breaks). A break is a contiguous period of time during which the vehicle
     * remains idle at its current position and cannot perform any visit. A break
     * may occur:
     * * during the travel between two visits (which includes the time right
     *   before or right after a visit, but not in the middle of a visit), in
     *   which case it extends the corresponding transit time between the visits,
     * * or before the vehicle start (the vehicle may not start in the middle of
     *   a break), in which case it does not affect the vehicle start time.
     * * or after the vehicle end (ditto, with the vehicle end time).
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel.BreakRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentModel.BreakRule)
        com.google.cloud.optimization.v1.ShipmentModel.BreakRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.class,
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.ShipmentModel.BreakRule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (breakRequestsBuilder_ == null) {
          breakRequests_ = java.util.Collections.emptyList();
        } else {
          breakRequests_ = null;
          breakRequestsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (frequencyConstraintsBuilder_ == null) {
          frequencyConstraints_ = java.util.Collections.emptyList();
        } else {
          frequencyConstraints_ = null;
          frequencyConstraintsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_ShipmentModel_BreakRule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.ShipmentModel.BreakRule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule build() {
        com.google.cloud.optimization.v1.ShipmentModel.BreakRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule buildPartial() {
        com.google.cloud.optimization.v1.ShipmentModel.BreakRule result =
            new com.google.cloud.optimization.v1.ShipmentModel.BreakRule(this);
        int from_bitField0_ = bitField0_;
        if (breakRequestsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            breakRequests_ = java.util.Collections.unmodifiableList(breakRequests_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.breakRequests_ = breakRequests_;
        } else {
          result.breakRequests_ = breakRequestsBuilder_.build();
        }
        if (frequencyConstraintsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            frequencyConstraints_ = java.util.Collections.unmodifiableList(frequencyConstraints_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.frequencyConstraints_ = frequencyConstraints_;
        } else {
          result.frequencyConstraints_ = frequencyConstraintsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.ShipmentModel.BreakRule) {
          return mergeFrom((com.google.cloud.optimization.v1.ShipmentModel.BreakRule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.ShipmentModel.BreakRule other) {
        if (other == com.google.cloud.optimization.v1.ShipmentModel.BreakRule.getDefaultInstance())
          return this;
        if (breakRequestsBuilder_ == null) {
          if (!other.breakRequests_.isEmpty()) {
            if (breakRequests_.isEmpty()) {
              breakRequests_ = other.breakRequests_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureBreakRequestsIsMutable();
              breakRequests_.addAll(other.breakRequests_);
            }
            onChanged();
          }
        } else {
          if (!other.breakRequests_.isEmpty()) {
            if (breakRequestsBuilder_.isEmpty()) {
              breakRequestsBuilder_.dispose();
              breakRequestsBuilder_ = null;
              breakRequests_ = other.breakRequests_;
              bitField0_ = (bitField0_ & ~0x00000001);
              breakRequestsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getBreakRequestsFieldBuilder()
                      : null;
            } else {
              breakRequestsBuilder_.addAllMessages(other.breakRequests_);
            }
          }
        }
        if (frequencyConstraintsBuilder_ == null) {
          if (!other.frequencyConstraints_.isEmpty()) {
            if (frequencyConstraints_.isEmpty()) {
              frequencyConstraints_ = other.frequencyConstraints_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureFrequencyConstraintsIsMutable();
              frequencyConstraints_.addAll(other.frequencyConstraints_);
            }
            onChanged();
          }
        } else {
          if (!other.frequencyConstraints_.isEmpty()) {
            if (frequencyConstraintsBuilder_.isEmpty()) {
              frequencyConstraintsBuilder_.dispose();
              frequencyConstraintsBuilder_ = null;
              frequencyConstraints_ = other.frequencyConstraints_;
              bitField0_ = (bitField0_ & ~0x00000002);
              frequencyConstraintsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFrequencyConstraintsFieldBuilder()
                      : null;
            } else {
              frequencyConstraintsBuilder_.addAllMessages(other.frequencyConstraints_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest m =
                      input.readMessage(
                          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
                              .parser(),
                          extensionRegistry);
                  if (breakRequestsBuilder_ == null) {
                    ensureBreakRequestsIsMutable();
                    breakRequests_.add(m);
                  } else {
                    breakRequestsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint m =
                      input.readMessage(
                          com.google.cloud.optimization.v1.ShipmentModel.BreakRule
                              .FrequencyConstraint.parser(),
                          extensionRegistry);
                  if (frequencyConstraintsBuilder_ == null) {
                    ensureFrequencyConstraintsIsMutable();
                    frequencyConstraints_.add(m);
                  } else {
                    frequencyConstraintsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest>
          breakRequests_ = java.util.Collections.emptyList();

      private void ensureBreakRequestsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          breakRequests_ =
              new java.util.ArrayList<
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest>(
                  breakRequests_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest,
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder,
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequestOrBuilder>
          breakRequestsBuilder_;

      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest>
          getBreakRequestsList() {
        if (breakRequestsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(breakRequests_);
        } else {
          return breakRequestsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public int getBreakRequestsCount() {
        if (breakRequestsBuilder_ == null) {
          return breakRequests_.size();
        } else {
          return breakRequestsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest getBreakRequests(
          int index) {
        if (breakRequestsBuilder_ == null) {
          return breakRequests_.get(index);
        } else {
          return breakRequestsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public Builder setBreakRequests(
          int index, com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest value) {
        if (breakRequestsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBreakRequestsIsMutable();
          breakRequests_.set(index, value);
          onChanged();
        } else {
          breakRequestsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public Builder setBreakRequests(
          int index,
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder
              builderForValue) {
        if (breakRequestsBuilder_ == null) {
          ensureBreakRequestsIsMutable();
          breakRequests_.set(index, builderForValue.build());
          onChanged();
        } else {
          breakRequestsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public Builder addBreakRequests(
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest value) {
        if (breakRequestsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBreakRequestsIsMutable();
          breakRequests_.add(value);
          onChanged();
        } else {
          breakRequestsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public Builder addBreakRequests(
          int index, com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest value) {
        if (breakRequestsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBreakRequestsIsMutable();
          breakRequests_.add(index, value);
          onChanged();
        } else {
          breakRequestsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public Builder addBreakRequests(
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder
              builderForValue) {
        if (breakRequestsBuilder_ == null) {
          ensureBreakRequestsIsMutable();
          breakRequests_.add(builderForValue.build());
          onChanged();
        } else {
          breakRequestsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public Builder addBreakRequests(
          int index,
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder
              builderForValue) {
        if (breakRequestsBuilder_ == null) {
          ensureBreakRequestsIsMutable();
          breakRequests_.add(index, builderForValue.build());
          onChanged();
        } else {
          breakRequestsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public Builder addAllBreakRequests(
          java.lang.Iterable<
                  ? extends com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest>
              values) {
        if (breakRequestsBuilder_ == null) {
          ensureBreakRequestsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, breakRequests_);
          onChanged();
        } else {
          breakRequestsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public Builder clearBreakRequests() {
        if (breakRequestsBuilder_ == null) {
          breakRequests_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          breakRequestsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public Builder removeBreakRequests(int index) {
        if (breakRequestsBuilder_ == null) {
          ensureBreakRequestsIsMutable();
          breakRequests_.remove(index);
          onChanged();
        } else {
          breakRequestsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder
          getBreakRequestsBuilder(int index) {
        return getBreakRequestsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequestOrBuilder
          getBreakRequestsOrBuilder(int index) {
        if (breakRequestsBuilder_ == null) {
          return breakRequests_.get(index);
        } else {
          return breakRequestsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequestOrBuilder>
          getBreakRequestsOrBuilderList() {
        if (breakRequestsBuilder_ != null) {
          return breakRequestsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(breakRequests_);
        }
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder
          addBreakRequestsBuilder() {
        return getBreakRequestsFieldBuilder()
            .addBuilder(
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder
          addBreakRequestsBuilder(int index) {
        return getBreakRequestsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Sequence of breaks. See the `BreakRequest` message.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest break_requests = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder>
          getBreakRequestsBuilderList() {
        return getBreakRequestsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest,
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder,
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequestOrBuilder>
          getBreakRequestsFieldBuilder() {
        if (breakRequestsBuilder_ == null) {
          breakRequestsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest,
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.Builder,
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequestOrBuilder>(
                  breakRequests_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          breakRequests_ = null;
        }
        return breakRequestsBuilder_;
      }

      private java.util.List<
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint>
          frequencyConstraints_ = java.util.Collections.emptyList();

      private void ensureFrequencyConstraintsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          frequencyConstraints_ =
              new java.util.ArrayList<
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint>(
                  frequencyConstraints_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint,
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.Builder,
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraintOrBuilder>
          frequencyConstraintsBuilder_;

      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint>
          getFrequencyConstraintsList() {
        if (frequencyConstraintsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(frequencyConstraints_);
        } else {
          return frequencyConstraintsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public int getFrequencyConstraintsCount() {
        if (frequencyConstraintsBuilder_ == null) {
          return frequencyConstraints_.size();
        } else {
          return frequencyConstraintsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
          getFrequencyConstraints(int index) {
        if (frequencyConstraintsBuilder_ == null) {
          return frequencyConstraints_.get(index);
        } else {
          return frequencyConstraintsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public Builder setFrequencyConstraints(
          int index,
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint value) {
        if (frequencyConstraintsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFrequencyConstraintsIsMutable();
          frequencyConstraints_.set(index, value);
          onChanged();
        } else {
          frequencyConstraintsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public Builder setFrequencyConstraints(
          int index,
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.Builder
              builderForValue) {
        if (frequencyConstraintsBuilder_ == null) {
          ensureFrequencyConstraintsIsMutable();
          frequencyConstraints_.set(index, builderForValue.build());
          onChanged();
        } else {
          frequencyConstraintsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public Builder addFrequencyConstraints(
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint value) {
        if (frequencyConstraintsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFrequencyConstraintsIsMutable();
          frequencyConstraints_.add(value);
          onChanged();
        } else {
          frequencyConstraintsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public Builder addFrequencyConstraints(
          int index,
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint value) {
        if (frequencyConstraintsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFrequencyConstraintsIsMutable();
          frequencyConstraints_.add(index, value);
          onChanged();
        } else {
          frequencyConstraintsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public Builder addFrequencyConstraints(
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.Builder
              builderForValue) {
        if (frequencyConstraintsBuilder_ == null) {
          ensureFrequencyConstraintsIsMutable();
          frequencyConstraints_.add(builderForValue.build());
          onChanged();
        } else {
          frequencyConstraintsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public Builder addFrequencyConstraints(
          int index,
          com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.Builder
              builderForValue) {
        if (frequencyConstraintsBuilder_ == null) {
          ensureFrequencyConstraintsIsMutable();
          frequencyConstraints_.add(index, builderForValue.build());
          onChanged();
        } else {
          frequencyConstraintsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public Builder addAllFrequencyConstraints(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint>
              values) {
        if (frequencyConstraintsBuilder_ == null) {
          ensureFrequencyConstraintsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frequencyConstraints_);
          onChanged();
        } else {
          frequencyConstraintsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public Builder clearFrequencyConstraints() {
        if (frequencyConstraintsBuilder_ == null) {
          frequencyConstraints_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          frequencyConstraintsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public Builder removeFrequencyConstraints(int index) {
        if (frequencyConstraintsBuilder_ == null) {
          ensureFrequencyConstraintsIsMutable();
          frequencyConstraints_.remove(index);
          onChanged();
        } else {
          frequencyConstraintsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.Builder
          getFrequencyConstraintsBuilder(int index) {
        return getFrequencyConstraintsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraintOrBuilder
          getFrequencyConstraintsOrBuilder(int index) {
        if (frequencyConstraintsBuilder_ == null) {
          return frequencyConstraints_.get(index);
        } else {
          return frequencyConstraintsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule
                      .FrequencyConstraintOrBuilder>
          getFrequencyConstraintsOrBuilderList() {
        if (frequencyConstraintsBuilder_ != null) {
          return frequencyConstraintsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(frequencyConstraints_);
        }
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.Builder
          addFrequencyConstraintsBuilder() {
        return getFrequencyConstraintsFieldBuilder()
            .addBuilder(
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.Builder
          addFrequencyConstraintsBuilder(int index) {
        return getFrequencyConstraintsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Several `FrequencyConstraint` may apply. They must all be satisfied by
       * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint frequency_constraints = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.Builder>
          getFrequencyConstraintsBuilderList() {
        return getFrequencyConstraintsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint,
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.Builder,
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraintOrBuilder>
          getFrequencyConstraintsFieldBuilder() {
        if (frequencyConstraintsBuilder_ == null) {
          frequencyConstraintsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint,
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
                      .Builder,
                  com.google.cloud.optimization.v1.ShipmentModel.BreakRule
                      .FrequencyConstraintOrBuilder>(
                  frequencyConstraints_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          frequencyConstraints_ = null;
        }
        return frequencyConstraintsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentModel.BreakRule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentModel.BreakRule)
    private static final com.google.cloud.optimization.v1.ShipmentModel.BreakRule DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentModel.BreakRule();
    }

    public static com.google.cloud.optimization.v1.ShipmentModel.BreakRule getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BreakRule> PARSER =
        new com.google.protobuf.AbstractParser<BreakRule>() {
          @java.lang.Override
          public BreakRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BreakRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BreakRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel.BreakRule getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int SHIPMENTS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.optimization.v1.Shipment> shipments_;
  /**
   *
   *
   * <pre>
   * Set of shipments which must be performed in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.Shipment> getShipmentsList() {
    return shipments_;
  }
  /**
   *
   *
   * <pre>
   * Set of shipments which must be performed in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentOrBuilder>
      getShipmentsOrBuilderList() {
    return shipments_;
  }
  /**
   *
   *
   * <pre>
   * Set of shipments which must be performed in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
   */
  @java.lang.Override
  public int getShipmentsCount() {
    return shipments_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of shipments which must be performed in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Shipment getShipments(int index) {
    return shipments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of shipments which must be performed in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentOrBuilder getShipmentsOrBuilder(int index) {
    return shipments_.get(index);
  }

  public static final int VEHICLES_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.optimization.v1.Vehicle> vehicles_;
  /**
   *
   *
   * <pre>
   * Set of vehicles which can be used to perform visits.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.Vehicle> getVehiclesList() {
    return vehicles_;
  }
  /**
   *
   *
   * <pre>
   * Set of vehicles which can be used to perform visits.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.VehicleOrBuilder>
      getVehiclesOrBuilderList() {
    return vehicles_;
  }
  /**
   *
   *
   * <pre>
   * Set of vehicles which can be used to perform visits.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
   */
  @java.lang.Override
  public int getVehiclesCount() {
    return vehicles_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of vehicles which can be used to perform visits.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Vehicle getVehicles(int index) {
    return vehicles_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of vehicles which can be used to perform visits.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.VehicleOrBuilder getVehiclesOrBuilder(int index) {
    return vehicles_.get(index);
  }

  public static final int MAX_ACTIVE_VEHICLES_FIELD_NUMBER = 4;
  private int maxActiveVehicles_;
  /**
   *
   *
   * <pre>
   * Constrains the maximum number of active vehicles. A vehicle is active if
   * its route performs at least one shipment. This can be used to limit the
   * number of routes in the case where there are fewer drivers than
   * vehicles and that the fleet of vehicles is heterogeneous. The optimization
   * will then select the best subset of vehicles to use.
   * Must be strictly positive.
   * </pre>
   *
   * <code>optional int32 max_active_vehicles = 4;</code>
   *
   * @return Whether the maxActiveVehicles field is set.
   */
  @java.lang.Override
  public boolean hasMaxActiveVehicles() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Constrains the maximum number of active vehicles. A vehicle is active if
   * its route performs at least one shipment. This can be used to limit the
   * number of routes in the case where there are fewer drivers than
   * vehicles and that the fleet of vehicles is heterogeneous. The optimization
   * will then select the best subset of vehicles to use.
   * Must be strictly positive.
   * </pre>
   *
   * <code>optional int32 max_active_vehicles = 4;</code>
   *
   * @return The maxActiveVehicles.
   */
  @java.lang.Override
  public int getMaxActiveVehicles() {
    return maxActiveVehicles_;
  }

  public static final int GLOBAL_START_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp globalStartTime_;
  /**
   *
   *
   * <pre>
   * Global start and end time of the model: no times outside of this range
   * can be considered valid.
   * The model's time span must be less than a year, i.e. the `global_end_time`
   * and the `global_start_time` must be within 31536000 seconds of each other.
   * When using `cost_per_*hour` fields, you might want to set this window to a
   * smaller interval to increase performance (eg. if you model a single day,
   * you should set the global time limits to that day).
   * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
   * as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
   *
   * @return Whether the globalStartTime field is set.
   */
  @java.lang.Override
  public boolean hasGlobalStartTime() {
    return globalStartTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Global start and end time of the model: no times outside of this range
   * can be considered valid.
   * The model's time span must be less than a year, i.e. the `global_end_time`
   * and the `global_start_time` must be within 31536000 seconds of each other.
   * When using `cost_per_*hour` fields, you might want to set this window to a
   * smaller interval to increase performance (eg. if you model a single day,
   * you should set the global time limits to that day).
   * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
   * as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
   *
   * @return The globalStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getGlobalStartTime() {
    return globalStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : globalStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Global start and end time of the model: no times outside of this range
   * can be considered valid.
   * The model's time span must be less than a year, i.e. the `global_end_time`
   * and the `global_start_time` must be within 31536000 seconds of each other.
   * When using `cost_per_*hour` fields, you might want to set this window to a
   * smaller interval to increase performance (eg. if you model a single day,
   * you should set the global time limits to that day).
   * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
   * as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getGlobalStartTimeOrBuilder() {
    return getGlobalStartTime();
  }

  public static final int GLOBAL_END_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp globalEndTime_;
  /**
   *
   *
   * <pre>
   * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
   * is used as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
   *
   * @return Whether the globalEndTime field is set.
   */
  @java.lang.Override
  public boolean hasGlobalEndTime() {
    return globalEndTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
   * is used as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
   *
   * @return The globalEndTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getGlobalEndTime() {
    return globalEndTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : globalEndTime_;
  }
  /**
   *
   *
   * <pre>
   * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
   * is used as default.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getGlobalEndTimeOrBuilder() {
    return getGlobalEndTime();
  }

  public static final int GLOBAL_DURATION_COST_PER_HOUR_FIELD_NUMBER = 7;
  private double globalDurationCostPerHour_;
  /**
   *
   *
   * <pre>
   * The "global duration" of the overall plan is the difference between the
   * earliest effective start time and the latest effective end time of
   * all vehicles. Users can assign a cost per hour to that quantity to try
   * and optimize for earliest job completion, for example. This cost must be in
   * the same unit as [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
   * </pre>
   *
   * <code>double global_duration_cost_per_hour = 7;</code>
   *
   * @return The globalDurationCostPerHour.
   */
  @java.lang.Override
  public double getGlobalDurationCostPerHour() {
    return globalDurationCostPerHour_;
  }

  public static final int DURATION_DISTANCE_MATRICES_FIELD_NUMBER = 8;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix>
      durationDistanceMatrices_;
  /**
   *
   *
   * <pre>
   * Specifies duration and distance matrices used in the model. If this field
   * is empty, Google Maps or geodesic distances will be used instead, depending
   * on the value of the `use_geodesic_distances` field. If it is not empty,
   * `use_geodesic_distances` cannot be true and neither
   * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
   * can be empty.
   * Usage examples:
   * * There are two locations: locA and locB.
   * * 1 vehicle starting its route at locA and ending it at locA.
   * * 1 pickup visit request at locB.
   * ```
   * model {
   *   vehicles { start_tags: "locA"  end_tags: "locA" }
   *   shipments { pickups { tags: "locB" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locA"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrices {
   *     rows {  # from: locA
   *       durations { seconds: 0 }   meters: 0    # to: locA
   *       durations { seconds: 100 } meters: 1000 # to: locB
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 102 } meters: 990 # to: locA
   *       durations { seconds: 0 }   meters: 0   # to: locB
   *     }
   *   }
   * }
   * ```
   * * There are three locations: locA, locB and locC.
   * * 1 vehicle starting its route at locA and ending it at locB, using
   *   matrix "fast".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "slow".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "fast".
   * * 1 pickup visit request at locC.
   * ```
   * model {
   *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
   *   shipments { pickups { tags: "locC" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_src_tags: "locC"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locC"
   *   duration_distance_matrices {
   *     vehicle_start_tag: "fast"
   *     rows {  # from: locA
   *       durations { seconds: 1000 } meters: 2000 # to: locB
   *       durations { seconds: 600 }  meters: 1000 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }   meters: 0    # to: locB
   *       durations { seconds: 700 } meters: 1200 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 702 } meters: 1190 # to: locB
   *       durations { seconds: 0 }   meters: 0    # to: locC
   *     }
   *   }
   *   duration_distance_matrices {
   *     vehicle_start_tag: "slow"
   *     rows {  # from: locA
   *       durations { seconds: 1800 } meters: 2001 # to: locB
   *       durations { seconds: 900 }  meters: 1002 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }    meters: 0    # to: locB
   *       durations { seconds: 1000 } meters: 1202 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 1001 } meters: 1195 # to: locB
   *       durations { seconds: 0 }    meters: 0    # to: locC
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix>
      getDurationDistanceMatricesList() {
    return durationDistanceMatrices_;
  }
  /**
   *
   *
   * <pre>
   * Specifies duration and distance matrices used in the model. If this field
   * is empty, Google Maps or geodesic distances will be used instead, depending
   * on the value of the `use_geodesic_distances` field. If it is not empty,
   * `use_geodesic_distances` cannot be true and neither
   * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
   * can be empty.
   * Usage examples:
   * * There are two locations: locA and locB.
   * * 1 vehicle starting its route at locA and ending it at locA.
   * * 1 pickup visit request at locB.
   * ```
   * model {
   *   vehicles { start_tags: "locA"  end_tags: "locA" }
   *   shipments { pickups { tags: "locB" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locA"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrices {
   *     rows {  # from: locA
   *       durations { seconds: 0 }   meters: 0    # to: locA
   *       durations { seconds: 100 } meters: 1000 # to: locB
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 102 } meters: 990 # to: locA
   *       durations { seconds: 0 }   meters: 0   # to: locB
   *     }
   *   }
   * }
   * ```
   * * There are three locations: locA, locB and locC.
   * * 1 vehicle starting its route at locA and ending it at locB, using
   *   matrix "fast".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "slow".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "fast".
   * * 1 pickup visit request at locC.
   * ```
   * model {
   *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
   *   shipments { pickups { tags: "locC" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_src_tags: "locC"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locC"
   *   duration_distance_matrices {
   *     vehicle_start_tag: "fast"
   *     rows {  # from: locA
   *       durations { seconds: 1000 } meters: 2000 # to: locB
   *       durations { seconds: 600 }  meters: 1000 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }   meters: 0    # to: locB
   *       durations { seconds: 700 } meters: 1200 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 702 } meters: 1190 # to: locB
   *       durations { seconds: 0 }   meters: 0    # to: locC
   *     }
   *   }
   *   duration_distance_matrices {
   *     vehicle_start_tag: "slow"
   *     rows {  # from: locA
   *       durations { seconds: 1800 } meters: 2001 # to: locB
   *       durations { seconds: 900 }  meters: 1002 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }    meters: 0    # to: locB
   *       durations { seconds: 1000 } meters: 1202 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 1001 } meters: 1195 # to: locB
   *       durations { seconds: 0 }    meters: 0    # to: locC
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrixOrBuilder>
      getDurationDistanceMatricesOrBuilderList() {
    return durationDistanceMatrices_;
  }
  /**
   *
   *
   * <pre>
   * Specifies duration and distance matrices used in the model. If this field
   * is empty, Google Maps or geodesic distances will be used instead, depending
   * on the value of the `use_geodesic_distances` field. If it is not empty,
   * `use_geodesic_distances` cannot be true and neither
   * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
   * can be empty.
   * Usage examples:
   * * There are two locations: locA and locB.
   * * 1 vehicle starting its route at locA and ending it at locA.
   * * 1 pickup visit request at locB.
   * ```
   * model {
   *   vehicles { start_tags: "locA"  end_tags: "locA" }
   *   shipments { pickups { tags: "locB" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locA"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrices {
   *     rows {  # from: locA
   *       durations { seconds: 0 }   meters: 0    # to: locA
   *       durations { seconds: 100 } meters: 1000 # to: locB
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 102 } meters: 990 # to: locA
   *       durations { seconds: 0 }   meters: 0   # to: locB
   *     }
   *   }
   * }
   * ```
   * * There are three locations: locA, locB and locC.
   * * 1 vehicle starting its route at locA and ending it at locB, using
   *   matrix "fast".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "slow".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "fast".
   * * 1 pickup visit request at locC.
   * ```
   * model {
   *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
   *   shipments { pickups { tags: "locC" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_src_tags: "locC"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locC"
   *   duration_distance_matrices {
   *     vehicle_start_tag: "fast"
   *     rows {  # from: locA
   *       durations { seconds: 1000 } meters: 2000 # to: locB
   *       durations { seconds: 600 }  meters: 1000 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }   meters: 0    # to: locB
   *       durations { seconds: 700 } meters: 1200 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 702 } meters: 1190 # to: locB
   *       durations { seconds: 0 }   meters: 0    # to: locC
   *     }
   *   }
   *   duration_distance_matrices {
   *     vehicle_start_tag: "slow"
   *     rows {  # from: locA
   *       durations { seconds: 1800 } meters: 2001 # to: locB
   *       durations { seconds: 900 }  meters: 1002 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }    meters: 0    # to: locB
   *       durations { seconds: 1000 } meters: 1202 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 1001 } meters: 1195 # to: locB
   *       durations { seconds: 0 }    meters: 0    # to: locC
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
   * </code>
   */
  @java.lang.Override
  public int getDurationDistanceMatricesCount() {
    return durationDistanceMatrices_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies duration and distance matrices used in the model. If this field
   * is empty, Google Maps or geodesic distances will be used instead, depending
   * on the value of the `use_geodesic_distances` field. If it is not empty,
   * `use_geodesic_distances` cannot be true and neither
   * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
   * can be empty.
   * Usage examples:
   * * There are two locations: locA and locB.
   * * 1 vehicle starting its route at locA and ending it at locA.
   * * 1 pickup visit request at locB.
   * ```
   * model {
   *   vehicles { start_tags: "locA"  end_tags: "locA" }
   *   shipments { pickups { tags: "locB" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locA"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrices {
   *     rows {  # from: locA
   *       durations { seconds: 0 }   meters: 0    # to: locA
   *       durations { seconds: 100 } meters: 1000 # to: locB
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 102 } meters: 990 # to: locA
   *       durations { seconds: 0 }   meters: 0   # to: locB
   *     }
   *   }
   * }
   * ```
   * * There are three locations: locA, locB and locC.
   * * 1 vehicle starting its route at locA and ending it at locB, using
   *   matrix "fast".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "slow".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "fast".
   * * 1 pickup visit request at locC.
   * ```
   * model {
   *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
   *   shipments { pickups { tags: "locC" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_src_tags: "locC"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locC"
   *   duration_distance_matrices {
   *     vehicle_start_tag: "fast"
   *     rows {  # from: locA
   *       durations { seconds: 1000 } meters: 2000 # to: locB
   *       durations { seconds: 600 }  meters: 1000 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }   meters: 0    # to: locB
   *       durations { seconds: 700 } meters: 1200 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 702 } meters: 1190 # to: locB
   *       durations { seconds: 0 }   meters: 0    # to: locC
   *     }
   *   }
   *   duration_distance_matrices {
   *     vehicle_start_tag: "slow"
   *     rows {  # from: locA
   *       durations { seconds: 1800 } meters: 2001 # to: locB
   *       durations { seconds: 900 }  meters: 1002 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }    meters: 0    # to: locB
   *       durations { seconds: 1000 } meters: 1202 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 1001 } meters: 1195 # to: locB
   *       durations { seconds: 0 }    meters: 0    # to: locC
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
      getDurationDistanceMatrices(int index) {
    return durationDistanceMatrices_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies duration and distance matrices used in the model. If this field
   * is empty, Google Maps or geodesic distances will be used instead, depending
   * on the value of the `use_geodesic_distances` field. If it is not empty,
   * `use_geodesic_distances` cannot be true and neither
   * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
   * can be empty.
   * Usage examples:
   * * There are two locations: locA and locB.
   * * 1 vehicle starting its route at locA and ending it at locA.
   * * 1 pickup visit request at locB.
   * ```
   * model {
   *   vehicles { start_tags: "locA"  end_tags: "locA" }
   *   shipments { pickups { tags: "locB" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locA"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrices {
   *     rows {  # from: locA
   *       durations { seconds: 0 }   meters: 0    # to: locA
   *       durations { seconds: 100 } meters: 1000 # to: locB
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 102 } meters: 990 # to: locA
   *       durations { seconds: 0 }   meters: 0   # to: locB
   *     }
   *   }
   * }
   * ```
   * * There are three locations: locA, locB and locC.
   * * 1 vehicle starting its route at locA and ending it at locB, using
   *   matrix "fast".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "slow".
   * * 1 vehicle starting its route at locB and ending it at locB, using
   *   matrix "fast".
   * * 1 pickup visit request at locC.
   * ```
   * model {
   *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
   *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
   *   shipments { pickups { tags: "locC" } }
   *   duration_distance_matrix_src_tags: "locA"
   *   duration_distance_matrix_src_tags: "locB"
   *   duration_distance_matrix_src_tags: "locC"
   *   duration_distance_matrix_dst_tags: "locB"
   *   duration_distance_matrix_dst_tags: "locC"
   *   duration_distance_matrices {
   *     vehicle_start_tag: "fast"
   *     rows {  # from: locA
   *       durations { seconds: 1000 } meters: 2000 # to: locB
   *       durations { seconds: 600 }  meters: 1000 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }   meters: 0    # to: locB
   *       durations { seconds: 700 } meters: 1200 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 702 } meters: 1190 # to: locB
   *       durations { seconds: 0 }   meters: 0    # to: locC
   *     }
   *   }
   *   duration_distance_matrices {
   *     vehicle_start_tag: "slow"
   *     rows {  # from: locA
   *       durations { seconds: 1800 } meters: 2001 # to: locB
   *       durations { seconds: 900 }  meters: 1002 # to: locC
   *     }
   *     rows {  # from: locB
   *       durations { seconds: 0 }    meters: 0    # to: locB
   *       durations { seconds: 1000 } meters: 1202 # to: locC
   *     }
   *     rows {  # from: locC
   *       durations { seconds: 1001 } meters: 1195 # to: locB
   *       durations { seconds: 0 }    meters: 0    # to: locC
   *     }
   *   }
   * }
   * ```
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrixOrBuilder
      getDurationDistanceMatricesOrBuilder(int index) {
    return durationDistanceMatrices_.get(index);
  }

  public static final int DURATION_DISTANCE_MATRIX_SRC_TAGS_FIELD_NUMBER = 9;
  private com.google.protobuf.LazyStringList durationDistanceMatrixSrcTags_;
  /**
   *
   *
   * <pre>
   * Tags defining the sources of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j)` defines durations and distances
   * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
   * in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
   *
   * @return A list containing the durationDistanceMatrixSrcTags.
   */
  public com.google.protobuf.ProtocolStringList getDurationDistanceMatrixSrcTagsList() {
    return durationDistanceMatrixSrcTags_;
  }
  /**
   *
   *
   * <pre>
   * Tags defining the sources of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j)` defines durations and distances
   * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
   * in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
   *
   * @return The count of durationDistanceMatrixSrcTags.
   */
  public int getDurationDistanceMatrixSrcTagsCount() {
    return durationDistanceMatrixSrcTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Tags defining the sources of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j)` defines durations and distances
   * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
   * in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The durationDistanceMatrixSrcTags at the given index.
   */
  public java.lang.String getDurationDistanceMatrixSrcTags(int index) {
    return durationDistanceMatrixSrcTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Tags defining the sources of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j)` defines durations and distances
   * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
   * in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the durationDistanceMatrixSrcTags at the given index.
   */
  public com.google.protobuf.ByteString getDurationDistanceMatrixSrcTagsBytes(int index) {
    return durationDistanceMatrixSrcTags_.getByteString(index);
  }

  public static final int DURATION_DISTANCE_MATRIX_DST_TAGS_FIELD_NUMBER = 10;
  private com.google.protobuf.LazyStringList durationDistanceMatrixDstTags_;
  /**
   *
   *
   * <pre>
   * Tags defining the destinations of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
   * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
   * (resp. the distance) of the travel from visits with tag
   * `duration_distance_matrix_src_tags(j)` to visits with tag
   * `duration_distance_matrix_dst_tags(k)` in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
   *
   * @return A list containing the durationDistanceMatrixDstTags.
   */
  public com.google.protobuf.ProtocolStringList getDurationDistanceMatrixDstTagsList() {
    return durationDistanceMatrixDstTags_;
  }
  /**
   *
   *
   * <pre>
   * Tags defining the destinations of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
   * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
   * (resp. the distance) of the travel from visits with tag
   * `duration_distance_matrix_src_tags(j)` to visits with tag
   * `duration_distance_matrix_dst_tags(k)` in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
   *
   * @return The count of durationDistanceMatrixDstTags.
   */
  public int getDurationDistanceMatrixDstTagsCount() {
    return durationDistanceMatrixDstTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Tags defining the destinations of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
   * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
   * (resp. the distance) of the travel from visits with tag
   * `duration_distance_matrix_src_tags(j)` to visits with tag
   * `duration_distance_matrix_dst_tags(k)` in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The durationDistanceMatrixDstTags at the given index.
   */
  public java.lang.String getDurationDistanceMatrixDstTags(int index) {
    return durationDistanceMatrixDstTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Tags defining the destinations of the duration and distance matrices;
   * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
   * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
   * (resp. the distance) of the travel from visits with tag
   * `duration_distance_matrix_src_tags(j)` to visits with tag
   * `duration_distance_matrix_dst_tags(k)` in matrix i.
   * Tags correspond to
   * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
   * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
   * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
   * field. Note that a `Vehicle`'s source, destination and matrix tags may be
   * the same; similarly a `VisitRequest`'s source and destination tags may be
   * the same. All tags must be different and cannot be empty strings. If this
   * field is not empty, then `duration_distance_matrices` must not be empty.
   * </pre>
   *
   * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the durationDistanceMatrixDstTags at the given index.
   */
  public com.google.protobuf.ByteString getDurationDistanceMatrixDstTagsBytes(int index) {
    return durationDistanceMatrixDstTags_.getByteString(index);
  }

  public static final int TRANSITION_ATTRIBUTES_FIELD_NUMBER = 11;
  private java.util.List<com.google.cloud.optimization.v1.TransitionAttributes>
      transitionAttributes_;
  /**
   *
   *
   * <pre>
   * Transition attributes added to the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.TransitionAttributes>
      getTransitionAttributesList() {
    return transitionAttributes_;
  }
  /**
   *
   *
   * <pre>
   * Transition attributes added to the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.TransitionAttributesOrBuilder>
      getTransitionAttributesOrBuilderList() {
    return transitionAttributes_;
  }
  /**
   *
   *
   * <pre>
   * Transition attributes added to the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
   * </code>
   */
  @java.lang.Override
  public int getTransitionAttributesCount() {
    return transitionAttributes_.size();
  }
  /**
   *
   *
   * <pre>
   * Transition attributes added to the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.TransitionAttributes getTransitionAttributes(int index) {
    return transitionAttributes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Transition attributes added to the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.TransitionAttributesOrBuilder
      getTransitionAttributesOrBuilder(int index) {
    return transitionAttributes_.get(index);
  }

  public static final int SHIPMENT_TYPE_INCOMPATIBILITIES_FIELD_NUMBER = 12;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentTypeIncompatibility>
      shipmentTypeIncompatibilities_;
  /**
   *
   *
   * <pre>
   * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.ShipmentTypeIncompatibility>
      getShipmentTypeIncompatibilitiesList() {
    return shipmentTypeIncompatibilities_;
  }
  /**
   *
   *
   * <pre>
   * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.optimization.v1.ShipmentTypeIncompatibilityOrBuilder>
      getShipmentTypeIncompatibilitiesOrBuilderList() {
    return shipmentTypeIncompatibilities_;
  }
  /**
   *
   *
   * <pre>
   * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
   * </code>
   */
  @java.lang.Override
  public int getShipmentTypeIncompatibilitiesCount() {
    return shipmentTypeIncompatibilities_.size();
  }
  /**
   *
   *
   * <pre>
   * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentTypeIncompatibility
      getShipmentTypeIncompatibilities(int index) {
    return shipmentTypeIncompatibilities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentTypeIncompatibilityOrBuilder
      getShipmentTypeIncompatibilitiesOrBuilder(int index) {
    return shipmentTypeIncompatibilities_.get(index);
  }

  public static final int SHIPMENT_TYPE_REQUIREMENTS_FIELD_NUMBER = 13;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentTypeRequirement>
      shipmentTypeRequirements_;
  /**
   *
   *
   * <pre>
   * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.ShipmentTypeRequirement>
      getShipmentTypeRequirementsList() {
    return shipmentTypeRequirements_;
  }
  /**
   *
   *
   * <pre>
   * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentTypeRequirementOrBuilder>
      getShipmentTypeRequirementsOrBuilderList() {
    return shipmentTypeRequirements_;
  }
  /**
   *
   *
   * <pre>
   * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
   * </code>
   */
  @java.lang.Override
  public int getShipmentTypeRequirementsCount() {
    return shipmentTypeRequirements_.size();
  }
  /**
   *
   *
   * <pre>
   * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentTypeRequirement getShipmentTypeRequirements(
      int index) {
    return shipmentTypeRequirements_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentTypeRequirementOrBuilder
      getShipmentTypeRequirementsOrBuilder(int index) {
    return shipmentTypeRequirements_.get(index);
  }

  public static final int PRECEDENCE_RULES_FIELD_NUMBER = 14;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule>
      precedenceRules_;
  /**
   *
   *
   * <pre>
   * Set of precedence rules which must be enforced in the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule>
      getPrecedenceRulesList() {
    return precedenceRules_;
  }
  /**
   *
   *
   * <pre>
   * Set of precedence rules which must be enforced in the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRuleOrBuilder>
      getPrecedenceRulesOrBuilderList() {
    return precedenceRules_;
  }
  /**
   *
   *
   * <pre>
   * Set of precedence rules which must be enforced in the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
   * </code>
   */
  @java.lang.Override
  public int getPrecedenceRulesCount() {
    return precedenceRules_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of precedence rules which must be enforced in the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule getPrecedenceRules(
      int index) {
    return precedenceRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of precedence rules which must be enforced in the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRuleOrBuilder
      getPrecedenceRulesOrBuilder(int index) {
    return precedenceRules_.get(index);
  }

  public static final int BREAK_RULES_FIELD_NUMBER = 15;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule> breakRules_;
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Set of break rules used in the model.
   * Each vehicle specifies the `BreakRule` that applies to it via the
   * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule>
      getBreakRulesList() {
    return breakRules_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Set of break rules used in the model.
   * Each vehicle specifies the `BreakRule` that applies to it via the
   * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentModel.BreakRuleOrBuilder>
      getBreakRulesOrBuilderList() {
    return breakRules_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Set of break rules used in the model.
   * Each vehicle specifies the `BreakRule` that applies to it via the
   * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getBreakRulesCount() {
    return breakRules_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Set of break rules used in the model.
   * Each vehicle specifies the `BreakRule` that applies to it via the
   * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.ShipmentModel.BreakRule getBreakRules(int index) {
    return breakRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated: No longer used.
   * Set of break rules used in the model.
   * Each vehicle specifies the `BreakRule` that applies to it via the
   * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.ShipmentModel.BreakRuleOrBuilder getBreakRulesOrBuilder(
      int index) {
    return breakRules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < shipments_.size(); i++) {
      output.writeMessage(1, shipments_.get(i));
    }
    for (int i = 0; i < vehicles_.size(); i++) {
      output.writeMessage(2, vehicles_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(4, maxActiveVehicles_);
    }
    if (globalStartTime_ != null) {
      output.writeMessage(5, getGlobalStartTime());
    }
    if (globalEndTime_ != null) {
      output.writeMessage(6, getGlobalEndTime());
    }
    if (java.lang.Double.doubleToRawLongBits(globalDurationCostPerHour_) != 0) {
      output.writeDouble(7, globalDurationCostPerHour_);
    }
    for (int i = 0; i < durationDistanceMatrices_.size(); i++) {
      output.writeMessage(8, durationDistanceMatrices_.get(i));
    }
    for (int i = 0; i < durationDistanceMatrixSrcTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 9, durationDistanceMatrixSrcTags_.getRaw(i));
    }
    for (int i = 0; i < durationDistanceMatrixDstTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 10, durationDistanceMatrixDstTags_.getRaw(i));
    }
    for (int i = 0; i < transitionAttributes_.size(); i++) {
      output.writeMessage(11, transitionAttributes_.get(i));
    }
    for (int i = 0; i < shipmentTypeIncompatibilities_.size(); i++) {
      output.writeMessage(12, shipmentTypeIncompatibilities_.get(i));
    }
    for (int i = 0; i < shipmentTypeRequirements_.size(); i++) {
      output.writeMessage(13, shipmentTypeRequirements_.get(i));
    }
    for (int i = 0; i < precedenceRules_.size(); i++) {
      output.writeMessage(14, precedenceRules_.get(i));
    }
    for (int i = 0; i < breakRules_.size(); i++) {
      output.writeMessage(15, breakRules_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < shipments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, shipments_.get(i));
    }
    for (int i = 0; i < vehicles_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, vehicles_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxActiveVehicles_);
    }
    if (globalStartTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getGlobalStartTime());
    }
    if (globalEndTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getGlobalEndTime());
    }
    if (java.lang.Double.doubleToRawLongBits(globalDurationCostPerHour_) != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(7, globalDurationCostPerHour_);
    }
    for (int i = 0; i < durationDistanceMatrices_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, durationDistanceMatrices_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < durationDistanceMatrixSrcTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(durationDistanceMatrixSrcTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDurationDistanceMatrixSrcTagsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < durationDistanceMatrixDstTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(durationDistanceMatrixDstTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDurationDistanceMatrixDstTagsList().size();
    }
    for (int i = 0; i < transitionAttributes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, transitionAttributes_.get(i));
    }
    for (int i = 0; i < shipmentTypeIncompatibilities_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, shipmentTypeIncompatibilities_.get(i));
    }
    for (int i = 0; i < shipmentTypeRequirements_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, shipmentTypeRequirements_.get(i));
    }
    for (int i = 0; i < precedenceRules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, precedenceRules_.get(i));
    }
    for (int i = 0; i < breakRules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, breakRules_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.ShipmentModel)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.ShipmentModel other =
        (com.google.cloud.optimization.v1.ShipmentModel) obj;

    if (!getShipmentsList().equals(other.getShipmentsList())) return false;
    if (!getVehiclesList().equals(other.getVehiclesList())) return false;
    if (hasMaxActiveVehicles() != other.hasMaxActiveVehicles()) return false;
    if (hasMaxActiveVehicles()) {
      if (getMaxActiveVehicles() != other.getMaxActiveVehicles()) return false;
    }
    if (hasGlobalStartTime() != other.hasGlobalStartTime()) return false;
    if (hasGlobalStartTime()) {
      if (!getGlobalStartTime().equals(other.getGlobalStartTime())) return false;
    }
    if (hasGlobalEndTime() != other.hasGlobalEndTime()) return false;
    if (hasGlobalEndTime()) {
      if (!getGlobalEndTime().equals(other.getGlobalEndTime())) return false;
    }
    if (java.lang.Double.doubleToLongBits(getGlobalDurationCostPerHour())
        != java.lang.Double.doubleToLongBits(other.getGlobalDurationCostPerHour())) return false;
    if (!getDurationDistanceMatricesList().equals(other.getDurationDistanceMatricesList()))
      return false;
    if (!getDurationDistanceMatrixSrcTagsList()
        .equals(other.getDurationDistanceMatrixSrcTagsList())) return false;
    if (!getDurationDistanceMatrixDstTagsList()
        .equals(other.getDurationDistanceMatrixDstTagsList())) return false;
    if (!getTransitionAttributesList().equals(other.getTransitionAttributesList())) return false;
    if (!getShipmentTypeIncompatibilitiesList()
        .equals(other.getShipmentTypeIncompatibilitiesList())) return false;
    if (!getShipmentTypeRequirementsList().equals(other.getShipmentTypeRequirementsList()))
      return false;
    if (!getPrecedenceRulesList().equals(other.getPrecedenceRulesList())) return false;
    if (!getBreakRulesList().equals(other.getBreakRulesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getShipmentsCount() > 0) {
      hash = (37 * hash) + SHIPMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getShipmentsList().hashCode();
    }
    if (getVehiclesCount() > 0) {
      hash = (37 * hash) + VEHICLES_FIELD_NUMBER;
      hash = (53 * hash) + getVehiclesList().hashCode();
    }
    if (hasMaxActiveVehicles()) {
      hash = (37 * hash) + MAX_ACTIVE_VEHICLES_FIELD_NUMBER;
      hash = (53 * hash) + getMaxActiveVehicles();
    }
    if (hasGlobalStartTime()) {
      hash = (37 * hash) + GLOBAL_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getGlobalStartTime().hashCode();
    }
    if (hasGlobalEndTime()) {
      hash = (37 * hash) + GLOBAL_END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getGlobalEndTime().hashCode();
    }
    hash = (37 * hash) + GLOBAL_DURATION_COST_PER_HOUR_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getGlobalDurationCostPerHour()));
    if (getDurationDistanceMatricesCount() > 0) {
      hash = (37 * hash) + DURATION_DISTANCE_MATRICES_FIELD_NUMBER;
      hash = (53 * hash) + getDurationDistanceMatricesList().hashCode();
    }
    if (getDurationDistanceMatrixSrcTagsCount() > 0) {
      hash = (37 * hash) + DURATION_DISTANCE_MATRIX_SRC_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getDurationDistanceMatrixSrcTagsList().hashCode();
    }
    if (getDurationDistanceMatrixDstTagsCount() > 0) {
      hash = (37 * hash) + DURATION_DISTANCE_MATRIX_DST_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getDurationDistanceMatrixDstTagsList().hashCode();
    }
    if (getTransitionAttributesCount() > 0) {
      hash = (37 * hash) + TRANSITION_ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + getTransitionAttributesList().hashCode();
    }
    if (getShipmentTypeIncompatibilitiesCount() > 0) {
      hash = (37 * hash) + SHIPMENT_TYPE_INCOMPATIBILITIES_FIELD_NUMBER;
      hash = (53 * hash) + getShipmentTypeIncompatibilitiesList().hashCode();
    }
    if (getShipmentTypeRequirementsCount() > 0) {
      hash = (37 * hash) + SHIPMENT_TYPE_REQUIREMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getShipmentTypeRequirementsList().hashCode();
    }
    if (getPrecedenceRulesCount() > 0) {
      hash = (37 * hash) + PRECEDENCE_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getPrecedenceRulesList().hashCode();
    }
    if (getBreakRulesCount() > 0) {
      hash = (37 * hash) + BREAK_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getBreakRulesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.ShipmentModel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.optimization.v1.ShipmentModel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A shipment model contains a set of shipments which must be performed by a
   * set of vehicles, while minimizing the overall cost, which is the sum of:
   * * the cost of routing the vehicles (sum of cost per total time, cost per
   *   travel time, and fixed cost over all vehicles).
   * * the unperformed shipment penalties.
   * * the cost of the global duration of the shipments
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.ShipmentModel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.ShipmentModel)
      com.google.cloud.optimization.v1.ShipmentModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentModel_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentModel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.ShipmentModel.class,
              com.google.cloud.optimization.v1.ShipmentModel.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.ShipmentModel.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (shipmentsBuilder_ == null) {
        shipments_ = java.util.Collections.emptyList();
      } else {
        shipments_ = null;
        shipmentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (vehiclesBuilder_ == null) {
        vehicles_ = java.util.Collections.emptyList();
      } else {
        vehicles_ = null;
        vehiclesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      maxActiveVehicles_ = 0;
      bitField0_ = (bitField0_ & ~0x00000004);
      if (globalStartTimeBuilder_ == null) {
        globalStartTime_ = null;
      } else {
        globalStartTime_ = null;
        globalStartTimeBuilder_ = null;
      }
      if (globalEndTimeBuilder_ == null) {
        globalEndTime_ = null;
      } else {
        globalEndTime_ = null;
        globalEndTimeBuilder_ = null;
      }
      globalDurationCostPerHour_ = 0D;

      if (durationDistanceMatricesBuilder_ == null) {
        durationDistanceMatrices_ = java.util.Collections.emptyList();
      } else {
        durationDistanceMatrices_ = null;
        durationDistanceMatricesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      durationDistanceMatrixSrcTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000010);
      durationDistanceMatrixDstTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000020);
      if (transitionAttributesBuilder_ == null) {
        transitionAttributes_ = java.util.Collections.emptyList();
      } else {
        transitionAttributes_ = null;
        transitionAttributesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        shipmentTypeIncompatibilities_ = java.util.Collections.emptyList();
      } else {
        shipmentTypeIncompatibilities_ = null;
        shipmentTypeIncompatibilitiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      if (shipmentTypeRequirementsBuilder_ == null) {
        shipmentTypeRequirements_ = java.util.Collections.emptyList();
      } else {
        shipmentTypeRequirements_ = null;
        shipmentTypeRequirementsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      if (precedenceRulesBuilder_ == null) {
        precedenceRules_ = java.util.Collections.emptyList();
      } else {
        precedenceRules_ = null;
        precedenceRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      if (breakRulesBuilder_ == null) {
        breakRules_ = java.util.Collections.emptyList();
      } else {
        breakRules_ = null;
        breakRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_ShipmentModel_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.ShipmentModel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel build() {
      com.google.cloud.optimization.v1.ShipmentModel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentModel buildPartial() {
      com.google.cloud.optimization.v1.ShipmentModel result =
          new com.google.cloud.optimization.v1.ShipmentModel(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (shipmentsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          shipments_ = java.util.Collections.unmodifiableList(shipments_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.shipments_ = shipments_;
      } else {
        result.shipments_ = shipmentsBuilder_.build();
      }
      if (vehiclesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          vehicles_ = java.util.Collections.unmodifiableList(vehicles_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.vehicles_ = vehicles_;
      } else {
        result.vehicles_ = vehiclesBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxActiveVehicles_ = maxActiveVehicles_;
        to_bitField0_ |= 0x00000001;
      }
      if (globalStartTimeBuilder_ == null) {
        result.globalStartTime_ = globalStartTime_;
      } else {
        result.globalStartTime_ = globalStartTimeBuilder_.build();
      }
      if (globalEndTimeBuilder_ == null) {
        result.globalEndTime_ = globalEndTime_;
      } else {
        result.globalEndTime_ = globalEndTimeBuilder_.build();
      }
      result.globalDurationCostPerHour_ = globalDurationCostPerHour_;
      if (durationDistanceMatricesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          durationDistanceMatrices_ =
              java.util.Collections.unmodifiableList(durationDistanceMatrices_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.durationDistanceMatrices_ = durationDistanceMatrices_;
      } else {
        result.durationDistanceMatrices_ = durationDistanceMatricesBuilder_.build();
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        durationDistanceMatrixSrcTags_ = durationDistanceMatrixSrcTags_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.durationDistanceMatrixSrcTags_ = durationDistanceMatrixSrcTags_;
      if (((bitField0_ & 0x00000020) != 0)) {
        durationDistanceMatrixDstTags_ = durationDistanceMatrixDstTags_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.durationDistanceMatrixDstTags_ = durationDistanceMatrixDstTags_;
      if (transitionAttributesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          transitionAttributes_ = java.util.Collections.unmodifiableList(transitionAttributes_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.transitionAttributes_ = transitionAttributes_;
      } else {
        result.transitionAttributes_ = transitionAttributesBuilder_.build();
      }
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          shipmentTypeIncompatibilities_ =
              java.util.Collections.unmodifiableList(shipmentTypeIncompatibilities_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.shipmentTypeIncompatibilities_ = shipmentTypeIncompatibilities_;
      } else {
        result.shipmentTypeIncompatibilities_ = shipmentTypeIncompatibilitiesBuilder_.build();
      }
      if (shipmentTypeRequirementsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          shipmentTypeRequirements_ =
              java.util.Collections.unmodifiableList(shipmentTypeRequirements_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.shipmentTypeRequirements_ = shipmentTypeRequirements_;
      } else {
        result.shipmentTypeRequirements_ = shipmentTypeRequirementsBuilder_.build();
      }
      if (precedenceRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          precedenceRules_ = java.util.Collections.unmodifiableList(precedenceRules_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.precedenceRules_ = precedenceRules_;
      } else {
        result.precedenceRules_ = precedenceRulesBuilder_.build();
      }
      if (breakRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          breakRules_ = java.util.Collections.unmodifiableList(breakRules_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.breakRules_ = breakRules_;
      } else {
        result.breakRules_ = breakRulesBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.ShipmentModel) {
        return mergeFrom((com.google.cloud.optimization.v1.ShipmentModel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.ShipmentModel other) {
      if (other == com.google.cloud.optimization.v1.ShipmentModel.getDefaultInstance()) return this;
      if (shipmentsBuilder_ == null) {
        if (!other.shipments_.isEmpty()) {
          if (shipments_.isEmpty()) {
            shipments_ = other.shipments_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureShipmentsIsMutable();
            shipments_.addAll(other.shipments_);
          }
          onChanged();
        }
      } else {
        if (!other.shipments_.isEmpty()) {
          if (shipmentsBuilder_.isEmpty()) {
            shipmentsBuilder_.dispose();
            shipmentsBuilder_ = null;
            shipments_ = other.shipments_;
            bitField0_ = (bitField0_ & ~0x00000001);
            shipmentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShipmentsFieldBuilder()
                    : null;
          } else {
            shipmentsBuilder_.addAllMessages(other.shipments_);
          }
        }
      }
      if (vehiclesBuilder_ == null) {
        if (!other.vehicles_.isEmpty()) {
          if (vehicles_.isEmpty()) {
            vehicles_ = other.vehicles_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureVehiclesIsMutable();
            vehicles_.addAll(other.vehicles_);
          }
          onChanged();
        }
      } else {
        if (!other.vehicles_.isEmpty()) {
          if (vehiclesBuilder_.isEmpty()) {
            vehiclesBuilder_.dispose();
            vehiclesBuilder_ = null;
            vehicles_ = other.vehicles_;
            bitField0_ = (bitField0_ & ~0x00000002);
            vehiclesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVehiclesFieldBuilder()
                    : null;
          } else {
            vehiclesBuilder_.addAllMessages(other.vehicles_);
          }
        }
      }
      if (other.hasMaxActiveVehicles()) {
        setMaxActiveVehicles(other.getMaxActiveVehicles());
      }
      if (other.hasGlobalStartTime()) {
        mergeGlobalStartTime(other.getGlobalStartTime());
      }
      if (other.hasGlobalEndTime()) {
        mergeGlobalEndTime(other.getGlobalEndTime());
      }
      if (other.getGlobalDurationCostPerHour() != 0D) {
        setGlobalDurationCostPerHour(other.getGlobalDurationCostPerHour());
      }
      if (durationDistanceMatricesBuilder_ == null) {
        if (!other.durationDistanceMatrices_.isEmpty()) {
          if (durationDistanceMatrices_.isEmpty()) {
            durationDistanceMatrices_ = other.durationDistanceMatrices_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureDurationDistanceMatricesIsMutable();
            durationDistanceMatrices_.addAll(other.durationDistanceMatrices_);
          }
          onChanged();
        }
      } else {
        if (!other.durationDistanceMatrices_.isEmpty()) {
          if (durationDistanceMatricesBuilder_.isEmpty()) {
            durationDistanceMatricesBuilder_.dispose();
            durationDistanceMatricesBuilder_ = null;
            durationDistanceMatrices_ = other.durationDistanceMatrices_;
            bitField0_ = (bitField0_ & ~0x00000008);
            durationDistanceMatricesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDurationDistanceMatricesFieldBuilder()
                    : null;
          } else {
            durationDistanceMatricesBuilder_.addAllMessages(other.durationDistanceMatrices_);
          }
        }
      }
      if (!other.durationDistanceMatrixSrcTags_.isEmpty()) {
        if (durationDistanceMatrixSrcTags_.isEmpty()) {
          durationDistanceMatrixSrcTags_ = other.durationDistanceMatrixSrcTags_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureDurationDistanceMatrixSrcTagsIsMutable();
          durationDistanceMatrixSrcTags_.addAll(other.durationDistanceMatrixSrcTags_);
        }
        onChanged();
      }
      if (!other.durationDistanceMatrixDstTags_.isEmpty()) {
        if (durationDistanceMatrixDstTags_.isEmpty()) {
          durationDistanceMatrixDstTags_ = other.durationDistanceMatrixDstTags_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureDurationDistanceMatrixDstTagsIsMutable();
          durationDistanceMatrixDstTags_.addAll(other.durationDistanceMatrixDstTags_);
        }
        onChanged();
      }
      if (transitionAttributesBuilder_ == null) {
        if (!other.transitionAttributes_.isEmpty()) {
          if (transitionAttributes_.isEmpty()) {
            transitionAttributes_ = other.transitionAttributes_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureTransitionAttributesIsMutable();
            transitionAttributes_.addAll(other.transitionAttributes_);
          }
          onChanged();
        }
      } else {
        if (!other.transitionAttributes_.isEmpty()) {
          if (transitionAttributesBuilder_.isEmpty()) {
            transitionAttributesBuilder_.dispose();
            transitionAttributesBuilder_ = null;
            transitionAttributes_ = other.transitionAttributes_;
            bitField0_ = (bitField0_ & ~0x00000040);
            transitionAttributesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTransitionAttributesFieldBuilder()
                    : null;
          } else {
            transitionAttributesBuilder_.addAllMessages(other.transitionAttributes_);
          }
        }
      }
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        if (!other.shipmentTypeIncompatibilities_.isEmpty()) {
          if (shipmentTypeIncompatibilities_.isEmpty()) {
            shipmentTypeIncompatibilities_ = other.shipmentTypeIncompatibilities_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureShipmentTypeIncompatibilitiesIsMutable();
            shipmentTypeIncompatibilities_.addAll(other.shipmentTypeIncompatibilities_);
          }
          onChanged();
        }
      } else {
        if (!other.shipmentTypeIncompatibilities_.isEmpty()) {
          if (shipmentTypeIncompatibilitiesBuilder_.isEmpty()) {
            shipmentTypeIncompatibilitiesBuilder_.dispose();
            shipmentTypeIncompatibilitiesBuilder_ = null;
            shipmentTypeIncompatibilities_ = other.shipmentTypeIncompatibilities_;
            bitField0_ = (bitField0_ & ~0x00000080);
            shipmentTypeIncompatibilitiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShipmentTypeIncompatibilitiesFieldBuilder()
                    : null;
          } else {
            shipmentTypeIncompatibilitiesBuilder_.addAllMessages(
                other.shipmentTypeIncompatibilities_);
          }
        }
      }
      if (shipmentTypeRequirementsBuilder_ == null) {
        if (!other.shipmentTypeRequirements_.isEmpty()) {
          if (shipmentTypeRequirements_.isEmpty()) {
            shipmentTypeRequirements_ = other.shipmentTypeRequirements_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureShipmentTypeRequirementsIsMutable();
            shipmentTypeRequirements_.addAll(other.shipmentTypeRequirements_);
          }
          onChanged();
        }
      } else {
        if (!other.shipmentTypeRequirements_.isEmpty()) {
          if (shipmentTypeRequirementsBuilder_.isEmpty()) {
            shipmentTypeRequirementsBuilder_.dispose();
            shipmentTypeRequirementsBuilder_ = null;
            shipmentTypeRequirements_ = other.shipmentTypeRequirements_;
            bitField0_ = (bitField0_ & ~0x00000100);
            shipmentTypeRequirementsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShipmentTypeRequirementsFieldBuilder()
                    : null;
          } else {
            shipmentTypeRequirementsBuilder_.addAllMessages(other.shipmentTypeRequirements_);
          }
        }
      }
      if (precedenceRulesBuilder_ == null) {
        if (!other.precedenceRules_.isEmpty()) {
          if (precedenceRules_.isEmpty()) {
            precedenceRules_ = other.precedenceRules_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensurePrecedenceRulesIsMutable();
            precedenceRules_.addAll(other.precedenceRules_);
          }
          onChanged();
        }
      } else {
        if (!other.precedenceRules_.isEmpty()) {
          if (precedenceRulesBuilder_.isEmpty()) {
            precedenceRulesBuilder_.dispose();
            precedenceRulesBuilder_ = null;
            precedenceRules_ = other.precedenceRules_;
            bitField0_ = (bitField0_ & ~0x00000200);
            precedenceRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPrecedenceRulesFieldBuilder()
                    : null;
          } else {
            precedenceRulesBuilder_.addAllMessages(other.precedenceRules_);
          }
        }
      }
      if (breakRulesBuilder_ == null) {
        if (!other.breakRules_.isEmpty()) {
          if (breakRules_.isEmpty()) {
            breakRules_ = other.breakRules_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureBreakRulesIsMutable();
            breakRules_.addAll(other.breakRules_);
          }
          onChanged();
        }
      } else {
        if (!other.breakRules_.isEmpty()) {
          if (breakRulesBuilder_.isEmpty()) {
            breakRulesBuilder_.dispose();
            breakRulesBuilder_ = null;
            breakRules_ = other.breakRules_;
            bitField0_ = (bitField0_ & ~0x00000400);
            breakRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBreakRulesFieldBuilder()
                    : null;
          } else {
            breakRulesBuilder_.addAllMessages(other.breakRules_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.optimization.v1.Shipment m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.Shipment.parser(), extensionRegistry);
                if (shipmentsBuilder_ == null) {
                  ensureShipmentsIsMutable();
                  shipments_.add(m);
                } else {
                  shipmentsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.optimization.v1.Vehicle m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.Vehicle.parser(), extensionRegistry);
                if (vehiclesBuilder_ == null) {
                  ensureVehiclesIsMutable();
                  vehicles_.add(m);
                } else {
                  vehiclesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 32:
              {
                maxActiveVehicles_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getGlobalStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getGlobalEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 57:
              {
                globalDurationCostPerHour_ = input.readDouble();

                break;
              } // case 57
            case 66:
              {
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
                            .parser(),
                        extensionRegistry);
                if (durationDistanceMatricesBuilder_ == null) {
                  ensureDurationDistanceMatricesIsMutable();
                  durationDistanceMatrices_.add(m);
                } else {
                  durationDistanceMatricesBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDurationDistanceMatrixSrcTagsIsMutable();
                durationDistanceMatrixSrcTags_.add(s);
                break;
              } // case 74
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDurationDistanceMatrixDstTagsIsMutable();
                durationDistanceMatrixDstTags_.add(s);
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.optimization.v1.TransitionAttributes m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.TransitionAttributes.parser(),
                        extensionRegistry);
                if (transitionAttributesBuilder_ == null) {
                  ensureTransitionAttributesIsMutable();
                  transitionAttributes_.add(m);
                } else {
                  transitionAttributesBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                com.google.cloud.optimization.v1.ShipmentTypeIncompatibility m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.parser(),
                        extensionRegistry);
                if (shipmentTypeIncompatibilitiesBuilder_ == null) {
                  ensureShipmentTypeIncompatibilitiesIsMutable();
                  shipmentTypeIncompatibilities_.add(m);
                } else {
                  shipmentTypeIncompatibilitiesBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                com.google.cloud.optimization.v1.ShipmentTypeRequirement m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentTypeRequirement.parser(),
                        extensionRegistry);
                if (shipmentTypeRequirementsBuilder_ == null) {
                  ensureShipmentTypeRequirementsIsMutable();
                  shipmentTypeRequirements_.add(m);
                } else {
                  shipmentTypeRequirementsBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.parser(),
                        extensionRegistry);
                if (precedenceRulesBuilder_ == null) {
                  ensurePrecedenceRulesIsMutable();
                  precedenceRules_.add(m);
                } else {
                  precedenceRulesBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 122:
              {
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentModel.BreakRule.parser(),
                        extensionRegistry);
                if (breakRulesBuilder_ == null) {
                  ensureBreakRulesIsMutable();
                  breakRules_.add(m);
                } else {
                  breakRulesBuilder_.addMessage(m);
                }
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.optimization.v1.Shipment> shipments_ =
        java.util.Collections.emptyList();

    private void ensureShipmentsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        shipments_ = new java.util.ArrayList<com.google.cloud.optimization.v1.Shipment>(shipments_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.Shipment,
            com.google.cloud.optimization.v1.Shipment.Builder,
            com.google.cloud.optimization.v1.ShipmentOrBuilder>
        shipmentsBuilder_;

    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.Shipment> getShipmentsList() {
      if (shipmentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shipments_);
      } else {
        return shipmentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public int getShipmentsCount() {
      if (shipmentsBuilder_ == null) {
        return shipments_.size();
      } else {
        return shipmentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public com.google.cloud.optimization.v1.Shipment getShipments(int index) {
      if (shipmentsBuilder_ == null) {
        return shipments_.get(index);
      } else {
        return shipmentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public Builder setShipments(int index, com.google.cloud.optimization.v1.Shipment value) {
      if (shipmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShipmentsIsMutable();
        shipments_.set(index, value);
        onChanged();
      } else {
        shipmentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public Builder setShipments(
        int index, com.google.cloud.optimization.v1.Shipment.Builder builderForValue) {
      if (shipmentsBuilder_ == null) {
        ensureShipmentsIsMutable();
        shipments_.set(index, builderForValue.build());
        onChanged();
      } else {
        shipmentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public Builder addShipments(com.google.cloud.optimization.v1.Shipment value) {
      if (shipmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShipmentsIsMutable();
        shipments_.add(value);
        onChanged();
      } else {
        shipmentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public Builder addShipments(int index, com.google.cloud.optimization.v1.Shipment value) {
      if (shipmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShipmentsIsMutable();
        shipments_.add(index, value);
        onChanged();
      } else {
        shipmentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public Builder addShipments(com.google.cloud.optimization.v1.Shipment.Builder builderForValue) {
      if (shipmentsBuilder_ == null) {
        ensureShipmentsIsMutable();
        shipments_.add(builderForValue.build());
        onChanged();
      } else {
        shipmentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public Builder addShipments(
        int index, com.google.cloud.optimization.v1.Shipment.Builder builderForValue) {
      if (shipmentsBuilder_ == null) {
        ensureShipmentsIsMutable();
        shipments_.add(index, builderForValue.build());
        onChanged();
      } else {
        shipmentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public Builder addAllShipments(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.Shipment> values) {
      if (shipmentsBuilder_ == null) {
        ensureShipmentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, shipments_);
        onChanged();
      } else {
        shipmentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public Builder clearShipments() {
      if (shipmentsBuilder_ == null) {
        shipments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        shipmentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public Builder removeShipments(int index) {
      if (shipmentsBuilder_ == null) {
        ensureShipmentsIsMutable();
        shipments_.remove(index);
        onChanged();
      } else {
        shipmentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.Builder getShipmentsBuilder(int index) {
      return getShipmentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentOrBuilder getShipmentsOrBuilder(int index) {
      if (shipmentsBuilder_ == null) {
        return shipments_.get(index);
      } else {
        return shipmentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentOrBuilder>
        getShipmentsOrBuilderList() {
      if (shipmentsBuilder_ != null) {
        return shipmentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shipments_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.Builder addShipmentsBuilder() {
      return getShipmentsFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.Shipment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.Builder addShipmentsBuilder(int index) {
      return getShipmentsFieldBuilder()
          .addBuilder(index, com.google.cloud.optimization.v1.Shipment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of shipments which must be performed in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment shipments = 1;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.Shipment.Builder>
        getShipmentsBuilderList() {
      return getShipmentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.Shipment,
            com.google.cloud.optimization.v1.Shipment.Builder,
            com.google.cloud.optimization.v1.ShipmentOrBuilder>
        getShipmentsFieldBuilder() {
      if (shipmentsBuilder_ == null) {
        shipmentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.Shipment,
                com.google.cloud.optimization.v1.Shipment.Builder,
                com.google.cloud.optimization.v1.ShipmentOrBuilder>(
                shipments_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        shipments_ = null;
      }
      return shipmentsBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.Vehicle> vehicles_ =
        java.util.Collections.emptyList();

    private void ensureVehiclesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        vehicles_ = new java.util.ArrayList<com.google.cloud.optimization.v1.Vehicle>(vehicles_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.Vehicle,
            com.google.cloud.optimization.v1.Vehicle.Builder,
            com.google.cloud.optimization.v1.VehicleOrBuilder>
        vehiclesBuilder_;

    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.Vehicle> getVehiclesList() {
      if (vehiclesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(vehicles_);
      } else {
        return vehiclesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public int getVehiclesCount() {
      if (vehiclesBuilder_ == null) {
        return vehicles_.size();
      } else {
        return vehiclesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public com.google.cloud.optimization.v1.Vehicle getVehicles(int index) {
      if (vehiclesBuilder_ == null) {
        return vehicles_.get(index);
      } else {
        return vehiclesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public Builder setVehicles(int index, com.google.cloud.optimization.v1.Vehicle value) {
      if (vehiclesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVehiclesIsMutable();
        vehicles_.set(index, value);
        onChanged();
      } else {
        vehiclesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public Builder setVehicles(
        int index, com.google.cloud.optimization.v1.Vehicle.Builder builderForValue) {
      if (vehiclesBuilder_ == null) {
        ensureVehiclesIsMutable();
        vehicles_.set(index, builderForValue.build());
        onChanged();
      } else {
        vehiclesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public Builder addVehicles(com.google.cloud.optimization.v1.Vehicle value) {
      if (vehiclesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVehiclesIsMutable();
        vehicles_.add(value);
        onChanged();
      } else {
        vehiclesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public Builder addVehicles(int index, com.google.cloud.optimization.v1.Vehicle value) {
      if (vehiclesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVehiclesIsMutable();
        vehicles_.add(index, value);
        onChanged();
      } else {
        vehiclesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public Builder addVehicles(com.google.cloud.optimization.v1.Vehicle.Builder builderForValue) {
      if (vehiclesBuilder_ == null) {
        ensureVehiclesIsMutable();
        vehicles_.add(builderForValue.build());
        onChanged();
      } else {
        vehiclesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public Builder addVehicles(
        int index, com.google.cloud.optimization.v1.Vehicle.Builder builderForValue) {
      if (vehiclesBuilder_ == null) {
        ensureVehiclesIsMutable();
        vehicles_.add(index, builderForValue.build());
        onChanged();
      } else {
        vehiclesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public Builder addAllVehicles(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.Vehicle> values) {
      if (vehiclesBuilder_ == null) {
        ensureVehiclesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, vehicles_);
        onChanged();
      } else {
        vehiclesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public Builder clearVehicles() {
      if (vehiclesBuilder_ == null) {
        vehicles_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        vehiclesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public Builder removeVehicles(int index) {
      if (vehiclesBuilder_ == null) {
        ensureVehiclesIsMutable();
        vehicles_.remove(index);
        onChanged();
      } else {
        vehiclesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public com.google.cloud.optimization.v1.Vehicle.Builder getVehiclesBuilder(int index) {
      return getVehiclesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public com.google.cloud.optimization.v1.VehicleOrBuilder getVehiclesOrBuilder(int index) {
      if (vehiclesBuilder_ == null) {
        return vehicles_.get(index);
      } else {
        return vehiclesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.VehicleOrBuilder>
        getVehiclesOrBuilderList() {
      if (vehiclesBuilder_ != null) {
        return vehiclesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(vehicles_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public com.google.cloud.optimization.v1.Vehicle.Builder addVehiclesBuilder() {
      return getVehiclesFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.Vehicle.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public com.google.cloud.optimization.v1.Vehicle.Builder addVehiclesBuilder(int index) {
      return getVehiclesFieldBuilder()
          .addBuilder(index, com.google.cloud.optimization.v1.Vehicle.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of vehicles which can be used to perform visits.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Vehicle vehicles = 2;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.Vehicle.Builder>
        getVehiclesBuilderList() {
      return getVehiclesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.Vehicle,
            com.google.cloud.optimization.v1.Vehicle.Builder,
            com.google.cloud.optimization.v1.VehicleOrBuilder>
        getVehiclesFieldBuilder() {
      if (vehiclesBuilder_ == null) {
        vehiclesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.Vehicle,
                com.google.cloud.optimization.v1.Vehicle.Builder,
                com.google.cloud.optimization.v1.VehicleOrBuilder>(
                vehicles_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        vehicles_ = null;
      }
      return vehiclesBuilder_;
    }

    private int maxActiveVehicles_;
    /**
     *
     *
     * <pre>
     * Constrains the maximum number of active vehicles. A vehicle is active if
     * its route performs at least one shipment. This can be used to limit the
     * number of routes in the case where there are fewer drivers than
     * vehicles and that the fleet of vehicles is heterogeneous. The optimization
     * will then select the best subset of vehicles to use.
     * Must be strictly positive.
     * </pre>
     *
     * <code>optional int32 max_active_vehicles = 4;</code>
     *
     * @return Whether the maxActiveVehicles field is set.
     */
    @java.lang.Override
    public boolean hasMaxActiveVehicles() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Constrains the maximum number of active vehicles. A vehicle is active if
     * its route performs at least one shipment. This can be used to limit the
     * number of routes in the case where there are fewer drivers than
     * vehicles and that the fleet of vehicles is heterogeneous. The optimization
     * will then select the best subset of vehicles to use.
     * Must be strictly positive.
     * </pre>
     *
     * <code>optional int32 max_active_vehicles = 4;</code>
     *
     * @return The maxActiveVehicles.
     */
    @java.lang.Override
    public int getMaxActiveVehicles() {
      return maxActiveVehicles_;
    }
    /**
     *
     *
     * <pre>
     * Constrains the maximum number of active vehicles. A vehicle is active if
     * its route performs at least one shipment. This can be used to limit the
     * number of routes in the case where there are fewer drivers than
     * vehicles and that the fleet of vehicles is heterogeneous. The optimization
     * will then select the best subset of vehicles to use.
     * Must be strictly positive.
     * </pre>
     *
     * <code>optional int32 max_active_vehicles = 4;</code>
     *
     * @param value The maxActiveVehicles to set.
     * @return This builder for chaining.
     */
    public Builder setMaxActiveVehicles(int value) {
      bitField0_ |= 0x00000004;
      maxActiveVehicles_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Constrains the maximum number of active vehicles. A vehicle is active if
     * its route performs at least one shipment. This can be used to limit the
     * number of routes in the case where there are fewer drivers than
     * vehicles and that the fleet of vehicles is heterogeneous. The optimization
     * will then select the best subset of vehicles to use.
     * Must be strictly positive.
     * </pre>
     *
     * <code>optional int32 max_active_vehicles = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxActiveVehicles() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxActiveVehicles_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp globalStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        globalStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     *
     * @return Whether the globalStartTime field is set.
     */
    public boolean hasGlobalStartTime() {
      return globalStartTimeBuilder_ != null || globalStartTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     *
     * @return The globalStartTime.
     */
    public com.google.protobuf.Timestamp getGlobalStartTime() {
      if (globalStartTimeBuilder_ == null) {
        return globalStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : globalStartTime_;
      } else {
        return globalStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     */
    public Builder setGlobalStartTime(com.google.protobuf.Timestamp value) {
      if (globalStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        globalStartTime_ = value;
        onChanged();
      } else {
        globalStartTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     */
    public Builder setGlobalStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (globalStartTimeBuilder_ == null) {
        globalStartTime_ = builderForValue.build();
        onChanged();
      } else {
        globalStartTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     */
    public Builder mergeGlobalStartTime(com.google.protobuf.Timestamp value) {
      if (globalStartTimeBuilder_ == null) {
        if (globalStartTime_ != null) {
          globalStartTime_ =
              com.google.protobuf.Timestamp.newBuilder(globalStartTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          globalStartTime_ = value;
        }
        onChanged();
      } else {
        globalStartTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     */
    public Builder clearGlobalStartTime() {
      if (globalStartTimeBuilder_ == null) {
        globalStartTime_ = null;
        onChanged();
      } else {
        globalStartTime_ = null;
        globalStartTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getGlobalStartTimeBuilder() {

      onChanged();
      return getGlobalStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getGlobalStartTimeOrBuilder() {
      if (globalStartTimeBuilder_ != null) {
        return globalStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return globalStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : globalStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Global start and end time of the model: no times outside of this range
     * can be considered valid.
     * The model's time span must be less than a year, i.e. the `global_end_time`
     * and the `global_start_time` must be within 31536000 seconds of each other.
     * When using `cost_per_*hour` fields, you might want to set this window to a
     * smaller interval to increase performance (eg. if you model a single day,
     * you should set the global time limits to that day).
     * If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
     * as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_start_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getGlobalStartTimeFieldBuilder() {
      if (globalStartTimeBuilder_ == null) {
        globalStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getGlobalStartTime(), getParentForChildren(), isClean());
        globalStartTime_ = null;
      }
      return globalStartTimeBuilder_;
    }

    private com.google.protobuf.Timestamp globalEndTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        globalEndTimeBuilder_;
    /**
     *
     *
     * <pre>
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     *
     * @return Whether the globalEndTime field is set.
     */
    public boolean hasGlobalEndTime() {
      return globalEndTimeBuilder_ != null || globalEndTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     *
     * @return The globalEndTime.
     */
    public com.google.protobuf.Timestamp getGlobalEndTime() {
      if (globalEndTimeBuilder_ == null) {
        return globalEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : globalEndTime_;
      } else {
        return globalEndTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     */
    public Builder setGlobalEndTime(com.google.protobuf.Timestamp value) {
      if (globalEndTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        globalEndTime_ = value;
        onChanged();
      } else {
        globalEndTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     */
    public Builder setGlobalEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (globalEndTimeBuilder_ == null) {
        globalEndTime_ = builderForValue.build();
        onChanged();
      } else {
        globalEndTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     */
    public Builder mergeGlobalEndTime(com.google.protobuf.Timestamp value) {
      if (globalEndTimeBuilder_ == null) {
        if (globalEndTime_ != null) {
          globalEndTime_ =
              com.google.protobuf.Timestamp.newBuilder(globalEndTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          globalEndTime_ = value;
        }
        onChanged();
      } else {
        globalEndTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     */
    public Builder clearGlobalEndTime() {
      if (globalEndTimeBuilder_ == null) {
        globalEndTime_ = null;
        onChanged();
      } else {
        globalEndTime_ = null;
        globalEndTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getGlobalEndTimeBuilder() {

      onChanged();
      return getGlobalEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getGlobalEndTimeOrBuilder() {
      if (globalEndTimeBuilder_ != null) {
        return globalEndTimeBuilder_.getMessageOrBuilder();
      } else {
        return globalEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : globalEndTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
     * is used as default.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp global_end_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getGlobalEndTimeFieldBuilder() {
      if (globalEndTimeBuilder_ == null) {
        globalEndTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getGlobalEndTime(), getParentForChildren(), isClean());
        globalEndTime_ = null;
      }
      return globalEndTimeBuilder_;
    }

    private double globalDurationCostPerHour_;
    /**
     *
     *
     * <pre>
     * The "global duration" of the overall plan is the difference between the
     * earliest effective start time and the latest effective end time of
     * all vehicles. Users can assign a cost per hour to that quantity to try
     * and optimize for earliest job completion, for example. This cost must be in
     * the same unit as [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
     * </pre>
     *
     * <code>double global_duration_cost_per_hour = 7;</code>
     *
     * @return The globalDurationCostPerHour.
     */
    @java.lang.Override
    public double getGlobalDurationCostPerHour() {
      return globalDurationCostPerHour_;
    }
    /**
     *
     *
     * <pre>
     * The "global duration" of the overall plan is the difference between the
     * earliest effective start time and the latest effective end time of
     * all vehicles. Users can assign a cost per hour to that quantity to try
     * and optimize for earliest job completion, for example. This cost must be in
     * the same unit as [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
     * </pre>
     *
     * <code>double global_duration_cost_per_hour = 7;</code>
     *
     * @param value The globalDurationCostPerHour to set.
     * @return This builder for chaining.
     */
    public Builder setGlobalDurationCostPerHour(double value) {

      globalDurationCostPerHour_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The "global duration" of the overall plan is the difference between the
     * earliest effective start time and the latest effective end time of
     * all vehicles. Users can assign a cost per hour to that quantity to try
     * and optimize for earliest job completion, for example. This cost must be in
     * the same unit as [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
     * </pre>
     *
     * <code>double global_duration_cost_per_hour = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGlobalDurationCostPerHour() {

      globalDurationCostPerHour_ = 0D;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix>
        durationDistanceMatrices_ = java.util.Collections.emptyList();

    private void ensureDurationDistanceMatricesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        durationDistanceMatrices_ =
            new java.util.ArrayList<
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix>(
                durationDistanceMatrices_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix,
            com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder,
            com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrixOrBuilder>
        durationDistanceMatricesBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix>
        getDurationDistanceMatricesList() {
      if (durationDistanceMatricesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(durationDistanceMatrices_);
      } else {
        return durationDistanceMatricesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public int getDurationDistanceMatricesCount() {
      if (durationDistanceMatricesBuilder_ == null) {
        return durationDistanceMatrices_.size();
      } else {
        return durationDistanceMatricesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
        getDurationDistanceMatrices(int index) {
      if (durationDistanceMatricesBuilder_ == null) {
        return durationDistanceMatrices_.get(index);
      } else {
        return durationDistanceMatricesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public Builder setDurationDistanceMatrices(
        int index, com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix value) {
      if (durationDistanceMatricesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDurationDistanceMatricesIsMutable();
        durationDistanceMatrices_.set(index, value);
        onChanged();
      } else {
        durationDistanceMatricesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public Builder setDurationDistanceMatrices(
        int index,
        com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder
            builderForValue) {
      if (durationDistanceMatricesBuilder_ == null) {
        ensureDurationDistanceMatricesIsMutable();
        durationDistanceMatrices_.set(index, builderForValue.build());
        onChanged();
      } else {
        durationDistanceMatricesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public Builder addDurationDistanceMatrices(
        com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix value) {
      if (durationDistanceMatricesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDurationDistanceMatricesIsMutable();
        durationDistanceMatrices_.add(value);
        onChanged();
      } else {
        durationDistanceMatricesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public Builder addDurationDistanceMatrices(
        int index, com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix value) {
      if (durationDistanceMatricesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDurationDistanceMatricesIsMutable();
        durationDistanceMatrices_.add(index, value);
        onChanged();
      } else {
        durationDistanceMatricesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public Builder addDurationDistanceMatrices(
        com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder
            builderForValue) {
      if (durationDistanceMatricesBuilder_ == null) {
        ensureDurationDistanceMatricesIsMutable();
        durationDistanceMatrices_.add(builderForValue.build());
        onChanged();
      } else {
        durationDistanceMatricesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public Builder addDurationDistanceMatrices(
        int index,
        com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder
            builderForValue) {
      if (durationDistanceMatricesBuilder_ == null) {
        ensureDurationDistanceMatricesIsMutable();
        durationDistanceMatrices_.add(index, builderForValue.build());
        onChanged();
      } else {
        durationDistanceMatricesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public Builder addAllDurationDistanceMatrices(
        java.lang.Iterable<
                ? extends com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix>
            values) {
      if (durationDistanceMatricesBuilder_ == null) {
        ensureDurationDistanceMatricesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, durationDistanceMatrices_);
        onChanged();
      } else {
        durationDistanceMatricesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public Builder clearDurationDistanceMatrices() {
      if (durationDistanceMatricesBuilder_ == null) {
        durationDistanceMatrices_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        durationDistanceMatricesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public Builder removeDurationDistanceMatrices(int index) {
      if (durationDistanceMatricesBuilder_ == null) {
        ensureDurationDistanceMatricesIsMutable();
        durationDistanceMatrices_.remove(index);
        onChanged();
      } else {
        durationDistanceMatricesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder
        getDurationDistanceMatricesBuilder(int index) {
      return getDurationDistanceMatricesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrixOrBuilder
        getDurationDistanceMatricesOrBuilder(int index) {
      if (durationDistanceMatricesBuilder_ == null) {
        return durationDistanceMatrices_.get(index);
      } else {
        return durationDistanceMatricesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrixOrBuilder>
        getDurationDistanceMatricesOrBuilderList() {
      if (durationDistanceMatricesBuilder_ != null) {
        return durationDistanceMatricesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(durationDistanceMatrices_);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder
        addDurationDistanceMatricesBuilder() {
      return getDurationDistanceMatricesFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder
        addDurationDistanceMatricesBuilder(int index) {
      return getDurationDistanceMatricesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies duration and distance matrices used in the model. If this field
     * is empty, Google Maps or geodesic distances will be used instead, depending
     * on the value of the `use_geodesic_distances` field. If it is not empty,
     * `use_geodesic_distances` cannot be true and neither
     * `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
     * can be empty.
     * Usage examples:
     * * There are two locations: locA and locB.
     * * 1 vehicle starting its route at locA and ending it at locA.
     * * 1 pickup visit request at locB.
     * ```
     * model {
     *   vehicles { start_tags: "locA"  end_tags: "locA" }
     *   shipments { pickups { tags: "locB" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locA"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrices {
     *     rows {  # from: locA
     *       durations { seconds: 0 }   meters: 0    # to: locA
     *       durations { seconds: 100 } meters: 1000 # to: locB
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 102 } meters: 990 # to: locA
     *       durations { seconds: 0 }   meters: 0   # to: locB
     *     }
     *   }
     * }
     * ```
     * * There are three locations: locA, locB and locC.
     * * 1 vehicle starting its route at locA and ending it at locB, using
     *   matrix "fast".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "slow".
     * * 1 vehicle starting its route at locB and ending it at locB, using
     *   matrix "fast".
     * * 1 pickup visit request at locC.
     * ```
     * model {
     *   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
     *   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
     *   shipments { pickups { tags: "locC" } }
     *   duration_distance_matrix_src_tags: "locA"
     *   duration_distance_matrix_src_tags: "locB"
     *   duration_distance_matrix_src_tags: "locC"
     *   duration_distance_matrix_dst_tags: "locB"
     *   duration_distance_matrix_dst_tags: "locC"
     *   duration_distance_matrices {
     *     vehicle_start_tag: "fast"
     *     rows {  # from: locA
     *       durations { seconds: 1000 } meters: 2000 # to: locB
     *       durations { seconds: 600 }  meters: 1000 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }   meters: 0    # to: locB
     *       durations { seconds: 700 } meters: 1200 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 702 } meters: 1190 # to: locB
     *       durations { seconds: 0 }   meters: 0    # to: locC
     *     }
     *   }
     *   duration_distance_matrices {
     *     vehicle_start_tag: "slow"
     *     rows {  # from: locA
     *       durations { seconds: 1800 } meters: 2001 # to: locB
     *       durations { seconds: 900 }  meters: 1002 # to: locC
     *     }
     *     rows {  # from: locB
     *       durations { seconds: 0 }    meters: 0    # to: locB
     *       durations { seconds: 1000 } meters: 1202 # to: locC
     *     }
     *     rows {  # from: locC
     *       durations { seconds: 1001 } meters: 1195 # to: locB
     *       durations { seconds: 0 }    meters: 0    # to: locC
     *     }
     *   }
     * }
     * ```
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix duration_distance_matrices = 8;
     * </code>
     */
    public java.util.List<
            com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder>
        getDurationDistanceMatricesBuilderList() {
      return getDurationDistanceMatricesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix,
            com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder,
            com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrixOrBuilder>
        getDurationDistanceMatricesFieldBuilder() {
      if (durationDistanceMatricesBuilder_ == null) {
        durationDistanceMatricesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix,
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Builder,
                com.google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrixOrBuilder>(
                durationDistanceMatrices_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        durationDistanceMatrices_ = null;
      }
      return durationDistanceMatricesBuilder_;
    }

    private com.google.protobuf.LazyStringList durationDistanceMatrixSrcTags_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureDurationDistanceMatrixSrcTagsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        durationDistanceMatrixSrcTags_ =
            new com.google.protobuf.LazyStringArrayList(durationDistanceMatrixSrcTags_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     *
     *
     * <pre>
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     *
     * @return A list containing the durationDistanceMatrixSrcTags.
     */
    public com.google.protobuf.ProtocolStringList getDurationDistanceMatrixSrcTagsList() {
      return durationDistanceMatrixSrcTags_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     *
     * @return The count of durationDistanceMatrixSrcTags.
     */
    public int getDurationDistanceMatrixSrcTagsCount() {
      return durationDistanceMatrixSrcTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The durationDistanceMatrixSrcTags at the given index.
     */
    public java.lang.String getDurationDistanceMatrixSrcTags(int index) {
      return durationDistanceMatrixSrcTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the durationDistanceMatrixSrcTags at the given index.
     */
    public com.google.protobuf.ByteString getDurationDistanceMatrixSrcTagsBytes(int index) {
      return durationDistanceMatrixSrcTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The durationDistanceMatrixSrcTags to set.
     * @return This builder for chaining.
     */
    public Builder setDurationDistanceMatrixSrcTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDurationDistanceMatrixSrcTagsIsMutable();
      durationDistanceMatrixSrcTags_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     *
     * @param value The durationDistanceMatrixSrcTags to add.
     * @return This builder for chaining.
     */
    public Builder addDurationDistanceMatrixSrcTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDurationDistanceMatrixSrcTagsIsMutable();
      durationDistanceMatrixSrcTags_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     *
     * @param values The durationDistanceMatrixSrcTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllDurationDistanceMatrixSrcTags(
        java.lang.Iterable<java.lang.String> values) {
      ensureDurationDistanceMatrixSrcTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, durationDistanceMatrixSrcTags_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDurationDistanceMatrixSrcTags() {
      durationDistanceMatrixSrcTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags defining the sources of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j)` defines durations and distances
     * from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
     * in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_src_tags = 9;</code>
     *
     * @param value The bytes of the durationDistanceMatrixSrcTags to add.
     * @return This builder for chaining.
     */
    public Builder addDurationDistanceMatrixSrcTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDurationDistanceMatrixSrcTagsIsMutable();
      durationDistanceMatrixSrcTags_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList durationDistanceMatrixDstTags_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureDurationDistanceMatrixDstTagsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        durationDistanceMatrixDstTags_ =
            new com.google.protobuf.LazyStringArrayList(durationDistanceMatrixDstTags_);
        bitField0_ |= 0x00000020;
      }
    }
    /**
     *
     *
     * <pre>
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     *
     * @return A list containing the durationDistanceMatrixDstTags.
     */
    public com.google.protobuf.ProtocolStringList getDurationDistanceMatrixDstTagsList() {
      return durationDistanceMatrixDstTags_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     *
     * @return The count of durationDistanceMatrixDstTags.
     */
    public int getDurationDistanceMatrixDstTagsCount() {
      return durationDistanceMatrixDstTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The durationDistanceMatrixDstTags at the given index.
     */
    public java.lang.String getDurationDistanceMatrixDstTags(int index) {
      return durationDistanceMatrixDstTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the durationDistanceMatrixDstTags at the given index.
     */
    public com.google.protobuf.ByteString getDurationDistanceMatrixDstTagsBytes(int index) {
      return durationDistanceMatrixDstTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The durationDistanceMatrixDstTags to set.
     * @return This builder for chaining.
     */
    public Builder setDurationDistanceMatrixDstTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDurationDistanceMatrixDstTagsIsMutable();
      durationDistanceMatrixDstTags_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     *
     * @param value The durationDistanceMatrixDstTags to add.
     * @return This builder for chaining.
     */
    public Builder addDurationDistanceMatrixDstTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDurationDistanceMatrixDstTagsIsMutable();
      durationDistanceMatrixDstTags_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     *
     * @param values The durationDistanceMatrixDstTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllDurationDistanceMatrixDstTags(
        java.lang.Iterable<java.lang.String> values) {
      ensureDurationDistanceMatrixDstTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, durationDistanceMatrixDstTags_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDurationDistanceMatrixDstTags() {
      durationDistanceMatrixDstTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags defining the destinations of the duration and distance matrices;
     * `duration_distance_matrices(i).rows(j).durations(k)` (resp.
     * `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
     * (resp. the distance) of the travel from visits with tag
     * `duration_distance_matrix_src_tags(j)` to visits with tag
     * `duration_distance_matrix_dst_tags(k)` in matrix i.
     * Tags correspond to
     * [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
     * or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
     * A given `VisitRequest` or `Vehicle` must match exactly one tag in this
     * field. Note that a `Vehicle`'s source, destination and matrix tags may be
     * the same; similarly a `VisitRequest`'s source and destination tags may be
     * the same. All tags must be different and cannot be empty strings. If this
     * field is not empty, then `duration_distance_matrices` must not be empty.
     * </pre>
     *
     * <code>repeated string duration_distance_matrix_dst_tags = 10;</code>
     *
     * @param value The bytes of the durationDistanceMatrixDstTags to add.
     * @return This builder for chaining.
     */
    public Builder addDurationDistanceMatrixDstTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDurationDistanceMatrixDstTagsIsMutable();
      durationDistanceMatrixDstTags_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.optimization.v1.TransitionAttributes>
        transitionAttributes_ = java.util.Collections.emptyList();

    private void ensureTransitionAttributesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        transitionAttributes_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.TransitionAttributes>(
                transitionAttributes_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.TransitionAttributes,
            com.google.cloud.optimization.v1.TransitionAttributes.Builder,
            com.google.cloud.optimization.v1.TransitionAttributesOrBuilder>
        transitionAttributesBuilder_;

    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.TransitionAttributes>
        getTransitionAttributesList() {
      if (transitionAttributesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(transitionAttributes_);
      } else {
        return transitionAttributesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public int getTransitionAttributesCount() {
      if (transitionAttributesBuilder_ == null) {
        return transitionAttributes_.size();
      } else {
        return transitionAttributesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public com.google.cloud.optimization.v1.TransitionAttributes getTransitionAttributes(
        int index) {
      if (transitionAttributesBuilder_ == null) {
        return transitionAttributes_.get(index);
      } else {
        return transitionAttributesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public Builder setTransitionAttributes(
        int index, com.google.cloud.optimization.v1.TransitionAttributes value) {
      if (transitionAttributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionAttributesIsMutable();
        transitionAttributes_.set(index, value);
        onChanged();
      } else {
        transitionAttributesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public Builder setTransitionAttributes(
        int index, com.google.cloud.optimization.v1.TransitionAttributes.Builder builderForValue) {
      if (transitionAttributesBuilder_ == null) {
        ensureTransitionAttributesIsMutable();
        transitionAttributes_.set(index, builderForValue.build());
        onChanged();
      } else {
        transitionAttributesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public Builder addTransitionAttributes(
        com.google.cloud.optimization.v1.TransitionAttributes value) {
      if (transitionAttributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionAttributesIsMutable();
        transitionAttributes_.add(value);
        onChanged();
      } else {
        transitionAttributesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public Builder addTransitionAttributes(
        int index, com.google.cloud.optimization.v1.TransitionAttributes value) {
      if (transitionAttributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionAttributesIsMutable();
        transitionAttributes_.add(index, value);
        onChanged();
      } else {
        transitionAttributesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public Builder addTransitionAttributes(
        com.google.cloud.optimization.v1.TransitionAttributes.Builder builderForValue) {
      if (transitionAttributesBuilder_ == null) {
        ensureTransitionAttributesIsMutable();
        transitionAttributes_.add(builderForValue.build());
        onChanged();
      } else {
        transitionAttributesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public Builder addTransitionAttributes(
        int index, com.google.cloud.optimization.v1.TransitionAttributes.Builder builderForValue) {
      if (transitionAttributesBuilder_ == null) {
        ensureTransitionAttributesIsMutable();
        transitionAttributes_.add(index, builderForValue.build());
        onChanged();
      } else {
        transitionAttributesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public Builder addAllTransitionAttributes(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.TransitionAttributes>
            values) {
      if (transitionAttributesBuilder_ == null) {
        ensureTransitionAttributesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transitionAttributes_);
        onChanged();
      } else {
        transitionAttributesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public Builder clearTransitionAttributes() {
      if (transitionAttributesBuilder_ == null) {
        transitionAttributes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        transitionAttributesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public Builder removeTransitionAttributes(int index) {
      if (transitionAttributesBuilder_ == null) {
        ensureTransitionAttributesIsMutable();
        transitionAttributes_.remove(index);
        onChanged();
      } else {
        transitionAttributesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public com.google.cloud.optimization.v1.TransitionAttributes.Builder
        getTransitionAttributesBuilder(int index) {
      return getTransitionAttributesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public com.google.cloud.optimization.v1.TransitionAttributesOrBuilder
        getTransitionAttributesOrBuilder(int index) {
      if (transitionAttributesBuilder_ == null) {
        return transitionAttributes_.get(index);
      } else {
        return transitionAttributesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.TransitionAttributesOrBuilder>
        getTransitionAttributesOrBuilderList() {
      if (transitionAttributesBuilder_ != null) {
        return transitionAttributesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(transitionAttributes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public com.google.cloud.optimization.v1.TransitionAttributes.Builder
        addTransitionAttributesBuilder() {
      return getTransitionAttributesFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.TransitionAttributes.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public com.google.cloud.optimization.v1.TransitionAttributes.Builder
        addTransitionAttributesBuilder(int index) {
      return getTransitionAttributesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.TransitionAttributes.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Transition attributes added to the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TransitionAttributes transition_attributes = 11;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.TransitionAttributes.Builder>
        getTransitionAttributesBuilderList() {
      return getTransitionAttributesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.TransitionAttributes,
            com.google.cloud.optimization.v1.TransitionAttributes.Builder,
            com.google.cloud.optimization.v1.TransitionAttributesOrBuilder>
        getTransitionAttributesFieldBuilder() {
      if (transitionAttributesBuilder_ == null) {
        transitionAttributesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.TransitionAttributes,
                com.google.cloud.optimization.v1.TransitionAttributes.Builder,
                com.google.cloud.optimization.v1.TransitionAttributesOrBuilder>(
                transitionAttributes_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        transitionAttributes_ = null;
      }
      return transitionAttributesBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.ShipmentTypeIncompatibility>
        shipmentTypeIncompatibilities_ = java.util.Collections.emptyList();

    private void ensureShipmentTypeIncompatibilitiesIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        shipmentTypeIncompatibilities_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentTypeIncompatibility>(
                shipmentTypeIncompatibilities_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentTypeIncompatibility,
            com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder,
            com.google.cloud.optimization.v1.ShipmentTypeIncompatibilityOrBuilder>
        shipmentTypeIncompatibilitiesBuilder_;

    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentTypeIncompatibility>
        getShipmentTypeIncompatibilitiesList() {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shipmentTypeIncompatibilities_);
      } else {
        return shipmentTypeIncompatibilitiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public int getShipmentTypeIncompatibilitiesCount() {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        return shipmentTypeIncompatibilities_.size();
      } else {
        return shipmentTypeIncompatibilitiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentTypeIncompatibility
        getShipmentTypeIncompatibilities(int index) {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        return shipmentTypeIncompatibilities_.get(index);
      } else {
        return shipmentTypeIncompatibilitiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public Builder setShipmentTypeIncompatibilities(
        int index, com.google.cloud.optimization.v1.ShipmentTypeIncompatibility value) {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShipmentTypeIncompatibilitiesIsMutable();
        shipmentTypeIncompatibilities_.set(index, value);
        onChanged();
      } else {
        shipmentTypeIncompatibilitiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public Builder setShipmentTypeIncompatibilities(
        int index,
        com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder builderForValue) {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        ensureShipmentTypeIncompatibilitiesIsMutable();
        shipmentTypeIncompatibilities_.set(index, builderForValue.build());
        onChanged();
      } else {
        shipmentTypeIncompatibilitiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public Builder addShipmentTypeIncompatibilities(
        com.google.cloud.optimization.v1.ShipmentTypeIncompatibility value) {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShipmentTypeIncompatibilitiesIsMutable();
        shipmentTypeIncompatibilities_.add(value);
        onChanged();
      } else {
        shipmentTypeIncompatibilitiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public Builder addShipmentTypeIncompatibilities(
        int index, com.google.cloud.optimization.v1.ShipmentTypeIncompatibility value) {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShipmentTypeIncompatibilitiesIsMutable();
        shipmentTypeIncompatibilities_.add(index, value);
        onChanged();
      } else {
        shipmentTypeIncompatibilitiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public Builder addShipmentTypeIncompatibilities(
        com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder builderForValue) {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        ensureShipmentTypeIncompatibilitiesIsMutable();
        shipmentTypeIncompatibilities_.add(builderForValue.build());
        onChanged();
      } else {
        shipmentTypeIncompatibilitiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public Builder addShipmentTypeIncompatibilities(
        int index,
        com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder builderForValue) {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        ensureShipmentTypeIncompatibilitiesIsMutable();
        shipmentTypeIncompatibilities_.add(index, builderForValue.build());
        onChanged();
      } else {
        shipmentTypeIncompatibilitiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public Builder addAllShipmentTypeIncompatibilities(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentTypeIncompatibility>
            values) {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        ensureShipmentTypeIncompatibilitiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, shipmentTypeIncompatibilities_);
        onChanged();
      } else {
        shipmentTypeIncompatibilitiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public Builder clearShipmentTypeIncompatibilities() {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        shipmentTypeIncompatibilities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        shipmentTypeIncompatibilitiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public Builder removeShipmentTypeIncompatibilities(int index) {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        ensureShipmentTypeIncompatibilitiesIsMutable();
        shipmentTypeIncompatibilities_.remove(index);
        onChanged();
      } else {
        shipmentTypeIncompatibilitiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder
        getShipmentTypeIncompatibilitiesBuilder(int index) {
      return getShipmentTypeIncompatibilitiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentTypeIncompatibilityOrBuilder
        getShipmentTypeIncompatibilitiesOrBuilder(int index) {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        return shipmentTypeIncompatibilities_.get(index);
      } else {
        return shipmentTypeIncompatibilitiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.ShipmentTypeIncompatibilityOrBuilder>
        getShipmentTypeIncompatibilitiesOrBuilderList() {
      if (shipmentTypeIncompatibilitiesBuilder_ != null) {
        return shipmentTypeIncompatibilitiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shipmentTypeIncompatibilities_);
      }
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder
        addShipmentTypeIncompatibilitiesBuilder() {
      return getShipmentTypeIncompatibilitiesFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder
        addShipmentTypeIncompatibilitiesBuilder(int index) {
      return getShipmentTypeIncompatibilitiesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeIncompatibility shipment_type_incompatibilities = 12;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder>
        getShipmentTypeIncompatibilitiesBuilderList() {
      return getShipmentTypeIncompatibilitiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentTypeIncompatibility,
            com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder,
            com.google.cloud.optimization.v1.ShipmentTypeIncompatibilityOrBuilder>
        getShipmentTypeIncompatibilitiesFieldBuilder() {
      if (shipmentTypeIncompatibilitiesBuilder_ == null) {
        shipmentTypeIncompatibilitiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentTypeIncompatibility,
                com.google.cloud.optimization.v1.ShipmentTypeIncompatibility.Builder,
                com.google.cloud.optimization.v1.ShipmentTypeIncompatibilityOrBuilder>(
                shipmentTypeIncompatibilities_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        shipmentTypeIncompatibilities_ = null;
      }
      return shipmentTypeIncompatibilitiesBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.ShipmentTypeRequirement>
        shipmentTypeRequirements_ = java.util.Collections.emptyList();

    private void ensureShipmentTypeRequirementsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        shipmentTypeRequirements_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentTypeRequirement>(
                shipmentTypeRequirements_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentTypeRequirement,
            com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder,
            com.google.cloud.optimization.v1.ShipmentTypeRequirementOrBuilder>
        shipmentTypeRequirementsBuilder_;

    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentTypeRequirement>
        getShipmentTypeRequirementsList() {
      if (shipmentTypeRequirementsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shipmentTypeRequirements_);
      } else {
        return shipmentTypeRequirementsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public int getShipmentTypeRequirementsCount() {
      if (shipmentTypeRequirementsBuilder_ == null) {
        return shipmentTypeRequirements_.size();
      } else {
        return shipmentTypeRequirementsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentTypeRequirement getShipmentTypeRequirements(
        int index) {
      if (shipmentTypeRequirementsBuilder_ == null) {
        return shipmentTypeRequirements_.get(index);
      } else {
        return shipmentTypeRequirementsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public Builder setShipmentTypeRequirements(
        int index, com.google.cloud.optimization.v1.ShipmentTypeRequirement value) {
      if (shipmentTypeRequirementsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShipmentTypeRequirementsIsMutable();
        shipmentTypeRequirements_.set(index, value);
        onChanged();
      } else {
        shipmentTypeRequirementsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public Builder setShipmentTypeRequirements(
        int index,
        com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder builderForValue) {
      if (shipmentTypeRequirementsBuilder_ == null) {
        ensureShipmentTypeRequirementsIsMutable();
        shipmentTypeRequirements_.set(index, builderForValue.build());
        onChanged();
      } else {
        shipmentTypeRequirementsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public Builder addShipmentTypeRequirements(
        com.google.cloud.optimization.v1.ShipmentTypeRequirement value) {
      if (shipmentTypeRequirementsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShipmentTypeRequirementsIsMutable();
        shipmentTypeRequirements_.add(value);
        onChanged();
      } else {
        shipmentTypeRequirementsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public Builder addShipmentTypeRequirements(
        int index, com.google.cloud.optimization.v1.ShipmentTypeRequirement value) {
      if (shipmentTypeRequirementsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShipmentTypeRequirementsIsMutable();
        shipmentTypeRequirements_.add(index, value);
        onChanged();
      } else {
        shipmentTypeRequirementsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public Builder addShipmentTypeRequirements(
        com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder builderForValue) {
      if (shipmentTypeRequirementsBuilder_ == null) {
        ensureShipmentTypeRequirementsIsMutable();
        shipmentTypeRequirements_.add(builderForValue.build());
        onChanged();
      } else {
        shipmentTypeRequirementsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public Builder addShipmentTypeRequirements(
        int index,
        com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder builderForValue) {
      if (shipmentTypeRequirementsBuilder_ == null) {
        ensureShipmentTypeRequirementsIsMutable();
        shipmentTypeRequirements_.add(index, builderForValue.build());
        onChanged();
      } else {
        shipmentTypeRequirementsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public Builder addAllShipmentTypeRequirements(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentTypeRequirement>
            values) {
      if (shipmentTypeRequirementsBuilder_ == null) {
        ensureShipmentTypeRequirementsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, shipmentTypeRequirements_);
        onChanged();
      } else {
        shipmentTypeRequirementsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public Builder clearShipmentTypeRequirements() {
      if (shipmentTypeRequirementsBuilder_ == null) {
        shipmentTypeRequirements_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        shipmentTypeRequirementsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public Builder removeShipmentTypeRequirements(int index) {
      if (shipmentTypeRequirementsBuilder_ == null) {
        ensureShipmentTypeRequirementsIsMutable();
        shipmentTypeRequirements_.remove(index);
        onChanged();
      } else {
        shipmentTypeRequirementsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder
        getShipmentTypeRequirementsBuilder(int index) {
      return getShipmentTypeRequirementsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentTypeRequirementOrBuilder
        getShipmentTypeRequirementsOrBuilder(int index) {
      if (shipmentTypeRequirementsBuilder_ == null) {
        return shipmentTypeRequirements_.get(index);
      } else {
        return shipmentTypeRequirementsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.ShipmentTypeRequirementOrBuilder>
        getShipmentTypeRequirementsOrBuilderList() {
      if (shipmentTypeRequirementsBuilder_ != null) {
        return shipmentTypeRequirementsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shipmentTypeRequirements_);
      }
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder
        addShipmentTypeRequirementsBuilder() {
      return getShipmentTypeRequirementsFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.ShipmentTypeRequirement.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder
        addShipmentTypeRequirementsBuilder(int index) {
      return getShipmentTypeRequirementsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.ShipmentTypeRequirement.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentTypeRequirement shipment_type_requirements = 13;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder>
        getShipmentTypeRequirementsBuilderList() {
      return getShipmentTypeRequirementsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentTypeRequirement,
            com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder,
            com.google.cloud.optimization.v1.ShipmentTypeRequirementOrBuilder>
        getShipmentTypeRequirementsFieldBuilder() {
      if (shipmentTypeRequirementsBuilder_ == null) {
        shipmentTypeRequirementsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentTypeRequirement,
                com.google.cloud.optimization.v1.ShipmentTypeRequirement.Builder,
                com.google.cloud.optimization.v1.ShipmentTypeRequirementOrBuilder>(
                shipmentTypeRequirements_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        shipmentTypeRequirements_ = null;
      }
      return shipmentTypeRequirementsBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule>
        precedenceRules_ = java.util.Collections.emptyList();

    private void ensurePrecedenceRulesIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        precedenceRules_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule>(
                precedenceRules_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule,
            com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder,
            com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRuleOrBuilder>
        precedenceRulesBuilder_;

    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule>
        getPrecedenceRulesList() {
      if (precedenceRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(precedenceRules_);
      } else {
        return precedenceRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public int getPrecedenceRulesCount() {
      if (precedenceRulesBuilder_ == null) {
        return precedenceRules_.size();
      } else {
        return precedenceRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule getPrecedenceRules(
        int index) {
      if (precedenceRulesBuilder_ == null) {
        return precedenceRules_.get(index);
      } else {
        return precedenceRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public Builder setPrecedenceRules(
        int index, com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule value) {
      if (precedenceRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePrecedenceRulesIsMutable();
        precedenceRules_.set(index, value);
        onChanged();
      } else {
        precedenceRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public Builder setPrecedenceRules(
        int index,
        com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder builderForValue) {
      if (precedenceRulesBuilder_ == null) {
        ensurePrecedenceRulesIsMutable();
        precedenceRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        precedenceRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public Builder addPrecedenceRules(
        com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule value) {
      if (precedenceRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePrecedenceRulesIsMutable();
        precedenceRules_.add(value);
        onChanged();
      } else {
        precedenceRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public Builder addPrecedenceRules(
        int index, com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule value) {
      if (precedenceRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePrecedenceRulesIsMutable();
        precedenceRules_.add(index, value);
        onChanged();
      } else {
        precedenceRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public Builder addPrecedenceRules(
        com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder builderForValue) {
      if (precedenceRulesBuilder_ == null) {
        ensurePrecedenceRulesIsMutable();
        precedenceRules_.add(builderForValue.build());
        onChanged();
      } else {
        precedenceRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public Builder addPrecedenceRules(
        int index,
        com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder builderForValue) {
      if (precedenceRulesBuilder_ == null) {
        ensurePrecedenceRulesIsMutable();
        precedenceRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        precedenceRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public Builder addAllPrecedenceRules(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule>
            values) {
      if (precedenceRulesBuilder_ == null) {
        ensurePrecedenceRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, precedenceRules_);
        onChanged();
      } else {
        precedenceRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public Builder clearPrecedenceRules() {
      if (precedenceRulesBuilder_ == null) {
        precedenceRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        precedenceRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public Builder removePrecedenceRules(int index) {
      if (precedenceRulesBuilder_ == null) {
        ensurePrecedenceRulesIsMutable();
        precedenceRules_.remove(index);
        onChanged();
      } else {
        precedenceRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder
        getPrecedenceRulesBuilder(int index) {
      return getPrecedenceRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRuleOrBuilder
        getPrecedenceRulesOrBuilder(int index) {
      if (precedenceRulesBuilder_ == null) {
        return precedenceRules_.get(index);
      } else {
        return precedenceRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRuleOrBuilder>
        getPrecedenceRulesOrBuilderList() {
      if (precedenceRulesBuilder_ != null) {
        return precedenceRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(precedenceRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder
        addPrecedenceRulesBuilder() {
      return getPrecedenceRulesFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder
        addPrecedenceRulesBuilder(int index) {
      return getPrecedenceRulesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of precedence rules which must be enforced in the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.PrecedenceRule precedence_rules = 14;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder>
        getPrecedenceRulesBuilderList() {
      return getPrecedenceRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule,
            com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder,
            com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRuleOrBuilder>
        getPrecedenceRulesFieldBuilder() {
      if (precedenceRulesBuilder_ == null) {
        precedenceRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule,
                com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.Builder,
                com.google.cloud.optimization.v1.ShipmentModel.PrecedenceRuleOrBuilder>(
                precedenceRules_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        precedenceRules_ = null;
      }
      return precedenceRulesBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule> breakRules_ =
        java.util.Collections.emptyList();

    private void ensureBreakRulesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        breakRules_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentModel.BreakRule>(
                breakRules_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentModel.BreakRule,
            com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder,
            com.google.cloud.optimization.v1.ShipmentModel.BreakRuleOrBuilder>
        breakRulesBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule>
        getBreakRulesList() {
      if (breakRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(breakRules_);
      } else {
        return breakRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getBreakRulesCount() {
      if (breakRulesBuilder_ == null) {
        return breakRules_.size();
      } else {
        return breakRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentModel.BreakRule getBreakRules(int index) {
      if (breakRulesBuilder_ == null) {
        return breakRules_.get(index);
      } else {
        return breakRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setBreakRules(
        int index, com.google.cloud.optimization.v1.ShipmentModel.BreakRule value) {
      if (breakRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBreakRulesIsMutable();
        breakRules_.set(index, value);
        onChanged();
      } else {
        breakRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setBreakRules(
        int index,
        com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder builderForValue) {
      if (breakRulesBuilder_ == null) {
        ensureBreakRulesIsMutable();
        breakRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        breakRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addBreakRules(com.google.cloud.optimization.v1.ShipmentModel.BreakRule value) {
      if (breakRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBreakRulesIsMutable();
        breakRules_.add(value);
        onChanged();
      } else {
        breakRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addBreakRules(
        int index, com.google.cloud.optimization.v1.ShipmentModel.BreakRule value) {
      if (breakRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBreakRulesIsMutable();
        breakRules_.add(index, value);
        onChanged();
      } else {
        breakRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addBreakRules(
        com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder builderForValue) {
      if (breakRulesBuilder_ == null) {
        ensureBreakRulesIsMutable();
        breakRules_.add(builderForValue.build());
        onChanged();
      } else {
        breakRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addBreakRules(
        int index,
        com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder builderForValue) {
      if (breakRulesBuilder_ == null) {
        ensureBreakRulesIsMutable();
        breakRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        breakRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllBreakRules(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentModel.BreakRule>
            values) {
      if (breakRulesBuilder_ == null) {
        ensureBreakRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, breakRules_);
        onChanged();
      } else {
        breakRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearBreakRules() {
      if (breakRulesBuilder_ == null) {
        breakRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        breakRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeBreakRules(int index) {
      if (breakRulesBuilder_ == null) {
        ensureBreakRulesIsMutable();
        breakRules_.remove(index);
        onChanged();
      } else {
        breakRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder getBreakRulesBuilder(
        int index) {
      return getBreakRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentModel.BreakRuleOrBuilder getBreakRulesOrBuilder(
        int index) {
      if (breakRulesBuilder_ == null) {
        return breakRules_.get(index);
      } else {
        return breakRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.ShipmentModel.BreakRuleOrBuilder>
        getBreakRulesOrBuilderList() {
      if (breakRulesBuilder_ != null) {
        return breakRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(breakRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder addBreakRulesBuilder() {
      return getBreakRulesFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.ShipmentModel.BreakRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder addBreakRulesBuilder(
        int index) {
      return getBreakRulesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.ShipmentModel.BreakRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: No longer used.
     * Set of break rules used in the model.
     * Each vehicle specifies the `BreakRule` that applies to it via the
     * [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices] field (which must be a singleton).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentModel.BreakRule break_rules = 15 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder>
        getBreakRulesBuilderList() {
      return getBreakRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentModel.BreakRule,
            com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder,
            com.google.cloud.optimization.v1.ShipmentModel.BreakRuleOrBuilder>
        getBreakRulesFieldBuilder() {
      if (breakRulesBuilder_ == null) {
        breakRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule,
                com.google.cloud.optimization.v1.ShipmentModel.BreakRule.Builder,
                com.google.cloud.optimization.v1.ShipmentModel.BreakRuleOrBuilder>(
                breakRules_, ((bitField0_ & 0x00000400) != 0), getParentForChildren(), isClean());
        breakRules_ = null;
      }
      return breakRulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.ShipmentModel)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.ShipmentModel)
  private static final com.google.cloud.optimization.v1.ShipmentModel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.ShipmentModel();
  }

  public static com.google.cloud.optimization.v1.ShipmentModel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ShipmentModel> PARSER =
      new com.google.protobuf.AbstractParser<ShipmentModel>() {
        @java.lang.Override
        public ShipmentModel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ShipmentModel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ShipmentModel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentModel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
