/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * The shipment of a single item, from one of its pickups to one of its
 * deliveries. For the shipment to be considered as performed, a unique vehicle
 * must visit one of its pickup locations (and decrease its spare capacities
 * accordingly), then visit one of its delivery locations later on (and
 * therefore re-increase its spare capacities accordingly).
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.Shipment}
 */
public final class Shipment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.Shipment)
    ShipmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Shipment.newBuilder() to construct.
  private Shipment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Shipment() {
    pickups_ = java.util.Collections.emptyList();
    deliveries_ = java.util.Collections.emptyList();
    allowedVehicleIndices_ = emptyIntList();
    costsPerVehicle_ = emptyDoubleList();
    costsPerVehicleIndices_ = emptyIntList();
    shipmentType_ = "";
    label_ = "";
    demands_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Shipment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_Shipment_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 14:
        return internalGetLoadDemands();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_Shipment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.Shipment.class,
            com.google.cloud.optimization.v1.Shipment.Builder.class);
  }

  public interface VisitRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.Shipment.VisitRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng arrival_location = 1;</code>
     *
     * @return Whether the arrivalLocation field is set.
     */
    boolean hasArrivalLocation();
    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng arrival_location = 1;</code>
     *
     * @return The arrivalLocation.
     */
    com.google.type.LatLng getArrivalLocation();
    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng arrival_location = 1;</code>
     */
    com.google.type.LatLngOrBuilder getArrivalLocationOrBuilder();

    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
     *
     * @return Whether the arrivalWaypoint field is set.
     */
    boolean hasArrivalWaypoint();
    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
     *
     * @return The arrivalWaypoint.
     */
    com.google.cloud.optimization.v1.Waypoint getArrivalWaypoint();
    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
     */
    com.google.cloud.optimization.v1.WaypointOrBuilder getArrivalWaypointOrBuilder();

    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
     * If the shipment model has duration distance matrices,
     * `departure_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng departure_location = 3;</code>
     *
     * @return Whether the departureLocation field is set.
     */
    boolean hasDepartureLocation();
    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
     * If the shipment model has duration distance matrices,
     * `departure_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng departure_location = 3;</code>
     *
     * @return The departureLocation.
     */
    com.google.type.LatLng getDepartureLocation();
    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
     * If the shipment model has duration distance matrices,
     * `departure_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng departure_location = 3;</code>
     */
    com.google.type.LatLngOrBuilder getDepartureLocationOrBuilder();

    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
     * If the shipment model has duration distance matrices,
     * `departure_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
     *
     * @return Whether the departureWaypoint field is set.
     */
    boolean hasDepartureWaypoint();
    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
     * If the shipment model has duration distance matrices,
     * `departure_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
     *
     * @return The departureWaypoint.
     */
    com.google.cloud.optimization.v1.Waypoint getDepartureWaypoint();
    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
     * If the shipment model has duration distance matrices,
     * `departure_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
     */
    com.google.cloud.optimization.v1.WaypointOrBuilder getDepartureWaypointOrBuilder();

    /**
     *
     *
     * <pre>
     * Specifies tags attached to the visit request.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @return A list containing the tags.
     */
    java.util.List<java.lang.String> getTagsList();
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the visit request.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @return The count of tags.
     */
    int getTagsCount();
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the visit request.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    java.lang.String getTags(int index);
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the visit request.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    com.google.protobuf.ByteString getTagsBytes(int index);

    /**
     *
     *
     * <pre>
     * Time windows which constrain the arrival time at a visit.
     * Note that a vehicle may depart outside of the arrival time window, i.e.
     * arrival time + duration do not need to be inside a time window. This can
     * result in waiting time if the vehicle arrives before
     * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
     * The absence of `TimeWindow` means that the vehicle can perform this visit
     * at any time.
     * Time windows must be disjoint, i.e. no time window must overlap with or
     * be adjacent to another, and they must be in increasing order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
     * be set if there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
     */
    java.util.List<com.google.cloud.optimization.v1.TimeWindow> getTimeWindowsList();
    /**
     *
     *
     * <pre>
     * Time windows which constrain the arrival time at a visit.
     * Note that a vehicle may depart outside of the arrival time window, i.e.
     * arrival time + duration do not need to be inside a time window. This can
     * result in waiting time if the vehicle arrives before
     * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
     * The absence of `TimeWindow` means that the vehicle can perform this visit
     * at any time.
     * Time windows must be disjoint, i.e. no time window must overlap with or
     * be adjacent to another, and they must be in increasing order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
     * be set if there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
     */
    com.google.cloud.optimization.v1.TimeWindow getTimeWindows(int index);
    /**
     *
     *
     * <pre>
     * Time windows which constrain the arrival time at a visit.
     * Note that a vehicle may depart outside of the arrival time window, i.e.
     * arrival time + duration do not need to be inside a time window. This can
     * result in waiting time if the vehicle arrives before
     * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
     * The absence of `TimeWindow` means that the vehicle can perform this visit
     * at any time.
     * Time windows must be disjoint, i.e. no time window must overlap with or
     * be adjacent to another, and they must be in increasing order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
     * be set if there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
     */
    int getTimeWindowsCount();
    /**
     *
     *
     * <pre>
     * Time windows which constrain the arrival time at a visit.
     * Note that a vehicle may depart outside of the arrival time window, i.e.
     * arrival time + duration do not need to be inside a time window. This can
     * result in waiting time if the vehicle arrives before
     * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
     * The absence of `TimeWindow` means that the vehicle can perform this visit
     * at any time.
     * Time windows must be disjoint, i.e. no time window must overlap with or
     * be adjacent to another, and they must be in increasing order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
     * be set if there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
     */
    java.util.List<? extends com.google.cloud.optimization.v1.TimeWindowOrBuilder>
        getTimeWindowsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Time windows which constrain the arrival time at a visit.
     * Note that a vehicle may depart outside of the arrival time window, i.e.
     * arrival time + duration do not need to be inside a time window. This can
     * result in waiting time if the vehicle arrives before
     * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
     * The absence of `TimeWindow` means that the vehicle can perform this visit
     * at any time.
     * Time windows must be disjoint, i.e. no time window must overlap with or
     * be adjacent to another, and they must be in increasing order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
     * be set if there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
     */
    com.google.cloud.optimization.v1.TimeWindowOrBuilder getTimeWindowsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Duration of the visit, i.e. time spent by the vehicle between arrival
     * and departure (to be added to the possible waiting time; see
     * `time_windows`).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 7;</code>
     *
     * @return Whether the duration field is set.
     */
    boolean hasDuration();
    /**
     *
     *
     * <pre>
     * Duration of the visit, i.e. time spent by the vehicle between arrival
     * and departure (to be added to the possible waiting time; see
     * `time_windows`).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 7;</code>
     *
     * @return The duration.
     */
    com.google.protobuf.Duration getDuration();
    /**
     *
     *
     * <pre>
     * Duration of the visit, i.e. time spent by the vehicle between arrival
     * and departure (to be added to the possible waiting time; see
     * `time_windows`).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 7;</code>
     */
    com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Cost to service this visit request on a vehicle route. This can be used
     * to pay different costs for each alternative pickup or delivery of a
     * shipment. This cost must be in the same unit as `Shipment.penalty_cost`
     * and must not be negative.
     * </pre>
     *
     * <code>double cost = 8;</code>
     *
     * @return The cost.
     */
    double getCost();

    /**
     *
     *
     * <pre>
     * Load demands of this visit request. This is just like
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
     * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
     * The demands listed here are added to the demands listed in
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
     * </code>
     */
    int getLoadDemandsCount();
    /**
     *
     *
     * <pre>
     * Load demands of this visit request. This is just like
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
     * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
     * The demands listed here are added to the demands listed in
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
     * </code>
     */
    boolean containsLoadDemands(java.lang.String key);
    /** Use {@link #getLoadDemandsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        getLoadDemands();
    /**
     *
     *
     * <pre>
     * Load demands of this visit request. This is just like
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
     * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
     * The demands listed here are added to the demands listed in
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
     * </code>
     */
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        getLoadDemandsMap();
    /**
     *
     *
     * <pre>
     * Load demands of this visit request. This is just like
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
     * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
     * The demands listed here are added to the demands listed in
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
     * </code>
     */

    /* nullable */
    com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.optimization.v1.Shipment.Load defaultValue);
    /**
     *
     *
     * <pre>
     * Load demands of this visit request. This is just like
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
     * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
     * The demands listed here are added to the demands listed in
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
     * </code>
     */
    com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Specifies the types of the visit. This may be used to allocate additional
     * time required for a vehicle to complete this visit (see
     * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
     * A type can only appear once.
     * </pre>
     *
     * <code>repeated string visit_types = 10;</code>
     *
     * @return A list containing the visitTypes.
     */
    java.util.List<java.lang.String> getVisitTypesList();
    /**
     *
     *
     * <pre>
     * Specifies the types of the visit. This may be used to allocate additional
     * time required for a vehicle to complete this visit (see
     * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
     * A type can only appear once.
     * </pre>
     *
     * <code>repeated string visit_types = 10;</code>
     *
     * @return The count of visitTypes.
     */
    int getVisitTypesCount();
    /**
     *
     *
     * <pre>
     * Specifies the types of the visit. This may be used to allocate additional
     * time required for a vehicle to complete this visit (see
     * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
     * A type can only appear once.
     * </pre>
     *
     * <code>repeated string visit_types = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The visitTypes at the given index.
     */
    java.lang.String getVisitTypes(int index);
    /**
     *
     *
     * <pre>
     * Specifies the types of the visit. This may be used to allocate additional
     * time required for a vehicle to complete this visit (see
     * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
     * A type can only appear once.
     * </pre>
     *
     * <code>repeated string visit_types = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the visitTypes at the given index.
     */
    com.google.protobuf.ByteString getVisitTypesBytes(int index);

    /**
     *
     *
     * <pre>
     * Specifies a label for this `VisitRequest`. This label is reported in the
     * response as `visit_label` in the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
     * </pre>
     *
     * <code>string label = 11;</code>
     *
     * @return The label.
     */
    java.lang.String getLabel();
    /**
     *
     *
     * <pre>
     * Specifies a label for this `VisitRequest`. This label is reported in the
     * response as `visit_label` in the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
     * </pre>
     *
     * <code>string label = 11;</code>
     *
     * @return The bytes for label.
     */
    com.google.protobuf.ByteString getLabelBytes();

    /**
     *
     *
     * <pre>
     * Deprecated: Use [VisitRequest.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getDemandsList();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [VisitRequest.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.optimization.v1.CapacityQuantity getDemands(int index);
    /**
     *
     *
     * <pre>
     * Deprecated: Use [VisitRequest.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    int getDemandsCount();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [VisitRequest.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getDemandsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Deprecated: Use [VisitRequest.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getDemandsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Request for a visit which can be done by a vehicle: it has a geo-location
   * (or two, see below), opening and closing times represented by time windows,
   * and a service duration time (time spent by the vehicle once it has arrived
   * to pickup or drop off goods).
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.Shipment.VisitRequest}
   */
  public static final class VisitRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.Shipment.VisitRequest)
      VisitRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VisitRequest.newBuilder() to construct.
    private VisitRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VisitRequest() {
      tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      timeWindows_ = java.util.Collections.emptyList();
      visitTypes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      label_ = "";
      demands_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VisitRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 12:
          return internalGetLoadDemands();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.Shipment.VisitRequest.class,
              com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder.class);
    }

    public static final int ARRIVAL_LOCATION_FIELD_NUMBER = 1;
    private com.google.type.LatLng arrivalLocation_;
    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng arrival_location = 1;</code>
     *
     * @return Whether the arrivalLocation field is set.
     */
    @java.lang.Override
    public boolean hasArrivalLocation() {
      return arrivalLocation_ != null;
    }
    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng arrival_location = 1;</code>
     *
     * @return The arrivalLocation.
     */
    @java.lang.Override
    public com.google.type.LatLng getArrivalLocation() {
      return arrivalLocation_ == null
          ? com.google.type.LatLng.getDefaultInstance()
          : arrivalLocation_;
    }
    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng arrival_location = 1;</code>
     */
    @java.lang.Override
    public com.google.type.LatLngOrBuilder getArrivalLocationOrBuilder() {
      return getArrivalLocation();
    }

    public static final int ARRIVAL_WAYPOINT_FIELD_NUMBER = 2;
    private com.google.cloud.optimization.v1.Waypoint arrivalWaypoint_;
    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
     *
     * @return Whether the arrivalWaypoint field is set.
     */
    @java.lang.Override
    public boolean hasArrivalWaypoint() {
      return arrivalWaypoint_ != null;
    }
    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
     *
     * @return The arrivalWaypoint.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Waypoint getArrivalWaypoint() {
      return arrivalWaypoint_ == null
          ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
          : arrivalWaypoint_;
    }
    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle arrives when performing this
     * `VisitRequest`. If the shipment model has duration distance matrices,
     * `arrival_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.WaypointOrBuilder getArrivalWaypointOrBuilder() {
      return getArrivalWaypoint();
    }

    public static final int DEPARTURE_LOCATION_FIELD_NUMBER = 3;
    private com.google.type.LatLng departureLocation_;
    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
     * If the shipment model has duration distance matrices,
     * `departure_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng departure_location = 3;</code>
     *
     * @return Whether the departureLocation field is set.
     */
    @java.lang.Override
    public boolean hasDepartureLocation() {
      return departureLocation_ != null;
    }
    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
     * If the shipment model has duration distance matrices,
     * `departure_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng departure_location = 3;</code>
     *
     * @return The departureLocation.
     */
    @java.lang.Override
    public com.google.type.LatLng getDepartureLocation() {
      return departureLocation_ == null
          ? com.google.type.LatLng.getDefaultInstance()
          : departureLocation_;
    }
    /**
     *
     *
     * <pre>
     * The geo-location where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
     * If the shipment model has duration distance matrices,
     * `departure_location` must not be specified.
     * </pre>
     *
     * <code>.google.type.LatLng departure_location = 3;</code>
     */
    @java.lang.Override
    public com.google.type.LatLngOrBuilder getDepartureLocationOrBuilder() {
      return getDepartureLocation();
    }

    public static final int DEPARTURE_WAYPOINT_FIELD_NUMBER = 4;
    private com.google.cloud.optimization.v1.Waypoint departureWaypoint_;
    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
     * If the shipment model has duration distance matrices,
     * `departure_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
     *
     * @return Whether the departureWaypoint field is set.
     */
    @java.lang.Override
    public boolean hasDepartureWaypoint() {
      return departureWaypoint_ != null;
    }
    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
     * If the shipment model has duration distance matrices,
     * `departure_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
     *
     * @return The departureWaypoint.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Waypoint getDepartureWaypoint() {
      return departureWaypoint_ == null
          ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
          : departureWaypoint_;
    }
    /**
     *
     *
     * <pre>
     * The waypoint where the vehicle departs after completing this
     * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
     * If the shipment model has duration distance matrices,
     * `departure_waypoint` must not be specified.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.WaypointOrBuilder getDepartureWaypointOrBuilder() {
      return getDepartureWaypoint();
    }

    public static final int TAGS_FIELD_NUMBER = 5;
    private com.google.protobuf.LazyStringList tags_;
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the visit request.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the visit request.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the visit request.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies tags attached to the visit request.
     * Empty or duplicate strings are not allowed.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }

    public static final int TIME_WINDOWS_FIELD_NUMBER = 6;
    private java.util.List<com.google.cloud.optimization.v1.TimeWindow> timeWindows_;
    /**
     *
     *
     * <pre>
     * Time windows which constrain the arrival time at a visit.
     * Note that a vehicle may depart outside of the arrival time window, i.e.
     * arrival time + duration do not need to be inside a time window. This can
     * result in waiting time if the vehicle arrives before
     * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
     * The absence of `TimeWindow` means that the vehicle can perform this visit
     * at any time.
     * Time windows must be disjoint, i.e. no time window must overlap with or
     * be adjacent to another, and they must be in increasing order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
     * be set if there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.optimization.v1.TimeWindow> getTimeWindowsList() {
      return timeWindows_;
    }
    /**
     *
     *
     * <pre>
     * Time windows which constrain the arrival time at a visit.
     * Note that a vehicle may depart outside of the arrival time window, i.e.
     * arrival time + duration do not need to be inside a time window. This can
     * result in waiting time if the vehicle arrives before
     * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
     * The absence of `TimeWindow` means that the vehicle can perform this visit
     * at any time.
     * Time windows must be disjoint, i.e. no time window must overlap with or
     * be adjacent to another, and they must be in increasing order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
     * be set if there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.optimization.v1.TimeWindowOrBuilder>
        getTimeWindowsOrBuilderList() {
      return timeWindows_;
    }
    /**
     *
     *
     * <pre>
     * Time windows which constrain the arrival time at a visit.
     * Note that a vehicle may depart outside of the arrival time window, i.e.
     * arrival time + duration do not need to be inside a time window. This can
     * result in waiting time if the vehicle arrives before
     * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
     * The absence of `TimeWindow` means that the vehicle can perform this visit
     * at any time.
     * Time windows must be disjoint, i.e. no time window must overlap with or
     * be adjacent to another, and they must be in increasing order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
     * be set if there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
     */
    @java.lang.Override
    public int getTimeWindowsCount() {
      return timeWindows_.size();
    }
    /**
     *
     *
     * <pre>
     * Time windows which constrain the arrival time at a visit.
     * Note that a vehicle may depart outside of the arrival time window, i.e.
     * arrival time + duration do not need to be inside a time window. This can
     * result in waiting time if the vehicle arrives before
     * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
     * The absence of `TimeWindow` means that the vehicle can perform this visit
     * at any time.
     * Time windows must be disjoint, i.e. no time window must overlap with or
     * be adjacent to another, and they must be in increasing order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
     * be set if there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.TimeWindow getTimeWindows(int index) {
      return timeWindows_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Time windows which constrain the arrival time at a visit.
     * Note that a vehicle may depart outside of the arrival time window, i.e.
     * arrival time + duration do not need to be inside a time window. This can
     * result in waiting time if the vehicle arrives before
     * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
     * The absence of `TimeWindow` means that the vehicle can perform this visit
     * at any time.
     * Time windows must be disjoint, i.e. no time window must overlap with or
     * be adjacent to another, and they must be in increasing order.
     * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
     * be set if there is a single time window.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.TimeWindowOrBuilder getTimeWindowsOrBuilder(int index) {
      return timeWindows_.get(index);
    }

    public static final int DURATION_FIELD_NUMBER = 7;
    private com.google.protobuf.Duration duration_;
    /**
     *
     *
     * <pre>
     * Duration of the visit, i.e. time spent by the vehicle between arrival
     * and departure (to be added to the possible waiting time; see
     * `time_windows`).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 7;</code>
     *
     * @return Whether the duration field is set.
     */
    @java.lang.Override
    public boolean hasDuration() {
      return duration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Duration of the visit, i.e. time spent by the vehicle between arrival
     * and departure (to be added to the possible waiting time; see
     * `time_windows`).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 7;</code>
     *
     * @return The duration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getDuration() {
      return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
    }
    /**
     *
     *
     * <pre>
     * Duration of the visit, i.e. time spent by the vehicle between arrival
     * and departure (to be added to the possible waiting time; see
     * `time_windows`).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      return getDuration();
    }

    public static final int COST_FIELD_NUMBER = 8;
    private double cost_;
    /**
     *
     *
     * <pre>
     * Cost to service this visit request on a vehicle route. This can be used
     * to pay different costs for each alternative pickup or delivery of a
     * shipment. This cost must be in the same unit as `Shipment.penalty_cost`
     * and must not be negative.
     * </pre>
     *
     * <code>double cost = 8;</code>
     *
     * @return The cost.
     */
    @java.lang.Override
    public double getCost() {
      return cost_;
    }

    public static final int LOAD_DEMANDS_FIELD_NUMBER = 12;

    private static final class LoadDemandsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
                      newDefaultInstance(
                          com.google.cloud.optimization.v1.FleetRoutingProto
                              .internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_LoadDemandsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.optimization.v1.Shipment.Load.getDefaultInstance());
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        loadDemands_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        internalGetLoadDemands() {
      if (loadDemands_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            LoadDemandsDefaultEntryHolder.defaultEntry);
      }
      return loadDemands_;
    }

    public int getLoadDemandsCount() {
      return internalGetLoadDemands().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Load demands of this visit request. This is just like
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
     * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
     * The demands listed here are added to the demands listed in
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
     * </code>
     */
    @java.lang.Override
    public boolean containsLoadDemands(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLoadDemands().getMap().containsKey(key);
    }
    /** Use {@link #getLoadDemandsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        getLoadDemands() {
      return getLoadDemandsMap();
    }
    /**
     *
     *
     * <pre>
     * Load demands of this visit request. This is just like
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
     * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
     * The demands listed here are added to the demands listed in
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        getLoadDemandsMap() {
      return internalGetLoadDemands().getMap();
    }
    /**
     *
     *
     * <pre>
     * Load demands of this visit request. This is just like
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
     * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
     * The demands listed here are added to the demands listed in
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrDefault(
        java.lang.String key, com.google.cloud.optimization.v1.Shipment.Load defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
          internalGetLoadDemands().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Load demands of this visit request. This is just like
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
     * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
     * The demands listed here are added to the demands listed in
     * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
          internalGetLoadDemands().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int VISIT_TYPES_FIELD_NUMBER = 10;
    private com.google.protobuf.LazyStringList visitTypes_;
    /**
     *
     *
     * <pre>
     * Specifies the types of the visit. This may be used to allocate additional
     * time required for a vehicle to complete this visit (see
     * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
     * A type can only appear once.
     * </pre>
     *
     * <code>repeated string visit_types = 10;</code>
     *
     * @return A list containing the visitTypes.
     */
    public com.google.protobuf.ProtocolStringList getVisitTypesList() {
      return visitTypes_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the types of the visit. This may be used to allocate additional
     * time required for a vehicle to complete this visit (see
     * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
     * A type can only appear once.
     * </pre>
     *
     * <code>repeated string visit_types = 10;</code>
     *
     * @return The count of visitTypes.
     */
    public int getVisitTypesCount() {
      return visitTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies the types of the visit. This may be used to allocate additional
     * time required for a vehicle to complete this visit (see
     * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
     * A type can only appear once.
     * </pre>
     *
     * <code>repeated string visit_types = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The visitTypes at the given index.
     */
    public java.lang.String getVisitTypes(int index) {
      return visitTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies the types of the visit. This may be used to allocate additional
     * time required for a vehicle to complete this visit (see
     * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
     * A type can only appear once.
     * </pre>
     *
     * <code>repeated string visit_types = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the visitTypes at the given index.
     */
    public com.google.protobuf.ByteString getVisitTypesBytes(int index) {
      return visitTypes_.getByteString(index);
    }

    public static final int LABEL_FIELD_NUMBER = 11;
    private volatile java.lang.Object label_;
    /**
     *
     *
     * <pre>
     * Specifies a label for this `VisitRequest`. This label is reported in the
     * response as `visit_label` in the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
     * </pre>
     *
     * <code>string label = 11;</code>
     *
     * @return The label.
     */
    @java.lang.Override
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a label for this `VisitRequest`. This label is reported in the
     * response as `visit_label` in the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
     * </pre>
     *
     * <code>string label = 11;</code>
     *
     * @return The bytes for label.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEMANDS_FIELD_NUMBER = 9;
    private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> demands_;
    /**
     *
     *
     * <pre>
     * Deprecated: Use [VisitRequest.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getDemandsList() {
      return demands_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [VisitRequest.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getDemandsOrBuilderList() {
      return demands_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [VisitRequest.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getDemandsCount() {
      return demands_.size();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [VisitRequest.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity getDemands(int index) {
      return demands_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [VisitRequest.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getDemandsOrBuilder(
        int index) {
      return demands_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (arrivalLocation_ != null) {
        output.writeMessage(1, getArrivalLocation());
      }
      if (arrivalWaypoint_ != null) {
        output.writeMessage(2, getArrivalWaypoint());
      }
      if (departureLocation_ != null) {
        output.writeMessage(3, getDepartureLocation());
      }
      if (departureWaypoint_ != null) {
        output.writeMessage(4, getDepartureWaypoint());
      }
      for (int i = 0; i < tags_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, tags_.getRaw(i));
      }
      for (int i = 0; i < timeWindows_.size(); i++) {
        output.writeMessage(6, timeWindows_.get(i));
      }
      if (duration_ != null) {
        output.writeMessage(7, getDuration());
      }
      if (java.lang.Double.doubleToRawLongBits(cost_) != 0) {
        output.writeDouble(8, cost_);
      }
      for (int i = 0; i < demands_.size(); i++) {
        output.writeMessage(9, demands_.get(i));
      }
      for (int i = 0; i < visitTypes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 10, visitTypes_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 11, label_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetLoadDemands(), LoadDemandsDefaultEntryHolder.defaultEntry, 12);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (arrivalLocation_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getArrivalLocation());
      }
      if (arrivalWaypoint_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getArrivalWaypoint());
      }
      if (departureLocation_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDepartureLocation());
      }
      if (departureWaypoint_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDepartureWaypoint());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < tags_.size(); i++) {
          dataSize += computeStringSizeNoTag(tags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTagsList().size();
      }
      for (int i = 0; i < timeWindows_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, timeWindows_.get(i));
      }
      if (duration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDuration());
      }
      if (java.lang.Double.doubleToRawLongBits(cost_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(8, cost_);
      }
      for (int i = 0; i < demands_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, demands_.get(i));
      }
      {
        int dataSize = 0;
        for (int i = 0; i < visitTypes_.size(); i++) {
          dataSize += computeStringSizeNoTag(visitTypes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getVisitTypesList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, label_);
      }
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          entry : internalGetLoadDemands().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
            loadDemands__ =
                LoadDemandsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, loadDemands__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.Shipment.VisitRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.Shipment.VisitRequest other =
          (com.google.cloud.optimization.v1.Shipment.VisitRequest) obj;

      if (hasArrivalLocation() != other.hasArrivalLocation()) return false;
      if (hasArrivalLocation()) {
        if (!getArrivalLocation().equals(other.getArrivalLocation())) return false;
      }
      if (hasArrivalWaypoint() != other.hasArrivalWaypoint()) return false;
      if (hasArrivalWaypoint()) {
        if (!getArrivalWaypoint().equals(other.getArrivalWaypoint())) return false;
      }
      if (hasDepartureLocation() != other.hasDepartureLocation()) return false;
      if (hasDepartureLocation()) {
        if (!getDepartureLocation().equals(other.getDepartureLocation())) return false;
      }
      if (hasDepartureWaypoint() != other.hasDepartureWaypoint()) return false;
      if (hasDepartureWaypoint()) {
        if (!getDepartureWaypoint().equals(other.getDepartureWaypoint())) return false;
      }
      if (!getTagsList().equals(other.getTagsList())) return false;
      if (!getTimeWindowsList().equals(other.getTimeWindowsList())) return false;
      if (hasDuration() != other.hasDuration()) return false;
      if (hasDuration()) {
        if (!getDuration().equals(other.getDuration())) return false;
      }
      if (java.lang.Double.doubleToLongBits(getCost())
          != java.lang.Double.doubleToLongBits(other.getCost())) return false;
      if (!internalGetLoadDemands().equals(other.internalGetLoadDemands())) return false;
      if (!getVisitTypesList().equals(other.getVisitTypesList())) return false;
      if (!getLabel().equals(other.getLabel())) return false;
      if (!getDemandsList().equals(other.getDemandsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasArrivalLocation()) {
        hash = (37 * hash) + ARRIVAL_LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getArrivalLocation().hashCode();
      }
      if (hasArrivalWaypoint()) {
        hash = (37 * hash) + ARRIVAL_WAYPOINT_FIELD_NUMBER;
        hash = (53 * hash) + getArrivalWaypoint().hashCode();
      }
      if (hasDepartureLocation()) {
        hash = (37 * hash) + DEPARTURE_LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getDepartureLocation().hashCode();
      }
      if (hasDepartureWaypoint()) {
        hash = (37 * hash) + DEPARTURE_WAYPOINT_FIELD_NUMBER;
        hash = (53 * hash) + getDepartureWaypoint().hashCode();
      }
      if (getTagsCount() > 0) {
        hash = (37 * hash) + TAGS_FIELD_NUMBER;
        hash = (53 * hash) + getTagsList().hashCode();
      }
      if (getTimeWindowsCount() > 0) {
        hash = (37 * hash) + TIME_WINDOWS_FIELD_NUMBER;
        hash = (53 * hash) + getTimeWindowsList().hashCode();
      }
      if (hasDuration()) {
        hash = (37 * hash) + DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getDuration().hashCode();
      }
      hash = (37 * hash) + COST_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getCost()));
      if (!internalGetLoadDemands().getMap().isEmpty()) {
        hash = (37 * hash) + LOAD_DEMANDS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetLoadDemands().hashCode();
      }
      if (getVisitTypesCount() > 0) {
        hash = (37 * hash) + VISIT_TYPES_FIELD_NUMBER;
        hash = (53 * hash) + getVisitTypesList().hashCode();
      }
      hash = (37 * hash) + LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getLabel().hashCode();
      if (getDemandsCount() > 0) {
        hash = (37 * hash) + DEMANDS_FIELD_NUMBER;
        hash = (53 * hash) + getDemandsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.Shipment.VisitRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request for a visit which can be done by a vehicle: it has a geo-location
     * (or two, see below), opening and closing times represented by time windows,
     * and a service duration time (time spent by the vehicle once it has arrived
     * to pickup or drop off goods).
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.Shipment.VisitRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.Shipment.VisitRequest)
        com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 12:
            return internalGetLoadDemands();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 12:
            return internalGetMutableLoadDemands();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.Shipment.VisitRequest.class,
                com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.Shipment.VisitRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (arrivalLocationBuilder_ == null) {
          arrivalLocation_ = null;
        } else {
          arrivalLocation_ = null;
          arrivalLocationBuilder_ = null;
        }
        if (arrivalWaypointBuilder_ == null) {
          arrivalWaypoint_ = null;
        } else {
          arrivalWaypoint_ = null;
          arrivalWaypointBuilder_ = null;
        }
        if (departureLocationBuilder_ == null) {
          departureLocation_ = null;
        } else {
          departureLocation_ = null;
          departureLocationBuilder_ = null;
        }
        if (departureWaypointBuilder_ == null) {
          departureWaypoint_ = null;
        } else {
          departureWaypoint_ = null;
          departureWaypointBuilder_ = null;
        }
        tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (timeWindowsBuilder_ == null) {
          timeWindows_ = java.util.Collections.emptyList();
        } else {
          timeWindows_ = null;
          timeWindowsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (durationBuilder_ == null) {
          duration_ = null;
        } else {
          duration_ = null;
          durationBuilder_ = null;
        }
        cost_ = 0D;

        internalGetMutableLoadDemands().clear();
        visitTypes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        label_ = "";

        if (demandsBuilder_ == null) {
          demands_ = java.util.Collections.emptyList();
        } else {
          demands_ = null;
          demandsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Shipment_VisitRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Shipment.VisitRequest getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.Shipment.VisitRequest.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Shipment.VisitRequest build() {
        com.google.cloud.optimization.v1.Shipment.VisitRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Shipment.VisitRequest buildPartial() {
        com.google.cloud.optimization.v1.Shipment.VisitRequest result =
            new com.google.cloud.optimization.v1.Shipment.VisitRequest(this);
        int from_bitField0_ = bitField0_;
        if (arrivalLocationBuilder_ == null) {
          result.arrivalLocation_ = arrivalLocation_;
        } else {
          result.arrivalLocation_ = arrivalLocationBuilder_.build();
        }
        if (arrivalWaypointBuilder_ == null) {
          result.arrivalWaypoint_ = arrivalWaypoint_;
        } else {
          result.arrivalWaypoint_ = arrivalWaypointBuilder_.build();
        }
        if (departureLocationBuilder_ == null) {
          result.departureLocation_ = departureLocation_;
        } else {
          result.departureLocation_ = departureLocationBuilder_.build();
        }
        if (departureWaypointBuilder_ == null) {
          result.departureWaypoint_ = departureWaypoint_;
        } else {
          result.departureWaypoint_ = departureWaypointBuilder_.build();
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          tags_ = tags_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.tags_ = tags_;
        if (timeWindowsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            timeWindows_ = java.util.Collections.unmodifiableList(timeWindows_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.timeWindows_ = timeWindows_;
        } else {
          result.timeWindows_ = timeWindowsBuilder_.build();
        }
        if (durationBuilder_ == null) {
          result.duration_ = duration_;
        } else {
          result.duration_ = durationBuilder_.build();
        }
        result.cost_ = cost_;
        result.loadDemands_ = internalGetLoadDemands();
        result.loadDemands_.makeImmutable();
        if (((bitField0_ & 0x00000008) != 0)) {
          visitTypes_ = visitTypes_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.visitTypes_ = visitTypes_;
        result.label_ = label_;
        if (demandsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            demands_ = java.util.Collections.unmodifiableList(demands_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.demands_ = demands_;
        } else {
          result.demands_ = demandsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.Shipment.VisitRequest) {
          return mergeFrom((com.google.cloud.optimization.v1.Shipment.VisitRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.Shipment.VisitRequest other) {
        if (other == com.google.cloud.optimization.v1.Shipment.VisitRequest.getDefaultInstance())
          return this;
        if (other.hasArrivalLocation()) {
          mergeArrivalLocation(other.getArrivalLocation());
        }
        if (other.hasArrivalWaypoint()) {
          mergeArrivalWaypoint(other.getArrivalWaypoint());
        }
        if (other.hasDepartureLocation()) {
          mergeDepartureLocation(other.getDepartureLocation());
        }
        if (other.hasDepartureWaypoint()) {
          mergeDepartureWaypoint(other.getDepartureWaypoint());
        }
        if (!other.tags_.isEmpty()) {
          if (tags_.isEmpty()) {
            tags_ = other.tags_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTagsIsMutable();
            tags_.addAll(other.tags_);
          }
          onChanged();
        }
        if (timeWindowsBuilder_ == null) {
          if (!other.timeWindows_.isEmpty()) {
            if (timeWindows_.isEmpty()) {
              timeWindows_ = other.timeWindows_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureTimeWindowsIsMutable();
              timeWindows_.addAll(other.timeWindows_);
            }
            onChanged();
          }
        } else {
          if (!other.timeWindows_.isEmpty()) {
            if (timeWindowsBuilder_.isEmpty()) {
              timeWindowsBuilder_.dispose();
              timeWindowsBuilder_ = null;
              timeWindows_ = other.timeWindows_;
              bitField0_ = (bitField0_ & ~0x00000002);
              timeWindowsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTimeWindowsFieldBuilder()
                      : null;
            } else {
              timeWindowsBuilder_.addAllMessages(other.timeWindows_);
            }
          }
        }
        if (other.hasDuration()) {
          mergeDuration(other.getDuration());
        }
        if (other.getCost() != 0D) {
          setCost(other.getCost());
        }
        internalGetMutableLoadDemands().mergeFrom(other.internalGetLoadDemands());
        if (!other.visitTypes_.isEmpty()) {
          if (visitTypes_.isEmpty()) {
            visitTypes_ = other.visitTypes_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureVisitTypesIsMutable();
            visitTypes_.addAll(other.visitTypes_);
          }
          onChanged();
        }
        if (!other.getLabel().isEmpty()) {
          label_ = other.label_;
          onChanged();
        }
        if (demandsBuilder_ == null) {
          if (!other.demands_.isEmpty()) {
            if (demands_.isEmpty()) {
              demands_ = other.demands_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureDemandsIsMutable();
              demands_.addAll(other.demands_);
            }
            onChanged();
          }
        } else {
          if (!other.demands_.isEmpty()) {
            if (demandsBuilder_.isEmpty()) {
              demandsBuilder_.dispose();
              demandsBuilder_ = null;
              demands_ = other.demands_;
              bitField0_ = (bitField0_ & ~0x00000010);
              demandsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDemandsFieldBuilder()
                      : null;
            } else {
              demandsBuilder_.addAllMessages(other.demands_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getArrivalLocationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getArrivalWaypointFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getDepartureLocationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getDepartureWaypointFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 34
              case 42:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTagsIsMutable();
                  tags_.add(s);
                  break;
                } // case 42
              case 50:
                {
                  com.google.cloud.optimization.v1.TimeWindow m =
                      input.readMessage(
                          com.google.cloud.optimization.v1.TimeWindow.parser(), extensionRegistry);
                  if (timeWindowsBuilder_ == null) {
                    ensureTimeWindowsIsMutable();
                    timeWindows_.add(m);
                  } else {
                    timeWindowsBuilder_.addMessage(m);
                  }
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 58
              case 65:
                {
                  cost_ = input.readDouble();

                  break;
                } // case 65
              case 74:
                {
                  com.google.cloud.optimization.v1.CapacityQuantity m =
                      input.readMessage(
                          com.google.cloud.optimization.v1.CapacityQuantity.parser(),
                          extensionRegistry);
                  if (demandsBuilder_ == null) {
                    ensureDemandsIsMutable();
                    demands_.add(m);
                  } else {
                    demandsBuilder_.addMessage(m);
                  }
                  break;
                } // case 74
              case 82:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureVisitTypesIsMutable();
                  visitTypes_.add(s);
                  break;
                } // case 82
              case 90:
                {
                  label_ = input.readStringRequireUtf8();

                  break;
                } // case 90
              case 98:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
                      loadDemands__ =
                          input.readMessage(
                              LoadDemandsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableLoadDemands()
                      .getMutableMap()
                      .put(loadDemands__.getKey(), loadDemands__.getValue());
                  break;
                } // case 98
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.type.LatLng arrivalLocation_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LatLng,
              com.google.type.LatLng.Builder,
              com.google.type.LatLngOrBuilder>
          arrivalLocationBuilder_;
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng arrival_location = 1;</code>
       *
       * @return Whether the arrivalLocation field is set.
       */
      public boolean hasArrivalLocation() {
        return arrivalLocationBuilder_ != null || arrivalLocation_ != null;
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng arrival_location = 1;</code>
       *
       * @return The arrivalLocation.
       */
      public com.google.type.LatLng getArrivalLocation() {
        if (arrivalLocationBuilder_ == null) {
          return arrivalLocation_ == null
              ? com.google.type.LatLng.getDefaultInstance()
              : arrivalLocation_;
        } else {
          return arrivalLocationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng arrival_location = 1;</code>
       */
      public Builder setArrivalLocation(com.google.type.LatLng value) {
        if (arrivalLocationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          arrivalLocation_ = value;
          onChanged();
        } else {
          arrivalLocationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng arrival_location = 1;</code>
       */
      public Builder setArrivalLocation(com.google.type.LatLng.Builder builderForValue) {
        if (arrivalLocationBuilder_ == null) {
          arrivalLocation_ = builderForValue.build();
          onChanged();
        } else {
          arrivalLocationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng arrival_location = 1;</code>
       */
      public Builder mergeArrivalLocation(com.google.type.LatLng value) {
        if (arrivalLocationBuilder_ == null) {
          if (arrivalLocation_ != null) {
            arrivalLocation_ =
                com.google.type.LatLng.newBuilder(arrivalLocation_).mergeFrom(value).buildPartial();
          } else {
            arrivalLocation_ = value;
          }
          onChanged();
        } else {
          arrivalLocationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng arrival_location = 1;</code>
       */
      public Builder clearArrivalLocation() {
        if (arrivalLocationBuilder_ == null) {
          arrivalLocation_ = null;
          onChanged();
        } else {
          arrivalLocation_ = null;
          arrivalLocationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng arrival_location = 1;</code>
       */
      public com.google.type.LatLng.Builder getArrivalLocationBuilder() {

        onChanged();
        return getArrivalLocationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng arrival_location = 1;</code>
       */
      public com.google.type.LatLngOrBuilder getArrivalLocationOrBuilder() {
        if (arrivalLocationBuilder_ != null) {
          return arrivalLocationBuilder_.getMessageOrBuilder();
        } else {
          return arrivalLocation_ == null
              ? com.google.type.LatLng.getDefaultInstance()
              : arrivalLocation_;
        }
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng arrival_location = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LatLng,
              com.google.type.LatLng.Builder,
              com.google.type.LatLngOrBuilder>
          getArrivalLocationFieldBuilder() {
        if (arrivalLocationBuilder_ == null) {
          arrivalLocationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.LatLng,
                  com.google.type.LatLng.Builder,
                  com.google.type.LatLngOrBuilder>(
                  getArrivalLocation(), getParentForChildren(), isClean());
          arrivalLocation_ = null;
        }
        return arrivalLocationBuilder_;
      }

      private com.google.cloud.optimization.v1.Waypoint arrivalWaypoint_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.Waypoint,
              com.google.cloud.optimization.v1.Waypoint.Builder,
              com.google.cloud.optimization.v1.WaypointOrBuilder>
          arrivalWaypointBuilder_;
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
       *
       * @return Whether the arrivalWaypoint field is set.
       */
      public boolean hasArrivalWaypoint() {
        return arrivalWaypointBuilder_ != null || arrivalWaypoint_ != null;
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
       *
       * @return The arrivalWaypoint.
       */
      public com.google.cloud.optimization.v1.Waypoint getArrivalWaypoint() {
        if (arrivalWaypointBuilder_ == null) {
          return arrivalWaypoint_ == null
              ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
              : arrivalWaypoint_;
        } else {
          return arrivalWaypointBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
       */
      public Builder setArrivalWaypoint(com.google.cloud.optimization.v1.Waypoint value) {
        if (arrivalWaypointBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          arrivalWaypoint_ = value;
          onChanged();
        } else {
          arrivalWaypointBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
       */
      public Builder setArrivalWaypoint(
          com.google.cloud.optimization.v1.Waypoint.Builder builderForValue) {
        if (arrivalWaypointBuilder_ == null) {
          arrivalWaypoint_ = builderForValue.build();
          onChanged();
        } else {
          arrivalWaypointBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
       */
      public Builder mergeArrivalWaypoint(com.google.cloud.optimization.v1.Waypoint value) {
        if (arrivalWaypointBuilder_ == null) {
          if (arrivalWaypoint_ != null) {
            arrivalWaypoint_ =
                com.google.cloud.optimization.v1.Waypoint.newBuilder(arrivalWaypoint_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            arrivalWaypoint_ = value;
          }
          onChanged();
        } else {
          arrivalWaypointBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
       */
      public Builder clearArrivalWaypoint() {
        if (arrivalWaypointBuilder_ == null) {
          arrivalWaypoint_ = null;
          onChanged();
        } else {
          arrivalWaypoint_ = null;
          arrivalWaypointBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
       */
      public com.google.cloud.optimization.v1.Waypoint.Builder getArrivalWaypointBuilder() {

        onChanged();
        return getArrivalWaypointFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
       */
      public com.google.cloud.optimization.v1.WaypointOrBuilder getArrivalWaypointOrBuilder() {
        if (arrivalWaypointBuilder_ != null) {
          return arrivalWaypointBuilder_.getMessageOrBuilder();
        } else {
          return arrivalWaypoint_ == null
              ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
              : arrivalWaypoint_;
        }
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle arrives when performing this
       * `VisitRequest`. If the shipment model has duration distance matrices,
       * `arrival_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint arrival_waypoint = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.Waypoint,
              com.google.cloud.optimization.v1.Waypoint.Builder,
              com.google.cloud.optimization.v1.WaypointOrBuilder>
          getArrivalWaypointFieldBuilder() {
        if (arrivalWaypointBuilder_ == null) {
          arrivalWaypointBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.optimization.v1.Waypoint,
                  com.google.cloud.optimization.v1.Waypoint.Builder,
                  com.google.cloud.optimization.v1.WaypointOrBuilder>(
                  getArrivalWaypoint(), getParentForChildren(), isClean());
          arrivalWaypoint_ = null;
        }
        return arrivalWaypointBuilder_;
      }

      private com.google.type.LatLng departureLocation_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LatLng,
              com.google.type.LatLng.Builder,
              com.google.type.LatLngOrBuilder>
          departureLocationBuilder_;
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
       * If the shipment model has duration distance matrices,
       * `departure_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng departure_location = 3;</code>
       *
       * @return Whether the departureLocation field is set.
       */
      public boolean hasDepartureLocation() {
        return departureLocationBuilder_ != null || departureLocation_ != null;
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
       * If the shipment model has duration distance matrices,
       * `departure_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng departure_location = 3;</code>
       *
       * @return The departureLocation.
       */
      public com.google.type.LatLng getDepartureLocation() {
        if (departureLocationBuilder_ == null) {
          return departureLocation_ == null
              ? com.google.type.LatLng.getDefaultInstance()
              : departureLocation_;
        } else {
          return departureLocationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
       * If the shipment model has duration distance matrices,
       * `departure_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng departure_location = 3;</code>
       */
      public Builder setDepartureLocation(com.google.type.LatLng value) {
        if (departureLocationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          departureLocation_ = value;
          onChanged();
        } else {
          departureLocationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
       * If the shipment model has duration distance matrices,
       * `departure_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng departure_location = 3;</code>
       */
      public Builder setDepartureLocation(com.google.type.LatLng.Builder builderForValue) {
        if (departureLocationBuilder_ == null) {
          departureLocation_ = builderForValue.build();
          onChanged();
        } else {
          departureLocationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
       * If the shipment model has duration distance matrices,
       * `departure_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng departure_location = 3;</code>
       */
      public Builder mergeDepartureLocation(com.google.type.LatLng value) {
        if (departureLocationBuilder_ == null) {
          if (departureLocation_ != null) {
            departureLocation_ =
                com.google.type.LatLng.newBuilder(departureLocation_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            departureLocation_ = value;
          }
          onChanged();
        } else {
          departureLocationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
       * If the shipment model has duration distance matrices,
       * `departure_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng departure_location = 3;</code>
       */
      public Builder clearDepartureLocation() {
        if (departureLocationBuilder_ == null) {
          departureLocation_ = null;
          onChanged();
        } else {
          departureLocation_ = null;
          departureLocationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
       * If the shipment model has duration distance matrices,
       * `departure_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng departure_location = 3;</code>
       */
      public com.google.type.LatLng.Builder getDepartureLocationBuilder() {

        onChanged();
        return getDepartureLocationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
       * If the shipment model has duration distance matrices,
       * `departure_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng departure_location = 3;</code>
       */
      public com.google.type.LatLngOrBuilder getDepartureLocationOrBuilder() {
        if (departureLocationBuilder_ != null) {
          return departureLocationBuilder_.getMessageOrBuilder();
        } else {
          return departureLocation_ == null
              ? com.google.type.LatLng.getDefaultInstance()
              : departureLocation_;
        }
      }
      /**
       *
       *
       * <pre>
       * The geo-location where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
       * If the shipment model has duration distance matrices,
       * `departure_location` must not be specified.
       * </pre>
       *
       * <code>.google.type.LatLng departure_location = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LatLng,
              com.google.type.LatLng.Builder,
              com.google.type.LatLngOrBuilder>
          getDepartureLocationFieldBuilder() {
        if (departureLocationBuilder_ == null) {
          departureLocationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.LatLng,
                  com.google.type.LatLng.Builder,
                  com.google.type.LatLngOrBuilder>(
                  getDepartureLocation(), getParentForChildren(), isClean());
          departureLocation_ = null;
        }
        return departureLocationBuilder_;
      }

      private com.google.cloud.optimization.v1.Waypoint departureWaypoint_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.Waypoint,
              com.google.cloud.optimization.v1.Waypoint.Builder,
              com.google.cloud.optimization.v1.WaypointOrBuilder>
          departureWaypointBuilder_;
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
       * If the shipment model has duration distance matrices,
       * `departure_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
       *
       * @return Whether the departureWaypoint field is set.
       */
      public boolean hasDepartureWaypoint() {
        return departureWaypointBuilder_ != null || departureWaypoint_ != null;
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
       * If the shipment model has duration distance matrices,
       * `departure_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
       *
       * @return The departureWaypoint.
       */
      public com.google.cloud.optimization.v1.Waypoint getDepartureWaypoint() {
        if (departureWaypointBuilder_ == null) {
          return departureWaypoint_ == null
              ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
              : departureWaypoint_;
        } else {
          return departureWaypointBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
       * If the shipment model has duration distance matrices,
       * `departure_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
       */
      public Builder setDepartureWaypoint(com.google.cloud.optimization.v1.Waypoint value) {
        if (departureWaypointBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          departureWaypoint_ = value;
          onChanged();
        } else {
          departureWaypointBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
       * If the shipment model has duration distance matrices,
       * `departure_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
       */
      public Builder setDepartureWaypoint(
          com.google.cloud.optimization.v1.Waypoint.Builder builderForValue) {
        if (departureWaypointBuilder_ == null) {
          departureWaypoint_ = builderForValue.build();
          onChanged();
        } else {
          departureWaypointBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
       * If the shipment model has duration distance matrices,
       * `departure_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
       */
      public Builder mergeDepartureWaypoint(com.google.cloud.optimization.v1.Waypoint value) {
        if (departureWaypointBuilder_ == null) {
          if (departureWaypoint_ != null) {
            departureWaypoint_ =
                com.google.cloud.optimization.v1.Waypoint.newBuilder(departureWaypoint_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            departureWaypoint_ = value;
          }
          onChanged();
        } else {
          departureWaypointBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
       * If the shipment model has duration distance matrices,
       * `departure_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
       */
      public Builder clearDepartureWaypoint() {
        if (departureWaypointBuilder_ == null) {
          departureWaypoint_ = null;
          onChanged();
        } else {
          departureWaypoint_ = null;
          departureWaypointBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
       * If the shipment model has duration distance matrices,
       * `departure_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
       */
      public com.google.cloud.optimization.v1.Waypoint.Builder getDepartureWaypointBuilder() {

        onChanged();
        return getDepartureWaypointFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
       * If the shipment model has duration distance matrices,
       * `departure_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
       */
      public com.google.cloud.optimization.v1.WaypointOrBuilder getDepartureWaypointOrBuilder() {
        if (departureWaypointBuilder_ != null) {
          return departureWaypointBuilder_.getMessageOrBuilder();
        } else {
          return departureWaypoint_ == null
              ? com.google.cloud.optimization.v1.Waypoint.getDefaultInstance()
              : departureWaypoint_;
        }
      }
      /**
       *
       *
       * <pre>
       * The waypoint where the vehicle departs after completing this
       * `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
       * If the shipment model has duration distance matrices,
       * `departure_waypoint` must not be specified.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.Waypoint departure_waypoint = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.Waypoint,
              com.google.cloud.optimization.v1.Waypoint.Builder,
              com.google.cloud.optimization.v1.WaypointOrBuilder>
          getDepartureWaypointFieldBuilder() {
        if (departureWaypointBuilder_ == null) {
          departureWaypointBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.optimization.v1.Waypoint,
                  com.google.cloud.optimization.v1.Waypoint.Builder,
                  com.google.cloud.optimization.v1.WaypointOrBuilder>(
                  getDepartureWaypoint(), getParentForChildren(), isClean());
          departureWaypoint_ = null;
        }
        return departureWaypointBuilder_;
      }

      private com.google.protobuf.LazyStringList tags_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureTagsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies tags attached to the visit request.
       * Empty or duplicate strings are not allowed.
       * </pre>
       *
       * <code>repeated string tags = 5;</code>
       *
       * @return A list containing the tags.
       */
      public com.google.protobuf.ProtocolStringList getTagsList() {
        return tags_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Specifies tags attached to the visit request.
       * Empty or duplicate strings are not allowed.
       * </pre>
       *
       * <code>repeated string tags = 5;</code>
       *
       * @return The count of tags.
       */
      public int getTagsCount() {
        return tags_.size();
      }
      /**
       *
       *
       * <pre>
       * Specifies tags attached to the visit request.
       * Empty or duplicate strings are not allowed.
       * </pre>
       *
       * <code>repeated string tags = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The tags at the given index.
       */
      public java.lang.String getTags(int index) {
        return tags_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies tags attached to the visit request.
       * Empty or duplicate strings are not allowed.
       * </pre>
       *
       * <code>repeated string tags = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the tags at the given index.
       */
      public com.google.protobuf.ByteString getTagsBytes(int index) {
        return tags_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies tags attached to the visit request.
       * Empty or duplicate strings are not allowed.
       * </pre>
       *
       * <code>repeated string tags = 5;</code>
       *
       * @param index The index to set the value at.
       * @param value The tags to set.
       * @return This builder for chaining.
       */
      public Builder setTags(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies tags attached to the visit request.
       * Empty or duplicate strings are not allowed.
       * </pre>
       *
       * <code>repeated string tags = 5;</code>
       *
       * @param value The tags to add.
       * @return This builder for chaining.
       */
      public Builder addTags(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies tags attached to the visit request.
       * Empty or duplicate strings are not allowed.
       * </pre>
       *
       * <code>repeated string tags = 5;</code>
       *
       * @param values The tags to add.
       * @return This builder for chaining.
       */
      public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
        ensureTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies tags attached to the visit request.
       * Empty or duplicate strings are not allowed.
       * </pre>
       *
       * <code>repeated string tags = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTags() {
        tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies tags attached to the visit request.
       * Empty or duplicate strings are not allowed.
       * </pre>
       *
       * <code>repeated string tags = 5;</code>
       *
       * @param value The bytes of the tags to add.
       * @return This builder for chaining.
       */
      public Builder addTagsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTagsIsMutable();
        tags_.add(value);
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.optimization.v1.TimeWindow> timeWindows_ =
          java.util.Collections.emptyList();

      private void ensureTimeWindowsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          timeWindows_ =
              new java.util.ArrayList<com.google.cloud.optimization.v1.TimeWindow>(timeWindows_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.TimeWindow,
              com.google.cloud.optimization.v1.TimeWindow.Builder,
              com.google.cloud.optimization.v1.TimeWindowOrBuilder>
          timeWindowsBuilder_;

      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public java.util.List<com.google.cloud.optimization.v1.TimeWindow> getTimeWindowsList() {
        if (timeWindowsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(timeWindows_);
        } else {
          return timeWindowsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public int getTimeWindowsCount() {
        if (timeWindowsBuilder_ == null) {
          return timeWindows_.size();
        } else {
          return timeWindowsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public com.google.cloud.optimization.v1.TimeWindow getTimeWindows(int index) {
        if (timeWindowsBuilder_ == null) {
          return timeWindows_.get(index);
        } else {
          return timeWindowsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public Builder setTimeWindows(int index, com.google.cloud.optimization.v1.TimeWindow value) {
        if (timeWindowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTimeWindowsIsMutable();
          timeWindows_.set(index, value);
          onChanged();
        } else {
          timeWindowsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public Builder setTimeWindows(
          int index, com.google.cloud.optimization.v1.TimeWindow.Builder builderForValue) {
        if (timeWindowsBuilder_ == null) {
          ensureTimeWindowsIsMutable();
          timeWindows_.set(index, builderForValue.build());
          onChanged();
        } else {
          timeWindowsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public Builder addTimeWindows(com.google.cloud.optimization.v1.TimeWindow value) {
        if (timeWindowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTimeWindowsIsMutable();
          timeWindows_.add(value);
          onChanged();
        } else {
          timeWindowsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public Builder addTimeWindows(int index, com.google.cloud.optimization.v1.TimeWindow value) {
        if (timeWindowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTimeWindowsIsMutable();
          timeWindows_.add(index, value);
          onChanged();
        } else {
          timeWindowsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public Builder addTimeWindows(
          com.google.cloud.optimization.v1.TimeWindow.Builder builderForValue) {
        if (timeWindowsBuilder_ == null) {
          ensureTimeWindowsIsMutable();
          timeWindows_.add(builderForValue.build());
          onChanged();
        } else {
          timeWindowsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public Builder addTimeWindows(
          int index, com.google.cloud.optimization.v1.TimeWindow.Builder builderForValue) {
        if (timeWindowsBuilder_ == null) {
          ensureTimeWindowsIsMutable();
          timeWindows_.add(index, builderForValue.build());
          onChanged();
        } else {
          timeWindowsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public Builder addAllTimeWindows(
          java.lang.Iterable<? extends com.google.cloud.optimization.v1.TimeWindow> values) {
        if (timeWindowsBuilder_ == null) {
          ensureTimeWindowsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, timeWindows_);
          onChanged();
        } else {
          timeWindowsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public Builder clearTimeWindows() {
        if (timeWindowsBuilder_ == null) {
          timeWindows_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          timeWindowsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public Builder removeTimeWindows(int index) {
        if (timeWindowsBuilder_ == null) {
          ensureTimeWindowsIsMutable();
          timeWindows_.remove(index);
          onChanged();
        } else {
          timeWindowsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public com.google.cloud.optimization.v1.TimeWindow.Builder getTimeWindowsBuilder(int index) {
        return getTimeWindowsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public com.google.cloud.optimization.v1.TimeWindowOrBuilder getTimeWindowsOrBuilder(
          int index) {
        if (timeWindowsBuilder_ == null) {
          return timeWindows_.get(index);
        } else {
          return timeWindowsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public java.util.List<? extends com.google.cloud.optimization.v1.TimeWindowOrBuilder>
          getTimeWindowsOrBuilderList() {
        if (timeWindowsBuilder_ != null) {
          return timeWindowsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(timeWindows_);
        }
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public com.google.cloud.optimization.v1.TimeWindow.Builder addTimeWindowsBuilder() {
        return getTimeWindowsFieldBuilder()
            .addBuilder(com.google.cloud.optimization.v1.TimeWindow.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public com.google.cloud.optimization.v1.TimeWindow.Builder addTimeWindowsBuilder(int index) {
        return getTimeWindowsFieldBuilder()
            .addBuilder(index, com.google.cloud.optimization.v1.TimeWindow.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Time windows which constrain the arrival time at a visit.
       * Note that a vehicle may depart outside of the arrival time window, i.e.
       * arrival time + duration do not need to be inside a time window. This can
       * result in waiting time if the vehicle arrives before
       * [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
       * The absence of `TimeWindow` means that the vehicle can perform this visit
       * at any time.
       * Time windows must be disjoint, i.e. no time window must overlap with or
       * be adjacent to another, and they must be in increasing order.
       * `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
       * be set if there is a single time window.
       * </pre>
       *
       * <code>repeated .google.cloud.optimization.v1.TimeWindow time_windows = 6;</code>
       */
      public java.util.List<com.google.cloud.optimization.v1.TimeWindow.Builder>
          getTimeWindowsBuilderList() {
        return getTimeWindowsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.TimeWindow,
              com.google.cloud.optimization.v1.TimeWindow.Builder,
              com.google.cloud.optimization.v1.TimeWindowOrBuilder>
          getTimeWindowsFieldBuilder() {
        if (timeWindowsBuilder_ == null) {
          timeWindowsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.optimization.v1.TimeWindow,
                  com.google.cloud.optimization.v1.TimeWindow.Builder,
                  com.google.cloud.optimization.v1.TimeWindowOrBuilder>(
                  timeWindows_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          timeWindows_ = null;
        }
        return timeWindowsBuilder_;
      }

      private com.google.protobuf.Duration duration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          durationBuilder_;
      /**
       *
       *
       * <pre>
       * Duration of the visit, i.e. time spent by the vehicle between arrival
       * and departure (to be added to the possible waiting time; see
       * `time_windows`).
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 7;</code>
       *
       * @return Whether the duration field is set.
       */
      public boolean hasDuration() {
        return durationBuilder_ != null || duration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Duration of the visit, i.e. time spent by the vehicle between arrival
       * and departure (to be added to the possible waiting time; see
       * `time_windows`).
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 7;</code>
       *
       * @return The duration.
       */
      public com.google.protobuf.Duration getDuration() {
        if (durationBuilder_ == null) {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        } else {
          return durationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of the visit, i.e. time spent by the vehicle between arrival
       * and departure (to be added to the possible waiting time; see
       * `time_windows`).
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 7;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          duration_ = value;
          onChanged();
        } else {
          durationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the visit, i.e. time spent by the vehicle between arrival
       * and departure (to be added to the possible waiting time; see
       * `time_windows`).
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 7;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (durationBuilder_ == null) {
          duration_ = builderForValue.build();
          onChanged();
        } else {
          durationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the visit, i.e. time spent by the vehicle between arrival
       * and departure (to be added to the possible waiting time; see
       * `time_windows`).
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 7;</code>
       */
      public Builder mergeDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (duration_ != null) {
            duration_ =
                com.google.protobuf.Duration.newBuilder(duration_).mergeFrom(value).buildPartial();
          } else {
            duration_ = value;
          }
          onChanged();
        } else {
          durationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the visit, i.e. time spent by the vehicle between arrival
       * and departure (to be added to the possible waiting time; see
       * `time_windows`).
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 7;</code>
       */
      public Builder clearDuration() {
        if (durationBuilder_ == null) {
          duration_ = null;
          onChanged();
        } else {
          duration_ = null;
          durationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the visit, i.e. time spent by the vehicle between arrival
       * and departure (to be added to the possible waiting time; see
       * `time_windows`).
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 7;</code>
       */
      public com.google.protobuf.Duration.Builder getDurationBuilder() {

        onChanged();
        return getDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration of the visit, i.e. time spent by the vehicle between arrival
       * and departure (to be added to the possible waiting time; see
       * `time_windows`).
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 7;</code>
       */
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        if (durationBuilder_ != null) {
          return durationBuilder_.getMessageOrBuilder();
        } else {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of the visit, i.e. time spent by the vehicle between arrival
       * and departure (to be added to the possible waiting time; see
       * `time_windows`).
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getDurationFieldBuilder() {
        if (durationBuilder_ == null) {
          durationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getDuration(), getParentForChildren(), isClean());
          duration_ = null;
        }
        return durationBuilder_;
      }

      private double cost_;
      /**
       *
       *
       * <pre>
       * Cost to service this visit request on a vehicle route. This can be used
       * to pay different costs for each alternative pickup or delivery of a
       * shipment. This cost must be in the same unit as `Shipment.penalty_cost`
       * and must not be negative.
       * </pre>
       *
       * <code>double cost = 8;</code>
       *
       * @return The cost.
       */
      @java.lang.Override
      public double getCost() {
        return cost_;
      }
      /**
       *
       *
       * <pre>
       * Cost to service this visit request on a vehicle route. This can be used
       * to pay different costs for each alternative pickup or delivery of a
       * shipment. This cost must be in the same unit as `Shipment.penalty_cost`
       * and must not be negative.
       * </pre>
       *
       * <code>double cost = 8;</code>
       *
       * @param value The cost to set.
       * @return This builder for chaining.
       */
      public Builder setCost(double value) {

        cost_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cost to service this visit request on a vehicle route. This can be used
       * to pay different costs for each alternative pickup or delivery of a
       * shipment. This cost must be in the same unit as `Shipment.penalty_cost`
       * and must not be negative.
       * </pre>
       *
       * <code>double cost = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCost() {

        cost_ = 0D;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          loadDemands_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          internalGetLoadDemands() {
        if (loadDemands_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              LoadDemandsDefaultEntryHolder.defaultEntry);
        }
        return loadDemands_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          internalGetMutableLoadDemands() {
        onChanged();
        ;
        if (loadDemands_ == null) {
          loadDemands_ =
              com.google.protobuf.MapField.newMapField(LoadDemandsDefaultEntryHolder.defaultEntry);
        }
        if (!loadDemands_.isMutable()) {
          loadDemands_ = loadDemands_.copy();
        }
        return loadDemands_;
      }

      public int getLoadDemandsCount() {
        return internalGetLoadDemands().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Load demands of this visit request. This is just like
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
       * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
       * The demands listed here are added to the demands listed in
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
       * </code>
       */
      @java.lang.Override
      public boolean containsLoadDemands(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetLoadDemands().getMap().containsKey(key);
      }
      /** Use {@link #getLoadDemandsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          getLoadDemands() {
        return getLoadDemandsMap();
      }
      /**
       *
       *
       * <pre>
       * Load demands of this visit request. This is just like
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
       * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
       * The demands listed here are added to the demands listed in
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          getLoadDemandsMap() {
        return internalGetLoadDemands().getMap();
      }
      /**
       *
       *
       * <pre>
       * Load demands of this visit request. This is just like
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
       * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
       * The demands listed here are added to the demands listed in
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrDefault(
          java.lang.String key, com.google.cloud.optimization.v1.Shipment.Load defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
            internalGetLoadDemands().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Load demands of this visit request. This is just like
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
       * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
       * The demands listed here are added to the demands listed in
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
            internalGetLoadDemands().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearLoadDemands() {
        internalGetMutableLoadDemands().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Load demands of this visit request. This is just like
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
       * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
       * The demands listed here are added to the demands listed in
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
       * </code>
       */
      public Builder removeLoadDemands(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableLoadDemands().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          getMutableLoadDemands() {
        return internalGetMutableLoadDemands().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Load demands of this visit request. This is just like
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
       * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
       * The demands listed here are added to the demands listed in
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
       * </code>
       */
      public Builder putLoadDemands(
          java.lang.String key, com.google.cloud.optimization.v1.Shipment.Load value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableLoadDemands().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Load demands of this visit request. This is just like
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands] field, except that it only applies to this
       * [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest] instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
       * The demands listed here are added to the demands listed in
       * [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 12;
       * </code>
       */
      public Builder putAllLoadDemands(
          java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> values) {
        internalGetMutableLoadDemands().getMutableMap().putAll(values);
        return this;
      }

      private com.google.protobuf.LazyStringList visitTypes_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureVisitTypesIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          visitTypes_ = new com.google.protobuf.LazyStringArrayList(visitTypes_);
          bitField0_ |= 0x00000008;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the types of the visit. This may be used to allocate additional
       * time required for a vehicle to complete this visit (see
       * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
       * A type can only appear once.
       * </pre>
       *
       * <code>repeated string visit_types = 10;</code>
       *
       * @return A list containing the visitTypes.
       */
      public com.google.protobuf.ProtocolStringList getVisitTypesList() {
        return visitTypes_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Specifies the types of the visit. This may be used to allocate additional
       * time required for a vehicle to complete this visit (see
       * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
       * A type can only appear once.
       * </pre>
       *
       * <code>repeated string visit_types = 10;</code>
       *
       * @return The count of visitTypes.
       */
      public int getVisitTypesCount() {
        return visitTypes_.size();
      }
      /**
       *
       *
       * <pre>
       * Specifies the types of the visit. This may be used to allocate additional
       * time required for a vehicle to complete this visit (see
       * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
       * A type can only appear once.
       * </pre>
       *
       * <code>repeated string visit_types = 10;</code>
       *
       * @param index The index of the element to return.
       * @return The visitTypes at the given index.
       */
      public java.lang.String getVisitTypes(int index) {
        return visitTypes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies the types of the visit. This may be used to allocate additional
       * time required for a vehicle to complete this visit (see
       * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
       * A type can only appear once.
       * </pre>
       *
       * <code>repeated string visit_types = 10;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the visitTypes at the given index.
       */
      public com.google.protobuf.ByteString getVisitTypesBytes(int index) {
        return visitTypes_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies the types of the visit. This may be used to allocate additional
       * time required for a vehicle to complete this visit (see
       * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
       * A type can only appear once.
       * </pre>
       *
       * <code>repeated string visit_types = 10;</code>
       *
       * @param index The index to set the value at.
       * @param value The visitTypes to set.
       * @return This builder for chaining.
       */
      public Builder setVisitTypes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVisitTypesIsMutable();
        visitTypes_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the types of the visit. This may be used to allocate additional
       * time required for a vehicle to complete this visit (see
       * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
       * A type can only appear once.
       * </pre>
       *
       * <code>repeated string visit_types = 10;</code>
       *
       * @param value The visitTypes to add.
       * @return This builder for chaining.
       */
      public Builder addVisitTypes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVisitTypesIsMutable();
        visitTypes_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the types of the visit. This may be used to allocate additional
       * time required for a vehicle to complete this visit (see
       * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
       * A type can only appear once.
       * </pre>
       *
       * <code>repeated string visit_types = 10;</code>
       *
       * @param values The visitTypes to add.
       * @return This builder for chaining.
       */
      public Builder addAllVisitTypes(java.lang.Iterable<java.lang.String> values) {
        ensureVisitTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, visitTypes_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the types of the visit. This may be used to allocate additional
       * time required for a vehicle to complete this visit (see
       * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
       * A type can only appear once.
       * </pre>
       *
       * <code>repeated string visit_types = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVisitTypes() {
        visitTypes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the types of the visit. This may be used to allocate additional
       * time required for a vehicle to complete this visit (see
       * [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
       * A type can only appear once.
       * </pre>
       *
       * <code>repeated string visit_types = 10;</code>
       *
       * @param value The bytes of the visitTypes to add.
       * @return This builder for chaining.
       */
      public Builder addVisitTypesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureVisitTypesIsMutable();
        visitTypes_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object label_ = "";
      /**
       *
       *
       * <pre>
       * Specifies a label for this `VisitRequest`. This label is reported in the
       * response as `visit_label` in the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
       * </pre>
       *
       * <code>string label = 11;</code>
       *
       * @return The label.
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          label_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies a label for this `VisitRequest`. This label is reported in the
       * response as `visit_label` in the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
       * </pre>
       *
       * <code>string label = 11;</code>
       *
       * @return The bytes for label.
       */
      public com.google.protobuf.ByteString getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies a label for this `VisitRequest`. This label is reported in the
       * response as `visit_label` in the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
       * </pre>
       *
       * <code>string label = 11;</code>
       *
       * @param value The label to set.
       * @return This builder for chaining.
       */
      public Builder setLabel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        label_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies a label for this `VisitRequest`. This label is reported in the
       * response as `visit_label` in the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
       * </pre>
       *
       * <code>string label = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLabel() {

        label_ = getDefaultInstance().getLabel();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies a label for this `VisitRequest`. This label is reported in the
       * response as `visit_label` in the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
       * </pre>
       *
       * <code>string label = 11;</code>
       *
       * @param value The bytes for label to set.
       * @return This builder for chaining.
       */
      public Builder setLabelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        label_ = value;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> demands_ =
          java.util.Collections.emptyList();

      private void ensureDemandsIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          demands_ =
              new java.util.ArrayList<com.google.cloud.optimization.v1.CapacityQuantity>(demands_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.CapacityQuantity,
              com.google.cloud.optimization.v1.CapacityQuantity.Builder,
              com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          demandsBuilder_;

      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getDemandsList() {
        if (demandsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(demands_);
        } else {
          return demandsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public int getDemandsCount() {
        if (demandsBuilder_ == null) {
          return demands_.size();
        } else {
          return demandsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity getDemands(int index) {
        if (demandsBuilder_ == null) {
          return demands_.get(index);
        } else {
          return demandsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setDemands(
          int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (demandsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDemandsIsMutable();
          demands_.set(index, value);
          onChanged();
        } else {
          demandsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setDemands(
          int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (demandsBuilder_ == null) {
          ensureDemandsIsMutable();
          demands_.set(index, builderForValue.build());
          onChanged();
        } else {
          demandsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addDemands(com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (demandsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDemandsIsMutable();
          demands_.add(value);
          onChanged();
        } else {
          demandsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addDemands(
          int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
        if (demandsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDemandsIsMutable();
          demands_.add(index, value);
          onChanged();
        } else {
          demandsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addDemands(
          com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (demandsBuilder_ == null) {
          ensureDemandsIsMutable();
          demands_.add(builderForValue.build());
          onChanged();
        } else {
          demandsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addDemands(
          int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
        if (demandsBuilder_ == null) {
          ensureDemandsIsMutable();
          demands_.add(index, builderForValue.build());
          onChanged();
        } else {
          demandsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAllDemands(
          java.lang.Iterable<? extends com.google.cloud.optimization.v1.CapacityQuantity> values) {
        if (demandsBuilder_ == null) {
          ensureDemandsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, demands_);
          onChanged();
        } else {
          demandsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder clearDemands() {
        if (demandsBuilder_ == null) {
          demands_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          demandsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder removeDemands(int index) {
        if (demandsBuilder_ == null) {
          ensureDemandsIsMutable();
          demands_.remove(index);
          onChanged();
        } else {
          demandsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder getDemandsBuilder(
          int index) {
        return getDemandsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getDemandsOrBuilder(
          int index) {
        if (demandsBuilder_ == null) {
          return demands_.get(index);
        } else {
          return demandsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          getDemandsOrBuilderList() {
        if (demandsBuilder_ != null) {
          return demandsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(demands_);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder addDemandsBuilder() {
        return getDemandsFieldBuilder()
            .addBuilder(com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.cloud.optimization.v1.CapacityQuantity.Builder addDemandsBuilder(
          int index) {
        return getDemandsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Deprecated: Use [VisitRequest.load_demands][] instead.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 9 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity.Builder>
          getDemandsBuilderList() {
        return getDemandsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.CapacityQuantity,
              com.google.cloud.optimization.v1.CapacityQuantity.Builder,
              com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
          getDemandsFieldBuilder() {
        if (demandsBuilder_ == null) {
          demandsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.optimization.v1.CapacityQuantity,
                  com.google.cloud.optimization.v1.CapacityQuantity.Builder,
                  com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>(
                  demands_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
          demands_ = null;
        }
        return demandsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.Shipment.VisitRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.Shipment.VisitRequest)
    private static final com.google.cloud.optimization.v1.Shipment.VisitRequest DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.Shipment.VisitRequest();
    }

    public static com.google.cloud.optimization.v1.Shipment.VisitRequest getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VisitRequest> PARSER =
        new com.google.protobuf.AbstractParser<VisitRequest>() {
          @java.lang.Override
          public VisitRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VisitRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VisitRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.Shipment.VisitRequest getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LoadOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.Shipment.Load)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The amount by which the load of the vehicle performing the corresponding
     * visit will vary. Since it is an integer, users are advised to choose an
     * appropriate unit to avoid loss of precision. Must be ≥ 0.
     * </pre>
     *
     * <code>int64 amount = 2;</code>
     *
     * @return The amount.
     */
    long getAmount();
  }
  /**
   *
   *
   * <pre>
   * When performing a visit, a predefined amount may be added to the vehicle
   * load if it's a pickup, or subtracted if it's a delivery. This message
   * defines such amount. See [load_demands][google.cloud.optimization.v1.Shipment.load_demands].
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.Shipment.Load}
   */
  public static final class Load extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.Shipment.Load)
      LoadOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Load.newBuilder() to construct.
    private Load(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Load() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Load();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Shipment_Load_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Shipment_Load_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.Shipment.Load.class,
              com.google.cloud.optimization.v1.Shipment.Load.Builder.class);
    }

    public static final int AMOUNT_FIELD_NUMBER = 2;
    private long amount_;
    /**
     *
     *
     * <pre>
     * The amount by which the load of the vehicle performing the corresponding
     * visit will vary. Since it is an integer, users are advised to choose an
     * appropriate unit to avoid loss of precision. Must be ≥ 0.
     * </pre>
     *
     * <code>int64 amount = 2;</code>
     *
     * @return The amount.
     */
    @java.lang.Override
    public long getAmount() {
      return amount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (amount_ != 0L) {
        output.writeInt64(2, amount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (amount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, amount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.Shipment.Load)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.Shipment.Load other =
          (com.google.cloud.optimization.v1.Shipment.Load) obj;

      if (getAmount() != other.getAmount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AMOUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAmount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.Shipment.Load parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.optimization.v1.Shipment.Load prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * When performing a visit, a predefined amount may be added to the vehicle
     * load if it's a pickup, or subtracted if it's a delivery. This message
     * defines such amount. See [load_demands][google.cloud.optimization.v1.Shipment.load_demands].
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.Shipment.Load}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.Shipment.Load)
        com.google.cloud.optimization.v1.Shipment.LoadOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Shipment_Load_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Shipment_Load_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.Shipment.Load.class,
                com.google.cloud.optimization.v1.Shipment.Load.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.Shipment.Load.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        amount_ = 0L;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_Shipment_Load_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Shipment.Load getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.Shipment.Load.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Shipment.Load build() {
        com.google.cloud.optimization.v1.Shipment.Load result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.Shipment.Load buildPartial() {
        com.google.cloud.optimization.v1.Shipment.Load result =
            new com.google.cloud.optimization.v1.Shipment.Load(this);
        result.amount_ = amount_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.Shipment.Load) {
          return mergeFrom((com.google.cloud.optimization.v1.Shipment.Load) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.Shipment.Load other) {
        if (other == com.google.cloud.optimization.v1.Shipment.Load.getDefaultInstance())
          return this;
        if (other.getAmount() != 0L) {
          setAmount(other.getAmount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  amount_ = input.readInt64();

                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private long amount_;
      /**
       *
       *
       * <pre>
       * The amount by which the load of the vehicle performing the corresponding
       * visit will vary. Since it is an integer, users are advised to choose an
       * appropriate unit to avoid loss of precision. Must be ≥ 0.
       * </pre>
       *
       * <code>int64 amount = 2;</code>
       *
       * @return The amount.
       */
      @java.lang.Override
      public long getAmount() {
        return amount_;
      }
      /**
       *
       *
       * <pre>
       * The amount by which the load of the vehicle performing the corresponding
       * visit will vary. Since it is an integer, users are advised to choose an
       * appropriate unit to avoid loss of precision. Must be ≥ 0.
       * </pre>
       *
       * <code>int64 amount = 2;</code>
       *
       * @param value The amount to set.
       * @return This builder for chaining.
       */
      public Builder setAmount(long value) {

        amount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The amount by which the load of the vehicle performing the corresponding
       * visit will vary. Since it is an integer, users are advised to choose an
       * appropriate unit to avoid loss of precision. Must be ≥ 0.
       * </pre>
       *
       * <code>int64 amount = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAmount() {

        amount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.Shipment.Load)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.Shipment.Load)
    private static final com.google.cloud.optimization.v1.Shipment.Load DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.Shipment.Load();
    }

    public static com.google.cloud.optimization.v1.Shipment.Load getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Load> PARSER =
        new com.google.protobuf.AbstractParser<Load>() {
          @java.lang.Override
          public Load parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Load> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Load> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.Shipment.Load getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PICKUPS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.optimization.v1.Shipment.VisitRequest> pickups_;
  /**
   *
   *
   * <pre>
   * Set of pickup alternatives associated to the shipment. If not specified,
   * the vehicle only needs to visit a location corresponding to the deliveries.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.Shipment.VisitRequest> getPickupsList() {
    return pickups_;
  }
  /**
   *
   *
   * <pre>
   * Set of pickup alternatives associated to the shipment. If not specified,
   * the vehicle only needs to visit a location corresponding to the deliveries.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder>
      getPickupsOrBuilderList() {
    return pickups_;
  }
  /**
   *
   *
   * <pre>
   * Set of pickup alternatives associated to the shipment. If not specified,
   * the vehicle only needs to visit a location corresponding to the deliveries.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
   */
  @java.lang.Override
  public int getPickupsCount() {
    return pickups_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of pickup alternatives associated to the shipment. If not specified,
   * the vehicle only needs to visit a location corresponding to the deliveries.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Shipment.VisitRequest getPickups(int index) {
    return pickups_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of pickup alternatives associated to the shipment. If not specified,
   * the vehicle only needs to visit a location corresponding to the deliveries.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder getPickupsOrBuilder(
      int index) {
    return pickups_.get(index);
  }

  public static final int DELIVERIES_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.optimization.v1.Shipment.VisitRequest> deliveries_;
  /**
   *
   *
   * <pre>
   * Set of delivery alternatives associated to the shipment. If not specified,
   * the vehicle only needs to visit a location corresponding to the pickups.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.Shipment.VisitRequest>
      getDeliveriesList() {
    return deliveries_;
  }
  /**
   *
   *
   * <pre>
   * Set of delivery alternatives associated to the shipment. If not specified,
   * the vehicle only needs to visit a location corresponding to the pickups.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder>
      getDeliveriesOrBuilderList() {
    return deliveries_;
  }
  /**
   *
   *
   * <pre>
   * Set of delivery alternatives associated to the shipment. If not specified,
   * the vehicle only needs to visit a location corresponding to the pickups.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
   */
  @java.lang.Override
  public int getDeliveriesCount() {
    return deliveries_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of delivery alternatives associated to the shipment. If not specified,
   * the vehicle only needs to visit a location corresponding to the pickups.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Shipment.VisitRequest getDeliveries(int index) {
    return deliveries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of delivery alternatives associated to the shipment. If not specified,
   * the vehicle only needs to visit a location corresponding to the pickups.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder getDeliveriesOrBuilder(
      int index) {
    return deliveries_.get(index);
  }

  public static final int LOAD_DEMANDS_FIELD_NUMBER = 14;

  private static final class LoadDemandsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
                    newDefaultInstance(
                        com.google.cloud.optimization.v1.FleetRoutingProto
                            .internal_static_google_cloud_optimization_v1_Shipment_LoadDemandsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.optimization.v1.Shipment.Load.getDefaultInstance());
  }

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
      loadDemands_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
      internalGetLoadDemands() {
    if (loadDemands_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LoadDemandsDefaultEntryHolder.defaultEntry);
    }
    return loadDemands_;
  }

  public int getLoadDemandsCount() {
    return internalGetLoadDemands().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Load demands of the shipment (for example weight, volume, number of
   * pallets etc). The keys in the map should be identifiers describing the type
   * of the corresponding load, ideally also including the units.
   * For example: "weight_kg", "volume_gallons", "pallet_count", etc.
   * If a given key does not appear in the map, the corresponding load is
   * considered as null.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 14;</code>
   */
  @java.lang.Override
  public boolean containsLoadDemands(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLoadDemands().getMap().containsKey(key);
  }
  /** Use {@link #getLoadDemandsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
      getLoadDemands() {
    return getLoadDemandsMap();
  }
  /**
   *
   *
   * <pre>
   * Load demands of the shipment (for example weight, volume, number of
   * pallets etc). The keys in the map should be identifiers describing the type
   * of the corresponding load, ideally also including the units.
   * For example: "weight_kg", "volume_gallons", "pallet_count", etc.
   * If a given key does not appear in the map, the corresponding load is
   * considered as null.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 14;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
      getLoadDemandsMap() {
    return internalGetLoadDemands().getMap();
  }
  /**
   *
   *
   * <pre>
   * Load demands of the shipment (for example weight, volume, number of
   * pallets etc). The keys in the map should be identifiers describing the type
   * of the corresponding load, ideally also including the units.
   * For example: "weight_kg", "volume_gallons", "pallet_count", etc.
   * If a given key does not appear in the map, the corresponding load is
   * considered as null.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrDefault(
      java.lang.String key, com.google.cloud.optimization.v1.Shipment.Load defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
        internalGetLoadDemands().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Load demands of the shipment (for example weight, volume, number of
   * pallets etc). The keys in the map should be identifiers describing the type
   * of the corresponding load, ideally also including the units.
   * For example: "weight_kg", "volume_gallons", "pallet_count", etc.
   * If a given key does not appear in the map, the corresponding load is
   * considered as null.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
        internalGetLoadDemands().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PENALTY_COST_FIELD_NUMBER = 4;
  private double penaltyCost_;
  /**
   *
   *
   * <pre>
   * If the shipment is not completed, this penalty is added to the overall
   * cost of the routes. A shipment is considered completed if one of its pickup
   * and delivery alternatives is visited. The cost may be expressed in the
   * same unit used for all other cost-related fields in the model and must be
   * positive.
   * *IMPORTANT*: If this penalty is not specified, it is considered infinite,
   * i.e. the shipment must be completed.
   * </pre>
   *
   * <code>optional double penalty_cost = 4;</code>
   *
   * @return Whether the penaltyCost field is set.
   */
  @java.lang.Override
  public boolean hasPenaltyCost() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * If the shipment is not completed, this penalty is added to the overall
   * cost of the routes. A shipment is considered completed if one of its pickup
   * and delivery alternatives is visited. The cost may be expressed in the
   * same unit used for all other cost-related fields in the model and must be
   * positive.
   * *IMPORTANT*: If this penalty is not specified, it is considered infinite,
   * i.e. the shipment must be completed.
   * </pre>
   *
   * <code>optional double penalty_cost = 4;</code>
   *
   * @return The penaltyCost.
   */
  @java.lang.Override
  public double getPenaltyCost() {
    return penaltyCost_;
  }

  public static final int ALLOWED_VEHICLE_INDICES_FIELD_NUMBER = 5;
  private com.google.protobuf.Internal.IntList allowedVehicleIndices_;
  /**
   *
   *
   * <pre>
   * The set of vehicles that may perform this shipment. If empty, all vehicles
   * may perform it. Vehicles are given by their index in the `ShipmentModel`'s
   * `vehicles` list.
   * </pre>
   *
   * <code>repeated int32 allowed_vehicle_indices = 5;</code>
   *
   * @return A list containing the allowedVehicleIndices.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getAllowedVehicleIndicesList() {
    return allowedVehicleIndices_;
  }
  /**
   *
   *
   * <pre>
   * The set of vehicles that may perform this shipment. If empty, all vehicles
   * may perform it. Vehicles are given by their index in the `ShipmentModel`'s
   * `vehicles` list.
   * </pre>
   *
   * <code>repeated int32 allowed_vehicle_indices = 5;</code>
   *
   * @return The count of allowedVehicleIndices.
   */
  public int getAllowedVehicleIndicesCount() {
    return allowedVehicleIndices_.size();
  }
  /**
   *
   *
   * <pre>
   * The set of vehicles that may perform this shipment. If empty, all vehicles
   * may perform it. Vehicles are given by their index in the `ShipmentModel`'s
   * `vehicles` list.
   * </pre>
   *
   * <code>repeated int32 allowed_vehicle_indices = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The allowedVehicleIndices at the given index.
   */
  public int getAllowedVehicleIndices(int index) {
    return allowedVehicleIndices_.getInt(index);
  }

  private int allowedVehicleIndicesMemoizedSerializedSize = -1;

  public static final int COSTS_PER_VEHICLE_FIELD_NUMBER = 6;
  private com.google.protobuf.Internal.DoubleList costsPerVehicle_;
  /**
   *
   *
   * <pre>
   * Specifies the cost that is incurred when this shipment is delivered by each
   * vehicle. If specified, it must have EITHER:
   *   * the same number of elements as `costs_per_vehicle_indices`.
   *     `costs_per_vehicle[i]` corresponds to vehicle
   *     `costs_per_vehicle_indices[i]` of the model.
   *   * the same number of elements as there are vehicles in the model. The
   *     i-th element corresponds to vehicle #i of the model.
   * These costs must be in the same unit as `penalty_cost` and must not be
   * negative. Leave this field empty, if there are no such costs.
   * </pre>
   *
   * <code>repeated double costs_per_vehicle = 6;</code>
   *
   * @return A list containing the costsPerVehicle.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double> getCostsPerVehicleList() {
    return costsPerVehicle_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the cost that is incurred when this shipment is delivered by each
   * vehicle. If specified, it must have EITHER:
   *   * the same number of elements as `costs_per_vehicle_indices`.
   *     `costs_per_vehicle[i]` corresponds to vehicle
   *     `costs_per_vehicle_indices[i]` of the model.
   *   * the same number of elements as there are vehicles in the model. The
   *     i-th element corresponds to vehicle #i of the model.
   * These costs must be in the same unit as `penalty_cost` and must not be
   * negative. Leave this field empty, if there are no such costs.
   * </pre>
   *
   * <code>repeated double costs_per_vehicle = 6;</code>
   *
   * @return The count of costsPerVehicle.
   */
  public int getCostsPerVehicleCount() {
    return costsPerVehicle_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies the cost that is incurred when this shipment is delivered by each
   * vehicle. If specified, it must have EITHER:
   *   * the same number of elements as `costs_per_vehicle_indices`.
   *     `costs_per_vehicle[i]` corresponds to vehicle
   *     `costs_per_vehicle_indices[i]` of the model.
   *   * the same number of elements as there are vehicles in the model. The
   *     i-th element corresponds to vehicle #i of the model.
   * These costs must be in the same unit as `penalty_cost` and must not be
   * negative. Leave this field empty, if there are no such costs.
   * </pre>
   *
   * <code>repeated double costs_per_vehicle = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The costsPerVehicle at the given index.
   */
  public double getCostsPerVehicle(int index) {
    return costsPerVehicle_.getDouble(index);
  }

  private int costsPerVehicleMemoizedSerializedSize = -1;

  public static final int COSTS_PER_VEHICLE_INDICES_FIELD_NUMBER = 7;
  private com.google.protobuf.Internal.IntList costsPerVehicleIndices_;
  /**
   *
   *
   * <pre>
   * Indices of the vehicles to which `costs_per_vehicle` applies. If non-empty,
   * it must have the same number of elements as `costs_per_vehicle`. A vehicle
   * index may not be specified more than once. If a vehicle is excluded from
   * `costs_per_vehicle_indices`, its cost is zero.
   * </pre>
   *
   * <code>repeated int32 costs_per_vehicle_indices = 7;</code>
   *
   * @return A list containing the costsPerVehicleIndices.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getCostsPerVehicleIndicesList() {
    return costsPerVehicleIndices_;
  }
  /**
   *
   *
   * <pre>
   * Indices of the vehicles to which `costs_per_vehicle` applies. If non-empty,
   * it must have the same number of elements as `costs_per_vehicle`. A vehicle
   * index may not be specified more than once. If a vehicle is excluded from
   * `costs_per_vehicle_indices`, its cost is zero.
   * </pre>
   *
   * <code>repeated int32 costs_per_vehicle_indices = 7;</code>
   *
   * @return The count of costsPerVehicleIndices.
   */
  public int getCostsPerVehicleIndicesCount() {
    return costsPerVehicleIndices_.size();
  }
  /**
   *
   *
   * <pre>
   * Indices of the vehicles to which `costs_per_vehicle` applies. If non-empty,
   * it must have the same number of elements as `costs_per_vehicle`. A vehicle
   * index may not be specified more than once. If a vehicle is excluded from
   * `costs_per_vehicle_indices`, its cost is zero.
   * </pre>
   *
   * <code>repeated int32 costs_per_vehicle_indices = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The costsPerVehicleIndices at the given index.
   */
  public int getCostsPerVehicleIndices(int index) {
    return costsPerVehicleIndices_.getInt(index);
  }

  private int costsPerVehicleIndicesMemoizedSerializedSize = -1;

  public static final int PICKUP_TO_DELIVERY_RELATIVE_DETOUR_LIMIT_FIELD_NUMBER = 8;
  private double pickupToDeliveryRelativeDetourLimit_;
  /**
   *
   *
   * <pre>
   * Specifies the maximum relative detour time compared to the shortest path
   * from pickup to delivery. If specified, it must be nonnegative, and the
   * shipment must contain at least a pickup and a delivery.
   * For example, let t be the shortest time taken to go from the selected
   * pickup alternative directly to the selected delivery alternative. Then
   * setting `pickup_to_delivery_relative_detour_limit` enforces:
   * ```
   * start_time(delivery) - start_time(pickup) &lt;=
   * std::ceil(t * (1.0 + pickup_to_delivery_relative_detour_limit))
   * ```
   * If both relative and absolute limits are specified on the same shipment,
   * the more constraining limit is used for each possible pickup/delivery pair.
   * As of 2017/10, detours are only supported when travel durations do not
   * depend on vehicles.
   * </pre>
   *
   * <code>optional double pickup_to_delivery_relative_detour_limit = 8;</code>
   *
   * @return Whether the pickupToDeliveryRelativeDetourLimit field is set.
   */
  @java.lang.Override
  public boolean hasPickupToDeliveryRelativeDetourLimit() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the maximum relative detour time compared to the shortest path
   * from pickup to delivery. If specified, it must be nonnegative, and the
   * shipment must contain at least a pickup and a delivery.
   * For example, let t be the shortest time taken to go from the selected
   * pickup alternative directly to the selected delivery alternative. Then
   * setting `pickup_to_delivery_relative_detour_limit` enforces:
   * ```
   * start_time(delivery) - start_time(pickup) &lt;=
   * std::ceil(t * (1.0 + pickup_to_delivery_relative_detour_limit))
   * ```
   * If both relative and absolute limits are specified on the same shipment,
   * the more constraining limit is used for each possible pickup/delivery pair.
   * As of 2017/10, detours are only supported when travel durations do not
   * depend on vehicles.
   * </pre>
   *
   * <code>optional double pickup_to_delivery_relative_detour_limit = 8;</code>
   *
   * @return The pickupToDeliveryRelativeDetourLimit.
   */
  @java.lang.Override
  public double getPickupToDeliveryRelativeDetourLimit() {
    return pickupToDeliveryRelativeDetourLimit_;
  }

  public static final int PICKUP_TO_DELIVERY_ABSOLUTE_DETOUR_LIMIT_FIELD_NUMBER = 9;
  private com.google.protobuf.Duration pickupToDeliveryAbsoluteDetourLimit_;
  /**
   *
   *
   * <pre>
   * Specifies the maximum absolute detour time compared to the shortest path
   * from pickup to delivery. If specified, it must be nonnegative, and the
   * shipment must contain at least a pickup and a delivery.
   * For example, let t be the shortest time taken to go from the selected
   * pickup alternative directly to the selected delivery alternative. Then
   * setting `pickup_to_delivery_absolute_detour_limit` enforces:
   * ```
   * start_time(delivery) - start_time(pickup) &lt;=
   * t + pickup_to_delivery_absolute_detour_limit
   * ```
   * If both relative and absolute limits are specified on the same shipment,
   * the more constraining limit is used for each possible pickup/delivery pair.
   * As of 2017/10, detours are only supported when travel durations do not
   * depend on vehicles.
   * </pre>
   *
   * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
   *
   * @return Whether the pickupToDeliveryAbsoluteDetourLimit field is set.
   */
  @java.lang.Override
  public boolean hasPickupToDeliveryAbsoluteDetourLimit() {
    return pickupToDeliveryAbsoluteDetourLimit_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies the maximum absolute detour time compared to the shortest path
   * from pickup to delivery. If specified, it must be nonnegative, and the
   * shipment must contain at least a pickup and a delivery.
   * For example, let t be the shortest time taken to go from the selected
   * pickup alternative directly to the selected delivery alternative. Then
   * setting `pickup_to_delivery_absolute_detour_limit` enforces:
   * ```
   * start_time(delivery) - start_time(pickup) &lt;=
   * t + pickup_to_delivery_absolute_detour_limit
   * ```
   * If both relative and absolute limits are specified on the same shipment,
   * the more constraining limit is used for each possible pickup/delivery pair.
   * As of 2017/10, detours are only supported when travel durations do not
   * depend on vehicles.
   * </pre>
   *
   * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
   *
   * @return The pickupToDeliveryAbsoluteDetourLimit.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getPickupToDeliveryAbsoluteDetourLimit() {
    return pickupToDeliveryAbsoluteDetourLimit_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : pickupToDeliveryAbsoluteDetourLimit_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the maximum absolute detour time compared to the shortest path
   * from pickup to delivery. If specified, it must be nonnegative, and the
   * shipment must contain at least a pickup and a delivery.
   * For example, let t be the shortest time taken to go from the selected
   * pickup alternative directly to the selected delivery alternative. Then
   * setting `pickup_to_delivery_absolute_detour_limit` enforces:
   * ```
   * start_time(delivery) - start_time(pickup) &lt;=
   * t + pickup_to_delivery_absolute_detour_limit
   * ```
   * If both relative and absolute limits are specified on the same shipment,
   * the more constraining limit is used for each possible pickup/delivery pair.
   * As of 2017/10, detours are only supported when travel durations do not
   * depend on vehicles.
   * </pre>
   *
   * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getPickupToDeliveryAbsoluteDetourLimitOrBuilder() {
    return getPickupToDeliveryAbsoluteDetourLimit();
  }

  public static final int PICKUP_TO_DELIVERY_TIME_LIMIT_FIELD_NUMBER = 10;
  private com.google.protobuf.Duration pickupToDeliveryTimeLimit_;
  /**
   *
   *
   * <pre>
   * Specifies the maximum duration from start of pickup to start of delivery of
   * a shipment. If specified, it must be nonnegative, and the shipment must
   * contain at least a pickup and a delivery. This does not depend on which
   * alternatives are selected for pickup and delivery, nor on vehicle speed.
   * This can be specified alongside maximum detour constraints: the solution
   * will respect both specifications.
   * </pre>
   *
   * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
   *
   * @return Whether the pickupToDeliveryTimeLimit field is set.
   */
  @java.lang.Override
  public boolean hasPickupToDeliveryTimeLimit() {
    return pickupToDeliveryTimeLimit_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies the maximum duration from start of pickup to start of delivery of
   * a shipment. If specified, it must be nonnegative, and the shipment must
   * contain at least a pickup and a delivery. This does not depend on which
   * alternatives are selected for pickup and delivery, nor on vehicle speed.
   * This can be specified alongside maximum detour constraints: the solution
   * will respect both specifications.
   * </pre>
   *
   * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
   *
   * @return The pickupToDeliveryTimeLimit.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getPickupToDeliveryTimeLimit() {
    return pickupToDeliveryTimeLimit_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : pickupToDeliveryTimeLimit_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the maximum duration from start of pickup to start of delivery of
   * a shipment. If specified, it must be nonnegative, and the shipment must
   * contain at least a pickup and a delivery. This does not depend on which
   * alternatives are selected for pickup and delivery, nor on vehicle speed.
   * This can be specified alongside maximum detour constraints: the solution
   * will respect both specifications.
   * </pre>
   *
   * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getPickupToDeliveryTimeLimitOrBuilder() {
    return getPickupToDeliveryTimeLimit();
  }

  public static final int SHIPMENT_TYPE_FIELD_NUMBER = 11;
  private volatile java.lang.Object shipmentType_;
  /**
   *
   *
   * <pre>
   * Non-empty string specifying a "type" for this shipment.
   * This feature can be used to define incompatibilities or requirements
   * between `shipment_types` (see `shipment_type_incompatibilities` and
   * `shipment_type_requirements` in `ShipmentModel`).
   * Differs from `visit_types` which is specified for a single visit: All
   * pickup/deliveries belonging to the same shipment share the same
   * `shipment_type`.
   * </pre>
   *
   * <code>string shipment_type = 11;</code>
   *
   * @return The shipmentType.
   */
  @java.lang.Override
  public java.lang.String getShipmentType() {
    java.lang.Object ref = shipmentType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      shipmentType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Non-empty string specifying a "type" for this shipment.
   * This feature can be used to define incompatibilities or requirements
   * between `shipment_types` (see `shipment_type_incompatibilities` and
   * `shipment_type_requirements` in `ShipmentModel`).
   * Differs from `visit_types` which is specified for a single visit: All
   * pickup/deliveries belonging to the same shipment share the same
   * `shipment_type`.
   * </pre>
   *
   * <code>string shipment_type = 11;</code>
   *
   * @return The bytes for shipmentType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getShipmentTypeBytes() {
    java.lang.Object ref = shipmentType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      shipmentType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FIELD_NUMBER = 12;
  private volatile java.lang.Object label_;
  /**
   *
   *
   * <pre>
   * Specifies a label for this shipment. This label is reported in the response
   * in the `shipment_label` of the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
   * </pre>
   *
   * <code>string label = 12;</code>
   *
   * @return The label.
   */
  @java.lang.Override
  public java.lang.String getLabel() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      label_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies a label for this shipment. This label is reported in the response
   * in the `shipment_label` of the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
   * </pre>
   *
   * <code>string label = 12;</code>
   *
   * @return The bytes for label.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelBytes() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      label_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IGNORE_FIELD_NUMBER = 13;
  private boolean ignore_;
  /**
   *
   *
   * <pre>
   * If true, skip this shipment, but don't apply a `penalty_cost`.
   * Ignoring a shipment results in a validation error when there are any
   * `shipment_type_requirements` in the model.
   * Ignoring a shipment that is performed in `injected_first_solution_routes`
   * or `injected_solution_constraint` is permitted; the solver removes the
   * related pickup/delivery visits from the performing route.
   * `precedence_rules` that reference ignored shipments will also be ignored.
   * </pre>
   *
   * <code>bool ignore = 13;</code>
   *
   * @return The ignore.
   */
  @java.lang.Override
  public boolean getIgnore() {
    return ignore_;
  }

  public static final int DEMANDS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> demands_;
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Shipment.load_demands][] instead.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getDemandsList() {
    return demands_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Shipment.load_demands][] instead.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
      getDemandsOrBuilderList() {
    return demands_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Shipment.load_demands][] instead.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getDemandsCount() {
    return demands_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Shipment.load_demands][] instead.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.CapacityQuantity getDemands(int index) {
    return demands_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Shipment.load_demands][] instead.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getDemandsOrBuilder(int index) {
    return demands_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    for (int i = 0; i < pickups_.size(); i++) {
      output.writeMessage(1, pickups_.get(i));
    }
    for (int i = 0; i < deliveries_.size(); i++) {
      output.writeMessage(2, deliveries_.get(i));
    }
    for (int i = 0; i < demands_.size(); i++) {
      output.writeMessage(3, demands_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeDouble(4, penaltyCost_);
    }
    if (getAllowedVehicleIndicesList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(allowedVehicleIndicesMemoizedSerializedSize);
    }
    for (int i = 0; i < allowedVehicleIndices_.size(); i++) {
      output.writeInt32NoTag(allowedVehicleIndices_.getInt(i));
    }
    if (getCostsPerVehicleList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(costsPerVehicleMemoizedSerializedSize);
    }
    for (int i = 0; i < costsPerVehicle_.size(); i++) {
      output.writeDoubleNoTag(costsPerVehicle_.getDouble(i));
    }
    if (getCostsPerVehicleIndicesList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(costsPerVehicleIndicesMemoizedSerializedSize);
    }
    for (int i = 0; i < costsPerVehicleIndices_.size(); i++) {
      output.writeInt32NoTag(costsPerVehicleIndices_.getInt(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeDouble(8, pickupToDeliveryRelativeDetourLimit_);
    }
    if (pickupToDeliveryAbsoluteDetourLimit_ != null) {
      output.writeMessage(9, getPickupToDeliveryAbsoluteDetourLimit());
    }
    if (pickupToDeliveryTimeLimit_ != null) {
      output.writeMessage(10, getPickupToDeliveryTimeLimit());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(shipmentType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, shipmentType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, label_);
    }
    if (ignore_ != false) {
      output.writeBool(13, ignore_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLoadDemands(), LoadDemandsDefaultEntryHolder.defaultEntry, 14);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < pickups_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, pickups_.get(i));
    }
    for (int i = 0; i < deliveries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, deliveries_.get(i));
    }
    for (int i = 0; i < demands_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, demands_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, penaltyCost_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < allowedVehicleIndices_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                allowedVehicleIndices_.getInt(i));
      }
      size += dataSize;
      if (!getAllowedVehicleIndicesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      allowedVehicleIndicesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      dataSize = 8 * getCostsPerVehicleList().size();
      size += dataSize;
      if (!getCostsPerVehicleList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      costsPerVehicleMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < costsPerVehicleIndices_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                costsPerVehicleIndices_.getInt(i));
      }
      size += dataSize;
      if (!getCostsPerVehicleIndicesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      costsPerVehicleIndicesMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              8, pickupToDeliveryRelativeDetourLimit_);
    }
    if (pickupToDeliveryAbsoluteDetourLimit_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, getPickupToDeliveryAbsoluteDetourLimit());
    }
    if (pickupToDeliveryTimeLimit_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, getPickupToDeliveryTimeLimit());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(shipmentType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, shipmentType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, label_);
    }
    if (ignore_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, ignore_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        entry : internalGetLoadDemands().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
          loadDemands__ =
              LoadDemandsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, loadDemands__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.Shipment)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.Shipment other =
        (com.google.cloud.optimization.v1.Shipment) obj;

    if (!getPickupsList().equals(other.getPickupsList())) return false;
    if (!getDeliveriesList().equals(other.getDeliveriesList())) return false;
    if (!internalGetLoadDemands().equals(other.internalGetLoadDemands())) return false;
    if (hasPenaltyCost() != other.hasPenaltyCost()) return false;
    if (hasPenaltyCost()) {
      if (java.lang.Double.doubleToLongBits(getPenaltyCost())
          != java.lang.Double.doubleToLongBits(other.getPenaltyCost())) return false;
    }
    if (!getAllowedVehicleIndicesList().equals(other.getAllowedVehicleIndicesList())) return false;
    if (!getCostsPerVehicleList().equals(other.getCostsPerVehicleList())) return false;
    if (!getCostsPerVehicleIndicesList().equals(other.getCostsPerVehicleIndicesList()))
      return false;
    if (hasPickupToDeliveryRelativeDetourLimit() != other.hasPickupToDeliveryRelativeDetourLimit())
      return false;
    if (hasPickupToDeliveryRelativeDetourLimit()) {
      if (java.lang.Double.doubleToLongBits(getPickupToDeliveryRelativeDetourLimit())
          != java.lang.Double.doubleToLongBits(other.getPickupToDeliveryRelativeDetourLimit()))
        return false;
    }
    if (hasPickupToDeliveryAbsoluteDetourLimit() != other.hasPickupToDeliveryAbsoluteDetourLimit())
      return false;
    if (hasPickupToDeliveryAbsoluteDetourLimit()) {
      if (!getPickupToDeliveryAbsoluteDetourLimit()
          .equals(other.getPickupToDeliveryAbsoluteDetourLimit())) return false;
    }
    if (hasPickupToDeliveryTimeLimit() != other.hasPickupToDeliveryTimeLimit()) return false;
    if (hasPickupToDeliveryTimeLimit()) {
      if (!getPickupToDeliveryTimeLimit().equals(other.getPickupToDeliveryTimeLimit()))
        return false;
    }
    if (!getShipmentType().equals(other.getShipmentType())) return false;
    if (!getLabel().equals(other.getLabel())) return false;
    if (getIgnore() != other.getIgnore()) return false;
    if (!getDemandsList().equals(other.getDemandsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPickupsCount() > 0) {
      hash = (37 * hash) + PICKUPS_FIELD_NUMBER;
      hash = (53 * hash) + getPickupsList().hashCode();
    }
    if (getDeliveriesCount() > 0) {
      hash = (37 * hash) + DELIVERIES_FIELD_NUMBER;
      hash = (53 * hash) + getDeliveriesList().hashCode();
    }
    if (!internalGetLoadDemands().getMap().isEmpty()) {
      hash = (37 * hash) + LOAD_DEMANDS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLoadDemands().hashCode();
    }
    if (hasPenaltyCost()) {
      hash = (37 * hash) + PENALTY_COST_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getPenaltyCost()));
    }
    if (getAllowedVehicleIndicesCount() > 0) {
      hash = (37 * hash) + ALLOWED_VEHICLE_INDICES_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedVehicleIndicesList().hashCode();
    }
    if (getCostsPerVehicleCount() > 0) {
      hash = (37 * hash) + COSTS_PER_VEHICLE_FIELD_NUMBER;
      hash = (53 * hash) + getCostsPerVehicleList().hashCode();
    }
    if (getCostsPerVehicleIndicesCount() > 0) {
      hash = (37 * hash) + COSTS_PER_VEHICLE_INDICES_FIELD_NUMBER;
      hash = (53 * hash) + getCostsPerVehicleIndicesList().hashCode();
    }
    if (hasPickupToDeliveryRelativeDetourLimit()) {
      hash = (37 * hash) + PICKUP_TO_DELIVERY_RELATIVE_DETOUR_LIMIT_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getPickupToDeliveryRelativeDetourLimit()));
    }
    if (hasPickupToDeliveryAbsoluteDetourLimit()) {
      hash = (37 * hash) + PICKUP_TO_DELIVERY_ABSOLUTE_DETOUR_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getPickupToDeliveryAbsoluteDetourLimit().hashCode();
    }
    if (hasPickupToDeliveryTimeLimit()) {
      hash = (37 * hash) + PICKUP_TO_DELIVERY_TIME_LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getPickupToDeliveryTimeLimit().hashCode();
    }
    hash = (37 * hash) + SHIPMENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getShipmentType().hashCode();
    hash = (37 * hash) + LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getLabel().hashCode();
    hash = (37 * hash) + IGNORE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnore());
    if (getDemandsCount() > 0) {
      hash = (37 * hash) + DEMANDS_FIELD_NUMBER;
      hash = (53 * hash) + getDemandsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.Shipment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.Shipment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.Shipment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.Shipment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.Shipment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.Shipment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.Shipment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.Shipment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.Shipment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.Shipment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.Shipment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.Shipment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.optimization.v1.Shipment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The shipment of a single item, from one of its pickups to one of its
   * deliveries. For the shipment to be considered as performed, a unique vehicle
   * must visit one of its pickup locations (and decrease its spare capacities
   * accordingly), then visit one of its delivery locations later on (and
   * therefore re-increase its spare capacities accordingly).
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.Shipment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.Shipment)
      com.google.cloud.optimization.v1.ShipmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Shipment_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 14:
          return internalGetLoadDemands();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 14:
          return internalGetMutableLoadDemands();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Shipment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.Shipment.class,
              com.google.cloud.optimization.v1.Shipment.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.Shipment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (pickupsBuilder_ == null) {
        pickups_ = java.util.Collections.emptyList();
      } else {
        pickups_ = null;
        pickupsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (deliveriesBuilder_ == null) {
        deliveries_ = java.util.Collections.emptyList();
      } else {
        deliveries_ = null;
        deliveriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableLoadDemands().clear();
      penaltyCost_ = 0D;
      bitField0_ = (bitField0_ & ~0x00000008);
      allowedVehicleIndices_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000010);
      costsPerVehicle_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000020);
      costsPerVehicleIndices_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000040);
      pickupToDeliveryRelativeDetourLimit_ = 0D;
      bitField0_ = (bitField0_ & ~0x00000080);
      if (pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
        pickupToDeliveryAbsoluteDetourLimit_ = null;
      } else {
        pickupToDeliveryAbsoluteDetourLimit_ = null;
        pickupToDeliveryAbsoluteDetourLimitBuilder_ = null;
      }
      if (pickupToDeliveryTimeLimitBuilder_ == null) {
        pickupToDeliveryTimeLimit_ = null;
      } else {
        pickupToDeliveryTimeLimit_ = null;
        pickupToDeliveryTimeLimitBuilder_ = null;
      }
      shipmentType_ = "";

      label_ = "";

      ignore_ = false;

      if (demandsBuilder_ == null) {
        demands_ = java.util.Collections.emptyList();
      } else {
        demands_ = null;
        demandsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_Shipment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.Shipment getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.Shipment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.Shipment build() {
      com.google.cloud.optimization.v1.Shipment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.Shipment buildPartial() {
      com.google.cloud.optimization.v1.Shipment result =
          new com.google.cloud.optimization.v1.Shipment(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (pickupsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          pickups_ = java.util.Collections.unmodifiableList(pickups_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.pickups_ = pickups_;
      } else {
        result.pickups_ = pickupsBuilder_.build();
      }
      if (deliveriesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          deliveries_ = java.util.Collections.unmodifiableList(deliveries_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.deliveries_ = deliveries_;
      } else {
        result.deliveries_ = deliveriesBuilder_.build();
      }
      result.loadDemands_ = internalGetLoadDemands();
      result.loadDemands_.makeImmutable();
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.penaltyCost_ = penaltyCost_;
        to_bitField0_ |= 0x00000001;
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        allowedVehicleIndices_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.allowedVehicleIndices_ = allowedVehicleIndices_;
      if (((bitField0_ & 0x00000020) != 0)) {
        costsPerVehicle_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.costsPerVehicle_ = costsPerVehicle_;
      if (((bitField0_ & 0x00000040) != 0)) {
        costsPerVehicleIndices_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000040);
      }
      result.costsPerVehicleIndices_ = costsPerVehicleIndices_;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.pickupToDeliveryRelativeDetourLimit_ = pickupToDeliveryRelativeDetourLimit_;
        to_bitField0_ |= 0x00000002;
      }
      if (pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
        result.pickupToDeliveryAbsoluteDetourLimit_ = pickupToDeliveryAbsoluteDetourLimit_;
      } else {
        result.pickupToDeliveryAbsoluteDetourLimit_ =
            pickupToDeliveryAbsoluteDetourLimitBuilder_.build();
      }
      if (pickupToDeliveryTimeLimitBuilder_ == null) {
        result.pickupToDeliveryTimeLimit_ = pickupToDeliveryTimeLimit_;
      } else {
        result.pickupToDeliveryTimeLimit_ = pickupToDeliveryTimeLimitBuilder_.build();
      }
      result.shipmentType_ = shipmentType_;
      result.label_ = label_;
      result.ignore_ = ignore_;
      if (demandsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          demands_ = java.util.Collections.unmodifiableList(demands_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.demands_ = demands_;
      } else {
        result.demands_ = demandsBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.Shipment) {
        return mergeFrom((com.google.cloud.optimization.v1.Shipment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.Shipment other) {
      if (other == com.google.cloud.optimization.v1.Shipment.getDefaultInstance()) return this;
      if (pickupsBuilder_ == null) {
        if (!other.pickups_.isEmpty()) {
          if (pickups_.isEmpty()) {
            pickups_ = other.pickups_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePickupsIsMutable();
            pickups_.addAll(other.pickups_);
          }
          onChanged();
        }
      } else {
        if (!other.pickups_.isEmpty()) {
          if (pickupsBuilder_.isEmpty()) {
            pickupsBuilder_.dispose();
            pickupsBuilder_ = null;
            pickups_ = other.pickups_;
            bitField0_ = (bitField0_ & ~0x00000001);
            pickupsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPickupsFieldBuilder()
                    : null;
          } else {
            pickupsBuilder_.addAllMessages(other.pickups_);
          }
        }
      }
      if (deliveriesBuilder_ == null) {
        if (!other.deliveries_.isEmpty()) {
          if (deliveries_.isEmpty()) {
            deliveries_ = other.deliveries_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDeliveriesIsMutable();
            deliveries_.addAll(other.deliveries_);
          }
          onChanged();
        }
      } else {
        if (!other.deliveries_.isEmpty()) {
          if (deliveriesBuilder_.isEmpty()) {
            deliveriesBuilder_.dispose();
            deliveriesBuilder_ = null;
            deliveries_ = other.deliveries_;
            bitField0_ = (bitField0_ & ~0x00000002);
            deliveriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDeliveriesFieldBuilder()
                    : null;
          } else {
            deliveriesBuilder_.addAllMessages(other.deliveries_);
          }
        }
      }
      internalGetMutableLoadDemands().mergeFrom(other.internalGetLoadDemands());
      if (other.hasPenaltyCost()) {
        setPenaltyCost(other.getPenaltyCost());
      }
      if (!other.allowedVehicleIndices_.isEmpty()) {
        if (allowedVehicleIndices_.isEmpty()) {
          allowedVehicleIndices_ = other.allowedVehicleIndices_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureAllowedVehicleIndicesIsMutable();
          allowedVehicleIndices_.addAll(other.allowedVehicleIndices_);
        }
        onChanged();
      }
      if (!other.costsPerVehicle_.isEmpty()) {
        if (costsPerVehicle_.isEmpty()) {
          costsPerVehicle_ = other.costsPerVehicle_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureCostsPerVehicleIsMutable();
          costsPerVehicle_.addAll(other.costsPerVehicle_);
        }
        onChanged();
      }
      if (!other.costsPerVehicleIndices_.isEmpty()) {
        if (costsPerVehicleIndices_.isEmpty()) {
          costsPerVehicleIndices_ = other.costsPerVehicleIndices_;
          bitField0_ = (bitField0_ & ~0x00000040);
        } else {
          ensureCostsPerVehicleIndicesIsMutable();
          costsPerVehicleIndices_.addAll(other.costsPerVehicleIndices_);
        }
        onChanged();
      }
      if (other.hasPickupToDeliveryRelativeDetourLimit()) {
        setPickupToDeliveryRelativeDetourLimit(other.getPickupToDeliveryRelativeDetourLimit());
      }
      if (other.hasPickupToDeliveryAbsoluteDetourLimit()) {
        mergePickupToDeliveryAbsoluteDetourLimit(other.getPickupToDeliveryAbsoluteDetourLimit());
      }
      if (other.hasPickupToDeliveryTimeLimit()) {
        mergePickupToDeliveryTimeLimit(other.getPickupToDeliveryTimeLimit());
      }
      if (!other.getShipmentType().isEmpty()) {
        shipmentType_ = other.shipmentType_;
        onChanged();
      }
      if (!other.getLabel().isEmpty()) {
        label_ = other.label_;
        onChanged();
      }
      if (other.getIgnore() != false) {
        setIgnore(other.getIgnore());
      }
      if (demandsBuilder_ == null) {
        if (!other.demands_.isEmpty()) {
          if (demands_.isEmpty()) {
            demands_ = other.demands_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureDemandsIsMutable();
            demands_.addAll(other.demands_);
          }
          onChanged();
        }
      } else {
        if (!other.demands_.isEmpty()) {
          if (demandsBuilder_.isEmpty()) {
            demandsBuilder_.dispose();
            demandsBuilder_ = null;
            demands_ = other.demands_;
            bitField0_ = (bitField0_ & ~0x00000100);
            demandsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDemandsFieldBuilder()
                    : null;
          } else {
            demandsBuilder_.addAllMessages(other.demands_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.optimization.v1.Shipment.VisitRequest m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.Shipment.VisitRequest.parser(),
                        extensionRegistry);
                if (pickupsBuilder_ == null) {
                  ensurePickupsIsMutable();
                  pickups_.add(m);
                } else {
                  pickupsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.optimization.v1.Shipment.VisitRequest m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.Shipment.VisitRequest.parser(),
                        extensionRegistry);
                if (deliveriesBuilder_ == null) {
                  ensureDeliveriesIsMutable();
                  deliveries_.add(m);
                } else {
                  deliveriesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.optimization.v1.CapacityQuantity m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.CapacityQuantity.parser(),
                        extensionRegistry);
                if (demandsBuilder_ == null) {
                  ensureDemandsIsMutable();
                  demands_.add(m);
                } else {
                  demandsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 33:
              {
                penaltyCost_ = input.readDouble();
                bitField0_ |= 0x00000008;
                break;
              } // case 33
            case 40:
              {
                int v = input.readInt32();
                ensureAllowedVehicleIndicesIsMutable();
                allowedVehicleIndices_.addInt(v);
                break;
              } // case 40
            case 42:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureAllowedVehicleIndicesIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  allowedVehicleIndices_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 42
            case 49:
              {
                double v = input.readDouble();
                ensureCostsPerVehicleIsMutable();
                costsPerVehicle_.addDouble(v);
                break;
              } // case 49
            case 50:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureCostsPerVehicleIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  costsPerVehicle_.addDouble(input.readDouble());
                }
                input.popLimit(limit);
                break;
              } // case 50
            case 56:
              {
                int v = input.readInt32();
                ensureCostsPerVehicleIndicesIsMutable();
                costsPerVehicleIndices_.addInt(v);
                break;
              } // case 56
            case 58:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureCostsPerVehicleIndicesIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  costsPerVehicleIndices_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 58
            case 65:
              {
                pickupToDeliveryRelativeDetourLimit_ = input.readDouble();
                bitField0_ |= 0x00000080;
                break;
              } // case 65
            case 74:
              {
                input.readMessage(
                    getPickupToDeliveryAbsoluteDetourLimitFieldBuilder().getBuilder(),
                    extensionRegistry);

                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getPickupToDeliveryTimeLimitFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 82
            case 90:
              {
                shipmentType_ = input.readStringRequireUtf8();

                break;
              } // case 90
            case 98:
              {
                label_ = input.readStringRequireUtf8();

                break;
              } // case 98
            case 104:
              {
                ignore_ = input.readBool();

                break;
              } // case 104
            case 114:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
                    loadDemands__ =
                        input.readMessage(
                            LoadDemandsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableLoadDemands()
                    .getMutableMap()
                    .put(loadDemands__.getKey(), loadDemands__.getValue());
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.optimization.v1.Shipment.VisitRequest> pickups_ =
        java.util.Collections.emptyList();

    private void ensurePickupsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        pickups_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.Shipment.VisitRequest>(
                pickups_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.Shipment.VisitRequest,
            com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder,
            com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder>
        pickupsBuilder_;

    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.Shipment.VisitRequest> getPickupsList() {
      if (pickupsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pickups_);
      } else {
        return pickupsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public int getPickupsCount() {
      if (pickupsBuilder_ == null) {
        return pickups_.size();
      } else {
        return pickupsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.VisitRequest getPickups(int index) {
      if (pickupsBuilder_ == null) {
        return pickups_.get(index);
      } else {
        return pickupsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public Builder setPickups(
        int index, com.google.cloud.optimization.v1.Shipment.VisitRequest value) {
      if (pickupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePickupsIsMutable();
        pickups_.set(index, value);
        onChanged();
      } else {
        pickupsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public Builder setPickups(
        int index, com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder builderForValue) {
      if (pickupsBuilder_ == null) {
        ensurePickupsIsMutable();
        pickups_.set(index, builderForValue.build());
        onChanged();
      } else {
        pickupsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public Builder addPickups(com.google.cloud.optimization.v1.Shipment.VisitRequest value) {
      if (pickupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePickupsIsMutable();
        pickups_.add(value);
        onChanged();
      } else {
        pickupsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public Builder addPickups(
        int index, com.google.cloud.optimization.v1.Shipment.VisitRequest value) {
      if (pickupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePickupsIsMutable();
        pickups_.add(index, value);
        onChanged();
      } else {
        pickupsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public Builder addPickups(
        com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder builderForValue) {
      if (pickupsBuilder_ == null) {
        ensurePickupsIsMutable();
        pickups_.add(builderForValue.build());
        onChanged();
      } else {
        pickupsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public Builder addPickups(
        int index, com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder builderForValue) {
      if (pickupsBuilder_ == null) {
        ensurePickupsIsMutable();
        pickups_.add(index, builderForValue.build());
        onChanged();
      } else {
        pickupsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public Builder addAllPickups(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.Shipment.VisitRequest>
            values) {
      if (pickupsBuilder_ == null) {
        ensurePickupsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pickups_);
        onChanged();
      } else {
        pickupsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public Builder clearPickups() {
      if (pickupsBuilder_ == null) {
        pickups_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        pickupsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public Builder removePickups(int index) {
      if (pickupsBuilder_ == null) {
        ensurePickupsIsMutable();
        pickups_.remove(index);
        onChanged();
      } else {
        pickupsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder getPickupsBuilder(
        int index) {
      return getPickupsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder getPickupsOrBuilder(
        int index) {
      if (pickupsBuilder_ == null) {
        return pickups_.get(index);
      } else {
        return pickupsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder>
        getPickupsOrBuilderList() {
      if (pickupsBuilder_ != null) {
        return pickupsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pickups_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder addPickupsBuilder() {
      return getPickupsFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.Shipment.VisitRequest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder addPickupsBuilder(
        int index) {
      return getPickupsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.Shipment.VisitRequest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of pickup alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the deliveries.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest pickups = 1;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder>
        getPickupsBuilderList() {
      return getPickupsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.Shipment.VisitRequest,
            com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder,
            com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder>
        getPickupsFieldBuilder() {
      if (pickupsBuilder_ == null) {
        pickupsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.Shipment.VisitRequest,
                com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder,
                com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder>(
                pickups_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        pickups_ = null;
      }
      return pickupsBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.Shipment.VisitRequest> deliveries_ =
        java.util.Collections.emptyList();

    private void ensureDeliveriesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        deliveries_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.Shipment.VisitRequest>(
                deliveries_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.Shipment.VisitRequest,
            com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder,
            com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder>
        deliveriesBuilder_;

    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.Shipment.VisitRequest>
        getDeliveriesList() {
      if (deliveriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(deliveries_);
      } else {
        return deliveriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public int getDeliveriesCount() {
      if (deliveriesBuilder_ == null) {
        return deliveries_.size();
      } else {
        return deliveriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.VisitRequest getDeliveries(int index) {
      if (deliveriesBuilder_ == null) {
        return deliveries_.get(index);
      } else {
        return deliveriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public Builder setDeliveries(
        int index, com.google.cloud.optimization.v1.Shipment.VisitRequest value) {
      if (deliveriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeliveriesIsMutable();
        deliveries_.set(index, value);
        onChanged();
      } else {
        deliveriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public Builder setDeliveries(
        int index, com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder builderForValue) {
      if (deliveriesBuilder_ == null) {
        ensureDeliveriesIsMutable();
        deliveries_.set(index, builderForValue.build());
        onChanged();
      } else {
        deliveriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public Builder addDeliveries(com.google.cloud.optimization.v1.Shipment.VisitRequest value) {
      if (deliveriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeliveriesIsMutable();
        deliveries_.add(value);
        onChanged();
      } else {
        deliveriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public Builder addDeliveries(
        int index, com.google.cloud.optimization.v1.Shipment.VisitRequest value) {
      if (deliveriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeliveriesIsMutable();
        deliveries_.add(index, value);
        onChanged();
      } else {
        deliveriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public Builder addDeliveries(
        com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder builderForValue) {
      if (deliveriesBuilder_ == null) {
        ensureDeliveriesIsMutable();
        deliveries_.add(builderForValue.build());
        onChanged();
      } else {
        deliveriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public Builder addDeliveries(
        int index, com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder builderForValue) {
      if (deliveriesBuilder_ == null) {
        ensureDeliveriesIsMutable();
        deliveries_.add(index, builderForValue.build());
        onChanged();
      } else {
        deliveriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public Builder addAllDeliveries(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.Shipment.VisitRequest>
            values) {
      if (deliveriesBuilder_ == null) {
        ensureDeliveriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deliveries_);
        onChanged();
      } else {
        deliveriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public Builder clearDeliveries() {
      if (deliveriesBuilder_ == null) {
        deliveries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        deliveriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public Builder removeDeliveries(int index) {
      if (deliveriesBuilder_ == null) {
        ensureDeliveriesIsMutable();
        deliveries_.remove(index);
        onChanged();
      } else {
        deliveriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder getDeliveriesBuilder(
        int index) {
      return getDeliveriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder getDeliveriesOrBuilder(
        int index) {
      if (deliveriesBuilder_ == null) {
        return deliveries_.get(index);
      } else {
        return deliveriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder>
        getDeliveriesOrBuilderList() {
      if (deliveriesBuilder_ != null) {
        return deliveriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(deliveries_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder addDeliveriesBuilder() {
      return getDeliveriesFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.Shipment.VisitRequest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder addDeliveriesBuilder(
        int index) {
      return getDeliveriesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.Shipment.VisitRequest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of delivery alternatives associated to the shipment. If not specified,
     * the vehicle only needs to visit a location corresponding to the pickups.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.Shipment.VisitRequest deliveries = 2;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder>
        getDeliveriesBuilderList() {
      return getDeliveriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.Shipment.VisitRequest,
            com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder,
            com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder>
        getDeliveriesFieldBuilder() {
      if (deliveriesBuilder_ == null) {
        deliveriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.Shipment.VisitRequest,
                com.google.cloud.optimization.v1.Shipment.VisitRequest.Builder,
                com.google.cloud.optimization.v1.Shipment.VisitRequestOrBuilder>(
                deliveries_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        deliveries_ = null;
      }
      return deliveriesBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        loadDemands_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        internalGetLoadDemands() {
      if (loadDemands_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            LoadDemandsDefaultEntryHolder.defaultEntry);
      }
      return loadDemands_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        internalGetMutableLoadDemands() {
      onChanged();
      ;
      if (loadDemands_ == null) {
        loadDemands_ =
            com.google.protobuf.MapField.newMapField(LoadDemandsDefaultEntryHolder.defaultEntry);
      }
      if (!loadDemands_.isMutable()) {
        loadDemands_ = loadDemands_.copy();
      }
      return loadDemands_;
    }

    public int getLoadDemandsCount() {
      return internalGetLoadDemands().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Load demands of the shipment (for example weight, volume, number of
     * pallets etc). The keys in the map should be identifiers describing the type
     * of the corresponding load, ideally also including the units.
     * For example: "weight_kg", "volume_gallons", "pallet_count", etc.
     * If a given key does not appear in the map, the corresponding load is
     * considered as null.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 14;
     * </code>
     */
    @java.lang.Override
    public boolean containsLoadDemands(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLoadDemands().getMap().containsKey(key);
    }
    /** Use {@link #getLoadDemandsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        getLoadDemands() {
      return getLoadDemandsMap();
    }
    /**
     *
     *
     * <pre>
     * Load demands of the shipment (for example weight, volume, number of
     * pallets etc). The keys in the map should be identifiers describing the type
     * of the corresponding load, ideally also including the units.
     * For example: "weight_kg", "volume_gallons", "pallet_count", etc.
     * If a given key does not appear in the map, the corresponding load is
     * considered as null.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 14;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        getLoadDemandsMap() {
      return internalGetLoadDemands().getMap();
    }
    /**
     *
     *
     * <pre>
     * Load demands of the shipment (for example weight, volume, number of
     * pallets etc). The keys in the map should be identifiers describing the type
     * of the corresponding load, ideally also including the units.
     * For example: "weight_kg", "volume_gallons", "pallet_count", etc.
     * If a given key does not appear in the map, the corresponding load is
     * considered as null.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrDefault(
        java.lang.String key, com.google.cloud.optimization.v1.Shipment.Load defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
          internalGetLoadDemands().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Load demands of the shipment (for example weight, volume, number of
     * pallets etc). The keys in the map should be identifiers describing the type
     * of the corresponding load, ideally also including the units.
     * For example: "weight_kg", "volume_gallons", "pallet_count", etc.
     * If a given key does not appear in the map, the corresponding load is
     * considered as null.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.Shipment.Load getLoadDemandsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> map =
          internalGetLoadDemands().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLoadDemands() {
      internalGetMutableLoadDemands().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Load demands of the shipment (for example weight, volume, number of
     * pallets etc). The keys in the map should be identifiers describing the type
     * of the corresponding load, ideally also including the units.
     * For example: "weight_kg", "volume_gallons", "pallet_count", etc.
     * If a given key does not appear in the map, the corresponding load is
     * considered as null.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 14;
     * </code>
     */
    public Builder removeLoadDemands(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLoadDemands().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load>
        getMutableLoadDemands() {
      return internalGetMutableLoadDemands().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Load demands of the shipment (for example weight, volume, number of
     * pallets etc). The keys in the map should be identifiers describing the type
     * of the corresponding load, ideally also including the units.
     * For example: "weight_kg", "volume_gallons", "pallet_count", etc.
     * If a given key does not appear in the map, the corresponding load is
     * considered as null.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 14;
     * </code>
     */
    public Builder putLoadDemands(
        java.lang.String key, com.google.cloud.optimization.v1.Shipment.Load value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLoadDemands().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Load demands of the shipment (for example weight, volume, number of
     * pallets etc). The keys in the map should be identifiers describing the type
     * of the corresponding load, ideally also including the units.
     * For example: "weight_kg", "volume_gallons", "pallet_count", etc.
     * If a given key does not appear in the map, the corresponding load is
     * considered as null.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.optimization.v1.Shipment.Load&gt; load_demands = 14;
     * </code>
     */
    public Builder putAllLoadDemands(
        java.util.Map<java.lang.String, com.google.cloud.optimization.v1.Shipment.Load> values) {
      internalGetMutableLoadDemands().getMutableMap().putAll(values);
      return this;
    }

    private double penaltyCost_;
    /**
     *
     *
     * <pre>
     * If the shipment is not completed, this penalty is added to the overall
     * cost of the routes. A shipment is considered completed if one of its pickup
     * and delivery alternatives is visited. The cost may be expressed in the
     * same unit used for all other cost-related fields in the model and must be
     * positive.
     * *IMPORTANT*: If this penalty is not specified, it is considered infinite,
     * i.e. the shipment must be completed.
     * </pre>
     *
     * <code>optional double penalty_cost = 4;</code>
     *
     * @return Whether the penaltyCost field is set.
     */
    @java.lang.Override
    public boolean hasPenaltyCost() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * If the shipment is not completed, this penalty is added to the overall
     * cost of the routes. A shipment is considered completed if one of its pickup
     * and delivery alternatives is visited. The cost may be expressed in the
     * same unit used for all other cost-related fields in the model and must be
     * positive.
     * *IMPORTANT*: If this penalty is not specified, it is considered infinite,
     * i.e. the shipment must be completed.
     * </pre>
     *
     * <code>optional double penalty_cost = 4;</code>
     *
     * @return The penaltyCost.
     */
    @java.lang.Override
    public double getPenaltyCost() {
      return penaltyCost_;
    }
    /**
     *
     *
     * <pre>
     * If the shipment is not completed, this penalty is added to the overall
     * cost of the routes. A shipment is considered completed if one of its pickup
     * and delivery alternatives is visited. The cost may be expressed in the
     * same unit used for all other cost-related fields in the model and must be
     * positive.
     * *IMPORTANT*: If this penalty is not specified, it is considered infinite,
     * i.e. the shipment must be completed.
     * </pre>
     *
     * <code>optional double penalty_cost = 4;</code>
     *
     * @param value The penaltyCost to set.
     * @return This builder for chaining.
     */
    public Builder setPenaltyCost(double value) {
      bitField0_ |= 0x00000008;
      penaltyCost_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the shipment is not completed, this penalty is added to the overall
     * cost of the routes. A shipment is considered completed if one of its pickup
     * and delivery alternatives is visited. The cost may be expressed in the
     * same unit used for all other cost-related fields in the model and must be
     * positive.
     * *IMPORTANT*: If this penalty is not specified, it is considered infinite,
     * i.e. the shipment must be completed.
     * </pre>
     *
     * <code>optional double penalty_cost = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPenaltyCost() {
      bitField0_ = (bitField0_ & ~0x00000008);
      penaltyCost_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList allowedVehicleIndices_ = emptyIntList();

    private void ensureAllowedVehicleIndicesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        allowedVehicleIndices_ = mutableCopy(allowedVehicleIndices_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     *
     *
     * <pre>
     * The set of vehicles that may perform this shipment. If empty, all vehicles
     * may perform it. Vehicles are given by their index in the `ShipmentModel`'s
     * `vehicles` list.
     * </pre>
     *
     * <code>repeated int32 allowed_vehicle_indices = 5;</code>
     *
     * @return A list containing the allowedVehicleIndices.
     */
    public java.util.List<java.lang.Integer> getAllowedVehicleIndicesList() {
      return ((bitField0_ & 0x00000010) != 0)
          ? java.util.Collections.unmodifiableList(allowedVehicleIndices_)
          : allowedVehicleIndices_;
    }
    /**
     *
     *
     * <pre>
     * The set of vehicles that may perform this shipment. If empty, all vehicles
     * may perform it. Vehicles are given by their index in the `ShipmentModel`'s
     * `vehicles` list.
     * </pre>
     *
     * <code>repeated int32 allowed_vehicle_indices = 5;</code>
     *
     * @return The count of allowedVehicleIndices.
     */
    public int getAllowedVehicleIndicesCount() {
      return allowedVehicleIndices_.size();
    }
    /**
     *
     *
     * <pre>
     * The set of vehicles that may perform this shipment. If empty, all vehicles
     * may perform it. Vehicles are given by their index in the `ShipmentModel`'s
     * `vehicles` list.
     * </pre>
     *
     * <code>repeated int32 allowed_vehicle_indices = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedVehicleIndices at the given index.
     */
    public int getAllowedVehicleIndices(int index) {
      return allowedVehicleIndices_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * The set of vehicles that may perform this shipment. If empty, all vehicles
     * may perform it. Vehicles are given by their index in the `ShipmentModel`'s
     * `vehicles` list.
     * </pre>
     *
     * <code>repeated int32 allowed_vehicle_indices = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowedVehicleIndices to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedVehicleIndices(int index, int value) {
      ensureAllowedVehicleIndicesIsMutable();
      allowedVehicleIndices_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of vehicles that may perform this shipment. If empty, all vehicles
     * may perform it. Vehicles are given by their index in the `ShipmentModel`'s
     * `vehicles` list.
     * </pre>
     *
     * <code>repeated int32 allowed_vehicle_indices = 5;</code>
     *
     * @param value The allowedVehicleIndices to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedVehicleIndices(int value) {
      ensureAllowedVehicleIndicesIsMutable();
      allowedVehicleIndices_.addInt(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of vehicles that may perform this shipment. If empty, all vehicles
     * may perform it. Vehicles are given by their index in the `ShipmentModel`'s
     * `vehicles` list.
     * </pre>
     *
     * <code>repeated int32 allowed_vehicle_indices = 5;</code>
     *
     * @param values The allowedVehicleIndices to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedVehicleIndices(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureAllowedVehicleIndicesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedVehicleIndices_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of vehicles that may perform this shipment. If empty, all vehicles
     * may perform it. Vehicles are given by their index in the `ShipmentModel`'s
     * `vehicles` list.
     * </pre>
     *
     * <code>repeated int32 allowed_vehicle_indices = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedVehicleIndices() {
      allowedVehicleIndices_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList costsPerVehicle_ = emptyDoubleList();

    private void ensureCostsPerVehicleIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        costsPerVehicle_ = mutableCopy(costsPerVehicle_);
        bitField0_ |= 0x00000020;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the cost that is incurred when this shipment is delivered by each
     * vehicle. If specified, it must have EITHER:
     *   * the same number of elements as `costs_per_vehicle_indices`.
     *     `costs_per_vehicle[i]` corresponds to vehicle
     *     `costs_per_vehicle_indices[i]` of the model.
     *   * the same number of elements as there are vehicles in the model. The
     *     i-th element corresponds to vehicle #i of the model.
     * These costs must be in the same unit as `penalty_cost` and must not be
     * negative. Leave this field empty, if there are no such costs.
     * </pre>
     *
     * <code>repeated double costs_per_vehicle = 6;</code>
     *
     * @return A list containing the costsPerVehicle.
     */
    public java.util.List<java.lang.Double> getCostsPerVehicleList() {
      return ((bitField0_ & 0x00000020) != 0)
          ? java.util.Collections.unmodifiableList(costsPerVehicle_)
          : costsPerVehicle_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the cost that is incurred when this shipment is delivered by each
     * vehicle. If specified, it must have EITHER:
     *   * the same number of elements as `costs_per_vehicle_indices`.
     *     `costs_per_vehicle[i]` corresponds to vehicle
     *     `costs_per_vehicle_indices[i]` of the model.
     *   * the same number of elements as there are vehicles in the model. The
     *     i-th element corresponds to vehicle #i of the model.
     * These costs must be in the same unit as `penalty_cost` and must not be
     * negative. Leave this field empty, if there are no such costs.
     * </pre>
     *
     * <code>repeated double costs_per_vehicle = 6;</code>
     *
     * @return The count of costsPerVehicle.
     */
    public int getCostsPerVehicleCount() {
      return costsPerVehicle_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies the cost that is incurred when this shipment is delivered by each
     * vehicle. If specified, it must have EITHER:
     *   * the same number of elements as `costs_per_vehicle_indices`.
     *     `costs_per_vehicle[i]` corresponds to vehicle
     *     `costs_per_vehicle_indices[i]` of the model.
     *   * the same number of elements as there are vehicles in the model. The
     *     i-th element corresponds to vehicle #i of the model.
     * These costs must be in the same unit as `penalty_cost` and must not be
     * negative. Leave this field empty, if there are no such costs.
     * </pre>
     *
     * <code>repeated double costs_per_vehicle = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The costsPerVehicle at the given index.
     */
    public double getCostsPerVehicle(int index) {
      return costsPerVehicle_.getDouble(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies the cost that is incurred when this shipment is delivered by each
     * vehicle. If specified, it must have EITHER:
     *   * the same number of elements as `costs_per_vehicle_indices`.
     *     `costs_per_vehicle[i]` corresponds to vehicle
     *     `costs_per_vehicle_indices[i]` of the model.
     *   * the same number of elements as there are vehicles in the model. The
     *     i-th element corresponds to vehicle #i of the model.
     * These costs must be in the same unit as `penalty_cost` and must not be
     * negative. Leave this field empty, if there are no such costs.
     * </pre>
     *
     * <code>repeated double costs_per_vehicle = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The costsPerVehicle to set.
     * @return This builder for chaining.
     */
    public Builder setCostsPerVehicle(int index, double value) {
      ensureCostsPerVehicleIsMutable();
      costsPerVehicle_.setDouble(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the cost that is incurred when this shipment is delivered by each
     * vehicle. If specified, it must have EITHER:
     *   * the same number of elements as `costs_per_vehicle_indices`.
     *     `costs_per_vehicle[i]` corresponds to vehicle
     *     `costs_per_vehicle_indices[i]` of the model.
     *   * the same number of elements as there are vehicles in the model. The
     *     i-th element corresponds to vehicle #i of the model.
     * These costs must be in the same unit as `penalty_cost` and must not be
     * negative. Leave this field empty, if there are no such costs.
     * </pre>
     *
     * <code>repeated double costs_per_vehicle = 6;</code>
     *
     * @param value The costsPerVehicle to add.
     * @return This builder for chaining.
     */
    public Builder addCostsPerVehicle(double value) {
      ensureCostsPerVehicleIsMutable();
      costsPerVehicle_.addDouble(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the cost that is incurred when this shipment is delivered by each
     * vehicle. If specified, it must have EITHER:
     *   * the same number of elements as `costs_per_vehicle_indices`.
     *     `costs_per_vehicle[i]` corresponds to vehicle
     *     `costs_per_vehicle_indices[i]` of the model.
     *   * the same number of elements as there are vehicles in the model. The
     *     i-th element corresponds to vehicle #i of the model.
     * These costs must be in the same unit as `penalty_cost` and must not be
     * negative. Leave this field empty, if there are no such costs.
     * </pre>
     *
     * <code>repeated double costs_per_vehicle = 6;</code>
     *
     * @param values The costsPerVehicle to add.
     * @return This builder for chaining.
     */
    public Builder addAllCostsPerVehicle(java.lang.Iterable<? extends java.lang.Double> values) {
      ensureCostsPerVehicleIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, costsPerVehicle_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the cost that is incurred when this shipment is delivered by each
     * vehicle. If specified, it must have EITHER:
     *   * the same number of elements as `costs_per_vehicle_indices`.
     *     `costs_per_vehicle[i]` corresponds to vehicle
     *     `costs_per_vehicle_indices[i]` of the model.
     *   * the same number of elements as there are vehicles in the model. The
     *     i-th element corresponds to vehicle #i of the model.
     * These costs must be in the same unit as `penalty_cost` and must not be
     * negative. Leave this field empty, if there are no such costs.
     * </pre>
     *
     * <code>repeated double costs_per_vehicle = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCostsPerVehicle() {
      costsPerVehicle_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList costsPerVehicleIndices_ = emptyIntList();

    private void ensureCostsPerVehicleIndicesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        costsPerVehicleIndices_ = mutableCopy(costsPerVehicleIndices_);
        bitField0_ |= 0x00000040;
      }
    }
    /**
     *
     *
     * <pre>
     * Indices of the vehicles to which `costs_per_vehicle` applies. If non-empty,
     * it must have the same number of elements as `costs_per_vehicle`. A vehicle
     * index may not be specified more than once. If a vehicle is excluded from
     * `costs_per_vehicle_indices`, its cost is zero.
     * </pre>
     *
     * <code>repeated int32 costs_per_vehicle_indices = 7;</code>
     *
     * @return A list containing the costsPerVehicleIndices.
     */
    public java.util.List<java.lang.Integer> getCostsPerVehicleIndicesList() {
      return ((bitField0_ & 0x00000040) != 0)
          ? java.util.Collections.unmodifiableList(costsPerVehicleIndices_)
          : costsPerVehicleIndices_;
    }
    /**
     *
     *
     * <pre>
     * Indices of the vehicles to which `costs_per_vehicle` applies. If non-empty,
     * it must have the same number of elements as `costs_per_vehicle`. A vehicle
     * index may not be specified more than once. If a vehicle is excluded from
     * `costs_per_vehicle_indices`, its cost is zero.
     * </pre>
     *
     * <code>repeated int32 costs_per_vehicle_indices = 7;</code>
     *
     * @return The count of costsPerVehicleIndices.
     */
    public int getCostsPerVehicleIndicesCount() {
      return costsPerVehicleIndices_.size();
    }
    /**
     *
     *
     * <pre>
     * Indices of the vehicles to which `costs_per_vehicle` applies. If non-empty,
     * it must have the same number of elements as `costs_per_vehicle`. A vehicle
     * index may not be specified more than once. If a vehicle is excluded from
     * `costs_per_vehicle_indices`, its cost is zero.
     * </pre>
     *
     * <code>repeated int32 costs_per_vehicle_indices = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The costsPerVehicleIndices at the given index.
     */
    public int getCostsPerVehicleIndices(int index) {
      return costsPerVehicleIndices_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * Indices of the vehicles to which `costs_per_vehicle` applies. If non-empty,
     * it must have the same number of elements as `costs_per_vehicle`. A vehicle
     * index may not be specified more than once. If a vehicle is excluded from
     * `costs_per_vehicle_indices`, its cost is zero.
     * </pre>
     *
     * <code>repeated int32 costs_per_vehicle_indices = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The costsPerVehicleIndices to set.
     * @return This builder for chaining.
     */
    public Builder setCostsPerVehicleIndices(int index, int value) {
      ensureCostsPerVehicleIndicesIsMutable();
      costsPerVehicleIndices_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indices of the vehicles to which `costs_per_vehicle` applies. If non-empty,
     * it must have the same number of elements as `costs_per_vehicle`. A vehicle
     * index may not be specified more than once. If a vehicle is excluded from
     * `costs_per_vehicle_indices`, its cost is zero.
     * </pre>
     *
     * <code>repeated int32 costs_per_vehicle_indices = 7;</code>
     *
     * @param value The costsPerVehicleIndices to add.
     * @return This builder for chaining.
     */
    public Builder addCostsPerVehicleIndices(int value) {
      ensureCostsPerVehicleIndicesIsMutable();
      costsPerVehicleIndices_.addInt(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indices of the vehicles to which `costs_per_vehicle` applies. If non-empty,
     * it must have the same number of elements as `costs_per_vehicle`. A vehicle
     * index may not be specified more than once. If a vehicle is excluded from
     * `costs_per_vehicle_indices`, its cost is zero.
     * </pre>
     *
     * <code>repeated int32 costs_per_vehicle_indices = 7;</code>
     *
     * @param values The costsPerVehicleIndices to add.
     * @return This builder for chaining.
     */
    public Builder addAllCostsPerVehicleIndices(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureCostsPerVehicleIndicesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, costsPerVehicleIndices_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indices of the vehicles to which `costs_per_vehicle` applies. If non-empty,
     * it must have the same number of elements as `costs_per_vehicle`. A vehicle
     * index may not be specified more than once. If a vehicle is excluded from
     * `costs_per_vehicle_indices`, its cost is zero.
     * </pre>
     *
     * <code>repeated int32 costs_per_vehicle_indices = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCostsPerVehicleIndices() {
      costsPerVehicleIndices_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    private double pickupToDeliveryRelativeDetourLimit_;
    /**
     *
     *
     * <pre>
     * Specifies the maximum relative detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_relative_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * std::ceil(t * (1.0 + pickup_to_delivery_relative_detour_limit))
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>optional double pickup_to_delivery_relative_detour_limit = 8;</code>
     *
     * @return Whether the pickupToDeliveryRelativeDetourLimit field is set.
     */
    @java.lang.Override
    public boolean hasPickupToDeliveryRelativeDetourLimit() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum relative detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_relative_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * std::ceil(t * (1.0 + pickup_to_delivery_relative_detour_limit))
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>optional double pickup_to_delivery_relative_detour_limit = 8;</code>
     *
     * @return The pickupToDeliveryRelativeDetourLimit.
     */
    @java.lang.Override
    public double getPickupToDeliveryRelativeDetourLimit() {
      return pickupToDeliveryRelativeDetourLimit_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum relative detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_relative_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * std::ceil(t * (1.0 + pickup_to_delivery_relative_detour_limit))
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>optional double pickup_to_delivery_relative_detour_limit = 8;</code>
     *
     * @param value The pickupToDeliveryRelativeDetourLimit to set.
     * @return This builder for chaining.
     */
    public Builder setPickupToDeliveryRelativeDetourLimit(double value) {
      bitField0_ |= 0x00000080;
      pickupToDeliveryRelativeDetourLimit_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum relative detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_relative_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * std::ceil(t * (1.0 + pickup_to_delivery_relative_detour_limit))
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>optional double pickup_to_delivery_relative_detour_limit = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPickupToDeliveryRelativeDetourLimit() {
      bitField0_ = (bitField0_ & ~0x00000080);
      pickupToDeliveryRelativeDetourLimit_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration pickupToDeliveryAbsoluteDetourLimit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        pickupToDeliveryAbsoluteDetourLimitBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the maximum absolute detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_absolute_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * t + pickup_to_delivery_absolute_detour_limit
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
     *
     * @return Whether the pickupToDeliveryAbsoluteDetourLimit field is set.
     */
    public boolean hasPickupToDeliveryAbsoluteDetourLimit() {
      return pickupToDeliveryAbsoluteDetourLimitBuilder_ != null
          || pickupToDeliveryAbsoluteDetourLimit_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum absolute detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_absolute_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * t + pickup_to_delivery_absolute_detour_limit
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
     *
     * @return The pickupToDeliveryAbsoluteDetourLimit.
     */
    public com.google.protobuf.Duration getPickupToDeliveryAbsoluteDetourLimit() {
      if (pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
        return pickupToDeliveryAbsoluteDetourLimit_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : pickupToDeliveryAbsoluteDetourLimit_;
      } else {
        return pickupToDeliveryAbsoluteDetourLimitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum absolute detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_absolute_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * t + pickup_to_delivery_absolute_detour_limit
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
     */
    public Builder setPickupToDeliveryAbsoluteDetourLimit(com.google.protobuf.Duration value) {
      if (pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pickupToDeliveryAbsoluteDetourLimit_ = value;
        onChanged();
      } else {
        pickupToDeliveryAbsoluteDetourLimitBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum absolute detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_absolute_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * t + pickup_to_delivery_absolute_detour_limit
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
     */
    public Builder setPickupToDeliveryAbsoluteDetourLimit(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
        pickupToDeliveryAbsoluteDetourLimit_ = builderForValue.build();
        onChanged();
      } else {
        pickupToDeliveryAbsoluteDetourLimitBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum absolute detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_absolute_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * t + pickup_to_delivery_absolute_detour_limit
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
     */
    public Builder mergePickupToDeliveryAbsoluteDetourLimit(com.google.protobuf.Duration value) {
      if (pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
        if (pickupToDeliveryAbsoluteDetourLimit_ != null) {
          pickupToDeliveryAbsoluteDetourLimit_ =
              com.google.protobuf.Duration.newBuilder(pickupToDeliveryAbsoluteDetourLimit_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pickupToDeliveryAbsoluteDetourLimit_ = value;
        }
        onChanged();
      } else {
        pickupToDeliveryAbsoluteDetourLimitBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum absolute detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_absolute_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * t + pickup_to_delivery_absolute_detour_limit
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
     */
    public Builder clearPickupToDeliveryAbsoluteDetourLimit() {
      if (pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
        pickupToDeliveryAbsoluteDetourLimit_ = null;
        onChanged();
      } else {
        pickupToDeliveryAbsoluteDetourLimit_ = null;
        pickupToDeliveryAbsoluteDetourLimitBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum absolute detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_absolute_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * t + pickup_to_delivery_absolute_detour_limit
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
     */
    public com.google.protobuf.Duration.Builder getPickupToDeliveryAbsoluteDetourLimitBuilder() {

      onChanged();
      return getPickupToDeliveryAbsoluteDetourLimitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum absolute detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_absolute_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * t + pickup_to_delivery_absolute_detour_limit
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
     */
    public com.google.protobuf.DurationOrBuilder getPickupToDeliveryAbsoluteDetourLimitOrBuilder() {
      if (pickupToDeliveryAbsoluteDetourLimitBuilder_ != null) {
        return pickupToDeliveryAbsoluteDetourLimitBuilder_.getMessageOrBuilder();
      } else {
        return pickupToDeliveryAbsoluteDetourLimit_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : pickupToDeliveryAbsoluteDetourLimit_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum absolute detour time compared to the shortest path
     * from pickup to delivery. If specified, it must be nonnegative, and the
     * shipment must contain at least a pickup and a delivery.
     * For example, let t be the shortest time taken to go from the selected
     * pickup alternative directly to the selected delivery alternative. Then
     * setting `pickup_to_delivery_absolute_detour_limit` enforces:
     * ```
     * start_time(delivery) - start_time(pickup) &lt;=
     * t + pickup_to_delivery_absolute_detour_limit
     * ```
     * If both relative and absolute limits are specified on the same shipment,
     * the more constraining limit is used for each possible pickup/delivery pair.
     * As of 2017/10, detours are only supported when travel durations do not
     * depend on vehicles.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_absolute_detour_limit = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getPickupToDeliveryAbsoluteDetourLimitFieldBuilder() {
      if (pickupToDeliveryAbsoluteDetourLimitBuilder_ == null) {
        pickupToDeliveryAbsoluteDetourLimitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getPickupToDeliveryAbsoluteDetourLimit(), getParentForChildren(), isClean());
        pickupToDeliveryAbsoluteDetourLimit_ = null;
      }
      return pickupToDeliveryAbsoluteDetourLimitBuilder_;
    }

    private com.google.protobuf.Duration pickupToDeliveryTimeLimit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        pickupToDeliveryTimeLimitBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration from start of pickup to start of delivery of
     * a shipment. If specified, it must be nonnegative, and the shipment must
     * contain at least a pickup and a delivery. This does not depend on which
     * alternatives are selected for pickup and delivery, nor on vehicle speed.
     * This can be specified alongside maximum detour constraints: the solution
     * will respect both specifications.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
     *
     * @return Whether the pickupToDeliveryTimeLimit field is set.
     */
    public boolean hasPickupToDeliveryTimeLimit() {
      return pickupToDeliveryTimeLimitBuilder_ != null || pickupToDeliveryTimeLimit_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration from start of pickup to start of delivery of
     * a shipment. If specified, it must be nonnegative, and the shipment must
     * contain at least a pickup and a delivery. This does not depend on which
     * alternatives are selected for pickup and delivery, nor on vehicle speed.
     * This can be specified alongside maximum detour constraints: the solution
     * will respect both specifications.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
     *
     * @return The pickupToDeliveryTimeLimit.
     */
    public com.google.protobuf.Duration getPickupToDeliveryTimeLimit() {
      if (pickupToDeliveryTimeLimitBuilder_ == null) {
        return pickupToDeliveryTimeLimit_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : pickupToDeliveryTimeLimit_;
      } else {
        return pickupToDeliveryTimeLimitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration from start of pickup to start of delivery of
     * a shipment. If specified, it must be nonnegative, and the shipment must
     * contain at least a pickup and a delivery. This does not depend on which
     * alternatives are selected for pickup and delivery, nor on vehicle speed.
     * This can be specified alongside maximum detour constraints: the solution
     * will respect both specifications.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
     */
    public Builder setPickupToDeliveryTimeLimit(com.google.protobuf.Duration value) {
      if (pickupToDeliveryTimeLimitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pickupToDeliveryTimeLimit_ = value;
        onChanged();
      } else {
        pickupToDeliveryTimeLimitBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration from start of pickup to start of delivery of
     * a shipment. If specified, it must be nonnegative, and the shipment must
     * contain at least a pickup and a delivery. This does not depend on which
     * alternatives are selected for pickup and delivery, nor on vehicle speed.
     * This can be specified alongside maximum detour constraints: the solution
     * will respect both specifications.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
     */
    public Builder setPickupToDeliveryTimeLimit(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (pickupToDeliveryTimeLimitBuilder_ == null) {
        pickupToDeliveryTimeLimit_ = builderForValue.build();
        onChanged();
      } else {
        pickupToDeliveryTimeLimitBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration from start of pickup to start of delivery of
     * a shipment. If specified, it must be nonnegative, and the shipment must
     * contain at least a pickup and a delivery. This does not depend on which
     * alternatives are selected for pickup and delivery, nor on vehicle speed.
     * This can be specified alongside maximum detour constraints: the solution
     * will respect both specifications.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
     */
    public Builder mergePickupToDeliveryTimeLimit(com.google.protobuf.Duration value) {
      if (pickupToDeliveryTimeLimitBuilder_ == null) {
        if (pickupToDeliveryTimeLimit_ != null) {
          pickupToDeliveryTimeLimit_ =
              com.google.protobuf.Duration.newBuilder(pickupToDeliveryTimeLimit_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pickupToDeliveryTimeLimit_ = value;
        }
        onChanged();
      } else {
        pickupToDeliveryTimeLimitBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration from start of pickup to start of delivery of
     * a shipment. If specified, it must be nonnegative, and the shipment must
     * contain at least a pickup and a delivery. This does not depend on which
     * alternatives are selected for pickup and delivery, nor on vehicle speed.
     * This can be specified alongside maximum detour constraints: the solution
     * will respect both specifications.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
     */
    public Builder clearPickupToDeliveryTimeLimit() {
      if (pickupToDeliveryTimeLimitBuilder_ == null) {
        pickupToDeliveryTimeLimit_ = null;
        onChanged();
      } else {
        pickupToDeliveryTimeLimit_ = null;
        pickupToDeliveryTimeLimitBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration from start of pickup to start of delivery of
     * a shipment. If specified, it must be nonnegative, and the shipment must
     * contain at least a pickup and a delivery. This does not depend on which
     * alternatives are selected for pickup and delivery, nor on vehicle speed.
     * This can be specified alongside maximum detour constraints: the solution
     * will respect both specifications.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
     */
    public com.google.protobuf.Duration.Builder getPickupToDeliveryTimeLimitBuilder() {

      onChanged();
      return getPickupToDeliveryTimeLimitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration from start of pickup to start of delivery of
     * a shipment. If specified, it must be nonnegative, and the shipment must
     * contain at least a pickup and a delivery. This does not depend on which
     * alternatives are selected for pickup and delivery, nor on vehicle speed.
     * This can be specified alongside maximum detour constraints: the solution
     * will respect both specifications.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
     */
    public com.google.protobuf.DurationOrBuilder getPickupToDeliveryTimeLimitOrBuilder() {
      if (pickupToDeliveryTimeLimitBuilder_ != null) {
        return pickupToDeliveryTimeLimitBuilder_.getMessageOrBuilder();
      } else {
        return pickupToDeliveryTimeLimit_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : pickupToDeliveryTimeLimit_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum duration from start of pickup to start of delivery of
     * a shipment. If specified, it must be nonnegative, and the shipment must
     * contain at least a pickup and a delivery. This does not depend on which
     * alternatives are selected for pickup and delivery, nor on vehicle speed.
     * This can be specified alongside maximum detour constraints: the solution
     * will respect both specifications.
     * </pre>
     *
     * <code>.google.protobuf.Duration pickup_to_delivery_time_limit = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getPickupToDeliveryTimeLimitFieldBuilder() {
      if (pickupToDeliveryTimeLimitBuilder_ == null) {
        pickupToDeliveryTimeLimitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getPickupToDeliveryTimeLimit(), getParentForChildren(), isClean());
        pickupToDeliveryTimeLimit_ = null;
      }
      return pickupToDeliveryTimeLimitBuilder_;
    }

    private java.lang.Object shipmentType_ = "";
    /**
     *
     *
     * <pre>
     * Non-empty string specifying a "type" for this shipment.
     * This feature can be used to define incompatibilities or requirements
     * between `shipment_types` (see `shipment_type_incompatibilities` and
     * `shipment_type_requirements` in `ShipmentModel`).
     * Differs from `visit_types` which is specified for a single visit: All
     * pickup/deliveries belonging to the same shipment share the same
     * `shipment_type`.
     * </pre>
     *
     * <code>string shipment_type = 11;</code>
     *
     * @return The shipmentType.
     */
    public java.lang.String getShipmentType() {
      java.lang.Object ref = shipmentType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        shipmentType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Non-empty string specifying a "type" for this shipment.
     * This feature can be used to define incompatibilities or requirements
     * between `shipment_types` (see `shipment_type_incompatibilities` and
     * `shipment_type_requirements` in `ShipmentModel`).
     * Differs from `visit_types` which is specified for a single visit: All
     * pickup/deliveries belonging to the same shipment share the same
     * `shipment_type`.
     * </pre>
     *
     * <code>string shipment_type = 11;</code>
     *
     * @return The bytes for shipmentType.
     */
    public com.google.protobuf.ByteString getShipmentTypeBytes() {
      java.lang.Object ref = shipmentType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        shipmentType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Non-empty string specifying a "type" for this shipment.
     * This feature can be used to define incompatibilities or requirements
     * between `shipment_types` (see `shipment_type_incompatibilities` and
     * `shipment_type_requirements` in `ShipmentModel`).
     * Differs from `visit_types` which is specified for a single visit: All
     * pickup/deliveries belonging to the same shipment share the same
     * `shipment_type`.
     * </pre>
     *
     * <code>string shipment_type = 11;</code>
     *
     * @param value The shipmentType to set.
     * @return This builder for chaining.
     */
    public Builder setShipmentType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      shipmentType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Non-empty string specifying a "type" for this shipment.
     * This feature can be used to define incompatibilities or requirements
     * between `shipment_types` (see `shipment_type_incompatibilities` and
     * `shipment_type_requirements` in `ShipmentModel`).
     * Differs from `visit_types` which is specified for a single visit: All
     * pickup/deliveries belonging to the same shipment share the same
     * `shipment_type`.
     * </pre>
     *
     * <code>string shipment_type = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShipmentType() {

      shipmentType_ = getDefaultInstance().getShipmentType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Non-empty string specifying a "type" for this shipment.
     * This feature can be used to define incompatibilities or requirements
     * between `shipment_types` (see `shipment_type_incompatibilities` and
     * `shipment_type_requirements` in `ShipmentModel`).
     * Differs from `visit_types` which is specified for a single visit: All
     * pickup/deliveries belonging to the same shipment share the same
     * `shipment_type`.
     * </pre>
     *
     * <code>string shipment_type = 11;</code>
     *
     * @param value The bytes for shipmentType to set.
     * @return This builder for chaining.
     */
    public Builder setShipmentTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      shipmentType_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object label_ = "";
    /**
     *
     *
     * <pre>
     * Specifies a label for this shipment. This label is reported in the response
     * in the `shipment_label` of the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
     * </pre>
     *
     * <code>string label = 12;</code>
     *
     * @return The label.
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a label for this shipment. This label is reported in the response
     * in the `shipment_label` of the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
     * </pre>
     *
     * <code>string label = 12;</code>
     *
     * @return The bytes for label.
     */
    public com.google.protobuf.ByteString getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a label for this shipment. This label is reported in the response
     * in the `shipment_label` of the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
     * </pre>
     *
     * <code>string label = 12;</code>
     *
     * @param value The label to set.
     * @return This builder for chaining.
     */
    public Builder setLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      label_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a label for this shipment. This label is reported in the response
     * in the `shipment_label` of the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
     * </pre>
     *
     * <code>string label = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabel() {

      label_ = getDefaultInstance().getLabel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a label for this shipment. This label is reported in the response
     * in the `shipment_label` of the corresponding [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
     * </pre>
     *
     * <code>string label = 12;</code>
     *
     * @param value The bytes for label to set.
     * @return This builder for chaining.
     */
    public Builder setLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      label_ = value;
      onChanged();
      return this;
    }

    private boolean ignore_;
    /**
     *
     *
     * <pre>
     * If true, skip this shipment, but don't apply a `penalty_cost`.
     * Ignoring a shipment results in a validation error when there are any
     * `shipment_type_requirements` in the model.
     * Ignoring a shipment that is performed in `injected_first_solution_routes`
     * or `injected_solution_constraint` is permitted; the solver removes the
     * related pickup/delivery visits from the performing route.
     * `precedence_rules` that reference ignored shipments will also be ignored.
     * </pre>
     *
     * <code>bool ignore = 13;</code>
     *
     * @return The ignore.
     */
    @java.lang.Override
    public boolean getIgnore() {
      return ignore_;
    }
    /**
     *
     *
     * <pre>
     * If true, skip this shipment, but don't apply a `penalty_cost`.
     * Ignoring a shipment results in a validation error when there are any
     * `shipment_type_requirements` in the model.
     * Ignoring a shipment that is performed in `injected_first_solution_routes`
     * or `injected_solution_constraint` is permitted; the solver removes the
     * related pickup/delivery visits from the performing route.
     * `precedence_rules` that reference ignored shipments will also be ignored.
     * </pre>
     *
     * <code>bool ignore = 13;</code>
     *
     * @param value The ignore to set.
     * @return This builder for chaining.
     */
    public Builder setIgnore(boolean value) {

      ignore_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, skip this shipment, but don't apply a `penalty_cost`.
     * Ignoring a shipment results in a validation error when there are any
     * `shipment_type_requirements` in the model.
     * Ignoring a shipment that is performed in `injected_first_solution_routes`
     * or `injected_solution_constraint` is permitted; the solver removes the
     * related pickup/delivery visits from the performing route.
     * `precedence_rules` that reference ignored shipments will also be ignored.
     * </pre>
     *
     * <code>bool ignore = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnore() {

      ignore_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> demands_ =
        java.util.Collections.emptyList();

    private void ensureDemandsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        demands_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.CapacityQuantity>(demands_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.CapacityQuantity,
            com.google.cloud.optimization.v1.CapacityQuantity.Builder,
            com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        demandsBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity> getDemandsList() {
      if (demandsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(demands_);
      } else {
        return demandsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getDemandsCount() {
      if (demandsBuilder_ == null) {
        return demands_.size();
      } else {
        return demandsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity getDemands(int index) {
      if (demandsBuilder_ == null) {
        return demands_.get(index);
      } else {
        return demandsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDemands(int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
      if (demandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDemandsIsMutable();
        demands_.set(index, value);
        onChanged();
      } else {
        demandsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDemands(
        int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
      if (demandsBuilder_ == null) {
        ensureDemandsIsMutable();
        demands_.set(index, builderForValue.build());
        onChanged();
      } else {
        demandsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addDemands(com.google.cloud.optimization.v1.CapacityQuantity value) {
      if (demandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDemandsIsMutable();
        demands_.add(value);
        onChanged();
      } else {
        demandsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addDemands(int index, com.google.cloud.optimization.v1.CapacityQuantity value) {
      if (demandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDemandsIsMutable();
        demands_.add(index, value);
        onChanged();
      } else {
        demandsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addDemands(
        com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
      if (demandsBuilder_ == null) {
        ensureDemandsIsMutable();
        demands_.add(builderForValue.build());
        onChanged();
      } else {
        demandsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addDemands(
        int index, com.google.cloud.optimization.v1.CapacityQuantity.Builder builderForValue) {
      if (demandsBuilder_ == null) {
        ensureDemandsIsMutable();
        demands_.add(index, builderForValue.build());
        onChanged();
      } else {
        demandsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllDemands(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.CapacityQuantity> values) {
      if (demandsBuilder_ == null) {
        ensureDemandsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, demands_);
        onChanged();
      } else {
        demandsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearDemands() {
      if (demandsBuilder_ == null) {
        demands_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        demandsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeDemands(int index) {
      if (demandsBuilder_ == null) {
        ensureDemandsIsMutable();
        demands_.remove(index);
        onChanged();
      } else {
        demandsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity.Builder getDemandsBuilder(int index) {
      return getDemandsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantityOrBuilder getDemandsOrBuilder(
        int index) {
      if (demandsBuilder_ == null) {
        return demands_.get(index);
      } else {
        return demandsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<? extends com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getDemandsOrBuilderList() {
      if (demandsBuilder_ != null) {
        return demandsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(demands_);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity.Builder addDemandsBuilder() {
      return getDemandsFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.optimization.v1.CapacityQuantity.Builder addDemandsBuilder(int index) {
      return getDemandsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.CapacityQuantity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Shipment.load_demands][] instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.CapacityQuantity demands = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.optimization.v1.CapacityQuantity.Builder>
        getDemandsBuilderList() {
      return getDemandsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.CapacityQuantity,
            com.google.cloud.optimization.v1.CapacityQuantity.Builder,
            com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>
        getDemandsFieldBuilder() {
      if (demandsBuilder_ == null) {
        demandsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.CapacityQuantity,
                com.google.cloud.optimization.v1.CapacityQuantity.Builder,
                com.google.cloud.optimization.v1.CapacityQuantityOrBuilder>(
                demands_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        demands_ = null;
      }
      return demandsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.Shipment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.Shipment)
  private static final com.google.cloud.optimization.v1.Shipment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.Shipment();
  }

  public static com.google.cloud.optimization.v1.Shipment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Shipment> PARSER =
      new com.google.protobuf.AbstractParser<Shipment>() {
        @java.lang.Override
        public Shipment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Shipment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Shipment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.Shipment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
