/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Describes an error encountered when validating an `OptimizeToursRequest`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.OptimizeToursValidationError}
 */
public final class OptimizeToursValidationError extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.OptimizeToursValidationError)
    OptimizeToursValidationErrorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OptimizeToursValidationError.newBuilder() to construct.
  private OptimizeToursValidationError(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OptimizeToursValidationError() {
    displayName_ = "";
    fields_ = java.util.Collections.emptyList();
    errorMessage_ = "";
    offendingValues_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OptimizeToursValidationError();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_OptimizeToursValidationError_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_OptimizeToursValidationError_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.OptimizeToursValidationError.class,
            com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder.class);
  }

  public interface FieldReferenceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Name of the field, e.g., "vehicles".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Name of the field, e.g., "vehicles".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Index of the field if repeated.
     * </pre>
     *
     * <code>int32 index = 2;</code>
     *
     * @return Whether the index field is set.
     */
    boolean hasIndex();
    /**
     *
     *
     * <pre>
     * Index of the field if repeated.
     * </pre>
     *
     * <code>int32 index = 2;</code>
     *
     * @return The index.
     */
    int getIndex();

    /**
     *
     *
     * <pre>
     * Key if the field is a map.
     * </pre>
     *
     * <code>string key = 4;</code>
     *
     * @return Whether the key field is set.
     */
    boolean hasKey();
    /**
     *
     *
     * <pre>
     * Key if the field is a map.
     * </pre>
     *
     * <code>string key = 4;</code>
     *
     * @return The key.
     */
    java.lang.String getKey();
    /**
     *
     *
     * <pre>
     * Key if the field is a map.
     * </pre>
     *
     * <code>string key = 4;</code>
     *
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString getKeyBytes();

    /**
     *
     *
     * <pre>
     * Recursively nested sub-field, if needed.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
     * </code>
     *
     * @return Whether the subField field is set.
     */
    boolean hasSubField();
    /**
     *
     *
     * <pre>
     * Recursively nested sub-field, if needed.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
     * </code>
     *
     * @return The subField.
     */
    com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference getSubField();
    /**
     *
     *
     * <pre>
     * Recursively nested sub-field, if needed.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
     * </code>
     */
    com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReferenceOrBuilder
        getSubFieldOrBuilder();

    public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
            .IndexOrKeyCase
        getIndexOrKeyCase();
  }
  /**
   *
   *
   * <pre>
   * Specifies a context for the validation error. A `FieldReference` always
   * refers to a given field in this file and follows the same hierarchical
   * structure. For example, we may specify element #2 of `start_time_windows`
   * of vehicle #5 using:
   * ```
   * name: "vehicles" index: 5 sub_field { name: "end_time_windows" index: 2 }
   * ```
   * We however omit top-level entities such as `OptimizeToursRequest` or
   * `ShipmentModel` to avoid crowding the message.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference}
   */
  public static final class FieldReference extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference)
      FieldReferenceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FieldReference.newBuilder() to construct.
    private FieldReference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FieldReference() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FieldReference();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursValidationError_FieldReference_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursValidationError_FieldReference_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.class,
              com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder
                  .class);
    }

    private int indexOrKeyCase_ = 0;
    private java.lang.Object indexOrKey_;

    public enum IndexOrKeyCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      INDEX(2),
      KEY(4),
      INDEXORKEY_NOT_SET(0);
      private final int value;

      private IndexOrKeyCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static IndexOrKeyCase valueOf(int value) {
        return forNumber(value);
      }

      public static IndexOrKeyCase forNumber(int value) {
        switch (value) {
          case 2:
            return INDEX;
          case 4:
            return KEY;
          case 0:
            return INDEXORKEY_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public IndexOrKeyCase getIndexOrKeyCase() {
      return IndexOrKeyCase.forNumber(indexOrKeyCase_);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Name of the field, e.g., "vehicles".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the field, e.g., "vehicles".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INDEX_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Index of the field if repeated.
     * </pre>
     *
     * <code>int32 index = 2;</code>
     *
     * @return Whether the index field is set.
     */
    @java.lang.Override
    public boolean hasIndex() {
      return indexOrKeyCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Index of the field if repeated.
     * </pre>
     *
     * <code>int32 index = 2;</code>
     *
     * @return The index.
     */
    @java.lang.Override
    public int getIndex() {
      if (indexOrKeyCase_ == 2) {
        return (java.lang.Integer) indexOrKey_;
      }
      return 0;
    }

    public static final int KEY_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Key if the field is a map.
     * </pre>
     *
     * <code>string key = 4;</code>
     *
     * @return Whether the key field is set.
     */
    public boolean hasKey() {
      return indexOrKeyCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Key if the field is a map.
     * </pre>
     *
     * <code>string key = 4;</code>
     *
     * @return The key.
     */
    public java.lang.String getKey() {
      java.lang.Object ref = "";
      if (indexOrKeyCase_ == 4) {
        ref = indexOrKey_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (indexOrKeyCase_ == 4) {
          indexOrKey_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Key if the field is a map.
     * </pre>
     *
     * <code>string key = 4;</code>
     *
     * @return The bytes for key.
     */
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = "";
      if (indexOrKeyCase_ == 4) {
        ref = indexOrKey_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (indexOrKeyCase_ == 4) {
          indexOrKey_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUB_FIELD_FIELD_NUMBER = 3;
    private com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference subField_;
    /**
     *
     *
     * <pre>
     * Recursively nested sub-field, if needed.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
     * </code>
     *
     * @return Whether the subField field is set.
     */
    @java.lang.Override
    public boolean hasSubField() {
      return subField_ != null;
    }
    /**
     *
     *
     * <pre>
     * Recursively nested sub-field, if needed.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
     * </code>
     *
     * @return The subField.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        getSubField() {
      return subField_ == null
          ? com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
              .getDefaultInstance()
          : subField_;
    }
    /**
     *
     *
     * <pre>
     * Recursively nested sub-field, if needed.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReferenceOrBuilder
        getSubFieldOrBuilder() {
      return getSubField();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (indexOrKeyCase_ == 2) {
        output.writeInt32(2, (int) ((java.lang.Integer) indexOrKey_));
      }
      if (subField_ != null) {
        output.writeMessage(3, getSubField());
      }
      if (indexOrKeyCase_ == 4) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, indexOrKey_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (indexOrKeyCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                2, (int) ((java.lang.Integer) indexOrKey_));
      }
      if (subField_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSubField());
      }
      if (indexOrKeyCase_ == 4) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, indexOrKey_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference other =
          (com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference) obj;

      if (!getName().equals(other.getName())) return false;
      if (hasSubField() != other.hasSubField()) return false;
      if (hasSubField()) {
        if (!getSubField().equals(other.getSubField())) return false;
      }
      if (!getIndexOrKeyCase().equals(other.getIndexOrKeyCase())) return false;
      switch (indexOrKeyCase_) {
        case 2:
          if (getIndex() != other.getIndex()) return false;
          break;
        case 4:
          if (!getKey().equals(other.getKey())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (hasSubField()) {
        hash = (37 * hash) + SUB_FIELD_FIELD_NUMBER;
        hash = (53 * hash) + getSubField().hashCode();
      }
      switch (indexOrKeyCase_) {
        case 2:
          hash = (37 * hash) + INDEX_FIELD_NUMBER;
          hash = (53 * hash) + getIndex();
          break;
        case 4:
          hash = (37 * hash) + KEY_FIELD_NUMBER;
          hash = (53 * hash) + getKey().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies a context for the validation error. A `FieldReference` always
     * refers to a given field in this file and follows the same hierarchical
     * structure. For example, we may specify element #2 of `start_time_windows`
     * of vehicle #5 using:
     * ```
     * name: "vehicles" index: 5 sub_field { name: "end_time_windows" index: 2 }
     * ```
     * We however omit top-level entities such as `OptimizeToursRequest` or
     * `ShipmentModel` to avoid crowding the message.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference)
        com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReferenceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_OptimizeToursValidationError_FieldReference_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_OptimizeToursValidationError_FieldReference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.class,
                com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        if (subFieldBuilder_ == null) {
          subField_ = null;
        } else {
          subField_ = null;
          subFieldBuilder_ = null;
        }
        indexOrKeyCase_ = 0;
        indexOrKey_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_OptimizeToursValidationError_FieldReference_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
          getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference build() {
        com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
          buildPartial() {
        com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference result =
            new com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference(this);
        result.name_ = name_;
        if (indexOrKeyCase_ == 2) {
          result.indexOrKey_ = indexOrKey_;
        }
        if (indexOrKeyCase_ == 4) {
          result.indexOrKey_ = indexOrKey_;
        }
        if (subFieldBuilder_ == null) {
          result.subField_ = subField_;
        } else {
          result.subField_ = subFieldBuilder_.build();
        }
        result.indexOrKeyCase_ = indexOrKeyCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference) {
          return mergeFrom(
              (com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference other) {
        if (other
            == com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (other.hasSubField()) {
          mergeSubField(other.getSubField());
        }
        switch (other.getIndexOrKeyCase()) {
          case INDEX:
            {
              setIndex(other.getIndex());
              break;
            }
          case KEY:
            {
              indexOrKeyCase_ = 4;
              indexOrKey_ = other.indexOrKey_;
              onChanged();
              break;
            }
          case INDEXORKEY_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 16:
                {
                  indexOrKey_ = input.readInt32();
                  indexOrKeyCase_ = 2;
                  break;
                } // case 16
              case 26:
                {
                  input.readMessage(getSubFieldFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  indexOrKeyCase_ = 4;
                  indexOrKey_ = s;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int indexOrKeyCase_ = 0;
      private java.lang.Object indexOrKey_;

      public IndexOrKeyCase getIndexOrKeyCase() {
        return IndexOrKeyCase.forNumber(indexOrKeyCase_);
      }

      public Builder clearIndexOrKey() {
        indexOrKeyCase_ = 0;
        indexOrKey_ = null;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Name of the field, e.g., "vehicles".
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the field, e.g., "vehicles".
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the field, e.g., "vehicles".
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the field, e.g., "vehicles".
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the field, e.g., "vehicles".
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Index of the field if repeated.
       * </pre>
       *
       * <code>int32 index = 2;</code>
       *
       * @return Whether the index field is set.
       */
      public boolean hasIndex() {
        return indexOrKeyCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Index of the field if repeated.
       * </pre>
       *
       * <code>int32 index = 2;</code>
       *
       * @return The index.
       */
      public int getIndex() {
        if (indexOrKeyCase_ == 2) {
          return (java.lang.Integer) indexOrKey_;
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * Index of the field if repeated.
       * </pre>
       *
       * <code>int32 index = 2;</code>
       *
       * @param value The index to set.
       * @return This builder for chaining.
       */
      public Builder setIndex(int value) {
        indexOrKeyCase_ = 2;
        indexOrKey_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Index of the field if repeated.
       * </pre>
       *
       * <code>int32 index = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIndex() {
        if (indexOrKeyCase_ == 2) {
          indexOrKeyCase_ = 0;
          indexOrKey_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Key if the field is a map.
       * </pre>
       *
       * <code>string key = 4;</code>
       *
       * @return Whether the key field is set.
       */
      @java.lang.Override
      public boolean hasKey() {
        return indexOrKeyCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Key if the field is a map.
       * </pre>
       *
       * <code>string key = 4;</code>
       *
       * @return The key.
       */
      @java.lang.Override
      public java.lang.String getKey() {
        java.lang.Object ref = "";
        if (indexOrKeyCase_ == 4) {
          ref = indexOrKey_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (indexOrKeyCase_ == 4) {
            indexOrKey_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Key if the field is a map.
       * </pre>
       *
       * <code>string key = 4;</code>
       *
       * @return The bytes for key.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = "";
        if (indexOrKeyCase_ == 4) {
          ref = indexOrKey_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (indexOrKeyCase_ == 4) {
            indexOrKey_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Key if the field is a map.
       * </pre>
       *
       * <code>string key = 4;</code>
       *
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        indexOrKeyCase_ = 4;
        indexOrKey_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key if the field is a map.
       * </pre>
       *
       * <code>string key = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        if (indexOrKeyCase_ == 4) {
          indexOrKeyCase_ = 0;
          indexOrKey_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key if the field is a map.
       * </pre>
       *
       * <code>string key = 4;</code>
       *
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        indexOrKeyCase_ = 4;
        indexOrKey_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
          subField_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference,
              com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder,
              com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReferenceOrBuilder>
          subFieldBuilder_;
      /**
       *
       *
       * <pre>
       * Recursively nested sub-field, if needed.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
       * </code>
       *
       * @return Whether the subField field is set.
       */
      public boolean hasSubField() {
        return subFieldBuilder_ != null || subField_ != null;
      }
      /**
       *
       *
       * <pre>
       * Recursively nested sub-field, if needed.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
       * </code>
       *
       * @return The subField.
       */
      public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
          getSubField() {
        if (subFieldBuilder_ == null) {
          return subField_ == null
              ? com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
                  .getDefaultInstance()
              : subField_;
        } else {
          return subFieldBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Recursively nested sub-field, if needed.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
       * </code>
       */
      public Builder setSubField(
          com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference value) {
        if (subFieldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          subField_ = value;
          onChanged();
        } else {
          subFieldBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Recursively nested sub-field, if needed.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
       * </code>
       */
      public Builder setSubField(
          com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder
              builderForValue) {
        if (subFieldBuilder_ == null) {
          subField_ = builderForValue.build();
          onChanged();
        } else {
          subFieldBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Recursively nested sub-field, if needed.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
       * </code>
       */
      public Builder mergeSubField(
          com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference value) {
        if (subFieldBuilder_ == null) {
          if (subField_ != null) {
            subField_ =
                com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
                    .newBuilder(subField_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            subField_ = value;
          }
          onChanged();
        } else {
          subFieldBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Recursively nested sub-field, if needed.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
       * </code>
       */
      public Builder clearSubField() {
        if (subFieldBuilder_ == null) {
          subField_ = null;
          onChanged();
        } else {
          subField_ = null;
          subFieldBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Recursively nested sub-field, if needed.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
       * </code>
       */
      public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder
          getSubFieldBuilder() {

        onChanged();
        return getSubFieldFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Recursively nested sub-field, if needed.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
       * </code>
       */
      public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReferenceOrBuilder
          getSubFieldOrBuilder() {
        if (subFieldBuilder_ != null) {
          return subFieldBuilder_.getMessageOrBuilder();
        } else {
          return subField_ == null
              ? com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
                  .getDefaultInstance()
              : subField_;
        }
      }
      /**
       *
       *
       * <pre>
       * Recursively nested sub-field, if needed.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference sub_field = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference,
              com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder,
              com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReferenceOrBuilder>
          getSubFieldFieldBuilder() {
        if (subFieldBuilder_ == null) {
          subFieldBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference,
                  com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
                      .Builder,
                  com.google.cloud.optimization.v1.OptimizeToursValidationError
                      .FieldReferenceOrBuilder>(getSubField(), getParentForChildren(), isClean());
          subField_ = null;
        }
        return subFieldBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference)
    private static final com.google.cloud.optimization.v1.OptimizeToursValidationError
            .FieldReference
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference();
    }

    public static com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FieldReference> PARSER =
        new com.google.protobuf.AbstractParser<FieldReference>() {
          @java.lang.Override
          public FieldReference parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FieldReference> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FieldReference> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CODE_FIELD_NUMBER = 1;
  private int code_;
  /**
   *
   *
   * <pre>
   * A validation error is defined by the pair (`code`, `display_name`) which
   * are always present.
   * Other fields (below) provide more context about the error.
   * *MULTIPLE ERRORS*:
   * When there are multiple errors, the validation process tries to output
   * several of them. Much like a compiler, this is an imperfect process. Some
   * validation errors will be "fatal", meaning that they stop the entire
   * validation process. This is the case for `display_name="UNSPECIFIED"`
   * errors, among others. Some may cause the validation process to skip other
   * errors.
   * *STABILITY*:
   * `code` and `display_name` should be very stable. But new codes and
   * display names may appear over time, which may cause a given (invalid)
   * request to yield a different (`code`, `display_name`) pair because the new
   * error hid the old one (see "MULTIPLE ERRORS").
   * *REFERENCE*: A list of all (code, name) pairs:
   * * UNSPECIFIED = 0;
   * * VALIDATION_TIMEOUT_ERROR = 10; Validation couldn't be completed within
   * the deadline.
   * * REQUEST_OPTIONS_ERROR = 12;
   *     * REQUEST_OPTIONS_INVALID_SOLVING_MODE = 1201;
   *     * REQUEST_OPTIONS_INVALID_MAX_VALIDATION_ERRORS = 1203;
   *     * REQUEST_OPTIONS_INVALID_GEODESIC_METERS_PER_SECOND = 1204;
   *     * REQUEST_OPTIONS_GEODESIC_METERS_PER_SECOND_TOO_SMALL = 1205;
   *     * REQUEST_OPTIONS_MISSING_GEODESIC_METERS_PER_SECOND = 1206;
   *     * REQUEST_OPTIONS_POPULATE_PATHFINDER_TRIPS_AND_GEODESIC_DISTANCE
   *       = 1207;
   *     * REQUEST_OPTIONS_COST_MODEL_OPTIONS_AND_GEODESIC_DISTANCE = 1208;
   *     * REQUEST_OPTIONS_TRAVEL_MODE_INCOMPATIBLE_WITH_TRAFFIC = 1211;
   *     * REQUEST_OPTIONS_MULTIPLE_TRAFFIC_FLAVORS = 1212;
   *     * REQUEST_OPTIONS_INVALID_TRAFFIC_FLAVOR = 1213;
   *     * REQUEST_OPTIONS_TRAFFIC_ENABLED_WITHOUT_GLOBAL_START_TIME = 1214;
   *     * REQUEST_OPTIONS_TRAFFIC_ENABLED_WITH_PRECEDENCES = 1215;
   *     * REQUEST_OPTIONS_TRAFFIC_PREFILL_MODE_INVALID = 1216;
   *     * REQUEST_OPTIONS_TRAFFIC_PREFILL_ENABLED_WITHOUT_TRAFFIC = 1217;
   * * INJECTED_SOLUTION_ERROR = 20;
   *     * INJECTED_SOLUTION_MISSING_LABEL = 2000;
   *     * INJECTED_SOLUTION_DUPLICATE_LABEL = 2001;
   *     * INJECTED_SOLUTION_AMBIGUOUS_INDEX = 2002;
   * * SHIPMENT_MODEL_ERROR = 22;
   *     * SHIPMENT_MODEL_TOO_LARGE = 2200;
   *     * SHIPMENT_MODEL_TOO_MANY_CAPACITY_TYPES = 2201;
   *     * SHIPMENT_MODEL_GLOBAL_START_TIME_NEGATIVE_OR_NAN = 2202;
   *     * SHIPMENT_MODEL_GLOBAL_END_TIME_TOO_LARGE_OR_NAN = 2203;
   *     * SHIPMENT_MODEL_GLOBAL_START_TIME_AFTER_GLOBAL_END_TIME = 2204;
   *     * SHIPMENT_MODEL_GLOBAL_DURATION_TOO_LONG = 2205;
   * * INDEX_ERROR = 24;
   * * TAG_ERROR = 26;
   * * TIME_WINDOW_ERROR = 28;
   *     * TIME_WINDOW_INVALID_START_TIME = 2800;
   *     * TIME_WINDOW_INVALID_END_TIME = 2801;
   *     * TIME_WINDOW_INVALID_SOFT_START_TIME = 2802;
   *     * TIME_WINDOW_INVALID_SOFT_END_TIME = 2803;
   *     * TIME_WINDOW_OUTSIDE_GLOBAL_TIME_WINDOW = 2804;
   *     * TIME_WINDOW_START_TIME_AFTER_END_TIME = 2805;
   *     * TIME_WINDOW_INVALID_COST_PER_HOUR_BEFORE_SOFT_START_TIME = 2806;
   *     * TIME_WINDOW_INVALID_COST_PER_HOUR_AFTER_SOFT_END_TIME = 2807;
   *     * TIME_WINDOW_COST_BEFORE_SOFT_START_TIME_WITHOUT_SOFT_START_TIME
   *       = 2808;
   *     * TIME_WINDOW_COST_AFTER_SOFT_END_TIME_WITHOUT_SOFT_END_TIME = 2809;
   *     * TIME_WINDOW_SOFT_START_TIME_WITHOUT_COST_BEFORE_SOFT_START_TIME
   *       = 2810;
   *     * TIME_WINDOW_SOFT_END_TIME_WITHOUT_COST_AFTER_SOFT_END_TIME = 2811;
   *     * TIME_WINDOW_OVERLAPPING_ADJACENT_OR_EARLIER_THAN_PREVIOUS = 2812;
   *     * TIME_WINDOW_START_TIME_AFTER_SOFT_START_TIME = 2813;
   *     * TIME_WINDOW_SOFT_START_TIME_AFTER_END_TIME = 2814;
   *     * TIME_WINDOW_START_TIME_AFTER_SOFT_END_TIME = 2815;
   *     * TIME_WINDOW_SOFT_END_TIME_AFTER_END_TIME = 2816;
   *     * TIME_WINDOW_COST_BEFORE_SOFT_START_TIME_SET_AND_MULTIPLE_WINDOWS
   *       = 2817;
   *     * TIME_WINDOW_COST_AFTER_SOFT_END_TIME_SET_AND_MULTIPLE_WINDOWS = 2818;
   *     * TRANSITION_ATTRIBUTES_ERROR = 30;
   *     * TRANSITION_ATTRIBUTES_INVALID_COST = 3000;
   *     * TRANSITION_ATTRIBUTES_INVALID_COST_PER_KILOMETER = 3001;
   *     * TRANSITION_ATTRIBUTES_DUPLICATE_TAG_PAIR = 3002;
   *     * TRANSITION_ATTRIBUTES_DISTANCE_LIMIT_MAX_METERS_UNSUPPORTED = 3003;
   *     * TRANSITION_ATTRIBUTES_UNSPECIFIED_SOURCE_TAGS = 3004;
   *     * TRANSITION_ATTRIBUTES_CONFLICTING_SOURCE_TAGS_FIELDS = 3005;
   *     * TRANSITION_ATTRIBUTES_UNSPECIFIED_DESTINATION_TAGS = 3006;
   *     * TRANSITION_ATTRIBUTES_CONFLICTING_DESTINATION_TAGS_FIELDS = 3007;
   *     * TRANSITION_ATTRIBUTES_DELAY_DURATION_NEGATIVE_OR_NAN = 3008;
   *     * TRANSITION_ATTRIBUTES_DELAY_DURATION_EXCEEDS_GLOBAL_DURATION = 3009;
   * * AMOUNT_ERROR = 31;
   *     * AMOUNT_NEGATIVE_VALUE = 3100;
   * * LOAD_LIMIT_ERROR = 33;
   *     * LOAD_LIMIT_INVALID_COST_ABOVE_SOFT_MAX = 3303;
   *     * LOAD_LIMIT_SOFT_MAX_WITHOUT_COST_ABOVE_SOFT_MAX = 3304;
   *     * LOAD_LIMIT_COST_ABOVE_SOFT_MAX_WITHOUT_SOFT_MAX = 3305;
   *     * LOAD_LIMIT_NEGATIVE_SOFT_MAX = 3306;
   *     * LOAD_LIMIT_MIXED_DEMAND_TYPE = 3307;
   *     * LOAD_LIMIT_MAX_LOAD_NEGATIVE_VALUE = 3308;
   *     * LOAD_LIMIT_SOFT_MAX_ABOVE_MAX = 3309;
   * * INTERVAL_ERROR = 34;
   *     * INTERVAL_MIN_EXCEEDS_MAX = 3401;
   *     * INTERVAL_NEGATIVE_MIN = 3402;
   *     * INTERVAL_NEGATIVE_MAX = 3403;
   *     * INTERVAL_MIN_EXCEEDS_CAPACITY = 3404;
   *     * INTERVAL_MAX_EXCEEDS_CAPACITY = 3405;
   * * DISTANCE_LIMIT_ERROR = 36;
   *     * DISTANCE_LIMIT_INVALID_COST_AFTER_SOFT_MAX = 3601;
   *     * DISTANCE_LIMIT_SOFT_MAX_WITHOUT_COST_AFTER_SOFT_MAX = 3602;
   *     * DISTANCE_LIMIT_COST_AFTER_SOFT_MAX_WITHOUT_SOFT_MAX = 3603;
   *     * DISTANCE_LIMIT_NEGATIVE_MAX = 3604;
   *     * DISTANCE_LIMIT_NEGATIVE_SOFT_MAX = 3605;
   *     * DISTANCE_LIMIT_SOFT_MAX_LARGER_THAN_MAX = 3606;
   * * DURATION_LIMIT_ERROR = 38;
   *     * DURATION_LIMIT_MAX_DURATION_NEGATIVE_OR_NAN = 3800;
   *     * DURATION_LIMIT_SOFT_MAX_DURATION_NEGATIVE_OR_NAN = 3801;
   *     * DURATION_LIMIT_INVALID_COST_PER_HOUR_AFTER_SOFT_MAX = 3802;
   *     * DURATION_LIMIT_SOFT_MAX_WITHOUT_COST_AFTER_SOFT_MAX = 3803;
   *     * DURATION_LIMIT_COST_AFTER_SOFT_MAX_WITHOUT_SOFT_MAX = 3804;
   *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_DURATION_NEGATIVE_OR_NAN = 3805;
   *     * DURATION_LIMIT_INVALID_COST_AFTER_QUADRATIC_SOFT_MAX = 3806;
   *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_WITHOUT_COST_PER_SQUARE_HOUR
   *       = 3807;
   *     * DURATION_LIMIT_COST_PER_SQUARE_HOUR_WITHOUT_QUADRATIC_SOFT_MAX
   *       = 3808;
   *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_WITHOUT_MAX = 3809;
   *     * DURATION_LIMIT_SOFT_MAX_LARGER_THAN_MAX = 3810;
   *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_LARGER_THAN_MAX = 3811;
   *     * DURATION_LIMIT_DIFF_BETWEEN_MAX_AND_QUADRATIC_SOFT_MAX_TOO_LARGE
   *       = 3812;
   *     * DURATION_LIMIT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION = 3813;
   *     * DURATION_LIMIT_SOFT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION = 3814;
   *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION
   *       = 3815;
   * * SHIPMENT_ERROR = 40;
   *     * SHIPMENT_PD_ABSOLUTE_DETOUR_LIMIT_DURATION_NEGATIVE_OR_NAN = 4000;
   *     * SHIPMENT_PD_ABSOLUTE_DETOUR_LIMIT_DURATION_EXCEEDS_GLOBAL_DURATION
   *       = 4001;
   *     * SHIPMENT_PD_TIME_LIMIT_DURATION_NEGATIVE_OR_NAN = 4002;
   *     * SHIPMENT_PD_TIME_LIMIT_DURATION_EXCEEDS_GLOBAL_DURATION = 4003;
   *     * SHIPMENT_EMPTY_SHIPMENT_TYPE = 4004;
   *     * SHIPMENT_NO_PICKUP_NO_DELIVERY = 4005;
   *     * SHIPMENT_INVALID_PENALTY_COST = 4006;
   *     * SHIPMENT_ALLOWED_VEHICLE_INDEX_OUT_OF_BOUNDS = 4007;
   *     * SHIPMENT_DUPLICATE_ALLOWED_VEHICLE_INDEX = 4008;
   *     * SHIPMENT_INCONSISTENT_COST_FOR_VEHICLE_SIZE_WITHOUT_INDEX = 4009;
   *     * SHIPMENT_INCONSISTENT_COST_FOR_VEHICLE_SIZE_WITH_INDEX = 4010;
   *     * SHIPMENT_INVALID_COST_FOR_VEHICLE = 4011;
   *     * SHIPMENT_COST_FOR_VEHICLE_INDEX_OUT_OF_BOUNDS = 4012;
   *     * SHIPMENT_DUPLICATE_COST_FOR_VEHICLE_INDEX = 4013;
   *     * SHIPMENT_DETOUR_WITHOUT_PICKUP_AND_DELIVERY = 4014;
   * * VEHICLE_ERROR = 42;
   *     * VEHICLE_EMPTY_REQUIRED_OPERATOR_TYPE = 4200;
   *     * VEHICLE_DUPLICATE_REQUIRED_OPERATOR_TYPE = 4201;
   *     * VEHICLE_NO_OPERATOR_WITH_REQUIRED_OPERATOR_TYPE = 4202;
   *     * VEHICLE_EMPTY_START_TAG = 4203;
   *     * VEHICLE_DUPLICATE_START_TAG = 4204;
   *     * VEHICLE_EMPTY_END_TAG = 4205;
   *     * VEHICLE_DUPLICATE_END_TAG = 4206;
   *     * VEHICLE_EXTRA_VISIT_DURATION_NEGATIVE_OR_NAN = 4207;
   *     * VEHICLE_EXTRA_VISIT_DURATION_EXCEEDS_GLOBAL_DURATION = 4208;
   *     * VEHICLE_EXTRA_VISIT_DURATION_EMPTY_KEY = 4209;
   *     * VEHICLE_FIRST_SHIPMENT_INDEX_OUT_OF_BOUNDS = 4210;
   *     * VEHICLE_FIRST_SHIPMENT_IGNORED = 4211;
   *     * VEHICLE_FIRST_SHIPMENT_NOT_BOUND = 4212;
   *     * VEHICLE_LAST_SHIPMENT_INDEX_OUT_OF_BOUNDS = 4213;
   *     * VEHICLE_LAST_SHIPMENT_IGNORED = 4214;
   *     * VEHICLE_LAST_SHIPMENT_NOT_BOUND = 4215;
   *     * VEHICLE_IGNORED_WITH_USED_IF_ROUTE_IS_EMPTY = 4216;
   *     * VEHICLE_INVALID_COST_PER_KILOMETER = 4217;
   *     * VEHICLE_INVALID_COST_PER_HOUR = 4218;
   *     * VEHICLE_INVALID_COST_PER_TRAVELED_HOUR = 4219;
   *     * VEHICLE_INVALID_FIXED_COST = 4220;
   *     * VEHICLE_INVALID_TRAVEL_DURATION_MULTIPLE = 4221;
   *     * VEHICLE_MINIMUM_DURATION_LONGER_THAN_DURATION_LIMIT = 4222;
   * * VISIT_REQUEST_ERROR = 44;
   *     * VISIT_REQUEST_EMPTY_TAG = 4400;
   *     * VISIT_REQUEST_DUPLICATE_TAG = 4401;
   *     * VISIT_REQUEST_DURATION_NEGATIVE_OR_NAN = 4404;
   *     * VISIT_REQUEST_DURATION_EXCEEDS_GLOBAL_DURATION = 4405;
   * * PRECEDENCE_ERROR = 46;
   * * BREAK_ERROR = 48;
   *     * BREAK_RULE_EMPTY = 4800;
   *     * BREAK_REQUEST_UNSPECIFIED_DURATION = 4801;
   *     * BREAK_REQUEST_UNSPECIFIED_EARLIEST_START_TIME = 4802;
   *     * BREAK_REQUEST_UNSPECIFIED_LATEST_START_TIME = 4803;
   *     * BREAK_REQUEST_DURATION_NEGATIVE_OR_NAN = 4804; = 4804;
   *     * BREAK_REQUEST_LATEST_START_TIME_BEFORE_EARLIEST_START_TIME = 4805;
   *     * BREAK_REQUEST_EARLIEST_START_TIME_BEFORE_GLOBAL_START_TIME = 4806;
   *     * BREAK_REQUEST_LATEST_END_TIME_AFTER_GLOBAL_END_TIME = 4807;
   *     * BREAK_REQUEST_NON_SCHEDULABLE = 4808;
   *     * BREAK_FREQUENCY_MAX_INTER_BREAK_DURATION_NEGATIVE_OR_NAN = 4809;
   *     * BREAK_FREQUENCY_MIN_BREAK_DURATION_NEGATIVE_OR_NAN = 4810;
   *     * BREAK_FREQUENCY_MIN_BREAK_DURATION_EXCEEDS_GLOBAL_DURATION = 4811;
   *     * BREAK_FREQUENCY_MAX_INTER_BREAK_DURATION_EXCEEDS_GLOBAL_DURATION
   *       = 4812;
   *     * BREAK_REQUEST_DURATION_EXCEEDS_GLOBAL_DURATION = 4813;
   *     * BREAK_FREQUENCY_MISSING_MAX_INTER_BREAK_DURATION = 4814;
   *     * BREAK_FREQUENCY_MISSING_MIN_BREAK_DURATION = 4815;
   * * SHIPMENT_TYPE_INCOMPATIBILITY_ERROR = 50;
   *     * SHIPMENT_TYPE_INCOMPATIBILITY_EMPTY_TYPE = 5001;
   *     * SHIPMENT_TYPE_INCOMPATIBILITY_LESS_THAN_TWO_TYPES = 5002;
   *     * SHIPMENT_TYPE_INCOMPATIBILITY_DUPLICATE_TYPE = 5003;
   *     * SHIPMENT_TYPE_INCOMPATIBILITY_INVALID_INCOMPATIBILITY_MODE = 5004;
   *     * SHIPMENT_TYPE_INCOMPATIBILITY_TOO_MANY_INCOMPATIBILITIES = 5005;
   * * SHIPMENT_TYPE_REQUIREMENT_ERROR = 52;
   *     * SHIPMENT_TYPE_REQUIREMENT_NO_REQUIRED_TYPE = 52001;
   *     * SHIPMENT_TYPE_REQUIREMENT_NO_DEPENDENT_TYPE = 52002;
   *     * SHIPMENT_TYPE_REQUIREMENT_INVALID_REQUIREMENT_MODE = 52003;
   *     * SHIPMENT_TYPE_REQUIREMENT_TOO_MANY_REQUIREMENTS = 52004;
   *     * SHIPMENT_TYPE_REQUIREMENT_EMPTY_REQUIRED_TYPE = 52005;
   *     * SHIPMENT_TYPE_REQUIREMENT_DUPLICATE_REQUIRED_TYPE = 52006;
   *     * SHIPMENT_TYPE_REQUIREMENT_NO_REQUIRED_TYPE_FOUND = 52007;
   *     * SHIPMENT_TYPE_REQUIREMENT_EMPTY_DEPENDENT_TYPE = 52008;
   *     * SHIPMENT_TYPE_REQUIREMENT_DUPLICATE_DEPENDENT_TYPE = 52009;
   *     * SHIPMENT_TYPE_REQUIREMENT_SELF_DEPENDENT_TYPE = 52010;
   *     * SHIPMENT_TYPE_REQUIREMENT_GRAPH_HAS_CYCLES = 52011;
   * * VEHICLE_OPERATOR_ERROR = 54;
   *     * VEHICLE_OPERATOR_EMPTY_TYPE = 5400;
   *     * VEHICLE_OPERATOR_MULTIPLE_START_TIME_WINDOWS = 5401;
   *     * VEHICLE_OPERATOR_SOFT_START_TIME_WINDOW = 5402;
   *     * VEHICLE_OPERATOR_MULTIPLE_END_TIME_WINDOWS = 5403;
   *     * VEHICLE_OPERATOR_SOFT_END_TIME_WINDOW = 5404;
   * * DURATION_SECONDS_MATRIX_ERROR = 56;
   *     * DURATION_SECONDS_MATRIX_DURATION_NEGATIVE_OR_NAN = 5600;
   *     * DURATION_SECONDS_MATRIX_DURATION_EXCEEDS_GLOBAL_DURATION = 5601;
   * * GRAPH_ARC_ERROR = 58;
   *     * GRAPH_ARC_DURATION_NEGATIVE_OR_NAN = 5800;
   *     * GRAPH_ARC_DURATION_EXCEEDS_GLOBAL_DURATION = 5801;
   * </pre>
   *
   * <code>int32 code = 1;</code>
   *
   * @return The code.
   */
  @java.lang.Override
  public int getCode() {
    return code_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The error display name.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The error display name.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIELDS_FIELD_NUMBER = 3;
  private java.util.List<
          com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference>
      fields_;
  /**
   *
   *
   * <pre>
   * An error context may involve 0, 1 (most of the time) or more fields. For
   * example, referring to vehicle #4 and shipment #2's first pickup can be
   * done as follows:
   * ```
   * fields { name: "vehicles" index: 4}
   * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
   * ```
   * Note, however, that the cardinality of `fields` should not change for a
   * given error code.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference>
      getFieldsList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * An error context may involve 0, 1 (most of the time) or more fields. For
   * example, referring to vehicle #4 and shipment #2's first pickup can be
   * done as follows:
   * ```
   * fields { name: "vehicles" index: 4}
   * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
   * ```
   * Note, however, that the cardinality of `fields` should not change for a
   * given error code.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReferenceOrBuilder>
      getFieldsOrBuilderList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * An error context may involve 0, 1 (most of the time) or more fields. For
   * example, referring to vehicle #4 and shipment #2's first pickup can be
   * done as follows:
   * ```
   * fields { name: "vehicles" index: 4}
   * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
   * ```
   * Note, however, that the cardinality of `fields` should not change for a
   * given error code.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
   * </code>
   */
  @java.lang.Override
  public int getFieldsCount() {
    return fields_.size();
  }
  /**
   *
   *
   * <pre>
   * An error context may involve 0, 1 (most of the time) or more fields. For
   * example, referring to vehicle #4 and shipment #2's first pickup can be
   * done as follows:
   * ```
   * fields { name: "vehicles" index: 4}
   * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
   * ```
   * Note, however, that the cardinality of `fields` should not change for a
   * given error code.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference getFields(
      int index) {
    return fields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An error context may involve 0, 1 (most of the time) or more fields. For
   * example, referring to vehicle #4 and shipment #2's first pickup can be
   * done as follows:
   * ```
   * fields { name: "vehicles" index: 4}
   * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
   * ```
   * Note, however, that the cardinality of `fields` should not change for a
   * given error code.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReferenceOrBuilder
      getFieldsOrBuilder(int index) {
    return fields_.get(index);
  }

  public static final int ERROR_MESSAGE_FIELD_NUMBER = 4;
  private volatile java.lang.Object errorMessage_;
  /**
   *
   *
   * <pre>
   * Human-readable string describing the error. There is a 1:1 mapping
   * between `code` and `error_message` (when code != "UNSPECIFIED").
   * *STABILITY*: Not stable: the error message associated to a given `code` may
   * change (hopefully to clarify it) over time. Please rely on the
   * `display_name` and `code` instead.
   * </pre>
   *
   * <code>string error_message = 4;</code>
   *
   * @return The errorMessage.
   */
  @java.lang.Override
  public java.lang.String getErrorMessage() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Human-readable string describing the error. There is a 1:1 mapping
   * between `code` and `error_message` (when code != "UNSPECIFIED").
   * *STABILITY*: Not stable: the error message associated to a given `code` may
   * change (hopefully to clarify it) over time. Please rely on the
   * `display_name` and `code` instead.
   * </pre>
   *
   * <code>string error_message = 4;</code>
   *
   * @return The bytes for errorMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorMessageBytes() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OFFENDING_VALUES_FIELD_NUMBER = 5;
  private volatile java.lang.Object offendingValues_;
  /**
   *
   *
   * <pre>
   * May contain the value(s) of the field(s). This is not always available. You
   * should absolutely not rely on it and use it only for manual model
   * debugging.
   * </pre>
   *
   * <code>string offending_values = 5;</code>
   *
   * @return The offendingValues.
   */
  @java.lang.Override
  public java.lang.String getOffendingValues() {
    java.lang.Object ref = offendingValues_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      offendingValues_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * May contain the value(s) of the field(s). This is not always available. You
   * should absolutely not rely on it and use it only for manual model
   * debugging.
   * </pre>
   *
   * <code>string offending_values = 5;</code>
   *
   * @return The bytes for offendingValues.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOffendingValuesBytes() {
    java.lang.Object ref = offendingValues_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      offendingValues_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (code_ != 0) {
      output.writeInt32(1, code_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    for (int i = 0; i < fields_.size(); i++) {
      output.writeMessage(3, fields_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, errorMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(offendingValues_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, offendingValues_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (code_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, code_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (int i = 0; i < fields_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, fields_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, errorMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(offendingValues_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, offendingValues_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.OptimizeToursValidationError)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.OptimizeToursValidationError other =
        (com.google.cloud.optimization.v1.OptimizeToursValidationError) obj;

    if (getCode() != other.getCode()) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getFieldsList().equals(other.getFieldsList())) return false;
    if (!getErrorMessage().equals(other.getErrorMessage())) return false;
    if (!getOffendingValues().equals(other.getOffendingValues())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CODE_FIELD_NUMBER;
    hash = (53 * hash) + getCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getFieldsCount() > 0) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getFieldsList().hashCode();
    }
    hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getErrorMessage().hashCode();
    hash = (37 * hash) + OFFENDING_VALUES_FIELD_NUMBER;
    hash = (53 * hash) + getOffendingValues().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.optimization.v1.OptimizeToursValidationError prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes an error encountered when validating an `OptimizeToursRequest`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.OptimizeToursValidationError}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.OptimizeToursValidationError)
      com.google.cloud.optimization.v1.OptimizeToursValidationErrorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursValidationError_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursValidationError_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.OptimizeToursValidationError.class,
              com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.OptimizeToursValidationError.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      code_ = 0;

      displayName_ = "";

      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
      } else {
        fields_ = null;
        fieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      errorMessage_ = "";

      offendingValues_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursValidationError_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursValidationError
        getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.OptimizeToursValidationError.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursValidationError build() {
      com.google.cloud.optimization.v1.OptimizeToursValidationError result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursValidationError buildPartial() {
      com.google.cloud.optimization.v1.OptimizeToursValidationError result =
          new com.google.cloud.optimization.v1.OptimizeToursValidationError(this);
      int from_bitField0_ = bitField0_;
      result.code_ = code_;
      result.displayName_ = displayName_;
      if (fieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          fields_ = java.util.Collections.unmodifiableList(fields_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.fields_ = fields_;
      } else {
        result.fields_ = fieldsBuilder_.build();
      }
      result.errorMessage_ = errorMessage_;
      result.offendingValues_ = offendingValues_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.OptimizeToursValidationError) {
        return mergeFrom((com.google.cloud.optimization.v1.OptimizeToursValidationError) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.OptimizeToursValidationError other) {
      if (other
          == com.google.cloud.optimization.v1.OptimizeToursValidationError.getDefaultInstance())
        return this;
      if (other.getCode() != 0) {
        setCode(other.getCode());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (fieldsBuilder_ == null) {
        if (!other.fields_.isEmpty()) {
          if (fields_.isEmpty()) {
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFieldsIsMutable();
            fields_.addAll(other.fields_);
          }
          onChanged();
        }
      } else {
        if (!other.fields_.isEmpty()) {
          if (fieldsBuilder_.isEmpty()) {
            fieldsBuilder_.dispose();
            fieldsBuilder_ = null;
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000001);
            fieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFieldsFieldBuilder()
                    : null;
          } else {
            fieldsBuilder_.addAllMessages(other.fields_);
          }
        }
      }
      if (!other.getErrorMessage().isEmpty()) {
        errorMessage_ = other.errorMessage_;
        onChanged();
      }
      if (!other.getOffendingValues().isEmpty()) {
        offendingValues_ = other.offendingValues_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                code_ = input.readInt32();

                break;
              } // case 8
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
                            .parser(),
                        extensionRegistry);
                if (fieldsBuilder_ == null) {
                  ensureFieldsIsMutable();
                  fields_.add(m);
                } else {
                  fieldsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                errorMessage_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                offendingValues_ = input.readStringRequireUtf8();

                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int code_;
    /**
     *
     *
     * <pre>
     * A validation error is defined by the pair (`code`, `display_name`) which
     * are always present.
     * Other fields (below) provide more context about the error.
     * *MULTIPLE ERRORS*:
     * When there are multiple errors, the validation process tries to output
     * several of them. Much like a compiler, this is an imperfect process. Some
     * validation errors will be "fatal", meaning that they stop the entire
     * validation process. This is the case for `display_name="UNSPECIFIED"`
     * errors, among others. Some may cause the validation process to skip other
     * errors.
     * *STABILITY*:
     * `code` and `display_name` should be very stable. But new codes and
     * display names may appear over time, which may cause a given (invalid)
     * request to yield a different (`code`, `display_name`) pair because the new
     * error hid the old one (see "MULTIPLE ERRORS").
     * *REFERENCE*: A list of all (code, name) pairs:
     * * UNSPECIFIED = 0;
     * * VALIDATION_TIMEOUT_ERROR = 10; Validation couldn't be completed within
     * the deadline.
     * * REQUEST_OPTIONS_ERROR = 12;
     *     * REQUEST_OPTIONS_INVALID_SOLVING_MODE = 1201;
     *     * REQUEST_OPTIONS_INVALID_MAX_VALIDATION_ERRORS = 1203;
     *     * REQUEST_OPTIONS_INVALID_GEODESIC_METERS_PER_SECOND = 1204;
     *     * REQUEST_OPTIONS_GEODESIC_METERS_PER_SECOND_TOO_SMALL = 1205;
     *     * REQUEST_OPTIONS_MISSING_GEODESIC_METERS_PER_SECOND = 1206;
     *     * REQUEST_OPTIONS_POPULATE_PATHFINDER_TRIPS_AND_GEODESIC_DISTANCE
     *       = 1207;
     *     * REQUEST_OPTIONS_COST_MODEL_OPTIONS_AND_GEODESIC_DISTANCE = 1208;
     *     * REQUEST_OPTIONS_TRAVEL_MODE_INCOMPATIBLE_WITH_TRAFFIC = 1211;
     *     * REQUEST_OPTIONS_MULTIPLE_TRAFFIC_FLAVORS = 1212;
     *     * REQUEST_OPTIONS_INVALID_TRAFFIC_FLAVOR = 1213;
     *     * REQUEST_OPTIONS_TRAFFIC_ENABLED_WITHOUT_GLOBAL_START_TIME = 1214;
     *     * REQUEST_OPTIONS_TRAFFIC_ENABLED_WITH_PRECEDENCES = 1215;
     *     * REQUEST_OPTIONS_TRAFFIC_PREFILL_MODE_INVALID = 1216;
     *     * REQUEST_OPTIONS_TRAFFIC_PREFILL_ENABLED_WITHOUT_TRAFFIC = 1217;
     * * INJECTED_SOLUTION_ERROR = 20;
     *     * INJECTED_SOLUTION_MISSING_LABEL = 2000;
     *     * INJECTED_SOLUTION_DUPLICATE_LABEL = 2001;
     *     * INJECTED_SOLUTION_AMBIGUOUS_INDEX = 2002;
     * * SHIPMENT_MODEL_ERROR = 22;
     *     * SHIPMENT_MODEL_TOO_LARGE = 2200;
     *     * SHIPMENT_MODEL_TOO_MANY_CAPACITY_TYPES = 2201;
     *     * SHIPMENT_MODEL_GLOBAL_START_TIME_NEGATIVE_OR_NAN = 2202;
     *     * SHIPMENT_MODEL_GLOBAL_END_TIME_TOO_LARGE_OR_NAN = 2203;
     *     * SHIPMENT_MODEL_GLOBAL_START_TIME_AFTER_GLOBAL_END_TIME = 2204;
     *     * SHIPMENT_MODEL_GLOBAL_DURATION_TOO_LONG = 2205;
     * * INDEX_ERROR = 24;
     * * TAG_ERROR = 26;
     * * TIME_WINDOW_ERROR = 28;
     *     * TIME_WINDOW_INVALID_START_TIME = 2800;
     *     * TIME_WINDOW_INVALID_END_TIME = 2801;
     *     * TIME_WINDOW_INVALID_SOFT_START_TIME = 2802;
     *     * TIME_WINDOW_INVALID_SOFT_END_TIME = 2803;
     *     * TIME_WINDOW_OUTSIDE_GLOBAL_TIME_WINDOW = 2804;
     *     * TIME_WINDOW_START_TIME_AFTER_END_TIME = 2805;
     *     * TIME_WINDOW_INVALID_COST_PER_HOUR_BEFORE_SOFT_START_TIME = 2806;
     *     * TIME_WINDOW_INVALID_COST_PER_HOUR_AFTER_SOFT_END_TIME = 2807;
     *     * TIME_WINDOW_COST_BEFORE_SOFT_START_TIME_WITHOUT_SOFT_START_TIME
     *       = 2808;
     *     * TIME_WINDOW_COST_AFTER_SOFT_END_TIME_WITHOUT_SOFT_END_TIME = 2809;
     *     * TIME_WINDOW_SOFT_START_TIME_WITHOUT_COST_BEFORE_SOFT_START_TIME
     *       = 2810;
     *     * TIME_WINDOW_SOFT_END_TIME_WITHOUT_COST_AFTER_SOFT_END_TIME = 2811;
     *     * TIME_WINDOW_OVERLAPPING_ADJACENT_OR_EARLIER_THAN_PREVIOUS = 2812;
     *     * TIME_WINDOW_START_TIME_AFTER_SOFT_START_TIME = 2813;
     *     * TIME_WINDOW_SOFT_START_TIME_AFTER_END_TIME = 2814;
     *     * TIME_WINDOW_START_TIME_AFTER_SOFT_END_TIME = 2815;
     *     * TIME_WINDOW_SOFT_END_TIME_AFTER_END_TIME = 2816;
     *     * TIME_WINDOW_COST_BEFORE_SOFT_START_TIME_SET_AND_MULTIPLE_WINDOWS
     *       = 2817;
     *     * TIME_WINDOW_COST_AFTER_SOFT_END_TIME_SET_AND_MULTIPLE_WINDOWS = 2818;
     *     * TRANSITION_ATTRIBUTES_ERROR = 30;
     *     * TRANSITION_ATTRIBUTES_INVALID_COST = 3000;
     *     * TRANSITION_ATTRIBUTES_INVALID_COST_PER_KILOMETER = 3001;
     *     * TRANSITION_ATTRIBUTES_DUPLICATE_TAG_PAIR = 3002;
     *     * TRANSITION_ATTRIBUTES_DISTANCE_LIMIT_MAX_METERS_UNSUPPORTED = 3003;
     *     * TRANSITION_ATTRIBUTES_UNSPECIFIED_SOURCE_TAGS = 3004;
     *     * TRANSITION_ATTRIBUTES_CONFLICTING_SOURCE_TAGS_FIELDS = 3005;
     *     * TRANSITION_ATTRIBUTES_UNSPECIFIED_DESTINATION_TAGS = 3006;
     *     * TRANSITION_ATTRIBUTES_CONFLICTING_DESTINATION_TAGS_FIELDS = 3007;
     *     * TRANSITION_ATTRIBUTES_DELAY_DURATION_NEGATIVE_OR_NAN = 3008;
     *     * TRANSITION_ATTRIBUTES_DELAY_DURATION_EXCEEDS_GLOBAL_DURATION = 3009;
     * * AMOUNT_ERROR = 31;
     *     * AMOUNT_NEGATIVE_VALUE = 3100;
     * * LOAD_LIMIT_ERROR = 33;
     *     * LOAD_LIMIT_INVALID_COST_ABOVE_SOFT_MAX = 3303;
     *     * LOAD_LIMIT_SOFT_MAX_WITHOUT_COST_ABOVE_SOFT_MAX = 3304;
     *     * LOAD_LIMIT_COST_ABOVE_SOFT_MAX_WITHOUT_SOFT_MAX = 3305;
     *     * LOAD_LIMIT_NEGATIVE_SOFT_MAX = 3306;
     *     * LOAD_LIMIT_MIXED_DEMAND_TYPE = 3307;
     *     * LOAD_LIMIT_MAX_LOAD_NEGATIVE_VALUE = 3308;
     *     * LOAD_LIMIT_SOFT_MAX_ABOVE_MAX = 3309;
     * * INTERVAL_ERROR = 34;
     *     * INTERVAL_MIN_EXCEEDS_MAX = 3401;
     *     * INTERVAL_NEGATIVE_MIN = 3402;
     *     * INTERVAL_NEGATIVE_MAX = 3403;
     *     * INTERVAL_MIN_EXCEEDS_CAPACITY = 3404;
     *     * INTERVAL_MAX_EXCEEDS_CAPACITY = 3405;
     * * DISTANCE_LIMIT_ERROR = 36;
     *     * DISTANCE_LIMIT_INVALID_COST_AFTER_SOFT_MAX = 3601;
     *     * DISTANCE_LIMIT_SOFT_MAX_WITHOUT_COST_AFTER_SOFT_MAX = 3602;
     *     * DISTANCE_LIMIT_COST_AFTER_SOFT_MAX_WITHOUT_SOFT_MAX = 3603;
     *     * DISTANCE_LIMIT_NEGATIVE_MAX = 3604;
     *     * DISTANCE_LIMIT_NEGATIVE_SOFT_MAX = 3605;
     *     * DISTANCE_LIMIT_SOFT_MAX_LARGER_THAN_MAX = 3606;
     * * DURATION_LIMIT_ERROR = 38;
     *     * DURATION_LIMIT_MAX_DURATION_NEGATIVE_OR_NAN = 3800;
     *     * DURATION_LIMIT_SOFT_MAX_DURATION_NEGATIVE_OR_NAN = 3801;
     *     * DURATION_LIMIT_INVALID_COST_PER_HOUR_AFTER_SOFT_MAX = 3802;
     *     * DURATION_LIMIT_SOFT_MAX_WITHOUT_COST_AFTER_SOFT_MAX = 3803;
     *     * DURATION_LIMIT_COST_AFTER_SOFT_MAX_WITHOUT_SOFT_MAX = 3804;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_DURATION_NEGATIVE_OR_NAN = 3805;
     *     * DURATION_LIMIT_INVALID_COST_AFTER_QUADRATIC_SOFT_MAX = 3806;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_WITHOUT_COST_PER_SQUARE_HOUR
     *       = 3807;
     *     * DURATION_LIMIT_COST_PER_SQUARE_HOUR_WITHOUT_QUADRATIC_SOFT_MAX
     *       = 3808;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_WITHOUT_MAX = 3809;
     *     * DURATION_LIMIT_SOFT_MAX_LARGER_THAN_MAX = 3810;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_LARGER_THAN_MAX = 3811;
     *     * DURATION_LIMIT_DIFF_BETWEEN_MAX_AND_QUADRATIC_SOFT_MAX_TOO_LARGE
     *       = 3812;
     *     * DURATION_LIMIT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION = 3813;
     *     * DURATION_LIMIT_SOFT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION = 3814;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION
     *       = 3815;
     * * SHIPMENT_ERROR = 40;
     *     * SHIPMENT_PD_ABSOLUTE_DETOUR_LIMIT_DURATION_NEGATIVE_OR_NAN = 4000;
     *     * SHIPMENT_PD_ABSOLUTE_DETOUR_LIMIT_DURATION_EXCEEDS_GLOBAL_DURATION
     *       = 4001;
     *     * SHIPMENT_PD_TIME_LIMIT_DURATION_NEGATIVE_OR_NAN = 4002;
     *     * SHIPMENT_PD_TIME_LIMIT_DURATION_EXCEEDS_GLOBAL_DURATION = 4003;
     *     * SHIPMENT_EMPTY_SHIPMENT_TYPE = 4004;
     *     * SHIPMENT_NO_PICKUP_NO_DELIVERY = 4005;
     *     * SHIPMENT_INVALID_PENALTY_COST = 4006;
     *     * SHIPMENT_ALLOWED_VEHICLE_INDEX_OUT_OF_BOUNDS = 4007;
     *     * SHIPMENT_DUPLICATE_ALLOWED_VEHICLE_INDEX = 4008;
     *     * SHIPMENT_INCONSISTENT_COST_FOR_VEHICLE_SIZE_WITHOUT_INDEX = 4009;
     *     * SHIPMENT_INCONSISTENT_COST_FOR_VEHICLE_SIZE_WITH_INDEX = 4010;
     *     * SHIPMENT_INVALID_COST_FOR_VEHICLE = 4011;
     *     * SHIPMENT_COST_FOR_VEHICLE_INDEX_OUT_OF_BOUNDS = 4012;
     *     * SHIPMENT_DUPLICATE_COST_FOR_VEHICLE_INDEX = 4013;
     *     * SHIPMENT_DETOUR_WITHOUT_PICKUP_AND_DELIVERY = 4014;
     * * VEHICLE_ERROR = 42;
     *     * VEHICLE_EMPTY_REQUIRED_OPERATOR_TYPE = 4200;
     *     * VEHICLE_DUPLICATE_REQUIRED_OPERATOR_TYPE = 4201;
     *     * VEHICLE_NO_OPERATOR_WITH_REQUIRED_OPERATOR_TYPE = 4202;
     *     * VEHICLE_EMPTY_START_TAG = 4203;
     *     * VEHICLE_DUPLICATE_START_TAG = 4204;
     *     * VEHICLE_EMPTY_END_TAG = 4205;
     *     * VEHICLE_DUPLICATE_END_TAG = 4206;
     *     * VEHICLE_EXTRA_VISIT_DURATION_NEGATIVE_OR_NAN = 4207;
     *     * VEHICLE_EXTRA_VISIT_DURATION_EXCEEDS_GLOBAL_DURATION = 4208;
     *     * VEHICLE_EXTRA_VISIT_DURATION_EMPTY_KEY = 4209;
     *     * VEHICLE_FIRST_SHIPMENT_INDEX_OUT_OF_BOUNDS = 4210;
     *     * VEHICLE_FIRST_SHIPMENT_IGNORED = 4211;
     *     * VEHICLE_FIRST_SHIPMENT_NOT_BOUND = 4212;
     *     * VEHICLE_LAST_SHIPMENT_INDEX_OUT_OF_BOUNDS = 4213;
     *     * VEHICLE_LAST_SHIPMENT_IGNORED = 4214;
     *     * VEHICLE_LAST_SHIPMENT_NOT_BOUND = 4215;
     *     * VEHICLE_IGNORED_WITH_USED_IF_ROUTE_IS_EMPTY = 4216;
     *     * VEHICLE_INVALID_COST_PER_KILOMETER = 4217;
     *     * VEHICLE_INVALID_COST_PER_HOUR = 4218;
     *     * VEHICLE_INVALID_COST_PER_TRAVELED_HOUR = 4219;
     *     * VEHICLE_INVALID_FIXED_COST = 4220;
     *     * VEHICLE_INVALID_TRAVEL_DURATION_MULTIPLE = 4221;
     *     * VEHICLE_MINIMUM_DURATION_LONGER_THAN_DURATION_LIMIT = 4222;
     * * VISIT_REQUEST_ERROR = 44;
     *     * VISIT_REQUEST_EMPTY_TAG = 4400;
     *     * VISIT_REQUEST_DUPLICATE_TAG = 4401;
     *     * VISIT_REQUEST_DURATION_NEGATIVE_OR_NAN = 4404;
     *     * VISIT_REQUEST_DURATION_EXCEEDS_GLOBAL_DURATION = 4405;
     * * PRECEDENCE_ERROR = 46;
     * * BREAK_ERROR = 48;
     *     * BREAK_RULE_EMPTY = 4800;
     *     * BREAK_REQUEST_UNSPECIFIED_DURATION = 4801;
     *     * BREAK_REQUEST_UNSPECIFIED_EARLIEST_START_TIME = 4802;
     *     * BREAK_REQUEST_UNSPECIFIED_LATEST_START_TIME = 4803;
     *     * BREAK_REQUEST_DURATION_NEGATIVE_OR_NAN = 4804; = 4804;
     *     * BREAK_REQUEST_LATEST_START_TIME_BEFORE_EARLIEST_START_TIME = 4805;
     *     * BREAK_REQUEST_EARLIEST_START_TIME_BEFORE_GLOBAL_START_TIME = 4806;
     *     * BREAK_REQUEST_LATEST_END_TIME_AFTER_GLOBAL_END_TIME = 4807;
     *     * BREAK_REQUEST_NON_SCHEDULABLE = 4808;
     *     * BREAK_FREQUENCY_MAX_INTER_BREAK_DURATION_NEGATIVE_OR_NAN = 4809;
     *     * BREAK_FREQUENCY_MIN_BREAK_DURATION_NEGATIVE_OR_NAN = 4810;
     *     * BREAK_FREQUENCY_MIN_BREAK_DURATION_EXCEEDS_GLOBAL_DURATION = 4811;
     *     * BREAK_FREQUENCY_MAX_INTER_BREAK_DURATION_EXCEEDS_GLOBAL_DURATION
     *       = 4812;
     *     * BREAK_REQUEST_DURATION_EXCEEDS_GLOBAL_DURATION = 4813;
     *     * BREAK_FREQUENCY_MISSING_MAX_INTER_BREAK_DURATION = 4814;
     *     * BREAK_FREQUENCY_MISSING_MIN_BREAK_DURATION = 4815;
     * * SHIPMENT_TYPE_INCOMPATIBILITY_ERROR = 50;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_EMPTY_TYPE = 5001;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_LESS_THAN_TWO_TYPES = 5002;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_DUPLICATE_TYPE = 5003;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_INVALID_INCOMPATIBILITY_MODE = 5004;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_TOO_MANY_INCOMPATIBILITIES = 5005;
     * * SHIPMENT_TYPE_REQUIREMENT_ERROR = 52;
     *     * SHIPMENT_TYPE_REQUIREMENT_NO_REQUIRED_TYPE = 52001;
     *     * SHIPMENT_TYPE_REQUIREMENT_NO_DEPENDENT_TYPE = 52002;
     *     * SHIPMENT_TYPE_REQUIREMENT_INVALID_REQUIREMENT_MODE = 52003;
     *     * SHIPMENT_TYPE_REQUIREMENT_TOO_MANY_REQUIREMENTS = 52004;
     *     * SHIPMENT_TYPE_REQUIREMENT_EMPTY_REQUIRED_TYPE = 52005;
     *     * SHIPMENT_TYPE_REQUIREMENT_DUPLICATE_REQUIRED_TYPE = 52006;
     *     * SHIPMENT_TYPE_REQUIREMENT_NO_REQUIRED_TYPE_FOUND = 52007;
     *     * SHIPMENT_TYPE_REQUIREMENT_EMPTY_DEPENDENT_TYPE = 52008;
     *     * SHIPMENT_TYPE_REQUIREMENT_DUPLICATE_DEPENDENT_TYPE = 52009;
     *     * SHIPMENT_TYPE_REQUIREMENT_SELF_DEPENDENT_TYPE = 52010;
     *     * SHIPMENT_TYPE_REQUIREMENT_GRAPH_HAS_CYCLES = 52011;
     * * VEHICLE_OPERATOR_ERROR = 54;
     *     * VEHICLE_OPERATOR_EMPTY_TYPE = 5400;
     *     * VEHICLE_OPERATOR_MULTIPLE_START_TIME_WINDOWS = 5401;
     *     * VEHICLE_OPERATOR_SOFT_START_TIME_WINDOW = 5402;
     *     * VEHICLE_OPERATOR_MULTIPLE_END_TIME_WINDOWS = 5403;
     *     * VEHICLE_OPERATOR_SOFT_END_TIME_WINDOW = 5404;
     * * DURATION_SECONDS_MATRIX_ERROR = 56;
     *     * DURATION_SECONDS_MATRIX_DURATION_NEGATIVE_OR_NAN = 5600;
     *     * DURATION_SECONDS_MATRIX_DURATION_EXCEEDS_GLOBAL_DURATION = 5601;
     * * GRAPH_ARC_ERROR = 58;
     *     * GRAPH_ARC_DURATION_NEGATIVE_OR_NAN = 5800;
     *     * GRAPH_ARC_DURATION_EXCEEDS_GLOBAL_DURATION = 5801;
     * </pre>
     *
     * <code>int32 code = 1;</code>
     *
     * @return The code.
     */
    @java.lang.Override
    public int getCode() {
      return code_;
    }
    /**
     *
     *
     * <pre>
     * A validation error is defined by the pair (`code`, `display_name`) which
     * are always present.
     * Other fields (below) provide more context about the error.
     * *MULTIPLE ERRORS*:
     * When there are multiple errors, the validation process tries to output
     * several of them. Much like a compiler, this is an imperfect process. Some
     * validation errors will be "fatal", meaning that they stop the entire
     * validation process. This is the case for `display_name="UNSPECIFIED"`
     * errors, among others. Some may cause the validation process to skip other
     * errors.
     * *STABILITY*:
     * `code` and `display_name` should be very stable. But new codes and
     * display names may appear over time, which may cause a given (invalid)
     * request to yield a different (`code`, `display_name`) pair because the new
     * error hid the old one (see "MULTIPLE ERRORS").
     * *REFERENCE*: A list of all (code, name) pairs:
     * * UNSPECIFIED = 0;
     * * VALIDATION_TIMEOUT_ERROR = 10; Validation couldn't be completed within
     * the deadline.
     * * REQUEST_OPTIONS_ERROR = 12;
     *     * REQUEST_OPTIONS_INVALID_SOLVING_MODE = 1201;
     *     * REQUEST_OPTIONS_INVALID_MAX_VALIDATION_ERRORS = 1203;
     *     * REQUEST_OPTIONS_INVALID_GEODESIC_METERS_PER_SECOND = 1204;
     *     * REQUEST_OPTIONS_GEODESIC_METERS_PER_SECOND_TOO_SMALL = 1205;
     *     * REQUEST_OPTIONS_MISSING_GEODESIC_METERS_PER_SECOND = 1206;
     *     * REQUEST_OPTIONS_POPULATE_PATHFINDER_TRIPS_AND_GEODESIC_DISTANCE
     *       = 1207;
     *     * REQUEST_OPTIONS_COST_MODEL_OPTIONS_AND_GEODESIC_DISTANCE = 1208;
     *     * REQUEST_OPTIONS_TRAVEL_MODE_INCOMPATIBLE_WITH_TRAFFIC = 1211;
     *     * REQUEST_OPTIONS_MULTIPLE_TRAFFIC_FLAVORS = 1212;
     *     * REQUEST_OPTIONS_INVALID_TRAFFIC_FLAVOR = 1213;
     *     * REQUEST_OPTIONS_TRAFFIC_ENABLED_WITHOUT_GLOBAL_START_TIME = 1214;
     *     * REQUEST_OPTIONS_TRAFFIC_ENABLED_WITH_PRECEDENCES = 1215;
     *     * REQUEST_OPTIONS_TRAFFIC_PREFILL_MODE_INVALID = 1216;
     *     * REQUEST_OPTIONS_TRAFFIC_PREFILL_ENABLED_WITHOUT_TRAFFIC = 1217;
     * * INJECTED_SOLUTION_ERROR = 20;
     *     * INJECTED_SOLUTION_MISSING_LABEL = 2000;
     *     * INJECTED_SOLUTION_DUPLICATE_LABEL = 2001;
     *     * INJECTED_SOLUTION_AMBIGUOUS_INDEX = 2002;
     * * SHIPMENT_MODEL_ERROR = 22;
     *     * SHIPMENT_MODEL_TOO_LARGE = 2200;
     *     * SHIPMENT_MODEL_TOO_MANY_CAPACITY_TYPES = 2201;
     *     * SHIPMENT_MODEL_GLOBAL_START_TIME_NEGATIVE_OR_NAN = 2202;
     *     * SHIPMENT_MODEL_GLOBAL_END_TIME_TOO_LARGE_OR_NAN = 2203;
     *     * SHIPMENT_MODEL_GLOBAL_START_TIME_AFTER_GLOBAL_END_TIME = 2204;
     *     * SHIPMENT_MODEL_GLOBAL_DURATION_TOO_LONG = 2205;
     * * INDEX_ERROR = 24;
     * * TAG_ERROR = 26;
     * * TIME_WINDOW_ERROR = 28;
     *     * TIME_WINDOW_INVALID_START_TIME = 2800;
     *     * TIME_WINDOW_INVALID_END_TIME = 2801;
     *     * TIME_WINDOW_INVALID_SOFT_START_TIME = 2802;
     *     * TIME_WINDOW_INVALID_SOFT_END_TIME = 2803;
     *     * TIME_WINDOW_OUTSIDE_GLOBAL_TIME_WINDOW = 2804;
     *     * TIME_WINDOW_START_TIME_AFTER_END_TIME = 2805;
     *     * TIME_WINDOW_INVALID_COST_PER_HOUR_BEFORE_SOFT_START_TIME = 2806;
     *     * TIME_WINDOW_INVALID_COST_PER_HOUR_AFTER_SOFT_END_TIME = 2807;
     *     * TIME_WINDOW_COST_BEFORE_SOFT_START_TIME_WITHOUT_SOFT_START_TIME
     *       = 2808;
     *     * TIME_WINDOW_COST_AFTER_SOFT_END_TIME_WITHOUT_SOFT_END_TIME = 2809;
     *     * TIME_WINDOW_SOFT_START_TIME_WITHOUT_COST_BEFORE_SOFT_START_TIME
     *       = 2810;
     *     * TIME_WINDOW_SOFT_END_TIME_WITHOUT_COST_AFTER_SOFT_END_TIME = 2811;
     *     * TIME_WINDOW_OVERLAPPING_ADJACENT_OR_EARLIER_THAN_PREVIOUS = 2812;
     *     * TIME_WINDOW_START_TIME_AFTER_SOFT_START_TIME = 2813;
     *     * TIME_WINDOW_SOFT_START_TIME_AFTER_END_TIME = 2814;
     *     * TIME_WINDOW_START_TIME_AFTER_SOFT_END_TIME = 2815;
     *     * TIME_WINDOW_SOFT_END_TIME_AFTER_END_TIME = 2816;
     *     * TIME_WINDOW_COST_BEFORE_SOFT_START_TIME_SET_AND_MULTIPLE_WINDOWS
     *       = 2817;
     *     * TIME_WINDOW_COST_AFTER_SOFT_END_TIME_SET_AND_MULTIPLE_WINDOWS = 2818;
     *     * TRANSITION_ATTRIBUTES_ERROR = 30;
     *     * TRANSITION_ATTRIBUTES_INVALID_COST = 3000;
     *     * TRANSITION_ATTRIBUTES_INVALID_COST_PER_KILOMETER = 3001;
     *     * TRANSITION_ATTRIBUTES_DUPLICATE_TAG_PAIR = 3002;
     *     * TRANSITION_ATTRIBUTES_DISTANCE_LIMIT_MAX_METERS_UNSUPPORTED = 3003;
     *     * TRANSITION_ATTRIBUTES_UNSPECIFIED_SOURCE_TAGS = 3004;
     *     * TRANSITION_ATTRIBUTES_CONFLICTING_SOURCE_TAGS_FIELDS = 3005;
     *     * TRANSITION_ATTRIBUTES_UNSPECIFIED_DESTINATION_TAGS = 3006;
     *     * TRANSITION_ATTRIBUTES_CONFLICTING_DESTINATION_TAGS_FIELDS = 3007;
     *     * TRANSITION_ATTRIBUTES_DELAY_DURATION_NEGATIVE_OR_NAN = 3008;
     *     * TRANSITION_ATTRIBUTES_DELAY_DURATION_EXCEEDS_GLOBAL_DURATION = 3009;
     * * AMOUNT_ERROR = 31;
     *     * AMOUNT_NEGATIVE_VALUE = 3100;
     * * LOAD_LIMIT_ERROR = 33;
     *     * LOAD_LIMIT_INVALID_COST_ABOVE_SOFT_MAX = 3303;
     *     * LOAD_LIMIT_SOFT_MAX_WITHOUT_COST_ABOVE_SOFT_MAX = 3304;
     *     * LOAD_LIMIT_COST_ABOVE_SOFT_MAX_WITHOUT_SOFT_MAX = 3305;
     *     * LOAD_LIMIT_NEGATIVE_SOFT_MAX = 3306;
     *     * LOAD_LIMIT_MIXED_DEMAND_TYPE = 3307;
     *     * LOAD_LIMIT_MAX_LOAD_NEGATIVE_VALUE = 3308;
     *     * LOAD_LIMIT_SOFT_MAX_ABOVE_MAX = 3309;
     * * INTERVAL_ERROR = 34;
     *     * INTERVAL_MIN_EXCEEDS_MAX = 3401;
     *     * INTERVAL_NEGATIVE_MIN = 3402;
     *     * INTERVAL_NEGATIVE_MAX = 3403;
     *     * INTERVAL_MIN_EXCEEDS_CAPACITY = 3404;
     *     * INTERVAL_MAX_EXCEEDS_CAPACITY = 3405;
     * * DISTANCE_LIMIT_ERROR = 36;
     *     * DISTANCE_LIMIT_INVALID_COST_AFTER_SOFT_MAX = 3601;
     *     * DISTANCE_LIMIT_SOFT_MAX_WITHOUT_COST_AFTER_SOFT_MAX = 3602;
     *     * DISTANCE_LIMIT_COST_AFTER_SOFT_MAX_WITHOUT_SOFT_MAX = 3603;
     *     * DISTANCE_LIMIT_NEGATIVE_MAX = 3604;
     *     * DISTANCE_LIMIT_NEGATIVE_SOFT_MAX = 3605;
     *     * DISTANCE_LIMIT_SOFT_MAX_LARGER_THAN_MAX = 3606;
     * * DURATION_LIMIT_ERROR = 38;
     *     * DURATION_LIMIT_MAX_DURATION_NEGATIVE_OR_NAN = 3800;
     *     * DURATION_LIMIT_SOFT_MAX_DURATION_NEGATIVE_OR_NAN = 3801;
     *     * DURATION_LIMIT_INVALID_COST_PER_HOUR_AFTER_SOFT_MAX = 3802;
     *     * DURATION_LIMIT_SOFT_MAX_WITHOUT_COST_AFTER_SOFT_MAX = 3803;
     *     * DURATION_LIMIT_COST_AFTER_SOFT_MAX_WITHOUT_SOFT_MAX = 3804;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_DURATION_NEGATIVE_OR_NAN = 3805;
     *     * DURATION_LIMIT_INVALID_COST_AFTER_QUADRATIC_SOFT_MAX = 3806;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_WITHOUT_COST_PER_SQUARE_HOUR
     *       = 3807;
     *     * DURATION_LIMIT_COST_PER_SQUARE_HOUR_WITHOUT_QUADRATIC_SOFT_MAX
     *       = 3808;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_WITHOUT_MAX = 3809;
     *     * DURATION_LIMIT_SOFT_MAX_LARGER_THAN_MAX = 3810;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_LARGER_THAN_MAX = 3811;
     *     * DURATION_LIMIT_DIFF_BETWEEN_MAX_AND_QUADRATIC_SOFT_MAX_TOO_LARGE
     *       = 3812;
     *     * DURATION_LIMIT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION = 3813;
     *     * DURATION_LIMIT_SOFT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION = 3814;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION
     *       = 3815;
     * * SHIPMENT_ERROR = 40;
     *     * SHIPMENT_PD_ABSOLUTE_DETOUR_LIMIT_DURATION_NEGATIVE_OR_NAN = 4000;
     *     * SHIPMENT_PD_ABSOLUTE_DETOUR_LIMIT_DURATION_EXCEEDS_GLOBAL_DURATION
     *       = 4001;
     *     * SHIPMENT_PD_TIME_LIMIT_DURATION_NEGATIVE_OR_NAN = 4002;
     *     * SHIPMENT_PD_TIME_LIMIT_DURATION_EXCEEDS_GLOBAL_DURATION = 4003;
     *     * SHIPMENT_EMPTY_SHIPMENT_TYPE = 4004;
     *     * SHIPMENT_NO_PICKUP_NO_DELIVERY = 4005;
     *     * SHIPMENT_INVALID_PENALTY_COST = 4006;
     *     * SHIPMENT_ALLOWED_VEHICLE_INDEX_OUT_OF_BOUNDS = 4007;
     *     * SHIPMENT_DUPLICATE_ALLOWED_VEHICLE_INDEX = 4008;
     *     * SHIPMENT_INCONSISTENT_COST_FOR_VEHICLE_SIZE_WITHOUT_INDEX = 4009;
     *     * SHIPMENT_INCONSISTENT_COST_FOR_VEHICLE_SIZE_WITH_INDEX = 4010;
     *     * SHIPMENT_INVALID_COST_FOR_VEHICLE = 4011;
     *     * SHIPMENT_COST_FOR_VEHICLE_INDEX_OUT_OF_BOUNDS = 4012;
     *     * SHIPMENT_DUPLICATE_COST_FOR_VEHICLE_INDEX = 4013;
     *     * SHIPMENT_DETOUR_WITHOUT_PICKUP_AND_DELIVERY = 4014;
     * * VEHICLE_ERROR = 42;
     *     * VEHICLE_EMPTY_REQUIRED_OPERATOR_TYPE = 4200;
     *     * VEHICLE_DUPLICATE_REQUIRED_OPERATOR_TYPE = 4201;
     *     * VEHICLE_NO_OPERATOR_WITH_REQUIRED_OPERATOR_TYPE = 4202;
     *     * VEHICLE_EMPTY_START_TAG = 4203;
     *     * VEHICLE_DUPLICATE_START_TAG = 4204;
     *     * VEHICLE_EMPTY_END_TAG = 4205;
     *     * VEHICLE_DUPLICATE_END_TAG = 4206;
     *     * VEHICLE_EXTRA_VISIT_DURATION_NEGATIVE_OR_NAN = 4207;
     *     * VEHICLE_EXTRA_VISIT_DURATION_EXCEEDS_GLOBAL_DURATION = 4208;
     *     * VEHICLE_EXTRA_VISIT_DURATION_EMPTY_KEY = 4209;
     *     * VEHICLE_FIRST_SHIPMENT_INDEX_OUT_OF_BOUNDS = 4210;
     *     * VEHICLE_FIRST_SHIPMENT_IGNORED = 4211;
     *     * VEHICLE_FIRST_SHIPMENT_NOT_BOUND = 4212;
     *     * VEHICLE_LAST_SHIPMENT_INDEX_OUT_OF_BOUNDS = 4213;
     *     * VEHICLE_LAST_SHIPMENT_IGNORED = 4214;
     *     * VEHICLE_LAST_SHIPMENT_NOT_BOUND = 4215;
     *     * VEHICLE_IGNORED_WITH_USED_IF_ROUTE_IS_EMPTY = 4216;
     *     * VEHICLE_INVALID_COST_PER_KILOMETER = 4217;
     *     * VEHICLE_INVALID_COST_PER_HOUR = 4218;
     *     * VEHICLE_INVALID_COST_PER_TRAVELED_HOUR = 4219;
     *     * VEHICLE_INVALID_FIXED_COST = 4220;
     *     * VEHICLE_INVALID_TRAVEL_DURATION_MULTIPLE = 4221;
     *     * VEHICLE_MINIMUM_DURATION_LONGER_THAN_DURATION_LIMIT = 4222;
     * * VISIT_REQUEST_ERROR = 44;
     *     * VISIT_REQUEST_EMPTY_TAG = 4400;
     *     * VISIT_REQUEST_DUPLICATE_TAG = 4401;
     *     * VISIT_REQUEST_DURATION_NEGATIVE_OR_NAN = 4404;
     *     * VISIT_REQUEST_DURATION_EXCEEDS_GLOBAL_DURATION = 4405;
     * * PRECEDENCE_ERROR = 46;
     * * BREAK_ERROR = 48;
     *     * BREAK_RULE_EMPTY = 4800;
     *     * BREAK_REQUEST_UNSPECIFIED_DURATION = 4801;
     *     * BREAK_REQUEST_UNSPECIFIED_EARLIEST_START_TIME = 4802;
     *     * BREAK_REQUEST_UNSPECIFIED_LATEST_START_TIME = 4803;
     *     * BREAK_REQUEST_DURATION_NEGATIVE_OR_NAN = 4804; = 4804;
     *     * BREAK_REQUEST_LATEST_START_TIME_BEFORE_EARLIEST_START_TIME = 4805;
     *     * BREAK_REQUEST_EARLIEST_START_TIME_BEFORE_GLOBAL_START_TIME = 4806;
     *     * BREAK_REQUEST_LATEST_END_TIME_AFTER_GLOBAL_END_TIME = 4807;
     *     * BREAK_REQUEST_NON_SCHEDULABLE = 4808;
     *     * BREAK_FREQUENCY_MAX_INTER_BREAK_DURATION_NEGATIVE_OR_NAN = 4809;
     *     * BREAK_FREQUENCY_MIN_BREAK_DURATION_NEGATIVE_OR_NAN = 4810;
     *     * BREAK_FREQUENCY_MIN_BREAK_DURATION_EXCEEDS_GLOBAL_DURATION = 4811;
     *     * BREAK_FREQUENCY_MAX_INTER_BREAK_DURATION_EXCEEDS_GLOBAL_DURATION
     *       = 4812;
     *     * BREAK_REQUEST_DURATION_EXCEEDS_GLOBAL_DURATION = 4813;
     *     * BREAK_FREQUENCY_MISSING_MAX_INTER_BREAK_DURATION = 4814;
     *     * BREAK_FREQUENCY_MISSING_MIN_BREAK_DURATION = 4815;
     * * SHIPMENT_TYPE_INCOMPATIBILITY_ERROR = 50;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_EMPTY_TYPE = 5001;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_LESS_THAN_TWO_TYPES = 5002;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_DUPLICATE_TYPE = 5003;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_INVALID_INCOMPATIBILITY_MODE = 5004;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_TOO_MANY_INCOMPATIBILITIES = 5005;
     * * SHIPMENT_TYPE_REQUIREMENT_ERROR = 52;
     *     * SHIPMENT_TYPE_REQUIREMENT_NO_REQUIRED_TYPE = 52001;
     *     * SHIPMENT_TYPE_REQUIREMENT_NO_DEPENDENT_TYPE = 52002;
     *     * SHIPMENT_TYPE_REQUIREMENT_INVALID_REQUIREMENT_MODE = 52003;
     *     * SHIPMENT_TYPE_REQUIREMENT_TOO_MANY_REQUIREMENTS = 52004;
     *     * SHIPMENT_TYPE_REQUIREMENT_EMPTY_REQUIRED_TYPE = 52005;
     *     * SHIPMENT_TYPE_REQUIREMENT_DUPLICATE_REQUIRED_TYPE = 52006;
     *     * SHIPMENT_TYPE_REQUIREMENT_NO_REQUIRED_TYPE_FOUND = 52007;
     *     * SHIPMENT_TYPE_REQUIREMENT_EMPTY_DEPENDENT_TYPE = 52008;
     *     * SHIPMENT_TYPE_REQUIREMENT_DUPLICATE_DEPENDENT_TYPE = 52009;
     *     * SHIPMENT_TYPE_REQUIREMENT_SELF_DEPENDENT_TYPE = 52010;
     *     * SHIPMENT_TYPE_REQUIREMENT_GRAPH_HAS_CYCLES = 52011;
     * * VEHICLE_OPERATOR_ERROR = 54;
     *     * VEHICLE_OPERATOR_EMPTY_TYPE = 5400;
     *     * VEHICLE_OPERATOR_MULTIPLE_START_TIME_WINDOWS = 5401;
     *     * VEHICLE_OPERATOR_SOFT_START_TIME_WINDOW = 5402;
     *     * VEHICLE_OPERATOR_MULTIPLE_END_TIME_WINDOWS = 5403;
     *     * VEHICLE_OPERATOR_SOFT_END_TIME_WINDOW = 5404;
     * * DURATION_SECONDS_MATRIX_ERROR = 56;
     *     * DURATION_SECONDS_MATRIX_DURATION_NEGATIVE_OR_NAN = 5600;
     *     * DURATION_SECONDS_MATRIX_DURATION_EXCEEDS_GLOBAL_DURATION = 5601;
     * * GRAPH_ARC_ERROR = 58;
     *     * GRAPH_ARC_DURATION_NEGATIVE_OR_NAN = 5800;
     *     * GRAPH_ARC_DURATION_EXCEEDS_GLOBAL_DURATION = 5801;
     * </pre>
     *
     * <code>int32 code = 1;</code>
     *
     * @param value The code to set.
     * @return This builder for chaining.
     */
    public Builder setCode(int value) {

      code_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A validation error is defined by the pair (`code`, `display_name`) which
     * are always present.
     * Other fields (below) provide more context about the error.
     * *MULTIPLE ERRORS*:
     * When there are multiple errors, the validation process tries to output
     * several of them. Much like a compiler, this is an imperfect process. Some
     * validation errors will be "fatal", meaning that they stop the entire
     * validation process. This is the case for `display_name="UNSPECIFIED"`
     * errors, among others. Some may cause the validation process to skip other
     * errors.
     * *STABILITY*:
     * `code` and `display_name` should be very stable. But new codes and
     * display names may appear over time, which may cause a given (invalid)
     * request to yield a different (`code`, `display_name`) pair because the new
     * error hid the old one (see "MULTIPLE ERRORS").
     * *REFERENCE*: A list of all (code, name) pairs:
     * * UNSPECIFIED = 0;
     * * VALIDATION_TIMEOUT_ERROR = 10; Validation couldn't be completed within
     * the deadline.
     * * REQUEST_OPTIONS_ERROR = 12;
     *     * REQUEST_OPTIONS_INVALID_SOLVING_MODE = 1201;
     *     * REQUEST_OPTIONS_INVALID_MAX_VALIDATION_ERRORS = 1203;
     *     * REQUEST_OPTIONS_INVALID_GEODESIC_METERS_PER_SECOND = 1204;
     *     * REQUEST_OPTIONS_GEODESIC_METERS_PER_SECOND_TOO_SMALL = 1205;
     *     * REQUEST_OPTIONS_MISSING_GEODESIC_METERS_PER_SECOND = 1206;
     *     * REQUEST_OPTIONS_POPULATE_PATHFINDER_TRIPS_AND_GEODESIC_DISTANCE
     *       = 1207;
     *     * REQUEST_OPTIONS_COST_MODEL_OPTIONS_AND_GEODESIC_DISTANCE = 1208;
     *     * REQUEST_OPTIONS_TRAVEL_MODE_INCOMPATIBLE_WITH_TRAFFIC = 1211;
     *     * REQUEST_OPTIONS_MULTIPLE_TRAFFIC_FLAVORS = 1212;
     *     * REQUEST_OPTIONS_INVALID_TRAFFIC_FLAVOR = 1213;
     *     * REQUEST_OPTIONS_TRAFFIC_ENABLED_WITHOUT_GLOBAL_START_TIME = 1214;
     *     * REQUEST_OPTIONS_TRAFFIC_ENABLED_WITH_PRECEDENCES = 1215;
     *     * REQUEST_OPTIONS_TRAFFIC_PREFILL_MODE_INVALID = 1216;
     *     * REQUEST_OPTIONS_TRAFFIC_PREFILL_ENABLED_WITHOUT_TRAFFIC = 1217;
     * * INJECTED_SOLUTION_ERROR = 20;
     *     * INJECTED_SOLUTION_MISSING_LABEL = 2000;
     *     * INJECTED_SOLUTION_DUPLICATE_LABEL = 2001;
     *     * INJECTED_SOLUTION_AMBIGUOUS_INDEX = 2002;
     * * SHIPMENT_MODEL_ERROR = 22;
     *     * SHIPMENT_MODEL_TOO_LARGE = 2200;
     *     * SHIPMENT_MODEL_TOO_MANY_CAPACITY_TYPES = 2201;
     *     * SHIPMENT_MODEL_GLOBAL_START_TIME_NEGATIVE_OR_NAN = 2202;
     *     * SHIPMENT_MODEL_GLOBAL_END_TIME_TOO_LARGE_OR_NAN = 2203;
     *     * SHIPMENT_MODEL_GLOBAL_START_TIME_AFTER_GLOBAL_END_TIME = 2204;
     *     * SHIPMENT_MODEL_GLOBAL_DURATION_TOO_LONG = 2205;
     * * INDEX_ERROR = 24;
     * * TAG_ERROR = 26;
     * * TIME_WINDOW_ERROR = 28;
     *     * TIME_WINDOW_INVALID_START_TIME = 2800;
     *     * TIME_WINDOW_INVALID_END_TIME = 2801;
     *     * TIME_WINDOW_INVALID_SOFT_START_TIME = 2802;
     *     * TIME_WINDOW_INVALID_SOFT_END_TIME = 2803;
     *     * TIME_WINDOW_OUTSIDE_GLOBAL_TIME_WINDOW = 2804;
     *     * TIME_WINDOW_START_TIME_AFTER_END_TIME = 2805;
     *     * TIME_WINDOW_INVALID_COST_PER_HOUR_BEFORE_SOFT_START_TIME = 2806;
     *     * TIME_WINDOW_INVALID_COST_PER_HOUR_AFTER_SOFT_END_TIME = 2807;
     *     * TIME_WINDOW_COST_BEFORE_SOFT_START_TIME_WITHOUT_SOFT_START_TIME
     *       = 2808;
     *     * TIME_WINDOW_COST_AFTER_SOFT_END_TIME_WITHOUT_SOFT_END_TIME = 2809;
     *     * TIME_WINDOW_SOFT_START_TIME_WITHOUT_COST_BEFORE_SOFT_START_TIME
     *       = 2810;
     *     * TIME_WINDOW_SOFT_END_TIME_WITHOUT_COST_AFTER_SOFT_END_TIME = 2811;
     *     * TIME_WINDOW_OVERLAPPING_ADJACENT_OR_EARLIER_THAN_PREVIOUS = 2812;
     *     * TIME_WINDOW_START_TIME_AFTER_SOFT_START_TIME = 2813;
     *     * TIME_WINDOW_SOFT_START_TIME_AFTER_END_TIME = 2814;
     *     * TIME_WINDOW_START_TIME_AFTER_SOFT_END_TIME = 2815;
     *     * TIME_WINDOW_SOFT_END_TIME_AFTER_END_TIME = 2816;
     *     * TIME_WINDOW_COST_BEFORE_SOFT_START_TIME_SET_AND_MULTIPLE_WINDOWS
     *       = 2817;
     *     * TIME_WINDOW_COST_AFTER_SOFT_END_TIME_SET_AND_MULTIPLE_WINDOWS = 2818;
     *     * TRANSITION_ATTRIBUTES_ERROR = 30;
     *     * TRANSITION_ATTRIBUTES_INVALID_COST = 3000;
     *     * TRANSITION_ATTRIBUTES_INVALID_COST_PER_KILOMETER = 3001;
     *     * TRANSITION_ATTRIBUTES_DUPLICATE_TAG_PAIR = 3002;
     *     * TRANSITION_ATTRIBUTES_DISTANCE_LIMIT_MAX_METERS_UNSUPPORTED = 3003;
     *     * TRANSITION_ATTRIBUTES_UNSPECIFIED_SOURCE_TAGS = 3004;
     *     * TRANSITION_ATTRIBUTES_CONFLICTING_SOURCE_TAGS_FIELDS = 3005;
     *     * TRANSITION_ATTRIBUTES_UNSPECIFIED_DESTINATION_TAGS = 3006;
     *     * TRANSITION_ATTRIBUTES_CONFLICTING_DESTINATION_TAGS_FIELDS = 3007;
     *     * TRANSITION_ATTRIBUTES_DELAY_DURATION_NEGATIVE_OR_NAN = 3008;
     *     * TRANSITION_ATTRIBUTES_DELAY_DURATION_EXCEEDS_GLOBAL_DURATION = 3009;
     * * AMOUNT_ERROR = 31;
     *     * AMOUNT_NEGATIVE_VALUE = 3100;
     * * LOAD_LIMIT_ERROR = 33;
     *     * LOAD_LIMIT_INVALID_COST_ABOVE_SOFT_MAX = 3303;
     *     * LOAD_LIMIT_SOFT_MAX_WITHOUT_COST_ABOVE_SOFT_MAX = 3304;
     *     * LOAD_LIMIT_COST_ABOVE_SOFT_MAX_WITHOUT_SOFT_MAX = 3305;
     *     * LOAD_LIMIT_NEGATIVE_SOFT_MAX = 3306;
     *     * LOAD_LIMIT_MIXED_DEMAND_TYPE = 3307;
     *     * LOAD_LIMIT_MAX_LOAD_NEGATIVE_VALUE = 3308;
     *     * LOAD_LIMIT_SOFT_MAX_ABOVE_MAX = 3309;
     * * INTERVAL_ERROR = 34;
     *     * INTERVAL_MIN_EXCEEDS_MAX = 3401;
     *     * INTERVAL_NEGATIVE_MIN = 3402;
     *     * INTERVAL_NEGATIVE_MAX = 3403;
     *     * INTERVAL_MIN_EXCEEDS_CAPACITY = 3404;
     *     * INTERVAL_MAX_EXCEEDS_CAPACITY = 3405;
     * * DISTANCE_LIMIT_ERROR = 36;
     *     * DISTANCE_LIMIT_INVALID_COST_AFTER_SOFT_MAX = 3601;
     *     * DISTANCE_LIMIT_SOFT_MAX_WITHOUT_COST_AFTER_SOFT_MAX = 3602;
     *     * DISTANCE_LIMIT_COST_AFTER_SOFT_MAX_WITHOUT_SOFT_MAX = 3603;
     *     * DISTANCE_LIMIT_NEGATIVE_MAX = 3604;
     *     * DISTANCE_LIMIT_NEGATIVE_SOFT_MAX = 3605;
     *     * DISTANCE_LIMIT_SOFT_MAX_LARGER_THAN_MAX = 3606;
     * * DURATION_LIMIT_ERROR = 38;
     *     * DURATION_LIMIT_MAX_DURATION_NEGATIVE_OR_NAN = 3800;
     *     * DURATION_LIMIT_SOFT_MAX_DURATION_NEGATIVE_OR_NAN = 3801;
     *     * DURATION_LIMIT_INVALID_COST_PER_HOUR_AFTER_SOFT_MAX = 3802;
     *     * DURATION_LIMIT_SOFT_MAX_WITHOUT_COST_AFTER_SOFT_MAX = 3803;
     *     * DURATION_LIMIT_COST_AFTER_SOFT_MAX_WITHOUT_SOFT_MAX = 3804;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_DURATION_NEGATIVE_OR_NAN = 3805;
     *     * DURATION_LIMIT_INVALID_COST_AFTER_QUADRATIC_SOFT_MAX = 3806;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_WITHOUT_COST_PER_SQUARE_HOUR
     *       = 3807;
     *     * DURATION_LIMIT_COST_PER_SQUARE_HOUR_WITHOUT_QUADRATIC_SOFT_MAX
     *       = 3808;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_WITHOUT_MAX = 3809;
     *     * DURATION_LIMIT_SOFT_MAX_LARGER_THAN_MAX = 3810;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_LARGER_THAN_MAX = 3811;
     *     * DURATION_LIMIT_DIFF_BETWEEN_MAX_AND_QUADRATIC_SOFT_MAX_TOO_LARGE
     *       = 3812;
     *     * DURATION_LIMIT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION = 3813;
     *     * DURATION_LIMIT_SOFT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION = 3814;
     *     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION
     *       = 3815;
     * * SHIPMENT_ERROR = 40;
     *     * SHIPMENT_PD_ABSOLUTE_DETOUR_LIMIT_DURATION_NEGATIVE_OR_NAN = 4000;
     *     * SHIPMENT_PD_ABSOLUTE_DETOUR_LIMIT_DURATION_EXCEEDS_GLOBAL_DURATION
     *       = 4001;
     *     * SHIPMENT_PD_TIME_LIMIT_DURATION_NEGATIVE_OR_NAN = 4002;
     *     * SHIPMENT_PD_TIME_LIMIT_DURATION_EXCEEDS_GLOBAL_DURATION = 4003;
     *     * SHIPMENT_EMPTY_SHIPMENT_TYPE = 4004;
     *     * SHIPMENT_NO_PICKUP_NO_DELIVERY = 4005;
     *     * SHIPMENT_INVALID_PENALTY_COST = 4006;
     *     * SHIPMENT_ALLOWED_VEHICLE_INDEX_OUT_OF_BOUNDS = 4007;
     *     * SHIPMENT_DUPLICATE_ALLOWED_VEHICLE_INDEX = 4008;
     *     * SHIPMENT_INCONSISTENT_COST_FOR_VEHICLE_SIZE_WITHOUT_INDEX = 4009;
     *     * SHIPMENT_INCONSISTENT_COST_FOR_VEHICLE_SIZE_WITH_INDEX = 4010;
     *     * SHIPMENT_INVALID_COST_FOR_VEHICLE = 4011;
     *     * SHIPMENT_COST_FOR_VEHICLE_INDEX_OUT_OF_BOUNDS = 4012;
     *     * SHIPMENT_DUPLICATE_COST_FOR_VEHICLE_INDEX = 4013;
     *     * SHIPMENT_DETOUR_WITHOUT_PICKUP_AND_DELIVERY = 4014;
     * * VEHICLE_ERROR = 42;
     *     * VEHICLE_EMPTY_REQUIRED_OPERATOR_TYPE = 4200;
     *     * VEHICLE_DUPLICATE_REQUIRED_OPERATOR_TYPE = 4201;
     *     * VEHICLE_NO_OPERATOR_WITH_REQUIRED_OPERATOR_TYPE = 4202;
     *     * VEHICLE_EMPTY_START_TAG = 4203;
     *     * VEHICLE_DUPLICATE_START_TAG = 4204;
     *     * VEHICLE_EMPTY_END_TAG = 4205;
     *     * VEHICLE_DUPLICATE_END_TAG = 4206;
     *     * VEHICLE_EXTRA_VISIT_DURATION_NEGATIVE_OR_NAN = 4207;
     *     * VEHICLE_EXTRA_VISIT_DURATION_EXCEEDS_GLOBAL_DURATION = 4208;
     *     * VEHICLE_EXTRA_VISIT_DURATION_EMPTY_KEY = 4209;
     *     * VEHICLE_FIRST_SHIPMENT_INDEX_OUT_OF_BOUNDS = 4210;
     *     * VEHICLE_FIRST_SHIPMENT_IGNORED = 4211;
     *     * VEHICLE_FIRST_SHIPMENT_NOT_BOUND = 4212;
     *     * VEHICLE_LAST_SHIPMENT_INDEX_OUT_OF_BOUNDS = 4213;
     *     * VEHICLE_LAST_SHIPMENT_IGNORED = 4214;
     *     * VEHICLE_LAST_SHIPMENT_NOT_BOUND = 4215;
     *     * VEHICLE_IGNORED_WITH_USED_IF_ROUTE_IS_EMPTY = 4216;
     *     * VEHICLE_INVALID_COST_PER_KILOMETER = 4217;
     *     * VEHICLE_INVALID_COST_PER_HOUR = 4218;
     *     * VEHICLE_INVALID_COST_PER_TRAVELED_HOUR = 4219;
     *     * VEHICLE_INVALID_FIXED_COST = 4220;
     *     * VEHICLE_INVALID_TRAVEL_DURATION_MULTIPLE = 4221;
     *     * VEHICLE_MINIMUM_DURATION_LONGER_THAN_DURATION_LIMIT = 4222;
     * * VISIT_REQUEST_ERROR = 44;
     *     * VISIT_REQUEST_EMPTY_TAG = 4400;
     *     * VISIT_REQUEST_DUPLICATE_TAG = 4401;
     *     * VISIT_REQUEST_DURATION_NEGATIVE_OR_NAN = 4404;
     *     * VISIT_REQUEST_DURATION_EXCEEDS_GLOBAL_DURATION = 4405;
     * * PRECEDENCE_ERROR = 46;
     * * BREAK_ERROR = 48;
     *     * BREAK_RULE_EMPTY = 4800;
     *     * BREAK_REQUEST_UNSPECIFIED_DURATION = 4801;
     *     * BREAK_REQUEST_UNSPECIFIED_EARLIEST_START_TIME = 4802;
     *     * BREAK_REQUEST_UNSPECIFIED_LATEST_START_TIME = 4803;
     *     * BREAK_REQUEST_DURATION_NEGATIVE_OR_NAN = 4804; = 4804;
     *     * BREAK_REQUEST_LATEST_START_TIME_BEFORE_EARLIEST_START_TIME = 4805;
     *     * BREAK_REQUEST_EARLIEST_START_TIME_BEFORE_GLOBAL_START_TIME = 4806;
     *     * BREAK_REQUEST_LATEST_END_TIME_AFTER_GLOBAL_END_TIME = 4807;
     *     * BREAK_REQUEST_NON_SCHEDULABLE = 4808;
     *     * BREAK_FREQUENCY_MAX_INTER_BREAK_DURATION_NEGATIVE_OR_NAN = 4809;
     *     * BREAK_FREQUENCY_MIN_BREAK_DURATION_NEGATIVE_OR_NAN = 4810;
     *     * BREAK_FREQUENCY_MIN_BREAK_DURATION_EXCEEDS_GLOBAL_DURATION = 4811;
     *     * BREAK_FREQUENCY_MAX_INTER_BREAK_DURATION_EXCEEDS_GLOBAL_DURATION
     *       = 4812;
     *     * BREAK_REQUEST_DURATION_EXCEEDS_GLOBAL_DURATION = 4813;
     *     * BREAK_FREQUENCY_MISSING_MAX_INTER_BREAK_DURATION = 4814;
     *     * BREAK_FREQUENCY_MISSING_MIN_BREAK_DURATION = 4815;
     * * SHIPMENT_TYPE_INCOMPATIBILITY_ERROR = 50;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_EMPTY_TYPE = 5001;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_LESS_THAN_TWO_TYPES = 5002;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_DUPLICATE_TYPE = 5003;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_INVALID_INCOMPATIBILITY_MODE = 5004;
     *     * SHIPMENT_TYPE_INCOMPATIBILITY_TOO_MANY_INCOMPATIBILITIES = 5005;
     * * SHIPMENT_TYPE_REQUIREMENT_ERROR = 52;
     *     * SHIPMENT_TYPE_REQUIREMENT_NO_REQUIRED_TYPE = 52001;
     *     * SHIPMENT_TYPE_REQUIREMENT_NO_DEPENDENT_TYPE = 52002;
     *     * SHIPMENT_TYPE_REQUIREMENT_INVALID_REQUIREMENT_MODE = 52003;
     *     * SHIPMENT_TYPE_REQUIREMENT_TOO_MANY_REQUIREMENTS = 52004;
     *     * SHIPMENT_TYPE_REQUIREMENT_EMPTY_REQUIRED_TYPE = 52005;
     *     * SHIPMENT_TYPE_REQUIREMENT_DUPLICATE_REQUIRED_TYPE = 52006;
     *     * SHIPMENT_TYPE_REQUIREMENT_NO_REQUIRED_TYPE_FOUND = 52007;
     *     * SHIPMENT_TYPE_REQUIREMENT_EMPTY_DEPENDENT_TYPE = 52008;
     *     * SHIPMENT_TYPE_REQUIREMENT_DUPLICATE_DEPENDENT_TYPE = 52009;
     *     * SHIPMENT_TYPE_REQUIREMENT_SELF_DEPENDENT_TYPE = 52010;
     *     * SHIPMENT_TYPE_REQUIREMENT_GRAPH_HAS_CYCLES = 52011;
     * * VEHICLE_OPERATOR_ERROR = 54;
     *     * VEHICLE_OPERATOR_EMPTY_TYPE = 5400;
     *     * VEHICLE_OPERATOR_MULTIPLE_START_TIME_WINDOWS = 5401;
     *     * VEHICLE_OPERATOR_SOFT_START_TIME_WINDOW = 5402;
     *     * VEHICLE_OPERATOR_MULTIPLE_END_TIME_WINDOWS = 5403;
     *     * VEHICLE_OPERATOR_SOFT_END_TIME_WINDOW = 5404;
     * * DURATION_SECONDS_MATRIX_ERROR = 56;
     *     * DURATION_SECONDS_MATRIX_DURATION_NEGATIVE_OR_NAN = 5600;
     *     * DURATION_SECONDS_MATRIX_DURATION_EXCEEDS_GLOBAL_DURATION = 5601;
     * * GRAPH_ARC_ERROR = 58;
     *     * GRAPH_ARC_DURATION_NEGATIVE_OR_NAN = 5800;
     *     * GRAPH_ARC_DURATION_EXCEEDS_GLOBAL_DURATION = 5801;
     * </pre>
     *
     * <code>int32 code = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCode() {

      code_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The error display name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The error display name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The error display name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error display name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error display name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference>
        fields_ = java.util.Collections.emptyList();

    private void ensureFieldsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        fields_ =
            new java.util.ArrayList<
                com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference>(
                fields_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference,
            com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder,
            com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReferenceOrBuilder>
        fieldsBuilder_;

    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference>
        getFieldsList() {
      if (fieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fields_);
      } else {
        return fieldsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public int getFieldsCount() {
      if (fieldsBuilder_ == null) {
        return fields_.size();
      } else {
        return fieldsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference getFields(
        int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public Builder setFields(
        int index,
        com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.set(index, value);
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public Builder setFields(
        int index,
        com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder
            builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.set(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public Builder addFields(
        com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public Builder addFields(
        int index,
        com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(index, value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public Builder addFields(
        com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder
            builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public Builder addFields(
        int index,
        com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder
            builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public Builder addAllFields(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference>
            values) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
        onChanged();
      } else {
        fieldsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public Builder clearFields() {
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        fieldsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public Builder removeFields(int index) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.remove(index);
        onChanged();
      } else {
        fieldsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder
        getFieldsBuilder(int index) {
      return getFieldsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReferenceOrBuilder
        getFieldsOrBuilder(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.optimization.v1.OptimizeToursValidationError
                    .FieldReferenceOrBuilder>
        getFieldsOrBuilderList() {
      if (fieldsBuilder_ != null) {
        return fieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fields_);
      }
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder
        addFieldsBuilder() {
      return getFieldsFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder
        addFieldsBuilder(int index) {
      return getFieldsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An error context may involve 0, 1 (most of the time) or more fields. For
     * example, referring to vehicle #4 and shipment #2's first pickup can be
     * done as follows:
     * ```
     * fields { name: "vehicles" index: 4}
     * fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
     * ```
     * Note, however, that the cardinality of `fields` should not change for a
     * given error code.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference fields = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder>
        getFieldsBuilderList() {
      return getFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference,
            com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.Builder,
            com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReferenceOrBuilder>
        getFieldsFieldBuilder() {
      if (fieldsBuilder_ == null) {
        fieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference,
                com.google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
                    .Builder,
                com.google.cloud.optimization.v1.OptimizeToursValidationError
                    .FieldReferenceOrBuilder>(
                fields_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        fields_ = null;
      }
      return fieldsBuilder_;
    }

    private java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * Human-readable string describing the error. There is a 1:1 mapping
     * between `code` and `error_message` (when code != "UNSPECIFIED").
     * *STABILITY*: Not stable: the error message associated to a given `code` may
     * change (hopefully to clarify it) over time. Please rely on the
     * `display_name` and `code` instead.
     * </pre>
     *
     * <code>string error_message = 4;</code>
     *
     * @return The errorMessage.
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human-readable string describing the error. There is a 1:1 mapping
     * between `code` and `error_message` (when code != "UNSPECIFIED").
     * *STABILITY*: Not stable: the error message associated to a given `code` may
     * change (hopefully to clarify it) over time. Please rely on the
     * `display_name` and `code` instead.
     * </pre>
     *
     * <code>string error_message = 4;</code>
     *
     * @return The bytes for errorMessage.
     */
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human-readable string describing the error. There is a 1:1 mapping
     * between `code` and `error_message` (when code != "UNSPECIFIED").
     * *STABILITY*: Not stable: the error message associated to a given `code` may
     * change (hopefully to clarify it) over time. Please rely on the
     * `display_name` and `code` instead.
     * </pre>
     *
     * <code>string error_message = 4;</code>
     *
     * @param value The errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      errorMessage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human-readable string describing the error. There is a 1:1 mapping
     * between `code` and `error_message` (when code != "UNSPECIFIED").
     * *STABILITY*: Not stable: the error message associated to a given `code` may
     * change (hopefully to clarify it) over time. Please rely on the
     * `display_name` and `code` instead.
     * </pre>
     *
     * <code>string error_message = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorMessage() {

      errorMessage_ = getDefaultInstance().getErrorMessage();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human-readable string describing the error. There is a 1:1 mapping
     * between `code` and `error_message` (when code != "UNSPECIFIED").
     * *STABILITY*: Not stable: the error message associated to a given `code` may
     * change (hopefully to clarify it) over time. Please rely on the
     * `display_name` and `code` instead.
     * </pre>
     *
     * <code>string error_message = 4;</code>
     *
     * @param value The bytes for errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      errorMessage_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object offendingValues_ = "";
    /**
     *
     *
     * <pre>
     * May contain the value(s) of the field(s). This is not always available. You
     * should absolutely not rely on it and use it only for manual model
     * debugging.
     * </pre>
     *
     * <code>string offending_values = 5;</code>
     *
     * @return The offendingValues.
     */
    public java.lang.String getOffendingValues() {
      java.lang.Object ref = offendingValues_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        offendingValues_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * May contain the value(s) of the field(s). This is not always available. You
     * should absolutely not rely on it and use it only for manual model
     * debugging.
     * </pre>
     *
     * <code>string offending_values = 5;</code>
     *
     * @return The bytes for offendingValues.
     */
    public com.google.protobuf.ByteString getOffendingValuesBytes() {
      java.lang.Object ref = offendingValues_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        offendingValues_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * May contain the value(s) of the field(s). This is not always available. You
     * should absolutely not rely on it and use it only for manual model
     * debugging.
     * </pre>
     *
     * <code>string offending_values = 5;</code>
     *
     * @param value The offendingValues to set.
     * @return This builder for chaining.
     */
    public Builder setOffendingValues(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      offendingValues_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * May contain the value(s) of the field(s). This is not always available. You
     * should absolutely not rely on it and use it only for manual model
     * debugging.
     * </pre>
     *
     * <code>string offending_values = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOffendingValues() {

      offendingValues_ = getDefaultInstance().getOffendingValues();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * May contain the value(s) of the field(s). This is not always available. You
     * should absolutely not rely on it and use it only for manual model
     * debugging.
     * </pre>
     *
     * <code>string offending_values = 5;</code>
     *
     * @param value The bytes for offendingValues to set.
     * @return This builder for chaining.
     */
    public Builder setOffendingValuesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      offendingValues_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.OptimizeToursValidationError)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.OptimizeToursValidationError)
  private static final com.google.cloud.optimization.v1.OptimizeToursValidationError
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.OptimizeToursValidationError();
  }

  public static com.google.cloud.optimization.v1.OptimizeToursValidationError getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OptimizeToursValidationError> PARSER =
      new com.google.protobuf.AbstractParser<OptimizeToursValidationError>() {
        @java.lang.Override
        public OptimizeToursValidationError parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OptimizeToursValidationError> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OptimizeToursValidationError> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.OptimizeToursValidationError getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
