/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Response after solving a tour optimization problem containing the routes
 * followed by each vehicle, the shipments which have been skipped and the
 * overall cost of the solution.
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.OptimizeToursResponse}
 */
public final class OptimizeToursResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.OptimizeToursResponse)
    OptimizeToursResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OptimizeToursResponse.newBuilder() to construct.
  private OptimizeToursResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OptimizeToursResponse() {
    routes_ = java.util.Collections.emptyList();
    requestLabel_ = "";
    skippedShipments_ = java.util.Collections.emptyList();
    validationErrors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OptimizeToursResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_OptimizeToursResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_OptimizeToursResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.OptimizeToursResponse.class,
            com.google.cloud.optimization.v1.OptimizeToursResponse.Builder.class);
  }

  public interface MetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.OptimizeToursResponse.Metrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Aggregated over the routes. Each metric is the sum (or max, for loads)
     * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
     *
     * @return Whether the aggregatedRouteMetrics field is set.
     */
    boolean hasAggregatedRouteMetrics();
    /**
     *
     *
     * <pre>
     * Aggregated over the routes. Each metric is the sum (or max, for loads)
     * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
     *
     * @return The aggregatedRouteMetrics.
     */
    com.google.cloud.optimization.v1.AggregatedMetrics getAggregatedRouteMetrics();
    /**
     *
     *
     * <pre>
     * Aggregated over the routes. Each metric is the sum (or max, for loads)
     * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
     */
    com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder
        getAggregatedRouteMetricsOrBuilder();

    /**
     *
     *
     * <pre>
     * Number of mandatory shipments skipped.
     * </pre>
     *
     * <code>int32 skipped_mandatory_shipment_count = 2;</code>
     *
     * @return The skippedMandatoryShipmentCount.
     */
    int getSkippedMandatoryShipmentCount();

    /**
     *
     *
     * <pre>
     * Number of vehicles used. Note: if a vehicle route is empty and
     * [Vehicle.used_if_route_is_empty][google.cloud.optimization.v1.Vehicle.used_if_route_is_empty] is true, the vehicle is considered
     * used.
     * </pre>
     *
     * <code>int32 used_vehicle_count = 3;</code>
     *
     * @return The usedVehicleCount.
     */
    int getUsedVehicleCount();

    /**
     *
     *
     * <pre>
     * The earliest start time for a used vehicle, computed as the minimum over
     * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
     *
     * @return Whether the earliestVehicleStartTime field is set.
     */
    boolean hasEarliestVehicleStartTime();
    /**
     *
     *
     * <pre>
     * The earliest start time for a used vehicle, computed as the minimum over
     * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
     *
     * @return The earliestVehicleStartTime.
     */
    com.google.protobuf.Timestamp getEarliestVehicleStartTime();
    /**
     *
     *
     * <pre>
     * The earliest start time for a used vehicle, computed as the minimum over
     * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEarliestVehicleStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The latest end time for a used vehicle, computed as the maximum over all
     * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
     *
     * @return Whether the latestVehicleEndTime field is set.
     */
    boolean hasLatestVehicleEndTime();
    /**
     *
     *
     * <pre>
     * The latest end time for a used vehicle, computed as the maximum over all
     * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
     *
     * @return The latestVehicleEndTime.
     */
    com.google.protobuf.Timestamp getLatestVehicleEndTime();
    /**
     *
     *
     * <pre>
     * The latest end time for a used vehicle, computed as the maximum over all
     * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
     */
    com.google.protobuf.TimestampOrBuilder getLatestVehicleEndTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Cost of the solution, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest,
     * e.g. "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole
     * solution. In other words, costs["model.shipments.pickups.cost"] is the
     * sum of all pickup costs over the solution. All costs defined in the model
     * are reported in detail here with the exception of costs related to
     * TransitionAttributes that are only reported in an aggregated way as of
     * 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10;</code>
     */
    int getCostsCount();
    /**
     *
     *
     * <pre>
     * Cost of the solution, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest,
     * e.g. "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole
     * solution. In other words, costs["model.shipments.pickups.cost"] is the
     * sum of all pickup costs over the solution. All costs defined in the model
     * are reported in detail here with the exception of costs related to
     * TransitionAttributes that are only reported in an aggregated way as of
     * 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10;</code>
     */
    boolean containsCosts(java.lang.String key);
    /** Use {@link #getCostsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.Double> getCosts();
    /**
     *
     *
     * <pre>
     * Cost of the solution, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest,
     * e.g. "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole
     * solution. In other words, costs["model.shipments.pickups.cost"] is the
     * sum of all pickup costs over the solution. All costs defined in the model
     * are reported in detail here with the exception of costs related to
     * TransitionAttributes that are only reported in an aggregated way as of
     * 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10;</code>
     */
    java.util.Map<java.lang.String, java.lang.Double> getCostsMap();
    /**
     *
     *
     * <pre>
     * Cost of the solution, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest,
     * e.g. "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole
     * solution. In other words, costs["model.shipments.pickups.cost"] is the
     * sum of all pickup costs over the solution. All costs defined in the model
     * are reported in detail here with the exception of costs related to
     * TransitionAttributes that are only reported in an aggregated way as of
     * 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10;</code>
     */
    double getCostsOrDefault(java.lang.String key, double defaultValue);
    /**
     *
     *
     * <pre>
     * Cost of the solution, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest,
     * e.g. "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole
     * solution. In other words, costs["model.shipments.pickups.cost"] is the
     * sum of all pickup costs over the solution. All costs defined in the model
     * are reported in detail here with the exception of costs related to
     * TransitionAttributes that are only reported in an aggregated way as of
     * 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10;</code>
     */
    double getCostsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Total cost of the solution. The sum of all values in the costs map.
     * </pre>
     *
     * <code>double total_cost = 6;</code>
     *
     * @return The totalCost.
     */
    double getTotalCost();
  }
  /**
   *
   *
   * <pre>
   * Overall metrics, aggregated over all routes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.OptimizeToursResponse.Metrics}
   */
  public static final class Metrics extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.OptimizeToursResponse.Metrics)
      MetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Metrics.newBuilder() to construct.
    private Metrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Metrics() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Metrics();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursResponse_Metrics_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 10:
          return internalGetCosts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursResponse_Metrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.class,
              com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.Builder.class);
    }

    public static final int AGGREGATED_ROUTE_METRICS_FIELD_NUMBER = 1;
    private com.google.cloud.optimization.v1.AggregatedMetrics aggregatedRouteMetrics_;
    /**
     *
     *
     * <pre>
     * Aggregated over the routes. Each metric is the sum (or max, for loads)
     * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
     *
     * @return Whether the aggregatedRouteMetrics field is set.
     */
    @java.lang.Override
    public boolean hasAggregatedRouteMetrics() {
      return aggregatedRouteMetrics_ != null;
    }
    /**
     *
     *
     * <pre>
     * Aggregated over the routes. Each metric is the sum (or max, for loads)
     * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
     *
     * @return The aggregatedRouteMetrics.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.AggregatedMetrics getAggregatedRouteMetrics() {
      return aggregatedRouteMetrics_ == null
          ? com.google.cloud.optimization.v1.AggregatedMetrics.getDefaultInstance()
          : aggregatedRouteMetrics_;
    }
    /**
     *
     *
     * <pre>
     * Aggregated over the routes. Each metric is the sum (or max, for loads)
     * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder
        getAggregatedRouteMetricsOrBuilder() {
      return getAggregatedRouteMetrics();
    }

    public static final int SKIPPED_MANDATORY_SHIPMENT_COUNT_FIELD_NUMBER = 2;
    private int skippedMandatoryShipmentCount_;
    /**
     *
     *
     * <pre>
     * Number of mandatory shipments skipped.
     * </pre>
     *
     * <code>int32 skipped_mandatory_shipment_count = 2;</code>
     *
     * @return The skippedMandatoryShipmentCount.
     */
    @java.lang.Override
    public int getSkippedMandatoryShipmentCount() {
      return skippedMandatoryShipmentCount_;
    }

    public static final int USED_VEHICLE_COUNT_FIELD_NUMBER = 3;
    private int usedVehicleCount_;
    /**
     *
     *
     * <pre>
     * Number of vehicles used. Note: if a vehicle route is empty and
     * [Vehicle.used_if_route_is_empty][google.cloud.optimization.v1.Vehicle.used_if_route_is_empty] is true, the vehicle is considered
     * used.
     * </pre>
     *
     * <code>int32 used_vehicle_count = 3;</code>
     *
     * @return The usedVehicleCount.
     */
    @java.lang.Override
    public int getUsedVehicleCount() {
      return usedVehicleCount_;
    }

    public static final int EARLIEST_VEHICLE_START_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp earliestVehicleStartTime_;
    /**
     *
     *
     * <pre>
     * The earliest start time for a used vehicle, computed as the minimum over
     * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
     *
     * @return Whether the earliestVehicleStartTime field is set.
     */
    @java.lang.Override
    public boolean hasEarliestVehicleStartTime() {
      return earliestVehicleStartTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The earliest start time for a used vehicle, computed as the minimum over
     * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
     *
     * @return The earliestVehicleStartTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEarliestVehicleStartTime() {
      return earliestVehicleStartTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : earliestVehicleStartTime_;
    }
    /**
     *
     *
     * <pre>
     * The earliest start time for a used vehicle, computed as the minimum over
     * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEarliestVehicleStartTimeOrBuilder() {
      return getEarliestVehicleStartTime();
    }

    public static final int LATEST_VEHICLE_END_TIME_FIELD_NUMBER = 5;
    private com.google.protobuf.Timestamp latestVehicleEndTime_;
    /**
     *
     *
     * <pre>
     * The latest end time for a used vehicle, computed as the maximum over all
     * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
     *
     * @return Whether the latestVehicleEndTime field is set.
     */
    @java.lang.Override
    public boolean hasLatestVehicleEndTime() {
      return latestVehicleEndTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The latest end time for a used vehicle, computed as the maximum over all
     * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
     *
     * @return The latestVehicleEndTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getLatestVehicleEndTime() {
      return latestVehicleEndTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : latestVehicleEndTime_;
    }
    /**
     *
     *
     * <pre>
     * The latest end time for a used vehicle, computed as the maximum over all
     * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
     * </pre>
     *
     * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getLatestVehicleEndTimeOrBuilder() {
      return getLatestVehicleEndTime();
    }

    public static final int COSTS_FIELD_NUMBER = 10;

    private static final class CostsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.Double>newDefaultInstance(
              com.google.cloud.optimization.v1.FleetRoutingProto
                  .internal_static_google_cloud_optimization_v1_OptimizeToursResponse_Metrics_CostsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.DOUBLE,
              0D);
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double> costs_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double> internalGetCosts() {
      if (costs_ == null) {
        return com.google.protobuf.MapField.emptyMapField(CostsDefaultEntryHolder.defaultEntry);
      }
      return costs_;
    }

    public int getCostsCount() {
      return internalGetCosts().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Cost of the solution, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest,
     * e.g. "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole
     * solution. In other words, costs["model.shipments.pickups.cost"] is the
     * sum of all pickup costs over the solution. All costs defined in the model
     * are reported in detail here with the exception of costs related to
     * TransitionAttributes that are only reported in an aggregated way as of
     * 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10;</code>
     */
    @java.lang.Override
    public boolean containsCosts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetCosts().getMap().containsKey(key);
    }
    /** Use {@link #getCostsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Double> getCosts() {
      return getCostsMap();
    }
    /**
     *
     *
     * <pre>
     * Cost of the solution, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest,
     * e.g. "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole
     * solution. In other words, costs["model.shipments.pickups.cost"] is the
     * sum of all pickup costs over the solution. All costs defined in the model
     * are reported in detail here with the exception of costs related to
     * TransitionAttributes that are only reported in an aggregated way as of
     * 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Double> getCostsMap() {
      return internalGetCosts().getMap();
    }
    /**
     *
     *
     * <pre>
     * Cost of the solution, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest,
     * e.g. "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole
     * solution. In other words, costs["model.shipments.pickups.cost"] is the
     * sum of all pickup costs over the solution. All costs defined in the model
     * are reported in detail here with the exception of costs related to
     * TransitionAttributes that are only reported in an aggregated way as of
     * 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10;</code>
     */
    @java.lang.Override
    public double getCostsOrDefault(java.lang.String key, double defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetCosts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Cost of the solution, broken down by cost-related request fields.
     * The keys are proto paths, relative to the input OptimizeToursRequest,
     * e.g. "model.shipments.pickups.cost", and the values are the total cost
     * generated by the corresponding cost field, aggregated over the whole
     * solution. In other words, costs["model.shipments.pickups.cost"] is the
     * sum of all pickup costs over the solution. All costs defined in the model
     * are reported in detail here with the exception of costs related to
     * TransitionAttributes that are only reported in an aggregated way as of
     * 2022/01.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10;</code>
     */
    @java.lang.Override
    public double getCostsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetCosts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int TOTAL_COST_FIELD_NUMBER = 6;
    private double totalCost_;
    /**
     *
     *
     * <pre>
     * Total cost of the solution. The sum of all values in the costs map.
     * </pre>
     *
     * <code>double total_cost = 6;</code>
     *
     * @return The totalCost.
     */
    @java.lang.Override
    public double getTotalCost() {
      return totalCost_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (aggregatedRouteMetrics_ != null) {
        output.writeMessage(1, getAggregatedRouteMetrics());
      }
      if (skippedMandatoryShipmentCount_ != 0) {
        output.writeInt32(2, skippedMandatoryShipmentCount_);
      }
      if (usedVehicleCount_ != 0) {
        output.writeInt32(3, usedVehicleCount_);
      }
      if (earliestVehicleStartTime_ != null) {
        output.writeMessage(4, getEarliestVehicleStartTime());
      }
      if (latestVehicleEndTime_ != null) {
        output.writeMessage(5, getLatestVehicleEndTime());
      }
      if (java.lang.Double.doubleToRawLongBits(totalCost_) != 0) {
        output.writeDouble(6, totalCost_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetCosts(), CostsDefaultEntryHolder.defaultEntry, 10);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (aggregatedRouteMetrics_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, getAggregatedRouteMetrics());
      }
      if (skippedMandatoryShipmentCount_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                2, skippedMandatoryShipmentCount_);
      }
      if (usedVehicleCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, usedVehicleCount_);
      }
      if (earliestVehicleStartTime_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getEarliestVehicleStartTime());
      }
      if (latestVehicleEndTime_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(5, getLatestVehicleEndTime());
      }
      if (java.lang.Double.doubleToRawLongBits(totalCost_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(6, totalCost_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.Double> entry :
          internalGetCosts().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> costs__ =
            CostsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, costs__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics other =
          (com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics) obj;

      if (hasAggregatedRouteMetrics() != other.hasAggregatedRouteMetrics()) return false;
      if (hasAggregatedRouteMetrics()) {
        if (!getAggregatedRouteMetrics().equals(other.getAggregatedRouteMetrics())) return false;
      }
      if (getSkippedMandatoryShipmentCount() != other.getSkippedMandatoryShipmentCount())
        return false;
      if (getUsedVehicleCount() != other.getUsedVehicleCount()) return false;
      if (hasEarliestVehicleStartTime() != other.hasEarliestVehicleStartTime()) return false;
      if (hasEarliestVehicleStartTime()) {
        if (!getEarliestVehicleStartTime().equals(other.getEarliestVehicleStartTime()))
          return false;
      }
      if (hasLatestVehicleEndTime() != other.hasLatestVehicleEndTime()) return false;
      if (hasLatestVehicleEndTime()) {
        if (!getLatestVehicleEndTime().equals(other.getLatestVehicleEndTime())) return false;
      }
      if (!internalGetCosts().equals(other.internalGetCosts())) return false;
      if (java.lang.Double.doubleToLongBits(getTotalCost())
          != java.lang.Double.doubleToLongBits(other.getTotalCost())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAggregatedRouteMetrics()) {
        hash = (37 * hash) + AGGREGATED_ROUTE_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getAggregatedRouteMetrics().hashCode();
      }
      hash = (37 * hash) + SKIPPED_MANDATORY_SHIPMENT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getSkippedMandatoryShipmentCount();
      hash = (37 * hash) + USED_VEHICLE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getUsedVehicleCount();
      if (hasEarliestVehicleStartTime()) {
        hash = (37 * hash) + EARLIEST_VEHICLE_START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEarliestVehicleStartTime().hashCode();
      }
      if (hasLatestVehicleEndTime()) {
        hash = (37 * hash) + LATEST_VEHICLE_END_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getLatestVehicleEndTime().hashCode();
      }
      if (!internalGetCosts().getMap().isEmpty()) {
        hash = (37 * hash) + COSTS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetCosts().hashCode();
      }
      hash = (37 * hash) + TOTAL_COST_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getTotalCost()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Overall metrics, aggregated over all routes.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.OptimizeToursResponse.Metrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.OptimizeToursResponse.Metrics)
        com.google.cloud.optimization.v1.OptimizeToursResponse.MetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_OptimizeToursResponse_Metrics_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 10:
            return internalGetCosts();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 10:
            return internalGetMutableCosts();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_OptimizeToursResponse_Metrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.class,
                com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (aggregatedRouteMetricsBuilder_ == null) {
          aggregatedRouteMetrics_ = null;
        } else {
          aggregatedRouteMetrics_ = null;
          aggregatedRouteMetricsBuilder_ = null;
        }
        skippedMandatoryShipmentCount_ = 0;

        usedVehicleCount_ = 0;

        if (earliestVehicleStartTimeBuilder_ == null) {
          earliestVehicleStartTime_ = null;
        } else {
          earliestVehicleStartTime_ = null;
          earliestVehicleStartTimeBuilder_ = null;
        }
        if (latestVehicleEndTimeBuilder_ == null) {
          latestVehicleEndTime_ = null;
        } else {
          latestVehicleEndTime_ = null;
          latestVehicleEndTimeBuilder_ = null;
        }
        internalGetMutableCosts().clear();
        totalCost_ = 0D;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_OptimizeToursResponse_Metrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics
          getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics build() {
        com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics buildPartial() {
        com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics result =
            new com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics(this);
        int from_bitField0_ = bitField0_;
        if (aggregatedRouteMetricsBuilder_ == null) {
          result.aggregatedRouteMetrics_ = aggregatedRouteMetrics_;
        } else {
          result.aggregatedRouteMetrics_ = aggregatedRouteMetricsBuilder_.build();
        }
        result.skippedMandatoryShipmentCount_ = skippedMandatoryShipmentCount_;
        result.usedVehicleCount_ = usedVehicleCount_;
        if (earliestVehicleStartTimeBuilder_ == null) {
          result.earliestVehicleStartTime_ = earliestVehicleStartTime_;
        } else {
          result.earliestVehicleStartTime_ = earliestVehicleStartTimeBuilder_.build();
        }
        if (latestVehicleEndTimeBuilder_ == null) {
          result.latestVehicleEndTime_ = latestVehicleEndTime_;
        } else {
          result.latestVehicleEndTime_ = latestVehicleEndTimeBuilder_.build();
        }
        result.costs_ = internalGetCosts();
        result.costs_.makeImmutable();
        result.totalCost_ = totalCost_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics) {
          return mergeFrom((com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics other) {
        if (other
            == com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.getDefaultInstance())
          return this;
        if (other.hasAggregatedRouteMetrics()) {
          mergeAggregatedRouteMetrics(other.getAggregatedRouteMetrics());
        }
        if (other.getSkippedMandatoryShipmentCount() != 0) {
          setSkippedMandatoryShipmentCount(other.getSkippedMandatoryShipmentCount());
        }
        if (other.getUsedVehicleCount() != 0) {
          setUsedVehicleCount(other.getUsedVehicleCount());
        }
        if (other.hasEarliestVehicleStartTime()) {
          mergeEarliestVehicleStartTime(other.getEarliestVehicleStartTime());
        }
        if (other.hasLatestVehicleEndTime()) {
          mergeLatestVehicleEndTime(other.getLatestVehicleEndTime());
        }
        internalGetMutableCosts().mergeFrom(other.internalGetCosts());
        if (other.getTotalCost() != 0D) {
          setTotalCost(other.getTotalCost());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getAggregatedRouteMetricsFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 16:
                {
                  skippedMandatoryShipmentCount_ = input.readInt32();

                  break;
                } // case 16
              case 24:
                {
                  usedVehicleCount_ = input.readInt32();

                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(
                      getEarliestVehicleStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getLatestVehicleEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 42
              case 49:
                {
                  totalCost_ = input.readDouble();

                  break;
                } // case 49
              case 82:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> costs__ =
                      input.readMessage(
                          CostsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableCosts()
                      .getMutableMap()
                      .put(costs__.getKey(), costs__.getValue());
                  break;
                } // case 82
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.optimization.v1.AggregatedMetrics aggregatedRouteMetrics_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.AggregatedMetrics,
              com.google.cloud.optimization.v1.AggregatedMetrics.Builder,
              com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder>
          aggregatedRouteMetricsBuilder_;
      /**
       *
       *
       * <pre>
       * Aggregated over the routes. Each metric is the sum (or max, for loads)
       * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
       *
       * @return Whether the aggregatedRouteMetrics field is set.
       */
      public boolean hasAggregatedRouteMetrics() {
        return aggregatedRouteMetricsBuilder_ != null || aggregatedRouteMetrics_ != null;
      }
      /**
       *
       *
       * <pre>
       * Aggregated over the routes. Each metric is the sum (or max, for loads)
       * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
       *
       * @return The aggregatedRouteMetrics.
       */
      public com.google.cloud.optimization.v1.AggregatedMetrics getAggregatedRouteMetrics() {
        if (aggregatedRouteMetricsBuilder_ == null) {
          return aggregatedRouteMetrics_ == null
              ? com.google.cloud.optimization.v1.AggregatedMetrics.getDefaultInstance()
              : aggregatedRouteMetrics_;
        } else {
          return aggregatedRouteMetricsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Aggregated over the routes. Each metric is the sum (or max, for loads)
       * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
       */
      public Builder setAggregatedRouteMetrics(
          com.google.cloud.optimization.v1.AggregatedMetrics value) {
        if (aggregatedRouteMetricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          aggregatedRouteMetrics_ = value;
          onChanged();
        } else {
          aggregatedRouteMetricsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Aggregated over the routes. Each metric is the sum (or max, for loads)
       * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
       */
      public Builder setAggregatedRouteMetrics(
          com.google.cloud.optimization.v1.AggregatedMetrics.Builder builderForValue) {
        if (aggregatedRouteMetricsBuilder_ == null) {
          aggregatedRouteMetrics_ = builderForValue.build();
          onChanged();
        } else {
          aggregatedRouteMetricsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Aggregated over the routes. Each metric is the sum (or max, for loads)
       * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
       */
      public Builder mergeAggregatedRouteMetrics(
          com.google.cloud.optimization.v1.AggregatedMetrics value) {
        if (aggregatedRouteMetricsBuilder_ == null) {
          if (aggregatedRouteMetrics_ != null) {
            aggregatedRouteMetrics_ =
                com.google.cloud.optimization.v1.AggregatedMetrics.newBuilder(
                        aggregatedRouteMetrics_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            aggregatedRouteMetrics_ = value;
          }
          onChanged();
        } else {
          aggregatedRouteMetricsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Aggregated over the routes. Each metric is the sum (or max, for loads)
       * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
       */
      public Builder clearAggregatedRouteMetrics() {
        if (aggregatedRouteMetricsBuilder_ == null) {
          aggregatedRouteMetrics_ = null;
          onChanged();
        } else {
          aggregatedRouteMetrics_ = null;
          aggregatedRouteMetricsBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Aggregated over the routes. Each metric is the sum (or max, for loads)
       * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
       */
      public com.google.cloud.optimization.v1.AggregatedMetrics.Builder
          getAggregatedRouteMetricsBuilder() {

        onChanged();
        return getAggregatedRouteMetricsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Aggregated over the routes. Each metric is the sum (or max, for loads)
       * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
       */
      public com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder
          getAggregatedRouteMetricsOrBuilder() {
        if (aggregatedRouteMetricsBuilder_ != null) {
          return aggregatedRouteMetricsBuilder_.getMessageOrBuilder();
        } else {
          return aggregatedRouteMetrics_ == null
              ? com.google.cloud.optimization.v1.AggregatedMetrics.getDefaultInstance()
              : aggregatedRouteMetrics_;
        }
      }
      /**
       *
       *
       * <pre>
       * Aggregated over the routes. Each metric is the sum (or max, for loads)
       * over all [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics] fields of the same name.
       * </pre>
       *
       * <code>.google.cloud.optimization.v1.AggregatedMetrics aggregated_route_metrics = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.AggregatedMetrics,
              com.google.cloud.optimization.v1.AggregatedMetrics.Builder,
              com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder>
          getAggregatedRouteMetricsFieldBuilder() {
        if (aggregatedRouteMetricsBuilder_ == null) {
          aggregatedRouteMetricsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.optimization.v1.AggregatedMetrics,
                  com.google.cloud.optimization.v1.AggregatedMetrics.Builder,
                  com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder>(
                  getAggregatedRouteMetrics(), getParentForChildren(), isClean());
          aggregatedRouteMetrics_ = null;
        }
        return aggregatedRouteMetricsBuilder_;
      }

      private int skippedMandatoryShipmentCount_;
      /**
       *
       *
       * <pre>
       * Number of mandatory shipments skipped.
       * </pre>
       *
       * <code>int32 skipped_mandatory_shipment_count = 2;</code>
       *
       * @return The skippedMandatoryShipmentCount.
       */
      @java.lang.Override
      public int getSkippedMandatoryShipmentCount() {
        return skippedMandatoryShipmentCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of mandatory shipments skipped.
       * </pre>
       *
       * <code>int32 skipped_mandatory_shipment_count = 2;</code>
       *
       * @param value The skippedMandatoryShipmentCount to set.
       * @return This builder for chaining.
       */
      public Builder setSkippedMandatoryShipmentCount(int value) {

        skippedMandatoryShipmentCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of mandatory shipments skipped.
       * </pre>
       *
       * <code>int32 skipped_mandatory_shipment_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSkippedMandatoryShipmentCount() {

        skippedMandatoryShipmentCount_ = 0;
        onChanged();
        return this;
      }

      private int usedVehicleCount_;
      /**
       *
       *
       * <pre>
       * Number of vehicles used. Note: if a vehicle route is empty and
       * [Vehicle.used_if_route_is_empty][google.cloud.optimization.v1.Vehicle.used_if_route_is_empty] is true, the vehicle is considered
       * used.
       * </pre>
       *
       * <code>int32 used_vehicle_count = 3;</code>
       *
       * @return The usedVehicleCount.
       */
      @java.lang.Override
      public int getUsedVehicleCount() {
        return usedVehicleCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of vehicles used. Note: if a vehicle route is empty and
       * [Vehicle.used_if_route_is_empty][google.cloud.optimization.v1.Vehicle.used_if_route_is_empty] is true, the vehicle is considered
       * used.
       * </pre>
       *
       * <code>int32 used_vehicle_count = 3;</code>
       *
       * @param value The usedVehicleCount to set.
       * @return This builder for chaining.
       */
      public Builder setUsedVehicleCount(int value) {

        usedVehicleCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of vehicles used. Note: if a vehicle route is empty and
       * [Vehicle.used_if_route_is_empty][google.cloud.optimization.v1.Vehicle.used_if_route_is_empty] is true, the vehicle is considered
       * used.
       * </pre>
       *
       * <code>int32 used_vehicle_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUsedVehicleCount() {

        usedVehicleCount_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp earliestVehicleStartTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          earliestVehicleStartTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The earliest start time for a used vehicle, computed as the minimum over
       * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
       *
       * @return Whether the earliestVehicleStartTime field is set.
       */
      public boolean hasEarliestVehicleStartTime() {
        return earliestVehicleStartTimeBuilder_ != null || earliestVehicleStartTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * The earliest start time for a used vehicle, computed as the minimum over
       * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
       *
       * @return The earliestVehicleStartTime.
       */
      public com.google.protobuf.Timestamp getEarliestVehicleStartTime() {
        if (earliestVehicleStartTimeBuilder_ == null) {
          return earliestVehicleStartTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : earliestVehicleStartTime_;
        } else {
          return earliestVehicleStartTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The earliest start time for a used vehicle, computed as the minimum over
       * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
       */
      public Builder setEarliestVehicleStartTime(com.google.protobuf.Timestamp value) {
        if (earliestVehicleStartTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          earliestVehicleStartTime_ = value;
          onChanged();
        } else {
          earliestVehicleStartTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The earliest start time for a used vehicle, computed as the minimum over
       * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
       */
      public Builder setEarliestVehicleStartTime(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (earliestVehicleStartTimeBuilder_ == null) {
          earliestVehicleStartTime_ = builderForValue.build();
          onChanged();
        } else {
          earliestVehicleStartTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The earliest start time for a used vehicle, computed as the minimum over
       * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
       */
      public Builder mergeEarliestVehicleStartTime(com.google.protobuf.Timestamp value) {
        if (earliestVehicleStartTimeBuilder_ == null) {
          if (earliestVehicleStartTime_ != null) {
            earliestVehicleStartTime_ =
                com.google.protobuf.Timestamp.newBuilder(earliestVehicleStartTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            earliestVehicleStartTime_ = value;
          }
          onChanged();
        } else {
          earliestVehicleStartTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The earliest start time for a used vehicle, computed as the minimum over
       * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
       */
      public Builder clearEarliestVehicleStartTime() {
        if (earliestVehicleStartTimeBuilder_ == null) {
          earliestVehicleStartTime_ = null;
          onChanged();
        } else {
          earliestVehicleStartTime_ = null;
          earliestVehicleStartTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The earliest start time for a used vehicle, computed as the minimum over
       * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEarliestVehicleStartTimeBuilder() {

        onChanged();
        return getEarliestVehicleStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The earliest start time for a used vehicle, computed as the minimum over
       * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEarliestVehicleStartTimeOrBuilder() {
        if (earliestVehicleStartTimeBuilder_ != null) {
          return earliestVehicleStartTimeBuilder_.getMessageOrBuilder();
        } else {
          return earliestVehicleStartTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : earliestVehicleStartTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The earliest start time for a used vehicle, computed as the minimum over
       * all used vehicles of [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp earliest_vehicle_start_time = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEarliestVehicleStartTimeFieldBuilder() {
        if (earliestVehicleStartTimeBuilder_ == null) {
          earliestVehicleStartTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEarliestVehicleStartTime(), getParentForChildren(), isClean());
          earliestVehicleStartTime_ = null;
        }
        return earliestVehicleStartTimeBuilder_;
      }

      private com.google.protobuf.Timestamp latestVehicleEndTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          latestVehicleEndTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The latest end time for a used vehicle, computed as the maximum over all
       * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
       *
       * @return Whether the latestVehicleEndTime field is set.
       */
      public boolean hasLatestVehicleEndTime() {
        return latestVehicleEndTimeBuilder_ != null || latestVehicleEndTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * The latest end time for a used vehicle, computed as the maximum over all
       * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
       *
       * @return The latestVehicleEndTime.
       */
      public com.google.protobuf.Timestamp getLatestVehicleEndTime() {
        if (latestVehicleEndTimeBuilder_ == null) {
          return latestVehicleEndTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : latestVehicleEndTime_;
        } else {
          return latestVehicleEndTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The latest end time for a used vehicle, computed as the maximum over all
       * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
       */
      public Builder setLatestVehicleEndTime(com.google.protobuf.Timestamp value) {
        if (latestVehicleEndTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          latestVehicleEndTime_ = value;
          onChanged();
        } else {
          latestVehicleEndTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The latest end time for a used vehicle, computed as the maximum over all
       * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
       */
      public Builder setLatestVehicleEndTime(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (latestVehicleEndTimeBuilder_ == null) {
          latestVehicleEndTime_ = builderForValue.build();
          onChanged();
        } else {
          latestVehicleEndTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The latest end time for a used vehicle, computed as the maximum over all
       * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
       */
      public Builder mergeLatestVehicleEndTime(com.google.protobuf.Timestamp value) {
        if (latestVehicleEndTimeBuilder_ == null) {
          if (latestVehicleEndTime_ != null) {
            latestVehicleEndTime_ =
                com.google.protobuf.Timestamp.newBuilder(latestVehicleEndTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            latestVehicleEndTime_ = value;
          }
          onChanged();
        } else {
          latestVehicleEndTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The latest end time for a used vehicle, computed as the maximum over all
       * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
       */
      public Builder clearLatestVehicleEndTime() {
        if (latestVehicleEndTimeBuilder_ == null) {
          latestVehicleEndTime_ = null;
          onChanged();
        } else {
          latestVehicleEndTime_ = null;
          latestVehicleEndTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The latest end time for a used vehicle, computed as the maximum over all
       * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
       */
      public com.google.protobuf.Timestamp.Builder getLatestVehicleEndTimeBuilder() {

        onChanged();
        return getLatestVehicleEndTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The latest end time for a used vehicle, computed as the maximum over all
       * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getLatestVehicleEndTimeOrBuilder() {
        if (latestVehicleEndTimeBuilder_ != null) {
          return latestVehicleEndTimeBuilder_.getMessageOrBuilder();
        } else {
          return latestVehicleEndTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : latestVehicleEndTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The latest end time for a used vehicle, computed as the maximum over all
       * used vehicles of [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
       * </pre>
       *
       * <code>.google.protobuf.Timestamp latest_vehicle_end_time = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getLatestVehicleEndTimeFieldBuilder() {
        if (latestVehicleEndTimeBuilder_ == null) {
          latestVehicleEndTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getLatestVehicleEndTime(), getParentForChildren(), isClean());
          latestVehicleEndTime_ = null;
        }
        return latestVehicleEndTimeBuilder_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.Double> costs_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.Double> internalGetCosts() {
        if (costs_ == null) {
          return com.google.protobuf.MapField.emptyMapField(CostsDefaultEntryHolder.defaultEntry);
        }
        return costs_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.Double>
          internalGetMutableCosts() {
        onChanged();
        ;
        if (costs_ == null) {
          costs_ = com.google.protobuf.MapField.newMapField(CostsDefaultEntryHolder.defaultEntry);
        }
        if (!costs_.isMutable()) {
          costs_ = costs_.copy();
        }
        return costs_;
      }

      public int getCostsCount() {
        return internalGetCosts().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Cost of the solution, broken down by cost-related request fields.
       * The keys are proto paths, relative to the input OptimizeToursRequest,
       * e.g. "model.shipments.pickups.cost", and the values are the total cost
       * generated by the corresponding cost field, aggregated over the whole
       * solution. In other words, costs["model.shipments.pickups.cost"] is the
       * sum of all pickup costs over the solution. All costs defined in the model
       * are reported in detail here with the exception of costs related to
       * TransitionAttributes that are only reported in an aggregated way as of
       * 2022/01.
       * </pre>
       *
       * <code>map&lt;string, double&gt; costs = 10;</code>
       */
      @java.lang.Override
      public boolean containsCosts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetCosts().getMap().containsKey(key);
      }
      /** Use {@link #getCostsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.Double> getCosts() {
        return getCostsMap();
      }
      /**
       *
       *
       * <pre>
       * Cost of the solution, broken down by cost-related request fields.
       * The keys are proto paths, relative to the input OptimizeToursRequest,
       * e.g. "model.shipments.pickups.cost", and the values are the total cost
       * generated by the corresponding cost field, aggregated over the whole
       * solution. In other words, costs["model.shipments.pickups.cost"] is the
       * sum of all pickup costs over the solution. All costs defined in the model
       * are reported in detail here with the exception of costs related to
       * TransitionAttributes that are only reported in an aggregated way as of
       * 2022/01.
       * </pre>
       *
       * <code>map&lt;string, double&gt; costs = 10;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.Double> getCostsMap() {
        return internalGetCosts().getMap();
      }
      /**
       *
       *
       * <pre>
       * Cost of the solution, broken down by cost-related request fields.
       * The keys are proto paths, relative to the input OptimizeToursRequest,
       * e.g. "model.shipments.pickups.cost", and the values are the total cost
       * generated by the corresponding cost field, aggregated over the whole
       * solution. In other words, costs["model.shipments.pickups.cost"] is the
       * sum of all pickup costs over the solution. All costs defined in the model
       * are reported in detail here with the exception of costs related to
       * TransitionAttributes that are only reported in an aggregated way as of
       * 2022/01.
       * </pre>
       *
       * <code>map&lt;string, double&gt; costs = 10;</code>
       */
      @java.lang.Override
      public double getCostsOrDefault(java.lang.String key, double defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.Double> map = internalGetCosts().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Cost of the solution, broken down by cost-related request fields.
       * The keys are proto paths, relative to the input OptimizeToursRequest,
       * e.g. "model.shipments.pickups.cost", and the values are the total cost
       * generated by the corresponding cost field, aggregated over the whole
       * solution. In other words, costs["model.shipments.pickups.cost"] is the
       * sum of all pickup costs over the solution. All costs defined in the model
       * are reported in detail here with the exception of costs related to
       * TransitionAttributes that are only reported in an aggregated way as of
       * 2022/01.
       * </pre>
       *
       * <code>map&lt;string, double&gt; costs = 10;</code>
       */
      @java.lang.Override
      public double getCostsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.Double> map = internalGetCosts().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearCosts() {
        internalGetMutableCosts().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cost of the solution, broken down by cost-related request fields.
       * The keys are proto paths, relative to the input OptimizeToursRequest,
       * e.g. "model.shipments.pickups.cost", and the values are the total cost
       * generated by the corresponding cost field, aggregated over the whole
       * solution. In other words, costs["model.shipments.pickups.cost"] is the
       * sum of all pickup costs over the solution. All costs defined in the model
       * are reported in detail here with the exception of costs related to
       * TransitionAttributes that are only reported in an aggregated way as of
       * 2022/01.
       * </pre>
       *
       * <code>map&lt;string, double&gt; costs = 10;</code>
       */
      public Builder removeCosts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableCosts().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.Double> getMutableCosts() {
        return internalGetMutableCosts().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Cost of the solution, broken down by cost-related request fields.
       * The keys are proto paths, relative to the input OptimizeToursRequest,
       * e.g. "model.shipments.pickups.cost", and the values are the total cost
       * generated by the corresponding cost field, aggregated over the whole
       * solution. In other words, costs["model.shipments.pickups.cost"] is the
       * sum of all pickup costs over the solution. All costs defined in the model
       * are reported in detail here with the exception of costs related to
       * TransitionAttributes that are only reported in an aggregated way as of
       * 2022/01.
       * </pre>
       *
       * <code>map&lt;string, double&gt; costs = 10;</code>
       */
      public Builder putCosts(java.lang.String key, double value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }

        internalGetMutableCosts().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cost of the solution, broken down by cost-related request fields.
       * The keys are proto paths, relative to the input OptimizeToursRequest,
       * e.g. "model.shipments.pickups.cost", and the values are the total cost
       * generated by the corresponding cost field, aggregated over the whole
       * solution. In other words, costs["model.shipments.pickups.cost"] is the
       * sum of all pickup costs over the solution. All costs defined in the model
       * are reported in detail here with the exception of costs related to
       * TransitionAttributes that are only reported in an aggregated way as of
       * 2022/01.
       * </pre>
       *
       * <code>map&lt;string, double&gt; costs = 10;</code>
       */
      public Builder putAllCosts(java.util.Map<java.lang.String, java.lang.Double> values) {
        internalGetMutableCosts().getMutableMap().putAll(values);
        return this;
      }

      private double totalCost_;
      /**
       *
       *
       * <pre>
       * Total cost of the solution. The sum of all values in the costs map.
       * </pre>
       *
       * <code>double total_cost = 6;</code>
       *
       * @return The totalCost.
       */
      @java.lang.Override
      public double getTotalCost() {
        return totalCost_;
      }
      /**
       *
       *
       * <pre>
       * Total cost of the solution. The sum of all values in the costs map.
       * </pre>
       *
       * <code>double total_cost = 6;</code>
       *
       * @param value The totalCost to set.
       * @return This builder for chaining.
       */
      public Builder setTotalCost(double value) {

        totalCost_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total cost of the solution. The sum of all values in the costs map.
       * </pre>
       *
       * <code>double total_cost = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalCost() {

        totalCost_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.OptimizeToursResponse.Metrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.OptimizeToursResponse.Metrics)
    private static final com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics();
    }

    public static com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Metrics> PARSER =
        new com.google.protobuf.AbstractParser<Metrics>() {
          @java.lang.Override
          public Metrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Metrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Metrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ROUTES_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute> routes_;
  /**
   *
   *
   * <pre>
   * Routes computed for each vehicle; the i-th route corresponds to the i-th
   * vehicle in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute> getRoutesList() {
    return routes_;
  }
  /**
   *
   *
   * <pre>
   * Routes computed for each vehicle; the i-th route corresponds to the i-th
   * vehicle in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
      getRoutesOrBuilderList() {
    return routes_;
  }
  /**
   *
   *
   * <pre>
   * Routes computed for each vehicle; the i-th route corresponds to the i-th
   * vehicle in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
   */
  @java.lang.Override
  public int getRoutesCount() {
    return routes_.size();
  }
  /**
   *
   *
   * <pre>
   * Routes computed for each vehicle; the i-th route corresponds to the i-th
   * vehicle in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute getRoutes(int index) {
    return routes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Routes computed for each vehicle; the i-th route corresponds to the i-th
   * vehicle in the model.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRouteOrBuilder getRoutesOrBuilder(int index) {
    return routes_.get(index);
  }

  public static final int REQUEST_LABEL_FIELD_NUMBER = 3;
  private volatile java.lang.Object requestLabel_;
  /**
   *
   *
   * <pre>
   * Copy of the [OptimizeToursRequest.label][google.cloud.optimization.v1.OptimizeToursRequest.label], if a label was specified in the
   * request.
   * </pre>
   *
   * <code>string request_label = 3;</code>
   *
   * @return The requestLabel.
   */
  @java.lang.Override
  public java.lang.String getRequestLabel() {
    java.lang.Object ref = requestLabel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestLabel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Copy of the [OptimizeToursRequest.label][google.cloud.optimization.v1.OptimizeToursRequest.label], if a label was specified in the
   * request.
   * </pre>
   *
   * <code>string request_label = 3;</code>
   *
   * @return The bytes for requestLabel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestLabelBytes() {
    java.lang.Object ref = requestLabel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestLabel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SKIPPED_SHIPMENTS_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.optimization.v1.SkippedShipment> skippedShipments_;
  /**
   *
   *
   * <pre>
   * The list of all shipments skipped.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.SkippedShipment>
      getSkippedShipmentsList() {
    return skippedShipments_;
  }
  /**
   *
   *
   * <pre>
   * The list of all shipments skipped.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.SkippedShipmentOrBuilder>
      getSkippedShipmentsOrBuilderList() {
    return skippedShipments_;
  }
  /**
   *
   *
   * <pre>
   * The list of all shipments skipped.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
   */
  @java.lang.Override
  public int getSkippedShipmentsCount() {
    return skippedShipments_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of all shipments skipped.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.SkippedShipment getSkippedShipments(int index) {
    return skippedShipments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of all shipments skipped.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.SkippedShipmentOrBuilder getSkippedShipmentsOrBuilder(
      int index) {
    return skippedShipments_.get(index);
  }

  public static final int VALIDATION_ERRORS_FIELD_NUMBER = 5;
  private java.util.List<com.google.cloud.optimization.v1.OptimizeToursValidationError>
      validationErrors_;
  /**
   *
   *
   * <pre>
   * List of all the validation errors that we were able to detect
   * independently. See the "MULTIPLE ERRORS" explanation for the
   * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.OptimizeToursValidationError>
      getValidationErrorsList() {
    return validationErrors_;
  }
  /**
   *
   *
   * <pre>
   * List of all the validation errors that we were able to detect
   * independently. See the "MULTIPLE ERRORS" explanation for the
   * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.optimization.v1.OptimizeToursValidationErrorOrBuilder>
      getValidationErrorsOrBuilderList() {
    return validationErrors_;
  }
  /**
   *
   *
   * <pre>
   * List of all the validation errors that we were able to detect
   * independently. See the "MULTIPLE ERRORS" explanation for the
   * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
   * </code>
   */
  @java.lang.Override
  public int getValidationErrorsCount() {
    return validationErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * List of all the validation errors that we were able to detect
   * independently. See the "MULTIPLE ERRORS" explanation for the
   * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.OptimizeToursValidationError getValidationErrors(
      int index) {
    return validationErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of all the validation errors that we were able to detect
   * independently. See the "MULTIPLE ERRORS" explanation for the
   * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.OptimizeToursValidationErrorOrBuilder
      getValidationErrorsOrBuilder(int index) {
    return validationErrors_.get(index);
  }

  public static final int METRICS_FIELD_NUMBER = 6;
  private com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics_;
  /**
   *
   *
   * <pre>
   * Duration, distance and usage metrics for this solution.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
   *
   * @return Whether the metrics field is set.
   */
  @java.lang.Override
  public boolean hasMetrics() {
    return metrics_ != null;
  }
  /**
   *
   *
   * <pre>
   * Duration, distance and usage metrics for this solution.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
   *
   * @return The metrics.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics getMetrics() {
    return metrics_ == null
        ? com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.getDefaultInstance()
        : metrics_;
  }
  /**
   *
   *
   * <pre>
   * Duration, distance and usage metrics for this solution.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.OptimizeToursResponse.MetricsOrBuilder
      getMetricsOrBuilder() {
    return getMetrics();
  }

  public static final int TOTAL_COST_FIELD_NUMBER = 2;
  private double totalCost_;
  /**
   *
   *
   * <pre>
   * Deprecated: Use [Metrics.total_cost][] instead.
   * Total cost of the solution. This takes into account all costs: costs per
   * per hour and travel hour, fixed vehicle costs, unperformed shipment penalty
   * costs, global duration cost, etc.
   * </pre>
   *
   * <code>double total_cost = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.OptimizeToursResponse.total_cost is deprecated. See
   *     google/cloud/optimization/v1/fleet_routing.proto;l=394
   * @return The totalCost.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public double getTotalCost() {
    return totalCost_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < routes_.size(); i++) {
      output.writeMessage(1, routes_.get(i));
    }
    if (java.lang.Double.doubleToRawLongBits(totalCost_) != 0) {
      output.writeDouble(2, totalCost_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestLabel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, requestLabel_);
    }
    for (int i = 0; i < skippedShipments_.size(); i++) {
      output.writeMessage(4, skippedShipments_.get(i));
    }
    for (int i = 0; i < validationErrors_.size(); i++) {
      output.writeMessage(5, validationErrors_.get(i));
    }
    if (metrics_ != null) {
      output.writeMessage(6, getMetrics());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < routes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, routes_.get(i));
    }
    if (java.lang.Double.doubleToRawLongBits(totalCost_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, totalCost_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestLabel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, requestLabel_);
    }
    for (int i = 0; i < skippedShipments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, skippedShipments_.get(i));
    }
    for (int i = 0; i < validationErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, validationErrors_.get(i));
    }
    if (metrics_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMetrics());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.OptimizeToursResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.OptimizeToursResponse other =
        (com.google.cloud.optimization.v1.OptimizeToursResponse) obj;

    if (!getRoutesList().equals(other.getRoutesList())) return false;
    if (!getRequestLabel().equals(other.getRequestLabel())) return false;
    if (!getSkippedShipmentsList().equals(other.getSkippedShipmentsList())) return false;
    if (!getValidationErrorsList().equals(other.getValidationErrorsList())) return false;
    if (hasMetrics() != other.hasMetrics()) return false;
    if (hasMetrics()) {
      if (!getMetrics().equals(other.getMetrics())) return false;
    }
    if (java.lang.Double.doubleToLongBits(getTotalCost())
        != java.lang.Double.doubleToLongBits(other.getTotalCost())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRoutesCount() > 0) {
      hash = (37 * hash) + ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getRoutesList().hashCode();
    }
    hash = (37 * hash) + REQUEST_LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getRequestLabel().hashCode();
    if (getSkippedShipmentsCount() > 0) {
      hash = (37 * hash) + SKIPPED_SHIPMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getSkippedShipmentsList().hashCode();
    }
    if (getValidationErrorsCount() > 0) {
      hash = (37 * hash) + VALIDATION_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getValidationErrorsList().hashCode();
    }
    if (hasMetrics()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrics().hashCode();
    }
    hash = (37 * hash) + TOTAL_COST_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getTotalCost()));
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.optimization.v1.OptimizeToursResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response after solving a tour optimization problem containing the routes
   * followed by each vehicle, the shipments which have been skipped and the
   * overall cost of the solution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.OptimizeToursResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.OptimizeToursResponse)
      com.google.cloud.optimization.v1.OptimizeToursResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.OptimizeToursResponse.class,
              com.google.cloud.optimization.v1.OptimizeToursResponse.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.OptimizeToursResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (routesBuilder_ == null) {
        routes_ = java.util.Collections.emptyList();
      } else {
        routes_ = null;
        routesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      requestLabel_ = "";

      if (skippedShipmentsBuilder_ == null) {
        skippedShipments_ = java.util.Collections.emptyList();
      } else {
        skippedShipments_ = null;
        skippedShipmentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (validationErrorsBuilder_ == null) {
        validationErrors_ = java.util.Collections.emptyList();
      } else {
        validationErrors_ = null;
        validationErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (metricsBuilder_ == null) {
        metrics_ = null;
      } else {
        metrics_ = null;
        metricsBuilder_ = null;
      }
      totalCost_ = 0D;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursResponse getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.OptimizeToursResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursResponse build() {
      com.google.cloud.optimization.v1.OptimizeToursResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursResponse buildPartial() {
      com.google.cloud.optimization.v1.OptimizeToursResponse result =
          new com.google.cloud.optimization.v1.OptimizeToursResponse(this);
      int from_bitField0_ = bitField0_;
      if (routesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          routes_ = java.util.Collections.unmodifiableList(routes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.routes_ = routes_;
      } else {
        result.routes_ = routesBuilder_.build();
      }
      result.requestLabel_ = requestLabel_;
      if (skippedShipmentsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          skippedShipments_ = java.util.Collections.unmodifiableList(skippedShipments_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.skippedShipments_ = skippedShipments_;
      } else {
        result.skippedShipments_ = skippedShipmentsBuilder_.build();
      }
      if (validationErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          validationErrors_ = java.util.Collections.unmodifiableList(validationErrors_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.validationErrors_ = validationErrors_;
      } else {
        result.validationErrors_ = validationErrorsBuilder_.build();
      }
      if (metricsBuilder_ == null) {
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      result.totalCost_ = totalCost_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.OptimizeToursResponse) {
        return mergeFrom((com.google.cloud.optimization.v1.OptimizeToursResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.OptimizeToursResponse other) {
      if (other == com.google.cloud.optimization.v1.OptimizeToursResponse.getDefaultInstance())
        return this;
      if (routesBuilder_ == null) {
        if (!other.routes_.isEmpty()) {
          if (routes_.isEmpty()) {
            routes_ = other.routes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRoutesIsMutable();
            routes_.addAll(other.routes_);
          }
          onChanged();
        }
      } else {
        if (!other.routes_.isEmpty()) {
          if (routesBuilder_.isEmpty()) {
            routesBuilder_.dispose();
            routesBuilder_ = null;
            routes_ = other.routes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            routesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRoutesFieldBuilder()
                    : null;
          } else {
            routesBuilder_.addAllMessages(other.routes_);
          }
        }
      }
      if (!other.getRequestLabel().isEmpty()) {
        requestLabel_ = other.requestLabel_;
        onChanged();
      }
      if (skippedShipmentsBuilder_ == null) {
        if (!other.skippedShipments_.isEmpty()) {
          if (skippedShipments_.isEmpty()) {
            skippedShipments_ = other.skippedShipments_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSkippedShipmentsIsMutable();
            skippedShipments_.addAll(other.skippedShipments_);
          }
          onChanged();
        }
      } else {
        if (!other.skippedShipments_.isEmpty()) {
          if (skippedShipmentsBuilder_.isEmpty()) {
            skippedShipmentsBuilder_.dispose();
            skippedShipmentsBuilder_ = null;
            skippedShipments_ = other.skippedShipments_;
            bitField0_ = (bitField0_ & ~0x00000002);
            skippedShipmentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSkippedShipmentsFieldBuilder()
                    : null;
          } else {
            skippedShipmentsBuilder_.addAllMessages(other.skippedShipments_);
          }
        }
      }
      if (validationErrorsBuilder_ == null) {
        if (!other.validationErrors_.isEmpty()) {
          if (validationErrors_.isEmpty()) {
            validationErrors_ = other.validationErrors_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureValidationErrorsIsMutable();
            validationErrors_.addAll(other.validationErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.validationErrors_.isEmpty()) {
          if (validationErrorsBuilder_.isEmpty()) {
            validationErrorsBuilder_.dispose();
            validationErrorsBuilder_ = null;
            validationErrors_ = other.validationErrors_;
            bitField0_ = (bitField0_ & ~0x00000004);
            validationErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getValidationErrorsFieldBuilder()
                    : null;
          } else {
            validationErrorsBuilder_.addAllMessages(other.validationErrors_);
          }
        }
      }
      if (other.hasMetrics()) {
        mergeMetrics(other.getMetrics());
      }
      if (other.getTotalCost() != 0D) {
        setTotalCost(other.getTotalCost());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.optimization.v1.ShipmentRoute m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentRoute.parser(), extensionRegistry);
                if (routesBuilder_ == null) {
                  ensureRoutesIsMutable();
                  routes_.add(m);
                } else {
                  routesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 17:
              {
                totalCost_ = input.readDouble();

                break;
              } // case 17
            case 26:
              {
                requestLabel_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                com.google.cloud.optimization.v1.SkippedShipment m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.SkippedShipment.parser(),
                        extensionRegistry);
                if (skippedShipmentsBuilder_ == null) {
                  ensureSkippedShipmentsIsMutable();
                  skippedShipments_.add(m);
                } else {
                  skippedShipmentsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.optimization.v1.OptimizeToursValidationError m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.OptimizeToursValidationError.parser(),
                        extensionRegistry);
                if (validationErrorsBuilder_ == null) {
                  ensureValidationErrorsIsMutable();
                  validationErrors_.add(m);
                } else {
                  validationErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getMetricsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute> routes_ =
        java.util.Collections.emptyList();

    private void ensureRoutesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        routes_ = new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentRoute>(routes_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute,
            com.google.cloud.optimization.v1.ShipmentRoute.Builder,
            com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        routesBuilder_;

    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute> getRoutesList() {
      if (routesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(routes_);
      } else {
        return routesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public int getRoutesCount() {
      if (routesBuilder_ == null) {
        return routes_.size();
      } else {
        return routesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute getRoutes(int index) {
      if (routesBuilder_ == null) {
        return routes_.get(index);
      } else {
        return routesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder setRoutes(int index, com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.set(index, value);
        onChanged();
      } else {
        routesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder setRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.set(index, builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder addRoutes(com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.add(value);
        onChanged();
      } else {
        routesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder addRoutes(int index, com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.add(index, value);
        onChanged();
      } else {
        routesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder addRoutes(
        com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.add(builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder addRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.add(index, builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder addAllRoutes(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentRoute> values) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, routes_);
        onChanged();
      } else {
        routesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder clearRoutes() {
      if (routesBuilder_ == null) {
        routes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        routesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder removeRoutes(int index) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.remove(index);
        onChanged();
      } else {
        routesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder getRoutesBuilder(int index) {
      return getRoutesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRouteOrBuilder getRoutesOrBuilder(int index) {
      if (routesBuilder_ == null) {
        return routes_.get(index);
      } else {
        return routesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        getRoutesOrBuilderList() {
      if (routesBuilder_ != null) {
        return routesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(routes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder addRoutesBuilder() {
      return getRoutesFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.ShipmentRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder addRoutesBuilder(int index) {
      return getRoutesFieldBuilder()
          .addBuilder(index, com.google.cloud.optimization.v1.ShipmentRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Routes computed for each vehicle; the i-th route corresponds to the i-th
     * vehicle in the model.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Builder>
        getRoutesBuilderList() {
      return getRoutesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute,
            com.google.cloud.optimization.v1.ShipmentRoute.Builder,
            com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        getRoutesFieldBuilder() {
      if (routesBuilder_ == null) {
        routesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentRoute,
                com.google.cloud.optimization.v1.ShipmentRoute.Builder,
                com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>(
                routes_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        routes_ = null;
      }
      return routesBuilder_;
    }

    private java.lang.Object requestLabel_ = "";
    /**
     *
     *
     * <pre>
     * Copy of the [OptimizeToursRequest.label][google.cloud.optimization.v1.OptimizeToursRequest.label], if a label was specified in the
     * request.
     * </pre>
     *
     * <code>string request_label = 3;</code>
     *
     * @return The requestLabel.
     */
    public java.lang.String getRequestLabel() {
      java.lang.Object ref = requestLabel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestLabel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Copy of the [OptimizeToursRequest.label][google.cloud.optimization.v1.OptimizeToursRequest.label], if a label was specified in the
     * request.
     * </pre>
     *
     * <code>string request_label = 3;</code>
     *
     * @return The bytes for requestLabel.
     */
    public com.google.protobuf.ByteString getRequestLabelBytes() {
      java.lang.Object ref = requestLabel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Copy of the [OptimizeToursRequest.label][google.cloud.optimization.v1.OptimizeToursRequest.label], if a label was specified in the
     * request.
     * </pre>
     *
     * <code>string request_label = 3;</code>
     *
     * @param value The requestLabel to set.
     * @return This builder for chaining.
     */
    public Builder setRequestLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      requestLabel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Copy of the [OptimizeToursRequest.label][google.cloud.optimization.v1.OptimizeToursRequest.label], if a label was specified in the
     * request.
     * </pre>
     *
     * <code>string request_label = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestLabel() {

      requestLabel_ = getDefaultInstance().getRequestLabel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Copy of the [OptimizeToursRequest.label][google.cloud.optimization.v1.OptimizeToursRequest.label], if a label was specified in the
     * request.
     * </pre>
     *
     * <code>string request_label = 3;</code>
     *
     * @param value The bytes for requestLabel to set.
     * @return This builder for chaining.
     */
    public Builder setRequestLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      requestLabel_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.optimization.v1.SkippedShipment> skippedShipments_ =
        java.util.Collections.emptyList();

    private void ensureSkippedShipmentsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        skippedShipments_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.SkippedShipment>(
                skippedShipments_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.SkippedShipment,
            com.google.cloud.optimization.v1.SkippedShipment.Builder,
            com.google.cloud.optimization.v1.SkippedShipmentOrBuilder>
        skippedShipmentsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.SkippedShipment>
        getSkippedShipmentsList() {
      if (skippedShipmentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(skippedShipments_);
      } else {
        return skippedShipmentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public int getSkippedShipmentsCount() {
      if (skippedShipmentsBuilder_ == null) {
        return skippedShipments_.size();
      } else {
        return skippedShipmentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment getSkippedShipments(int index) {
      if (skippedShipmentsBuilder_ == null) {
        return skippedShipments_.get(index);
      } else {
        return skippedShipmentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public Builder setSkippedShipments(
        int index, com.google.cloud.optimization.v1.SkippedShipment value) {
      if (skippedShipmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.set(index, value);
        onChanged();
      } else {
        skippedShipmentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public Builder setSkippedShipments(
        int index, com.google.cloud.optimization.v1.SkippedShipment.Builder builderForValue) {
      if (skippedShipmentsBuilder_ == null) {
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.set(index, builderForValue.build());
        onChanged();
      } else {
        skippedShipmentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public Builder addSkippedShipments(com.google.cloud.optimization.v1.SkippedShipment value) {
      if (skippedShipmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.add(value);
        onChanged();
      } else {
        skippedShipmentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public Builder addSkippedShipments(
        int index, com.google.cloud.optimization.v1.SkippedShipment value) {
      if (skippedShipmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.add(index, value);
        onChanged();
      } else {
        skippedShipmentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public Builder addSkippedShipments(
        com.google.cloud.optimization.v1.SkippedShipment.Builder builderForValue) {
      if (skippedShipmentsBuilder_ == null) {
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.add(builderForValue.build());
        onChanged();
      } else {
        skippedShipmentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public Builder addSkippedShipments(
        int index, com.google.cloud.optimization.v1.SkippedShipment.Builder builderForValue) {
      if (skippedShipmentsBuilder_ == null) {
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.add(index, builderForValue.build());
        onChanged();
      } else {
        skippedShipmentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public Builder addAllSkippedShipments(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.SkippedShipment> values) {
      if (skippedShipmentsBuilder_ == null) {
        ensureSkippedShipmentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, skippedShipments_);
        onChanged();
      } else {
        skippedShipmentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public Builder clearSkippedShipments() {
      if (skippedShipmentsBuilder_ == null) {
        skippedShipments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        skippedShipmentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public Builder removeSkippedShipments(int index) {
      if (skippedShipmentsBuilder_ == null) {
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.remove(index);
        onChanged();
      } else {
        skippedShipmentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment.Builder getSkippedShipmentsBuilder(
        int index) {
      return getSkippedShipmentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipmentOrBuilder getSkippedShipmentsOrBuilder(
        int index) {
      if (skippedShipmentsBuilder_ == null) {
        return skippedShipments_.get(index);
      } else {
        return skippedShipmentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.SkippedShipmentOrBuilder>
        getSkippedShipmentsOrBuilderList() {
      if (skippedShipmentsBuilder_ != null) {
        return skippedShipmentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(skippedShipments_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment.Builder addSkippedShipmentsBuilder() {
      return getSkippedShipmentsFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.SkippedShipment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment.Builder addSkippedShipmentsBuilder(
        int index) {
      return getSkippedShipmentsFieldBuilder()
          .addBuilder(index, com.google.cloud.optimization.v1.SkippedShipment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of all shipments skipped.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 4;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.SkippedShipment.Builder>
        getSkippedShipmentsBuilderList() {
      return getSkippedShipmentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.SkippedShipment,
            com.google.cloud.optimization.v1.SkippedShipment.Builder,
            com.google.cloud.optimization.v1.SkippedShipmentOrBuilder>
        getSkippedShipmentsFieldBuilder() {
      if (skippedShipmentsBuilder_ == null) {
        skippedShipmentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.SkippedShipment,
                com.google.cloud.optimization.v1.SkippedShipment.Builder,
                com.google.cloud.optimization.v1.SkippedShipmentOrBuilder>(
                skippedShipments_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        skippedShipments_ = null;
      }
      return skippedShipmentsBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.OptimizeToursValidationError>
        validationErrors_ = java.util.Collections.emptyList();

    private void ensureValidationErrorsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        validationErrors_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.OptimizeToursValidationError>(
                validationErrors_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.OptimizeToursValidationError,
            com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder,
            com.google.cloud.optimization.v1.OptimizeToursValidationErrorOrBuilder>
        validationErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.OptimizeToursValidationError>
        getValidationErrorsList() {
      if (validationErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(validationErrors_);
      } else {
        return validationErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public int getValidationErrorsCount() {
      if (validationErrorsBuilder_ == null) {
        return validationErrors_.size();
      } else {
        return validationErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursValidationError getValidationErrors(
        int index) {
      if (validationErrorsBuilder_ == null) {
        return validationErrors_.get(index);
      } else {
        return validationErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public Builder setValidationErrors(
        int index, com.google.cloud.optimization.v1.OptimizeToursValidationError value) {
      if (validationErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValidationErrorsIsMutable();
        validationErrors_.set(index, value);
        onChanged();
      } else {
        validationErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public Builder setValidationErrors(
        int index,
        com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder builderForValue) {
      if (validationErrorsBuilder_ == null) {
        ensureValidationErrorsIsMutable();
        validationErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        validationErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public Builder addValidationErrors(
        com.google.cloud.optimization.v1.OptimizeToursValidationError value) {
      if (validationErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValidationErrorsIsMutable();
        validationErrors_.add(value);
        onChanged();
      } else {
        validationErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public Builder addValidationErrors(
        int index, com.google.cloud.optimization.v1.OptimizeToursValidationError value) {
      if (validationErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValidationErrorsIsMutable();
        validationErrors_.add(index, value);
        onChanged();
      } else {
        validationErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public Builder addValidationErrors(
        com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder builderForValue) {
      if (validationErrorsBuilder_ == null) {
        ensureValidationErrorsIsMutable();
        validationErrors_.add(builderForValue.build());
        onChanged();
      } else {
        validationErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public Builder addValidationErrors(
        int index,
        com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder builderForValue) {
      if (validationErrorsBuilder_ == null) {
        ensureValidationErrorsIsMutable();
        validationErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        validationErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public Builder addAllValidationErrors(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.OptimizeToursValidationError>
            values) {
      if (validationErrorsBuilder_ == null) {
        ensureValidationErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, validationErrors_);
        onChanged();
      } else {
        validationErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public Builder clearValidationErrors() {
      if (validationErrorsBuilder_ == null) {
        validationErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        validationErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public Builder removeValidationErrors(int index) {
      if (validationErrorsBuilder_ == null) {
        ensureValidationErrorsIsMutable();
        validationErrors_.remove(index);
        onChanged();
      } else {
        validationErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder
        getValidationErrorsBuilder(int index) {
      return getValidationErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursValidationErrorOrBuilder
        getValidationErrorsOrBuilder(int index) {
      if (validationErrorsBuilder_ == null) {
        return validationErrors_.get(index);
      } else {
        return validationErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.OptimizeToursValidationErrorOrBuilder>
        getValidationErrorsOrBuilderList() {
      if (validationErrorsBuilder_ != null) {
        return validationErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(validationErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder
        addValidationErrorsBuilder() {
      return getValidationErrorsFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.OptimizeToursValidationError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder
        addValidationErrorsBuilder(int index) {
      return getValidationErrorsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.OptimizeToursValidationError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of all the validation errors that we were able to detect
     * independently. See the "MULTIPLE ERRORS" explanation for the
     * [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError] message.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.OptimizeToursValidationError validation_errors = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder>
        getValidationErrorsBuilderList() {
      return getValidationErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.OptimizeToursValidationError,
            com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder,
            com.google.cloud.optimization.v1.OptimizeToursValidationErrorOrBuilder>
        getValidationErrorsFieldBuilder() {
      if (validationErrorsBuilder_ == null) {
        validationErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.OptimizeToursValidationError,
                com.google.cloud.optimization.v1.OptimizeToursValidationError.Builder,
                com.google.cloud.optimization.v1.OptimizeToursValidationErrorOrBuilder>(
                validationErrors_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        validationErrors_ = null;
      }
      return validationErrorsBuilder_;
    }

    private com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics,
            com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.Builder,
            com.google.cloud.optimization.v1.OptimizeToursResponse.MetricsOrBuilder>
        metricsBuilder_;
    /**
     *
     *
     * <pre>
     * Duration, distance and usage metrics for this solution.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
     *
     * @return Whether the metrics field is set.
     */
    public boolean hasMetrics() {
      return metricsBuilder_ != null || metrics_ != null;
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and usage metrics for this solution.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
     *
     * @return The metrics.
     */
    public com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics getMetrics() {
      if (metricsBuilder_ == null) {
        return metrics_ == null
            ? com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.getDefaultInstance()
            : metrics_;
      } else {
        return metricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and usage metrics for this solution.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
     */
    public Builder setMetrics(
        com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        metricsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and usage metrics for this solution.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
     */
    public Builder setMetrics(
        com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        metricsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and usage metrics for this solution.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
     */
    public Builder mergeMetrics(
        com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics value) {
      if (metricsBuilder_ == null) {
        if (metrics_ != null) {
          metrics_ =
              com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.newBuilder(metrics_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        metricsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and usage metrics for this solution.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = null;
        onChanged();
      } else {
        metrics_ = null;
        metricsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and usage metrics for this solution.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.Builder
        getMetricsBuilder() {

      onChanged();
      return getMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and usage metrics for this solution.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
     */
    public com.google.cloud.optimization.v1.OptimizeToursResponse.MetricsOrBuilder
        getMetricsOrBuilder() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilder();
      } else {
        return metrics_ == null
            ? com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.getDefaultInstance()
            : metrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Duration, distance and usage metrics for this solution.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursResponse.Metrics metrics = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics,
            com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.Builder,
            com.google.cloud.optimization.v1.OptimizeToursResponse.MetricsOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics,
                com.google.cloud.optimization.v1.OptimizeToursResponse.Metrics.Builder,
                com.google.cloud.optimization.v1.OptimizeToursResponse.MetricsOrBuilder>(
                getMetrics(), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private double totalCost_;
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Metrics.total_cost][] instead.
     * Total cost of the solution. This takes into account all costs: costs per
     * per hour and travel hour, fixed vehicle costs, unperformed shipment penalty
     * costs, global duration cost, etc.
     * </pre>
     *
     * <code>double total_cost = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.OptimizeToursResponse.total_cost is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=394
     * @return The totalCost.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public double getTotalCost() {
      return totalCost_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Metrics.total_cost][] instead.
     * Total cost of the solution. This takes into account all costs: costs per
     * per hour and travel hour, fixed vehicle costs, unperformed shipment penalty
     * costs, global duration cost, etc.
     * </pre>
     *
     * <code>double total_cost = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.OptimizeToursResponse.total_cost is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=394
     * @param value The totalCost to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setTotalCost(double value) {

      totalCost_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [Metrics.total_cost][] instead.
     * Total cost of the solution. This takes into account all costs: costs per
     * per hour and travel hour, fixed vehicle costs, unperformed shipment penalty
     * costs, global duration cost, etc.
     * </pre>
     *
     * <code>double total_cost = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.OptimizeToursResponse.total_cost is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=394
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearTotalCost() {

      totalCost_ = 0D;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.OptimizeToursResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.OptimizeToursResponse)
  private static final com.google.cloud.optimization.v1.OptimizeToursResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.OptimizeToursResponse();
  }

  public static com.google.cloud.optimization.v1.OptimizeToursResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OptimizeToursResponse> PARSER =
      new com.google.protobuf.AbstractParser<OptimizeToursResponse>() {
        @java.lang.Override
        public OptimizeToursResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OptimizeToursResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OptimizeToursResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.OptimizeToursResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
