/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Request to be given to a tour optimization solver which defines the
 * shipment model to solve as well as optimization parameters.
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.OptimizeToursRequest}
 */
public final class OptimizeToursRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.OptimizeToursRequest)
    OptimizeToursRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OptimizeToursRequest.newBuilder() to construct.
  private OptimizeToursRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OptimizeToursRequest() {
    parent_ = "";
    solvingMode_ = 0;
    searchMode_ = 0;
    injectedFirstSolutionRoutes_ = java.util.Collections.emptyList();
    refreshDetailsRoutes_ = java.util.Collections.emptyList();
    label_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OptimizeToursRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_OptimizeToursRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_OptimizeToursRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.OptimizeToursRequest.class,
            com.google.cloud.optimization.v1.OptimizeToursRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Defines how the solver should handle the request. In all modes but
   * `VALIDATE_ONLY`, if the request is invalid, you will receive an
   * `INVALID_REQUEST` error. See [max_validation_errors][google.cloud.optimization.v1.OptimizeToursRequest.max_validation_errors] to cap the number of
   * errors returned.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode}
   */
  public enum SolvingMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Solve the model.
     * </pre>
     *
     * <code>DEFAULT_SOLVE = 0;</code>
     */
    DEFAULT_SOLVE(0),
    /**
     *
     *
     * <pre>
     * Only validates the model without solving it: populates as many
     * [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
     * as possible.
     * </pre>
     *
     * <code>VALIDATE_ONLY = 1;</code>
     */
    VALIDATE_ONLY(1),
    /**
     *
     *
     * <pre>
     * Only populates
     * [OptimizeToursResponse.skipped_shipments][google.cloud.optimization.v1.OptimizeToursResponse.skipped_shipments],
     * and doesn't actually solve the rest of the request (`status` and `routes`
     * are unset in the response).
     * *IMPORTANT*: not all infeasible shipments are returned here, but only the
     * ones that are detected as infeasible as a preprocessing.
     * </pre>
     *
     * <code>DETECT_SOME_INFEASIBLE_SHIPMENTS = 2;</code>
     */
    DETECT_SOME_INFEASIBLE_SHIPMENTS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Solve the model.
     * </pre>
     *
     * <code>DEFAULT_SOLVE = 0;</code>
     */
    public static final int DEFAULT_SOLVE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Only validates the model without solving it: populates as many
     * [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
     * as possible.
     * </pre>
     *
     * <code>VALIDATE_ONLY = 1;</code>
     */
    public static final int VALIDATE_ONLY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Only populates
     * [OptimizeToursResponse.skipped_shipments][google.cloud.optimization.v1.OptimizeToursResponse.skipped_shipments],
     * and doesn't actually solve the rest of the request (`status` and `routes`
     * are unset in the response).
     * *IMPORTANT*: not all infeasible shipments are returned here, but only the
     * ones that are detected as infeasible as a preprocessing.
     * </pre>
     *
     * <code>DETECT_SOME_INFEASIBLE_SHIPMENTS = 2;</code>
     */
    public static final int DETECT_SOME_INFEASIBLE_SHIPMENTS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SolvingMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SolvingMode forNumber(int value) {
      switch (value) {
        case 0:
          return DEFAULT_SOLVE;
        case 1:
          return VALIDATE_ONLY;
        case 2:
          return DETECT_SOME_INFEASIBLE_SHIPMENTS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SolvingMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SolvingMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SolvingMode>() {
          public SolvingMode findValueByNumber(int number) {
            return SolvingMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.optimization.v1.OptimizeToursRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final SolvingMode[] VALUES = values();

    public static SolvingMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SolvingMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode)
  }

  /**
   *
   *
   * <pre>
   * Mode defining the behavior of the search, trading off latency versus
   * solution quality. In all modes, the global request deadline is enforced.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.optimization.v1.OptimizeToursRequest.SearchMode}
   */
  public enum SearchMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified search mode, equivalent to `RETURN_FAST`.
     * </pre>
     *
     * <code>SEARCH_MODE_UNSPECIFIED = 0;</code>
     */
    SEARCH_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Stop the search after finding the first good solution.
     * </pre>
     *
     * <code>RETURN_FAST = 1;</code>
     */
    RETURN_FAST(1),
    /**
     *
     *
     * <pre>
     * Spend all the available time to search for better solutions.
     * </pre>
     *
     * <code>CONSUME_ALL_AVAILABLE_TIME = 2;</code>
     */
    CONSUME_ALL_AVAILABLE_TIME(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified search mode, equivalent to `RETURN_FAST`.
     * </pre>
     *
     * <code>SEARCH_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int SEARCH_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Stop the search after finding the first good solution.
     * </pre>
     *
     * <code>RETURN_FAST = 1;</code>
     */
    public static final int RETURN_FAST_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Spend all the available time to search for better solutions.
     * </pre>
     *
     * <code>CONSUME_ALL_AVAILABLE_TIME = 2;</code>
     */
    public static final int CONSUME_ALL_AVAILABLE_TIME_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SearchMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SearchMode forNumber(int value) {
      switch (value) {
        case 0:
          return SEARCH_MODE_UNSPECIFIED;
        case 1:
          return RETURN_FAST;
        case 2:
          return CONSUME_ALL_AVAILABLE_TIME;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SearchMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SearchMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SearchMode>() {
          public SearchMode findValueByNumber(int number) {
            return SearchMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.optimization.v1.OptimizeToursRequest.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final SearchMode[] VALUES = values();

    public static SearchMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SearchMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.optimization.v1.OptimizeToursRequest.SearchMode)
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. Target project and location to make a call.
   * Format: `projects/{project-id}/locations/{location-id}`.
   * If no location is specified, a region will be chosen automatically.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Target project and location to make a call.
   * Format: `projects/{project-id}/locations/{location-id}`.
   * If no location is specified, a region will be chosen automatically.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIMEOUT_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * If this timeout is set, the server returns a response before the timeout
   * period has elapsed or the server deadline for synchronous requests is
   * reached, whichever is sooner.
   * For asynchronous requests, the server will generate a solution (if
   * possible) before the timeout has elapsed.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 2;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * If this timeout is set, the server returns a response before the timeout
   * period has elapsed or the server deadline for synchronous requests is
   * reached, whichever is sooner.
   * For asynchronous requests, the server will generate a solution (if
   * possible) before the timeout has elapsed.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 2;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * If this timeout is set, the server returns a response before the timeout
   * period has elapsed or the server deadline for synchronous requests is
   * reached, whichever is sooner.
   * For asynchronous requests, the server will generate a solution (if
   * possible) before the timeout has elapsed.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return getTimeout();
  }

  public static final int MODEL_FIELD_NUMBER = 3;
  private com.google.cloud.optimization.v1.ShipmentModel model_;
  /**
   *
   *
   * <pre>
   * Shipment model to solve.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
   *
   * @return Whether the model field is set.
   */
  @java.lang.Override
  public boolean hasModel() {
    return model_ != null;
  }
  /**
   *
   *
   * <pre>
   * Shipment model to solve.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentModel getModel() {
    return model_ == null
        ? com.google.cloud.optimization.v1.ShipmentModel.getDefaultInstance()
        : model_;
  }
  /**
   *
   *
   * <pre>
   * Shipment model to solve.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentModelOrBuilder getModelOrBuilder() {
    return getModel();
  }

  public static final int SOLVING_MODE_FIELD_NUMBER = 4;
  private int solvingMode_;
  /**
   *
   *
   * <pre>
   * By default, the solving mode is `DEFAULT_SOLVE` (0).
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode solving_mode = 4;</code>
   *
   * @return The enum numeric value on the wire for solvingMode.
   */
  @java.lang.Override
  public int getSolvingModeValue() {
    return solvingMode_;
  }
  /**
   *
   *
   * <pre>
   * By default, the solving mode is `DEFAULT_SOLVE` (0).
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode solving_mode = 4;</code>
   *
   * @return The solvingMode.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode getSolvingMode() {
    @SuppressWarnings("deprecation")
    com.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode result =
        com.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode.valueOf(solvingMode_);
    return result == null
        ? com.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode.UNRECOGNIZED
        : result;
  }

  public static final int MAX_VALIDATION_ERRORS_FIELD_NUMBER = 5;
  private int maxValidationErrors_;
  /**
   *
   *
   * <pre>
   * Truncates the number of validation errors returned. Those errors are
   * typically attached to an INVALID_ARGUMENT error payload as a BadRequest
   * error detail (https://cloud.google.com/apis/design/errors#error_details),
   * unless solving_mode=VALIDATE_ONLY: see the
   * [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
   * field.
   * This defaults to 100 and is capped at 10,000.
   * </pre>
   *
   * <code>optional int32 max_validation_errors = 5;</code>
   *
   * @return Whether the maxValidationErrors field is set.
   */
  @java.lang.Override
  public boolean hasMaxValidationErrors() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Truncates the number of validation errors returned. Those errors are
   * typically attached to an INVALID_ARGUMENT error payload as a BadRequest
   * error detail (https://cloud.google.com/apis/design/errors#error_details),
   * unless solving_mode=VALIDATE_ONLY: see the
   * [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
   * field.
   * This defaults to 100 and is capped at 10,000.
   * </pre>
   *
   * <code>optional int32 max_validation_errors = 5;</code>
   *
   * @return The maxValidationErrors.
   */
  @java.lang.Override
  public int getMaxValidationErrors() {
    return maxValidationErrors_;
  }

  public static final int SEARCH_MODE_FIELD_NUMBER = 6;
  private int searchMode_;
  /**
   *
   *
   * <pre>
   * Search mode used to solve the request.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode search_mode = 6;</code>
   *
   * @return The enum numeric value on the wire for searchMode.
   */
  @java.lang.Override
  public int getSearchModeValue() {
    return searchMode_;
  }
  /**
   *
   *
   * <pre>
   * Search mode used to solve the request.
   * </pre>
   *
   * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode search_mode = 6;</code>
   *
   * @return The searchMode.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode getSearchMode() {
    @SuppressWarnings("deprecation")
    com.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode result =
        com.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode.valueOf(searchMode_);
    return result == null
        ? com.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode.UNRECOGNIZED
        : result;
  }

  public static final int INJECTED_FIRST_SOLUTION_ROUTES_FIELD_NUMBER = 7;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute>
      injectedFirstSolutionRoutes_;
  /**
   *
   *
   * <pre>
   * Guide the optimization algorithm in finding a first solution that is
   * similar to a previous solution.
   * The model is constrained when the first solution is built.
   * Any shipments not performed on a route are implicitly skipped in the first
   * solution, but they may be performed in successive solutions.
   * The solution must satisfy some basic validity assumptions:
   *   * for all routes, `vehicle_index` must be in range and not be duplicated.
   *   * for all visits, `shipment_index` and `visit_request_index` must be
   *     in range.
   *   * a shipment may only be referenced on one route.
   *   * the pickup of a pickup-delivery shipment must be performed before
   *     the delivery.
   *   * no more than one pickup alternative or delivery alternative of
   *     a shipment may be performed.
   *   * for all routes, times are increasing (i.e., `vehicle_start_time
   *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
   *     &lt;= vehicle_end_time`).
   *   * a shipment may only be performed on a vehicle that is allowed. A
   *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
   *     its `vehicle_index` is included in
   *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
   * If the injected solution is not feasible, a validation error is not
   * necessarily returned and an error indicating infeasibility may be returned
   * instead.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute>
      getInjectedFirstSolutionRoutesList() {
    return injectedFirstSolutionRoutes_;
  }
  /**
   *
   *
   * <pre>
   * Guide the optimization algorithm in finding a first solution that is
   * similar to a previous solution.
   * The model is constrained when the first solution is built.
   * Any shipments not performed on a route are implicitly skipped in the first
   * solution, but they may be performed in successive solutions.
   * The solution must satisfy some basic validity assumptions:
   *   * for all routes, `vehicle_index` must be in range and not be duplicated.
   *   * for all visits, `shipment_index` and `visit_request_index` must be
   *     in range.
   *   * a shipment may only be referenced on one route.
   *   * the pickup of a pickup-delivery shipment must be performed before
   *     the delivery.
   *   * no more than one pickup alternative or delivery alternative of
   *     a shipment may be performed.
   *   * for all routes, times are increasing (i.e., `vehicle_start_time
   *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
   *     &lt;= vehicle_end_time`).
   *   * a shipment may only be performed on a vehicle that is allowed. A
   *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
   *     its `vehicle_index` is included in
   *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
   * If the injected solution is not feasible, a validation error is not
   * necessarily returned and an error indicating infeasibility may be returned
   * instead.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
      getInjectedFirstSolutionRoutesOrBuilderList() {
    return injectedFirstSolutionRoutes_;
  }
  /**
   *
   *
   * <pre>
   * Guide the optimization algorithm in finding a first solution that is
   * similar to a previous solution.
   * The model is constrained when the first solution is built.
   * Any shipments not performed on a route are implicitly skipped in the first
   * solution, but they may be performed in successive solutions.
   * The solution must satisfy some basic validity assumptions:
   *   * for all routes, `vehicle_index` must be in range and not be duplicated.
   *   * for all visits, `shipment_index` and `visit_request_index` must be
   *     in range.
   *   * a shipment may only be referenced on one route.
   *   * the pickup of a pickup-delivery shipment must be performed before
   *     the delivery.
   *   * no more than one pickup alternative or delivery alternative of
   *     a shipment may be performed.
   *   * for all routes, times are increasing (i.e., `vehicle_start_time
   *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
   *     &lt;= vehicle_end_time`).
   *   * a shipment may only be performed on a vehicle that is allowed. A
   *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
   *     its `vehicle_index` is included in
   *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
   * If the injected solution is not feasible, a validation error is not
   * necessarily returned and an error indicating infeasibility may be returned
   * instead.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
   * </code>
   */
  @java.lang.Override
  public int getInjectedFirstSolutionRoutesCount() {
    return injectedFirstSolutionRoutes_.size();
  }
  /**
   *
   *
   * <pre>
   * Guide the optimization algorithm in finding a first solution that is
   * similar to a previous solution.
   * The model is constrained when the first solution is built.
   * Any shipments not performed on a route are implicitly skipped in the first
   * solution, but they may be performed in successive solutions.
   * The solution must satisfy some basic validity assumptions:
   *   * for all routes, `vehicle_index` must be in range and not be duplicated.
   *   * for all visits, `shipment_index` and `visit_request_index` must be
   *     in range.
   *   * a shipment may only be referenced on one route.
   *   * the pickup of a pickup-delivery shipment must be performed before
   *     the delivery.
   *   * no more than one pickup alternative or delivery alternative of
   *     a shipment may be performed.
   *   * for all routes, times are increasing (i.e., `vehicle_start_time
   *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
   *     &lt;= vehicle_end_time`).
   *   * a shipment may only be performed on a vehicle that is allowed. A
   *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
   *     its `vehicle_index` is included in
   *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
   * If the injected solution is not feasible, a validation error is not
   * necessarily returned and an error indicating infeasibility may be returned
   * instead.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute getInjectedFirstSolutionRoutes(int index) {
    return injectedFirstSolutionRoutes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Guide the optimization algorithm in finding a first solution that is
   * similar to a previous solution.
   * The model is constrained when the first solution is built.
   * Any shipments not performed on a route are implicitly skipped in the first
   * solution, but they may be performed in successive solutions.
   * The solution must satisfy some basic validity assumptions:
   *   * for all routes, `vehicle_index` must be in range and not be duplicated.
   *   * for all visits, `shipment_index` and `visit_request_index` must be
   *     in range.
   *   * a shipment may only be referenced on one route.
   *   * the pickup of a pickup-delivery shipment must be performed before
   *     the delivery.
   *   * no more than one pickup alternative or delivery alternative of
   *     a shipment may be performed.
   *   * for all routes, times are increasing (i.e., `vehicle_start_time
   *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
   *     &lt;= vehicle_end_time`).
   *   * a shipment may only be performed on a vehicle that is allowed. A
   *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
   *     its `vehicle_index` is included in
   *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
   * If the injected solution is not feasible, a validation error is not
   * necessarily returned and an error indicating infeasibility may be returned
   * instead.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRouteOrBuilder
      getInjectedFirstSolutionRoutesOrBuilder(int index) {
    return injectedFirstSolutionRoutes_.get(index);
  }

  public static final int INJECTED_SOLUTION_CONSTRAINT_FIELD_NUMBER = 8;
  private com.google.cloud.optimization.v1.InjectedSolutionConstraint injectedSolutionConstraint_;
  /**
   *
   *
   * <pre>
   * Constrain the optimization algorithm to find a final solution that is
   * similar to a previous solution. For example, this may be used to freeze
   * portions of routes which have already been completed or which are to be
   * completed but must not be modified.
   * If the injected solution is not feasible, a validation error is not
   * necessarily returned and an error indicating infeasibility may be returned
   * instead.
   * </pre>
   *
   * <code>
   * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
   * </code>
   *
   * @return Whether the injectedSolutionConstraint field is set.
   */
  @java.lang.Override
  public boolean hasInjectedSolutionConstraint() {
    return injectedSolutionConstraint_ != null;
  }
  /**
   *
   *
   * <pre>
   * Constrain the optimization algorithm to find a final solution that is
   * similar to a previous solution. For example, this may be used to freeze
   * portions of routes which have already been completed or which are to be
   * completed but must not be modified.
   * If the injected solution is not feasible, a validation error is not
   * necessarily returned and an error indicating infeasibility may be returned
   * instead.
   * </pre>
   *
   * <code>
   * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
   * </code>
   *
   * @return The injectedSolutionConstraint.
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.InjectedSolutionConstraint
      getInjectedSolutionConstraint() {
    return injectedSolutionConstraint_ == null
        ? com.google.cloud.optimization.v1.InjectedSolutionConstraint.getDefaultInstance()
        : injectedSolutionConstraint_;
  }
  /**
   *
   *
   * <pre>
   * Constrain the optimization algorithm to find a final solution that is
   * similar to a previous solution. For example, this may be used to freeze
   * portions of routes which have already been completed or which are to be
   * completed but must not be modified.
   * If the injected solution is not feasible, a validation error is not
   * necessarily returned and an error indicating infeasibility may be returned
   * instead.
   * </pre>
   *
   * <code>
   * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.InjectedSolutionConstraintOrBuilder
      getInjectedSolutionConstraintOrBuilder() {
    return getInjectedSolutionConstraint();
  }

  public static final int REFRESH_DETAILS_ROUTES_FIELD_NUMBER = 9;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute> refreshDetailsRoutes_;
  /**
   *
   *
   * <pre>
   * If non-empty, the given routes will be refreshed, without modifying their
   * underlying sequence of visits or travel times: only other details will be
   * updated. This does not solve the model.
   * As of 2020/11, this only populates the polylines of non-empty routes and
   * requires that `populate_polylines` is true.
   * The `route_polyline` fields of the passed-in routes may be inconsistent
   * with route `transitions`.
   * This field must not be used together with `injected_first_solution_routes`
   * or `injected_solution_constraint`.
   * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
   * Polylines are still populated between all visits in all non-empty routes
   * regardless of whether the related shipments or vehicles are ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute>
      getRefreshDetailsRoutesList() {
    return refreshDetailsRoutes_;
  }
  /**
   *
   *
   * <pre>
   * If non-empty, the given routes will be refreshed, without modifying their
   * underlying sequence of visits or travel times: only other details will be
   * updated. This does not solve the model.
   * As of 2020/11, this only populates the polylines of non-empty routes and
   * requires that `populate_polylines` is true.
   * The `route_polyline` fields of the passed-in routes may be inconsistent
   * with route `transitions`.
   * This field must not be used together with `injected_first_solution_routes`
   * or `injected_solution_constraint`.
   * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
   * Polylines are still populated between all visits in all non-empty routes
   * regardless of whether the related shipments or vehicles are ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
      getRefreshDetailsRoutesOrBuilderList() {
    return refreshDetailsRoutes_;
  }
  /**
   *
   *
   * <pre>
   * If non-empty, the given routes will be refreshed, without modifying their
   * underlying sequence of visits or travel times: only other details will be
   * updated. This does not solve the model.
   * As of 2020/11, this only populates the polylines of non-empty routes and
   * requires that `populate_polylines` is true.
   * The `route_polyline` fields of the passed-in routes may be inconsistent
   * with route `transitions`.
   * This field must not be used together with `injected_first_solution_routes`
   * or `injected_solution_constraint`.
   * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
   * Polylines are still populated between all visits in all non-empty routes
   * regardless of whether the related shipments or vehicles are ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
   */
  @java.lang.Override
  public int getRefreshDetailsRoutesCount() {
    return refreshDetailsRoutes_.size();
  }
  /**
   *
   *
   * <pre>
   * If non-empty, the given routes will be refreshed, without modifying their
   * underlying sequence of visits or travel times: only other details will be
   * updated. This does not solve the model.
   * As of 2020/11, this only populates the polylines of non-empty routes and
   * requires that `populate_polylines` is true.
   * The `route_polyline` fields of the passed-in routes may be inconsistent
   * with route `transitions`.
   * This field must not be used together with `injected_first_solution_routes`
   * or `injected_solution_constraint`.
   * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
   * Polylines are still populated between all visits in all non-empty routes
   * regardless of whether the related shipments or vehicles are ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute getRefreshDetailsRoutes(int index) {
    return refreshDetailsRoutes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If non-empty, the given routes will be refreshed, without modifying their
   * underlying sequence of visits or travel times: only other details will be
   * updated. This does not solve the model.
   * As of 2020/11, this only populates the polylines of non-empty routes and
   * requires that `populate_polylines` is true.
   * The `route_polyline` fields of the passed-in routes may be inconsistent
   * with route `transitions`.
   * This field must not be used together with `injected_first_solution_routes`
   * or `injected_solution_constraint`.
   * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
   * Polylines are still populated between all visits in all non-empty routes
   * regardless of whether the related shipments or vehicles are ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRouteOrBuilder getRefreshDetailsRoutesOrBuilder(
      int index) {
    return refreshDetailsRoutes_.get(index);
  }

  public static final int INTERPRET_INJECTED_SOLUTIONS_USING_LABELS_FIELD_NUMBER = 10;
  private boolean interpretInjectedSolutionsUsingLabels_;
  /**
   *
   *
   * <pre>
   * If true:
   *   * uses [ShipmentRoute.vehicle_label][google.cloud.optimization.v1.ShipmentRoute.vehicle_label] instead of `vehicle_index` to
   *     match routes in an injected solution with vehicles in the request;
   *     reuses the mapping of original [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index] to new
   *     [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index] to update
   *     [ConstraintRelaxation.vehicle_indices][google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.vehicle_indices]
   *     if non-empty, but the mapping must be unambiguous (i.e., multiple
   *     `ShipmentRoute`s must not share the same original `vehicle_index`).
   *   * uses [ShipmentRoute.Visit.shipment_label][google.cloud.optimization.v1.ShipmentRoute.Visit.shipment_label] instead of `shipment_index`
   *     to match visits in an injected solution with shipments in the request;
   *   * uses [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] instead of [SkippedShipment.index][google.cloud.optimization.v1.SkippedShipment.index] to
   *     match skipped shipments in the injected solution with request
   *     shipments.
   * This interpretation applies to the `injected_first_solution_routes`,
   * `injected_solution_constraint`, and `refresh_details_routes` fields.
   * It can be used when shipment or vehicle indices in the request have
   * changed since the solution was created, perhaps because shipments or
   * vehicles have been removed from or added to the request.
   * If true, labels in the following categories must appear at most once in
   * their category:
   *   * [Vehicle.label][google.cloud.optimization.v1.Vehicle.label] in the request;
   *   * [Shipment.label][google.cloud.optimization.v1.Shipment.label] in the request;
   *   * [ShipmentRoute.vehicle_label][google.cloud.optimization.v1.ShipmentRoute.vehicle_label] in the injected solution;
   *   * [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] and [ShipmentRoute.Visit.shipment_label][google.cloud.optimization.v1.ShipmentRoute.Visit.shipment_label] in
   *     the injected solution (except pickup/delivery visit pairs, whose
   *     `shipment_label` must appear twice).
   * If a `vehicle_label` in the injected solution does not correspond to a
   * request vehicle, the corresponding route is removed from the solution
   * along with its visits. If a `shipment_label` in the injected solution does
   * not correspond to a request shipment, the corresponding visit is removed
   * from the solution. If a [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] in the injected solution
   * does not correspond to a request shipment, the `SkippedShipment` is removed
   * from the solution.
   * Removing route visits or entire routes from an injected solution may
   * have an effect on the implied constraints, which may lead to change in
   * solution, validation errors, or infeasibility.
   * NOTE: The caller must ensure that each [Vehicle.label][google.cloud.optimization.v1.Vehicle.label]
   * (resp. [Shipment.label][google.cloud.optimization.v1.Shipment.label]) uniquely identifies a vehicle (resp. shipment)
   * entity used across the two relevant requests: the past request that
   * produced the `OptimizeToursResponse` used in the injected solution and the
   * current request that includes the injected solution. The uniqueness checks
   * described above are not enough to guarantee this requirement.
   * </pre>
   *
   * <code>bool interpret_injected_solutions_using_labels = 10;</code>
   *
   * @return The interpretInjectedSolutionsUsingLabels.
   */
  @java.lang.Override
  public boolean getInterpretInjectedSolutionsUsingLabels() {
    return interpretInjectedSolutionsUsingLabels_;
  }

  public static final int CONSIDER_ROAD_TRAFFIC_FIELD_NUMBER = 11;
  private boolean considerRoadTraffic_;
  /**
   *
   *
   * <pre>
   * Consider traffic estimation in calculating `ShipmentRoute` fields
   * [Transition.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration],
   * [Visit.start_time][google.cloud.optimization.v1.ShipmentRoute.Visit.start_time],
   * and `vehicle_end_time`; in setting the
   * [ShipmentRoute.has_traffic_infeasibilities][google.cloud.optimization.v1.ShipmentRoute.has_traffic_infeasibilities] field, and in calculating the
   * [OptimizeToursResponse.total_cost][google.cloud.optimization.v1.OptimizeToursResponse.total_cost] field.
   * </pre>
   *
   * <code>bool consider_road_traffic = 11;</code>
   *
   * @return The considerRoadTraffic.
   */
  @java.lang.Override
  public boolean getConsiderRoadTraffic() {
    return considerRoadTraffic_;
  }

  public static final int POPULATE_POLYLINES_FIELD_NUMBER = 12;
  private boolean populatePolylines_;
  /**
   *
   *
   * <pre>
   * If true, polylines will be populated in response `ShipmentRoute`s.
   * </pre>
   *
   * <code>bool populate_polylines = 12;</code>
   *
   * @return The populatePolylines.
   */
  @java.lang.Override
  public boolean getPopulatePolylines() {
    return populatePolylines_;
  }

  public static final int POPULATE_TRANSITION_POLYLINES_FIELD_NUMBER = 13;
  private boolean populateTransitionPolylines_;
  /**
   *
   *
   * <pre>
   * If true, polylines will be populated in response
   * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions].
   * Note that in this case, the polylines will also be populated in the
   * deprecated `travel_steps`.
   * </pre>
   *
   * <code>bool populate_transition_polylines = 13;</code>
   *
   * @return The populateTransitionPolylines.
   */
  @java.lang.Override
  public boolean getPopulateTransitionPolylines() {
    return populateTransitionPolylines_;
  }

  public static final int ALLOW_LARGE_DEADLINE_DESPITE_INTERRUPTION_RISK_FIELD_NUMBER = 14;
  private boolean allowLargeDeadlineDespiteInterruptionRisk_;
  /**
   *
   *
   * <pre>
   * If this is set, then the request can have a deadline
   * (see https://grpc.io/blog/deadlines) of up to 60 minutes.
   * Otherwise, the maximum deadline is only 30 minutes.
   * Note that long-lived requests have a significantly larger (but still small)
   * risk of interruption.
   * </pre>
   *
   * <code>bool allow_large_deadline_despite_interruption_risk = 14;</code>
   *
   * @return The allowLargeDeadlineDespiteInterruptionRisk.
   */
  @java.lang.Override
  public boolean getAllowLargeDeadlineDespiteInterruptionRisk() {
    return allowLargeDeadlineDespiteInterruptionRisk_;
  }

  public static final int USE_GEODESIC_DISTANCES_FIELD_NUMBER = 15;
  private boolean useGeodesicDistances_;
  /**
   *
   *
   * <pre>
   * If true, travel distances will be computed using geodesic distances instead
   * of Google Maps distances, and travel times will be computed using geodesic
   * distances with a speed defined by `geodesic_meters_per_second`.
   * </pre>
   *
   * <code>bool use_geodesic_distances = 15;</code>
   *
   * @return The useGeodesicDistances.
   */
  @java.lang.Override
  public boolean getUseGeodesicDistances() {
    return useGeodesicDistances_;
  }

  public static final int GEODESIC_METERS_PER_SECOND_FIELD_NUMBER = 16;
  private double geodesicMetersPerSecond_;
  /**
   *
   *
   * <pre>
   * When `use_geodesic_distances` is true, this field must be set and defines
   * the speed applied to compute travel times. Its value must be at least 1.0
   * meters/seconds.
   * </pre>
   *
   * <code>optional double geodesic_meters_per_second = 16;</code>
   *
   * @return Whether the geodesicMetersPerSecond field is set.
   */
  @java.lang.Override
  public boolean hasGeodesicMetersPerSecond() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * When `use_geodesic_distances` is true, this field must be set and defines
   * the speed applied to compute travel times. Its value must be at least 1.0
   * meters/seconds.
   * </pre>
   *
   * <code>optional double geodesic_meters_per_second = 16;</code>
   *
   * @return The geodesicMetersPerSecond.
   */
  @java.lang.Override
  public double getGeodesicMetersPerSecond() {
    return geodesicMetersPerSecond_;
  }

  public static final int LABEL_FIELD_NUMBER = 17;
  private volatile java.lang.Object label_;
  /**
   *
   *
   * <pre>
   * Label that may be used to identify this request, reported back in the
   * [OptimizeToursResponse.request_label][google.cloud.optimization.v1.OptimizeToursResponse.request_label].
   * </pre>
   *
   * <code>string label = 17;</code>
   *
   * @return The label.
   */
  @java.lang.Override
  public java.lang.String getLabel() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      label_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Label that may be used to identify this request, reported back in the
   * [OptimizeToursResponse.request_label][google.cloud.optimization.v1.OptimizeToursResponse.request_label].
   * </pre>
   *
   * <code>string label = 17;</code>
   *
   * @return The bytes for label.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelBytes() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      label_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POPULATE_TRAVEL_STEP_POLYLINES_FIELD_NUMBER = 20;
  private boolean populateTravelStepPolylines_;
  /**
   *
   *
   * <pre>
   * Deprecated: Use [OptimizeToursRequest.populate_transition_polylines][] instead.
   * If true, polylines will be populated in response
   * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]. Note that in this case, the polylines will
   * also be populated in the deprecated `travel_steps`.
   * </pre>
   *
   * <code>bool populate_travel_step_polylines = 20 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines is
   *     deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=327
   * @return The populateTravelStepPolylines.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getPopulateTravelStepPolylines() {
    return populateTravelStepPolylines_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (timeout_ != null) {
      output.writeMessage(2, getTimeout());
    }
    if (model_ != null) {
      output.writeMessage(3, getModel());
    }
    if (solvingMode_
        != com.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode.DEFAULT_SOLVE
            .getNumber()) {
      output.writeEnum(4, solvingMode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(5, maxValidationErrors_);
    }
    if (searchMode_
        != com.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode.SEARCH_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, searchMode_);
    }
    for (int i = 0; i < injectedFirstSolutionRoutes_.size(); i++) {
      output.writeMessage(7, injectedFirstSolutionRoutes_.get(i));
    }
    if (injectedSolutionConstraint_ != null) {
      output.writeMessage(8, getInjectedSolutionConstraint());
    }
    for (int i = 0; i < refreshDetailsRoutes_.size(); i++) {
      output.writeMessage(9, refreshDetailsRoutes_.get(i));
    }
    if (interpretInjectedSolutionsUsingLabels_ != false) {
      output.writeBool(10, interpretInjectedSolutionsUsingLabels_);
    }
    if (considerRoadTraffic_ != false) {
      output.writeBool(11, considerRoadTraffic_);
    }
    if (populatePolylines_ != false) {
      output.writeBool(12, populatePolylines_);
    }
    if (populateTransitionPolylines_ != false) {
      output.writeBool(13, populateTransitionPolylines_);
    }
    if (allowLargeDeadlineDespiteInterruptionRisk_ != false) {
      output.writeBool(14, allowLargeDeadlineDespiteInterruptionRisk_);
    }
    if (useGeodesicDistances_ != false) {
      output.writeBool(15, useGeodesicDistances_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeDouble(16, geodesicMetersPerSecond_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, label_);
    }
    if (populateTravelStepPolylines_ != false) {
      output.writeBool(20, populateTravelStepPolylines_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTimeout());
    }
    if (model_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getModel());
    }
    if (solvingMode_
        != com.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode.DEFAULT_SOLVE
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, solvingMode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, maxValidationErrors_);
    }
    if (searchMode_
        != com.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode.SEARCH_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, searchMode_);
    }
    for (int i = 0; i < injectedFirstSolutionRoutes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, injectedFirstSolutionRoutes_.get(i));
    }
    if (injectedSolutionConstraint_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getInjectedSolutionConstraint());
    }
    for (int i = 0; i < refreshDetailsRoutes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, refreshDetailsRoutes_.get(i));
    }
    if (interpretInjectedSolutionsUsingLabels_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              10, interpretInjectedSolutionsUsingLabels_);
    }
    if (considerRoadTraffic_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, considerRoadTraffic_);
    }
    if (populatePolylines_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, populatePolylines_);
    }
    if (populateTransitionPolylines_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(13, populateTransitionPolylines_);
    }
    if (allowLargeDeadlineDespiteInterruptionRisk_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              14, allowLargeDeadlineDespiteInterruptionRisk_);
    }
    if (useGeodesicDistances_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, useGeodesicDistances_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(16, geodesicMetersPerSecond_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, label_);
    }
    if (populateTravelStepPolylines_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(20, populateTravelStepPolylines_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.OptimizeToursRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.OptimizeToursRequest other =
        (com.google.cloud.optimization.v1.OptimizeToursRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (hasModel() != other.hasModel()) return false;
    if (hasModel()) {
      if (!getModel().equals(other.getModel())) return false;
    }
    if (solvingMode_ != other.solvingMode_) return false;
    if (hasMaxValidationErrors() != other.hasMaxValidationErrors()) return false;
    if (hasMaxValidationErrors()) {
      if (getMaxValidationErrors() != other.getMaxValidationErrors()) return false;
    }
    if (searchMode_ != other.searchMode_) return false;
    if (!getInjectedFirstSolutionRoutesList().equals(other.getInjectedFirstSolutionRoutesList()))
      return false;
    if (hasInjectedSolutionConstraint() != other.hasInjectedSolutionConstraint()) return false;
    if (hasInjectedSolutionConstraint()) {
      if (!getInjectedSolutionConstraint().equals(other.getInjectedSolutionConstraint()))
        return false;
    }
    if (!getRefreshDetailsRoutesList().equals(other.getRefreshDetailsRoutesList())) return false;
    if (getInterpretInjectedSolutionsUsingLabels()
        != other.getInterpretInjectedSolutionsUsingLabels()) return false;
    if (getConsiderRoadTraffic() != other.getConsiderRoadTraffic()) return false;
    if (getPopulatePolylines() != other.getPopulatePolylines()) return false;
    if (getPopulateTransitionPolylines() != other.getPopulateTransitionPolylines()) return false;
    if (getAllowLargeDeadlineDespiteInterruptionRisk()
        != other.getAllowLargeDeadlineDespiteInterruptionRisk()) return false;
    if (getUseGeodesicDistances() != other.getUseGeodesicDistances()) return false;
    if (hasGeodesicMetersPerSecond() != other.hasGeodesicMetersPerSecond()) return false;
    if (hasGeodesicMetersPerSecond()) {
      if (java.lang.Double.doubleToLongBits(getGeodesicMetersPerSecond())
          != java.lang.Double.doubleToLongBits(other.getGeodesicMetersPerSecond())) return false;
    }
    if (!getLabel().equals(other.getLabel())) return false;
    if (getPopulateTravelStepPolylines() != other.getPopulateTravelStepPolylines()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    if (hasModel()) {
      hash = (37 * hash) + MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getModel().hashCode();
    }
    hash = (37 * hash) + SOLVING_MODE_FIELD_NUMBER;
    hash = (53 * hash) + solvingMode_;
    if (hasMaxValidationErrors()) {
      hash = (37 * hash) + MAX_VALIDATION_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxValidationErrors();
    }
    hash = (37 * hash) + SEARCH_MODE_FIELD_NUMBER;
    hash = (53 * hash) + searchMode_;
    if (getInjectedFirstSolutionRoutesCount() > 0) {
      hash = (37 * hash) + INJECTED_FIRST_SOLUTION_ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getInjectedFirstSolutionRoutesList().hashCode();
    }
    if (hasInjectedSolutionConstraint()) {
      hash = (37 * hash) + INJECTED_SOLUTION_CONSTRAINT_FIELD_NUMBER;
      hash = (53 * hash) + getInjectedSolutionConstraint().hashCode();
    }
    if (getRefreshDetailsRoutesCount() > 0) {
      hash = (37 * hash) + REFRESH_DETAILS_ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getRefreshDetailsRoutesList().hashCode();
    }
    hash = (37 * hash) + INTERPRET_INJECTED_SOLUTIONS_USING_LABELS_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashBoolean(getInterpretInjectedSolutionsUsingLabels());
    hash = (37 * hash) + CONSIDER_ROAD_TRAFFIC_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getConsiderRoadTraffic());
    hash = (37 * hash) + POPULATE_POLYLINES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPopulatePolylines());
    hash = (37 * hash) + POPULATE_TRANSITION_POLYLINES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPopulateTransitionPolylines());
    hash = (37 * hash) + ALLOW_LARGE_DEADLINE_DESPITE_INTERRUPTION_RISK_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashBoolean(
                getAllowLargeDeadlineDespiteInterruptionRisk());
    hash = (37 * hash) + USE_GEODESIC_DISTANCES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseGeodesicDistances());
    if (hasGeodesicMetersPerSecond()) {
      hash = (37 * hash) + GEODESIC_METERS_PER_SECOND_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getGeodesicMetersPerSecond()));
    }
    hash = (37 * hash) + LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getLabel().hashCode();
    hash = (37 * hash) + POPULATE_TRAVEL_STEP_POLYLINES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPopulateTravelStepPolylines());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.optimization.v1.OptimizeToursRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request to be given to a tour optimization solver which defines the
   * shipment model to solve as well as optimization parameters.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.OptimizeToursRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.OptimizeToursRequest)
      com.google.cloud.optimization.v1.OptimizeToursRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.OptimizeToursRequest.class,
              com.google.cloud.optimization.v1.OptimizeToursRequest.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.OptimizeToursRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      if (timeoutBuilder_ == null) {
        timeout_ = null;
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }
      if (modelBuilder_ == null) {
        model_ = null;
      } else {
        model_ = null;
        modelBuilder_ = null;
      }
      solvingMode_ = 0;

      maxValidationErrors_ = 0;
      bitField0_ = (bitField0_ & ~0x00000001);
      searchMode_ = 0;

      if (injectedFirstSolutionRoutesBuilder_ == null) {
        injectedFirstSolutionRoutes_ = java.util.Collections.emptyList();
      } else {
        injectedFirstSolutionRoutes_ = null;
        injectedFirstSolutionRoutesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (injectedSolutionConstraintBuilder_ == null) {
        injectedSolutionConstraint_ = null;
      } else {
        injectedSolutionConstraint_ = null;
        injectedSolutionConstraintBuilder_ = null;
      }
      if (refreshDetailsRoutesBuilder_ == null) {
        refreshDetailsRoutes_ = java.util.Collections.emptyList();
      } else {
        refreshDetailsRoutes_ = null;
        refreshDetailsRoutesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      interpretInjectedSolutionsUsingLabels_ = false;

      considerRoadTraffic_ = false;

      populatePolylines_ = false;

      populateTransitionPolylines_ = false;

      allowLargeDeadlineDespiteInterruptionRisk_ = false;

      useGeodesicDistances_ = false;

      geodesicMetersPerSecond_ = 0D;
      bitField0_ = (bitField0_ & ~0x00000008);
      label_ = "";

      populateTravelStepPolylines_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_OptimizeToursRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursRequest getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.OptimizeToursRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursRequest build() {
      com.google.cloud.optimization.v1.OptimizeToursRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursRequest buildPartial() {
      com.google.cloud.optimization.v1.OptimizeToursRequest result =
          new com.google.cloud.optimization.v1.OptimizeToursRequest(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.parent_ = parent_;
      if (timeoutBuilder_ == null) {
        result.timeout_ = timeout_;
      } else {
        result.timeout_ = timeoutBuilder_.build();
      }
      if (modelBuilder_ == null) {
        result.model_ = model_;
      } else {
        result.model_ = modelBuilder_.build();
      }
      result.solvingMode_ = solvingMode_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.maxValidationErrors_ = maxValidationErrors_;
        to_bitField0_ |= 0x00000001;
      }
      result.searchMode_ = searchMode_;
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          injectedFirstSolutionRoutes_ =
              java.util.Collections.unmodifiableList(injectedFirstSolutionRoutes_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.injectedFirstSolutionRoutes_ = injectedFirstSolutionRoutes_;
      } else {
        result.injectedFirstSolutionRoutes_ = injectedFirstSolutionRoutesBuilder_.build();
      }
      if (injectedSolutionConstraintBuilder_ == null) {
        result.injectedSolutionConstraint_ = injectedSolutionConstraint_;
      } else {
        result.injectedSolutionConstraint_ = injectedSolutionConstraintBuilder_.build();
      }
      if (refreshDetailsRoutesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          refreshDetailsRoutes_ = java.util.Collections.unmodifiableList(refreshDetailsRoutes_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.refreshDetailsRoutes_ = refreshDetailsRoutes_;
      } else {
        result.refreshDetailsRoutes_ = refreshDetailsRoutesBuilder_.build();
      }
      result.interpretInjectedSolutionsUsingLabels_ = interpretInjectedSolutionsUsingLabels_;
      result.considerRoadTraffic_ = considerRoadTraffic_;
      result.populatePolylines_ = populatePolylines_;
      result.populateTransitionPolylines_ = populateTransitionPolylines_;
      result.allowLargeDeadlineDespiteInterruptionRisk_ =
          allowLargeDeadlineDespiteInterruptionRisk_;
      result.useGeodesicDistances_ = useGeodesicDistances_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.geodesicMetersPerSecond_ = geodesicMetersPerSecond_;
        to_bitField0_ |= 0x00000002;
      }
      result.label_ = label_;
      result.populateTravelStepPolylines_ = populateTravelStepPolylines_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.OptimizeToursRequest) {
        return mergeFrom((com.google.cloud.optimization.v1.OptimizeToursRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.OptimizeToursRequest other) {
      if (other == com.google.cloud.optimization.v1.OptimizeToursRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.hasModel()) {
        mergeModel(other.getModel());
      }
      if (other.solvingMode_ != 0) {
        setSolvingModeValue(other.getSolvingModeValue());
      }
      if (other.hasMaxValidationErrors()) {
        setMaxValidationErrors(other.getMaxValidationErrors());
      }
      if (other.searchMode_ != 0) {
        setSearchModeValue(other.getSearchModeValue());
      }
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        if (!other.injectedFirstSolutionRoutes_.isEmpty()) {
          if (injectedFirstSolutionRoutes_.isEmpty()) {
            injectedFirstSolutionRoutes_ = other.injectedFirstSolutionRoutes_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureInjectedFirstSolutionRoutesIsMutable();
            injectedFirstSolutionRoutes_.addAll(other.injectedFirstSolutionRoutes_);
          }
          onChanged();
        }
      } else {
        if (!other.injectedFirstSolutionRoutes_.isEmpty()) {
          if (injectedFirstSolutionRoutesBuilder_.isEmpty()) {
            injectedFirstSolutionRoutesBuilder_.dispose();
            injectedFirstSolutionRoutesBuilder_ = null;
            injectedFirstSolutionRoutes_ = other.injectedFirstSolutionRoutes_;
            bitField0_ = (bitField0_ & ~0x00000002);
            injectedFirstSolutionRoutesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInjectedFirstSolutionRoutesFieldBuilder()
                    : null;
          } else {
            injectedFirstSolutionRoutesBuilder_.addAllMessages(other.injectedFirstSolutionRoutes_);
          }
        }
      }
      if (other.hasInjectedSolutionConstraint()) {
        mergeInjectedSolutionConstraint(other.getInjectedSolutionConstraint());
      }
      if (refreshDetailsRoutesBuilder_ == null) {
        if (!other.refreshDetailsRoutes_.isEmpty()) {
          if (refreshDetailsRoutes_.isEmpty()) {
            refreshDetailsRoutes_ = other.refreshDetailsRoutes_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureRefreshDetailsRoutesIsMutable();
            refreshDetailsRoutes_.addAll(other.refreshDetailsRoutes_);
          }
          onChanged();
        }
      } else {
        if (!other.refreshDetailsRoutes_.isEmpty()) {
          if (refreshDetailsRoutesBuilder_.isEmpty()) {
            refreshDetailsRoutesBuilder_.dispose();
            refreshDetailsRoutesBuilder_ = null;
            refreshDetailsRoutes_ = other.refreshDetailsRoutes_;
            bitField0_ = (bitField0_ & ~0x00000004);
            refreshDetailsRoutesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRefreshDetailsRoutesFieldBuilder()
                    : null;
          } else {
            refreshDetailsRoutesBuilder_.addAllMessages(other.refreshDetailsRoutes_);
          }
        }
      }
      if (other.getInterpretInjectedSolutionsUsingLabels() != false) {
        setInterpretInjectedSolutionsUsingLabels(other.getInterpretInjectedSolutionsUsingLabels());
      }
      if (other.getConsiderRoadTraffic() != false) {
        setConsiderRoadTraffic(other.getConsiderRoadTraffic());
      }
      if (other.getPopulatePolylines() != false) {
        setPopulatePolylines(other.getPopulatePolylines());
      }
      if (other.getPopulateTransitionPolylines() != false) {
        setPopulateTransitionPolylines(other.getPopulateTransitionPolylines());
      }
      if (other.getAllowLargeDeadlineDespiteInterruptionRisk() != false) {
        setAllowLargeDeadlineDespiteInterruptionRisk(
            other.getAllowLargeDeadlineDespiteInterruptionRisk());
      }
      if (other.getUseGeodesicDistances() != false) {
        setUseGeodesicDistances(other.getUseGeodesicDistances());
      }
      if (other.hasGeodesicMetersPerSecond()) {
        setGeodesicMetersPerSecond(other.getGeodesicMetersPerSecond());
      }
      if (!other.getLabel().isEmpty()) {
        label_ = other.label_;
        onChanged();
      }
      if (other.getPopulateTravelStepPolylines() != false) {
        setPopulateTravelStepPolylines(other.getPopulateTravelStepPolylines());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getModelFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 32:
              {
                solvingMode_ = input.readEnum();

                break;
              } // case 32
            case 40:
              {
                maxValidationErrors_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 40
            case 48:
              {
                searchMode_ = input.readEnum();

                break;
              } // case 48
            case 58:
              {
                com.google.cloud.optimization.v1.ShipmentRoute m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentRoute.parser(), extensionRegistry);
                if (injectedFirstSolutionRoutesBuilder_ == null) {
                  ensureInjectedFirstSolutionRoutesIsMutable();
                  injectedFirstSolutionRoutes_.add(m);
                } else {
                  injectedFirstSolutionRoutesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getInjectedSolutionConstraintFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 74:
              {
                com.google.cloud.optimization.v1.ShipmentRoute m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentRoute.parser(), extensionRegistry);
                if (refreshDetailsRoutesBuilder_ == null) {
                  ensureRefreshDetailsRoutesIsMutable();
                  refreshDetailsRoutes_.add(m);
                } else {
                  refreshDetailsRoutesBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 80:
              {
                interpretInjectedSolutionsUsingLabels_ = input.readBool();

                break;
              } // case 80
            case 88:
              {
                considerRoadTraffic_ = input.readBool();

                break;
              } // case 88
            case 96:
              {
                populatePolylines_ = input.readBool();

                break;
              } // case 96
            case 104:
              {
                populateTransitionPolylines_ = input.readBool();

                break;
              } // case 104
            case 112:
              {
                allowLargeDeadlineDespiteInterruptionRisk_ = input.readBool();

                break;
              } // case 112
            case 120:
              {
                useGeodesicDistances_ = input.readBool();

                break;
              } // case 120
            case 129:
              {
                geodesicMetersPerSecond_ = input.readDouble();
                bitField0_ |= 0x00000008;
                break;
              } // case 129
            case 138:
              {
                label_ = input.readStringRequireUtf8();

                break;
              } // case 138
            case 160:
              {
                populateTravelStepPolylines_ = input.readBool();

                break;
              } // case 160
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Target project and location to make a call.
     * Format: `projects/{project-id}/locations/{location-id}`.
     * If no location is specified, a region will be chosen automatically.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Target project and location to make a call.
     * Format: `projects/{project-id}/locations/{location-id}`.
     * If no location is specified, a region will be chosen automatically.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Target project and location to make a call.
     * Format: `projects/{project-id}/locations/{location-id}`.
     * If no location is specified, a region will be chosen automatically.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Target project and location to make a call.
     * Format: `projects/{project-id}/locations/{location-id}`.
     * If no location is specified, a region will be chosen automatically.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Target project and location to make a call.
     * Format: `projects/{project-id}/locations/{location-id}`.
     * If no location is specified, a region will be chosen automatically.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 2;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return timeoutBuilder_ != null || timeout_ != null;
    }
    /**
     *
     *
     * <pre>
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 2;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 2;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
        onChanged();
      } else {
        timeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 2;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
        onChanged();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 2;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (timeout_ != null) {
          timeout_ =
              com.google.protobuf.Duration.newBuilder(timeout_).mergeFrom(value).buildPartial();
        } else {
          timeout_ = value;
        }
        onChanged();
      } else {
        timeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 2;</code>
     */
    public Builder clearTimeout() {
      if (timeoutBuilder_ == null) {
        timeout_ = null;
        onChanged();
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {

      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * If this timeout is set, the server returns a response before the timeout
     * period has elapsed or the server deadline for synchronous requests is
     * reached, whichever is sooner.
     * For asynchronous requests, the server will generate a solution (if
     * possible) before the timeout has elapsed.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private com.google.cloud.optimization.v1.ShipmentModel model_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentModel,
            com.google.cloud.optimization.v1.ShipmentModel.Builder,
            com.google.cloud.optimization.v1.ShipmentModelOrBuilder>
        modelBuilder_;
    /**
     *
     *
     * <pre>
     * Shipment model to solve.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
     *
     * @return Whether the model field is set.
     */
    public boolean hasModel() {
      return modelBuilder_ != null || model_ != null;
    }
    /**
     *
     *
     * <pre>
     * Shipment model to solve.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
     *
     * @return The model.
     */
    public com.google.cloud.optimization.v1.ShipmentModel getModel() {
      if (modelBuilder_ == null) {
        return model_ == null
            ? com.google.cloud.optimization.v1.ShipmentModel.getDefaultInstance()
            : model_;
      } else {
        return modelBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Shipment model to solve.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
     */
    public Builder setModel(com.google.cloud.optimization.v1.ShipmentModel value) {
      if (modelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        model_ = value;
        onChanged();
      } else {
        modelBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Shipment model to solve.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
     */
    public Builder setModel(
        com.google.cloud.optimization.v1.ShipmentModel.Builder builderForValue) {
      if (modelBuilder_ == null) {
        model_ = builderForValue.build();
        onChanged();
      } else {
        modelBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Shipment model to solve.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
     */
    public Builder mergeModel(com.google.cloud.optimization.v1.ShipmentModel value) {
      if (modelBuilder_ == null) {
        if (model_ != null) {
          model_ =
              com.google.cloud.optimization.v1.ShipmentModel.newBuilder(model_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          model_ = value;
        }
        onChanged();
      } else {
        modelBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Shipment model to solve.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
     */
    public Builder clearModel() {
      if (modelBuilder_ == null) {
        model_ = null;
        onChanged();
      } else {
        model_ = null;
        modelBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Shipment model to solve.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentModel.Builder getModelBuilder() {

      onChanged();
      return getModelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Shipment model to solve.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentModelOrBuilder getModelOrBuilder() {
      if (modelBuilder_ != null) {
        return modelBuilder_.getMessageOrBuilder();
      } else {
        return model_ == null
            ? com.google.cloud.optimization.v1.ShipmentModel.getDefaultInstance()
            : model_;
      }
    }
    /**
     *
     *
     * <pre>
     * Shipment model to solve.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.ShipmentModel model = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentModel,
            com.google.cloud.optimization.v1.ShipmentModel.Builder,
            com.google.cloud.optimization.v1.ShipmentModelOrBuilder>
        getModelFieldBuilder() {
      if (modelBuilder_ == null) {
        modelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentModel,
                com.google.cloud.optimization.v1.ShipmentModel.Builder,
                com.google.cloud.optimization.v1.ShipmentModelOrBuilder>(
                getModel(), getParentForChildren(), isClean());
        model_ = null;
      }
      return modelBuilder_;
    }

    private int solvingMode_ = 0;
    /**
     *
     *
     * <pre>
     * By default, the solving mode is `DEFAULT_SOLVE` (0).
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode solving_mode = 4;</code>
     *
     * @return The enum numeric value on the wire for solvingMode.
     */
    @java.lang.Override
    public int getSolvingModeValue() {
      return solvingMode_;
    }
    /**
     *
     *
     * <pre>
     * By default, the solving mode is `DEFAULT_SOLVE` (0).
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode solving_mode = 4;</code>
     *
     * @param value The enum numeric value on the wire for solvingMode to set.
     * @return This builder for chaining.
     */
    public Builder setSolvingModeValue(int value) {

      solvingMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * By default, the solving mode is `DEFAULT_SOLVE` (0).
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode solving_mode = 4;</code>
     *
     * @return The solvingMode.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode getSolvingMode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode result =
          com.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode.valueOf(solvingMode_);
      return result == null
          ? com.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * By default, the solving mode is `DEFAULT_SOLVE` (0).
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode solving_mode = 4;</code>
     *
     * @param value The solvingMode to set.
     * @return This builder for chaining.
     */
    public Builder setSolvingMode(
        com.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      solvingMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * By default, the solving mode is `DEFAULT_SOLVE` (0).
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode solving_mode = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSolvingMode() {

      solvingMode_ = 0;
      onChanged();
      return this;
    }

    private int maxValidationErrors_;
    /**
     *
     *
     * <pre>
     * Truncates the number of validation errors returned. Those errors are
     * typically attached to an INVALID_ARGUMENT error payload as a BadRequest
     * error detail (https://cloud.google.com/apis/design/errors#error_details),
     * unless solving_mode=VALIDATE_ONLY: see the
     * [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
     * field.
     * This defaults to 100 and is capped at 10,000.
     * </pre>
     *
     * <code>optional int32 max_validation_errors = 5;</code>
     *
     * @return Whether the maxValidationErrors field is set.
     */
    @java.lang.Override
    public boolean hasMaxValidationErrors() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Truncates the number of validation errors returned. Those errors are
     * typically attached to an INVALID_ARGUMENT error payload as a BadRequest
     * error detail (https://cloud.google.com/apis/design/errors#error_details),
     * unless solving_mode=VALIDATE_ONLY: see the
     * [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
     * field.
     * This defaults to 100 and is capped at 10,000.
     * </pre>
     *
     * <code>optional int32 max_validation_errors = 5;</code>
     *
     * @return The maxValidationErrors.
     */
    @java.lang.Override
    public int getMaxValidationErrors() {
      return maxValidationErrors_;
    }
    /**
     *
     *
     * <pre>
     * Truncates the number of validation errors returned. Those errors are
     * typically attached to an INVALID_ARGUMENT error payload as a BadRequest
     * error detail (https://cloud.google.com/apis/design/errors#error_details),
     * unless solving_mode=VALIDATE_ONLY: see the
     * [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
     * field.
     * This defaults to 100 and is capped at 10,000.
     * </pre>
     *
     * <code>optional int32 max_validation_errors = 5;</code>
     *
     * @param value The maxValidationErrors to set.
     * @return This builder for chaining.
     */
    public Builder setMaxValidationErrors(int value) {
      bitField0_ |= 0x00000001;
      maxValidationErrors_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Truncates the number of validation errors returned. Those errors are
     * typically attached to an INVALID_ARGUMENT error payload as a BadRequest
     * error detail (https://cloud.google.com/apis/design/errors#error_details),
     * unless solving_mode=VALIDATE_ONLY: see the
     * [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
     * field.
     * This defaults to 100 and is capped at 10,000.
     * </pre>
     *
     * <code>optional int32 max_validation_errors = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxValidationErrors() {
      bitField0_ = (bitField0_ & ~0x00000001);
      maxValidationErrors_ = 0;
      onChanged();
      return this;
    }

    private int searchMode_ = 0;
    /**
     *
     *
     * <pre>
     * Search mode used to solve the request.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode search_mode = 6;</code>
     *
     * @return The enum numeric value on the wire for searchMode.
     */
    @java.lang.Override
    public int getSearchModeValue() {
      return searchMode_;
    }
    /**
     *
     *
     * <pre>
     * Search mode used to solve the request.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode search_mode = 6;</code>
     *
     * @param value The enum numeric value on the wire for searchMode to set.
     * @return This builder for chaining.
     */
    public Builder setSearchModeValue(int value) {

      searchMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Search mode used to solve the request.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode search_mode = 6;</code>
     *
     * @return The searchMode.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode getSearchMode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode result =
          com.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode.valueOf(searchMode_);
      return result == null
          ? com.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Search mode used to solve the request.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode search_mode = 6;</code>
     *
     * @param value The searchMode to set.
     * @return This builder for chaining.
     */
    public Builder setSearchMode(
        com.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      searchMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Search mode used to solve the request.
     * </pre>
     *
     * <code>.google.cloud.optimization.v1.OptimizeToursRequest.SearchMode search_mode = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSearchMode() {

      searchMode_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute>
        injectedFirstSolutionRoutes_ = java.util.Collections.emptyList();

    private void ensureInjectedFirstSolutionRoutesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        injectedFirstSolutionRoutes_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentRoute>(
                injectedFirstSolutionRoutes_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute,
            com.google.cloud.optimization.v1.ShipmentRoute.Builder,
            com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        injectedFirstSolutionRoutesBuilder_;

    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute>
        getInjectedFirstSolutionRoutesList() {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(injectedFirstSolutionRoutes_);
      } else {
        return injectedFirstSolutionRoutesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public int getInjectedFirstSolutionRoutesCount() {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        return injectedFirstSolutionRoutes_.size();
      } else {
        return injectedFirstSolutionRoutesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute getInjectedFirstSolutionRoutes(
        int index) {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        return injectedFirstSolutionRoutes_.get(index);
      } else {
        return injectedFirstSolutionRoutesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public Builder setInjectedFirstSolutionRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInjectedFirstSolutionRoutesIsMutable();
        injectedFirstSolutionRoutes_.set(index, value);
        onChanged();
      } else {
        injectedFirstSolutionRoutesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public Builder setInjectedFirstSolutionRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        ensureInjectedFirstSolutionRoutesIsMutable();
        injectedFirstSolutionRoutes_.set(index, builderForValue.build());
        onChanged();
      } else {
        injectedFirstSolutionRoutesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public Builder addInjectedFirstSolutionRoutes(
        com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInjectedFirstSolutionRoutesIsMutable();
        injectedFirstSolutionRoutes_.add(value);
        onChanged();
      } else {
        injectedFirstSolutionRoutesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public Builder addInjectedFirstSolutionRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInjectedFirstSolutionRoutesIsMutable();
        injectedFirstSolutionRoutes_.add(index, value);
        onChanged();
      } else {
        injectedFirstSolutionRoutesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public Builder addInjectedFirstSolutionRoutes(
        com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        ensureInjectedFirstSolutionRoutesIsMutable();
        injectedFirstSolutionRoutes_.add(builderForValue.build());
        onChanged();
      } else {
        injectedFirstSolutionRoutesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public Builder addInjectedFirstSolutionRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        ensureInjectedFirstSolutionRoutesIsMutable();
        injectedFirstSolutionRoutes_.add(index, builderForValue.build());
        onChanged();
      } else {
        injectedFirstSolutionRoutesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public Builder addAllInjectedFirstSolutionRoutes(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentRoute> values) {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        ensureInjectedFirstSolutionRoutesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, injectedFirstSolutionRoutes_);
        onChanged();
      } else {
        injectedFirstSolutionRoutesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public Builder clearInjectedFirstSolutionRoutes() {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        injectedFirstSolutionRoutes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        injectedFirstSolutionRoutesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public Builder removeInjectedFirstSolutionRoutes(int index) {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        ensureInjectedFirstSolutionRoutesIsMutable();
        injectedFirstSolutionRoutes_.remove(index);
        onChanged();
      } else {
        injectedFirstSolutionRoutesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder
        getInjectedFirstSolutionRoutesBuilder(int index) {
      return getInjectedFirstSolutionRoutesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentRouteOrBuilder
        getInjectedFirstSolutionRoutesOrBuilder(int index) {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        return injectedFirstSolutionRoutes_.get(index);
      } else {
        return injectedFirstSolutionRoutesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        getInjectedFirstSolutionRoutesOrBuilderList() {
      if (injectedFirstSolutionRoutesBuilder_ != null) {
        return injectedFirstSolutionRoutesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(injectedFirstSolutionRoutes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder
        addInjectedFirstSolutionRoutesBuilder() {
      return getInjectedFirstSolutionRoutesFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.ShipmentRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder
        addInjectedFirstSolutionRoutesBuilder(int index) {
      return getInjectedFirstSolutionRoutesFieldBuilder()
          .addBuilder(index, com.google.cloud.optimization.v1.ShipmentRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Guide the optimization algorithm in finding a first solution that is
     * similar to a previous solution.
     * The model is constrained when the first solution is built.
     * Any shipments not performed on a route are implicitly skipped in the first
     * solution, but they may be performed in successive solutions.
     * The solution must satisfy some basic validity assumptions:
     *   * for all routes, `vehicle_index` must be in range and not be duplicated.
     *   * for all visits, `shipment_index` and `visit_request_index` must be
     *     in range.
     *   * a shipment may only be referenced on one route.
     *   * the pickup of a pickup-delivery shipment must be performed before
     *     the delivery.
     *   * no more than one pickup alternative or delivery alternative of
     *     a shipment may be performed.
     *   * for all routes, times are increasing (i.e., `vehicle_start_time
     *     &lt;= visits[0].start_time &lt;= visits[1].start_time ...
     *     &lt;= vehicle_end_time`).
     *   * a shipment may only be performed on a vehicle that is allowed. A
     *     vehicle is allowed if [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices] is empty or
     *     its `vehicle_index` is included in
     *     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.ShipmentRoute injected_first_solution_routes = 7;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Builder>
        getInjectedFirstSolutionRoutesBuilderList() {
      return getInjectedFirstSolutionRoutesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute,
            com.google.cloud.optimization.v1.ShipmentRoute.Builder,
            com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        getInjectedFirstSolutionRoutesFieldBuilder() {
      if (injectedFirstSolutionRoutesBuilder_ == null) {
        injectedFirstSolutionRoutesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentRoute,
                com.google.cloud.optimization.v1.ShipmentRoute.Builder,
                com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>(
                injectedFirstSolutionRoutes_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        injectedFirstSolutionRoutes_ = null;
      }
      return injectedFirstSolutionRoutesBuilder_;
    }

    private com.google.cloud.optimization.v1.InjectedSolutionConstraint injectedSolutionConstraint_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.InjectedSolutionConstraint,
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.Builder,
            com.google.cloud.optimization.v1.InjectedSolutionConstraintOrBuilder>
        injectedSolutionConstraintBuilder_;
    /**
     *
     *
     * <pre>
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
     * </code>
     *
     * @return Whether the injectedSolutionConstraint field is set.
     */
    public boolean hasInjectedSolutionConstraint() {
      return injectedSolutionConstraintBuilder_ != null || injectedSolutionConstraint_ != null;
    }
    /**
     *
     *
     * <pre>
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
     * </code>
     *
     * @return The injectedSolutionConstraint.
     */
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint
        getInjectedSolutionConstraint() {
      if (injectedSolutionConstraintBuilder_ == null) {
        return injectedSolutionConstraint_ == null
            ? com.google.cloud.optimization.v1.InjectedSolutionConstraint.getDefaultInstance()
            : injectedSolutionConstraint_;
      } else {
        return injectedSolutionConstraintBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
     * </code>
     */
    public Builder setInjectedSolutionConstraint(
        com.google.cloud.optimization.v1.InjectedSolutionConstraint value) {
      if (injectedSolutionConstraintBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        injectedSolutionConstraint_ = value;
        onChanged();
      } else {
        injectedSolutionConstraintBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
     * </code>
     */
    public Builder setInjectedSolutionConstraint(
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.Builder builderForValue) {
      if (injectedSolutionConstraintBuilder_ == null) {
        injectedSolutionConstraint_ = builderForValue.build();
        onChanged();
      } else {
        injectedSolutionConstraintBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
     * </code>
     */
    public Builder mergeInjectedSolutionConstraint(
        com.google.cloud.optimization.v1.InjectedSolutionConstraint value) {
      if (injectedSolutionConstraintBuilder_ == null) {
        if (injectedSolutionConstraint_ != null) {
          injectedSolutionConstraint_ =
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.newBuilder(
                      injectedSolutionConstraint_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          injectedSolutionConstraint_ = value;
        }
        onChanged();
      } else {
        injectedSolutionConstraintBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
     * </code>
     */
    public Builder clearInjectedSolutionConstraint() {
      if (injectedSolutionConstraintBuilder_ == null) {
        injectedSolutionConstraint_ = null;
        onChanged();
      } else {
        injectedSolutionConstraint_ = null;
        injectedSolutionConstraintBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
     * </code>
     */
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint.Builder
        getInjectedSolutionConstraintBuilder() {

      onChanged();
      return getInjectedSolutionConstraintFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
     * </code>
     */
    public com.google.cloud.optimization.v1.InjectedSolutionConstraintOrBuilder
        getInjectedSolutionConstraintOrBuilder() {
      if (injectedSolutionConstraintBuilder_ != null) {
        return injectedSolutionConstraintBuilder_.getMessageOrBuilder();
      } else {
        return injectedSolutionConstraint_ == null
            ? com.google.cloud.optimization.v1.InjectedSolutionConstraint.getDefaultInstance()
            : injectedSolutionConstraint_;
      }
    }
    /**
     *
     *
     * <pre>
     * Constrain the optimization algorithm to find a final solution that is
     * similar to a previous solution. For example, this may be used to freeze
     * portions of routes which have already been completed or which are to be
     * completed but must not be modified.
     * If the injected solution is not feasible, a validation error is not
     * necessarily returned and an error indicating infeasibility may be returned
     * instead.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InjectedSolutionConstraint injected_solution_constraint = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.optimization.v1.InjectedSolutionConstraint,
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.Builder,
            com.google.cloud.optimization.v1.InjectedSolutionConstraintOrBuilder>
        getInjectedSolutionConstraintFieldBuilder() {
      if (injectedSolutionConstraintBuilder_ == null) {
        injectedSolutionConstraintBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.optimization.v1.InjectedSolutionConstraint,
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.Builder,
                com.google.cloud.optimization.v1.InjectedSolutionConstraintOrBuilder>(
                getInjectedSolutionConstraint(), getParentForChildren(), isClean());
        injectedSolutionConstraint_ = null;
      }
      return injectedSolutionConstraintBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute> refreshDetailsRoutes_ =
        java.util.Collections.emptyList();

    private void ensureRefreshDetailsRoutesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        refreshDetailsRoutes_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentRoute>(
                refreshDetailsRoutes_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute,
            com.google.cloud.optimization.v1.ShipmentRoute.Builder,
            com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        refreshDetailsRoutesBuilder_;

    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute>
        getRefreshDetailsRoutesList() {
      if (refreshDetailsRoutesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(refreshDetailsRoutes_);
      } else {
        return refreshDetailsRoutesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public int getRefreshDetailsRoutesCount() {
      if (refreshDetailsRoutesBuilder_ == null) {
        return refreshDetailsRoutes_.size();
      } else {
        return refreshDetailsRoutesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute getRefreshDetailsRoutes(int index) {
      if (refreshDetailsRoutesBuilder_ == null) {
        return refreshDetailsRoutes_.get(index);
      } else {
        return refreshDetailsRoutesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public Builder setRefreshDetailsRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (refreshDetailsRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRefreshDetailsRoutesIsMutable();
        refreshDetailsRoutes_.set(index, value);
        onChanged();
      } else {
        refreshDetailsRoutesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public Builder setRefreshDetailsRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (refreshDetailsRoutesBuilder_ == null) {
        ensureRefreshDetailsRoutesIsMutable();
        refreshDetailsRoutes_.set(index, builderForValue.build());
        onChanged();
      } else {
        refreshDetailsRoutesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public Builder addRefreshDetailsRoutes(com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (refreshDetailsRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRefreshDetailsRoutesIsMutable();
        refreshDetailsRoutes_.add(value);
        onChanged();
      } else {
        refreshDetailsRoutesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public Builder addRefreshDetailsRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (refreshDetailsRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRefreshDetailsRoutesIsMutable();
        refreshDetailsRoutes_.add(index, value);
        onChanged();
      } else {
        refreshDetailsRoutesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public Builder addRefreshDetailsRoutes(
        com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (refreshDetailsRoutesBuilder_ == null) {
        ensureRefreshDetailsRoutesIsMutable();
        refreshDetailsRoutes_.add(builderForValue.build());
        onChanged();
      } else {
        refreshDetailsRoutesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public Builder addRefreshDetailsRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (refreshDetailsRoutesBuilder_ == null) {
        ensureRefreshDetailsRoutesIsMutable();
        refreshDetailsRoutes_.add(index, builderForValue.build());
        onChanged();
      } else {
        refreshDetailsRoutesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public Builder addAllRefreshDetailsRoutes(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentRoute> values) {
      if (refreshDetailsRoutesBuilder_ == null) {
        ensureRefreshDetailsRoutesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, refreshDetailsRoutes_);
        onChanged();
      } else {
        refreshDetailsRoutesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public Builder clearRefreshDetailsRoutes() {
      if (refreshDetailsRoutesBuilder_ == null) {
        refreshDetailsRoutes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        refreshDetailsRoutesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public Builder removeRefreshDetailsRoutes(int index) {
      if (refreshDetailsRoutesBuilder_ == null) {
        ensureRefreshDetailsRoutesIsMutable();
        refreshDetailsRoutes_.remove(index);
        onChanged();
      } else {
        refreshDetailsRoutesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder getRefreshDetailsRoutesBuilder(
        int index) {
      return getRefreshDetailsRoutesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRouteOrBuilder getRefreshDetailsRoutesOrBuilder(
        int index) {
      if (refreshDetailsRoutesBuilder_ == null) {
        return refreshDetailsRoutes_.get(index);
      } else {
        return refreshDetailsRoutesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        getRefreshDetailsRoutesOrBuilderList() {
      if (refreshDetailsRoutesBuilder_ != null) {
        return refreshDetailsRoutesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(refreshDetailsRoutes_);
      }
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder addRefreshDetailsRoutesBuilder() {
      return getRefreshDetailsRoutesFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.ShipmentRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder addRefreshDetailsRoutesBuilder(
        int index) {
      return getRefreshDetailsRoutesFieldBuilder()
          .addBuilder(index, com.google.cloud.optimization.v1.ShipmentRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If non-empty, the given routes will be refreshed, without modifying their
     * underlying sequence of visits or travel times: only other details will be
     * updated. This does not solve the model.
     * As of 2020/11, this only populates the polylines of non-empty routes and
     * requires that `populate_polylines` is true.
     * The `route_polyline` fields of the passed-in routes may be inconsistent
     * with route `transitions`.
     * This field must not be used together with `injected_first_solution_routes`
     * or `injected_solution_constraint`.
     * `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
     * Polylines are still populated between all visits in all non-empty routes
     * regardless of whether the related shipments or vehicles are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute refresh_details_routes = 9;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Builder>
        getRefreshDetailsRoutesBuilderList() {
      return getRefreshDetailsRoutesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute,
            com.google.cloud.optimization.v1.ShipmentRoute.Builder,
            com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        getRefreshDetailsRoutesFieldBuilder() {
      if (refreshDetailsRoutesBuilder_ == null) {
        refreshDetailsRoutesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentRoute,
                com.google.cloud.optimization.v1.ShipmentRoute.Builder,
                com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>(
                refreshDetailsRoutes_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        refreshDetailsRoutes_ = null;
      }
      return refreshDetailsRoutesBuilder_;
    }

    private boolean interpretInjectedSolutionsUsingLabels_;
    /**
     *
     *
     * <pre>
     * If true:
     *   * uses [ShipmentRoute.vehicle_label][google.cloud.optimization.v1.ShipmentRoute.vehicle_label] instead of `vehicle_index` to
     *     match routes in an injected solution with vehicles in the request;
     *     reuses the mapping of original [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index] to new
     *     [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index] to update
     *     [ConstraintRelaxation.vehicle_indices][google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.vehicle_indices]
     *     if non-empty, but the mapping must be unambiguous (i.e., multiple
     *     `ShipmentRoute`s must not share the same original `vehicle_index`).
     *   * uses [ShipmentRoute.Visit.shipment_label][google.cloud.optimization.v1.ShipmentRoute.Visit.shipment_label] instead of `shipment_index`
     *     to match visits in an injected solution with shipments in the request;
     *   * uses [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] instead of [SkippedShipment.index][google.cloud.optimization.v1.SkippedShipment.index] to
     *     match skipped shipments in the injected solution with request
     *     shipments.
     * This interpretation applies to the `injected_first_solution_routes`,
     * `injected_solution_constraint`, and `refresh_details_routes` fields.
     * It can be used when shipment or vehicle indices in the request have
     * changed since the solution was created, perhaps because shipments or
     * vehicles have been removed from or added to the request.
     * If true, labels in the following categories must appear at most once in
     * their category:
     *   * [Vehicle.label][google.cloud.optimization.v1.Vehicle.label] in the request;
     *   * [Shipment.label][google.cloud.optimization.v1.Shipment.label] in the request;
     *   * [ShipmentRoute.vehicle_label][google.cloud.optimization.v1.ShipmentRoute.vehicle_label] in the injected solution;
     *   * [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] and [ShipmentRoute.Visit.shipment_label][google.cloud.optimization.v1.ShipmentRoute.Visit.shipment_label] in
     *     the injected solution (except pickup/delivery visit pairs, whose
     *     `shipment_label` must appear twice).
     * If a `vehicle_label` in the injected solution does not correspond to a
     * request vehicle, the corresponding route is removed from the solution
     * along with its visits. If a `shipment_label` in the injected solution does
     * not correspond to a request shipment, the corresponding visit is removed
     * from the solution. If a [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] in the injected solution
     * does not correspond to a request shipment, the `SkippedShipment` is removed
     * from the solution.
     * Removing route visits or entire routes from an injected solution may
     * have an effect on the implied constraints, which may lead to change in
     * solution, validation errors, or infeasibility.
     * NOTE: The caller must ensure that each [Vehicle.label][google.cloud.optimization.v1.Vehicle.label]
     * (resp. [Shipment.label][google.cloud.optimization.v1.Shipment.label]) uniquely identifies a vehicle (resp. shipment)
     * entity used across the two relevant requests: the past request that
     * produced the `OptimizeToursResponse` used in the injected solution and the
     * current request that includes the injected solution. The uniqueness checks
     * described above are not enough to guarantee this requirement.
     * </pre>
     *
     * <code>bool interpret_injected_solutions_using_labels = 10;</code>
     *
     * @return The interpretInjectedSolutionsUsingLabels.
     */
    @java.lang.Override
    public boolean getInterpretInjectedSolutionsUsingLabels() {
      return interpretInjectedSolutionsUsingLabels_;
    }
    /**
     *
     *
     * <pre>
     * If true:
     *   * uses [ShipmentRoute.vehicle_label][google.cloud.optimization.v1.ShipmentRoute.vehicle_label] instead of `vehicle_index` to
     *     match routes in an injected solution with vehicles in the request;
     *     reuses the mapping of original [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index] to new
     *     [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index] to update
     *     [ConstraintRelaxation.vehicle_indices][google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.vehicle_indices]
     *     if non-empty, but the mapping must be unambiguous (i.e., multiple
     *     `ShipmentRoute`s must not share the same original `vehicle_index`).
     *   * uses [ShipmentRoute.Visit.shipment_label][google.cloud.optimization.v1.ShipmentRoute.Visit.shipment_label] instead of `shipment_index`
     *     to match visits in an injected solution with shipments in the request;
     *   * uses [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] instead of [SkippedShipment.index][google.cloud.optimization.v1.SkippedShipment.index] to
     *     match skipped shipments in the injected solution with request
     *     shipments.
     * This interpretation applies to the `injected_first_solution_routes`,
     * `injected_solution_constraint`, and `refresh_details_routes` fields.
     * It can be used when shipment or vehicle indices in the request have
     * changed since the solution was created, perhaps because shipments or
     * vehicles have been removed from or added to the request.
     * If true, labels in the following categories must appear at most once in
     * their category:
     *   * [Vehicle.label][google.cloud.optimization.v1.Vehicle.label] in the request;
     *   * [Shipment.label][google.cloud.optimization.v1.Shipment.label] in the request;
     *   * [ShipmentRoute.vehicle_label][google.cloud.optimization.v1.ShipmentRoute.vehicle_label] in the injected solution;
     *   * [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] and [ShipmentRoute.Visit.shipment_label][google.cloud.optimization.v1.ShipmentRoute.Visit.shipment_label] in
     *     the injected solution (except pickup/delivery visit pairs, whose
     *     `shipment_label` must appear twice).
     * If a `vehicle_label` in the injected solution does not correspond to a
     * request vehicle, the corresponding route is removed from the solution
     * along with its visits. If a `shipment_label` in the injected solution does
     * not correspond to a request shipment, the corresponding visit is removed
     * from the solution. If a [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] in the injected solution
     * does not correspond to a request shipment, the `SkippedShipment` is removed
     * from the solution.
     * Removing route visits or entire routes from an injected solution may
     * have an effect on the implied constraints, which may lead to change in
     * solution, validation errors, or infeasibility.
     * NOTE: The caller must ensure that each [Vehicle.label][google.cloud.optimization.v1.Vehicle.label]
     * (resp. [Shipment.label][google.cloud.optimization.v1.Shipment.label]) uniquely identifies a vehicle (resp. shipment)
     * entity used across the two relevant requests: the past request that
     * produced the `OptimizeToursResponse` used in the injected solution and the
     * current request that includes the injected solution. The uniqueness checks
     * described above are not enough to guarantee this requirement.
     * </pre>
     *
     * <code>bool interpret_injected_solutions_using_labels = 10;</code>
     *
     * @param value The interpretInjectedSolutionsUsingLabels to set.
     * @return This builder for chaining.
     */
    public Builder setInterpretInjectedSolutionsUsingLabels(boolean value) {

      interpretInjectedSolutionsUsingLabels_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true:
     *   * uses [ShipmentRoute.vehicle_label][google.cloud.optimization.v1.ShipmentRoute.vehicle_label] instead of `vehicle_index` to
     *     match routes in an injected solution with vehicles in the request;
     *     reuses the mapping of original [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index] to new
     *     [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index] to update
     *     [ConstraintRelaxation.vehicle_indices][google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.vehicle_indices]
     *     if non-empty, but the mapping must be unambiguous (i.e., multiple
     *     `ShipmentRoute`s must not share the same original `vehicle_index`).
     *   * uses [ShipmentRoute.Visit.shipment_label][google.cloud.optimization.v1.ShipmentRoute.Visit.shipment_label] instead of `shipment_index`
     *     to match visits in an injected solution with shipments in the request;
     *   * uses [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] instead of [SkippedShipment.index][google.cloud.optimization.v1.SkippedShipment.index] to
     *     match skipped shipments in the injected solution with request
     *     shipments.
     * This interpretation applies to the `injected_first_solution_routes`,
     * `injected_solution_constraint`, and `refresh_details_routes` fields.
     * It can be used when shipment or vehicle indices in the request have
     * changed since the solution was created, perhaps because shipments or
     * vehicles have been removed from or added to the request.
     * If true, labels in the following categories must appear at most once in
     * their category:
     *   * [Vehicle.label][google.cloud.optimization.v1.Vehicle.label] in the request;
     *   * [Shipment.label][google.cloud.optimization.v1.Shipment.label] in the request;
     *   * [ShipmentRoute.vehicle_label][google.cloud.optimization.v1.ShipmentRoute.vehicle_label] in the injected solution;
     *   * [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] and [ShipmentRoute.Visit.shipment_label][google.cloud.optimization.v1.ShipmentRoute.Visit.shipment_label] in
     *     the injected solution (except pickup/delivery visit pairs, whose
     *     `shipment_label` must appear twice).
     * If a `vehicle_label` in the injected solution does not correspond to a
     * request vehicle, the corresponding route is removed from the solution
     * along with its visits. If a `shipment_label` in the injected solution does
     * not correspond to a request shipment, the corresponding visit is removed
     * from the solution. If a [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] in the injected solution
     * does not correspond to a request shipment, the `SkippedShipment` is removed
     * from the solution.
     * Removing route visits or entire routes from an injected solution may
     * have an effect on the implied constraints, which may lead to change in
     * solution, validation errors, or infeasibility.
     * NOTE: The caller must ensure that each [Vehicle.label][google.cloud.optimization.v1.Vehicle.label]
     * (resp. [Shipment.label][google.cloud.optimization.v1.Shipment.label]) uniquely identifies a vehicle (resp. shipment)
     * entity used across the two relevant requests: the past request that
     * produced the `OptimizeToursResponse` used in the injected solution and the
     * current request that includes the injected solution. The uniqueness checks
     * described above are not enough to guarantee this requirement.
     * </pre>
     *
     * <code>bool interpret_injected_solutions_using_labels = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterpretInjectedSolutionsUsingLabels() {

      interpretInjectedSolutionsUsingLabels_ = false;
      onChanged();
      return this;
    }

    private boolean considerRoadTraffic_;
    /**
     *
     *
     * <pre>
     * Consider traffic estimation in calculating `ShipmentRoute` fields
     * [Transition.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration],
     * [Visit.start_time][google.cloud.optimization.v1.ShipmentRoute.Visit.start_time],
     * and `vehicle_end_time`; in setting the
     * [ShipmentRoute.has_traffic_infeasibilities][google.cloud.optimization.v1.ShipmentRoute.has_traffic_infeasibilities] field, and in calculating the
     * [OptimizeToursResponse.total_cost][google.cloud.optimization.v1.OptimizeToursResponse.total_cost] field.
     * </pre>
     *
     * <code>bool consider_road_traffic = 11;</code>
     *
     * @return The considerRoadTraffic.
     */
    @java.lang.Override
    public boolean getConsiderRoadTraffic() {
      return considerRoadTraffic_;
    }
    /**
     *
     *
     * <pre>
     * Consider traffic estimation in calculating `ShipmentRoute` fields
     * [Transition.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration],
     * [Visit.start_time][google.cloud.optimization.v1.ShipmentRoute.Visit.start_time],
     * and `vehicle_end_time`; in setting the
     * [ShipmentRoute.has_traffic_infeasibilities][google.cloud.optimization.v1.ShipmentRoute.has_traffic_infeasibilities] field, and in calculating the
     * [OptimizeToursResponse.total_cost][google.cloud.optimization.v1.OptimizeToursResponse.total_cost] field.
     * </pre>
     *
     * <code>bool consider_road_traffic = 11;</code>
     *
     * @param value The considerRoadTraffic to set.
     * @return This builder for chaining.
     */
    public Builder setConsiderRoadTraffic(boolean value) {

      considerRoadTraffic_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Consider traffic estimation in calculating `ShipmentRoute` fields
     * [Transition.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration],
     * [Visit.start_time][google.cloud.optimization.v1.ShipmentRoute.Visit.start_time],
     * and `vehicle_end_time`; in setting the
     * [ShipmentRoute.has_traffic_infeasibilities][google.cloud.optimization.v1.ShipmentRoute.has_traffic_infeasibilities] field, and in calculating the
     * [OptimizeToursResponse.total_cost][google.cloud.optimization.v1.OptimizeToursResponse.total_cost] field.
     * </pre>
     *
     * <code>bool consider_road_traffic = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConsiderRoadTraffic() {

      considerRoadTraffic_ = false;
      onChanged();
      return this;
    }

    private boolean populatePolylines_;
    /**
     *
     *
     * <pre>
     * If true, polylines will be populated in response `ShipmentRoute`s.
     * </pre>
     *
     * <code>bool populate_polylines = 12;</code>
     *
     * @return The populatePolylines.
     */
    @java.lang.Override
    public boolean getPopulatePolylines() {
      return populatePolylines_;
    }
    /**
     *
     *
     * <pre>
     * If true, polylines will be populated in response `ShipmentRoute`s.
     * </pre>
     *
     * <code>bool populate_polylines = 12;</code>
     *
     * @param value The populatePolylines to set.
     * @return This builder for chaining.
     */
    public Builder setPopulatePolylines(boolean value) {

      populatePolylines_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, polylines will be populated in response `ShipmentRoute`s.
     * </pre>
     *
     * <code>bool populate_polylines = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPopulatePolylines() {

      populatePolylines_ = false;
      onChanged();
      return this;
    }

    private boolean populateTransitionPolylines_;
    /**
     *
     *
     * <pre>
     * If true, polylines will be populated in response
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions].
     * Note that in this case, the polylines will also be populated in the
     * deprecated `travel_steps`.
     * </pre>
     *
     * <code>bool populate_transition_polylines = 13;</code>
     *
     * @return The populateTransitionPolylines.
     */
    @java.lang.Override
    public boolean getPopulateTransitionPolylines() {
      return populateTransitionPolylines_;
    }
    /**
     *
     *
     * <pre>
     * If true, polylines will be populated in response
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions].
     * Note that in this case, the polylines will also be populated in the
     * deprecated `travel_steps`.
     * </pre>
     *
     * <code>bool populate_transition_polylines = 13;</code>
     *
     * @param value The populateTransitionPolylines to set.
     * @return This builder for chaining.
     */
    public Builder setPopulateTransitionPolylines(boolean value) {

      populateTransitionPolylines_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, polylines will be populated in response
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions].
     * Note that in this case, the polylines will also be populated in the
     * deprecated `travel_steps`.
     * </pre>
     *
     * <code>bool populate_transition_polylines = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPopulateTransitionPolylines() {

      populateTransitionPolylines_ = false;
      onChanged();
      return this;
    }

    private boolean allowLargeDeadlineDespiteInterruptionRisk_;
    /**
     *
     *
     * <pre>
     * If this is set, then the request can have a deadline
     * (see https://grpc.io/blog/deadlines) of up to 60 minutes.
     * Otherwise, the maximum deadline is only 30 minutes.
     * Note that long-lived requests have a significantly larger (but still small)
     * risk of interruption.
     * </pre>
     *
     * <code>bool allow_large_deadline_despite_interruption_risk = 14;</code>
     *
     * @return The allowLargeDeadlineDespiteInterruptionRisk.
     */
    @java.lang.Override
    public boolean getAllowLargeDeadlineDespiteInterruptionRisk() {
      return allowLargeDeadlineDespiteInterruptionRisk_;
    }
    /**
     *
     *
     * <pre>
     * If this is set, then the request can have a deadline
     * (see https://grpc.io/blog/deadlines) of up to 60 minutes.
     * Otherwise, the maximum deadline is only 30 minutes.
     * Note that long-lived requests have a significantly larger (but still small)
     * risk of interruption.
     * </pre>
     *
     * <code>bool allow_large_deadline_despite_interruption_risk = 14;</code>
     *
     * @param value The allowLargeDeadlineDespiteInterruptionRisk to set.
     * @return This builder for chaining.
     */
    public Builder setAllowLargeDeadlineDespiteInterruptionRisk(boolean value) {

      allowLargeDeadlineDespiteInterruptionRisk_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this is set, then the request can have a deadline
     * (see https://grpc.io/blog/deadlines) of up to 60 minutes.
     * Otherwise, the maximum deadline is only 30 minutes.
     * Note that long-lived requests have a significantly larger (but still small)
     * risk of interruption.
     * </pre>
     *
     * <code>bool allow_large_deadline_despite_interruption_risk = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowLargeDeadlineDespiteInterruptionRisk() {

      allowLargeDeadlineDespiteInterruptionRisk_ = false;
      onChanged();
      return this;
    }

    private boolean useGeodesicDistances_;
    /**
     *
     *
     * <pre>
     * If true, travel distances will be computed using geodesic distances instead
     * of Google Maps distances, and travel times will be computed using geodesic
     * distances with a speed defined by `geodesic_meters_per_second`.
     * </pre>
     *
     * <code>bool use_geodesic_distances = 15;</code>
     *
     * @return The useGeodesicDistances.
     */
    @java.lang.Override
    public boolean getUseGeodesicDistances() {
      return useGeodesicDistances_;
    }
    /**
     *
     *
     * <pre>
     * If true, travel distances will be computed using geodesic distances instead
     * of Google Maps distances, and travel times will be computed using geodesic
     * distances with a speed defined by `geodesic_meters_per_second`.
     * </pre>
     *
     * <code>bool use_geodesic_distances = 15;</code>
     *
     * @param value The useGeodesicDistances to set.
     * @return This builder for chaining.
     */
    public Builder setUseGeodesicDistances(boolean value) {

      useGeodesicDistances_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, travel distances will be computed using geodesic distances instead
     * of Google Maps distances, and travel times will be computed using geodesic
     * distances with a speed defined by `geodesic_meters_per_second`.
     * </pre>
     *
     * <code>bool use_geodesic_distances = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUseGeodesicDistances() {

      useGeodesicDistances_ = false;
      onChanged();
      return this;
    }

    private double geodesicMetersPerSecond_;
    /**
     *
     *
     * <pre>
     * When `use_geodesic_distances` is true, this field must be set and defines
     * the speed applied to compute travel times. Its value must be at least 1.0
     * meters/seconds.
     * </pre>
     *
     * <code>optional double geodesic_meters_per_second = 16;</code>
     *
     * @return Whether the geodesicMetersPerSecond field is set.
     */
    @java.lang.Override
    public boolean hasGeodesicMetersPerSecond() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * When `use_geodesic_distances` is true, this field must be set and defines
     * the speed applied to compute travel times. Its value must be at least 1.0
     * meters/seconds.
     * </pre>
     *
     * <code>optional double geodesic_meters_per_second = 16;</code>
     *
     * @return The geodesicMetersPerSecond.
     */
    @java.lang.Override
    public double getGeodesicMetersPerSecond() {
      return geodesicMetersPerSecond_;
    }
    /**
     *
     *
     * <pre>
     * When `use_geodesic_distances` is true, this field must be set and defines
     * the speed applied to compute travel times. Its value must be at least 1.0
     * meters/seconds.
     * </pre>
     *
     * <code>optional double geodesic_meters_per_second = 16;</code>
     *
     * @param value The geodesicMetersPerSecond to set.
     * @return This builder for chaining.
     */
    public Builder setGeodesicMetersPerSecond(double value) {
      bitField0_ |= 0x00000008;
      geodesicMetersPerSecond_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When `use_geodesic_distances` is true, this field must be set and defines
     * the speed applied to compute travel times. Its value must be at least 1.0
     * meters/seconds.
     * </pre>
     *
     * <code>optional double geodesic_meters_per_second = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeodesicMetersPerSecond() {
      bitField0_ = (bitField0_ & ~0x00000008);
      geodesicMetersPerSecond_ = 0D;
      onChanged();
      return this;
    }

    private java.lang.Object label_ = "";
    /**
     *
     *
     * <pre>
     * Label that may be used to identify this request, reported back in the
     * [OptimizeToursResponse.request_label][google.cloud.optimization.v1.OptimizeToursResponse.request_label].
     * </pre>
     *
     * <code>string label = 17;</code>
     *
     * @return The label.
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Label that may be used to identify this request, reported back in the
     * [OptimizeToursResponse.request_label][google.cloud.optimization.v1.OptimizeToursResponse.request_label].
     * </pre>
     *
     * <code>string label = 17;</code>
     *
     * @return The bytes for label.
     */
    public com.google.protobuf.ByteString getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Label that may be used to identify this request, reported back in the
     * [OptimizeToursResponse.request_label][google.cloud.optimization.v1.OptimizeToursResponse.request_label].
     * </pre>
     *
     * <code>string label = 17;</code>
     *
     * @param value The label to set.
     * @return This builder for chaining.
     */
    public Builder setLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      label_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label that may be used to identify this request, reported back in the
     * [OptimizeToursResponse.request_label][google.cloud.optimization.v1.OptimizeToursResponse.request_label].
     * </pre>
     *
     * <code>string label = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabel() {

      label_ = getDefaultInstance().getLabel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label that may be used to identify this request, reported back in the
     * [OptimizeToursResponse.request_label][google.cloud.optimization.v1.OptimizeToursResponse.request_label].
     * </pre>
     *
     * <code>string label = 17;</code>
     *
     * @param value The bytes for label to set.
     * @return This builder for chaining.
     */
    public Builder setLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      label_ = value;
      onChanged();
      return this;
    }

    private boolean populateTravelStepPolylines_;
    /**
     *
     *
     * <pre>
     * Deprecated: Use [OptimizeToursRequest.populate_transition_polylines][] instead.
     * If true, polylines will be populated in response
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]. Note that in this case, the polylines will
     * also be populated in the deprecated `travel_steps`.
     * </pre>
     *
     * <code>bool populate_travel_step_polylines = 20 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines
     *     is deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=327
     * @return The populateTravelStepPolylines.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getPopulateTravelStepPolylines() {
      return populateTravelStepPolylines_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [OptimizeToursRequest.populate_transition_polylines][] instead.
     * If true, polylines will be populated in response
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]. Note that in this case, the polylines will
     * also be populated in the deprecated `travel_steps`.
     * </pre>
     *
     * <code>bool populate_travel_step_polylines = 20 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines
     *     is deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=327
     * @param value The populateTravelStepPolylines to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setPopulateTravelStepPolylines(boolean value) {

      populateTravelStepPolylines_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [OptimizeToursRequest.populate_transition_polylines][] instead.
     * If true, polylines will be populated in response
     * [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]. Note that in this case, the polylines will
     * also be populated in the deprecated `travel_steps`.
     * </pre>
     *
     * <code>bool populate_travel_step_polylines = 20 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines
     *     is deprecated. See google/cloud/optimization/v1/fleet_routing.proto;l=327
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearPopulateTravelStepPolylines() {

      populateTravelStepPolylines_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.OptimizeToursRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.OptimizeToursRequest)
  private static final com.google.cloud.optimization.v1.OptimizeToursRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.OptimizeToursRequest();
  }

  public static com.google.cloud.optimization.v1.OptimizeToursRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OptimizeToursRequest> PARSER =
      new com.google.protobuf.AbstractParser<OptimizeToursRequest>() {
        @java.lang.Override
        public OptimizeToursRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OptimizeToursRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OptimizeToursRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.OptimizeToursRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
