/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Solution injected in the request including information about which visits
 * must be constrained and how they must be constrained.
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.InjectedSolutionConstraint}
 */
public final class InjectedSolutionConstraint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.InjectedSolutionConstraint)
    InjectedSolutionConstraintOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InjectedSolutionConstraint.newBuilder() to construct.
  private InjectedSolutionConstraint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InjectedSolutionConstraint() {
    routes_ = java.util.Collections.emptyList();
    skippedShipments_ = java.util.Collections.emptyList();
    constraintRelaxations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InjectedSolutionConstraint();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.class,
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.Builder.class);
  }

  public interface ConstraintRelaxationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * All the visit constraint relaxations that will apply to visits on
     * routes with vehicles in `vehicle_indices`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
     * </code>
     */
    java.util.List<
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation>
        getRelaxationsList();
    /**
     *
     *
     * <pre>
     * All the visit constraint relaxations that will apply to visits on
     * routes with vehicles in `vehicle_indices`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
     * </code>
     */
    com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation
        getRelaxations(int index);
    /**
     *
     *
     * <pre>
     * All the visit constraint relaxations that will apply to visits on
     * routes with vehicles in `vehicle_indices`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
     * </code>
     */
    int getRelaxationsCount();
    /**
     *
     *
     * <pre>
     * All the visit constraint relaxations that will apply to visits on
     * routes with vehicles in `vehicle_indices`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .RelaxationOrBuilder>
        getRelaxationsOrBuilderList();
    /**
     *
     *
     * <pre>
     * All the visit constraint relaxations that will apply to visits on
     * routes with vehicles in `vehicle_indices`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
     * </code>
     */
    com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
            .RelaxationOrBuilder
        getRelaxationsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Specifies the vehicle indices to which the visit constraint
     * `relaxations` apply. If empty, this is considered the default and the
     * `relaxations` apply to all vehicles that are not specified in other
     * `constraint_relaxations`. There can be at most one default, i.e., at
     * most one constraint relaxation field is allowed empty
     * `vehicle_indices`. A vehicle index can only be listed once, even within
     * several `constraint_relaxations`.
     * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
     * `interpret_injected_solutions_using_labels` is true (see `fields`
     * comment).
     * </pre>
     *
     * <code>repeated int32 vehicle_indices = 2;</code>
     *
     * @return A list containing the vehicleIndices.
     */
    java.util.List<java.lang.Integer> getVehicleIndicesList();
    /**
     *
     *
     * <pre>
     * Specifies the vehicle indices to which the visit constraint
     * `relaxations` apply. If empty, this is considered the default and the
     * `relaxations` apply to all vehicles that are not specified in other
     * `constraint_relaxations`. There can be at most one default, i.e., at
     * most one constraint relaxation field is allowed empty
     * `vehicle_indices`. A vehicle index can only be listed once, even within
     * several `constraint_relaxations`.
     * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
     * `interpret_injected_solutions_using_labels` is true (see `fields`
     * comment).
     * </pre>
     *
     * <code>repeated int32 vehicle_indices = 2;</code>
     *
     * @return The count of vehicleIndices.
     */
    int getVehicleIndicesCount();
    /**
     *
     *
     * <pre>
     * Specifies the vehicle indices to which the visit constraint
     * `relaxations` apply. If empty, this is considered the default and the
     * `relaxations` apply to all vehicles that are not specified in other
     * `constraint_relaxations`. There can be at most one default, i.e., at
     * most one constraint relaxation field is allowed empty
     * `vehicle_indices`. A vehicle index can only be listed once, even within
     * several `constraint_relaxations`.
     * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
     * `interpret_injected_solutions_using_labels` is true (see `fields`
     * comment).
     * </pre>
     *
     * <code>repeated int32 vehicle_indices = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The vehicleIndices at the given index.
     */
    int getVehicleIndices(int index);
  }
  /**
   *
   *
   * <pre>
   * For a group of vehicles, specifies at what threshold(s) constraints on
   * visits will be relaxed and to which level. Shipments listed in
   * the `skipped_shipment` field are constrained to be skipped; i.e., they
   * cannot be performed.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation}
   */
  public static final class ConstraintRelaxation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation)
      ConstraintRelaxationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConstraintRelaxation.newBuilder() to construct.
    private ConstraintRelaxation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConstraintRelaxation() {
      relaxations_ = java.util.Collections.emptyList();
      vehicleIndices_ = emptyIntList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConstraintRelaxation();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_ConstraintRelaxation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_ConstraintRelaxation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .class,
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Builder.class);
    }

    public interface RelaxationOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The constraint relaxation level that applies when the conditions
       * at or after `threshold_time` AND at least `threshold_visit_count` are
       * satified.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level level = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for level.
       */
      int getLevelValue();
      /**
       *
       *
       * <pre>
       * The constraint relaxation level that applies when the conditions
       * at or after `threshold_time` AND at least `threshold_visit_count` are
       * satified.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level level = 1;
       * </code>
       *
       * @return The level.
       */
      com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation
              .Level
          getLevel();

      /**
       *
       *
       * <pre>
       * The time at or after which the relaxation `level` may be applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
       *
       * @return Whether the thresholdTime field is set.
       */
      boolean hasThresholdTime();
      /**
       *
       *
       * <pre>
       * The time at or after which the relaxation `level` may be applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
       *
       * @return The thresholdTime.
       */
      com.google.protobuf.Timestamp getThresholdTime();
      /**
       *
       *
       * <pre>
       * The time at or after which the relaxation `level` may be applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
       */
      com.google.protobuf.TimestampOrBuilder getThresholdTimeOrBuilder();

      /**
       *
       *
       * <pre>
       * The number of visits at or after which the relaxation `level` may be
       * applied. If `threshold_visit_count` is 0 (or unset), the `level` may be
       * applied directly at the vehicle start.
       * If it is `route.visits_size() + 1`, the `level` may only be applied to
       * the vehicle end. If it is more than `route.visits_size() + 1`,
       * `level` is not applied at all for that route.
       * </pre>
       *
       * <code>int32 threshold_visit_count = 3;</code>
       *
       * @return The thresholdVisitCount.
       */
      int getThresholdVisitCount();
    }
    /**
     *
     *
     * <pre>
     * If `relaxations` is empty, the start time and sequence of all visits
     * on `routes` are fully constrained and no new visits may be inserted or
     * added to those routes. Also, a vehicle's start and end time in
     * `routes` is fully constrained, unless the vehicle is empty (i.e., has no
     * visits and has `used_if_route_is_empty` set to false in the model).
     * `relaxations(i).level` specifies the constraint relaxation level applied
     * to a visit #j that satisfies:
     *   * `route.visits(j).start_time &gt;= relaxations(i).threshold_time` AND
     *   * `j + 1 &gt;= relaxations(i).threshold_visit_count`
     * Similarly, the vehicle start is relaxed to `relaxations(i).level` if it
     * satisfies:
     *   * `vehicle_start_time &gt;= relaxations(i).threshold_time` AND
     *   * `relaxations(i).threshold_visit_count == 0`
     * and the vehicle end is relaxed to `relaxations(i).level` if it satisfies:
     *   * `vehicle_end_time &gt;= relaxations(i).threshold_time` AND
     *   * `route.visits_size() + 1 &gt;= relaxations(i).threshold_visit_count`
     * To apply a relaxation level if a visit meets the `threshold_visit_count`
     * OR the `threshold_time` add two `relaxations` with the same `level`:
     * one with only `threshold_visit_count` set and the other with only
     * `threshold_time` set. If a visit satisfies the conditions of multiple
     * `relaxations`, the most relaxed level applies. As a result, from the
     * vehicle start through the route visits in order to the vehicle end, the
     * relaxation level becomes more relaxed: i.e., the relaxation level is
     * non-decreasing as the route progresses.
     * The timing and sequence of route visits that do not satisfy the
     * threshold conditions of any `relaxations` are fully constrained
     * and no visits may be inserted into these sequences. Also, if a
     * vehicle start or end does not satisfy the conditions of any
     * relaxation the time is fixed, unless the vehicle is empty.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation}
     */
    public static final class Relaxation extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation)
        RelaxationOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Relaxation.newBuilder() to construct.
      private Relaxation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Relaxation() {
        level_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Relaxation();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .Relaxation.class,
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .Relaxation.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Expresses the different constraint relaxation levels, which are
       * applied for a visit and those that follow when it satifies the
       * threshold conditions.
       * The enumeration below is in order of increasing relaxation.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level}
       */
      public enum Level implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Implicit default relaxation level: no constraints are relaxed,
         * i.e., all visits are fully constrained.
         * This value must not be explicly used in `level`.
         * </pre>
         *
         * <code>LEVEL_UNSPECIFIED = 0;</code>
         */
        LEVEL_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Visit start times and vehicle start/end times will be relaxed, but
         * each visit remains bound to the same vehicle and the visit sequence
         * must be observed: no visit can be inserted between them or before
         * them.
         * </pre>
         *
         * <code>RELAX_VISIT_TIMES_AFTER_THRESHOLD = 1;</code>
         */
        RELAX_VISIT_TIMES_AFTER_THRESHOLD(1),
        /**
         *
         *
         * <pre>
         * Same as `RELAX_VISIT_TIMES_AFTER_THRESHOLD`, but the visit sequence
         * is also relaxed: visits remain simply bound to their vehicle.
         * </pre>
         *
         * <code>RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD = 2;</code>
         */
        RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD(2),
        /**
         *
         *
         * <pre>
         * Same as `RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD`, but the
         * vehicle is also relaxed: visits are completely free at or after the
         * threshold time and can potentially become unperformed.
         * </pre>
         *
         * <code>RELAX_ALL_AFTER_THRESHOLD = 3;</code>
         */
        RELAX_ALL_AFTER_THRESHOLD(3),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Implicit default relaxation level: no constraints are relaxed,
         * i.e., all visits are fully constrained.
         * This value must not be explicly used in `level`.
         * </pre>
         *
         * <code>LEVEL_UNSPECIFIED = 0;</code>
         */
        public static final int LEVEL_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Visit start times and vehicle start/end times will be relaxed, but
         * each visit remains bound to the same vehicle and the visit sequence
         * must be observed: no visit can be inserted between them or before
         * them.
         * </pre>
         *
         * <code>RELAX_VISIT_TIMES_AFTER_THRESHOLD = 1;</code>
         */
        public static final int RELAX_VISIT_TIMES_AFTER_THRESHOLD_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Same as `RELAX_VISIT_TIMES_AFTER_THRESHOLD`, but the visit sequence
         * is also relaxed: visits remain simply bound to their vehicle.
         * </pre>
         *
         * <code>RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD = 2;</code>
         */
        public static final int RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Same as `RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD`, but the
         * vehicle is also relaxed: visits are completely free at or after the
         * threshold time and can potentially become unperformed.
         * </pre>
         *
         * <code>RELAX_ALL_AFTER_THRESHOLD = 3;</code>
         */
        public static final int RELAX_ALL_AFTER_THRESHOLD_VALUE = 3;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Level valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Level forNumber(int value) {
          switch (value) {
            case 0:
              return LEVEL_UNSPECIFIED;
            case 1:
              return RELAX_VISIT_TIMES_AFTER_THRESHOLD;
            case 2:
              return RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD;
            case 3:
              return RELAX_ALL_AFTER_THRESHOLD;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Level> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<Level> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Level>() {
              public Level findValueByNumber(int number) {
                return Level.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final Level[] VALUES = values();

        public static Level valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Level(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level)
      }

      public static final int LEVEL_FIELD_NUMBER = 1;
      private int level_;
      /**
       *
       *
       * <pre>
       * The constraint relaxation level that applies when the conditions
       * at or after `threshold_time` AND at least `threshold_visit_count` are
       * satified.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level level = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for level.
       */
      @java.lang.Override
      public int getLevelValue() {
        return level_;
      }
      /**
       *
       *
       * <pre>
       * The constraint relaxation level that applies when the conditions
       * at or after `threshold_time` AND at least `threshold_visit_count` are
       * satified.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level level = 1;
       * </code>
       *
       * @return The level.
       */
      @java.lang.Override
      public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation.Level
          getLevel() {
        @SuppressWarnings("deprecation")
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation
                .Level
            result =
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .Relaxation.Level.valueOf(level_);
        return result == null
            ? com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation.Level.UNRECOGNIZED
            : result;
      }

      public static final int THRESHOLD_TIME_FIELD_NUMBER = 2;
      private com.google.protobuf.Timestamp thresholdTime_;
      /**
       *
       *
       * <pre>
       * The time at or after which the relaxation `level` may be applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
       *
       * @return Whether the thresholdTime field is set.
       */
      @java.lang.Override
      public boolean hasThresholdTime() {
        return thresholdTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * The time at or after which the relaxation `level` may be applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
       *
       * @return The thresholdTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getThresholdTime() {
        return thresholdTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : thresholdTime_;
      }
      /**
       *
       *
       * <pre>
       * The time at or after which the relaxation `level` may be applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getThresholdTimeOrBuilder() {
        return getThresholdTime();
      }

      public static final int THRESHOLD_VISIT_COUNT_FIELD_NUMBER = 3;
      private int thresholdVisitCount_;
      /**
       *
       *
       * <pre>
       * The number of visits at or after which the relaxation `level` may be
       * applied. If `threshold_visit_count` is 0 (or unset), the `level` may be
       * applied directly at the vehicle start.
       * If it is `route.visits_size() + 1`, the `level` may only be applied to
       * the vehicle end. If it is more than `route.visits_size() + 1`,
       * `level` is not applied at all for that route.
       * </pre>
       *
       * <code>int32 threshold_visit_count = 3;</code>
       *
       * @return The thresholdVisitCount.
       */
      @java.lang.Override
      public int getThresholdVisitCount() {
        return thresholdVisitCount_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (level_
            != com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation.Level.LEVEL_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, level_);
        }
        if (thresholdTime_ != null) {
          output.writeMessage(2, getThresholdTime());
        }
        if (thresholdVisitCount_ != 0) {
          output.writeInt32(3, thresholdVisitCount_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (level_
            != com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation.Level.LEVEL_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, level_);
        }
        if (thresholdTime_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getThresholdTime());
        }
        if (thresholdVisitCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, thresholdVisitCount_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation)) {
          return super.equals(obj);
        }
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation
            other =
                (com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                        .Relaxation)
                    obj;

        if (level_ != other.level_) return false;
        if (hasThresholdTime() != other.hasThresholdTime()) return false;
        if (hasThresholdTime()) {
          if (!getThresholdTime().equals(other.getThresholdTime())) return false;
        }
        if (getThresholdVisitCount() != other.getThresholdVisitCount()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LEVEL_FIELD_NUMBER;
        hash = (53 * hash) + level_;
        if (hasThresholdTime()) {
          hash = (37 * hash) + THRESHOLD_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getThresholdTime().hashCode();
        }
        hash = (37 * hash) + THRESHOLD_VISIT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getThresholdVisitCount();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * If `relaxations` is empty, the start time and sequence of all visits
       * on `routes` are fully constrained and no new visits may be inserted or
       * added to those routes. Also, a vehicle's start and end time in
       * `routes` is fully constrained, unless the vehicle is empty (i.e., has no
       * visits and has `used_if_route_is_empty` set to false in the model).
       * `relaxations(i).level` specifies the constraint relaxation level applied
       * to a visit #j that satisfies:
       *   * `route.visits(j).start_time &gt;= relaxations(i).threshold_time` AND
       *   * `j + 1 &gt;= relaxations(i).threshold_visit_count`
       * Similarly, the vehicle start is relaxed to `relaxations(i).level` if it
       * satisfies:
       *   * `vehicle_start_time &gt;= relaxations(i).threshold_time` AND
       *   * `relaxations(i).threshold_visit_count == 0`
       * and the vehicle end is relaxed to `relaxations(i).level` if it satisfies:
       *   * `vehicle_end_time &gt;= relaxations(i).threshold_time` AND
       *   * `route.visits_size() + 1 &gt;= relaxations(i).threshold_visit_count`
       * To apply a relaxation level if a visit meets the `threshold_visit_count`
       * OR the `threshold_time` add two `relaxations` with the same `level`:
       * one with only `threshold_visit_count` set and the other with only
       * `threshold_time` set. If a visit satisfies the conditions of multiple
       * `relaxations`, the most relaxed level applies. As a result, from the
       * vehicle start through the route visits in order to the vehicle end, the
       * relaxation level becomes more relaxed: i.e., the relaxation level is
       * non-decreasing as the route progresses.
       * The timing and sequence of route visits that do not satisfy the
       * threshold conditions of any `relaxations` are fully constrained
       * and no visits may be inserted into these sequences. Also, if a
       * vehicle start or end does not satisfy the conditions of any
       * relaxation the time is fixed, unless the vehicle is empty.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation)
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .RelaxationOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                      .Relaxation.class,
                  com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                      .Relaxation.Builder.class);
        }

        // Construct using
        // com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          level_ = 0;

          if (thresholdTimeBuilder_ == null) {
            thresholdTime_ = null;
          } else {
            thresholdTime_ = null;
            thresholdTimeBuilder_ = null;
          }
          thresholdVisitCount_ = 0;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.optimization.v1.FleetRoutingProto
              .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation
            getDefaultInstanceForType() {
          return com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation
            build() {
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation
            buildPartial() {
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation
              result =
                  new com.google.cloud.optimization.v1.InjectedSolutionConstraint
                      .ConstraintRelaxation.Relaxation(this);
          result.level_ = level_;
          if (thresholdTimeBuilder_ == null) {
            result.thresholdTime_ = thresholdTime_;
          } else {
            result.thresholdTime_ = thresholdTimeBuilder_.build();
          }
          result.thresholdVisitCount_ = thresholdVisitCount_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation) {
            return mergeFrom(
                (com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                        .Relaxation)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .Relaxation
                other) {
          if (other
              == com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation.getDefaultInstance()) return this;
          if (other.level_ != 0) {
            setLevelValue(other.getLevelValue());
          }
          if (other.hasThresholdTime()) {
            mergeThresholdTime(other.getThresholdTime());
          }
          if (other.getThresholdVisitCount() != 0) {
            setThresholdVisitCount(other.getThresholdVisitCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    level_ = input.readEnum();

                    break;
                  } // case 8
                case 18:
                  {
                    input.readMessage(
                        getThresholdTimeFieldBuilder().getBuilder(), extensionRegistry);

                    break;
                  } // case 18
                case 24:
                  {
                    thresholdVisitCount_ = input.readInt32();

                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int level_ = 0;
        /**
         *
         *
         * <pre>
         * The constraint relaxation level that applies when the conditions
         * at or after `threshold_time` AND at least `threshold_visit_count` are
         * satified.
         * </pre>
         *
         * <code>
         * .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level level = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for level.
         */
        @java.lang.Override
        public int getLevelValue() {
          return level_;
        }
        /**
         *
         *
         * <pre>
         * The constraint relaxation level that applies when the conditions
         * at or after `threshold_time` AND at least `threshold_visit_count` are
         * satified.
         * </pre>
         *
         * <code>
         * .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level level = 1;
         * </code>
         *
         * @param value The enum numeric value on the wire for level to set.
         * @return This builder for chaining.
         */
        public Builder setLevelValue(int value) {

          level_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The constraint relaxation level that applies when the conditions
         * at or after `threshold_time` AND at least `threshold_visit_count` are
         * satified.
         * </pre>
         *
         * <code>
         * .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level level = 1;
         * </code>
         *
         * @return The level.
         */
        @java.lang.Override
        public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation.Level
            getLevel() {
          @SuppressWarnings("deprecation")
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation.Level
              result =
                  com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                      .Relaxation.Level.valueOf(level_);
          return result == null
              ? com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation.Level.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * The constraint relaxation level that applies when the conditions
         * at or after `threshold_time` AND at least `threshold_visit_count` are
         * satified.
         * </pre>
         *
         * <code>
         * .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level level = 1;
         * </code>
         *
         * @param value The level to set.
         * @return This builder for chaining.
         */
        public Builder setLevel(
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .Relaxation.Level
                value) {
          if (value == null) {
            throw new NullPointerException();
          }

          level_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The constraint relaxation level that applies when the conditions
         * at or after `threshold_time` AND at least `threshold_visit_count` are
         * satified.
         * </pre>
         *
         * <code>
         * .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level level = 1;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLevel() {

          level_ = 0;
          onChanged();
          return this;
        }

        private com.google.protobuf.Timestamp thresholdTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            thresholdTimeBuilder_;
        /**
         *
         *
         * <pre>
         * The time at or after which the relaxation `level` may be applied.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
         *
         * @return Whether the thresholdTime field is set.
         */
        public boolean hasThresholdTime() {
          return thresholdTimeBuilder_ != null || thresholdTime_ != null;
        }
        /**
         *
         *
         * <pre>
         * The time at or after which the relaxation `level` may be applied.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
         *
         * @return The thresholdTime.
         */
        public com.google.protobuf.Timestamp getThresholdTime() {
          if (thresholdTimeBuilder_ == null) {
            return thresholdTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : thresholdTime_;
          } else {
            return thresholdTimeBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The time at or after which the relaxation `level` may be applied.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
         */
        public Builder setThresholdTime(com.google.protobuf.Timestamp value) {
          if (thresholdTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            thresholdTime_ = value;
            onChanged();
          } else {
            thresholdTimeBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The time at or after which the relaxation `level` may be applied.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
         */
        public Builder setThresholdTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (thresholdTimeBuilder_ == null) {
            thresholdTime_ = builderForValue.build();
            onChanged();
          } else {
            thresholdTimeBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The time at or after which the relaxation `level` may be applied.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
         */
        public Builder mergeThresholdTime(com.google.protobuf.Timestamp value) {
          if (thresholdTimeBuilder_ == null) {
            if (thresholdTime_ != null) {
              thresholdTime_ =
                  com.google.protobuf.Timestamp.newBuilder(thresholdTime_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              thresholdTime_ = value;
            }
            onChanged();
          } else {
            thresholdTimeBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The time at or after which the relaxation `level` may be applied.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
         */
        public Builder clearThresholdTime() {
          if (thresholdTimeBuilder_ == null) {
            thresholdTime_ = null;
            onChanged();
          } else {
            thresholdTime_ = null;
            thresholdTimeBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The time at or after which the relaxation `level` may be applied.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
         */
        public com.google.protobuf.Timestamp.Builder getThresholdTimeBuilder() {

          onChanged();
          return getThresholdTimeFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The time at or after which the relaxation `level` may be applied.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
         */
        public com.google.protobuf.TimestampOrBuilder getThresholdTimeOrBuilder() {
          if (thresholdTimeBuilder_ != null) {
            return thresholdTimeBuilder_.getMessageOrBuilder();
          } else {
            return thresholdTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : thresholdTime_;
          }
        }
        /**
         *
         *
         * <pre>
         * The time at or after which the relaxation `level` may be applied.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp threshold_time = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getThresholdTimeFieldBuilder() {
          if (thresholdTimeBuilder_ == null) {
            thresholdTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getThresholdTime(), getParentForChildren(), isClean());
            thresholdTime_ = null;
          }
          return thresholdTimeBuilder_;
        }

        private int thresholdVisitCount_;
        /**
         *
         *
         * <pre>
         * The number of visits at or after which the relaxation `level` may be
         * applied. If `threshold_visit_count` is 0 (or unset), the `level` may be
         * applied directly at the vehicle start.
         * If it is `route.visits_size() + 1`, the `level` may only be applied to
         * the vehicle end. If it is more than `route.visits_size() + 1`,
         * `level` is not applied at all for that route.
         * </pre>
         *
         * <code>int32 threshold_visit_count = 3;</code>
         *
         * @return The thresholdVisitCount.
         */
        @java.lang.Override
        public int getThresholdVisitCount() {
          return thresholdVisitCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of visits at or after which the relaxation `level` may be
         * applied. If `threshold_visit_count` is 0 (or unset), the `level` may be
         * applied directly at the vehicle start.
         * If it is `route.visits_size() + 1`, the `level` may only be applied to
         * the vehicle end. If it is more than `route.visits_size() + 1`,
         * `level` is not applied at all for that route.
         * </pre>
         *
         * <code>int32 threshold_visit_count = 3;</code>
         *
         * @param value The thresholdVisitCount to set.
         * @return This builder for chaining.
         */
        public Builder setThresholdVisitCount(int value) {

          thresholdVisitCount_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of visits at or after which the relaxation `level` may be
         * applied. If `threshold_visit_count` is 0 (or unset), the `level` may be
         * applied directly at the vehicle start.
         * If it is `route.visits_size() + 1`, the `level` may only be applied to
         * the vehicle end. If it is more than `route.visits_size() + 1`,
         * `level` is not applied at all for that route.
         * </pre>
         *
         * <code>int32 threshold_visit_count = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearThresholdVisitCount() {

          thresholdVisitCount_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation)
      private static final com.google.cloud.optimization.v1.InjectedSolutionConstraint
              .ConstraintRelaxation.Relaxation
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation();
      }

      public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Relaxation> PARSER =
          new com.google.protobuf.AbstractParser<Relaxation>() {
            @java.lang.Override
            public Relaxation parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Relaxation> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Relaxation> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int RELAXATIONS_FIELD_NUMBER = 1;
    private java.util.List<
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation>
        relaxations_;
    /**
     *
     *
     * <pre>
     * All the visit constraint relaxations that will apply to visits on
     * routes with vehicles in `vehicle_indices`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Relaxation>
        getRelaxationsList() {
      return relaxations_;
    }
    /**
     *
     *
     * <pre>
     * All the visit constraint relaxations that will apply to visits on
     * routes with vehicles in `vehicle_indices`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .RelaxationOrBuilder>
        getRelaxationsOrBuilderList() {
      return relaxations_;
    }
    /**
     *
     *
     * <pre>
     * All the visit constraint relaxations that will apply to visits on
     * routes with vehicles in `vehicle_indices`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
     * </code>
     */
    @java.lang.Override
    public int getRelaxationsCount() {
      return relaxations_.size();
    }
    /**
     *
     *
     * <pre>
     * All the visit constraint relaxations that will apply to visits on
     * routes with vehicles in `vehicle_indices`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
            .Relaxation
        getRelaxations(int index) {
      return relaxations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * All the visit constraint relaxations that will apply to visits on
     * routes with vehicles in `vehicle_indices`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
            .RelaxationOrBuilder
        getRelaxationsOrBuilder(int index) {
      return relaxations_.get(index);
    }

    public static final int VEHICLE_INDICES_FIELD_NUMBER = 2;
    private com.google.protobuf.Internal.IntList vehicleIndices_;
    /**
     *
     *
     * <pre>
     * Specifies the vehicle indices to which the visit constraint
     * `relaxations` apply. If empty, this is considered the default and the
     * `relaxations` apply to all vehicles that are not specified in other
     * `constraint_relaxations`. There can be at most one default, i.e., at
     * most one constraint relaxation field is allowed empty
     * `vehicle_indices`. A vehicle index can only be listed once, even within
     * several `constraint_relaxations`.
     * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
     * `interpret_injected_solutions_using_labels` is true (see `fields`
     * comment).
     * </pre>
     *
     * <code>repeated int32 vehicle_indices = 2;</code>
     *
     * @return A list containing the vehicleIndices.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getVehicleIndicesList() {
      return vehicleIndices_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the vehicle indices to which the visit constraint
     * `relaxations` apply. If empty, this is considered the default and the
     * `relaxations` apply to all vehicles that are not specified in other
     * `constraint_relaxations`. There can be at most one default, i.e., at
     * most one constraint relaxation field is allowed empty
     * `vehicle_indices`. A vehicle index can only be listed once, even within
     * several `constraint_relaxations`.
     * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
     * `interpret_injected_solutions_using_labels` is true (see `fields`
     * comment).
     * </pre>
     *
     * <code>repeated int32 vehicle_indices = 2;</code>
     *
     * @return The count of vehicleIndices.
     */
    public int getVehicleIndicesCount() {
      return vehicleIndices_.size();
    }
    /**
     *
     *
     * <pre>
     * Specifies the vehicle indices to which the visit constraint
     * `relaxations` apply. If empty, this is considered the default and the
     * `relaxations` apply to all vehicles that are not specified in other
     * `constraint_relaxations`. There can be at most one default, i.e., at
     * most one constraint relaxation field is allowed empty
     * `vehicle_indices`. A vehicle index can only be listed once, even within
     * several `constraint_relaxations`.
     * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
     * `interpret_injected_solutions_using_labels` is true (see `fields`
     * comment).
     * </pre>
     *
     * <code>repeated int32 vehicle_indices = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The vehicleIndices at the given index.
     */
    public int getVehicleIndices(int index) {
      return vehicleIndices_.getInt(index);
    }

    private int vehicleIndicesMemoizedSerializedSize = -1;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < relaxations_.size(); i++) {
        output.writeMessage(1, relaxations_.get(i));
      }
      if (getVehicleIndicesList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(vehicleIndicesMemoizedSerializedSize);
      }
      for (int i = 0; i < vehicleIndices_.size(); i++) {
        output.writeInt32NoTag(vehicleIndices_.getInt(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < relaxations_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, relaxations_.get(i));
      }
      {
        int dataSize = 0;
        for (int i = 0; i < vehicleIndices_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                  vehicleIndices_.getInt(i));
        }
        size += dataSize;
        if (!getVehicleIndicesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        vehicleIndicesMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation other =
          (com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation) obj;

      if (!getRelaxationsList().equals(other.getRelaxationsList())) return false;
      if (!getVehicleIndicesList().equals(other.getVehicleIndicesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getRelaxationsCount() > 0) {
        hash = (37 * hash) + RELAXATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getRelaxationsList().hashCode();
      }
      if (getVehicleIndicesCount() > 0) {
        hash = (37 * hash) + VEHICLE_INDICES_FIELD_NUMBER;
        hash = (53 * hash) + getVehicleIndicesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * For a group of vehicles, specifies at what threshold(s) constraints on
     * visits will be relaxed and to which level. Shipments listed in
     * the `skipped_shipment` field are constrained to be skipped; i.e., they
     * cannot be performed.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation)
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_ConstraintRelaxation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_ConstraintRelaxation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .class,
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (relaxationsBuilder_ == null) {
          relaxations_ = java.util.Collections.emptyList();
        } else {
          relaxations_ = null;
          relaxationsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        vehicleIndices_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_ConstraintRelaxation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
          getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
          build() {
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
          buildPartial() {
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation result =
            new com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation(
                this);
        int from_bitField0_ = bitField0_;
        if (relaxationsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            relaxations_ = java.util.Collections.unmodifiableList(relaxations_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.relaxations_ = relaxations_;
        } else {
          result.relaxations_ = relaxationsBuilder_.build();
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          vehicleIndices_.makeImmutable();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.vehicleIndices_ = vehicleIndices_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation) {
          return mergeFrom(
              (com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation other) {
        if (other
            == com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .getDefaultInstance()) return this;
        if (relaxationsBuilder_ == null) {
          if (!other.relaxations_.isEmpty()) {
            if (relaxations_.isEmpty()) {
              relaxations_ = other.relaxations_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureRelaxationsIsMutable();
              relaxations_.addAll(other.relaxations_);
            }
            onChanged();
          }
        } else {
          if (!other.relaxations_.isEmpty()) {
            if (relaxationsBuilder_.isEmpty()) {
              relaxationsBuilder_.dispose();
              relaxationsBuilder_ = null;
              relaxations_ = other.relaxations_;
              bitField0_ = (bitField0_ & ~0x00000001);
              relaxationsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getRelaxationsFieldBuilder()
                      : null;
            } else {
              relaxationsBuilder_.addAllMessages(other.relaxations_);
            }
          }
        }
        if (!other.vehicleIndices_.isEmpty()) {
          if (vehicleIndices_.isEmpty()) {
            vehicleIndices_ = other.vehicleIndices_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureVehicleIndicesIsMutable();
            vehicleIndices_.addAll(other.vehicleIndices_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                          .Relaxation
                      m =
                          input.readMessage(
                              com.google.cloud.optimization.v1.InjectedSolutionConstraint
                                  .ConstraintRelaxation.Relaxation.parser(),
                              extensionRegistry);
                  if (relaxationsBuilder_ == null) {
                    ensureRelaxationsIsMutable();
                    relaxations_.add(m);
                  } else {
                    relaxationsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 16:
                {
                  int v = input.readInt32();
                  ensureVehicleIndicesIsMutable();
                  vehicleIndices_.addInt(v);
                  break;
                } // case 16
              case 18:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  ensureVehicleIndicesIsMutable();
                  while (input.getBytesUntilLimit() > 0) {
                    vehicleIndices_.addInt(input.readInt32());
                  }
                  input.popLimit(limit);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation>
          relaxations_ = java.util.Collections.emptyList();

      private void ensureRelaxationsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          relaxations_ =
              new java.util.ArrayList<
                  com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                      .Relaxation>(relaxations_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation,
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation.Builder,
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .RelaxationOrBuilder>
          relaxationsBuilder_;

      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation>
          getRelaxationsList() {
        if (relaxationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(relaxations_);
        } else {
          return relaxationsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public int getRelaxationsCount() {
        if (relaxationsBuilder_ == null) {
          return relaxations_.size();
        } else {
          return relaxationsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation
          getRelaxations(int index) {
        if (relaxationsBuilder_ == null) {
          return relaxations_.get(index);
        } else {
          return relaxationsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public Builder setRelaxations(
          int index,
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation
              value) {
        if (relaxationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRelaxationsIsMutable();
          relaxations_.set(index, value);
          onChanged();
        } else {
          relaxationsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public Builder setRelaxations(
          int index,
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation.Builder
              builderForValue) {
        if (relaxationsBuilder_ == null) {
          ensureRelaxationsIsMutable();
          relaxations_.set(index, builderForValue.build());
          onChanged();
        } else {
          relaxationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public Builder addRelaxations(
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation
              value) {
        if (relaxationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRelaxationsIsMutable();
          relaxations_.add(value);
          onChanged();
        } else {
          relaxationsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public Builder addRelaxations(
          int index,
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation
              value) {
        if (relaxationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRelaxationsIsMutable();
          relaxations_.add(index, value);
          onChanged();
        } else {
          relaxationsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public Builder addRelaxations(
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation.Builder
              builderForValue) {
        if (relaxationsBuilder_ == null) {
          ensureRelaxationsIsMutable();
          relaxations_.add(builderForValue.build());
          onChanged();
        } else {
          relaxationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public Builder addRelaxations(
          int index,
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation.Builder
              builderForValue) {
        if (relaxationsBuilder_ == null) {
          ensureRelaxationsIsMutable();
          relaxations_.add(index, builderForValue.build());
          onChanged();
        } else {
          relaxationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public Builder addAllRelaxations(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.optimization.v1.InjectedSolutionConstraint
                          .ConstraintRelaxation.Relaxation>
              values) {
        if (relaxationsBuilder_ == null) {
          ensureRelaxationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, relaxations_);
          onChanged();
        } else {
          relaxationsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public Builder clearRelaxations() {
        if (relaxationsBuilder_ == null) {
          relaxations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          relaxationsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public Builder removeRelaxations(int index) {
        if (relaxationsBuilder_ == null) {
          ensureRelaxationsIsMutable();
          relaxations_.remove(index);
          onChanged();
        } else {
          relaxationsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation.Builder
          getRelaxationsBuilder(int index) {
        return getRelaxationsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .RelaxationOrBuilder
          getRelaxationsOrBuilder(int index) {
        if (relaxationsBuilder_ == null) {
          return relaxations_.get(index);
        } else {
          return relaxationsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                      .RelaxationOrBuilder>
          getRelaxationsOrBuilderList() {
        if (relaxationsBuilder_ != null) {
          return relaxationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(relaxations_);
        }
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation.Builder
          addRelaxationsBuilder() {
        return getRelaxationsFieldBuilder()
            .addBuilder(
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .Relaxation.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
              .Relaxation.Builder
          addRelaxationsBuilder(int index) {
        return getRelaxationsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .Relaxation.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * All the visit constraint relaxations that will apply to visits on
       * routes with vehicles in `vehicle_indices`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation relaxations = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation.Builder>
          getRelaxationsBuilderList() {
        return getRelaxationsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation,
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .Relaxation.Builder,
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .RelaxationOrBuilder>
          getRelaxationsFieldBuilder() {
        if (relaxationsBuilder_ == null) {
          relaxationsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                      .Relaxation,
                  com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                      .Relaxation.Builder,
                  com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                      .RelaxationOrBuilder>(
                  relaxations_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          relaxations_ = null;
        }
        return relaxationsBuilder_;
      }

      private com.google.protobuf.Internal.IntList vehicleIndices_ = emptyIntList();

      private void ensureVehicleIndicesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          vehicleIndices_ = mutableCopy(vehicleIndices_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the vehicle indices to which the visit constraint
       * `relaxations` apply. If empty, this is considered the default and the
       * `relaxations` apply to all vehicles that are not specified in other
       * `constraint_relaxations`. There can be at most one default, i.e., at
       * most one constraint relaxation field is allowed empty
       * `vehicle_indices`. A vehicle index can only be listed once, even within
       * several `constraint_relaxations`.
       * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
       * `interpret_injected_solutions_using_labels` is true (see `fields`
       * comment).
       * </pre>
       *
       * <code>repeated int32 vehicle_indices = 2;</code>
       *
       * @return A list containing the vehicleIndices.
       */
      public java.util.List<java.lang.Integer> getVehicleIndicesList() {
        return ((bitField0_ & 0x00000002) != 0)
            ? java.util.Collections.unmodifiableList(vehicleIndices_)
            : vehicleIndices_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the vehicle indices to which the visit constraint
       * `relaxations` apply. If empty, this is considered the default and the
       * `relaxations` apply to all vehicles that are not specified in other
       * `constraint_relaxations`. There can be at most one default, i.e., at
       * most one constraint relaxation field is allowed empty
       * `vehicle_indices`. A vehicle index can only be listed once, even within
       * several `constraint_relaxations`.
       * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
       * `interpret_injected_solutions_using_labels` is true (see `fields`
       * comment).
       * </pre>
       *
       * <code>repeated int32 vehicle_indices = 2;</code>
       *
       * @return The count of vehicleIndices.
       */
      public int getVehicleIndicesCount() {
        return vehicleIndices_.size();
      }
      /**
       *
       *
       * <pre>
       * Specifies the vehicle indices to which the visit constraint
       * `relaxations` apply. If empty, this is considered the default and the
       * `relaxations` apply to all vehicles that are not specified in other
       * `constraint_relaxations`. There can be at most one default, i.e., at
       * most one constraint relaxation field is allowed empty
       * `vehicle_indices`. A vehicle index can only be listed once, even within
       * several `constraint_relaxations`.
       * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
       * `interpret_injected_solutions_using_labels` is true (see `fields`
       * comment).
       * </pre>
       *
       * <code>repeated int32 vehicle_indices = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The vehicleIndices at the given index.
       */
      public int getVehicleIndices(int index) {
        return vehicleIndices_.getInt(index);
      }
      /**
       *
       *
       * <pre>
       * Specifies the vehicle indices to which the visit constraint
       * `relaxations` apply. If empty, this is considered the default and the
       * `relaxations` apply to all vehicles that are not specified in other
       * `constraint_relaxations`. There can be at most one default, i.e., at
       * most one constraint relaxation field is allowed empty
       * `vehicle_indices`. A vehicle index can only be listed once, even within
       * several `constraint_relaxations`.
       * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
       * `interpret_injected_solutions_using_labels` is true (see `fields`
       * comment).
       * </pre>
       *
       * <code>repeated int32 vehicle_indices = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The vehicleIndices to set.
       * @return This builder for chaining.
       */
      public Builder setVehicleIndices(int index, int value) {
        ensureVehicleIndicesIsMutable();
        vehicleIndices_.setInt(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the vehicle indices to which the visit constraint
       * `relaxations` apply. If empty, this is considered the default and the
       * `relaxations` apply to all vehicles that are not specified in other
       * `constraint_relaxations`. There can be at most one default, i.e., at
       * most one constraint relaxation field is allowed empty
       * `vehicle_indices`. A vehicle index can only be listed once, even within
       * several `constraint_relaxations`.
       * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
       * `interpret_injected_solutions_using_labels` is true (see `fields`
       * comment).
       * </pre>
       *
       * <code>repeated int32 vehicle_indices = 2;</code>
       *
       * @param value The vehicleIndices to add.
       * @return This builder for chaining.
       */
      public Builder addVehicleIndices(int value) {
        ensureVehicleIndicesIsMutable();
        vehicleIndices_.addInt(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the vehicle indices to which the visit constraint
       * `relaxations` apply. If empty, this is considered the default and the
       * `relaxations` apply to all vehicles that are not specified in other
       * `constraint_relaxations`. There can be at most one default, i.e., at
       * most one constraint relaxation field is allowed empty
       * `vehicle_indices`. A vehicle index can only be listed once, even within
       * several `constraint_relaxations`.
       * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
       * `interpret_injected_solutions_using_labels` is true (see `fields`
       * comment).
       * </pre>
       *
       * <code>repeated int32 vehicle_indices = 2;</code>
       *
       * @param values The vehicleIndices to add.
       * @return This builder for chaining.
       */
      public Builder addAllVehicleIndices(java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureVehicleIndicesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, vehicleIndices_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the vehicle indices to which the visit constraint
       * `relaxations` apply. If empty, this is considered the default and the
       * `relaxations` apply to all vehicles that are not specified in other
       * `constraint_relaxations`. There can be at most one default, i.e., at
       * most one constraint relaxation field is allowed empty
       * `vehicle_indices`. A vehicle index can only be listed once, even within
       * several `constraint_relaxations`.
       * A vehicle index is mapped the same as [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index], if
       * `interpret_injected_solutions_using_labels` is true (see `fields`
       * comment).
       * </pre>
       *
       * <code>repeated int32 vehicle_indices = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVehicleIndices() {
        vehicleIndices_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation)
    private static final com.google.cloud.optimization.v1.InjectedSolutionConstraint
            .ConstraintRelaxation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation();
    }

    public static com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConstraintRelaxation> PARSER =
        new com.google.protobuf.AbstractParser<ConstraintRelaxation>() {
          @java.lang.Override
          public ConstraintRelaxation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConstraintRelaxation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConstraintRelaxation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ROUTES_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute> routes_;
  /**
   *
   *
   * <pre>
   * Routes of the solution to inject. Some routes may be omitted from the
   * original solution. The routes and skipped shipments must satisfy the basic
   * validity assumptions listed for `injected_first_solution_routes`.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute> getRoutesList() {
    return routes_;
  }
  /**
   *
   *
   * <pre>
   * Routes of the solution to inject. Some routes may be omitted from the
   * original solution. The routes and skipped shipments must satisfy the basic
   * validity assumptions listed for `injected_first_solution_routes`.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
      getRoutesOrBuilderList() {
    return routes_;
  }
  /**
   *
   *
   * <pre>
   * Routes of the solution to inject. Some routes may be omitted from the
   * original solution. The routes and skipped shipments must satisfy the basic
   * validity assumptions listed for `injected_first_solution_routes`.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
   */
  @java.lang.Override
  public int getRoutesCount() {
    return routes_.size();
  }
  /**
   *
   *
   * <pre>
   * Routes of the solution to inject. Some routes may be omitted from the
   * original solution. The routes and skipped shipments must satisfy the basic
   * validity assumptions listed for `injected_first_solution_routes`.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute getRoutes(int index) {
    return routes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Routes of the solution to inject. Some routes may be omitted from the
   * original solution. The routes and skipped shipments must satisfy the basic
   * validity assumptions listed for `injected_first_solution_routes`.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRouteOrBuilder getRoutesOrBuilder(int index) {
    return routes_.get(index);
  }

  public static final int SKIPPED_SHIPMENTS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.optimization.v1.SkippedShipment> skippedShipments_;
  /**
   *
   *
   * <pre>
   * Skipped shipments of the solution to inject. Some may be omitted from the
   * original solution. See the `routes` field.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.SkippedShipment>
      getSkippedShipmentsList() {
    return skippedShipments_;
  }
  /**
   *
   *
   * <pre>
   * Skipped shipments of the solution to inject. Some may be omitted from the
   * original solution. See the `routes` field.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.SkippedShipmentOrBuilder>
      getSkippedShipmentsOrBuilderList() {
    return skippedShipments_;
  }
  /**
   *
   *
   * <pre>
   * Skipped shipments of the solution to inject. Some may be omitted from the
   * original solution. See the `routes` field.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
   */
  @java.lang.Override
  public int getSkippedShipmentsCount() {
    return skippedShipments_.size();
  }
  /**
   *
   *
   * <pre>
   * Skipped shipments of the solution to inject. Some may be omitted from the
   * original solution. See the `routes` field.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.SkippedShipment getSkippedShipments(int index) {
    return skippedShipments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Skipped shipments of the solution to inject. Some may be omitted from the
   * original solution. See the `routes` field.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.SkippedShipmentOrBuilder getSkippedShipmentsOrBuilder(
      int index) {
    return skippedShipments_.get(index);
  }

  public static final int CONSTRAINT_RELAXATIONS_FIELD_NUMBER = 3;
  private java.util.List<
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation>
      constraintRelaxations_;
  /**
   *
   *
   * <pre>
   * For zero or more groups of vehicles, specifies when and how much to relax
   * constraints. If this field is empty, all non-empty vehicle routes are
   * fully constrained.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation>
      getConstraintRelaxationsList() {
    return constraintRelaxations_;
  }
  /**
   *
   *
   * <pre>
   * For zero or more groups of vehicles, specifies when and how much to relax
   * constraints. If this field is empty, all non-empty vehicle routes are
   * fully constrained.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.optimization.v1.InjectedSolutionConstraint
                  .ConstraintRelaxationOrBuilder>
      getConstraintRelaxationsOrBuilderList() {
    return constraintRelaxations_;
  }
  /**
   *
   *
   * <pre>
   * For zero or more groups of vehicles, specifies when and how much to relax
   * constraints. If this field is empty, all non-empty vehicle routes are
   * fully constrained.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
   * </code>
   */
  @java.lang.Override
  public int getConstraintRelaxationsCount() {
    return constraintRelaxations_.size();
  }
  /**
   *
   *
   * <pre>
   * For zero or more groups of vehicles, specifies when and how much to relax
   * constraints. If this field is empty, all non-empty vehicle routes are
   * fully constrained.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
      getConstraintRelaxations(int index) {
    return constraintRelaxations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * For zero or more groups of vehicles, specifies when and how much to relax
   * constraints. If this field is empty, all non-empty vehicle routes are
   * fully constrained.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxationOrBuilder
      getConstraintRelaxationsOrBuilder(int index) {
    return constraintRelaxations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < routes_.size(); i++) {
      output.writeMessage(1, routes_.get(i));
    }
    for (int i = 0; i < skippedShipments_.size(); i++) {
      output.writeMessage(2, skippedShipments_.get(i));
    }
    for (int i = 0; i < constraintRelaxations_.size(); i++) {
      output.writeMessage(3, constraintRelaxations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < routes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, routes_.get(i));
    }
    for (int i = 0; i < skippedShipments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, skippedShipments_.get(i));
    }
    for (int i = 0; i < constraintRelaxations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, constraintRelaxations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.InjectedSolutionConstraint)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.InjectedSolutionConstraint other =
        (com.google.cloud.optimization.v1.InjectedSolutionConstraint) obj;

    if (!getRoutesList().equals(other.getRoutesList())) return false;
    if (!getSkippedShipmentsList().equals(other.getSkippedShipmentsList())) return false;
    if (!getConstraintRelaxationsList().equals(other.getConstraintRelaxationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRoutesCount() > 0) {
      hash = (37 * hash) + ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getRoutesList().hashCode();
    }
    if (getSkippedShipmentsCount() > 0) {
      hash = (37 * hash) + SKIPPED_SHIPMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getSkippedShipmentsList().hashCode();
    }
    if (getConstraintRelaxationsCount() > 0) {
      hash = (37 * hash) + CONSTRAINT_RELAXATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConstraintRelaxationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.optimization.v1.InjectedSolutionConstraint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Solution injected in the request including information about which visits
   * must be constrained and how they must be constrained.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.InjectedSolutionConstraint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.InjectedSolutionConstraint)
      com.google.cloud.optimization.v1.InjectedSolutionConstraintOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.class,
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.InjectedSolutionConstraint.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (routesBuilder_ == null) {
        routes_ = java.util.Collections.emptyList();
      } else {
        routes_ = null;
        routesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (skippedShipmentsBuilder_ == null) {
        skippedShipments_ = java.util.Collections.emptyList();
      } else {
        skippedShipments_ = null;
        skippedShipmentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (constraintRelaxationsBuilder_ == null) {
        constraintRelaxations_ = java.util.Collections.emptyList();
      } else {
        constraintRelaxations_ = null;
        constraintRelaxationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_InjectedSolutionConstraint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.InjectedSolutionConstraint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint build() {
      com.google.cloud.optimization.v1.InjectedSolutionConstraint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint buildPartial() {
      com.google.cloud.optimization.v1.InjectedSolutionConstraint result =
          new com.google.cloud.optimization.v1.InjectedSolutionConstraint(this);
      int from_bitField0_ = bitField0_;
      if (routesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          routes_ = java.util.Collections.unmodifiableList(routes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.routes_ = routes_;
      } else {
        result.routes_ = routesBuilder_.build();
      }
      if (skippedShipmentsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          skippedShipments_ = java.util.Collections.unmodifiableList(skippedShipments_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.skippedShipments_ = skippedShipments_;
      } else {
        result.skippedShipments_ = skippedShipmentsBuilder_.build();
      }
      if (constraintRelaxationsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          constraintRelaxations_ = java.util.Collections.unmodifiableList(constraintRelaxations_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.constraintRelaxations_ = constraintRelaxations_;
      } else {
        result.constraintRelaxations_ = constraintRelaxationsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.InjectedSolutionConstraint) {
        return mergeFrom((com.google.cloud.optimization.v1.InjectedSolutionConstraint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.InjectedSolutionConstraint other) {
      if (other == com.google.cloud.optimization.v1.InjectedSolutionConstraint.getDefaultInstance())
        return this;
      if (routesBuilder_ == null) {
        if (!other.routes_.isEmpty()) {
          if (routes_.isEmpty()) {
            routes_ = other.routes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRoutesIsMutable();
            routes_.addAll(other.routes_);
          }
          onChanged();
        }
      } else {
        if (!other.routes_.isEmpty()) {
          if (routesBuilder_.isEmpty()) {
            routesBuilder_.dispose();
            routesBuilder_ = null;
            routes_ = other.routes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            routesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRoutesFieldBuilder()
                    : null;
          } else {
            routesBuilder_.addAllMessages(other.routes_);
          }
        }
      }
      if (skippedShipmentsBuilder_ == null) {
        if (!other.skippedShipments_.isEmpty()) {
          if (skippedShipments_.isEmpty()) {
            skippedShipments_ = other.skippedShipments_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSkippedShipmentsIsMutable();
            skippedShipments_.addAll(other.skippedShipments_);
          }
          onChanged();
        }
      } else {
        if (!other.skippedShipments_.isEmpty()) {
          if (skippedShipmentsBuilder_.isEmpty()) {
            skippedShipmentsBuilder_.dispose();
            skippedShipmentsBuilder_ = null;
            skippedShipments_ = other.skippedShipments_;
            bitField0_ = (bitField0_ & ~0x00000002);
            skippedShipmentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSkippedShipmentsFieldBuilder()
                    : null;
          } else {
            skippedShipmentsBuilder_.addAllMessages(other.skippedShipments_);
          }
        }
      }
      if (constraintRelaxationsBuilder_ == null) {
        if (!other.constraintRelaxations_.isEmpty()) {
          if (constraintRelaxations_.isEmpty()) {
            constraintRelaxations_ = other.constraintRelaxations_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureConstraintRelaxationsIsMutable();
            constraintRelaxations_.addAll(other.constraintRelaxations_);
          }
          onChanged();
        }
      } else {
        if (!other.constraintRelaxations_.isEmpty()) {
          if (constraintRelaxationsBuilder_.isEmpty()) {
            constraintRelaxationsBuilder_.dispose();
            constraintRelaxationsBuilder_ = null;
            constraintRelaxations_ = other.constraintRelaxations_;
            bitField0_ = (bitField0_ & ~0x00000004);
            constraintRelaxationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConstraintRelaxationsFieldBuilder()
                    : null;
          } else {
            constraintRelaxationsBuilder_.addAllMessages(other.constraintRelaxations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.optimization.v1.ShipmentRoute m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.ShipmentRoute.parser(), extensionRegistry);
                if (routesBuilder_ == null) {
                  ensureRoutesIsMutable();
                  routes_.add(m);
                } else {
                  routesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.optimization.v1.SkippedShipment m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.SkippedShipment.parser(),
                        extensionRegistry);
                if (skippedShipmentsBuilder_ == null) {
                  ensureSkippedShipmentsIsMutable();
                  skippedShipments_.add(m);
                } else {
                  skippedShipmentsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.InjectedSolutionConstraint
                            .ConstraintRelaxation.parser(),
                        extensionRegistry);
                if (constraintRelaxationsBuilder_ == null) {
                  ensureConstraintRelaxationsIsMutable();
                  constraintRelaxations_.add(m);
                } else {
                  constraintRelaxationsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.optimization.v1.ShipmentRoute> routes_ =
        java.util.Collections.emptyList();

    private void ensureRoutesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        routes_ = new java.util.ArrayList<com.google.cloud.optimization.v1.ShipmentRoute>(routes_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute,
            com.google.cloud.optimization.v1.ShipmentRoute.Builder,
            com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        routesBuilder_;

    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute> getRoutesList() {
      if (routesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(routes_);
      } else {
        return routesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public int getRoutesCount() {
      if (routesBuilder_ == null) {
        return routes_.size();
      } else {
        return routesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute getRoutes(int index) {
      if (routesBuilder_ == null) {
        return routes_.get(index);
      } else {
        return routesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder setRoutes(int index, com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.set(index, value);
        onChanged();
      } else {
        routesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder setRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.set(index, builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder addRoutes(com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.add(value);
        onChanged();
      } else {
        routesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder addRoutes(int index, com.google.cloud.optimization.v1.ShipmentRoute value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.add(index, value);
        onChanged();
      } else {
        routesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder addRoutes(
        com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.add(builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder addRoutes(
        int index, com.google.cloud.optimization.v1.ShipmentRoute.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.add(index, builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder addAllRoutes(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.ShipmentRoute> values) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, routes_);
        onChanged();
      } else {
        routesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder clearRoutes() {
      if (routesBuilder_ == null) {
        routes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        routesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public Builder removeRoutes(int index) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.remove(index);
        onChanged();
      } else {
        routesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder getRoutesBuilder(int index) {
      return getRoutesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRouteOrBuilder getRoutesOrBuilder(int index) {
      if (routesBuilder_ == null) {
        return routes_.get(index);
      } else {
        return routesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        getRoutesOrBuilderList() {
      if (routesBuilder_ != null) {
        return routesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(routes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder addRoutesBuilder() {
      return getRoutesFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.ShipmentRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public com.google.cloud.optimization.v1.ShipmentRoute.Builder addRoutesBuilder(int index) {
      return getRoutesFieldBuilder()
          .addBuilder(index, com.google.cloud.optimization.v1.ShipmentRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Routes of the solution to inject. Some routes may be omitted from the
     * original solution. The routes and skipped shipments must satisfy the basic
     * validity assumptions listed for `injected_first_solution_routes`.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.ShipmentRoute routes = 1;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.ShipmentRoute.Builder>
        getRoutesBuilderList() {
      return getRoutesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.ShipmentRoute,
            com.google.cloud.optimization.v1.ShipmentRoute.Builder,
            com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>
        getRoutesFieldBuilder() {
      if (routesBuilder_ == null) {
        routesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.ShipmentRoute,
                com.google.cloud.optimization.v1.ShipmentRoute.Builder,
                com.google.cloud.optimization.v1.ShipmentRouteOrBuilder>(
                routes_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        routes_ = null;
      }
      return routesBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.SkippedShipment> skippedShipments_ =
        java.util.Collections.emptyList();

    private void ensureSkippedShipmentsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        skippedShipments_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.SkippedShipment>(
                skippedShipments_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.SkippedShipment,
            com.google.cloud.optimization.v1.SkippedShipment.Builder,
            com.google.cloud.optimization.v1.SkippedShipmentOrBuilder>
        skippedShipmentsBuilder_;

    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.SkippedShipment>
        getSkippedShipmentsList() {
      if (skippedShipmentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(skippedShipments_);
      } else {
        return skippedShipmentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public int getSkippedShipmentsCount() {
      if (skippedShipmentsBuilder_ == null) {
        return skippedShipments_.size();
      } else {
        return skippedShipmentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment getSkippedShipments(int index) {
      if (skippedShipmentsBuilder_ == null) {
        return skippedShipments_.get(index);
      } else {
        return skippedShipmentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public Builder setSkippedShipments(
        int index, com.google.cloud.optimization.v1.SkippedShipment value) {
      if (skippedShipmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.set(index, value);
        onChanged();
      } else {
        skippedShipmentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public Builder setSkippedShipments(
        int index, com.google.cloud.optimization.v1.SkippedShipment.Builder builderForValue) {
      if (skippedShipmentsBuilder_ == null) {
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.set(index, builderForValue.build());
        onChanged();
      } else {
        skippedShipmentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public Builder addSkippedShipments(com.google.cloud.optimization.v1.SkippedShipment value) {
      if (skippedShipmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.add(value);
        onChanged();
      } else {
        skippedShipmentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public Builder addSkippedShipments(
        int index, com.google.cloud.optimization.v1.SkippedShipment value) {
      if (skippedShipmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.add(index, value);
        onChanged();
      } else {
        skippedShipmentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public Builder addSkippedShipments(
        com.google.cloud.optimization.v1.SkippedShipment.Builder builderForValue) {
      if (skippedShipmentsBuilder_ == null) {
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.add(builderForValue.build());
        onChanged();
      } else {
        skippedShipmentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public Builder addSkippedShipments(
        int index, com.google.cloud.optimization.v1.SkippedShipment.Builder builderForValue) {
      if (skippedShipmentsBuilder_ == null) {
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.add(index, builderForValue.build());
        onChanged();
      } else {
        skippedShipmentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public Builder addAllSkippedShipments(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.SkippedShipment> values) {
      if (skippedShipmentsBuilder_ == null) {
        ensureSkippedShipmentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, skippedShipments_);
        onChanged();
      } else {
        skippedShipmentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public Builder clearSkippedShipments() {
      if (skippedShipmentsBuilder_ == null) {
        skippedShipments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        skippedShipmentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public Builder removeSkippedShipments(int index) {
      if (skippedShipmentsBuilder_ == null) {
        ensureSkippedShipmentsIsMutable();
        skippedShipments_.remove(index);
        onChanged();
      } else {
        skippedShipmentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment.Builder getSkippedShipmentsBuilder(
        int index) {
      return getSkippedShipmentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipmentOrBuilder getSkippedShipmentsOrBuilder(
        int index) {
      if (skippedShipmentsBuilder_ == null) {
        return skippedShipments_.get(index);
      } else {
        return skippedShipmentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.optimization.v1.SkippedShipmentOrBuilder>
        getSkippedShipmentsOrBuilderList() {
      if (skippedShipmentsBuilder_ != null) {
        return skippedShipmentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(skippedShipments_);
      }
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment.Builder addSkippedShipmentsBuilder() {
      return getSkippedShipmentsFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.SkippedShipment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public com.google.cloud.optimization.v1.SkippedShipment.Builder addSkippedShipmentsBuilder(
        int index) {
      return getSkippedShipmentsFieldBuilder()
          .addBuilder(index, com.google.cloud.optimization.v1.SkippedShipment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Skipped shipments of the solution to inject. Some may be omitted from the
     * original solution. See the `routes` field.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.SkippedShipment skipped_shipments = 2;</code>
     */
    public java.util.List<com.google.cloud.optimization.v1.SkippedShipment.Builder>
        getSkippedShipmentsBuilderList() {
      return getSkippedShipmentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.SkippedShipment,
            com.google.cloud.optimization.v1.SkippedShipment.Builder,
            com.google.cloud.optimization.v1.SkippedShipmentOrBuilder>
        getSkippedShipmentsFieldBuilder() {
      if (skippedShipmentsBuilder_ == null) {
        skippedShipmentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.SkippedShipment,
                com.google.cloud.optimization.v1.SkippedShipment.Builder,
                com.google.cloud.optimization.v1.SkippedShipmentOrBuilder>(
                skippedShipments_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        skippedShipments_ = null;
      }
      return skippedShipmentsBuilder_;
    }

    private java.util.List<
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation>
        constraintRelaxations_ = java.util.Collections.emptyList();

    private void ensureConstraintRelaxationsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        constraintRelaxations_ =
            new java.util.ArrayList<
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation>(
                constraintRelaxations_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation,
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Builder,
            com.google.cloud.optimization.v1.InjectedSolutionConstraint
                .ConstraintRelaxationOrBuilder>
        constraintRelaxationsBuilder_;

    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation>
        getConstraintRelaxationsList() {
      if (constraintRelaxationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(constraintRelaxations_);
      } else {
        return constraintRelaxationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public int getConstraintRelaxationsCount() {
      if (constraintRelaxationsBuilder_ == null) {
        return constraintRelaxations_.size();
      } else {
        return constraintRelaxationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
        getConstraintRelaxations(int index) {
      if (constraintRelaxationsBuilder_ == null) {
        return constraintRelaxations_.get(index);
      } else {
        return constraintRelaxationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public Builder setConstraintRelaxations(
        int index,
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation value) {
      if (constraintRelaxationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConstraintRelaxationsIsMutable();
        constraintRelaxations_.set(index, value);
        onChanged();
      } else {
        constraintRelaxationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public Builder setConstraintRelaxations(
        int index,
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Builder
            builderForValue) {
      if (constraintRelaxationsBuilder_ == null) {
        ensureConstraintRelaxationsIsMutable();
        constraintRelaxations_.set(index, builderForValue.build());
        onChanged();
      } else {
        constraintRelaxationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public Builder addConstraintRelaxations(
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation value) {
      if (constraintRelaxationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConstraintRelaxationsIsMutable();
        constraintRelaxations_.add(value);
        onChanged();
      } else {
        constraintRelaxationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public Builder addConstraintRelaxations(
        int index,
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation value) {
      if (constraintRelaxationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConstraintRelaxationsIsMutable();
        constraintRelaxations_.add(index, value);
        onChanged();
      } else {
        constraintRelaxationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public Builder addConstraintRelaxations(
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Builder
            builderForValue) {
      if (constraintRelaxationsBuilder_ == null) {
        ensureConstraintRelaxationsIsMutable();
        constraintRelaxations_.add(builderForValue.build());
        onChanged();
      } else {
        constraintRelaxationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public Builder addConstraintRelaxations(
        int index,
        com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Builder
            builderForValue) {
      if (constraintRelaxationsBuilder_ == null) {
        ensureConstraintRelaxationsIsMutable();
        constraintRelaxations_.add(index, builderForValue.build());
        onChanged();
      } else {
        constraintRelaxationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public Builder addAllConstraintRelaxations(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.optimization.v1.InjectedSolutionConstraint
                        .ConstraintRelaxation>
            values) {
      if (constraintRelaxationsBuilder_ == null) {
        ensureConstraintRelaxationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, constraintRelaxations_);
        onChanged();
      } else {
        constraintRelaxationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public Builder clearConstraintRelaxations() {
      if (constraintRelaxationsBuilder_ == null) {
        constraintRelaxations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        constraintRelaxationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public Builder removeConstraintRelaxations(int index) {
      if (constraintRelaxationsBuilder_ == null) {
        ensureConstraintRelaxationsIsMutable();
        constraintRelaxations_.remove(index);
        onChanged();
      } else {
        constraintRelaxationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Builder
        getConstraintRelaxationsBuilder(int index) {
      return getConstraintRelaxationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxationOrBuilder
        getConstraintRelaxationsOrBuilder(int index) {
      if (constraintRelaxationsBuilder_ == null) {
        return constraintRelaxations_.get(index);
      } else {
        return constraintRelaxationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.optimization.v1.InjectedSolutionConstraint
                    .ConstraintRelaxationOrBuilder>
        getConstraintRelaxationsOrBuilderList() {
      if (constraintRelaxationsBuilder_ != null) {
        return constraintRelaxationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(constraintRelaxations_);
      }
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Builder
        addConstraintRelaxationsBuilder() {
      return getConstraintRelaxationsFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Builder
        addConstraintRelaxationsBuilder(int index) {
      return getConstraintRelaxationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * For zero or more groups of vehicles, specifies when and how much to relax
     * constraints. If this field is empty, all non-empty vehicle routes are
     * fully constrained.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation constraint_relaxations = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Builder>
        getConstraintRelaxationsBuilderList() {
      return getConstraintRelaxationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation,
            com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                .Builder,
            com.google.cloud.optimization.v1.InjectedSolutionConstraint
                .ConstraintRelaxationOrBuilder>
        getConstraintRelaxationsFieldBuilder() {
      if (constraintRelaxationsBuilder_ == null) {
        constraintRelaxationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation,
                com.google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
                    .Builder,
                com.google.cloud.optimization.v1.InjectedSolutionConstraint
                    .ConstraintRelaxationOrBuilder>(
                constraintRelaxations_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        constraintRelaxations_ = null;
      }
      return constraintRelaxationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.InjectedSolutionConstraint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.InjectedSolutionConstraint)
  private static final com.google.cloud.optimization.v1.InjectedSolutionConstraint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.InjectedSolutionConstraint();
  }

  public static com.google.cloud.optimization.v1.InjectedSolutionConstraint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InjectedSolutionConstraint> PARSER =
      new com.google.protobuf.AbstractParser<InjectedSolutionConstraint>() {
        @java.lang.Override
        public InjectedSolutionConstraint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InjectedSolutionConstraint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InjectedSolutionConstraint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.InjectedSolutionConstraint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
