/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Rules to generate time breaks for a vehicle (e.g. lunch breaks). A break
 * is a contiguous period of time during which the vehicle remains idle at its
 * current position and cannot perform any visit. A break may occur:
 * * during the travel between two visits (which includes the time right
 *   before or right after a visit, but not in the middle of a visit), in
 *   which case it extends the corresponding transit time between the visits,
 * * or before the vehicle start (the vehicle may not start in the middle of
 *   a break), in which case it does not affect the vehicle start time.
 * * or after the vehicle end (ditto, with the vehicle end time).
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.BreakRule}
 */
public final class BreakRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.BreakRule)
    BreakRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BreakRule.newBuilder() to construct.
  private BreakRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BreakRule() {
    breakRequests_ = java.util.Collections.emptyList();
    frequencyConstraints_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BreakRule();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_BreakRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_BreakRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.BreakRule.class,
            com.google.cloud.optimization.v1.BreakRule.Builder.class);
  }

  public interface BreakRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.BreakRule.BreakRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Lower bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the earliestStartTime field is set.
     */
    boolean hasEarliestStartTime();
    /**
     *
     *
     * <pre>
     * Required. Lower bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The earliestStartTime.
     */
    com.google.protobuf.Timestamp getEarliestStartTime();
    /**
     *
     *
     * <pre>
     * Required. Lower bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getEarliestStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Upper bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the latestStartTime field is set.
     */
    boolean hasLatestStartTime();
    /**
     *
     *
     * <pre>
     * Required. Upper bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The latestStartTime.
     */
    com.google.protobuf.Timestamp getLatestStartTime();
    /**
     *
     *
     * <pre>
     * Required. Upper bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getLatestStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Minimum duration of the break. Must be positive.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the minDuration field is set.
     */
    boolean hasMinDuration();
    /**
     *
     *
     * <pre>
     * Required. Minimum duration of the break. Must be positive.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The minDuration.
     */
    com.google.protobuf.Duration getMinDuration();
    /**
     *
     *
     * <pre>
     * Required. Minimum duration of the break. Must be positive.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.protobuf.DurationOrBuilder getMinDurationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The sequence of breaks (i.e. their number and order) that apply to each
   * vehicle must be known beforehand. The repeated `BreakRequest`s define
   * that sequence, in the order in which they must occur. Their time windows
   * (`earliest_start_time` / `latest_start_time`) may overlap, but they must
   * be compatible with the order (this is checked).
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.BreakRule.BreakRequest}
   */
  public static final class BreakRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.BreakRule.BreakRequest)
      BreakRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BreakRequest.newBuilder() to construct.
    private BreakRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BreakRequest() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BreakRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BreakRule_BreakRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BreakRule_BreakRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.BreakRule.BreakRequest.class,
              com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder.class);
    }

    public static final int EARLIEST_START_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp earliestStartTime_;
    /**
     *
     *
     * <pre>
     * Required. Lower bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the earliestStartTime field is set.
     */
    @java.lang.Override
    public boolean hasEarliestStartTime() {
      return earliestStartTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Lower bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The earliestStartTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEarliestStartTime() {
      return earliestStartTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : earliestStartTime_;
    }
    /**
     *
     *
     * <pre>
     * Required. Lower bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEarliestStartTimeOrBuilder() {
      return getEarliestStartTime();
    }

    public static final int LATEST_START_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp latestStartTime_;
    /**
     *
     *
     * <pre>
     * Required. Upper bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the latestStartTime field is set.
     */
    @java.lang.Override
    public boolean hasLatestStartTime() {
      return latestStartTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Upper bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The latestStartTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getLatestStartTime() {
      return latestStartTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : latestStartTime_;
    }
    /**
     *
     *
     * <pre>
     * Required. Upper bound (inclusive) on the start of the break.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getLatestStartTimeOrBuilder() {
      return getLatestStartTime();
    }

    public static final int MIN_DURATION_FIELD_NUMBER = 3;
    private com.google.protobuf.Duration minDuration_;
    /**
     *
     *
     * <pre>
     * Required. Minimum duration of the break. Must be positive.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the minDuration field is set.
     */
    @java.lang.Override
    public boolean hasMinDuration() {
      return minDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Minimum duration of the break. Must be positive.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The minDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMinDuration() {
      return minDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : minDuration_;
    }
    /**
     *
     *
     * <pre>
     * Required. Minimum duration of the break. Must be positive.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMinDurationOrBuilder() {
      return getMinDuration();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (earliestStartTime_ != null) {
        output.writeMessage(1, getEarliestStartTime());
      }
      if (latestStartTime_ != null) {
        output.writeMessage(2, getLatestStartTime());
      }
      if (minDuration_ != null) {
        output.writeMessage(3, getMinDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (earliestStartTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEarliestStartTime());
      }
      if (latestStartTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLatestStartTime());
      }
      if (minDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMinDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.BreakRule.BreakRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.BreakRule.BreakRequest other =
          (com.google.cloud.optimization.v1.BreakRule.BreakRequest) obj;

      if (hasEarliestStartTime() != other.hasEarliestStartTime()) return false;
      if (hasEarliestStartTime()) {
        if (!getEarliestStartTime().equals(other.getEarliestStartTime())) return false;
      }
      if (hasLatestStartTime() != other.hasLatestStartTime()) return false;
      if (hasLatestStartTime()) {
        if (!getLatestStartTime().equals(other.getLatestStartTime())) return false;
      }
      if (hasMinDuration() != other.hasMinDuration()) return false;
      if (hasMinDuration()) {
        if (!getMinDuration().equals(other.getMinDuration())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEarliestStartTime()) {
        hash = (37 * hash) + EARLIEST_START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEarliestStartTime().hashCode();
      }
      if (hasLatestStartTime()) {
        hash = (37 * hash) + LATEST_START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getLatestStartTime().hashCode();
      }
      if (hasMinDuration()) {
        hash = (37 * hash) + MIN_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getMinDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.BreakRule.BreakRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The sequence of breaks (i.e. their number and order) that apply to each
     * vehicle must be known beforehand. The repeated `BreakRequest`s define
     * that sequence, in the order in which they must occur. Their time windows
     * (`earliest_start_time` / `latest_start_time`) may overlap, but they must
     * be compatible with the order (this is checked).
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.BreakRule.BreakRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.BreakRule.BreakRequest)
        com.google.cloud.optimization.v1.BreakRule.BreakRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_BreakRule_BreakRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_BreakRule_BreakRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.BreakRule.BreakRequest.class,
                com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.BreakRule.BreakRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (earliestStartTimeBuilder_ == null) {
          earliestStartTime_ = null;
        } else {
          earliestStartTime_ = null;
          earliestStartTimeBuilder_ = null;
        }
        if (latestStartTimeBuilder_ == null) {
          latestStartTime_ = null;
        } else {
          latestStartTime_ = null;
          latestStartTimeBuilder_ = null;
        }
        if (minDurationBuilder_ == null) {
          minDuration_ = null;
        } else {
          minDuration_ = null;
          minDurationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_BreakRule_BreakRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.BreakRule.BreakRequest getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.BreakRule.BreakRequest.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.BreakRule.BreakRequest build() {
        com.google.cloud.optimization.v1.BreakRule.BreakRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.BreakRule.BreakRequest buildPartial() {
        com.google.cloud.optimization.v1.BreakRule.BreakRequest result =
            new com.google.cloud.optimization.v1.BreakRule.BreakRequest(this);
        if (earliestStartTimeBuilder_ == null) {
          result.earliestStartTime_ = earliestStartTime_;
        } else {
          result.earliestStartTime_ = earliestStartTimeBuilder_.build();
        }
        if (latestStartTimeBuilder_ == null) {
          result.latestStartTime_ = latestStartTime_;
        } else {
          result.latestStartTime_ = latestStartTimeBuilder_.build();
        }
        if (minDurationBuilder_ == null) {
          result.minDuration_ = minDuration_;
        } else {
          result.minDuration_ = minDurationBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.BreakRule.BreakRequest) {
          return mergeFrom((com.google.cloud.optimization.v1.BreakRule.BreakRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.optimization.v1.BreakRule.BreakRequest other) {
        if (other == com.google.cloud.optimization.v1.BreakRule.BreakRequest.getDefaultInstance())
          return this;
        if (other.hasEarliestStartTime()) {
          mergeEarliestStartTime(other.getEarliestStartTime());
        }
        if (other.hasLatestStartTime()) {
          mergeLatestStartTime(other.getLatestStartTime());
        }
        if (other.hasMinDuration()) {
          mergeMinDuration(other.getMinDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getEarliestStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getLatestStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getMinDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.protobuf.Timestamp earliestStartTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          earliestStartTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the earliestStartTime field is set.
       */
      public boolean hasEarliestStartTime() {
        return earliestStartTimeBuilder_ != null || earliestStartTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The earliestStartTime.
       */
      public com.google.protobuf.Timestamp getEarliestStartTime() {
        if (earliestStartTimeBuilder_ == null) {
          return earliestStartTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : earliestStartTime_;
        } else {
          return earliestStartTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setEarliestStartTime(com.google.protobuf.Timestamp value) {
        if (earliestStartTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          earliestStartTime_ = value;
          onChanged();
        } else {
          earliestStartTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setEarliestStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (earliestStartTimeBuilder_ == null) {
          earliestStartTime_ = builderForValue.build();
          onChanged();
        } else {
          earliestStartTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeEarliestStartTime(com.google.protobuf.Timestamp value) {
        if (earliestStartTimeBuilder_ == null) {
          if (earliestStartTime_ != null) {
            earliestStartTime_ =
                com.google.protobuf.Timestamp.newBuilder(earliestStartTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            earliestStartTime_ = value;
          }
          onChanged();
        } else {
          earliestStartTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearEarliestStartTime() {
        if (earliestStartTimeBuilder_ == null) {
          earliestStartTime_ = null;
          onChanged();
        } else {
          earliestStartTime_ = null;
          earliestStartTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getEarliestStartTimeBuilder() {

        onChanged();
        return getEarliestStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getEarliestStartTimeOrBuilder() {
        if (earliestStartTimeBuilder_ != null) {
          return earliestStartTimeBuilder_.getMessageOrBuilder();
        } else {
          return earliestStartTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : earliestStartTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Lower bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp earliest_start_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEarliestStartTimeFieldBuilder() {
        if (earliestStartTimeBuilder_ == null) {
          earliestStartTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEarliestStartTime(), getParentForChildren(), isClean());
          earliestStartTime_ = null;
        }
        return earliestStartTimeBuilder_;
      }

      private com.google.protobuf.Timestamp latestStartTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          latestStartTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the latestStartTime field is set.
       */
      public boolean hasLatestStartTime() {
        return latestStartTimeBuilder_ != null || latestStartTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The latestStartTime.
       */
      public com.google.protobuf.Timestamp getLatestStartTime() {
        if (latestStartTimeBuilder_ == null) {
          return latestStartTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : latestStartTime_;
        } else {
          return latestStartTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setLatestStartTime(com.google.protobuf.Timestamp value) {
        if (latestStartTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          latestStartTime_ = value;
          onChanged();
        } else {
          latestStartTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setLatestStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (latestStartTimeBuilder_ == null) {
          latestStartTime_ = builderForValue.build();
          onChanged();
        } else {
          latestStartTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeLatestStartTime(com.google.protobuf.Timestamp value) {
        if (latestStartTimeBuilder_ == null) {
          if (latestStartTime_ != null) {
            latestStartTime_ =
                com.google.protobuf.Timestamp.newBuilder(latestStartTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            latestStartTime_ = value;
          }
          onChanged();
        } else {
          latestStartTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearLatestStartTime() {
        if (latestStartTimeBuilder_ == null) {
          latestStartTime_ = null;
          onChanged();
        } else {
          latestStartTime_ = null;
          latestStartTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getLatestStartTimeBuilder() {

        onChanged();
        return getLatestStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getLatestStartTimeOrBuilder() {
        if (latestStartTimeBuilder_ != null) {
          return latestStartTimeBuilder_.getMessageOrBuilder();
        } else {
          return latestStartTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : latestStartTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Upper bound (inclusive) on the start of the break.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp latest_start_time = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getLatestStartTimeFieldBuilder() {
        if (latestStartTimeBuilder_ == null) {
          latestStartTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getLatestStartTime(), getParentForChildren(), isClean());
          latestStartTime_ = null;
        }
        return latestStartTimeBuilder_;
      }

      private com.google.protobuf.Duration minDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          minDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the minDuration field is set.
       */
      public boolean hasMinDuration() {
        return minDurationBuilder_ != null || minDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The minDuration.
       */
      public com.google.protobuf.Duration getMinDuration() {
        if (minDurationBuilder_ == null) {
          return minDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : minDuration_;
        } else {
          return minDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMinDuration(com.google.protobuf.Duration value) {
        if (minDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          minDuration_ = value;
          onChanged();
        } else {
          minDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMinDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (minDurationBuilder_ == null) {
          minDuration_ = builderForValue.build();
          onChanged();
        } else {
          minDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeMinDuration(com.google.protobuf.Duration value) {
        if (minDurationBuilder_ == null) {
          if (minDuration_ != null) {
            minDuration_ =
                com.google.protobuf.Duration.newBuilder(minDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            minDuration_ = value;
          }
          onChanged();
        } else {
          minDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearMinDuration() {
        if (minDurationBuilder_ == null) {
          minDuration_ = null;
          onChanged();
        } else {
          minDuration_ = null;
          minDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.Duration.Builder getMinDurationBuilder() {

        onChanged();
        return getMinDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.DurationOrBuilder getMinDurationOrBuilder() {
        if (minDurationBuilder_ != null) {
          return minDurationBuilder_.getMessageOrBuilder();
        } else {
          return minDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : minDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum duration of the break. Must be positive.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMinDurationFieldBuilder() {
        if (minDurationBuilder_ == null) {
          minDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMinDuration(), getParentForChildren(), isClean());
          minDuration_ = null;
        }
        return minDurationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.BreakRule.BreakRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.BreakRule.BreakRequest)
    private static final com.google.cloud.optimization.v1.BreakRule.BreakRequest DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.BreakRule.BreakRequest();
    }

    public static com.google.cloud.optimization.v1.BreakRule.BreakRequest getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BreakRequest> PARSER =
        new com.google.protobuf.AbstractParser<BreakRequest>() {
          @java.lang.Override
          public BreakRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BreakRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BreakRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.BreakRule.BreakRequest getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FrequencyConstraintOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.BreakRule.FrequencyConstraint)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Minimum break duration for this constraint. Nonnegative.
     * See description of `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the minBreakDuration field is set.
     */
    boolean hasMinBreakDuration();
    /**
     *
     *
     * <pre>
     * Required. Minimum break duration for this constraint. Nonnegative.
     * See description of `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The minBreakDuration.
     */
    com.google.protobuf.Duration getMinBreakDuration();
    /**
     *
     *
     * <pre>
     * Required. Minimum break duration for this constraint. Nonnegative.
     * See description of `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.protobuf.DurationOrBuilder getMinBreakDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Maximum allowed span of any interval of time in the route that does not
     * include at least partially a break of `duration &gt;=
     * min_break_duration`. Must be positive.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the maxInterBreakDuration field is set.
     */
    boolean hasMaxInterBreakDuration();
    /**
     *
     *
     * <pre>
     * Required. Maximum allowed span of any interval of time in the route that does not
     * include at least partially a break of `duration &gt;=
     * min_break_duration`. Must be positive.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The maxInterBreakDuration.
     */
    com.google.protobuf.Duration getMaxInterBreakDuration();
    /**
     *
     *
     * <pre>
     * Required. Maximum allowed span of any interval of time in the route that does not
     * include at least partially a break of `duration &gt;=
     * min_break_duration`. Must be positive.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.protobuf.DurationOrBuilder getMaxInterBreakDurationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * One may further constrain the frequency and duration of the breaks
   * specified above, by enforcing a minimum break frequency, such as
   * "There must be a break of at least 1 hour every 12 hours". Assuming that
   * this can be interpreted as "Within any sliding time window of 12h, there
   * must be at least one break of at least one hour", that example would
   * translate to the following `FrequencyConstraint`:
   * ```
   * {
   *    min_break_duration { seconds: 3600 }         # 1 hour.
   *    max_inter_break_duration { seconds: 39600 }  # 11 hours (12 - 1 = 11).
   * }
   * ```
   * The timing and duration of the breaks in the solution will respect all
   * such constraints, in addition to the time windows and minimum durations
   * already specified in the `BreakRequest`.
   * A `FrequencyConstraint` may in practice apply to non-consecutive breaks.
   * For example, the following schedule honors the "1h every 12h" example:
   * ```
   *   04:00 vehicle start
   *    .. performing travel and visits ..
   *   09:00 1 hour break
   *   10:00 end of the break
   *    .. performing travel and visits ..
   *   12:00 20-min lunch break
   *   12:20 end of the break
   *    .. performing travel and visits ..
   *   21:00 1 hour break
   *   22:00 end of the break
   *    .. performing travel and visits ..
   *   23:59 vehicle end
   * ```
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.BreakRule.FrequencyConstraint}
   */
  public static final class FrequencyConstraint extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.BreakRule.FrequencyConstraint)
      FrequencyConstraintOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FrequencyConstraint.newBuilder() to construct.
    private FrequencyConstraint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FrequencyConstraint() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FrequencyConstraint();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BreakRule_FrequencyConstraint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BreakRule_FrequencyConstraint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.class,
              com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder.class);
    }

    public static final int MIN_BREAK_DURATION_FIELD_NUMBER = 1;
    private com.google.protobuf.Duration minBreakDuration_;
    /**
     *
     *
     * <pre>
     * Required. Minimum break duration for this constraint. Nonnegative.
     * See description of `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the minBreakDuration field is set.
     */
    @java.lang.Override
    public boolean hasMinBreakDuration() {
      return minBreakDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Minimum break duration for this constraint. Nonnegative.
     * See description of `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The minBreakDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMinBreakDuration() {
      return minBreakDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : minBreakDuration_;
    }
    /**
     *
     *
     * <pre>
     * Required. Minimum break duration for this constraint. Nonnegative.
     * See description of `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMinBreakDurationOrBuilder() {
      return getMinBreakDuration();
    }

    public static final int MAX_INTER_BREAK_DURATION_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration maxInterBreakDuration_;
    /**
     *
     *
     * <pre>
     * Required. Maximum allowed span of any interval of time in the route that does not
     * include at least partially a break of `duration &gt;=
     * min_break_duration`. Must be positive.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the maxInterBreakDuration field is set.
     */
    @java.lang.Override
    public boolean hasMaxInterBreakDuration() {
      return maxInterBreakDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Maximum allowed span of any interval of time in the route that does not
     * include at least partially a break of `duration &gt;=
     * min_break_duration`. Must be positive.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The maxInterBreakDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMaxInterBreakDuration() {
      return maxInterBreakDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : maxInterBreakDuration_;
    }
    /**
     *
     *
     * <pre>
     * Required. Maximum allowed span of any interval of time in the route that does not
     * include at least partially a break of `duration &gt;=
     * min_break_duration`. Must be positive.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMaxInterBreakDurationOrBuilder() {
      return getMaxInterBreakDuration();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (minBreakDuration_ != null) {
        output.writeMessage(1, getMinBreakDuration());
      }
      if (maxInterBreakDuration_ != null) {
        output.writeMessage(2, getMaxInterBreakDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (minBreakDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMinBreakDuration());
      }
      if (maxInterBreakDuration_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMaxInterBreakDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint other =
          (com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint) obj;

      if (hasMinBreakDuration() != other.hasMinBreakDuration()) return false;
      if (hasMinBreakDuration()) {
        if (!getMinBreakDuration().equals(other.getMinBreakDuration())) return false;
      }
      if (hasMaxInterBreakDuration() != other.hasMaxInterBreakDuration()) return false;
      if (hasMaxInterBreakDuration()) {
        if (!getMaxInterBreakDuration().equals(other.getMaxInterBreakDuration())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMinBreakDuration()) {
        hash = (37 * hash) + MIN_BREAK_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getMinBreakDuration().hashCode();
      }
      if (hasMaxInterBreakDuration()) {
        hash = (37 * hash) + MAX_INTER_BREAK_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getMaxInterBreakDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * One may further constrain the frequency and duration of the breaks
     * specified above, by enforcing a minimum break frequency, such as
     * "There must be a break of at least 1 hour every 12 hours". Assuming that
     * this can be interpreted as "Within any sliding time window of 12h, there
     * must be at least one break of at least one hour", that example would
     * translate to the following `FrequencyConstraint`:
     * ```
     * {
     *    min_break_duration { seconds: 3600 }         # 1 hour.
     *    max_inter_break_duration { seconds: 39600 }  # 11 hours (12 - 1 = 11).
     * }
     * ```
     * The timing and duration of the breaks in the solution will respect all
     * such constraints, in addition to the time windows and minimum durations
     * already specified in the `BreakRequest`.
     * A `FrequencyConstraint` may in practice apply to non-consecutive breaks.
     * For example, the following schedule honors the "1h every 12h" example:
     * ```
     *   04:00 vehicle start
     *    .. performing travel and visits ..
     *   09:00 1 hour break
     *   10:00 end of the break
     *    .. performing travel and visits ..
     *   12:00 20-min lunch break
     *   12:20 end of the break
     *    .. performing travel and visits ..
     *   21:00 1 hour break
     *   22:00 end of the break
     *    .. performing travel and visits ..
     *   23:59 vehicle end
     * ```
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.BreakRule.FrequencyConstraint}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.BreakRule.FrequencyConstraint)
        com.google.cloud.optimization.v1.BreakRule.FrequencyConstraintOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_BreakRule_FrequencyConstraint_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_BreakRule_FrequencyConstraint_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.class,
                com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder.class);
      }

      // Construct using com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (minBreakDurationBuilder_ == null) {
          minBreakDuration_ = null;
        } else {
          minBreakDuration_ = null;
          minBreakDurationBuilder_ = null;
        }
        if (maxInterBreakDurationBuilder_ == null) {
          maxInterBreakDuration_ = null;
        } else {
          maxInterBreakDuration_ = null;
          maxInterBreakDurationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_BreakRule_FrequencyConstraint_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint
          getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint build() {
        com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint buildPartial() {
        com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint result =
            new com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint(this);
        if (minBreakDurationBuilder_ == null) {
          result.minBreakDuration_ = minBreakDuration_;
        } else {
          result.minBreakDuration_ = minBreakDurationBuilder_.build();
        }
        if (maxInterBreakDurationBuilder_ == null) {
          result.maxInterBreakDuration_ = maxInterBreakDuration_;
        } else {
          result.maxInterBreakDuration_ = maxInterBreakDurationBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint) {
          return mergeFrom((com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint other) {
        if (other
            == com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.getDefaultInstance())
          return this;
        if (other.hasMinBreakDuration()) {
          mergeMinBreakDuration(other.getMinBreakDuration());
        }
        if (other.hasMaxInterBreakDuration()) {
          mergeMaxInterBreakDuration(other.getMaxInterBreakDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getMinBreakDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getMaxInterBreakDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.protobuf.Duration minBreakDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          minBreakDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the minBreakDuration field is set.
       */
      public boolean hasMinBreakDuration() {
        return minBreakDurationBuilder_ != null || minBreakDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The minBreakDuration.
       */
      public com.google.protobuf.Duration getMinBreakDuration() {
        if (minBreakDurationBuilder_ == null) {
          return minBreakDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : minBreakDuration_;
        } else {
          return minBreakDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMinBreakDuration(com.google.protobuf.Duration value) {
        if (minBreakDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          minBreakDuration_ = value;
          onChanged();
        } else {
          minBreakDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMinBreakDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (minBreakDurationBuilder_ == null) {
          minBreakDuration_ = builderForValue.build();
          onChanged();
        } else {
          minBreakDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeMinBreakDuration(com.google.protobuf.Duration value) {
        if (minBreakDurationBuilder_ == null) {
          if (minBreakDuration_ != null) {
            minBreakDuration_ =
                com.google.protobuf.Duration.newBuilder(minBreakDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            minBreakDuration_ = value;
          }
          onChanged();
        } else {
          minBreakDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearMinBreakDuration() {
        if (minBreakDurationBuilder_ == null) {
          minBreakDuration_ = null;
          onChanged();
        } else {
          minBreakDuration_ = null;
          minBreakDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.Duration.Builder getMinBreakDurationBuilder() {

        onChanged();
        return getMinBreakDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.DurationOrBuilder getMinBreakDurationOrBuilder() {
        if (minBreakDurationBuilder_ != null) {
          return minBreakDurationBuilder_.getMessageOrBuilder();
        } else {
          return minBreakDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : minBreakDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Minimum break duration for this constraint. Nonnegative.
       * See description of `FrequencyConstraint`.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_break_duration = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMinBreakDurationFieldBuilder() {
        if (minBreakDurationBuilder_ == null) {
          minBreakDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMinBreakDuration(), getParentForChildren(), isClean());
          minBreakDuration_ = null;
        }
        return minBreakDurationBuilder_;
      }

      private com.google.protobuf.Duration maxInterBreakDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          maxInterBreakDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the maxInterBreakDuration field is set.
       */
      public boolean hasMaxInterBreakDuration() {
        return maxInterBreakDurationBuilder_ != null || maxInterBreakDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The maxInterBreakDuration.
       */
      public com.google.protobuf.Duration getMaxInterBreakDuration() {
        if (maxInterBreakDurationBuilder_ == null) {
          return maxInterBreakDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : maxInterBreakDuration_;
        } else {
          return maxInterBreakDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMaxInterBreakDuration(com.google.protobuf.Duration value) {
        if (maxInterBreakDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxInterBreakDuration_ = value;
          onChanged();
        } else {
          maxInterBreakDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMaxInterBreakDuration(
          com.google.protobuf.Duration.Builder builderForValue) {
        if (maxInterBreakDurationBuilder_ == null) {
          maxInterBreakDuration_ = builderForValue.build();
          onChanged();
        } else {
          maxInterBreakDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeMaxInterBreakDuration(com.google.protobuf.Duration value) {
        if (maxInterBreakDurationBuilder_ == null) {
          if (maxInterBreakDuration_ != null) {
            maxInterBreakDuration_ =
                com.google.protobuf.Duration.newBuilder(maxInterBreakDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            maxInterBreakDuration_ = value;
          }
          onChanged();
        } else {
          maxInterBreakDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearMaxInterBreakDuration() {
        if (maxInterBreakDurationBuilder_ == null) {
          maxInterBreakDuration_ = null;
          onChanged();
        } else {
          maxInterBreakDuration_ = null;
          maxInterBreakDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.Duration.Builder getMaxInterBreakDurationBuilder() {

        onChanged();
        return getMaxInterBreakDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.DurationOrBuilder getMaxInterBreakDurationOrBuilder() {
        if (maxInterBreakDurationBuilder_ != null) {
          return maxInterBreakDurationBuilder_.getMessageOrBuilder();
        } else {
          return maxInterBreakDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : maxInterBreakDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Maximum allowed span of any interval of time in the route that does not
       * include at least partially a break of `duration &gt;=
       * min_break_duration`. Must be positive.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration max_inter_break_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMaxInterBreakDurationFieldBuilder() {
        if (maxInterBreakDurationBuilder_ == null) {
          maxInterBreakDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMaxInterBreakDuration(), getParentForChildren(), isClean());
          maxInterBreakDuration_ = null;
        }
        return maxInterBreakDurationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.BreakRule.FrequencyConstraint)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.BreakRule.FrequencyConstraint)
    private static final com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint();
    }

    public static com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FrequencyConstraint> PARSER =
        new com.google.protobuf.AbstractParser<FrequencyConstraint>() {
          @java.lang.Override
          public FrequencyConstraint parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FrequencyConstraint> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FrequencyConstraint> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int BREAK_REQUESTS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.optimization.v1.BreakRule.BreakRequest> breakRequests_;
  /**
   *
   *
   * <pre>
   * Sequence of breaks. See the `BreakRequest` message.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.BreakRule.BreakRequest>
      getBreakRequestsList() {
    return breakRequests_;
  }
  /**
   *
   *
   * <pre>
   * Sequence of breaks. See the `BreakRequest` message.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.optimization.v1.BreakRule.BreakRequestOrBuilder>
      getBreakRequestsOrBuilderList() {
    return breakRequests_;
  }
  /**
   *
   *
   * <pre>
   * Sequence of breaks. See the `BreakRequest` message.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;</code>
   */
  @java.lang.Override
  public int getBreakRequestsCount() {
    return breakRequests_.size();
  }
  /**
   *
   *
   * <pre>
   * Sequence of breaks. See the `BreakRequest` message.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.BreakRule.BreakRequest getBreakRequests(int index) {
    return breakRequests_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Sequence of breaks. See the `BreakRequest` message.
   * </pre>
   *
   * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.BreakRule.BreakRequestOrBuilder getBreakRequestsOrBuilder(
      int index) {
    return breakRequests_.get(index);
  }

  public static final int FREQUENCY_CONSTRAINTS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint>
      frequencyConstraints_;
  /**
   *
   *
   * <pre>
   * Several `FrequencyConstraint` may apply. They must all be satisfied by
   * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint>
      getFrequencyConstraintsList() {
    return frequencyConstraints_;
  }
  /**
   *
   *
   * <pre>
   * Several `FrequencyConstraint` may apply. They must all be satisfied by
   * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.optimization.v1.BreakRule.FrequencyConstraintOrBuilder>
      getFrequencyConstraintsOrBuilderList() {
    return frequencyConstraints_;
  }
  /**
   *
   *
   * <pre>
   * Several `FrequencyConstraint` may apply. They must all be satisfied by
   * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
   * </code>
   */
  @java.lang.Override
  public int getFrequencyConstraintsCount() {
    return frequencyConstraints_.size();
  }
  /**
   *
   *
   * <pre>
   * Several `FrequencyConstraint` may apply. They must all be satisfied by
   * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint getFrequencyConstraints(
      int index) {
    return frequencyConstraints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Several `FrequencyConstraint` may apply. They must all be satisfied by
   * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.BreakRule.FrequencyConstraintOrBuilder
      getFrequencyConstraintsOrBuilder(int index) {
    return frequencyConstraints_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < breakRequests_.size(); i++) {
      output.writeMessage(1, breakRequests_.get(i));
    }
    for (int i = 0; i < frequencyConstraints_.size(); i++) {
      output.writeMessage(2, frequencyConstraints_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < breakRequests_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, breakRequests_.get(i));
    }
    for (int i = 0; i < frequencyConstraints_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, frequencyConstraints_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.BreakRule)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.BreakRule other =
        (com.google.cloud.optimization.v1.BreakRule) obj;

    if (!getBreakRequestsList().equals(other.getBreakRequestsList())) return false;
    if (!getFrequencyConstraintsList().equals(other.getFrequencyConstraintsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getBreakRequestsCount() > 0) {
      hash = (37 * hash) + BREAK_REQUESTS_FIELD_NUMBER;
      hash = (53 * hash) + getBreakRequestsList().hashCode();
    }
    if (getFrequencyConstraintsCount() > 0) {
      hash = (37 * hash) + FREQUENCY_CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getFrequencyConstraintsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.BreakRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.BreakRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.BreakRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.BreakRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.BreakRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.BreakRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.BreakRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.BreakRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.BreakRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.BreakRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.BreakRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.BreakRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.optimization.v1.BreakRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Rules to generate time breaks for a vehicle (e.g. lunch breaks). A break
   * is a contiguous period of time during which the vehicle remains idle at its
   * current position and cannot perform any visit. A break may occur:
   * * during the travel between two visits (which includes the time right
   *   before or right after a visit, but not in the middle of a visit), in
   *   which case it extends the corresponding transit time between the visits,
   * * or before the vehicle start (the vehicle may not start in the middle of
   *   a break), in which case it does not affect the vehicle start time.
   * * or after the vehicle end (ditto, with the vehicle end time).
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.BreakRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.BreakRule)
      com.google.cloud.optimization.v1.BreakRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BreakRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BreakRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.BreakRule.class,
              com.google.cloud.optimization.v1.BreakRule.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.BreakRule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (breakRequestsBuilder_ == null) {
        breakRequests_ = java.util.Collections.emptyList();
      } else {
        breakRequests_ = null;
        breakRequestsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (frequencyConstraintsBuilder_ == null) {
        frequencyConstraints_ = java.util.Collections.emptyList();
      } else {
        frequencyConstraints_ = null;
        frequencyConstraintsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BreakRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.BreakRule getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.BreakRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.BreakRule build() {
      com.google.cloud.optimization.v1.BreakRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.BreakRule buildPartial() {
      com.google.cloud.optimization.v1.BreakRule result =
          new com.google.cloud.optimization.v1.BreakRule(this);
      int from_bitField0_ = bitField0_;
      if (breakRequestsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          breakRequests_ = java.util.Collections.unmodifiableList(breakRequests_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.breakRequests_ = breakRequests_;
      } else {
        result.breakRequests_ = breakRequestsBuilder_.build();
      }
      if (frequencyConstraintsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          frequencyConstraints_ = java.util.Collections.unmodifiableList(frequencyConstraints_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.frequencyConstraints_ = frequencyConstraints_;
      } else {
        result.frequencyConstraints_ = frequencyConstraintsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.BreakRule) {
        return mergeFrom((com.google.cloud.optimization.v1.BreakRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.BreakRule other) {
      if (other == com.google.cloud.optimization.v1.BreakRule.getDefaultInstance()) return this;
      if (breakRequestsBuilder_ == null) {
        if (!other.breakRequests_.isEmpty()) {
          if (breakRequests_.isEmpty()) {
            breakRequests_ = other.breakRequests_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureBreakRequestsIsMutable();
            breakRequests_.addAll(other.breakRequests_);
          }
          onChanged();
        }
      } else {
        if (!other.breakRequests_.isEmpty()) {
          if (breakRequestsBuilder_.isEmpty()) {
            breakRequestsBuilder_.dispose();
            breakRequestsBuilder_ = null;
            breakRequests_ = other.breakRequests_;
            bitField0_ = (bitField0_ & ~0x00000001);
            breakRequestsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBreakRequestsFieldBuilder()
                    : null;
          } else {
            breakRequestsBuilder_.addAllMessages(other.breakRequests_);
          }
        }
      }
      if (frequencyConstraintsBuilder_ == null) {
        if (!other.frequencyConstraints_.isEmpty()) {
          if (frequencyConstraints_.isEmpty()) {
            frequencyConstraints_ = other.frequencyConstraints_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureFrequencyConstraintsIsMutable();
            frequencyConstraints_.addAll(other.frequencyConstraints_);
          }
          onChanged();
        }
      } else {
        if (!other.frequencyConstraints_.isEmpty()) {
          if (frequencyConstraintsBuilder_.isEmpty()) {
            frequencyConstraintsBuilder_.dispose();
            frequencyConstraintsBuilder_ = null;
            frequencyConstraints_ = other.frequencyConstraints_;
            bitField0_ = (bitField0_ & ~0x00000002);
            frequencyConstraintsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFrequencyConstraintsFieldBuilder()
                    : null;
          } else {
            frequencyConstraintsBuilder_.addAllMessages(other.frequencyConstraints_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.optimization.v1.BreakRule.BreakRequest m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.BreakRule.BreakRequest.parser(),
                        extensionRegistry);
                if (breakRequestsBuilder_ == null) {
                  ensureBreakRequestsIsMutable();
                  breakRequests_.add(m);
                } else {
                  breakRequestsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.parser(),
                        extensionRegistry);
                if (frequencyConstraintsBuilder_ == null) {
                  ensureFrequencyConstraintsIsMutable();
                  frequencyConstraints_.add(m);
                } else {
                  frequencyConstraintsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.optimization.v1.BreakRule.BreakRequest> breakRequests_ =
        java.util.Collections.emptyList();

    private void ensureBreakRequestsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        breakRequests_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.BreakRule.BreakRequest>(
                breakRequests_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.BreakRule.BreakRequest,
            com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder,
            com.google.cloud.optimization.v1.BreakRule.BreakRequestOrBuilder>
        breakRequestsBuilder_;

    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.BreakRule.BreakRequest>
        getBreakRequestsList() {
      if (breakRequestsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(breakRequests_);
      } else {
        return breakRequestsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public int getBreakRequestsCount() {
      if (breakRequestsBuilder_ == null) {
        return breakRequests_.size();
      } else {
        return breakRequestsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public com.google.cloud.optimization.v1.BreakRule.BreakRequest getBreakRequests(int index) {
      if (breakRequestsBuilder_ == null) {
        return breakRequests_.get(index);
      } else {
        return breakRequestsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public Builder setBreakRequests(
        int index, com.google.cloud.optimization.v1.BreakRule.BreakRequest value) {
      if (breakRequestsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBreakRequestsIsMutable();
        breakRequests_.set(index, value);
        onChanged();
      } else {
        breakRequestsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public Builder setBreakRequests(
        int index,
        com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder builderForValue) {
      if (breakRequestsBuilder_ == null) {
        ensureBreakRequestsIsMutable();
        breakRequests_.set(index, builderForValue.build());
        onChanged();
      } else {
        breakRequestsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public Builder addBreakRequests(com.google.cloud.optimization.v1.BreakRule.BreakRequest value) {
      if (breakRequestsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBreakRequestsIsMutable();
        breakRequests_.add(value);
        onChanged();
      } else {
        breakRequestsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public Builder addBreakRequests(
        int index, com.google.cloud.optimization.v1.BreakRule.BreakRequest value) {
      if (breakRequestsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBreakRequestsIsMutable();
        breakRequests_.add(index, value);
        onChanged();
      } else {
        breakRequestsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public Builder addBreakRequests(
        com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder builderForValue) {
      if (breakRequestsBuilder_ == null) {
        ensureBreakRequestsIsMutable();
        breakRequests_.add(builderForValue.build());
        onChanged();
      } else {
        breakRequestsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public Builder addBreakRequests(
        int index,
        com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder builderForValue) {
      if (breakRequestsBuilder_ == null) {
        ensureBreakRequestsIsMutable();
        breakRequests_.add(index, builderForValue.build());
        onChanged();
      } else {
        breakRequestsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public Builder addAllBreakRequests(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.BreakRule.BreakRequest>
            values) {
      if (breakRequestsBuilder_ == null) {
        ensureBreakRequestsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, breakRequests_);
        onChanged();
      } else {
        breakRequestsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public Builder clearBreakRequests() {
      if (breakRequestsBuilder_ == null) {
        breakRequests_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        breakRequestsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public Builder removeBreakRequests(int index) {
      if (breakRequestsBuilder_ == null) {
        ensureBreakRequestsIsMutable();
        breakRequests_.remove(index);
        onChanged();
      } else {
        breakRequestsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder getBreakRequestsBuilder(
        int index) {
      return getBreakRequestsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public com.google.cloud.optimization.v1.BreakRule.BreakRequestOrBuilder
        getBreakRequestsOrBuilder(int index) {
      if (breakRequestsBuilder_ == null) {
        return breakRequests_.get(index);
      } else {
        return breakRequestsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.BreakRule.BreakRequestOrBuilder>
        getBreakRequestsOrBuilderList() {
      if (breakRequestsBuilder_ != null) {
        return breakRequestsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(breakRequests_);
      }
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder
        addBreakRequestsBuilder() {
      return getBreakRequestsFieldBuilder()
          .addBuilder(com.google.cloud.optimization.v1.BreakRule.BreakRequest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder addBreakRequestsBuilder(
        int index) {
      return getBreakRequestsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.optimization.v1.BreakRule.BreakRequest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sequence of breaks. See the `BreakRequest` message.
     * </pre>
     *
     * <code>repeated .google.cloud.optimization.v1.BreakRule.BreakRequest break_requests = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder>
        getBreakRequestsBuilderList() {
      return getBreakRequestsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.BreakRule.BreakRequest,
            com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder,
            com.google.cloud.optimization.v1.BreakRule.BreakRequestOrBuilder>
        getBreakRequestsFieldBuilder() {
      if (breakRequestsBuilder_ == null) {
        breakRequestsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.BreakRule.BreakRequest,
                com.google.cloud.optimization.v1.BreakRule.BreakRequest.Builder,
                com.google.cloud.optimization.v1.BreakRule.BreakRequestOrBuilder>(
                breakRequests_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        breakRequests_ = null;
      }
      return breakRequestsBuilder_;
    }

    private java.util.List<com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint>
        frequencyConstraints_ = java.util.Collections.emptyList();

    private void ensureFrequencyConstraintsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        frequencyConstraints_ =
            new java.util.ArrayList<com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint>(
                frequencyConstraints_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint,
            com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder,
            com.google.cloud.optimization.v1.BreakRule.FrequencyConstraintOrBuilder>
        frequencyConstraintsBuilder_;

    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint>
        getFrequencyConstraintsList() {
      if (frequencyConstraintsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(frequencyConstraints_);
      } else {
        return frequencyConstraintsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public int getFrequencyConstraintsCount() {
      if (frequencyConstraintsBuilder_ == null) {
        return frequencyConstraints_.size();
      } else {
        return frequencyConstraintsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint getFrequencyConstraints(
        int index) {
      if (frequencyConstraintsBuilder_ == null) {
        return frequencyConstraints_.get(index);
      } else {
        return frequencyConstraintsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public Builder setFrequencyConstraints(
        int index, com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint value) {
      if (frequencyConstraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrequencyConstraintsIsMutable();
        frequencyConstraints_.set(index, value);
        onChanged();
      } else {
        frequencyConstraintsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public Builder setFrequencyConstraints(
        int index,
        com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder builderForValue) {
      if (frequencyConstraintsBuilder_ == null) {
        ensureFrequencyConstraintsIsMutable();
        frequencyConstraints_.set(index, builderForValue.build());
        onChanged();
      } else {
        frequencyConstraintsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public Builder addFrequencyConstraints(
        com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint value) {
      if (frequencyConstraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrequencyConstraintsIsMutable();
        frequencyConstraints_.add(value);
        onChanged();
      } else {
        frequencyConstraintsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public Builder addFrequencyConstraints(
        int index, com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint value) {
      if (frequencyConstraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrequencyConstraintsIsMutable();
        frequencyConstraints_.add(index, value);
        onChanged();
      } else {
        frequencyConstraintsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public Builder addFrequencyConstraints(
        com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder builderForValue) {
      if (frequencyConstraintsBuilder_ == null) {
        ensureFrequencyConstraintsIsMutable();
        frequencyConstraints_.add(builderForValue.build());
        onChanged();
      } else {
        frequencyConstraintsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public Builder addFrequencyConstraints(
        int index,
        com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder builderForValue) {
      if (frequencyConstraintsBuilder_ == null) {
        ensureFrequencyConstraintsIsMutable();
        frequencyConstraints_.add(index, builderForValue.build());
        onChanged();
      } else {
        frequencyConstraintsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public Builder addAllFrequencyConstraints(
        java.lang.Iterable<? extends com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint>
            values) {
      if (frequencyConstraintsBuilder_ == null) {
        ensureFrequencyConstraintsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frequencyConstraints_);
        onChanged();
      } else {
        frequencyConstraintsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public Builder clearFrequencyConstraints() {
      if (frequencyConstraintsBuilder_ == null) {
        frequencyConstraints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        frequencyConstraintsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public Builder removeFrequencyConstraints(int index) {
      if (frequencyConstraintsBuilder_ == null) {
        ensureFrequencyConstraintsIsMutable();
        frequencyConstraints_.remove(index);
        onChanged();
      } else {
        frequencyConstraintsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder
        getFrequencyConstraintsBuilder(int index) {
      return getFrequencyConstraintsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public com.google.cloud.optimization.v1.BreakRule.FrequencyConstraintOrBuilder
        getFrequencyConstraintsOrBuilder(int index) {
      if (frequencyConstraintsBuilder_ == null) {
        return frequencyConstraints_.get(index);
      } else {
        return frequencyConstraintsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.optimization.v1.BreakRule.FrequencyConstraintOrBuilder>
        getFrequencyConstraintsOrBuilderList() {
      if (frequencyConstraintsBuilder_ != null) {
        return frequencyConstraintsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(frequencyConstraints_);
      }
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder
        addFrequencyConstraintsBuilder() {
      return getFrequencyConstraintsFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder
        addFrequencyConstraintsBuilder(int index) {
      return getFrequencyConstraintsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Several `FrequencyConstraint` may apply. They must all be satisfied by
     * the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BreakRule.FrequencyConstraint frequency_constraints = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder>
        getFrequencyConstraintsBuilderList() {
      return getFrequencyConstraintsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint,
            com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder,
            com.google.cloud.optimization.v1.BreakRule.FrequencyConstraintOrBuilder>
        getFrequencyConstraintsFieldBuilder() {
      if (frequencyConstraintsBuilder_ == null) {
        frequencyConstraintsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint,
                com.google.cloud.optimization.v1.BreakRule.FrequencyConstraint.Builder,
                com.google.cloud.optimization.v1.BreakRule.FrequencyConstraintOrBuilder>(
                frequencyConstraints_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        frequencyConstraints_ = null;
      }
      return frequencyConstraintsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.BreakRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.BreakRule)
  private static final com.google.cloud.optimization.v1.BreakRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.BreakRule();
  }

  public static com.google.cloud.optimization.v1.BreakRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BreakRule> PARSER =
      new com.google.protobuf.AbstractParser<BreakRule>() {
        @java.lang.Override
        public BreakRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BreakRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BreakRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.BreakRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
