/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Request to batch optimize tours as an asynchronous operation.
 * Each input file should contain one `OptimizeToursRequest`, and each output
 * file will contain one `OptimizeToursResponse`. The request contains
 * information to read/write and parse the files. All the input and output files
 * should be under the same project.
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.BatchOptimizeToursRequest}
 */
public final class BatchOptimizeToursRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.BatchOptimizeToursRequest)
    BatchOptimizeToursRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchOptimizeToursRequest.newBuilder() to construct.
  private BatchOptimizeToursRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchOptimizeToursRequest() {
    parent_ = "";
    modelConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchOptimizeToursRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_BatchOptimizeToursRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_BatchOptimizeToursRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.class,
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.Builder.class);
  }

  public interface AsyncModelConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * User defined model name, can be used as alias by users to keep track of
     * models.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * User defined model name, can be used as alias by users to keep track of
     * models.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Required. Information about the input model.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the inputConfig field is set.
     */
    boolean hasInputConfig();
    /**
     *
     *
     * <pre>
     * Required. Information about the input model.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The inputConfig.
     */
    com.google.cloud.optimization.v1.InputConfig getInputConfig();
    /**
     *
     *
     * <pre>
     * Required. Information about the input model.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.optimization.v1.InputConfigOrBuilder getInputConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The desired output location information.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    boolean hasOutputConfig();
    /**
     *
     *
     * <pre>
     * Required. The desired output location information.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputConfig.
     */
    com.google.cloud.optimization.v1.OutputConfig getOutputConfig();
    /**
     *
     *
     * <pre>
     * Required. The desired output location information.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.optimization.v1.OutputConfigOrBuilder getOutputConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * If this is set, the model will be solved in the checkpoint mode. In this
     * mode, the input model can have a deadline longer than 30 mins without the
     * risk of interruption. The model will be solved in multiple short-running
     * stages. Each stage generates an intermediate checkpoint
     * and stores it in the user's Cloud Storage buckets. The checkpoint
     * mode should be preferred over
     * allow_large_deadline_despite_interruption_risk since it prevents the risk
     * of interruption.
     * </pre>
     *
     * <code>bool enable_checkpoints = 4;</code>
     *
     * @return The enableCheckpoints.
     */
    boolean getEnableCheckpoints();
  }
  /**
   *
   *
   * <pre>
   * Information for solving one optimization model asynchronously.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig}
   */
  public static final class AsyncModelConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig)
      AsyncModelConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AsyncModelConfig.newBuilder() to construct.
    private AsyncModelConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AsyncModelConfig() {
      displayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AsyncModelConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BatchOptimizeToursRequest_AsyncModelConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BatchOptimizeToursRequest_AsyncModelConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.class,
              com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder
                  .class);
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object displayName_;
    /**
     *
     *
     * <pre>
     * User defined model name, can be used as alias by users to keep track of
     * models.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * User defined model name, can be used as alias by users to keep track of
     * models.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INPUT_CONFIG_FIELD_NUMBER = 2;
    private com.google.cloud.optimization.v1.InputConfig inputConfig_;
    /**
     *
     *
     * <pre>
     * Required. Information about the input model.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the inputConfig field is set.
     */
    @java.lang.Override
    public boolean hasInputConfig() {
      return inputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input model.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The inputConfig.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.InputConfig getInputConfig() {
      return inputConfig_ == null
          ? com.google.cloud.optimization.v1.InputConfig.getDefaultInstance()
          : inputConfig_;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input model.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.InputConfigOrBuilder getInputConfigOrBuilder() {
      return getInputConfig();
    }

    public static final int OUTPUT_CONFIG_FIELD_NUMBER = 3;
    private com.google.cloud.optimization.v1.OutputConfig outputConfig_;
    /**
     *
     *
     * <pre>
     * Required. The desired output location information.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    @java.lang.Override
    public boolean hasOutputConfig() {
      return outputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired output location information.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputConfig.
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.OutputConfig getOutputConfig() {
      return outputConfig_ == null
          ? com.google.cloud.optimization.v1.OutputConfig.getDefaultInstance()
          : outputConfig_;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired output location information.
     * </pre>
     *
     * <code>
     * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.OutputConfigOrBuilder getOutputConfigOrBuilder() {
      return getOutputConfig();
    }

    public static final int ENABLE_CHECKPOINTS_FIELD_NUMBER = 4;
    private boolean enableCheckpoints_;
    /**
     *
     *
     * <pre>
     * If this is set, the model will be solved in the checkpoint mode. In this
     * mode, the input model can have a deadline longer than 30 mins without the
     * risk of interruption. The model will be solved in multiple short-running
     * stages. Each stage generates an intermediate checkpoint
     * and stores it in the user's Cloud Storage buckets. The checkpoint
     * mode should be preferred over
     * allow_large_deadline_despite_interruption_risk since it prevents the risk
     * of interruption.
     * </pre>
     *
     * <code>bool enable_checkpoints = 4;</code>
     *
     * @return The enableCheckpoints.
     */
    @java.lang.Override
    public boolean getEnableCheckpoints() {
      return enableCheckpoints_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
      }
      if (inputConfig_ != null) {
        output.writeMessage(2, getInputConfig());
      }
      if (outputConfig_ != null) {
        output.writeMessage(3, getOutputConfig());
      }
      if (enableCheckpoints_ != false) {
        output.writeBool(4, enableCheckpoints_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
      }
      if (inputConfig_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getInputConfig());
      }
      if (outputConfig_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOutputConfig());
      }
      if (enableCheckpoints_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, enableCheckpoints_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig other =
          (com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig) obj;

      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (hasInputConfig() != other.hasInputConfig()) return false;
      if (hasInputConfig()) {
        if (!getInputConfig().equals(other.getInputConfig())) return false;
      }
      if (hasOutputConfig() != other.hasOutputConfig()) return false;
      if (hasOutputConfig()) {
        if (!getOutputConfig().equals(other.getOutputConfig())) return false;
      }
      if (getEnableCheckpoints() != other.getEnableCheckpoints()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      if (hasInputConfig()) {
        hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getInputConfig().hashCode();
      }
      if (hasOutputConfig()) {
        hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getOutputConfig().hashCode();
      }
      hash = (37 * hash) + ENABLE_CHECKPOINTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableCheckpoints());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information for solving one optimization model asynchronously.
     * </pre>
     *
     * Protobuf type {@code google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig)
        com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_BatchOptimizeToursRequest_AsyncModelConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_BatchOptimizeToursRequest_AsyncModelConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.class,
                com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        displayName_ = "";

        if (inputConfigBuilder_ == null) {
          inputConfig_ = null;
        } else {
          inputConfig_ = null;
          inputConfigBuilder_ = null;
        }
        if (outputConfigBuilder_ == null) {
          outputConfig_ = null;
        } else {
          outputConfig_ = null;
          outputConfigBuilder_ = null;
        }
        enableCheckpoints_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.optimization.v1.FleetRoutingProto
            .internal_static_google_cloud_optimization_v1_BatchOptimizeToursRequest_AsyncModelConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
          getDefaultInstanceForType() {
        return com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig build() {
        com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
          buildPartial() {
        com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig result =
            new com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig(this);
        result.displayName_ = displayName_;
        if (inputConfigBuilder_ == null) {
          result.inputConfig_ = inputConfig_;
        } else {
          result.inputConfig_ = inputConfigBuilder_.build();
        }
        if (outputConfigBuilder_ == null) {
          result.outputConfig_ = outputConfig_;
        } else {
          result.outputConfig_ = outputConfigBuilder_.build();
        }
        result.enableCheckpoints_ = enableCheckpoints_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig) {
          return mergeFrom(
              (com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig other) {
        if (other
            == com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
                .getDefaultInstance()) return this;
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          onChanged();
        }
        if (other.hasInputConfig()) {
          mergeInputConfig(other.getInputConfig());
        }
        if (other.hasOutputConfig()) {
          mergeOutputConfig(other.getOutputConfig());
        }
        if (other.getEnableCheckpoints() != false) {
          setEnableCheckpoints(other.getEnableCheckpoints());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  displayName_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getInputConfigFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getOutputConfigFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              case 32:
                {
                  enableCheckpoints_ = input.readBool();

                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * User defined model name, can be used as alias by users to keep track of
       * models.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * User defined model name, can be used as alias by users to keep track of
       * models.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * User defined model name, can be used as alias by users to keep track of
       * models.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        displayName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User defined model name, can be used as alias by users to keep track of
       * models.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {

        displayName_ = getDefaultInstance().getDisplayName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User defined model name, can be used as alias by users to keep track of
       * models.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        displayName_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.optimization.v1.InputConfig inputConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.InputConfig,
              com.google.cloud.optimization.v1.InputConfig.Builder,
              com.google.cloud.optimization.v1.InputConfigOrBuilder>
          inputConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Information about the input model.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the inputConfig field is set.
       */
      public boolean hasInputConfig() {
        return inputConfigBuilder_ != null || inputConfig_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Information about the input model.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The inputConfig.
       */
      public com.google.cloud.optimization.v1.InputConfig getInputConfig() {
        if (inputConfigBuilder_ == null) {
          return inputConfig_ == null
              ? com.google.cloud.optimization.v1.InputConfig.getDefaultInstance()
              : inputConfig_;
        } else {
          return inputConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Information about the input model.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setInputConfig(com.google.cloud.optimization.v1.InputConfig value) {
        if (inputConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          inputConfig_ = value;
          onChanged();
        } else {
          inputConfigBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Information about the input model.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setInputConfig(
          com.google.cloud.optimization.v1.InputConfig.Builder builderForValue) {
        if (inputConfigBuilder_ == null) {
          inputConfig_ = builderForValue.build();
          onChanged();
        } else {
          inputConfigBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Information about the input model.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeInputConfig(com.google.cloud.optimization.v1.InputConfig value) {
        if (inputConfigBuilder_ == null) {
          if (inputConfig_ != null) {
            inputConfig_ =
                com.google.cloud.optimization.v1.InputConfig.newBuilder(inputConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            inputConfig_ = value;
          }
          onChanged();
        } else {
          inputConfigBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Information about the input model.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearInputConfig() {
        if (inputConfigBuilder_ == null) {
          inputConfig_ = null;
          onChanged();
        } else {
          inputConfig_ = null;
          inputConfigBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Information about the input model.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.optimization.v1.InputConfig.Builder getInputConfigBuilder() {

        onChanged();
        return getInputConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Information about the input model.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.optimization.v1.InputConfigOrBuilder getInputConfigOrBuilder() {
        if (inputConfigBuilder_ != null) {
          return inputConfigBuilder_.getMessageOrBuilder();
        } else {
          return inputConfig_ == null
              ? com.google.cloud.optimization.v1.InputConfig.getDefaultInstance()
              : inputConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Information about the input model.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.InputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.InputConfig,
              com.google.cloud.optimization.v1.InputConfig.Builder,
              com.google.cloud.optimization.v1.InputConfigOrBuilder>
          getInputConfigFieldBuilder() {
        if (inputConfigBuilder_ == null) {
          inputConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.optimization.v1.InputConfig,
                  com.google.cloud.optimization.v1.InputConfig.Builder,
                  com.google.cloud.optimization.v1.InputConfigOrBuilder>(
                  getInputConfig(), getParentForChildren(), isClean());
          inputConfig_ = null;
        }
        return inputConfigBuilder_;
      }

      private com.google.cloud.optimization.v1.OutputConfig outputConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.OutputConfig,
              com.google.cloud.optimization.v1.OutputConfig.Builder,
              com.google.cloud.optimization.v1.OutputConfigOrBuilder>
          outputConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The desired output location information.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the outputConfig field is set.
       */
      public boolean hasOutputConfig() {
        return outputConfigBuilder_ != null || outputConfig_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. The desired output location information.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The outputConfig.
       */
      public com.google.cloud.optimization.v1.OutputConfig getOutputConfig() {
        if (outputConfigBuilder_ == null) {
          return outputConfig_ == null
              ? com.google.cloud.optimization.v1.OutputConfig.getDefaultInstance()
              : outputConfig_;
        } else {
          return outputConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The desired output location information.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setOutputConfig(com.google.cloud.optimization.v1.OutputConfig value) {
        if (outputConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          outputConfig_ = value;
          onChanged();
        } else {
          outputConfigBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The desired output location information.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setOutputConfig(
          com.google.cloud.optimization.v1.OutputConfig.Builder builderForValue) {
        if (outputConfigBuilder_ == null) {
          outputConfig_ = builderForValue.build();
          onChanged();
        } else {
          outputConfigBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The desired output location information.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeOutputConfig(com.google.cloud.optimization.v1.OutputConfig value) {
        if (outputConfigBuilder_ == null) {
          if (outputConfig_ != null) {
            outputConfig_ =
                com.google.cloud.optimization.v1.OutputConfig.newBuilder(outputConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            outputConfig_ = value;
          }
          onChanged();
        } else {
          outputConfigBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The desired output location information.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearOutputConfig() {
        if (outputConfigBuilder_ == null) {
          outputConfig_ = null;
          onChanged();
        } else {
          outputConfig_ = null;
          outputConfigBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The desired output location information.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.optimization.v1.OutputConfig.Builder getOutputConfigBuilder() {

        onChanged();
        return getOutputConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The desired output location information.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.optimization.v1.OutputConfigOrBuilder getOutputConfigOrBuilder() {
        if (outputConfigBuilder_ != null) {
          return outputConfigBuilder_.getMessageOrBuilder();
        } else {
          return outputConfig_ == null
              ? com.google.cloud.optimization.v1.OutputConfig.getDefaultInstance()
              : outputConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The desired output location information.
       * </pre>
       *
       * <code>
       * .google.cloud.optimization.v1.OutputConfig output_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.optimization.v1.OutputConfig,
              com.google.cloud.optimization.v1.OutputConfig.Builder,
              com.google.cloud.optimization.v1.OutputConfigOrBuilder>
          getOutputConfigFieldBuilder() {
        if (outputConfigBuilder_ == null) {
          outputConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.optimization.v1.OutputConfig,
                  com.google.cloud.optimization.v1.OutputConfig.Builder,
                  com.google.cloud.optimization.v1.OutputConfigOrBuilder>(
                  getOutputConfig(), getParentForChildren(), isClean());
          outputConfig_ = null;
        }
        return outputConfigBuilder_;
      }

      private boolean enableCheckpoints_;
      /**
       *
       *
       * <pre>
       * If this is set, the model will be solved in the checkpoint mode. In this
       * mode, the input model can have a deadline longer than 30 mins without the
       * risk of interruption. The model will be solved in multiple short-running
       * stages. Each stage generates an intermediate checkpoint
       * and stores it in the user's Cloud Storage buckets. The checkpoint
       * mode should be preferred over
       * allow_large_deadline_despite_interruption_risk since it prevents the risk
       * of interruption.
       * </pre>
       *
       * <code>bool enable_checkpoints = 4;</code>
       *
       * @return The enableCheckpoints.
       */
      @java.lang.Override
      public boolean getEnableCheckpoints() {
        return enableCheckpoints_;
      }
      /**
       *
       *
       * <pre>
       * If this is set, the model will be solved in the checkpoint mode. In this
       * mode, the input model can have a deadline longer than 30 mins without the
       * risk of interruption. The model will be solved in multiple short-running
       * stages. Each stage generates an intermediate checkpoint
       * and stores it in the user's Cloud Storage buckets. The checkpoint
       * mode should be preferred over
       * allow_large_deadline_despite_interruption_risk since it prevents the risk
       * of interruption.
       * </pre>
       *
       * <code>bool enable_checkpoints = 4;</code>
       *
       * @param value The enableCheckpoints to set.
       * @return This builder for chaining.
       */
      public Builder setEnableCheckpoints(boolean value) {

        enableCheckpoints_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If this is set, the model will be solved in the checkpoint mode. In this
       * mode, the input model can have a deadline longer than 30 mins without the
       * risk of interruption. The model will be solved in multiple short-running
       * stages. Each stage generates an intermediate checkpoint
       * and stores it in the user's Cloud Storage buckets. The checkpoint
       * mode should be preferred over
       * allow_large_deadline_despite_interruption_risk since it prevents the risk
       * of interruption.
       * </pre>
       *
       * <code>bool enable_checkpoints = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableCheckpoints() {

        enableCheckpoints_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig)
    private static final com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig();
    }

    public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AsyncModelConfig> PARSER =
        new com.google.protobuf.AbstractParser<AsyncModelConfig>() {
          @java.lang.Override
          public AsyncModelConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AsyncModelConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AsyncModelConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. Target project and location to make a call.
   * Format: `projects/{project-id}/locations/{location-id}`.
   * If no location is specified, a region will be chosen automatically.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Target project and location to make a call.
   * Format: `projects/{project-id}/locations/{location-id}`.
   * If no location is specified, a region will be chosen automatically.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_CONFIGS_FIELD_NUMBER = 2;
  private java.util.List<
          com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig>
      modelConfigs_;
  /**
   *
   *
   * <pre>
   * Required. Input/Output information each purchase model, such as file paths and data
   * formats.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig>
      getModelConfigsList() {
    return modelConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input/Output information each purchase model, such as file paths and data
   * formats.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfigOrBuilder>
      getModelConfigsOrBuilderList() {
    return modelConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input/Output information each purchase model, such as file paths and data
   * formats.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getModelConfigsCount() {
    return modelConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Input/Output information each purchase model, such as file paths and data
   * formats.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
      getModelConfigs(int index) {
    return modelConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Input/Output information each purchase model, such as file paths and data
   * formats.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfigOrBuilder
      getModelConfigsOrBuilder(int index) {
    return modelConfigs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    for (int i = 0; i < modelConfigs_.size(); i++) {
      output.writeMessage(2, modelConfigs_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    for (int i = 0; i < modelConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, modelConfigs_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.BatchOptimizeToursRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.BatchOptimizeToursRequest other =
        (com.google.cloud.optimization.v1.BatchOptimizeToursRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getModelConfigsList().equals(other.getModelConfigsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (getModelConfigsCount() > 0) {
      hash = (37 * hash) + MODEL_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getModelConfigsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.optimization.v1.BatchOptimizeToursRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request to batch optimize tours as an asynchronous operation.
   * Each input file should contain one `OptimizeToursRequest`, and each output
   * file will contain one `OptimizeToursResponse`. The request contains
   * information to read/write and parse the files. All the input and output files
   * should be under the same project.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.BatchOptimizeToursRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.BatchOptimizeToursRequest)
      com.google.cloud.optimization.v1.BatchOptimizeToursRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BatchOptimizeToursRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BatchOptimizeToursRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.BatchOptimizeToursRequest.class,
              com.google.cloud.optimization.v1.BatchOptimizeToursRequest.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.BatchOptimizeToursRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      if (modelConfigsBuilder_ == null) {
        modelConfigs_ = java.util.Collections.emptyList();
      } else {
        modelConfigs_ = null;
        modelConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_BatchOptimizeToursRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.BatchOptimizeToursRequest getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.BatchOptimizeToursRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.BatchOptimizeToursRequest build() {
      com.google.cloud.optimization.v1.BatchOptimizeToursRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.BatchOptimizeToursRequest buildPartial() {
      com.google.cloud.optimization.v1.BatchOptimizeToursRequest result =
          new com.google.cloud.optimization.v1.BatchOptimizeToursRequest(this);
      int from_bitField0_ = bitField0_;
      result.parent_ = parent_;
      if (modelConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          modelConfigs_ = java.util.Collections.unmodifiableList(modelConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.modelConfigs_ = modelConfigs_;
      } else {
        result.modelConfigs_ = modelConfigsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.BatchOptimizeToursRequest) {
        return mergeFrom((com.google.cloud.optimization.v1.BatchOptimizeToursRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.BatchOptimizeToursRequest other) {
      if (other == com.google.cloud.optimization.v1.BatchOptimizeToursRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (modelConfigsBuilder_ == null) {
        if (!other.modelConfigs_.isEmpty()) {
          if (modelConfigs_.isEmpty()) {
            modelConfigs_ = other.modelConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureModelConfigsIsMutable();
            modelConfigs_.addAll(other.modelConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.modelConfigs_.isEmpty()) {
          if (modelConfigsBuilder_.isEmpty()) {
            modelConfigsBuilder_.dispose();
            modelConfigsBuilder_ = null;
            modelConfigs_ = other.modelConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            modelConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getModelConfigsFieldBuilder()
                    : null;
          } else {
            modelConfigsBuilder_.addAllMessages(other.modelConfigs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig m =
                    input.readMessage(
                        com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
                            .parser(),
                        extensionRegistry);
                if (modelConfigsBuilder_ == null) {
                  ensureModelConfigsIsMutable();
                  modelConfigs_.add(m);
                } else {
                  modelConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Target project and location to make a call.
     * Format: `projects/{project-id}/locations/{location-id}`.
     * If no location is specified, a region will be chosen automatically.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Target project and location to make a call.
     * Format: `projects/{project-id}/locations/{location-id}`.
     * If no location is specified, a region will be chosen automatically.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Target project and location to make a call.
     * Format: `projects/{project-id}/locations/{location-id}`.
     * If no location is specified, a region will be chosen automatically.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Target project and location to make a call.
     * Format: `projects/{project-id}/locations/{location-id}`.
     * If no location is specified, a region will be chosen automatically.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Target project and location to make a call.
     * Format: `projects/{project-id}/locations/{location-id}`.
     * If no location is specified, a region will be chosen automatically.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig>
        modelConfigs_ = java.util.Collections.emptyList();

    private void ensureModelConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        modelConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig>(
                modelConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig,
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder,
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfigOrBuilder>
        modelConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig>
        getModelConfigsList() {
      if (modelConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(modelConfigs_);
      } else {
        return modelConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getModelConfigsCount() {
      if (modelConfigsBuilder_ == null) {
        return modelConfigs_.size();
      } else {
        return modelConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
        getModelConfigs(int index) {
      if (modelConfigsBuilder_ == null) {
        return modelConfigs_.get(index);
      } else {
        return modelConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setModelConfigs(
        int index,
        com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig value) {
      if (modelConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModelConfigsIsMutable();
        modelConfigs_.set(index, value);
        onChanged();
      } else {
        modelConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setModelConfigs(
        int index,
        com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder
            builderForValue) {
      if (modelConfigsBuilder_ == null) {
        ensureModelConfigsIsMutable();
        modelConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        modelConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModelConfigs(
        com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig value) {
      if (modelConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModelConfigsIsMutable();
        modelConfigs_.add(value);
        onChanged();
      } else {
        modelConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModelConfigs(
        int index,
        com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig value) {
      if (modelConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModelConfigsIsMutable();
        modelConfigs_.add(index, value);
        onChanged();
      } else {
        modelConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModelConfigs(
        com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder
            builderForValue) {
      if (modelConfigsBuilder_ == null) {
        ensureModelConfigsIsMutable();
        modelConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        modelConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModelConfigs(
        int index,
        com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder
            builderForValue) {
      if (modelConfigsBuilder_ == null) {
        ensureModelConfigsIsMutable();
        modelConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        modelConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllModelConfigs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig>
            values) {
      if (modelConfigsBuilder_ == null) {
        ensureModelConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, modelConfigs_);
        onChanged();
      } else {
        modelConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearModelConfigs() {
      if (modelConfigsBuilder_ == null) {
        modelConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        modelConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeModelConfigs(int index) {
      if (modelConfigsBuilder_ == null) {
        ensureModelConfigsIsMutable();
        modelConfigs_.remove(index);
        onChanged();
      } else {
        modelConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder
        getModelConfigsBuilder(int index) {
      return getModelConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfigOrBuilder
        getModelConfigsOrBuilder(int index) {
      if (modelConfigsBuilder_ == null) {
        return modelConfigs_.get(index);
      } else {
        return modelConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.optimization.v1.BatchOptimizeToursRequest
                    .AsyncModelConfigOrBuilder>
        getModelConfigsOrBuilderList() {
      if (modelConfigsBuilder_ != null) {
        return modelConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(modelConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder
        addModelConfigsBuilder() {
      return getModelConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder
        addModelConfigsBuilder(int index) {
      return getModelConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Input/Output information each purchase model, such as file paths and data
     * formats.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig model_configs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder>
        getModelConfigsBuilderList() {
      return getModelConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig,
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder,
            com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfigOrBuilder>
        getModelConfigsFieldBuilder() {
      if (modelConfigsBuilder_ == null) {
        modelConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig,
                com.google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.Builder,
                com.google.cloud.optimization.v1.BatchOptimizeToursRequest
                    .AsyncModelConfigOrBuilder>(
                modelConfigs_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        modelConfigs_ = null;
      }
      return modelConfigsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.BatchOptimizeToursRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.BatchOptimizeToursRequest)
  private static final com.google.cloud.optimization.v1.BatchOptimizeToursRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.BatchOptimizeToursRequest();
  }

  public static com.google.cloud.optimization.v1.BatchOptimizeToursRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchOptimizeToursRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchOptimizeToursRequest>() {
        @java.lang.Override
        public BatchOptimizeToursRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchOptimizeToursRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchOptimizeToursRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.BatchOptimizeToursRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
