/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

public interface AggregatedMetricsOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.optimization.v1.AggregatedMetrics)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Number of shipments performed. Note that a pickup and delivery pair only
   * counts once.
   * </pre>
   *
   * <code>int32 performed_shipment_count = 1;</code>
   *
   * @return The performedShipmentCount.
   */
  int getPerformedShipmentCount();

  /**
   *
   *
   * <pre>
   * Total travel duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration travel_duration = 2;</code>
   *
   * @return Whether the travelDuration field is set.
   */
  boolean hasTravelDuration();
  /**
   *
   *
   * <pre>
   * Total travel duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration travel_duration = 2;</code>
   *
   * @return The travelDuration.
   */
  com.google.protobuf.Duration getTravelDuration();
  /**
   *
   *
   * <pre>
   * Total travel duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration travel_duration = 2;</code>
   */
  com.google.protobuf.DurationOrBuilder getTravelDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Total wait duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait_duration = 3;</code>
   *
   * @return Whether the waitDuration field is set.
   */
  boolean hasWaitDuration();
  /**
   *
   *
   * <pre>
   * Total wait duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait_duration = 3;</code>
   *
   * @return The waitDuration.
   */
  com.google.protobuf.Duration getWaitDuration();
  /**
   *
   *
   * <pre>
   * Total wait duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait_duration = 3;</code>
   */
  com.google.protobuf.DurationOrBuilder getWaitDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Total delay duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration delay_duration = 4;</code>
   *
   * @return Whether the delayDuration field is set.
   */
  boolean hasDelayDuration();
  /**
   *
   *
   * <pre>
   * Total delay duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration delay_duration = 4;</code>
   *
   * @return The delayDuration.
   */
  com.google.protobuf.Duration getDelayDuration();
  /**
   *
   *
   * <pre>
   * Total delay duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration delay_duration = 4;</code>
   */
  com.google.protobuf.DurationOrBuilder getDelayDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Total break duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration break_duration = 5;</code>
   *
   * @return Whether the breakDuration field is set.
   */
  boolean hasBreakDuration();
  /**
   *
   *
   * <pre>
   * Total break duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration break_duration = 5;</code>
   *
   * @return The breakDuration.
   */
  com.google.protobuf.Duration getBreakDuration();
  /**
   *
   *
   * <pre>
   * Total break duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration break_duration = 5;</code>
   */
  com.google.protobuf.DurationOrBuilder getBreakDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Total visit duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration visit_duration = 6;</code>
   *
   * @return Whether the visitDuration field is set.
   */
  boolean hasVisitDuration();
  /**
   *
   *
   * <pre>
   * Total visit duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration visit_duration = 6;</code>
   *
   * @return The visitDuration.
   */
  com.google.protobuf.Duration getVisitDuration();
  /**
   *
   *
   * <pre>
   * Total visit duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration visit_duration = 6;</code>
   */
  com.google.protobuf.DurationOrBuilder getVisitDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * The total duration should be equal to the sum of all durations above.
   * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
   * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
   * </pre>
   *
   * <code>.google.protobuf.Duration total_duration = 7;</code>
   *
   * @return Whether the totalDuration field is set.
   */
  boolean hasTotalDuration();
  /**
   *
   *
   * <pre>
   * The total duration should be equal to the sum of all durations above.
   * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
   * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
   * </pre>
   *
   * <code>.google.protobuf.Duration total_duration = 7;</code>
   *
   * @return The totalDuration.
   */
  com.google.protobuf.Duration getTotalDuration();
  /**
   *
   *
   * <pre>
   * The total duration should be equal to the sum of all durations above.
   * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
   * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
   * </pre>
   *
   * <code>.google.protobuf.Duration total_duration = 7;</code>
   */
  com.google.protobuf.DurationOrBuilder getTotalDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Total travel distance for a route or a solution.
   * </pre>
   *
   * <code>double travel_distance_meters = 8;</code>
   *
   * @return The travelDistanceMeters.
   */
  double getTravelDistanceMeters();

  /**
   *
   *
   * <pre>
   * Maximum load achieved over the entire route (resp. solution), for each of
   * the quantities on this route (resp. solution), computed as the maximum over
   * all
   * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
   * (resp.
   * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
   * </code>
   */
  int getMaxLoadsCount();
  /**
   *
   *
   * <pre>
   * Maximum load achieved over the entire route (resp. solution), for each of
   * the quantities on this route (resp. solution), computed as the maximum over
   * all
   * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
   * (resp.
   * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
   * </code>
   */
  boolean containsMaxLoads(java.lang.String key);
  /** Use {@link #getMaxLoadsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
      getMaxLoads();
  /**
   *
   *
   * <pre>
   * Maximum load achieved over the entire route (resp. solution), for each of
   * the quantities on this route (resp. solution), computed as the maximum over
   * all
   * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
   * (resp.
   * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
   * </code>
   */
  java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
      getMaxLoadsMap();
  /**
   *
   *
   * <pre>
   * Maximum load achieved over the entire route (resp. solution), for each of
   * the quantities on this route (resp. solution), computed as the maximum over
   * all
   * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
   * (resp.
   * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
   * </code>
   */

  /* nullable */
  com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getMaxLoadsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad defaultValue);
  /**
   *
   *
   * <pre>
   * Maximum load achieved over the entire route (resp. solution), for each of
   * the quantities on this route (resp. solution), computed as the maximum over
   * all
   * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
   * (resp.
   * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
   * </code>
   */
  com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getMaxLoadsOrThrow(
      java.lang.String key);

  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
   * </pre>
   *
   * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  int getCostsCount();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
   * </pre>
   *
   * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  boolean containsCosts(java.lang.String key);
  /** Use {@link #getCostsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.Double> getCosts();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
   * </pre>
   *
   * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.Double> getCostsMap();
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
   * </pre>
   *
   * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  double getCostsOrDefault(java.lang.String key, double defaultValue);
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
   * </pre>
   *
   * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  double getCostsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.route_total_cost][] and [OptimizeToursResponse.Metrics.total_cost][] instead.
   * </pre>
   *
   * <code>double total_cost = 11 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.AggregatedMetrics.total_cost is deprecated. See
   *     google/cloud/optimization/v1/fleet_routing.proto;l=2206
   * @return The totalCost.
   */
  @java.lang.Deprecated
  double getTotalCost();
}
