/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/optimization/v1/fleet_routing.proto

package com.google.cloud.optimization.v1;

/**
 *
 *
 * <pre>
 * Aggregated metrics for [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute] (resp. for [OptimizeToursResponse][google.cloud.optimization.v1.OptimizeToursResponse]
 * over all [Transition][google.cloud.optimization.v1.ShipmentRoute.Transition]
 * and/or [Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] (resp. over
 * all [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute]) elements.
 * </pre>
 *
 * Protobuf type {@code google.cloud.optimization.v1.AggregatedMetrics}
 */
public final class AggregatedMetrics extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.optimization.v1.AggregatedMetrics)
    AggregatedMetricsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AggregatedMetrics.newBuilder() to construct.
  private AggregatedMetrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AggregatedMetrics() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AggregatedMetrics();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_AggregatedMetrics_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 9:
        return internalGetMaxLoads();
      case 10:
        return internalGetCosts();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.optimization.v1.FleetRoutingProto
        .internal_static_google_cloud_optimization_v1_AggregatedMetrics_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.optimization.v1.AggregatedMetrics.class,
            com.google.cloud.optimization.v1.AggregatedMetrics.Builder.class);
  }

  public static final int PERFORMED_SHIPMENT_COUNT_FIELD_NUMBER = 1;
  private int performedShipmentCount_;
  /**
   *
   *
   * <pre>
   * Number of shipments performed. Note that a pickup and delivery pair only
   * counts once.
   * </pre>
   *
   * <code>int32 performed_shipment_count = 1;</code>
   *
   * @return The performedShipmentCount.
   */
  @java.lang.Override
  public int getPerformedShipmentCount() {
    return performedShipmentCount_;
  }

  public static final int TRAVEL_DURATION_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration travelDuration_;
  /**
   *
   *
   * <pre>
   * Total travel duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration travel_duration = 2;</code>
   *
   * @return Whether the travelDuration field is set.
   */
  @java.lang.Override
  public boolean hasTravelDuration() {
    return travelDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Total travel duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration travel_duration = 2;</code>
   *
   * @return The travelDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTravelDuration() {
    return travelDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : travelDuration_;
  }
  /**
   *
   *
   * <pre>
   * Total travel duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration travel_duration = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTravelDurationOrBuilder() {
    return getTravelDuration();
  }

  public static final int WAIT_DURATION_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration waitDuration_;
  /**
   *
   *
   * <pre>
   * Total wait duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait_duration = 3;</code>
   *
   * @return Whether the waitDuration field is set.
   */
  @java.lang.Override
  public boolean hasWaitDuration() {
    return waitDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Total wait duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait_duration = 3;</code>
   *
   * @return The waitDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getWaitDuration() {
    return waitDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : waitDuration_;
  }
  /**
   *
   *
   * <pre>
   * Total wait duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration wait_duration = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getWaitDurationOrBuilder() {
    return getWaitDuration();
  }

  public static final int DELAY_DURATION_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration delayDuration_;
  /**
   *
   *
   * <pre>
   * Total delay duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration delay_duration = 4;</code>
   *
   * @return Whether the delayDuration field is set.
   */
  @java.lang.Override
  public boolean hasDelayDuration() {
    return delayDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Total delay duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration delay_duration = 4;</code>
   *
   * @return The delayDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDelayDuration() {
    return delayDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : delayDuration_;
  }
  /**
   *
   *
   * <pre>
   * Total delay duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration delay_duration = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDelayDurationOrBuilder() {
    return getDelayDuration();
  }

  public static final int BREAK_DURATION_FIELD_NUMBER = 5;
  private com.google.protobuf.Duration breakDuration_;
  /**
   *
   *
   * <pre>
   * Total break duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration break_duration = 5;</code>
   *
   * @return Whether the breakDuration field is set.
   */
  @java.lang.Override
  public boolean hasBreakDuration() {
    return breakDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Total break duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration break_duration = 5;</code>
   *
   * @return The breakDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getBreakDuration() {
    return breakDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : breakDuration_;
  }
  /**
   *
   *
   * <pre>
   * Total break duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration break_duration = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getBreakDurationOrBuilder() {
    return getBreakDuration();
  }

  public static final int VISIT_DURATION_FIELD_NUMBER = 6;
  private com.google.protobuf.Duration visitDuration_;
  /**
   *
   *
   * <pre>
   * Total visit duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration visit_duration = 6;</code>
   *
   * @return Whether the visitDuration field is set.
   */
  @java.lang.Override
  public boolean hasVisitDuration() {
    return visitDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Total visit duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration visit_duration = 6;</code>
   *
   * @return The visitDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getVisitDuration() {
    return visitDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : visitDuration_;
  }
  /**
   *
   *
   * <pre>
   * Total visit duration for a route or a solution.
   * </pre>
   *
   * <code>.google.protobuf.Duration visit_duration = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getVisitDurationOrBuilder() {
    return getVisitDuration();
  }

  public static final int TOTAL_DURATION_FIELD_NUMBER = 7;
  private com.google.protobuf.Duration totalDuration_;
  /**
   *
   *
   * <pre>
   * The total duration should be equal to the sum of all durations above.
   * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
   * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
   * </pre>
   *
   * <code>.google.protobuf.Duration total_duration = 7;</code>
   *
   * @return Whether the totalDuration field is set.
   */
  @java.lang.Override
  public boolean hasTotalDuration() {
    return totalDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * The total duration should be equal to the sum of all durations above.
   * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
   * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
   * </pre>
   *
   * <code>.google.protobuf.Duration total_duration = 7;</code>
   *
   * @return The totalDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTotalDuration() {
    return totalDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : totalDuration_;
  }
  /**
   *
   *
   * <pre>
   * The total duration should be equal to the sum of all durations above.
   * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
   * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
   * </pre>
   *
   * <code>.google.protobuf.Duration total_duration = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTotalDurationOrBuilder() {
    return getTotalDuration();
  }

  public static final int TRAVEL_DISTANCE_METERS_FIELD_NUMBER = 8;
  private double travelDistanceMeters_;
  /**
   *
   *
   * <pre>
   * Total travel distance for a route or a solution.
   * </pre>
   *
   * <code>double travel_distance_meters = 8;</code>
   *
   * @return The travelDistanceMeters.
   */
  @java.lang.Override
  public double getTravelDistanceMeters() {
    return travelDistanceMeters_;
  }

  public static final int MAX_LOADS_FIELD_NUMBER = 9;

  private static final class MaxLoadsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
                    newDefaultInstance(
                        com.google.cloud.optimization.v1.FleetRoutingProto
                            .internal_static_google_cloud_optimization_v1_AggregatedMetrics_MaxLoadsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad
                            .getDefaultInstance());
  }

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
      maxLoads_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
      internalGetMaxLoads() {
    if (maxLoads_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MaxLoadsDefaultEntryHolder.defaultEntry);
    }
    return maxLoads_;
  }

  public int getMaxLoadsCount() {
    return internalGetMaxLoads().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Maximum load achieved over the entire route (resp. solution), for each of
   * the quantities on this route (resp. solution), computed as the maximum over
   * all
   * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
   * (resp.
   * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
   * </code>
   */
  @java.lang.Override
  public boolean containsMaxLoads(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMaxLoads().getMap().containsKey(key);
  }
  /** Use {@link #getMaxLoadsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
      getMaxLoads() {
    return getMaxLoadsMap();
  }
  /**
   *
   *
   * <pre>
   * Maximum load achieved over the entire route (resp. solution), for each of
   * the quantities on this route (resp. solution), computed as the maximum over
   * all
   * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
   * (resp.
   * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
      getMaxLoadsMap() {
    return internalGetMaxLoads().getMap();
  }
  /**
   *
   *
   * <pre>
   * Maximum load achieved over the entire route (resp. solution), for each of
   * the quantities on this route (resp. solution), computed as the maximum over
   * all
   * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
   * (resp.
   * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getMaxLoadsOrDefault(
      java.lang.String key,
      com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        map = internalGetMaxLoads().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Maximum load achieved over the entire route (resp. solution), for each of
   * the quantities on this route (resp. solution), computed as the maximum over
   * all
   * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
   * (resp.
   * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getMaxLoadsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        map = internalGetMaxLoads().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int COSTS_FIELD_NUMBER = 10;

  private static final class CostsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Double>newDefaultInstance(
            com.google.cloud.optimization.v1.FleetRoutingProto
                .internal_static_google_cloud_optimization_v1_AggregatedMetrics_CostsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.DOUBLE,
            0D);
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.Double> costs_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Double> internalGetCosts() {
    if (costs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(CostsDefaultEntryHolder.defaultEntry);
    }
    return costs_;
  }

  @java.lang.Deprecated
  public int getCostsCount() {
    return internalGetCosts().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
   * </pre>
   *
   * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  @java.lang.Override
  public boolean containsCosts(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetCosts().getMap().containsKey(key);
  }
  /** Use {@link #getCostsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Double> getCosts() {
    return getCostsMap();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
   * </pre>
   *
   * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Double> getCostsMap() {
    return internalGetCosts().getMap();
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
   * </pre>
   *
   * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public double getCostsOrDefault(java.lang.String key, double defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Double> map = internalGetCosts().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
   * </pre>
   *
   * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public double getCostsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Double> map = internalGetCosts().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TOTAL_COST_FIELD_NUMBER = 11;
  private double totalCost_;
  /**
   *
   *
   * <pre>
   * Deprecated: Use [ShipmentRoute.route_total_cost][] and [OptimizeToursResponse.Metrics.total_cost][] instead.
   * </pre>
   *
   * <code>double total_cost = 11 [deprecated = true];</code>
   *
   * @deprecated google.cloud.optimization.v1.AggregatedMetrics.total_cost is deprecated. See
   *     google/cloud/optimization/v1/fleet_routing.proto;l=2206
   * @return The totalCost.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public double getTotalCost() {
    return totalCost_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (performedShipmentCount_ != 0) {
      output.writeInt32(1, performedShipmentCount_);
    }
    if (travelDuration_ != null) {
      output.writeMessage(2, getTravelDuration());
    }
    if (waitDuration_ != null) {
      output.writeMessage(3, getWaitDuration());
    }
    if (delayDuration_ != null) {
      output.writeMessage(4, getDelayDuration());
    }
    if (breakDuration_ != null) {
      output.writeMessage(5, getBreakDuration());
    }
    if (visitDuration_ != null) {
      output.writeMessage(6, getVisitDuration());
    }
    if (totalDuration_ != null) {
      output.writeMessage(7, getTotalDuration());
    }
    if (java.lang.Double.doubleToRawLongBits(travelDistanceMeters_) != 0) {
      output.writeDouble(8, travelDistanceMeters_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMaxLoads(), MaxLoadsDefaultEntryHolder.defaultEntry, 9);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetCosts(), CostsDefaultEntryHolder.defaultEntry, 10);
    if (java.lang.Double.doubleToRawLongBits(totalCost_) != 0) {
      output.writeDouble(11, totalCost_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (performedShipmentCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, performedShipmentCount_);
    }
    if (travelDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTravelDuration());
    }
    if (waitDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getWaitDuration());
    }
    if (delayDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDelayDuration());
    }
    if (breakDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getBreakDuration());
    }
    if (visitDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getVisitDuration());
    }
    if (totalDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTotalDuration());
    }
    if (java.lang.Double.doubleToRawLongBits(travelDistanceMeters_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(8, travelDistanceMeters_);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        entry : internalGetMaxLoads().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          maxLoads__ =
              MaxLoadsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, maxLoads__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Double> entry :
        internalGetCosts().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> costs__ =
          CostsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, costs__);
    }
    if (java.lang.Double.doubleToRawLongBits(totalCost_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(11, totalCost_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.optimization.v1.AggregatedMetrics)) {
      return super.equals(obj);
    }
    com.google.cloud.optimization.v1.AggregatedMetrics other =
        (com.google.cloud.optimization.v1.AggregatedMetrics) obj;

    if (getPerformedShipmentCount() != other.getPerformedShipmentCount()) return false;
    if (hasTravelDuration() != other.hasTravelDuration()) return false;
    if (hasTravelDuration()) {
      if (!getTravelDuration().equals(other.getTravelDuration())) return false;
    }
    if (hasWaitDuration() != other.hasWaitDuration()) return false;
    if (hasWaitDuration()) {
      if (!getWaitDuration().equals(other.getWaitDuration())) return false;
    }
    if (hasDelayDuration() != other.hasDelayDuration()) return false;
    if (hasDelayDuration()) {
      if (!getDelayDuration().equals(other.getDelayDuration())) return false;
    }
    if (hasBreakDuration() != other.hasBreakDuration()) return false;
    if (hasBreakDuration()) {
      if (!getBreakDuration().equals(other.getBreakDuration())) return false;
    }
    if (hasVisitDuration() != other.hasVisitDuration()) return false;
    if (hasVisitDuration()) {
      if (!getVisitDuration().equals(other.getVisitDuration())) return false;
    }
    if (hasTotalDuration() != other.hasTotalDuration()) return false;
    if (hasTotalDuration()) {
      if (!getTotalDuration().equals(other.getTotalDuration())) return false;
    }
    if (java.lang.Double.doubleToLongBits(getTravelDistanceMeters())
        != java.lang.Double.doubleToLongBits(other.getTravelDistanceMeters())) return false;
    if (!internalGetMaxLoads().equals(other.internalGetMaxLoads())) return false;
    if (!internalGetCosts().equals(other.internalGetCosts())) return false;
    if (java.lang.Double.doubleToLongBits(getTotalCost())
        != java.lang.Double.doubleToLongBits(other.getTotalCost())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PERFORMED_SHIPMENT_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getPerformedShipmentCount();
    if (hasTravelDuration()) {
      hash = (37 * hash) + TRAVEL_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getTravelDuration().hashCode();
    }
    if (hasWaitDuration()) {
      hash = (37 * hash) + WAIT_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getWaitDuration().hashCode();
    }
    if (hasDelayDuration()) {
      hash = (37 * hash) + DELAY_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getDelayDuration().hashCode();
    }
    if (hasBreakDuration()) {
      hash = (37 * hash) + BREAK_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getBreakDuration().hashCode();
    }
    if (hasVisitDuration()) {
      hash = (37 * hash) + VISIT_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getVisitDuration().hashCode();
    }
    if (hasTotalDuration()) {
      hash = (37 * hash) + TOTAL_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getTotalDuration().hashCode();
    }
    hash = (37 * hash) + TRAVEL_DISTANCE_METERS_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getTravelDistanceMeters()));
    if (!internalGetMaxLoads().getMap().isEmpty()) {
      hash = (37 * hash) + MAX_LOADS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMaxLoads().hashCode();
    }
    if (!internalGetCosts().getMap().isEmpty()) {
      hash = (37 * hash) + COSTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetCosts().hashCode();
    }
    hash = (37 * hash) + TOTAL_COST_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getTotalCost()));
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.optimization.v1.AggregatedMetrics prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Aggregated metrics for [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute] (resp. for [OptimizeToursResponse][google.cloud.optimization.v1.OptimizeToursResponse]
   * over all [Transition][google.cloud.optimization.v1.ShipmentRoute.Transition]
   * and/or [Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] (resp. over
   * all [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute]) elements.
   * </pre>
   *
   * Protobuf type {@code google.cloud.optimization.v1.AggregatedMetrics}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.optimization.v1.AggregatedMetrics)
      com.google.cloud.optimization.v1.AggregatedMetricsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_AggregatedMetrics_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 9:
          return internalGetMaxLoads();
        case 10:
          return internalGetCosts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 9:
          return internalGetMutableMaxLoads();
        case 10:
          return internalGetMutableCosts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_AggregatedMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.optimization.v1.AggregatedMetrics.class,
              com.google.cloud.optimization.v1.AggregatedMetrics.Builder.class);
    }

    // Construct using com.google.cloud.optimization.v1.AggregatedMetrics.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      performedShipmentCount_ = 0;

      if (travelDurationBuilder_ == null) {
        travelDuration_ = null;
      } else {
        travelDuration_ = null;
        travelDurationBuilder_ = null;
      }
      if (waitDurationBuilder_ == null) {
        waitDuration_ = null;
      } else {
        waitDuration_ = null;
        waitDurationBuilder_ = null;
      }
      if (delayDurationBuilder_ == null) {
        delayDuration_ = null;
      } else {
        delayDuration_ = null;
        delayDurationBuilder_ = null;
      }
      if (breakDurationBuilder_ == null) {
        breakDuration_ = null;
      } else {
        breakDuration_ = null;
        breakDurationBuilder_ = null;
      }
      if (visitDurationBuilder_ == null) {
        visitDuration_ = null;
      } else {
        visitDuration_ = null;
        visitDurationBuilder_ = null;
      }
      if (totalDurationBuilder_ == null) {
        totalDuration_ = null;
      } else {
        totalDuration_ = null;
        totalDurationBuilder_ = null;
      }
      travelDistanceMeters_ = 0D;

      internalGetMutableMaxLoads().clear();
      internalGetMutableCosts().clear();
      totalCost_ = 0D;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.optimization.v1.FleetRoutingProto
          .internal_static_google_cloud_optimization_v1_AggregatedMetrics_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.AggregatedMetrics getDefaultInstanceForType() {
      return com.google.cloud.optimization.v1.AggregatedMetrics.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.AggregatedMetrics build() {
      com.google.cloud.optimization.v1.AggregatedMetrics result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.optimization.v1.AggregatedMetrics buildPartial() {
      com.google.cloud.optimization.v1.AggregatedMetrics result =
          new com.google.cloud.optimization.v1.AggregatedMetrics(this);
      int from_bitField0_ = bitField0_;
      result.performedShipmentCount_ = performedShipmentCount_;
      if (travelDurationBuilder_ == null) {
        result.travelDuration_ = travelDuration_;
      } else {
        result.travelDuration_ = travelDurationBuilder_.build();
      }
      if (waitDurationBuilder_ == null) {
        result.waitDuration_ = waitDuration_;
      } else {
        result.waitDuration_ = waitDurationBuilder_.build();
      }
      if (delayDurationBuilder_ == null) {
        result.delayDuration_ = delayDuration_;
      } else {
        result.delayDuration_ = delayDurationBuilder_.build();
      }
      if (breakDurationBuilder_ == null) {
        result.breakDuration_ = breakDuration_;
      } else {
        result.breakDuration_ = breakDurationBuilder_.build();
      }
      if (visitDurationBuilder_ == null) {
        result.visitDuration_ = visitDuration_;
      } else {
        result.visitDuration_ = visitDurationBuilder_.build();
      }
      if (totalDurationBuilder_ == null) {
        result.totalDuration_ = totalDuration_;
      } else {
        result.totalDuration_ = totalDurationBuilder_.build();
      }
      result.travelDistanceMeters_ = travelDistanceMeters_;
      result.maxLoads_ = internalGetMaxLoads();
      result.maxLoads_.makeImmutable();
      result.costs_ = internalGetCosts();
      result.costs_.makeImmutable();
      result.totalCost_ = totalCost_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.optimization.v1.AggregatedMetrics) {
        return mergeFrom((com.google.cloud.optimization.v1.AggregatedMetrics) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.optimization.v1.AggregatedMetrics other) {
      if (other == com.google.cloud.optimization.v1.AggregatedMetrics.getDefaultInstance())
        return this;
      if (other.getPerformedShipmentCount() != 0) {
        setPerformedShipmentCount(other.getPerformedShipmentCount());
      }
      if (other.hasTravelDuration()) {
        mergeTravelDuration(other.getTravelDuration());
      }
      if (other.hasWaitDuration()) {
        mergeWaitDuration(other.getWaitDuration());
      }
      if (other.hasDelayDuration()) {
        mergeDelayDuration(other.getDelayDuration());
      }
      if (other.hasBreakDuration()) {
        mergeBreakDuration(other.getBreakDuration());
      }
      if (other.hasVisitDuration()) {
        mergeVisitDuration(other.getVisitDuration());
      }
      if (other.hasTotalDuration()) {
        mergeTotalDuration(other.getTotalDuration());
      }
      if (other.getTravelDistanceMeters() != 0D) {
        setTravelDistanceMeters(other.getTravelDistanceMeters());
      }
      internalGetMutableMaxLoads().mergeFrom(other.internalGetMaxLoads());
      internalGetMutableCosts().mergeFrom(other.internalGetCosts());
      if (other.getTotalCost() != 0D) {
        setTotalCost(other.getTotalCost());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                performedShipmentCount_ = input.readInt32();

                break;
              } // case 8
            case 18:
              {
                input.readMessage(getTravelDurationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getWaitDurationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDelayDurationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getBreakDurationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getVisitDurationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                input.readMessage(getTotalDurationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 65:
              {
                travelDistanceMeters_ = input.readDouble();

                break;
              } // case 65
            case 74:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
                    maxLoads__ =
                        input.readMessage(
                            MaxLoadsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableMaxLoads()
                    .getMutableMap()
                    .put(maxLoads__.getKey(), maxLoads__.getValue());
                break;
              } // case 74
            case 82:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> costs__ =
                    input.readMessage(
                        CostsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableCosts().getMutableMap().put(costs__.getKey(), costs__.getValue());
                break;
              } // case 82
            case 89:
              {
                totalCost_ = input.readDouble();

                break;
              } // case 89
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int performedShipmentCount_;
    /**
     *
     *
     * <pre>
     * Number of shipments performed. Note that a pickup and delivery pair only
     * counts once.
     * </pre>
     *
     * <code>int32 performed_shipment_count = 1;</code>
     *
     * @return The performedShipmentCount.
     */
    @java.lang.Override
    public int getPerformedShipmentCount() {
      return performedShipmentCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of shipments performed. Note that a pickup and delivery pair only
     * counts once.
     * </pre>
     *
     * <code>int32 performed_shipment_count = 1;</code>
     *
     * @param value The performedShipmentCount to set.
     * @return This builder for chaining.
     */
    public Builder setPerformedShipmentCount(int value) {

      performedShipmentCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of shipments performed. Note that a pickup and delivery pair only
     * counts once.
     * </pre>
     *
     * <code>int32 performed_shipment_count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPerformedShipmentCount() {

      performedShipmentCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration travelDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        travelDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Total travel duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     *
     * @return Whether the travelDuration field is set.
     */
    public boolean hasTravelDuration() {
      return travelDurationBuilder_ != null || travelDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Total travel duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     *
     * @return The travelDuration.
     */
    public com.google.protobuf.Duration getTravelDuration() {
      if (travelDurationBuilder_ == null) {
        return travelDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : travelDuration_;
      } else {
        return travelDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Total travel duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     */
    public Builder setTravelDuration(com.google.protobuf.Duration value) {
      if (travelDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        travelDuration_ = value;
        onChanged();
      } else {
        travelDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total travel duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     */
    public Builder setTravelDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (travelDurationBuilder_ == null) {
        travelDuration_ = builderForValue.build();
        onChanged();
      } else {
        travelDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total travel duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     */
    public Builder mergeTravelDuration(com.google.protobuf.Duration value) {
      if (travelDurationBuilder_ == null) {
        if (travelDuration_ != null) {
          travelDuration_ =
              com.google.protobuf.Duration.newBuilder(travelDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          travelDuration_ = value;
        }
        onChanged();
      } else {
        travelDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total travel duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     */
    public Builder clearTravelDuration() {
      if (travelDurationBuilder_ == null) {
        travelDuration_ = null;
        onChanged();
      } else {
        travelDuration_ = null;
        travelDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total travel duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getTravelDurationBuilder() {

      onChanged();
      return getTravelDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Total travel duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTravelDurationOrBuilder() {
      if (travelDurationBuilder_ != null) {
        return travelDurationBuilder_.getMessageOrBuilder();
      } else {
        return travelDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : travelDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Total travel duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTravelDurationFieldBuilder() {
      if (travelDurationBuilder_ == null) {
        travelDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTravelDuration(), getParentForChildren(), isClean());
        travelDuration_ = null;
      }
      return travelDurationBuilder_;
    }

    private com.google.protobuf.Duration waitDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        waitDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Total wait duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 3;</code>
     *
     * @return Whether the waitDuration field is set.
     */
    public boolean hasWaitDuration() {
      return waitDurationBuilder_ != null || waitDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Total wait duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 3;</code>
     *
     * @return The waitDuration.
     */
    public com.google.protobuf.Duration getWaitDuration() {
      if (waitDurationBuilder_ == null) {
        return waitDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : waitDuration_;
      } else {
        return waitDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Total wait duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 3;</code>
     */
    public Builder setWaitDuration(com.google.protobuf.Duration value) {
      if (waitDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        waitDuration_ = value;
        onChanged();
      } else {
        waitDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total wait duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 3;</code>
     */
    public Builder setWaitDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (waitDurationBuilder_ == null) {
        waitDuration_ = builderForValue.build();
        onChanged();
      } else {
        waitDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total wait duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 3;</code>
     */
    public Builder mergeWaitDuration(com.google.protobuf.Duration value) {
      if (waitDurationBuilder_ == null) {
        if (waitDuration_ != null) {
          waitDuration_ =
              com.google.protobuf.Duration.newBuilder(waitDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          waitDuration_ = value;
        }
        onChanged();
      } else {
        waitDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total wait duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 3;</code>
     */
    public Builder clearWaitDuration() {
      if (waitDurationBuilder_ == null) {
        waitDuration_ = null;
        onChanged();
      } else {
        waitDuration_ = null;
        waitDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total wait duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getWaitDurationBuilder() {

      onChanged();
      return getWaitDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Total wait duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getWaitDurationOrBuilder() {
      if (waitDurationBuilder_ != null) {
        return waitDurationBuilder_.getMessageOrBuilder();
      } else {
        return waitDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : waitDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Total wait duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration wait_duration = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getWaitDurationFieldBuilder() {
      if (waitDurationBuilder_ == null) {
        waitDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getWaitDuration(), getParentForChildren(), isClean());
        waitDuration_ = null;
      }
      return waitDurationBuilder_;
    }

    private com.google.protobuf.Duration delayDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        delayDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Total delay duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     *
     * @return Whether the delayDuration field is set.
     */
    public boolean hasDelayDuration() {
      return delayDurationBuilder_ != null || delayDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Total delay duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     *
     * @return The delayDuration.
     */
    public com.google.protobuf.Duration getDelayDuration() {
      if (delayDurationBuilder_ == null) {
        return delayDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : delayDuration_;
      } else {
        return delayDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Total delay duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     */
    public Builder setDelayDuration(com.google.protobuf.Duration value) {
      if (delayDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        delayDuration_ = value;
        onChanged();
      } else {
        delayDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total delay duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     */
    public Builder setDelayDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (delayDurationBuilder_ == null) {
        delayDuration_ = builderForValue.build();
        onChanged();
      } else {
        delayDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total delay duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     */
    public Builder mergeDelayDuration(com.google.protobuf.Duration value) {
      if (delayDurationBuilder_ == null) {
        if (delayDuration_ != null) {
          delayDuration_ =
              com.google.protobuf.Duration.newBuilder(delayDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          delayDuration_ = value;
        }
        onChanged();
      } else {
        delayDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total delay duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     */
    public Builder clearDelayDuration() {
      if (delayDurationBuilder_ == null) {
        delayDuration_ = null;
        onChanged();
      } else {
        delayDuration_ = null;
        delayDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total delay duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getDelayDurationBuilder() {

      onChanged();
      return getDelayDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Total delay duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getDelayDurationOrBuilder() {
      if (delayDurationBuilder_ != null) {
        return delayDurationBuilder_.getMessageOrBuilder();
      } else {
        return delayDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : delayDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Total delay duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration delay_duration = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDelayDurationFieldBuilder() {
      if (delayDurationBuilder_ == null) {
        delayDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDelayDuration(), getParentForChildren(), isClean());
        delayDuration_ = null;
      }
      return delayDurationBuilder_;
    }

    private com.google.protobuf.Duration breakDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        breakDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Total break duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     *
     * @return Whether the breakDuration field is set.
     */
    public boolean hasBreakDuration() {
      return breakDurationBuilder_ != null || breakDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Total break duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     *
     * @return The breakDuration.
     */
    public com.google.protobuf.Duration getBreakDuration() {
      if (breakDurationBuilder_ == null) {
        return breakDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : breakDuration_;
      } else {
        return breakDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Total break duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     */
    public Builder setBreakDuration(com.google.protobuf.Duration value) {
      if (breakDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        breakDuration_ = value;
        onChanged();
      } else {
        breakDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total break duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     */
    public Builder setBreakDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (breakDurationBuilder_ == null) {
        breakDuration_ = builderForValue.build();
        onChanged();
      } else {
        breakDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total break duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     */
    public Builder mergeBreakDuration(com.google.protobuf.Duration value) {
      if (breakDurationBuilder_ == null) {
        if (breakDuration_ != null) {
          breakDuration_ =
              com.google.protobuf.Duration.newBuilder(breakDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          breakDuration_ = value;
        }
        onChanged();
      } else {
        breakDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total break duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     */
    public Builder clearBreakDuration() {
      if (breakDurationBuilder_ == null) {
        breakDuration_ = null;
        onChanged();
      } else {
        breakDuration_ = null;
        breakDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total break duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getBreakDurationBuilder() {

      onChanged();
      return getBreakDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Total break duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     */
    public com.google.protobuf.DurationOrBuilder getBreakDurationOrBuilder() {
      if (breakDurationBuilder_ != null) {
        return breakDurationBuilder_.getMessageOrBuilder();
      } else {
        return breakDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : breakDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Total break duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration break_duration = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getBreakDurationFieldBuilder() {
      if (breakDurationBuilder_ == null) {
        breakDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getBreakDuration(), getParentForChildren(), isClean());
        breakDuration_ = null;
      }
      return breakDurationBuilder_;
    }

    private com.google.protobuf.Duration visitDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        visitDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Total visit duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration visit_duration = 6;</code>
     *
     * @return Whether the visitDuration field is set.
     */
    public boolean hasVisitDuration() {
      return visitDurationBuilder_ != null || visitDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Total visit duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration visit_duration = 6;</code>
     *
     * @return The visitDuration.
     */
    public com.google.protobuf.Duration getVisitDuration() {
      if (visitDurationBuilder_ == null) {
        return visitDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : visitDuration_;
      } else {
        return visitDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Total visit duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration visit_duration = 6;</code>
     */
    public Builder setVisitDuration(com.google.protobuf.Duration value) {
      if (visitDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        visitDuration_ = value;
        onChanged();
      } else {
        visitDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total visit duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration visit_duration = 6;</code>
     */
    public Builder setVisitDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (visitDurationBuilder_ == null) {
        visitDuration_ = builderForValue.build();
        onChanged();
      } else {
        visitDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total visit duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration visit_duration = 6;</code>
     */
    public Builder mergeVisitDuration(com.google.protobuf.Duration value) {
      if (visitDurationBuilder_ == null) {
        if (visitDuration_ != null) {
          visitDuration_ =
              com.google.protobuf.Duration.newBuilder(visitDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          visitDuration_ = value;
        }
        onChanged();
      } else {
        visitDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total visit duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration visit_duration = 6;</code>
     */
    public Builder clearVisitDuration() {
      if (visitDurationBuilder_ == null) {
        visitDuration_ = null;
        onChanged();
      } else {
        visitDuration_ = null;
        visitDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Total visit duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration visit_duration = 6;</code>
     */
    public com.google.protobuf.Duration.Builder getVisitDurationBuilder() {

      onChanged();
      return getVisitDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Total visit duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration visit_duration = 6;</code>
     */
    public com.google.protobuf.DurationOrBuilder getVisitDurationOrBuilder() {
      if (visitDurationBuilder_ != null) {
        return visitDurationBuilder_.getMessageOrBuilder();
      } else {
        return visitDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : visitDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Total visit duration for a route or a solution.
     * </pre>
     *
     * <code>.google.protobuf.Duration visit_duration = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getVisitDurationFieldBuilder() {
      if (visitDurationBuilder_ == null) {
        visitDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getVisitDuration(), getParentForChildren(), isClean());
        visitDuration_ = null;
      }
      return visitDurationBuilder_;
    }

    private com.google.protobuf.Duration totalDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        totalDurationBuilder_;
    /**
     *
     *
     * <pre>
     * The total duration should be equal to the sum of all durations above.
     * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
     * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     *
     * @return Whether the totalDuration field is set.
     */
    public boolean hasTotalDuration() {
      return totalDurationBuilder_ != null || totalDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * The total duration should be equal to the sum of all durations above.
     * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
     * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     *
     * @return The totalDuration.
     */
    public com.google.protobuf.Duration getTotalDuration() {
      if (totalDurationBuilder_ == null) {
        return totalDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : totalDuration_;
      } else {
        return totalDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The total duration should be equal to the sum of all durations above.
     * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
     * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     */
    public Builder setTotalDuration(com.google.protobuf.Duration value) {
      if (totalDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        totalDuration_ = value;
        onChanged();
      } else {
        totalDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The total duration should be equal to the sum of all durations above.
     * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
     * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     */
    public Builder setTotalDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (totalDurationBuilder_ == null) {
        totalDuration_ = builderForValue.build();
        onChanged();
      } else {
        totalDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The total duration should be equal to the sum of all durations above.
     * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
     * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     */
    public Builder mergeTotalDuration(com.google.protobuf.Duration value) {
      if (totalDurationBuilder_ == null) {
        if (totalDuration_ != null) {
          totalDuration_ =
              com.google.protobuf.Duration.newBuilder(totalDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          totalDuration_ = value;
        }
        onChanged();
      } else {
        totalDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The total duration should be equal to the sum of all durations above.
     * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
     * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     */
    public Builder clearTotalDuration() {
      if (totalDurationBuilder_ == null) {
        totalDuration_ = null;
        onChanged();
      } else {
        totalDuration_ = null;
        totalDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The total duration should be equal to the sum of all durations above.
     * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
     * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     */
    public com.google.protobuf.Duration.Builder getTotalDurationBuilder() {

      onChanged();
      return getTotalDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The total duration should be equal to the sum of all durations above.
     * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
     * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTotalDurationOrBuilder() {
      if (totalDurationBuilder_ != null) {
        return totalDurationBuilder_.getMessageOrBuilder();
      } else {
        return totalDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : totalDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The total duration should be equal to the sum of all durations above.
     * For routes, it also corresponds to [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time] -
     * [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTotalDurationFieldBuilder() {
      if (totalDurationBuilder_ == null) {
        totalDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTotalDuration(), getParentForChildren(), isClean());
        totalDuration_ = null;
      }
      return totalDurationBuilder_;
    }

    private double travelDistanceMeters_;
    /**
     *
     *
     * <pre>
     * Total travel distance for a route or a solution.
     * </pre>
     *
     * <code>double travel_distance_meters = 8;</code>
     *
     * @return The travelDistanceMeters.
     */
    @java.lang.Override
    public double getTravelDistanceMeters() {
      return travelDistanceMeters_;
    }
    /**
     *
     *
     * <pre>
     * Total travel distance for a route or a solution.
     * </pre>
     *
     * <code>double travel_distance_meters = 8;</code>
     *
     * @param value The travelDistanceMeters to set.
     * @return This builder for chaining.
     */
    public Builder setTravelDistanceMeters(double value) {

      travelDistanceMeters_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total travel distance for a route or a solution.
     * </pre>
     *
     * <code>double travel_distance_meters = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTravelDistanceMeters() {

      travelDistanceMeters_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        maxLoads_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        internalGetMaxLoads() {
      if (maxLoads_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MaxLoadsDefaultEntryHolder.defaultEntry);
      }
      return maxLoads_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        internalGetMutableMaxLoads() {
      onChanged();
      ;
      if (maxLoads_ == null) {
        maxLoads_ =
            com.google.protobuf.MapField.newMapField(MaxLoadsDefaultEntryHolder.defaultEntry);
      }
      if (!maxLoads_.isMutable()) {
        maxLoads_ = maxLoads_.copy();
      }
      return maxLoads_;
    }

    public int getMaxLoadsCount() {
      return internalGetMaxLoads().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Maximum load achieved over the entire route (resp. solution), for each of
     * the quantities on this route (resp. solution), computed as the maximum over
     * all
     * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
     * (resp.
     * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
     * </code>
     */
    @java.lang.Override
    public boolean containsMaxLoads(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMaxLoads().getMap().containsKey(key);
    }
    /** Use {@link #getMaxLoadsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        getMaxLoads() {
      return getMaxLoadsMap();
    }
    /**
     *
     *
     * <pre>
     * Maximum load achieved over the entire route (resp. solution), for each of
     * the quantities on this route (resp. solution), computed as the maximum over
     * all
     * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
     * (resp.
     * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        getMaxLoadsMap() {
      return internalGetMaxLoads().getMap();
    }
    /**
     *
     *
     * <pre>
     * Maximum load achieved over the entire route (resp. solution), for each of
     * the quantities on this route (resp. solution), computed as the maximum over
     * all
     * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
     * (resp.
     * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getMaxLoadsOrDefault(
        java.lang.String key,
        com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          map = internalGetMaxLoads().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Maximum load achieved over the entire route (resp. solution), for each of
     * the quantities on this route (resp. solution), computed as the maximum over
     * all
     * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
     * (resp.
     * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad getMaxLoadsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
          map = internalGetMaxLoads().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMaxLoads() {
      internalGetMutableMaxLoads().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum load achieved over the entire route (resp. solution), for each of
     * the quantities on this route (resp. solution), computed as the maximum over
     * all
     * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
     * (resp.
     * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
     * </code>
     */
    public Builder removeMaxLoads(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMaxLoads().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
        getMutableMaxLoads() {
      return internalGetMutableMaxLoads().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Maximum load achieved over the entire route (resp. solution), for each of
     * the quantities on this route (resp. solution), computed as the maximum over
     * all
     * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
     * (resp.
     * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
     * </code>
     */
    public Builder putMaxLoads(
        java.lang.String key, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableMaxLoads().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum load achieved over the entire route (resp. solution), for each of
     * the quantities on this route (resp. solution), computed as the maximum over
     * all
     * [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
     * (resp.
     * [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.optimization.v1.ShipmentRoute.VehicleLoad&gt; max_loads = 9;
     * </code>
     */
    public Builder putAllMaxLoads(
        java.util.Map<java.lang.String, com.google.cloud.optimization.v1.ShipmentRoute.VehicleLoad>
            values) {
      internalGetMutableMaxLoads().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double> costs_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double> internalGetCosts() {
      if (costs_ == null) {
        return com.google.protobuf.MapField.emptyMapField(CostsDefaultEntryHolder.defaultEntry);
      }
      return costs_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double>
        internalGetMutableCosts() {
      onChanged();
      ;
      if (costs_ == null) {
        costs_ = com.google.protobuf.MapField.newMapField(CostsDefaultEntryHolder.defaultEntry);
      }
      if (!costs_.isMutable()) {
        costs_ = costs_.copy();
      }
      return costs_;
    }

    @java.lang.Deprecated
    public int getCostsCount() {
      return internalGetCosts().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    @java.lang.Override
    public boolean containsCosts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetCosts().getMap().containsKey(key);
    }
    /** Use {@link #getCostsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Double> getCosts() {
      return getCostsMap();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Double> getCostsMap() {
      return internalGetCosts().getMap();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public double getCostsOrDefault(java.lang.String key, double defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetCosts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public double getCostsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetCosts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    @java.lang.Deprecated
    public Builder clearCosts() {
      internalGetMutableCosts().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder removeCosts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableCosts().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Double> getMutableCosts() {
      return internalGetMutableCosts().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder putCosts(java.lang.String key, double value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableCosts().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.route_costs][] and [OptimizeToursResponse.Metrics.costs][] instead.
     * </pre>
     *
     * <code>map&lt;string, double&gt; costs = 10 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder putAllCosts(java.util.Map<java.lang.String, java.lang.Double> values) {
      internalGetMutableCosts().getMutableMap().putAll(values);
      return this;
    }

    private double totalCost_;
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.route_total_cost][] and [OptimizeToursResponse.Metrics.total_cost][] instead.
     * </pre>
     *
     * <code>double total_cost = 11 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.AggregatedMetrics.total_cost is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=2206
     * @return The totalCost.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public double getTotalCost() {
      return totalCost_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.route_total_cost][] and [OptimizeToursResponse.Metrics.total_cost][] instead.
     * </pre>
     *
     * <code>double total_cost = 11 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.AggregatedMetrics.total_cost is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=2206
     * @param value The totalCost to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setTotalCost(double value) {

      totalCost_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use [ShipmentRoute.route_total_cost][] and [OptimizeToursResponse.Metrics.total_cost][] instead.
     * </pre>
     *
     * <code>double total_cost = 11 [deprecated = true];</code>
     *
     * @deprecated google.cloud.optimization.v1.AggregatedMetrics.total_cost is deprecated. See
     *     google/cloud/optimization/v1/fleet_routing.proto;l=2206
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearTotalCost() {

      totalCost_ = 0D;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.optimization.v1.AggregatedMetrics)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.optimization.v1.AggregatedMetrics)
  private static final com.google.cloud.optimization.v1.AggregatedMetrics DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.optimization.v1.AggregatedMetrics();
  }

  public static com.google.cloud.optimization.v1.AggregatedMetrics getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AggregatedMetrics> PARSER =
      new com.google.protobuf.AbstractParser<AggregatedMetrics>() {
        @java.lang.Override
        public AggregatedMetrics parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AggregatedMetrics> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AggregatedMetrics> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.optimization.v1.AggregatedMetrics getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
