/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/metric_service.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * The `QueryTimeSeries` response.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.QueryTimeSeriesResponse}
 */
public final class QueryTimeSeriesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.QueryTimeSeriesResponse)
    QueryTimeSeriesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryTimeSeriesResponse.newBuilder() to construct.
  private QueryTimeSeriesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryTimeSeriesResponse() {
    timeSeriesData_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    partialErrors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryTimeSeriesResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private QueryTimeSeriesResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 66:
            {
              com.google.monitoring.v3.TimeSeriesDescriptor.Builder subBuilder = null;
              if (timeSeriesDescriptor_ != null) {
                subBuilder = timeSeriesDescriptor_.toBuilder();
              }
              timeSeriesDescriptor_ =
                  input.readMessage(
                      com.google.monitoring.v3.TimeSeriesDescriptor.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(timeSeriesDescriptor_);
                timeSeriesDescriptor_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                timeSeriesData_ =
                    new java.util.ArrayList<com.google.monitoring.v3.TimeSeriesData>();
                mutable_bitField0_ |= 0x00000001;
              }
              timeSeriesData_.add(
                  input.readMessage(
                      com.google.monitoring.v3.TimeSeriesData.parser(), extensionRegistry));
              break;
            }
          case 82:
            {
              java.lang.String s = input.readStringRequireUtf8();

              nextPageToken_ = s;
              break;
            }
          case 90:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                partialErrors_ = new java.util.ArrayList<com.google.rpc.Status>();
                mutable_bitField0_ |= 0x00000002;
              }
              partialErrors_.add(
                  input.readMessage(com.google.rpc.Status.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        timeSeriesData_ = java.util.Collections.unmodifiableList(timeSeriesData_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        partialErrors_ = java.util.Collections.unmodifiableList(partialErrors_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.MetricServiceProto
        .internal_static_google_monitoring_v3_QueryTimeSeriesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.MetricServiceProto
        .internal_static_google_monitoring_v3_QueryTimeSeriesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.QueryTimeSeriesResponse.class,
            com.google.monitoring.v3.QueryTimeSeriesResponse.Builder.class);
  }

  public static final int TIME_SERIES_DESCRIPTOR_FIELD_NUMBER = 8;
  private com.google.monitoring.v3.TimeSeriesDescriptor timeSeriesDescriptor_;
  /**
   *
   *
   * <pre>
   * The descriptor for the time series data.
   * </pre>
   *
   * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
   *
   * @return Whether the timeSeriesDescriptor field is set.
   */
  @java.lang.Override
  public boolean hasTimeSeriesDescriptor() {
    return timeSeriesDescriptor_ != null;
  }
  /**
   *
   *
   * <pre>
   * The descriptor for the time series data.
   * </pre>
   *
   * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
   *
   * @return The timeSeriesDescriptor.
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesDescriptor getTimeSeriesDescriptor() {
    return timeSeriesDescriptor_ == null
        ? com.google.monitoring.v3.TimeSeriesDescriptor.getDefaultInstance()
        : timeSeriesDescriptor_;
  }
  /**
   *
   *
   * <pre>
   * The descriptor for the time series data.
   * </pre>
   *
   * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesDescriptorOrBuilder getTimeSeriesDescriptorOrBuilder() {
    return getTimeSeriesDescriptor();
  }

  public static final int TIME_SERIES_DATA_FIELD_NUMBER = 9;
  private java.util.List<com.google.monitoring.v3.TimeSeriesData> timeSeriesData_;
  /**
   *
   *
   * <pre>
   * The time series data.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.TimeSeriesData> getTimeSeriesDataList() {
    return timeSeriesData_;
  }
  /**
   *
   *
   * <pre>
   * The time series data.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.monitoring.v3.TimeSeriesDataOrBuilder>
      getTimeSeriesDataOrBuilderList() {
    return timeSeriesData_;
  }
  /**
   *
   *
   * <pre>
   * The time series data.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
   */
  @java.lang.Override
  public int getTimeSeriesDataCount() {
    return timeSeriesData_.size();
  }
  /**
   *
   *
   * <pre>
   * The time series data.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesData getTimeSeriesData(int index) {
    return timeSeriesData_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The time series data.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesDataOrBuilder getTimeSeriesDataOrBuilder(int index) {
    return timeSeriesData_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 10;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * If there are more results than have been returned, then this field is set
   * to a non-empty value.  To see the additional results, use that value as
   * `page_token` in the next call to this method.
   * </pre>
   *
   * <code>string next_page_token = 10;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If there are more results than have been returned, then this field is set
   * to a non-empty value.  To see the additional results, use that value as
   * `page_token` in the next call to this method.
   * </pre>
   *
   * <code>string next_page_token = 10;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTIAL_ERRORS_FIELD_NUMBER = 11;
  private java.util.List<com.google.rpc.Status> partialErrors_;
  /**
   *
   *
   * <pre>
   * Query execution errors that may have caused the time series data returned
   * to be incomplete. The available data will be available in the
   * response.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getPartialErrorsList() {
    return partialErrors_;
  }
  /**
   *
   *
   * <pre>
   * Query execution errors that may have caused the time series data returned
   * to be incomplete. The available data will be available in the
   * response.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 11;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getPartialErrorsOrBuilderList() {
    return partialErrors_;
  }
  /**
   *
   *
   * <pre>
   * Query execution errors that may have caused the time series data returned
   * to be incomplete. The available data will be available in the
   * response.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 11;</code>
   */
  @java.lang.Override
  public int getPartialErrorsCount() {
    return partialErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * Query execution errors that may have caused the time series data returned
   * to be incomplete. The available data will be available in the
   * response.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 11;</code>
   */
  @java.lang.Override
  public com.google.rpc.Status getPartialErrors(int index) {
    return partialErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Query execution errors that may have caused the time series data returned
   * to be incomplete. The available data will be available in the
   * response.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 11;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getPartialErrorsOrBuilder(int index) {
    return partialErrors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (timeSeriesDescriptor_ != null) {
      output.writeMessage(8, getTimeSeriesDescriptor());
    }
    for (int i = 0; i < timeSeriesData_.size(); i++) {
      output.writeMessage(9, timeSeriesData_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, nextPageToken_);
    }
    for (int i = 0; i < partialErrors_.size(); i++) {
      output.writeMessage(11, partialErrors_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (timeSeriesDescriptor_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTimeSeriesDescriptor());
    }
    for (int i = 0; i < timeSeriesData_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, timeSeriesData_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, nextPageToken_);
    }
    for (int i = 0; i < partialErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, partialErrors_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.QueryTimeSeriesResponse)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.QueryTimeSeriesResponse other =
        (com.google.monitoring.v3.QueryTimeSeriesResponse) obj;

    if (hasTimeSeriesDescriptor() != other.hasTimeSeriesDescriptor()) return false;
    if (hasTimeSeriesDescriptor()) {
      if (!getTimeSeriesDescriptor().equals(other.getTimeSeriesDescriptor())) return false;
    }
    if (!getTimeSeriesDataList().equals(other.getTimeSeriesDataList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getPartialErrorsList().equals(other.getPartialErrorsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTimeSeriesDescriptor()) {
      hash = (37 * hash) + TIME_SERIES_DESCRIPTOR_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSeriesDescriptor().hashCode();
    }
    if (getTimeSeriesDataCount() > 0) {
      hash = (37 * hash) + TIME_SERIES_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSeriesDataList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getPartialErrorsCount() > 0) {
      hash = (37 * hash) + PARTIAL_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getPartialErrorsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.QueryTimeSeriesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The `QueryTimeSeries` response.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.QueryTimeSeriesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.QueryTimeSeriesResponse)
      com.google.monitoring.v3.QueryTimeSeriesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_QueryTimeSeriesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_QueryTimeSeriesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.QueryTimeSeriesResponse.class,
              com.google.monitoring.v3.QueryTimeSeriesResponse.Builder.class);
    }

    // Construct using com.google.monitoring.v3.QueryTimeSeriesResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTimeSeriesDataFieldBuilder();
        getPartialErrorsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (timeSeriesDescriptorBuilder_ == null) {
        timeSeriesDescriptor_ = null;
      } else {
        timeSeriesDescriptor_ = null;
        timeSeriesDescriptorBuilder_ = null;
      }
      if (timeSeriesDataBuilder_ == null) {
        timeSeriesData_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        timeSeriesDataBuilder_.clear();
      }
      nextPageToken_ = "";

      if (partialErrorsBuilder_ == null) {
        partialErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        partialErrorsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_QueryTimeSeriesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.QueryTimeSeriesResponse getDefaultInstanceForType() {
      return com.google.monitoring.v3.QueryTimeSeriesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.QueryTimeSeriesResponse build() {
      com.google.monitoring.v3.QueryTimeSeriesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.QueryTimeSeriesResponse buildPartial() {
      com.google.monitoring.v3.QueryTimeSeriesResponse result =
          new com.google.monitoring.v3.QueryTimeSeriesResponse(this);
      int from_bitField0_ = bitField0_;
      if (timeSeriesDescriptorBuilder_ == null) {
        result.timeSeriesDescriptor_ = timeSeriesDescriptor_;
      } else {
        result.timeSeriesDescriptor_ = timeSeriesDescriptorBuilder_.build();
      }
      if (timeSeriesDataBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          timeSeriesData_ = java.util.Collections.unmodifiableList(timeSeriesData_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.timeSeriesData_ = timeSeriesData_;
      } else {
        result.timeSeriesData_ = timeSeriesDataBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      if (partialErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          partialErrors_ = java.util.Collections.unmodifiableList(partialErrors_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.partialErrors_ = partialErrors_;
      } else {
        result.partialErrors_ = partialErrorsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.QueryTimeSeriesResponse) {
        return mergeFrom((com.google.monitoring.v3.QueryTimeSeriesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.QueryTimeSeriesResponse other) {
      if (other == com.google.monitoring.v3.QueryTimeSeriesResponse.getDefaultInstance())
        return this;
      if (other.hasTimeSeriesDescriptor()) {
        mergeTimeSeriesDescriptor(other.getTimeSeriesDescriptor());
      }
      if (timeSeriesDataBuilder_ == null) {
        if (!other.timeSeriesData_.isEmpty()) {
          if (timeSeriesData_.isEmpty()) {
            timeSeriesData_ = other.timeSeriesData_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTimeSeriesDataIsMutable();
            timeSeriesData_.addAll(other.timeSeriesData_);
          }
          onChanged();
        }
      } else {
        if (!other.timeSeriesData_.isEmpty()) {
          if (timeSeriesDataBuilder_.isEmpty()) {
            timeSeriesDataBuilder_.dispose();
            timeSeriesDataBuilder_ = null;
            timeSeriesData_ = other.timeSeriesData_;
            bitField0_ = (bitField0_ & ~0x00000001);
            timeSeriesDataBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTimeSeriesDataFieldBuilder()
                    : null;
          } else {
            timeSeriesDataBuilder_.addAllMessages(other.timeSeriesData_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      if (partialErrorsBuilder_ == null) {
        if (!other.partialErrors_.isEmpty()) {
          if (partialErrors_.isEmpty()) {
            partialErrors_ = other.partialErrors_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePartialErrorsIsMutable();
            partialErrors_.addAll(other.partialErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.partialErrors_.isEmpty()) {
          if (partialErrorsBuilder_.isEmpty()) {
            partialErrorsBuilder_.dispose();
            partialErrorsBuilder_ = null;
            partialErrors_ = other.partialErrors_;
            bitField0_ = (bitField0_ & ~0x00000002);
            partialErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialErrorsFieldBuilder()
                    : null;
          } else {
            partialErrorsBuilder_.addAllMessages(other.partialErrors_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.monitoring.v3.QueryTimeSeriesResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.monitoring.v3.QueryTimeSeriesResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.monitoring.v3.TimeSeriesDescriptor timeSeriesDescriptor_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TimeSeriesDescriptor,
            com.google.monitoring.v3.TimeSeriesDescriptor.Builder,
            com.google.monitoring.v3.TimeSeriesDescriptorOrBuilder>
        timeSeriesDescriptorBuilder_;
    /**
     *
     *
     * <pre>
     * The descriptor for the time series data.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
     *
     * @return Whether the timeSeriesDescriptor field is set.
     */
    public boolean hasTimeSeriesDescriptor() {
      return timeSeriesDescriptorBuilder_ != null || timeSeriesDescriptor_ != null;
    }
    /**
     *
     *
     * <pre>
     * The descriptor for the time series data.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
     *
     * @return The timeSeriesDescriptor.
     */
    public com.google.monitoring.v3.TimeSeriesDescriptor getTimeSeriesDescriptor() {
      if (timeSeriesDescriptorBuilder_ == null) {
        return timeSeriesDescriptor_ == null
            ? com.google.monitoring.v3.TimeSeriesDescriptor.getDefaultInstance()
            : timeSeriesDescriptor_;
      } else {
        return timeSeriesDescriptorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The descriptor for the time series data.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
     */
    public Builder setTimeSeriesDescriptor(com.google.monitoring.v3.TimeSeriesDescriptor value) {
      if (timeSeriesDescriptorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeSeriesDescriptor_ = value;
        onChanged();
      } else {
        timeSeriesDescriptorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The descriptor for the time series data.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
     */
    public Builder setTimeSeriesDescriptor(
        com.google.monitoring.v3.TimeSeriesDescriptor.Builder builderForValue) {
      if (timeSeriesDescriptorBuilder_ == null) {
        timeSeriesDescriptor_ = builderForValue.build();
        onChanged();
      } else {
        timeSeriesDescriptorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The descriptor for the time series data.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
     */
    public Builder mergeTimeSeriesDescriptor(com.google.monitoring.v3.TimeSeriesDescriptor value) {
      if (timeSeriesDescriptorBuilder_ == null) {
        if (timeSeriesDescriptor_ != null) {
          timeSeriesDescriptor_ =
              com.google.monitoring.v3.TimeSeriesDescriptor.newBuilder(timeSeriesDescriptor_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          timeSeriesDescriptor_ = value;
        }
        onChanged();
      } else {
        timeSeriesDescriptorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The descriptor for the time series data.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
     */
    public Builder clearTimeSeriesDescriptor() {
      if (timeSeriesDescriptorBuilder_ == null) {
        timeSeriesDescriptor_ = null;
        onChanged();
      } else {
        timeSeriesDescriptor_ = null;
        timeSeriesDescriptorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The descriptor for the time series data.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
     */
    public com.google.monitoring.v3.TimeSeriesDescriptor.Builder getTimeSeriesDescriptorBuilder() {

      onChanged();
      return getTimeSeriesDescriptorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The descriptor for the time series data.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
     */
    public com.google.monitoring.v3.TimeSeriesDescriptorOrBuilder
        getTimeSeriesDescriptorOrBuilder() {
      if (timeSeriesDescriptorBuilder_ != null) {
        return timeSeriesDescriptorBuilder_.getMessageOrBuilder();
      } else {
        return timeSeriesDescriptor_ == null
            ? com.google.monitoring.v3.TimeSeriesDescriptor.getDefaultInstance()
            : timeSeriesDescriptor_;
      }
    }
    /**
     *
     *
     * <pre>
     * The descriptor for the time series data.
     * </pre>
     *
     * <code>.google.monitoring.v3.TimeSeriesDescriptor time_series_descriptor = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TimeSeriesDescriptor,
            com.google.monitoring.v3.TimeSeriesDescriptor.Builder,
            com.google.monitoring.v3.TimeSeriesDescriptorOrBuilder>
        getTimeSeriesDescriptorFieldBuilder() {
      if (timeSeriesDescriptorBuilder_ == null) {
        timeSeriesDescriptorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.TimeSeriesDescriptor,
                com.google.monitoring.v3.TimeSeriesDescriptor.Builder,
                com.google.monitoring.v3.TimeSeriesDescriptorOrBuilder>(
                getTimeSeriesDescriptor(), getParentForChildren(), isClean());
        timeSeriesDescriptor_ = null;
      }
      return timeSeriesDescriptorBuilder_;
    }

    private java.util.List<com.google.monitoring.v3.TimeSeriesData> timeSeriesData_ =
        java.util.Collections.emptyList();

    private void ensureTimeSeriesDataIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        timeSeriesData_ =
            new java.util.ArrayList<com.google.monitoring.v3.TimeSeriesData>(timeSeriesData_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.TimeSeriesData,
            com.google.monitoring.v3.TimeSeriesData.Builder,
            com.google.monitoring.v3.TimeSeriesDataOrBuilder>
        timeSeriesDataBuilder_;

    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public java.util.List<com.google.monitoring.v3.TimeSeriesData> getTimeSeriesDataList() {
      if (timeSeriesDataBuilder_ == null) {
        return java.util.Collections.unmodifiableList(timeSeriesData_);
      } else {
        return timeSeriesDataBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public int getTimeSeriesDataCount() {
      if (timeSeriesDataBuilder_ == null) {
        return timeSeriesData_.size();
      } else {
        return timeSeriesDataBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public com.google.monitoring.v3.TimeSeriesData getTimeSeriesData(int index) {
      if (timeSeriesDataBuilder_ == null) {
        return timeSeriesData_.get(index);
      } else {
        return timeSeriesDataBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public Builder setTimeSeriesData(int index, com.google.monitoring.v3.TimeSeriesData value) {
      if (timeSeriesDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.set(index, value);
        onChanged();
      } else {
        timeSeriesDataBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public Builder setTimeSeriesData(
        int index, com.google.monitoring.v3.TimeSeriesData.Builder builderForValue) {
      if (timeSeriesDataBuilder_ == null) {
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.set(index, builderForValue.build());
        onChanged();
      } else {
        timeSeriesDataBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public Builder addTimeSeriesData(com.google.monitoring.v3.TimeSeriesData value) {
      if (timeSeriesDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.add(value);
        onChanged();
      } else {
        timeSeriesDataBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public Builder addTimeSeriesData(int index, com.google.monitoring.v3.TimeSeriesData value) {
      if (timeSeriesDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.add(index, value);
        onChanged();
      } else {
        timeSeriesDataBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public Builder addTimeSeriesData(
        com.google.monitoring.v3.TimeSeriesData.Builder builderForValue) {
      if (timeSeriesDataBuilder_ == null) {
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.add(builderForValue.build());
        onChanged();
      } else {
        timeSeriesDataBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public Builder addTimeSeriesData(
        int index, com.google.monitoring.v3.TimeSeriesData.Builder builderForValue) {
      if (timeSeriesDataBuilder_ == null) {
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.add(index, builderForValue.build());
        onChanged();
      } else {
        timeSeriesDataBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public Builder addAllTimeSeriesData(
        java.lang.Iterable<? extends com.google.monitoring.v3.TimeSeriesData> values) {
      if (timeSeriesDataBuilder_ == null) {
        ensureTimeSeriesDataIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, timeSeriesData_);
        onChanged();
      } else {
        timeSeriesDataBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public Builder clearTimeSeriesData() {
      if (timeSeriesDataBuilder_ == null) {
        timeSeriesData_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        timeSeriesDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public Builder removeTimeSeriesData(int index) {
      if (timeSeriesDataBuilder_ == null) {
        ensureTimeSeriesDataIsMutable();
        timeSeriesData_.remove(index);
        onChanged();
      } else {
        timeSeriesDataBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public com.google.monitoring.v3.TimeSeriesData.Builder getTimeSeriesDataBuilder(int index) {
      return getTimeSeriesDataFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public com.google.monitoring.v3.TimeSeriesDataOrBuilder getTimeSeriesDataOrBuilder(int index) {
      if (timeSeriesDataBuilder_ == null) {
        return timeSeriesData_.get(index);
      } else {
        return timeSeriesDataBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public java.util.List<? extends com.google.monitoring.v3.TimeSeriesDataOrBuilder>
        getTimeSeriesDataOrBuilderList() {
      if (timeSeriesDataBuilder_ != null) {
        return timeSeriesDataBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(timeSeriesData_);
      }
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public com.google.monitoring.v3.TimeSeriesData.Builder addTimeSeriesDataBuilder() {
      return getTimeSeriesDataFieldBuilder()
          .addBuilder(com.google.monitoring.v3.TimeSeriesData.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public com.google.monitoring.v3.TimeSeriesData.Builder addTimeSeriesDataBuilder(int index) {
      return getTimeSeriesDataFieldBuilder()
          .addBuilder(index, com.google.monitoring.v3.TimeSeriesData.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The time series data.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.TimeSeriesData time_series_data = 9;</code>
     */
    public java.util.List<com.google.monitoring.v3.TimeSeriesData.Builder>
        getTimeSeriesDataBuilderList() {
      return getTimeSeriesDataFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.TimeSeriesData,
            com.google.monitoring.v3.TimeSeriesData.Builder,
            com.google.monitoring.v3.TimeSeriesDataOrBuilder>
        getTimeSeriesDataFieldBuilder() {
      if (timeSeriesDataBuilder_ == null) {
        timeSeriesDataBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.TimeSeriesData,
                com.google.monitoring.v3.TimeSeriesData.Builder,
                com.google.monitoring.v3.TimeSeriesDataOrBuilder>(
                timeSeriesData_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        timeSeriesData_ = null;
      }
      return timeSeriesDataBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * If there are more results than have been returned, then this field is set
     * to a non-empty value.  To see the additional results, use that value as
     * `page_token` in the next call to this method.
     * </pre>
     *
     * <code>string next_page_token = 10;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If there are more results than have been returned, then this field is set
     * to a non-empty value.  To see the additional results, use that value as
     * `page_token` in the next call to this method.
     * </pre>
     *
     * <code>string next_page_token = 10;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If there are more results than have been returned, then this field is set
     * to a non-empty value.  To see the additional results, use that value as
     * `page_token` in the next call to this method.
     * </pre>
     *
     * <code>string next_page_token = 10;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are more results than have been returned, then this field is set
     * to a non-empty value.  To see the additional results, use that value as
     * `page_token` in the next call to this method.
     * </pre>
     *
     * <code>string next_page_token = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If there are more results than have been returned, then this field is set
     * to a non-empty value.  To see the additional results, use that value as
     * `page_token` in the next call to this method.
     * </pre>
     *
     * <code>string next_page_token = 10;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.rpc.Status> partialErrors_ =
        java.util.Collections.emptyList();

    private void ensurePartialErrorsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        partialErrors_ = new java.util.ArrayList<com.google.rpc.Status>(partialErrors_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        partialErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public java.util.List<com.google.rpc.Status> getPartialErrorsList() {
      if (partialErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialErrors_);
      } else {
        return partialErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public int getPartialErrorsCount() {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.size();
      } else {
        return partialErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public com.google.rpc.Status getPartialErrors(int index) {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.get(index);
      } else {
        return partialErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public Builder setPartialErrors(int index, com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.set(index, value);
        onChanged();
      } else {
        partialErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public Builder setPartialErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public Builder addPartialErrors(com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.add(value);
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public Builder addPartialErrors(int index, com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.add(index, value);
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public Builder addPartialErrors(com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.add(builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public Builder addPartialErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public Builder addAllPartialErrors(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialErrors_);
        onChanged();
      } else {
        partialErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public Builder clearPartialErrors() {
      if (partialErrorsBuilder_ == null) {
        partialErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        partialErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public Builder removePartialErrors(int index) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.remove(index);
        onChanged();
      } else {
        partialErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public com.google.rpc.Status.Builder getPartialErrorsBuilder(int index) {
      return getPartialErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public com.google.rpc.StatusOrBuilder getPartialErrorsOrBuilder(int index) {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.get(index);
      } else {
        return partialErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getPartialErrorsOrBuilderList() {
      if (partialErrorsBuilder_ != null) {
        return partialErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public com.google.rpc.Status.Builder addPartialErrorsBuilder() {
      return getPartialErrorsFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public com.google.rpc.Status.Builder addPartialErrorsBuilder(int index) {
      return getPartialErrorsFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Query execution errors that may have caused the time series data returned
     * to be incomplete. The available data will be available in the
     * response.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 11;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getPartialErrorsBuilderList() {
      return getPartialErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getPartialErrorsFieldBuilder() {
      if (partialErrorsBuilder_ == null) {
        partialErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                partialErrors_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        partialErrors_ = null;
      }
      return partialErrorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.QueryTimeSeriesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.QueryTimeSeriesResponse)
  private static final com.google.monitoring.v3.QueryTimeSeriesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.QueryTimeSeriesResponse();
  }

  public static com.google.monitoring.v3.QueryTimeSeriesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryTimeSeriesResponse> PARSER =
      new com.google.protobuf.AbstractParser<QueryTimeSeriesResponse>() {
        @java.lang.Override
        public QueryTimeSeriesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new QueryTimeSeriesResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<QueryTimeSeriesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryTimeSeriesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.QueryTimeSeriesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
