/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IntentName
implements ResourceName {
    private static final PathTemplate PROJECT_INTENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/intents/{intent}");
    private static final PathTemplate PROJECT_LOCATION_INTENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agent/intents/{intent}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String intent;
    private final String location;

    @Deprecated
    protected IntentName() {
        this.project = null;
        this.intent = null;
        this.location = null;
    }

    private IntentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.intent = (String)Preconditions.checkNotNull((Object)builder.getIntent());
        this.location = null;
        this.pathTemplate = PROJECT_INTENT;
    }

    private IntentName(ProjectLocationIntentBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.intent = (String)Preconditions.checkNotNull((Object)builder.getIntent());
        this.pathTemplate = PROJECT_LOCATION_INTENT;
    }

    public String getProject() {
        return this.project;
    }

    public String getIntent() {
        return this.intent;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectIntentBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationIntentBuilder newProjectLocationIntentBuilder() {
        return new ProjectLocationIntentBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static IntentName of(String project, String intent) {
        return IntentName.newBuilder().setProject(project).setIntent(intent).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static IntentName ofProjectIntentName(String project, String intent) {
        return IntentName.newBuilder().setProject(project).setIntent(intent).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static IntentName ofProjectLocationIntentName(String project, String location, String intent) {
        return IntentName.newProjectLocationIntentBuilder().setProject(project).setLocation(location).setIntent(intent).build();
    }

    public static String format(String project, String intent) {
        return IntentName.newBuilder().setProject(project).setIntent(intent).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectIntentName(String project, String intent) {
        return IntentName.newBuilder().setProject(project).setIntent(intent).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationIntentName(String project, String location, String intent) {
        return IntentName.newProjectLocationIntentBuilder().setProject(project).setLocation(location).setIntent(intent).build().toString();
    }

    public static IntentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_INTENT.matches(formattedString)) {
            Map matchMap = PROJECT_INTENT.match(formattedString);
            return IntentName.ofProjectIntentName((String)matchMap.get("project"), (String)matchMap.get("intent"));
        }
        if (PROJECT_LOCATION_INTENT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_INTENT.match(formattedString);
            return IntentName.ofProjectLocationIntentName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("intent"));
        }
        throw new ValidationException("IntentName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<IntentName> parseList(List<String> formattedStrings) {
        ArrayList<IntentName> list = new ArrayList<IntentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IntentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IntentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IntentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INTENT.matches(formattedString) || PROJECT_LOCATION_INTENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IntentName intentName = this;
            synchronized (intentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.intent != null) {
                        fieldMapBuilder.put((Object)"intent", (Object)this.intent);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            IntentName that = (IntentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.intent, that.intent) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.intent);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationIntentBuilder {
        private String project;
        private String location;
        private String intent;

        protected ProjectLocationIntentBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getIntent() {
            return this.intent;
        }

        public ProjectLocationIntentBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationIntentBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationIntentBuilder setIntent(String intent) {
            this.intent = intent;
            return this;
        }

        public IntentName build() {
            return new IntentName(this);
        }
    }

    public static class Builder {
        private String project;
        private String intent;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getIntent() {
            return this.intent;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setIntent(String intent) {
            this.intent = intent;
            return this;
        }

        private Builder(IntentName intentName) {
            Preconditions.checkArgument((boolean)Objects.equals(intentName.pathTemplate, PROJECT_INTENT), (Object)"toBuilder is only supported when IntentName has the pattern of projects/{project}/agent/intents/{intent}");
            this.project = intentName.project;
            this.intent = intentName.intent;
        }

        public IntentName build() {
            return new IntentName(this);
        }
    }
}

