/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.cloud.dataproc.v1.AcceleratorConfig;
import com.google.cloud.dataproc.v1.AcceleratorConfigOrBuilder;
import com.google.cloud.dataproc.v1.ClustersProto;
import com.google.cloud.dataproc.v1.DiskConfig;
import com.google.cloud.dataproc.v1.DiskConfigOrBuilder;
import com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy;
import com.google.cloud.dataproc.v1.InstanceFlexibilityPolicyOrBuilder;
import com.google.cloud.dataproc.v1.InstanceGroupConfigOrBuilder;
import com.google.cloud.dataproc.v1.InstanceReference;
import com.google.cloud.dataproc.v1.InstanceReferenceOrBuilder;
import com.google.cloud.dataproc.v1.ManagedGroupConfig;
import com.google.cloud.dataproc.v1.ManagedGroupConfigOrBuilder;
import com.google.cloud.dataproc.v1.StartupConfig;
import com.google.cloud.dataproc.v1.StartupConfigOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class InstanceGroupConfig
extends GeneratedMessageV3
implements InstanceGroupConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NUM_INSTANCES_FIELD_NUMBER = 1;
    private int numInstances_ = 0;
    public static final int INSTANCE_NAMES_FIELD_NUMBER = 2;
    private LazyStringArrayList instanceNames_ = LazyStringArrayList.emptyList();
    public static final int INSTANCE_REFERENCES_FIELD_NUMBER = 11;
    private List<InstanceReference> instanceReferences_;
    public static final int IMAGE_URI_FIELD_NUMBER = 3;
    private volatile Object imageUri_ = "";
    public static final int MACHINE_TYPE_URI_FIELD_NUMBER = 4;
    private volatile Object machineTypeUri_ = "";
    public static final int DISK_CONFIG_FIELD_NUMBER = 5;
    private DiskConfig diskConfig_;
    public static final int IS_PREEMPTIBLE_FIELD_NUMBER = 6;
    private boolean isPreemptible_ = false;
    public static final int PREEMPTIBILITY_FIELD_NUMBER = 10;
    private int preemptibility_ = 0;
    public static final int MANAGED_GROUP_CONFIG_FIELD_NUMBER = 7;
    private ManagedGroupConfig managedGroupConfig_;
    public static final int ACCELERATORS_FIELD_NUMBER = 8;
    private List<AcceleratorConfig> accelerators_;
    public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 9;
    private volatile Object minCpuPlatform_ = "";
    public static final int MIN_NUM_INSTANCES_FIELD_NUMBER = 12;
    private int minNumInstances_ = 0;
    public static final int INSTANCE_FLEXIBILITY_POLICY_FIELD_NUMBER = 13;
    private InstanceFlexibilityPolicy instanceFlexibilityPolicy_;
    public static final int STARTUP_CONFIG_FIELD_NUMBER = 14;
    private StartupConfig startupConfig_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final InstanceGroupConfig DEFAULT_INSTANCE = new InstanceGroupConfig();
    private static final Parser<InstanceGroupConfig> PARSER = new AbstractParser<InstanceGroupConfig>(){

        public InstanceGroupConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = InstanceGroupConfig.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private InstanceGroupConfig(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private InstanceGroupConfig() {
        this.instanceNames_ = LazyStringArrayList.emptyList();
        this.instanceReferences_ = Collections.emptyList();
        this.imageUri_ = "";
        this.machineTypeUri_ = "";
        this.preemptibility_ = 0;
        this.accelerators_ = Collections.emptyList();
        this.minCpuPlatform_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new InstanceGroupConfig();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ClustersProto.internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ClustersProto.internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(InstanceGroupConfig.class, Builder.class);
    }

    @Override
    public int getNumInstances() {
        return this.numInstances_;
    }

    public ProtocolStringList getInstanceNamesList() {
        return this.instanceNames_;
    }

    @Override
    public int getInstanceNamesCount() {
        return this.instanceNames_.size();
    }

    @Override
    public String getInstanceNames(int index) {
        return this.instanceNames_.get(index);
    }

    @Override
    public ByteString getInstanceNamesBytes(int index) {
        return this.instanceNames_.getByteString(index);
    }

    @Override
    public List<InstanceReference> getInstanceReferencesList() {
        return this.instanceReferences_;
    }

    @Override
    public List<? extends InstanceReferenceOrBuilder> getInstanceReferencesOrBuilderList() {
        return this.instanceReferences_;
    }

    @Override
    public int getInstanceReferencesCount() {
        return this.instanceReferences_.size();
    }

    @Override
    public InstanceReference getInstanceReferences(int index) {
        return this.instanceReferences_.get(index);
    }

    @Override
    public InstanceReferenceOrBuilder getInstanceReferencesOrBuilder(int index) {
        return this.instanceReferences_.get(index);
    }

    @Override
    public String getImageUri() {
        Object ref = this.imageUri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.imageUri_ = s;
        return s;
    }

    @Override
    public ByteString getImageUriBytes() {
        Object ref = this.imageUri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.imageUri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getMachineTypeUri() {
        Object ref = this.machineTypeUri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.machineTypeUri_ = s;
        return s;
    }

    @Override
    public ByteString getMachineTypeUriBytes() {
        Object ref = this.machineTypeUri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.machineTypeUri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasDiskConfig() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public DiskConfig getDiskConfig() {
        return this.diskConfig_ == null ? DiskConfig.getDefaultInstance() : this.diskConfig_;
    }

    @Override
    public DiskConfigOrBuilder getDiskConfigOrBuilder() {
        return this.diskConfig_ == null ? DiskConfig.getDefaultInstance() : this.diskConfig_;
    }

    @Override
    public boolean getIsPreemptible() {
        return this.isPreemptible_;
    }

    @Override
    public int getPreemptibilityValue() {
        return this.preemptibility_;
    }

    @Override
    public Preemptibility getPreemptibility() {
        Preemptibility result = Preemptibility.forNumber(this.preemptibility_);
        return result == null ? Preemptibility.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasManagedGroupConfig() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public ManagedGroupConfig getManagedGroupConfig() {
        return this.managedGroupConfig_ == null ? ManagedGroupConfig.getDefaultInstance() : this.managedGroupConfig_;
    }

    @Override
    public ManagedGroupConfigOrBuilder getManagedGroupConfigOrBuilder() {
        return this.managedGroupConfig_ == null ? ManagedGroupConfig.getDefaultInstance() : this.managedGroupConfig_;
    }

    @Override
    public List<AcceleratorConfig> getAcceleratorsList() {
        return this.accelerators_;
    }

    @Override
    public List<? extends AcceleratorConfigOrBuilder> getAcceleratorsOrBuilderList() {
        return this.accelerators_;
    }

    @Override
    public int getAcceleratorsCount() {
        return this.accelerators_.size();
    }

    @Override
    public AcceleratorConfig getAccelerators(int index) {
        return this.accelerators_.get(index);
    }

    @Override
    public AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(int index) {
        return this.accelerators_.get(index);
    }

    @Override
    public String getMinCpuPlatform() {
        Object ref = this.minCpuPlatform_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.minCpuPlatform_ = s;
        return s;
    }

    @Override
    public ByteString getMinCpuPlatformBytes() {
        Object ref = this.minCpuPlatform_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.minCpuPlatform_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getMinNumInstances() {
        return this.minNumInstances_;
    }

    @Override
    public boolean hasInstanceFlexibilityPolicy() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public InstanceFlexibilityPolicy getInstanceFlexibilityPolicy() {
        return this.instanceFlexibilityPolicy_ == null ? InstanceFlexibilityPolicy.getDefaultInstance() : this.instanceFlexibilityPolicy_;
    }

    @Override
    public InstanceFlexibilityPolicyOrBuilder getInstanceFlexibilityPolicyOrBuilder() {
        return this.instanceFlexibilityPolicy_ == null ? InstanceFlexibilityPolicy.getDefaultInstance() : this.instanceFlexibilityPolicy_;
    }

    @Override
    public boolean hasStartupConfig() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public StartupConfig getStartupConfig() {
        return this.startupConfig_ == null ? StartupConfig.getDefaultInstance() : this.startupConfig_;
    }

    @Override
    public StartupConfigOrBuilder getStartupConfigOrBuilder() {
        return this.startupConfig_ == null ? StartupConfig.getDefaultInstance() : this.startupConfig_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (this.numInstances_ != 0) {
            output.writeInt32(1, this.numInstances_);
        }
        for (i = 0; i < this.instanceNames_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.instanceNames_.getRaw(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.imageUri_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.imageUri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.machineTypeUri_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.machineTypeUri_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(5, (MessageLite)this.getDiskConfig());
        }
        if (this.isPreemptible_) {
            output.writeBool(6, this.isPreemptible_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(7, (MessageLite)this.getManagedGroupConfig());
        }
        for (i = 0; i < this.accelerators_.size(); ++i) {
            output.writeMessage(8, (MessageLite)this.accelerators_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.minCpuPlatform_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.minCpuPlatform_);
        }
        if (this.preemptibility_ != Preemptibility.PREEMPTIBILITY_UNSPECIFIED.getNumber()) {
            output.writeEnum(10, this.preemptibility_);
        }
        for (i = 0; i < this.instanceReferences_.size(); ++i) {
            output.writeMessage(11, (MessageLite)this.instanceReferences_.get(i));
        }
        if (this.minNumInstances_ != 0) {
            output.writeInt32(12, this.minNumInstances_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(13, (MessageLite)this.getInstanceFlexibilityPolicy());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(14, (MessageLite)this.getStartupConfig());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.numInstances_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)1, (int)this.numInstances_);
        }
        int dataSize = 0;
        for (int i2 = 0; i2 < this.instanceNames_.size(); ++i2) {
            dataSize += InstanceGroupConfig.computeStringSizeNoTag((Object)this.instanceNames_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getInstanceNamesList().size();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.imageUri_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.imageUri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.machineTypeUri_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.machineTypeUri_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getDiskConfig());
        }
        if (this.isPreemptible_) {
            size += CodedOutputStream.computeBoolSize((int)6, (boolean)this.isPreemptible_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getManagedGroupConfig());
        }
        for (i = 0; i < this.accelerators_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((MessageLite)this.accelerators_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.minCpuPlatform_)) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.minCpuPlatform_);
        }
        if (this.preemptibility_ != Preemptibility.PREEMPTIBILITY_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.preemptibility_);
        }
        for (i = 0; i < this.instanceReferences_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)((MessageLite)this.instanceReferences_.get(i)));
        }
        if (this.minNumInstances_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)12, (int)this.minNumInstances_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getInstanceFlexibilityPolicy());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)this.getStartupConfig());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InstanceGroupConfig)) {
            return super.equals(obj);
        }
        InstanceGroupConfig other = (InstanceGroupConfig)obj;
        if (this.getNumInstances() != other.getNumInstances()) {
            return false;
        }
        if (!this.getInstanceNamesList().equals(other.getInstanceNamesList())) {
            return false;
        }
        if (!this.getInstanceReferencesList().equals(other.getInstanceReferencesList())) {
            return false;
        }
        if (!this.getImageUri().equals(other.getImageUri())) {
            return false;
        }
        if (!this.getMachineTypeUri().equals(other.getMachineTypeUri())) {
            return false;
        }
        if (this.hasDiskConfig() != other.hasDiskConfig()) {
            return false;
        }
        if (this.hasDiskConfig() && !this.getDiskConfig().equals(other.getDiskConfig())) {
            return false;
        }
        if (this.getIsPreemptible() != other.getIsPreemptible()) {
            return false;
        }
        if (this.preemptibility_ != other.preemptibility_) {
            return false;
        }
        if (this.hasManagedGroupConfig() != other.hasManagedGroupConfig()) {
            return false;
        }
        if (this.hasManagedGroupConfig() && !this.getManagedGroupConfig().equals(other.getManagedGroupConfig())) {
            return false;
        }
        if (!this.getAcceleratorsList().equals(other.getAcceleratorsList())) {
            return false;
        }
        if (!this.getMinCpuPlatform().equals(other.getMinCpuPlatform())) {
            return false;
        }
        if (this.getMinNumInstances() != other.getMinNumInstances()) {
            return false;
        }
        if (this.hasInstanceFlexibilityPolicy() != other.hasInstanceFlexibilityPolicy()) {
            return false;
        }
        if (this.hasInstanceFlexibilityPolicy() && !this.getInstanceFlexibilityPolicy().equals(other.getInstanceFlexibilityPolicy())) {
            return false;
        }
        if (this.hasStartupConfig() != other.hasStartupConfig()) {
            return false;
        }
        if (this.hasStartupConfig() && !this.getStartupConfig().equals(other.getStartupConfig())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + InstanceGroupConfig.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getNumInstances();
        if (this.getInstanceNamesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getInstanceNamesList().hashCode();
        }
        if (this.getInstanceReferencesCount() > 0) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getInstanceReferencesList().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getImageUri().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getMachineTypeUri().hashCode();
        if (this.hasDiskConfig()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getDiskConfig().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIsPreemptible());
        hash = 37 * hash + 10;
        hash = 53 * hash + this.preemptibility_;
        if (this.hasManagedGroupConfig()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getManagedGroupConfig().hashCode();
        }
        if (this.getAcceleratorsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getAcceleratorsList().hashCode();
        }
        hash = 37 * hash + 9;
        hash = 53 * hash + this.getMinCpuPlatform().hashCode();
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getMinNumInstances();
        if (this.hasInstanceFlexibilityPolicy()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getInstanceFlexibilityPolicy().hashCode();
        }
        if (this.hasStartupConfig()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getStartupConfig().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static InstanceGroupConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data);
    }

    public static InstanceGroupConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InstanceGroupConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data);
    }

    public static InstanceGroupConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InstanceGroupConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data);
    }

    public static InstanceGroupConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InstanceGroupConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InstanceGroupConfig parseFrom(InputStream input) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static InstanceGroupConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static InstanceGroupConfig parseDelimitedFrom(InputStream input) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static InstanceGroupConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static InstanceGroupConfig parseFrom(CodedInputStream input) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static InstanceGroupConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InstanceGroupConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return InstanceGroupConfig.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static InstanceGroupConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<InstanceGroupConfig> parser() {
        return PARSER;
    }

    public Parser<InstanceGroupConfig> getParserForType() {
        return PARSER;
    }

    public InstanceGroupConfig getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements InstanceGroupConfigOrBuilder {
        private int bitField0_;
        private int numInstances_;
        private LazyStringArrayList instanceNames_ = LazyStringArrayList.emptyList();
        private List<InstanceReference> instanceReferences_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<InstanceReference, InstanceReference.Builder, InstanceReferenceOrBuilder> instanceReferencesBuilder_;
        private Object imageUri_ = "";
        private Object machineTypeUri_ = "";
        private DiskConfig diskConfig_;
        private SingleFieldBuilderV3<DiskConfig, DiskConfig.Builder, DiskConfigOrBuilder> diskConfigBuilder_;
        private boolean isPreemptible_;
        private int preemptibility_ = 0;
        private ManagedGroupConfig managedGroupConfig_;
        private SingleFieldBuilderV3<ManagedGroupConfig, ManagedGroupConfig.Builder, ManagedGroupConfigOrBuilder> managedGroupConfigBuilder_;
        private List<AcceleratorConfig> accelerators_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AcceleratorConfig, AcceleratorConfig.Builder, AcceleratorConfigOrBuilder> acceleratorsBuilder_;
        private Object minCpuPlatform_ = "";
        private int minNumInstances_;
        private InstanceFlexibilityPolicy instanceFlexibilityPolicy_;
        private SingleFieldBuilderV3<InstanceFlexibilityPolicy, InstanceFlexibilityPolicy.Builder, InstanceFlexibilityPolicyOrBuilder> instanceFlexibilityPolicyBuilder_;
        private StartupConfig startupConfig_;
        private SingleFieldBuilderV3<StartupConfig, StartupConfig.Builder, StartupConfigOrBuilder> startupConfigBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ClustersProto.internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ClustersProto.internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(InstanceGroupConfig.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getInstanceReferencesFieldBuilder();
                this.getDiskConfigFieldBuilder();
                this.getManagedGroupConfigFieldBuilder();
                this.getAcceleratorsFieldBuilder();
                this.getInstanceFlexibilityPolicyFieldBuilder();
                this.getStartupConfigFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.numInstances_ = 0;
            this.instanceNames_ = LazyStringArrayList.emptyList();
            if (this.instanceReferencesBuilder_ == null) {
                this.instanceReferences_ = Collections.emptyList();
            } else {
                this.instanceReferences_ = null;
                this.instanceReferencesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            this.imageUri_ = "";
            this.machineTypeUri_ = "";
            this.diskConfig_ = null;
            if (this.diskConfigBuilder_ != null) {
                this.diskConfigBuilder_.dispose();
                this.diskConfigBuilder_ = null;
            }
            this.isPreemptible_ = false;
            this.preemptibility_ = 0;
            this.managedGroupConfig_ = null;
            if (this.managedGroupConfigBuilder_ != null) {
                this.managedGroupConfigBuilder_.dispose();
                this.managedGroupConfigBuilder_ = null;
            }
            if (this.acceleratorsBuilder_ == null) {
                this.accelerators_ = Collections.emptyList();
            } else {
                this.accelerators_ = null;
                this.acceleratorsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            this.minCpuPlatform_ = "";
            this.minNumInstances_ = 0;
            this.instanceFlexibilityPolicy_ = null;
            if (this.instanceFlexibilityPolicyBuilder_ != null) {
                this.instanceFlexibilityPolicyBuilder_.dispose();
                this.instanceFlexibilityPolicyBuilder_ = null;
            }
            this.startupConfig_ = null;
            if (this.startupConfigBuilder_ != null) {
                this.startupConfigBuilder_.dispose();
                this.startupConfigBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ClustersProto.internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_descriptor;
        }

        public InstanceGroupConfig getDefaultInstanceForType() {
            return InstanceGroupConfig.getDefaultInstance();
        }

        public InstanceGroupConfig build() {
            InstanceGroupConfig result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public InstanceGroupConfig buildPartial() {
            InstanceGroupConfig result = new InstanceGroupConfig(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(InstanceGroupConfig result) {
            if (this.instanceReferencesBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.instanceReferences_ = Collections.unmodifiableList(this.instanceReferences_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.instanceReferences_ = this.instanceReferences_;
            } else {
                result.instanceReferences_ = this.instanceReferencesBuilder_.build();
            }
            if (this.acceleratorsBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.accelerators_ = Collections.unmodifiableList(this.accelerators_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.accelerators_ = this.accelerators_;
            } else {
                result.accelerators_ = this.acceleratorsBuilder_.build();
            }
        }

        private void buildPartial0(InstanceGroupConfig result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.numInstances_ = this.numInstances_;
            }
            if ((from_bitField0_ & 2) != 0) {
                this.instanceNames_.makeImmutable();
                result.instanceNames_ = this.instanceNames_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.imageUri_ = this.imageUri_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.machineTypeUri_ = this.machineTypeUri_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x20) != 0) {
                result.diskConfig_ = this.diskConfigBuilder_ == null ? this.diskConfig_ : (DiskConfig)this.diskConfigBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.isPreemptible_ = this.isPreemptible_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.preemptibility_ = this.preemptibility_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.managedGroupConfig_ = this.managedGroupConfigBuilder_ == null ? this.managedGroupConfig_ : (ManagedGroupConfig)this.managedGroupConfigBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.minCpuPlatform_ = this.minCpuPlatform_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.minNumInstances_ = this.minNumInstances_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.instanceFlexibilityPolicy_ = this.instanceFlexibilityPolicyBuilder_ == null ? this.instanceFlexibilityPolicy_ : (InstanceFlexibilityPolicy)this.instanceFlexibilityPolicyBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.startupConfig_ = this.startupConfigBuilder_ == null ? this.startupConfig_ : (StartupConfig)this.startupConfigBuilder_.build();
                to_bitField0_ |= 8;
            }
            InstanceGroupConfig instanceGroupConfig = result;
            instanceGroupConfig.bitField0_ = instanceGroupConfig.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof InstanceGroupConfig) {
                return this.mergeFrom((InstanceGroupConfig)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(InstanceGroupConfig other) {
            if (other == InstanceGroupConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getNumInstances() != 0) {
                this.setNumInstances(other.getNumInstances());
            }
            if (!other.instanceNames_.isEmpty()) {
                if (this.instanceNames_.isEmpty()) {
                    this.instanceNames_ = other.instanceNames_;
                    this.bitField0_ |= 2;
                } else {
                    this.ensureInstanceNamesIsMutable();
                    this.instanceNames_.addAll((Collection)other.instanceNames_);
                }
                this.onChanged();
            }
            if (this.instanceReferencesBuilder_ == null) {
                if (!other.instanceReferences_.isEmpty()) {
                    if (this.instanceReferences_.isEmpty()) {
                        this.instanceReferences_ = other.instanceReferences_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureInstanceReferencesIsMutable();
                        this.instanceReferences_.addAll(other.instanceReferences_);
                    }
                    this.onChanged();
                }
            } else if (!other.instanceReferences_.isEmpty()) {
                if (this.instanceReferencesBuilder_.isEmpty()) {
                    this.instanceReferencesBuilder_.dispose();
                    this.instanceReferencesBuilder_ = null;
                    this.instanceReferences_ = other.instanceReferences_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.instanceReferencesBuilder_ = alwaysUseFieldBuilders ? this.getInstanceReferencesFieldBuilder() : null;
                } else {
                    this.instanceReferencesBuilder_.addAllMessages((Iterable)other.instanceReferences_);
                }
            }
            if (!other.getImageUri().isEmpty()) {
                this.imageUri_ = other.imageUri_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.getMachineTypeUri().isEmpty()) {
                this.machineTypeUri_ = other.machineTypeUri_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.hasDiskConfig()) {
                this.mergeDiskConfig(other.getDiskConfig());
            }
            if (other.getIsPreemptible()) {
                this.setIsPreemptible(other.getIsPreemptible());
            }
            if (other.preemptibility_ != 0) {
                this.setPreemptibilityValue(other.getPreemptibilityValue());
            }
            if (other.hasManagedGroupConfig()) {
                this.mergeManagedGroupConfig(other.getManagedGroupConfig());
            }
            if (this.acceleratorsBuilder_ == null) {
                if (!other.accelerators_.isEmpty()) {
                    if (this.accelerators_.isEmpty()) {
                        this.accelerators_ = other.accelerators_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureAcceleratorsIsMutable();
                        this.accelerators_.addAll(other.accelerators_);
                    }
                    this.onChanged();
                }
            } else if (!other.accelerators_.isEmpty()) {
                if (this.acceleratorsBuilder_.isEmpty()) {
                    this.acceleratorsBuilder_.dispose();
                    this.acceleratorsBuilder_ = null;
                    this.accelerators_ = other.accelerators_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.acceleratorsBuilder_ = alwaysUseFieldBuilders ? this.getAcceleratorsFieldBuilder() : null;
                } else {
                    this.acceleratorsBuilder_.addAllMessages((Iterable)other.accelerators_);
                }
            }
            if (!other.getMinCpuPlatform().isEmpty()) {
                this.minCpuPlatform_ = other.minCpuPlatform_;
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            if (other.getMinNumInstances() != 0) {
                this.setMinNumInstances(other.getMinNumInstances());
            }
            if (other.hasInstanceFlexibilityPolicy()) {
                this.mergeInstanceFlexibilityPolicy(other.getInstanceFlexibilityPolicy());
            }
            if (other.hasStartupConfig()) {
                this.mergeStartupConfig(other.getStartupConfig());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block22: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block22;
                        }
                        case 8: {
                            this.numInstances_ = input.readInt32();
                            this.bitField0_ |= 1;
                            continue block22;
                        }
                        case 18: {
                            String s = input.readStringRequireUtf8();
                            this.ensureInstanceNamesIsMutable();
                            this.instanceNames_.add((Object)s);
                            continue block22;
                        }
                        case 26: {
                            this.imageUri_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block22;
                        }
                        case 34: {
                            this.machineTypeUri_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block22;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getDiskConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block22;
                        }
                        case 48: {
                            this.isPreemptible_ = input.readBool();
                            this.bitField0_ |= 0x40;
                            continue block22;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getManagedGroupConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block22;
                        }
                        case 66: {
                            GeneratedMessageV3 m = (AcceleratorConfig)input.readMessage(AcceleratorConfig.parser(), extensionRegistry);
                            if (this.acceleratorsBuilder_ == null) {
                                this.ensureAcceleratorsIsMutable();
                                this.accelerators_.add((AcceleratorConfig)m);
                                continue block22;
                            }
                            this.acceleratorsBuilder_.addMessage((AbstractMessage)m);
                            continue block22;
                        }
                        case 74: {
                            this.minCpuPlatform_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x400;
                            continue block22;
                        }
                        case 80: {
                            this.preemptibility_ = input.readEnum();
                            this.bitField0_ |= 0x80;
                            continue block22;
                        }
                        case 90: {
                            GeneratedMessageV3 m = (InstanceReference)input.readMessage(InstanceReference.parser(), extensionRegistry);
                            if (this.instanceReferencesBuilder_ == null) {
                                this.ensureInstanceReferencesIsMutable();
                                this.instanceReferences_.add((InstanceReference)m);
                                continue block22;
                            }
                            this.instanceReferencesBuilder_.addMessage((AbstractMessage)m);
                            continue block22;
                        }
                        case 96: {
                            this.minNumInstances_ = input.readInt32();
                            this.bitField0_ |= 0x800;
                            continue block22;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getInstanceFlexibilityPolicyFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block22;
                        }
                        case 114: {
                            input.readMessage((MessageLite.Builder)this.getStartupConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x2000;
                            continue block22;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public int getNumInstances() {
            return this.numInstances_;
        }

        public Builder setNumInstances(int value) {
            this.numInstances_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearNumInstances() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.numInstances_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureInstanceNamesIsMutable() {
            if (!this.instanceNames_.isModifiable()) {
                this.instanceNames_ = new LazyStringArrayList((LazyStringList)this.instanceNames_);
            }
            this.bitField0_ |= 2;
        }

        public ProtocolStringList getInstanceNamesList() {
            this.instanceNames_.makeImmutable();
            return this.instanceNames_;
        }

        @Override
        public int getInstanceNamesCount() {
            return this.instanceNames_.size();
        }

        @Override
        public String getInstanceNames(int index) {
            return this.instanceNames_.get(index);
        }

        @Override
        public ByteString getInstanceNamesBytes(int index) {
            return this.instanceNames_.getByteString(index);
        }

        public Builder setInstanceNames(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureInstanceNamesIsMutable();
            this.instanceNames_.set(index, value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder addInstanceNames(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureInstanceNamesIsMutable();
            this.instanceNames_.add((Object)value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder addAllInstanceNames(Iterable<String> values) {
            this.ensureInstanceNamesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.instanceNames_);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearInstanceNames() {
            this.instanceNames_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder addInstanceNamesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InstanceGroupConfig.checkByteStringIsUtf8((ByteString)value);
            this.ensureInstanceNamesIsMutable();
            this.instanceNames_.add(value);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        private void ensureInstanceReferencesIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.instanceReferences_ = new ArrayList<InstanceReference>(this.instanceReferences_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<InstanceReference> getInstanceReferencesList() {
            if (this.instanceReferencesBuilder_ == null) {
                return Collections.unmodifiableList(this.instanceReferences_);
            }
            return this.instanceReferencesBuilder_.getMessageList();
        }

        @Override
        public int getInstanceReferencesCount() {
            if (this.instanceReferencesBuilder_ == null) {
                return this.instanceReferences_.size();
            }
            return this.instanceReferencesBuilder_.getCount();
        }

        @Override
        public InstanceReference getInstanceReferences(int index) {
            if (this.instanceReferencesBuilder_ == null) {
                return this.instanceReferences_.get(index);
            }
            return (InstanceReference)this.instanceReferencesBuilder_.getMessage(index);
        }

        public Builder setInstanceReferences(int index, InstanceReference value) {
            if (this.instanceReferencesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInstanceReferencesIsMutable();
                this.instanceReferences_.set(index, value);
                this.onChanged();
            } else {
                this.instanceReferencesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setInstanceReferences(int index, InstanceReference.Builder builderForValue) {
            if (this.instanceReferencesBuilder_ == null) {
                this.ensureInstanceReferencesIsMutable();
                this.instanceReferences_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.instanceReferencesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addInstanceReferences(InstanceReference value) {
            if (this.instanceReferencesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInstanceReferencesIsMutable();
                this.instanceReferences_.add(value);
                this.onChanged();
            } else {
                this.instanceReferencesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addInstanceReferences(int index, InstanceReference value) {
            if (this.instanceReferencesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInstanceReferencesIsMutable();
                this.instanceReferences_.add(index, value);
                this.onChanged();
            } else {
                this.instanceReferencesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addInstanceReferences(InstanceReference.Builder builderForValue) {
            if (this.instanceReferencesBuilder_ == null) {
                this.ensureInstanceReferencesIsMutable();
                this.instanceReferences_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.instanceReferencesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addInstanceReferences(int index, InstanceReference.Builder builderForValue) {
            if (this.instanceReferencesBuilder_ == null) {
                this.ensureInstanceReferencesIsMutable();
                this.instanceReferences_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.instanceReferencesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllInstanceReferences(Iterable<? extends InstanceReference> values) {
            if (this.instanceReferencesBuilder_ == null) {
                this.ensureInstanceReferencesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.instanceReferences_);
                this.onChanged();
            } else {
                this.instanceReferencesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearInstanceReferences() {
            if (this.instanceReferencesBuilder_ == null) {
                this.instanceReferences_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.instanceReferencesBuilder_.clear();
            }
            return this;
        }

        public Builder removeInstanceReferences(int index) {
            if (this.instanceReferencesBuilder_ == null) {
                this.ensureInstanceReferencesIsMutable();
                this.instanceReferences_.remove(index);
                this.onChanged();
            } else {
                this.instanceReferencesBuilder_.remove(index);
            }
            return this;
        }

        public InstanceReference.Builder getInstanceReferencesBuilder(int index) {
            return (InstanceReference.Builder)this.getInstanceReferencesFieldBuilder().getBuilder(index);
        }

        @Override
        public InstanceReferenceOrBuilder getInstanceReferencesOrBuilder(int index) {
            if (this.instanceReferencesBuilder_ == null) {
                return this.instanceReferences_.get(index);
            }
            return (InstanceReferenceOrBuilder)this.instanceReferencesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends InstanceReferenceOrBuilder> getInstanceReferencesOrBuilderList() {
            if (this.instanceReferencesBuilder_ != null) {
                return this.instanceReferencesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.instanceReferences_);
        }

        public InstanceReference.Builder addInstanceReferencesBuilder() {
            return (InstanceReference.Builder)this.getInstanceReferencesFieldBuilder().addBuilder((AbstractMessage)InstanceReference.getDefaultInstance());
        }

        public InstanceReference.Builder addInstanceReferencesBuilder(int index) {
            return (InstanceReference.Builder)this.getInstanceReferencesFieldBuilder().addBuilder(index, (AbstractMessage)InstanceReference.getDefaultInstance());
        }

        public List<InstanceReference.Builder> getInstanceReferencesBuilderList() {
            return this.getInstanceReferencesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<InstanceReference, InstanceReference.Builder, InstanceReferenceOrBuilder> getInstanceReferencesFieldBuilder() {
            if (this.instanceReferencesBuilder_ == null) {
                this.instanceReferencesBuilder_ = new RepeatedFieldBuilderV3(this.instanceReferences_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.instanceReferences_ = null;
            }
            return this.instanceReferencesBuilder_;
        }

        @Override
        public String getImageUri() {
            Object ref = this.imageUri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.imageUri_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getImageUriBytes() {
            Object ref = this.imageUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.imageUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setImageUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.imageUri_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearImageUri() {
            this.imageUri_ = InstanceGroupConfig.getDefaultInstance().getImageUri();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setImageUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InstanceGroupConfig.checkByteStringIsUtf8((ByteString)value);
            this.imageUri_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public String getMachineTypeUri() {
            Object ref = this.machineTypeUri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.machineTypeUri_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMachineTypeUriBytes() {
            Object ref = this.machineTypeUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.machineTypeUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMachineTypeUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.machineTypeUri_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearMachineTypeUri() {
            this.machineTypeUri_ = InstanceGroupConfig.getDefaultInstance().getMachineTypeUri();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setMachineTypeUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InstanceGroupConfig.checkByteStringIsUtf8((ByteString)value);
            this.machineTypeUri_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDiskConfig() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public DiskConfig getDiskConfig() {
            if (this.diskConfigBuilder_ == null) {
                return this.diskConfig_ == null ? DiskConfig.getDefaultInstance() : this.diskConfig_;
            }
            return (DiskConfig)this.diskConfigBuilder_.getMessage();
        }

        public Builder setDiskConfig(DiskConfig value) {
            if (this.diskConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.diskConfig_ = value;
            } else {
                this.diskConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setDiskConfig(DiskConfig.Builder builderForValue) {
            if (this.diskConfigBuilder_ == null) {
                this.diskConfig_ = builderForValue.build();
            } else {
                this.diskConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeDiskConfig(DiskConfig value) {
            if (this.diskConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.diskConfig_ != null && this.diskConfig_ != DiskConfig.getDefaultInstance()) {
                    this.getDiskConfigBuilder().mergeFrom(value);
                } else {
                    this.diskConfig_ = value;
                }
            } else {
                this.diskConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.diskConfig_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDiskConfig() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.diskConfig_ = null;
            if (this.diskConfigBuilder_ != null) {
                this.diskConfigBuilder_.dispose();
                this.diskConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DiskConfig.Builder getDiskConfigBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (DiskConfig.Builder)this.getDiskConfigFieldBuilder().getBuilder();
        }

        @Override
        public DiskConfigOrBuilder getDiskConfigOrBuilder() {
            if (this.diskConfigBuilder_ != null) {
                return (DiskConfigOrBuilder)this.diskConfigBuilder_.getMessageOrBuilder();
            }
            return this.diskConfig_ == null ? DiskConfig.getDefaultInstance() : this.diskConfig_;
        }

        private SingleFieldBuilderV3<DiskConfig, DiskConfig.Builder, DiskConfigOrBuilder> getDiskConfigFieldBuilder() {
            if (this.diskConfigBuilder_ == null) {
                this.diskConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDiskConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.diskConfig_ = null;
            }
            return this.diskConfigBuilder_;
        }

        @Override
        public boolean getIsPreemptible() {
            return this.isPreemptible_;
        }

        public Builder setIsPreemptible(boolean value) {
            this.isPreemptible_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearIsPreemptible() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.isPreemptible_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getPreemptibilityValue() {
            return this.preemptibility_;
        }

        public Builder setPreemptibilityValue(int value) {
            this.preemptibility_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public Preemptibility getPreemptibility() {
            Preemptibility result = Preemptibility.forNumber(this.preemptibility_);
            return result == null ? Preemptibility.UNRECOGNIZED : result;
        }

        public Builder setPreemptibility(Preemptibility value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x80;
            this.preemptibility_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPreemptibility() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.preemptibility_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasManagedGroupConfig() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public ManagedGroupConfig getManagedGroupConfig() {
            if (this.managedGroupConfigBuilder_ == null) {
                return this.managedGroupConfig_ == null ? ManagedGroupConfig.getDefaultInstance() : this.managedGroupConfig_;
            }
            return (ManagedGroupConfig)this.managedGroupConfigBuilder_.getMessage();
        }

        public Builder setManagedGroupConfig(ManagedGroupConfig value) {
            if (this.managedGroupConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.managedGroupConfig_ = value;
            } else {
                this.managedGroupConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setManagedGroupConfig(ManagedGroupConfig.Builder builderForValue) {
            if (this.managedGroupConfigBuilder_ == null) {
                this.managedGroupConfig_ = builderForValue.build();
            } else {
                this.managedGroupConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeManagedGroupConfig(ManagedGroupConfig value) {
            if (this.managedGroupConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.managedGroupConfig_ != null && this.managedGroupConfig_ != ManagedGroupConfig.getDefaultInstance()) {
                    this.getManagedGroupConfigBuilder().mergeFrom(value);
                } else {
                    this.managedGroupConfig_ = value;
                }
            } else {
                this.managedGroupConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.managedGroupConfig_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearManagedGroupConfig() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.managedGroupConfig_ = null;
            if (this.managedGroupConfigBuilder_ != null) {
                this.managedGroupConfigBuilder_.dispose();
                this.managedGroupConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ManagedGroupConfig.Builder getManagedGroupConfigBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (ManagedGroupConfig.Builder)this.getManagedGroupConfigFieldBuilder().getBuilder();
        }

        @Override
        public ManagedGroupConfigOrBuilder getManagedGroupConfigOrBuilder() {
            if (this.managedGroupConfigBuilder_ != null) {
                return (ManagedGroupConfigOrBuilder)this.managedGroupConfigBuilder_.getMessageOrBuilder();
            }
            return this.managedGroupConfig_ == null ? ManagedGroupConfig.getDefaultInstance() : this.managedGroupConfig_;
        }

        private SingleFieldBuilderV3<ManagedGroupConfig, ManagedGroupConfig.Builder, ManagedGroupConfigOrBuilder> getManagedGroupConfigFieldBuilder() {
            if (this.managedGroupConfigBuilder_ == null) {
                this.managedGroupConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getManagedGroupConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.managedGroupConfig_ = null;
            }
            return this.managedGroupConfigBuilder_;
        }

        private void ensureAcceleratorsIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.accelerators_ = new ArrayList<AcceleratorConfig>(this.accelerators_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<AcceleratorConfig> getAcceleratorsList() {
            if (this.acceleratorsBuilder_ == null) {
                return Collections.unmodifiableList(this.accelerators_);
            }
            return this.acceleratorsBuilder_.getMessageList();
        }

        @Override
        public int getAcceleratorsCount() {
            if (this.acceleratorsBuilder_ == null) {
                return this.accelerators_.size();
            }
            return this.acceleratorsBuilder_.getCount();
        }

        @Override
        public AcceleratorConfig getAccelerators(int index) {
            if (this.acceleratorsBuilder_ == null) {
                return this.accelerators_.get(index);
            }
            return (AcceleratorConfig)this.acceleratorsBuilder_.getMessage(index);
        }

        public Builder setAccelerators(int index, AcceleratorConfig value) {
            if (this.acceleratorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.set(index, value);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAccelerators(int index, AcceleratorConfig.Builder builderForValue) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAccelerators(AcceleratorConfig value) {
            if (this.acceleratorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(value);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAccelerators(int index, AcceleratorConfig value) {
            if (this.acceleratorsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(index, value);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAccelerators(AcceleratorConfig.Builder builderForValue) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAccelerators(int index, AcceleratorConfig.Builder builderForValue) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAccelerators(Iterable<? extends AcceleratorConfig> values) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.accelerators_);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAccelerators() {
            if (this.acceleratorsBuilder_ == null) {
                this.accelerators_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAccelerators(int index) {
            if (this.acceleratorsBuilder_ == null) {
                this.ensureAcceleratorsIsMutable();
                this.accelerators_.remove(index);
                this.onChanged();
            } else {
                this.acceleratorsBuilder_.remove(index);
            }
            return this;
        }

        public AcceleratorConfig.Builder getAcceleratorsBuilder(int index) {
            return (AcceleratorConfig.Builder)this.getAcceleratorsFieldBuilder().getBuilder(index);
        }

        @Override
        public AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(int index) {
            if (this.acceleratorsBuilder_ == null) {
                return this.accelerators_.get(index);
            }
            return (AcceleratorConfigOrBuilder)this.acceleratorsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AcceleratorConfigOrBuilder> getAcceleratorsOrBuilderList() {
            if (this.acceleratorsBuilder_ != null) {
                return this.acceleratorsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.accelerators_);
        }

        public AcceleratorConfig.Builder addAcceleratorsBuilder() {
            return (AcceleratorConfig.Builder)this.getAcceleratorsFieldBuilder().addBuilder((AbstractMessage)AcceleratorConfig.getDefaultInstance());
        }

        public AcceleratorConfig.Builder addAcceleratorsBuilder(int index) {
            return (AcceleratorConfig.Builder)this.getAcceleratorsFieldBuilder().addBuilder(index, (AbstractMessage)AcceleratorConfig.getDefaultInstance());
        }

        public List<AcceleratorConfig.Builder> getAcceleratorsBuilderList() {
            return this.getAcceleratorsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AcceleratorConfig, AcceleratorConfig.Builder, AcceleratorConfigOrBuilder> getAcceleratorsFieldBuilder() {
            if (this.acceleratorsBuilder_ == null) {
                this.acceleratorsBuilder_ = new RepeatedFieldBuilderV3(this.accelerators_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.accelerators_ = null;
            }
            return this.acceleratorsBuilder_;
        }

        @Override
        public String getMinCpuPlatform() {
            Object ref = this.minCpuPlatform_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.minCpuPlatform_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMinCpuPlatformBytes() {
            Object ref = this.minCpuPlatform_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.minCpuPlatform_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMinCpuPlatform(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.minCpuPlatform_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearMinCpuPlatform() {
            this.minCpuPlatform_ = InstanceGroupConfig.getDefaultInstance().getMinCpuPlatform();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        public Builder setMinCpuPlatformBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            InstanceGroupConfig.checkByteStringIsUtf8((ByteString)value);
            this.minCpuPlatform_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public int getMinNumInstances() {
            return this.minNumInstances_;
        }

        public Builder setMinNumInstances(int value) {
            this.minNumInstances_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearMinNumInstances() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.minNumInstances_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasInstanceFlexibilityPolicy() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public InstanceFlexibilityPolicy getInstanceFlexibilityPolicy() {
            if (this.instanceFlexibilityPolicyBuilder_ == null) {
                return this.instanceFlexibilityPolicy_ == null ? InstanceFlexibilityPolicy.getDefaultInstance() : this.instanceFlexibilityPolicy_;
            }
            return (InstanceFlexibilityPolicy)this.instanceFlexibilityPolicyBuilder_.getMessage();
        }

        public Builder setInstanceFlexibilityPolicy(InstanceFlexibilityPolicy value) {
            if (this.instanceFlexibilityPolicyBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.instanceFlexibilityPolicy_ = value;
            } else {
                this.instanceFlexibilityPolicyBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setInstanceFlexibilityPolicy(InstanceFlexibilityPolicy.Builder builderForValue) {
            if (this.instanceFlexibilityPolicyBuilder_ == null) {
                this.instanceFlexibilityPolicy_ = builderForValue.build();
            } else {
                this.instanceFlexibilityPolicyBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeInstanceFlexibilityPolicy(InstanceFlexibilityPolicy value) {
            if (this.instanceFlexibilityPolicyBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.instanceFlexibilityPolicy_ != null && this.instanceFlexibilityPolicy_ != InstanceFlexibilityPolicy.getDefaultInstance()) {
                    this.getInstanceFlexibilityPolicyBuilder().mergeFrom(value);
                } else {
                    this.instanceFlexibilityPolicy_ = value;
                }
            } else {
                this.instanceFlexibilityPolicyBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.instanceFlexibilityPolicy_ != null) {
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearInstanceFlexibilityPolicy() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.instanceFlexibilityPolicy_ = null;
            if (this.instanceFlexibilityPolicyBuilder_ != null) {
                this.instanceFlexibilityPolicyBuilder_.dispose();
                this.instanceFlexibilityPolicyBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public InstanceFlexibilityPolicy.Builder getInstanceFlexibilityPolicyBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (InstanceFlexibilityPolicy.Builder)this.getInstanceFlexibilityPolicyFieldBuilder().getBuilder();
        }

        @Override
        public InstanceFlexibilityPolicyOrBuilder getInstanceFlexibilityPolicyOrBuilder() {
            if (this.instanceFlexibilityPolicyBuilder_ != null) {
                return (InstanceFlexibilityPolicyOrBuilder)this.instanceFlexibilityPolicyBuilder_.getMessageOrBuilder();
            }
            return this.instanceFlexibilityPolicy_ == null ? InstanceFlexibilityPolicy.getDefaultInstance() : this.instanceFlexibilityPolicy_;
        }

        private SingleFieldBuilderV3<InstanceFlexibilityPolicy, InstanceFlexibilityPolicy.Builder, InstanceFlexibilityPolicyOrBuilder> getInstanceFlexibilityPolicyFieldBuilder() {
            if (this.instanceFlexibilityPolicyBuilder_ == null) {
                this.instanceFlexibilityPolicyBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getInstanceFlexibilityPolicy(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.instanceFlexibilityPolicy_ = null;
            }
            return this.instanceFlexibilityPolicyBuilder_;
        }

        @Override
        public boolean hasStartupConfig() {
            return (this.bitField0_ & 0x2000) != 0;
        }

        @Override
        public StartupConfig getStartupConfig() {
            if (this.startupConfigBuilder_ == null) {
                return this.startupConfig_ == null ? StartupConfig.getDefaultInstance() : this.startupConfig_;
            }
            return (StartupConfig)this.startupConfigBuilder_.getMessage();
        }

        public Builder setStartupConfig(StartupConfig value) {
            if (this.startupConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.startupConfig_ = value;
            } else {
                this.startupConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder setStartupConfig(StartupConfig.Builder builderForValue) {
            if (this.startupConfigBuilder_ == null) {
                this.startupConfig_ = builderForValue.build();
            } else {
                this.startupConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder mergeStartupConfig(StartupConfig value) {
            if (this.startupConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0 && this.startupConfig_ != null && this.startupConfig_ != StartupConfig.getDefaultInstance()) {
                    this.getStartupConfigBuilder().mergeFrom(value);
                } else {
                    this.startupConfig_ = value;
                }
            } else {
                this.startupConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.startupConfig_ != null) {
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearStartupConfig() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.startupConfig_ = null;
            if (this.startupConfigBuilder_ != null) {
                this.startupConfigBuilder_.dispose();
                this.startupConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public StartupConfig.Builder getStartupConfigBuilder() {
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return (StartupConfig.Builder)this.getStartupConfigFieldBuilder().getBuilder();
        }

        @Override
        public StartupConfigOrBuilder getStartupConfigOrBuilder() {
            if (this.startupConfigBuilder_ != null) {
                return (StartupConfigOrBuilder)this.startupConfigBuilder_.getMessageOrBuilder();
            }
            return this.startupConfig_ == null ? StartupConfig.getDefaultInstance() : this.startupConfig_;
        }

        private SingleFieldBuilderV3<StartupConfig, StartupConfig.Builder, StartupConfigOrBuilder> getStartupConfigFieldBuilder() {
            if (this.startupConfigBuilder_ == null) {
                this.startupConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStartupConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.startupConfig_ = null;
            }
            return this.startupConfigBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum Preemptibility implements ProtocolMessageEnum
    {
        PREEMPTIBILITY_UNSPECIFIED(0),
        NON_PREEMPTIBLE(1),
        PREEMPTIBLE(2),
        SPOT(3),
        UNRECOGNIZED(-1);

        public static final int PREEMPTIBILITY_UNSPECIFIED_VALUE = 0;
        public static final int NON_PREEMPTIBLE_VALUE = 1;
        public static final int PREEMPTIBLE_VALUE = 2;
        public static final int SPOT_VALUE = 3;
        private static final Internal.EnumLiteMap<Preemptibility> internalValueMap;
        private static final Preemptibility[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Preemptibility valueOf(int value) {
            return Preemptibility.forNumber(value);
        }

        public static Preemptibility forNumber(int value) {
            switch (value) {
                case 0: {
                    return PREEMPTIBILITY_UNSPECIFIED;
                }
                case 1: {
                    return NON_PREEMPTIBLE;
                }
                case 2: {
                    return PREEMPTIBLE;
                }
                case 3: {
                    return SPOT;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Preemptibility> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Preemptibility.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Preemptibility.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)InstanceGroupConfig.getDescriptor().getEnumTypes().get(0);
        }

        public static Preemptibility valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Preemptibility.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Preemptibility(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Preemptibility>(){

                public Preemptibility findValueByNumber(int number) {
                    return Preemptibility.forNumber(number);
                }
            };
            VALUES = Preemptibility.values();
        }
    }
}

