/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/service.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Request message for [CloudChannelService.TransferEntitlementsToGoogle][google.cloud.channel.v1.CloudChannelService.TransferEntitlementsToGoogle].
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.TransferEntitlementsToGoogleRequest}
 */
public final class TransferEntitlementsToGoogleRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.TransferEntitlementsToGoogleRequest)
    TransferEntitlementsToGoogleRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransferEntitlementsToGoogleRequest.newBuilder() to construct.
  private TransferEntitlementsToGoogleRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransferEntitlementsToGoogleRequest() {
    parent_ = "";
    entitlements_ = java.util.Collections.emptyList();
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransferEntitlementsToGoogleRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.ServiceProto
        .internal_static_google_cloud_channel_v1_TransferEntitlementsToGoogleRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.ServiceProto
        .internal_static_google_cloud_channel_v1_TransferEntitlementsToGoogleRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest.class,
            com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the reseller's customer account where the entitlements
   * transfer from.
   * Parent uses the format: accounts/{account_id}/customers/{customer_id}
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the reseller's customer account where the entitlements
   * transfer from.
   * Parent uses the format: accounts/{account_id}/customers/{customer_id}
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITLEMENTS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.channel.v1.Entitlement> entitlements_;
  /**
   *
   *
   * <pre>
   * Required. The entitlements to transfer to Google.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.Entitlement> getEntitlementsList() {
    return entitlements_;
  }
  /**
   *
   *
   * <pre>
   * Required. The entitlements to transfer to Google.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.channel.v1.EntitlementOrBuilder>
      getEntitlementsOrBuilderList() {
    return entitlements_;
  }
  /**
   *
   *
   * <pre>
   * Required. The entitlements to transfer to Google.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getEntitlementsCount() {
    return entitlements_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The entitlements to transfer to Google.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Entitlement getEntitlements(int index) {
    return entitlements_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The entitlements to transfer to Google.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.EntitlementOrBuilder getEntitlementsOrBuilder(int index) {
    return entitlements_.get(index);
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 3;
  private volatile java.lang.Object requestId_;
  /**
   *
   *
   * <pre>
   * Optional. You can specify an optional unique request ID, and if you need to retry
   * your request, the server will know to ignore the request if it's complete.
   * For example, you make an initial request and the request times out. If you
   * make the request again with the same request ID, the server can check if
   * it received the original operation with the same request ID. If it did, it
   * will ignore the second request.
   * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
   * with the exception that zero UUID is not supported
   * (`00000000-0000-0000-0000-000000000000`).
   * </pre>
   *
   * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. You can specify an optional unique request ID, and if you need to retry
   * your request, the server will know to ignore the request if it's complete.
   * For example, you make an initial request and the request times out. If you
   * make the request again with the same request ID, the server can check if
   * it received the original operation with the same request ID. If it did, it
   * will ignore the second request.
   * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
   * with the exception that zero UUID is not supported
   * (`00000000-0000-0000-0000-000000000000`).
   * </pre>
   *
   * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    for (int i = 0; i < entitlements_.size(); i++) {
      output.writeMessage(2, entitlements_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    for (int i = 0; i < entitlements_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, entitlements_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest other =
        (com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getEntitlementsList().equals(other.getEntitlementsList())) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (getEntitlementsCount() > 0) {
      hash = (37 * hash) + ENTITLEMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getEntitlementsList().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [CloudChannelService.TransferEntitlementsToGoogle][google.cloud.channel.v1.CloudChannelService.TransferEntitlementsToGoogle].
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.TransferEntitlementsToGoogleRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.TransferEntitlementsToGoogleRequest)
      com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_TransferEntitlementsToGoogleRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_TransferEntitlementsToGoogleRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest.class,
              com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      if (entitlementsBuilder_ == null) {
        entitlements_ = java.util.Collections.emptyList();
      } else {
        entitlements_ = null;
        entitlementsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      requestId_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_TransferEntitlementsToGoogleRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest
        getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest build() {
      com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest buildPartial() {
      com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest result =
          new com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest(this);
      int from_bitField0_ = bitField0_;
      result.parent_ = parent_;
      if (entitlementsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          entitlements_ = java.util.Collections.unmodifiableList(entitlements_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.entitlements_ = entitlements_;
      } else {
        result.entitlements_ = entitlementsBuilder_.build();
      }
      result.requestId_ = requestId_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest) {
        return mergeFrom((com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest other) {
      if (other
          == com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (entitlementsBuilder_ == null) {
        if (!other.entitlements_.isEmpty()) {
          if (entitlements_.isEmpty()) {
            entitlements_ = other.entitlements_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEntitlementsIsMutable();
            entitlements_.addAll(other.entitlements_);
          }
          onChanged();
        }
      } else {
        if (!other.entitlements_.isEmpty()) {
          if (entitlementsBuilder_.isEmpty()) {
            entitlementsBuilder_.dispose();
            entitlementsBuilder_ = null;
            entitlements_ = other.entitlements_;
            bitField0_ = (bitField0_ & ~0x00000001);
            entitlementsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEntitlementsFieldBuilder()
                    : null;
          } else {
            entitlementsBuilder_.addAllMessages(other.entitlements_);
          }
        }
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                com.google.cloud.channel.v1.Entitlement m =
                    input.readMessage(
                        com.google.cloud.channel.v1.Entitlement.parser(), extensionRegistry);
                if (entitlementsBuilder_ == null) {
                  ensureEntitlementsIsMutable();
                  entitlements_.add(m);
                } else {
                  entitlementsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                requestId_ = input.readStringRequireUtf8();

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's customer account where the entitlements
     * transfer from.
     * Parent uses the format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's customer account where the entitlements
     * transfer from.
     * Parent uses the format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's customer account where the entitlements
     * transfer from.
     * Parent uses the format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's customer account where the entitlements
     * transfer from.
     * Parent uses the format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's customer account where the entitlements
     * transfer from.
     * Parent uses the format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.channel.v1.Entitlement> entitlements_ =
        java.util.Collections.emptyList();

    private void ensureEntitlementsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        entitlements_ =
            new java.util.ArrayList<com.google.cloud.channel.v1.Entitlement>(entitlements_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.Entitlement,
            com.google.cloud.channel.v1.Entitlement.Builder,
            com.google.cloud.channel.v1.EntitlementOrBuilder>
        entitlementsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.channel.v1.Entitlement> getEntitlementsList() {
      if (entitlementsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(entitlements_);
      } else {
        return entitlementsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getEntitlementsCount() {
      if (entitlementsBuilder_ == null) {
        return entitlements_.size();
      } else {
        return entitlementsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.Entitlement getEntitlements(int index) {
      if (entitlementsBuilder_ == null) {
        return entitlements_.get(index);
      } else {
        return entitlementsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setEntitlements(int index, com.google.cloud.channel.v1.Entitlement value) {
      if (entitlementsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitlementsIsMutable();
        entitlements_.set(index, value);
        onChanged();
      } else {
        entitlementsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setEntitlements(
        int index, com.google.cloud.channel.v1.Entitlement.Builder builderForValue) {
      if (entitlementsBuilder_ == null) {
        ensureEntitlementsIsMutable();
        entitlements_.set(index, builderForValue.build());
        onChanged();
      } else {
        entitlementsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntitlements(com.google.cloud.channel.v1.Entitlement value) {
      if (entitlementsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitlementsIsMutable();
        entitlements_.add(value);
        onChanged();
      } else {
        entitlementsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntitlements(int index, com.google.cloud.channel.v1.Entitlement value) {
      if (entitlementsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitlementsIsMutable();
        entitlements_.add(index, value);
        onChanged();
      } else {
        entitlementsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntitlements(
        com.google.cloud.channel.v1.Entitlement.Builder builderForValue) {
      if (entitlementsBuilder_ == null) {
        ensureEntitlementsIsMutable();
        entitlements_.add(builderForValue.build());
        onChanged();
      } else {
        entitlementsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntitlements(
        int index, com.google.cloud.channel.v1.Entitlement.Builder builderForValue) {
      if (entitlementsBuilder_ == null) {
        ensureEntitlementsIsMutable();
        entitlements_.add(index, builderForValue.build());
        onChanged();
      } else {
        entitlementsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllEntitlements(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.Entitlement> values) {
      if (entitlementsBuilder_ == null) {
        ensureEntitlementsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entitlements_);
        onChanged();
      } else {
        entitlementsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearEntitlements() {
      if (entitlementsBuilder_ == null) {
        entitlements_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        entitlementsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeEntitlements(int index) {
      if (entitlementsBuilder_ == null) {
        ensureEntitlementsIsMutable();
        entitlements_.remove(index);
        onChanged();
      } else {
        entitlementsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.Entitlement.Builder getEntitlementsBuilder(int index) {
      return getEntitlementsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.EntitlementOrBuilder getEntitlementsOrBuilder(int index) {
      if (entitlementsBuilder_ == null) {
        return entitlements_.get(index);
      } else {
        return entitlementsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.channel.v1.EntitlementOrBuilder>
        getEntitlementsOrBuilderList() {
      if (entitlementsBuilder_ != null) {
        return entitlementsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(entitlements_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.Entitlement.Builder addEntitlementsBuilder() {
      return getEntitlementsFieldBuilder()
          .addBuilder(com.google.cloud.channel.v1.Entitlement.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.Entitlement.Builder addEntitlementsBuilder(int index) {
      return getEntitlementsFieldBuilder()
          .addBuilder(index, com.google.cloud.channel.v1.Entitlement.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The entitlements to transfer to Google.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement entitlements = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.channel.v1.Entitlement.Builder>
        getEntitlementsBuilderList() {
      return getEntitlementsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.Entitlement,
            com.google.cloud.channel.v1.Entitlement.Builder,
            com.google.cloud.channel.v1.EntitlementOrBuilder>
        getEntitlementsFieldBuilder() {
      if (entitlementsBuilder_ == null) {
        entitlementsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.channel.v1.Entitlement,
                com.google.cloud.channel.v1.Entitlement.Builder,
                com.google.cloud.channel.v1.EntitlementOrBuilder>(
                entitlements_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        entitlements_ = null;
      }
      return entitlementsBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. You can specify an optional unique request ID, and if you need to retry
     * your request, the server will know to ignore the request if it's complete.
     * For example, you make an initial request and the request times out. If you
     * make the request again with the same request ID, the server can check if
     * it received the original operation with the same request ID. If it did, it
     * will ignore the second request.
     * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     * with the exception that zero UUID is not supported
     * (`00000000-0000-0000-0000-000000000000`).
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. You can specify an optional unique request ID, and if you need to retry
     * your request, the server will know to ignore the request if it's complete.
     * For example, you make an initial request and the request times out. If you
     * make the request again with the same request ID, the server can check if
     * it received the original operation with the same request ID. If it did, it
     * will ignore the second request.
     * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     * with the exception that zero UUID is not supported
     * (`00000000-0000-0000-0000-000000000000`).
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. You can specify an optional unique request ID, and if you need to retry
     * your request, the server will know to ignore the request if it's complete.
     * For example, you make an initial request and the request times out. If you
     * make the request again with the same request ID, the server can check if
     * it received the original operation with the same request ID. If it did, it
     * will ignore the second request.
     * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     * with the exception that zero UUID is not supported
     * (`00000000-0000-0000-0000-000000000000`).
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      requestId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. You can specify an optional unique request ID, and if you need to retry
     * your request, the server will know to ignore the request if it's complete.
     * For example, you make an initial request and the request times out. If you
     * make the request again with the same request ID, the server can check if
     * it received the original operation with the same request ID. If it did, it
     * will ignore the second request.
     * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     * with the exception that zero UUID is not supported
     * (`00000000-0000-0000-0000-000000000000`).
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {

      requestId_ = getDefaultInstance().getRequestId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. You can specify an optional unique request ID, and if you need to retry
     * your request, the server will know to ignore the request if it's complete.
     * For example, you make an initial request and the request times out. If you
     * make the request again with the same request ID, the server can check if
     * it received the original operation with the same request ID. If it did, it
     * will ignore the second request.
     * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     * with the exception that zero UUID is not supported
     * (`00000000-0000-0000-0000-000000000000`).
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      requestId_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.TransferEntitlementsToGoogleRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.TransferEntitlementsToGoogleRequest)
  private static final com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest();
  }

  public static com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransferEntitlementsToGoogleRequest> PARSER =
      new com.google.protobuf.AbstractParser<TransferEntitlementsToGoogleRequest>() {
        @java.lang.Override
        public TransferEntitlementsToGoogleRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransferEntitlementsToGoogleRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransferEntitlementsToGoogleRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
