/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/repricing.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Configuration for repricing a Google bill over a period of time.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.RepricingConfig}
 */
public final class RepricingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.RepricingConfig)
    RepricingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RepricingConfig.newBuilder() to construct.
  private RepricingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RepricingConfig() {
    rebillingBasis_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RepricingConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.RepricingProto
        .internal_static_google_cloud_channel_v1_RepricingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.RepricingProto
        .internal_static_google_cloud_channel_v1_RepricingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.RepricingConfig.class,
            com.google.cloud.channel.v1.RepricingConfig.Builder.class);
  }

  public interface EntitlementGranularityOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.channel.v1.RepricingConfig.EntitlementGranularity)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Resource name of the entitlement.
     * Format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The entitlement.
     */
    java.lang.String getEntitlement();
    /**
     *
     *
     * <pre>
     * Resource name of the entitlement.
     * Format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for entitlement.
     */
    com.google.protobuf.ByteString getEntitlementBytes();
  }
  /**
   *
   *
   * <pre>
   * Applies the repricing configuration at the entitlement level.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.RepricingConfig.EntitlementGranularity}
   */
  public static final class EntitlementGranularity extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.RepricingConfig.EntitlementGranularity)
      EntitlementGranularityOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EntitlementGranularity.newBuilder() to construct.
    private EntitlementGranularity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EntitlementGranularity() {
      entitlement_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EntitlementGranularity();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.RepricingProto
          .internal_static_google_cloud_channel_v1_RepricingConfig_EntitlementGranularity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.RepricingProto
          .internal_static_google_cloud_channel_v1_RepricingConfig_EntitlementGranularity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.class,
              com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.Builder.class);
    }

    public static final int ENTITLEMENT_FIELD_NUMBER = 1;
    private volatile java.lang.Object entitlement_;
    /**
     *
     *
     * <pre>
     * Resource name of the entitlement.
     * Format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The entitlement.
     */
    @java.lang.Override
    public java.lang.String getEntitlement() {
      java.lang.Object ref = entitlement_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entitlement_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the entitlement.
     * Format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for entitlement.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntitlementBytes() {
      java.lang.Object ref = entitlement_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entitlement_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entitlement_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, entitlement_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entitlement_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, entitlement_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity)) {
        return super.equals(obj);
      }
      com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity other =
          (com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity) obj;

      if (!getEntitlement().equals(other.getEntitlement())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENTITLEMENT_FIELD_NUMBER;
      hash = (53 * hash) + getEntitlement().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the entitlement level.
     * </pre>
     *
     * Protobuf type {@code google.cloud.channel.v1.RepricingConfig.EntitlementGranularity}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.RepricingConfig.EntitlementGranularity)
        com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.channel.v1.RepricingProto
            .internal_static_google_cloud_channel_v1_RepricingConfig_EntitlementGranularity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.channel.v1.RepricingProto
            .internal_static_google_cloud_channel_v1_RepricingConfig_EntitlementGranularity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.class,
                com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.Builder.class);
      }

      // Construct using
      // com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        entitlement_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.channel.v1.RepricingProto
            .internal_static_google_cloud_channel_v1_RepricingConfig_EntitlementGranularity_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
          getDefaultInstanceForType() {
        return com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity build() {
        com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity buildPartial() {
        com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity result =
            new com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity(this);
        result.entitlement_ = entitlement_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity) {
          return mergeFrom(
              (com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity other) {
        if (other
            == com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
                .getDefaultInstance()) return this;
        if (!other.getEntitlement().isEmpty()) {
          entitlement_ = other.entitlement_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  entitlement_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object entitlement_ = "";
      /**
       *
       *
       * <pre>
       * Resource name of the entitlement.
       * Format:
       * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
       * </pre>
       *
       * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The entitlement.
       */
      public java.lang.String getEntitlement() {
        java.lang.Object ref = entitlement_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entitlement_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Resource name of the entitlement.
       * Format:
       * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
       * </pre>
       *
       * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for entitlement.
       */
      public com.google.protobuf.ByteString getEntitlementBytes() {
        java.lang.Object ref = entitlement_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entitlement_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Resource name of the entitlement.
       * Format:
       * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
       * </pre>
       *
       * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The entitlement to set.
       * @return This builder for chaining.
       */
      public Builder setEntitlement(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        entitlement_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource name of the entitlement.
       * Format:
       * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
       * </pre>
       *
       * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEntitlement() {

        entitlement_ = getDefaultInstance().getEntitlement();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource name of the entitlement.
       * Format:
       * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
       * </pre>
       *
       * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for entitlement to set.
       * @return This builder for chaining.
       */
      public Builder setEntitlementBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        entitlement_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.RepricingConfig.EntitlementGranularity)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.RepricingConfig.EntitlementGranularity)
    private static final com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity();
    }

    public static com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EntitlementGranularity> PARSER =
        new com.google.protobuf.AbstractParser<EntitlementGranularity>() {
          @java.lang.Override
          public EntitlementGranularity parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EntitlementGranularity> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EntitlementGranularity> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ChannelPartnerGranularityOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Applies the repricing configuration at the channel partner level.
   * The channel partner value is derived from the resource name. Takes an
   * empty json object.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity}
   */
  public static final class ChannelPartnerGranularity extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity)
      ChannelPartnerGranularityOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ChannelPartnerGranularity.newBuilder() to construct.
    private ChannelPartnerGranularity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ChannelPartnerGranularity() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ChannelPartnerGranularity();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.RepricingProto
          .internal_static_google_cloud_channel_v1_RepricingConfig_ChannelPartnerGranularity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.RepricingProto
          .internal_static_google_cloud_channel_v1_RepricingConfig_ChannelPartnerGranularity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity.class,
              com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity)) {
        return super.equals(obj);
      }
      com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity other =
          (com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the channel partner level.
     * The channel partner value is derived from the resource name. Takes an
     * empty json object.
     * </pre>
     *
     * Protobuf type {@code google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity)
        com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.channel.v1.RepricingProto
            .internal_static_google_cloud_channel_v1_RepricingConfig_ChannelPartnerGranularity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.channel.v1.RepricingProto
            .internal_static_google_cloud_channel_v1_RepricingConfig_ChannelPartnerGranularity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity.class,
                com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.channel.v1.RepricingProto
            .internal_static_google_cloud_channel_v1_RepricingConfig_ChannelPartnerGranularity_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
          getDefaultInstanceForType() {
        return com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity build() {
        com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity buildPartial() {
        com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity result =
            new com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity) {
          return mergeFrom(
              (com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity other) {
        if (other
            == com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity)
    private static final com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity();
    }

    public static com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ChannelPartnerGranularity> PARSER =
        new com.google.protobuf.AbstractParser<ChannelPartnerGranularity>() {
          @java.lang.Override
          public ChannelPartnerGranularity parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ChannelPartnerGranularity> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ChannelPartnerGranularity> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int granularityCase_ = 0;
  private java.lang.Object granularity_;

  public enum GranularityCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ENTITLEMENT_GRANULARITY(4),
    CHANNEL_PARTNER_GRANULARITY(5),
    GRANULARITY_NOT_SET(0);
    private final int value;

    private GranularityCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static GranularityCase valueOf(int value) {
      return forNumber(value);
    }

    public static GranularityCase forNumber(int value) {
      switch (value) {
        case 4:
          return ENTITLEMENT_GRANULARITY;
        case 5:
          return CHANNEL_PARTNER_GRANULARITY;
        case 0:
          return GRANULARITY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public GranularityCase getGranularityCase() {
    return GranularityCase.forNumber(granularityCase_);
  }

  public static final int ENTITLEMENT_GRANULARITY_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Applies the repricing configuration at the entitlement level. This is
   * the only supported value for CustomerRepricingConfig.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
   * </code>
   *
   * @return Whether the entitlementGranularity field is set.
   */
  @java.lang.Override
  public boolean hasEntitlementGranularity() {
    return granularityCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Applies the repricing configuration at the entitlement level. This is
   * the only supported value for CustomerRepricingConfig.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
   * </code>
   *
   * @return The entitlementGranularity.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
      getEntitlementGranularity() {
    if (granularityCase_ == 4) {
      return (com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity) granularity_;
    }
    return com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Applies the repricing configuration at the entitlement level. This is
   * the only supported value for CustomerRepricingConfig.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularityOrBuilder
      getEntitlementGranularityOrBuilder() {
    if (granularityCase_ == 4) {
      return (com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity) granularity_;
    }
    return com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.getDefaultInstance();
  }

  public static final int CHANNEL_PARTNER_GRANULARITY_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Applies the repricing configuration at the channel partner level.
   * This is the only supported value for ChannelPartnerRepricingConfig.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
   * </code>
   *
   * @return Whether the channelPartnerGranularity field is set.
   */
  @java.lang.Override
  public boolean hasChannelPartnerGranularity() {
    return granularityCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Applies the repricing configuration at the channel partner level.
   * This is the only supported value for ChannelPartnerRepricingConfig.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
   * </code>
   *
   * @return The channelPartnerGranularity.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
      getChannelPartnerGranularity() {
    if (granularityCase_ == 5) {
      return (com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity) granularity_;
    }
    return com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Applies the repricing configuration at the channel partner level.
   * This is the only supported value for ChannelPartnerRepricingConfig.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularityOrBuilder
      getChannelPartnerGranularityOrBuilder() {
    if (granularityCase_ == 5) {
      return (com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity) granularity_;
    }
    return com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
        .getDefaultInstance();
  }

  public static final int EFFECTIVE_INVOICE_MONTH_FIELD_NUMBER = 1;
  private com.google.type.Date effectiveInvoiceMonth_;
  /**
   *
   *
   * <pre>
   * Required. The YearMonth when these adjustments activate. The Day field needs to be
   * "0" since we only accept YearMonth repricing boundaries.
   * </pre>
   *
   * <code>.google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the effectiveInvoiceMonth field is set.
   */
  @java.lang.Override
  public boolean hasEffectiveInvoiceMonth() {
    return effectiveInvoiceMonth_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The YearMonth when these adjustments activate. The Day field needs to be
   * "0" since we only accept YearMonth repricing boundaries.
   * </pre>
   *
   * <code>.google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The effectiveInvoiceMonth.
   */
  @java.lang.Override
  public com.google.type.Date getEffectiveInvoiceMonth() {
    return effectiveInvoiceMonth_ == null
        ? com.google.type.Date.getDefaultInstance()
        : effectiveInvoiceMonth_;
  }
  /**
   *
   *
   * <pre>
   * Required. The YearMonth when these adjustments activate. The Day field needs to be
   * "0" since we only accept YearMonth repricing boundaries.
   * </pre>
   *
   * <code>.google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.type.DateOrBuilder getEffectiveInvoiceMonthOrBuilder() {
    return getEffectiveInvoiceMonth();
  }

  public static final int ADJUSTMENT_FIELD_NUMBER = 2;
  private com.google.cloud.channel.v1.RepricingAdjustment adjustment_;
  /**
   *
   *
   * <pre>
   * Required. Information about the adjustment.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the adjustment field is set.
   */
  @java.lang.Override
  public boolean hasAdjustment() {
    return adjustment_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Information about the adjustment.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The adjustment.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.RepricingAdjustment getAdjustment() {
    return adjustment_ == null
        ? com.google.cloud.channel.v1.RepricingAdjustment.getDefaultInstance()
        : adjustment_;
  }
  /**
   *
   *
   * <pre>
   * Required. Information about the adjustment.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.RepricingAdjustmentOrBuilder getAdjustmentOrBuilder() {
    return getAdjustment();
  }

  public static final int REBILLING_BASIS_FIELD_NUMBER = 3;
  private int rebillingBasis_;
  /**
   *
   *
   * <pre>
   * Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to use for this bill. Specifies the relative cost
   * based on repricing costs you will apply.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.RebillingBasis rebilling_basis = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for rebillingBasis.
   */
  @java.lang.Override
  public int getRebillingBasisValue() {
    return rebillingBasis_;
  }
  /**
   *
   *
   * <pre>
   * Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to use for this bill. Specifies the relative cost
   * based on repricing costs you will apply.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.RebillingBasis rebilling_basis = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The rebillingBasis.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.RebillingBasis getRebillingBasis() {
    @SuppressWarnings("deprecation")
    com.google.cloud.channel.v1.RebillingBasis result =
        com.google.cloud.channel.v1.RebillingBasis.valueOf(rebillingBasis_);
    return result == null ? com.google.cloud.channel.v1.RebillingBasis.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (effectiveInvoiceMonth_ != null) {
      output.writeMessage(1, getEffectiveInvoiceMonth());
    }
    if (adjustment_ != null) {
      output.writeMessage(2, getAdjustment());
    }
    if (rebillingBasis_
        != com.google.cloud.channel.v1.RebillingBasis.REBILLING_BASIS_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, rebillingBasis_);
    }
    if (granularityCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity) granularity_);
    }
    if (granularityCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity) granularity_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (effectiveInvoiceMonth_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEffectiveInvoiceMonth());
    }
    if (adjustment_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAdjustment());
    }
    if (rebillingBasis_
        != com.google.cloud.channel.v1.RebillingBasis.REBILLING_BASIS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, rebillingBasis_);
    }
    if (granularityCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity) granularity_);
    }
    if (granularityCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity) granularity_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.RepricingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.RepricingConfig other =
        (com.google.cloud.channel.v1.RepricingConfig) obj;

    if (hasEffectiveInvoiceMonth() != other.hasEffectiveInvoiceMonth()) return false;
    if (hasEffectiveInvoiceMonth()) {
      if (!getEffectiveInvoiceMonth().equals(other.getEffectiveInvoiceMonth())) return false;
    }
    if (hasAdjustment() != other.hasAdjustment()) return false;
    if (hasAdjustment()) {
      if (!getAdjustment().equals(other.getAdjustment())) return false;
    }
    if (rebillingBasis_ != other.rebillingBasis_) return false;
    if (!getGranularityCase().equals(other.getGranularityCase())) return false;
    switch (granularityCase_) {
      case 4:
        if (!getEntitlementGranularity().equals(other.getEntitlementGranularity())) return false;
        break;
      case 5:
        if (!getChannelPartnerGranularity().equals(other.getChannelPartnerGranularity()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasEffectiveInvoiceMonth()) {
      hash = (37 * hash) + EFFECTIVE_INVOICE_MONTH_FIELD_NUMBER;
      hash = (53 * hash) + getEffectiveInvoiceMonth().hashCode();
    }
    if (hasAdjustment()) {
      hash = (37 * hash) + ADJUSTMENT_FIELD_NUMBER;
      hash = (53 * hash) + getAdjustment().hashCode();
    }
    hash = (37 * hash) + REBILLING_BASIS_FIELD_NUMBER;
    hash = (53 * hash) + rebillingBasis_;
    switch (granularityCase_) {
      case 4:
        hash = (37 * hash) + ENTITLEMENT_GRANULARITY_FIELD_NUMBER;
        hash = (53 * hash) + getEntitlementGranularity().hashCode();
        break;
      case 5:
        hash = (37 * hash) + CHANNEL_PARTNER_GRANULARITY_FIELD_NUMBER;
        hash = (53 * hash) + getChannelPartnerGranularity().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.RepricingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.RepricingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for repricing a Google bill over a period of time.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.RepricingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.RepricingConfig)
      com.google.cloud.channel.v1.RepricingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.RepricingProto
          .internal_static_google_cloud_channel_v1_RepricingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.RepricingProto
          .internal_static_google_cloud_channel_v1_RepricingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.RepricingConfig.class,
              com.google.cloud.channel.v1.RepricingConfig.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.RepricingConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (entitlementGranularityBuilder_ != null) {
        entitlementGranularityBuilder_.clear();
      }
      if (channelPartnerGranularityBuilder_ != null) {
        channelPartnerGranularityBuilder_.clear();
      }
      if (effectiveInvoiceMonthBuilder_ == null) {
        effectiveInvoiceMonth_ = null;
      } else {
        effectiveInvoiceMonth_ = null;
        effectiveInvoiceMonthBuilder_ = null;
      }
      if (adjustmentBuilder_ == null) {
        adjustment_ = null;
      } else {
        adjustment_ = null;
        adjustmentBuilder_ = null;
      }
      rebillingBasis_ = 0;

      granularityCase_ = 0;
      granularity_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.RepricingProto
          .internal_static_google_cloud_channel_v1_RepricingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.RepricingConfig getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.RepricingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.RepricingConfig build() {
      com.google.cloud.channel.v1.RepricingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.RepricingConfig buildPartial() {
      com.google.cloud.channel.v1.RepricingConfig result =
          new com.google.cloud.channel.v1.RepricingConfig(this);
      if (granularityCase_ == 4) {
        if (entitlementGranularityBuilder_ == null) {
          result.granularity_ = granularity_;
        } else {
          result.granularity_ = entitlementGranularityBuilder_.build();
        }
      }
      if (granularityCase_ == 5) {
        if (channelPartnerGranularityBuilder_ == null) {
          result.granularity_ = granularity_;
        } else {
          result.granularity_ = channelPartnerGranularityBuilder_.build();
        }
      }
      if (effectiveInvoiceMonthBuilder_ == null) {
        result.effectiveInvoiceMonth_ = effectiveInvoiceMonth_;
      } else {
        result.effectiveInvoiceMonth_ = effectiveInvoiceMonthBuilder_.build();
      }
      if (adjustmentBuilder_ == null) {
        result.adjustment_ = adjustment_;
      } else {
        result.adjustment_ = adjustmentBuilder_.build();
      }
      result.rebillingBasis_ = rebillingBasis_;
      result.granularityCase_ = granularityCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.RepricingConfig) {
        return mergeFrom((com.google.cloud.channel.v1.RepricingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.RepricingConfig other) {
      if (other == com.google.cloud.channel.v1.RepricingConfig.getDefaultInstance()) return this;
      if (other.hasEffectiveInvoiceMonth()) {
        mergeEffectiveInvoiceMonth(other.getEffectiveInvoiceMonth());
      }
      if (other.hasAdjustment()) {
        mergeAdjustment(other.getAdjustment());
      }
      if (other.rebillingBasis_ != 0) {
        setRebillingBasisValue(other.getRebillingBasisValue());
      }
      switch (other.getGranularityCase()) {
        case ENTITLEMENT_GRANULARITY:
          {
            mergeEntitlementGranularity(other.getEntitlementGranularity());
            break;
          }
        case CHANNEL_PARTNER_GRANULARITY:
          {
            mergeChannelPartnerGranularity(other.getChannelPartnerGranularity());
            break;
          }
        case GRANULARITY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getEffectiveInvoiceMonthFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getAdjustmentFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 24:
              {
                rebillingBasis_ = input.readEnum();

                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getEntitlementGranularityFieldBuilder().getBuilder(), extensionRegistry);
                granularityCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getChannelPartnerGranularityFieldBuilder().getBuilder(), extensionRegistry);
                granularityCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int granularityCase_ = 0;
    private java.lang.Object granularity_;

    public GranularityCase getGranularityCase() {
      return GranularityCase.forNumber(granularityCase_);
    }

    public Builder clearGranularity() {
      granularityCase_ = 0;
      granularity_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity,
            com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.Builder,
            com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularityOrBuilder>
        entitlementGranularityBuilder_;
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the entitlement level. This is
     * the only supported value for CustomerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
     * </code>
     *
     * @return Whether the entitlementGranularity field is set.
     */
    @java.lang.Override
    public boolean hasEntitlementGranularity() {
      return granularityCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the entitlement level. This is
     * the only supported value for CustomerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
     * </code>
     *
     * @return The entitlementGranularity.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
        getEntitlementGranularity() {
      if (entitlementGranularityBuilder_ == null) {
        if (granularityCase_ == 4) {
          return (com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity) granularity_;
        }
        return com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
            .getDefaultInstance();
      } else {
        if (granularityCase_ == 4) {
          return entitlementGranularityBuilder_.getMessage();
        }
        return com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the entitlement level. This is
     * the only supported value for CustomerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
     * </code>
     */
    public Builder setEntitlementGranularity(
        com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity value) {
      if (entitlementGranularityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        granularity_ = value;
        onChanged();
      } else {
        entitlementGranularityBuilder_.setMessage(value);
      }
      granularityCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the entitlement level. This is
     * the only supported value for CustomerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
     * </code>
     */
    public Builder setEntitlementGranularity(
        com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.Builder
            builderForValue) {
      if (entitlementGranularityBuilder_ == null) {
        granularity_ = builderForValue.build();
        onChanged();
      } else {
        entitlementGranularityBuilder_.setMessage(builderForValue.build());
      }
      granularityCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the entitlement level. This is
     * the only supported value for CustomerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
     * </code>
     */
    public Builder mergeEntitlementGranularity(
        com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity value) {
      if (entitlementGranularityBuilder_ == null) {
        if (granularityCase_ == 4
            && granularity_
                != com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
                    .getDefaultInstance()) {
          granularity_ =
              com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.newBuilder(
                      (com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity)
                          granularity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          granularity_ = value;
        }
        onChanged();
      } else {
        if (granularityCase_ == 4) {
          entitlementGranularityBuilder_.mergeFrom(value);
        } else {
          entitlementGranularityBuilder_.setMessage(value);
        }
      }
      granularityCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the entitlement level. This is
     * the only supported value for CustomerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
     * </code>
     */
    public Builder clearEntitlementGranularity() {
      if (entitlementGranularityBuilder_ == null) {
        if (granularityCase_ == 4) {
          granularityCase_ = 0;
          granularity_ = null;
          onChanged();
        }
      } else {
        if (granularityCase_ == 4) {
          granularityCase_ = 0;
          granularity_ = null;
        }
        entitlementGranularityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the entitlement level. This is
     * the only supported value for CustomerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
     * </code>
     */
    public com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.Builder
        getEntitlementGranularityBuilder() {
      return getEntitlementGranularityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the entitlement level. This is
     * the only supported value for CustomerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularityOrBuilder
        getEntitlementGranularityOrBuilder() {
      if ((granularityCase_ == 4) && (entitlementGranularityBuilder_ != null)) {
        return entitlementGranularityBuilder_.getMessageOrBuilder();
      } else {
        if (granularityCase_ == 4) {
          return (com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity) granularity_;
        }
        return com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the entitlement level. This is
     * the only supported value for CustomerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.EntitlementGranularity entitlement_granularity = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity,
            com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.Builder,
            com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularityOrBuilder>
        getEntitlementGranularityFieldBuilder() {
      if (entitlementGranularityBuilder_ == null) {
        if (!(granularityCase_ == 4)) {
          granularity_ =
              com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
                  .getDefaultInstance();
        }
        entitlementGranularityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity,
                com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.Builder,
                com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularityOrBuilder>(
                (com.google.cloud.channel.v1.RepricingConfig.EntitlementGranularity) granularity_,
                getParentForChildren(),
                isClean());
        granularity_ = null;
      }
      granularityCase_ = 4;
      onChanged();
      ;
      return entitlementGranularityBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity,
            com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity.Builder,
            com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularityOrBuilder>
        channelPartnerGranularityBuilder_;
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the channel partner level.
     * This is the only supported value for ChannelPartnerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
     * </code>
     *
     * @return Whether the channelPartnerGranularity field is set.
     */
    @java.lang.Override
    public boolean hasChannelPartnerGranularity() {
      return granularityCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the channel partner level.
     * This is the only supported value for ChannelPartnerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
     * </code>
     *
     * @return The channelPartnerGranularity.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
        getChannelPartnerGranularity() {
      if (channelPartnerGranularityBuilder_ == null) {
        if (granularityCase_ == 5) {
          return (com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity)
              granularity_;
        }
        return com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
            .getDefaultInstance();
      } else {
        if (granularityCase_ == 5) {
          return channelPartnerGranularityBuilder_.getMessage();
        }
        return com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the channel partner level.
     * This is the only supported value for ChannelPartnerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
     * </code>
     */
    public Builder setChannelPartnerGranularity(
        com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity value) {
      if (channelPartnerGranularityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        granularity_ = value;
        onChanged();
      } else {
        channelPartnerGranularityBuilder_.setMessage(value);
      }
      granularityCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the channel partner level.
     * This is the only supported value for ChannelPartnerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
     * </code>
     */
    public Builder setChannelPartnerGranularity(
        com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity.Builder
            builderForValue) {
      if (channelPartnerGranularityBuilder_ == null) {
        granularity_ = builderForValue.build();
        onChanged();
      } else {
        channelPartnerGranularityBuilder_.setMessage(builderForValue.build());
      }
      granularityCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the channel partner level.
     * This is the only supported value for ChannelPartnerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
     * </code>
     */
    public Builder mergeChannelPartnerGranularity(
        com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity value) {
      if (channelPartnerGranularityBuilder_ == null) {
        if (granularityCase_ == 5
            && granularity_
                != com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
                    .getDefaultInstance()) {
          granularity_ =
              com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity.newBuilder(
                      (com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity)
                          granularity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          granularity_ = value;
        }
        onChanged();
      } else {
        if (granularityCase_ == 5) {
          channelPartnerGranularityBuilder_.mergeFrom(value);
        } else {
          channelPartnerGranularityBuilder_.setMessage(value);
        }
      }
      granularityCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the channel partner level.
     * This is the only supported value for ChannelPartnerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
     * </code>
     */
    public Builder clearChannelPartnerGranularity() {
      if (channelPartnerGranularityBuilder_ == null) {
        if (granularityCase_ == 5) {
          granularityCase_ = 0;
          granularity_ = null;
          onChanged();
        }
      } else {
        if (granularityCase_ == 5) {
          granularityCase_ = 0;
          granularity_ = null;
        }
        channelPartnerGranularityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the channel partner level.
     * This is the only supported value for ChannelPartnerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
     * </code>
     */
    public com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity.Builder
        getChannelPartnerGranularityBuilder() {
      return getChannelPartnerGranularityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the channel partner level.
     * This is the only supported value for ChannelPartnerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularityOrBuilder
        getChannelPartnerGranularityOrBuilder() {
      if ((granularityCase_ == 5) && (channelPartnerGranularityBuilder_ != null)) {
        return channelPartnerGranularityBuilder_.getMessageOrBuilder();
      } else {
        if (granularityCase_ == 5) {
          return (com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity)
              granularity_;
        }
        return com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies the repricing configuration at the channel partner level.
     * This is the only supported value for ChannelPartnerRepricingConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity channel_partner_granularity = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity,
            com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity.Builder,
            com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularityOrBuilder>
        getChannelPartnerGranularityFieldBuilder() {
      if (channelPartnerGranularityBuilder_ == null) {
        if (!(granularityCase_ == 5)) {
          granularity_ =
              com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
                  .getDefaultInstance();
        }
        channelPartnerGranularityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity,
                com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity.Builder,
                com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularityOrBuilder>(
                (com.google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity)
                    granularity_,
                getParentForChildren(),
                isClean());
        granularity_ = null;
      }
      granularityCase_ = 5;
      onChanged();
      ;
      return channelPartnerGranularityBuilder_;
    }

    private com.google.type.Date effectiveInvoiceMonth_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        effectiveInvoiceMonthBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The YearMonth when these adjustments activate. The Day field needs to be
     * "0" since we only accept YearMonth repricing boundaries.
     * </pre>
     *
     * <code>
     * .google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the effectiveInvoiceMonth field is set.
     */
    public boolean hasEffectiveInvoiceMonth() {
      return effectiveInvoiceMonthBuilder_ != null || effectiveInvoiceMonth_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The YearMonth when these adjustments activate. The Day field needs to be
     * "0" since we only accept YearMonth repricing boundaries.
     * </pre>
     *
     * <code>
     * .google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The effectiveInvoiceMonth.
     */
    public com.google.type.Date getEffectiveInvoiceMonth() {
      if (effectiveInvoiceMonthBuilder_ == null) {
        return effectiveInvoiceMonth_ == null
            ? com.google.type.Date.getDefaultInstance()
            : effectiveInvoiceMonth_;
      } else {
        return effectiveInvoiceMonthBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The YearMonth when these adjustments activate. The Day field needs to be
     * "0" since we only accept YearMonth repricing boundaries.
     * </pre>
     *
     * <code>
     * .google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setEffectiveInvoiceMonth(com.google.type.Date value) {
      if (effectiveInvoiceMonthBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        effectiveInvoiceMonth_ = value;
        onChanged();
      } else {
        effectiveInvoiceMonthBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The YearMonth when these adjustments activate. The Day field needs to be
     * "0" since we only accept YearMonth repricing boundaries.
     * </pre>
     *
     * <code>
     * .google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setEffectiveInvoiceMonth(com.google.type.Date.Builder builderForValue) {
      if (effectiveInvoiceMonthBuilder_ == null) {
        effectiveInvoiceMonth_ = builderForValue.build();
        onChanged();
      } else {
        effectiveInvoiceMonthBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The YearMonth when these adjustments activate. The Day field needs to be
     * "0" since we only accept YearMonth repricing boundaries.
     * </pre>
     *
     * <code>
     * .google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeEffectiveInvoiceMonth(com.google.type.Date value) {
      if (effectiveInvoiceMonthBuilder_ == null) {
        if (effectiveInvoiceMonth_ != null) {
          effectiveInvoiceMonth_ =
              com.google.type.Date.newBuilder(effectiveInvoiceMonth_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          effectiveInvoiceMonth_ = value;
        }
        onChanged();
      } else {
        effectiveInvoiceMonthBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The YearMonth when these adjustments activate. The Day field needs to be
     * "0" since we only accept YearMonth repricing boundaries.
     * </pre>
     *
     * <code>
     * .google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearEffectiveInvoiceMonth() {
      if (effectiveInvoiceMonthBuilder_ == null) {
        effectiveInvoiceMonth_ = null;
        onChanged();
      } else {
        effectiveInvoiceMonth_ = null;
        effectiveInvoiceMonthBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The YearMonth when these adjustments activate. The Day field needs to be
     * "0" since we only accept YearMonth repricing boundaries.
     * </pre>
     *
     * <code>
     * .google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.type.Date.Builder getEffectiveInvoiceMonthBuilder() {

      onChanged();
      return getEffectiveInvoiceMonthFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The YearMonth when these adjustments activate. The Day field needs to be
     * "0" since we only accept YearMonth repricing boundaries.
     * </pre>
     *
     * <code>
     * .google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.type.DateOrBuilder getEffectiveInvoiceMonthOrBuilder() {
      if (effectiveInvoiceMonthBuilder_ != null) {
        return effectiveInvoiceMonthBuilder_.getMessageOrBuilder();
      } else {
        return effectiveInvoiceMonth_ == null
            ? com.google.type.Date.getDefaultInstance()
            : effectiveInvoiceMonth_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The YearMonth when these adjustments activate. The Day field needs to be
     * "0" since we only accept YearMonth repricing boundaries.
     * </pre>
     *
     * <code>
     * .google.type.Date effective_invoice_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        getEffectiveInvoiceMonthFieldBuilder() {
      if (effectiveInvoiceMonthBuilder_ == null) {
        effectiveInvoiceMonthBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>(
                getEffectiveInvoiceMonth(), getParentForChildren(), isClean());
        effectiveInvoiceMonth_ = null;
      }
      return effectiveInvoiceMonthBuilder_;
    }

    private com.google.cloud.channel.v1.RepricingAdjustment adjustment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.RepricingAdjustment,
            com.google.cloud.channel.v1.RepricingAdjustment.Builder,
            com.google.cloud.channel.v1.RepricingAdjustmentOrBuilder>
        adjustmentBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Information about the adjustment.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the adjustment field is set.
     */
    public boolean hasAdjustment() {
      return adjustmentBuilder_ != null || adjustment_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the adjustment.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The adjustment.
     */
    public com.google.cloud.channel.v1.RepricingAdjustment getAdjustment() {
      if (adjustmentBuilder_ == null) {
        return adjustment_ == null
            ? com.google.cloud.channel.v1.RepricingAdjustment.getDefaultInstance()
            : adjustment_;
      } else {
        return adjustmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the adjustment.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAdjustment(com.google.cloud.channel.v1.RepricingAdjustment value) {
      if (adjustmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        adjustment_ = value;
        onChanged();
      } else {
        adjustmentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the adjustment.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAdjustment(
        com.google.cloud.channel.v1.RepricingAdjustment.Builder builderForValue) {
      if (adjustmentBuilder_ == null) {
        adjustment_ = builderForValue.build();
        onChanged();
      } else {
        adjustmentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the adjustment.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAdjustment(com.google.cloud.channel.v1.RepricingAdjustment value) {
      if (adjustmentBuilder_ == null) {
        if (adjustment_ != null) {
          adjustment_ =
              com.google.cloud.channel.v1.RepricingAdjustment.newBuilder(adjustment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          adjustment_ = value;
        }
        onChanged();
      } else {
        adjustmentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the adjustment.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAdjustment() {
      if (adjustmentBuilder_ == null) {
        adjustment_ = null;
        onChanged();
      } else {
        adjustment_ = null;
        adjustmentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the adjustment.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.RepricingAdjustment.Builder getAdjustmentBuilder() {

      onChanged();
      return getAdjustmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the adjustment.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.RepricingAdjustmentOrBuilder getAdjustmentOrBuilder() {
      if (adjustmentBuilder_ != null) {
        return adjustmentBuilder_.getMessageOrBuilder();
      } else {
        return adjustment_ == null
            ? com.google.cloud.channel.v1.RepricingAdjustment.getDefaultInstance()
            : adjustment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the adjustment.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RepricingAdjustment adjustment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.RepricingAdjustment,
            com.google.cloud.channel.v1.RepricingAdjustment.Builder,
            com.google.cloud.channel.v1.RepricingAdjustmentOrBuilder>
        getAdjustmentFieldBuilder() {
      if (adjustmentBuilder_ == null) {
        adjustmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.RepricingAdjustment,
                com.google.cloud.channel.v1.RepricingAdjustment.Builder,
                com.google.cloud.channel.v1.RepricingAdjustmentOrBuilder>(
                getAdjustment(), getParentForChildren(), isClean());
        adjustment_ = null;
      }
      return adjustmentBuilder_;
    }

    private int rebillingBasis_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to use for this bill. Specifies the relative cost
     * based on repricing costs you will apply.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RebillingBasis rebilling_basis = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for rebillingBasis.
     */
    @java.lang.Override
    public int getRebillingBasisValue() {
      return rebillingBasis_;
    }
    /**
     *
     *
     * <pre>
     * Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to use for this bill. Specifies the relative cost
     * based on repricing costs you will apply.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RebillingBasis rebilling_basis = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for rebillingBasis to set.
     * @return This builder for chaining.
     */
    public Builder setRebillingBasisValue(int value) {

      rebillingBasis_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to use for this bill. Specifies the relative cost
     * based on repricing costs you will apply.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RebillingBasis rebilling_basis = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The rebillingBasis.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.RebillingBasis getRebillingBasis() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.RebillingBasis result =
          com.google.cloud.channel.v1.RebillingBasis.valueOf(rebillingBasis_);
      return result == null ? com.google.cloud.channel.v1.RebillingBasis.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to use for this bill. Specifies the relative cost
     * based on repricing costs you will apply.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RebillingBasis rebilling_basis = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The rebillingBasis to set.
     * @return This builder for chaining.
     */
    public Builder setRebillingBasis(com.google.cloud.channel.v1.RebillingBasis value) {
      if (value == null) {
        throw new NullPointerException();
      }

      rebillingBasis_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to use for this bill. Specifies the relative cost
     * based on repricing costs you will apply.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.RebillingBasis rebilling_basis = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRebillingBasis() {

      rebillingBasis_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.RepricingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.RepricingConfig)
  private static final com.google.cloud.channel.v1.RepricingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.RepricingConfig();
  }

  public static com.google.cloud.channel.v1.RepricingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RepricingConfig> PARSER =
      new com.google.protobuf.AbstractParser<RepricingConfig>() {
        @java.lang.Override
        public RepricingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RepricingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RepricingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.RepricingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
