/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/reports_service.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * A single report value.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.ReportValue}
 */
public final class ReportValue extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.ReportValue)
    ReportValueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReportValue.newBuilder() to construct.
  private ReportValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReportValue() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReportValue();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.ReportsServiceProto
        .internal_static_google_cloud_channel_v1_ReportValue_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.ReportsServiceProto
        .internal_static_google_cloud_channel_v1_ReportValue_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.ReportValue.class,
            com.google.cloud.channel.v1.ReportValue.Builder.class);
  }

  private int valueCase_ = 0;
  private java.lang.Object value_;

  public enum ValueCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STRING_VALUE(1),
    INT_VALUE(2),
    DECIMAL_VALUE(3),
    MONEY_VALUE(4),
    DATE_VALUE(5),
    DATE_TIME_VALUE(6),
    VALUE_NOT_SET(0);
    private final int value;

    private ValueCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueCase valueOf(int value) {
      return forNumber(value);
    }

    public static ValueCase forNumber(int value) {
      switch (value) {
        case 1:
          return STRING_VALUE;
        case 2:
          return INT_VALUE;
        case 3:
          return DECIMAL_VALUE;
        case 4:
          return MONEY_VALUE;
        case 5:
          return DATE_VALUE;
        case 6:
          return DATE_TIME_VALUE;
        case 0:
          return VALUE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ValueCase getValueCase() {
    return ValueCase.forNumber(valueCase_);
  }

  public static final int STRING_VALUE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * A value of type `string`.
   * </pre>
   *
   * <code>string string_value = 1;</code>
   *
   * @return Whether the stringValue field is set.
   */
  public boolean hasStringValue() {
    return valueCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * A value of type `string`.
   * </pre>
   *
   * <code>string string_value = 1;</code>
   *
   * @return The stringValue.
   */
  public java.lang.String getStringValue() {
    java.lang.Object ref = "";
    if (valueCase_ == 1) {
      ref = value_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (valueCase_ == 1) {
        value_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A value of type `string`.
   * </pre>
   *
   * <code>string string_value = 1;</code>
   *
   * @return The bytes for stringValue.
   */
  public com.google.protobuf.ByteString getStringValueBytes() {
    java.lang.Object ref = "";
    if (valueCase_ == 1) {
      ref = value_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (valueCase_ == 1) {
        value_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INT_VALUE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A value of type `int`.
   * </pre>
   *
   * <code>int64 int_value = 2;</code>
   *
   * @return Whether the intValue field is set.
   */
  @java.lang.Override
  public boolean hasIntValue() {
    return valueCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A value of type `int`.
   * </pre>
   *
   * <code>int64 int_value = 2;</code>
   *
   * @return The intValue.
   */
  @java.lang.Override
  public long getIntValue() {
    if (valueCase_ == 2) {
      return (java.lang.Long) value_;
    }
    return 0L;
  }

  public static final int DECIMAL_VALUE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A value of type `google.type.Decimal`, representing non-integer numeric
   * values.
   * </pre>
   *
   * <code>.google.type.Decimal decimal_value = 3;</code>
   *
   * @return Whether the decimalValue field is set.
   */
  @java.lang.Override
  public boolean hasDecimalValue() {
    return valueCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A value of type `google.type.Decimal`, representing non-integer numeric
   * values.
   * </pre>
   *
   * <code>.google.type.Decimal decimal_value = 3;</code>
   *
   * @return The decimalValue.
   */
  @java.lang.Override
  public com.google.type.Decimal getDecimalValue() {
    if (valueCase_ == 3) {
      return (com.google.type.Decimal) value_;
    }
    return com.google.type.Decimal.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A value of type `google.type.Decimal`, representing non-integer numeric
   * values.
   * </pre>
   *
   * <code>.google.type.Decimal decimal_value = 3;</code>
   */
  @java.lang.Override
  public com.google.type.DecimalOrBuilder getDecimalValueOrBuilder() {
    if (valueCase_ == 3) {
      return (com.google.type.Decimal) value_;
    }
    return com.google.type.Decimal.getDefaultInstance();
  }

  public static final int MONEY_VALUE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A value of type `google.type.Money` (currency code, whole units, decimal
   * units).
   * </pre>
   *
   * <code>.google.type.Money money_value = 4;</code>
   *
   * @return Whether the moneyValue field is set.
   */
  @java.lang.Override
  public boolean hasMoneyValue() {
    return valueCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A value of type `google.type.Money` (currency code, whole units, decimal
   * units).
   * </pre>
   *
   * <code>.google.type.Money money_value = 4;</code>
   *
   * @return The moneyValue.
   */
  @java.lang.Override
  public com.google.type.Money getMoneyValue() {
    if (valueCase_ == 4) {
      return (com.google.type.Money) value_;
    }
    return com.google.type.Money.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A value of type `google.type.Money` (currency code, whole units, decimal
   * units).
   * </pre>
   *
   * <code>.google.type.Money money_value = 4;</code>
   */
  @java.lang.Override
  public com.google.type.MoneyOrBuilder getMoneyValueOrBuilder() {
    if (valueCase_ == 4) {
      return (com.google.type.Money) value_;
    }
    return com.google.type.Money.getDefaultInstance();
  }

  public static final int DATE_VALUE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A value of type `google.type.Date` (year, month, day).
   * </pre>
   *
   * <code>.google.type.Date date_value = 5;</code>
   *
   * @return Whether the dateValue field is set.
   */
  @java.lang.Override
  public boolean hasDateValue() {
    return valueCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A value of type `google.type.Date` (year, month, day).
   * </pre>
   *
   * <code>.google.type.Date date_value = 5;</code>
   *
   * @return The dateValue.
   */
  @java.lang.Override
  public com.google.type.Date getDateValue() {
    if (valueCase_ == 5) {
      return (com.google.type.Date) value_;
    }
    return com.google.type.Date.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A value of type `google.type.Date` (year, month, day).
   * </pre>
   *
   * <code>.google.type.Date date_value = 5;</code>
   */
  @java.lang.Override
  public com.google.type.DateOrBuilder getDateValueOrBuilder() {
    if (valueCase_ == 5) {
      return (com.google.type.Date) value_;
    }
    return com.google.type.Date.getDefaultInstance();
  }

  public static final int DATE_TIME_VALUE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A value of type `google.type.DateTime` (year, month, day, hour, minute,
   * second, and UTC offset or timezone.)
   * </pre>
   *
   * <code>.google.type.DateTime date_time_value = 6;</code>
   *
   * @return Whether the dateTimeValue field is set.
   */
  @java.lang.Override
  public boolean hasDateTimeValue() {
    return valueCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A value of type `google.type.DateTime` (year, month, day, hour, minute,
   * second, and UTC offset or timezone.)
   * </pre>
   *
   * <code>.google.type.DateTime date_time_value = 6;</code>
   *
   * @return The dateTimeValue.
   */
  @java.lang.Override
  public com.google.type.DateTime getDateTimeValue() {
    if (valueCase_ == 6) {
      return (com.google.type.DateTime) value_;
    }
    return com.google.type.DateTime.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A value of type `google.type.DateTime` (year, month, day, hour, minute,
   * second, and UTC offset or timezone.)
   * </pre>
   *
   * <code>.google.type.DateTime date_time_value = 6;</code>
   */
  @java.lang.Override
  public com.google.type.DateTimeOrBuilder getDateTimeValueOrBuilder() {
    if (valueCase_ == 6) {
      return (com.google.type.DateTime) value_;
    }
    return com.google.type.DateTime.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (valueCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, value_);
    }
    if (valueCase_ == 2) {
      output.writeInt64(2, (long) ((java.lang.Long) value_));
    }
    if (valueCase_ == 3) {
      output.writeMessage(3, (com.google.type.Decimal) value_);
    }
    if (valueCase_ == 4) {
      output.writeMessage(4, (com.google.type.Money) value_);
    }
    if (valueCase_ == 5) {
      output.writeMessage(5, (com.google.type.Date) value_);
    }
    if (valueCase_ == 6) {
      output.writeMessage(6, (com.google.type.DateTime) value_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (valueCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, value_);
    }
    if (valueCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              2, (long) ((java.lang.Long) value_));
    }
    if (valueCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.type.Decimal) value_);
    }
    if (valueCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.type.Money) value_);
    }
    if (valueCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.type.Date) value_);
    }
    if (valueCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.type.DateTime) value_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.ReportValue)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.ReportValue other = (com.google.cloud.channel.v1.ReportValue) obj;

    if (!getValueCase().equals(other.getValueCase())) return false;
    switch (valueCase_) {
      case 1:
        if (!getStringValue().equals(other.getStringValue())) return false;
        break;
      case 2:
        if (getIntValue() != other.getIntValue()) return false;
        break;
      case 3:
        if (!getDecimalValue().equals(other.getDecimalValue())) return false;
        break;
      case 4:
        if (!getMoneyValue().equals(other.getMoneyValue())) return false;
        break;
      case 5:
        if (!getDateValue().equals(other.getDateValue())) return false;
        break;
      case 6:
        if (!getDateTimeValue().equals(other.getDateTimeValue())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (valueCase_) {
      case 1:
        hash = (37 * hash) + STRING_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getStringValue().hashCode();
        break;
      case 2:
        hash = (37 * hash) + INT_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIntValue());
        break;
      case 3:
        hash = (37 * hash) + DECIMAL_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getDecimalValue().hashCode();
        break;
      case 4:
        hash = (37 * hash) + MONEY_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getMoneyValue().hashCode();
        break;
      case 5:
        hash = (37 * hash) + DATE_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getDateValue().hashCode();
        break;
      case 6:
        hash = (37 * hash) + DATE_TIME_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getDateTimeValue().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.ReportValue parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ReportValue parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ReportValue parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ReportValue parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ReportValue parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ReportValue parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ReportValue parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ReportValue parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ReportValue parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ReportValue parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ReportValue parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ReportValue parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.ReportValue prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A single report value.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.ReportValue}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.ReportValue)
      com.google.cloud.channel.v1.ReportValueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.ReportsServiceProto
          .internal_static_google_cloud_channel_v1_ReportValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.ReportsServiceProto
          .internal_static_google_cloud_channel_v1_ReportValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.ReportValue.class,
              com.google.cloud.channel.v1.ReportValue.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.ReportValue.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (decimalValueBuilder_ != null) {
        decimalValueBuilder_.clear();
      }
      if (moneyValueBuilder_ != null) {
        moneyValueBuilder_.clear();
      }
      if (dateValueBuilder_ != null) {
        dateValueBuilder_.clear();
      }
      if (dateTimeValueBuilder_ != null) {
        dateTimeValueBuilder_.clear();
      }
      valueCase_ = 0;
      value_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.ReportsServiceProto
          .internal_static_google_cloud_channel_v1_ReportValue_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ReportValue getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.ReportValue.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ReportValue build() {
      com.google.cloud.channel.v1.ReportValue result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ReportValue buildPartial() {
      com.google.cloud.channel.v1.ReportValue result =
          new com.google.cloud.channel.v1.ReportValue(this);
      if (valueCase_ == 1) {
        result.value_ = value_;
      }
      if (valueCase_ == 2) {
        result.value_ = value_;
      }
      if (valueCase_ == 3) {
        if (decimalValueBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = decimalValueBuilder_.build();
        }
      }
      if (valueCase_ == 4) {
        if (moneyValueBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = moneyValueBuilder_.build();
        }
      }
      if (valueCase_ == 5) {
        if (dateValueBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = dateValueBuilder_.build();
        }
      }
      if (valueCase_ == 6) {
        if (dateTimeValueBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = dateTimeValueBuilder_.build();
        }
      }
      result.valueCase_ = valueCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.ReportValue) {
        return mergeFrom((com.google.cloud.channel.v1.ReportValue) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.ReportValue other) {
      if (other == com.google.cloud.channel.v1.ReportValue.getDefaultInstance()) return this;
      switch (other.getValueCase()) {
        case STRING_VALUE:
          {
            valueCase_ = 1;
            value_ = other.value_;
            onChanged();
            break;
          }
        case INT_VALUE:
          {
            setIntValue(other.getIntValue());
            break;
          }
        case DECIMAL_VALUE:
          {
            mergeDecimalValue(other.getDecimalValue());
            break;
          }
        case MONEY_VALUE:
          {
            mergeMoneyValue(other.getMoneyValue());
            break;
          }
        case DATE_VALUE:
          {
            mergeDateValue(other.getDateValue());
            break;
          }
        case DATE_TIME_VALUE:
          {
            mergeDateTimeValue(other.getDateTimeValue());
            break;
          }
        case VALUE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                valueCase_ = 1;
                value_ = s;
                break;
              } // case 10
            case 16:
              {
                value_ = input.readInt64();
                valueCase_ = 2;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getDecimalValueFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getMoneyValueFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getDateValueFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getDateTimeValueFieldBuilder().getBuilder(), extensionRegistry);
                valueCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int valueCase_ = 0;
    private java.lang.Object value_;

    public ValueCase getValueCase() {
      return ValueCase.forNumber(valueCase_);
    }

    public Builder clearValue() {
      valueCase_ = 0;
      value_ = null;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A value of type `string`.
     * </pre>
     *
     * <code>string string_value = 1;</code>
     *
     * @return Whether the stringValue field is set.
     */
    @java.lang.Override
    public boolean hasStringValue() {
      return valueCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A value of type `string`.
     * </pre>
     *
     * <code>string string_value = 1;</code>
     *
     * @return The stringValue.
     */
    @java.lang.Override
    public java.lang.String getStringValue() {
      java.lang.Object ref = "";
      if (valueCase_ == 1) {
        ref = value_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valueCase_ == 1) {
          value_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A value of type `string`.
     * </pre>
     *
     * <code>string string_value = 1;</code>
     *
     * @return The bytes for stringValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStringValueBytes() {
      java.lang.Object ref = "";
      if (valueCase_ == 1) {
        ref = value_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (valueCase_ == 1) {
          value_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A value of type `string`.
     * </pre>
     *
     * <code>string string_value = 1;</code>
     *
     * @param value The stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valueCase_ = 1;
      value_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `string`.
     * </pre>
     *
     * <code>string string_value = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStringValue() {
      if (valueCase_ == 1) {
        valueCase_ = 0;
        value_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `string`.
     * </pre>
     *
     * <code>string string_value = 1;</code>
     *
     * @param value The bytes for stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      valueCase_ = 1;
      value_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A value of type `int`.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @return Whether the intValue field is set.
     */
    public boolean hasIntValue() {
      return valueCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A value of type `int`.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @return The intValue.
     */
    public long getIntValue() {
      if (valueCase_ == 2) {
        return (java.lang.Long) value_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * A value of type `int`.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @param value The intValue to set.
     * @return This builder for chaining.
     */
    public Builder setIntValue(long value) {
      valueCase_ = 2;
      value_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `int`.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntValue() {
      if (valueCase_ == 2) {
        valueCase_ = 0;
        value_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Decimal,
            com.google.type.Decimal.Builder,
            com.google.type.DecimalOrBuilder>
        decimalValueBuilder_;
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Decimal`, representing non-integer numeric
     * values.
     * </pre>
     *
     * <code>.google.type.Decimal decimal_value = 3;</code>
     *
     * @return Whether the decimalValue field is set.
     */
    @java.lang.Override
    public boolean hasDecimalValue() {
      return valueCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Decimal`, representing non-integer numeric
     * values.
     * </pre>
     *
     * <code>.google.type.Decimal decimal_value = 3;</code>
     *
     * @return The decimalValue.
     */
    @java.lang.Override
    public com.google.type.Decimal getDecimalValue() {
      if (decimalValueBuilder_ == null) {
        if (valueCase_ == 3) {
          return (com.google.type.Decimal) value_;
        }
        return com.google.type.Decimal.getDefaultInstance();
      } else {
        if (valueCase_ == 3) {
          return decimalValueBuilder_.getMessage();
        }
        return com.google.type.Decimal.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Decimal`, representing non-integer numeric
     * values.
     * </pre>
     *
     * <code>.google.type.Decimal decimal_value = 3;</code>
     */
    public Builder setDecimalValue(com.google.type.Decimal value) {
      if (decimalValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        decimalValueBuilder_.setMessage(value);
      }
      valueCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Decimal`, representing non-integer numeric
     * values.
     * </pre>
     *
     * <code>.google.type.Decimal decimal_value = 3;</code>
     */
    public Builder setDecimalValue(com.google.type.Decimal.Builder builderForValue) {
      if (decimalValueBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        decimalValueBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Decimal`, representing non-integer numeric
     * values.
     * </pre>
     *
     * <code>.google.type.Decimal decimal_value = 3;</code>
     */
    public Builder mergeDecimalValue(com.google.type.Decimal value) {
      if (decimalValueBuilder_ == null) {
        if (valueCase_ == 3 && value_ != com.google.type.Decimal.getDefaultInstance()) {
          value_ =
              com.google.type.Decimal.newBuilder((com.google.type.Decimal) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 3) {
          decimalValueBuilder_.mergeFrom(value);
        } else {
          decimalValueBuilder_.setMessage(value);
        }
      }
      valueCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Decimal`, representing non-integer numeric
     * values.
     * </pre>
     *
     * <code>.google.type.Decimal decimal_value = 3;</code>
     */
    public Builder clearDecimalValue() {
      if (decimalValueBuilder_ == null) {
        if (valueCase_ == 3) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 3) {
          valueCase_ = 0;
          value_ = null;
        }
        decimalValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Decimal`, representing non-integer numeric
     * values.
     * </pre>
     *
     * <code>.google.type.Decimal decimal_value = 3;</code>
     */
    public com.google.type.Decimal.Builder getDecimalValueBuilder() {
      return getDecimalValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Decimal`, representing non-integer numeric
     * values.
     * </pre>
     *
     * <code>.google.type.Decimal decimal_value = 3;</code>
     */
    @java.lang.Override
    public com.google.type.DecimalOrBuilder getDecimalValueOrBuilder() {
      if ((valueCase_ == 3) && (decimalValueBuilder_ != null)) {
        return decimalValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 3) {
          return (com.google.type.Decimal) value_;
        }
        return com.google.type.Decimal.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Decimal`, representing non-integer numeric
     * values.
     * </pre>
     *
     * <code>.google.type.Decimal decimal_value = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Decimal,
            com.google.type.Decimal.Builder,
            com.google.type.DecimalOrBuilder>
        getDecimalValueFieldBuilder() {
      if (decimalValueBuilder_ == null) {
        if (!(valueCase_ == 3)) {
          value_ = com.google.type.Decimal.getDefaultInstance();
        }
        decimalValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Decimal,
                com.google.type.Decimal.Builder,
                com.google.type.DecimalOrBuilder>(
                (com.google.type.Decimal) value_, getParentForChildren(), isClean());
        value_ = null;
      }
      valueCase_ = 3;
      onChanged();
      ;
      return decimalValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        moneyValueBuilder_;
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Money` (currency code, whole units, decimal
     * units).
     * </pre>
     *
     * <code>.google.type.Money money_value = 4;</code>
     *
     * @return Whether the moneyValue field is set.
     */
    @java.lang.Override
    public boolean hasMoneyValue() {
      return valueCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Money` (currency code, whole units, decimal
     * units).
     * </pre>
     *
     * <code>.google.type.Money money_value = 4;</code>
     *
     * @return The moneyValue.
     */
    @java.lang.Override
    public com.google.type.Money getMoneyValue() {
      if (moneyValueBuilder_ == null) {
        if (valueCase_ == 4) {
          return (com.google.type.Money) value_;
        }
        return com.google.type.Money.getDefaultInstance();
      } else {
        if (valueCase_ == 4) {
          return moneyValueBuilder_.getMessage();
        }
        return com.google.type.Money.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Money` (currency code, whole units, decimal
     * units).
     * </pre>
     *
     * <code>.google.type.Money money_value = 4;</code>
     */
    public Builder setMoneyValue(com.google.type.Money value) {
      if (moneyValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        moneyValueBuilder_.setMessage(value);
      }
      valueCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Money` (currency code, whole units, decimal
     * units).
     * </pre>
     *
     * <code>.google.type.Money money_value = 4;</code>
     */
    public Builder setMoneyValue(com.google.type.Money.Builder builderForValue) {
      if (moneyValueBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        moneyValueBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Money` (currency code, whole units, decimal
     * units).
     * </pre>
     *
     * <code>.google.type.Money money_value = 4;</code>
     */
    public Builder mergeMoneyValue(com.google.type.Money value) {
      if (moneyValueBuilder_ == null) {
        if (valueCase_ == 4 && value_ != com.google.type.Money.getDefaultInstance()) {
          value_ =
              com.google.type.Money.newBuilder((com.google.type.Money) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 4) {
          moneyValueBuilder_.mergeFrom(value);
        } else {
          moneyValueBuilder_.setMessage(value);
        }
      }
      valueCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Money` (currency code, whole units, decimal
     * units).
     * </pre>
     *
     * <code>.google.type.Money money_value = 4;</code>
     */
    public Builder clearMoneyValue() {
      if (moneyValueBuilder_ == null) {
        if (valueCase_ == 4) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 4) {
          valueCase_ = 0;
          value_ = null;
        }
        moneyValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Money` (currency code, whole units, decimal
     * units).
     * </pre>
     *
     * <code>.google.type.Money money_value = 4;</code>
     */
    public com.google.type.Money.Builder getMoneyValueBuilder() {
      return getMoneyValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Money` (currency code, whole units, decimal
     * units).
     * </pre>
     *
     * <code>.google.type.Money money_value = 4;</code>
     */
    @java.lang.Override
    public com.google.type.MoneyOrBuilder getMoneyValueOrBuilder() {
      if ((valueCase_ == 4) && (moneyValueBuilder_ != null)) {
        return moneyValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 4) {
          return (com.google.type.Money) value_;
        }
        return com.google.type.Money.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Money` (currency code, whole units, decimal
     * units).
     * </pre>
     *
     * <code>.google.type.Money money_value = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        getMoneyValueFieldBuilder() {
      if (moneyValueBuilder_ == null) {
        if (!(valueCase_ == 4)) {
          value_ = com.google.type.Money.getDefaultInstance();
        }
        moneyValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Money,
                com.google.type.Money.Builder,
                com.google.type.MoneyOrBuilder>(
                (com.google.type.Money) value_, getParentForChildren(), isClean());
        value_ = null;
      }
      valueCase_ = 4;
      onChanged();
      ;
      return moneyValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        dateValueBuilder_;
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Date` (year, month, day).
     * </pre>
     *
     * <code>.google.type.Date date_value = 5;</code>
     *
     * @return Whether the dateValue field is set.
     */
    @java.lang.Override
    public boolean hasDateValue() {
      return valueCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Date` (year, month, day).
     * </pre>
     *
     * <code>.google.type.Date date_value = 5;</code>
     *
     * @return The dateValue.
     */
    @java.lang.Override
    public com.google.type.Date getDateValue() {
      if (dateValueBuilder_ == null) {
        if (valueCase_ == 5) {
          return (com.google.type.Date) value_;
        }
        return com.google.type.Date.getDefaultInstance();
      } else {
        if (valueCase_ == 5) {
          return dateValueBuilder_.getMessage();
        }
        return com.google.type.Date.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Date` (year, month, day).
     * </pre>
     *
     * <code>.google.type.Date date_value = 5;</code>
     */
    public Builder setDateValue(com.google.type.Date value) {
      if (dateValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        dateValueBuilder_.setMessage(value);
      }
      valueCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Date` (year, month, day).
     * </pre>
     *
     * <code>.google.type.Date date_value = 5;</code>
     */
    public Builder setDateValue(com.google.type.Date.Builder builderForValue) {
      if (dateValueBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        dateValueBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Date` (year, month, day).
     * </pre>
     *
     * <code>.google.type.Date date_value = 5;</code>
     */
    public Builder mergeDateValue(com.google.type.Date value) {
      if (dateValueBuilder_ == null) {
        if (valueCase_ == 5 && value_ != com.google.type.Date.getDefaultInstance()) {
          value_ =
              com.google.type.Date.newBuilder((com.google.type.Date) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 5) {
          dateValueBuilder_.mergeFrom(value);
        } else {
          dateValueBuilder_.setMessage(value);
        }
      }
      valueCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Date` (year, month, day).
     * </pre>
     *
     * <code>.google.type.Date date_value = 5;</code>
     */
    public Builder clearDateValue() {
      if (dateValueBuilder_ == null) {
        if (valueCase_ == 5) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 5) {
          valueCase_ = 0;
          value_ = null;
        }
        dateValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Date` (year, month, day).
     * </pre>
     *
     * <code>.google.type.Date date_value = 5;</code>
     */
    public com.google.type.Date.Builder getDateValueBuilder() {
      return getDateValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Date` (year, month, day).
     * </pre>
     *
     * <code>.google.type.Date date_value = 5;</code>
     */
    @java.lang.Override
    public com.google.type.DateOrBuilder getDateValueOrBuilder() {
      if ((valueCase_ == 5) && (dateValueBuilder_ != null)) {
        return dateValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 5) {
          return (com.google.type.Date) value_;
        }
        return com.google.type.Date.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.Date` (year, month, day).
     * </pre>
     *
     * <code>.google.type.Date date_value = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        getDateValueFieldBuilder() {
      if (dateValueBuilder_ == null) {
        if (!(valueCase_ == 5)) {
          value_ = com.google.type.Date.getDefaultInstance();
        }
        dateValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>(
                (com.google.type.Date) value_, getParentForChildren(), isClean());
        value_ = null;
      }
      valueCase_ = 5;
      onChanged();
      ;
      return dateValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.DateTime,
            com.google.type.DateTime.Builder,
            com.google.type.DateTimeOrBuilder>
        dateTimeValueBuilder_;
    /**
     *
     *
     * <pre>
     * A value of type `google.type.DateTime` (year, month, day, hour, minute,
     * second, and UTC offset or timezone.)
     * </pre>
     *
     * <code>.google.type.DateTime date_time_value = 6;</code>
     *
     * @return Whether the dateTimeValue field is set.
     */
    @java.lang.Override
    public boolean hasDateTimeValue() {
      return valueCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.DateTime` (year, month, day, hour, minute,
     * second, and UTC offset or timezone.)
     * </pre>
     *
     * <code>.google.type.DateTime date_time_value = 6;</code>
     *
     * @return The dateTimeValue.
     */
    @java.lang.Override
    public com.google.type.DateTime getDateTimeValue() {
      if (dateTimeValueBuilder_ == null) {
        if (valueCase_ == 6) {
          return (com.google.type.DateTime) value_;
        }
        return com.google.type.DateTime.getDefaultInstance();
      } else {
        if (valueCase_ == 6) {
          return dateTimeValueBuilder_.getMessage();
        }
        return com.google.type.DateTime.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.DateTime` (year, month, day, hour, minute,
     * second, and UTC offset or timezone.)
     * </pre>
     *
     * <code>.google.type.DateTime date_time_value = 6;</code>
     */
    public Builder setDateTimeValue(com.google.type.DateTime value) {
      if (dateTimeValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        onChanged();
      } else {
        dateTimeValueBuilder_.setMessage(value);
      }
      valueCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.DateTime` (year, month, day, hour, minute,
     * second, and UTC offset or timezone.)
     * </pre>
     *
     * <code>.google.type.DateTime date_time_value = 6;</code>
     */
    public Builder setDateTimeValue(com.google.type.DateTime.Builder builderForValue) {
      if (dateTimeValueBuilder_ == null) {
        value_ = builderForValue.build();
        onChanged();
      } else {
        dateTimeValueBuilder_.setMessage(builderForValue.build());
      }
      valueCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.DateTime` (year, month, day, hour, minute,
     * second, and UTC offset or timezone.)
     * </pre>
     *
     * <code>.google.type.DateTime date_time_value = 6;</code>
     */
    public Builder mergeDateTimeValue(com.google.type.DateTime value) {
      if (dateTimeValueBuilder_ == null) {
        if (valueCase_ == 6 && value_ != com.google.type.DateTime.getDefaultInstance()) {
          value_ =
              com.google.type.DateTime.newBuilder((com.google.type.DateTime) value_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          value_ = value;
        }
        onChanged();
      } else {
        if (valueCase_ == 6) {
          dateTimeValueBuilder_.mergeFrom(value);
        } else {
          dateTimeValueBuilder_.setMessage(value);
        }
      }
      valueCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.DateTime` (year, month, day, hour, minute,
     * second, and UTC offset or timezone.)
     * </pre>
     *
     * <code>.google.type.DateTime date_time_value = 6;</code>
     */
    public Builder clearDateTimeValue() {
      if (dateTimeValueBuilder_ == null) {
        if (valueCase_ == 6) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
      } else {
        if (valueCase_ == 6) {
          valueCase_ = 0;
          value_ = null;
        }
        dateTimeValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.DateTime` (year, month, day, hour, minute,
     * second, and UTC offset or timezone.)
     * </pre>
     *
     * <code>.google.type.DateTime date_time_value = 6;</code>
     */
    public com.google.type.DateTime.Builder getDateTimeValueBuilder() {
      return getDateTimeValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.DateTime` (year, month, day, hour, minute,
     * second, and UTC offset or timezone.)
     * </pre>
     *
     * <code>.google.type.DateTime date_time_value = 6;</code>
     */
    @java.lang.Override
    public com.google.type.DateTimeOrBuilder getDateTimeValueOrBuilder() {
      if ((valueCase_ == 6) && (dateTimeValueBuilder_ != null)) {
        return dateTimeValueBuilder_.getMessageOrBuilder();
      } else {
        if (valueCase_ == 6) {
          return (com.google.type.DateTime) value_;
        }
        return com.google.type.DateTime.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A value of type `google.type.DateTime` (year, month, day, hour, minute,
     * second, and UTC offset or timezone.)
     * </pre>
     *
     * <code>.google.type.DateTime date_time_value = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.DateTime,
            com.google.type.DateTime.Builder,
            com.google.type.DateTimeOrBuilder>
        getDateTimeValueFieldBuilder() {
      if (dateTimeValueBuilder_ == null) {
        if (!(valueCase_ == 6)) {
          value_ = com.google.type.DateTime.getDefaultInstance();
        }
        dateTimeValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.DateTime,
                com.google.type.DateTime.Builder,
                com.google.type.DateTimeOrBuilder>(
                (com.google.type.DateTime) value_, getParentForChildren(), isClean());
        value_ = null;
      }
      valueCase_ = 6;
      onChanged();
      ;
      return dateTimeValueBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.ReportValue)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.ReportValue)
  private static final com.google.cloud.channel.v1.ReportValue DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.ReportValue();
  }

  public static com.google.cloud.channel.v1.ReportValue getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReportValue> PARSER =
      new com.google.protobuf.AbstractParser<ReportValue>() {
        @java.lang.Override
        public ReportValue parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReportValue> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReportValue> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.ReportValue getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
