/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/offers.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Specifies the price by the duration of months.
 * For example, a 20% discount for the first six months, then a 10% discount
 * starting on the seventh month.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.PricePhase}
 */
public final class PricePhase extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.PricePhase)
    PricePhaseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PricePhase.newBuilder() to construct.
  private PricePhase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PricePhase() {
    periodType_ = 0;
    priceTiers_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PricePhase();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_PricePhase_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_PricePhase_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.PricePhase.class,
            com.google.cloud.channel.v1.PricePhase.Builder.class);
  }

  public static final int PERIOD_TYPE_FIELD_NUMBER = 1;
  private int periodType_;
  /**
   *
   *
   * <pre>
   * Defines the phase period type.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.PeriodType period_type = 1;</code>
   *
   * @return The enum numeric value on the wire for periodType.
   */
  @java.lang.Override
  public int getPeriodTypeValue() {
    return periodType_;
  }
  /**
   *
   *
   * <pre>
   * Defines the phase period type.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.PeriodType period_type = 1;</code>
   *
   * @return The periodType.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PeriodType getPeriodType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.channel.v1.PeriodType result =
        com.google.cloud.channel.v1.PeriodType.valueOf(periodType_);
    return result == null ? com.google.cloud.channel.v1.PeriodType.UNRECOGNIZED : result;
  }

  public static final int FIRST_PERIOD_FIELD_NUMBER = 2;
  private int firstPeriod_;
  /**
   *
   *
   * <pre>
   * Defines first period for the phase.
   * </pre>
   *
   * <code>int32 first_period = 2;</code>
   *
   * @return The firstPeriod.
   */
  @java.lang.Override
  public int getFirstPeriod() {
    return firstPeriod_;
  }

  public static final int LAST_PERIOD_FIELD_NUMBER = 3;
  private int lastPeriod_;
  /**
   *
   *
   * <pre>
   * Defines first period for the phase.
   * </pre>
   *
   * <code>int32 last_period = 3;</code>
   *
   * @return The lastPeriod.
   */
  @java.lang.Override
  public int getLastPeriod() {
    return lastPeriod_;
  }

  public static final int PRICE_FIELD_NUMBER = 4;
  private com.google.cloud.channel.v1.Price price_;
  /**
   *
   *
   * <pre>
   * Price of the phase. Present if there are no price tiers.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Price price = 4;</code>
   *
   * @return Whether the price field is set.
   */
  @java.lang.Override
  public boolean hasPrice() {
    return price_ != null;
  }
  /**
   *
   *
   * <pre>
   * Price of the phase. Present if there are no price tiers.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Price price = 4;</code>
   *
   * @return The price.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Price getPrice() {
    return price_ == null ? com.google.cloud.channel.v1.Price.getDefaultInstance() : price_;
  }
  /**
   *
   *
   * <pre>
   * Price of the phase. Present if there are no price tiers.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Price price = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PriceOrBuilder getPriceOrBuilder() {
    return getPrice();
  }

  public static final int PRICE_TIERS_FIELD_NUMBER = 5;
  private java.util.List<com.google.cloud.channel.v1.PriceTier> priceTiers_;
  /**
   *
   *
   * <pre>
   * Price by the resource tiers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.PriceTier> getPriceTiersList() {
    return priceTiers_;
  }
  /**
   *
   *
   * <pre>
   * Price by the resource tiers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.channel.v1.PriceTierOrBuilder>
      getPriceTiersOrBuilderList() {
    return priceTiers_;
  }
  /**
   *
   *
   * <pre>
   * Price by the resource tiers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
   */
  @java.lang.Override
  public int getPriceTiersCount() {
    return priceTiers_.size();
  }
  /**
   *
   *
   * <pre>
   * Price by the resource tiers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PriceTier getPriceTiers(int index) {
    return priceTiers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Price by the resource tiers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PriceTierOrBuilder getPriceTiersOrBuilder(int index) {
    return priceTiers_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (periodType_ != com.google.cloud.channel.v1.PeriodType.PERIOD_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, periodType_);
    }
    if (firstPeriod_ != 0) {
      output.writeInt32(2, firstPeriod_);
    }
    if (lastPeriod_ != 0) {
      output.writeInt32(3, lastPeriod_);
    }
    if (price_ != null) {
      output.writeMessage(4, getPrice());
    }
    for (int i = 0; i < priceTiers_.size(); i++) {
      output.writeMessage(5, priceTiers_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (periodType_ != com.google.cloud.channel.v1.PeriodType.PERIOD_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, periodType_);
    }
    if (firstPeriod_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, firstPeriod_);
    }
    if (lastPeriod_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, lastPeriod_);
    }
    if (price_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPrice());
    }
    for (int i = 0; i < priceTiers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, priceTiers_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.PricePhase)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.PricePhase other = (com.google.cloud.channel.v1.PricePhase) obj;

    if (periodType_ != other.periodType_) return false;
    if (getFirstPeriod() != other.getFirstPeriod()) return false;
    if (getLastPeriod() != other.getLastPeriod()) return false;
    if (hasPrice() != other.hasPrice()) return false;
    if (hasPrice()) {
      if (!getPrice().equals(other.getPrice())) return false;
    }
    if (!getPriceTiersList().equals(other.getPriceTiersList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PERIOD_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + periodType_;
    hash = (37 * hash) + FIRST_PERIOD_FIELD_NUMBER;
    hash = (53 * hash) + getFirstPeriod();
    hash = (37 * hash) + LAST_PERIOD_FIELD_NUMBER;
    hash = (53 * hash) + getLastPeriod();
    if (hasPrice()) {
      hash = (37 * hash) + PRICE_FIELD_NUMBER;
      hash = (53 * hash) + getPrice().hashCode();
    }
    if (getPriceTiersCount() > 0) {
      hash = (37 * hash) + PRICE_TIERS_FIELD_NUMBER;
      hash = (53 * hash) + getPriceTiersList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.PricePhase parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.PricePhase parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.PricePhase parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.PricePhase parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.PricePhase parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.PricePhase parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.PricePhase parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.PricePhase parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.PricePhase parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.PricePhase parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.PricePhase parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.PricePhase parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.PricePhase prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies the price by the duration of months.
   * For example, a 20% discount for the first six months, then a 10% discount
   * starting on the seventh month.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.PricePhase}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.PricePhase)
      com.google.cloud.channel.v1.PricePhaseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_PricePhase_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_PricePhase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.PricePhase.class,
              com.google.cloud.channel.v1.PricePhase.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.PricePhase.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      periodType_ = 0;

      firstPeriod_ = 0;

      lastPeriod_ = 0;

      if (priceBuilder_ == null) {
        price_ = null;
      } else {
        price_ = null;
        priceBuilder_ = null;
      }
      if (priceTiersBuilder_ == null) {
        priceTiers_ = java.util.Collections.emptyList();
      } else {
        priceTiers_ = null;
        priceTiersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_PricePhase_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.PricePhase getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.PricePhase.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.PricePhase build() {
      com.google.cloud.channel.v1.PricePhase result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.PricePhase buildPartial() {
      com.google.cloud.channel.v1.PricePhase result =
          new com.google.cloud.channel.v1.PricePhase(this);
      int from_bitField0_ = bitField0_;
      result.periodType_ = periodType_;
      result.firstPeriod_ = firstPeriod_;
      result.lastPeriod_ = lastPeriod_;
      if (priceBuilder_ == null) {
        result.price_ = price_;
      } else {
        result.price_ = priceBuilder_.build();
      }
      if (priceTiersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          priceTiers_ = java.util.Collections.unmodifiableList(priceTiers_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.priceTiers_ = priceTiers_;
      } else {
        result.priceTiers_ = priceTiersBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.PricePhase) {
        return mergeFrom((com.google.cloud.channel.v1.PricePhase) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.PricePhase other) {
      if (other == com.google.cloud.channel.v1.PricePhase.getDefaultInstance()) return this;
      if (other.periodType_ != 0) {
        setPeriodTypeValue(other.getPeriodTypeValue());
      }
      if (other.getFirstPeriod() != 0) {
        setFirstPeriod(other.getFirstPeriod());
      }
      if (other.getLastPeriod() != 0) {
        setLastPeriod(other.getLastPeriod());
      }
      if (other.hasPrice()) {
        mergePrice(other.getPrice());
      }
      if (priceTiersBuilder_ == null) {
        if (!other.priceTiers_.isEmpty()) {
          if (priceTiers_.isEmpty()) {
            priceTiers_ = other.priceTiers_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePriceTiersIsMutable();
            priceTiers_.addAll(other.priceTiers_);
          }
          onChanged();
        }
      } else {
        if (!other.priceTiers_.isEmpty()) {
          if (priceTiersBuilder_.isEmpty()) {
            priceTiersBuilder_.dispose();
            priceTiersBuilder_ = null;
            priceTiers_ = other.priceTiers_;
            bitField0_ = (bitField0_ & ~0x00000001);
            priceTiersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPriceTiersFieldBuilder()
                    : null;
          } else {
            priceTiersBuilder_.addAllMessages(other.priceTiers_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                periodType_ = input.readEnum();

                break;
              } // case 8
            case 16:
              {
                firstPeriod_ = input.readInt32();

                break;
              } // case 16
            case 24:
              {
                lastPeriod_ = input.readInt32();

                break;
              } // case 24
            case 34:
              {
                input.readMessage(getPriceFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                com.google.cloud.channel.v1.PriceTier m =
                    input.readMessage(
                        com.google.cloud.channel.v1.PriceTier.parser(), extensionRegistry);
                if (priceTiersBuilder_ == null) {
                  ensurePriceTiersIsMutable();
                  priceTiers_.add(m);
                } else {
                  priceTiersBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int periodType_ = 0;
    /**
     *
     *
     * <pre>
     * Defines the phase period type.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PeriodType period_type = 1;</code>
     *
     * @return The enum numeric value on the wire for periodType.
     */
    @java.lang.Override
    public int getPeriodTypeValue() {
      return periodType_;
    }
    /**
     *
     *
     * <pre>
     * Defines the phase period type.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PeriodType period_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for periodType to set.
     * @return This builder for chaining.
     */
    public Builder setPeriodTypeValue(int value) {

      periodType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the phase period type.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PeriodType period_type = 1;</code>
     *
     * @return The periodType.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.PeriodType getPeriodType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.PeriodType result =
          com.google.cloud.channel.v1.PeriodType.valueOf(periodType_);
      return result == null ? com.google.cloud.channel.v1.PeriodType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Defines the phase period type.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PeriodType period_type = 1;</code>
     *
     * @param value The periodType to set.
     * @return This builder for chaining.
     */
    public Builder setPeriodType(com.google.cloud.channel.v1.PeriodType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      periodType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the phase period type.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PeriodType period_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeriodType() {

      periodType_ = 0;
      onChanged();
      return this;
    }

    private int firstPeriod_;
    /**
     *
     *
     * <pre>
     * Defines first period for the phase.
     * </pre>
     *
     * <code>int32 first_period = 2;</code>
     *
     * @return The firstPeriod.
     */
    @java.lang.Override
    public int getFirstPeriod() {
      return firstPeriod_;
    }
    /**
     *
     *
     * <pre>
     * Defines first period for the phase.
     * </pre>
     *
     * <code>int32 first_period = 2;</code>
     *
     * @param value The firstPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setFirstPeriod(int value) {

      firstPeriod_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines first period for the phase.
     * </pre>
     *
     * <code>int32 first_period = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFirstPeriod() {

      firstPeriod_ = 0;
      onChanged();
      return this;
    }

    private int lastPeriod_;
    /**
     *
     *
     * <pre>
     * Defines first period for the phase.
     * </pre>
     *
     * <code>int32 last_period = 3;</code>
     *
     * @return The lastPeriod.
     */
    @java.lang.Override
    public int getLastPeriod() {
      return lastPeriod_;
    }
    /**
     *
     *
     * <pre>
     * Defines first period for the phase.
     * </pre>
     *
     * <code>int32 last_period = 3;</code>
     *
     * @param value The lastPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setLastPeriod(int value) {

      lastPeriod_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines first period for the phase.
     * </pre>
     *
     * <code>int32 last_period = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastPeriod() {

      lastPeriod_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.channel.v1.Price price_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Price,
            com.google.cloud.channel.v1.Price.Builder,
            com.google.cloud.channel.v1.PriceOrBuilder>
        priceBuilder_;
    /**
     *
     *
     * <pre>
     * Price of the phase. Present if there are no price tiers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 4;</code>
     *
     * @return Whether the price field is set.
     */
    public boolean hasPrice() {
      return priceBuilder_ != null || price_ != null;
    }
    /**
     *
     *
     * <pre>
     * Price of the phase. Present if there are no price tiers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 4;</code>
     *
     * @return The price.
     */
    public com.google.cloud.channel.v1.Price getPrice() {
      if (priceBuilder_ == null) {
        return price_ == null ? com.google.cloud.channel.v1.Price.getDefaultInstance() : price_;
      } else {
        return priceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Price of the phase. Present if there are no price tiers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 4;</code>
     */
    public Builder setPrice(com.google.cloud.channel.v1.Price value) {
      if (priceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        price_ = value;
        onChanged();
      } else {
        priceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Price of the phase. Present if there are no price tiers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 4;</code>
     */
    public Builder setPrice(com.google.cloud.channel.v1.Price.Builder builderForValue) {
      if (priceBuilder_ == null) {
        price_ = builderForValue.build();
        onChanged();
      } else {
        priceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Price of the phase. Present if there are no price tiers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 4;</code>
     */
    public Builder mergePrice(com.google.cloud.channel.v1.Price value) {
      if (priceBuilder_ == null) {
        if (price_ != null) {
          price_ =
              com.google.cloud.channel.v1.Price.newBuilder(price_).mergeFrom(value).buildPartial();
        } else {
          price_ = value;
        }
        onChanged();
      } else {
        priceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Price of the phase. Present if there are no price tiers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 4;</code>
     */
    public Builder clearPrice() {
      if (priceBuilder_ == null) {
        price_ = null;
        onChanged();
      } else {
        price_ = null;
        priceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Price of the phase. Present if there are no price tiers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 4;</code>
     */
    public com.google.cloud.channel.v1.Price.Builder getPriceBuilder() {

      onChanged();
      return getPriceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Price of the phase. Present if there are no price tiers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 4;</code>
     */
    public com.google.cloud.channel.v1.PriceOrBuilder getPriceOrBuilder() {
      if (priceBuilder_ != null) {
        return priceBuilder_.getMessageOrBuilder();
      } else {
        return price_ == null ? com.google.cloud.channel.v1.Price.getDefaultInstance() : price_;
      }
    }
    /**
     *
     *
     * <pre>
     * Price of the phase. Present if there are no price tiers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Price,
            com.google.cloud.channel.v1.Price.Builder,
            com.google.cloud.channel.v1.PriceOrBuilder>
        getPriceFieldBuilder() {
      if (priceBuilder_ == null) {
        priceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.Price,
                com.google.cloud.channel.v1.Price.Builder,
                com.google.cloud.channel.v1.PriceOrBuilder>(
                getPrice(), getParentForChildren(), isClean());
        price_ = null;
      }
      return priceBuilder_;
    }

    private java.util.List<com.google.cloud.channel.v1.PriceTier> priceTiers_ =
        java.util.Collections.emptyList();

    private void ensurePriceTiersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        priceTiers_ = new java.util.ArrayList<com.google.cloud.channel.v1.PriceTier>(priceTiers_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.PriceTier,
            com.google.cloud.channel.v1.PriceTier.Builder,
            com.google.cloud.channel.v1.PriceTierOrBuilder>
        priceTiersBuilder_;

    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.PriceTier> getPriceTiersList() {
      if (priceTiersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(priceTiers_);
      } else {
        return priceTiersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public int getPriceTiersCount() {
      if (priceTiersBuilder_ == null) {
        return priceTiers_.size();
      } else {
        return priceTiersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public com.google.cloud.channel.v1.PriceTier getPriceTiers(int index) {
      if (priceTiersBuilder_ == null) {
        return priceTiers_.get(index);
      } else {
        return priceTiersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public Builder setPriceTiers(int index, com.google.cloud.channel.v1.PriceTier value) {
      if (priceTiersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePriceTiersIsMutable();
        priceTiers_.set(index, value);
        onChanged();
      } else {
        priceTiersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public Builder setPriceTiers(
        int index, com.google.cloud.channel.v1.PriceTier.Builder builderForValue) {
      if (priceTiersBuilder_ == null) {
        ensurePriceTiersIsMutable();
        priceTiers_.set(index, builderForValue.build());
        onChanged();
      } else {
        priceTiersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public Builder addPriceTiers(com.google.cloud.channel.v1.PriceTier value) {
      if (priceTiersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePriceTiersIsMutable();
        priceTiers_.add(value);
        onChanged();
      } else {
        priceTiersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public Builder addPriceTiers(int index, com.google.cloud.channel.v1.PriceTier value) {
      if (priceTiersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePriceTiersIsMutable();
        priceTiers_.add(index, value);
        onChanged();
      } else {
        priceTiersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public Builder addPriceTiers(com.google.cloud.channel.v1.PriceTier.Builder builderForValue) {
      if (priceTiersBuilder_ == null) {
        ensurePriceTiersIsMutable();
        priceTiers_.add(builderForValue.build());
        onChanged();
      } else {
        priceTiersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public Builder addPriceTiers(
        int index, com.google.cloud.channel.v1.PriceTier.Builder builderForValue) {
      if (priceTiersBuilder_ == null) {
        ensurePriceTiersIsMutable();
        priceTiers_.add(index, builderForValue.build());
        onChanged();
      } else {
        priceTiersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public Builder addAllPriceTiers(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.PriceTier> values) {
      if (priceTiersBuilder_ == null) {
        ensurePriceTiersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, priceTiers_);
        onChanged();
      } else {
        priceTiersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public Builder clearPriceTiers() {
      if (priceTiersBuilder_ == null) {
        priceTiers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        priceTiersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public Builder removePriceTiers(int index) {
      if (priceTiersBuilder_ == null) {
        ensurePriceTiersIsMutable();
        priceTiers_.remove(index);
        onChanged();
      } else {
        priceTiersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public com.google.cloud.channel.v1.PriceTier.Builder getPriceTiersBuilder(int index) {
      return getPriceTiersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public com.google.cloud.channel.v1.PriceTierOrBuilder getPriceTiersOrBuilder(int index) {
      if (priceTiersBuilder_ == null) {
        return priceTiers_.get(index);
      } else {
        return priceTiersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.channel.v1.PriceTierOrBuilder>
        getPriceTiersOrBuilderList() {
      if (priceTiersBuilder_ != null) {
        return priceTiersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(priceTiers_);
      }
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public com.google.cloud.channel.v1.PriceTier.Builder addPriceTiersBuilder() {
      return getPriceTiersFieldBuilder()
          .addBuilder(com.google.cloud.channel.v1.PriceTier.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public com.google.cloud.channel.v1.PriceTier.Builder addPriceTiersBuilder(int index) {
      return getPriceTiersFieldBuilder()
          .addBuilder(index, com.google.cloud.channel.v1.PriceTier.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Price by the resource tiers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceTier price_tiers = 5;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.PriceTier.Builder>
        getPriceTiersBuilderList() {
      return getPriceTiersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.PriceTier,
            com.google.cloud.channel.v1.PriceTier.Builder,
            com.google.cloud.channel.v1.PriceTierOrBuilder>
        getPriceTiersFieldBuilder() {
      if (priceTiersBuilder_ == null) {
        priceTiersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.channel.v1.PriceTier,
                com.google.cloud.channel.v1.PriceTier.Builder,
                com.google.cloud.channel.v1.PriceTierOrBuilder>(
                priceTiers_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        priceTiers_ = null;
      }
      return priceTiersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.PricePhase)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.PricePhase)
  private static final com.google.cloud.channel.v1.PricePhase DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.PricePhase();
  }

  public static com.google.cloud.channel.v1.PricePhase getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PricePhase> PARSER =
      new com.google.protobuf.AbstractParser<PricePhase>() {
        @java.lang.Override
        public PricePhase parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PricePhase> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PricePhase> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.PricePhase getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
