/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/offers.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Represents price by resource type.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.PriceByResource}
 */
public final class PriceByResource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.PriceByResource)
    PriceByResourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PriceByResource.newBuilder() to construct.
  private PriceByResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PriceByResource() {
    resourceType_ = 0;
    pricePhases_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PriceByResource();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_PriceByResource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_PriceByResource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.PriceByResource.class,
            com.google.cloud.channel.v1.PriceByResource.Builder.class);
  }

  public static final int RESOURCE_TYPE_FIELD_NUMBER = 1;
  private int resourceType_;
  /**
   *
   *
   * <pre>
   * Resource Type. Example: SEAT
   * </pre>
   *
   * <code>.google.cloud.channel.v1.ResourceType resource_type = 1;</code>
   *
   * @return The enum numeric value on the wire for resourceType.
   */
  @java.lang.Override
  public int getResourceTypeValue() {
    return resourceType_;
  }
  /**
   *
   *
   * <pre>
   * Resource Type. Example: SEAT
   * </pre>
   *
   * <code>.google.cloud.channel.v1.ResourceType resource_type = 1;</code>
   *
   * @return The resourceType.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ResourceType getResourceType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.channel.v1.ResourceType result =
        com.google.cloud.channel.v1.ResourceType.valueOf(resourceType_);
    return result == null ? com.google.cloud.channel.v1.ResourceType.UNRECOGNIZED : result;
  }

  public static final int PRICE_FIELD_NUMBER = 2;
  private com.google.cloud.channel.v1.Price price_;
  /**
   *
   *
   * <pre>
   * Price of the Offer. Present if there are no price phases.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Price price = 2;</code>
   *
   * @return Whether the price field is set.
   */
  @java.lang.Override
  public boolean hasPrice() {
    return price_ != null;
  }
  /**
   *
   *
   * <pre>
   * Price of the Offer. Present if there are no price phases.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Price price = 2;</code>
   *
   * @return The price.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Price getPrice() {
    return price_ == null ? com.google.cloud.channel.v1.Price.getDefaultInstance() : price_;
  }
  /**
   *
   *
   * <pre>
   * Price of the Offer. Present if there are no price phases.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Price price = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PriceOrBuilder getPriceOrBuilder() {
    return getPrice();
  }

  public static final int PRICE_PHASES_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.channel.v1.PricePhase> pricePhases_;
  /**
   *
   *
   * <pre>
   * Specifies the price by time range.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.PricePhase> getPricePhasesList() {
    return pricePhases_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the price by time range.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.channel.v1.PricePhaseOrBuilder>
      getPricePhasesOrBuilderList() {
    return pricePhases_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the price by time range.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
   */
  @java.lang.Override
  public int getPricePhasesCount() {
    return pricePhases_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies the price by time range.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PricePhase getPricePhases(int index) {
    return pricePhases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies the price by time range.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PricePhaseOrBuilder getPricePhasesOrBuilder(int index) {
    return pricePhases_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (resourceType_
        != com.google.cloud.channel.v1.ResourceType.RESOURCE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, resourceType_);
    }
    if (price_ != null) {
      output.writeMessage(2, getPrice());
    }
    for (int i = 0; i < pricePhases_.size(); i++) {
      output.writeMessage(3, pricePhases_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (resourceType_
        != com.google.cloud.channel.v1.ResourceType.RESOURCE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, resourceType_);
    }
    if (price_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPrice());
    }
    for (int i = 0; i < pricePhases_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, pricePhases_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.PriceByResource)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.PriceByResource other =
        (com.google.cloud.channel.v1.PriceByResource) obj;

    if (resourceType_ != other.resourceType_) return false;
    if (hasPrice() != other.hasPrice()) return false;
    if (hasPrice()) {
      if (!getPrice().equals(other.getPrice())) return false;
    }
    if (!getPricePhasesList().equals(other.getPricePhasesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + resourceType_;
    if (hasPrice()) {
      hash = (37 * hash) + PRICE_FIELD_NUMBER;
      hash = (53 * hash) + getPrice().hashCode();
    }
    if (getPricePhasesCount() > 0) {
      hash = (37 * hash) + PRICE_PHASES_FIELD_NUMBER;
      hash = (53 * hash) + getPricePhasesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.PriceByResource parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.PriceByResource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.PriceByResource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.PriceByResource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.PriceByResource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.PriceByResource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.PriceByResource parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.PriceByResource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.PriceByResource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.PriceByResource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.PriceByResource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.PriceByResource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.PriceByResource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents price by resource type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.PriceByResource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.PriceByResource)
      com.google.cloud.channel.v1.PriceByResourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_PriceByResource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_PriceByResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.PriceByResource.class,
              com.google.cloud.channel.v1.PriceByResource.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.PriceByResource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      resourceType_ = 0;

      if (priceBuilder_ == null) {
        price_ = null;
      } else {
        price_ = null;
        priceBuilder_ = null;
      }
      if (pricePhasesBuilder_ == null) {
        pricePhases_ = java.util.Collections.emptyList();
      } else {
        pricePhases_ = null;
        pricePhasesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_PriceByResource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.PriceByResource getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.PriceByResource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.PriceByResource build() {
      com.google.cloud.channel.v1.PriceByResource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.PriceByResource buildPartial() {
      com.google.cloud.channel.v1.PriceByResource result =
          new com.google.cloud.channel.v1.PriceByResource(this);
      int from_bitField0_ = bitField0_;
      result.resourceType_ = resourceType_;
      if (priceBuilder_ == null) {
        result.price_ = price_;
      } else {
        result.price_ = priceBuilder_.build();
      }
      if (pricePhasesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          pricePhases_ = java.util.Collections.unmodifiableList(pricePhases_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.pricePhases_ = pricePhases_;
      } else {
        result.pricePhases_ = pricePhasesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.PriceByResource) {
        return mergeFrom((com.google.cloud.channel.v1.PriceByResource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.PriceByResource other) {
      if (other == com.google.cloud.channel.v1.PriceByResource.getDefaultInstance()) return this;
      if (other.resourceType_ != 0) {
        setResourceTypeValue(other.getResourceTypeValue());
      }
      if (other.hasPrice()) {
        mergePrice(other.getPrice());
      }
      if (pricePhasesBuilder_ == null) {
        if (!other.pricePhases_.isEmpty()) {
          if (pricePhases_.isEmpty()) {
            pricePhases_ = other.pricePhases_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePricePhasesIsMutable();
            pricePhases_.addAll(other.pricePhases_);
          }
          onChanged();
        }
      } else {
        if (!other.pricePhases_.isEmpty()) {
          if (pricePhasesBuilder_.isEmpty()) {
            pricePhasesBuilder_.dispose();
            pricePhasesBuilder_ = null;
            pricePhases_ = other.pricePhases_;
            bitField0_ = (bitField0_ & ~0x00000001);
            pricePhasesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPricePhasesFieldBuilder()
                    : null;
          } else {
            pricePhasesBuilder_.addAllMessages(other.pricePhases_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                resourceType_ = input.readEnum();

                break;
              } // case 8
            case 18:
              {
                input.readMessage(getPriceFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                com.google.cloud.channel.v1.PricePhase m =
                    input.readMessage(
                        com.google.cloud.channel.v1.PricePhase.parser(), extensionRegistry);
                if (pricePhasesBuilder_ == null) {
                  ensurePricePhasesIsMutable();
                  pricePhases_.add(m);
                } else {
                  pricePhasesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int resourceType_ = 0;
    /**
     *
     *
     * <pre>
     * Resource Type. Example: SEAT
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ResourceType resource_type = 1;</code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    @java.lang.Override
    public int getResourceTypeValue() {
      return resourceType_;
    }
    /**
     *
     *
     * <pre>
     * Resource Type. Example: SEAT
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ResourceType resource_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeValue(int value) {

      resourceType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource Type. Example: SEAT
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ResourceType resource_type = 1;</code>
     *
     * @return The resourceType.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.ResourceType getResourceType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.ResourceType result =
          com.google.cloud.channel.v1.ResourceType.valueOf(resourceType_);
      return result == null ? com.google.cloud.channel.v1.ResourceType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Resource Type. Example: SEAT
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ResourceType resource_type = 1;</code>
     *
     * @param value The resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceType(com.google.cloud.channel.v1.ResourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      resourceType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource Type. Example: SEAT
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ResourceType resource_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceType() {

      resourceType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.channel.v1.Price price_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Price,
            com.google.cloud.channel.v1.Price.Builder,
            com.google.cloud.channel.v1.PriceOrBuilder>
        priceBuilder_;
    /**
     *
     *
     * <pre>
     * Price of the Offer. Present if there are no price phases.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 2;</code>
     *
     * @return Whether the price field is set.
     */
    public boolean hasPrice() {
      return priceBuilder_ != null || price_ != null;
    }
    /**
     *
     *
     * <pre>
     * Price of the Offer. Present if there are no price phases.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 2;</code>
     *
     * @return The price.
     */
    public com.google.cloud.channel.v1.Price getPrice() {
      if (priceBuilder_ == null) {
        return price_ == null ? com.google.cloud.channel.v1.Price.getDefaultInstance() : price_;
      } else {
        return priceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Price of the Offer. Present if there are no price phases.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 2;</code>
     */
    public Builder setPrice(com.google.cloud.channel.v1.Price value) {
      if (priceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        price_ = value;
        onChanged();
      } else {
        priceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Price of the Offer. Present if there are no price phases.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 2;</code>
     */
    public Builder setPrice(com.google.cloud.channel.v1.Price.Builder builderForValue) {
      if (priceBuilder_ == null) {
        price_ = builderForValue.build();
        onChanged();
      } else {
        priceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Price of the Offer. Present if there are no price phases.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 2;</code>
     */
    public Builder mergePrice(com.google.cloud.channel.v1.Price value) {
      if (priceBuilder_ == null) {
        if (price_ != null) {
          price_ =
              com.google.cloud.channel.v1.Price.newBuilder(price_).mergeFrom(value).buildPartial();
        } else {
          price_ = value;
        }
        onChanged();
      } else {
        priceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Price of the Offer. Present if there are no price phases.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 2;</code>
     */
    public Builder clearPrice() {
      if (priceBuilder_ == null) {
        price_ = null;
        onChanged();
      } else {
        price_ = null;
        priceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Price of the Offer. Present if there are no price phases.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 2;</code>
     */
    public com.google.cloud.channel.v1.Price.Builder getPriceBuilder() {

      onChanged();
      return getPriceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Price of the Offer. Present if there are no price phases.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 2;</code>
     */
    public com.google.cloud.channel.v1.PriceOrBuilder getPriceOrBuilder() {
      if (priceBuilder_ != null) {
        return priceBuilder_.getMessageOrBuilder();
      } else {
        return price_ == null ? com.google.cloud.channel.v1.Price.getDefaultInstance() : price_;
      }
    }
    /**
     *
     *
     * <pre>
     * Price of the Offer. Present if there are no price phases.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Price price = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Price,
            com.google.cloud.channel.v1.Price.Builder,
            com.google.cloud.channel.v1.PriceOrBuilder>
        getPriceFieldBuilder() {
      if (priceBuilder_ == null) {
        priceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.Price,
                com.google.cloud.channel.v1.Price.Builder,
                com.google.cloud.channel.v1.PriceOrBuilder>(
                getPrice(), getParentForChildren(), isClean());
        price_ = null;
      }
      return priceBuilder_;
    }

    private java.util.List<com.google.cloud.channel.v1.PricePhase> pricePhases_ =
        java.util.Collections.emptyList();

    private void ensurePricePhasesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        pricePhases_ =
            new java.util.ArrayList<com.google.cloud.channel.v1.PricePhase>(pricePhases_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.PricePhase,
            com.google.cloud.channel.v1.PricePhase.Builder,
            com.google.cloud.channel.v1.PricePhaseOrBuilder>
        pricePhasesBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.PricePhase> getPricePhasesList() {
      if (pricePhasesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pricePhases_);
      } else {
        return pricePhasesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public int getPricePhasesCount() {
      if (pricePhasesBuilder_ == null) {
        return pricePhases_.size();
      } else {
        return pricePhasesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public com.google.cloud.channel.v1.PricePhase getPricePhases(int index) {
      if (pricePhasesBuilder_ == null) {
        return pricePhases_.get(index);
      } else {
        return pricePhasesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public Builder setPricePhases(int index, com.google.cloud.channel.v1.PricePhase value) {
      if (pricePhasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePricePhasesIsMutable();
        pricePhases_.set(index, value);
        onChanged();
      } else {
        pricePhasesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public Builder setPricePhases(
        int index, com.google.cloud.channel.v1.PricePhase.Builder builderForValue) {
      if (pricePhasesBuilder_ == null) {
        ensurePricePhasesIsMutable();
        pricePhases_.set(index, builderForValue.build());
        onChanged();
      } else {
        pricePhasesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public Builder addPricePhases(com.google.cloud.channel.v1.PricePhase value) {
      if (pricePhasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePricePhasesIsMutable();
        pricePhases_.add(value);
        onChanged();
      } else {
        pricePhasesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public Builder addPricePhases(int index, com.google.cloud.channel.v1.PricePhase value) {
      if (pricePhasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePricePhasesIsMutable();
        pricePhases_.add(index, value);
        onChanged();
      } else {
        pricePhasesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public Builder addPricePhases(com.google.cloud.channel.v1.PricePhase.Builder builderForValue) {
      if (pricePhasesBuilder_ == null) {
        ensurePricePhasesIsMutable();
        pricePhases_.add(builderForValue.build());
        onChanged();
      } else {
        pricePhasesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public Builder addPricePhases(
        int index, com.google.cloud.channel.v1.PricePhase.Builder builderForValue) {
      if (pricePhasesBuilder_ == null) {
        ensurePricePhasesIsMutable();
        pricePhases_.add(index, builderForValue.build());
        onChanged();
      } else {
        pricePhasesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public Builder addAllPricePhases(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.PricePhase> values) {
      if (pricePhasesBuilder_ == null) {
        ensurePricePhasesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pricePhases_);
        onChanged();
      } else {
        pricePhasesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public Builder clearPricePhases() {
      if (pricePhasesBuilder_ == null) {
        pricePhases_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        pricePhasesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public Builder removePricePhases(int index) {
      if (pricePhasesBuilder_ == null) {
        ensurePricePhasesIsMutable();
        pricePhases_.remove(index);
        onChanged();
      } else {
        pricePhasesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public com.google.cloud.channel.v1.PricePhase.Builder getPricePhasesBuilder(int index) {
      return getPricePhasesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public com.google.cloud.channel.v1.PricePhaseOrBuilder getPricePhasesOrBuilder(int index) {
      if (pricePhasesBuilder_ == null) {
        return pricePhases_.get(index);
      } else {
        return pricePhasesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.channel.v1.PricePhaseOrBuilder>
        getPricePhasesOrBuilderList() {
      if (pricePhasesBuilder_ != null) {
        return pricePhasesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pricePhases_);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public com.google.cloud.channel.v1.PricePhase.Builder addPricePhasesBuilder() {
      return getPricePhasesFieldBuilder()
          .addBuilder(com.google.cloud.channel.v1.PricePhase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public com.google.cloud.channel.v1.PricePhase.Builder addPricePhasesBuilder(int index) {
      return getPricePhasesFieldBuilder()
          .addBuilder(index, com.google.cloud.channel.v1.PricePhase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies the price by time range.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PricePhase price_phases = 3;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.PricePhase.Builder>
        getPricePhasesBuilderList() {
      return getPricePhasesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.PricePhase,
            com.google.cloud.channel.v1.PricePhase.Builder,
            com.google.cloud.channel.v1.PricePhaseOrBuilder>
        getPricePhasesFieldBuilder() {
      if (pricePhasesBuilder_ == null) {
        pricePhasesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.channel.v1.PricePhase,
                com.google.cloud.channel.v1.PricePhase.Builder,
                com.google.cloud.channel.v1.PricePhaseOrBuilder>(
                pricePhases_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        pricePhases_ = null;
      }
      return pricePhasesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.PriceByResource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.PriceByResource)
  private static final com.google.cloud.channel.v1.PriceByResource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.PriceByResource();
  }

  public static com.google.cloud.channel.v1.PriceByResource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PriceByResource> PARSER =
      new com.google.protobuf.AbstractParser<PriceByResource>() {
        @java.lang.Override
        public PriceByResource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PriceByResource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PriceByResource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.PriceByResource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
