/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/offers.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * The payment plan for the Offer. Describes how to make a payment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.Plan}
 */
public final class Plan extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.Plan)
    PlanOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Plan.newBuilder() to construct.
  private Plan(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Plan() {
    paymentPlan_ = 0;
    paymentType_ = 0;
    billingAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Plan();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_Plan_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_Plan_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.Plan.class, com.google.cloud.channel.v1.Plan.Builder.class);
  }

  public static final int PAYMENT_PLAN_FIELD_NUMBER = 1;
  private int paymentPlan_;
  /**
   *
   *
   * <pre>
   * Describes how a reseller will be billed.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.PaymentPlan payment_plan = 1;</code>
   *
   * @return The enum numeric value on the wire for paymentPlan.
   */
  @java.lang.Override
  public int getPaymentPlanValue() {
    return paymentPlan_;
  }
  /**
   *
   *
   * <pre>
   * Describes how a reseller will be billed.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.PaymentPlan payment_plan = 1;</code>
   *
   * @return The paymentPlan.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PaymentPlan getPaymentPlan() {
    @SuppressWarnings("deprecation")
    com.google.cloud.channel.v1.PaymentPlan result =
        com.google.cloud.channel.v1.PaymentPlan.valueOf(paymentPlan_);
    return result == null ? com.google.cloud.channel.v1.PaymentPlan.UNRECOGNIZED : result;
  }

  public static final int PAYMENT_TYPE_FIELD_NUMBER = 2;
  private int paymentType_;
  /**
   *
   *
   * <pre>
   * Specifies when the payment needs to happen.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.PaymentType payment_type = 2;</code>
   *
   * @return The enum numeric value on the wire for paymentType.
   */
  @java.lang.Override
  public int getPaymentTypeValue() {
    return paymentType_;
  }
  /**
   *
   *
   * <pre>
   * Specifies when the payment needs to happen.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.PaymentType payment_type = 2;</code>
   *
   * @return The paymentType.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PaymentType getPaymentType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.channel.v1.PaymentType result =
        com.google.cloud.channel.v1.PaymentType.valueOf(paymentType_);
    return result == null ? com.google.cloud.channel.v1.PaymentType.UNRECOGNIZED : result;
  }

  public static final int PAYMENT_CYCLE_FIELD_NUMBER = 3;
  private com.google.cloud.channel.v1.Period paymentCycle_;
  /**
   *
   *
   * <pre>
   * Describes how frequently the reseller will be billed, such as
   * once per month.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
   *
   * @return Whether the paymentCycle field is set.
   */
  @java.lang.Override
  public boolean hasPaymentCycle() {
    return paymentCycle_ != null;
  }
  /**
   *
   *
   * <pre>
   * Describes how frequently the reseller will be billed, such as
   * once per month.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
   *
   * @return The paymentCycle.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Period getPaymentCycle() {
    return paymentCycle_ == null
        ? com.google.cloud.channel.v1.Period.getDefaultInstance()
        : paymentCycle_;
  }
  /**
   *
   *
   * <pre>
   * Describes how frequently the reseller will be billed, such as
   * once per month.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PeriodOrBuilder getPaymentCycleOrBuilder() {
    return getPaymentCycle();
  }

  public static final int TRIAL_PERIOD_FIELD_NUMBER = 4;
  private com.google.cloud.channel.v1.Period trialPeriod_;
  /**
   *
   *
   * <pre>
   * Present for Offers with a trial period.
   * For trial-only Offers, a paid service needs to start before the trial
   * period ends for continued service.
   * For Regular Offers with a trial period, the regular pricing goes into
   * effect when trial period ends, or if paid service is started before the end
   * of the trial period.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
   *
   * @return Whether the trialPeriod field is set.
   */
  @java.lang.Override
  public boolean hasTrialPeriod() {
    return trialPeriod_ != null;
  }
  /**
   *
   *
   * <pre>
   * Present for Offers with a trial period.
   * For trial-only Offers, a paid service needs to start before the trial
   * period ends for continued service.
   * For Regular Offers with a trial period, the regular pricing goes into
   * effect when trial period ends, or if paid service is started before the end
   * of the trial period.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
   *
   * @return The trialPeriod.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Period getTrialPeriod() {
    return trialPeriod_ == null
        ? com.google.cloud.channel.v1.Period.getDefaultInstance()
        : trialPeriod_;
  }
  /**
   *
   *
   * <pre>
   * Present for Offers with a trial period.
   * For trial-only Offers, a paid service needs to start before the trial
   * period ends for continued service.
   * For Regular Offers with a trial period, the regular pricing goes into
   * effect when trial period ends, or if paid service is started before the end
   * of the trial period.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PeriodOrBuilder getTrialPeriodOrBuilder() {
    return getTrialPeriod();
  }

  public static final int BILLING_ACCOUNT_FIELD_NUMBER = 5;
  private volatile java.lang.Object billingAccount_;
  /**
   *
   *
   * <pre>
   * Reseller Billing account to charge after an offer transaction.
   * Only present for Google Cloud Platform offers.
   * </pre>
   *
   * <code>string billing_account = 5;</code>
   *
   * @return The billingAccount.
   */
  @java.lang.Override
  public java.lang.String getBillingAccount() {
    java.lang.Object ref = billingAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      billingAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Reseller Billing account to charge after an offer transaction.
   * Only present for Google Cloud Platform offers.
   * </pre>
   *
   * <code>string billing_account = 5;</code>
   *
   * @return The bytes for billingAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBillingAccountBytes() {
    java.lang.Object ref = billingAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      billingAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (paymentPlan_
        != com.google.cloud.channel.v1.PaymentPlan.PAYMENT_PLAN_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, paymentPlan_);
    }
    if (paymentType_
        != com.google.cloud.channel.v1.PaymentType.PAYMENT_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, paymentType_);
    }
    if (paymentCycle_ != null) {
      output.writeMessage(3, getPaymentCycle());
    }
    if (trialPeriod_ != null) {
      output.writeMessage(4, getTrialPeriod());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(billingAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, billingAccount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (paymentPlan_
        != com.google.cloud.channel.v1.PaymentPlan.PAYMENT_PLAN_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, paymentPlan_);
    }
    if (paymentType_
        != com.google.cloud.channel.v1.PaymentType.PAYMENT_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, paymentType_);
    }
    if (paymentCycle_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPaymentCycle());
    }
    if (trialPeriod_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTrialPeriod());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(billingAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, billingAccount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.Plan)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.Plan other = (com.google.cloud.channel.v1.Plan) obj;

    if (paymentPlan_ != other.paymentPlan_) return false;
    if (paymentType_ != other.paymentType_) return false;
    if (hasPaymentCycle() != other.hasPaymentCycle()) return false;
    if (hasPaymentCycle()) {
      if (!getPaymentCycle().equals(other.getPaymentCycle())) return false;
    }
    if (hasTrialPeriod() != other.hasTrialPeriod()) return false;
    if (hasTrialPeriod()) {
      if (!getTrialPeriod().equals(other.getTrialPeriod())) return false;
    }
    if (!getBillingAccount().equals(other.getBillingAccount())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PAYMENT_PLAN_FIELD_NUMBER;
    hash = (53 * hash) + paymentPlan_;
    hash = (37 * hash) + PAYMENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + paymentType_;
    if (hasPaymentCycle()) {
      hash = (37 * hash) + PAYMENT_CYCLE_FIELD_NUMBER;
      hash = (53 * hash) + getPaymentCycle().hashCode();
    }
    if (hasTrialPeriod()) {
      hash = (37 * hash) + TRIAL_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getTrialPeriod().hashCode();
    }
    hash = (37 * hash) + BILLING_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getBillingAccount().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.Plan parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Plan parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Plan parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Plan parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Plan parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Plan parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Plan parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Plan parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Plan parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Plan parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Plan parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Plan parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.Plan prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The payment plan for the Offer. Describes how to make a payment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.Plan}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.Plan)
      com.google.cloud.channel.v1.PlanOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_Plan_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_Plan_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.Plan.class,
              com.google.cloud.channel.v1.Plan.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.Plan.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      paymentPlan_ = 0;

      paymentType_ = 0;

      if (paymentCycleBuilder_ == null) {
        paymentCycle_ = null;
      } else {
        paymentCycle_ = null;
        paymentCycleBuilder_ = null;
      }
      if (trialPeriodBuilder_ == null) {
        trialPeriod_ = null;
      } else {
        trialPeriod_ = null;
        trialPeriodBuilder_ = null;
      }
      billingAccount_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_Plan_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Plan getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.Plan.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Plan build() {
      com.google.cloud.channel.v1.Plan result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Plan buildPartial() {
      com.google.cloud.channel.v1.Plan result = new com.google.cloud.channel.v1.Plan(this);
      result.paymentPlan_ = paymentPlan_;
      result.paymentType_ = paymentType_;
      if (paymentCycleBuilder_ == null) {
        result.paymentCycle_ = paymentCycle_;
      } else {
        result.paymentCycle_ = paymentCycleBuilder_.build();
      }
      if (trialPeriodBuilder_ == null) {
        result.trialPeriod_ = trialPeriod_;
      } else {
        result.trialPeriod_ = trialPeriodBuilder_.build();
      }
      result.billingAccount_ = billingAccount_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.Plan) {
        return mergeFrom((com.google.cloud.channel.v1.Plan) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.Plan other) {
      if (other == com.google.cloud.channel.v1.Plan.getDefaultInstance()) return this;
      if (other.paymentPlan_ != 0) {
        setPaymentPlanValue(other.getPaymentPlanValue());
      }
      if (other.paymentType_ != 0) {
        setPaymentTypeValue(other.getPaymentTypeValue());
      }
      if (other.hasPaymentCycle()) {
        mergePaymentCycle(other.getPaymentCycle());
      }
      if (other.hasTrialPeriod()) {
        mergeTrialPeriod(other.getTrialPeriod());
      }
      if (!other.getBillingAccount().isEmpty()) {
        billingAccount_ = other.billingAccount_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                paymentPlan_ = input.readEnum();

                break;
              } // case 8
            case 16:
              {
                paymentType_ = input.readEnum();

                break;
              } // case 16
            case 26:
              {
                input.readMessage(getPaymentCycleFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTrialPeriodFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                billingAccount_ = input.readStringRequireUtf8();

                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int paymentPlan_ = 0;
    /**
     *
     *
     * <pre>
     * Describes how a reseller will be billed.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PaymentPlan payment_plan = 1;</code>
     *
     * @return The enum numeric value on the wire for paymentPlan.
     */
    @java.lang.Override
    public int getPaymentPlanValue() {
      return paymentPlan_;
    }
    /**
     *
     *
     * <pre>
     * Describes how a reseller will be billed.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PaymentPlan payment_plan = 1;</code>
     *
     * @param value The enum numeric value on the wire for paymentPlan to set.
     * @return This builder for chaining.
     */
    public Builder setPaymentPlanValue(int value) {

      paymentPlan_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes how a reseller will be billed.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PaymentPlan payment_plan = 1;</code>
     *
     * @return The paymentPlan.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.PaymentPlan getPaymentPlan() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.PaymentPlan result =
          com.google.cloud.channel.v1.PaymentPlan.valueOf(paymentPlan_);
      return result == null ? com.google.cloud.channel.v1.PaymentPlan.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Describes how a reseller will be billed.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PaymentPlan payment_plan = 1;</code>
     *
     * @param value The paymentPlan to set.
     * @return This builder for chaining.
     */
    public Builder setPaymentPlan(com.google.cloud.channel.v1.PaymentPlan value) {
      if (value == null) {
        throw new NullPointerException();
      }

      paymentPlan_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes how a reseller will be billed.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PaymentPlan payment_plan = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPaymentPlan() {

      paymentPlan_ = 0;
      onChanged();
      return this;
    }

    private int paymentType_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies when the payment needs to happen.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PaymentType payment_type = 2;</code>
     *
     * @return The enum numeric value on the wire for paymentType.
     */
    @java.lang.Override
    public int getPaymentTypeValue() {
      return paymentType_;
    }
    /**
     *
     *
     * <pre>
     * Specifies when the payment needs to happen.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PaymentType payment_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for paymentType to set.
     * @return This builder for chaining.
     */
    public Builder setPaymentTypeValue(int value) {

      paymentType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies when the payment needs to happen.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PaymentType payment_type = 2;</code>
     *
     * @return The paymentType.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.PaymentType getPaymentType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.PaymentType result =
          com.google.cloud.channel.v1.PaymentType.valueOf(paymentType_);
      return result == null ? com.google.cloud.channel.v1.PaymentType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Specifies when the payment needs to happen.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PaymentType payment_type = 2;</code>
     *
     * @param value The paymentType to set.
     * @return This builder for chaining.
     */
    public Builder setPaymentType(com.google.cloud.channel.v1.PaymentType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      paymentType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies when the payment needs to happen.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.PaymentType payment_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPaymentType() {

      paymentType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.channel.v1.Period paymentCycle_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Period,
            com.google.cloud.channel.v1.Period.Builder,
            com.google.cloud.channel.v1.PeriodOrBuilder>
        paymentCycleBuilder_;
    /**
     *
     *
     * <pre>
     * Describes how frequently the reseller will be billed, such as
     * once per month.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
     *
     * @return Whether the paymentCycle field is set.
     */
    public boolean hasPaymentCycle() {
      return paymentCycleBuilder_ != null || paymentCycle_ != null;
    }
    /**
     *
     *
     * <pre>
     * Describes how frequently the reseller will be billed, such as
     * once per month.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
     *
     * @return The paymentCycle.
     */
    public com.google.cloud.channel.v1.Period getPaymentCycle() {
      if (paymentCycleBuilder_ == null) {
        return paymentCycle_ == null
            ? com.google.cloud.channel.v1.Period.getDefaultInstance()
            : paymentCycle_;
      } else {
        return paymentCycleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes how frequently the reseller will be billed, such as
     * once per month.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
     */
    public Builder setPaymentCycle(com.google.cloud.channel.v1.Period value) {
      if (paymentCycleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        paymentCycle_ = value;
        onChanged();
      } else {
        paymentCycleBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes how frequently the reseller will be billed, such as
     * once per month.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
     */
    public Builder setPaymentCycle(com.google.cloud.channel.v1.Period.Builder builderForValue) {
      if (paymentCycleBuilder_ == null) {
        paymentCycle_ = builderForValue.build();
        onChanged();
      } else {
        paymentCycleBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes how frequently the reseller will be billed, such as
     * once per month.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
     */
    public Builder mergePaymentCycle(com.google.cloud.channel.v1.Period value) {
      if (paymentCycleBuilder_ == null) {
        if (paymentCycle_ != null) {
          paymentCycle_ =
              com.google.cloud.channel.v1.Period.newBuilder(paymentCycle_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          paymentCycle_ = value;
        }
        onChanged();
      } else {
        paymentCycleBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes how frequently the reseller will be billed, such as
     * once per month.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
     */
    public Builder clearPaymentCycle() {
      if (paymentCycleBuilder_ == null) {
        paymentCycle_ = null;
        onChanged();
      } else {
        paymentCycle_ = null;
        paymentCycleBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes how frequently the reseller will be billed, such as
     * once per month.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
     */
    public com.google.cloud.channel.v1.Period.Builder getPaymentCycleBuilder() {

      onChanged();
      return getPaymentCycleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describes how frequently the reseller will be billed, such as
     * once per month.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
     */
    public com.google.cloud.channel.v1.PeriodOrBuilder getPaymentCycleOrBuilder() {
      if (paymentCycleBuilder_ != null) {
        return paymentCycleBuilder_.getMessageOrBuilder();
      } else {
        return paymentCycle_ == null
            ? com.google.cloud.channel.v1.Period.getDefaultInstance()
            : paymentCycle_;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes how frequently the reseller will be billed, such as
     * once per month.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period payment_cycle = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Period,
            com.google.cloud.channel.v1.Period.Builder,
            com.google.cloud.channel.v1.PeriodOrBuilder>
        getPaymentCycleFieldBuilder() {
      if (paymentCycleBuilder_ == null) {
        paymentCycleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.Period,
                com.google.cloud.channel.v1.Period.Builder,
                com.google.cloud.channel.v1.PeriodOrBuilder>(
                getPaymentCycle(), getParentForChildren(), isClean());
        paymentCycle_ = null;
      }
      return paymentCycleBuilder_;
    }

    private com.google.cloud.channel.v1.Period trialPeriod_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Period,
            com.google.cloud.channel.v1.Period.Builder,
            com.google.cloud.channel.v1.PeriodOrBuilder>
        trialPeriodBuilder_;
    /**
     *
     *
     * <pre>
     * Present for Offers with a trial period.
     * For trial-only Offers, a paid service needs to start before the trial
     * period ends for continued service.
     * For Regular Offers with a trial period, the regular pricing goes into
     * effect when trial period ends, or if paid service is started before the end
     * of the trial period.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
     *
     * @return Whether the trialPeriod field is set.
     */
    public boolean hasTrialPeriod() {
      return trialPeriodBuilder_ != null || trialPeriod_ != null;
    }
    /**
     *
     *
     * <pre>
     * Present for Offers with a trial period.
     * For trial-only Offers, a paid service needs to start before the trial
     * period ends for continued service.
     * For Regular Offers with a trial period, the regular pricing goes into
     * effect when trial period ends, or if paid service is started before the end
     * of the trial period.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
     *
     * @return The trialPeriod.
     */
    public com.google.cloud.channel.v1.Period getTrialPeriod() {
      if (trialPeriodBuilder_ == null) {
        return trialPeriod_ == null
            ? com.google.cloud.channel.v1.Period.getDefaultInstance()
            : trialPeriod_;
      } else {
        return trialPeriodBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Present for Offers with a trial period.
     * For trial-only Offers, a paid service needs to start before the trial
     * period ends for continued service.
     * For Regular Offers with a trial period, the regular pricing goes into
     * effect when trial period ends, or if paid service is started before the end
     * of the trial period.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
     */
    public Builder setTrialPeriod(com.google.cloud.channel.v1.Period value) {
      if (trialPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trialPeriod_ = value;
        onChanged();
      } else {
        trialPeriodBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Present for Offers with a trial period.
     * For trial-only Offers, a paid service needs to start before the trial
     * period ends for continued service.
     * For Regular Offers with a trial period, the regular pricing goes into
     * effect when trial period ends, or if paid service is started before the end
     * of the trial period.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
     */
    public Builder setTrialPeriod(com.google.cloud.channel.v1.Period.Builder builderForValue) {
      if (trialPeriodBuilder_ == null) {
        trialPeriod_ = builderForValue.build();
        onChanged();
      } else {
        trialPeriodBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Present for Offers with a trial period.
     * For trial-only Offers, a paid service needs to start before the trial
     * period ends for continued service.
     * For Regular Offers with a trial period, the regular pricing goes into
     * effect when trial period ends, or if paid service is started before the end
     * of the trial period.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
     */
    public Builder mergeTrialPeriod(com.google.cloud.channel.v1.Period value) {
      if (trialPeriodBuilder_ == null) {
        if (trialPeriod_ != null) {
          trialPeriod_ =
              com.google.cloud.channel.v1.Period.newBuilder(trialPeriod_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trialPeriod_ = value;
        }
        onChanged();
      } else {
        trialPeriodBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Present for Offers with a trial period.
     * For trial-only Offers, a paid service needs to start before the trial
     * period ends for continued service.
     * For Regular Offers with a trial period, the regular pricing goes into
     * effect when trial period ends, or if paid service is started before the end
     * of the trial period.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
     */
    public Builder clearTrialPeriod() {
      if (trialPeriodBuilder_ == null) {
        trialPeriod_ = null;
        onChanged();
      } else {
        trialPeriod_ = null;
        trialPeriodBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Present for Offers with a trial period.
     * For trial-only Offers, a paid service needs to start before the trial
     * period ends for continued service.
     * For Regular Offers with a trial period, the regular pricing goes into
     * effect when trial period ends, or if paid service is started before the end
     * of the trial period.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
     */
    public com.google.cloud.channel.v1.Period.Builder getTrialPeriodBuilder() {

      onChanged();
      return getTrialPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Present for Offers with a trial period.
     * For trial-only Offers, a paid service needs to start before the trial
     * period ends for continued service.
     * For Regular Offers with a trial period, the regular pricing goes into
     * effect when trial period ends, or if paid service is started before the end
     * of the trial period.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
     */
    public com.google.cloud.channel.v1.PeriodOrBuilder getTrialPeriodOrBuilder() {
      if (trialPeriodBuilder_ != null) {
        return trialPeriodBuilder_.getMessageOrBuilder();
      } else {
        return trialPeriod_ == null
            ? com.google.cloud.channel.v1.Period.getDefaultInstance()
            : trialPeriod_;
      }
    }
    /**
     *
     *
     * <pre>
     * Present for Offers with a trial period.
     * For trial-only Offers, a paid service needs to start before the trial
     * period ends for continued service.
     * For Regular Offers with a trial period, the regular pricing goes into
     * effect when trial period ends, or if paid service is started before the end
     * of the trial period.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Period trial_period = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Period,
            com.google.cloud.channel.v1.Period.Builder,
            com.google.cloud.channel.v1.PeriodOrBuilder>
        getTrialPeriodFieldBuilder() {
      if (trialPeriodBuilder_ == null) {
        trialPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.Period,
                com.google.cloud.channel.v1.Period.Builder,
                com.google.cloud.channel.v1.PeriodOrBuilder>(
                getTrialPeriod(), getParentForChildren(), isClean());
        trialPeriod_ = null;
      }
      return trialPeriodBuilder_;
    }

    private java.lang.Object billingAccount_ = "";
    /**
     *
     *
     * <pre>
     * Reseller Billing account to charge after an offer transaction.
     * Only present for Google Cloud Platform offers.
     * </pre>
     *
     * <code>string billing_account = 5;</code>
     *
     * @return The billingAccount.
     */
    public java.lang.String getBillingAccount() {
      java.lang.Object ref = billingAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        billingAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reseller Billing account to charge after an offer transaction.
     * Only present for Google Cloud Platform offers.
     * </pre>
     *
     * <code>string billing_account = 5;</code>
     *
     * @return The bytes for billingAccount.
     */
    public com.google.protobuf.ByteString getBillingAccountBytes() {
      java.lang.Object ref = billingAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        billingAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reseller Billing account to charge after an offer transaction.
     * Only present for Google Cloud Platform offers.
     * </pre>
     *
     * <code>string billing_account = 5;</code>
     *
     * @param value The billingAccount to set.
     * @return This builder for chaining.
     */
    public Builder setBillingAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      billingAccount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reseller Billing account to charge after an offer transaction.
     * Only present for Google Cloud Platform offers.
     * </pre>
     *
     * <code>string billing_account = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBillingAccount() {

      billingAccount_ = getDefaultInstance().getBillingAccount();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reseller Billing account to charge after an offer transaction.
     * Only present for Google Cloud Platform offers.
     * </pre>
     *
     * <code>string billing_account = 5;</code>
     *
     * @param value The bytes for billingAccount to set.
     * @return This builder for chaining.
     */
    public Builder setBillingAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      billingAccount_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.Plan)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.Plan)
  private static final com.google.cloud.channel.v1.Plan DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.Plan();
  }

  public static com.google.cloud.channel.v1.Plan getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Plan> PARSER =
      new com.google.protobuf.AbstractParser<Plan>() {
        @java.lang.Override
        public Plan parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Plan> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Plan> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.Plan getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
