/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/offers.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Parameter's definition. Specifies what parameter is required to use the
 * current Offer to purchase.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.ParameterDefinition}
 */
public final class ParameterDefinition extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.ParameterDefinition)
    ParameterDefinitionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ParameterDefinition.newBuilder() to construct.
  private ParameterDefinition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ParameterDefinition() {
    name_ = "";
    parameterType_ = 0;
    allowedValues_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ParameterDefinition();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_ParameterDefinition_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_ParameterDefinition_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.ParameterDefinition.class,
            com.google.cloud.channel.v1.ParameterDefinition.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Data type of the parameter.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.channel.v1.ParameterDefinition.ParameterType}
   */
  public enum ParameterType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>PARAMETER_TYPE_UNSPECIFIED = 0;</code>
     */
    PARAMETER_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Int64 type.
     * </pre>
     *
     * <code>INT64 = 1;</code>
     */
    INT64(1),
    /**
     *
     *
     * <pre>
     * String type.
     * </pre>
     *
     * <code>STRING = 2;</code>
     */
    STRING(2),
    /**
     *
     *
     * <pre>
     * Double type.
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    DOUBLE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>PARAMETER_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int PARAMETER_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Int64 type.
     * </pre>
     *
     * <code>INT64 = 1;</code>
     */
    public static final int INT64_VALUE = 1;
    /**
     *
     *
     * <pre>
     * String type.
     * </pre>
     *
     * <code>STRING = 2;</code>
     */
    public static final int STRING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Double type.
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    public static final int DOUBLE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ParameterType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ParameterType forNumber(int value) {
      switch (value) {
        case 0:
          return PARAMETER_TYPE_UNSPECIFIED;
        case 1:
          return INT64;
        case 2:
          return STRING;
        case 3:
          return DOUBLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ParameterType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ParameterType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ParameterType>() {
          public ParameterType findValueByNumber(int number) {
            return ParameterType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.channel.v1.ParameterDefinition.getDescriptor().getEnumTypes().get(0);
    }

    private static final ParameterType[] VALUES = values();

    public static ParameterType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ParameterType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.channel.v1.ParameterDefinition.ParameterType)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Name of the parameter.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the parameter.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETER_TYPE_FIELD_NUMBER = 2;
  private int parameterType_;
  /**
   *
   *
   * <pre>
   * Data type of the parameter. Minimal value, Maximum value and allowed values
   * will use specified data type here.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.ParameterDefinition.ParameterType parameter_type = 2;</code>
   *
   * @return The enum numeric value on the wire for parameterType.
   */
  @java.lang.Override
  public int getParameterTypeValue() {
    return parameterType_;
  }
  /**
   *
   *
   * <pre>
   * Data type of the parameter. Minimal value, Maximum value and allowed values
   * will use specified data type here.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.ParameterDefinition.ParameterType parameter_type = 2;</code>
   *
   * @return The parameterType.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ParameterDefinition.ParameterType getParameterType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.channel.v1.ParameterDefinition.ParameterType result =
        com.google.cloud.channel.v1.ParameterDefinition.ParameterType.valueOf(parameterType_);
    return result == null
        ? com.google.cloud.channel.v1.ParameterDefinition.ParameterType.UNRECOGNIZED
        : result;
  }

  public static final int MIN_VALUE_FIELD_NUMBER = 3;
  private com.google.cloud.channel.v1.Value minValue_;
  /**
   *
   *
   * <pre>
   * Minimal value of the parameter, if applicable. Inclusive. For example,
   * minimal commitment when purchasing Anthos is 0.01.
   * Applicable to INT64 and DOUBLE parameter types.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
   *
   * @return Whether the minValue field is set.
   */
  @java.lang.Override
  public boolean hasMinValue() {
    return minValue_ != null;
  }
  /**
   *
   *
   * <pre>
   * Minimal value of the parameter, if applicable. Inclusive. For example,
   * minimal commitment when purchasing Anthos is 0.01.
   * Applicable to INT64 and DOUBLE parameter types.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
   *
   * @return The minValue.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Value getMinValue() {
    return minValue_ == null ? com.google.cloud.channel.v1.Value.getDefaultInstance() : minValue_;
  }
  /**
   *
   *
   * <pre>
   * Minimal value of the parameter, if applicable. Inclusive. For example,
   * minimal commitment when purchasing Anthos is 0.01.
   * Applicable to INT64 and DOUBLE parameter types.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ValueOrBuilder getMinValueOrBuilder() {
    return getMinValue();
  }

  public static final int MAX_VALUE_FIELD_NUMBER = 4;
  private com.google.cloud.channel.v1.Value maxValue_;
  /**
   *
   *
   * <pre>
   * Maximum value of the parameter, if applicable. Inclusive. For example,
   * maximum seats when purchasing Google Workspace Business Standard.
   * Applicable to INT64 and DOUBLE parameter types.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
   *
   * @return Whether the maxValue field is set.
   */
  @java.lang.Override
  public boolean hasMaxValue() {
    return maxValue_ != null;
  }
  /**
   *
   *
   * <pre>
   * Maximum value of the parameter, if applicable. Inclusive. For example,
   * maximum seats when purchasing Google Workspace Business Standard.
   * Applicable to INT64 and DOUBLE parameter types.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
   *
   * @return The maxValue.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Value getMaxValue() {
    return maxValue_ == null ? com.google.cloud.channel.v1.Value.getDefaultInstance() : maxValue_;
  }
  /**
   *
   *
   * <pre>
   * Maximum value of the parameter, if applicable. Inclusive. For example,
   * maximum seats when purchasing Google Workspace Business Standard.
   * Applicable to INT64 and DOUBLE parameter types.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ValueOrBuilder getMaxValueOrBuilder() {
    return getMaxValue();
  }

  public static final int ALLOWED_VALUES_FIELD_NUMBER = 5;
  private java.util.List<com.google.cloud.channel.v1.Value> allowedValues_;
  /**
   *
   *
   * <pre>
   * If not empty, parameter values must be drawn from this list.
   * For example, [us-west1, us-west2, ...]
   * Applicable to STRING parameter type.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.Value> getAllowedValuesList() {
    return allowedValues_;
  }
  /**
   *
   *
   * <pre>
   * If not empty, parameter values must be drawn from this list.
   * For example, [us-west1, us-west2, ...]
   * Applicable to STRING parameter type.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.channel.v1.ValueOrBuilder>
      getAllowedValuesOrBuilderList() {
    return allowedValues_;
  }
  /**
   *
   *
   * <pre>
   * If not empty, parameter values must be drawn from this list.
   * For example, [us-west1, us-west2, ...]
   * Applicable to STRING parameter type.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
   */
  @java.lang.Override
  public int getAllowedValuesCount() {
    return allowedValues_.size();
  }
  /**
   *
   *
   * <pre>
   * If not empty, parameter values must be drawn from this list.
   * For example, [us-west1, us-west2, ...]
   * Applicable to STRING parameter type.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Value getAllowedValues(int index) {
    return allowedValues_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If not empty, parameter values must be drawn from this list.
   * For example, [us-west1, us-west2, ...]
   * Applicable to STRING parameter type.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ValueOrBuilder getAllowedValuesOrBuilder(int index) {
    return allowedValues_.get(index);
  }

  public static final int OPTIONAL_FIELD_NUMBER = 6;
  private boolean optional_;
  /**
   *
   *
   * <pre>
   * If set to true, parameter is optional to purchase this Offer.
   * </pre>
   *
   * <code>bool optional = 6;</code>
   *
   * @return The optional.
   */
  @java.lang.Override
  public boolean getOptional() {
    return optional_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (parameterType_
        != com.google.cloud.channel.v1.ParameterDefinition.ParameterType.PARAMETER_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, parameterType_);
    }
    if (minValue_ != null) {
      output.writeMessage(3, getMinValue());
    }
    if (maxValue_ != null) {
      output.writeMessage(4, getMaxValue());
    }
    for (int i = 0; i < allowedValues_.size(); i++) {
      output.writeMessage(5, allowedValues_.get(i));
    }
    if (optional_ != false) {
      output.writeBool(6, optional_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (parameterType_
        != com.google.cloud.channel.v1.ParameterDefinition.ParameterType.PARAMETER_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, parameterType_);
    }
    if (minValue_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMinValue());
    }
    if (maxValue_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMaxValue());
    }
    for (int i = 0; i < allowedValues_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, allowedValues_.get(i));
    }
    if (optional_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, optional_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.ParameterDefinition)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.ParameterDefinition other =
        (com.google.cloud.channel.v1.ParameterDefinition) obj;

    if (!getName().equals(other.getName())) return false;
    if (parameterType_ != other.parameterType_) return false;
    if (hasMinValue() != other.hasMinValue()) return false;
    if (hasMinValue()) {
      if (!getMinValue().equals(other.getMinValue())) return false;
    }
    if (hasMaxValue() != other.hasMaxValue()) return false;
    if (hasMaxValue()) {
      if (!getMaxValue().equals(other.getMaxValue())) return false;
    }
    if (!getAllowedValuesList().equals(other.getAllowedValuesList())) return false;
    if (getOptional() != other.getOptional()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PARAMETER_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + parameterType_;
    if (hasMinValue()) {
      hash = (37 * hash) + MIN_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getMinValue().hashCode();
    }
    if (hasMaxValue()) {
      hash = (37 * hash) + MAX_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxValue().hashCode();
    }
    if (getAllowedValuesCount() > 0) {
      hash = (37 * hash) + ALLOWED_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedValuesList().hashCode();
    }
    hash = (37 * hash) + OPTIONAL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOptional());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ParameterDefinition parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.ParameterDefinition prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameter's definition. Specifies what parameter is required to use the
   * current Offer to purchase.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.ParameterDefinition}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.ParameterDefinition)
      com.google.cloud.channel.v1.ParameterDefinitionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_ParameterDefinition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_ParameterDefinition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.ParameterDefinition.class,
              com.google.cloud.channel.v1.ParameterDefinition.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.ParameterDefinition.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      parameterType_ = 0;

      if (minValueBuilder_ == null) {
        minValue_ = null;
      } else {
        minValue_ = null;
        minValueBuilder_ = null;
      }
      if (maxValueBuilder_ == null) {
        maxValue_ = null;
      } else {
        maxValue_ = null;
        maxValueBuilder_ = null;
      }
      if (allowedValuesBuilder_ == null) {
        allowedValues_ = java.util.Collections.emptyList();
      } else {
        allowedValues_ = null;
        allowedValuesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      optional_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_ParameterDefinition_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ParameterDefinition getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.ParameterDefinition.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ParameterDefinition build() {
      com.google.cloud.channel.v1.ParameterDefinition result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ParameterDefinition buildPartial() {
      com.google.cloud.channel.v1.ParameterDefinition result =
          new com.google.cloud.channel.v1.ParameterDefinition(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.parameterType_ = parameterType_;
      if (minValueBuilder_ == null) {
        result.minValue_ = minValue_;
      } else {
        result.minValue_ = minValueBuilder_.build();
      }
      if (maxValueBuilder_ == null) {
        result.maxValue_ = maxValue_;
      } else {
        result.maxValue_ = maxValueBuilder_.build();
      }
      if (allowedValuesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          allowedValues_ = java.util.Collections.unmodifiableList(allowedValues_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.allowedValues_ = allowedValues_;
      } else {
        result.allowedValues_ = allowedValuesBuilder_.build();
      }
      result.optional_ = optional_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.ParameterDefinition) {
        return mergeFrom((com.google.cloud.channel.v1.ParameterDefinition) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.ParameterDefinition other) {
      if (other == com.google.cloud.channel.v1.ParameterDefinition.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.parameterType_ != 0) {
        setParameterTypeValue(other.getParameterTypeValue());
      }
      if (other.hasMinValue()) {
        mergeMinValue(other.getMinValue());
      }
      if (other.hasMaxValue()) {
        mergeMaxValue(other.getMaxValue());
      }
      if (allowedValuesBuilder_ == null) {
        if (!other.allowedValues_.isEmpty()) {
          if (allowedValues_.isEmpty()) {
            allowedValues_ = other.allowedValues_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAllowedValuesIsMutable();
            allowedValues_.addAll(other.allowedValues_);
          }
          onChanged();
        }
      } else {
        if (!other.allowedValues_.isEmpty()) {
          if (allowedValuesBuilder_.isEmpty()) {
            allowedValuesBuilder_.dispose();
            allowedValuesBuilder_ = null;
            allowedValues_ = other.allowedValues_;
            bitField0_ = (bitField0_ & ~0x00000001);
            allowedValuesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAllowedValuesFieldBuilder()
                    : null;
          } else {
            allowedValuesBuilder_.addAllMessages(other.allowedValues_);
          }
        }
      }
      if (other.getOptional() != false) {
        setOptional(other.getOptional());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                parameterType_ = input.readEnum();

                break;
              } // case 16
            case 26:
              {
                input.readMessage(getMinValueFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getMaxValueFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                com.google.cloud.channel.v1.Value m =
                    input.readMessage(
                        com.google.cloud.channel.v1.Value.parser(), extensionRegistry);
                if (allowedValuesBuilder_ == null) {
                  ensureAllowedValuesIsMutable();
                  allowedValues_.add(m);
                } else {
                  allowedValuesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 48:
              {
                optional_ = input.readBool();

                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the parameter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the parameter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the parameter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the parameter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the parameter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private int parameterType_ = 0;
    /**
     *
     *
     * <pre>
     * Data type of the parameter. Minimal value, Maximum value and allowed values
     * will use specified data type here.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ParameterDefinition.ParameterType parameter_type = 2;</code>
     *
     * @return The enum numeric value on the wire for parameterType.
     */
    @java.lang.Override
    public int getParameterTypeValue() {
      return parameterType_;
    }
    /**
     *
     *
     * <pre>
     * Data type of the parameter. Minimal value, Maximum value and allowed values
     * will use specified data type here.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ParameterDefinition.ParameterType parameter_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for parameterType to set.
     * @return This builder for chaining.
     */
    public Builder setParameterTypeValue(int value) {

      parameterType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data type of the parameter. Minimal value, Maximum value and allowed values
     * will use specified data type here.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ParameterDefinition.ParameterType parameter_type = 2;</code>
     *
     * @return The parameterType.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.ParameterDefinition.ParameterType getParameterType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.ParameterDefinition.ParameterType result =
          com.google.cloud.channel.v1.ParameterDefinition.ParameterType.valueOf(parameterType_);
      return result == null
          ? com.google.cloud.channel.v1.ParameterDefinition.ParameterType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Data type of the parameter. Minimal value, Maximum value and allowed values
     * will use specified data type here.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ParameterDefinition.ParameterType parameter_type = 2;</code>
     *
     * @param value The parameterType to set.
     * @return This builder for chaining.
     */
    public Builder setParameterType(
        com.google.cloud.channel.v1.ParameterDefinition.ParameterType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parameterType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data type of the parameter. Minimal value, Maximum value and allowed values
     * will use specified data type here.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ParameterDefinition.ParameterType parameter_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParameterType() {

      parameterType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.channel.v1.Value minValue_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Value,
            com.google.cloud.channel.v1.Value.Builder,
            com.google.cloud.channel.v1.ValueOrBuilder>
        minValueBuilder_;
    /**
     *
     *
     * <pre>
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     *
     * @return Whether the minValue field is set.
     */
    public boolean hasMinValue() {
      return minValueBuilder_ != null || minValue_ != null;
    }
    /**
     *
     *
     * <pre>
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     *
     * @return The minValue.
     */
    public com.google.cloud.channel.v1.Value getMinValue() {
      if (minValueBuilder_ == null) {
        return minValue_ == null
            ? com.google.cloud.channel.v1.Value.getDefaultInstance()
            : minValue_;
      } else {
        return minValueBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     */
    public Builder setMinValue(com.google.cloud.channel.v1.Value value) {
      if (minValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        minValue_ = value;
        onChanged();
      } else {
        minValueBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     */
    public Builder setMinValue(com.google.cloud.channel.v1.Value.Builder builderForValue) {
      if (minValueBuilder_ == null) {
        minValue_ = builderForValue.build();
        onChanged();
      } else {
        minValueBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     */
    public Builder mergeMinValue(com.google.cloud.channel.v1.Value value) {
      if (minValueBuilder_ == null) {
        if (minValue_ != null) {
          minValue_ =
              com.google.cloud.channel.v1.Value.newBuilder(minValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          minValue_ = value;
        }
        onChanged();
      } else {
        minValueBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     */
    public Builder clearMinValue() {
      if (minValueBuilder_ == null) {
        minValue_ = null;
        onChanged();
      } else {
        minValue_ = null;
        minValueBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     */
    public com.google.cloud.channel.v1.Value.Builder getMinValueBuilder() {

      onChanged();
      return getMinValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     */
    public com.google.cloud.channel.v1.ValueOrBuilder getMinValueOrBuilder() {
      if (minValueBuilder_ != null) {
        return minValueBuilder_.getMessageOrBuilder();
      } else {
        return minValue_ == null
            ? com.google.cloud.channel.v1.Value.getDefaultInstance()
            : minValue_;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Value,
            com.google.cloud.channel.v1.Value.Builder,
            com.google.cloud.channel.v1.ValueOrBuilder>
        getMinValueFieldBuilder() {
      if (minValueBuilder_ == null) {
        minValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.Value,
                com.google.cloud.channel.v1.Value.Builder,
                com.google.cloud.channel.v1.ValueOrBuilder>(
                getMinValue(), getParentForChildren(), isClean());
        minValue_ = null;
      }
      return minValueBuilder_;
    }

    private com.google.cloud.channel.v1.Value maxValue_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Value,
            com.google.cloud.channel.v1.Value.Builder,
            com.google.cloud.channel.v1.ValueOrBuilder>
        maxValueBuilder_;
    /**
     *
     *
     * <pre>
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     *
     * @return Whether the maxValue field is set.
     */
    public boolean hasMaxValue() {
      return maxValueBuilder_ != null || maxValue_ != null;
    }
    /**
     *
     *
     * <pre>
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     *
     * @return The maxValue.
     */
    public com.google.cloud.channel.v1.Value getMaxValue() {
      if (maxValueBuilder_ == null) {
        return maxValue_ == null
            ? com.google.cloud.channel.v1.Value.getDefaultInstance()
            : maxValue_;
      } else {
        return maxValueBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     */
    public Builder setMaxValue(com.google.cloud.channel.v1.Value value) {
      if (maxValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxValue_ = value;
        onChanged();
      } else {
        maxValueBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     */
    public Builder setMaxValue(com.google.cloud.channel.v1.Value.Builder builderForValue) {
      if (maxValueBuilder_ == null) {
        maxValue_ = builderForValue.build();
        onChanged();
      } else {
        maxValueBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     */
    public Builder mergeMaxValue(com.google.cloud.channel.v1.Value value) {
      if (maxValueBuilder_ == null) {
        if (maxValue_ != null) {
          maxValue_ =
              com.google.cloud.channel.v1.Value.newBuilder(maxValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          maxValue_ = value;
        }
        onChanged();
      } else {
        maxValueBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     */
    public Builder clearMaxValue() {
      if (maxValueBuilder_ == null) {
        maxValue_ = null;
        onChanged();
      } else {
        maxValue_ = null;
        maxValueBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     */
    public com.google.cloud.channel.v1.Value.Builder getMaxValueBuilder() {

      onChanged();
      return getMaxValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     */
    public com.google.cloud.channel.v1.ValueOrBuilder getMaxValueOrBuilder() {
      if (maxValueBuilder_ != null) {
        return maxValueBuilder_.getMessageOrBuilder();
      } else {
        return maxValue_ == null
            ? com.google.cloud.channel.v1.Value.getDefaultInstance()
            : maxValue_;
      }
    }
    /**
     *
     *
     * <pre>
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Value,
            com.google.cloud.channel.v1.Value.Builder,
            com.google.cloud.channel.v1.ValueOrBuilder>
        getMaxValueFieldBuilder() {
      if (maxValueBuilder_ == null) {
        maxValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.Value,
                com.google.cloud.channel.v1.Value.Builder,
                com.google.cloud.channel.v1.ValueOrBuilder>(
                getMaxValue(), getParentForChildren(), isClean());
        maxValue_ = null;
      }
      return maxValueBuilder_;
    }

    private java.util.List<com.google.cloud.channel.v1.Value> allowedValues_ =
        java.util.Collections.emptyList();

    private void ensureAllowedValuesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        allowedValues_ = new java.util.ArrayList<com.google.cloud.channel.v1.Value>(allowedValues_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.Value,
            com.google.cloud.channel.v1.Value.Builder,
            com.google.cloud.channel.v1.ValueOrBuilder>
        allowedValuesBuilder_;

    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.Value> getAllowedValuesList() {
      if (allowedValuesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(allowedValues_);
      } else {
        return allowedValuesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public int getAllowedValuesCount() {
      if (allowedValuesBuilder_ == null) {
        return allowedValues_.size();
      } else {
        return allowedValuesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public com.google.cloud.channel.v1.Value getAllowedValues(int index) {
      if (allowedValuesBuilder_ == null) {
        return allowedValues_.get(index);
      } else {
        return allowedValuesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public Builder setAllowedValues(int index, com.google.cloud.channel.v1.Value value) {
      if (allowedValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedValuesIsMutable();
        allowedValues_.set(index, value);
        onChanged();
      } else {
        allowedValuesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public Builder setAllowedValues(
        int index, com.google.cloud.channel.v1.Value.Builder builderForValue) {
      if (allowedValuesBuilder_ == null) {
        ensureAllowedValuesIsMutable();
        allowedValues_.set(index, builderForValue.build());
        onChanged();
      } else {
        allowedValuesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public Builder addAllowedValues(com.google.cloud.channel.v1.Value value) {
      if (allowedValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedValuesIsMutable();
        allowedValues_.add(value);
        onChanged();
      } else {
        allowedValuesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public Builder addAllowedValues(int index, com.google.cloud.channel.v1.Value value) {
      if (allowedValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedValuesIsMutable();
        allowedValues_.add(index, value);
        onChanged();
      } else {
        allowedValuesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public Builder addAllowedValues(com.google.cloud.channel.v1.Value.Builder builderForValue) {
      if (allowedValuesBuilder_ == null) {
        ensureAllowedValuesIsMutable();
        allowedValues_.add(builderForValue.build());
        onChanged();
      } else {
        allowedValuesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public Builder addAllowedValues(
        int index, com.google.cloud.channel.v1.Value.Builder builderForValue) {
      if (allowedValuesBuilder_ == null) {
        ensureAllowedValuesIsMutable();
        allowedValues_.add(index, builderForValue.build());
        onChanged();
      } else {
        allowedValuesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public Builder addAllAllowedValues(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.Value> values) {
      if (allowedValuesBuilder_ == null) {
        ensureAllowedValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedValues_);
        onChanged();
      } else {
        allowedValuesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public Builder clearAllowedValues() {
      if (allowedValuesBuilder_ == null) {
        allowedValues_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        allowedValuesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public Builder removeAllowedValues(int index) {
      if (allowedValuesBuilder_ == null) {
        ensureAllowedValuesIsMutable();
        allowedValues_.remove(index);
        onChanged();
      } else {
        allowedValuesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public com.google.cloud.channel.v1.Value.Builder getAllowedValuesBuilder(int index) {
      return getAllowedValuesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public com.google.cloud.channel.v1.ValueOrBuilder getAllowedValuesOrBuilder(int index) {
      if (allowedValuesBuilder_ == null) {
        return allowedValues_.get(index);
      } else {
        return allowedValuesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.channel.v1.ValueOrBuilder>
        getAllowedValuesOrBuilderList() {
      if (allowedValuesBuilder_ != null) {
        return allowedValuesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(allowedValues_);
      }
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public com.google.cloud.channel.v1.Value.Builder addAllowedValuesBuilder() {
      return getAllowedValuesFieldBuilder()
          .addBuilder(com.google.cloud.channel.v1.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public com.google.cloud.channel.v1.Value.Builder addAllowedValuesBuilder(int index) {
      return getAllowedValuesFieldBuilder()
          .addBuilder(index, com.google.cloud.channel.v1.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.Value.Builder> getAllowedValuesBuilderList() {
      return getAllowedValuesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.Value,
            com.google.cloud.channel.v1.Value.Builder,
            com.google.cloud.channel.v1.ValueOrBuilder>
        getAllowedValuesFieldBuilder() {
      if (allowedValuesBuilder_ == null) {
        allowedValuesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.channel.v1.Value,
                com.google.cloud.channel.v1.Value.Builder,
                com.google.cloud.channel.v1.ValueOrBuilder>(
                allowedValues_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        allowedValues_ = null;
      }
      return allowedValuesBuilder_;
    }

    private boolean optional_;
    /**
     *
     *
     * <pre>
     * If set to true, parameter is optional to purchase this Offer.
     * </pre>
     *
     * <code>bool optional = 6;</code>
     *
     * @return The optional.
     */
    @java.lang.Override
    public boolean getOptional() {
      return optional_;
    }
    /**
     *
     *
     * <pre>
     * If set to true, parameter is optional to purchase this Offer.
     * </pre>
     *
     * <code>bool optional = 6;</code>
     *
     * @param value The optional to set.
     * @return This builder for chaining.
     */
    public Builder setOptional(boolean value) {

      optional_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to true, parameter is optional to purchase this Offer.
     * </pre>
     *
     * <code>bool optional = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOptional() {

      optional_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.ParameterDefinition)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.ParameterDefinition)
  private static final com.google.cloud.channel.v1.ParameterDefinition DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.ParameterDefinition();
  }

  public static com.google.cloud.channel.v1.ParameterDefinition getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ParameterDefinition> PARSER =
      new com.google.protobuf.AbstractParser<ParameterDefinition>() {
        @java.lang.Override
        public ParameterDefinition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ParameterDefinition> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ParameterDefinition> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.ParameterDefinition getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
