/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/offers.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Represents an offer made to resellers for purchase.
 * An offer is associated with a [Sku][google.cloud.channel.v1.Sku], has a plan for payment, a price, and
 * defines the constraints for buying.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.Offer}
 */
public final class Offer extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.Offer)
    OfferOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Offer.newBuilder() to construct.
  private Offer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Offer() {
    name_ = "";
    priceByResources_ = java.util.Collections.emptyList();
    parameterDefinitions_ = java.util.Collections.emptyList();
    dealCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Offer();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_Offer_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_Offer_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.Offer.class,
            com.google.cloud.channel.v1.Offer.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Resource Name of the Offer.
   * Format: accounts/{account_id}/offers/{offer_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource Name of the Offer.
   * Format: accounts/{account_id}/offers/{offer_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MARKETING_INFO_FIELD_NUMBER = 2;
  private com.google.cloud.channel.v1.MarketingInfo marketingInfo_;
  /**
   *
   *
   * <pre>
   * Marketing information for the Offer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
   *
   * @return Whether the marketingInfo field is set.
   */
  @java.lang.Override
  public boolean hasMarketingInfo() {
    return marketingInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Marketing information for the Offer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
   *
   * @return The marketingInfo.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.MarketingInfo getMarketingInfo() {
    return marketingInfo_ == null
        ? com.google.cloud.channel.v1.MarketingInfo.getDefaultInstance()
        : marketingInfo_;
  }
  /**
   *
   *
   * <pre>
   * Marketing information for the Offer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.MarketingInfoOrBuilder getMarketingInfoOrBuilder() {
    return getMarketingInfo();
  }

  public static final int SKU_FIELD_NUMBER = 3;
  private com.google.cloud.channel.v1.Sku sku_;
  /**
   *
   *
   * <pre>
   * SKU the offer is associated with.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
   *
   * @return Whether the sku field is set.
   */
  @java.lang.Override
  public boolean hasSku() {
    return sku_ != null;
  }
  /**
   *
   *
   * <pre>
   * SKU the offer is associated with.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
   *
   * @return The sku.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Sku getSku() {
    return sku_ == null ? com.google.cloud.channel.v1.Sku.getDefaultInstance() : sku_;
  }
  /**
   *
   *
   * <pre>
   * SKU the offer is associated with.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.SkuOrBuilder getSkuOrBuilder() {
    return getSku();
  }

  public static final int PLAN_FIELD_NUMBER = 4;
  private com.google.cloud.channel.v1.Plan plan_;
  /**
   *
   *
   * <pre>
   * Describes the payment plan for the Offer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
   *
   * @return Whether the plan field is set.
   */
  @java.lang.Override
  public boolean hasPlan() {
    return plan_ != null;
  }
  /**
   *
   *
   * <pre>
   * Describes the payment plan for the Offer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
   *
   * @return The plan.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Plan getPlan() {
    return plan_ == null ? com.google.cloud.channel.v1.Plan.getDefaultInstance() : plan_;
  }
  /**
   *
   *
   * <pre>
   * Describes the payment plan for the Offer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PlanOrBuilder getPlanOrBuilder() {
    return getPlan();
  }

  public static final int CONSTRAINTS_FIELD_NUMBER = 5;
  private com.google.cloud.channel.v1.Constraints constraints_;
  /**
   *
   *
   * <pre>
   * Constraints on transacting the Offer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
   *
   * @return Whether the constraints field is set.
   */
  @java.lang.Override
  public boolean hasConstraints() {
    return constraints_ != null;
  }
  /**
   *
   *
   * <pre>
   * Constraints on transacting the Offer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
   *
   * @return The constraints.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Constraints getConstraints() {
    return constraints_ == null
        ? com.google.cloud.channel.v1.Constraints.getDefaultInstance()
        : constraints_;
  }
  /**
   *
   *
   * <pre>
   * Constraints on transacting the Offer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ConstraintsOrBuilder getConstraintsOrBuilder() {
    return getConstraints();
  }

  public static final int PRICE_BY_RESOURCES_FIELD_NUMBER = 6;
  private java.util.List<com.google.cloud.channel.v1.PriceByResource> priceByResources_;
  /**
   *
   *
   * <pre>
   * Price for each monetizable resource type.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.PriceByResource> getPriceByResourcesList() {
    return priceByResources_;
  }
  /**
   *
   *
   * <pre>
   * Price for each monetizable resource type.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.channel.v1.PriceByResourceOrBuilder>
      getPriceByResourcesOrBuilderList() {
    return priceByResources_;
  }
  /**
   *
   *
   * <pre>
   * Price for each monetizable resource type.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
   */
  @java.lang.Override
  public int getPriceByResourcesCount() {
    return priceByResources_.size();
  }
  /**
   *
   *
   * <pre>
   * Price for each monetizable resource type.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PriceByResource getPriceByResources(int index) {
    return priceByResources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Price for each monetizable resource type.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PriceByResourceOrBuilder getPriceByResourcesOrBuilder(
      int index) {
    return priceByResources_.get(index);
  }

  public static final int START_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Start of the Offer validity time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Start of the Offer validity time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Start of the Offer validity time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. End of the Offer validity time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. End of the Offer validity time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. End of the Offer validity time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int PARAMETER_DEFINITIONS_FIELD_NUMBER = 9;
  private java.util.List<com.google.cloud.channel.v1.ParameterDefinition> parameterDefinitions_;
  /**
   *
   *
   * <pre>
   * Parameters required to use current Offer to purchase.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.ParameterDefinition>
      getParameterDefinitionsList() {
    return parameterDefinitions_;
  }
  /**
   *
   *
   * <pre>
   * Parameters required to use current Offer to purchase.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.channel.v1.ParameterDefinitionOrBuilder>
      getParameterDefinitionsOrBuilderList() {
    return parameterDefinitions_;
  }
  /**
   *
   *
   * <pre>
   * Parameters required to use current Offer to purchase.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
   */
  @java.lang.Override
  public int getParameterDefinitionsCount() {
    return parameterDefinitions_.size();
  }
  /**
   *
   *
   * <pre>
   * Parameters required to use current Offer to purchase.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ParameterDefinition getParameterDefinitions(int index) {
    return parameterDefinitions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Parameters required to use current Offer to purchase.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ParameterDefinitionOrBuilder getParameterDefinitionsOrBuilder(
      int index) {
    return parameterDefinitions_.get(index);
  }

  public static final int DEAL_CODE_FIELD_NUMBER = 12;
  private volatile java.lang.Object dealCode_;
  /**
   *
   *
   * <pre>
   * The deal code of the offer to get a special promotion or discount.
   * </pre>
   *
   * <code>string deal_code = 12;</code>
   *
   * @return The dealCode.
   */
  @java.lang.Override
  public java.lang.String getDealCode() {
    java.lang.Object ref = dealCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dealCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The deal code of the offer to get a special promotion or discount.
   * </pre>
   *
   * <code>string deal_code = 12;</code>
   *
   * @return The bytes for dealCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDealCodeBytes() {
    java.lang.Object ref = dealCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dealCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (marketingInfo_ != null) {
      output.writeMessage(2, getMarketingInfo());
    }
    if (sku_ != null) {
      output.writeMessage(3, getSku());
    }
    if (plan_ != null) {
      output.writeMessage(4, getPlan());
    }
    if (constraints_ != null) {
      output.writeMessage(5, getConstraints());
    }
    for (int i = 0; i < priceByResources_.size(); i++) {
      output.writeMessage(6, priceByResources_.get(i));
    }
    if (startTime_ != null) {
      output.writeMessage(7, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(8, getEndTime());
    }
    for (int i = 0; i < parameterDefinitions_.size(); i++) {
      output.writeMessage(9, parameterDefinitions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dealCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, dealCode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (marketingInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMarketingInfo());
    }
    if (sku_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSku());
    }
    if (plan_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPlan());
    }
    if (constraints_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getConstraints());
    }
    for (int i = 0; i < priceByResources_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, priceByResources_.get(i));
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEndTime());
    }
    for (int i = 0; i < parameterDefinitions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, parameterDefinitions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dealCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, dealCode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.Offer)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.Offer other = (com.google.cloud.channel.v1.Offer) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasMarketingInfo() != other.hasMarketingInfo()) return false;
    if (hasMarketingInfo()) {
      if (!getMarketingInfo().equals(other.getMarketingInfo())) return false;
    }
    if (hasSku() != other.hasSku()) return false;
    if (hasSku()) {
      if (!getSku().equals(other.getSku())) return false;
    }
    if (hasPlan() != other.hasPlan()) return false;
    if (hasPlan()) {
      if (!getPlan().equals(other.getPlan())) return false;
    }
    if (hasConstraints() != other.hasConstraints()) return false;
    if (hasConstraints()) {
      if (!getConstraints().equals(other.getConstraints())) return false;
    }
    if (!getPriceByResourcesList().equals(other.getPriceByResourcesList())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getParameterDefinitionsList().equals(other.getParameterDefinitionsList())) return false;
    if (!getDealCode().equals(other.getDealCode())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasMarketingInfo()) {
      hash = (37 * hash) + MARKETING_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getMarketingInfo().hashCode();
    }
    if (hasSku()) {
      hash = (37 * hash) + SKU_FIELD_NUMBER;
      hash = (53 * hash) + getSku().hashCode();
    }
    if (hasPlan()) {
      hash = (37 * hash) + PLAN_FIELD_NUMBER;
      hash = (53 * hash) + getPlan().hashCode();
    }
    if (hasConstraints()) {
      hash = (37 * hash) + CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getConstraints().hashCode();
    }
    if (getPriceByResourcesCount() > 0) {
      hash = (37 * hash) + PRICE_BY_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getPriceByResourcesList().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (getParameterDefinitionsCount() > 0) {
      hash = (37 * hash) + PARAMETER_DEFINITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getParameterDefinitionsList().hashCode();
    }
    hash = (37 * hash) + DEAL_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getDealCode().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.Offer parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Offer parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Offer parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Offer parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Offer parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Offer parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Offer parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Offer parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Offer parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Offer parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Offer parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Offer parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.Offer prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an offer made to resellers for purchase.
   * An offer is associated with a [Sku][google.cloud.channel.v1.Sku], has a plan for payment, a price, and
   * defines the constraints for buying.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.Offer}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.Offer)
      com.google.cloud.channel.v1.OfferOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_Offer_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_Offer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.Offer.class,
              com.google.cloud.channel.v1.Offer.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.Offer.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (marketingInfoBuilder_ == null) {
        marketingInfo_ = null;
      } else {
        marketingInfo_ = null;
        marketingInfoBuilder_ = null;
      }
      if (skuBuilder_ == null) {
        sku_ = null;
      } else {
        sku_ = null;
        skuBuilder_ = null;
      }
      if (planBuilder_ == null) {
        plan_ = null;
      } else {
        plan_ = null;
        planBuilder_ = null;
      }
      if (constraintsBuilder_ == null) {
        constraints_ = null;
      } else {
        constraints_ = null;
        constraintsBuilder_ = null;
      }
      if (priceByResourcesBuilder_ == null) {
        priceByResources_ = java.util.Collections.emptyList();
      } else {
        priceByResources_ = null;
        priceByResourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      if (parameterDefinitionsBuilder_ == null) {
        parameterDefinitions_ = java.util.Collections.emptyList();
      } else {
        parameterDefinitions_ = null;
        parameterDefinitionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      dealCode_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_Offer_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Offer getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.Offer.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Offer build() {
      com.google.cloud.channel.v1.Offer result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Offer buildPartial() {
      com.google.cloud.channel.v1.Offer result = new com.google.cloud.channel.v1.Offer(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (marketingInfoBuilder_ == null) {
        result.marketingInfo_ = marketingInfo_;
      } else {
        result.marketingInfo_ = marketingInfoBuilder_.build();
      }
      if (skuBuilder_ == null) {
        result.sku_ = sku_;
      } else {
        result.sku_ = skuBuilder_.build();
      }
      if (planBuilder_ == null) {
        result.plan_ = plan_;
      } else {
        result.plan_ = planBuilder_.build();
      }
      if (constraintsBuilder_ == null) {
        result.constraints_ = constraints_;
      } else {
        result.constraints_ = constraintsBuilder_.build();
      }
      if (priceByResourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          priceByResources_ = java.util.Collections.unmodifiableList(priceByResources_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.priceByResources_ = priceByResources_;
      } else {
        result.priceByResources_ = priceByResourcesBuilder_.build();
      }
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      if (parameterDefinitionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          parameterDefinitions_ = java.util.Collections.unmodifiableList(parameterDefinitions_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.parameterDefinitions_ = parameterDefinitions_;
      } else {
        result.parameterDefinitions_ = parameterDefinitionsBuilder_.build();
      }
      result.dealCode_ = dealCode_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.Offer) {
        return mergeFrom((com.google.cloud.channel.v1.Offer) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.Offer other) {
      if (other == com.google.cloud.channel.v1.Offer.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasMarketingInfo()) {
        mergeMarketingInfo(other.getMarketingInfo());
      }
      if (other.hasSku()) {
        mergeSku(other.getSku());
      }
      if (other.hasPlan()) {
        mergePlan(other.getPlan());
      }
      if (other.hasConstraints()) {
        mergeConstraints(other.getConstraints());
      }
      if (priceByResourcesBuilder_ == null) {
        if (!other.priceByResources_.isEmpty()) {
          if (priceByResources_.isEmpty()) {
            priceByResources_ = other.priceByResources_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePriceByResourcesIsMutable();
            priceByResources_.addAll(other.priceByResources_);
          }
          onChanged();
        }
      } else {
        if (!other.priceByResources_.isEmpty()) {
          if (priceByResourcesBuilder_.isEmpty()) {
            priceByResourcesBuilder_.dispose();
            priceByResourcesBuilder_ = null;
            priceByResources_ = other.priceByResources_;
            bitField0_ = (bitField0_ & ~0x00000001);
            priceByResourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPriceByResourcesFieldBuilder()
                    : null;
          } else {
            priceByResourcesBuilder_.addAllMessages(other.priceByResources_);
          }
        }
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (parameterDefinitionsBuilder_ == null) {
        if (!other.parameterDefinitions_.isEmpty()) {
          if (parameterDefinitions_.isEmpty()) {
            parameterDefinitions_ = other.parameterDefinitions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureParameterDefinitionsIsMutable();
            parameterDefinitions_.addAll(other.parameterDefinitions_);
          }
          onChanged();
        }
      } else {
        if (!other.parameterDefinitions_.isEmpty()) {
          if (parameterDefinitionsBuilder_.isEmpty()) {
            parameterDefinitionsBuilder_.dispose();
            parameterDefinitionsBuilder_ = null;
            parameterDefinitions_ = other.parameterDefinitions_;
            bitField0_ = (bitField0_ & ~0x00000002);
            parameterDefinitionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParameterDefinitionsFieldBuilder()
                    : null;
          } else {
            parameterDefinitionsBuilder_.addAllMessages(other.parameterDefinitions_);
          }
        }
      }
      if (!other.getDealCode().isEmpty()) {
        dealCode_ = other.dealCode_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getMarketingInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getSkuFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPlanFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getConstraintsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                com.google.cloud.channel.v1.PriceByResource m =
                    input.readMessage(
                        com.google.cloud.channel.v1.PriceByResource.parser(), extensionRegistry);
                if (priceByResourcesBuilder_ == null) {
                  ensurePriceByResourcesIsMutable();
                  priceByResources_.add(m);
                } else {
                  priceByResourcesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 74:
              {
                com.google.cloud.channel.v1.ParameterDefinition m =
                    input.readMessage(
                        com.google.cloud.channel.v1.ParameterDefinition.parser(),
                        extensionRegistry);
                if (parameterDefinitionsBuilder_ == null) {
                  ensureParameterDefinitionsIsMutable();
                  parameterDefinitions_.add(m);
                } else {
                  parameterDefinitionsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 98:
              {
                dealCode_ = input.readStringRequireUtf8();

                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Resource Name of the Offer.
     * Format: accounts/{account_id}/offers/{offer_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource Name of the Offer.
     * Format: accounts/{account_id}/offers/{offer_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource Name of the Offer.
     * Format: accounts/{account_id}/offers/{offer_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource Name of the Offer.
     * Format: accounts/{account_id}/offers/{offer_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource Name of the Offer.
     * Format: accounts/{account_id}/offers/{offer_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.channel.v1.MarketingInfo marketingInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.MarketingInfo,
            com.google.cloud.channel.v1.MarketingInfo.Builder,
            com.google.cloud.channel.v1.MarketingInfoOrBuilder>
        marketingInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Marketing information for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     *
     * @return Whether the marketingInfo field is set.
     */
    public boolean hasMarketingInfo() {
      return marketingInfoBuilder_ != null || marketingInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Marketing information for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     *
     * @return The marketingInfo.
     */
    public com.google.cloud.channel.v1.MarketingInfo getMarketingInfo() {
      if (marketingInfoBuilder_ == null) {
        return marketingInfo_ == null
            ? com.google.cloud.channel.v1.MarketingInfo.getDefaultInstance()
            : marketingInfo_;
      } else {
        return marketingInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Marketing information for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     */
    public Builder setMarketingInfo(com.google.cloud.channel.v1.MarketingInfo value) {
      if (marketingInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        marketingInfo_ = value;
        onChanged();
      } else {
        marketingInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Marketing information for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     */
    public Builder setMarketingInfo(
        com.google.cloud.channel.v1.MarketingInfo.Builder builderForValue) {
      if (marketingInfoBuilder_ == null) {
        marketingInfo_ = builderForValue.build();
        onChanged();
      } else {
        marketingInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Marketing information for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     */
    public Builder mergeMarketingInfo(com.google.cloud.channel.v1.MarketingInfo value) {
      if (marketingInfoBuilder_ == null) {
        if (marketingInfo_ != null) {
          marketingInfo_ =
              com.google.cloud.channel.v1.MarketingInfo.newBuilder(marketingInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          marketingInfo_ = value;
        }
        onChanged();
      } else {
        marketingInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Marketing information for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     */
    public Builder clearMarketingInfo() {
      if (marketingInfoBuilder_ == null) {
        marketingInfo_ = null;
        onChanged();
      } else {
        marketingInfo_ = null;
        marketingInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Marketing information for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     */
    public com.google.cloud.channel.v1.MarketingInfo.Builder getMarketingInfoBuilder() {

      onChanged();
      return getMarketingInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Marketing information for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     */
    public com.google.cloud.channel.v1.MarketingInfoOrBuilder getMarketingInfoOrBuilder() {
      if (marketingInfoBuilder_ != null) {
        return marketingInfoBuilder_.getMessageOrBuilder();
      } else {
        return marketingInfo_ == null
            ? com.google.cloud.channel.v1.MarketingInfo.getDefaultInstance()
            : marketingInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Marketing information for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.MarketingInfo marketing_info = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.MarketingInfo,
            com.google.cloud.channel.v1.MarketingInfo.Builder,
            com.google.cloud.channel.v1.MarketingInfoOrBuilder>
        getMarketingInfoFieldBuilder() {
      if (marketingInfoBuilder_ == null) {
        marketingInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.MarketingInfo,
                com.google.cloud.channel.v1.MarketingInfo.Builder,
                com.google.cloud.channel.v1.MarketingInfoOrBuilder>(
                getMarketingInfo(), getParentForChildren(), isClean());
        marketingInfo_ = null;
      }
      return marketingInfoBuilder_;
    }

    private com.google.cloud.channel.v1.Sku sku_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Sku,
            com.google.cloud.channel.v1.Sku.Builder,
            com.google.cloud.channel.v1.SkuOrBuilder>
        skuBuilder_;
    /**
     *
     *
     * <pre>
     * SKU the offer is associated with.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
     *
     * @return Whether the sku field is set.
     */
    public boolean hasSku() {
      return skuBuilder_ != null || sku_ != null;
    }
    /**
     *
     *
     * <pre>
     * SKU the offer is associated with.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
     *
     * @return The sku.
     */
    public com.google.cloud.channel.v1.Sku getSku() {
      if (skuBuilder_ == null) {
        return sku_ == null ? com.google.cloud.channel.v1.Sku.getDefaultInstance() : sku_;
      } else {
        return skuBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * SKU the offer is associated with.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
     */
    public Builder setSku(com.google.cloud.channel.v1.Sku value) {
      if (skuBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sku_ = value;
        onChanged();
      } else {
        skuBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * SKU the offer is associated with.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
     */
    public Builder setSku(com.google.cloud.channel.v1.Sku.Builder builderForValue) {
      if (skuBuilder_ == null) {
        sku_ = builderForValue.build();
        onChanged();
      } else {
        skuBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * SKU the offer is associated with.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
     */
    public Builder mergeSku(com.google.cloud.channel.v1.Sku value) {
      if (skuBuilder_ == null) {
        if (sku_ != null) {
          sku_ = com.google.cloud.channel.v1.Sku.newBuilder(sku_).mergeFrom(value).buildPartial();
        } else {
          sku_ = value;
        }
        onChanged();
      } else {
        skuBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * SKU the offer is associated with.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
     */
    public Builder clearSku() {
      if (skuBuilder_ == null) {
        sku_ = null;
        onChanged();
      } else {
        sku_ = null;
        skuBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * SKU the offer is associated with.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
     */
    public com.google.cloud.channel.v1.Sku.Builder getSkuBuilder() {

      onChanged();
      return getSkuFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * SKU the offer is associated with.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
     */
    public com.google.cloud.channel.v1.SkuOrBuilder getSkuOrBuilder() {
      if (skuBuilder_ != null) {
        return skuBuilder_.getMessageOrBuilder();
      } else {
        return sku_ == null ? com.google.cloud.channel.v1.Sku.getDefaultInstance() : sku_;
      }
    }
    /**
     *
     *
     * <pre>
     * SKU the offer is associated with.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Sku sku = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Sku,
            com.google.cloud.channel.v1.Sku.Builder,
            com.google.cloud.channel.v1.SkuOrBuilder>
        getSkuFieldBuilder() {
      if (skuBuilder_ == null) {
        skuBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.Sku,
                com.google.cloud.channel.v1.Sku.Builder,
                com.google.cloud.channel.v1.SkuOrBuilder>(
                getSku(), getParentForChildren(), isClean());
        sku_ = null;
      }
      return skuBuilder_;
    }

    private com.google.cloud.channel.v1.Plan plan_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Plan,
            com.google.cloud.channel.v1.Plan.Builder,
            com.google.cloud.channel.v1.PlanOrBuilder>
        planBuilder_;
    /**
     *
     *
     * <pre>
     * Describes the payment plan for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
     *
     * @return Whether the plan field is set.
     */
    public boolean hasPlan() {
      return planBuilder_ != null || plan_ != null;
    }
    /**
     *
     *
     * <pre>
     * Describes the payment plan for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
     *
     * @return The plan.
     */
    public com.google.cloud.channel.v1.Plan getPlan() {
      if (planBuilder_ == null) {
        return plan_ == null ? com.google.cloud.channel.v1.Plan.getDefaultInstance() : plan_;
      } else {
        return planBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the payment plan for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
     */
    public Builder setPlan(com.google.cloud.channel.v1.Plan value) {
      if (planBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        plan_ = value;
        onChanged();
      } else {
        planBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the payment plan for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
     */
    public Builder setPlan(com.google.cloud.channel.v1.Plan.Builder builderForValue) {
      if (planBuilder_ == null) {
        plan_ = builderForValue.build();
        onChanged();
      } else {
        planBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the payment plan for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
     */
    public Builder mergePlan(com.google.cloud.channel.v1.Plan value) {
      if (planBuilder_ == null) {
        if (plan_ != null) {
          plan_ =
              com.google.cloud.channel.v1.Plan.newBuilder(plan_).mergeFrom(value).buildPartial();
        } else {
          plan_ = value;
        }
        onChanged();
      } else {
        planBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the payment plan for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
     */
    public Builder clearPlan() {
      if (planBuilder_ == null) {
        plan_ = null;
        onChanged();
      } else {
        plan_ = null;
        planBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the payment plan for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
     */
    public com.google.cloud.channel.v1.Plan.Builder getPlanBuilder() {

      onChanged();
      return getPlanFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describes the payment plan for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
     */
    public com.google.cloud.channel.v1.PlanOrBuilder getPlanOrBuilder() {
      if (planBuilder_ != null) {
        return planBuilder_.getMessageOrBuilder();
      } else {
        return plan_ == null ? com.google.cloud.channel.v1.Plan.getDefaultInstance() : plan_;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the payment plan for the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Plan plan = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Plan,
            com.google.cloud.channel.v1.Plan.Builder,
            com.google.cloud.channel.v1.PlanOrBuilder>
        getPlanFieldBuilder() {
      if (planBuilder_ == null) {
        planBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.Plan,
                com.google.cloud.channel.v1.Plan.Builder,
                com.google.cloud.channel.v1.PlanOrBuilder>(
                getPlan(), getParentForChildren(), isClean());
        plan_ = null;
      }
      return planBuilder_;
    }

    private com.google.cloud.channel.v1.Constraints constraints_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Constraints,
            com.google.cloud.channel.v1.Constraints.Builder,
            com.google.cloud.channel.v1.ConstraintsOrBuilder>
        constraintsBuilder_;
    /**
     *
     *
     * <pre>
     * Constraints on transacting the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
     *
     * @return Whether the constraints field is set.
     */
    public boolean hasConstraints() {
      return constraintsBuilder_ != null || constraints_ != null;
    }
    /**
     *
     *
     * <pre>
     * Constraints on transacting the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
     *
     * @return The constraints.
     */
    public com.google.cloud.channel.v1.Constraints getConstraints() {
      if (constraintsBuilder_ == null) {
        return constraints_ == null
            ? com.google.cloud.channel.v1.Constraints.getDefaultInstance()
            : constraints_;
      } else {
        return constraintsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Constraints on transacting the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
     */
    public Builder setConstraints(com.google.cloud.channel.v1.Constraints value) {
      if (constraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        constraints_ = value;
        onChanged();
      } else {
        constraintsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Constraints on transacting the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
     */
    public Builder setConstraints(com.google.cloud.channel.v1.Constraints.Builder builderForValue) {
      if (constraintsBuilder_ == null) {
        constraints_ = builderForValue.build();
        onChanged();
      } else {
        constraintsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Constraints on transacting the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
     */
    public Builder mergeConstraints(com.google.cloud.channel.v1.Constraints value) {
      if (constraintsBuilder_ == null) {
        if (constraints_ != null) {
          constraints_ =
              com.google.cloud.channel.v1.Constraints.newBuilder(constraints_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          constraints_ = value;
        }
        onChanged();
      } else {
        constraintsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Constraints on transacting the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
     */
    public Builder clearConstraints() {
      if (constraintsBuilder_ == null) {
        constraints_ = null;
        onChanged();
      } else {
        constraints_ = null;
        constraintsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Constraints on transacting the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
     */
    public com.google.cloud.channel.v1.Constraints.Builder getConstraintsBuilder() {

      onChanged();
      return getConstraintsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Constraints on transacting the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
     */
    public com.google.cloud.channel.v1.ConstraintsOrBuilder getConstraintsOrBuilder() {
      if (constraintsBuilder_ != null) {
        return constraintsBuilder_.getMessageOrBuilder();
      } else {
        return constraints_ == null
            ? com.google.cloud.channel.v1.Constraints.getDefaultInstance()
            : constraints_;
      }
    }
    /**
     *
     *
     * <pre>
     * Constraints on transacting the Offer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Constraints constraints = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.Constraints,
            com.google.cloud.channel.v1.Constraints.Builder,
            com.google.cloud.channel.v1.ConstraintsOrBuilder>
        getConstraintsFieldBuilder() {
      if (constraintsBuilder_ == null) {
        constraintsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.Constraints,
                com.google.cloud.channel.v1.Constraints.Builder,
                com.google.cloud.channel.v1.ConstraintsOrBuilder>(
                getConstraints(), getParentForChildren(), isClean());
        constraints_ = null;
      }
      return constraintsBuilder_;
    }

    private java.util.List<com.google.cloud.channel.v1.PriceByResource> priceByResources_ =
        java.util.Collections.emptyList();

    private void ensurePriceByResourcesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        priceByResources_ =
            new java.util.ArrayList<com.google.cloud.channel.v1.PriceByResource>(priceByResources_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.PriceByResource,
            com.google.cloud.channel.v1.PriceByResource.Builder,
            com.google.cloud.channel.v1.PriceByResourceOrBuilder>
        priceByResourcesBuilder_;

    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.PriceByResource> getPriceByResourcesList() {
      if (priceByResourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(priceByResources_);
      } else {
        return priceByResourcesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public int getPriceByResourcesCount() {
      if (priceByResourcesBuilder_ == null) {
        return priceByResources_.size();
      } else {
        return priceByResourcesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public com.google.cloud.channel.v1.PriceByResource getPriceByResources(int index) {
      if (priceByResourcesBuilder_ == null) {
        return priceByResources_.get(index);
      } else {
        return priceByResourcesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public Builder setPriceByResources(
        int index, com.google.cloud.channel.v1.PriceByResource value) {
      if (priceByResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePriceByResourcesIsMutable();
        priceByResources_.set(index, value);
        onChanged();
      } else {
        priceByResourcesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public Builder setPriceByResources(
        int index, com.google.cloud.channel.v1.PriceByResource.Builder builderForValue) {
      if (priceByResourcesBuilder_ == null) {
        ensurePriceByResourcesIsMutable();
        priceByResources_.set(index, builderForValue.build());
        onChanged();
      } else {
        priceByResourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public Builder addPriceByResources(com.google.cloud.channel.v1.PriceByResource value) {
      if (priceByResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePriceByResourcesIsMutable();
        priceByResources_.add(value);
        onChanged();
      } else {
        priceByResourcesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public Builder addPriceByResources(
        int index, com.google.cloud.channel.v1.PriceByResource value) {
      if (priceByResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePriceByResourcesIsMutable();
        priceByResources_.add(index, value);
        onChanged();
      } else {
        priceByResourcesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public Builder addPriceByResources(
        com.google.cloud.channel.v1.PriceByResource.Builder builderForValue) {
      if (priceByResourcesBuilder_ == null) {
        ensurePriceByResourcesIsMutable();
        priceByResources_.add(builderForValue.build());
        onChanged();
      } else {
        priceByResourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public Builder addPriceByResources(
        int index, com.google.cloud.channel.v1.PriceByResource.Builder builderForValue) {
      if (priceByResourcesBuilder_ == null) {
        ensurePriceByResourcesIsMutable();
        priceByResources_.add(index, builderForValue.build());
        onChanged();
      } else {
        priceByResourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public Builder addAllPriceByResources(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.PriceByResource> values) {
      if (priceByResourcesBuilder_ == null) {
        ensurePriceByResourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, priceByResources_);
        onChanged();
      } else {
        priceByResourcesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public Builder clearPriceByResources() {
      if (priceByResourcesBuilder_ == null) {
        priceByResources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        priceByResourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public Builder removePriceByResources(int index) {
      if (priceByResourcesBuilder_ == null) {
        ensurePriceByResourcesIsMutable();
        priceByResources_.remove(index);
        onChanged();
      } else {
        priceByResourcesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public com.google.cloud.channel.v1.PriceByResource.Builder getPriceByResourcesBuilder(
        int index) {
      return getPriceByResourcesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public com.google.cloud.channel.v1.PriceByResourceOrBuilder getPriceByResourcesOrBuilder(
        int index) {
      if (priceByResourcesBuilder_ == null) {
        return priceByResources_.get(index);
      } else {
        return priceByResourcesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.channel.v1.PriceByResourceOrBuilder>
        getPriceByResourcesOrBuilderList() {
      if (priceByResourcesBuilder_ != null) {
        return priceByResourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(priceByResources_);
      }
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public com.google.cloud.channel.v1.PriceByResource.Builder addPriceByResourcesBuilder() {
      return getPriceByResourcesFieldBuilder()
          .addBuilder(com.google.cloud.channel.v1.PriceByResource.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public com.google.cloud.channel.v1.PriceByResource.Builder addPriceByResourcesBuilder(
        int index) {
      return getPriceByResourcesFieldBuilder()
          .addBuilder(index, com.google.cloud.channel.v1.PriceByResource.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Price for each monetizable resource type.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PriceByResource price_by_resources = 6;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.PriceByResource.Builder>
        getPriceByResourcesBuilderList() {
      return getPriceByResourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.PriceByResource,
            com.google.cloud.channel.v1.PriceByResource.Builder,
            com.google.cloud.channel.v1.PriceByResourceOrBuilder>
        getPriceByResourcesFieldBuilder() {
      if (priceByResourcesBuilder_ == null) {
        priceByResourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.channel.v1.PriceByResource,
                com.google.cloud.channel.v1.PriceByResource.Builder,
                com.google.cloud.channel.v1.PriceByResourceOrBuilder>(
                priceByResources_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        priceByResources_ = null;
      }
      return priceByResourcesBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Start of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Start of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Start of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Start of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Start of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. End of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. End of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. End of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. End of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. End of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. End of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. End of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. End of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. End of the Offer validity time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private java.util.List<com.google.cloud.channel.v1.ParameterDefinition> parameterDefinitions_ =
        java.util.Collections.emptyList();

    private void ensureParameterDefinitionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        parameterDefinitions_ =
            new java.util.ArrayList<com.google.cloud.channel.v1.ParameterDefinition>(
                parameterDefinitions_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.ParameterDefinition,
            com.google.cloud.channel.v1.ParameterDefinition.Builder,
            com.google.cloud.channel.v1.ParameterDefinitionOrBuilder>
        parameterDefinitionsBuilder_;

    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.ParameterDefinition>
        getParameterDefinitionsList() {
      if (parameterDefinitionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameterDefinitions_);
      } else {
        return parameterDefinitionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public int getParameterDefinitionsCount() {
      if (parameterDefinitionsBuilder_ == null) {
        return parameterDefinitions_.size();
      } else {
        return parameterDefinitionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public com.google.cloud.channel.v1.ParameterDefinition getParameterDefinitions(int index) {
      if (parameterDefinitionsBuilder_ == null) {
        return parameterDefinitions_.get(index);
      } else {
        return parameterDefinitionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public Builder setParameterDefinitions(
        int index, com.google.cloud.channel.v1.ParameterDefinition value) {
      if (parameterDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParameterDefinitionsIsMutable();
        parameterDefinitions_.set(index, value);
        onChanged();
      } else {
        parameterDefinitionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public Builder setParameterDefinitions(
        int index, com.google.cloud.channel.v1.ParameterDefinition.Builder builderForValue) {
      if (parameterDefinitionsBuilder_ == null) {
        ensureParameterDefinitionsIsMutable();
        parameterDefinitions_.set(index, builderForValue.build());
        onChanged();
      } else {
        parameterDefinitionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public Builder addParameterDefinitions(com.google.cloud.channel.v1.ParameterDefinition value) {
      if (parameterDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParameterDefinitionsIsMutable();
        parameterDefinitions_.add(value);
        onChanged();
      } else {
        parameterDefinitionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public Builder addParameterDefinitions(
        int index, com.google.cloud.channel.v1.ParameterDefinition value) {
      if (parameterDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParameterDefinitionsIsMutable();
        parameterDefinitions_.add(index, value);
        onChanged();
      } else {
        parameterDefinitionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public Builder addParameterDefinitions(
        com.google.cloud.channel.v1.ParameterDefinition.Builder builderForValue) {
      if (parameterDefinitionsBuilder_ == null) {
        ensureParameterDefinitionsIsMutable();
        parameterDefinitions_.add(builderForValue.build());
        onChanged();
      } else {
        parameterDefinitionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public Builder addParameterDefinitions(
        int index, com.google.cloud.channel.v1.ParameterDefinition.Builder builderForValue) {
      if (parameterDefinitionsBuilder_ == null) {
        ensureParameterDefinitionsIsMutable();
        parameterDefinitions_.add(index, builderForValue.build());
        onChanged();
      } else {
        parameterDefinitionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public Builder addAllParameterDefinitions(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.ParameterDefinition> values) {
      if (parameterDefinitionsBuilder_ == null) {
        ensureParameterDefinitionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameterDefinitions_);
        onChanged();
      } else {
        parameterDefinitionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public Builder clearParameterDefinitions() {
      if (parameterDefinitionsBuilder_ == null) {
        parameterDefinitions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        parameterDefinitionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public Builder removeParameterDefinitions(int index) {
      if (parameterDefinitionsBuilder_ == null) {
        ensureParameterDefinitionsIsMutable();
        parameterDefinitions_.remove(index);
        onChanged();
      } else {
        parameterDefinitionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public com.google.cloud.channel.v1.ParameterDefinition.Builder getParameterDefinitionsBuilder(
        int index) {
      return getParameterDefinitionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public com.google.cloud.channel.v1.ParameterDefinitionOrBuilder
        getParameterDefinitionsOrBuilder(int index) {
      if (parameterDefinitionsBuilder_ == null) {
        return parameterDefinitions_.get(index);
      } else {
        return parameterDefinitionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.channel.v1.ParameterDefinitionOrBuilder>
        getParameterDefinitionsOrBuilderList() {
      if (parameterDefinitionsBuilder_ != null) {
        return parameterDefinitionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameterDefinitions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public com.google.cloud.channel.v1.ParameterDefinition.Builder
        addParameterDefinitionsBuilder() {
      return getParameterDefinitionsFieldBuilder()
          .addBuilder(com.google.cloud.channel.v1.ParameterDefinition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public com.google.cloud.channel.v1.ParameterDefinition.Builder addParameterDefinitionsBuilder(
        int index) {
      return getParameterDefinitionsFieldBuilder()
          .addBuilder(index, com.google.cloud.channel.v1.ParameterDefinition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Parameters required to use current Offer to purchase.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.ParameterDefinition parameter_definitions = 9;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.ParameterDefinition.Builder>
        getParameterDefinitionsBuilderList() {
      return getParameterDefinitionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.ParameterDefinition,
            com.google.cloud.channel.v1.ParameterDefinition.Builder,
            com.google.cloud.channel.v1.ParameterDefinitionOrBuilder>
        getParameterDefinitionsFieldBuilder() {
      if (parameterDefinitionsBuilder_ == null) {
        parameterDefinitionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.channel.v1.ParameterDefinition,
                com.google.cloud.channel.v1.ParameterDefinition.Builder,
                com.google.cloud.channel.v1.ParameterDefinitionOrBuilder>(
                parameterDefinitions_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        parameterDefinitions_ = null;
      }
      return parameterDefinitionsBuilder_;
    }

    private java.lang.Object dealCode_ = "";
    /**
     *
     *
     * <pre>
     * The deal code of the offer to get a special promotion or discount.
     * </pre>
     *
     * <code>string deal_code = 12;</code>
     *
     * @return The dealCode.
     */
    public java.lang.String getDealCode() {
      java.lang.Object ref = dealCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dealCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The deal code of the offer to get a special promotion or discount.
     * </pre>
     *
     * <code>string deal_code = 12;</code>
     *
     * @return The bytes for dealCode.
     */
    public com.google.protobuf.ByteString getDealCodeBytes() {
      java.lang.Object ref = dealCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dealCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The deal code of the offer to get a special promotion or discount.
     * </pre>
     *
     * <code>string deal_code = 12;</code>
     *
     * @param value The dealCode to set.
     * @return This builder for chaining.
     */
    public Builder setDealCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      dealCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The deal code of the offer to get a special promotion or discount.
     * </pre>
     *
     * <code>string deal_code = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDealCode() {

      dealCode_ = getDefaultInstance().getDealCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The deal code of the offer to get a special promotion or discount.
     * </pre>
     *
     * <code>string deal_code = 12;</code>
     *
     * @param value The bytes for dealCode to set.
     * @return This builder for chaining.
     */
    public Builder setDealCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      dealCode_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.Offer)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.Offer)
  private static final com.google.cloud.channel.v1.Offer DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.Offer();
  }

  public static com.google.cloud.channel.v1.Offer getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Offer> PARSER =
      new com.google.protobuf.AbstractParser<Offer>() {
        @java.lang.Override
        public Offer parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Offer> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Offer> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.Offer getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
