/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/service.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Request message for [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers]
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.ListTransferableOffersRequest}
 */
public final class ListTransferableOffersRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.ListTransferableOffersRequest)
    ListTransferableOffersRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListTransferableOffersRequest.newBuilder() to construct.
  private ListTransferableOffersRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListTransferableOffersRequest() {
    parent_ = "";
    pageToken_ = "";
    sku_ = "";
    languageCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListTransferableOffersRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.ServiceProto
        .internal_static_google_cloud_channel_v1_ListTransferableOffersRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.ServiceProto
        .internal_static_google_cloud_channel_v1_ListTransferableOffersRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.ListTransferableOffersRequest.class,
            com.google.cloud.channel.v1.ListTransferableOffersRequest.Builder.class);
  }

  private int transferredCustomerIdentityCase_ = 0;
  private java.lang.Object transferredCustomerIdentity_;

  public enum TransferredCustomerIdentityCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CLOUD_IDENTITY_ID(4),
    CUSTOMER_NAME(5),
    TRANSFERREDCUSTOMERIDENTITY_NOT_SET(0);
    private final int value;

    private TransferredCustomerIdentityCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransferredCustomerIdentityCase valueOf(int value) {
      return forNumber(value);
    }

    public static TransferredCustomerIdentityCase forNumber(int value) {
      switch (value) {
        case 4:
          return CLOUD_IDENTITY_ID;
        case 5:
          return CUSTOMER_NAME;
        case 0:
          return TRANSFERREDCUSTOMERIDENTITY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TransferredCustomerIdentityCase getTransferredCustomerIdentityCase() {
    return TransferredCustomerIdentityCase.forNumber(transferredCustomerIdentityCase_);
  }

  public static final int CLOUD_IDENTITY_ID_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Customer's Cloud Identity ID
   * </pre>
   *
   * <code>string cloud_identity_id = 4;</code>
   *
   * @return Whether the cloudIdentityId field is set.
   */
  public boolean hasCloudIdentityId() {
    return transferredCustomerIdentityCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Customer's Cloud Identity ID
   * </pre>
   *
   * <code>string cloud_identity_id = 4;</code>
   *
   * @return The cloudIdentityId.
   */
  public java.lang.String getCloudIdentityId() {
    java.lang.Object ref = "";
    if (transferredCustomerIdentityCase_ == 4) {
      ref = transferredCustomerIdentity_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (transferredCustomerIdentityCase_ == 4) {
        transferredCustomerIdentity_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Customer's Cloud Identity ID
   * </pre>
   *
   * <code>string cloud_identity_id = 4;</code>
   *
   * @return The bytes for cloudIdentityId.
   */
  public com.google.protobuf.ByteString getCloudIdentityIdBytes() {
    java.lang.Object ref = "";
    if (transferredCustomerIdentityCase_ == 4) {
      ref = transferredCustomerIdentity_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (transferredCustomerIdentityCase_ == 4) {
        transferredCustomerIdentity_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOMER_NAME_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A reseller should create a customer and use the resource name of
   * that customer here.
   * </pre>
   *
   * <code>string customer_name = 5;</code>
   *
   * @return Whether the customerName field is set.
   */
  public boolean hasCustomerName() {
    return transferredCustomerIdentityCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A reseller should create a customer and use the resource name of
   * that customer here.
   * </pre>
   *
   * <code>string customer_name = 5;</code>
   *
   * @return The customerName.
   */
  public java.lang.String getCustomerName() {
    java.lang.Object ref = "";
    if (transferredCustomerIdentityCase_ == 5) {
      ref = transferredCustomerIdentity_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (transferredCustomerIdentityCase_ == 5) {
        transferredCustomerIdentity_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A reseller should create a customer and use the resource name of
   * that customer here.
   * </pre>
   *
   * <code>string customer_name = 5;</code>
   *
   * @return The bytes for customerName.
   */
  public com.google.protobuf.ByteString getCustomerNameBytes() {
    java.lang.Object ref = "";
    if (transferredCustomerIdentityCase_ == 5) {
      ref = transferredCustomerIdentity_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (transferredCustomerIdentityCase_ == 5) {
        transferredCustomerIdentity_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the reseller's account.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the reseller's account.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 2;
  private int pageSize_;
  /**
   *
   *
   * <pre>
   * Requested page size. Server might return fewer results than requested.
   * If unspecified, returns at most 100 offers.
   * The maximum value is 1000; the server will coerce values above 1000.
   * </pre>
   *
   * <code>int32 page_size = 2;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 3;
  private volatile java.lang.Object pageToken_;
  /**
   *
   *
   * <pre>
   * A token for a page of results other than the first page.
   * Obtained using
   * [ListTransferableOffersResponse.next_page_token][google.cloud.channel.v1.ListTransferableOffersResponse.next_page_token] of the previous
   * [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers] call.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A token for a page of results other than the first page.
   * Obtained using
   * [ListTransferableOffersResponse.next_page_token][google.cloud.channel.v1.ListTransferableOffersResponse.next_page_token] of the previous
   * [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers] call.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SKU_FIELD_NUMBER = 6;
  private volatile java.lang.Object sku_;
  /**
   *
   *
   * <pre>
   * Required. The SKU to look up Offers for.
   * </pre>
   *
   * <code>string sku = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sku.
   */
  @java.lang.Override
  public java.lang.String getSku() {
    java.lang.Object ref = sku_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sku_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The SKU to look up Offers for.
   * </pre>
   *
   * <code>string sku = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sku.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSkuBytes() {
    java.lang.Object ref = sku_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sku_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 7;
  private volatile java.lang.Object languageCode_;
  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code. For example, "en-US". The
   * response will localize in the corresponding language code, if specified.
   * The default value is "en-US".
   * </pre>
   *
   * <code>string language_code = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code. For example, "en-US". The
   * response will localize in the corresponding language code, if specified.
   * The default value is "en-US".
   * </pre>
   *
   * <code>string language_code = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
    }
    if (transferredCustomerIdentityCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, transferredCustomerIdentity_);
    }
    if (transferredCustomerIdentityCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, transferredCustomerIdentity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sku_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, sku_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, languageCode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
    }
    if (transferredCustomerIdentityCase_ == 4) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(4, transferredCustomerIdentity_);
    }
    if (transferredCustomerIdentityCase_ == 5) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(5, transferredCustomerIdentity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sku_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, sku_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, languageCode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.ListTransferableOffersRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.ListTransferableOffersRequest other =
        (com.google.cloud.channel.v1.ListTransferableOffersRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getSku().equals(other.getSku())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getTransferredCustomerIdentityCase().equals(other.getTransferredCustomerIdentityCase()))
      return false;
    switch (transferredCustomerIdentityCase_) {
      case 4:
        if (!getCloudIdentityId().equals(other.getCloudIdentityId())) return false;
        break;
      case 5:
        if (!getCustomerName().equals(other.getCustomerName())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + SKU_FIELD_NUMBER;
    hash = (53 * hash) + getSku().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    switch (transferredCustomerIdentityCase_) {
      case 4:
        hash = (37 * hash) + CLOUD_IDENTITY_ID_FIELD_NUMBER;
        hash = (53 * hash) + getCloudIdentityId().hashCode();
        break;
      case 5:
        hash = (37 * hash) + CUSTOMER_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getCustomerName().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.channel.v1.ListTransferableOffersRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers]
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.ListTransferableOffersRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.ListTransferableOffersRequest)
      com.google.cloud.channel.v1.ListTransferableOffersRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ListTransferableOffersRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ListTransferableOffersRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.ListTransferableOffersRequest.class,
              com.google.cloud.channel.v1.ListTransferableOffersRequest.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.ListTransferableOffersRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      pageSize_ = 0;

      pageToken_ = "";

      sku_ = "";

      languageCode_ = "";

      transferredCustomerIdentityCase_ = 0;
      transferredCustomerIdentity_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ListTransferableOffersRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ListTransferableOffersRequest getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.ListTransferableOffersRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ListTransferableOffersRequest build() {
      com.google.cloud.channel.v1.ListTransferableOffersRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ListTransferableOffersRequest buildPartial() {
      com.google.cloud.channel.v1.ListTransferableOffersRequest result =
          new com.google.cloud.channel.v1.ListTransferableOffersRequest(this);
      if (transferredCustomerIdentityCase_ == 4) {
        result.transferredCustomerIdentity_ = transferredCustomerIdentity_;
      }
      if (transferredCustomerIdentityCase_ == 5) {
        result.transferredCustomerIdentity_ = transferredCustomerIdentity_;
      }
      result.parent_ = parent_;
      result.pageSize_ = pageSize_;
      result.pageToken_ = pageToken_;
      result.sku_ = sku_;
      result.languageCode_ = languageCode_;
      result.transferredCustomerIdentityCase_ = transferredCustomerIdentityCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.ListTransferableOffersRequest) {
        return mergeFrom((com.google.cloud.channel.v1.ListTransferableOffersRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.ListTransferableOffersRequest other) {
      if (other == com.google.cloud.channel.v1.ListTransferableOffersRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        onChanged();
      }
      if (!other.getSku().isEmpty()) {
        sku_ = other.sku_;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        onChanged();
      }
      switch (other.getTransferredCustomerIdentityCase()) {
        case CLOUD_IDENTITY_ID:
          {
            transferredCustomerIdentityCase_ = 4;
            transferredCustomerIdentity_ = other.transferredCustomerIdentity_;
            onChanged();
            break;
          }
        case CUSTOMER_NAME:
          {
            transferredCustomerIdentityCase_ = 5;
            transferredCustomerIdentity_ = other.transferredCustomerIdentity_;
            onChanged();
            break;
          }
        case TRANSFERREDCUSTOMERIDENTITY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                pageSize_ = input.readInt32();

                break;
              } // case 16
            case 26:
              {
                pageToken_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                transferredCustomerIdentityCase_ = 4;
                transferredCustomerIdentity_ = s;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                transferredCustomerIdentityCase_ = 5;
                transferredCustomerIdentity_ = s;
                break;
              } // case 42
            case 50:
              {
                sku_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 58:
              {
                languageCode_ = input.readStringRequireUtf8();

                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int transferredCustomerIdentityCase_ = 0;
    private java.lang.Object transferredCustomerIdentity_;

    public TransferredCustomerIdentityCase getTransferredCustomerIdentityCase() {
      return TransferredCustomerIdentityCase.forNumber(transferredCustomerIdentityCase_);
    }

    public Builder clearTransferredCustomerIdentity() {
      transferredCustomerIdentityCase_ = 0;
      transferredCustomerIdentity_ = null;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 4;</code>
     *
     * @return Whether the cloudIdentityId field is set.
     */
    @java.lang.Override
    public boolean hasCloudIdentityId() {
      return transferredCustomerIdentityCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 4;</code>
     *
     * @return The cloudIdentityId.
     */
    @java.lang.Override
    public java.lang.String getCloudIdentityId() {
      java.lang.Object ref = "";
      if (transferredCustomerIdentityCase_ == 4) {
        ref = transferredCustomerIdentity_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (transferredCustomerIdentityCase_ == 4) {
          transferredCustomerIdentity_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 4;</code>
     *
     * @return The bytes for cloudIdentityId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCloudIdentityIdBytes() {
      java.lang.Object ref = "";
      if (transferredCustomerIdentityCase_ == 4) {
        ref = transferredCustomerIdentity_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (transferredCustomerIdentityCase_ == 4) {
          transferredCustomerIdentity_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 4;</code>
     *
     * @param value The cloudIdentityId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudIdentityId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transferredCustomerIdentityCase_ = 4;
      transferredCustomerIdentity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudIdentityId() {
      if (transferredCustomerIdentityCase_ == 4) {
        transferredCustomerIdentityCase_ = 0;
        transferredCustomerIdentity_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 4;</code>
     *
     * @param value The bytes for cloudIdentityId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudIdentityIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      transferredCustomerIdentityCase_ = 4;
      transferredCustomerIdentity_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A reseller should create a customer and use the resource name of
     * that customer here.
     * </pre>
     *
     * <code>string customer_name = 5;</code>
     *
     * @return Whether the customerName field is set.
     */
    @java.lang.Override
    public boolean hasCustomerName() {
      return transferredCustomerIdentityCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A reseller should create a customer and use the resource name of
     * that customer here.
     * </pre>
     *
     * <code>string customer_name = 5;</code>
     *
     * @return The customerName.
     */
    @java.lang.Override
    public java.lang.String getCustomerName() {
      java.lang.Object ref = "";
      if (transferredCustomerIdentityCase_ == 5) {
        ref = transferredCustomerIdentity_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (transferredCustomerIdentityCase_ == 5) {
          transferredCustomerIdentity_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A reseller should create a customer and use the resource name of
     * that customer here.
     * </pre>
     *
     * <code>string customer_name = 5;</code>
     *
     * @return The bytes for customerName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCustomerNameBytes() {
      java.lang.Object ref = "";
      if (transferredCustomerIdentityCase_ == 5) {
        ref = transferredCustomerIdentity_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (transferredCustomerIdentityCase_ == 5) {
          transferredCustomerIdentity_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A reseller should create a customer and use the resource name of
     * that customer here.
     * </pre>
     *
     * <code>string customer_name = 5;</code>
     *
     * @param value The customerName to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transferredCustomerIdentityCase_ = 5;
      transferredCustomerIdentity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reseller should create a customer and use the resource name of
     * that customer here.
     * </pre>
     *
     * <code>string customer_name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomerName() {
      if (transferredCustomerIdentityCase_ == 5) {
        transferredCustomerIdentityCase_ = 0;
        transferredCustomerIdentity_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reseller should create a customer and use the resource name of
     * that customer here.
     * </pre>
     *
     * <code>string customer_name = 5;</code>
     *
     * @param value The bytes for customerName to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      transferredCustomerIdentityCase_ = 5;
      transferredCustomerIdentity_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's account.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's account.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's account.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's account.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's account.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Requested page size. Server might return fewer results than requested.
     * If unspecified, returns at most 100 offers.
     * The maximum value is 1000; the server will coerce values above 1000.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Requested page size. Server might return fewer results than requested.
     * If unspecified, returns at most 100 offers.
     * The maximum value is 1000; the server will coerce values above 1000.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested page size. Server might return fewer results than requested.
     * If unspecified, returns at most 100 offers.
     * The maximum value is 1000; the server will coerce values above 1000.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {

      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * A token for a page of results other than the first page.
     * Obtained using
     * [ListTransferableOffersResponse.next_page_token][google.cloud.channel.v1.ListTransferableOffersResponse.next_page_token] of the previous
     * [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers] call.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token for a page of results other than the first page.
     * Obtained using
     * [ListTransferableOffersResponse.next_page_token][google.cloud.channel.v1.ListTransferableOffersResponse.next_page_token] of the previous
     * [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers] call.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token for a page of results other than the first page.
     * Obtained using
     * [ListTransferableOffersResponse.next_page_token][google.cloud.channel.v1.ListTransferableOffersResponse.next_page_token] of the previous
     * [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers] call.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token for a page of results other than the first page.
     * Obtained using
     * [ListTransferableOffersResponse.next_page_token][google.cloud.channel.v1.ListTransferableOffersResponse.next_page_token] of the previous
     * [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers] call.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {

      pageToken_ = getDefaultInstance().getPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token for a page of results other than the first page.
     * Obtained using
     * [ListTransferableOffersResponse.next_page_token][google.cloud.channel.v1.ListTransferableOffersResponse.next_page_token] of the previous
     * [CloudChannelService.ListTransferableOffers][google.cloud.channel.v1.CloudChannelService.ListTransferableOffers] call.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pageToken_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object sku_ = "";
    /**
     *
     *
     * <pre>
     * Required. The SKU to look up Offers for.
     * </pre>
     *
     * <code>string sku = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sku.
     */
    public java.lang.String getSku() {
      java.lang.Object ref = sku_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sku_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The SKU to look up Offers for.
     * </pre>
     *
     * <code>string sku = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sku.
     */
    public com.google.protobuf.ByteString getSkuBytes() {
      java.lang.Object ref = sku_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sku_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The SKU to look up Offers for.
     * </pre>
     *
     * <code>string sku = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The sku to set.
     * @return This builder for chaining.
     */
    public Builder setSku(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      sku_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The SKU to look up Offers for.
     * </pre>
     *
     * <code>string sku = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSku() {

      sku_ = getDefaultInstance().getSku();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The SKU to look up Offers for.
     * </pre>
     *
     * <code>string sku = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for sku to set.
     * @return This builder for chaining.
     */
    public Builder setSkuBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      sku_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code. For example, "en-US". The
     * response will localize in the corresponding language code, if specified.
     * The default value is "en-US".
     * </pre>
     *
     * <code>string language_code = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code. For example, "en-US". The
     * response will localize in the corresponding language code, if specified.
     * The default value is "en-US".
     * </pre>
     *
     * <code>string language_code = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code. For example, "en-US". The
     * response will localize in the corresponding language code, if specified.
     * The default value is "en-US".
     * </pre>
     *
     * <code>string language_code = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      languageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code. For example, "en-US". The
     * response will localize in the corresponding language code, if specified.
     * The default value is "en-US".
     * </pre>
     *
     * <code>string language_code = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {

      languageCode_ = getDefaultInstance().getLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code. For example, "en-US". The
     * response will localize in the corresponding language code, if specified.
     * The default value is "en-US".
     * </pre>
     *
     * <code>string language_code = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      languageCode_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.ListTransferableOffersRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.ListTransferableOffersRequest)
  private static final com.google.cloud.channel.v1.ListTransferableOffersRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.ListTransferableOffersRequest();
  }

  public static com.google.cloud.channel.v1.ListTransferableOffersRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListTransferableOffersRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListTransferableOffersRequest>() {
        @java.lang.Override
        public ListTransferableOffersRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListTransferableOffersRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListTransferableOffersRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.ListTransferableOffersRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
