/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/service.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Request message for ListPurchasableSkus.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.ListPurchasableSkusRequest}
 */
public final class ListPurchasableSkusRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.ListPurchasableSkusRequest)
    ListPurchasableSkusRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListPurchasableSkusRequest.newBuilder() to construct.
  private ListPurchasableSkusRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListPurchasableSkusRequest() {
    customer_ = "";
    pageToken_ = "";
    languageCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListPurchasableSkusRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.ServiceProto
        .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.ServiceProto
        .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.class,
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.Builder.class);
  }

  public interface CreateEntitlementPurchaseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. List SKUs belonging to this Product.
     * Format: products/{product_id}.
     * Supports products/- to retrieve SKUs for all products.
     * </pre>
     *
     * <code>string product = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The product.
     */
    java.lang.String getProduct();
    /**
     *
     *
     * <pre>
     * Required. List SKUs belonging to this Product.
     * Format: products/{product_id}.
     * Supports products/- to retrieve SKUs for all products.
     * </pre>
     *
     * <code>string product = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for product.
     */
    com.google.protobuf.ByteString getProductBytes();
  }
  /**
   *
   *
   * <pre>
   * List SKUs for a new entitlement. Make the purchase using
   * [CloudChannelService.CreateEntitlement][google.cloud.channel.v1.CloudChannelService.CreateEntitlement].
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase}
   */
  public static final class CreateEntitlementPurchase extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
      CreateEntitlementPurchaseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CreateEntitlementPurchase.newBuilder() to construct.
    private CreateEntitlementPurchase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CreateEntitlementPurchase() {
      product_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CreateEntitlementPurchase();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_CreateEntitlementPurchase_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_CreateEntitlementPurchase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
                  .class,
              com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
                  .Builder.class);
    }

    public static final int PRODUCT_FIELD_NUMBER = 1;
    private volatile java.lang.Object product_;
    /**
     *
     *
     * <pre>
     * Required. List SKUs belonging to this Product.
     * Format: products/{product_id}.
     * Supports products/- to retrieve SKUs for all products.
     * </pre>
     *
     * <code>string product = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The product.
     */
    @java.lang.Override
    public java.lang.String getProduct() {
      java.lang.Object ref = product_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        product_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List SKUs belonging to this Product.
     * Format: products/{product_id}.
     * Supports products/- to retrieve SKUs for all products.
     * </pre>
     *
     * <code>string product = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for product.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProductBytes() {
      java.lang.Object ref = product_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        product_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(product_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, product_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(product_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, product_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)) {
        return super.equals(obj);
      }
      com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase other =
          (com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase) obj;

      if (!getProduct().equals(other.getProduct())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
      hash = (53 * hash) + getProduct().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for a new entitlement. Make the purchase using
     * [CloudChannelService.CreateEntitlement][google.cloud.channel.v1.CloudChannelService.CreateEntitlement].
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchaseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.channel.v1.ServiceProto
            .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_CreateEntitlementPurchase_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.channel.v1.ServiceProto
            .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_CreateEntitlementPurchase_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
                    .class,
                com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        product_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.channel.v1.ServiceProto
            .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_CreateEntitlementPurchase_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
          getDefaultInstanceForType() {
        return com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
          build() {
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
          buildPartial() {
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase result =
            new com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase(
                this);
        result.product_ = product_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase) {
          return mergeFrom(
              (com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase other) {
        if (other
            == com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
                .getDefaultInstance()) return this;
        if (!other.getProduct().isEmpty()) {
          product_ = other.product_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  product_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object product_ = "";
      /**
       *
       *
       * <pre>
       * Required. List SKUs belonging to this Product.
       * Format: products/{product_id}.
       * Supports products/- to retrieve SKUs for all products.
       * </pre>
       *
       * <code>string product = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The product.
       */
      public java.lang.String getProduct() {
        java.lang.Object ref = product_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          product_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List SKUs belonging to this Product.
       * Format: products/{product_id}.
       * Supports products/- to retrieve SKUs for all products.
       * </pre>
       *
       * <code>string product = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for product.
       */
      public com.google.protobuf.ByteString getProductBytes() {
        java.lang.Object ref = product_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          product_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List SKUs belonging to this Product.
       * Format: products/{product_id}.
       * Supports products/- to retrieve SKUs for all products.
       * </pre>
       *
       * <code>string product = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The product to set.
       * @return This builder for chaining.
       */
      public Builder setProduct(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        product_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List SKUs belonging to this Product.
       * Format: products/{product_id}.
       * Supports products/- to retrieve SKUs for all products.
       * </pre>
       *
       * <code>string product = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProduct() {

        product_ = getDefaultInstance().getProduct();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List SKUs belonging to this Product.
       * Format: products/{product_id}.
       * Supports products/- to retrieve SKUs for all products.
       * </pre>
       *
       * <code>string product = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for product to set.
       * @return This builder for chaining.
       */
      public Builder setProductBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        product_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
    private static final com.google.cloud.channel.v1.ListPurchasableSkusRequest
            .CreateEntitlementPurchase
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase();
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CreateEntitlementPurchase> PARSER =
        new com.google.protobuf.AbstractParser<CreateEntitlementPurchase>() {
          @java.lang.Override
          public CreateEntitlementPurchase parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CreateEntitlementPurchase> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CreateEntitlementPurchase> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ChangeOfferPurchaseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Resource name of the entitlement.
     * Format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The entitlement.
     */
    java.lang.String getEntitlement();
    /**
     *
     *
     * <pre>
     * Required. Resource name of the entitlement.
     * Format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for entitlement.
     */
    com.google.protobuf.ByteString getEntitlementBytes();

    /**
     *
     *
     * <pre>
     * Required. Change Type for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for changeType.
     */
    int getChangeTypeValue();
    /**
     *
     *
     * <pre>
     * Required. Change Type for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The changeType.
     */
    com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
        getChangeType();
  }
  /**
   *
   *
   * <pre>
   * List SKUs for upgrading or downgrading an entitlement. Make the purchase
   * using [CloudChannelService.ChangeOffer][google.cloud.channel.v1.CloudChannelService.ChangeOffer].
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase}
   */
  public static final class ChangeOfferPurchase extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
      ChangeOfferPurchaseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ChangeOfferPurchase.newBuilder() to construct.
    private ChangeOfferPurchase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ChangeOfferPurchase() {
      entitlement_ = "";
      changeType_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ChangeOfferPurchase();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_ChangeOfferPurchase_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_ChangeOfferPurchase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.class,
              com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Change Type enum.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType}
     */
    public enum ChangeType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Not used.
       * </pre>
       *
       * <code>CHANGE_TYPE_UNSPECIFIED = 0;</code>
       */
      CHANGE_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * SKU is an upgrade on the current entitlement.
       * </pre>
       *
       * <code>UPGRADE = 1;</code>
       */
      UPGRADE(1),
      /**
       *
       *
       * <pre>
       * SKU is a downgrade on the current entitlement.
       * </pre>
       *
       * <code>DOWNGRADE = 2;</code>
       */
      DOWNGRADE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Not used.
       * </pre>
       *
       * <code>CHANGE_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int CHANGE_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * SKU is an upgrade on the current entitlement.
       * </pre>
       *
       * <code>UPGRADE = 1;</code>
       */
      public static final int UPGRADE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * SKU is a downgrade on the current entitlement.
       * </pre>
       *
       * <code>DOWNGRADE = 2;</code>
       */
      public static final int DOWNGRADE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ChangeType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ChangeType forNumber(int value) {
        switch (value) {
          case 0:
            return CHANGE_TYPE_UNSPECIFIED;
          case 1:
            return UPGRADE;
          case 2:
            return DOWNGRADE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ChangeType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ChangeType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ChangeType>() {
            public ChangeType findValueByNumber(int number) {
              return ChangeType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ChangeType[] VALUES = values();

      public static ChangeType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ChangeType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType)
    }

    public static final int ENTITLEMENT_FIELD_NUMBER = 1;
    private volatile java.lang.Object entitlement_;
    /**
     *
     *
     * <pre>
     * Required. Resource name of the entitlement.
     * Format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The entitlement.
     */
    @java.lang.Override
    public java.lang.String getEntitlement() {
      java.lang.Object ref = entitlement_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entitlement_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name of the entitlement.
     * Format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for entitlement.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntitlementBytes() {
      java.lang.Object ref = entitlement_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entitlement_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CHANGE_TYPE_FIELD_NUMBER = 2;
    private int changeType_;
    /**
     *
     *
     * <pre>
     * Required. Change Type for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for changeType.
     */
    @java.lang.Override
    public int getChangeTypeValue() {
      return changeType_;
    }
    /**
     *
     *
     * <pre>
     * Required. Change Type for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The changeType.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
        getChangeType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType result =
          com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
              .valueOf(changeType_);
      return result == null
          ? com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entitlement_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, entitlement_);
      }
      if (changeType_
          != com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
              .CHANGE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, changeType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entitlement_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, entitlement_);
      }
      if (changeType_
          != com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
              .CHANGE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, changeType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)) {
        return super.equals(obj);
      }
      com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase other =
          (com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase) obj;

      if (!getEntitlement().equals(other.getEntitlement())) return false;
      if (changeType_ != other.changeType_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENTITLEMENT_FIELD_NUMBER;
      hash = (53 * hash) + getEntitlement().hashCode();
      hash = (37 * hash) + CHANGE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + changeType_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for upgrading or downgrading an entitlement. Make the purchase
     * using [CloudChannelService.ChangeOffer][google.cloud.channel.v1.CloudChannelService.ChangeOffer].
     * </pre>
     *
     * Protobuf type {@code google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchaseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.channel.v1.ServiceProto
            .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_ChangeOfferPurchase_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.channel.v1.ServiceProto
            .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_ChangeOfferPurchase_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.class,
                com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        entitlement_ = "";

        changeType_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.channel.v1.ServiceProto
            .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_ChangeOfferPurchase_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
          getDefaultInstanceForType() {
        return com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase build() {
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
          buildPartial() {
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase result =
            new com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase(this);
        result.entitlement_ = entitlement_;
        result.changeType_ = changeType_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase) {
          return mergeFrom(
              (com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase other) {
        if (other
            == com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
                .getDefaultInstance()) return this;
        if (!other.getEntitlement().isEmpty()) {
          entitlement_ = other.entitlement_;
          onChanged();
        }
        if (other.changeType_ != 0) {
          setChangeTypeValue(other.getChangeTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  entitlement_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 16:
                {
                  changeType_ = input.readEnum();

                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object entitlement_ = "";
      /**
       *
       *
       * <pre>
       * Required. Resource name of the entitlement.
       * Format:
       * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
       * </pre>
       *
       * <code>string entitlement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The entitlement.
       */
      public java.lang.String getEntitlement() {
        java.lang.Object ref = entitlement_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entitlement_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Resource name of the entitlement.
       * Format:
       * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
       * </pre>
       *
       * <code>string entitlement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for entitlement.
       */
      public com.google.protobuf.ByteString getEntitlementBytes() {
        java.lang.Object ref = entitlement_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entitlement_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Resource name of the entitlement.
       * Format:
       * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
       * </pre>
       *
       * <code>string entitlement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The entitlement to set.
       * @return This builder for chaining.
       */
      public Builder setEntitlement(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        entitlement_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Resource name of the entitlement.
       * Format:
       * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
       * </pre>
       *
       * <code>string entitlement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEntitlement() {

        entitlement_ = getDefaultInstance().getEntitlement();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Resource name of the entitlement.
       * Format:
       * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
       * </pre>
       *
       * <code>string entitlement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for entitlement to set.
       * @return This builder for chaining.
       */
      public Builder setEntitlementBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        entitlement_ = value;
        onChanged();
        return this;
      }

      private int changeType_ = 0;
      /**
       *
       *
       * <pre>
       * Required. Change Type for the entitlement.
       * </pre>
       *
       * <code>
       * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for changeType.
       */
      @java.lang.Override
      public int getChangeTypeValue() {
        return changeType_;
      }
      /**
       *
       *
       * <pre>
       * Required. Change Type for the entitlement.
       * </pre>
       *
       * <code>
       * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for changeType to set.
       * @return This builder for chaining.
       */
      public Builder setChangeTypeValue(int value) {

        changeType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Change Type for the entitlement.
       * </pre>
       *
       * <code>
       * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The changeType.
       */
      @java.lang.Override
      public com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
          getChangeType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
            result =
                com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
                    .ChangeType.valueOf(changeType_);
        return result == null
            ? com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. Change Type for the entitlement.
       * </pre>
       *
       * <code>
       * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The changeType to set.
       * @return This builder for chaining.
       */
      public Builder setChangeType(
          com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType
              value) {
        if (value == null) {
          throw new NullPointerException();
        }

        changeType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Change Type for the entitlement.
       * </pre>
       *
       * <code>
       * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.ChangeType change_type = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearChangeType() {

        changeType_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
    private static final com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase();
    }

    public static com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ChangeOfferPurchase> PARSER =
        new com.google.protobuf.AbstractParser<ChangeOfferPurchase>() {
          @java.lang.Override
          public ChangeOfferPurchase parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ChangeOfferPurchase> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ChangeOfferPurchase> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int purchaseOptionCase_ = 0;
  private java.lang.Object purchaseOption_;

  public enum PurchaseOptionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CREATE_ENTITLEMENT_PURCHASE(2),
    CHANGE_OFFER_PURCHASE(3),
    PURCHASEOPTION_NOT_SET(0);
    private final int value;

    private PurchaseOptionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PurchaseOptionCase valueOf(int value) {
      return forNumber(value);
    }

    public static PurchaseOptionCase forNumber(int value) {
      switch (value) {
        case 2:
          return CREATE_ENTITLEMENT_PURCHASE;
        case 3:
          return CHANGE_OFFER_PURCHASE;
        case 0:
          return PURCHASEOPTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PurchaseOptionCase getPurchaseOptionCase() {
    return PurchaseOptionCase.forNumber(purchaseOptionCase_);
  }

  public static final int CREATE_ENTITLEMENT_PURCHASE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * List SKUs for CreateEntitlement purchase.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
   * </code>
   *
   * @return Whether the createEntitlementPurchase field is set.
   */
  @java.lang.Override
  public boolean hasCreateEntitlementPurchase() {
    return purchaseOptionCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * List SKUs for CreateEntitlement purchase.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
   * </code>
   *
   * @return The createEntitlementPurchase.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
      getCreateEntitlementPurchase() {
    if (purchaseOptionCase_ == 2) {
      return (com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
          purchaseOption_;
    }
    return com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * List SKUs for CreateEntitlement purchase.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchaseOrBuilder
      getCreateEntitlementPurchaseOrBuilder() {
    if (purchaseOptionCase_ == 2) {
      return (com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
          purchaseOption_;
    }
    return com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        .getDefaultInstance();
  }

  public static final int CHANGE_OFFER_PURCHASE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * List SKUs for ChangeOffer purchase with a new SKU.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
   * </code>
   *
   * @return Whether the changeOfferPurchase field is set.
   */
  @java.lang.Override
  public boolean hasChangeOfferPurchase() {
    return purchaseOptionCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * List SKUs for ChangeOffer purchase with a new SKU.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
   * </code>
   *
   * @return The changeOfferPurchase.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
      getChangeOfferPurchase() {
    if (purchaseOptionCase_ == 3) {
      return (com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
          purchaseOption_;
    }
    return com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * List SKUs for ChangeOffer purchase with a new SKU.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchaseOrBuilder
      getChangeOfferPurchaseOrBuilder() {
    if (purchaseOptionCase_ == 3) {
      return (com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
          purchaseOption_;
    }
    return com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        .getDefaultInstance();
  }

  public static final int CUSTOMER_FIELD_NUMBER = 1;
  private volatile java.lang.Object customer_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the customer to list SKUs for.
   * Format: accounts/{account_id}/customers/{customer_id}.
   * </pre>
   *
   * <code>
   * string customer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The customer.
   */
  @java.lang.Override
  public java.lang.String getCustomer() {
    java.lang.Object ref = customer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the customer to list SKUs for.
   * Format: accounts/{account_id}/customers/{customer_id}.
   * </pre>
   *
   * <code>
   * string customer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for customer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomerBytes() {
    java.lang.Object ref = customer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 4;
  private int pageSize_;
  /**
   *
   *
   * <pre>
   * Optional. Requested page size. Server might return fewer results than requested.
   * If unspecified, returns at most 100 SKUs.
   * The maximum value is 1000; the server will coerce values above 1000.
   * </pre>
   *
   * <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 5;
  private volatile java.lang.Object pageToken_;
  /**
   *
   *
   * <pre>
   * Optional. A token for a page of results other than the first page.
   * </pre>
   *
   * <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A token for a page of results other than the first page.
   * </pre>
   *
   * <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 6;
  private volatile java.lang.Object languageCode_;
  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code. For example, "en-US". The
   * response will localize in the corresponding language code, if specified.
   * The default value is "en-US".
   * </pre>
   *
   * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code. For example, "en-US". The
   * response will localize in the corresponding language code, if specified.
   * The default value is "en-US".
   * </pre>
   *
   * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, customer_);
    }
    if (purchaseOptionCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
              purchaseOption_);
    }
    if (purchaseOptionCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
              purchaseOption_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(4, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, languageCode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, customer_);
    }
    if (purchaseOptionCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
                  purchaseOption_);
    }
    if (purchaseOptionCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
                  purchaseOption_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, languageCode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.ListPurchasableSkusRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.ListPurchasableSkusRequest other =
        (com.google.cloud.channel.v1.ListPurchasableSkusRequest) obj;

    if (!getCustomer().equals(other.getCustomer())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getPurchaseOptionCase().equals(other.getPurchaseOptionCase())) return false;
    switch (purchaseOptionCase_) {
      case 2:
        if (!getCreateEntitlementPurchase().equals(other.getCreateEntitlementPurchase()))
          return false;
        break;
      case 3:
        if (!getChangeOfferPurchase().equals(other.getChangeOfferPurchase())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CUSTOMER_FIELD_NUMBER;
    hash = (53 * hash) + getCustomer().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    switch (purchaseOptionCase_) {
      case 2:
        hash = (37 * hash) + CREATE_ENTITLEMENT_PURCHASE_FIELD_NUMBER;
        hash = (53 * hash) + getCreateEntitlementPurchase().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CHANGE_OFFER_PURCHASE_FIELD_NUMBER;
        hash = (53 * hash) + getChangeOfferPurchase().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.channel.v1.ListPurchasableSkusRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for ListPurchasableSkus.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.ListPurchasableSkusRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.ListPurchasableSkusRequest)
      com.google.cloud.channel.v1.ListPurchasableSkusRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.ListPurchasableSkusRequest.class,
              com.google.cloud.channel.v1.ListPurchasableSkusRequest.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.ListPurchasableSkusRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (createEntitlementPurchaseBuilder_ != null) {
        createEntitlementPurchaseBuilder_.clear();
      }
      if (changeOfferPurchaseBuilder_ != null) {
        changeOfferPurchaseBuilder_.clear();
      }
      customer_ = "";

      pageSize_ = 0;

      pageToken_ = "";

      languageCode_ = "";

      purchaseOptionCase_ = 0;
      purchaseOption_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ListPurchasableSkusRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.ListPurchasableSkusRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest build() {
      com.google.cloud.channel.v1.ListPurchasableSkusRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest buildPartial() {
      com.google.cloud.channel.v1.ListPurchasableSkusRequest result =
          new com.google.cloud.channel.v1.ListPurchasableSkusRequest(this);
      if (purchaseOptionCase_ == 2) {
        if (createEntitlementPurchaseBuilder_ == null) {
          result.purchaseOption_ = purchaseOption_;
        } else {
          result.purchaseOption_ = createEntitlementPurchaseBuilder_.build();
        }
      }
      if (purchaseOptionCase_ == 3) {
        if (changeOfferPurchaseBuilder_ == null) {
          result.purchaseOption_ = purchaseOption_;
        } else {
          result.purchaseOption_ = changeOfferPurchaseBuilder_.build();
        }
      }
      result.customer_ = customer_;
      result.pageSize_ = pageSize_;
      result.pageToken_ = pageToken_;
      result.languageCode_ = languageCode_;
      result.purchaseOptionCase_ = purchaseOptionCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.ListPurchasableSkusRequest) {
        return mergeFrom((com.google.cloud.channel.v1.ListPurchasableSkusRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.ListPurchasableSkusRequest other) {
      if (other == com.google.cloud.channel.v1.ListPurchasableSkusRequest.getDefaultInstance())
        return this;
      if (!other.getCustomer().isEmpty()) {
        customer_ = other.customer_;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        onChanged();
      }
      switch (other.getPurchaseOptionCase()) {
        case CREATE_ENTITLEMENT_PURCHASE:
          {
            mergeCreateEntitlementPurchase(other.getCreateEntitlementPurchase());
            break;
          }
        case CHANGE_OFFER_PURCHASE:
          {
            mergeChangeOfferPurchase(other.getChangeOfferPurchase());
            break;
          }
        case PURCHASEOPTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                customer_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getCreateEntitlementPurchaseFieldBuilder().getBuilder(), extensionRegistry);
                purchaseOptionCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getChangeOfferPurchaseFieldBuilder().getBuilder(), extensionRegistry);
                purchaseOptionCase_ = 3;
                break;
              } // case 26
            case 32:
              {
                pageSize_ = input.readInt32();

                break;
              } // case 32
            case 42:
              {
                pageToken_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                languageCode_ = input.readStringRequireUtf8();

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int purchaseOptionCase_ = 0;
    private java.lang.Object purchaseOption_;

    public PurchaseOptionCase getPurchaseOptionCase() {
      return PurchaseOptionCase.forNumber(purchaseOptionCase_);
    }

    public Builder clearPurchaseOption() {
      purchaseOptionCase_ = 0;
      purchaseOption_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase,
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
                .Builder,
            com.google.cloud.channel.v1.ListPurchasableSkusRequest
                .CreateEntitlementPurchaseOrBuilder>
        createEntitlementPurchaseBuilder_;
    /**
     *
     *
     * <pre>
     * List SKUs for CreateEntitlement purchase.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
     * </code>
     *
     * @return Whether the createEntitlementPurchase field is set.
     */
    @java.lang.Override
    public boolean hasCreateEntitlementPurchase() {
      return purchaseOptionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for CreateEntitlement purchase.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
     * </code>
     *
     * @return The createEntitlementPurchase.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
        getCreateEntitlementPurchase() {
      if (createEntitlementPurchaseBuilder_ == null) {
        if (purchaseOptionCase_ == 2) {
          return (com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
              purchaseOption_;
        }
        return com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
            .getDefaultInstance();
      } else {
        if (purchaseOptionCase_ == 2) {
          return createEntitlementPurchaseBuilder_.getMessage();
        }
        return com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * List SKUs for CreateEntitlement purchase.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
     * </code>
     */
    public Builder setCreateEntitlementPurchase(
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase value) {
      if (createEntitlementPurchaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        purchaseOption_ = value;
        onChanged();
      } else {
        createEntitlementPurchaseBuilder_.setMessage(value);
      }
      purchaseOptionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for CreateEntitlement purchase.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
     * </code>
     */
    public Builder setCreateEntitlementPurchase(
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase.Builder
            builderForValue) {
      if (createEntitlementPurchaseBuilder_ == null) {
        purchaseOption_ = builderForValue.build();
        onChanged();
      } else {
        createEntitlementPurchaseBuilder_.setMessage(builderForValue.build());
      }
      purchaseOptionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for CreateEntitlement purchase.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
     * </code>
     */
    public Builder mergeCreateEntitlementPurchase(
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase value) {
      if (createEntitlementPurchaseBuilder_ == null) {
        if (purchaseOptionCase_ == 2
            && purchaseOption_
                != com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
                    .getDefaultInstance()) {
          purchaseOption_ =
              com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
                  .newBuilder(
                      (com.google.cloud.channel.v1.ListPurchasableSkusRequest
                              .CreateEntitlementPurchase)
                          purchaseOption_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          purchaseOption_ = value;
        }
        onChanged();
      } else {
        if (purchaseOptionCase_ == 2) {
          createEntitlementPurchaseBuilder_.mergeFrom(value);
        } else {
          createEntitlementPurchaseBuilder_.setMessage(value);
        }
      }
      purchaseOptionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for CreateEntitlement purchase.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
     * </code>
     */
    public Builder clearCreateEntitlementPurchase() {
      if (createEntitlementPurchaseBuilder_ == null) {
        if (purchaseOptionCase_ == 2) {
          purchaseOptionCase_ = 0;
          purchaseOption_ = null;
          onChanged();
        }
      } else {
        if (purchaseOptionCase_ == 2) {
          purchaseOptionCase_ = 0;
          purchaseOption_ = null;
        }
        createEntitlementPurchaseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for CreateEntitlement purchase.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
     * </code>
     */
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase.Builder
        getCreateEntitlementPurchaseBuilder() {
      return getCreateEntitlementPurchaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * List SKUs for CreateEntitlement purchase.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchaseOrBuilder
        getCreateEntitlementPurchaseOrBuilder() {
      if ((purchaseOptionCase_ == 2) && (createEntitlementPurchaseBuilder_ != null)) {
        return createEntitlementPurchaseBuilder_.getMessageOrBuilder();
      } else {
        if (purchaseOptionCase_ == 2) {
          return (com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
              purchaseOption_;
        }
        return com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * List SKUs for CreateEntitlement purchase.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase create_entitlement_purchase = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase,
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
                .Builder,
            com.google.cloud.channel.v1.ListPurchasableSkusRequest
                .CreateEntitlementPurchaseOrBuilder>
        getCreateEntitlementPurchaseFieldBuilder() {
      if (createEntitlementPurchaseBuilder_ == null) {
        if (!(purchaseOptionCase_ == 2)) {
          purchaseOption_ =
              com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
                  .getDefaultInstance();
        }
        createEntitlementPurchaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase,
                com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase
                    .Builder,
                com.google.cloud.channel.v1.ListPurchasableSkusRequest
                    .CreateEntitlementPurchaseOrBuilder>(
                (com.google.cloud.channel.v1.ListPurchasableSkusRequest.CreateEntitlementPurchase)
                    purchaseOption_,
                getParentForChildren(),
                isClean());
        purchaseOption_ = null;
      }
      purchaseOptionCase_ = 2;
      onChanged();
      ;
      return createEntitlementPurchaseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase,
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.Builder,
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchaseOrBuilder>
        changeOfferPurchaseBuilder_;
    /**
     *
     *
     * <pre>
     * List SKUs for ChangeOffer purchase with a new SKU.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
     * </code>
     *
     * @return Whether the changeOfferPurchase field is set.
     */
    @java.lang.Override
    public boolean hasChangeOfferPurchase() {
      return purchaseOptionCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for ChangeOffer purchase with a new SKU.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
     * </code>
     *
     * @return The changeOfferPurchase.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
        getChangeOfferPurchase() {
      if (changeOfferPurchaseBuilder_ == null) {
        if (purchaseOptionCase_ == 3) {
          return (com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
              purchaseOption_;
        }
        return com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
            .getDefaultInstance();
      } else {
        if (purchaseOptionCase_ == 3) {
          return changeOfferPurchaseBuilder_.getMessage();
        }
        return com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * List SKUs for ChangeOffer purchase with a new SKU.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
     * </code>
     */
    public Builder setChangeOfferPurchase(
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase value) {
      if (changeOfferPurchaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        purchaseOption_ = value;
        onChanged();
      } else {
        changeOfferPurchaseBuilder_.setMessage(value);
      }
      purchaseOptionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for ChangeOffer purchase with a new SKU.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
     * </code>
     */
    public Builder setChangeOfferPurchase(
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.Builder
            builderForValue) {
      if (changeOfferPurchaseBuilder_ == null) {
        purchaseOption_ = builderForValue.build();
        onChanged();
      } else {
        changeOfferPurchaseBuilder_.setMessage(builderForValue.build());
      }
      purchaseOptionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for ChangeOffer purchase with a new SKU.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
     * </code>
     */
    public Builder mergeChangeOfferPurchase(
        com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase value) {
      if (changeOfferPurchaseBuilder_ == null) {
        if (purchaseOptionCase_ == 3
            && purchaseOption_
                != com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
                    .getDefaultInstance()) {
          purchaseOption_ =
              com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.newBuilder(
                      (com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
                          purchaseOption_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          purchaseOption_ = value;
        }
        onChanged();
      } else {
        if (purchaseOptionCase_ == 3) {
          changeOfferPurchaseBuilder_.mergeFrom(value);
        } else {
          changeOfferPurchaseBuilder_.setMessage(value);
        }
      }
      purchaseOptionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for ChangeOffer purchase with a new SKU.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
     * </code>
     */
    public Builder clearChangeOfferPurchase() {
      if (changeOfferPurchaseBuilder_ == null) {
        if (purchaseOptionCase_ == 3) {
          purchaseOptionCase_ = 0;
          purchaseOption_ = null;
          onChanged();
        }
      } else {
        if (purchaseOptionCase_ == 3) {
          purchaseOptionCase_ = 0;
          purchaseOption_ = null;
        }
        changeOfferPurchaseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List SKUs for ChangeOffer purchase with a new SKU.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
     * </code>
     */
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.Builder
        getChangeOfferPurchaseBuilder() {
      return getChangeOfferPurchaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * List SKUs for ChangeOffer purchase with a new SKU.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchaseOrBuilder
        getChangeOfferPurchaseOrBuilder() {
      if ((purchaseOptionCase_ == 3) && (changeOfferPurchaseBuilder_ != null)) {
        return changeOfferPurchaseBuilder_.getMessageOrBuilder();
      } else {
        if (purchaseOptionCase_ == 3) {
          return (com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
              purchaseOption_;
        }
        return com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * List SKUs for ChangeOffer purchase with a new SKU.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase change_offer_purchase = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase,
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.Builder,
            com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchaseOrBuilder>
        getChangeOfferPurchaseFieldBuilder() {
      if (changeOfferPurchaseBuilder_ == null) {
        if (!(purchaseOptionCase_ == 3)) {
          purchaseOption_ =
              com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase
                  .getDefaultInstance();
        }
        changeOfferPurchaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase,
                com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase.Builder,
                com.google.cloud.channel.v1.ListPurchasableSkusRequest
                    .ChangeOfferPurchaseOrBuilder>(
                (com.google.cloud.channel.v1.ListPurchasableSkusRequest.ChangeOfferPurchase)
                    purchaseOption_,
                getParentForChildren(),
                isClean());
        purchaseOption_ = null;
      }
      purchaseOptionCase_ = 3;
      onChanged();
      ;
      return changeOfferPurchaseBuilder_;
    }

    private java.lang.Object customer_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the customer to list SKUs for.
     * Format: accounts/{account_id}/customers/{customer_id}.
     * </pre>
     *
     * <code>
     * string customer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The customer.
     */
    public java.lang.String getCustomer() {
      java.lang.Object ref = customer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the customer to list SKUs for.
     * Format: accounts/{account_id}/customers/{customer_id}.
     * </pre>
     *
     * <code>
     * string customer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for customer.
     */
    public com.google.protobuf.ByteString getCustomerBytes() {
      java.lang.Object ref = customer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the customer to list SKUs for.
     * Format: accounts/{account_id}/customers/{customer_id}.
     * </pre>
     *
     * <code>
     * string customer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The customer to set.
     * @return This builder for chaining.
     */
    public Builder setCustomer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      customer_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the customer to list SKUs for.
     * Format: accounts/{account_id}/customers/{customer_id}.
     * </pre>
     *
     * <code>
     * string customer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomer() {

      customer_ = getDefaultInstance().getCustomer();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the customer to list SKUs for.
     * Format: accounts/{account_id}/customers/{customer_id}.
     * </pre>
     *
     * <code>
     * string customer = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for customer to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      customer_ = value;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Optional. Requested page size. Server might return fewer results than requested.
     * If unspecified, returns at most 100 SKUs.
     * The maximum value is 1000; the server will coerce values above 1000.
     * </pre>
     *
     * <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Requested page size. Server might return fewer results than requested.
     * If unspecified, returns at most 100 SKUs.
     * The maximum value is 1000; the server will coerce values above 1000.
     * </pre>
     *
     * <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Requested page size. Server might return fewer results than requested.
     * If unspecified, returns at most 100 SKUs.
     * The maximum value is 1000; the server will coerce values above 1000.
     * </pre>
     *
     * <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {

      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A token for a page of results other than the first page.
     * </pre>
     *
     * <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A token for a page of results other than the first page.
     * </pre>
     *
     * <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A token for a page of results other than the first page.
     * </pre>
     *
     * <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A token for a page of results other than the first page.
     * </pre>
     *
     * <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {

      pageToken_ = getDefaultInstance().getPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A token for a page of results other than the first page.
     * </pre>
     *
     * <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pageToken_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code. For example, "en-US". The
     * response will localize in the corresponding language code, if specified.
     * The default value is "en-US".
     * </pre>
     *
     * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code. For example, "en-US". The
     * response will localize in the corresponding language code, if specified.
     * The default value is "en-US".
     * </pre>
     *
     * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code. For example, "en-US". The
     * response will localize in the corresponding language code, if specified.
     * The default value is "en-US".
     * </pre>
     *
     * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      languageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code. For example, "en-US". The
     * response will localize in the corresponding language code, if specified.
     * The default value is "en-US".
     * </pre>
     *
     * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {

      languageCode_ = getDefaultInstance().getLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code. For example, "en-US". The
     * response will localize in the corresponding language code, if specified.
     * The default value is "en-US".
     * </pre>
     *
     * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      languageCode_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.ListPurchasableSkusRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.ListPurchasableSkusRequest)
  private static final com.google.cloud.channel.v1.ListPurchasableSkusRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.ListPurchasableSkusRequest();
  }

  public static com.google.cloud.channel.v1.ListPurchasableSkusRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListPurchasableSkusRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListPurchasableSkusRequest>() {
        @java.lang.Override
        public ListPurchasableSkusRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListPurchasableSkusRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListPurchasableSkusRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.ListPurchasableSkusRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
