/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/service.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Request message for [CloudChannelService.ImportCustomer][google.cloud.channel.v1.CloudChannelService.ImportCustomer]
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.ImportCustomerRequest}
 */
public final class ImportCustomerRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.ImportCustomerRequest)
    ImportCustomerRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportCustomerRequest.newBuilder() to construct.
  private ImportCustomerRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportCustomerRequest() {
    parent_ = "";
    authToken_ = "";
    channelPartnerId_ = "";
    customer_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportCustomerRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.ServiceProto
        .internal_static_google_cloud_channel_v1_ImportCustomerRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.ServiceProto
        .internal_static_google_cloud_channel_v1_ImportCustomerRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.ImportCustomerRequest.class,
            com.google.cloud.channel.v1.ImportCustomerRequest.Builder.class);
  }

  private int customerIdentityCase_ = 0;
  private java.lang.Object customerIdentity_;

  public enum CustomerIdentityCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DOMAIN(2),
    CLOUD_IDENTITY_ID(3),
    CUSTOMERIDENTITY_NOT_SET(0);
    private final int value;

    private CustomerIdentityCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CustomerIdentityCase valueOf(int value) {
      return forNumber(value);
    }

    public static CustomerIdentityCase forNumber(int value) {
      switch (value) {
        case 2:
          return DOMAIN;
        case 3:
          return CLOUD_IDENTITY_ID;
        case 0:
          return CUSTOMERIDENTITY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CustomerIdentityCase getCustomerIdentityCase() {
    return CustomerIdentityCase.forNumber(customerIdentityCase_);
  }

  public static final int DOMAIN_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Required. Customer domain.
   * </pre>
   *
   * <code>string domain = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the domain field is set.
   */
  public boolean hasDomain() {
    return customerIdentityCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Required. Customer domain.
   * </pre>
   *
   * <code>string domain = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The domain.
   */
  public java.lang.String getDomain() {
    java.lang.Object ref = "";
    if (customerIdentityCase_ == 2) {
      ref = customerIdentity_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (customerIdentityCase_ == 2) {
        customerIdentity_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Customer domain.
   * </pre>
   *
   * <code>string domain = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for domain.
   */
  public com.google.protobuf.ByteString getDomainBytes() {
    java.lang.Object ref = "";
    if (customerIdentityCase_ == 2) {
      ref = customerIdentity_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (customerIdentityCase_ == 2) {
        customerIdentity_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLOUD_IDENTITY_ID_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Required. Customer's Cloud Identity ID
   * </pre>
   *
   * <code>string cloud_identity_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the cloudIdentityId field is set.
   */
  public boolean hasCloudIdentityId() {
    return customerIdentityCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Required. Customer's Cloud Identity ID
   * </pre>
   *
   * <code>string cloud_identity_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The cloudIdentityId.
   */
  public java.lang.String getCloudIdentityId() {
    java.lang.Object ref = "";
    if (customerIdentityCase_ == 3) {
      ref = customerIdentity_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (customerIdentityCase_ == 3) {
        customerIdentity_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Customer's Cloud Identity ID
   * </pre>
   *
   * <code>string cloud_identity_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for cloudIdentityId.
   */
  public com.google.protobuf.ByteString getCloudIdentityIdBytes() {
    java.lang.Object ref = "";
    if (customerIdentityCase_ == 3) {
      ref = customerIdentity_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (customerIdentityCase_ == 3) {
        customerIdentity_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the reseller's account.
   * Parent takes the format: accounts/{account_id} or
   * accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the reseller's account.
   * Parent takes the format: accounts/{account_id} or
   * accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTH_TOKEN_FIELD_NUMBER = 4;
  private volatile java.lang.Object authToken_;
  /**
   *
   *
   * <pre>
   * Optional. The super admin of the resold customer generates this token to
   * authorize a reseller to access their Cloud Identity and purchase
   * entitlements on their behalf. You can omit this token after authorization.
   * See https://support.google.com/a/answer/7643790 for more details.
   * </pre>
   *
   * <code>string auth_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The authToken.
   */
  @java.lang.Override
  public java.lang.String getAuthToken() {
    java.lang.Object ref = authToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The super admin of the resold customer generates this token to
   * authorize a reseller to access their Cloud Identity and purchase
   * entitlements on their behalf. You can omit this token after authorization.
   * See https://support.google.com/a/answer/7643790 for more details.
   * </pre>
   *
   * <code>string auth_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for authToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAuthTokenBytes() {
    java.lang.Object ref = authToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      authToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OVERWRITE_IF_EXISTS_FIELD_NUMBER = 5;
  private boolean overwriteIfExists_;
  /**
   *
   *
   * <pre>
   * Required. Choose to overwrite an existing customer if found.
   * This must be set to true if there is an existing customer with a
   * conflicting region code or domain.
   * </pre>
   *
   * <code>bool overwrite_if_exists = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The overwriteIfExists.
   */
  @java.lang.Override
  public boolean getOverwriteIfExists() {
    return overwriteIfExists_;
  }

  public static final int CHANNEL_PARTNER_ID_FIELD_NUMBER = 6;
  private volatile java.lang.Object channelPartnerId_;
  /**
   *
   *
   * <pre>
   * Optional. Cloud Identity ID of a channel partner who will be the direct reseller for
   * the customer's order. This field is required for 2-tier transfer scenarios
   * and can be provided via the request Parent binding as well.
   * </pre>
   *
   * <code>string channel_partner_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The channelPartnerId.
   */
  @java.lang.Override
  public java.lang.String getChannelPartnerId() {
    java.lang.Object ref = channelPartnerId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      channelPartnerId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Cloud Identity ID of a channel partner who will be the direct reseller for
   * the customer's order. This field is required for 2-tier transfer scenarios
   * and can be provided via the request Parent binding as well.
   * </pre>
   *
   * <code>string channel_partner_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for channelPartnerId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getChannelPartnerIdBytes() {
    java.lang.Object ref = channelPartnerId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      channelPartnerId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOMER_FIELD_NUMBER = 7;
  private volatile java.lang.Object customer_;
  /**
   *
   *
   * <pre>
   * Optional. Specifies the customer that will receive imported Cloud Identity
   * information.
   * Format: accounts/{account_id}/customers/{customer_id}
   * </pre>
   *
   * <code>
   * string customer = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The customer.
   */
  @java.lang.Override
  public java.lang.String getCustomer() {
    java.lang.Object ref = customer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the customer that will receive imported Cloud Identity
   * information.
   * Format: accounts/{account_id}/customers/{customer_id}
   * </pre>
   *
   * <code>
   * string customer = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for customer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomerBytes() {
    java.lang.Object ref = customer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (customerIdentityCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, customerIdentity_);
    }
    if (customerIdentityCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, customerIdentity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, authToken_);
    }
    if (overwriteIfExists_ != false) {
      output.writeBool(5, overwriteIfExists_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(channelPartnerId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, channelPartnerId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, customer_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (customerIdentityCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, customerIdentity_);
    }
    if (customerIdentityCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, customerIdentity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, authToken_);
    }
    if (overwriteIfExists_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, overwriteIfExists_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(channelPartnerId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, channelPartnerId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, customer_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.ImportCustomerRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.ImportCustomerRequest other =
        (com.google.cloud.channel.v1.ImportCustomerRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getAuthToken().equals(other.getAuthToken())) return false;
    if (getOverwriteIfExists() != other.getOverwriteIfExists()) return false;
    if (!getChannelPartnerId().equals(other.getChannelPartnerId())) return false;
    if (!getCustomer().equals(other.getCustomer())) return false;
    if (!getCustomerIdentityCase().equals(other.getCustomerIdentityCase())) return false;
    switch (customerIdentityCase_) {
      case 2:
        if (!getDomain().equals(other.getDomain())) return false;
        break;
      case 3:
        if (!getCloudIdentityId().equals(other.getCloudIdentityId())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + AUTH_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getAuthToken().hashCode();
    hash = (37 * hash) + OVERWRITE_IF_EXISTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOverwriteIfExists());
    hash = (37 * hash) + CHANNEL_PARTNER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getChannelPartnerId().hashCode();
    hash = (37 * hash) + CUSTOMER_FIELD_NUMBER;
    hash = (53 * hash) + getCustomer().hashCode();
    switch (customerIdentityCase_) {
      case 2:
        hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
        hash = (53 * hash) + getDomain().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CLOUD_IDENTITY_ID_FIELD_NUMBER;
        hash = (53 * hash) + getCloudIdentityId().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.ImportCustomerRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [CloudChannelService.ImportCustomer][google.cloud.channel.v1.CloudChannelService.ImportCustomer]
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.ImportCustomerRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.ImportCustomerRequest)
      com.google.cloud.channel.v1.ImportCustomerRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ImportCustomerRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ImportCustomerRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.ImportCustomerRequest.class,
              com.google.cloud.channel.v1.ImportCustomerRequest.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.ImportCustomerRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      authToken_ = "";

      overwriteIfExists_ = false;

      channelPartnerId_ = "";

      customer_ = "";

      customerIdentityCase_ = 0;
      customerIdentity_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ImportCustomerRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ImportCustomerRequest getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.ImportCustomerRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ImportCustomerRequest build() {
      com.google.cloud.channel.v1.ImportCustomerRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ImportCustomerRequest buildPartial() {
      com.google.cloud.channel.v1.ImportCustomerRequest result =
          new com.google.cloud.channel.v1.ImportCustomerRequest(this);
      if (customerIdentityCase_ == 2) {
        result.customerIdentity_ = customerIdentity_;
      }
      if (customerIdentityCase_ == 3) {
        result.customerIdentity_ = customerIdentity_;
      }
      result.parent_ = parent_;
      result.authToken_ = authToken_;
      result.overwriteIfExists_ = overwriteIfExists_;
      result.channelPartnerId_ = channelPartnerId_;
      result.customer_ = customer_;
      result.customerIdentityCase_ = customerIdentityCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.ImportCustomerRequest) {
        return mergeFrom((com.google.cloud.channel.v1.ImportCustomerRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.ImportCustomerRequest other) {
      if (other == com.google.cloud.channel.v1.ImportCustomerRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (!other.getAuthToken().isEmpty()) {
        authToken_ = other.authToken_;
        onChanged();
      }
      if (other.getOverwriteIfExists() != false) {
        setOverwriteIfExists(other.getOverwriteIfExists());
      }
      if (!other.getChannelPartnerId().isEmpty()) {
        channelPartnerId_ = other.channelPartnerId_;
        onChanged();
      }
      if (!other.getCustomer().isEmpty()) {
        customer_ = other.customer_;
        onChanged();
      }
      switch (other.getCustomerIdentityCase()) {
        case DOMAIN:
          {
            customerIdentityCase_ = 2;
            customerIdentity_ = other.customerIdentity_;
            onChanged();
            break;
          }
        case CLOUD_IDENTITY_ID:
          {
            customerIdentityCase_ = 3;
            customerIdentity_ = other.customerIdentity_;
            onChanged();
            break;
          }
        case CUSTOMERIDENTITY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                customerIdentityCase_ = 2;
                customerIdentity_ = s;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                customerIdentityCase_ = 3;
                customerIdentity_ = s;
                break;
              } // case 26
            case 34:
              {
                authToken_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 40:
              {
                overwriteIfExists_ = input.readBool();

                break;
              } // case 40
            case 50:
              {
                channelPartnerId_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 58:
              {
                customer_ = input.readStringRequireUtf8();

                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int customerIdentityCase_ = 0;
    private java.lang.Object customerIdentity_;

    public CustomerIdentityCase getCustomerIdentityCase() {
      return CustomerIdentityCase.forNumber(customerIdentityCase_);
    }

    public Builder clearCustomerIdentity() {
      customerIdentityCase_ = 0;
      customerIdentity_ = null;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Customer domain.
     * </pre>
     *
     * <code>string domain = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the domain field is set.
     */
    @java.lang.Override
    public boolean hasDomain() {
      return customerIdentityCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Required. Customer domain.
     * </pre>
     *
     * <code>string domain = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The domain.
     */
    @java.lang.Override
    public java.lang.String getDomain() {
      java.lang.Object ref = "";
      if (customerIdentityCase_ == 2) {
        ref = customerIdentity_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (customerIdentityCase_ == 2) {
          customerIdentity_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Customer domain.
     * </pre>
     *
     * <code>string domain = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for domain.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDomainBytes() {
      java.lang.Object ref = "";
      if (customerIdentityCase_ == 2) {
        ref = customerIdentity_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (customerIdentityCase_ == 2) {
          customerIdentity_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Customer domain.
     * </pre>
     *
     * <code>string domain = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomain(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customerIdentityCase_ = 2;
      customerIdentity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Customer domain.
     * </pre>
     *
     * <code>string domain = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomain() {
      if (customerIdentityCase_ == 2) {
        customerIdentityCase_ = 0;
        customerIdentity_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Customer domain.
     * </pre>
     *
     * <code>string domain = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomainBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customerIdentityCase_ = 2;
      customerIdentity_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the cloudIdentityId field is set.
     */
    @java.lang.Override
    public boolean hasCloudIdentityId() {
      return customerIdentityCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Required. Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The cloudIdentityId.
     */
    @java.lang.Override
    public java.lang.String getCloudIdentityId() {
      java.lang.Object ref = "";
      if (customerIdentityCase_ == 3) {
        ref = customerIdentity_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (customerIdentityCase_ == 3) {
          customerIdentity_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for cloudIdentityId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCloudIdentityIdBytes() {
      java.lang.Object ref = "";
      if (customerIdentityCase_ == 3) {
        ref = customerIdentity_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (customerIdentityCase_ == 3) {
          customerIdentity_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The cloudIdentityId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudIdentityId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customerIdentityCase_ = 3;
      customerIdentity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudIdentityId() {
      if (customerIdentityCase_ == 3) {
        customerIdentityCase_ = 0;
        customerIdentity_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Customer's Cloud Identity ID
     * </pre>
     *
     * <code>string cloud_identity_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for cloudIdentityId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudIdentityIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customerIdentityCase_ = 3;
      customerIdentity_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's account.
     * Parent takes the format: accounts/{account_id} or
     * accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's account.
     * Parent takes the format: accounts/{account_id} or
     * accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's account.
     * Parent takes the format: accounts/{account_id} or
     * accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's account.
     * Parent takes the format: accounts/{account_id} or
     * accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the reseller's account.
     * Parent takes the format: accounts/{account_id} or
     * accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object authToken_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The super admin of the resold customer generates this token to
     * authorize a reseller to access their Cloud Identity and purchase
     * entitlements on their behalf. You can omit this token after authorization.
     * See https://support.google.com/a/answer/7643790 for more details.
     * </pre>
     *
     * <code>string auth_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The authToken.
     */
    public java.lang.String getAuthToken() {
      java.lang.Object ref = authToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The super admin of the resold customer generates this token to
     * authorize a reseller to access their Cloud Identity and purchase
     * entitlements on their behalf. You can omit this token after authorization.
     * See https://support.google.com/a/answer/7643790 for more details.
     * </pre>
     *
     * <code>string auth_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for authToken.
     */
    public com.google.protobuf.ByteString getAuthTokenBytes() {
      java.lang.Object ref = authToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        authToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The super admin of the resold customer generates this token to
     * authorize a reseller to access their Cloud Identity and purchase
     * entitlements on their behalf. You can omit this token after authorization.
     * See https://support.google.com/a/answer/7643790 for more details.
     * </pre>
     *
     * <code>string auth_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The authToken to set.
     * @return This builder for chaining.
     */
    public Builder setAuthToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      authToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The super admin of the resold customer generates this token to
     * authorize a reseller to access their Cloud Identity and purchase
     * entitlements on their behalf. You can omit this token after authorization.
     * See https://support.google.com/a/answer/7643790 for more details.
     * </pre>
     *
     * <code>string auth_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthToken() {

      authToken_ = getDefaultInstance().getAuthToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The super admin of the resold customer generates this token to
     * authorize a reseller to access their Cloud Identity and purchase
     * entitlements on their behalf. You can omit this token after authorization.
     * See https://support.google.com/a/answer/7643790 for more details.
     * </pre>
     *
     * <code>string auth_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for authToken to set.
     * @return This builder for chaining.
     */
    public Builder setAuthTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      authToken_ = value;
      onChanged();
      return this;
    }

    private boolean overwriteIfExists_;
    /**
     *
     *
     * <pre>
     * Required. Choose to overwrite an existing customer if found.
     * This must be set to true if there is an existing customer with a
     * conflicting region code or domain.
     * </pre>
     *
     * <code>bool overwrite_if_exists = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The overwriteIfExists.
     */
    @java.lang.Override
    public boolean getOverwriteIfExists() {
      return overwriteIfExists_;
    }
    /**
     *
     *
     * <pre>
     * Required. Choose to overwrite an existing customer if found.
     * This must be set to true if there is an existing customer with a
     * conflicting region code or domain.
     * </pre>
     *
     * <code>bool overwrite_if_exists = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The overwriteIfExists to set.
     * @return This builder for chaining.
     */
    public Builder setOverwriteIfExists(boolean value) {

      overwriteIfExists_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Choose to overwrite an existing customer if found.
     * This must be set to true if there is an existing customer with a
     * conflicting region code or domain.
     * </pre>
     *
     * <code>bool overwrite_if_exists = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOverwriteIfExists() {

      overwriteIfExists_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object channelPartnerId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Cloud Identity ID of a channel partner who will be the direct reseller for
     * the customer's order. This field is required for 2-tier transfer scenarios
     * and can be provided via the request Parent binding as well.
     * </pre>
     *
     * <code>string channel_partner_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The channelPartnerId.
     */
    public java.lang.String getChannelPartnerId() {
      java.lang.Object ref = channelPartnerId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        channelPartnerId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Identity ID of a channel partner who will be the direct reseller for
     * the customer's order. This field is required for 2-tier transfer scenarios
     * and can be provided via the request Parent binding as well.
     * </pre>
     *
     * <code>string channel_partner_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for channelPartnerId.
     */
    public com.google.protobuf.ByteString getChannelPartnerIdBytes() {
      java.lang.Object ref = channelPartnerId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        channelPartnerId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Identity ID of a channel partner who will be the direct reseller for
     * the customer's order. This field is required for 2-tier transfer scenarios
     * and can be provided via the request Parent binding as well.
     * </pre>
     *
     * <code>string channel_partner_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The channelPartnerId to set.
     * @return This builder for chaining.
     */
    public Builder setChannelPartnerId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      channelPartnerId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Identity ID of a channel partner who will be the direct reseller for
     * the customer's order. This field is required for 2-tier transfer scenarios
     * and can be provided via the request Parent binding as well.
     * </pre>
     *
     * <code>string channel_partner_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChannelPartnerId() {

      channelPartnerId_ = getDefaultInstance().getChannelPartnerId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Identity ID of a channel partner who will be the direct reseller for
     * the customer's order. This field is required for 2-tier transfer scenarios
     * and can be provided via the request Parent binding as well.
     * </pre>
     *
     * <code>string channel_partner_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for channelPartnerId to set.
     * @return This builder for chaining.
     */
    public Builder setChannelPartnerIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      channelPartnerId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object customer_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Specifies the customer that will receive imported Cloud Identity
     * information.
     * Format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>
     * string customer = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The customer.
     */
    public java.lang.String getCustomer() {
      java.lang.Object ref = customer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the customer that will receive imported Cloud Identity
     * information.
     * Format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>
     * string customer = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for customer.
     */
    public com.google.protobuf.ByteString getCustomerBytes() {
      java.lang.Object ref = customer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the customer that will receive imported Cloud Identity
     * information.
     * Format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>
     * string customer = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The customer to set.
     * @return This builder for chaining.
     */
    public Builder setCustomer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      customer_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the customer that will receive imported Cloud Identity
     * information.
     * Format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>
     * string customer = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomer() {

      customer_ = getDefaultInstance().getCustomer();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the customer that will receive imported Cloud Identity
     * information.
     * Format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>
     * string customer = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for customer to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      customer_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.ImportCustomerRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.ImportCustomerRequest)
  private static final com.google.cloud.channel.v1.ImportCustomerRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.ImportCustomerRequest();
  }

  public static com.google.cloud.channel.v1.ImportCustomerRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportCustomerRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportCustomerRequest>() {
        @java.lang.Override
        public ImportCustomerRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportCustomerRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportCustomerRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.ImportCustomerRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
