/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/reports_service.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Response message for [CloudChannelReportsService.FetchReportResults][google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults].
 * Contains a tabular representation of the report results.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.FetchReportResultsResponse}
 */
public final class FetchReportResultsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.FetchReportResultsResponse)
    FetchReportResultsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FetchReportResultsResponse.newBuilder() to construct.
  private FetchReportResultsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FetchReportResultsResponse() {
    rows_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FetchReportResultsResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.ReportsServiceProto
        .internal_static_google_cloud_channel_v1_FetchReportResultsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.ReportsServiceProto
        .internal_static_google_cloud_channel_v1_FetchReportResultsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.FetchReportResultsResponse.class,
            com.google.cloud.channel.v1.FetchReportResultsResponse.Builder.class);
  }

  public static final int REPORT_METADATA_FIELD_NUMBER = 1;
  private com.google.cloud.channel.v1.ReportResultsMetadata reportMetadata_;
  /**
   *
   *
   * <pre>
   * The metadata for the report results (display name, columns, row count, and
   * date ranges).
   * </pre>
   *
   * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
   *
   * @return Whether the reportMetadata field is set.
   */
  @java.lang.Override
  public boolean hasReportMetadata() {
    return reportMetadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * The metadata for the report results (display name, columns, row count, and
   * date ranges).
   * </pre>
   *
   * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
   *
   * @return The reportMetadata.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ReportResultsMetadata getReportMetadata() {
    return reportMetadata_ == null
        ? com.google.cloud.channel.v1.ReportResultsMetadata.getDefaultInstance()
        : reportMetadata_;
  }
  /**
   *
   *
   * <pre>
   * The metadata for the report results (display name, columns, row count, and
   * date ranges).
   * </pre>
   *
   * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ReportResultsMetadataOrBuilder getReportMetadataOrBuilder() {
    return getReportMetadata();
  }

  public static final int ROWS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.channel.v1.Row> rows_;
  /**
   *
   *
   * <pre>
   * The report's lists of values. Each row follows the settings and ordering
   * of the columns from `report_metadata`.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.Row> getRowsList() {
    return rows_;
  }
  /**
   *
   *
   * <pre>
   * The report's lists of values. Each row follows the settings and ordering
   * of the columns from `report_metadata`.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.channel.v1.RowOrBuilder> getRowsOrBuilderList() {
    return rows_;
  }
  /**
   *
   *
   * <pre>
   * The report's lists of values. Each row follows the settings and ordering
   * of the columns from `report_metadata`.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
   */
  @java.lang.Override
  public int getRowsCount() {
    return rows_.size();
  }
  /**
   *
   *
   * <pre>
   * The report's lists of values. Each row follows the settings and ordering
   * of the columns from `report_metadata`.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Row getRows(int index) {
    return rows_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The report's lists of values. Each row follows the settings and ordering
   * of the columns from `report_metadata`.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.RowOrBuilder getRowsOrBuilder(int index) {
    return rows_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * Pass this token to [FetchReportResultsRequest.page_token][google.cloud.channel.v1.FetchReportResultsRequest.page_token] to retrieve
   * the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Pass this token to [FetchReportResultsRequest.page_token][google.cloud.channel.v1.FetchReportResultsRequest.page_token] to retrieve
   * the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (reportMetadata_ != null) {
      output.writeMessage(1, getReportMetadata());
    }
    for (int i = 0; i < rows_.size(); i++) {
      output.writeMessage(2, rows_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (reportMetadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getReportMetadata());
    }
    for (int i = 0; i < rows_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, rows_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.FetchReportResultsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.FetchReportResultsResponse other =
        (com.google.cloud.channel.v1.FetchReportResultsResponse) obj;

    if (hasReportMetadata() != other.hasReportMetadata()) return false;
    if (hasReportMetadata()) {
      if (!getReportMetadata().equals(other.getReportMetadata())) return false;
    }
    if (!getRowsList().equals(other.getRowsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasReportMetadata()) {
      hash = (37 * hash) + REPORT_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getReportMetadata().hashCode();
    }
    if (getRowsCount() > 0) {
      hash = (37 * hash) + ROWS_FIELD_NUMBER;
      hash = (53 * hash) + getRowsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.channel.v1.FetchReportResultsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for [CloudChannelReportsService.FetchReportResults][google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults].
   * Contains a tabular representation of the report results.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.FetchReportResultsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.FetchReportResultsResponse)
      com.google.cloud.channel.v1.FetchReportResultsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.ReportsServiceProto
          .internal_static_google_cloud_channel_v1_FetchReportResultsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.ReportsServiceProto
          .internal_static_google_cloud_channel_v1_FetchReportResultsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.FetchReportResultsResponse.class,
              com.google.cloud.channel.v1.FetchReportResultsResponse.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.FetchReportResultsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (reportMetadataBuilder_ == null) {
        reportMetadata_ = null;
      } else {
        reportMetadata_ = null;
        reportMetadataBuilder_ = null;
      }
      if (rowsBuilder_ == null) {
        rows_ = java.util.Collections.emptyList();
      } else {
        rows_ = null;
        rowsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.ReportsServiceProto
          .internal_static_google_cloud_channel_v1_FetchReportResultsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.FetchReportResultsResponse getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.FetchReportResultsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.FetchReportResultsResponse build() {
      com.google.cloud.channel.v1.FetchReportResultsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.FetchReportResultsResponse buildPartial() {
      com.google.cloud.channel.v1.FetchReportResultsResponse result =
          new com.google.cloud.channel.v1.FetchReportResultsResponse(this);
      int from_bitField0_ = bitField0_;
      if (reportMetadataBuilder_ == null) {
        result.reportMetadata_ = reportMetadata_;
      } else {
        result.reportMetadata_ = reportMetadataBuilder_.build();
      }
      if (rowsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          rows_ = java.util.Collections.unmodifiableList(rows_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.rows_ = rows_;
      } else {
        result.rows_ = rowsBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.FetchReportResultsResponse) {
        return mergeFrom((com.google.cloud.channel.v1.FetchReportResultsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.FetchReportResultsResponse other) {
      if (other == com.google.cloud.channel.v1.FetchReportResultsResponse.getDefaultInstance())
        return this;
      if (other.hasReportMetadata()) {
        mergeReportMetadata(other.getReportMetadata());
      }
      if (rowsBuilder_ == null) {
        if (!other.rows_.isEmpty()) {
          if (rows_.isEmpty()) {
            rows_ = other.rows_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRowsIsMutable();
            rows_.addAll(other.rows_);
          }
          onChanged();
        }
      } else {
        if (!other.rows_.isEmpty()) {
          if (rowsBuilder_.isEmpty()) {
            rowsBuilder_.dispose();
            rowsBuilder_ = null;
            rows_ = other.rows_;
            bitField0_ = (bitField0_ & ~0x00000001);
            rowsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRowsFieldBuilder()
                    : null;
          } else {
            rowsBuilder_.addAllMessages(other.rows_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getReportMetadataFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                com.google.cloud.channel.v1.Row m =
                    input.readMessage(com.google.cloud.channel.v1.Row.parser(), extensionRegistry);
                if (rowsBuilder_ == null) {
                  ensureRowsIsMutable();
                  rows_.add(m);
                } else {
                  rowsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                nextPageToken_ = input.readStringRequireUtf8();

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.channel.v1.ReportResultsMetadata reportMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.ReportResultsMetadata,
            com.google.cloud.channel.v1.ReportResultsMetadata.Builder,
            com.google.cloud.channel.v1.ReportResultsMetadataOrBuilder>
        reportMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * The metadata for the report results (display name, columns, row count, and
     * date ranges).
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
     *
     * @return Whether the reportMetadata field is set.
     */
    public boolean hasReportMetadata() {
      return reportMetadataBuilder_ != null || reportMetadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * The metadata for the report results (display name, columns, row count, and
     * date ranges).
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
     *
     * @return The reportMetadata.
     */
    public com.google.cloud.channel.v1.ReportResultsMetadata getReportMetadata() {
      if (reportMetadataBuilder_ == null) {
        return reportMetadata_ == null
            ? com.google.cloud.channel.v1.ReportResultsMetadata.getDefaultInstance()
            : reportMetadata_;
      } else {
        return reportMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata for the report results (display name, columns, row count, and
     * date ranges).
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
     */
    public Builder setReportMetadata(com.google.cloud.channel.v1.ReportResultsMetadata value) {
      if (reportMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reportMetadata_ = value;
        onChanged();
      } else {
        reportMetadataBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata for the report results (display name, columns, row count, and
     * date ranges).
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
     */
    public Builder setReportMetadata(
        com.google.cloud.channel.v1.ReportResultsMetadata.Builder builderForValue) {
      if (reportMetadataBuilder_ == null) {
        reportMetadata_ = builderForValue.build();
        onChanged();
      } else {
        reportMetadataBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata for the report results (display name, columns, row count, and
     * date ranges).
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
     */
    public Builder mergeReportMetadata(com.google.cloud.channel.v1.ReportResultsMetadata value) {
      if (reportMetadataBuilder_ == null) {
        if (reportMetadata_ != null) {
          reportMetadata_ =
              com.google.cloud.channel.v1.ReportResultsMetadata.newBuilder(reportMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          reportMetadata_ = value;
        }
        onChanged();
      } else {
        reportMetadataBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata for the report results (display name, columns, row count, and
     * date ranges).
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
     */
    public Builder clearReportMetadata() {
      if (reportMetadataBuilder_ == null) {
        reportMetadata_ = null;
        onChanged();
      } else {
        reportMetadata_ = null;
        reportMetadataBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata for the report results (display name, columns, row count, and
     * date ranges).
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
     */
    public com.google.cloud.channel.v1.ReportResultsMetadata.Builder getReportMetadataBuilder() {

      onChanged();
      return getReportMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The metadata for the report results (display name, columns, row count, and
     * date ranges).
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
     */
    public com.google.cloud.channel.v1.ReportResultsMetadataOrBuilder getReportMetadataOrBuilder() {
      if (reportMetadataBuilder_ != null) {
        return reportMetadataBuilder_.getMessageOrBuilder();
      } else {
        return reportMetadata_ == null
            ? com.google.cloud.channel.v1.ReportResultsMetadata.getDefaultInstance()
            : reportMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata for the report results (display name, columns, row count, and
     * date ranges).
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ReportResultsMetadata report_metadata = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.ReportResultsMetadata,
            com.google.cloud.channel.v1.ReportResultsMetadata.Builder,
            com.google.cloud.channel.v1.ReportResultsMetadataOrBuilder>
        getReportMetadataFieldBuilder() {
      if (reportMetadataBuilder_ == null) {
        reportMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.ReportResultsMetadata,
                com.google.cloud.channel.v1.ReportResultsMetadata.Builder,
                com.google.cloud.channel.v1.ReportResultsMetadataOrBuilder>(
                getReportMetadata(), getParentForChildren(), isClean());
        reportMetadata_ = null;
      }
      return reportMetadataBuilder_;
    }

    private java.util.List<com.google.cloud.channel.v1.Row> rows_ =
        java.util.Collections.emptyList();

    private void ensureRowsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        rows_ = new java.util.ArrayList<com.google.cloud.channel.v1.Row>(rows_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.Row,
            com.google.cloud.channel.v1.Row.Builder,
            com.google.cloud.channel.v1.RowOrBuilder>
        rowsBuilder_;

    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.Row> getRowsList() {
      if (rowsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rows_);
      } else {
        return rowsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public int getRowsCount() {
      if (rowsBuilder_ == null) {
        return rows_.size();
      } else {
        return rowsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public com.google.cloud.channel.v1.Row getRows(int index) {
      if (rowsBuilder_ == null) {
        return rows_.get(index);
      } else {
        return rowsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public Builder setRows(int index, com.google.cloud.channel.v1.Row value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.set(index, value);
        onChanged();
      } else {
        rowsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public Builder setRows(int index, com.google.cloud.channel.v1.Row.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.set(index, builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public Builder addRows(com.google.cloud.channel.v1.Row value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.add(value);
        onChanged();
      } else {
        rowsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public Builder addRows(int index, com.google.cloud.channel.v1.Row value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.add(index, value);
        onChanged();
      } else {
        rowsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public Builder addRows(com.google.cloud.channel.v1.Row.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.add(builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public Builder addRows(int index, com.google.cloud.channel.v1.Row.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.add(index, builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public Builder addAllRows(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.Row> values) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rows_);
        onChanged();
      } else {
        rowsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public Builder clearRows() {
      if (rowsBuilder_ == null) {
        rows_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        rowsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public Builder removeRows(int index) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.remove(index);
        onChanged();
      } else {
        rowsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public com.google.cloud.channel.v1.Row.Builder getRowsBuilder(int index) {
      return getRowsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public com.google.cloud.channel.v1.RowOrBuilder getRowsOrBuilder(int index) {
      if (rowsBuilder_ == null) {
        return rows_.get(index);
      } else {
        return rowsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.channel.v1.RowOrBuilder>
        getRowsOrBuilderList() {
      if (rowsBuilder_ != null) {
        return rowsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rows_);
      }
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public com.google.cloud.channel.v1.Row.Builder addRowsBuilder() {
      return getRowsFieldBuilder().addBuilder(com.google.cloud.channel.v1.Row.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public com.google.cloud.channel.v1.Row.Builder addRowsBuilder(int index) {
      return getRowsFieldBuilder()
          .addBuilder(index, com.google.cloud.channel.v1.Row.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The report's lists of values. Each row follows the settings and ordering
     * of the columns from `report_metadata`.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Row rows = 2;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.Row.Builder> getRowsBuilderList() {
      return getRowsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.Row,
            com.google.cloud.channel.v1.Row.Builder,
            com.google.cloud.channel.v1.RowOrBuilder>
        getRowsFieldBuilder() {
      if (rowsBuilder_ == null) {
        rowsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.channel.v1.Row,
                com.google.cloud.channel.v1.Row.Builder,
                com.google.cloud.channel.v1.RowOrBuilder>(
                rows_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        rows_ = null;
      }
      return rowsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * Pass this token to [FetchReportResultsRequest.page_token][google.cloud.channel.v1.FetchReportResultsRequest.page_token] to retrieve
     * the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Pass this token to [FetchReportResultsRequest.page_token][google.cloud.channel.v1.FetchReportResultsRequest.page_token] to retrieve
     * the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Pass this token to [FetchReportResultsRequest.page_token][google.cloud.channel.v1.FetchReportResultsRequest.page_token] to retrieve
     * the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pass this token to [FetchReportResultsRequest.page_token][google.cloud.channel.v1.FetchReportResultsRequest.page_token] to retrieve
     * the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pass this token to [FetchReportResultsRequest.page_token][google.cloud.channel.v1.FetchReportResultsRequest.page_token] to retrieve
     * the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.FetchReportResultsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.FetchReportResultsResponse)
  private static final com.google.cloud.channel.v1.FetchReportResultsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.FetchReportResultsResponse();
  }

  public static com.google.cloud.channel.v1.FetchReportResultsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FetchReportResultsResponse> PARSER =
      new com.google.protobuf.AbstractParser<FetchReportResultsResponse>() {
        @java.lang.Override
        public FetchReportResultsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FetchReportResultsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FetchReportResultsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.FetchReportResultsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
