/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/subscriber_event.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Represents Pub/Sub message content describing entitlement update.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.EntitlementEvent}
 */
public final class EntitlementEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.EntitlementEvent)
    EntitlementEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EntitlementEvent.newBuilder() to construct.
  private EntitlementEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EntitlementEvent() {
    entitlement_ = "";
    eventType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EntitlementEvent();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.SubscriberEventProto
        .internal_static_google_cloud_channel_v1_EntitlementEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.SubscriberEventProto
        .internal_static_google_cloud_channel_v1_EntitlementEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.EntitlementEvent.class,
            com.google.cloud.channel.v1.EntitlementEvent.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of entitlement event.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.channel.v1.EntitlementEvent.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A new entitlement was created.
     * </pre>
     *
     * <code>CREATED = 1;</code>
     */
    CREATED(1),
    /**
     *
     *
     * <pre>
     * The offer type associated with an entitlement was changed.
     * This is not triggered if an entitlement converts from a commit offer to a
     * flexible offer as part of a renewal.
     * </pre>
     *
     * <code>PRICE_PLAN_SWITCHED = 3;</code>
     */
    PRICE_PLAN_SWITCHED(3),
    /**
     *
     *
     * <pre>
     * Annual commitment for a commit plan was changed.
     * </pre>
     *
     * <code>COMMITMENT_CHANGED = 4;</code>
     */
    COMMITMENT_CHANGED(4),
    /**
     *
     *
     * <pre>
     * An annual entitlement was renewed.
     * </pre>
     *
     * <code>RENEWED = 5;</code>
     */
    RENEWED(5),
    /**
     *
     *
     * <pre>
     * Entitlement was suspended.
     * </pre>
     *
     * <code>SUSPENDED = 6;</code>
     */
    SUSPENDED(6),
    /**
     *
     *
     * <pre>
     * Entitlement was unsuspended.
     * </pre>
     *
     * <code>ACTIVATED = 7;</code>
     */
    ACTIVATED(7),
    /**
     *
     *
     * <pre>
     * Entitlement was cancelled.
     * </pre>
     *
     * <code>CANCELLED = 8;</code>
     */
    CANCELLED(8),
    /**
     *
     *
     * <pre>
     * Entitlement was upgraded or downgraded (e.g. from Google Workspace
     * Business Standard to Google Workspace Business Plus).
     * </pre>
     *
     * <code>SKU_CHANGED = 9;</code>
     */
    SKU_CHANGED(9),
    /**
     *
     *
     * <pre>
     * The renewal settings of an entitlement has changed.
     * </pre>
     *
     * <code>RENEWAL_SETTING_CHANGED = 10;</code>
     */
    RENEWAL_SETTING_CHANGED(10),
    /**
     *
     *
     * <pre>
     * Paid service has started on trial entitlement.
     * </pre>
     *
     * <code>PAID_SERVICE_STARTED = 11;</code>
     */
    PAID_SERVICE_STARTED(11),
    /**
     *
     *
     * <pre>
     * License was assigned to or revoked from a user.
     * </pre>
     *
     * <code>LICENSE_ASSIGNMENT_CHANGED = 12;</code>
     */
    LICENSE_ASSIGNMENT_CHANGED(12),
    /**
     *
     *
     * <pre>
     * License cap was changed for the entitlement.
     * </pre>
     *
     * <code>LICENSE_CAP_CHANGED = 13;</code>
     */
    LICENSE_CAP_CHANGED(13),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A new entitlement was created.
     * </pre>
     *
     * <code>CREATED = 1;</code>
     */
    public static final int CREATED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The offer type associated with an entitlement was changed.
     * This is not triggered if an entitlement converts from a commit offer to a
     * flexible offer as part of a renewal.
     * </pre>
     *
     * <code>PRICE_PLAN_SWITCHED = 3;</code>
     */
    public static final int PRICE_PLAN_SWITCHED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Annual commitment for a commit plan was changed.
     * </pre>
     *
     * <code>COMMITMENT_CHANGED = 4;</code>
     */
    public static final int COMMITMENT_CHANGED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * An annual entitlement was renewed.
     * </pre>
     *
     * <code>RENEWED = 5;</code>
     */
    public static final int RENEWED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Entitlement was suspended.
     * </pre>
     *
     * <code>SUSPENDED = 6;</code>
     */
    public static final int SUSPENDED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Entitlement was unsuspended.
     * </pre>
     *
     * <code>ACTIVATED = 7;</code>
     */
    public static final int ACTIVATED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Entitlement was cancelled.
     * </pre>
     *
     * <code>CANCELLED = 8;</code>
     */
    public static final int CANCELLED_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Entitlement was upgraded or downgraded (e.g. from Google Workspace
     * Business Standard to Google Workspace Business Plus).
     * </pre>
     *
     * <code>SKU_CHANGED = 9;</code>
     */
    public static final int SKU_CHANGED_VALUE = 9;
    /**
     *
     *
     * <pre>
     * The renewal settings of an entitlement has changed.
     * </pre>
     *
     * <code>RENEWAL_SETTING_CHANGED = 10;</code>
     */
    public static final int RENEWAL_SETTING_CHANGED_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Paid service has started on trial entitlement.
     * </pre>
     *
     * <code>PAID_SERVICE_STARTED = 11;</code>
     */
    public static final int PAID_SERVICE_STARTED_VALUE = 11;
    /**
     *
     *
     * <pre>
     * License was assigned to or revoked from a user.
     * </pre>
     *
     * <code>LICENSE_ASSIGNMENT_CHANGED = 12;</code>
     */
    public static final int LICENSE_ASSIGNMENT_CHANGED_VALUE = 12;
    /**
     *
     *
     * <pre>
     * License cap was changed for the entitlement.
     * </pre>
     *
     * <code>LICENSE_CAP_CHANGED = 13;</code>
     */
    public static final int LICENSE_CAP_CHANGED_VALUE = 13;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return CREATED;
        case 3:
          return PRICE_PLAN_SWITCHED;
        case 4:
          return COMMITMENT_CHANGED;
        case 5:
          return RENEWED;
        case 6:
          return SUSPENDED;
        case 7:
          return ACTIVATED;
        case 8:
          return CANCELLED;
        case 9:
          return SKU_CHANGED;
        case 10:
          return RENEWAL_SETTING_CHANGED;
        case 11:
          return PAID_SERVICE_STARTED;
        case 12:
          return LICENSE_ASSIGNMENT_CHANGED;
        case 13:
          return LICENSE_CAP_CHANGED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.channel.v1.EntitlementEvent.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.channel.v1.EntitlementEvent.Type)
  }

  public static final int ENTITLEMENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object entitlement_;
  /**
   *
   *
   * <pre>
   * Resource name of an entitlement of the form:
   * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
   * </pre>
   *
   * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The entitlement.
   */
  @java.lang.Override
  public java.lang.String getEntitlement() {
    java.lang.Object ref = entitlement_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entitlement_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name of an entitlement of the form:
   * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
   * </pre>
   *
   * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for entitlement.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntitlementBytes() {
    java.lang.Object ref = entitlement_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entitlement_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_TYPE_FIELD_NUMBER = 2;
  private int eventType_;
  /**
   *
   *
   * <pre>
   * Type of event which happened on the entitlement.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.EntitlementEvent.Type event_type = 2;</code>
   *
   * @return The enum numeric value on the wire for eventType.
   */
  @java.lang.Override
  public int getEventTypeValue() {
    return eventType_;
  }
  /**
   *
   *
   * <pre>
   * Type of event which happened on the entitlement.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.EntitlementEvent.Type event_type = 2;</code>
   *
   * @return The eventType.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.EntitlementEvent.Type getEventType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.channel.v1.EntitlementEvent.Type result =
        com.google.cloud.channel.v1.EntitlementEvent.Type.valueOf(eventType_);
    return result == null ? com.google.cloud.channel.v1.EntitlementEvent.Type.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entitlement_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, entitlement_);
    }
    if (eventType_
        != com.google.cloud.channel.v1.EntitlementEvent.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, eventType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entitlement_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, entitlement_);
    }
    if (eventType_
        != com.google.cloud.channel.v1.EntitlementEvent.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, eventType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.EntitlementEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.EntitlementEvent other =
        (com.google.cloud.channel.v1.EntitlementEvent) obj;

    if (!getEntitlement().equals(other.getEntitlement())) return false;
    if (eventType_ != other.eventType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENTITLEMENT_FIELD_NUMBER;
    hash = (53 * hash) + getEntitlement().hashCode();
    hash = (37 * hash) + EVENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + eventType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.EntitlementEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.EntitlementEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents Pub/Sub message content describing entitlement update.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.EntitlementEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.EntitlementEvent)
      com.google.cloud.channel.v1.EntitlementEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.SubscriberEventProto
          .internal_static_google_cloud_channel_v1_EntitlementEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.SubscriberEventProto
          .internal_static_google_cloud_channel_v1_EntitlementEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.EntitlementEvent.class,
              com.google.cloud.channel.v1.EntitlementEvent.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.EntitlementEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      entitlement_ = "";

      eventType_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.SubscriberEventProto
          .internal_static_google_cloud_channel_v1_EntitlementEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.EntitlementEvent getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.EntitlementEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.EntitlementEvent build() {
      com.google.cloud.channel.v1.EntitlementEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.EntitlementEvent buildPartial() {
      com.google.cloud.channel.v1.EntitlementEvent result =
          new com.google.cloud.channel.v1.EntitlementEvent(this);
      result.entitlement_ = entitlement_;
      result.eventType_ = eventType_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.EntitlementEvent) {
        return mergeFrom((com.google.cloud.channel.v1.EntitlementEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.EntitlementEvent other) {
      if (other == com.google.cloud.channel.v1.EntitlementEvent.getDefaultInstance()) return this;
      if (!other.getEntitlement().isEmpty()) {
        entitlement_ = other.entitlement_;
        onChanged();
      }
      if (other.eventType_ != 0) {
        setEventTypeValue(other.getEventTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                entitlement_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                eventType_ = input.readEnum();

                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object entitlement_ = "";
    /**
     *
     *
     * <pre>
     * Resource name of an entitlement of the form:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The entitlement.
     */
    public java.lang.String getEntitlement() {
      java.lang.Object ref = entitlement_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entitlement_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of an entitlement of the form:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for entitlement.
     */
    public com.google.protobuf.ByteString getEntitlementBytes() {
      java.lang.Object ref = entitlement_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entitlement_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of an entitlement of the form:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The entitlement to set.
     * @return This builder for chaining.
     */
    public Builder setEntitlement(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      entitlement_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of an entitlement of the form:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntitlement() {

      entitlement_ = getDefaultInstance().getEntitlement();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of an entitlement of the form:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string entitlement = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for entitlement to set.
     * @return This builder for chaining.
     */
    public Builder setEntitlementBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      entitlement_ = value;
      onChanged();
      return this;
    }

    private int eventType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of event which happened on the entitlement.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EntitlementEvent.Type event_type = 2;</code>
     *
     * @return The enum numeric value on the wire for eventType.
     */
    @java.lang.Override
    public int getEventTypeValue() {
      return eventType_;
    }
    /**
     *
     *
     * <pre>
     * Type of event which happened on the entitlement.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EntitlementEvent.Type event_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventTypeValue(int value) {

      eventType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of event which happened on the entitlement.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EntitlementEvent.Type event_type = 2;</code>
     *
     * @return The eventType.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.EntitlementEvent.Type getEventType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.EntitlementEvent.Type result =
          com.google.cloud.channel.v1.EntitlementEvent.Type.valueOf(eventType_);
      return result == null
          ? com.google.cloud.channel.v1.EntitlementEvent.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of event which happened on the entitlement.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EntitlementEvent.Type event_type = 2;</code>
     *
     * @param value The eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventType(com.google.cloud.channel.v1.EntitlementEvent.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }

      eventType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of event which happened on the entitlement.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EntitlementEvent.Type event_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEventType() {

      eventType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.EntitlementEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.EntitlementEvent)
  private static final com.google.cloud.channel.v1.EntitlementEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.EntitlementEvent();
  }

  public static com.google.cloud.channel.v1.EntitlementEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EntitlementEvent> PARSER =
      new com.google.protobuf.AbstractParser<EntitlementEvent>() {
        @java.lang.Override
        public EntitlementEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EntitlementEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EntitlementEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.EntitlementEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
