/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/entitlements.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * An entitlement is a representation of a customer's ability to use a service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.Entitlement}
 */
public final class Entitlement extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.Entitlement)
    EntitlementOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Entitlement.newBuilder() to construct.
  private Entitlement(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Entitlement() {
    name_ = "";
    offer_ = "";
    provisioningState_ = 0;
    suspensionReasons_ = java.util.Collections.emptyList();
    purchaseOrderId_ = "";
    parameters_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Entitlement();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.EntitlementsProto
        .internal_static_google_cloud_channel_v1_Entitlement_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.EntitlementsProto
        .internal_static_google_cloud_channel_v1_Entitlement_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.Entitlement.class,
            com.google.cloud.channel.v1.Entitlement.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates the current provisioning state of the entitlement.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.channel.v1.Entitlement.ProvisioningState}
   */
  public enum ProvisioningState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>PROVISIONING_STATE_UNSPECIFIED = 0;</code>
     */
    PROVISIONING_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The entitlement is currently active.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * The entitlement is currently suspended.
     * </pre>
     *
     * <code>SUSPENDED = 5;</code>
     */
    SUSPENDED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>PROVISIONING_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int PROVISIONING_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The entitlement is currently active.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The entitlement is currently suspended.
     * </pre>
     *
     * <code>SUSPENDED = 5;</code>
     */
    public static final int SUSPENDED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProvisioningState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ProvisioningState forNumber(int value) {
      switch (value) {
        case 0:
          return PROVISIONING_STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 5:
          return SUSPENDED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProvisioningState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ProvisioningState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ProvisioningState>() {
              public ProvisioningState findValueByNumber(int number) {
                return ProvisioningState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.channel.v1.Entitlement.getDescriptor().getEnumTypes().get(0);
    }

    private static final ProvisioningState[] VALUES = values();

    public static ProvisioningState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProvisioningState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.channel.v1.Entitlement.ProvisioningState)
  }

  /**
   *
   *
   * <pre>
   * Suspension reason for an entitlement if [provisioning_state][google.cloud.channel.v1.Entitlement.provisioning_state] = SUSPENDED.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.channel.v1.Entitlement.SuspensionReason}
   */
  public enum SuspensionReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>SUSPENSION_REASON_UNSPECIFIED = 0;</code>
     */
    SUSPENSION_REASON_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Entitlement was manually suspended by the Reseller.
     * </pre>
     *
     * <code>RESELLER_INITIATED = 1;</code>
     */
    RESELLER_INITIATED(1),
    /**
     *
     *
     * <pre>
     * Trial ended.
     * </pre>
     *
     * <code>TRIAL_ENDED = 2;</code>
     */
    TRIAL_ENDED(2),
    /**
     *
     *
     * <pre>
     * Entitlement renewal was canceled.
     * </pre>
     *
     * <code>RENEWAL_WITH_TYPE_CANCEL = 3;</code>
     */
    RENEWAL_WITH_TYPE_CANCEL(3),
    /**
     *
     *
     * <pre>
     * Entitlement was automatically suspended on creation for pending ToS
     * acceptance on customer.
     * </pre>
     *
     * <code>PENDING_TOS_ACCEPTANCE = 4;</code>
     */
    PENDING_TOS_ACCEPTANCE(4),
    /**
     *
     *
     * <pre>
     * Other reasons (internal reasons, abuse, etc.).
     * </pre>
     *
     * <code>OTHER = 100;</code>
     */
    OTHER(100),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>SUSPENSION_REASON_UNSPECIFIED = 0;</code>
     */
    public static final int SUSPENSION_REASON_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Entitlement was manually suspended by the Reseller.
     * </pre>
     *
     * <code>RESELLER_INITIATED = 1;</code>
     */
    public static final int RESELLER_INITIATED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Trial ended.
     * </pre>
     *
     * <code>TRIAL_ENDED = 2;</code>
     */
    public static final int TRIAL_ENDED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Entitlement renewal was canceled.
     * </pre>
     *
     * <code>RENEWAL_WITH_TYPE_CANCEL = 3;</code>
     */
    public static final int RENEWAL_WITH_TYPE_CANCEL_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Entitlement was automatically suspended on creation for pending ToS
     * acceptance on customer.
     * </pre>
     *
     * <code>PENDING_TOS_ACCEPTANCE = 4;</code>
     */
    public static final int PENDING_TOS_ACCEPTANCE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Other reasons (internal reasons, abuse, etc.).
     * </pre>
     *
     * <code>OTHER = 100;</code>
     */
    public static final int OTHER_VALUE = 100;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SuspensionReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SuspensionReason forNumber(int value) {
      switch (value) {
        case 0:
          return SUSPENSION_REASON_UNSPECIFIED;
        case 1:
          return RESELLER_INITIATED;
        case 2:
          return TRIAL_ENDED;
        case 3:
          return RENEWAL_WITH_TYPE_CANCEL;
        case 4:
          return PENDING_TOS_ACCEPTANCE;
        case 100:
          return OTHER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SuspensionReason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SuspensionReason>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SuspensionReason>() {
              public SuspensionReason findValueByNumber(int number) {
                return SuspensionReason.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.channel.v1.Entitlement.getDescriptor().getEnumTypes().get(1);
    }

    private static final SuspensionReason[] VALUES = values();

    public static SuspensionReason valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SuspensionReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.channel.v1.Entitlement.SuspensionReason)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Resource name of an entitlement in the form:
   * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of an entitlement in the form:
   * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the entitlement is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the entitlement is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the entitlement is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the entitlement is updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the entitlement is updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the entitlement is updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int OFFER_FIELD_NUMBER = 8;
  private volatile java.lang.Object offer_;
  /**
   *
   *
   * <pre>
   * Required. The offer resource name for which the entitlement is to be
   * created. Takes the form: accounts/{account_id}/offers/{offer_id}.
   * </pre>
   *
   * <code>
   * string offer = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The offer.
   */
  @java.lang.Override
  public java.lang.String getOffer() {
    java.lang.Object ref = offer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      offer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The offer resource name for which the entitlement is to be
   * created. Takes the form: accounts/{account_id}/offers/{offer_id}.
   * </pre>
   *
   * <code>
   * string offer = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for offer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOfferBytes() {
    java.lang.Object ref = offer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      offer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMMITMENT_SETTINGS_FIELD_NUMBER = 12;
  private com.google.cloud.channel.v1.CommitmentSettings commitmentSettings_;
  /**
   *
   *
   * <pre>
   * Commitment settings for a commitment-based Offer.
   * Required for commitment based offers.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
   *
   * @return Whether the commitmentSettings field is set.
   */
  @java.lang.Override
  public boolean hasCommitmentSettings() {
    return commitmentSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Commitment settings for a commitment-based Offer.
   * Required for commitment based offers.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
   *
   * @return The commitmentSettings.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.CommitmentSettings getCommitmentSettings() {
    return commitmentSettings_ == null
        ? com.google.cloud.channel.v1.CommitmentSettings.getDefaultInstance()
        : commitmentSettings_;
  }
  /**
   *
   *
   * <pre>
   * Commitment settings for a commitment-based Offer.
   * Required for commitment based offers.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.CommitmentSettingsOrBuilder getCommitmentSettingsOrBuilder() {
    return getCommitmentSettings();
  }

  public static final int PROVISIONING_STATE_FIELD_NUMBER = 13;
  private int provisioningState_;
  /**
   *
   *
   * <pre>
   * Output only. Current provisioning state of the entitlement.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.Entitlement.ProvisioningState provisioning_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for provisioningState.
   */
  @java.lang.Override
  public int getProvisioningStateValue() {
    return provisioningState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current provisioning state of the entitlement.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.Entitlement.ProvisioningState provisioning_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The provisioningState.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Entitlement.ProvisioningState getProvisioningState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.channel.v1.Entitlement.ProvisioningState result =
        com.google.cloud.channel.v1.Entitlement.ProvisioningState.valueOf(provisioningState_);
    return result == null
        ? com.google.cloud.channel.v1.Entitlement.ProvisioningState.UNRECOGNIZED
        : result;
  }

  public static final int PROVISIONED_SERVICE_FIELD_NUMBER = 16;
  private com.google.cloud.channel.v1.ProvisionedService provisionedService_;
  /**
   *
   *
   * <pre>
   * Output only. Service provisioning details for the entitlement.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the provisionedService field is set.
   */
  @java.lang.Override
  public boolean hasProvisionedService() {
    return provisionedService_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Service provisioning details for the entitlement.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The provisionedService.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ProvisionedService getProvisionedService() {
    return provisionedService_ == null
        ? com.google.cloud.channel.v1.ProvisionedService.getDefaultInstance()
        : provisionedService_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Service provisioning details for the entitlement.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ProvisionedServiceOrBuilder getProvisionedServiceOrBuilder() {
    return getProvisionedService();
  }

  public static final int SUSPENSION_REASONS_FIELD_NUMBER = 18;
  private java.util.List<java.lang.Integer> suspensionReasons_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.channel.v1.Entitlement.SuspensionReason>
      suspensionReasons_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.channel.v1.Entitlement.SuspensionReason>() {
            public com.google.cloud.channel.v1.Entitlement.SuspensionReason convert(
                java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.cloud.channel.v1.Entitlement.SuspensionReason result =
                  com.google.cloud.channel.v1.Entitlement.SuspensionReason.valueOf(from);
              return result == null
                  ? com.google.cloud.channel.v1.Entitlement.SuspensionReason.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Output only. Enumerable of all current suspension reasons for an entitlement.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the suspensionReasons.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.Entitlement.SuspensionReason>
      getSuspensionReasonsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.channel.v1.Entitlement.SuspensionReason>(
        suspensionReasons_, suspensionReasons_converter_);
  }
  /**
   *
   *
   * <pre>
   * Output only. Enumerable of all current suspension reasons for an entitlement.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of suspensionReasons.
   */
  @java.lang.Override
  public int getSuspensionReasonsCount() {
    return suspensionReasons_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Enumerable of all current suspension reasons for an entitlement.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The suspensionReasons at the given index.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Entitlement.SuspensionReason getSuspensionReasons(int index) {
    return suspensionReasons_converter_.convert(suspensionReasons_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Output only. Enumerable of all current suspension reasons for an entitlement.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for suspensionReasons.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSuspensionReasonsValueList() {
    return suspensionReasons_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Enumerable of all current suspension reasons for an entitlement.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of suspensionReasons at the given index.
   */
  @java.lang.Override
  public int getSuspensionReasonsValue(int index) {
    return suspensionReasons_.get(index);
  }

  private int suspensionReasonsMemoizedSerializedSize;

  public static final int PURCHASE_ORDER_ID_FIELD_NUMBER = 19;
  private volatile java.lang.Object purchaseOrderId_;
  /**
   *
   *
   * <pre>
   * Optional. This purchase order (PO) information is for resellers to use for their
   * company tracking usage. If a purchaseOrderId value is given, it appears in
   * the API responses and shows up in the invoice. The property accepts up to
   * 80 plain text characters. This is only supported for Google Workspace
   * entitlements.
   * </pre>
   *
   * <code>string purchase_order_id = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The purchaseOrderId.
   */
  @java.lang.Override
  public java.lang.String getPurchaseOrderId() {
    java.lang.Object ref = purchaseOrderId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      purchaseOrderId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. This purchase order (PO) information is for resellers to use for their
   * company tracking usage. If a purchaseOrderId value is given, it appears in
   * the API responses and shows up in the invoice. The property accepts up to
   * 80 plain text characters. This is only supported for Google Workspace
   * entitlements.
   * </pre>
   *
   * <code>string purchase_order_id = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for purchaseOrderId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPurchaseOrderIdBytes() {
    java.lang.Object ref = purchaseOrderId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      purchaseOrderId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIAL_SETTINGS_FIELD_NUMBER = 21;
  private com.google.cloud.channel.v1.TrialSettings trialSettings_;
  /**
   *
   *
   * <pre>
   * Output only. Settings for trial offers.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the trialSettings field is set.
   */
  @java.lang.Override
  public boolean hasTrialSettings() {
    return trialSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Settings for trial offers.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The trialSettings.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.TrialSettings getTrialSettings() {
    return trialSettings_ == null
        ? com.google.cloud.channel.v1.TrialSettings.getDefaultInstance()
        : trialSettings_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Settings for trial offers.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.TrialSettingsOrBuilder getTrialSettingsOrBuilder() {
    return getTrialSettings();
  }

  public static final int ASSOCIATION_INFO_FIELD_NUMBER = 23;
  private com.google.cloud.channel.v1.AssociationInfo associationInfo_;
  /**
   *
   *
   * <pre>
   * Association information to other entitlements.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
   *
   * @return Whether the associationInfo field is set.
   */
  @java.lang.Override
  public boolean hasAssociationInfo() {
    return associationInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Association information to other entitlements.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
   *
   * @return The associationInfo.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.AssociationInfo getAssociationInfo() {
    return associationInfo_ == null
        ? com.google.cloud.channel.v1.AssociationInfo.getDefaultInstance()
        : associationInfo_;
  }
  /**
   *
   *
   * <pre>
   * Association information to other entitlements.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.AssociationInfoOrBuilder getAssociationInfoOrBuilder() {
    return getAssociationInfo();
  }

  public static final int PARAMETERS_FIELD_NUMBER = 26;
  private java.util.List<com.google.cloud.channel.v1.Parameter> parameters_;
  /**
   *
   *
   * <pre>
   * Extended entitlement parameters. When creating an entitlement, valid
   * parameter names and values are defined in the
   * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
   * The response may include the following output-only Parameters:
   * - assigned_units: The number of licenses assigned to users.
   * - max_units: The maximum assignable units for a flexible offer.
   * - num_units: The total commitment for commitment-based offers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.Parameter> getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Extended entitlement parameters. When creating an entitlement, valid
   * parameter names and values are defined in the
   * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
   * The response may include the following output-only Parameters:
   * - assigned_units: The number of licenses assigned to users.
   * - max_units: The maximum assignable units for a flexible offer.
   * - num_units: The total commitment for commitment-based offers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.channel.v1.ParameterOrBuilder>
      getParametersOrBuilderList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Extended entitlement parameters. When creating an entitlement, valid
   * parameter names and values are defined in the
   * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
   * The response may include the following output-only Parameters:
   * - assigned_units: The number of licenses assigned to users.
   * - max_units: The maximum assignable units for a flexible offer.
   * - num_units: The total commitment for commitment-based offers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
   */
  @java.lang.Override
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * Extended entitlement parameters. When creating an entitlement, valid
   * parameter names and values are defined in the
   * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
   * The response may include the following output-only Parameters:
   * - assigned_units: The number of licenses assigned to users.
   * - max_units: The maximum assignable units for a flexible offer.
   * - num_units: The total commitment for commitment-based offers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Parameter getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Extended entitlement parameters. When creating an entitlement, valid
   * parameter names and values are defined in the
   * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
   * The response may include the following output-only Parameters:
   * - assigned_units: The number of licenses assigned to users.
   * - max_units: The maximum assignable units for a flexible offer.
   * - num_units: The total commitment for commitment-based offers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ParameterOrBuilder getParametersOrBuilder(int index) {
    return parameters_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(5, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(offer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, offer_);
    }
    if (commitmentSettings_ != null) {
      output.writeMessage(12, getCommitmentSettings());
    }
    if (provisioningState_
        != com.google.cloud.channel.v1.Entitlement.ProvisioningState.PROVISIONING_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(13, provisioningState_);
    }
    if (provisionedService_ != null) {
      output.writeMessage(16, getProvisionedService());
    }
    if (getSuspensionReasonsList().size() > 0) {
      output.writeUInt32NoTag(146);
      output.writeUInt32NoTag(suspensionReasonsMemoizedSerializedSize);
    }
    for (int i = 0; i < suspensionReasons_.size(); i++) {
      output.writeEnumNoTag(suspensionReasons_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(purchaseOrderId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, purchaseOrderId_);
    }
    if (trialSettings_ != null) {
      output.writeMessage(21, getTrialSettings());
    }
    if (associationInfo_ != null) {
      output.writeMessage(23, getAssociationInfo());
    }
    for (int i = 0; i < parameters_.size(); i++) {
      output.writeMessage(26, parameters_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(offer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, offer_);
    }
    if (commitmentSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getCommitmentSettings());
    }
    if (provisioningState_
        != com.google.cloud.channel.v1.Entitlement.ProvisioningState.PROVISIONING_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, provisioningState_);
    }
    if (provisionedService_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getProvisionedService());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < suspensionReasons_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(suspensionReasons_.get(i));
      }
      size += dataSize;
      if (!getSuspensionReasonsList().isEmpty()) {
        size += 2;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      suspensionReasonsMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(purchaseOrderId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, purchaseOrderId_);
    }
    if (trialSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getTrialSettings());
    }
    if (associationInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getAssociationInfo());
    }
    for (int i = 0; i < parameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, parameters_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.Entitlement)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.Entitlement other = (com.google.cloud.channel.v1.Entitlement) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getOffer().equals(other.getOffer())) return false;
    if (hasCommitmentSettings() != other.hasCommitmentSettings()) return false;
    if (hasCommitmentSettings()) {
      if (!getCommitmentSettings().equals(other.getCommitmentSettings())) return false;
    }
    if (provisioningState_ != other.provisioningState_) return false;
    if (hasProvisionedService() != other.hasProvisionedService()) return false;
    if (hasProvisionedService()) {
      if (!getProvisionedService().equals(other.getProvisionedService())) return false;
    }
    if (!suspensionReasons_.equals(other.suspensionReasons_)) return false;
    if (!getPurchaseOrderId().equals(other.getPurchaseOrderId())) return false;
    if (hasTrialSettings() != other.hasTrialSettings()) return false;
    if (hasTrialSettings()) {
      if (!getTrialSettings().equals(other.getTrialSettings())) return false;
    }
    if (hasAssociationInfo() != other.hasAssociationInfo()) return false;
    if (hasAssociationInfo()) {
      if (!getAssociationInfo().equals(other.getAssociationInfo())) return false;
    }
    if (!getParametersList().equals(other.getParametersList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + OFFER_FIELD_NUMBER;
    hash = (53 * hash) + getOffer().hashCode();
    if (hasCommitmentSettings()) {
      hash = (37 * hash) + COMMITMENT_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getCommitmentSettings().hashCode();
    }
    hash = (37 * hash) + PROVISIONING_STATE_FIELD_NUMBER;
    hash = (53 * hash) + provisioningState_;
    if (hasProvisionedService()) {
      hash = (37 * hash) + PROVISIONED_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getProvisionedService().hashCode();
    }
    if (getSuspensionReasonsCount() > 0) {
      hash = (37 * hash) + SUSPENSION_REASONS_FIELD_NUMBER;
      hash = (53 * hash) + suspensionReasons_.hashCode();
    }
    hash = (37 * hash) + PURCHASE_ORDER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPurchaseOrderId().hashCode();
    if (hasTrialSettings()) {
      hash = (37 * hash) + TRIAL_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getTrialSettings().hashCode();
    }
    if (hasAssociationInfo()) {
      hash = (37 * hash) + ASSOCIATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getAssociationInfo().hashCode();
    }
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.Entitlement parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Entitlement parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Entitlement parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Entitlement parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Entitlement parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Entitlement parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Entitlement parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Entitlement parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Entitlement parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Entitlement parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Entitlement parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Entitlement parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.Entitlement prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An entitlement is a representation of a customer's ability to use a service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.Entitlement}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.Entitlement)
      com.google.cloud.channel.v1.EntitlementOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.EntitlementsProto
          .internal_static_google_cloud_channel_v1_Entitlement_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.EntitlementsProto
          .internal_static_google_cloud_channel_v1_Entitlement_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.Entitlement.class,
              com.google.cloud.channel.v1.Entitlement.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.Entitlement.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      offer_ = "";

      if (commitmentSettingsBuilder_ == null) {
        commitmentSettings_ = null;
      } else {
        commitmentSettings_ = null;
        commitmentSettingsBuilder_ = null;
      }
      provisioningState_ = 0;

      if (provisionedServiceBuilder_ == null) {
        provisionedService_ = null;
      } else {
        provisionedService_ = null;
        provisionedServiceBuilder_ = null;
      }
      suspensionReasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      purchaseOrderId_ = "";

      if (trialSettingsBuilder_ == null) {
        trialSettings_ = null;
      } else {
        trialSettings_ = null;
        trialSettingsBuilder_ = null;
      }
      if (associationInfoBuilder_ == null) {
        associationInfo_ = null;
      } else {
        associationInfo_ = null;
        associationInfoBuilder_ = null;
      }
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
      } else {
        parameters_ = null;
        parametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.EntitlementsProto
          .internal_static_google_cloud_channel_v1_Entitlement_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Entitlement getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.Entitlement.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Entitlement build() {
      com.google.cloud.channel.v1.Entitlement result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Entitlement buildPartial() {
      com.google.cloud.channel.v1.Entitlement result =
          new com.google.cloud.channel.v1.Entitlement(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.offer_ = offer_;
      if (commitmentSettingsBuilder_ == null) {
        result.commitmentSettings_ = commitmentSettings_;
      } else {
        result.commitmentSettings_ = commitmentSettingsBuilder_.build();
      }
      result.provisioningState_ = provisioningState_;
      if (provisionedServiceBuilder_ == null) {
        result.provisionedService_ = provisionedService_;
      } else {
        result.provisionedService_ = provisionedServiceBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        suspensionReasons_ = java.util.Collections.unmodifiableList(suspensionReasons_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.suspensionReasons_ = suspensionReasons_;
      result.purchaseOrderId_ = purchaseOrderId_;
      if (trialSettingsBuilder_ == null) {
        result.trialSettings_ = trialSettings_;
      } else {
        result.trialSettings_ = trialSettingsBuilder_.build();
      }
      if (associationInfoBuilder_ == null) {
        result.associationInfo_ = associationInfo_;
      } else {
        result.associationInfo_ = associationInfoBuilder_.build();
      }
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.Entitlement) {
        return mergeFrom((com.google.cloud.channel.v1.Entitlement) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.Entitlement other) {
      if (other == com.google.cloud.channel.v1.Entitlement.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getOffer().isEmpty()) {
        offer_ = other.offer_;
        onChanged();
      }
      if (other.hasCommitmentSettings()) {
        mergeCommitmentSettings(other.getCommitmentSettings());
      }
      if (other.provisioningState_ != 0) {
        setProvisioningStateValue(other.getProvisioningStateValue());
      }
      if (other.hasProvisionedService()) {
        mergeProvisionedService(other.getProvisionedService());
      }
      if (!other.suspensionReasons_.isEmpty()) {
        if (suspensionReasons_.isEmpty()) {
          suspensionReasons_ = other.suspensionReasons_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureSuspensionReasonsIsMutable();
          suspensionReasons_.addAll(other.suspensionReasons_);
        }
        onChanged();
      }
      if (!other.getPurchaseOrderId().isEmpty()) {
        purchaseOrderId_ = other.purchaseOrderId_;
        onChanged();
      }
      if (other.hasTrialSettings()) {
        mergeTrialSettings(other.getTrialSettings());
      }
      if (other.hasAssociationInfo()) {
        mergeAssociationInfo(other.getAssociationInfo());
      }
      if (parametersBuilder_ == null) {
        if (!other.parameters_.isEmpty()) {
          if (parameters_.isEmpty()) {
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureParametersIsMutable();
            parameters_.addAll(other.parameters_);
          }
          onChanged();
        }
      } else {
        if (!other.parameters_.isEmpty()) {
          if (parametersBuilder_.isEmpty()) {
            parametersBuilder_.dispose();
            parametersBuilder_ = null;
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000002);
            parametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParametersFieldBuilder()
                    : null;
          } else {
            parametersBuilder_.addAllMessages(other.parameters_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 66:
              {
                offer_ = input.readStringRequireUtf8();

                break;
              } // case 66
            case 98:
              {
                input.readMessage(
                    getCommitmentSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 98
            case 104:
              {
                provisioningState_ = input.readEnum();

                break;
              } // case 104
            case 130:
              {
                input.readMessage(
                    getProvisionedServiceFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 130
            case 144:
              {
                int tmpRaw = input.readEnum();
                ensureSuspensionReasonsIsMutable();
                suspensionReasons_.add(tmpRaw);
                break;
              } // case 144
            case 146:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSuspensionReasonsIsMutable();
                  suspensionReasons_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 146
            case 154:
              {
                purchaseOrderId_ = input.readStringRequireUtf8();

                break;
              } // case 154
            case 170:
              {
                input.readMessage(getTrialSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 170
            case 186:
              {
                input.readMessage(getAssociationInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 186
            case 210:
              {
                com.google.cloud.channel.v1.Parameter m =
                    input.readMessage(
                        com.google.cloud.channel.v1.Parameter.parser(), extensionRegistry);
                if (parametersBuilder_ == null) {
                  ensureParametersIsMutable();
                  parameters_.add(m);
                } else {
                  parametersBuilder_.addMessage(m);
                }
                break;
              } // case 210
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of an entitlement in the form:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of an entitlement in the form:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of an entitlement in the form:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of an entitlement in the form:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of an entitlement in the form:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the entitlement is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object offer_ = "";
    /**
     *
     *
     * <pre>
     * Required. The offer resource name for which the entitlement is to be
     * created. Takes the form: accounts/{account_id}/offers/{offer_id}.
     * </pre>
     *
     * <code>
     * string offer = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The offer.
     */
    public java.lang.String getOffer() {
      java.lang.Object ref = offer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        offer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The offer resource name for which the entitlement is to be
     * created. Takes the form: accounts/{account_id}/offers/{offer_id}.
     * </pre>
     *
     * <code>
     * string offer = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for offer.
     */
    public com.google.protobuf.ByteString getOfferBytes() {
      java.lang.Object ref = offer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        offer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The offer resource name for which the entitlement is to be
     * created. Takes the form: accounts/{account_id}/offers/{offer_id}.
     * </pre>
     *
     * <code>
     * string offer = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The offer to set.
     * @return This builder for chaining.
     */
    public Builder setOffer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      offer_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The offer resource name for which the entitlement is to be
     * created. Takes the form: accounts/{account_id}/offers/{offer_id}.
     * </pre>
     *
     * <code>
     * string offer = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOffer() {

      offer_ = getDefaultInstance().getOffer();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The offer resource name for which the entitlement is to be
     * created. Takes the form: accounts/{account_id}/offers/{offer_id}.
     * </pre>
     *
     * <code>
     * string offer = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for offer to set.
     * @return This builder for chaining.
     */
    public Builder setOfferBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      offer_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.channel.v1.CommitmentSettings commitmentSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.CommitmentSettings,
            com.google.cloud.channel.v1.CommitmentSettings.Builder,
            com.google.cloud.channel.v1.CommitmentSettingsOrBuilder>
        commitmentSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Commitment settings for a commitment-based Offer.
     * Required for commitment based offers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
     *
     * @return Whether the commitmentSettings field is set.
     */
    public boolean hasCommitmentSettings() {
      return commitmentSettingsBuilder_ != null || commitmentSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Commitment settings for a commitment-based Offer.
     * Required for commitment based offers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
     *
     * @return The commitmentSettings.
     */
    public com.google.cloud.channel.v1.CommitmentSettings getCommitmentSettings() {
      if (commitmentSettingsBuilder_ == null) {
        return commitmentSettings_ == null
            ? com.google.cloud.channel.v1.CommitmentSettings.getDefaultInstance()
            : commitmentSettings_;
      } else {
        return commitmentSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Commitment settings for a commitment-based Offer.
     * Required for commitment based offers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
     */
    public Builder setCommitmentSettings(com.google.cloud.channel.v1.CommitmentSettings value) {
      if (commitmentSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commitmentSettings_ = value;
        onChanged();
      } else {
        commitmentSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Commitment settings for a commitment-based Offer.
     * Required for commitment based offers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
     */
    public Builder setCommitmentSettings(
        com.google.cloud.channel.v1.CommitmentSettings.Builder builderForValue) {
      if (commitmentSettingsBuilder_ == null) {
        commitmentSettings_ = builderForValue.build();
        onChanged();
      } else {
        commitmentSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Commitment settings for a commitment-based Offer.
     * Required for commitment based offers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
     */
    public Builder mergeCommitmentSettings(com.google.cloud.channel.v1.CommitmentSettings value) {
      if (commitmentSettingsBuilder_ == null) {
        if (commitmentSettings_ != null) {
          commitmentSettings_ =
              com.google.cloud.channel.v1.CommitmentSettings.newBuilder(commitmentSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          commitmentSettings_ = value;
        }
        onChanged();
      } else {
        commitmentSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Commitment settings for a commitment-based Offer.
     * Required for commitment based offers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
     */
    public Builder clearCommitmentSettings() {
      if (commitmentSettingsBuilder_ == null) {
        commitmentSettings_ = null;
        onChanged();
      } else {
        commitmentSettings_ = null;
        commitmentSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Commitment settings for a commitment-based Offer.
     * Required for commitment based offers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
     */
    public com.google.cloud.channel.v1.CommitmentSettings.Builder getCommitmentSettingsBuilder() {

      onChanged();
      return getCommitmentSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Commitment settings for a commitment-based Offer.
     * Required for commitment based offers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
     */
    public com.google.cloud.channel.v1.CommitmentSettingsOrBuilder
        getCommitmentSettingsOrBuilder() {
      if (commitmentSettingsBuilder_ != null) {
        return commitmentSettingsBuilder_.getMessageOrBuilder();
      } else {
        return commitmentSettings_ == null
            ? com.google.cloud.channel.v1.CommitmentSettings.getDefaultInstance()
            : commitmentSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Commitment settings for a commitment-based Offer.
     * Required for commitment based offers.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CommitmentSettings commitment_settings = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.CommitmentSettings,
            com.google.cloud.channel.v1.CommitmentSettings.Builder,
            com.google.cloud.channel.v1.CommitmentSettingsOrBuilder>
        getCommitmentSettingsFieldBuilder() {
      if (commitmentSettingsBuilder_ == null) {
        commitmentSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.CommitmentSettings,
                com.google.cloud.channel.v1.CommitmentSettings.Builder,
                com.google.cloud.channel.v1.CommitmentSettingsOrBuilder>(
                getCommitmentSettings(), getParentForChildren(), isClean());
        commitmentSettings_ = null;
      }
      return commitmentSettingsBuilder_;
    }

    private int provisioningState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current provisioning state of the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.Entitlement.ProvisioningState provisioning_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for provisioningState.
     */
    @java.lang.Override
    public int getProvisioningStateValue() {
      return provisioningState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current provisioning state of the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.Entitlement.ProvisioningState provisioning_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for provisioningState to set.
     * @return This builder for chaining.
     */
    public Builder setProvisioningStateValue(int value) {

      provisioningState_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current provisioning state of the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.Entitlement.ProvisioningState provisioning_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The provisioningState.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.Entitlement.ProvisioningState getProvisioningState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.Entitlement.ProvisioningState result =
          com.google.cloud.channel.v1.Entitlement.ProvisioningState.valueOf(provisioningState_);
      return result == null
          ? com.google.cloud.channel.v1.Entitlement.ProvisioningState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current provisioning state of the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.Entitlement.ProvisioningState provisioning_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The provisioningState to set.
     * @return This builder for chaining.
     */
    public Builder setProvisioningState(
        com.google.cloud.channel.v1.Entitlement.ProvisioningState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      provisioningState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current provisioning state of the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.Entitlement.ProvisioningState provisioning_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProvisioningState() {

      provisioningState_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.channel.v1.ProvisionedService provisionedService_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.ProvisionedService,
            com.google.cloud.channel.v1.ProvisionedService.Builder,
            com.google.cloud.channel.v1.ProvisionedServiceOrBuilder>
        provisionedServiceBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Service provisioning details for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the provisionedService field is set.
     */
    public boolean hasProvisionedService() {
      return provisionedServiceBuilder_ != null || provisionedService_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Service provisioning details for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The provisionedService.
     */
    public com.google.cloud.channel.v1.ProvisionedService getProvisionedService() {
      if (provisionedServiceBuilder_ == null) {
        return provisionedService_ == null
            ? com.google.cloud.channel.v1.ProvisionedService.getDefaultInstance()
            : provisionedService_;
      } else {
        return provisionedServiceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Service provisioning details for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProvisionedService(com.google.cloud.channel.v1.ProvisionedService value) {
      if (provisionedServiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        provisionedService_ = value;
        onChanged();
      } else {
        provisionedServiceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Service provisioning details for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProvisionedService(
        com.google.cloud.channel.v1.ProvisionedService.Builder builderForValue) {
      if (provisionedServiceBuilder_ == null) {
        provisionedService_ = builderForValue.build();
        onChanged();
      } else {
        provisionedServiceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Service provisioning details for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeProvisionedService(com.google.cloud.channel.v1.ProvisionedService value) {
      if (provisionedServiceBuilder_ == null) {
        if (provisionedService_ != null) {
          provisionedService_ =
              com.google.cloud.channel.v1.ProvisionedService.newBuilder(provisionedService_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          provisionedService_ = value;
        }
        onChanged();
      } else {
        provisionedServiceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Service provisioning details for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearProvisionedService() {
      if (provisionedServiceBuilder_ == null) {
        provisionedService_ = null;
        onChanged();
      } else {
        provisionedService_ = null;
        provisionedServiceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Service provisioning details for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.channel.v1.ProvisionedService.Builder getProvisionedServiceBuilder() {

      onChanged();
      return getProvisionedServiceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Service provisioning details for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.channel.v1.ProvisionedServiceOrBuilder
        getProvisionedServiceOrBuilder() {
      if (provisionedServiceBuilder_ != null) {
        return provisionedServiceBuilder_.getMessageOrBuilder();
      } else {
        return provisionedService_ == null
            ? com.google.cloud.channel.v1.ProvisionedService.getDefaultInstance()
            : provisionedService_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Service provisioning details for the entitlement.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ProvisionedService provisioned_service = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.ProvisionedService,
            com.google.cloud.channel.v1.ProvisionedService.Builder,
            com.google.cloud.channel.v1.ProvisionedServiceOrBuilder>
        getProvisionedServiceFieldBuilder() {
      if (provisionedServiceBuilder_ == null) {
        provisionedServiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.ProvisionedService,
                com.google.cloud.channel.v1.ProvisionedService.Builder,
                com.google.cloud.channel.v1.ProvisionedServiceOrBuilder>(
                getProvisionedService(), getParentForChildren(), isClean());
        provisionedService_ = null;
      }
      return provisionedServiceBuilder_;
    }

    private java.util.List<java.lang.Integer> suspensionReasons_ =
        java.util.Collections.emptyList();

    private void ensureSuspensionReasonsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        suspensionReasons_ = new java.util.ArrayList<java.lang.Integer>(suspensionReasons_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the suspensionReasons.
     */
    public java.util.List<com.google.cloud.channel.v1.Entitlement.SuspensionReason>
        getSuspensionReasonsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.channel.v1.Entitlement.SuspensionReason>(
          suspensionReasons_, suspensionReasons_converter_);
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of suspensionReasons.
     */
    public int getSuspensionReasonsCount() {
      return suspensionReasons_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The suspensionReasons at the given index.
     */
    public com.google.cloud.channel.v1.Entitlement.SuspensionReason getSuspensionReasons(
        int index) {
      return suspensionReasons_converter_.convert(suspensionReasons_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The suspensionReasons to set.
     * @return This builder for chaining.
     */
    public Builder setSuspensionReasons(
        int index, com.google.cloud.channel.v1.Entitlement.SuspensionReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addSuspensionReasons(
        com.google.cloud.channel.v1.Entitlement.SuspensionReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllSuspensionReasons(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.Entitlement.SuspensionReason>
            values) {
      ensureSuspensionReasonsIsMutable();
      for (com.google.cloud.channel.v1.Entitlement.SuspensionReason value : values) {
        suspensionReasons_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuspensionReasons() {
      suspensionReasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for suspensionReasons.
     */
    public java.util.List<java.lang.Integer> getSuspensionReasonsValueList() {
      return java.util.Collections.unmodifiableList(suspensionReasons_);
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of suspensionReasons at the given index.
     */
    public int getSuspensionReasonsValue(int index) {
      return suspensionReasons_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for suspensionReasons to set.
     * @return This builder for chaining.
     */
    public Builder setSuspensionReasonsValue(int index, int value) {
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addSuspensionReasonsValue(int value) {
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Enumerable of all current suspension reasons for an entitlement.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Entitlement.SuspensionReason suspension_reasons = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The enum numeric values on the wire for suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllSuspensionReasonsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSuspensionReasonsIsMutable();
      for (int value : values) {
        suspensionReasons_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object purchaseOrderId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. This purchase order (PO) information is for resellers to use for their
     * company tracking usage. If a purchaseOrderId value is given, it appears in
     * the API responses and shows up in the invoice. The property accepts up to
     * 80 plain text characters. This is only supported for Google Workspace
     * entitlements.
     * </pre>
     *
     * <code>string purchase_order_id = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The purchaseOrderId.
     */
    public java.lang.String getPurchaseOrderId() {
      java.lang.Object ref = purchaseOrderId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        purchaseOrderId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This purchase order (PO) information is for resellers to use for their
     * company tracking usage. If a purchaseOrderId value is given, it appears in
     * the API responses and shows up in the invoice. The property accepts up to
     * 80 plain text characters. This is only supported for Google Workspace
     * entitlements.
     * </pre>
     *
     * <code>string purchase_order_id = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for purchaseOrderId.
     */
    public com.google.protobuf.ByteString getPurchaseOrderIdBytes() {
      java.lang.Object ref = purchaseOrderId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        purchaseOrderId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This purchase order (PO) information is for resellers to use for their
     * company tracking usage. If a purchaseOrderId value is given, it appears in
     * the API responses and shows up in the invoice. The property accepts up to
     * 80 plain text characters. This is only supported for Google Workspace
     * entitlements.
     * </pre>
     *
     * <code>string purchase_order_id = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The purchaseOrderId to set.
     * @return This builder for chaining.
     */
    public Builder setPurchaseOrderId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      purchaseOrderId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This purchase order (PO) information is for resellers to use for their
     * company tracking usage. If a purchaseOrderId value is given, it appears in
     * the API responses and shows up in the invoice. The property accepts up to
     * 80 plain text characters. This is only supported for Google Workspace
     * entitlements.
     * </pre>
     *
     * <code>string purchase_order_id = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPurchaseOrderId() {

      purchaseOrderId_ = getDefaultInstance().getPurchaseOrderId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This purchase order (PO) information is for resellers to use for their
     * company tracking usage. If a purchaseOrderId value is given, it appears in
     * the API responses and shows up in the invoice. The property accepts up to
     * 80 plain text characters. This is only supported for Google Workspace
     * entitlements.
     * </pre>
     *
     * <code>string purchase_order_id = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for purchaseOrderId to set.
     * @return This builder for chaining.
     */
    public Builder setPurchaseOrderIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      purchaseOrderId_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.channel.v1.TrialSettings trialSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.TrialSettings,
            com.google.cloud.channel.v1.TrialSettings.Builder,
            com.google.cloud.channel.v1.TrialSettingsOrBuilder>
        trialSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Settings for trial offers.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the trialSettings field is set.
     */
    public boolean hasTrialSettings() {
      return trialSettingsBuilder_ != null || trialSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Settings for trial offers.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The trialSettings.
     */
    public com.google.cloud.channel.v1.TrialSettings getTrialSettings() {
      if (trialSettingsBuilder_ == null) {
        return trialSettings_ == null
            ? com.google.cloud.channel.v1.TrialSettings.getDefaultInstance()
            : trialSettings_;
      } else {
        return trialSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Settings for trial offers.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTrialSettings(com.google.cloud.channel.v1.TrialSettings value) {
      if (trialSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trialSettings_ = value;
        onChanged();
      } else {
        trialSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Settings for trial offers.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTrialSettings(
        com.google.cloud.channel.v1.TrialSettings.Builder builderForValue) {
      if (trialSettingsBuilder_ == null) {
        trialSettings_ = builderForValue.build();
        onChanged();
      } else {
        trialSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Settings for trial offers.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTrialSettings(com.google.cloud.channel.v1.TrialSettings value) {
      if (trialSettingsBuilder_ == null) {
        if (trialSettings_ != null) {
          trialSettings_ =
              com.google.cloud.channel.v1.TrialSettings.newBuilder(trialSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trialSettings_ = value;
        }
        onChanged();
      } else {
        trialSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Settings for trial offers.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTrialSettings() {
      if (trialSettingsBuilder_ == null) {
        trialSettings_ = null;
        onChanged();
      } else {
        trialSettings_ = null;
        trialSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Settings for trial offers.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.channel.v1.TrialSettings.Builder getTrialSettingsBuilder() {

      onChanged();
      return getTrialSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Settings for trial offers.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.channel.v1.TrialSettingsOrBuilder getTrialSettingsOrBuilder() {
      if (trialSettingsBuilder_ != null) {
        return trialSettingsBuilder_.getMessageOrBuilder();
      } else {
        return trialSettings_ == null
            ? com.google.cloud.channel.v1.TrialSettings.getDefaultInstance()
            : trialSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Settings for trial offers.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.TrialSettings trial_settings = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.TrialSettings,
            com.google.cloud.channel.v1.TrialSettings.Builder,
            com.google.cloud.channel.v1.TrialSettingsOrBuilder>
        getTrialSettingsFieldBuilder() {
      if (trialSettingsBuilder_ == null) {
        trialSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.TrialSettings,
                com.google.cloud.channel.v1.TrialSettings.Builder,
                com.google.cloud.channel.v1.TrialSettingsOrBuilder>(
                getTrialSettings(), getParentForChildren(), isClean());
        trialSettings_ = null;
      }
      return trialSettingsBuilder_;
    }

    private com.google.cloud.channel.v1.AssociationInfo associationInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.AssociationInfo,
            com.google.cloud.channel.v1.AssociationInfo.Builder,
            com.google.cloud.channel.v1.AssociationInfoOrBuilder>
        associationInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Association information to other entitlements.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
     *
     * @return Whether the associationInfo field is set.
     */
    public boolean hasAssociationInfo() {
      return associationInfoBuilder_ != null || associationInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Association information to other entitlements.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
     *
     * @return The associationInfo.
     */
    public com.google.cloud.channel.v1.AssociationInfo getAssociationInfo() {
      if (associationInfoBuilder_ == null) {
        return associationInfo_ == null
            ? com.google.cloud.channel.v1.AssociationInfo.getDefaultInstance()
            : associationInfo_;
      } else {
        return associationInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Association information to other entitlements.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
     */
    public Builder setAssociationInfo(com.google.cloud.channel.v1.AssociationInfo value) {
      if (associationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        associationInfo_ = value;
        onChanged();
      } else {
        associationInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Association information to other entitlements.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
     */
    public Builder setAssociationInfo(
        com.google.cloud.channel.v1.AssociationInfo.Builder builderForValue) {
      if (associationInfoBuilder_ == null) {
        associationInfo_ = builderForValue.build();
        onChanged();
      } else {
        associationInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Association information to other entitlements.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
     */
    public Builder mergeAssociationInfo(com.google.cloud.channel.v1.AssociationInfo value) {
      if (associationInfoBuilder_ == null) {
        if (associationInfo_ != null) {
          associationInfo_ =
              com.google.cloud.channel.v1.AssociationInfo.newBuilder(associationInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          associationInfo_ = value;
        }
        onChanged();
      } else {
        associationInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Association information to other entitlements.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
     */
    public Builder clearAssociationInfo() {
      if (associationInfoBuilder_ == null) {
        associationInfo_ = null;
        onChanged();
      } else {
        associationInfo_ = null;
        associationInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Association information to other entitlements.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
     */
    public com.google.cloud.channel.v1.AssociationInfo.Builder getAssociationInfoBuilder() {

      onChanged();
      return getAssociationInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Association information to other entitlements.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
     */
    public com.google.cloud.channel.v1.AssociationInfoOrBuilder getAssociationInfoOrBuilder() {
      if (associationInfoBuilder_ != null) {
        return associationInfoBuilder_.getMessageOrBuilder();
      } else {
        return associationInfo_ == null
            ? com.google.cloud.channel.v1.AssociationInfo.getDefaultInstance()
            : associationInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Association information to other entitlements.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.AssociationInfo association_info = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.AssociationInfo,
            com.google.cloud.channel.v1.AssociationInfo.Builder,
            com.google.cloud.channel.v1.AssociationInfoOrBuilder>
        getAssociationInfoFieldBuilder() {
      if (associationInfoBuilder_ == null) {
        associationInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.AssociationInfo,
                com.google.cloud.channel.v1.AssociationInfo.Builder,
                com.google.cloud.channel.v1.AssociationInfoOrBuilder>(
                getAssociationInfo(), getParentForChildren(), isClean());
        associationInfo_ = null;
      }
      return associationInfoBuilder_;
    }

    private java.util.List<com.google.cloud.channel.v1.Parameter> parameters_ =
        java.util.Collections.emptyList();

    private void ensureParametersIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        parameters_ = new java.util.ArrayList<com.google.cloud.channel.v1.Parameter>(parameters_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.Parameter,
            com.google.cloud.channel.v1.Parameter.Builder,
            com.google.cloud.channel.v1.ParameterOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.Parameter> getParametersList() {
      if (parametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameters_);
      } else {
        return parametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public int getParametersCount() {
      if (parametersBuilder_ == null) {
        return parameters_.size();
      } else {
        return parametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public com.google.cloud.channel.v1.Parameter getParameters(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public Builder setParameters(int index, com.google.cloud.channel.v1.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.set(index, value);
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public Builder setParameters(
        int index, com.google.cloud.channel.v1.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public Builder addParameters(com.google.cloud.channel.v1.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public Builder addParameters(int index, com.google.cloud.channel.v1.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(index, value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public Builder addParameters(com.google.cloud.channel.v1.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public Builder addParameters(
        int index, com.google.cloud.channel.v1.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public Builder addAllParameters(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.Parameter> values) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
        onChanged();
      } else {
        parametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        parametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public Builder removeParameters(int index) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.remove(index);
        onChanged();
      } else {
        parametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public com.google.cloud.channel.v1.Parameter.Builder getParametersBuilder(int index) {
      return getParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public com.google.cloud.channel.v1.ParameterOrBuilder getParametersOrBuilder(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public java.util.List<? extends com.google.cloud.channel.v1.ParameterOrBuilder>
        getParametersOrBuilderList() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public com.google.cloud.channel.v1.Parameter.Builder addParametersBuilder() {
      return getParametersFieldBuilder()
          .addBuilder(com.google.cloud.channel.v1.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public com.google.cloud.channel.v1.Parameter.Builder addParametersBuilder(int index) {
      return getParametersFieldBuilder()
          .addBuilder(index, com.google.cloud.channel.v1.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Extended entitlement parameters. When creating an entitlement, valid
     * parameter names and values are defined in the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
     * The response may include the following output-only Parameters:
     * - assigned_units: The number of licenses assigned to users.
     * - max_units: The maximum assignable units for a flexible offer.
     * - num_units: The total commitment for commitment-based offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.Parameter parameters = 26;</code>
     */
    public java.util.List<com.google.cloud.channel.v1.Parameter.Builder>
        getParametersBuilderList() {
      return getParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.Parameter,
            com.google.cloud.channel.v1.Parameter.Builder,
            com.google.cloud.channel.v1.ParameterOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.channel.v1.Parameter,
                com.google.cloud.channel.v1.Parameter.Builder,
                com.google.cloud.channel.v1.ParameterOrBuilder>(
                parameters_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.Entitlement)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.Entitlement)
  private static final com.google.cloud.channel.v1.Entitlement DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.Entitlement();
  }

  public static com.google.cloud.channel.v1.Entitlement getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Entitlement> PARSER =
      new com.google.protobuf.AbstractParser<Entitlement>() {
        @java.lang.Override
        public Entitlement parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Entitlement> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Entitlement> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.Entitlement getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
