/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/offers.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Represents constraints required to purchase the Offer for a customer.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.CustomerConstraints}
 */
public final class CustomerConstraints extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.CustomerConstraints)
    CustomerConstraintsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CustomerConstraints.newBuilder() to construct.
  private CustomerConstraints(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomerConstraints() {
    allowedRegions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    allowedCustomerTypes_ = java.util.Collections.emptyList();
    promotionalOrderTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomerConstraints();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_CustomerConstraints_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.OffersProto
        .internal_static_google_cloud_channel_v1_CustomerConstraints_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.CustomerConstraints.class,
            com.google.cloud.channel.v1.CustomerConstraints.Builder.class);
  }

  public static final int ALLOWED_REGIONS_FIELD_NUMBER = 1;
  private com.google.protobuf.LazyStringList allowedRegions_;
  /**
   *
   *
   * <pre>
   * Allowed geographical regions of the customer.
   * </pre>
   *
   * <code>repeated string allowed_regions = 1;</code>
   *
   * @return A list containing the allowedRegions.
   */
  public com.google.protobuf.ProtocolStringList getAllowedRegionsList() {
    return allowedRegions_;
  }
  /**
   *
   *
   * <pre>
   * Allowed geographical regions of the customer.
   * </pre>
   *
   * <code>repeated string allowed_regions = 1;</code>
   *
   * @return The count of allowedRegions.
   */
  public int getAllowedRegionsCount() {
    return allowedRegions_.size();
  }
  /**
   *
   *
   * <pre>
   * Allowed geographical regions of the customer.
   * </pre>
   *
   * <code>repeated string allowed_regions = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The allowedRegions at the given index.
   */
  public java.lang.String getAllowedRegions(int index) {
    return allowedRegions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Allowed geographical regions of the customer.
   * </pre>
   *
   * <code>repeated string allowed_regions = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowedRegions at the given index.
   */
  public com.google.protobuf.ByteString getAllowedRegionsBytes(int index) {
    return allowedRegions_.getByteString(index);
  }

  public static final int ALLOWED_CUSTOMER_TYPES_FIELD_NUMBER = 2;
  private java.util.List<java.lang.Integer> allowedCustomerTypes_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType>
      allowedCustomerTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType>() {
            public com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType convert(
                java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType result =
                  com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType.valueOf(from);
              return result == null
                  ? com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Allowed Customer Type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
   * </code>
   *
   * @return A list containing the allowedCustomerTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType>
      getAllowedCustomerTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType>(
        allowedCustomerTypes_, allowedCustomerTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * Allowed Customer Type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
   * </code>
   *
   * @return The count of allowedCustomerTypes.
   */
  @java.lang.Override
  public int getAllowedCustomerTypesCount() {
    return allowedCustomerTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Allowed Customer Type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The allowedCustomerTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType getAllowedCustomerTypes(
      int index) {
    return allowedCustomerTypes_converter_.convert(allowedCustomerTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Allowed Customer Type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for allowedCustomerTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getAllowedCustomerTypesValueList() {
    return allowedCustomerTypes_;
  }
  /**
   *
   *
   * <pre>
   * Allowed Customer Type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of allowedCustomerTypes at the given index.
   */
  @java.lang.Override
  public int getAllowedCustomerTypesValue(int index) {
    return allowedCustomerTypes_.get(index);
  }

  private int allowedCustomerTypesMemoizedSerializedSize;

  public static final int PROMOTIONAL_ORDER_TYPES_FIELD_NUMBER = 3;
  private java.util.List<java.lang.Integer> promotionalOrderTypes_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.channel.v1.PromotionalOrderType>
      promotionalOrderTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.channel.v1.PromotionalOrderType>() {
            public com.google.cloud.channel.v1.PromotionalOrderType convert(
                java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.cloud.channel.v1.PromotionalOrderType result =
                  com.google.cloud.channel.v1.PromotionalOrderType.valueOf(from);
              return result == null
                  ? com.google.cloud.channel.v1.PromotionalOrderType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Allowed Promotional Order Type. Present for Promotional offers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
   * </code>
   *
   * @return A list containing the promotionalOrderTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.PromotionalOrderType>
      getPromotionalOrderTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.channel.v1.PromotionalOrderType>(
        promotionalOrderTypes_, promotionalOrderTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * Allowed Promotional Order Type. Present for Promotional offers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
   * </code>
   *
   * @return The count of promotionalOrderTypes.
   */
  @java.lang.Override
  public int getPromotionalOrderTypesCount() {
    return promotionalOrderTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Allowed Promotional Order Type. Present for Promotional offers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The promotionalOrderTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.PromotionalOrderType getPromotionalOrderTypes(int index) {
    return promotionalOrderTypes_converter_.convert(promotionalOrderTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Allowed Promotional Order Type. Present for Promotional offers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for promotionalOrderTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getPromotionalOrderTypesValueList() {
    return promotionalOrderTypes_;
  }
  /**
   *
   *
   * <pre>
   * Allowed Promotional Order Type. Present for Promotional offers.
   * </pre>
   *
   * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of promotionalOrderTypes at the given index.
   */
  @java.lang.Override
  public int getPromotionalOrderTypesValue(int index) {
    return promotionalOrderTypes_.get(index);
  }

  private int promotionalOrderTypesMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    for (int i = 0; i < allowedRegions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, allowedRegions_.getRaw(i));
    }
    if (getAllowedCustomerTypesList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(allowedCustomerTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < allowedCustomerTypes_.size(); i++) {
      output.writeEnumNoTag(allowedCustomerTypes_.get(i));
    }
    if (getPromotionalOrderTypesList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(promotionalOrderTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < promotionalOrderTypes_.size(); i++) {
      output.writeEnumNoTag(promotionalOrderTypes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < allowedRegions_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowedRegions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAllowedRegionsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < allowedCustomerTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                allowedCustomerTypes_.get(i));
      }
      size += dataSize;
      if (!getAllowedCustomerTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      allowedCustomerTypesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < promotionalOrderTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                promotionalOrderTypes_.get(i));
      }
      size += dataSize;
      if (!getPromotionalOrderTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      promotionalOrderTypesMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.CustomerConstraints)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.CustomerConstraints other =
        (com.google.cloud.channel.v1.CustomerConstraints) obj;

    if (!getAllowedRegionsList().equals(other.getAllowedRegionsList())) return false;
    if (!allowedCustomerTypes_.equals(other.allowedCustomerTypes_)) return false;
    if (!promotionalOrderTypes_.equals(other.promotionalOrderTypes_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAllowedRegionsCount() > 0) {
      hash = (37 * hash) + ALLOWED_REGIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedRegionsList().hashCode();
    }
    if (getAllowedCustomerTypesCount() > 0) {
      hash = (37 * hash) + ALLOWED_CUSTOMER_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + allowedCustomerTypes_.hashCode();
    }
    if (getPromotionalOrderTypesCount() > 0) {
      hash = (37 * hash) + PROMOTIONAL_ORDER_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + promotionalOrderTypes_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.CustomerConstraints parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.CustomerConstraints prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents constraints required to purchase the Offer for a customer.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.CustomerConstraints}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.CustomerConstraints)
      com.google.cloud.channel.v1.CustomerConstraintsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_CustomerConstraints_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_CustomerConstraints_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.CustomerConstraints.class,
              com.google.cloud.channel.v1.CustomerConstraints.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.CustomerConstraints.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      allowedRegions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      allowedCustomerTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      promotionalOrderTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.OffersProto
          .internal_static_google_cloud_channel_v1_CustomerConstraints_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.CustomerConstraints getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.CustomerConstraints.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.CustomerConstraints build() {
      com.google.cloud.channel.v1.CustomerConstraints result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.CustomerConstraints buildPartial() {
      com.google.cloud.channel.v1.CustomerConstraints result =
          new com.google.cloud.channel.v1.CustomerConstraints(this);
      int from_bitField0_ = bitField0_;
      if (((bitField0_ & 0x00000001) != 0)) {
        allowedRegions_ = allowedRegions_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.allowedRegions_ = allowedRegions_;
      if (((bitField0_ & 0x00000002) != 0)) {
        allowedCustomerTypes_ = java.util.Collections.unmodifiableList(allowedCustomerTypes_);
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.allowedCustomerTypes_ = allowedCustomerTypes_;
      if (((bitField0_ & 0x00000004) != 0)) {
        promotionalOrderTypes_ = java.util.Collections.unmodifiableList(promotionalOrderTypes_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.promotionalOrderTypes_ = promotionalOrderTypes_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.CustomerConstraints) {
        return mergeFrom((com.google.cloud.channel.v1.CustomerConstraints) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.CustomerConstraints other) {
      if (other == com.google.cloud.channel.v1.CustomerConstraints.getDefaultInstance())
        return this;
      if (!other.allowedRegions_.isEmpty()) {
        if (allowedRegions_.isEmpty()) {
          allowedRegions_ = other.allowedRegions_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureAllowedRegionsIsMutable();
          allowedRegions_.addAll(other.allowedRegions_);
        }
        onChanged();
      }
      if (!other.allowedCustomerTypes_.isEmpty()) {
        if (allowedCustomerTypes_.isEmpty()) {
          allowedCustomerTypes_ = other.allowedCustomerTypes_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureAllowedCustomerTypesIsMutable();
          allowedCustomerTypes_.addAll(other.allowedCustomerTypes_);
        }
        onChanged();
      }
      if (!other.promotionalOrderTypes_.isEmpty()) {
        if (promotionalOrderTypes_.isEmpty()) {
          promotionalOrderTypes_ = other.promotionalOrderTypes_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensurePromotionalOrderTypesIsMutable();
          promotionalOrderTypes_.addAll(other.promotionalOrderTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAllowedRegionsIsMutable();
                allowedRegions_.add(s);
                break;
              } // case 10
            case 16:
              {
                int tmpRaw = input.readEnum();
                ensureAllowedCustomerTypesIsMutable();
                allowedCustomerTypes_.add(tmpRaw);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureAllowedCustomerTypesIsMutable();
                  allowedCustomerTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 18
            case 24:
              {
                int tmpRaw = input.readEnum();
                ensurePromotionalOrderTypesIsMutable();
                promotionalOrderTypes_.add(tmpRaw);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensurePromotionalOrderTypesIsMutable();
                  promotionalOrderTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringList allowedRegions_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureAllowedRegionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        allowedRegions_ = new com.google.protobuf.LazyStringArrayList(allowedRegions_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Allowed geographical regions of the customer.
     * </pre>
     *
     * <code>repeated string allowed_regions = 1;</code>
     *
     * @return A list containing the allowedRegions.
     */
    public com.google.protobuf.ProtocolStringList getAllowedRegionsList() {
      return allowedRegions_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Allowed geographical regions of the customer.
     * </pre>
     *
     * <code>repeated string allowed_regions = 1;</code>
     *
     * @return The count of allowedRegions.
     */
    public int getAllowedRegionsCount() {
      return allowedRegions_.size();
    }
    /**
     *
     *
     * <pre>
     * Allowed geographical regions of the customer.
     * </pre>
     *
     * <code>repeated string allowed_regions = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedRegions at the given index.
     */
    public java.lang.String getAllowedRegions(int index) {
      return allowedRegions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Allowed geographical regions of the customer.
     * </pre>
     *
     * <code>repeated string allowed_regions = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedRegions at the given index.
     */
    public com.google.protobuf.ByteString getAllowedRegionsBytes(int index) {
      return allowedRegions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Allowed geographical regions of the customer.
     * </pre>
     *
     * <code>repeated string allowed_regions = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowedRegions to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedRegions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedRegionsIsMutable();
      allowedRegions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed geographical regions of the customer.
     * </pre>
     *
     * <code>repeated string allowed_regions = 1;</code>
     *
     * @param value The allowedRegions to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedRegions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedRegionsIsMutable();
      allowedRegions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed geographical regions of the customer.
     * </pre>
     *
     * <code>repeated string allowed_regions = 1;</code>
     *
     * @param values The allowedRegions to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedRegions(java.lang.Iterable<java.lang.String> values) {
      ensureAllowedRegionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedRegions_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed geographical regions of the customer.
     * </pre>
     *
     * <code>repeated string allowed_regions = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedRegions() {
      allowedRegions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed geographical regions of the customer.
     * </pre>
     *
     * <code>repeated string allowed_regions = 1;</code>
     *
     * @param value The bytes of the allowedRegions to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedRegionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowedRegionsIsMutable();
      allowedRegions_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> allowedCustomerTypes_ =
        java.util.Collections.emptyList();

    private void ensureAllowedCustomerTypesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        allowedCustomerTypes_ = new java.util.ArrayList<java.lang.Integer>(allowedCustomerTypes_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @return A list containing the allowedCustomerTypes.
     */
    public java.util.List<com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType>
        getAllowedCustomerTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType>(
          allowedCustomerTypes_, allowedCustomerTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @return The count of allowedCustomerTypes.
     */
    public int getAllowedCustomerTypesCount() {
      return allowedCustomerTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The allowedCustomerTypes at the given index.
     */
    public com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType getAllowedCustomerTypes(
        int index) {
      return allowedCustomerTypes_converter_.convert(allowedCustomerTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The allowedCustomerTypes to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedCustomerTypes(
        int index, com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedCustomerTypesIsMutable();
      allowedCustomerTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @param value The allowedCustomerTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedCustomerTypes(
        com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedCustomerTypesIsMutable();
      allowedCustomerTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @param values The allowedCustomerTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedCustomerTypes(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType>
            values) {
      ensureAllowedCustomerTypesIsMutable();
      for (com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType value : values) {
        allowedCustomerTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedCustomerTypes() {
      allowedCustomerTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for allowedCustomerTypes.
     */
    public java.util.List<java.lang.Integer> getAllowedCustomerTypesValueList() {
      return java.util.Collections.unmodifiableList(allowedCustomerTypes_);
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of allowedCustomerTypes at the given index.
     */
    public int getAllowedCustomerTypesValue(int index) {
      return allowedCustomerTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for allowedCustomerTypes to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedCustomerTypesValue(int index, int value) {
      ensureAllowedCustomerTypesIsMutable();
      allowedCustomerTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for allowedCustomerTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedCustomerTypesValue(int value) {
      ensureAllowedCustomerTypesIsMutable();
      allowedCustomerTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Customer Type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.CloudIdentityInfo.CustomerType allowed_customer_types = 2;
     * </code>
     *
     * @param values The enum numeric values on the wire for allowedCustomerTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedCustomerTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureAllowedCustomerTypesIsMutable();
      for (int value : values) {
        allowedCustomerTypes_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> promotionalOrderTypes_ =
        java.util.Collections.emptyList();

    private void ensurePromotionalOrderTypesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        promotionalOrderTypes_ = new java.util.ArrayList<java.lang.Integer>(promotionalOrderTypes_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @return A list containing the promotionalOrderTypes.
     */
    public java.util.List<com.google.cloud.channel.v1.PromotionalOrderType>
        getPromotionalOrderTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.channel.v1.PromotionalOrderType>(
          promotionalOrderTypes_, promotionalOrderTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @return The count of promotionalOrderTypes.
     */
    public int getPromotionalOrderTypesCount() {
      return promotionalOrderTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The promotionalOrderTypes at the given index.
     */
    public com.google.cloud.channel.v1.PromotionalOrderType getPromotionalOrderTypes(int index) {
      return promotionalOrderTypes_converter_.convert(promotionalOrderTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The promotionalOrderTypes to set.
     * @return This builder for chaining.
     */
    public Builder setPromotionalOrderTypes(
        int index, com.google.cloud.channel.v1.PromotionalOrderType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePromotionalOrderTypesIsMutable();
      promotionalOrderTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @param value The promotionalOrderTypes to add.
     * @return This builder for chaining.
     */
    public Builder addPromotionalOrderTypes(
        com.google.cloud.channel.v1.PromotionalOrderType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePromotionalOrderTypesIsMutable();
      promotionalOrderTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @param values The promotionalOrderTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllPromotionalOrderTypes(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.PromotionalOrderType> values) {
      ensurePromotionalOrderTypesIsMutable();
      for (com.google.cloud.channel.v1.PromotionalOrderType value : values) {
        promotionalOrderTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPromotionalOrderTypes() {
      promotionalOrderTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for promotionalOrderTypes.
     */
    public java.util.List<java.lang.Integer> getPromotionalOrderTypesValueList() {
      return java.util.Collections.unmodifiableList(promotionalOrderTypes_);
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of promotionalOrderTypes at the given index.
     */
    public int getPromotionalOrderTypesValue(int index) {
      return promotionalOrderTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for promotionalOrderTypes to set.
     * @return This builder for chaining.
     */
    public Builder setPromotionalOrderTypesValue(int index, int value) {
      ensurePromotionalOrderTypesIsMutable();
      promotionalOrderTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for promotionalOrderTypes to add.
     * @return This builder for chaining.
     */
    public Builder addPromotionalOrderTypesValue(int value) {
      ensurePromotionalOrderTypesIsMutable();
      promotionalOrderTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowed Promotional Order Type. Present for Promotional offers.
     * </pre>
     *
     * <code>repeated .google.cloud.channel.v1.PromotionalOrderType promotional_order_types = 3;
     * </code>
     *
     * @param values The enum numeric values on the wire for promotionalOrderTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllPromotionalOrderTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensurePromotionalOrderTypesIsMutable();
      for (int value : values) {
        promotionalOrderTypes_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.CustomerConstraints)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.CustomerConstraints)
  private static final com.google.cloud.channel.v1.CustomerConstraints DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.CustomerConstraints();
  }

  public static com.google.cloud.channel.v1.CustomerConstraints getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomerConstraints> PARSER =
      new com.google.protobuf.AbstractParser<CustomerConstraints>() {
        @java.lang.Override
        public CustomerConstraints parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomerConstraints> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomerConstraints> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.CustomerConstraints getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
