/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/customers.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Entity representing a customer of a reseller or distributor.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.Customer}
 */
public final class Customer extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.Customer)
    CustomerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Customer.newBuilder() to construct.
  private Customer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Customer() {
    name_ = "";
    orgDisplayName_ = "";
    alternateEmail_ = "";
    domain_ = "";
    cloudIdentityId_ = "";
    languageCode_ = "";
    channelPartnerId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Customer();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.CustomersProto
        .internal_static_google_cloud_channel_v1_Customer_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.CustomersProto
        .internal_static_google_cloud_channel_v1_Customer_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.Customer.class,
            com.google.cloud.channel.v1.Customer.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the customer.
   * Format: accounts/{account_id}/customers/{customer_id}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the customer.
   * Format: accounts/{account_id}/customers/{customer_id}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORG_DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object orgDisplayName_;
  /**
   *
   *
   * <pre>
   * Required. Name of the organization that the customer entity represents.
   * </pre>
   *
   * <code>string org_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The orgDisplayName.
   */
  @java.lang.Override
  public java.lang.String getOrgDisplayName() {
    java.lang.Object ref = orgDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orgDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the organization that the customer entity represents.
   * </pre>
   *
   * <code>string org_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for orgDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrgDisplayNameBytes() {
    java.lang.Object ref = orgDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orgDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORG_POSTAL_ADDRESS_FIELD_NUMBER = 3;
  private com.google.type.PostalAddress orgPostalAddress_;
  /**
   *
   *
   * <pre>
   * Required. The organization address for the customer. To enforce US laws and
   * embargoes, we require a region and zip code. You must provide valid
   * addresses for every customer. To set the customer's language, use the
   * Customer-level language code.
   * </pre>
   *
   * <code>
   * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the orgPostalAddress field is set.
   */
  @java.lang.Override
  public boolean hasOrgPostalAddress() {
    return orgPostalAddress_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The organization address for the customer. To enforce US laws and
   * embargoes, we require a region and zip code. You must provide valid
   * addresses for every customer. To set the customer's language, use the
   * Customer-level language code.
   * </pre>
   *
   * <code>
   * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The orgPostalAddress.
   */
  @java.lang.Override
  public com.google.type.PostalAddress getOrgPostalAddress() {
    return orgPostalAddress_ == null
        ? com.google.type.PostalAddress.getDefaultInstance()
        : orgPostalAddress_;
  }
  /**
   *
   *
   * <pre>
   * Required. The organization address for the customer. To enforce US laws and
   * embargoes, we require a region and zip code. You must provide valid
   * addresses for every customer. To set the customer's language, use the
   * Customer-level language code.
   * </pre>
   *
   * <code>
   * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.type.PostalAddressOrBuilder getOrgPostalAddressOrBuilder() {
    return getOrgPostalAddress();
  }

  public static final int PRIMARY_CONTACT_INFO_FIELD_NUMBER = 4;
  private com.google.cloud.channel.v1.ContactInfo primaryContactInfo_;
  /**
   *
   *
   * <pre>
   * Primary contact info.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
   *
   * @return Whether the primaryContactInfo field is set.
   */
  @java.lang.Override
  public boolean hasPrimaryContactInfo() {
    return primaryContactInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Primary contact info.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
   *
   * @return The primaryContactInfo.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ContactInfo getPrimaryContactInfo() {
    return primaryContactInfo_ == null
        ? com.google.cloud.channel.v1.ContactInfo.getDefaultInstance()
        : primaryContactInfo_;
  }
  /**
   *
   *
   * <pre>
   * Primary contact info.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ContactInfoOrBuilder getPrimaryContactInfoOrBuilder() {
    return getPrimaryContactInfo();
  }

  public static final int ALTERNATE_EMAIL_FIELD_NUMBER = 5;
  private volatile java.lang.Object alternateEmail_;
  /**
   *
   *
   * <pre>
   * Secondary contact email. You need to provide an alternate email to create
   * different domains if a primary contact email already exists. Users will
   * receive a notification with credentials when you create an admin.google.com
   * account. Secondary emails are also recovery email addresses. Alternate
   * emails are optional when you create Team customers.
   * </pre>
   *
   * <code>string alternate_email = 5;</code>
   *
   * @return The alternateEmail.
   */
  @java.lang.Override
  public java.lang.String getAlternateEmail() {
    java.lang.Object ref = alternateEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      alternateEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Secondary contact email. You need to provide an alternate email to create
   * different domains if a primary contact email already exists. Users will
   * receive a notification with credentials when you create an admin.google.com
   * account. Secondary emails are also recovery email addresses. Alternate
   * emails are optional when you create Team customers.
   * </pre>
   *
   * <code>string alternate_email = 5;</code>
   *
   * @return The bytes for alternateEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAlternateEmailBytes() {
    java.lang.Object ref = alternateEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      alternateEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOMAIN_FIELD_NUMBER = 6;
  private volatile java.lang.Object domain_;
  /**
   *
   *
   * <pre>
   * Required. The customer's primary domain. Must match the primary contact
   * email's domain.
   * </pre>
   *
   * <code>string domain = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The domain.
   */
  @java.lang.Override
  public java.lang.String getDomain() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      domain_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The customer's primary domain. Must match the primary contact
   * email's domain.
   * </pre>
   *
   * <code>string domain = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for domain.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDomainBytes() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      domain_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the customer was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the customer was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the customer was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the customer was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the customer was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the customer was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int CLOUD_IDENTITY_ID_FIELD_NUMBER = 9;
  private volatile java.lang.Object cloudIdentityId_;
  /**
   *
   *
   * <pre>
   * Output only. The customer's Cloud Identity ID if the customer has a Cloud
   * Identity resource.
   * </pre>
   *
   * <code>string cloud_identity_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The cloudIdentityId.
   */
  @java.lang.Override
  public java.lang.String getCloudIdentityId() {
    java.lang.Object ref = cloudIdentityId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudIdentityId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The customer's Cloud Identity ID if the customer has a Cloud
   * Identity resource.
   * </pre>
   *
   * <code>string cloud_identity_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for cloudIdentityId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudIdentityIdBytes() {
    java.lang.Object ref = cloudIdentityId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudIdentityId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 10;
  private volatile java.lang.Object languageCode_;
  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
   * information, see
   * https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
   * </pre>
   *
   * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
   * information, see
   * https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
   * </pre>
   *
   * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLOUD_IDENTITY_INFO_FIELD_NUMBER = 12;
  private com.google.cloud.channel.v1.CloudIdentityInfo cloudIdentityInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Cloud Identity information for the customer.
   * Populated only if a Cloud Identity account exists for this customer.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the cloudIdentityInfo field is set.
   */
  @java.lang.Override
  public boolean hasCloudIdentityInfo() {
    return cloudIdentityInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Cloud Identity information for the customer.
   * Populated only if a Cloud Identity account exists for this customer.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The cloudIdentityInfo.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.CloudIdentityInfo getCloudIdentityInfo() {
    return cloudIdentityInfo_ == null
        ? com.google.cloud.channel.v1.CloudIdentityInfo.getDefaultInstance()
        : cloudIdentityInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Cloud Identity information for the customer.
   * Populated only if a Cloud Identity account exists for this customer.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.CloudIdentityInfoOrBuilder getCloudIdentityInfoOrBuilder() {
    return getCloudIdentityInfo();
  }

  public static final int CHANNEL_PARTNER_ID_FIELD_NUMBER = 13;
  private volatile java.lang.Object channelPartnerId_;
  /**
   *
   *
   * <pre>
   * Cloud Identity ID of the customer's channel partner.
   * Populated only if a channel partner exists for this customer.
   * </pre>
   *
   * <code>string channel_partner_id = 13;</code>
   *
   * @return The channelPartnerId.
   */
  @java.lang.Override
  public java.lang.String getChannelPartnerId() {
    java.lang.Object ref = channelPartnerId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      channelPartnerId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud Identity ID of the customer's channel partner.
   * Populated only if a channel partner exists for this customer.
   * </pre>
   *
   * <code>string channel_partner_id = 13;</code>
   *
   * @return The bytes for channelPartnerId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getChannelPartnerIdBytes() {
    java.lang.Object ref = channelPartnerId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      channelPartnerId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orgDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, orgDisplayName_);
    }
    if (orgPostalAddress_ != null) {
      output.writeMessage(3, getOrgPostalAddress());
    }
    if (primaryContactInfo_ != null) {
      output.writeMessage(4, getPrimaryContactInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alternateEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, alternateEmail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, domain_);
    }
    if (createTime_ != null) {
      output.writeMessage(7, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(8, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudIdentityId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, cloudIdentityId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, languageCode_);
    }
    if (cloudIdentityInfo_ != null) {
      output.writeMessage(12, getCloudIdentityInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(channelPartnerId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, channelPartnerId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orgDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, orgDisplayName_);
    }
    if (orgPostalAddress_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOrgPostalAddress());
    }
    if (primaryContactInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPrimaryContactInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alternateEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, alternateEmail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, domain_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudIdentityId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, cloudIdentityId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, languageCode_);
    }
    if (cloudIdentityInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getCloudIdentityInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(channelPartnerId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, channelPartnerId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.Customer)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.Customer other = (com.google.cloud.channel.v1.Customer) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getOrgDisplayName().equals(other.getOrgDisplayName())) return false;
    if (hasOrgPostalAddress() != other.hasOrgPostalAddress()) return false;
    if (hasOrgPostalAddress()) {
      if (!getOrgPostalAddress().equals(other.getOrgPostalAddress())) return false;
    }
    if (hasPrimaryContactInfo() != other.hasPrimaryContactInfo()) return false;
    if (hasPrimaryContactInfo()) {
      if (!getPrimaryContactInfo().equals(other.getPrimaryContactInfo())) return false;
    }
    if (!getAlternateEmail().equals(other.getAlternateEmail())) return false;
    if (!getDomain().equals(other.getDomain())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getCloudIdentityId().equals(other.getCloudIdentityId())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (hasCloudIdentityInfo() != other.hasCloudIdentityInfo()) return false;
    if (hasCloudIdentityInfo()) {
      if (!getCloudIdentityInfo().equals(other.getCloudIdentityInfo())) return false;
    }
    if (!getChannelPartnerId().equals(other.getChannelPartnerId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ORG_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getOrgDisplayName().hashCode();
    if (hasOrgPostalAddress()) {
      hash = (37 * hash) + ORG_POSTAL_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getOrgPostalAddress().hashCode();
    }
    if (hasPrimaryContactInfo()) {
      hash = (37 * hash) + PRIMARY_CONTACT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getPrimaryContactInfo().hashCode();
    }
    hash = (37 * hash) + ALTERNATE_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getAlternateEmail().hashCode();
    hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
    hash = (53 * hash) + getDomain().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + CLOUD_IDENTITY_ID_FIELD_NUMBER;
    hash = (53 * hash) + getCloudIdentityId().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    if (hasCloudIdentityInfo()) {
      hash = (37 * hash) + CLOUD_IDENTITY_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getCloudIdentityInfo().hashCode();
    }
    hash = (37 * hash) + CHANNEL_PARTNER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getChannelPartnerId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.Customer parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Customer parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Customer parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Customer parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Customer parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Customer parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Customer parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Customer parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Customer parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Customer parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Customer parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Customer parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.Customer prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Entity representing a customer of a reseller or distributor.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.Customer}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.Customer)
      com.google.cloud.channel.v1.CustomerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.CustomersProto
          .internal_static_google_cloud_channel_v1_Customer_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.CustomersProto
          .internal_static_google_cloud_channel_v1_Customer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.Customer.class,
              com.google.cloud.channel.v1.Customer.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.Customer.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      orgDisplayName_ = "";

      if (orgPostalAddressBuilder_ == null) {
        orgPostalAddress_ = null;
      } else {
        orgPostalAddress_ = null;
        orgPostalAddressBuilder_ = null;
      }
      if (primaryContactInfoBuilder_ == null) {
        primaryContactInfo_ = null;
      } else {
        primaryContactInfo_ = null;
        primaryContactInfoBuilder_ = null;
      }
      alternateEmail_ = "";

      domain_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      cloudIdentityId_ = "";

      languageCode_ = "";

      if (cloudIdentityInfoBuilder_ == null) {
        cloudIdentityInfo_ = null;
      } else {
        cloudIdentityInfo_ = null;
        cloudIdentityInfoBuilder_ = null;
      }
      channelPartnerId_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.CustomersProto
          .internal_static_google_cloud_channel_v1_Customer_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Customer getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.Customer.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Customer build() {
      com.google.cloud.channel.v1.Customer result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Customer buildPartial() {
      com.google.cloud.channel.v1.Customer result = new com.google.cloud.channel.v1.Customer(this);
      result.name_ = name_;
      result.orgDisplayName_ = orgDisplayName_;
      if (orgPostalAddressBuilder_ == null) {
        result.orgPostalAddress_ = orgPostalAddress_;
      } else {
        result.orgPostalAddress_ = orgPostalAddressBuilder_.build();
      }
      if (primaryContactInfoBuilder_ == null) {
        result.primaryContactInfo_ = primaryContactInfo_;
      } else {
        result.primaryContactInfo_ = primaryContactInfoBuilder_.build();
      }
      result.alternateEmail_ = alternateEmail_;
      result.domain_ = domain_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.cloudIdentityId_ = cloudIdentityId_;
      result.languageCode_ = languageCode_;
      if (cloudIdentityInfoBuilder_ == null) {
        result.cloudIdentityInfo_ = cloudIdentityInfo_;
      } else {
        result.cloudIdentityInfo_ = cloudIdentityInfoBuilder_.build();
      }
      result.channelPartnerId_ = channelPartnerId_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.Customer) {
        return mergeFrom((com.google.cloud.channel.v1.Customer) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.Customer other) {
      if (other == com.google.cloud.channel.v1.Customer.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getOrgDisplayName().isEmpty()) {
        orgDisplayName_ = other.orgDisplayName_;
        onChanged();
      }
      if (other.hasOrgPostalAddress()) {
        mergeOrgPostalAddress(other.getOrgPostalAddress());
      }
      if (other.hasPrimaryContactInfo()) {
        mergePrimaryContactInfo(other.getPrimaryContactInfo());
      }
      if (!other.getAlternateEmail().isEmpty()) {
        alternateEmail_ = other.alternateEmail_;
        onChanged();
      }
      if (!other.getDomain().isEmpty()) {
        domain_ = other.domain_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getCloudIdentityId().isEmpty()) {
        cloudIdentityId_ = other.cloudIdentityId_;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        onChanged();
      }
      if (other.hasCloudIdentityInfo()) {
        mergeCloudIdentityInfo(other.getCloudIdentityInfo());
      }
      if (!other.getChannelPartnerId().isEmpty()) {
        channelPartnerId_ = other.channelPartnerId_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                orgDisplayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getOrgPostalAddressFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getPrimaryContactInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                alternateEmail_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                domain_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 74:
              {
                cloudIdentityId_ = input.readStringRequireUtf8();

                break;
              } // case 74
            case 82:
              {
                languageCode_ = input.readStringRequireUtf8();

                break;
              } // case 82
            case 98:
              {
                input.readMessage(
                    getCloudIdentityInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 98
            case 106:
              {
                channelPartnerId_ = input.readStringRequireUtf8();

                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the customer.
     * Format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the customer.
     * Format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the customer.
     * Format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the customer.
     * Format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the customer.
     * Format: accounts/{account_id}/customers/{customer_id}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object orgDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the organization that the customer entity represents.
     * </pre>
     *
     * <code>string org_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The orgDisplayName.
     */
    public java.lang.String getOrgDisplayName() {
      java.lang.Object ref = orgDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orgDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the organization that the customer entity represents.
     * </pre>
     *
     * <code>string org_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for orgDisplayName.
     */
    public com.google.protobuf.ByteString getOrgDisplayNameBytes() {
      java.lang.Object ref = orgDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orgDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the organization that the customer entity represents.
     * </pre>
     *
     * <code>string org_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The orgDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setOrgDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      orgDisplayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the organization that the customer entity represents.
     * </pre>
     *
     * <code>string org_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrgDisplayName() {

      orgDisplayName_ = getDefaultInstance().getOrgDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the organization that the customer entity represents.
     * </pre>
     *
     * <code>string org_display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for orgDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setOrgDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      orgDisplayName_ = value;
      onChanged();
      return this;
    }

    private com.google.type.PostalAddress orgPostalAddress_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.PostalAddress,
            com.google.type.PostalAddress.Builder,
            com.google.type.PostalAddressOrBuilder>
        orgPostalAddressBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The organization address for the customer. To enforce US laws and
     * embargoes, we require a region and zip code. You must provide valid
     * addresses for every customer. To set the customer's language, use the
     * Customer-level language code.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the orgPostalAddress field is set.
     */
    public boolean hasOrgPostalAddress() {
      return orgPostalAddressBuilder_ != null || orgPostalAddress_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The organization address for the customer. To enforce US laws and
     * embargoes, we require a region and zip code. You must provide valid
     * addresses for every customer. To set the customer's language, use the
     * Customer-level language code.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The orgPostalAddress.
     */
    public com.google.type.PostalAddress getOrgPostalAddress() {
      if (orgPostalAddressBuilder_ == null) {
        return orgPostalAddress_ == null
            ? com.google.type.PostalAddress.getDefaultInstance()
            : orgPostalAddress_;
      } else {
        return orgPostalAddressBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The organization address for the customer. To enforce US laws and
     * embargoes, we require a region and zip code. You must provide valid
     * addresses for every customer. To set the customer's language, use the
     * Customer-level language code.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOrgPostalAddress(com.google.type.PostalAddress value) {
      if (orgPostalAddressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        orgPostalAddress_ = value;
        onChanged();
      } else {
        orgPostalAddressBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The organization address for the customer. To enforce US laws and
     * embargoes, we require a region and zip code. You must provide valid
     * addresses for every customer. To set the customer's language, use the
     * Customer-level language code.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOrgPostalAddress(com.google.type.PostalAddress.Builder builderForValue) {
      if (orgPostalAddressBuilder_ == null) {
        orgPostalAddress_ = builderForValue.build();
        onChanged();
      } else {
        orgPostalAddressBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The organization address for the customer. To enforce US laws and
     * embargoes, we require a region and zip code. You must provide valid
     * addresses for every customer. To set the customer's language, use the
     * Customer-level language code.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOrgPostalAddress(com.google.type.PostalAddress value) {
      if (orgPostalAddressBuilder_ == null) {
        if (orgPostalAddress_ != null) {
          orgPostalAddress_ =
              com.google.type.PostalAddress.newBuilder(orgPostalAddress_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          orgPostalAddress_ = value;
        }
        onChanged();
      } else {
        orgPostalAddressBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The organization address for the customer. To enforce US laws and
     * embargoes, we require a region and zip code. You must provide valid
     * addresses for every customer. To set the customer's language, use the
     * Customer-level language code.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOrgPostalAddress() {
      if (orgPostalAddressBuilder_ == null) {
        orgPostalAddress_ = null;
        onChanged();
      } else {
        orgPostalAddress_ = null;
        orgPostalAddressBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The organization address for the customer. To enforce US laws and
     * embargoes, we require a region and zip code. You must provide valid
     * addresses for every customer. To set the customer's language, use the
     * Customer-level language code.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.type.PostalAddress.Builder getOrgPostalAddressBuilder() {

      onChanged();
      return getOrgPostalAddressFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The organization address for the customer. To enforce US laws and
     * embargoes, we require a region and zip code. You must provide valid
     * addresses for every customer. To set the customer's language, use the
     * Customer-level language code.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.type.PostalAddressOrBuilder getOrgPostalAddressOrBuilder() {
      if (orgPostalAddressBuilder_ != null) {
        return orgPostalAddressBuilder_.getMessageOrBuilder();
      } else {
        return orgPostalAddress_ == null
            ? com.google.type.PostalAddress.getDefaultInstance()
            : orgPostalAddress_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The organization address for the customer. To enforce US laws and
     * embargoes, we require a region and zip code. You must provide valid
     * addresses for every customer. To set the customer's language, use the
     * Customer-level language code.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress org_postal_address = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.PostalAddress,
            com.google.type.PostalAddress.Builder,
            com.google.type.PostalAddressOrBuilder>
        getOrgPostalAddressFieldBuilder() {
      if (orgPostalAddressBuilder_ == null) {
        orgPostalAddressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.PostalAddress,
                com.google.type.PostalAddress.Builder,
                com.google.type.PostalAddressOrBuilder>(
                getOrgPostalAddress(), getParentForChildren(), isClean());
        orgPostalAddress_ = null;
      }
      return orgPostalAddressBuilder_;
    }

    private com.google.cloud.channel.v1.ContactInfo primaryContactInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.ContactInfo,
            com.google.cloud.channel.v1.ContactInfo.Builder,
            com.google.cloud.channel.v1.ContactInfoOrBuilder>
        primaryContactInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Primary contact info.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
     *
     * @return Whether the primaryContactInfo field is set.
     */
    public boolean hasPrimaryContactInfo() {
      return primaryContactInfoBuilder_ != null || primaryContactInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Primary contact info.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
     *
     * @return The primaryContactInfo.
     */
    public com.google.cloud.channel.v1.ContactInfo getPrimaryContactInfo() {
      if (primaryContactInfoBuilder_ == null) {
        return primaryContactInfo_ == null
            ? com.google.cloud.channel.v1.ContactInfo.getDefaultInstance()
            : primaryContactInfo_;
      } else {
        return primaryContactInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Primary contact info.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
     */
    public Builder setPrimaryContactInfo(com.google.cloud.channel.v1.ContactInfo value) {
      if (primaryContactInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        primaryContactInfo_ = value;
        onChanged();
      } else {
        primaryContactInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Primary contact info.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
     */
    public Builder setPrimaryContactInfo(
        com.google.cloud.channel.v1.ContactInfo.Builder builderForValue) {
      if (primaryContactInfoBuilder_ == null) {
        primaryContactInfo_ = builderForValue.build();
        onChanged();
      } else {
        primaryContactInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Primary contact info.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
     */
    public Builder mergePrimaryContactInfo(com.google.cloud.channel.v1.ContactInfo value) {
      if (primaryContactInfoBuilder_ == null) {
        if (primaryContactInfo_ != null) {
          primaryContactInfo_ =
              com.google.cloud.channel.v1.ContactInfo.newBuilder(primaryContactInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          primaryContactInfo_ = value;
        }
        onChanged();
      } else {
        primaryContactInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Primary contact info.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
     */
    public Builder clearPrimaryContactInfo() {
      if (primaryContactInfoBuilder_ == null) {
        primaryContactInfo_ = null;
        onChanged();
      } else {
        primaryContactInfo_ = null;
        primaryContactInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Primary contact info.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
     */
    public com.google.cloud.channel.v1.ContactInfo.Builder getPrimaryContactInfoBuilder() {

      onChanged();
      return getPrimaryContactInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Primary contact info.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
     */
    public com.google.cloud.channel.v1.ContactInfoOrBuilder getPrimaryContactInfoOrBuilder() {
      if (primaryContactInfoBuilder_ != null) {
        return primaryContactInfoBuilder_.getMessageOrBuilder();
      } else {
        return primaryContactInfo_ == null
            ? com.google.cloud.channel.v1.ContactInfo.getDefaultInstance()
            : primaryContactInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Primary contact info.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.ContactInfo primary_contact_info = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.ContactInfo,
            com.google.cloud.channel.v1.ContactInfo.Builder,
            com.google.cloud.channel.v1.ContactInfoOrBuilder>
        getPrimaryContactInfoFieldBuilder() {
      if (primaryContactInfoBuilder_ == null) {
        primaryContactInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.ContactInfo,
                com.google.cloud.channel.v1.ContactInfo.Builder,
                com.google.cloud.channel.v1.ContactInfoOrBuilder>(
                getPrimaryContactInfo(), getParentForChildren(), isClean());
        primaryContactInfo_ = null;
      }
      return primaryContactInfoBuilder_;
    }

    private java.lang.Object alternateEmail_ = "";
    /**
     *
     *
     * <pre>
     * Secondary contact email. You need to provide an alternate email to create
     * different domains if a primary contact email already exists. Users will
     * receive a notification with credentials when you create an admin.google.com
     * account. Secondary emails are also recovery email addresses. Alternate
     * emails are optional when you create Team customers.
     * </pre>
     *
     * <code>string alternate_email = 5;</code>
     *
     * @return The alternateEmail.
     */
    public java.lang.String getAlternateEmail() {
      java.lang.Object ref = alternateEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        alternateEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Secondary contact email. You need to provide an alternate email to create
     * different domains if a primary contact email already exists. Users will
     * receive a notification with credentials when you create an admin.google.com
     * account. Secondary emails are also recovery email addresses. Alternate
     * emails are optional when you create Team customers.
     * </pre>
     *
     * <code>string alternate_email = 5;</code>
     *
     * @return The bytes for alternateEmail.
     */
    public com.google.protobuf.ByteString getAlternateEmailBytes() {
      java.lang.Object ref = alternateEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        alternateEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Secondary contact email. You need to provide an alternate email to create
     * different domains if a primary contact email already exists. Users will
     * receive a notification with credentials when you create an admin.google.com
     * account. Secondary emails are also recovery email addresses. Alternate
     * emails are optional when you create Team customers.
     * </pre>
     *
     * <code>string alternate_email = 5;</code>
     *
     * @param value The alternateEmail to set.
     * @return This builder for chaining.
     */
    public Builder setAlternateEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      alternateEmail_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary contact email. You need to provide an alternate email to create
     * different domains if a primary contact email already exists. Users will
     * receive a notification with credentials when you create an admin.google.com
     * account. Secondary emails are also recovery email addresses. Alternate
     * emails are optional when you create Team customers.
     * </pre>
     *
     * <code>string alternate_email = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlternateEmail() {

      alternateEmail_ = getDefaultInstance().getAlternateEmail();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary contact email. You need to provide an alternate email to create
     * different domains if a primary contact email already exists. Users will
     * receive a notification with credentials when you create an admin.google.com
     * account. Secondary emails are also recovery email addresses. Alternate
     * emails are optional when you create Team customers.
     * </pre>
     *
     * <code>string alternate_email = 5;</code>
     *
     * @param value The bytes for alternateEmail to set.
     * @return This builder for chaining.
     */
    public Builder setAlternateEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      alternateEmail_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object domain_ = "";
    /**
     *
     *
     * <pre>
     * Required. The customer's primary domain. Must match the primary contact
     * email's domain.
     * </pre>
     *
     * <code>string domain = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The domain.
     */
    public java.lang.String getDomain() {
      java.lang.Object ref = domain_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domain_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The customer's primary domain. Must match the primary contact
     * email's domain.
     * </pre>
     *
     * <code>string domain = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for domain.
     */
    public com.google.protobuf.ByteString getDomainBytes() {
      java.lang.Object ref = domain_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        domain_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The customer's primary domain. Must match the primary contact
     * email's domain.
     * </pre>
     *
     * <code>string domain = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomain(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      domain_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The customer's primary domain. Must match the primary contact
     * email's domain.
     * </pre>
     *
     * <code>string domain = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomain() {

      domain_ = getDefaultInstance().getDomain();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The customer's primary domain. Must match the primary contact
     * email's domain.
     * </pre>
     *
     * <code>string domain = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomainBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      domain_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the customer was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object cloudIdentityId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The customer's Cloud Identity ID if the customer has a Cloud
     * Identity resource.
     * </pre>
     *
     * <code>string cloud_identity_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The cloudIdentityId.
     */
    public java.lang.String getCloudIdentityId() {
      java.lang.Object ref = cloudIdentityId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudIdentityId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The customer's Cloud Identity ID if the customer has a Cloud
     * Identity resource.
     * </pre>
     *
     * <code>string cloud_identity_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for cloudIdentityId.
     */
    public com.google.protobuf.ByteString getCloudIdentityIdBytes() {
      java.lang.Object ref = cloudIdentityId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudIdentityId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The customer's Cloud Identity ID if the customer has a Cloud
     * Identity resource.
     * </pre>
     *
     * <code>string cloud_identity_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The cloudIdentityId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudIdentityId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      cloudIdentityId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The customer's Cloud Identity ID if the customer has a Cloud
     * Identity resource.
     * </pre>
     *
     * <code>string cloud_identity_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudIdentityId() {

      cloudIdentityId_ = getDefaultInstance().getCloudIdentityId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The customer's Cloud Identity ID if the customer has a Cloud
     * Identity resource.
     * </pre>
     *
     * <code>string cloud_identity_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for cloudIdentityId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudIdentityIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      cloudIdentityId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      languageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {

      languageCode_ = getDefaultInstance().getLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      languageCode_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.channel.v1.CloudIdentityInfo cloudIdentityInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.CloudIdentityInfo,
            com.google.cloud.channel.v1.CloudIdentityInfo.Builder,
            com.google.cloud.channel.v1.CloudIdentityInfoOrBuilder>
        cloudIdentityInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity information for the customer.
     * Populated only if a Cloud Identity account exists for this customer.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the cloudIdentityInfo field is set.
     */
    public boolean hasCloudIdentityInfo() {
      return cloudIdentityInfoBuilder_ != null || cloudIdentityInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity information for the customer.
     * Populated only if a Cloud Identity account exists for this customer.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cloudIdentityInfo.
     */
    public com.google.cloud.channel.v1.CloudIdentityInfo getCloudIdentityInfo() {
      if (cloudIdentityInfoBuilder_ == null) {
        return cloudIdentityInfo_ == null
            ? com.google.cloud.channel.v1.CloudIdentityInfo.getDefaultInstance()
            : cloudIdentityInfo_;
      } else {
        return cloudIdentityInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity information for the customer.
     * Populated only if a Cloud Identity account exists for this customer.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCloudIdentityInfo(com.google.cloud.channel.v1.CloudIdentityInfo value) {
      if (cloudIdentityInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cloudIdentityInfo_ = value;
        onChanged();
      } else {
        cloudIdentityInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity information for the customer.
     * Populated only if a Cloud Identity account exists for this customer.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCloudIdentityInfo(
        com.google.cloud.channel.v1.CloudIdentityInfo.Builder builderForValue) {
      if (cloudIdentityInfoBuilder_ == null) {
        cloudIdentityInfo_ = builderForValue.build();
        onChanged();
      } else {
        cloudIdentityInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity information for the customer.
     * Populated only if a Cloud Identity account exists for this customer.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCloudIdentityInfo(com.google.cloud.channel.v1.CloudIdentityInfo value) {
      if (cloudIdentityInfoBuilder_ == null) {
        if (cloudIdentityInfo_ != null) {
          cloudIdentityInfo_ =
              com.google.cloud.channel.v1.CloudIdentityInfo.newBuilder(cloudIdentityInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          cloudIdentityInfo_ = value;
        }
        onChanged();
      } else {
        cloudIdentityInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity information for the customer.
     * Populated only if a Cloud Identity account exists for this customer.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCloudIdentityInfo() {
      if (cloudIdentityInfoBuilder_ == null) {
        cloudIdentityInfo_ = null;
        onChanged();
      } else {
        cloudIdentityInfo_ = null;
        cloudIdentityInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity information for the customer.
     * Populated only if a Cloud Identity account exists for this customer.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.channel.v1.CloudIdentityInfo.Builder getCloudIdentityInfoBuilder() {

      onChanged();
      return getCloudIdentityInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity information for the customer.
     * Populated only if a Cloud Identity account exists for this customer.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.channel.v1.CloudIdentityInfoOrBuilder getCloudIdentityInfoOrBuilder() {
      if (cloudIdentityInfoBuilder_ != null) {
        return cloudIdentityInfoBuilder_.getMessageOrBuilder();
      } else {
        return cloudIdentityInfo_ == null
            ? com.google.cloud.channel.v1.CloudIdentityInfo.getDefaultInstance()
            : cloudIdentityInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity information for the customer.
     * Populated only if a Cloud Identity account exists for this customer.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo cloud_identity_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.CloudIdentityInfo,
            com.google.cloud.channel.v1.CloudIdentityInfo.Builder,
            com.google.cloud.channel.v1.CloudIdentityInfoOrBuilder>
        getCloudIdentityInfoFieldBuilder() {
      if (cloudIdentityInfoBuilder_ == null) {
        cloudIdentityInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.CloudIdentityInfo,
                com.google.cloud.channel.v1.CloudIdentityInfo.Builder,
                com.google.cloud.channel.v1.CloudIdentityInfoOrBuilder>(
                getCloudIdentityInfo(), getParentForChildren(), isClean());
        cloudIdentityInfo_ = null;
      }
      return cloudIdentityInfoBuilder_;
    }

    private java.lang.Object channelPartnerId_ = "";
    /**
     *
     *
     * <pre>
     * Cloud Identity ID of the customer's channel partner.
     * Populated only if a channel partner exists for this customer.
     * </pre>
     *
     * <code>string channel_partner_id = 13;</code>
     *
     * @return The channelPartnerId.
     */
    public java.lang.String getChannelPartnerId() {
      java.lang.Object ref = channelPartnerId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        channelPartnerId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Identity ID of the customer's channel partner.
     * Populated only if a channel partner exists for this customer.
     * </pre>
     *
     * <code>string channel_partner_id = 13;</code>
     *
     * @return The bytes for channelPartnerId.
     */
    public com.google.protobuf.ByteString getChannelPartnerIdBytes() {
      java.lang.Object ref = channelPartnerId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        channelPartnerId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Identity ID of the customer's channel partner.
     * Populated only if a channel partner exists for this customer.
     * </pre>
     *
     * <code>string channel_partner_id = 13;</code>
     *
     * @param value The channelPartnerId to set.
     * @return This builder for chaining.
     */
    public Builder setChannelPartnerId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      channelPartnerId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Identity ID of the customer's channel partner.
     * Populated only if a channel partner exists for this customer.
     * </pre>
     *
     * <code>string channel_partner_id = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChannelPartnerId() {

      channelPartnerId_ = getDefaultInstance().getChannelPartnerId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Identity ID of the customer's channel partner.
     * Populated only if a channel partner exists for this customer.
     * </pre>
     *
     * <code>string channel_partner_id = 13;</code>
     *
     * @param value The bytes for channelPartnerId to set.
     * @return This builder for chaining.
     */
    public Builder setChannelPartnerIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      channelPartnerId_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.Customer)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.Customer)
  private static final com.google.cloud.channel.v1.Customer DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.Customer();
  }

  public static com.google.cloud.channel.v1.Customer getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Customer> PARSER =
      new com.google.protobuf.AbstractParser<Customer>() {
        @java.lang.Override
        public Customer parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Customer> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Customer> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.Customer getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
