/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/reports_service.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * The definition of a report column. Specifies the data properties
 * in the corresponding position of the report rows.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.Column}
 */
public final class Column extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.Column)
    ColumnOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Column.newBuilder() to construct.
  private Column(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Column() {
    columnId_ = "";
    displayName_ = "";
    dataType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Column();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.ReportsServiceProto
        .internal_static_google_cloud_channel_v1_Column_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.ReportsServiceProto
        .internal_static_google_cloud_channel_v1_Column_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.Column.class,
            com.google.cloud.channel.v1.Column.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Available data types for columns. Corresponds to the fields in the
   * ReportValue `oneof` field.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.channel.v1.Column.DataType}
   */
  public enum DataType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>DATA_TYPE_UNSPECIFIED = 0;</code>
     */
    DATA_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use string_value.
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    STRING(1),
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use int_value.
     * </pre>
     *
     * <code>INT = 2;</code>
     */
    INT(2),
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use decimal_value.
     * </pre>
     *
     * <code>DECIMAL = 3;</code>
     */
    DECIMAL(3),
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use money_value.
     * </pre>
     *
     * <code>MONEY = 4;</code>
     */
    MONEY(4),
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use date_value.
     * </pre>
     *
     * <code>DATE = 5;</code>
     */
    DATE(5),
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use date_time_value.
     * </pre>
     *
     * <code>DATE_TIME = 6;</code>
     */
    DATE_TIME(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>DATA_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DATA_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use string_value.
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    public static final int STRING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use int_value.
     * </pre>
     *
     * <code>INT = 2;</code>
     */
    public static final int INT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use decimal_value.
     * </pre>
     *
     * <code>DECIMAL = 3;</code>
     */
    public static final int DECIMAL_VALUE = 3;
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use money_value.
     * </pre>
     *
     * <code>MONEY = 4;</code>
     */
    public static final int MONEY_VALUE = 4;
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use date_value.
     * </pre>
     *
     * <code>DATE = 5;</code>
     */
    public static final int DATE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * ReportValues for this column will use date_time_value.
     * </pre>
     *
     * <code>DATE_TIME = 6;</code>
     */
    public static final int DATE_TIME_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataType forNumber(int value) {
      switch (value) {
        case 0:
          return DATA_TYPE_UNSPECIFIED;
        case 1:
          return STRING;
        case 2:
          return INT;
        case 3:
          return DECIMAL;
        case 4:
          return MONEY;
        case 5:
          return DATE;
        case 6:
          return DATE_TIME;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DataType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DataType>() {
          public DataType findValueByNumber(int number) {
            return DataType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.channel.v1.Column.getDescriptor().getEnumTypes().get(0);
    }

    private static final DataType[] VALUES = values();

    public static DataType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.channel.v1.Column.DataType)
  }

  public static final int COLUMN_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object columnId_;
  /**
   *
   *
   * <pre>
   * The unique name of the column (for example, customer_domain,
   * channel_partner, customer_cost). You can use column IDs in
   * [RunReportJobRequest.filter][google.cloud.channel.v1.RunReportJobRequest.filter].
   * To see all reports and their columns, call
   * [CloudChannelReportsService.ListReports][google.cloud.channel.v1.CloudChannelReportsService.ListReports].
   * </pre>
   *
   * <code>string column_id = 1;</code>
   *
   * @return The columnId.
   */
  @java.lang.Override
  public java.lang.String getColumnId() {
    java.lang.Object ref = columnId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      columnId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique name of the column (for example, customer_domain,
   * channel_partner, customer_cost). You can use column IDs in
   * [RunReportJobRequest.filter][google.cloud.channel.v1.RunReportJobRequest.filter].
   * To see all reports and their columns, call
   * [CloudChannelReportsService.ListReports][google.cloud.channel.v1.CloudChannelReportsService.ListReports].
   * </pre>
   *
   * <code>string column_id = 1;</code>
   *
   * @return The bytes for columnId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getColumnIdBytes() {
    java.lang.Object ref = columnId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      columnId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The column's display name.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The column's display name.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_TYPE_FIELD_NUMBER = 3;
  private int dataType_;
  /**
   *
   *
   * <pre>
   * The type of the values for this column.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Column.DataType data_type = 3;</code>
   *
   * @return The enum numeric value on the wire for dataType.
   */
  @java.lang.Override
  public int getDataTypeValue() {
    return dataType_;
  }
  /**
   *
   *
   * <pre>
   * The type of the values for this column.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.Column.DataType data_type = 3;</code>
   *
   * @return The dataType.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Column.DataType getDataType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.channel.v1.Column.DataType result =
        com.google.cloud.channel.v1.Column.DataType.valueOf(dataType_);
    return result == null ? com.google.cloud.channel.v1.Column.DataType.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(columnId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, columnId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (dataType_
        != com.google.cloud.channel.v1.Column.DataType.DATA_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, dataType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(columnId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, columnId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (dataType_
        != com.google.cloud.channel.v1.Column.DataType.DATA_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, dataType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.Column)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.Column other = (com.google.cloud.channel.v1.Column) obj;

    if (!getColumnId().equals(other.getColumnId())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (dataType_ != other.dataType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + COLUMN_ID_FIELD_NUMBER;
    hash = (53 * hash) + getColumnId().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DATA_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + dataType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.Column parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Column parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Column parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Column parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Column parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.Column parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Column parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Column parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Column parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Column parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.Column parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.Column parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.Column prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The definition of a report column. Specifies the data properties
   * in the corresponding position of the report rows.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.Column}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.Column)
      com.google.cloud.channel.v1.ColumnOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.ReportsServiceProto
          .internal_static_google_cloud_channel_v1_Column_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.ReportsServiceProto
          .internal_static_google_cloud_channel_v1_Column_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.Column.class,
              com.google.cloud.channel.v1.Column.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.Column.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      columnId_ = "";

      displayName_ = "";

      dataType_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.ReportsServiceProto
          .internal_static_google_cloud_channel_v1_Column_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Column getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.Column.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Column build() {
      com.google.cloud.channel.v1.Column result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.Column buildPartial() {
      com.google.cloud.channel.v1.Column result = new com.google.cloud.channel.v1.Column(this);
      result.columnId_ = columnId_;
      result.displayName_ = displayName_;
      result.dataType_ = dataType_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.Column) {
        return mergeFrom((com.google.cloud.channel.v1.Column) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.Column other) {
      if (other == com.google.cloud.channel.v1.Column.getDefaultInstance()) return this;
      if (!other.getColumnId().isEmpty()) {
        columnId_ = other.columnId_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.dataType_ != 0) {
        setDataTypeValue(other.getDataTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                columnId_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 24:
              {
                dataType_ = input.readEnum();

                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object columnId_ = "";
    /**
     *
     *
     * <pre>
     * The unique name of the column (for example, customer_domain,
     * channel_partner, customer_cost). You can use column IDs in
     * [RunReportJobRequest.filter][google.cloud.channel.v1.RunReportJobRequest.filter].
     * To see all reports and their columns, call
     * [CloudChannelReportsService.ListReports][google.cloud.channel.v1.CloudChannelReportsService.ListReports].
     * </pre>
     *
     * <code>string column_id = 1;</code>
     *
     * @return The columnId.
     */
    public java.lang.String getColumnId() {
      java.lang.Object ref = columnId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        columnId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique name of the column (for example, customer_domain,
     * channel_partner, customer_cost). You can use column IDs in
     * [RunReportJobRequest.filter][google.cloud.channel.v1.RunReportJobRequest.filter].
     * To see all reports and their columns, call
     * [CloudChannelReportsService.ListReports][google.cloud.channel.v1.CloudChannelReportsService.ListReports].
     * </pre>
     *
     * <code>string column_id = 1;</code>
     *
     * @return The bytes for columnId.
     */
    public com.google.protobuf.ByteString getColumnIdBytes() {
      java.lang.Object ref = columnId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        columnId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique name of the column (for example, customer_domain,
     * channel_partner, customer_cost). You can use column IDs in
     * [RunReportJobRequest.filter][google.cloud.channel.v1.RunReportJobRequest.filter].
     * To see all reports and their columns, call
     * [CloudChannelReportsService.ListReports][google.cloud.channel.v1.CloudChannelReportsService.ListReports].
     * </pre>
     *
     * <code>string column_id = 1;</code>
     *
     * @param value The columnId to set.
     * @return This builder for chaining.
     */
    public Builder setColumnId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      columnId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique name of the column (for example, customer_domain,
     * channel_partner, customer_cost). You can use column IDs in
     * [RunReportJobRequest.filter][google.cloud.channel.v1.RunReportJobRequest.filter].
     * To see all reports and their columns, call
     * [CloudChannelReportsService.ListReports][google.cloud.channel.v1.CloudChannelReportsService.ListReports].
     * </pre>
     *
     * <code>string column_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColumnId() {

      columnId_ = getDefaultInstance().getColumnId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique name of the column (for example, customer_domain,
     * channel_partner, customer_cost). You can use column IDs in
     * [RunReportJobRequest.filter][google.cloud.channel.v1.RunReportJobRequest.filter].
     * To see all reports and their columns, call
     * [CloudChannelReportsService.ListReports][google.cloud.channel.v1.CloudChannelReportsService.ListReports].
     * </pre>
     *
     * <code>string column_id = 1;</code>
     *
     * @param value The bytes for columnId to set.
     * @return This builder for chaining.
     */
    public Builder setColumnIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      columnId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The column's display name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The column's display name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The column's display name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The column's display name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The column's display name.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private int dataType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the values for this column.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Column.DataType data_type = 3;</code>
     *
     * @return The enum numeric value on the wire for dataType.
     */
    @java.lang.Override
    public int getDataTypeValue() {
      return dataType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the values for this column.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Column.DataType data_type = 3;</code>
     *
     * @param value The enum numeric value on the wire for dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataTypeValue(int value) {

      dataType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the values for this column.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Column.DataType data_type = 3;</code>
     *
     * @return The dataType.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.Column.DataType getDataType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.Column.DataType result =
          com.google.cloud.channel.v1.Column.DataType.valueOf(dataType_);
      return result == null ? com.google.cloud.channel.v1.Column.DataType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the values for this column.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Column.DataType data_type = 3;</code>
     *
     * @param value The dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataType(com.google.cloud.channel.v1.Column.DataType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      dataType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the values for this column.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.Column.DataType data_type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataType() {

      dataType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.Column)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.Column)
  private static final com.google.cloud.channel.v1.Column DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.Column();
  }

  public static com.google.cloud.channel.v1.Column getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Column> PARSER =
      new com.google.protobuf.AbstractParser<Column>() {
        @java.lang.Override
        public Column parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Column> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Column> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.Column getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
