/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/common.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Cloud Identity information for the Cloud Channel Customer.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.CloudIdentityInfo}
 */
public final class CloudIdentityInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.CloudIdentityInfo)
    CloudIdentityInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudIdentityInfo.newBuilder() to construct.
  private CloudIdentityInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudIdentityInfo() {
    customerType_ = 0;
    primaryDomain_ = "";
    alternateEmail_ = "";
    phoneNumber_ = "";
    languageCode_ = "";
    adminConsoleUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudIdentityInfo();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.CommonProto
        .internal_static_google_cloud_channel_v1_CloudIdentityInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.CommonProto
        .internal_static_google_cloud_channel_v1_CloudIdentityInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.CloudIdentityInfo.class,
            com.google.cloud.channel.v1.CloudIdentityInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * CustomerType of the customer
   * </pre>
   *
   * Protobuf enum {@code google.cloud.channel.v1.CloudIdentityInfo.CustomerType}
   */
  public enum CustomerType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>CUSTOMER_TYPE_UNSPECIFIED = 0;</code>
     */
    CUSTOMER_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Domain-owning customer which needs domain verification to use services.
     * </pre>
     *
     * <code>DOMAIN = 1;</code>
     */
    DOMAIN(1),
    /**
     *
     *
     * <pre>
     * Team customer which needs email verification to use services.
     * </pre>
     *
     * <code>TEAM = 2;</code>
     */
    TEAM(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>CUSTOMER_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int CUSTOMER_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Domain-owning customer which needs domain verification to use services.
     * </pre>
     *
     * <code>DOMAIN = 1;</code>
     */
    public static final int DOMAIN_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Team customer which needs email verification to use services.
     * </pre>
     *
     * <code>TEAM = 2;</code>
     */
    public static final int TEAM_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CustomerType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CustomerType forNumber(int value) {
      switch (value) {
        case 0:
          return CUSTOMER_TYPE_UNSPECIFIED;
        case 1:
          return DOMAIN;
        case 2:
          return TEAM;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CustomerType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CustomerType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<CustomerType>() {
          public CustomerType findValueByNumber(int number) {
            return CustomerType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.channel.v1.CloudIdentityInfo.getDescriptor().getEnumTypes().get(0);
    }

    private static final CustomerType[] VALUES = values();

    public static CustomerType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CustomerType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.channel.v1.CloudIdentityInfo.CustomerType)
  }

  public static final int CUSTOMER_TYPE_FIELD_NUMBER = 1;
  private int customerType_;
  /**
   *
   *
   * <pre>
   * CustomerType indicates verification type needed for using services.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.CloudIdentityInfo.CustomerType customer_type = 1;</code>
   *
   * @return The enum numeric value on the wire for customerType.
   */
  @java.lang.Override
  public int getCustomerTypeValue() {
    return customerType_;
  }
  /**
   *
   *
   * <pre>
   * CustomerType indicates verification type needed for using services.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.CloudIdentityInfo.CustomerType customer_type = 1;</code>
   *
   * @return The customerType.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType getCustomerType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType result =
        com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType.valueOf(customerType_);
    return result == null
        ? com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType.UNRECOGNIZED
        : result;
  }

  public static final int PRIMARY_DOMAIN_FIELD_NUMBER = 9;
  private volatile java.lang.Object primaryDomain_;
  /**
   *
   *
   * <pre>
   * Output only. The primary domain name.
   * </pre>
   *
   * <code>string primary_domain = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The primaryDomain.
   */
  @java.lang.Override
  public java.lang.String getPrimaryDomain() {
    java.lang.Object ref = primaryDomain_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      primaryDomain_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The primary domain name.
   * </pre>
   *
   * <code>string primary_domain = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for primaryDomain.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrimaryDomainBytes() {
    java.lang.Object ref = primaryDomain_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      primaryDomain_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_DOMAIN_VERIFIED_FIELD_NUMBER = 4;
  private boolean isDomainVerified_;
  /**
   *
   *
   * <pre>
   * Output only. Whether the domain is verified.
   * This field is not returned for a Customer's cloud_identity_info resource.
   * Partners can use the domains.get() method of the Workspace SDK's
   * Directory API, or listen to the PRIMARY_DOMAIN_VERIFIED Pub/Sub event in
   * to track domain verification of their resolve Workspace customers.
   * </pre>
   *
   * <code>bool is_domain_verified = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The isDomainVerified.
   */
  @java.lang.Override
  public boolean getIsDomainVerified() {
    return isDomainVerified_;
  }

  public static final int ALTERNATE_EMAIL_FIELD_NUMBER = 6;
  private volatile java.lang.Object alternateEmail_;
  /**
   *
   *
   * <pre>
   * The alternate email.
   * </pre>
   *
   * <code>string alternate_email = 6;</code>
   *
   * @return The alternateEmail.
   */
  @java.lang.Override
  public java.lang.String getAlternateEmail() {
    java.lang.Object ref = alternateEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      alternateEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The alternate email.
   * </pre>
   *
   * <code>string alternate_email = 6;</code>
   *
   * @return The bytes for alternateEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAlternateEmailBytes() {
    java.lang.Object ref = alternateEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      alternateEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PHONE_NUMBER_FIELD_NUMBER = 7;
  private volatile java.lang.Object phoneNumber_;
  /**
   *
   *
   * <pre>
   * Phone number associated with the Cloud Identity.
   * </pre>
   *
   * <code>string phone_number = 7;</code>
   *
   * @return The phoneNumber.
   */
  @java.lang.Override
  public java.lang.String getPhoneNumber() {
    java.lang.Object ref = phoneNumber_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      phoneNumber_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Phone number associated with the Cloud Identity.
   * </pre>
   *
   * <code>string phone_number = 7;</code>
   *
   * @return The bytes for phoneNumber.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPhoneNumberBytes() {
    java.lang.Object ref = phoneNumber_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      phoneNumber_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 8;
  private volatile java.lang.Object languageCode_;
  /**
   *
   *
   * <pre>
   * Language code.
   * </pre>
   *
   * <code>string language_code = 8;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Language code.
   * </pre>
   *
   * <code>string language_code = 8;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADMIN_CONSOLE_URI_FIELD_NUMBER = 10;
  private volatile java.lang.Object adminConsoleUri_;
  /**
   *
   *
   * <pre>
   * Output only. URI of Customer's Admin console dashboard.
   * </pre>
   *
   * <code>string admin_console_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The adminConsoleUri.
   */
  @java.lang.Override
  public java.lang.String getAdminConsoleUri() {
    java.lang.Object ref = adminConsoleUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      adminConsoleUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. URI of Customer's Admin console dashboard.
   * </pre>
   *
   * <code>string admin_console_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for adminConsoleUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAdminConsoleUriBytes() {
    java.lang.Object ref = adminConsoleUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      adminConsoleUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EDU_DATA_FIELD_NUMBER = 22;
  private com.google.cloud.channel.v1.EduData eduData_;
  /**
   *
   *
   * <pre>
   * Edu information about the customer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
   *
   * @return Whether the eduData field is set.
   */
  @java.lang.Override
  public boolean hasEduData() {
    return eduData_ != null;
  }
  /**
   *
   *
   * <pre>
   * Edu information about the customer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
   *
   * @return The eduData.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.EduData getEduData() {
    return eduData_ == null ? com.google.cloud.channel.v1.EduData.getDefaultInstance() : eduData_;
  }
  /**
   *
   *
   * <pre>
   * Edu information about the customer.
   * </pre>
   *
   * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.EduDataOrBuilder getEduDataOrBuilder() {
    return getEduData();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (customerType_
        != com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType.CUSTOMER_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, customerType_);
    }
    if (isDomainVerified_ != false) {
      output.writeBool(4, isDomainVerified_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alternateEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, alternateEmail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phoneNumber_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, phoneNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, languageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryDomain_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, primaryDomain_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(adminConsoleUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, adminConsoleUri_);
    }
    if (eduData_ != null) {
      output.writeMessage(22, getEduData());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (customerType_
        != com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType.CUSTOMER_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, customerType_);
    }
    if (isDomainVerified_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, isDomainVerified_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alternateEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, alternateEmail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phoneNumber_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, phoneNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, languageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryDomain_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, primaryDomain_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(adminConsoleUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, adminConsoleUri_);
    }
    if (eduData_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getEduData());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.CloudIdentityInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.CloudIdentityInfo other =
        (com.google.cloud.channel.v1.CloudIdentityInfo) obj;

    if (customerType_ != other.customerType_) return false;
    if (!getPrimaryDomain().equals(other.getPrimaryDomain())) return false;
    if (getIsDomainVerified() != other.getIsDomainVerified()) return false;
    if (!getAlternateEmail().equals(other.getAlternateEmail())) return false;
    if (!getPhoneNumber().equals(other.getPhoneNumber())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getAdminConsoleUri().equals(other.getAdminConsoleUri())) return false;
    if (hasEduData() != other.hasEduData()) return false;
    if (hasEduData()) {
      if (!getEduData().equals(other.getEduData())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CUSTOMER_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + customerType_;
    hash = (37 * hash) + PRIMARY_DOMAIN_FIELD_NUMBER;
    hash = (53 * hash) + getPrimaryDomain().hashCode();
    hash = (37 * hash) + IS_DOMAIN_VERIFIED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsDomainVerified());
    hash = (37 * hash) + ALTERNATE_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getAlternateEmail().hashCode();
    hash = (37 * hash) + PHONE_NUMBER_FIELD_NUMBER;
    hash = (53 * hash) + getPhoneNumber().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + ADMIN_CONSOLE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAdminConsoleUri().hashCode();
    if (hasEduData()) {
      hash = (37 * hash) + EDU_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getEduData().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.CloudIdentityInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Cloud Identity information for the Cloud Channel Customer.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.CloudIdentityInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.CloudIdentityInfo)
      com.google.cloud.channel.v1.CloudIdentityInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.CommonProto
          .internal_static_google_cloud_channel_v1_CloudIdentityInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.CommonProto
          .internal_static_google_cloud_channel_v1_CloudIdentityInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.CloudIdentityInfo.class,
              com.google.cloud.channel.v1.CloudIdentityInfo.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.CloudIdentityInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      customerType_ = 0;

      primaryDomain_ = "";

      isDomainVerified_ = false;

      alternateEmail_ = "";

      phoneNumber_ = "";

      languageCode_ = "";

      adminConsoleUri_ = "";

      if (eduDataBuilder_ == null) {
        eduData_ = null;
      } else {
        eduData_ = null;
        eduDataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.CommonProto
          .internal_static_google_cloud_channel_v1_CloudIdentityInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.CloudIdentityInfo getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.CloudIdentityInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.CloudIdentityInfo build() {
      com.google.cloud.channel.v1.CloudIdentityInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.CloudIdentityInfo buildPartial() {
      com.google.cloud.channel.v1.CloudIdentityInfo result =
          new com.google.cloud.channel.v1.CloudIdentityInfo(this);
      result.customerType_ = customerType_;
      result.primaryDomain_ = primaryDomain_;
      result.isDomainVerified_ = isDomainVerified_;
      result.alternateEmail_ = alternateEmail_;
      result.phoneNumber_ = phoneNumber_;
      result.languageCode_ = languageCode_;
      result.adminConsoleUri_ = adminConsoleUri_;
      if (eduDataBuilder_ == null) {
        result.eduData_ = eduData_;
      } else {
        result.eduData_ = eduDataBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.CloudIdentityInfo) {
        return mergeFrom((com.google.cloud.channel.v1.CloudIdentityInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.CloudIdentityInfo other) {
      if (other == com.google.cloud.channel.v1.CloudIdentityInfo.getDefaultInstance()) return this;
      if (other.customerType_ != 0) {
        setCustomerTypeValue(other.getCustomerTypeValue());
      }
      if (!other.getPrimaryDomain().isEmpty()) {
        primaryDomain_ = other.primaryDomain_;
        onChanged();
      }
      if (other.getIsDomainVerified() != false) {
        setIsDomainVerified(other.getIsDomainVerified());
      }
      if (!other.getAlternateEmail().isEmpty()) {
        alternateEmail_ = other.alternateEmail_;
        onChanged();
      }
      if (!other.getPhoneNumber().isEmpty()) {
        phoneNumber_ = other.phoneNumber_;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        onChanged();
      }
      if (!other.getAdminConsoleUri().isEmpty()) {
        adminConsoleUri_ = other.adminConsoleUri_;
        onChanged();
      }
      if (other.hasEduData()) {
        mergeEduData(other.getEduData());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                customerType_ = input.readEnum();

                break;
              } // case 8
            case 32:
              {
                isDomainVerified_ = input.readBool();

                break;
              } // case 32
            case 50:
              {
                alternateEmail_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 58:
              {
                phoneNumber_ = input.readStringRequireUtf8();

                break;
              } // case 58
            case 66:
              {
                languageCode_ = input.readStringRequireUtf8();

                break;
              } // case 66
            case 74:
              {
                primaryDomain_ = input.readStringRequireUtf8();

                break;
              } // case 74
            case 82:
              {
                adminConsoleUri_ = input.readStringRequireUtf8();

                break;
              } // case 82
            case 178:
              {
                input.readMessage(getEduDataFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 178
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int customerType_ = 0;
    /**
     *
     *
     * <pre>
     * CustomerType indicates verification type needed for using services.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CloudIdentityInfo.CustomerType customer_type = 1;</code>
     *
     * @return The enum numeric value on the wire for customerType.
     */
    @java.lang.Override
    public int getCustomerTypeValue() {
      return customerType_;
    }
    /**
     *
     *
     * <pre>
     * CustomerType indicates verification type needed for using services.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CloudIdentityInfo.CustomerType customer_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for customerType to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerTypeValue(int value) {

      customerType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomerType indicates verification type needed for using services.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CloudIdentityInfo.CustomerType customer_type = 1;</code>
     *
     * @return The customerType.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType getCustomerType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType result =
          com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType.valueOf(customerType_);
      return result == null
          ? com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * CustomerType indicates verification type needed for using services.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CloudIdentityInfo.CustomerType customer_type = 1;</code>
     *
     * @param value The customerType to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerType(
        com.google.cloud.channel.v1.CloudIdentityInfo.CustomerType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      customerType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomerType indicates verification type needed for using services.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.CloudIdentityInfo.CustomerType customer_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomerType() {

      customerType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object primaryDomain_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The primary domain name.
     * </pre>
     *
     * <code>string primary_domain = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The primaryDomain.
     */
    public java.lang.String getPrimaryDomain() {
      java.lang.Object ref = primaryDomain_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        primaryDomain_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The primary domain name.
     * </pre>
     *
     * <code>string primary_domain = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for primaryDomain.
     */
    public com.google.protobuf.ByteString getPrimaryDomainBytes() {
      java.lang.Object ref = primaryDomain_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        primaryDomain_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The primary domain name.
     * </pre>
     *
     * <code>string primary_domain = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The primaryDomain to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryDomain(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      primaryDomain_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The primary domain name.
     * </pre>
     *
     * <code>string primary_domain = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrimaryDomain() {

      primaryDomain_ = getDefaultInstance().getPrimaryDomain();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The primary domain name.
     * </pre>
     *
     * <code>string primary_domain = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for primaryDomain to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryDomainBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      primaryDomain_ = value;
      onChanged();
      return this;
    }

    private boolean isDomainVerified_;
    /**
     *
     *
     * <pre>
     * Output only. Whether the domain is verified.
     * This field is not returned for a Customer's cloud_identity_info resource.
     * Partners can use the domains.get() method of the Workspace SDK's
     * Directory API, or listen to the PRIMARY_DOMAIN_VERIFIED Pub/Sub event in
     * to track domain verification of their resolve Workspace customers.
     * </pre>
     *
     * <code>bool is_domain_verified = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The isDomainVerified.
     */
    @java.lang.Override
    public boolean getIsDomainVerified() {
      return isDomainVerified_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the domain is verified.
     * This field is not returned for a Customer's cloud_identity_info resource.
     * Partners can use the domains.get() method of the Workspace SDK's
     * Directory API, or listen to the PRIMARY_DOMAIN_VERIFIED Pub/Sub event in
     * to track domain verification of their resolve Workspace customers.
     * </pre>
     *
     * <code>bool is_domain_verified = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The isDomainVerified to set.
     * @return This builder for chaining.
     */
    public Builder setIsDomainVerified(boolean value) {

      isDomainVerified_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether the domain is verified.
     * This field is not returned for a Customer's cloud_identity_info resource.
     * Partners can use the domains.get() method of the Workspace SDK's
     * Directory API, or listen to the PRIMARY_DOMAIN_VERIFIED Pub/Sub event in
     * to track domain verification of their resolve Workspace customers.
     * </pre>
     *
     * <code>bool is_domain_verified = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsDomainVerified() {

      isDomainVerified_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object alternateEmail_ = "";
    /**
     *
     *
     * <pre>
     * The alternate email.
     * </pre>
     *
     * <code>string alternate_email = 6;</code>
     *
     * @return The alternateEmail.
     */
    public java.lang.String getAlternateEmail() {
      java.lang.Object ref = alternateEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        alternateEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The alternate email.
     * </pre>
     *
     * <code>string alternate_email = 6;</code>
     *
     * @return The bytes for alternateEmail.
     */
    public com.google.protobuf.ByteString getAlternateEmailBytes() {
      java.lang.Object ref = alternateEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        alternateEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The alternate email.
     * </pre>
     *
     * <code>string alternate_email = 6;</code>
     *
     * @param value The alternateEmail to set.
     * @return This builder for chaining.
     */
    public Builder setAlternateEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      alternateEmail_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The alternate email.
     * </pre>
     *
     * <code>string alternate_email = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlternateEmail() {

      alternateEmail_ = getDefaultInstance().getAlternateEmail();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The alternate email.
     * </pre>
     *
     * <code>string alternate_email = 6;</code>
     *
     * @param value The bytes for alternateEmail to set.
     * @return This builder for chaining.
     */
    public Builder setAlternateEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      alternateEmail_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object phoneNumber_ = "";
    /**
     *
     *
     * <pre>
     * Phone number associated with the Cloud Identity.
     * </pre>
     *
     * <code>string phone_number = 7;</code>
     *
     * @return The phoneNumber.
     */
    public java.lang.String getPhoneNumber() {
      java.lang.Object ref = phoneNumber_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        phoneNumber_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Phone number associated with the Cloud Identity.
     * </pre>
     *
     * <code>string phone_number = 7;</code>
     *
     * @return The bytes for phoneNumber.
     */
    public com.google.protobuf.ByteString getPhoneNumberBytes() {
      java.lang.Object ref = phoneNumber_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        phoneNumber_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Phone number associated with the Cloud Identity.
     * </pre>
     *
     * <code>string phone_number = 7;</code>
     *
     * @param value The phoneNumber to set.
     * @return This builder for chaining.
     */
    public Builder setPhoneNumber(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      phoneNumber_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Phone number associated with the Cloud Identity.
     * </pre>
     *
     * <code>string phone_number = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhoneNumber() {

      phoneNumber_ = getDefaultInstance().getPhoneNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Phone number associated with the Cloud Identity.
     * </pre>
     *
     * <code>string phone_number = 7;</code>
     *
     * @param value The bytes for phoneNumber to set.
     * @return This builder for chaining.
     */
    public Builder setPhoneNumberBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      phoneNumber_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Language code.
     * </pre>
     *
     * <code>string language_code = 8;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language code.
     * </pre>
     *
     * <code>string language_code = 8;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language code.
     * </pre>
     *
     * <code>string language_code = 8;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      languageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language code.
     * </pre>
     *
     * <code>string language_code = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {

      languageCode_ = getDefaultInstance().getLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language code.
     * </pre>
     *
     * <code>string language_code = 8;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      languageCode_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object adminConsoleUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. URI of Customer's Admin console dashboard.
     * </pre>
     *
     * <code>string admin_console_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The adminConsoleUri.
     */
    public java.lang.String getAdminConsoleUri() {
      java.lang.Object ref = adminConsoleUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        adminConsoleUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of Customer's Admin console dashboard.
     * </pre>
     *
     * <code>string admin_console_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for adminConsoleUri.
     */
    public com.google.protobuf.ByteString getAdminConsoleUriBytes() {
      java.lang.Object ref = adminConsoleUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        adminConsoleUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of Customer's Admin console dashboard.
     * </pre>
     *
     * <code>string admin_console_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The adminConsoleUri to set.
     * @return This builder for chaining.
     */
    public Builder setAdminConsoleUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      adminConsoleUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of Customer's Admin console dashboard.
     * </pre>
     *
     * <code>string admin_console_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdminConsoleUri() {

      adminConsoleUri_ = getDefaultInstance().getAdminConsoleUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of Customer's Admin console dashboard.
     * </pre>
     *
     * <code>string admin_console_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for adminConsoleUri to set.
     * @return This builder for chaining.
     */
    public Builder setAdminConsoleUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      adminConsoleUri_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.channel.v1.EduData eduData_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.EduData,
            com.google.cloud.channel.v1.EduData.Builder,
            com.google.cloud.channel.v1.EduDataOrBuilder>
        eduDataBuilder_;
    /**
     *
     *
     * <pre>
     * Edu information about the customer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
     *
     * @return Whether the eduData field is set.
     */
    public boolean hasEduData() {
      return eduDataBuilder_ != null || eduData_ != null;
    }
    /**
     *
     *
     * <pre>
     * Edu information about the customer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
     *
     * @return The eduData.
     */
    public com.google.cloud.channel.v1.EduData getEduData() {
      if (eduDataBuilder_ == null) {
        return eduData_ == null
            ? com.google.cloud.channel.v1.EduData.getDefaultInstance()
            : eduData_;
      } else {
        return eduDataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Edu information about the customer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
     */
    public Builder setEduData(com.google.cloud.channel.v1.EduData value) {
      if (eduDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eduData_ = value;
        onChanged();
      } else {
        eduDataBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Edu information about the customer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
     */
    public Builder setEduData(com.google.cloud.channel.v1.EduData.Builder builderForValue) {
      if (eduDataBuilder_ == null) {
        eduData_ = builderForValue.build();
        onChanged();
      } else {
        eduDataBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Edu information about the customer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
     */
    public Builder mergeEduData(com.google.cloud.channel.v1.EduData value) {
      if (eduDataBuilder_ == null) {
        if (eduData_ != null) {
          eduData_ =
              com.google.cloud.channel.v1.EduData.newBuilder(eduData_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          eduData_ = value;
        }
        onChanged();
      } else {
        eduDataBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Edu information about the customer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
     */
    public Builder clearEduData() {
      if (eduDataBuilder_ == null) {
        eduData_ = null;
        onChanged();
      } else {
        eduData_ = null;
        eduDataBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Edu information about the customer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
     */
    public com.google.cloud.channel.v1.EduData.Builder getEduDataBuilder() {

      onChanged();
      return getEduDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Edu information about the customer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
     */
    public com.google.cloud.channel.v1.EduDataOrBuilder getEduDataOrBuilder() {
      if (eduDataBuilder_ != null) {
        return eduDataBuilder_.getMessageOrBuilder();
      } else {
        return eduData_ == null
            ? com.google.cloud.channel.v1.EduData.getDefaultInstance()
            : eduData_;
      }
    }
    /**
     *
     *
     * <pre>
     * Edu information about the customer.
     * </pre>
     *
     * <code>.google.cloud.channel.v1.EduData edu_data = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.EduData,
            com.google.cloud.channel.v1.EduData.Builder,
            com.google.cloud.channel.v1.EduDataOrBuilder>
        getEduDataFieldBuilder() {
      if (eduDataBuilder_ == null) {
        eduDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.EduData,
                com.google.cloud.channel.v1.EduData.Builder,
                com.google.cloud.channel.v1.EduDataOrBuilder>(
                getEduData(), getParentForChildren(), isClean());
        eduData_ = null;
      }
      return eduDataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.CloudIdentityInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.CloudIdentityInfo)
  private static final com.google.cloud.channel.v1.CloudIdentityInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.CloudIdentityInfo();
  }

  public static com.google.cloud.channel.v1.CloudIdentityInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudIdentityInfo> PARSER =
      new com.google.protobuf.AbstractParser<CloudIdentityInfo>() {
        @java.lang.Override
        public CloudIdentityInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudIdentityInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudIdentityInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.CloudIdentityInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
