/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/channel_partner_links.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Entity representing a link between distributors and their indirect
 * resellers in an n-tier resale channel.
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.ChannelPartnerLink}
 */
public final class ChannelPartnerLink extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.ChannelPartnerLink)
    ChannelPartnerLinkOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ChannelPartnerLink.newBuilder() to construct.
  private ChannelPartnerLink(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ChannelPartnerLink() {
    name_ = "";
    resellerCloudIdentityId_ = "";
    linkState_ = 0;
    inviteLinkUri_ = "";
    publicId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ChannelPartnerLink();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.ChannelPartnerLinksProto
        .internal_static_google_cloud_channel_v1_ChannelPartnerLink_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.ChannelPartnerLinksProto
        .internal_static_google_cloud_channel_v1_ChannelPartnerLink_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.ChannelPartnerLink.class,
            com.google.cloud.channel.v1.ChannelPartnerLink.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Resource name for the channel partner link, in the format
   * accounts/{account_id}/channelPartnerLinks/{id}.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name for the channel partner link, in the format
   * accounts/{account_id}/channelPartnerLinks/{id}.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESELLER_CLOUD_IDENTITY_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object resellerCloudIdentityId_;
  /**
   *
   *
   * <pre>
   * Required. Cloud Identity ID of the linked reseller.
   * </pre>
   *
   * <code>string reseller_cloud_identity_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The resellerCloudIdentityId.
   */
  @java.lang.Override
  public java.lang.String getResellerCloudIdentityId() {
    java.lang.Object ref = resellerCloudIdentityId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resellerCloudIdentityId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Cloud Identity ID of the linked reseller.
   * </pre>
   *
   * <code>string reseller_cloud_identity_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for resellerCloudIdentityId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResellerCloudIdentityIdBytes() {
    java.lang.Object ref = resellerCloudIdentityId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resellerCloudIdentityId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINK_STATE_FIELD_NUMBER = 3;
  private int linkState_;
  /**
   *
   *
   * <pre>
   * Required. State of the channel partner link.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.ChannelPartnerLinkState link_state = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for linkState.
   */
  @java.lang.Override
  public int getLinkStateValue() {
    return linkState_;
  }
  /**
   *
   *
   * <pre>
   * Required. State of the channel partner link.
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.ChannelPartnerLinkState link_state = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The linkState.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ChannelPartnerLinkState getLinkState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.channel.v1.ChannelPartnerLinkState result =
        com.google.cloud.channel.v1.ChannelPartnerLinkState.valueOf(linkState_);
    return result == null
        ? com.google.cloud.channel.v1.ChannelPartnerLinkState.UNRECOGNIZED
        : result;
  }

  public static final int INVITE_LINK_URI_FIELD_NUMBER = 4;
  private volatile java.lang.Object inviteLinkUri_;
  /**
   *
   *
   * <pre>
   * Output only. URI of the web page where partner accepts the link invitation.
   * </pre>
   *
   * <code>string invite_link_uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The inviteLinkUri.
   */
  @java.lang.Override
  public java.lang.String getInviteLinkUri() {
    java.lang.Object ref = inviteLinkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inviteLinkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. URI of the web page where partner accepts the link invitation.
   * </pre>
   *
   * <code>string invite_link_uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for inviteLinkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInviteLinkUriBytes() {
    java.lang.Object ref = inviteLinkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inviteLinkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when the channel partner link is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when the channel partner link is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when the channel partner link is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when the channel partner link is updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when the channel partner link is updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when the channel partner link is updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int PUBLIC_ID_FIELD_NUMBER = 7;
  private volatile java.lang.Object publicId_;
  /**
   *
   *
   * <pre>
   * Output only. Public identifier that a customer must use to generate a transfer token
   * to move to this distributor-reseller combination.
   * </pre>
   *
   * <code>string public_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The publicId.
   */
  @java.lang.Override
  public java.lang.String getPublicId() {
    java.lang.Object ref = publicId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      publicId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Public identifier that a customer must use to generate a transfer token
   * to move to this distributor-reseller combination.
   * </pre>
   *
   * <code>string public_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for publicId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPublicIdBytes() {
    java.lang.Object ref = publicId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      publicId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHANNEL_PARTNER_CLOUD_IDENTITY_INFO_FIELD_NUMBER = 8;
  private com.google.cloud.channel.v1.CloudIdentityInfo channelPartnerCloudIdentityInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Cloud Identity info of the channel partner (IR).
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the channelPartnerCloudIdentityInfo field is set.
   */
  @java.lang.Override
  public boolean hasChannelPartnerCloudIdentityInfo() {
    return channelPartnerCloudIdentityInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Cloud Identity info of the channel partner (IR).
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The channelPartnerCloudIdentityInfo.
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.CloudIdentityInfo getChannelPartnerCloudIdentityInfo() {
    return channelPartnerCloudIdentityInfo_ == null
        ? com.google.cloud.channel.v1.CloudIdentityInfo.getDefaultInstance()
        : channelPartnerCloudIdentityInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Cloud Identity info of the channel partner (IR).
   * </pre>
   *
   * <code>
   * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.CloudIdentityInfoOrBuilder
      getChannelPartnerCloudIdentityInfoOrBuilder() {
    return getChannelPartnerCloudIdentityInfo();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resellerCloudIdentityId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resellerCloudIdentityId_);
    }
    if (linkState_
        != com.google.cloud.channel.v1.ChannelPartnerLinkState
            .CHANNEL_PARTNER_LINK_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, linkState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inviteLinkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, inviteLinkUri_);
    }
    if (createTime_ != null) {
      output.writeMessage(5, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, publicId_);
    }
    if (channelPartnerCloudIdentityInfo_ != null) {
      output.writeMessage(8, getChannelPartnerCloudIdentityInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resellerCloudIdentityId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resellerCloudIdentityId_);
    }
    if (linkState_
        != com.google.cloud.channel.v1.ChannelPartnerLinkState
            .CHANNEL_PARTNER_LINK_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, linkState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inviteLinkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, inviteLinkUri_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, publicId_);
    }
    if (channelPartnerCloudIdentityInfo_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getChannelPartnerCloudIdentityInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.ChannelPartnerLink)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.ChannelPartnerLink other =
        (com.google.cloud.channel.v1.ChannelPartnerLink) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getResellerCloudIdentityId().equals(other.getResellerCloudIdentityId())) return false;
    if (linkState_ != other.linkState_) return false;
    if (!getInviteLinkUri().equals(other.getInviteLinkUri())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getPublicId().equals(other.getPublicId())) return false;
    if (hasChannelPartnerCloudIdentityInfo() != other.hasChannelPartnerCloudIdentityInfo())
      return false;
    if (hasChannelPartnerCloudIdentityInfo()) {
      if (!getChannelPartnerCloudIdentityInfo().equals(other.getChannelPartnerCloudIdentityInfo()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + RESELLER_CLOUD_IDENTITY_ID_FIELD_NUMBER;
    hash = (53 * hash) + getResellerCloudIdentityId().hashCode();
    hash = (37 * hash) + LINK_STATE_FIELD_NUMBER;
    hash = (53 * hash) + linkState_;
    hash = (37 * hash) + INVITE_LINK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getInviteLinkUri().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + PUBLIC_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPublicId().hashCode();
    if (hasChannelPartnerCloudIdentityInfo()) {
      hash = (37 * hash) + CHANNEL_PARTNER_CLOUD_IDENTITY_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getChannelPartnerCloudIdentityInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.ChannelPartnerLink prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Entity representing a link between distributors and their indirect
   * resellers in an n-tier resale channel.
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.ChannelPartnerLink}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.ChannelPartnerLink)
      com.google.cloud.channel.v1.ChannelPartnerLinkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.ChannelPartnerLinksProto
          .internal_static_google_cloud_channel_v1_ChannelPartnerLink_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.ChannelPartnerLinksProto
          .internal_static_google_cloud_channel_v1_ChannelPartnerLink_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.ChannelPartnerLink.class,
              com.google.cloud.channel.v1.ChannelPartnerLink.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.ChannelPartnerLink.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      resellerCloudIdentityId_ = "";

      linkState_ = 0;

      inviteLinkUri_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      publicId_ = "";

      if (channelPartnerCloudIdentityInfoBuilder_ == null) {
        channelPartnerCloudIdentityInfo_ = null;
      } else {
        channelPartnerCloudIdentityInfo_ = null;
        channelPartnerCloudIdentityInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.ChannelPartnerLinksProto
          .internal_static_google_cloud_channel_v1_ChannelPartnerLink_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ChannelPartnerLink getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.ChannelPartnerLink.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ChannelPartnerLink build() {
      com.google.cloud.channel.v1.ChannelPartnerLink result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ChannelPartnerLink buildPartial() {
      com.google.cloud.channel.v1.ChannelPartnerLink result =
          new com.google.cloud.channel.v1.ChannelPartnerLink(this);
      result.name_ = name_;
      result.resellerCloudIdentityId_ = resellerCloudIdentityId_;
      result.linkState_ = linkState_;
      result.inviteLinkUri_ = inviteLinkUri_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.publicId_ = publicId_;
      if (channelPartnerCloudIdentityInfoBuilder_ == null) {
        result.channelPartnerCloudIdentityInfo_ = channelPartnerCloudIdentityInfo_;
      } else {
        result.channelPartnerCloudIdentityInfo_ = channelPartnerCloudIdentityInfoBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.ChannelPartnerLink) {
        return mergeFrom((com.google.cloud.channel.v1.ChannelPartnerLink) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.ChannelPartnerLink other) {
      if (other == com.google.cloud.channel.v1.ChannelPartnerLink.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getResellerCloudIdentityId().isEmpty()) {
        resellerCloudIdentityId_ = other.resellerCloudIdentityId_;
        onChanged();
      }
      if (other.linkState_ != 0) {
        setLinkStateValue(other.getLinkStateValue());
      }
      if (!other.getInviteLinkUri().isEmpty()) {
        inviteLinkUri_ = other.inviteLinkUri_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getPublicId().isEmpty()) {
        publicId_ = other.publicId_;
        onChanged();
      }
      if (other.hasChannelPartnerCloudIdentityInfo()) {
        mergeChannelPartnerCloudIdentityInfo(other.getChannelPartnerCloudIdentityInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                resellerCloudIdentityId_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 24:
              {
                linkState_ = input.readEnum();

                break;
              } // case 24
            case 34:
              {
                inviteLinkUri_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                publicId_ = input.readStringRequireUtf8();

                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getChannelPartnerCloudIdentityInfoFieldBuilder().getBuilder(),
                    extensionRegistry);

                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name for the channel partner link, in the format
     * accounts/{account_id}/channelPartnerLinks/{id}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name for the channel partner link, in the format
     * accounts/{account_id}/channelPartnerLinks/{id}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name for the channel partner link, in the format
     * accounts/{account_id}/channelPartnerLinks/{id}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name for the channel partner link, in the format
     * accounts/{account_id}/channelPartnerLinks/{id}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name for the channel partner link, in the format
     * accounts/{account_id}/channelPartnerLinks/{id}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object resellerCloudIdentityId_ = "";
    /**
     *
     *
     * <pre>
     * Required. Cloud Identity ID of the linked reseller.
     * </pre>
     *
     * <code>string reseller_cloud_identity_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The resellerCloudIdentityId.
     */
    public java.lang.String getResellerCloudIdentityId() {
      java.lang.Object ref = resellerCloudIdentityId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resellerCloudIdentityId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Cloud Identity ID of the linked reseller.
     * </pre>
     *
     * <code>string reseller_cloud_identity_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for resellerCloudIdentityId.
     */
    public com.google.protobuf.ByteString getResellerCloudIdentityIdBytes() {
      java.lang.Object ref = resellerCloudIdentityId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resellerCloudIdentityId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Cloud Identity ID of the linked reseller.
     * </pre>
     *
     * <code>string reseller_cloud_identity_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The resellerCloudIdentityId to set.
     * @return This builder for chaining.
     */
    public Builder setResellerCloudIdentityId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      resellerCloudIdentityId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Cloud Identity ID of the linked reseller.
     * </pre>
     *
     * <code>string reseller_cloud_identity_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResellerCloudIdentityId() {

      resellerCloudIdentityId_ = getDefaultInstance().getResellerCloudIdentityId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Cloud Identity ID of the linked reseller.
     * </pre>
     *
     * <code>string reseller_cloud_identity_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for resellerCloudIdentityId to set.
     * @return This builder for chaining.
     */
    public Builder setResellerCloudIdentityIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      resellerCloudIdentityId_ = value;
      onChanged();
      return this;
    }

    private int linkState_ = 0;
    /**
     *
     *
     * <pre>
     * Required. State of the channel partner link.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ChannelPartnerLinkState link_state = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for linkState.
     */
    @java.lang.Override
    public int getLinkStateValue() {
      return linkState_;
    }
    /**
     *
     *
     * <pre>
     * Required. State of the channel partner link.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ChannelPartnerLinkState link_state = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for linkState to set.
     * @return This builder for chaining.
     */
    public Builder setLinkStateValue(int value) {

      linkState_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. State of the channel partner link.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ChannelPartnerLinkState link_state = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The linkState.
     */
    @java.lang.Override
    public com.google.cloud.channel.v1.ChannelPartnerLinkState getLinkState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.channel.v1.ChannelPartnerLinkState result =
          com.google.cloud.channel.v1.ChannelPartnerLinkState.valueOf(linkState_);
      return result == null
          ? com.google.cloud.channel.v1.ChannelPartnerLinkState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. State of the channel partner link.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ChannelPartnerLinkState link_state = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The linkState to set.
     * @return This builder for chaining.
     */
    public Builder setLinkState(com.google.cloud.channel.v1.ChannelPartnerLinkState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      linkState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. State of the channel partner link.
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.ChannelPartnerLinkState link_state = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLinkState() {

      linkState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object inviteLinkUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. URI of the web page where partner accepts the link invitation.
     * </pre>
     *
     * <code>string invite_link_uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The inviteLinkUri.
     */
    public java.lang.String getInviteLinkUri() {
      java.lang.Object ref = inviteLinkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inviteLinkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of the web page where partner accepts the link invitation.
     * </pre>
     *
     * <code>string invite_link_uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for inviteLinkUri.
     */
    public com.google.protobuf.ByteString getInviteLinkUriBytes() {
      java.lang.Object ref = inviteLinkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inviteLinkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of the web page where partner accepts the link invitation.
     * </pre>
     *
     * <code>string invite_link_uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The inviteLinkUri to set.
     * @return This builder for chaining.
     */
    public Builder setInviteLinkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      inviteLinkUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of the web page where partner accepts the link invitation.
     * </pre>
     *
     * <code>string invite_link_uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInviteLinkUri() {

      inviteLinkUri_ = getDefaultInstance().getInviteLinkUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of the web page where partner accepts the link invitation.
     * </pre>
     *
     * <code>string invite_link_uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for inviteLinkUri to set.
     * @return This builder for chaining.
     */
    public Builder setInviteLinkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      inviteLinkUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when the channel partner link is updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object publicId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Public identifier that a customer must use to generate a transfer token
     * to move to this distributor-reseller combination.
     * </pre>
     *
     * <code>string public_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The publicId.
     */
    public java.lang.String getPublicId() {
      java.lang.Object ref = publicId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publicId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Public identifier that a customer must use to generate a transfer token
     * to move to this distributor-reseller combination.
     * </pre>
     *
     * <code>string public_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for publicId.
     */
    public com.google.protobuf.ByteString getPublicIdBytes() {
      java.lang.Object ref = publicId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publicId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Public identifier that a customer must use to generate a transfer token
     * to move to this distributor-reseller combination.
     * </pre>
     *
     * <code>string public_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The publicId to set.
     * @return This builder for chaining.
     */
    public Builder setPublicId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      publicId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Public identifier that a customer must use to generate a transfer token
     * to move to this distributor-reseller combination.
     * </pre>
     *
     * <code>string public_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublicId() {

      publicId_ = getDefaultInstance().getPublicId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Public identifier that a customer must use to generate a transfer token
     * to move to this distributor-reseller combination.
     * </pre>
     *
     * <code>string public_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for publicId to set.
     * @return This builder for chaining.
     */
    public Builder setPublicIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      publicId_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.channel.v1.CloudIdentityInfo channelPartnerCloudIdentityInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.CloudIdentityInfo,
            com.google.cloud.channel.v1.CloudIdentityInfo.Builder,
            com.google.cloud.channel.v1.CloudIdentityInfoOrBuilder>
        channelPartnerCloudIdentityInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity info of the channel partner (IR).
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the channelPartnerCloudIdentityInfo field is set.
     */
    public boolean hasChannelPartnerCloudIdentityInfo() {
      return channelPartnerCloudIdentityInfoBuilder_ != null
          || channelPartnerCloudIdentityInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity info of the channel partner (IR).
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The channelPartnerCloudIdentityInfo.
     */
    public com.google.cloud.channel.v1.CloudIdentityInfo getChannelPartnerCloudIdentityInfo() {
      if (channelPartnerCloudIdentityInfoBuilder_ == null) {
        return channelPartnerCloudIdentityInfo_ == null
            ? com.google.cloud.channel.v1.CloudIdentityInfo.getDefaultInstance()
            : channelPartnerCloudIdentityInfo_;
      } else {
        return channelPartnerCloudIdentityInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity info of the channel partner (IR).
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChannelPartnerCloudIdentityInfo(
        com.google.cloud.channel.v1.CloudIdentityInfo value) {
      if (channelPartnerCloudIdentityInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        channelPartnerCloudIdentityInfo_ = value;
        onChanged();
      } else {
        channelPartnerCloudIdentityInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity info of the channel partner (IR).
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChannelPartnerCloudIdentityInfo(
        com.google.cloud.channel.v1.CloudIdentityInfo.Builder builderForValue) {
      if (channelPartnerCloudIdentityInfoBuilder_ == null) {
        channelPartnerCloudIdentityInfo_ = builderForValue.build();
        onChanged();
      } else {
        channelPartnerCloudIdentityInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity info of the channel partner (IR).
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeChannelPartnerCloudIdentityInfo(
        com.google.cloud.channel.v1.CloudIdentityInfo value) {
      if (channelPartnerCloudIdentityInfoBuilder_ == null) {
        if (channelPartnerCloudIdentityInfo_ != null) {
          channelPartnerCloudIdentityInfo_ =
              com.google.cloud.channel.v1.CloudIdentityInfo.newBuilder(
                      channelPartnerCloudIdentityInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          channelPartnerCloudIdentityInfo_ = value;
        }
        onChanged();
      } else {
        channelPartnerCloudIdentityInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity info of the channel partner (IR).
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearChannelPartnerCloudIdentityInfo() {
      if (channelPartnerCloudIdentityInfoBuilder_ == null) {
        channelPartnerCloudIdentityInfo_ = null;
        onChanged();
      } else {
        channelPartnerCloudIdentityInfo_ = null;
        channelPartnerCloudIdentityInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity info of the channel partner (IR).
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.channel.v1.CloudIdentityInfo.Builder
        getChannelPartnerCloudIdentityInfoBuilder() {

      onChanged();
      return getChannelPartnerCloudIdentityInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity info of the channel partner (IR).
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.channel.v1.CloudIdentityInfoOrBuilder
        getChannelPartnerCloudIdentityInfoOrBuilder() {
      if (channelPartnerCloudIdentityInfoBuilder_ != null) {
        return channelPartnerCloudIdentityInfoBuilder_.getMessageOrBuilder();
      } else {
        return channelPartnerCloudIdentityInfo_ == null
            ? com.google.cloud.channel.v1.CloudIdentityInfo.getDefaultInstance()
            : channelPartnerCloudIdentityInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Identity info of the channel partner (IR).
     * </pre>
     *
     * <code>
     * .google.cloud.channel.v1.CloudIdentityInfo channel_partner_cloud_identity_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.channel.v1.CloudIdentityInfo,
            com.google.cloud.channel.v1.CloudIdentityInfo.Builder,
            com.google.cloud.channel.v1.CloudIdentityInfoOrBuilder>
        getChannelPartnerCloudIdentityInfoFieldBuilder() {
      if (channelPartnerCloudIdentityInfoBuilder_ == null) {
        channelPartnerCloudIdentityInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.channel.v1.CloudIdentityInfo,
                com.google.cloud.channel.v1.CloudIdentityInfo.Builder,
                com.google.cloud.channel.v1.CloudIdentityInfoOrBuilder>(
                getChannelPartnerCloudIdentityInfo(), getParentForChildren(), isClean());
        channelPartnerCloudIdentityInfo_ = null;
      }
      return channelPartnerCloudIdentityInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.ChannelPartnerLink)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.ChannelPartnerLink)
  private static final com.google.cloud.channel.v1.ChannelPartnerLink DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.ChannelPartnerLink();
  }

  public static com.google.cloud.channel.v1.ChannelPartnerLink getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ChannelPartnerLink> PARSER =
      new com.google.protobuf.AbstractParser<ChannelPartnerLink>() {
        @java.lang.Override
        public ChannelPartnerLink parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ChannelPartnerLink> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ChannelPartnerLink> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.ChannelPartnerLink getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
