/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/channel/v1/service.proto

package com.google.cloud.channel.v1;

/**
 *
 *
 * <pre>
 * Request message for [CloudChannelService.ChangeParametersRequest][].
 * </pre>
 *
 * Protobuf type {@code google.cloud.channel.v1.ChangeParametersRequest}
 */
public final class ChangeParametersRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.channel.v1.ChangeParametersRequest)
    ChangeParametersRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ChangeParametersRequest.newBuilder() to construct.
  private ChangeParametersRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ChangeParametersRequest() {
    name_ = "";
    parameters_ = java.util.Collections.emptyList();
    requestId_ = "";
    purchaseOrderId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ChangeParametersRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.channel.v1.ServiceProto
        .internal_static_google_cloud_channel_v1_ChangeParametersRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.channel.v1.ServiceProto
        .internal_static_google_cloud_channel_v1_ChangeParametersRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.channel.v1.ChangeParametersRequest.class,
            com.google.cloud.channel.v1.ChangeParametersRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The name of the entitlement to update.
   * Name uses the format:
   * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the entitlement to update.
   * Name uses the format:
   * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETERS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.channel.v1.Parameter> parameters_;
  /**
   *
   *
   * <pre>
   * Required. Entitlement parameters to update. You can only change editable parameters.
   * To view the available Parameters for a request, refer to the
   * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.channel.v1.Parameter> getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Required. Entitlement parameters to update. You can only change editable parameters.
   * To view the available Parameters for a request, refer to the
   * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.channel.v1.ParameterOrBuilder>
      getParametersOrBuilderList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Required. Entitlement parameters to update. You can only change editable parameters.
   * To view the available Parameters for a request, refer to the
   * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Entitlement parameters to update. You can only change editable parameters.
   * To view the available Parameters for a request, refer to the
   * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.Parameter getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Entitlement parameters to update. You can only change editable parameters.
   * To view the available Parameters for a request, refer to the
   * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.channel.v1.ParameterOrBuilder getParametersOrBuilder(int index) {
    return parameters_.get(index);
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 4;
  private volatile java.lang.Object requestId_;
  /**
   *
   *
   * <pre>
   * Optional. You can specify an optional unique request ID, and if you need to retry
   * your request, the server will know to ignore the request if it's complete.
   * For example, you make an initial request and the request times out. If you
   * make the request again with the same request ID, the server can check if
   * it received the original operation with the same request ID. If it did, it
   * will ignore the second request.
   * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
   * with the exception that zero UUID is not supported
   * (`00000000-0000-0000-0000-000000000000`).
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. You can specify an optional unique request ID, and if you need to retry
   * your request, the server will know to ignore the request if it's complete.
   * For example, you make an initial request and the request times out. If you
   * make the request again with the same request ID, the server can check if
   * it received the original operation with the same request ID. If it did, it
   * will ignore the second request.
   * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
   * with the exception that zero UUID is not supported
   * (`00000000-0000-0000-0000-000000000000`).
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PURCHASE_ORDER_ID_FIELD_NUMBER = 5;
  private volatile java.lang.Object purchaseOrderId_;
  /**
   *
   *
   * <pre>
   * Optional. Purchase order ID provided by the reseller.
   * </pre>
   *
   * <code>string purchase_order_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The purchaseOrderId.
   */
  @java.lang.Override
  public java.lang.String getPurchaseOrderId() {
    java.lang.Object ref = purchaseOrderId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      purchaseOrderId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Purchase order ID provided by the reseller.
   * </pre>
   *
   * <code>string purchase_order_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for purchaseOrderId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPurchaseOrderIdBytes() {
    java.lang.Object ref = purchaseOrderId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      purchaseOrderId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < parameters_.size(); i++) {
      output.writeMessage(2, parameters_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(purchaseOrderId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, purchaseOrderId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < parameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, parameters_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(purchaseOrderId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, purchaseOrderId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.channel.v1.ChangeParametersRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.channel.v1.ChangeParametersRequest other =
        (com.google.cloud.channel.v1.ChangeParametersRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getParametersList().equals(other.getParametersList())) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getPurchaseOrderId().equals(other.getPurchaseOrderId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (37 * hash) + PURCHASE_ORDER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPurchaseOrderId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.channel.v1.ChangeParametersRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [CloudChannelService.ChangeParametersRequest][].
   * </pre>
   *
   * Protobuf type {@code google.cloud.channel.v1.ChangeParametersRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.channel.v1.ChangeParametersRequest)
      com.google.cloud.channel.v1.ChangeParametersRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ChangeParametersRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ChangeParametersRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.channel.v1.ChangeParametersRequest.class,
              com.google.cloud.channel.v1.ChangeParametersRequest.Builder.class);
    }

    // Construct using com.google.cloud.channel.v1.ChangeParametersRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
      } else {
        parameters_ = null;
        parametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      requestId_ = "";

      purchaseOrderId_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.channel.v1.ServiceProto
          .internal_static_google_cloud_channel_v1_ChangeParametersRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ChangeParametersRequest getDefaultInstanceForType() {
      return com.google.cloud.channel.v1.ChangeParametersRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ChangeParametersRequest build() {
      com.google.cloud.channel.v1.ChangeParametersRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.channel.v1.ChangeParametersRequest buildPartial() {
      com.google.cloud.channel.v1.ChangeParametersRequest result =
          new com.google.cloud.channel.v1.ChangeParametersRequest(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
      result.requestId_ = requestId_;
      result.purchaseOrderId_ = purchaseOrderId_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.channel.v1.ChangeParametersRequest) {
        return mergeFrom((com.google.cloud.channel.v1.ChangeParametersRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.channel.v1.ChangeParametersRequest other) {
      if (other == com.google.cloud.channel.v1.ChangeParametersRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (parametersBuilder_ == null) {
        if (!other.parameters_.isEmpty()) {
          if (parameters_.isEmpty()) {
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureParametersIsMutable();
            parameters_.addAll(other.parameters_);
          }
          onChanged();
        }
      } else {
        if (!other.parameters_.isEmpty()) {
          if (parametersBuilder_.isEmpty()) {
            parametersBuilder_.dispose();
            parametersBuilder_ = null;
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000001);
            parametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParametersFieldBuilder()
                    : null;
          } else {
            parametersBuilder_.addAllMessages(other.parameters_);
          }
        }
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        onChanged();
      }
      if (!other.getPurchaseOrderId().isEmpty()) {
        purchaseOrderId_ = other.purchaseOrderId_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                com.google.cloud.channel.v1.Parameter m =
                    input.readMessage(
                        com.google.cloud.channel.v1.Parameter.parser(), extensionRegistry);
                if (parametersBuilder_ == null) {
                  ensureParametersIsMutable();
                  parameters_.add(m);
                } else {
                  parametersBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 34:
              {
                requestId_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                purchaseOrderId_ = input.readStringRequireUtf8();

                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the entitlement to update.
     * Name uses the format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the entitlement to update.
     * Name uses the format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the entitlement to update.
     * Name uses the format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the entitlement to update.
     * Name uses the format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the entitlement to update.
     * Name uses the format:
     * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.channel.v1.Parameter> parameters_ =
        java.util.Collections.emptyList();

    private void ensureParametersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        parameters_ = new java.util.ArrayList<com.google.cloud.channel.v1.Parameter>(parameters_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.Parameter,
            com.google.cloud.channel.v1.Parameter.Builder,
            com.google.cloud.channel.v1.ParameterOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.channel.v1.Parameter> getParametersList() {
      if (parametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameters_);
      } else {
        return parametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getParametersCount() {
      if (parametersBuilder_ == null) {
        return parameters_.size();
      } else {
        return parametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.Parameter getParameters(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setParameters(int index, com.google.cloud.channel.v1.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.set(index, value);
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setParameters(
        int index, com.google.cloud.channel.v1.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(com.google.cloud.channel.v1.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(int index, com.google.cloud.channel.v1.Parameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(index, value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(com.google.cloud.channel.v1.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(
        int index, com.google.cloud.channel.v1.Parameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllParameters(
        java.lang.Iterable<? extends com.google.cloud.channel.v1.Parameter> values) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
        onChanged();
      } else {
        parametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        parametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeParameters(int index) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.remove(index);
        onChanged();
      } else {
        parametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.Parameter.Builder getParametersBuilder(int index) {
      return getParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.ParameterOrBuilder getParametersOrBuilder(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.channel.v1.ParameterOrBuilder>
        getParametersOrBuilderList() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.Parameter.Builder addParametersBuilder() {
      return getParametersFieldBuilder()
          .addBuilder(com.google.cloud.channel.v1.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.channel.v1.Parameter.Builder addParametersBuilder(int index) {
      return getParametersFieldBuilder()
          .addBuilder(index, com.google.cloud.channel.v1.Parameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Entitlement parameters to update. You can only change editable parameters.
     * To view the available Parameters for a request, refer to the
     * [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions] from the desired offer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.channel.v1.Parameter parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.channel.v1.Parameter.Builder>
        getParametersBuilderList() {
      return getParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.channel.v1.Parameter,
            com.google.cloud.channel.v1.Parameter.Builder,
            com.google.cloud.channel.v1.ParameterOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.channel.v1.Parameter,
                com.google.cloud.channel.v1.Parameter.Builder,
                com.google.cloud.channel.v1.ParameterOrBuilder>(
                parameters_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. You can specify an optional unique request ID, and if you need to retry
     * your request, the server will know to ignore the request if it's complete.
     * For example, you make an initial request and the request times out. If you
     * make the request again with the same request ID, the server can check if
     * it received the original operation with the same request ID. If it did, it
     * will ignore the second request.
     * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     * with the exception that zero UUID is not supported
     * (`00000000-0000-0000-0000-000000000000`).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. You can specify an optional unique request ID, and if you need to retry
     * your request, the server will know to ignore the request if it's complete.
     * For example, you make an initial request and the request times out. If you
     * make the request again with the same request ID, the server can check if
     * it received the original operation with the same request ID. If it did, it
     * will ignore the second request.
     * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     * with the exception that zero UUID is not supported
     * (`00000000-0000-0000-0000-000000000000`).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. You can specify an optional unique request ID, and if you need to retry
     * your request, the server will know to ignore the request if it's complete.
     * For example, you make an initial request and the request times out. If you
     * make the request again with the same request ID, the server can check if
     * it received the original operation with the same request ID. If it did, it
     * will ignore the second request.
     * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     * with the exception that zero UUID is not supported
     * (`00000000-0000-0000-0000-000000000000`).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      requestId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. You can specify an optional unique request ID, and if you need to retry
     * your request, the server will know to ignore the request if it's complete.
     * For example, you make an initial request and the request times out. If you
     * make the request again with the same request ID, the server can check if
     * it received the original operation with the same request ID. If it did, it
     * will ignore the second request.
     * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     * with the exception that zero UUID is not supported
     * (`00000000-0000-0000-0000-000000000000`).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {

      requestId_ = getDefaultInstance().getRequestId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. You can specify an optional unique request ID, and if you need to retry
     * your request, the server will know to ignore the request if it's complete.
     * For example, you make an initial request and the request times out. If you
     * make the request again with the same request ID, the server can check if
     * it received the original operation with the same request ID. If it did, it
     * will ignore the second request.
     * The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
     * with the exception that zero UUID is not supported
     * (`00000000-0000-0000-0000-000000000000`).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      requestId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object purchaseOrderId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Purchase order ID provided by the reseller.
     * </pre>
     *
     * <code>string purchase_order_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The purchaseOrderId.
     */
    public java.lang.String getPurchaseOrderId() {
      java.lang.Object ref = purchaseOrderId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        purchaseOrderId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Purchase order ID provided by the reseller.
     * </pre>
     *
     * <code>string purchase_order_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for purchaseOrderId.
     */
    public com.google.protobuf.ByteString getPurchaseOrderIdBytes() {
      java.lang.Object ref = purchaseOrderId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        purchaseOrderId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Purchase order ID provided by the reseller.
     * </pre>
     *
     * <code>string purchase_order_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The purchaseOrderId to set.
     * @return This builder for chaining.
     */
    public Builder setPurchaseOrderId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      purchaseOrderId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Purchase order ID provided by the reseller.
     * </pre>
     *
     * <code>string purchase_order_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPurchaseOrderId() {

      purchaseOrderId_ = getDefaultInstance().getPurchaseOrderId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Purchase order ID provided by the reseller.
     * </pre>
     *
     * <code>string purchase_order_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for purchaseOrderId to set.
     * @return This builder for chaining.
     */
    public Builder setPurchaseOrderIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      purchaseOrderId_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.channel.v1.ChangeParametersRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.channel.v1.ChangeParametersRequest)
  private static final com.google.cloud.channel.v1.ChangeParametersRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.channel.v1.ChangeParametersRequest();
  }

  public static com.google.cloud.channel.v1.ChangeParametersRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ChangeParametersRequest> PARSER =
      new com.google.protobuf.AbstractParser<ChangeParametersRequest>() {
        @java.lang.Override
        public ChangeParametersRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ChangeParametersRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ChangeParametersRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.channel.v1.ChangeParametersRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
