/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/reservation/v1/reservation.proto

package com.google.cloud.bigquery.reservation.v1;

/**
 *
 *
 * <pre>
 * A reservation is a mechanism used to guarantee slots to users.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.reservation.v1.Reservation}
 */
public final class Reservation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.reservation.v1.Reservation)
    ReservationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Reservation.newBuilder() to construct.
  private Reservation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Reservation() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Reservation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.reservation.v1.ReservationProto
        .internal_static_google_cloud_bigquery_reservation_v1_Reservation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.reservation.v1.ReservationProto
        .internal_static_google_cloud_bigquery_reservation_v1_Reservation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.reservation.v1.Reservation.class,
            com.google.cloud.bigquery.reservation.v1.Reservation.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the reservation, e.g.,
   * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
   * The reservation_id must only contain lower case alphanumeric characters or
   * dashes. It must start with a letter and must not end with a dash. Its
   * maximum length is 64 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the reservation, e.g.,
   * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
   * The reservation_id must only contain lower case alphanumeric characters or
   * dashes. It must start with a letter and must not end with a dash. Its
   * maximum length is 64 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SLOT_CAPACITY_FIELD_NUMBER = 2;
  private long slotCapacity_;
  /**
   *
   *
   * <pre>
   * Minimum slots available to this reservation. A slot is a unit of
   * computational power in BigQuery, and serves as the unit of parallelism.
   * Queries using this reservation might use more slots during runtime if
   * ignore_idle_slots is set to false.
   * If the new reservation's slot capacity exceeds the project's slot capacity
   * or if total slot capacity of the new reservation and its siblings exceeds
   * the project's slot capacity, the request will fail with
   * `google.rpc.Code.RESOURCE_EXHAUSTED`.
   * NOTE: for reservations in US or EU multi-regions, slot capacity constraints
   * are checked separately for default and auxiliary regions. See
   * multi_region_auxiliary flag for more details.
   * </pre>
   *
   * <code>int64 slot_capacity = 2;</code>
   *
   * @return The slotCapacity.
   */
  @java.lang.Override
  public long getSlotCapacity() {
    return slotCapacity_;
  }

  public static final int IGNORE_IDLE_SLOTS_FIELD_NUMBER = 4;
  private boolean ignoreIdleSlots_;
  /**
   *
   *
   * <pre>
   * If false, any query or pipeline job using this reservation will use idle
   * slots from other reservations within the same admin project. If true, a
   * query or pipeline job using this reservation will execute with the slot
   * capacity specified in the slot_capacity field at most.
   * </pre>
   *
   * <code>bool ignore_idle_slots = 4;</code>
   *
   * @return The ignoreIdleSlots.
   */
  @java.lang.Override
  public boolean getIgnoreIdleSlots() {
    return ignoreIdleSlots_;
  }

  public static final int CONCURRENCY_FIELD_NUMBER = 16;
  private long concurrency_;
  /**
   *
   *
   * <pre>
   * Maximum number of queries that are allowed to run concurrently in this
   * reservation. This is a soft limit due to asynchronous nature of the system
   * and various optimizations for small queries.
   * Default value is 0 which means that concurrency will be automatically set
   * based on the reservation size.
   * </pre>
   *
   * <code>int64 concurrency = 16;</code>
   *
   * @return The concurrency.
   */
  @java.lang.Override
  public long getConcurrency() {
    return concurrency_;
  }

  public static final int CREATION_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp creationTime_;
  /**
   *
   *
   * <pre>
   * Output only. Creation time of the reservation.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the creationTime field is set.
   */
  @java.lang.Override
  public boolean hasCreationTime() {
    return creationTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time of the reservation.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The creationTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreationTime() {
    return creationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : creationTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time of the reservation.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreationTimeOrBuilder() {
    return getCreationTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Last update time of the reservation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Last update time of the reservation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Last update time of the reservation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int MULTI_REGION_AUXILIARY_FIELD_NUMBER = 14;
  private boolean multiRegionAuxiliary_;
  /**
   *
   *
   * <pre>
   * Applicable only for reservations located within one of the BigQuery
   * multi-regions (US or EU).
   * If set to true, this reservation is placed in the organization's
   * secondary region which is designated for disaster recovery purposes.
   * If false, this reservation is placed in the organization's default region.
   * </pre>
   *
   * <code>bool multi_region_auxiliary = 14;</code>
   *
   * @return The multiRegionAuxiliary.
   */
  @java.lang.Override
  public boolean getMultiRegionAuxiliary() {
    return multiRegionAuxiliary_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (slotCapacity_ != 0L) {
      output.writeInt64(2, slotCapacity_);
    }
    if (ignoreIdleSlots_ != false) {
      output.writeBool(4, ignoreIdleSlots_);
    }
    if (creationTime_ != null) {
      output.writeMessage(8, getCreationTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(9, getUpdateTime());
    }
    if (multiRegionAuxiliary_ != false) {
      output.writeBool(14, multiRegionAuxiliary_);
    }
    if (concurrency_ != 0L) {
      output.writeInt64(16, concurrency_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (slotCapacity_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, slotCapacity_);
    }
    if (ignoreIdleSlots_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, ignoreIdleSlots_);
    }
    if (creationTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreationTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    if (multiRegionAuxiliary_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, multiRegionAuxiliary_);
    }
    if (concurrency_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(16, concurrency_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.reservation.v1.Reservation)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.reservation.v1.Reservation other =
        (com.google.cloud.bigquery.reservation.v1.Reservation) obj;

    if (!getName().equals(other.getName())) return false;
    if (getSlotCapacity() != other.getSlotCapacity()) return false;
    if (getIgnoreIdleSlots() != other.getIgnoreIdleSlots()) return false;
    if (getConcurrency() != other.getConcurrency()) return false;
    if (hasCreationTime() != other.hasCreationTime()) return false;
    if (hasCreationTime()) {
      if (!getCreationTime().equals(other.getCreationTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getMultiRegionAuxiliary() != other.getMultiRegionAuxiliary()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + SLOT_CAPACITY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSlotCapacity());
    hash = (37 * hash) + IGNORE_IDLE_SLOTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreIdleSlots());
    hash = (37 * hash) + CONCURRENCY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getConcurrency());
    if (hasCreationTime()) {
      hash = (37 * hash) + CREATION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + MULTI_REGION_AUXILIARY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMultiRegionAuxiliary());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.bigquery.reservation.v1.Reservation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A reservation is a mechanism used to guarantee slots to users.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.reservation.v1.Reservation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.reservation.v1.Reservation)
      com.google.cloud.bigquery.reservation.v1.ReservationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_Reservation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_Reservation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.reservation.v1.Reservation.class,
              com.google.cloud.bigquery.reservation.v1.Reservation.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.reservation.v1.Reservation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      slotCapacity_ = 0L;

      ignoreIdleSlots_ = false;

      concurrency_ = 0L;

      if (creationTimeBuilder_ == null) {
        creationTime_ = null;
      } else {
        creationTime_ = null;
        creationTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      multiRegionAuxiliary_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.reservation.v1.ReservationProto
          .internal_static_google_cloud_bigquery_reservation_v1_Reservation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.Reservation getDefaultInstanceForType() {
      return com.google.cloud.bigquery.reservation.v1.Reservation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.Reservation build() {
      com.google.cloud.bigquery.reservation.v1.Reservation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.reservation.v1.Reservation buildPartial() {
      com.google.cloud.bigquery.reservation.v1.Reservation result =
          new com.google.cloud.bigquery.reservation.v1.Reservation(this);
      result.name_ = name_;
      result.slotCapacity_ = slotCapacity_;
      result.ignoreIdleSlots_ = ignoreIdleSlots_;
      result.concurrency_ = concurrency_;
      if (creationTimeBuilder_ == null) {
        result.creationTime_ = creationTime_;
      } else {
        result.creationTime_ = creationTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.multiRegionAuxiliary_ = multiRegionAuxiliary_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.reservation.v1.Reservation) {
        return mergeFrom((com.google.cloud.bigquery.reservation.v1.Reservation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.reservation.v1.Reservation other) {
      if (other == com.google.cloud.bigquery.reservation.v1.Reservation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.getSlotCapacity() != 0L) {
        setSlotCapacity(other.getSlotCapacity());
      }
      if (other.getIgnoreIdleSlots() != false) {
        setIgnoreIdleSlots(other.getIgnoreIdleSlots());
      }
      if (other.getConcurrency() != 0L) {
        setConcurrency(other.getConcurrency());
      }
      if (other.hasCreationTime()) {
        mergeCreationTime(other.getCreationTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getMultiRegionAuxiliary() != false) {
        setMultiRegionAuxiliary(other.getMultiRegionAuxiliary());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                slotCapacity_ = input.readInt64();

                break;
              } // case 16
            case 32:
              {
                ignoreIdleSlots_ = input.readBool();

                break;
              } // case 32
            case 66:
              {
                input.readMessage(getCreationTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 74
            case 112:
              {
                multiRegionAuxiliary_ = input.readBool();

                break;
              } // case 112
            case 128:
              {
                concurrency_ = input.readInt64();

                break;
              } // case 128
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     * The reservation_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end with a dash. Its
     * maximum length is 64 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     * The reservation_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end with a dash. Its
     * maximum length is 64 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     * The reservation_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end with a dash. Its
     * maximum length is 64 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     * The reservation_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end with a dash. Its
     * maximum length is 64 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     * The reservation_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end with a dash. Its
     * maximum length is 64 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private long slotCapacity_;
    /**
     *
     *
     * <pre>
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceeds the project's slot capacity
     * or if total slot capacity of the new reservation and its siblings exceeds
     * the project's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     * NOTE: for reservations in US or EU multi-regions, slot capacity constraints
     * are checked separately for default and auxiliary regions. See
     * multi_region_auxiliary flag for more details.
     * </pre>
     *
     * <code>int64 slot_capacity = 2;</code>
     *
     * @return The slotCapacity.
     */
    @java.lang.Override
    public long getSlotCapacity() {
      return slotCapacity_;
    }
    /**
     *
     *
     * <pre>
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceeds the project's slot capacity
     * or if total slot capacity of the new reservation and its siblings exceeds
     * the project's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     * NOTE: for reservations in US or EU multi-regions, slot capacity constraints
     * are checked separately for default and auxiliary regions. See
     * multi_region_auxiliary flag for more details.
     * </pre>
     *
     * <code>int64 slot_capacity = 2;</code>
     *
     * @param value The slotCapacity to set.
     * @return This builder for chaining.
     */
    public Builder setSlotCapacity(long value) {

      slotCapacity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceeds the project's slot capacity
     * or if total slot capacity of the new reservation and its siblings exceeds
     * the project's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     * NOTE: for reservations in US or EU multi-regions, slot capacity constraints
     * are checked separately for default and auxiliary regions. See
     * multi_region_auxiliary flag for more details.
     * </pre>
     *
     * <code>int64 slot_capacity = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSlotCapacity() {

      slotCapacity_ = 0L;
      onChanged();
      return this;
    }

    private boolean ignoreIdleSlots_;
    /**
     *
     *
     * <pre>
     * If false, any query or pipeline job using this reservation will use idle
     * slots from other reservations within the same admin project. If true, a
     * query or pipeline job using this reservation will execute with the slot
     * capacity specified in the slot_capacity field at most.
     * </pre>
     *
     * <code>bool ignore_idle_slots = 4;</code>
     *
     * @return The ignoreIdleSlots.
     */
    @java.lang.Override
    public boolean getIgnoreIdleSlots() {
      return ignoreIdleSlots_;
    }
    /**
     *
     *
     * <pre>
     * If false, any query or pipeline job using this reservation will use idle
     * slots from other reservations within the same admin project. If true, a
     * query or pipeline job using this reservation will execute with the slot
     * capacity specified in the slot_capacity field at most.
     * </pre>
     *
     * <code>bool ignore_idle_slots = 4;</code>
     *
     * @param value The ignoreIdleSlots to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreIdleSlots(boolean value) {

      ignoreIdleSlots_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If false, any query or pipeline job using this reservation will use idle
     * slots from other reservations within the same admin project. If true, a
     * query or pipeline job using this reservation will execute with the slot
     * capacity specified in the slot_capacity field at most.
     * </pre>
     *
     * <code>bool ignore_idle_slots = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnoreIdleSlots() {

      ignoreIdleSlots_ = false;
      onChanged();
      return this;
    }

    private long concurrency_;
    /**
     *
     *
     * <pre>
     * Maximum number of queries that are allowed to run concurrently in this
     * reservation. This is a soft limit due to asynchronous nature of the system
     * and various optimizations for small queries.
     * Default value is 0 which means that concurrency will be automatically set
     * based on the reservation size.
     * </pre>
     *
     * <code>int64 concurrency = 16;</code>
     *
     * @return The concurrency.
     */
    @java.lang.Override
    public long getConcurrency() {
      return concurrency_;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of queries that are allowed to run concurrently in this
     * reservation. This is a soft limit due to asynchronous nature of the system
     * and various optimizations for small queries.
     * Default value is 0 which means that concurrency will be automatically set
     * based on the reservation size.
     * </pre>
     *
     * <code>int64 concurrency = 16;</code>
     *
     * @param value The concurrency to set.
     * @return This builder for chaining.
     */
    public Builder setConcurrency(long value) {

      concurrency_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of queries that are allowed to run concurrently in this
     * reservation. This is a soft limit due to asynchronous nature of the system
     * and various optimizations for small queries.
     * Default value is 0 which means that concurrency will be automatically set
     * based on the reservation size.
     * </pre>
     *
     * <code>int64 concurrency = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConcurrency() {

      concurrency_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp creationTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        creationTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Creation time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the creationTime field is set.
     */
    public boolean hasCreationTime() {
      return creationTimeBuilder_ != null || creationTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The creationTime.
     */
    public com.google.protobuf.Timestamp getCreationTime() {
      if (creationTimeBuilder_ == null) {
        return creationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : creationTime_;
      } else {
        return creationTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreationTime(com.google.protobuf.Timestamp value) {
      if (creationTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        creationTime_ = value;
        onChanged();
      } else {
        creationTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreationTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (creationTimeBuilder_ == null) {
        creationTime_ = builderForValue.build();
        onChanged();
      } else {
        creationTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreationTime(com.google.protobuf.Timestamp value) {
      if (creationTimeBuilder_ == null) {
        if (creationTime_ != null) {
          creationTime_ =
              com.google.protobuf.Timestamp.newBuilder(creationTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          creationTime_ = value;
        }
        onChanged();
      } else {
        creationTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreationTime() {
      if (creationTimeBuilder_ == null) {
        creationTime_ = null;
        onChanged();
      } else {
        creationTime_ = null;
        creationTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreationTimeBuilder() {

      onChanged();
      return getCreationTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreationTimeOrBuilder() {
      if (creationTimeBuilder_ != null) {
        return creationTimeBuilder_.getMessageOrBuilder();
      } else {
        return creationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : creationTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreationTimeFieldBuilder() {
      if (creationTimeBuilder_ == null) {
        creationTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreationTime(), getParentForChildren(), isClean());
        creationTime_ = null;
      }
      return creationTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Last update time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of the reservation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private boolean multiRegionAuxiliary_;
    /**
     *
     *
     * <pre>
     * Applicable only for reservations located within one of the BigQuery
     * multi-regions (US or EU).
     * If set to true, this reservation is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this reservation is placed in the organization's default region.
     * </pre>
     *
     * <code>bool multi_region_auxiliary = 14;</code>
     *
     * @return The multiRegionAuxiliary.
     */
    @java.lang.Override
    public boolean getMultiRegionAuxiliary() {
      return multiRegionAuxiliary_;
    }
    /**
     *
     *
     * <pre>
     * Applicable only for reservations located within one of the BigQuery
     * multi-regions (US or EU).
     * If set to true, this reservation is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this reservation is placed in the organization's default region.
     * </pre>
     *
     * <code>bool multi_region_auxiliary = 14;</code>
     *
     * @param value The multiRegionAuxiliary to set.
     * @return This builder for chaining.
     */
    public Builder setMultiRegionAuxiliary(boolean value) {

      multiRegionAuxiliary_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applicable only for reservations located within one of the BigQuery
     * multi-regions (US or EU).
     * If set to true, this reservation is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this reservation is placed in the organization's default region.
     * </pre>
     *
     * <code>bool multi_region_auxiliary = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMultiRegionAuxiliary() {

      multiRegionAuxiliary_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.reservation.v1.Reservation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.reservation.v1.Reservation)
  private static final com.google.cloud.bigquery.reservation.v1.Reservation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.reservation.v1.Reservation();
  }

  public static com.google.cloud.bigquery.reservation.v1.Reservation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Reservation> PARSER =
      new com.google.protobuf.AbstractParser<Reservation>() {
        @java.lang.Override
        public Reservation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Reservation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Reservation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.reservation.v1.Reservation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
